/** X3DOM Runtime, http://www.x3dom.org/ 1.7.0 - f33e92d248a2f25d52fa63ede8ffee570c8a6304 - Wed Jun 17 09:49:25 2015 +0200 */// Note: For maximum-speed code, see "Optimizing Code" on the Emscripten wiki, https://github.com/kripken/emscripten/wiki/Optimizing-Code
// Note: Some Emscripten settings may limit the speed of the generated code.
// The Module object: Our interface to the outside world. We import
// and export values on it, and do the work to get that through
// closure compiler if necessary. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(Module) { ..generated code.. }
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to do an eval in order to handle the closure compiler
// case, where this code here is minified but Module was defined
// elsewhere (e.g. case 4 above). We also need to check if Module
// already exists (e.g. case 3 above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module;
if (!Module) Module = eval('(function() { try { return Module || {} } catch(e) { return {} } })()');
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides = {};
for (var key in Module) {
  if (Module.hasOwnProperty(key)) {
    moduleOverrides[key] = Module[key];
  }
}
// The environment setup code below is customized to use Module.
// *** Environment setup code ***
var ENVIRONMENT_IS_NODE = typeof process === 'object' && typeof require === 'function';
var ENVIRONMENT_IS_WEB = typeof window === 'object';
var ENVIRONMENT_IS_WORKER = typeof importScripts === 'function';
var ENVIRONMENT_IS_SHELL = !ENVIRONMENT_IS_WEB && !ENVIRONMENT_IS_NODE && !ENVIRONMENT_IS_WORKER;
if (ENVIRONMENT_IS_NODE) {
  // Expose functionality in the same simple way that the shells work
  // Note that we pollute the global namespace here, otherwise we break in node
  Module['print'] = function(x) {
    process['stdout'].write(x + '\n');
  };
  Module['printErr'] = function(x) {
    process['stderr'].write(x + '\n');
  };
  var nodeFS = require('fs');
  var nodePath = require('path');
  Module['read'] = function(filename, binary) {
    filename = nodePath['normalize'](filename);
    var ret = nodeFS['readFileSync'](filename);
    // The path is absolute if the normalized version is the same as the resolved.
    if (!ret && filename != nodePath['resolve'](filename)) {
      filename = path.join(__dirname, '..', 'src', filename);
      ret = nodeFS['readFileSync'](filename);
    }
    if (ret && !binary) ret = ret.toString();
    return ret;
  };
  Module['readBinary'] = function(filename) { return Module['read'](filename, true) };
  Module['load'] = function(f) {
    globalEval(read(f));
  };
  Module['arguments'] = process['argv'].slice(2);
  module.exports = Module;
}
else if (ENVIRONMENT_IS_SHELL) {
  Module['print'] = print;
  if (typeof printErr != 'undefined') Module['printErr'] = printErr; // not present in v8 or older sm
  if (typeof read != 'undefined') {
    Module['read'] = read;
  } else {
    Module['read'] = function() { throw 'no read() available (jsc?)' };
  }
  Module['readBinary'] = function(f) {
    return read(f, 'binary');
  };
  if (typeof scriptArgs != 'undefined') {
    Module['arguments'] = scriptArgs;
  } else if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  this['Module'] = Module;
}
else if (ENVIRONMENT_IS_WEB || ENVIRONMENT_IS_WORKER) {
  Module['read'] = function(url) {
    var xhr = new XMLHttpRequest();
    xhr.open('GET', url, false);
    xhr.send(null);
    return xhr.responseText;
  };
  if (typeof arguments != 'undefined') {
    Module['arguments'] = arguments;
  }
  if (ENVIRONMENT_IS_WEB) {
    Module['print'] = function(x) {
      console.log(x);
    };
    Module['printErr'] = function(x) {
      console.log(x);
    };
    this['Module'] = Module;
  } else if (ENVIRONMENT_IS_WORKER) {
    // We can do very little here...
    var TRY_USE_DUMP = false;
    Module['print'] = (TRY_USE_DUMP && (typeof(dump) !== "undefined") ? (function(x) {
      dump(x);
    }) : (function(x) {
      // self.postMessage(x); // enable this if you want stdout to be sent as messages
    }));
    Module['load'] = importScripts;
  }
}
else {
  // Unreachable because SHELL is dependant on the others
  throw 'Unknown runtime environment. Where are we?';
}
function globalEval(x) {
  eval.call(null, x);
}
if (!Module['load'] == 'undefined' && Module['read']) {
  Module['load'] = function(f) {
    globalEval(Module['read'](f));
  };
}
if (!Module['print']) {
  Module['print'] = function(){};
}
if (!Module['printErr']) {
  Module['printErr'] = Module['print'];
}
if (!Module['arguments']) {
  Module['arguments'] = [];
}
// *** Environment setup code ***
// Closure helpers
Module.print = Module['print'];
Module.printErr = Module['printErr'];
// Callbacks
Module['preRun'] = [];
Module['postRun'] = [];
// Merge back in the overrides
for (var key in moduleOverrides) {
  if (moduleOverrides.hasOwnProperty(key)) {
    Module[key] = moduleOverrides[key];
  }
}
// === Auto-generated preamble library stuff ===
//========================================
// Runtime code shared with compiler
//========================================
var Runtime = {
  stackSave: function () {
    return STACKTOP;
  },
  stackRestore: function (stackTop) {
    STACKTOP = stackTop;
  },
  forceAlign: function (target, quantum) {
    quantum = quantum || 4;
    if (quantum == 1) return target;
    if (isNumber(target) && isNumber(quantum)) {
      return Math.ceil(target/quantum)*quantum;
    } else if (isNumber(quantum) && isPowerOfTwo(quantum)) {
      var logg = log2(quantum);
      return '((((' +target + ')+' + (quantum-1) + ')>>' + logg + ')<<' + logg + ')';
    }
    return 'Math.ceil((' + target + ')/' + quantum + ')*' + quantum;
  },
  isNumberType: function (type) {
    return type in Runtime.INT_TYPES || type in Runtime.FLOAT_TYPES;
  },
  isPointerType: function isPointerType(type) {
  return type[type.length-1] == '*';
},
  isStructType: function isStructType(type) {
  if (isPointerType(type)) return false;
  if (isArrayType(type)) return true;
  if (/<?{ ?[^}]* ?}>?/.test(type)) return true; // { i32, i8 } etc. - anonymous struct types
  // See comment in isStructPointerType()
  return type[0] == '%';
},
  INT_TYPES: {"i1":0,"i8":0,"i16":0,"i32":0,"i64":0},
  FLOAT_TYPES: {"float":0,"double":0},
  or64: function (x, y) {
    var l = (x | 0) | (y | 0);
    var h = (Math.round(x / 4294967296) | Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  and64: function (x, y) {
    var l = (x | 0) & (y | 0);
    var h = (Math.round(x / 4294967296) & Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  xor64: function (x, y) {
    var l = (x | 0) ^ (y | 0);
    var h = (Math.round(x / 4294967296) ^ Math.round(y / 4294967296)) * 4294967296;
    return l + h;
  },
  getNativeTypeSize: function (type, quantumSize) {
    if (Runtime.QUANTUM_SIZE == 1) return 1;
    var size = {
      '%i1': 1,
      '%i8': 1,
      '%i16': 2,
      '%i32': 4,
      '%i64': 8,
      "%float": 4,
      "%double": 8
    }['%'+type]; // add '%' since float and double confuse Closure compiler as keys, and also spidermonkey as a compiler will remove 's from '_i8' etc
    if (!size) {
      if (type.charAt(type.length-1) == '*') {
        size = Runtime.QUANTUM_SIZE; // A pointer
      } else if (type[0] == 'i') {
        var bits = parseInt(type.substr(1));
        assert(bits % 8 == 0);
        size = bits/8;
      }
    }
    return size;
  },
  getNativeFieldSize: function (type) {
    return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE);
  },
  dedup: function dedup(items, ident) {
  var seen = {};
  if (ident) {
    return items.filter(function(item) {
      if (seen[item[ident]]) return false;
      seen[item[ident]] = true;
      return true;
    });
  } else {
    return items.filter(function(item) {
      if (seen[item]) return false;
      seen[item] = true;
      return true;
    });
  }
},
  set: function set() {
  var args = typeof arguments[0] === 'object' ? arguments[0] : arguments;
  var ret = {};
  for (var i = 0; i < args.length; i++) {
    ret[args[i]] = 0;
  }
  return ret;
},
  STACK_ALIGN: 8,
  getAlignSize: function (type, size, vararg) {
    // we align i64s and doubles on 64-bit boundaries, unlike x86
    if (type == 'i64' || type == 'double' || vararg) return 8;
    if (!type) return Math.min(size, 8); // align structures internally to 64 bits
    return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE);
  },
  calculateStructAlignment: function calculateStructAlignment(type) {
    type.flatSize = 0;
    type.alignSize = 0;
    var diffs = [];
    var prev = -1;
    var index = 0;
    type.flatIndexes = type.fields.map(function(field) {
      index++;
      var size, alignSize;
      if (Runtime.isNumberType(field) || Runtime.isPointerType(field)) {
        size = Runtime.getNativeTypeSize(field); // pack char; char; in structs, also char[X]s.
        alignSize = Runtime.getAlignSize(field, size);
      } else if (Runtime.isStructType(field)) {
        if (field[1] === '0') {
          // this is [0 x something]. When inside another structure like here, it must be at the end,
          // and it adds no size
          // XXX this happens in java-nbody for example... assert(index === type.fields.length, 'zero-length in the middle!');
          size = 0;
          alignSize = type.alignSize || QUANTUM_SIZE;
        } else {
          size = Types.types[field].flatSize;
          alignSize = Runtime.getAlignSize(null, Types.types[field].alignSize);
        }
      } else if (field[0] == 'b') {
        // bN, large number field, like a [N x i8]
        size = field.substr(1)|0;
        alignSize = 1;
      } else {
        throw 'Unclear type in struct: ' + field + ', in ' + type.name_ + ' :: ' + dump(Types.types[type.name_]);
      }
      if (type.packed) alignSize = 1;
      type.alignSize = Math.max(type.alignSize, alignSize);
      var curr = Runtime.alignMemory(type.flatSize, alignSize); // if necessary, place this on aligned memory
      type.flatSize = curr + size;
      if (prev >= 0) {
        diffs.push(curr-prev);
      }
      prev = curr;
      return curr;
    });
    type.flatSize = Runtime.alignMemory(type.flatSize, type.alignSize);
    if (diffs.length == 0) {
      type.flatFactor = type.flatSize;
    } else if (Runtime.dedup(diffs).length == 1) {
      type.flatFactor = diffs[0];
    }
    type.needsFlattening = (type.flatFactor != 1);
    return type.flatIndexes;
  },
  generateStructInfo: function (struct, typeName, offset) {
    var type, alignment;
    if (typeName) {
      offset = offset || 0;
      type = (typeof Types === 'undefined' ? Runtime.typeInfo : Types.types)[typeName];
      if (!type) return null;
      if (type.fields.length != struct.length) {
        printErr('Number of named fields must match the type for ' + typeName + ': possibly duplicate struct names. Cannot return structInfo');
        return null;
      }
      alignment = type.flatIndexes;
    } else {
      var type = { fields: struct.map(function(item) { return item[0] }) };
      alignment = Runtime.calculateStructAlignment(type);
    }
    var ret = {
      __size__: type.flatSize
    };
    if (typeName) {
      struct.forEach(function(item, i) {
        if (typeof item === 'string') {
          ret[item] = alignment[i] + offset;
        } else {
          // embedded struct
          var key;
          for (var k in item) key = k;
          ret[key] = Runtime.generateStructInfo(item[key], type.fields[i], alignment[i]);
        }
      });
    } else {
      struct.forEach(function(item, i) {
        ret[item[1]] = alignment[i];
      });
    }
    return ret;
  },
  dynCall: function (sig, ptr, args) {
    if (args && args.length) {
      if (!args.splice) args = Array.prototype.slice.call(args);
      args.splice(0, 0, ptr);
      return Module['dynCall_' + sig].apply(null, args);
    } else {
      return Module['dynCall_' + sig].call(null, ptr);
    }
  },
  functionPointers: [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null],
  addFunction: function (func) {
    for (var i = 0; i < Runtime.functionPointers.length; i++) {
      if (!Runtime.functionPointers[i]) {
        Runtime.functionPointers[i] = func;
        return 2 + 2*i;
      }
    }
    throw 'Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS.';
  },
  removeFunction: function (index) {
    Runtime.functionPointers[(index-2)/2] = null;
  },
  warnOnce: function (text) {
    if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
    if (!Runtime.warnOnce.shown[text]) {
      Runtime.warnOnce.shown[text] = 1;
      Module.printErr(text);
    }
  },
  funcWrappers: {},
  getFuncWrapper: function (func, sig) {
    assert(sig);
    if (!Runtime.funcWrappers[func]) {
      Runtime.funcWrappers[func] = function() {
        return Runtime.dynCall(sig, func, arguments);
      };
    }
    return Runtime.funcWrappers[func];
  },
  UTF8Processor: function () {
    var buffer = [];
    var needed = 0;
    this.processCChar = function (code) {
      code = code & 0xFF;
      if (buffer.length == 0) {
        if ((code & 0x80) == 0x00) {        // 0xxxxxxx
          return String.fromCharCode(code);
        }
        buffer.push(code);
        if ((code & 0xE0) == 0xC0) {        // 110xxxxx
          needed = 1;
        } else if ((code & 0xF0) == 0xE0) { // 1110xxxx
          needed = 2;
        } else {                            // 11110xxx
          needed = 3;
        }
        return '';
      }
      if (needed) {
        buffer.push(code);
        needed--;
        if (needed > 0) return '';
      }
      var c1 = buffer[0];
      var c2 = buffer[1];
      var c3 = buffer[2];
      var c4 = buffer[3];
      var ret;
      if (buffer.length == 2) {
        ret = String.fromCharCode(((c1 & 0x1F) << 6)  | (c2 & 0x3F));
      } else if (buffer.length == 3) {
        ret = String.fromCharCode(((c1 & 0x0F) << 12) | ((c2 & 0x3F) << 6)  | (c3 & 0x3F));
      } else {
        // http://mathiasbynens.be/notes/javascript-encoding#surrogate-formulae
        var codePoint = ((c1 & 0x07) << 18) | ((c2 & 0x3F) << 12) |
                        ((c3 & 0x3F) << 6)  | (c4 & 0x3F);
        ret = String.fromCharCode(
          Math.floor((codePoint - 0x10000) / 0x400) + 0xD800,
          (codePoint - 0x10000) % 0x400 + 0xDC00);
      }
      buffer.length = 0;
      return ret;
    }
    this.processJSString = function(string) {
      string = unescape(encodeURIComponent(string));
      var ret = [];
      for (var i = 0; i < string.length; i++) {
        ret.push(string.charCodeAt(i));
      }
      return ret;
    }
  },
  stackAlloc: function (size) { var ret = STACKTOP;STACKTOP = (STACKTOP + size)|0;STACKTOP = ((((STACKTOP)+7)>>3)<<3); return ret; },
  staticAlloc: function (size) { var ret = STATICTOP;STATICTOP = (STATICTOP + size)|0;STATICTOP = ((((STATICTOP)+7)>>3)<<3); return ret; },
  dynamicAlloc: function (size) { var ret = DYNAMICTOP;DYNAMICTOP = (DYNAMICTOP + size)|0;DYNAMICTOP = ((((DYNAMICTOP)+7)>>3)<<3); if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();; return ret; },
  alignMemory: function (size,quantum) { var ret = size = Math.ceil((size)/(quantum ? quantum : 8))*(quantum ? quantum : 8); return ret; },
  makeBigInt: function (low,high,unsigned) { var ret = (unsigned ? ((+(((low)>>>(0))))+((+(((high)>>>(0))))*(+(4294967296)))) : ((+(((low)>>>(0))))+((+(((high)|(0))))*(+(4294967296))))); return ret; },
  GLOBAL_BASE: 8,
  QUANTUM_SIZE: 4,
  __dummy__: 0
}
function jsCall() {
  var args = Array.prototype.slice.call(arguments);
  return Runtime.functionPointers[args[0]].apply(null, args.slice(1));
}
//========================================
// Runtime essentials
//========================================
var __THREW__ = 0; // Used in checking for thrown exceptions.
var ABORT = false; // whether we are quitting the application. no code should run after this. set in exit() and abort()
var EXITSTATUS = 0;
var undef = 0;
// tempInt is used for 32-bit signed values or smaller. tempBigInt is used
// for 32-bit unsigned values or more than 32 bits. TODO: audit all uses of tempInt
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;
function assert(condition, text) {
  if (!condition) {
    abort('Assertion failed: ' + text);
  }
}
var globalScope = this;
// C calling interface. A convenient way to call C functions (in C files, or
// defined with extern "C").
//
// Note: LLVM optimizations can inline and remove functions, after which you will not be
//       able to call them. Closure can also do so. To avoid that, add your function to
//       the exports using something like
//
//         -s EXPORTED_FUNCTIONS='["_main", "_myfunc"]'
//
// @param ident      The name of the C function (note that C++ functions will be name-mangled - use extern "C")
// @param returnType The return type of the function, one of the JS types 'number', 'string' or 'array' (use 'number' for any C pointer, and
//                   'array' for JavaScript arrays and typed arrays; note that arrays are 8-bit).
// @param argTypes   An array of the types of arguments for the function (if there are no arguments, this can be ommitted). Types are as in returnType,
//                   except that 'array' is not possible (there is no way for us to know the length of the array)
// @param args       An array of the arguments to the function, as native JS values (as in returnType)
//                   Note that string arguments will be stored on the stack (the JS string will become a C string on the stack).
// @return           The return value, as a native JS value (as in returnType)
function ccall(ident, returnType, argTypes, args) {
  return ccallFunc(getCFunc(ident), returnType, argTypes, args);
}
Module["ccall"] = ccall;
// Returns the C function with a specified identifier (for C++, you need to do manual name mangling)
function getCFunc(ident) {
  try {
    var func = Module['_' + ident]; // closure exported function
    if (!func) func = eval('_' + ident); // explicit lookup
  } catch(e) {
  }
  assert(func, 'Cannot call unknown function ' + ident + ' (perhaps LLVM optimizations or closure removed it?)');
  return func;
}
// Internal function that does a C call using a function, not an identifier
function ccallFunc(func, returnType, argTypes, args) {
  var stack = 0;
  function toC(value, type) {
    if (type == 'string') {
      if (value === null || value === undefined || value === 0) return 0; // null string
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length+1);
      writeStringToMemory(value, ret);
      return ret;
    } else if (type == 'array') {
      if (!stack) stack = Runtime.stackSave();
      var ret = Runtime.stackAlloc(value.length);
      writeArrayToMemory(value, ret);
      return ret;
    }
    return value;
  }
  function fromC(value, type) {
    if (type == 'string') {
      return Pointer_stringify(value);
    }
    assert(type != 'array');
    return value;
  }
  var i = 0;
  var cArgs = args ? args.map(function(arg) {
    return toC(arg, argTypes[i++]);
  }) : [];
  var ret = fromC(func.apply(null, cArgs), returnType);
  if (stack) Runtime.stackRestore(stack);
  return ret;
}
// Returns a native JS wrapper for a C function. This is similar to ccall, but
// returns a function you can call repeatedly in a normal way. For example:
//
//   var my_function = cwrap('my_c_function', 'number', ['number', 'number']);
//   alert(my_function(5, 22));
//   alert(my_function(99, 12));
//
function cwrap(ident, returnType, argTypes) {
  var func = getCFunc(ident);
  return function() {
    return ccallFunc(func, returnType, argTypes, Array.prototype.slice.call(arguments));
  }
}
Module["cwrap"] = cwrap;
// Sets a value in memory in a dynamic way at run-time. Uses the
// type data. This is the same as makeSetValue, except that
// makeSetValue is done at compile-time and generates the needed
// code then, whereas this function picks the right code at
// run-time.
// Note that setValue and getValue only do *aligned* writes and reads!
// Note that ccall uses JS types as for defining types, while setValue and
// getValue need LLVM types ('i8', 'i32') - this is a lower-level operation
function setValue(ptr, value, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': HEAP8[(ptr)]=value; break;
      case 'i8': HEAP8[(ptr)]=value; break;
      case 'i16': HEAP16[((ptr)>>1)]=value; break;
      case 'i32': HEAP32[((ptr)>>2)]=value; break;
      case 'i64': (tempI64 = [value>>>0,(tempDouble=value,(+(Math.abs(tempDouble))) >= (+(1)) ? (tempDouble > (+(0)) ? ((Math.min((+(Math.floor((tempDouble)/(+(4294967296))))), (+(4294967295))))|0)>>>0 : (~~((+(Math.ceil((tempDouble - +(((~~(tempDouble)))>>>0))/(+(4294967296)))))))>>>0) : 0)],HEAP32[((ptr)>>2)]=tempI64[0],HEAP32[(((ptr)+(4))>>2)]=tempI64[1]); break;
      case 'float': HEAPF32[((ptr)>>2)]=value; break;
      case 'double': HEAPF64[((ptr)>>3)]=value; break;
      default: abort('invalid type for setValue: ' + type);
    }
}
Module['setValue'] = setValue;
// Parallel to setValue.
function getValue(ptr, type, noSafe) {
  type = type || 'i8';
  if (type.charAt(type.length-1) === '*') type = 'i32'; // pointers are 32-bit
    switch(type) {
      case 'i1': return HEAP8[(ptr)];
      case 'i8': return HEAP8[(ptr)];
      case 'i16': return HEAP16[((ptr)>>1)];
      case 'i32': return HEAP32[((ptr)>>2)];
      case 'i64': return HEAP32[((ptr)>>2)];
      case 'float': return HEAPF32[((ptr)>>2)];
      case 'double': return HEAPF64[((ptr)>>3)];
      default: abort('invalid type for setValue: ' + type);
    }
  return null;
}
Module['getValue'] = getValue;
var ALLOC_NORMAL = 0; // Tries to use _malloc()
var ALLOC_STACK = 1; // Lives for the duration of the current function call
var ALLOC_STATIC = 2; // Cannot be freed
var ALLOC_DYNAMIC = 3; // Cannot be freed except through sbrk
var ALLOC_NONE = 4; // Do not allocate
Module['ALLOC_NORMAL'] = ALLOC_NORMAL;
Module['ALLOC_STACK'] = ALLOC_STACK;
Module['ALLOC_STATIC'] = ALLOC_STATIC;
Module['ALLOC_DYNAMIC'] = ALLOC_DYNAMIC;
Module['ALLOC_NONE'] = ALLOC_NONE;
// allocate(): This is for internal use. You can use it yourself as well, but the interface
//             is a little tricky (see docs right below). The reason is that it is optimized
//             for multiple syntaxes to save space in generated code. So you should
//             normally not use allocate(), and instead allocate memory using _malloc(),
//             initialize it with setValue(), and so forth.
// @slab: An array of data, or a number. If a number, then the size of the block to allocate,
//        in *bytes* (note that this is sometimes confusing: the next parameter does not
//        affect this!)
// @types: Either an array of types, one for each byte (or 0 if no type at that position),
//         or a single type which is used for the entire block. This only matters if there
//         is initial data - if @slab is a number, then this does not matter at all and is
//         ignored.
// @allocator: How to allocate memory, see ALLOC_*
function allocate(slab, types, allocator, ptr) {
  var zeroinit, size;
  if (typeof slab === 'number') {
    zeroinit = true;
    size = slab;
  } else {
    zeroinit = false;
    size = slab.length;
  }
  var singleType = typeof types === 'string' ? types : null;
  var ret;
  if (allocator == ALLOC_NONE) {
    ret = ptr;
  } else {
    ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length));
  }
  if (zeroinit) {
    var ptr = ret, stop;
    assert((ret & 3) == 0);
    stop = ret + (size & ~3);
    for (; ptr < stop; ptr += 4) {
      HEAP32[((ptr)>>2)]=0;
    }
    stop = ret + size;
    while (ptr < stop) {
      HEAP8[((ptr++)|0)]=0;
    }
    return ret;
  }
  if (singleType === 'i8') {
    if (slab.subarray || slab.slice) {
      HEAPU8.set(slab, ret);
    } else {
      HEAPU8.set(new Uint8Array(slab), ret);
    }
    return ret;
  }
  var i = 0, type, typeSize, previousType;
  while (i < size) {
    var curr = slab[i];
    if (typeof curr === 'function') {
      curr = Runtime.getFunctionIndex(curr);
    }
    type = singleType || types[i];
    if (type === 0) {
      i++;
      continue;
    }
    if (type == 'i64') type = 'i32'; // special case: we have one i32 here, and one i32 later
    setValue(ret+i, curr, type);
    // no need to look up size unless type changes, so cache it
    if (previousType !== type) {
      typeSize = Runtime.getNativeTypeSize(type);
      previousType = type;
    }
    i += typeSize;
  }
  return ret;
}
Module['allocate'] = allocate;
function Pointer_stringify(ptr, /* optional */ length) {
  // TODO: use TextDecoder
  // Find the length, and check for UTF while doing so
  var hasUtf = false;
  var t;
  var i = 0;
  while (1) {
    t = HEAPU8[(((ptr)+(i))|0)];
    if (t >= 128) hasUtf = true;
    else if (t == 0 && !length) break;
    i++;
    if (length && i == length) break;
  }
  if (!length) length = i;
  var ret = '';
  if (!hasUtf) {
    var MAX_CHUNK = 1024; // split up into chunks, because .apply on a huge string can overflow the stack
    var curr;
    while (length > 0) {
      curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
      ret = ret ? ret + curr : curr;
      ptr += MAX_CHUNK;
      length -= MAX_CHUNK;
    }
    return ret;
  }
  var utf8 = new Runtime.UTF8Processor();
  for (i = 0; i < length; i++) {
    t = HEAPU8[(((ptr)+(i))|0)];
    ret += utf8.processCChar(t);
  }
  return ret;
}
Module['Pointer_stringify'] = Pointer_stringify;
// Memory management
var PAGE_SIZE = 4096;
function alignMemoryPage(x) {
  return ((x+4095)>>12)<<12;
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0, STATICTOP = 0, staticSealed = false; // static area
var STACK_BASE = 0, STACKTOP = 0, STACK_MAX = 0; // stack area
var DYNAMIC_BASE = 0, DYNAMICTOP = 0; // dynamic area handled by sbrk
function enlargeMemory() {
  abort('Cannot enlarge memory arrays in asm.js. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value, or (2) set Module.TOTAL_MEMORY before the program runs.');
}
var TOTAL_STACK = Module['TOTAL_STACK'] || 5242880;
var TOTAL_MEMORY = Module['TOTAL_MEMORY'] || 67108864;
var FAST_MEMORY = Module['FAST_MEMORY'] || 2097152;
// Initialize the runtime's memory
// check for full engine support (use string 'subarray' to avoid closure compiler confusion)
assert(!!Int32Array && !!Float64Array && !!(new Int32Array(1)['subarray']) && !!(new Int32Array(1)['set']),
       'Cannot fallback to non-typed array case: Code is too specialized');
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
// Endianness check (note: assumes compiler arch was little-endian)
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, 'Typed arrays 2 must be run on a little-endian system');
Module['HEAP'] = HEAP;
Module['HEAP8'] = HEAP8;
Module['HEAP16'] = HEAP16;
Module['HEAP32'] = HEAP32;
Module['HEAPU8'] = HEAPU8;
Module['HEAPU16'] = HEAPU16;
Module['HEAPU32'] = HEAPU32;
Module['HEAPF32'] = HEAPF32;
Module['HEAPF64'] = HEAPF64;
function callRuntimeCallbacks(callbacks) {
  while(callbacks.length > 0) {
    var callback = callbacks.shift();
    if (typeof callback == 'function') {
      callback();
      continue;
    }
    var func = callback.func;
    if (typeof func === 'number') {
      if (callback.arg === undefined) {
        Runtime.dynCall('v', func);
      } else {
        Runtime.dynCall('vi', func, [callback.arg]);
      }
    } else {
      func(callback.arg === undefined ? null : callback.arg);
    }
  }
}
var __ATPRERUN__  = []; // functions called before the runtime is initialized
var __ATINIT__    = []; // functions called during startup
var __ATMAIN__    = []; // functions called when main() is to be run
var __ATEXIT__    = []; // functions called during shutdown
var __ATPOSTRUN__ = []; // functions called after the runtime has exited
var runtimeInitialized = false;
function preRun() {
  // compatibility - merge in anything from Module['preRun'] at this time
  if (Module['preRun']) {
    if (typeof Module['preRun'] == 'function') Module['preRun'] = [Module['preRun']];
    while (Module['preRun'].length) {
      addOnPreRun(Module['preRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPRERUN__);
}
function ensureInitRuntime() {
  if (runtimeInitialized) return;
  runtimeInitialized = true;
  callRuntimeCallbacks(__ATINIT__);
}
function preMain() {
  callRuntimeCallbacks(__ATMAIN__);
}
function exitRuntime() {
  callRuntimeCallbacks(__ATEXIT__);
}
function postRun() {
  // compatibility - merge in anything from Module['postRun'] at this time
  if (Module['postRun']) {
    if (typeof Module['postRun'] == 'function') Module['postRun'] = [Module['postRun']];
    while (Module['postRun'].length) {
      addOnPostRun(Module['postRun'].shift());
    }
  }
  callRuntimeCallbacks(__ATPOSTRUN__);
}
function addOnPreRun(cb) {
  __ATPRERUN__.unshift(cb);
}
Module['addOnPreRun'] = Module.addOnPreRun = addOnPreRun;
function addOnInit(cb) {
  __ATINIT__.unshift(cb);
}
Module['addOnInit'] = Module.addOnInit = addOnInit;
function addOnPreMain(cb) {
  __ATMAIN__.unshift(cb);
}
Module['addOnPreMain'] = Module.addOnPreMain = addOnPreMain;
function addOnExit(cb) {
  __ATEXIT__.unshift(cb);
}
Module['addOnExit'] = Module.addOnExit = addOnExit;
function addOnPostRun(cb) {
  __ATPOSTRUN__.unshift(cb);
}
Module['addOnPostRun'] = Module.addOnPostRun = addOnPostRun;
// Tools
// This processes a JS string into a C-line array of numbers, 0-terminated.
// For LLVM-originating strings, see parser.js:parseLLVMString function
function intArrayFromString(stringy, dontAddNull, length /* optional */) {
  var ret = (new Runtime.UTF8Processor()).processJSString(stringy);
  if (length) {
    ret.length = length;
  }
  if (!dontAddNull) {
    ret.push(0);
  }
  return ret;
}
Module['intArrayFromString'] = intArrayFromString;
function intArrayToString(array) {
  var ret = [];
  for (var i = 0; i < array.length; i++) {
    var chr = array[i];
    if (chr > 0xFF) {
      chr &= 0xFF;
    }
    ret.push(String.fromCharCode(chr));
  }
  return ret.join('');
}
Module['intArrayToString'] = intArrayToString;
// Write a Javascript array to somewhere in the heap
function writeStringToMemory(string, buffer, dontAddNull) {
  var array = intArrayFromString(string, dontAddNull);
  var i = 0;
  while (i < array.length) {
    var chr = array[i];
    HEAP8[(((buffer)+(i))|0)]=chr
    i = i + 1;
  }
}
Module['writeStringToMemory'] = writeStringToMemory;
function writeArrayToMemory(array, buffer) {
  for (var i = 0; i < array.length; i++) {
    HEAP8[(((buffer)+(i))|0)]=array[i];
  }
}
Module['writeArrayToMemory'] = writeArrayToMemory;
function unSign(value, bits, ignore, sig) {
  if (value >= 0) {
    return value;
  }
  return bits <= 32 ? 2*Math.abs(1 << (bits-1)) + value // Need some trickery, since if bits == 32, we are right at the limit of the bits JS uses in bitshifts
                    : Math.pow(2, bits)         + value;
}
function reSign(value, bits, ignore, sig) {
  if (value <= 0) {
    return value;
  }
  var half = bits <= 32 ? Math.abs(1 << (bits-1)) // abs is needed if bits == 32
                        : Math.pow(2, bits-1);
  if (value >= half && (bits <= 32 || value > half)) { // for huge values, we can hit the precision limit and always get true here. so don't do that
                                                       // but, in general there is no perfect solution here. With 64-bit ints, we get rounding and errors
                                                       // TODO: In i64 mode 1, resign the two parts separately and safely
    value = -2*half + value; // Cannot bitshift half, as it may be at the limit of the bits JS uses in bitshifts
  }
  return value;
}
if (!Math['imul']) Math['imul'] = function(a, b) {
  var ah  = a >>> 16;
  var al = a & 0xffff;
  var bh  = b >>> 16;
  var bl = b & 0xffff;
  return (al*bl + ((ah*bl + al*bh) << 16))|0;
};
Math.imul = Math['imul'];
// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// PRE_RUN_ADDITIONS (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies = 0;
var runDependencyTracking = {};
var calledInit = false, calledRun = false;
var runDependencyWatcher = null;
function addRunDependency(id) {
  runDependencies++;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(!runDependencyTracking[id]);
    runDependencyTracking[id] = 1;
  } else {
    Module.printErr('warning: run dependency added without ID');
  }
}
Module['addRunDependency'] = addRunDependency;
function removeRunDependency(id) {
  runDependencies--;
  if (Module['monitorRunDependencies']) {
    Module['monitorRunDependencies'](runDependencies);
  }
  if (id) {
    assert(runDependencyTracking[id]);
    delete runDependencyTracking[id];
  } else {
    Module.printErr('warning: run dependency removed without ID');
  }
  if (runDependencies == 0) {
    if (runDependencyWatcher !== null) {
      clearInterval(runDependencyWatcher);
      runDependencyWatcher = null;
    } 
    // If run has never been called, and we should call run (INVOKE_RUN is true, and Module.noInitialRun is not false)
    if (!calledRun && shouldRunNow) run();
  }
}
Module['removeRunDependency'] = removeRunDependency;
Module["preloadedImages"] = {}; // maps url to image data
Module["preloadedAudios"] = {}; // maps url to audio data
function loadMemoryInitializer(filename) {
  function applyData(data) {
    HEAPU8.set(data, STATIC_BASE);
  }
  // always do this asynchronously, to keep shell and web as similar as possible
  addOnPreRun(function() {
    if (ENVIRONMENT_IS_NODE || ENVIRONMENT_IS_SHELL) {
      applyData(Module['readBinary'](filename));
    } else {
      Browser.asyncLoad(filename, function(data) {
        applyData(data);
      }, function(data) {
        throw 'could not load memory initializer ' + filename;
      });
    }
  });
}
// === Body ===
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 44152;
/* global initializers */ __ATINIT__.push({ func: function() { runPostSets() } },{ func: function() { __GLOBAL__I_a() } });
var ___dso_handle;
var __ZTVN10__cxxabiv120__si_class_type_infoE;
var __ZTVN10__cxxabiv117__class_type_infoE;
__ZTVN10__cxxabiv120__si_class_type_infoE=allocate([0,0,0,0,104,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
__ZTVN10__cxxabiv117__class_type_infoE=allocate([0,0,0,0,120,135,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], "i8", ALLOC_STATIC);
/* memory initializer */ allocate([92,0,0,0,158,6,0,0,42,0,0,0,84,1,0,0,28,4,0,0,84,0,0,0,56,1,0,0,134,1,0,0,108,0,0,0,120,1,0,0,68,0,0,0,206,1,0,0,70,0,0,0,82,4,0,0,54,0,0,0,14,2,0,0,64,0,0,0,10,4,0,0,88,0,0,0,98,6,0,0,16,1,0,0,192,0,0,0,236,1,0,0,54,0,0,0,176,6,0,0,50,0,0,0,174,3,0,0,18,1,0,0,48,0,0,0,42,0,0,0,42,0,0,0,86,2,0,0,42,0,0,0,250,2,0,0,144,8,0,0,128,1,0,0,206,1,0,0,224,0,0,0,54,0,0,0,62,0,0,0,196,4,0,0,128,2,0,0,40,2,0,0,144,1,0,0,164,4,0,0,90,4,0,0,108,1,0,0,142,6,0,0,0,6,0,0,238,4,0,0,0,1,0,0,88,1,0,0,254,8,0,0,82,2,0,0,200,0,0,0,216,1,0,0,66,0,0,0,114,0,0,0,252,3,0,0,206,0,0,0,112,0,0,0,230,1,0,0,178,6,0,0,204,1,0,0,240,2,0,0,74,0,0,0,146,2,0,0,48,0,0,0,84,4,0,0,50,0,0,0,68,0,0,0,168,0,0,0,122,6,0,0,58,2,0,0,106,0,0,0,42,0,0,0,204,1,0,0,198,3,0,0,202,2,0,0,36,2,0,0,204,2,0,0,136,0,0,0,172,1,0,0,86,1,0,0,72,0,0,0,188,2,0,0,70,1,0,0,98,0,0,0,104,5,0,0,64,1,0,0,182,3,0,0,66,2,0,0,118,2,0,0,142,0,0,0,132,0,0,0,230,5,0,0,184,0,0,0,36,6,0,0,46,0,0,0,52,1,0,0,74,0,0,0,172,5,0,0,110,0,0,0,162,0,0,0,136,4,0,0,178,0,0,0,66,0,0,0,96,10,0,0,214,4,0,0,68,0,0,0,98,3,0,0,44,0,0,0,130,1,0,0,124,0,0,0,138,5,0,0,196,1,0,0,70,0,0,0,46,5,0,0,238,5,0,0,68,10,0,0,72,1,0,0,222,0,0,0,76,0,0,0,94,4,0,0,196,0,0,0,234,3,0,0,46,9,0,0,52,0,0,0,32,3,0,0,166,0,0,0,108,0,0,0,92,7,0,0,68,0,0,0,126,5,0,0,10,2,0,0,200,0,0,0,36,3,0,0,204,9,0,0,144,0,0,0,86,0,0,0,112,0,0,0,98,0,0,0,190,0,0,0,42,5,0,0,18,1,0,0,204,1,0,0,10,3,0,0,38,1,0,0,58,0,0,0,146,1,0,0,70,0,0,0,52,1,0,0,216,1,0,0,56,0,0,0,252,2,0,0,36,2,0,0,224,5,0,0,24,5,0,0,88,0,0,0,46,0,0,0,64,5,0,0,142,0,0,0,80,1,0,0,2,3,0,0,220,9,0,0,98,0,0,0,242,3,0,0,236,4,0,0,170,1,0,0,232,0,0,0,28,8,0,0,48,8,0,0,122,5,0,0,68,4,0,0,18,5,0,0,18,9,0,0,216,5,0,0,100,4,0,0,60,1,0,0,84,6,0,0,0,3,0,0,120,4,0,0,84,1,0,0,56,10,0,0,98,0,0,0,120,0,0,0,50,0,0,0,218,7,0,0,112,6,0,0,158,1,0,0,210,4,0,0,144,6,0,0,154,2,0,0,192,0,0,0,150,2,0,0,186,1,0,0,132,5,0,0,196,0,0,0,38,2,0,0,132,4,0,0,192,1,0,0,42,3,0,0,122,0,0,0,106,0,0,0,230,3,0,0,58,0,0,0,194,3,0,0,116,0,0,0,138,2,0,0,234,5,0,0,48,1,0,0,148,5,0,0,140,0,0,0,44,5,0,0,196,4,0,0,12,5,0,0,68,1,0,0,138,0,0,0,120,5,0,0,214,1,0,0,90,2,0,0,176,0,0,0,132,10,0,0,24,3,0,0,96,2,0,0,210,1,0,0,140,0,0,0,50,0,0,0,178,1,0,0,40,1,0,0,8,5,0,0,106,0,0,0,34,4,0,0,40,5,0,0,172,0,0,0,230,0,0,0,220,10,0,0,172,9,0,0,220,1,0,0,246,3,0,0,36,4,0,0,56,1,0,0,64,1,0,0,60,0,0,0,228,0,0,0,170,7,0,0,108,4,0,0,254,3,0,0,208,0,0,0,222,7,0,0,232,0,0,0,82,7,0,0,44,0,0,0,172,3,0,0,72,0,0,0,152,5,0,0,44,0,0,0,174,1,0,0,86,0,0,0,192,3,0,0,224,0,0,0,244,0,0,0,12,8,0,0,120,1,0,0,60,0,0,0,82,1,0,0,222,3,0,0,40,7,0,0,168,4,0,0,186,0,0,0,174,7,0,0,238,0,0,0,238,0,0,0,28,2,0,0,114,0,0,0,110,2,0,0,242,7,0,0,42,0,0,0,126,7,0,0,166,7,0,0,6,1,0,0,230,8,0,0,112,6,0,0,2,3,0,0,222,1,0,0,92,1,0,0,4,2,0,0,44,0,0,0,126,0,0,0,122,1,0,0,90,1,0,0,250,3,0,0,88,0,0,0,86,10,0,0,118,0,0,0,188,0,0,0,198,6,0,0,198,0,0,0,16,1,0,0,56,4,0,0,74,7,0,0,88,0,0,0,64,0,0,0,122,10,0,0,50,3,0,0,130,10,0,0,108,3,0,0,50,1,0,0,94,0,0,0,46,0,0,0,114,0,0,0,136,3,0,0,48,1,0,0,196,1,0,0,224,0,0,0,196,0,0,0,62,0,0,0,42,0,0,0,98,1,0,0,222,0,0,0,174,2,0,0,144,0,0,0,154,0,0,0,170,0,0,0,64,3,0,0,44,4,0,0,80,0,0,0,56,3,0,0,44,0,0,0,52,0,0,0,44,0,0,0,42,0,0,0,8,3,0,0,82,2,0,0,164,1,0,0,42,1,0,0,0,2,0,0,62,3,0,0,20,1,0,0,106,9,0,0,132,0,0,0,116,3,0,0,0,9,0,0,164,0,0,0,66,3,0,0,64,2,0,0,152,0,0,0,140,4,0,0,218,0,0,0,34,3,0,0,148,1,0,0,42,0,0,0,14,10,0,0,130,3,0,0,232,1,0,0,228,3,0,0,134,0,0,0,78,0,0,0,48,0,0,0,120,0,0,0,54,1,0,0,224,1,0,0,90,0,0,0,206,4,0,0,236,0,0,0,132,0,0,0,154,5,0,0,130,0,0,0,74,0,0,0,50,0,0,0,62,0,0,0,64,0,0,0,144,1,0,0,76,1,0,0,48,0,0,0,34,2,0,0,66,0,0,0,226,0,0,0,48,0,0,0,80,7,0,0,166,9,0,0,126,3,0,0,122,0,0,0,124,9,0,0,246,2,0,0,156,2,0,0,94,1,0,0,30,5,0,0,242,0,0,0,194,5,0,0,90,4,0,0,68,0,0,0,42,0,0,0,50,1,0,0,62,0,0,0,174,6,0,0,170,1,0,0,194,0,0,0,134,1,0,0,98,2,0,0,92,0,0,0,198,3,0,0,226,3,0,0,66,0,0,0,114,1,0,0,250,9,0,0,120,2,0,0,172,0,0,0,42,5,0,0,18,1,0,0,6,1,0,0,104,0,0,0,132,5,0,0,22,9,0,0,96,5,0,0,120,0,0,0,92,0,0,0,120,2,0,0,80,0,0,0,6,5,0,0,54,9,0,0,208,3,0,0,22,3,0,0,220,0,0,0,124,8,0,0,232,5,0,0,42,1,0,0,96,0,0,0,164,1,0,0,50,1,0,0,222,9,0,0,74,1,0,0,34,6,0,0,76,0,0,0,150,1,0,0,218,1,0,0,80,0,0,0,68,1,0,0,234,2,0,0,156,2,0,0,24,4,0,0,242,1,0,0,192,0,0,0,0,1,0,0,98,0,0,0,198,0,0,0,80,2,0,0,56,0,0,0,150,1,0,0,200,4,0,0,208,0,0,0,10,1,0,0,208,10,0,0,84,0,0,0,94,6,0,0,2,1,0,0,110,0,0,0,38,3,0,0,56,1,0,0,110,3,0,0,210,4,0,0,156,10,0,0,134,6,0,0,38,1,0,0,240,1,0,0,90,0,0,0,194,6,0,0,18,6,0,0,56,0,0,0,62,7,0,0,226,7,0,0,140,2,0,0,240,0,0,0,68,3,0,0,216,6,0,0,152,3,0,0,80,0,0,0,2,2,0,0,70,1,0,0,94,3,0,0,76,0,0,0,220,7,0,0,206,4,0,0,112,1,0,0,76,8,0,0,130,4,0,0,80,0,0,0,110,2,0,0,26,2,0,0,28,1,0,0,86,0,0,0,38,2,0,0,44,4,0,0,86,0,0,0,206,9,0,0,236,0,0,0,192,5,0,0,112,0,0,0,196,0,0,0,102,4,0,0,32,1,0,0,124,1,0,0,36,2,0,0,100,1,0,0,82,5,0,0,112,1,0,0,216,1,0,0,12,4,0,0,86,1,0,0,216,3,0,0,238,2,0,0,136,0,0,0,54,0,0,0,88,4,0,0,102,2,0,0,166,1,0,0,122,0,0,0,54,1,0,0,28,1,0,0,16,1,0,0,20,6,0,0,76,0,0,0,60,3,0,0,234,3,0,0,36,5,0,0,68,6,0,0,168,0,0,0,242,2,0,0,44,0,0,0,42,0,0,0,42,0,0,0,40,3,0,0,250,8,0,0,174,2,0,0,174,3,0,0,128,0,0,0,168,10,0,0,66,1,0,0,24,1,0,0,50,0,0,0,22,6,0,0,110,2,0,0,80,0,0,0,58,0,0,0,174,2,0,0,42,0,0,0,180,0,0,0,182,1,0,0,80,2,0,0,128,0,0,0,142,1,0,0,32,2,0,0,190,1,0,0,140,6,0,0,186,4,0,0,202,0,0,0,192,0,0,0,128,3,0,0,4,9,0,0,182,5,0,0,94,0,0,0,52,0,0,0,50,4,0,0,164,3,0,0,136,0,0,0,68,0,0,0,100,1,0,0,82,3,0,0,218,1,0,0,52,1,0,0,98,0,0,0,74,1,0,0,46,0,0,0,50,7,0,0,50,9,0,0,126,9,0,0,94,1,0,0,32,3,0,0,88,0,0,0,88,0,0,0,42,0,0,0,174,6,0,0,114,5,0,0,60,1,0,0,62,6,0,0,180,4,0,0,72,1,0,0,148,2,0,0,92,6,0,0,152,0,0,0,174,5,0,0,6,6,0,0,22,3,0,0,140,7,0,0,64,6,0,0,6,1,0,0,22,2,0,0,216,0,0,0,174,1,0,0,96,6,0,0,132,0,0,0,150,4,0,0,126,6,0,0,246,0,0,0,2,5,0,0,128,1,0,0,72,0,0,0,226,0,0,0,54,5,0,0,162,7,0,0,152,0,0,0,90,0,0,0,210,0,0,0,160,1,0,0,42,0,0,0,46,0,0,0,170,5,0,0,192,1,0,0,44,0,0,0,56,0,0,0,228,2,0,0,46,0,0,0,60,0,0,0,246,1,0,0,52,0,0,0,56,5,0,0,94,1,0,0,156,2,0,0,110,5,0,0,98,9,0,0,48,4,0,0,78,0,0,0,222,1,0,0,138,1,0,0,88,2,0,0,186,1,0,0,176,2,0,0,188,6,0,0,84,0,0,0,240,0,0,0,170,0,0,0,78,0,0,0,210,1,0,0,58,0,0,0,18,2,0,0,84,0,0,0,106,10,0,0,122,4,0,0,100,0,0,0,180,6,0,0,46,2,0,0,206,0,0,0,44,0,0,0,26,5,0,0,172,10,0,0,168,7,0,0,102,2,0,0,208,0,0,0,82,1,0,0,170,2,0,0,252,0,0,0,44,0,0,0,160,1,0,0,60,0,0,0,106,3,0,0,142,2,0,0,62,4,0,0,80,0,0,0,118,9,0,0,120,0,0,0,108,6,0,0,122,3,0,0,58,7,0,0,124,0,0,0,132,2,0,0,244,0,0,0,92,2,0,0,208,1,0,0,114,2,0,0,160,0,0,0,122,2,0,0,108,1,0,0,160,6,0,0,134,0,0,0,148,2,0,0,236,7,0,0,148,5,0,0,160,1,0,0,150,2,0,0,138,3,0,0,140,4,0,0,12,5,0,0,52,5,0,0,174,8,0,0,54,2,0,0,186,5,0,0,52,0,0,0,26,4,0,0,42,0,0,0,42,0,0,0,148,1,0,0,34,4,0,0,56,0,0,0,132,1,0,0,10,7,0,0,158,0,0,0,42,1,0,0,104,1,0,0,54,6,0,0,236,0,0,0,82,1,0,0,14,1,0,0,156,3,0,0,52,0,0,0,148,8,0,0,110,3,0,0,242,8,0,0,218,1,0,0,104,0,0,0,150,4,0,0,122,8,0,0,180,1,0,0,200,6,0,0,104,2,0,0,98,0,0,0,158,7,0,0,92,2,0,0,84,0,0,0,142,1,0,0,200,3,0,0,138,2,0,0,140,3,0,0,2,5,0,0,182,1,0,0,148,6,0,0,202,0,0,0,74,0,0,0,62,0,0,0,106,5,0,0,208,2,0,0,222,0,0,0,86,0,0,0,102,0,0,0,128,3,0,0,52,3,0,0,216,7,0,0,130,1,0,0,42,0,0,0,126,1,0,0,172,0,0,0,222,0,0,0,44,8,0,0,144,10,0,0,184,1,0,0,202,0,0,0,148,0,0,0,50,3,0,0,88,4,0,0,46,3,0,0,176,2,0,0,180,2,0,0,254,2,0,0,50,8,0,0,72,5,0,0,100,7,0,0,28,6,0,0,188,9,0,0,30,1,0,0,132,3,0,0,52,5,0,0,238,2,0,0,88,0,0,0,160,0,0,0,186,0,0,0,112,0,0,0,192,9,0,0,156,5,0,0,62,3,0,0,190,5,0,0,232,1,0,0,194,6,0,0,80,5,0,0,174,1,0,0,176,1,0,0,236,0,0,0,52,0,0,0,228,6,0,0,238,1,0,0,206,3,0,0,88,0,0,0,164,2,0,0,98,1,0,0,200,6,0,0,42,4,0,0,180,1,0,0,40,1,0,0,100,1,0,0,170,1,0,0,148,10,0,0,96,5,0,0,50,0,0,0,92,5,0,0,50,0,0,0,170,0,0,0,64,4,0,0,224,0,0,0,60,2,0,0,66,6,0,0,86,5,0,0,206,0,0,0,96,1,0,0,172,2,0,0,140,0,0,0,60,0,0,0,50,0,0,0,98,1,0,0,200,1,0,0,96,0,0,0,160,1,0,0,104,4,0,0,46,0,0,0,82,0,0,0,194,0,0,0,138,10,0,0,136,0,0,0,50,2,0,0,58,0,0,0,226,1,0,0,106,0,0,0,230,1,0,0,94,0,0,0,44,2,0,0,0,1,0,0,178,2,0,0,16,5,0,0,62,0,0,0,188,10,0,0,158,0,0,0,58,0,0,0,128,0,0,0,90,3,0,0,22,3,0,0,96,0,0,0,252,2,0,0,80,0,0,0,252,1,0,0,42,8,0,0,164,7,0,0,90,0,0,0,58,0,0,0,50,0,0,0,46,0,0,0,202,2,0,0,240,3,0,0,50,1,0,0,124,1,0,0,70,5,0,0,168,1,0,0,216,8,0,0,138,0,0,0,14,2,0,0,190,3,0,0,62,6,0,0,132,7,0,0,6,5,0,0,142,5,0,0,76,0,0,0,4,1,0,0,226,1,0,0,162,0,0,0,46,0,0,0,120,0,0,0,104,0,0,0,76,0,0,0,200,1,0,0,100,3,0,0,128,0,0,0,114,10,0,0,28,1,0,0,168,4,0,0,50,0,0,0,12,10,0,0,4,3,0,0,62,2,0,0,28,3,0,0,106,0,0,0,38,1,0,0,214,1,0,0,168,9,0,0,144,0,0,0,224,8,0,0,128,0,0,0,218,3,0,0,246,0,0,0,242,0,0,0,168,3,0,0,204,0,0,0,174,0,0,0,192,1,0,0,70,0,0,0,204,5,0,0,180,10,0,0,154,0,0,0,108,7,0,0,182,2,0,0,102,2,0,0,140,0,0,0,230,1,0,0,10,4,0,0,58,6,0,0,50,1,0,0,2,2,0,0,90,1,0,0,156,4,0,0,146,0,0,0,26,3,0,0,188,2,0,0,96,0,0,0,244,1,0,0,160,9,0,0,242,0,0,0,82,0,0,0,234,8,0,0,68,2,0,0,158,1,0,0,48,0,0,0,42,0,0,0,44,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,44,0,0,0,42,0,0,0,178,0,0,0,210,8,0,0,46,0,0,0,126,0,0,0,104,0,0,0,44,0,0,0,42,0,0,0,28,1,0,0,78,0,0,0,60,6,0,0,42,0,0,0,42,0,0,0,42,0,0,0,232,2,0,0,48,0,0,0,24,2,0,0,82,2,0,0,200,0,0,0,186,0,0,0,124,0,0,0,8,5,0,0,144,6,0,0,66,3,0,0,84,2,0,0,106,3,0,0,134,5,0,0,146,1,0,0,98,0,0,0,86,0,0,0,138,3,0,0,86,0,0,0,186,0,0,0,110,1,0,0,116,1,0,0,148,0,0,0,252,8,0,0,202,1,0,0,116,0,0,0,152,2,0,0,178,3,0,0,124,4,0,0,32,3,0,0,154,6,0,0,78,0,0,0,102,1,0,0,18,1,0,0,28,1,0,0,40,10,0,0,216,0,0,0,52,0,0,0,152,5,0,0,50,3,0,0,98,5,0,0,176,0,0,0,126,2,0,0,148,0,0,0,158,2,0,0,232,2,0,0,142,0,0,0,224,2,0,0,46,0,0,0,182,0,0,0,170,1,0,0,208,1,0,0,32,4,0,0,126,5,0,0,172,4,0,0,112,4,0,0,52,0,0,0,158,0,0,0,116,0,0,0,44,0,0,0,140,1,0,0,132,6,0,0,96,0,0,0,50,6,0,0,200,5,0,0,144,1,0,0,120,1,0,0,16,9,0,0,158,4,0,0,252,2,0,0,108,3,0,0,72,2,0,0,192,5,0,0,102,6,0,0,44,9,0,0,38,4,0,0,188,1,0,0,146,3,0,0,102,3,0,0,0,5,0,0,100,0,0,0,154,1,0,0,220,2,0,0,102,6,0,0,196,5,0,0,20,3,0,0,26,1,0,0,104,2,0,0,204,6,0,0,216,1,0,0,192,4,0,0,128,1,0,0,94,0,0,0,60,0,0,0,12,1,0,0,20,4,0,0,210,0,0,0,34,1,0,0,80,1,0,0,110,0,0,0,68,0,0,0,56,2,0,0,106,1,0,0,234,4,0,0,114,0,0,0,90,0,0,0,100,1,0,0,90,0,0,0,152,4,0,0,36,10,0,0,100,0,0,0,92,3,0,0,80,0,0,0,52,0,0,0,44,0,0,0,44,0,0,0,60,7,0,0,44,0,0,0,154,1,0,0,134,0,0,0,86,1,0,0,156,0,0,0,108,1,0,0,106,0,0,0,72,0,0,0,108,0,0,0,220,2,0,0,162,0,0,0,4,1,0,0,48,0,0,0,212,1,0,0,50,0,0,0,198,2,0,0,162,1,0,0,94,5,0,0,80,1,0,0,48,0,0,0,146,0,0,0,82,1,0,0,138,0,0,0,100,0,0,0,10,3,0,0,106,2,0,0,84,0,0,0,156,0,0,0,22,4,0,0,12,3,0,0,226,9,0,0,72,2,0,0,218,3,0,0,170,9,0,0,122,7,0,0,162,2,0,0,202,3,0,0,16,4,0,0,208,2,0,0,60,5,0,0,206,1,0,0,0,1,0,0,148,2,0,0,86,0,0,0,162,4,0,0,10,3,0,0,192,3,0,0,224,4,0,0,252,6,0,0,86,0,0,0,74,4,0,0,114,1,0,0,168,1,0,0,240,5,0,0,116,1,0,0,22,2,0,0,170,4,0,0,44,0,0,0,36,1,0,0,0,1,0,0,88,0,0,0,108,0,0,0,178,4,0,0,202,0,0,0,156,4,0,0,50,4,0,0,108,0,0,0,50,0,0,0,42,0,0,0,158,0,0,0,212,1,0,0,244,0,0,0,166,0,0,0,68,9,0,0,214,0,0,0,140,5,0,0,86,4,0,0,68,0,0,0,216,2,0,0,186,4,0,0,150,0,0,0,4,5,0,0,196,0,0,0,102,8,0,0,52,0,0,0,46,0,0,0,50,0,0,0,240,4,0,0,108,5,0,0,208,6,0,0,204,1,0,0,232,1,0,0,68,5,0,0,94,5,0,0,124,1,0,0,214,10,0,0,206,0,0,0,178,3,0,0,42,0,0,0,146,1,0,0,58,2,0,0,64,3,0,0,154,0,0,0,48,6,0,0,184,1,0,0,236,5,0,0,92,5,0,0,38,8,0,0,166,3,0,0,246,0,0,0,252,0,0,0,102,0,0,0,40,5,0,0,108,0,0,0,72,0,0,0,106,0,0,0,78,0,0,0,48,0,0,0,126,4,0,0,76,4,0,0,54,0,0,0,178,0,0,0,66,0,0,0,142,1,0,0,4,6,0,0,26,5,0,0,112,1,0,0,100,6,0,0,148,1,0,0,178,2,0,0,166,0,0,0,166,0,0,0,58,1,0,0,32,1,0,0,242,1,0,0,84,0,0,0,160,3,0,0,220,1,0,0,146,5,0,0,156,1,0,0,100,0,0,0,188,4,0,0,144,0,0,0,88,0,0,0,222,0,0,0,230,0,0,0,210,1,0,0,56,0,0,0,238,0,0,0,174,0,0,0,174,0,0,0,62,0,0,0,56,0,0,0,46,0,0,0,44,0,0,0,42,0,0,0,148,0,0,0,154,1,0,0,252,1,0,0,58,0,0,0,40,4,0,0,68,0,0,0,44,0,0,0,218,1,0,0,154,0,0,0,156,0,0,0,234,6,0,0,44,0,0,0,42,0,0,0,160,3,0,0,202,0,0,0,214,3,0,0,82,10,0,0,66,0,0,0,42,10,0,0,78,5,0,0,146,0,0,0,246,4,0,0,188,2,0,0,56,0,0,0,102,0,0,0,208,8,0,0,90,2,0,0,82,0,0,0,12,1,0,0,26,1,0,0,88,0,0,0,118,1,0,0,254,1,0,0,46,0,0,0,186,0,0,0,180,0,0,0,52,0,0,0,42,0,0,0,42,0,0,0,140,6,0,0,128,5,0,0,58,0,0,0,18,1,0,0,46,7,0,0,20,3,0,0,124,1,0,0,2,1,0,0,112,0,0,0,48,0,0,0,48,0,0,0,126,6,0,0,22,1,0,0,126,0,0,0,56,3,0,0,28,7,0,0,118,5,0,0,74,0,0,0,54,0,0,0,42,0,0,0,212,9,0,0,78,1,0,0,82,0,0,0,8,2,0,0,50,10,0,0,14,3,0,0,224,1,0,0,150,0,0,0,236,6,0,0,100,1,0,0,64,3,0,0,62,0,0,0,54,0,0,0,48,0,0,0,60,0,0,0,48,0,0,0,46,0,0,0,194,10,0,0,176,3,0,0,50,0,0,0,186,2,0,0,246,1,0,0,128,0,0,0,230,2,0,0,230,2,0,0,164,6,0,0,184,1,0,0,12,1,0,0,78,2,0,0,78,2,0,0,82,0,0,0,114,0,0,0,42,0,0,0,250,1,0,0,254,1,0,0,42,0,0,0,152,1,0,0,144,0,0,0,124,0,0,0,106,1,0,0,10,1,0,0,56,0,0,0,142,3,0,0,156,8,0,0,94,4,0,0,64,0,0,0,116,1,0,0,216,0,0,0,12,2,0,0,14,6,0,0,138,1,0,0,14,1,0,0,70,0,0,0,58,1,0,0,140,1,0,0,198,1,0,0,88,0,0,0,74,1,0,0,180,0,0,0,254,0,0,0,72,1,0,0,112,1,0,0,104,0,0,0,238,1,0,0,146,9,0,0,248,0,0,0,56,1,0,0,52,1,0,0,238,1,0,0,112,0,0,0,64,0,0,0,172,4,0,0,90,0,0,0,128,0,0,0,166,1,0,0,254,0,0,0,126,4,0,0,44,3,0,0,76,10,0,0,84,0,0,0,64,1,0,0,214,1,0,0,54,0,0,0,106,4,0,0,242,1,0,0,154,0,0,0,106,1,0,0,204,0,0,0,158,0,0,0,178,4,0,0,210,0,0,0,234,1,0,0,76,0,0,0,242,4,0,0,30,2,0,0,250,5,0,0,222,2,0,0,42,2,0,0,10,1,0,0,104,1,0,0,174,0,0,0,216,4,0,0,54,7,0,0,86,1,0,0,144,1,0,0,182,1,0,0,100,9,0,0,50,0,0,0,98,0,0,0,158,1,0,0,58,0,0,0,172,0,0,0,62,0,0,0,118,1,0,0,218,9,0,0,70,0,0,0,244,7,0,0,226,0,0,0,250,5,0,0,64,0,0,0,164,0,0,0,112,4,0,0,208,1,0,0,110,5,0,0,20,1,0,0,140,1,0,0,212,0,0,0,46,0,0,0,44,3,0,0,224,9,0,0,244,0,0,0,0,1,0,0,42,0,0,0,16,4,0,0,212,0,0,0,158,1,0,0,82,0,0,0,52,2,0,0,238,0,0,0,134,4,0,0,230,1,0,0,174,5,0,0,66,2,0,0,64,0,0,0,192,1,0,0,220,4,0,0,56,6,0,0,32,10,0,0,218,2,0,0,242,2,0,0,202,0,0,0,202,5,0,0,54,0,0,0,42,3,0,0,132,1,0,0,214,2,0,0,38,2,0,0,86,0,0,0,24,9,0,0,78,5,0,0,152,2,0,0,82,0,0,0,184,1,0,0,162,1,0,0,200,0,0,0,164,5,0,0,128,1,0,0,224,0,0,0,170,8,0,0,20,9,0,0,110,0,0,0,80,4,0,0,222,0,0,0,8,10,0,0,114,0,0,0,68,1,0,0,0,5,0,0,48,5,0,0,34,1,0,0,42,0,0,0,42,0,0,0,188,3,0,0,136,0,0,0,160,4,0,0,164,6,0,0,128,2,0,0,80,10,0,0,200,2,0,0,14,7,0,0,44,0,0,0,44,0,0,0,6,2,0,0,62,1,0,0,92,0,0,0,214,1,0,0,254,0,0,0,224,0,0,0,158,8,0,0,124,5,0,0,120,6,0,0,150,6,0,0,104,0,0,0,172,8,0,0,92,1,0,0,136,7,0,0,226,8,0,0,176,8,0,0,180,4,0,0,102,2,0,0,128,0,0,0,54,5,0,0,74,3,0,0,74,0,0,0,188,1,0,0,52,1,0,0,18,2,0,0,182,0,0,0,122,1,0,0,80,5,0,0,216,3,0,0,246,0,0,0,124,10,0,0,76,0,0,0,100,0,0,0,142,10,0,0,178,8,0,0,126,2,0,0,24,2,0,0,66,5,0,0,130,1,0,0,162,2,0,0,226,4,0,0,70,0,0,0,98,4,0,0,230,0,0,0,124,6,0,0,98,3,0,0,48,4,0,0,104,4,0,0,120,0,0,0,30,4,0,0,58,1,0,0,202,6,0,0,82,8,0,0,54,10,0,0,236,2,0,0,10,1,0,0,68,2,0,0,94,1,0,0,158,0,0,0,142,4,0,0,236,3,0,0,60,1,0,0,184,3,0,0,16,2,0,0,174,1,0,0,72,3,0,0,24,2,0,0,208,5,0,0,34,5,0,0,104,1,0,0,208,1,0,0,80,3,0,0,250,0,0,0,236,0,0,0,160,2,0,0,172,0,0,0,240,0,0,0,88,1,0,0,218,0,0,0,204,4,0,0,196,3,0,0,218,2,0,0,66,0,0,0,50,0,0,0,56,0,0,0,238,8,0,0,48,6,0,0,118,4,0,0,54,1,0,0,48,5,0,0,116,0,0,0,54,6,0,0,14,5,0,0,74,0,0,0,248,5,0,0,226,5,0,0,42,0,0,0,218,2,0,0,220,0,0,0,234,0,0,0,50,0,0,0,44,0,0,0,46,0,0,0,44,1,0,0,30,7,0,0,110,4,0,0,166,1,0,0,180,3,0,0,0,10,0,0,214,0,0,0,16,2,0,0,122,1,0,0,224,1,0,0,60,2,0,0,74,1,0,0,46,0,0,0,222,10,0,0,134,0,0,0,192,4,0,0,106,0,0,0,178,1,0,0,98,1,0,0,46,0,0,0,42,6,0,0,162,0,0,0,12,1,0,0,108,0,0,0,52,0,0,0,72,0,0,0,174,4,0,0,66,1,0,0,154,7,0,0,78,0,0,0,116,0,0,0,144,0,0,0,186,2,0,0,252,0,0,0,68,1,0,0,64,0,0,0,212,5,0,0,110,6,0,0,170,0,0,0,184,6,0,0,102,0,0,0,70,2,0,0,50,0,0,0,52,2,0,0,132,3,0,0,96,1,0,0,46,1,0,0,8,1,0,0,118,3,0,0,102,1,0,0,114,7,0,0,84,0,0,0,206,1,0,0,196,6,0,0,112,2,0,0,46,0,0,0,76,0,0,0,46,6,0,0,100,2,0,0,6,6,0,0,112,1,0,0,216,0,0,0,44,1,0,0,226,0,0,0,106,0,0,0,114,2,0,0,120,0,0,0,158,1,0,0,40,1,0,0,210,2,0,0,244,0,0,0,252,1,0,0,70,0,0,0,162,2,0,0,48,2,0,0,14,2,0,0,192,2,0,0,104,1,0,0,202,1,0,0,218,0,0,0,132,0,0,0,40,1,0,0,140,0,0,0,196,0,0,0,186,7,0,0,118,0,0,0,10,2,0,0,226,2,0,0,196,1,0,0,36,1,0,0,32,1,0,0,20,1,0,0,196,2,0,0,206,8,0,0,216,1,0,0,46,1,0,0,190,0,0,0,174,0,0,0,186,1,0,0,166,0,0,0,136,0,0,0,20,2,0,0,216,4,0,0,98,2,0,0,224,0,0,0,176,0,0,0,84,5,0,0,250,0,0,0,120,1,0,0,164,2,0,0,116,0,0,0,92,0,0,0,126,2,0,0,202,1,0,0,158,3,0,0,66,0,0,0,188,8,0,0,32,1,0,0,166,2,0,0,172,6,0,0,172,1,0,0,80,1,0,0,200,1,0,0,104,1,0,0,140,0,0,0,238,3,0,0,114,4,0,0,240,9,0,0,180,0,0,0,234,1,0,0,82,1,0,0,236,3,0,0,242,1,0,0,8,1,0,0,252,2,0,0,24,8,0,0,94,0,0,0,206,7,0,0,234,5,0,0,204,0,0,0,104,6,0,0,58,3,0,0,126,0,0,0,208,9,0,0,178,1,0,0,236,0,0,0,108,0,0,0,108,2,0,0,138,3,0,0,136,0,0,0,68,2,0,0,192,0,0,0,150,0,0,0,146,10,0,0,232,2,0,0,54,2,0,0,194,0,0,0,86,1,0,0,208,6,0,0,100,0,0,0,66,0,0,0,118,3,0,0,44,1,0,0,52,0,0,0,116,0,0,0,138,6,0,0,74,0,0,0,246,8,0,0,72,10,0,0,56,0,0,0,114,6,0,0,232,0,0,0,12,1,0,0,116,3,0,0,136,2,0,0,120,10,0,0,150,2,0,0,72,0,0,0,80,0,0,0,212,8,0,0,242,9,0,0,104,0,0,0,8,4,0,0,54,0,0,0,78,3,0,0,250,0,0,0,50,5,0,0,70,9,0,0,44,2,0,0,44,0,0,0,42,4,0,0,50,0,0,0,62,0,0,0,124,3,0,0,78,0,0,0,248,5,0,0,142,0,0,0,46,0,0,0,60,4,0,0,60,8,0,0,90,7,0,0,204,5,0,0,232,0,0,0,242,0,0,0,238,0,0,0,188,5,0,0,46,1,0,0,60,0,0,0,58,1,0,0,194,1,0,0,134,2,0,0,76,0,0,0,252,0,0,0,60,3,0,0,162,0,0,0,228,0,0,0,50,1,0,0,170,0,0,0,136,1,0,0,128,1,0,0,58,0,0,0,116,0,0,0,222,2,0,0,32,6,0,0,58,1,0,0,128,4,0,0,6,1,0,0,172,1,0,0,230,1,0,0,30,2,0,0,70,0,0,0,74,0,0,0,198,1,0,0,112,5,0,0,222,5,0,0,82,0,0,0,52,0,0,0,164,0,0,0,216,1,0,0,48,1,0,0,44,1,0,0,96,1,0,0,60,0,0,0,82,6,0,0,184,8,0,0,98,0,0,0,60,0,0,0,238,1,0,0,58,0,0,0,2,6,0,0,94,2,0,0,58,0,0,0,180,7,0,0,54,4,0,0,240,8,0,0,72,0,0,0,44,0,0,0,42,6,0,0,44,2,0,0,254,0,0,0,144,1,0,0,66,0,0,0,70,0,0,0,38,9,0,0,234,0,0,0,218,0,0,0,40,2,0,0,162,1,0,0,86,0,0,0,108,0,0,0,214,1,0,0,52,0,0,0,62,0,0,0,232,0,0,0,46,4,0,0,60,4,0,0,160,1,0,0,32,1,0,0,30,6,0,0,70,0,0,0,90,1,0,0,74,3,0,0,128,8,0,0,126,0,0,0,24,4,0,0,174,0,0,0,144,0,0,0,248,0,0,0,28,2,0,0,74,2,0,0,74,2,0,0,4,2,0,0,30,1,0,0,168,0,0,0,210,1,0,0,226,1,0,0,8,9,0,0,64,0,0,0,64,0,0,0,248,1,0,0,126,1,0,0,120,3,0,0,12,6,0,0,156,9,0,0,50,0,0,0,210,2,0,0,238,6,0,0,102,1,0,0,204,7,0,0,168,1,0,0,202,5,0,0,76,5,0,0,164,0,0,0,118,3,0,0,234,0,0,0,38,5,0,0,84,2,0,0,32,9,0,0,248,0,0,0,218,10,0,0,22,6,0,0,234,2,0,0,18,5,0,0,216,0,0,0,54,1,0,0,24,2,0,0,6,2,0,0,44,0,0,0,68,8,0,0,182,0,0,0,24,7,0,0,90,6,0,0,46,0,0,0,68,0,0,0,52,0,0,0,178,0,0,0,8,6,0,0,16,2,0,0,34,1,0,0,90,0,0,0,104,0,0,0,130,9,0,0,176,1,0,0,244,4,0,0,184,0,0,0,64,8,0,0,212,1,0,0,192,0,0,0,46,0,0,0,44,0,0,0,86,0,0,0,140,0,0,0,184,6,0,0,170,0,0,0,128,1,0,0,88,3,0,0,176,1,0,0,180,0,0,0,82,0,0,0,112,0,0,0,34,1,0,0,18,10,0,0,54,2,0,0,230,3,0,0,212,4,0,0,252,0,0,0,166,8,0,0,128,3,0,0,210,0,0,0,250,1,0,0,110,0,0,0,200,2,0,0,144,4,0,0,106,2,0,0,168,2,0,0,114,6,0,0,150,2,0,0,38,3,0,0,58,2,0,0,164,0,0,0,252,4,0,0,46,3,0,0,192,1,0,0,188,1,0,0,4,1,0,0,156,0,0,0,20,1,0,0,122,0,0,0,46,0,0,0,42,0,0,0,130,0,0,0,92,1,0,0,50,0,0,0,116,4,0,0,78,0,0,0,84,1,0,0,62,0,0,0,50,2,0,0,86,0,0,0,250,1,0,0,42,0,0,0,74,2,0,0,194,2,0,0,152,2,0,0,90,2,0,0,62,0,0,0,128,2,0,0,62,1,0,0,206,2,0,0,4,1,0,0,54,0,0,0,38,4,0,0,72,0,0,0,160,0,0,0,58,5,0,0,252,0,0,0,158,1,0,0,100,1,0,0,44,0,0,0,230,0,0,0,152,0,0,0,222,4,0,0,170,10,0,0,146,0,0,0,42,0,0,0,130,0,0,0,128,0,0,0,200,1,0,0,46,10,0,0,76,0,0,0,56,5,0,0,118,0,0,0,244,6,0,0,156,1,0,0,60,6,0,0,228,2,0,0,198,0,0,0,204,2,0,0,120,0,0,0,134,4,0,0,80,0,0,0,92,0,0,0,168,1,0,0,84,0,0,0,152,10,0,0,42,0,0,0,46,2,0,0,134,9,0,0,210,1,0,0,26,1,0,0,48,0,0,0,80,0,0,0,178,0,0,0,112,0,0,0,76,3,0,0,214,5,0,0,206,0,0,0,58,0,0,0,172,2,0,0,160,2,0,0,70,0,0,0,110,0,0,0,40,2,0,0,226,6,0,0,52,8,0,0,202,6,0,0,186,9,0,0,202,1,0,0,48,0,0,0,48,0,0,0,210,0,0,0,152,1,0,0,40,2,0,0,58,0,0,0,76,4,0,0,132,1,0,0,122,1,0,0,36,2,0,0,130,0,0,0,90,9,0,0,78,1,0,0,10,5,0,0,116,9,0,0,16,1,0,0,190,0,0,0,8,1,0,0,236,8,0,0,152,9,0,0,130,1,0,0,126,1,0,0,138,1,0,0,154,0,0,0,76,1,0,0,228,0,0,0,54,0,0,0,190,6,0,0,128,9,0,0,36,8,0,0,30,10,0,0,242,2,0,0,104,0,0,0,44,10,0,0,182,5,0,0,230,0,0,0,62,9,0,0,144,1,0,0,146,2,0,0,104,1,0,0,80,8,0,0,72,0,0,0,38,3,0,0,60,3,0,0,194,0,0,0,2,2,0,0,70,0,0,0,112,9,0,0,118,7,0,0,194,2,0,0,54,1,0,0,246,5,0,0,38,1,0,0,198,0,0,0,8,3,0,0,250,1,0,0,12,3,0,0,116,1,0,0,188,0,0,0,94,0,0,0,38,2,0,0,64,1,0,0,222,8,0,0,88,0,0,0,114,1,0,0,64,0,0,0,102,0,0,0,198,7,0,0,154,1,0,0,26,8,0,0,60,1,0,0,144,0,0,0,162,2,0,0,52,7,0,0,94,10,0,0,42,0,0,0,46,6,0,0,236,1,0,0,84,0,0,0,108,8,0,0,214,9,0,0,204,10,0,0,14,2,0,0,56,7,0,0,218,8,0,0,124,1,0,0,94,1,0,0,72,2,0,0,222,1,0,0,132,0,0,0,94,8,0,0,68,2,0,0,104,0,0,0,248,0,0,0,96,0,0,0,46,0,0,0,208,2,0,0,30,5,0,0,158,0,0,0,54,0,0,0,164,5,0,0,228,8,0,0,60,3,0,0,120,0,0,0,92,0,0,0,2,8,0,0,160,1,0,0,210,2,0,0,208,0,0,0,142,5,0,0,136,1,0,0,128,6,0,0,46,0,0,0,42,0,0,0,42,2,0,0,82,0,0,0,102,0,0,0,100,0,0,0,94,0,0,0,134,0,0,0,166,1,0,0,122,0,0,0,132,0,0,0,82,1,0,0,16,2,0,0,2,1,0,0,54,1,0,0,252,0,0,0,82,0,0,0,46,0,0,0,44,0,0,0,86,0,0,0,76,2,0,0,124,1,0,0,106,6,0,0,128,2,0,0,140,0,0,0,132,8,0,0,26,7,0,0,202,4,0,0,126,2,0,0,176,0,0,0,254,2,0,0,78,1,0,0,108,6,0,0,186,0,0,0,122,0,0,0,184,5,0,0,80,2,0,0,236,0,0,0,4,1,0,0,52,0,0,0,238,7,0,0,58,8,0,0,90,1,0,0,82,0,0,0,16,3,0,0,82,0,0,0,4,7,0,0,74,8,0,0,212,0,0,0,52,10,0,0,20,3,0,0,10,2,0,0,50,0,0,0,106,5,0,0,124,0,0,0,138,1,0,0,92,3,0,0,56,0,0,0,34,2,0,0,44,0,0,0,94,7,0,0,158,3,0,0,78,8,0,0,210,9,0,0,206,1,0,0,176,0,0,0,94,0,0,0,244,3,0,0,126,1,0,0,176,1,0,0,106,1,0,0,200,4,0,0,102,1,0,0,112,3,0,0,42,0,0,0,158,4,0,0,208,2,0,0,42,3,0,0,22,5,0,0,254,7,0,0,226,4,0,0,146,4,0,0,244,1,0,0,18,8,0,0,0,7,0,0,232,3,0,0,48,7,0,0,186,1,0,0,188,5,0,0,152,6,0,0,62,0,0,0,72,1,0,0,14,5,0,0,112,1,0,0,166,1,0,0,162,5,0,0,244,1,0,0,36,3,0,0,64,7,0,0,82,5,0,0,100,8,0,0,134,8,0,0,124,0,0,0,244,3,0,0,104,6,0,0,250,4,0,0,46,0,0,0,110,10,0,0,86,8,0,0,138,1,0,0,234,1,0,0,214,1,0,0,76,0,0,0,188,0,0,0,34,10,0,0,236,5,0,0,20,2,0,0,74,2,0,0,42,0,0,0,218,0,0,0,70,2,0,0,104,0,0,0,160,2,0,0,218,4,0,0,118,2,0,0,38,6,0,0,64,0,0,0,108,3,0,0,78,6,0,0,82,9,0,0,210,3,0,0,46,3,0,0,28,5,0,0,212,1,0,0,202,4,0,0,82,0,0,0,28,2,0,0,250,0,0,0,86,0,0,0,102,0,0,0,126,0,0,0,180,1,0,0,214,3,0,0,234,0,0,0,48,1,0,0,200,10,0,0,82,1,0,0,126,1,0,0,208,3,0,0,44,0,0,0,56,0,0,0,252,7,0,0,124,6,0,0,50,1,0,0,76,1,0,0,84,4,0,0,78,0,0,0,232,1,0,0,104,0,0,0,0,8,0,0,82,0,0,0,168,5,0,0,228,0,0,0,192,2,0,0,142,0,0,0,94,0,0,0,24,6,0,0,48,0,0,0,48,0,0,0,44,0,0,0,40,6,0,0,176,5,0,0,118,0,0,0,44,6,0,0,18,3,0,0,90,3,0,0,218,5,0,0,14,1,0,0,48,0,0,0,110,8,0,0,88,2,0,0,194,5,0,0,240,7,0,0,54,0,0,0,120,9,0,0,138,0,0,0,206,1,0,0,166,1,0,0,74,1,0,0,50,2,0,0,60,0,0,0,116,0,0,0,250,0,0,0,138,0,0,0,206,5,0,0,134,1,0,0,170,0,0,0,70,0,0,0,34,7,0,0,128,4,0,0,96,0,0,0,110,1,0,0,40,1,0,0,30,3,0,0,26,10,0,0,208,7,0,0,230,4,0,0,98,1,0,0,138,4,0,0,100,5,0,0,184,0,0,0,62,1,0,0,100,0,0,0,154,9,0,0,236,1,0,0,184,4,0,0,162,3,0,0,104,1,0,0,254,3,0,0,62,1,0,0,36,1,0,0,50,5,0,0,236,9,0,0,208,0,0,0,206,5,0,0,194,1,0,0,86,3,0,0,134,0,0,0,224,4,0,0,130,0,0,0,50,3,0,0,122,2,0,0,132,0,0,0,46,0,0,0,198,2,0,0,182,4,0,0,96,0,0,0,72,5,0,0,112,0,0,0,50,0,0,0,42,0,0,0,42,0,0,0,220,0,0,0,240,2,0,0,144,2,0,0,64,9,0,0,190,1,0,0,76,3,0,0,60,0,0,0,156,1,0,0,16,6,0,0,74,0,0,0,6,9,0,0,182,0,0,0,228,4,0,0,14,4,0,0,186,2,0,0,50,0,0,0,136,1,0,0,142,4,0,0,44,0,0,0,68,0,0,0,150,0,0,0,110,0,0,0,20,5,0,0,66,0,0,0,166,0,0,0,122,0,0,0,40,6,0,0,142,0,0,0,190,0,0,0,76,2,0,0,166,0,0,0,114,5,0,0,132,2,0,0,100,10,0,0,20,1,0,0,38,1,0,0,136,10,0,0,32,2,0,0,8,7,0,0,34,1,0,0,72,6,0,0,118,2,0,0,216,0,0,0,92,0,0,0,102,4,0,0,182,7,0,0,226,5,0,0,58,10,0,0,28,3,0,0,8,4,0,0,168,1,0,0,240,1,0,0,190,7,0,0,130,0,0,0,76,3,0,0,138,2,0,0,136,3,0,0,222,0,0,0,20,8,0,0,56,0,0,0,30,1,0,0,18,6,0,0,254,1,0,0,52,0,0,0,110,0,0,0,76,1,0,0,130,0,0,0,220,1,0,0,212,2,0,0,8,1,0,0,162,10,0,0,66,8,0,0,142,7,0,0,58,0,0,0,68,2,0,0,218,4,0,0,102,9,0,0,12,6,0,0,76,0,0,0,56,4,0,0,238,0,0,0,48,0,0,0,162,8,0,0,198,5,0,0,150,5,0,0,156,0,0,0,52,3,0,0,102,0,0,0,188,0,0,0,82,3,0,0,54,1,0,0,160,8,0,0,52,2,0,0,96,1,0,0,94,0,0,0,94,0,0,0,204,1,0,0,172,6,0,0,232,1,0,0,176,7,0,0,2,1,0,0,218,1,0,0,122,0,0,0,212,3,0,0,66,0,0,0,154,3,0,0,168,5,0,0,102,1,0,0,20,4,0,0,178,7,0,0,218,0,0,0,22,8,0,0,248,0,0,0,162,4,0,0,182,3,0,0,146,8,0,0,134,5,0,0,70,0,0,0,58,0,0,0,114,0,0,0,226,0,0,0,50,0,0,0,86,0,0,0,198,10,0,0,240,1,0,0,174,1,0,0,22,10,0,0,232,0,0,0,76,0,0,0,150,0,0,0,212,0,0,0,174,0,0,0,50,6,0,0,126,0,0,0,84,5,0,0,8,1,0,0,228,1,0,0,180,3,0,0,108,0,0,0,80,0,0,0,58,0,0,0,42,0,0,0,42,0,0,0,8,6,0,0,30,3,0,0,74,0,0,0,18,2,0,0,58,0,0,0,98,2,0,0,96,1,0,0,42,0,0,0,42,0,0,0,120,2,0,0,176,3,0,0,148,0,0,0,210,3,0,0,170,4,0,0,96,0,0,0,118,0,0,0,174,1,0,0,68,1,0,0,246,1,0,0,70,7,0,0,148,0,0,0,34,9,0,0,156,1,0,0,188,6,0,0].concat([200,2,0,0,98,0,0,0,26,2,0,0,98,0,0,0,222,0,0,0,172,3,0,0,196,7,0,0,104,9,0,0,240,4,0,0,152,1,0,0,70,2,0,0,156,1,0,0,242,0,0,0,14,6,0,0,178,0,0,0,30,2,0,0,160,0,0,0,86,1,0,0,104,3,0,0,214,0,0,0,74,6,0,0,140,1,0,0,52,0,0,0,44,0,0,0,240,0,0,0,66,1,0,0,232,6,0,0,62,0,0,0,100,2,0,0,238,0,0,0,44,0,0,0,80,4,0,0,168,3,0,0,198,4,0,0,56,2,0,0,114,0,0,0,240,1,0,0,196,10,0,0,2,10,0,0,160,5,0,0,146,0,0,0,22,7,0,0,188,3,0,0,134,3,0,0,64,0,0,0,160,0,0,0,72,1,0,0,150,5,0,0,168,2,0,0,232,0,0,0,164,10,0,0,6,2,0,0,98,5,0,0,226,2,0,0,114,0,0,0,96,4,0,0,156,6,0,0,230,0,0,0,136,1,0,0,150,0,0,0,250,4,0,0,238,4,0,0,96,1,0,0,180,1,0,0,54,4,0,0,48,0,0,0,42,0,0,0,28,2,0,0,108,0,0,0,42,2,0,0,254,0,0,0,58,3,0,0,24,3,0,0,214,0,0,0,90,10,0,0,6,4,0,0,224,6,0,0,78,1,0,0,208,0,0,0,70,1,0,0,68,6,0,0,200,8,0,0,102,0,0,0,86,3,0,0,140,1,0,0,92,0,0,0,66,0,0,0,244,2,0,0,244,5,0,0,36,1,0,0,246,6,0,0,182,2,0,0,90,1,0,0,10,2,0,0,144,4,0,0,194,0,0,0,64,10,0,0,158,2,0,0,126,0,0,0,108,9,0,0,92,0,0,0,164,0,0,0,226,1,0,0,162,1,0,0,50,0,0,0,78,7,0,0,230,6,0,0,64,2,0,0,232,0,0,0,60,2,0,0,196,3,0,0,44,2,0,0,118,0,0,0,138,0,0,0,118,1,0,0,254,5,0,0,236,1,0,0,120,3,0,0,110,6,0,0,102,0,0,0,102,1,0,0,56,1,0,0,48,2,0,0,64,0,0,0,22,2,0,0,110,1,0,0,16,1,0,0,74,5,0,0,100,0,0,0,26,9,0,0,254,9,0,0,208,5,0,0,140,1,0,0,48,3,0,0,64,0,0,0,22,1,0,0,2,9,0,0,88,8,0,0,14,2,0,0,94,3,0,0,154,5,0,0,34,2,0,0,158,1,0,0,204,4,0,0,220,0,0,0,234,0,0,0,134,0,0,0,46,0,0,0,136,9,0,0,200,1,0,0,68,3,0,0,176,6,0,0,178,2,0,0,84,2,0,0,48,1,0,0,54,2,0,0,104,7,0,0,166,2,0,0,136,0,0,0,186,5,0,0,142,0,0,0,144,2,0,0,94,0,0,0,138,0,0,0,86,5,0,0,88,6,0,0,10,3,0,0,176,4,0,0,152,3,0,0,122,6,0,0,62,5,0,0,116,2,0,0,246,5,0,0,160,0,0,0,102,5,0,0,178,1,0,0,186,6,0,0,234,1,0,0,80,2,0,0,220,0,0,0,58,4,0,0,10,6,0,0,200,7,0,0,210,1,0,0,42,0,0,0,150,1,0,0,230,0,0,0,108,10,0,0,158,1,0,0,130,4,0,0,128,6,0,0,174,9,0,0,184,0,0,0,8,8,0,0,166,3,0,0,24,1,0,0,80,0,0,0,54,3,0,0,140,8,0,0,154,10,0,0,16,8,0,0,254,2,0,0,74,1,0,0,204,0,0,0,194,3,0,0,2,4,0,0,24,2,0,0,64,0,0,0,134,0,0,0,22,1,0,0,136,2,0,0,56,0,0,0,76,6,0,0,32,7,0,0,154,3,0,0,30,2,0,0,144,0,0,0,154,1,0,0,66,7,0,0,126,10,0,0,98,0,0,0,148,1,0,0,168,0,0,0,32,8,0,0,82,0,0,0,82,2,0,0,180,0,0,0,70,0,0,0,138,0,0,0,170,2,0,0,194,0,0,0,148,4,0,0,58,6,0,0,116,4,0,0,118,10,0,0,252,5,0,0,198,5,0,0,152,0,0,0,46,0,0,0,74,10,0,0,14,9,0,0,4,8,0,0,178,10,0,0,212,0,0,0,76,1,0,0,44,7,0,0,188,7,0,0,54,0,0,0,138,0,0,0,8,2,0,0,236,1,0,0,106,1,0,0,8,3,0,0,218,5,0,0,130,1,0,0,96,0,0,0,46,0,0,0,254,1,0,0,136,5,0,0,178,5,0,0,146,4,0,0,56,0,0,0,48,9,0,0,44,0,0,0,184,3,0,0,178,5,0,0,42,0,0,0,42,0,0,0,148,7,0,0,244,1,0,0,94,0,0,0,100,0,0,0,244,2,0,0,232,4,0,0,110,1,0,0,136,6,0,0,136,5,0,0,180,0,0,0,212,1,0,0,52,0,0,0,10,1,0,0,184,2,0,0,174,2,0,0,22,1,0,0,142,6,0,0,70,3,0,0,146,7,0,0,176,1,0,0,58,4,0,0,134,0,0,0,160,1,0,0,46,1,0,0,114,3,0,0,74,1,0,0,92,0,0,0,200,9,0,0,214,4,0,0,212,2,0,0,104,3,0,0,124,1,0,0,56,2,0,0,48,1,0,0,44,0,0,0,48,0,0,0,76,5,0,0,84,1,0,0,42,0,0,0,52,0,0,0,112,7,0,0,12,3,0,0,64,0,0,0,102,0,0,0,66,2,0,0,166,5,0,0,116,5,0,0,46,1,0,0,248,0,0,0,90,0,0,0,116,6,0,0,108,0,0,0,98,4,0,0,200,2,0,0,132,0,0,0,108,2,0,0,56,0,0,0,26,3,0,0,206,3,0,0,172,2,0,0,150,9,0,0,134,0,0,0,78,10,0,0,122,1,0,0,50,2,0,0,116,5,0,0,120,5,0,0,52,2,0,0,162,6,0,0,168,6,0,0,180,5,0,0,78,0,0,0,36,1,0,0,70,0,0,0,104,3,0,0,56,1,0,0,162,1,0,0,106,0,0,0,62,3,0,0,94,0,0,0,144,1,0,0,224,3,0,0,196,0,0,0,64,1,0,0,154,2,0,0,160,0,0,0,74,0,0,0,220,5,0,0,26,1,0,0,146,2,0,0,232,7,0,0,190,0,0,0,124,2,0,0,248,1,0,0,84,0,0,0,180,1,0,0,162,1,0,0,156,2,0,0,214,0,0,0,96,2,0,0,44,0,0,0,44,0,0,0,44,0,0,0,108,1,0,0,210,0,0,0,226,3,0,0,58,0,0,0,66,3,0,0,0,1,0,0,186,6,0,0,136,1,0,0,198,9,0,0,206,3,0,0,222,2,0,0,18,1,0,0,16,7,0,0,96,6,0,0,62,4,0,0,48,1,0,0,146,1,0,0,26,2,0,0,148,0,0,0,228,1,0,0,132,1,0,0,172,3,0,0,198,1,0,0,246,3,0,0,42,1,0,0,188,2,0,0,10,6,0,0,228,5,0,0,138,9,0,0,82,0,0,0,120,6,0,0,60,2,0,0,86,3,0,0,116,1,0,0,78,4,0,0,118,0,0,0,164,1,0,0,36,1,0,0,64,5,0,0,212,10,0,0,132,3,0,0,198,2,0,0,148,9,0,0,64,2,0,0,60,0,0,0,52,9,0,0,218,1,0,0,2,1,0,0,92,0,0,0,60,0,0,0,142,3,0,0,182,0,0,0,164,0,0,0,184,10,0,0,192,8,0,0,92,9,0,0,14,1,0,0,202,0,0,0,122,0,0,0,4,6,0,0,246,0,0,0,70,5,0,0,42,9,0,0,64,6,0,0,244,3,0,0,4,5,0,0,152,6,0,0,62,1,0,0,222,1,0,0,86,2,0,0,190,10,0,0,78,0,0,0,144,7,0,0,42,7,0,0,234,0,0,0,74,6,0,0,24,10,0,0,254,0,0,0,180,2,0,0,12,1,0,0,244,1,0,0,136,1,0,0,48,0,0,0,188,0,0,0,6,3,0,0,8,3,0,0,84,0,0,0,140,0,0,0,120,2,0,0,242,4,0,0,162,6,0,0,70,3,0,0,16,3,0,0,206,0,0,0,132,0,0,0,66,0,0,0,30,4,0,0,54,0,0,0,116,0,0,0,128,7,0,0,232,4,0,0,234,0,0,0,128,0,0,0,62,1,0,0,34,3,0,0,60,2,0,0,100,0,0,0,92,0,0,0,170,6,0,0,166,4,0,0,194,7,0,0,134,10,0,0,104,5,0,0,94,0,0,0,192,6,0,0,118,5,0,0,222,1,0,0,232,8,0,0,136,2,0,0,18,2,0,0,146,0,0,0,52,0,0,0,40,9,0,0,104,2,0,0,94,9,0,0,134,1,0,0,206,0,0,0,24,3,0,0,242,2,0,0,240,0,0,0,234,2,0,0,72,4,0,0,16,2,0,0,218,2,0,0,28,1,0,0,220,1,0,0,184,0,0,0,16,1,0,0,226,0,0,0,40,3,0,0,12,2,0,0,122,2,0,0,56,3,0,0,170,1,0,0,84,7,0,0,6,1,0,0,246,2,0,0,122,0,0,0,200,0,0,0,238,2,0,0,246,0,0,0,160,4,0,0,42,0,0,0,92,1,0,0,228,9,0,0,12,2,0,0,182,0,0,0,204,0,0,0,240,2,0,0,70,2,0,0,98,1,0,0,22,3,0,0,240,1,0,0,108,4,0,0,64,2,0,0,2,3,0,0,162,3,0,0,164,0,0,0,28,1,0,0,38,2,0,0,216,0,0,0,50,2,0,0,170,1,0,0,68,0,0,0,100,2,0,0,58,0,0,0,44,0,0,0,4,3,0,0,116,1,0,0,248,0,0,0,148,1,0,0,92,0,0,0,50,0,0,0,204,3,0,0,136,0,0,0,154,0,0,0,26,3,0,0,4,1,0,0,62,2,0,0,176,1,0,0,130,0,0,0,2,1,0,0,130,5,0,0,168,0,0,0,190,1,0,0,38,1,0,0,140,0,0,0,234,1,0,0,216,3,0,0,20,2,0,0,130,1,0,0,118,4,0,0,234,1,0,0,130,0,0,0,242,5,0,0,194,2,0,0,168,0,0,0,108,1,0,0,124,3,0,0,60,0,0,0,200,1,0,0,130,1,0,0,132,1,0,0,68,4,0,0,24,1,0,0,46,0,0,0,80,1,0,0,156,1,0,0,122,1,0,0,6,3,0,0,176,2,0,0,92,2,0,0,12,1,0,0,140,0,0,0,62,1,0,0,174,1,0,0,96,0,0,0,78,2,0,0,12,9,0,0,204,3,0,0,114,2,0,0,52,6,0,0,10,1,0,0,222,5,0,0,202,7,0,0,38,5,0,0,240,6,0,0,120,0,0,0,56,0,0,0,64,0,0,0,42,0,0,0,126,3,0,0,84,3,0,0,126,0,0,0,70,4,0,0,40,3,0,0,52,1,0,0,170,5,0,0,150,8,0,0,48,3,0,0,124,1,0,0,14,3,0,0,126,8,0,0,16,3,0,0,220,0,0,0,112,10,0,0,242,1,0,0,32,4,0,0,54,3,0,0,162,1,0,0,54,0,0,0,220,2,0,0,230,7,0,0,46,0,0,0,106,2,0,0,214,1,0,0,124,0,0,0,142,0,0,0,154,1,0,0,26,2,0,0,90,0,0,0,96,0,0,0,42,0,0,0,48,10,0,0,72,8,0,0,52,3,0,0,232,1,0,0,248,3,0,0,246,7,0,0,38,10,0,0,90,1,0,0,30,2,0,0,112,2,0,0,70,6,0,0,128,0,0,0,84,10,0,0,56,6,0,0,78,9,0,0,178,6,0,0,0,2,0,0,118,6,0,0,62,2,0,0,2,4,0,0,120,1,0,0,196,0,0,0,226,2,0,0,88,3,0,0,36,7,0,0,88,2,0,0,72,0,0,0,86,0,0,0,64,4,0,0,92,4,0,0,32,5,0,0,100,1,0,0,94,6,0,0,84,9,0,0,18,7,0,0,154,6,0,0,190,1,0,0,188,1,0,0,108,0,0,0,152,4,0,0,176,4,0,0,64,3,0,0,142,0,0,0,36,2,0,0,180,9,0,0,40,8,0,0,202,0,0,0,236,2,0,0,38,1,0,0,72,4,0,0,46,0,0,0,50,0,0,0,96,4,0,0,212,0,0,0,184,0,0,0,4,2,0,0,76,9,0,0,144,5,0,0,170,6,0,0,94,0,0,0,72,2,0,0,62,0,0,0,160,10,0,0,50,0,0,0,54,0,0,0,182,1,0,0,188,4,0,0,130,2,0,0,70,8,0,0,92,1,0,0,64,0,0,0,50,0,0,0,246,9,0,0,152,1,0,0,134,1,0,0,124,5,0,0,72,0,0,0,90,2,0,0,64,0,0,0,246,2,0,0,46,8,0,0,110,0,0,0,102,0,0,0,114,4,0,0,30,1,0,0,120,0,0,0,60,9,0,0,74,0,0,0,202,3,0,0,160,5,0,0,48,2,0,0,118,8,0,0,182,6,0,0,216,0,0,0,104,10,0,0,252,4,0,0,50,2,0,0,190,2,0,0,224,5,0,0,160,7,0,0,176,5,0,0,22,4,0,0,92,0,0,0,24,2,0,0,52,0,0,0,138,6,0,0,40,2,0,0,6,1,0,0,214,7,0,0,76,1,0,0,48,0,0,0,88,1,0,0,212,2,0,0,210,5,0,0,74,0,0,0,54,2,0,0,254,1,0,0,126,0,0,0,56,9,0,0,150,1,0,0,198,1,0,0,114,3,0,0,0,1,0,0,116,8,0,0,150,10,0,0,70,10,0,0,46,2,0,0,234,1,0,0,66,4,0,0,182,8,0,0,254,5,0,0,194,1,0,0,164,3,0,0,140,5,0,0,6,1,0,0,206,2,0,0,186,1,0,0,68,0,0,0,146,3,0,0,190,4,0,0,156,7,0,0,212,6,0,0,18,1,0,0,78,0,0,0,0,4,0,0,84,8,0,0,174,1,0,0,176,10,0,0,178,0,0,0,18,3,0,0,20,1,0,0,200,3,0,0,102,0,0,0,150,1,0,0,78,0,0,0,56,2,0,0,212,7,0,0,22,2,0,0,92,0,0,0,112,2,0,0,178,9,0,0,194,8,0,0,184,5,0,0,208,4,0,0,130,2,0,0,152,3,0,0,12,4,0,0,86,0,0,0,244,4,0,0,34,6,0,0,230,5,0,0,190,9,0,0,222,0,0,0,142,2,0,0,46,0,0,0,90,1,0,0,68,0,0,0,244,9,0,0,68,0,0,0,246,4,0,0,116,7,0,0,202,10,0,0,220,3,0,0,88,5,0,0,66,6,0,0,222,1,0,0,176,0,0,0,24,6,0,0,218,0,0,0,154,8,0,0,184,4,0,0,136,3,0,0,186,1,0,0,170,2,0,0,44,0,0,0,140,1,0,0,42,0,0,0,124,2,0,0,188,0,0,0,106,0,0,0,70,0,0,0,166,5,0,0,212,4,0,0,6,2,0,0,74,2,0,0,72,0,0,0,184,2,0,0,48,0,0,0,130,7,0,0,78,6,0,0,96,2,0,0,72,9,0,0,248,2,0,0,48,0,0,0,60,0,0,0,74,0,0,0,166,2,0,0,134,2,0,0,4,1,0,0,222,4,0,0,46,0,0,0,164,1,0,0,122,3,0,0,78,0,0,0,108,1,0,0,246,1,0,0,182,9,0,0,134,0,0,0,244,5,0,0,118,6,0,0,190,3,0,0,146,2,0,0,224,7,0,0,156,6,0,0,76,1,0,0,82,4,0,0,76,0,0,0,144,3,0,0,156,1,0,0,194,0,0,0,208,1,0,0,66,1,0,0,144,5,0,0,138,5,0,0,160,1,0,0,8,2,0,0,220,1,0,0,216,0,0,0,194,1,0,0,56,0,0,0,216,5,0,0,48,0,0,0,44,0,0,0,242,5,0,0,184,2,0,0,48,0,0,0,176,3,0,0,130,8,0,0,200,0,0,0,66,0,0,0,74,0,0,0,194,0,0,0,6,3,0,0,122,4,0,0,214,8,0,0,82,0,0,0,52,0,0,0,198,6,0,0,194,0,0,0,180,5,0,0,204,6,0,0,164,1,0,0,196,2,0,0,196,1,0,0,72,6,0,0,124,3,0,0,92,6,0,0,236,4,0,0,60,0,0,0,48,0,0,0,52,0,0,0,88,10,0,0,54,0,0,0,244,8,0,0,46,0,0,0,134,7,0,0,220,8,0,0,10,2,0,0,134,3,0,0,248,8,0,0,180,2,0,0,156,3,0,0,168,2,0,0,208,3,0,0,62,2,0,0,248,1,0,0,20,1,0,0,18,3,0,0,242,6,0,0,198,1,0,0,134,1,0,0,48,0,0,0,56,0,0,0,200,5,0,0,70,1,0,0,214,2,0,0,182,4,0,0,88,0,0,0,14,8,0,0,136,0,0,0,50,0,0,0,130,3,0,0,94,3,0,0,160,6,0,0,0,1,0,0,52,2,0,0,146,0,0,0,114,1,0,0,110,0,0,0,34,8,0,0,52,0,0,0,46,0,0,0,238,9,0,0,62,5,0,0,132,1,0,0,114,0,0,0,44,0,0,0,146,1,0,0,106,4,0,0,42,0,0,0,186,10,0,0,92,1,0,0,56,1,0,0,216,2,0,0,118,1,0,0,190,0,0,0,150,1,0,0,154,0,0,0,150,0,0,0,212,3,0,0,22,2,0,0,214,0,0,0,4,2,0,0,226,2,0,0,118,0,0,0,68,0,0,0,136,4,0,0,222,3,0,0,84,2,0,0,54,0,0,0,72,0,0,0,248,9,0,0,204,0,0,0,176,0,0,0,78,3,0,0,4,2,0,0,92,0,0,0,154,0,0,0,206,1,0,0,120,8,0,0,8,1,0,0,20,5,0,0,124,2,0,0,56,2,0,0,242,1,0,0,222,6,0,0,142,0,0,0,216,2,0,0,76,6,0,0,166,0,0,0,106,1,0,0,214,0,0,0,152,8,0,0,90,0,0,0,168,8,0,0,110,7,0,0,158,9,0,0,224,3,0,0,34,1,0,0,198,1,0,0,84,0,0,0,62,0,0,0,44,1,0,0,212,0,0,0,180,6,0,0,68,0,0,0,138,7,0,0,142,2,0,0,2,7,0,0,188,1,0,0,126,0,0,0,32,1,0,0,188,0,0,0,202,9,0,0,42,1,0,0,30,9,0,0,2,2,0,0,24,1,0,0,84,0,0,0,96,0,0,0,84,6,0,0,6,2,0,0,254,6,0,0,62,0,0,0,100,6,0,0,80,6,0,0,56,0,0,0,98,8,0,0,128,5,0,0,176,1,0,0,92,1,0,0,252,0,0,0,68,1,0,0,236,0,0,0,242,0,0,0,20,6,0,0,96,1,0,0,250,0,0,0,116,1,0,0,194,9,0,0,44,0,0,0,220,1,0,0,168,0,0,0,42,0,0,0,88,2,0,0,122,9,0,0,6,7,0,0,48,0,0,0,28,4,0,0,96,9,0,0,42,0,0,0,168,0,0,0,100,3,0,0,98,0,0,0,232,5,0,0,200,0,0,0,242,0,0,0,62,8,0,0,50,0,0,0,152,0,0,0,166,10,0,0,32,5,0,0,190,2,0,0,60,1,0,0,60,5,0,0,196,5,0,0,248,1,0,0,150,7,0,0,136,1,0,0,24,1,0,0,182,6,0,0,46,2,0,0,172,0,0,0,134,0,0,0,60,0,0,0,34,2,0,0,60,10,0,0,42,0,0,0,74,9,0,0,190,8,0,0,94,1,0,0,210,0,0,0,212,0,0,0,80,3,0,0,122,5,0,0,142,8,0,0,196,2,0,0,10,4,0,0,82,2,0,0,104,8,0,0,104,0,0,0,252,1,0,0,16,1,0,0,32,1,0,0,72,0,0,0,156,5,0,0,92,8,0,0,182,1,0,0,166,6,0,0,192,1,0,0,114,0,0,0,118,0,0,0,164,2,0,0,64,0,0,0,142,1,0,0,60,1,0,0,82,1,0,0,62,0,0,0,128,10,0,0,80,0,0,0,68,7,0,0,122,0,0,0,10,5,0,0,198,0,0,0,42,0,0,0,132,0,0,0,62,0,0,0,44,0,0,0,52,0,0,0,54,0,0,0,46,0,0,0,42,0,0,0,42,0,0,0,62,0,0,0,66,1,0,0,90,0,0,0,80,1,0,0,60,1,0,0,64,1,0,0,210,2,0,0,96,0,0,0,66,3,0,0,202,1,0,0,18,3,0,0,4,1,0,0,244,2,0,0,132,2,0,0,92,0,0,0,110,0,0,0,236,2,0,0,14,1,0,0,196,6,0,0,80,9,0,0,178,0,0,0,82,6,0,0,198,0,0,0,88,0,0,0,94,2,0,0,54,0,0,0,140,10,0,0,248,2,0,0,78,0,0,0,240,5,0,0,228,1,0,0,214,0,0,0,162,0,0,0,172,1,0,0,56,2,0,0,190,0,0,0,88,0,0,0,74,5,0,0,164,1,0,0,48,0,0,0,248,1,0,0,192,7,0,0,28,1,0,0,88,1,0,0,110,1,0,0,36,9,0,0,182,2,0,0,0,2,0,0,24,1,0,0,230,1,0,0,34,1,0,0,196,9,0,0,144,0,0,0,166,0,0,0,0,3,0,0,30,1,0,0,78,0,0,0,66,9,0,0,64,2,0,0,196,1,0,0,118,0,0,0,0,3,0,0,206,6,0,0,110,1,0,0,76,0,0,0,224,2,0,0,146,0,0,0,44,0,0,0,44,1,0,0,150,0,0,0,8,1,0,0,168,6,0,0,124,7,0,0,116,10,0,0,252,3,0,0,42,2,0,0,228,7,0,0,58,5,0,0,228,4,0,0,180,0,0,0,88,1,0,0,226,1,0,0,18,2,0,0,54,1,0,0,198,8,0,0,250,3,0,0,138,1,0,0,24,5,0,0,32,2,0,0,106,1,0,0,22,1,0,0,36,5,0,0,164,1,0,0,58,1,0,0,70,0,0,0,52,0,0,0,250,3,0,0,166,6,0,0,42,1,0,0,138,8,0,0,92,10,0,0,198,2,0,0,130,6,0,0,66,0,0,0,176,9,0,0,46,3,0,0,140,2,0,0,70,4,0,0,32,1,0,0,254,4,0,0,152,1,0,0,96,3,0,0,6,4,0,0,134,2,0,0,46,0,0,0,154,4,0,0,146,0,0,0,126,0,0,0,206,10,0,0,198,1,0,0,196,1,0,0,0,2,0,0,158,10,0,0,204,0,0,0,10,8,0,0,138,0,0,0,96,8,0,0,148,6,0,0,102,7,0,0,132,0,0,0,158,2,0,0,192,0,0,0,28,9,0,0,98,1,0,0,224,2,0,0,10,10,0,0,198,4,0,0,54,8,0,0,144,2,0,0,48,2,0,0,56,0,0,0,140,2,0,0,226,3,0,0,66,5,0,0,116,2,0,0,30,3,0,0,152,1,0,0,206,6,0,0,84,1,0,0,58,0,0,0,70,0,0,0,178,1,0,0,86,4,0,0,26,2,0,0,228,3,0,0,24,3,0,0,58,3,0,0,154,4,0,0,204,2,0,0,6,4,0,0,70,1,0,0,34,2,0,0,44,0,0,0,72,0,0,0,14,1,0,0,234,2,0,0,130,2,0,0,150,1,0,0,74,2,0,0,236,1,0,0,14,3,0,0,150,1,0,0,80,6,0,0,4,10,0,0,16,10,0,0,186,3,0,0,212,1,0,0,42,0,0,0,204,2,0,0,224,1,0,0,8,2,0,0,20,7,0,0,232,9,0,0,210,10,0,0,42,0,0,0,74,1,0,0,68,0,0,0,162,1,0,0,70,1,0,0,2,1,0,0,62,0,0,0,60,0,0,0,54,0,0,0,40,4,0,0,86,0,0,0,176,1,0,0,60,0,0,0,10,1,0,0,172,0,0,0,84,0,0,0,52,0,0,0,98,1,0,0,44,0,0,0,108,2,0,0,194,1,0,0,86,2,0,0,190,0,0,0,12,1,0,0,8,2,0,0,144,1,0,0,178,1,0,0,12,1,0,0,190,4,0,0,42,0,0,0,68,0,0,0,66,0,0,0,186,8,0,0,140,1,0,0,172,5,0,0,152,0,0,0,48,0,0,0,172,7,0,0,16,5,0,0,248,4,0,0,88,2,0,0,46,1,0,0,38,6,0,0,164,8,0,0,74,4,0,0,54,0,0,0,76,2,0,0,4,3,0,0,60,2,0,0,118,1,0,0,190,1,0,0,50,0,0,0,30,1,0,0,182,10,0,0,192,2,0,0,72,3,0,0,228,0,0,0,76,0,0,0,244,0,0,0,148,3,0,0,42,0,0,0,224,1,0,0,234,9,0,0,68,3,0,0,168,2,0,0,70,2,0,0,8,4,0,0,114,0,0,0,228,2,0,0,76,1,0,0,246,1,0,0,42,0,0,0,106,7,0,0,150,3,0,0,192,1,0,0,236,3,0,0,238,0,0,0,110,0,0,0,170,3,0,0,152,1,0,0,88,0,0,0,124,0,0,0,216,9,0,0,130,0,0,0,48,3,0,0,136,0,0,0,192,0,0,0,132,1,0,0,128,0,0,0,224,1,0,0,2,2,0,0,6,1,0,0,228,2,0,0,112,0,0,0,190,6,0,0,18,4,0,0,118,0,0,0,84,0,0,0,90,5,0,0,246,2,0,0,124,4,0,0,80,1,0,0,34,3,0,0,188,1,0,0,100,5,0,0,188,0,0,0,114,1,0,0,54,0,0,0,68,0,0,0,186,1,0,0,100,0,0,0,156,1,0,0,0,0,0,0,10,215,163,60,0,0,0,0,99,111,110,118,101,120,83,119,101,101,112,84,101,115,116,0,67,67,68,32,109,111,116,105,111,110,32,99,108,97,109,112,105,110,103,0,0,0,0,0,82,111,111,116,0,0,0,0,46,46,47,46,46,47,115,114,99,47,66,117,108,108,101,116,67,111,108,108,105,115,105,111,110,47,78,97,114,114,111,119,80,104,97,115,101,67,111,108,108,105,115,105,111,110,47,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,116,97,99,116,67,108,105,112,112,105,110,103,46,99,112,112,0,0,99,111,110,118,101,120,83,119,101,101,112,67,111,109,112,111,117,110,100,0,0,0,0,0,85,110,105,102,111,114,109,83,99,97,108,105,110,103,83,104,97,112,101,0,0,0,0,0,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,0,105,110,116,101,103,114,97,116,101,84,114,97,110,115,102,111,114,109,115,0,0,0,0,0,98,116,73,110,116,73,110,100,101,120,68,97,116,97,0,0,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,68,97,116,97,0,0,100,105,115,112,97,116,99,104,65,108,108,67,111,108,108,105,115,105,111,110,80,97,105,114,115,0,0,0,0,0,0,0,105,115,108,97,110,100,85,110,105,111,110,70,105,110,100,65,110,100,81,117,105,99,107,83,111,114,116,0,0,0,0,0,98,116,83,99,97,108,101,100,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,0,0,99,97,108,99,117,108,97,116,101,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,115,0,0,0,0,0,0,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,68,97,116,97,0,0,0,0,0,98,116,79,112,116,105,109,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,99,97,108,99,117,108,97,116,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,0,0,0,0,0,0,0,98,116,80,111,115,105,116,105,111,110,65,110,100,82,97,100,105,117,115,0,0,0,0,0,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,0,0,0,0,0,0,0,0,72,69,73,71,72,84,70,73,69,76,68,0,0,0,0,0,69,109,112,116,121,0,0,0,98,116,77,101,115,104,80,97,114,116,68,97,116,97,0,0,112,101,114,102,111,114,109,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,105,111,110,0,0,0,0,0,0,0,67,121,108,105,110,100,101,114,90,0,0,0,0,0,0,0,117,112,100,97,116,101,65,99,116,105,118,97,116,105,111,110,83,116,97,116,101,0,0,0,98,116,86,101,99,116,111,114,51,68,111,117,98,108,101,68,97,116,97,0,0,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,67,104,105,108,100,68,97,116,97,0,0,0,0,0,0,0,0,67,121,108,105,110,100,101,114,89,0,0,0,0,0,0,0,117,112,100,97,116,101,65,97,98,98,115,0,0,0,0,0,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,79,118,101,114,102,108,111,119,32,105,110,32,65,65,66,66,44,32,111,98,106,101,99,116,32,114,101,109,111,118,101,100,32,102,114,111,109,32,115,105,109,117,108,97,116,105,111,110,0,0,0,0,0,0,0,0,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,68,97,116,97,0,0,0,0,117,112,100,97,116,101,65,99,116,105,111,110,115,0,0,0,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,86,101,99,116,111,114,51,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,70,108,111,97,116,68,97,116,97,0,67,97,112,115,117,108,101,88,0,0,0,0,0,0,0,0,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,68,97,116,97,0,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,0,84,104,97,110,107,115,46,10,0,0,0,0,0,0,0,0,115,116,100,58,58,98,97,100,95,97,108,108,111,99,0,0,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,105,110,116,101,114,110,97,108,83,105,110,103,108,101,83,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,0,0,100,49,62,61,48,46,48,102,0,0,0,0,0,0,0,0,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,83,101,116,117,112,0,0,0,0,98,116,67,104,97,114,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,100,101,98,117,103,68,114,97,119,87,111,114,108,100,0,0,98,116,66,118,104,83,117,98,116,114,101,101,73,110,102,111,68,97,116,97,0,0,0,0,77,117,108,116,105,83,112,104,101,114,101,0,0,0,0,0,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,68,97,116,97,0,0,0,0,0,67,111,110,118,101,120,0,0,67,111,109,112,111,117,110,100,0,0,0,0,0,0,0,0,80,108,101,97,115,101,32,105,110,99,108,117,100,101,32,97,98,111,118,101,32,105,110,102,111,114,109,97,116,105,111,110,44,32,121,111,117,114,32,80,108,97,116,102,111,114,109,44,32,118,101,114,115,105,111,110,32,111,102,32,79,83,46,10,0,0,0,0,0,0,0,0,116,111,105,32,61,32,37,102,10,0,0,0,0,0,0,0,98,116,82,105,103,105,100,66,111,100,121,70,108,111,97,116,68,97,116,97,0,0,0,0,98,116,67,97,112,115,117,108,101,83,104,97,112,101,68,97,116,97,0,0,0,0,0,0,115,111,108,118,101,71,114,111,117,112,0,0,0,0,0,0,115,116,101,112,83,105,109,117,108,97,116,105,111,110,0,0,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,0,0,100,48,62,61,48,46,48,102,0,0,0,0,0,0,0,0,98,116,66,85,95,83,105,109,112,108,101,120,49,116,111,52,0,0,0,0,0,0,0,0,98,116,83,104,111,114,116,73,110,116,73,110,100,101,120,84,114,105,112,108,101,116,68,97,116,97,0,0,0,0,0,0,83,84,65,84,73,67,80,76,65,78,69,0,0,0,0,0,83,80,72,69,82,69,0,0,112,114,111,99,101,115,115,73,115,108,97,110,100,115,0,0,83,67,65,76,69,68,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,0,0,84,114,105,97,110,103,108,101,0,0,0,0,0,0,0,0,98,116,81,117,97,110,116,105,122,101,100,66,118,104,78,111,100,101,68,97,116,97,0,0,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,70,108,111,97,116,68,97,116,97,0,0,0,0,0,0,98,116,77,117,108,116,105,83,112,104,101,114,101,83,104,97,112,101,68,97,116,97,0,0,67,121,108,105,110,100,101,114,88,0,0,0,0,0,0,0,67,111,110,118,101,120,84,114,105,109,101,115,104,0,0,0,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,68,97,116,97,0,0,0,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,67,111,110,101,0,0,0,0,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,68,97,116,97,0,0,0,0,0,73,102,32,121,111,117,32,99,97,110,32,114,101,112,114,111,100,117,99,101,32,116,104,105,115,44,32,112,108,101,97,115,101,32,101,109,97,105,108,32,98,117,103,115,64,99,111,110,116,105,110,117,111,117,115,112,104,121,115,105,99,115,46,99,111,109,10,0,0,0,0,0,67,97,112,115,117,108,101,90,0,0,0,0,0,0,0,0,66,86,72,84,82,73,65,78,71,76,69,77,69,83,72,0,66,111,120,0,0,0,0,0,115,121,110,99,104,114,111,110,105,122,101,77,111,116,105,111,110,83,116,97,116,101,115,0,115,111,108,118,101,71,114,111,117,112,67,97,99,104,101,70,114,105,101,110,100,108,121,73,116,101,114,97,116,105,111,110,115,0,0,0,0,0,0,0,112,114,101,100,105,99,116,85,110,99,111,110,115,116,114,97,105,110,116,77,111,116,105,111,110,0,0,0,0,0,0,0,115,101,97,114,99,104,32,115,112,101,99,117,108,97,116,105,118,101,32,99,111,110,116,97,99,116,115,0,0,0,0,0,97,100,100,83,112,101,99,117,108,97,116,105,118,101,67,111,110,116,97,99,116,115,0,0,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,68,97,116,97,0,0,0,0,0,0,0,98,111,111,108,32,84,101,115,116,83,101,112,65,120,105,115,40,99,111,110,115,116,32,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,32,38,44,32,99,111,110,115,116,32,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,32,38,44,32,99,111,110,115,116,32,98,116,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,116,84,114,97,110,115,102,111,114,109,32,38,44,32,99,111,110,115,116,32,98,116,86,101,99,116,111,114,51,32,38,44,32,102,108,111,97,116,32,38,41,0,0,0,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,208,132,0,0,120,0,0,0,2,4,0,0,72,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,132,0,0,196,1,0,0,228,3,0,0,184,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,132,0,0,112,0,0,0,186,3,0,0,30,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,0,0,144,3,0,0,210,0,0,0,118,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,133,0,0,194,1,0,0,196,2,0,0,176,0,0,0,54,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,133,0,0,192,3,0,0,34,3,0,0,62,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,133,0,0,86,2,0,0,228,1,0,0,204,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,133,0,0,30,4,0,0,14,4,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,133,0,0,120,1,0,0,212,3,0,0,112,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,133,0,0,132,1,0,0,94,2,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,133,0,0,4,4,0,0,220,0,0,0,120,1,0,0,102,1,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,133,0,0,180,0,0,0,34,1,0,0,78,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,133,0,0,182,2,0,0,228,0,0,0,122,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,133,0,0,18,2,0,0,54,0,0,0,166,1,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,133,0,0,88,3,0,0,58,0,0,0,166,1,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,133,0,0,182,0,0,0,200,3,0,0,230,1,0,0,72,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,133,0,0,88,1,0,0,138,0,0,0,238,0,0,0,26,3,0,0,60,0,0,0,88,1,0,0,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,133,0,0,116,2,0,0,140,2,0,0,122,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,133,0,0,134,2,0,0,156,0,0,0,122,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,134,0,0,236,2,0,0,160,0,0,0,86,1,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,134,0,0,104,0,0,0,66,0,0,0,220,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,134,0,0,206,2,0,0,126,1,0,0,186,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,134,0,0,164,2,0,0,148,2,0,0,66,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,134,0,0,18,4,0,0,186,0,0,0,100,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,134,0,0,32,2,0,0,6,1,0,0,106,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,134,0,0,172,0,0,0,166,1,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,134,0,0,76,2,0,0,254,2,0,0,116,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,134,0,0,0,4,0,0,70,1,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,134,0,0,176,2,0,0,102,3,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,134,0,0,108,1,0,0,4,3,0,0,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,134,0,0,224,3,0,0,42,3,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,134,0,0,248,0,0,0,174,0,0,0,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,134,0,0,22,2,0,0,206,0,0,0,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,135,0,0,60,0,0,0,32,3,0,0,180,1,0,0,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,135,0,0,4,2,0,0,202,2,0,0,148,1,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,135,0,0,190,2,0,0,70,3,0,0,148,1,0,0,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,135,0,0,172,1,0,0,0,4,0,0,182,1,0,0,96,0,0,0,94,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,135,0,0,0,2,0,0,144,0,0,0,82,0,0,0,232,1,0,0,174,0,0,0,70,0,0,0,112,0,0,0,226,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,135,0,0,238,1,0,0,190,0,0,0,204,0,0,0,46,0,0,0,250,1,0,0,158,2,0,0,52,0,0,0,42,0,0,0,44,0,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,135,0,0,136,0,0,0,2,1,0,0,90,0,0,0,66,0,0,0,8,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,135,0,0,232,2,0,0,248,3,0,0,52,0,0,0,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,135,0,0,64,0,0,0,116,3,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,135,0,0,106,3,0,0,238,3,0,0,118,0,0,0,50,0,0,0,146,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,0,0,188,3,0,0,72,0,0,0,56,0,0,0,62,0,0,0,132,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,136,0,0,112,2,0,0,44,1,0,0,174,10,0,0,144,3,0,0,86,9,0,0,4,1,0,0,234,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,136,0,0,28,4,0,0,146,3,0,0,128,0,0,0,44,0,0,0,192,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,136,0,0,208,0,0,0,118,1,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,136,0,0,74,3,0,0,126,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,136,0,0,196,0,0,0,166,3,0,0,48,2,0,0,68,0,0,0,28,3,0,0,148,3,0,0,56,0,0,0,62,0,0,0,98,0,0,0,6,10,0,0,242,0,0,0,132,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,136,0,0,154,2,0,0,84,1,0,0,240,0,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,136,0,0,52,2,0,0,68,3,0,0,20,2,0,0,48,1,0,0,202,2,0,0,58,0,0,0,70,6,0,0,250,7,0,0,106,0,0,0,112,8,0,0,92,1,0,0,72,2,0,0,56,8,0,0,210,0,0,0,154,1,0,0,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,136,0,0,124,2,0,0,212,0,0,0,124,0,0,0,94,0,0,0,84,1,0,0,162,5,0,0,32,6,0,0,98,7,0,0,246,0,0,0,86,7,0,0,118,1,0,0,248,2,0,0,208,0,0,0,234,0,0,0,96,7,0,0,112,5,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,136,0,0,92,2,0,0,242,3,0,0,130,0,0,0,60,0,0,0,108,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,136,0,0,96,2,0,0,212,2,0,0,44,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,136,0,0,16,4,0,0,58,2,0,0,106,0,0,0,48,0,0,0,58,0,0,0,92,4,0,0,28,6,0,0,26,6,0,0,204,3,0,0,194,4,0,0,202,8,0,0,98,0,0,0,24,1,0,0,142,9,0,0,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,136,0,0,14,3,0,0,170,3,0,0,80,0,0,0,56,0,0,0,154,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,137,0,0])
.concat([184,2,0,0,234,3,0,0,148,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,137,0,0,226,0,0,0,2,2,0,0,114,1,0,0,190,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,137,0,0,198,3,0,0,26,1,0,0,152,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,36,6,0,0,110,9,0,0,82,0,0,0,210,6,0,0,92,1,0,0,72,2,0,0,110,4,0,0,90,0,0,0,154,1,0,0,78,2,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,137,0,0,216,1,0,0,142,3,0,0,54,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,137,0,0,172,1,0,0,244,1,0,0,202,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,52,4,0,0,140,9,0,0,94,0,0,0,30,8,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,46,0,0,0,110,1,0,0,58,0,0,0,120,1,0,0,220,6,0,0,64,1,0,0,90,8,0,0,4,4,0,0,228,1,0,0,228,1,0,0,124,0,0,0,214,5,0,0,70,1,0,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,137,0,0,142,0,0,0,210,3,0,0,168,1,0,0,44,5,0,0,186,3,0,0,246,1,0,0,42,2,0,0,168,1,0,0,180,1,0,0,236,0,0,0,112,3,0,0,242,3,0,0,52,0,0,0,190,1,0,0,54,3,0,0,90,3,0,0,140,3,0,0,4,4,0,0,130,6,0,0,134,0,0,0,198,0,0,0,66,2,0,0,190,1,0,0,228,5,0,0,214,2,0,0,162,9,0,0,212,1,0,0,222,1,0,0,16,6,0,0,90,1,0,0,164,4,0,0,88,0,0,0,58,2,0,0,116,2,0,0,48,2,0,0,90,0,0,0,228,1,0,0,94,0,0,0,12,2,0,0,114,1,0,0,46,2,0,0,62,2,0,0,238,5,0,0,62,1,0,0,230,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,137,0,0,250,2,0,0,84,2,0,0,254,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,137,0,0,114,3,0,0,186,2,0,0,36,1,0,0,186,0,0,0,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,137,0,0,46,1,0,0,12,2,0,0,106,1,0,0,220,3,0,0,58,9,0,0,244,0,0,0,232,3,0,0,14,1,0,0,76,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,137,0,0,224,2,0,0,252,3,0,0,136,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,137,0,0,124,0,0,0,80,3,0,0,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,137,0,0,54,3,0,0,202,3,0,0,164,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,224,1,0,0,76,7,0,0,94,0,0,0,42,0,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,112,0,0,0,44,1,0,0,188,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,90,8,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,137,0,0,122,2,0,0,144,2,0,0,44,3,0,0,68,0,0,0,254,3,0,0,98,6,0,0,56,0,0,0,66,0,0,0,66,0,0,0,240,3,0,0,158,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,138,0,0,184,3,0,0,8,2,0,0,48,2,0,0,68,0,0,0,28,3,0,0,148,4,0,0,56,0,0,0,62,0,0,0,98,0,0,0,102,10,0,0,252,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,138,0,0,246,3,0,0,118,2,0,0,168,1,0,0,44,5,0,0,186,3,0,0,246,1,0,0,42,2,0,0,168,1,0,0,180,1,0,0,236,0,0,0,112,3,0,0,242,3,0,0,52,0,0,0,190,1,0,0,54,3,0,0,90,3,0,0,140,3,0,0,4,4,0,0,130,6,0,0,134,0,0,0,198,0,0,0,66,2,0,0,190,1,0,0,228,5,0,0,214,2,0,0,162,9,0,0,212,1,0,0,222,1,0,0,138,4,0,0,90,1,0,0,164,4,0,0,88,0,0,0,58,2,0,0,116,2,0,0,48,2,0,0,90,0,0,0,228,1,0,0,94,0,0,0,12,2,0,0,10,1,0,0,46,2,0,0,62,2,0,0,238,5,0,0,62,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,138,0,0,240,3,0,0,78,2,0,0,100,0,0,0,52,0,0,0,98,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,138,0,0,42,2,0,0,196,3,0,0,168,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,138,0,0,20,3,0,0,184,0,0,0,36,1,0,0,186,0,0,0,92,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,138,0,0,102,0,0,0,96,3,0,0,46,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,138,0,0,214,3,0,0,98,2,0,0,238,0,0,0,158,5,0,0,60,0,0,0,88,1,0,0,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,138,0,0,162,3,0,0,72,1,0,0,182,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,72,1,0,0,166,4,0,0,120,0,0,0,98,10,0,0,92,1,0,0,72,2,0,0,84,3,0,0,148,0,0,0,154,1,0,0,210,1,0,0,66,0,0,0,200,0,0,0,58,1,0,0,108,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,138,0,0,180,3,0,0,148,0,0,0,110,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,138,0,0,36,3,0,0,204,1,0,0,48,2,0,0,68,0,0,0,28,3,0,0,148,4,0,0,56,0,0,0,62,0,0,0,98,0,0,0,102,10,0,0,252,0,0,0,132,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,138,0,0,24,4,0,0,92,3,0,0,198,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,22,5,0,0,106,6,0,0,102,0,0,0,132,4,0,0,110,0,0,0,214,2,0,0,110,4,0,0,90,0,0,0,154,1,0,0,126,1,0,0,56,1,0,0,122,1,0,0,16,2,0,0,66,1,0,0,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,138,0,0,130,3,0,0,190,3,0,0,22,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,138,0,0,182,3,0,0,110,0,0,0,80,2,0,0,44,5,0,0,186,3,0,0,222,2,0,0,42,2,0,0,168,1,0,0,194,1,0,0,66,2,0,0,112,3,0,0,160,3,0,0,48,0,0,0,232,0,0,0,90,6,0,0,28,5,0,0,30,6,0,0,2,6,0,0,192,2,0,0,218,3,0,0,212,5,0,0,14,2,0,0,206,2,0,0,18,4,0,0,20,4,0,0,94,2,0,0,112,1,0,0,120,0,0,0,226,1,0,0,182,1,0,0,248,4,0,0,130,5,0,0,86,6,0,0,178,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,139,0,0,158,0,0,0,110,3,0,0,38,3,0,0,68,0,0,0,88,6,0,0,66,4,0,0,66,0,0,0,60,0,0,0,62,0,0,0,12,7,0,0,74,0,0,0,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,139,0,0,222,3,0,0,30,3,0,0,48,0,0,0,220,0,0,0,254,0,0,0,220,4,0,0,62,0,0,0,250,0,0,0,34,2,0,0,192,10,0,0,184,1,0,0,144,9,0,0,164,3,0,0,210,7,0,0,40,1,0,0,36,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,139,0,0,16,3,0,0,252,1,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,139,0,0,172,2,0,0,6,2,0,0,210,5,0,0,96,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,139,0,0,146,0,0,0,100,3,0,0,42,0,0,0,42,0,0,0,42,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,139,0,0,242,0,0,0,250,1,0,0,46,0,0,0,74,0,0,0,88,0,0,0,86,2,0,0,64,0,0,0,234,0,0,0,64,1,0,0,120,7,0,0,180,8,0,0,22,1,0,0,208,4,0,0,230,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,139,0,0,26,2,0,0,236,1,0,0,54,0,0,0,52,1,0,0,72,0,0,0,230,0,0,0,54,0,0,0,192,1,0,0,150,3,0,0,130,2,0,0,248,6,0,0,172,1,0,0,112,3,0,0,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,139,0,0,98,3,0,0,180,1,0,0,238,0,0,0,254,4,0,0,60,0,0,0,88,1,0,0,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,139,0,0,70,2,0,0,22,1,0,0,182,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,88,5,0,0,166,4,0,0,120,0,0,0,0,6,0,0,92,1,0,0,72,2,0,0,110,4,0,0,90,0,0,0,154,1,0,0,190,1,0,0,66,0,0,0,200,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,139,0,0,100,1,0,0,142,2,0,0,162,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,139,0,0,176,0,0,0,140,3,0,0,78,0,0,0,74,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,139,0,0,156,3,0,0,100,2,0,0,238,0,0,0,188,0,0,0,60,0,0,0,88,1,0,0,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,139,0,0,218,1,0,0,102,1,0,0,156,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,44,3,0,0,44,6,0,0,112,0,0,0,114,9,0,0,92,1,0,0,72,2,0,0,248,7,0,0,224,0,0,0,154,1,0,0,78,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,139,0,0,132,2,0,0,178,1,0,0,152,2,0,0,68,0,0,0,146,1,0,0,238,3,0,0,56,0,0,0,42,0,0,0,58,0,0,0,250,2,0,0,138,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,139,0,0,136,2,0,0,12,4,0,0,56,0,0,0,218,0,0,0,64,0,0,0,252,1,0,0,90,0,0,0,94,1,0,0,174,4,0,0,88,7,0,0,218,6,0,0,20,1,0,0,44,0,0,0,22,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,140,0,0,66,1,0,0,254,1,0,0,126,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,158,6,0,0,76,7,0,0,46,0,0,0,100,4,0,0,172,0,0,0,58,2,0,0,88,9,0,0,226,0,0,0,154,1,0,0,112,0,0,0,184,0,0,0,44,2,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,140,0,0,158,3,0,0,50,1,0,0,48,2,0,0,68,0,0,0,28,3,0,0,148,3,0,0,56,0,0,0,62,0,0,0,98,0,0,0,6,10,0,0,242,0,0,0,132,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,140,0,0,44,2,0,0,178,3,0,0,182,0,0,0,172,1,0,0,60,0,0,0,88,1,0,0,154,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,140,0,0,230,3,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,140,0,0,130,0,0,0,78,3,0,0,152,2,0,0,68,0,0,0,42,0,0,0,42,0,0,0,56,0,0,0,42,0,0,0,42,0,0,0,34,5,0,0,198,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,140,0,0,48,0,0,0,30,1,0,0,40,3,0,0,68,0,0,0,102,5,0,0,230,2,0,0,56,0,0,0,64,0,0,0,50,0,0,0,184,7,0,0,228,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,140,0,0,216,2,0,0,232,3,0,0,76,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,140,0,0,58,3,0,0,154,3,0,0,202,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,116,6,0,0,76,7,0,0,94,0,0,0,152,7,0,0,172,0,0,0,58,2,0,0,230,9,0,0,152,0,0,0,154,1,0,0,248,0,0,0,254,0,0,0,142,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,90,8,0,0,190,5,0,0,170,0,0,0,100,0,0,0,40,1,0,0,132,9,0,0,40,2,0,0,74,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,140,0,0,46,1,0,0,110,2,0,0,0,3,0,0,220,3,0,0,58,9,0,0,244,0,0,0,232,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,168,140,0,0,240,0,0,0,146,1,0,0,54,0,0,0,52,1,0,0,72,0,0,0,230,0,0,0,54,0,0,0,192,1,0,0,150,3,0,0,130,2,0,0,248,6,0,0,172,1,0,0,112,3,0,0,24,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,140,0,0,6,3,0,0,142,1,0,0,178,1,0,0,218,0,0,0,252,255,255,255,184,140,0,0,118,0,0,0,72,3,0,0,54,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,140,0,0,84,3,0,0,36,2,0,0,42,0,0,0,46,4,0,0,78,1,0,0,86,1,0,0,128,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,140,0,0,14,1,0,0,148,3,0,0,8,1,0,0,142,1,0,0,60,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,140,0,0,10,1,0,0,26,4,0,0,36,1,0,0,186,0,0,0,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,141,0,0,106,0,0,0,114,1,0,0,138,0,0,0,46,0,0,0,230,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,141,0,0,78,0,0,0,28,3,0,0,58,0,0,0,46,1,0,0,124,0,0,0,130,1,0,0,78,0,0,0,68,0,0,0,246,0,0,0,252,9,0,0,20,2,0,0,138,1,0,0,146,5,0,0,52,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,141,0,0,80,1,0,0,78,1,0,0,12,2,0,0,48,1,0,0,202,2,0,0,58,0,0,0,106,2,0,0,76,7,0,0,72,0,0,0,216,10,0,0,32,2,0,0,58,2,0,0,224,10,0,0,246,0,0,0,154,1,0,0,80,0,0,0,42,0,0,0,248,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,68,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,141,0,0,76,0,0,0,194,2,0,0,12,2,0,0,48,1,0,0,202,2,0,0,58,0,0,0,106,2,0,0,76,7,0,0,72,0,0,0,184,9,0,0,32,2,0,0,58,2,0,0,224,10,0,0,246,0,0,0,154,1,0,0,80,0,0,0,42,1,0,0,160,0,0,0,120,1,0,0,220,6,0,0,64,1,0,0,12,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,141,0,0,114,0,0,0,250,0,0,0,168,1,0,0,44,5,0,0,186,3,0,0,84,0,0,0,42,2,0,0,168,1,0,0,194,1,0,0,46,5,0,0,112,3,0,0,160,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,141,0,0,150,3,0,0,244,2,0,0,84,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,104,141,0,0,220,3,0,0,40,1,0,0,70,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,90,5,0,0,76,7,0,0,94,0,0,0,62,10,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,112,0,0,0,44,1,0,0,188,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,90,8,0,0,20,10,0,0,194,4,0,0,164,0,0,0,96,0,0,0,164,9,0,0,0,2,0,0,56,0,0,0,208,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,141,0,0,116,1,0,0,116,0,0,0,168,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,224,1,0,0,76,7,0,0,54,0,0,0,108,2,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,112,0,0,0,96,1,0,0,18,1,0,0,120,1,0,0,248,3,0,0,108,1,0,0,90,8,0,0,52,4,0,0,106,8,0,0,98,0,0,0,194,1,0,0,52,6,0,0,162,0,0,0,48,0,0,0,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,136,141,0,0,48,3,0,0,120,3,0,0,156,0,0,0,46,0,0,0,220,0,0,0,38,7,0,0,68,5,0,0,200,0,0,0,170,0,0,0,244,0,0,0,134,1,0,0,26,6,0,0,228,0,0,0,116,0,0,0,146,6,0,0,90,0,0,0,238,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,152,141,0,0,82,3,0,0,114,2,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,184,141,0,0,204,0,0,0,104,2,0,0,12,2,0,0,48,1,0,0,202,2,0,0,58,0,0,0,106,2,0,0,76,7,0,0,72,0,0,0,158,5,0,0,32,2,0,0,58,2,0,0,224,10,0,0,246,0,0,0,154,1,0,0,80,0,0,0,170,1,0,0,88,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,250,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,200,141,0,0,202,1,0,0,122,0,0,0,26,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,182,1,0,0,142,1,0,0,100,0,0,0,10,9,0,0,184,1,0,0,170,2,0,0,120,4,0,0,240,0,0,0,154,1,0,0,124,0,0,0,20,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,216,141,0,0,66,2,0,0,240,2,0,0,200,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,26,4,0,0,76,7,0,0,50,0,0,0,28,10,0,0,196,1,0,0,58,2,0,0,174,3,0,0,186,0,0,0,154,1,0,0,112,0,0,0,26,1,0,0,244,0,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,232,141,0,0,226,1,0,0,42,1,0,0,200,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,26,4,0,0,76,7,0,0,50,0,0,0,72,7,0,0,196,1,0,0,58,2,0,0,174,3,0,0,186,0,0,0,154,1,0,0,112,0,0,0,26,1,0,0,244,0,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,248,141,0,0,72,2,0,0,62,3,0,0,106,0,0,0,48,0,0,0,58,0,0,0,92,4,0,0,28,6,0,0,26,6,0,0,134,6,0,0,102,3,0,0,202,8,0,0,98,0,0,0,24,1,0,0,142,9,0,0,206,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,142,0,0,68,0,0,0,200,1,0,0,72,0,0,0,60,0,0,0,202,0,0,0,170,3,0,0,252,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,142,0,0,38,2,0,0,126,3,0,0,72,0,0,0,60,0,0,0,202,0,0,0,170,3,0,0,252,5,0,0,114,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,142,0,0,180,2,0,0,168,3,0,0,200,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,26,4,0,0,76,7,0,0,50,0,0,0,136,8,0,0,196,1,0,0,58,2,0,0,174,3,0,0,186,0,0,0,154,1,0,0,112,0,0,0,26,1,0,0,244,0,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,72,142,0,0,62,0,0,0,248,2,0,0,66,0,0,0,48,1,0,0,202,2,0,0,58,0,0,0,224,1,0,0,76,7,0,0,136,0,0,0,250,6,0,0,108,0,0,0,28,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,16,1,0,0,68,1,0,0,110,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,142,0,0,46,1,0,0,56,3,0,0,170,1,0,0,220,3,0,0,58,9,0,0,244,0,0,0,232,3,0,0,2,1,0,0,52,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,142,0,0,28,2,0,0,178,0,0,0,64,2,0,0,48,1,0,0,202,2,0,0,58,0,0,0,14,4,0,0,114,8,0,0,90,0,0,0,150,6,0,0,92,1,0,0,72,2,0,0,110,4,0,0,90,0,0,0,154,1,0,0,10,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,142,0,0,160,2,0,0,134,3,0,0,164,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,36,3,0,0,76,7,0,0,76,0,0,0,234,4,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,58,1,0,0,60,1,0,0,84,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,142,0,0,122,3,0,0,220,2,0,0,164,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,36,3,0,0,76,7,0,0,76,0,0,0,234,4,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,58,1,0,0,60,1,0,0,84,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,142,0,0,194,3,0,0,46,2,0,0,46,0,0,0,74,0,0,0,88,0,0,0,86,2,0,0,64,0,0,0,234,0,0,0,64,1,0,0,120,7,0,0,180,8,0,0,22,1,0,0,208,4,0,0,230,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,142,0,0,184,0,0,0,198,0,0,0,208,1,0,0,220,3,0,0,196,8,0,0,208,0,0,0,68,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,142,0,0,30,2,0,0,148,1,0,0,164,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,36,3,0,0,76,7,0,0,76,0,0,0,234,4,0,0,172,0,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,58,1,0,0,60,1,0,0,84,1,0,0,120,1,0,0,220,6,0,0,64,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,142,0,0,104,1,0,0,166,2,0,0,138,1,0,0,48,1,0,0,202,2,0,0,58,0,0,0,220,5,0,0,76,7,0,0,56,0,0,0,6,8,0,0,26,1,0,0,58,2,0,0,86,6,0,0,118,0,0,0,154,1,0,0,214,0,0,0,60,0,0,0,134,1,0,0,120,1,0,0,214,6,0,0,146,1,0,0,90,8,0,0,204,8,0,0,136,6,0,0,238,1,0,0,38,1,0,0,78,4,0,0,250,0,0,0,72,0,0,0,188,1,0,0,0,0,0,0,0,0,0,0,90,78,75,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,51,49,99,97,108,99,117,108,97,116,101,80,114,105,110,99,105,112,97,108,65,120,105,115,84,114,97,110,115,102,111,114,109,69,82,49,49,98,116,84,114,97,110,115,102,111,114,109,82,57,98,116,86,101,99,116,111,114,51,82,102,69,49,53,73,110,101,114,116,105,97,67,97,108,108,98,97,99,107,95,48,0,90,78,75,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,51,49,99,97,108,99,117,108,97,116,101,80,114,105,110,99,105,112,97,108,65,120,105,115,84,114,97,110,115,102,111,114,109,69,82,49,49,98,116,84,114,97,110,115,102,111,114,109,82,57,98,116,86,101,99,116,111,114,51,82,102,69,49,52,67,101,110,116,101,114,67,97,108,108,98,97,99,107,0,0,0,0,90,78,75,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,90,78,75,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,57,112,114,111,99,101,115,115,65,108,108,84,114,105,97,110,103,108,101,115,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,49,54,70,105,108,116,101,114,101,100,67,97,108,108,98,97,99,107,0,0,0,90,78,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,49,50,99,97,108,99,80,101,110,68,101,112,116,104,69,82,50,50,98,116,86,111,114,111,110,111,105,83,105,109,112,108,101,120,83,111,108,118,101,114,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,83,52,95,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,55,95,82,57,98,116,86,101,99,116,111,114,51,83,57,95,83,57,95,80,49,50,98,116,73,68,101,98,117,103,68,114,97,119,80,49,50,98,116,83,116,97,99,107,65,108,108,111,99,69,50,48,98,116,73,110,116,101,114,109,101,100,105,97,116,101,82,101,115,117,108,116,0,0,0,0,0,0,0,90,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,50,49,99,97,108,99,117,108,97,116,101,84,105,109,101,79,102,73,109,112,97,99,116,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,51,49,76,111,99,97,108,84,114,105,97,110,103,108,101,83,112,104,101,114,101,67,97,115,116,67,97,108,108,98,97,99,107,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,51,55,114,101,109,111,118,101,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,115,67,111,110,116,97,105,110,105,110,103,80,114,111,120,121,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,56,82,101,109,111,118,101,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,90,78,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,49,57,99,108,101,97,110,80,114,111,120,121,70,114,111,109,80,97,105,114,115,69,80,49,55,98,116,66,114,111,97,100,112,104,97,115,101,80,114,111,120,121,80,49,50,98,116,68,105,115,112,97,116,99,104,101,114,69,49,55,67,108,101,97,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,90,78,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,50,51,99,97,108,99,117,108,97,116,101,65,97,98,98,66,114,117,116,101,70,111,114,99,101,69,82,57,98,116,86,101,99,116,111,114,51,83,49,95,69,50,51,65,97,98,98,67,97,108,99,117,108,97,116,105,111,110,67,97,108,108,98,97,99,107,0,0,0,90,78,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,49,54,115,111,108,118,101,67,111,110,115,116,114,97,105,110,116,115,69,82,49,57,98,116,67,111,110,116,97,99,116,83,111,108,118,101,114,73,110,102,111,69,50,55,73,110,112,108,97,99,101,83,111,108,118,101,114,73,115,108,97,110,100,67,97,108,108,98,97,99,107,0,0,0,0,0,0,90,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,54,112,114,111,99,101,115,115,67,111,108,108,105,115,105,111,110,69,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,83,49,95,82,75,49,54,98,116,68,105,115,112,97,116,99,104,101,114,73,110,102,111,80,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,69,49,51,98,116,68,117,109,109,121,82,101,115,117,108,116,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,55,112,101,114,102,111,114,109,67,111,110,118,101,120,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,83,52,95,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,90,78,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,49,52,112,101,114,102,111,114,109,82,97,121,99,97,115,116,69,80,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,49,77,121,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,51,50,66,114,105,100,103,101,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,111,98,106,101,99,116,81,117,101,114,121,83,105,110,103,108,101,69,80,75,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,53,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,53,95,82,78,83,95,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,102,69,49,52,76,111,99,97,108,73,110,102,111,65,100,100,101,114,95,49,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,57,82,97,121,84,101,115,116,101,114,95,49,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,95,48,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,50,57,66,114,105,100,103,101,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,90,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,51,114,97,121,84,101,115,116,83,105,110,103,108,101,69,82,75,49,49,98,116,84,114,97,110,115,102,111,114,109,83,50,95,80,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,80,75,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,83,50,95,82,78,83,95,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,69,49,53,76,111,99,97,108,73,110,102,111,65,100,100,101,114,50,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,57,81,117,97,110,116,105,122,101,100,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,90,78,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,53,98,117,105,108,100,69,80,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,98,82,75,57,98,116,86,101,99,116,111,114,51,83,52,95,69,50,48,78,111,100,101,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,95,48,0,0,0,0,83,116,57,116,121,112,101,95,105,110,102,111,0,0,0,0,83,116,57,101,120,99,101,112,116,105,111,110,0,0,0,0,83,116,57,98,97,100,95,97,108,108,111,99,0,0,0,0,78,54,98,116,68,98,118,116,56,73,67,111,108,108,105,100,101,69,0,0,0,0,0,0,78,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,54,82,101,115,117,108,116,69,0,78,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,78,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,55,83,119,97,112,112,101,100,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,78,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,78,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,78,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,49,52,73,115,108,97,110,100,67,97,108,108,98,97,99,107,69,0,0,0,78,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,78,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,49,48,67,114,101,97,116,101,70,117,110,99,69,0,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,55,67,108,111,115,101,115,116,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,67,108,111,115,101,115,116,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,52,65,108,108,72,105,116,115,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,49,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,50,48,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,0,0,0,0,0,78,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,49,55,82,97,121,82,101,115,117,108,116,67,97,108,108,98,97,99,107,69,0,78,49,50,98,116,67,111,110,118,101,120,67,97,115,116,49,48,67,97,115,116,82,101,115,117,108,116,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,49,95,95,118,109,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,50,48,95,95,115,105,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,55,95,95,99,108,97,115,115,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,78,49,48,95,95,99,120,120,97,98,105,118,49,49,54,95,95,115,104,105,109,95,116,121,112,101,95,105,110,102,111,69,0,0,0,0,0,0,0,0,51,54,98,116,68,105,115,99,114,101,116,101,67,111,108,108,105,115,105,111,110,68,101,116,101,99,116,111,114,73,110,116,101,114,102,97,99,101,0,0,51,53,98,116,83,101,113,117,101,110,116,105,97,108,73,109,112,117,108,115,101,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,51,52,98,116,83,112,104,101,114,101,84,114,105,97,110,103,108,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,51,52,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,0,0,0,51,52,98,116,67,108,111,115,101,115,116,78,111,116,77,101,67,111,110,118,101,120,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,0,0,0,51,51,98,116,77,105,110,107,111,119,115,107,105,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,51,51,98,116,67,111,110,118,101,120,67,111,110,99,97,118,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,51,50,98,116,83,112,104,101,114,101,83,112,104,101,114,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116])
.concat([104,109,0,0,0,0,0,0,51,50,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,65,97,98,98,67,97,99,104,105,110,103,83,104,97,112,101,0,0,0,0,0,0,51,49,98,116,73,110,116,101,114,110,97,108,84,114,105,97,110,103,108,101,73,110,100,101,120,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,51,49,98,116,68,101,102,97,117,108,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,0,51,49,98,116,67,111,110,118,101,120,80,108,97,110,101,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,51,48,98,116,71,106,107,69,112,97,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,111,110,118,101,120,80,101,110,101,116,114,97,116,105,111,110,68,101,112,116,104,83,111,108,118,101,114,0,0,0,0,0,0,0,0,51,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,67,114,101,97,116,101,70,117,110,99,0,0,0,0,0,0,0,0,51,48,98,116,65,99,116,105,118,97,116,105,110,103,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,0,50,57,98,116,71,101,110,101,114,105,99,54,68,111,102,83,112,114,105,110,103,67,111,110,115,116,114,97,105,110,116,0,50,57,67,111,110,99,114,101,116,101,67,111,110,116,97,99,116,82,101,115,117,108,116,67,97,108,108,98,97,99,107,0,50,56,98,116,84,114,105,97,110,103,108,101,67,111,110,118,101,120,99,97,115,116,67,97,108,108,98,97,99,107,0,0,50,56,98,116,83,99,97,108,101,100,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,50,56,98,116,72,97,115,104,101,100,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,50,56,98,116,67,111,109,112,111,117,110,100,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,50,55,98,116,67,111,110,116,105,110,117,111,117,115,67,111,110,118,101,120,67,111,108,108,105,115,105,111,110,0,0,0,50,54,98,116,84,114,105,97,110,103,108,101,73,110,100,101,120,86,101,114,116,101,120,65,114,114,97,121,0,0,0,0,50,54,98,116,66,111,120,66,111,120,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,0,0,50,54,76,111,99,97,108,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,0,0,0,50,53,98,116,84,114,105,97,110,103,108,101,82,97,121,99,97,115,116,67,97,108,108,98,97,99,107,0,0,0,0,0,50,53,98,116,83,105,109,117,108,97,116,105,111,110,73,115,108,97,110,100,77,97,110,97,103,101,114,0,0,0,0,0,50,53,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,50,53,98,116,72,101,105,103,104,116,102,105,101,108,100,84,101,114,114,97,105,110,83,104,97,112,101,0,0,0,0,0,50,53,98,116,68,101,102,97,117,108,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,0,50,53,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,50,53,98,116,67,111,110,116,105,110,117,111,117,115,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,50,52,98,116,83,99,97,108,101,100,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,50,52,98,116,80,101,114,116,117,114,98,101,100,67,111,110,116,97,99,116,82,101,115,117,108,116,0,0,0,0,0,0,50,52,98,116,80,97,105,114,67,97,99,104,105,110,103,71,104,111,115,116,79,98,106,101,99,116,0,0,0,0,0,0,50,52,98,116,67,111,110,118,101,120,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,0,0,50,52,98,116,67,111,108,108,105,115,105,111,110,67,111,110,102,105,103,117,114,97,116,105,111,110,0,0,0,0,0,0,50,52,98,116,66,114,111,97,100,112,104,97,115,101,65,97,98,98,67,97,108,108,98,97,99,107,0,0,0,0,0,0,50,51,98,116,83,116,114,105,100,105,110,103,77,101,115,104,73,110,116,101,114,102,97,99,101,0,0,0,0,0,0,0,50,51,98,116,83,105,110,103,108,101,67,111,110,116,97,99,116,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,50,51,98,116,80,111,108,121,104,101,100,114,97,108,67,111,110,118,101,120,83,104,97,112,101,0,0,0,0,0,0,0,50,51,98,116,80,111,105,110,116,50,80,111,105,110,116,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,50,51,98,116,71,101,110,101,114,105,99,54,68,111,102,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,0,0,50,51,98,116,68,105,115,99,114,101,116,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,50,51,98,116,67,111,110,118,101,120,67,111,110,118,101,120,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,0,50,51,98,116,67,111,108,108,105,115,105,111,110,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,50,51,98,116,66,114,111,97,100,112,104,97,115,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,50,51,98,116,66,114,105,100,103,101,100,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,0,50,50,98,116,83,117,98,115,105,109,112,108,101,120,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,0,50,50,98,116,79,118,101,114,108,97,112,112,105,110,103,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,0,50,50,98,116,67,111,109,112,111,117,110,100,76,101,97,102,67,97,108,108,98,97,99,107,0,0,0,0,0,0,0,0,50,50,98,116,66,118,104,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,0,0,0,0,0,50,50,83,112,104,101,114,101,84,114,105,97,110,103,108,101,68,101,116,101,99,116,111,114,0,0,0,0,0,0,0,0,50,49,98,116,85,110,105,118,101,114,115,97,108,67,111,110,115,116,114,97,105,110,116,0,50,49,98,116,85,110,105,102,111,114,109,83,99,97,108,105,110,103,83,104,97,112,101,0,50,49,98,116,83,105,110,103,108,101,83,119,101,101,112,67,97,108,108,98,97,99,107,0,50,49,98,116,83,105,109,112,108,101,68,121,110,97,109,105,99,115,87,111,114,108,100,0,50,49,98,116,78,111,100,101,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,50,49,98,116,67,111,110,118,101,120,73,110,116,101,114,110,97,108,83,104,97,112,101,0,50,49,98,116,67,111,110,101,84,119,105,115,116,67,111,110,115,116,114,97,105,110,116,0,50,49,98,116,67,111,108,108,105,115,105,111,110,68,105,115,112,97,116,99,104,101,114,0,50,49,98,116,66,114,111,97,100,112,104,97,115,101,73,110,116,101,114,102,97,99,101,0,50,49,83,117,112,112,111,114,116,86,101,114,116,101,120,67,97,108,108,98,97,99,107,0,50,48,98,116,68,101,102,97,117,108,116,77,111,116,105,111,110,83,116,97,116,101,0,0,50,48,98,116,67,111,108,108,105,115,105,111,110,65,108,103,111,114,105,116,104,109,0,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,116,69,0,0,0,0,0,0,0,50,48,98,116,65,120,105,115,83,119,101,101,112,51,73,110,116,101,114,110,97,108,73,106,69,0,0,0,0,0,0,0,50,48,66,114,111,97,100,112,104,97,115,101,65,97,98,98,84,101,115,116,101,114,0,0,49,57,98,116,84,114,105,97,110,103,108,101,77,101,115,104,83,104,97,112,101,0,0,0,49,57,98,116,83,105,110,103,108,101,82,97,121,67,97,108,108,98,97,99,107,0,0,0,49,57,98,116,71,104,111,115,116,80,97,105,114,67,97,108,108,98,97,99,107,0,0,0,49,57,66,114,111,97,100,112,104,97,115,101,82,97,121,84,101,115,116,101,114,0,0,0,49,56,98,116,86,101,104,105,99,108,101,82,97,121,99,97,115,116,101,114,0,0,0,0,49,56,98,116,84,114,105,97,110,103,108,101,67,97,108,108,98,97,99,107,0,0,0,0,49,56,98,116,83,116,97,116,105,99,80,108,97,110,101,83,104,97,112,101,0,0,0,0,49,56,98,116,83,108,105,100,101,114,67,111,110,115,116,114,97,105,110,116,0,0,0,0,49,56,98,116,83,105,109,112,108,101,66,114,111,97,100,112,104,97,115,101,0,0,0,0,49,56,98,116,77,117,108,116,105,83,112,104,101,114,101,83,104,97,112,101,0,0,0,0,49,56,98,116,72,105,110,103,101,50,67,111,110,115,116,114,97,105,110,116,0,0,0,0,49,56,98,116,68,98,118,116,84,114,101,101,67,111,108,108,105,100,101,114,0,0,0,0,49,56,98,116,67,111,110,118,101,120,80,111,108,121,104,101,100,114,111,110,0,0,0,0,49,56,98,116,67,111,110,115,116,114,97,105,110,116,83,111,108,118,101,114,0,0,0,0,49,55,98,116,84,121,112,101,100,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,49,55,98,116,79,118,101,114,108,97,112,67,97,108,108,98,97,99,107,0,0,0,0,0,49,55,98,116,72,105,110,103,101,67,111,110,115,116,114,97,105,110,116,0,0,0,0,0,49,55,98,116,71,106,107,80,97,105,114,68,101,116,101,99,116,111,114,0,0,0,0,0,49,55,98,116,67,111,110,118,101,120,72,117,108,108,83,104,97,112,101,0,0,0,0,0,49,55,98,116,67,111,108,108,105,115,105,111,110,79,98,106,101,99,116,0,0,0,0,0,49,55,98,116,65,99,116,105,111,110,73,110,116,101,114,102,97,99,101,0,0,0,0,0,49,55,98,116,51,50,66,105,116,65,120,105,115,83,119,101,101,112,51,0,0,0,0,0,49,55,68,101,98,117,103,68,114,97,119,99,97,108,108,98,97,99,107,0,0,0,0,0,49,54,98,116,82,97,121,99,97,115,116,86,101,104,105,99,108,101,0,0,0,0,0,0,49,54,98,116,80,111,105,110,116,67,111,108,108,101,99,116,111,114,0,0,0,0,0,0,49,54,98,116,77,97,110,105,102,111,108,100,82,101,115,117,108,116,0,0,0,0,0,0,49,54,98,116,69,109,112,116,121,65,108,103,111,114,105,116,104,109,0,0,0,0,0,0,49,54,98,116,68,98,118,116,66,114,111,97,100,112,104,97,115,101,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,90,0,0,0,0,0,0,49,54,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,88,0,0,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,87,111,114,108,100,0,0,0,0,0,0,49,54,98,116,67,111,108,108,105,115,105,111,110,83,104,97,112,101,0,0,0,0,0,0,49,54,98,116,66,111,120,66,111,120,68,101,116,101,99,116,111,114,0,0,0,0,0,0,49,54,98,116,66,85,95,83,105,109,112,108,101,120,49,116,111,52,0,0,0,0,0,0,49,53,98,116,84,114,105,97,110,103,108,101,83,104,97,112,101,0,0,0,0,0,0,0,49,53,98,116,78,117,108,108,80,97,105,114,67,97,99,104,101,0,0,0,0,0,0,0,49,53,98,116,71,106,107,67,111,110,118,101,120,67,97,115,116,0,0,0,0,0,0,0,49,53,98,116,68,121,110,97,109,105,99,115,87,111,114,108,100,0,0,0,0,0,0,0,49,53,98,116,67,121,108,105,110,100,101,114,83,104,97,112,101,0,0,0,0,0,0,0,49,53,98,116,67,111,109,112,111,117,110,100,83,104,97,112,101,0,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,90,0,0,0,0,0,0,0,49,53,98,116,67,97,112,115,117,108,101,83,104,97,112,101,88,0,0,0,0,0,0,0,49,52,98,116,84,114,105,97,110,103,108,101,77,101,115,104,0,0,0,0,0,0,0,0,49,52,98,116,81,117,97,110,116,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,49,52,98,116,79,112,116,105,109,105,122,101,100,66,118,104,0,0,0,0,0,0,0,0,49,52,98,116,67,111,110,99,97,118,101,83,104,97,112,101,0,0,0,0,0,0,0,0,49,52,98,116,67,97,112,115,117,108,101,83,104,97,112,101,0,0,0,0,0,0,0,0,49,51,98,116,84,121,112,101,100,79,98,106,101,99,116,0,49,51,98,116,83,112,104,101,114,101,83,104,97,112,101,0,49,51,98,116,77,111,116,105,111,110,83,116,97,116,101,0,49,51,98,116,71,104,111,115,116,79,98,106,101,99,116,0,49,51,98,116,67,111,110,118,101,120,83,104,97,112,101,0,49,50,98,116,69,109,112,116,121,83,104,97,112,101,0,0,49,50,98,116,68,105,115,112,97,116,99,104,101,114,0,0,49,50,98,116,67,111,110,118,101,120,67,97,115,116,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,90,0,0,49,50,98,116,67,111,110,101,83,104,97,112,101,88,0,0,49,50,98,116,65,120,105,115,83,119,101,101,112,51,0,0,49,49,98,116,82,105,103,105,100,66,111,100,121,0,0,0,49,49,98,116,67,111,110,101,83,104,97,112,101,0,0,0,49,48,98,116,66,111,120,83,104,97,112,101,0,0,0,0,0,0,0,0,216,102,0,0,32,136,0,0,0,0,0,0,0,0,0,0,72,103,0,0,32,136,0,0,0,0,0,0,0,0,0,0,184,103,0,0,240,138,0,0,0,0,0,0,0,0,0,0,40,104,0,0,32,136,0,0,0,0,0,0,0,0,0,0,144,104,0,0,88,134,0,0,0,0,0,0,0,0,0,0,80,105,0,0,208,139,0,0,0,0,0,0,0,0,0,0,240,105,0,0,96,140,0,0,0,0,0,0,0,0,0,0,120,106,0,0,96,140,0,0,0,0,0,0,0,0,0,0,232,106,0,0,32,136,0,0,0,0,0,0,0,0,0,0,72,107,0,0,224,134,0,0,0,0,0,0,0,0,0,0,176,107,0,0,88,134,0,0,0,0,0,0,0,0,0,0,48,108,0,0,240,138,0,0,0,0,0,0,0,0,0,0,168,108,0,0,240,138,0,0,0,0,0,0,0,0,0,0,16,109,0,0,152,136,0,0,0,0,0,0,0,0,0,0,200,109,0,0,152,136,0,0,0,0,0,0,0,0,0,0,128,110,0,0,64,135,0,0,0,0,0,0,0,0,0,0,40,111,0,0,80,134,0,0,0,0,0,0,0,0,0,0,176,111,0,0,24,137,0,0,0,0,0,0,0,0,0,0,80,112,0,0,24,137,0,0,0,0,0,0,0,0,0,0,240,112,0,0,72,135,0,0,0,0,0,0,0,0,0,0,128,113,0,0,32,136,0,0,0,0,0,0,0,0,0,0,232,113,0,0,32,136,0,0,0,0,0,0,0,0,0,0,72,114,0,0,0,0,0,0,88,114,0,0,0,0,0,0,104,114,0,0,56,134,0,0,0,0,0,0,0,0,0,0,120,114,0,0,0,0,0,0,144,114,0,0,0,0,0,0,192,114,0,0,96,136,0,0,0,0,0,0,0,0,0,0,248,114,0,0,96,136,0,0,0,0,0,0,0,0,0,0,56,115,0,0,96,136,0,0,0,0,0,0,0,0,0,0,112,115,0,0,96,136,0,0,0,0,0,0,0,0,0,0,168,115,0,0,96,136,0,0,0,0,0,0,0,0,0,0,216,115,0,0,96,136,0,0,0,0,0,0,0,0,0,0,16,116,0,0,96,136,0,0,0,0,0,0,0,0,0,0,64,116,0,0,96,136,0,0,0,0,0,0,0,0,0,0,112,116,0,0,0,0,0,0,160,116,0,0,96,136,0,0,0,0,0,0,0,0,0,0,200,116,0,0,96,136,0,0,0,0,0,0,0,0,0,0,240,116,0,0,64,135,0,0,0,0,0,0,0,0,0,0,40,117,0,0,72,135,0,0,0,0,0,0,0,0,0,0,88,117,0,0,72,135,0,0,0,0,0,0,0,0,0,0,136,117,0,0,0,0,0,0,184,117,0,0,0,0,0,0,232,117,0,0,0,0,0,0,16,118,0,0,0,0,0,0,48,118,0,0,120,135,0,0,0,0,0,0,0,0,0,0,88,118,0,0,120,135,0,0,0,0,0,0,0,0,0,0,128,118,0,0,136,135,0,0,0,0,0,0,0,0,0,0,168,118,0,0,48,134,0,0,0,0,0,0,0,0,0,0,208,118,0,0,0,0,0,0,248,118,0,0,64,140,0,0,0,0,0,0,0,0,0,0,32,119,0,0,104,136,0,0,0,0,0,0,0,0,0,0,72,119,0,0,224,137,0,0,0,0,0,0,0,0,0,0,112,119,0,0,8,135,0,0,0,0,0,0,0,0,0,0,152,119,0,0,88,136,0,0,0,0,0,0,0,0,0,0,192,119,0,0,104,136,0,0,0,0,0,0,0,0,0,0,232,119,0,0,104,136,0,0,0,0,0,0,0,0,0,0,16,120,0,0,248,138,0,0,0,0,0,0,0,0,0,0,56,120,0,0,0,0,0,0,96,120,0,0,184,137,0,0,0,0,0,0,0,0,0,0,136,120,0,0,80,139,0,0,0,0,0,0,0,0,0,0,176,120,0,0,88,136,0,0,0,0,0,0,0,0,0,0,216,120,0,0,0,0,0,0,0,121,0,0,0,0,0,0,40,121,0,0,80,139,0,0,0,0,0,0,0,0,0,0,80,121,0,0,0,138,0,0,0,0,0,0,0,0,0,0,112,121,0,0,56,135,0,0,0,0,0,0,0,0,0,0,144,121,0,0,208,139,0,0,0,0,0,0,0,0,0,0,176,121,0,0,32,142,0,0,0,0,0,0,0,0,0,0,208,121,0,0,112,138,0,0,0,0,0,0,0,0,0,0,240,121,0,0,104,136,0,0,0,0,0,0,0,0,0,0,16,122,0,0,152,142,0,0,0,0,0,0,0,0,0,0,48,122,0,0,200,137,0,0,0,0,0,0,0,0,0,0,80,122,0,0,104,136,0,0,0,0,0,0,0,0,0,0,112,122,0,0,32,136,0,0,0,0,0,0,0,0,0,0,144,122,0,0,208,139,0,0,0,0,0,0,0,0,0,0,176,122,0,0,0,0,0,0,208,122,0,0,0,0,0,0,240,122,0,0,32,142,0,0,0,0,0,0,0,0,0,0,16,123,0,0,200,139,0,0,0,0,0,0,0,0,0,0,48,123,0,0,192,135,0,0,0,0,0,0,0,0,0,0,80,123,0,0,16,138,0,0,0,0,0,0,0,0,0,0,112,123,0,0,208,139,0,0,0,0,0,0,0,0,0,0,144,123,0,0,248,140,0,0,0,0,0,0,0,0,0,0,176,123,0,0,96,142,0,0,0,0,0,0,0,0,0,0,208,123,0,0,208,139,0,0,0,0,0,0,0,0,0,0,240,123,0,0,0,0,0,0,16,124,0,0,0,0,0,0,48,124,0,0,0,0,0,0,80,124,0,0,192,137,0,0,0,0,0,0,0,0,0,0,112,124,0,0,248,138,0,0,0,0,0,0,0,0,0,0,144,124,0,0,72,140,0,0,0,0,0,0,0,0,0,0,176,124,0,0,72,140,0,0,0,0,0,0,0,0,0,0,208,124,0,0,168,141,0,0,0,0,0,0,0,0,0,0,240,124,0,0,104,136,0,0,0,0,0,0,0,0,0,0,16,125,0,0,96,140,0,0,0,0,0,0,0,0,0,0,48,125,0,0,192,137,0,0,0,0,0,0,0,0,0,0,80,125,0,0,248,140,0,0,0,0,0,0,0,0,0,0,112,125,0,0,152,142,0,0,0,0,0,0,0,0,0,0,144,125,0,0,48,137,0,0,0,0,0,0,0,0,0,0,176,125,0,0,80,134,0,0,0,0,0,0,0,0,0,0,208,125,0,0,136,139,0,0,0,0,0,0,0,0,0,0,240,125,0,0,152,135,0,0,0,0,0,0,0,0,0,0,16,126,0,0,0,138,0,0,0,0,0,0,0,0,0,0,40,126,0,0,112,142,0,0,0,0,0,0,0,0,0,0,64,126,0,0,64,138,0,0,0,0,0,0,0,0,0,0,88,126,0,0,168,141,0,0,0,0,0,0,0,0,0,0,112,126,0,0,0,0,0,0,136,126,0,0,112,142,0,0,0,0,0,0,0,0,0,0,160,126,0,0,72,140,0,0,0,0,0,0,0,0,0,0,184,126,0,0,144,142,0,0,0,0,0,0,0,0,0,0,208,126,0,0,0,0,0,0,232,126,0,0,208,139,0,0,0,0,0,0,0,0,0,0,0,127,0,0,88,142,0,0,0,0,0,0,0,0,0,0,24,127,0,0,0,0,0,0,48,127,0,0,40,139,0,0,0,0,0,0,0,0,0,0,80,127,0,0,40,139,0,0,0,0,0,0,0,0,0,0,112,127,0,0,80,134,0,0,0,0,0,0,0,0,0,0,136,127,0,0,32,142,0,0,0,0,0,0,0,0,0,0,160,127,0,0,64,138,0,0,0,0,0,0,0,0,0,0,184,127,0,0,48,137,0,0,0,0,0,0,0,0,0,0,208,127,0,0,80,134,0,0,0,0,0,0,0,0,0,0,232,127,0,0,0,0,0,0,0,128,0,0,0,0,0,0,24,128,0,0,32,142,0,0,0,0,0,0,0,0,0,0,48,128,0,0,72,140,0,0,0,0,0,0,0,0,0,0,72,128,0,0,40,139,0,0,0,0,0,0,0,0,0,0,96,128,0,0,16,136,0,0,0,0,0,0,0,0,0,0,120,128,0,0,120,136,0,0,0,0,0,0,0,0,0,0,144,128,0,0,80,134,0,0,0,0,0,0,0,0,0,0,168,128,0,0,0,0,0,0,192,128,0,0,128,76,0,0,216,128,0,0,0,0,0,0,1,0,0,0,64,142,0,0,2,4,0,0,0,0,0,0,240,128,0,0,0,0,0,0,8,129,0,0,72,140,0,0,0,0,0,0,0,0,0,0,32,129,0,0,152,135,0,0,0,0,0,0,0,0,0,0,56,129,0,0,192,135,0,0,0,0,0,0,0,0,0,0,80,129,0,0,0,0,0,0,104,129,0,0,0,0,0,0,128,129,0,0,104,139,0,0,0,0,0,0,128,76,0,0,152,129,0,0,0,0,0,0,2,0,0,0,208,139,0,0,2,0,0,0,32,136,0,0,2,4,0,0,0,0,0,0,176,129,0,0,160,140,0,0,0,0,0,0,0,0,0,0,200,129,0,0,88,134,0,0,0,0,0,0,0,0,0,0,224,129,0,0,88,134,0,0,0,0,0,0,0,0,0,0,248,129,0,0,80,139,0,0,0,0,0,0,0,0,0,0,16,130,0,0,40,139,0,0,0,0,0,0,0,0,0,0,40,130,0,0,184,141,0,0,0,0,0,0,0,0,0,0,64,130,0,0,184,141,0,0,0,0,0,0,0,0,0,0,88,130,0,0,0,0,0,0,112,130,0,0,0,0,0,0,136,130,0,0,152,135,0,0,0,0,0,0,0,0,0,0,160,130,0,0,192,135,0,0,0,0,0,0,0,0,0,0,184,130,0,0,224,137,0,0,0,0,0,0,0,0,0,0,208,130,0,0,112,138,0,0,0,0,0,0,0,0,0,0,232,130,0,0,152,142,0,0,0,0,0,0,0,0,0,0,0,131,0,0,72,141,0,0,0,0,0,0,0,0,0,0,24,131,0,0,248,138,0,0,0,0,0,0,0,0,0,0,48,131,0,0,80,141,0,0,0,0,0,0,0,0,0,0,72,131,0,0,48,142,0,0,0,0,0,0,0,0,0,0,96,131,0,0,48,142,0,0,0,0,0,0,0,0,0,0,120,131,0,0,232,136,0,0,0,0,0,0,0,0,0,0,144,131,0,0,0,0,0,0,168,131,0,0,8,142,0,0,0,0,0,0,0,0,0,0,192,131,0,0,80,141,0,0,0,0,0,0,0,0,0,0,216,131,0,0,248,138,0,0,0,0,0,0,0,0,0,0,240,131,0,0,0,0,0,0,0,132,0,0,248,138,0,0,0,0,0,0,0,0,0,0,16,132,0,0,0,0,0,0,32,132,0,0,152,140,0,0,0,0,0,0,0,0,0,0,48,132,0,0,80,141,0,0,0,0,0,0,0,0,0,0,64,132,0,0,32,142,0,0,0,0,0,0,0,0,0,0,80,132,0,0,0,0,0,0,96,132,0,0,0,0,0,0,112,132,0,0,224,142,0,0,0,0,0,0,0,0,0,0,128,132,0,0,224,142,0,0,0,0,0,0,0,0,0,0,144,132,0,0,88,139,0,0,0,0,0,0,0,0,0,0,160,132,0,0,152,140,0,0,0,0,0,0,0,0,0,0,176,132,0,0,248,138,0,0,0,0,0,0,0,0,0,0,192,132,0,0,224,137,0,0,0,0,0,0,160,167,0,0,0,0,0,0])
, "i8", ALLOC_NONE, Runtime.GLOBAL_BASE)
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);
function copyTempFloat(ptr) { // functions, because inlining this code increases code size too much
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
}
function copyTempDouble(ptr) {
  HEAP8[tempDoublePtr] = HEAP8[ptr];
  HEAP8[tempDoublePtr+1] = HEAP8[ptr+1];
  HEAP8[tempDoublePtr+2] = HEAP8[ptr+2];
  HEAP8[tempDoublePtr+3] = HEAP8[ptr+3];
  HEAP8[tempDoublePtr+4] = HEAP8[ptr+4];
  HEAP8[tempDoublePtr+5] = HEAP8[ptr+5];
  HEAP8[tempDoublePtr+6] = HEAP8[ptr+6];
  HEAP8[tempDoublePtr+7] = HEAP8[ptr+7];
}
  function ___gxx_personality_v0() {
    }
  function ___cxa_guard_acquire(variable) {
      if (!HEAP8[(variable)]) { // ignore SAFE_HEAP stuff because llvm mixes i64 and i8 here
        HEAP8[(variable)]=1;
        return 1;
      }
      return 0;
    }
  function ___cxa_guard_abort() {}
  function ___cxa_guard_release() {}
  Module["_memcpy"] = _memcpy;var _llvm_memcpy_p0i8_p0i8_i32=_memcpy;
  function __exit(status) {
      // void _exit(int status);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/exit.html
      Module.print('exit(' + status + ') called');
      Module['exit'](status);
    }function _exit(status) {
      __exit(status);
    }function __ZSt9terminatev() {
      _exit(-1234);
    }
  function __ZN20btAxisSweep3InternalItE26processAllOverlappingPairsEP17btOverlapCallback() {
  Module['printErr']('missing function: _ZN20btAxisSweep3InternalItE26processAllOverlappingPairsEP17btOverlapCallback'); abort(-1);
  }
  function __ZN20btAxisSweep3InternalIjE26processAllOverlappingPairsEP17btOverlapCallback() {
  Module['printErr']('missing function: _ZN20btAxisSweep3InternalIjE26processAllOverlappingPairsEP17btOverlapCallback'); abort(-1);
  }
  function ___cxa_pure_virtual() {
      ABORT = true;
      throw 'Pure virtual function called!';
    }
  var _sqrtf=Math.sqrt;
  var _acosf=Math.acos;
  var _sinf=Math.sin;
  var _cosf=Math.cos;
  var _llvm_pow_f32=Math.pow;
  function _fmod(x, y) {
      return x % y;
    }var _fmodf=_fmod;
  var _fabsf=Math.abs;
  var _asinf=Math.asin;
  var _atan2f=Math.atan2;
  Module["_memset"] = _memset;var _llvm_memset_p0i8_i64=_memset;
  function _llvm_lifetime_start() {}
  function _llvm_lifetime_end() {}
  var ERRNO_CODES={EPERM:1,ENOENT:2,ESRCH:3,EINTR:4,EIO:5,ENXIO:6,E2BIG:7,ENOEXEC:8,EBADF:9,ECHILD:10,EAGAIN:11,EWOULDBLOCK:11,ENOMEM:12,EACCES:13,EFAULT:14,ENOTBLK:15,EBUSY:16,EEXIST:17,EXDEV:18,ENODEV:19,ENOTDIR:20,EISDIR:21,EINVAL:22,ENFILE:23,EMFILE:24,ENOTTY:25,ETXTBSY:26,EFBIG:27,ENOSPC:28,ESPIPE:29,EROFS:30,EMLINK:31,EPIPE:32,EDOM:33,ERANGE:34,ENOMSG:35,EIDRM:36,ECHRNG:37,EL2NSYNC:38,EL3HLT:39,EL3RST:40,ELNRNG:41,EUNATCH:42,ENOCSI:43,EL2HLT:44,EDEADLK:45,ENOLCK:46,EBADE:50,EBADR:51,EXFULL:52,ENOANO:53,EBADRQC:54,EBADSLT:55,EDEADLOCK:56,EBFONT:57,ENOSTR:60,ENODATA:61,ETIME:62,ENOSR:63,ENONET:64,ENOPKG:65,EREMOTE:66,ENOLINK:67,EADV:68,ESRMNT:69,ECOMM:70,EPROTO:71,EMULTIHOP:74,EDOTDOT:76,EBADMSG:77,ENOTUNIQ:80,EBADFD:81,EREMCHG:82,ELIBACC:83,ELIBBAD:84,ELIBSCN:85,ELIBMAX:86,ELIBEXEC:87,ENOSYS:88,ENOTEMPTY:90,ENAMETOOLONG:91,ELOOP:92,EOPNOTSUPP:95,EPFNOSUPPORT:96,ECONNRESET:104,ENOBUFS:105,EAFNOSUPPORT:106,EPROTOTYPE:107,ENOTSOCK:108,ENOPROTOOPT:109,ESHUTDOWN:110,ECONNREFUSED:111,EADDRINUSE:112,ECONNABORTED:113,ENETUNREACH:114,ENETDOWN:115,ETIMEDOUT:116,EHOSTDOWN:117,EHOSTUNREACH:118,EINPROGRESS:119,EALREADY:120,EDESTADDRREQ:121,EMSGSIZE:122,EPROTONOSUPPORT:123,ESOCKTNOSUPPORT:124,EADDRNOTAVAIL:125,ENETRESET:126,EISCONN:127,ENOTCONN:128,ETOOMANYREFS:129,EUSERS:131,EDQUOT:132,ESTALE:133,ENOTSUP:134,ENOMEDIUM:135,EILSEQ:138,EOVERFLOW:139,ECANCELED:140,ENOTRECOVERABLE:141,EOWNERDEAD:142,ESTRPIPE:143};
  var ERRNO_MESSAGES={0:"Success",1:"Not super-user",2:"No such file or directory",3:"No such process",4:"Interrupted system call",5:"I/O error",6:"No such device or address",7:"Arg list too long",8:"Exec format error",9:"Bad file number",10:"No children",11:"No more processes",12:"Not enough core",13:"Permission denied",14:"Bad address",15:"Block device required",16:"Mount device busy",17:"File exists",18:"Cross-device link",19:"No such device",20:"Not a directory",21:"Is a directory",22:"Invalid argument",23:"Too many open files in system",24:"Too many open files",25:"Not a typewriter",26:"Text file busy",27:"File too large",28:"No space left on device",29:"Illegal seek",30:"Read only file system",31:"Too many links",32:"Broken pipe",33:"Math arg out of domain of func",34:"Math result not representable",35:"No message of desired type",36:"Identifier removed",37:"Channel number out of range",38:"Level 2 not synchronized",39:"Level 3 halted",40:"Level 3 reset",41:"Link number out of range",42:"Protocol driver not attached",43:"No CSI structure available",44:"Level 2 halted",45:"Deadlock condition",46:"No record locks available",50:"Invalid exchange",51:"Invalid request descriptor",52:"Exchange full",53:"No anode",54:"Invalid request code",55:"Invalid slot",56:"File locking deadlock error",57:"Bad font file fmt",60:"Device not a stream",61:"No data (for no delay io)",62:"Timer expired",63:"Out of streams resources",64:"Machine is not on the network",65:"Package not installed",66:"The object is remote",67:"The link has been severed",68:"Advertise error",69:"Srmount error",70:"Communication error on send",71:"Protocol error",74:"Multihop attempted",76:"Cross mount point (not really error)",77:"Trying to read unreadable message",80:"Given log. name not unique",81:"f.d. invalid for this operation",82:"Remote address changed",83:"Can   access a needed shared lib",84:"Accessing a corrupted shared lib",85:".lib section in a.out corrupted",86:"Attempting to link in too many libs",87:"Attempting to exec a shared library",88:"Function not implemented",90:"Directory not empty",91:"File or path name too long",92:"Too many symbolic links",95:"Operation not supported on transport endpoint",96:"Protocol family not supported",104:"Connection reset by peer",105:"No buffer space available",106:"Address family not supported by protocol family",107:"Protocol wrong type for socket",108:"Socket operation on non-socket",109:"Protocol not available",110:"Can't send after socket shutdown",111:"Connection refused",112:"Address already in use",113:"Connection aborted",114:"Network is unreachable",115:"Network interface is not configured",116:"Connection timed out",117:"Host is down",118:"Host is unreachable",119:"Connection already in progress",120:"Socket already connected",121:"Destination address required",122:"Message too long",123:"Unknown protocol",124:"Socket type not supported",125:"Address not available",126:"Connection reset by network",127:"Socket is already connected",128:"Socket is not connected",129:"Too many references",131:"Too many users",132:"Quota exceeded",133:"Stale file handle",134:"Not supported",135:"No medium (in tape drive)",138:"Illegal byte sequence",139:"Value too large for defined data type",140:"Operation canceled",141:"State not recoverable",142:"Previous owner died",143:"Streams pipe error"};
  var ___errno_state=0;function ___setErrNo(value) {
      // For convenient setting and returning of errno.
      HEAP32[((___errno_state)>>2)]=value
      return value;
    }
  var VFS=undefined;
  var PATH={splitPath:function (filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1);
      },normalizeArray:function (parts, allowAboveRoot) {
        // if the path tries to go above the root, `up` ends up > 0
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
          var last = parts[i];
          if (last === '.') {
            parts.splice(i, 1);
          } else if (last === '..') {
            parts.splice(i, 1);
            up++;
          } else if (up) {
            parts.splice(i, 1);
            up--;
          }
        }
        // if the path is allowed to go above the root, restore leading ..s
        if (allowAboveRoot) {
          for (; up--; up) {
            parts.unshift('..');
          }
        }
        return parts;
      },normalize:function (path) {
        var isAbsolute = path.charAt(0) === '/',
            trailingSlash = path.substr(-1) === '/';
        // Normalize the path
        path = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), !isAbsolute).join('/');
        if (!path && !isAbsolute) {
          path = '.';
        }
        if (path && trailingSlash) {
          path += '/';
        }
        return (isAbsolute ? '/' : '') + path;
      },dirname:function (path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
          // No dirname whatsoever
          return '.';
        }
        if (dir) {
          // It has a dirname, strip trailing slash
          dir = dir.substr(0, dir.length - 1);
        }
        return root + dir;
      },basename:function (path, ext) {
        // EMSCRIPTEN return '/'' for '/', not an empty string
        if (path === '/') return '/';
        var f = PATH.splitPath(path)[2];
        if (ext && f.substr(-1 * ext.length) === ext) {
          f = f.substr(0, f.length - ext.length);
        }
        return f;
      },join:function () {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.filter(function(p, index) {
          if (typeof p !== 'string') {
            throw new TypeError('Arguments to path.join must be strings');
          }
          return p;
        }).join('/'));
      },resolve:function () {
        var resolvedPath = '',
          resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
          var path = (i >= 0) ? arguments[i] : FS.cwd();
          // Skip empty and invalid entries
          if (typeof path !== 'string') {
            throw new TypeError('Arguments to path.resolve must be strings');
          } else if (!path) {
            continue;
          }
          resolvedPath = path + '/' + resolvedPath;
          resolvedAbsolute = path.charAt(0) === '/';
        }
        // At this point the path should be resolved to a full absolute path, but
        // handle relative paths to be safe (might happen when process.cwd() fails)
        resolvedPath = PATH.normalizeArray(resolvedPath.split('/').filter(function(p) {
          return !!p;
        }), !resolvedAbsolute).join('/');
        return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
      },relative:function (from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);
        function trim(arr) {
          var start = 0;
          for (; start < arr.length; start++) {
            if (arr[start] !== '') break;
          }
          var end = arr.length - 1;
          for (; end >= 0; end--) {
            if (arr[end] !== '') break;
          }
          if (start > end) return [];
          return arr.slice(start, end - start + 1);
        }
        var fromParts = trim(from.split('/'));
        var toParts = trim(to.split('/'));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
          if (fromParts[i] !== toParts[i]) {
            samePartsLength = i;
            break;
          }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
          outputParts.push('..');
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join('/');
      }};
  var TTY={ttys:[],register:function (dev, ops) {
        TTY.ttys[dev] = { input: [], output: [], ops: ops };
        FS.registerDevice(dev, TTY.stream_ops);
      },stream_ops:{open:function (stream) {
          // this wouldn't be required if the library wasn't eval'd at first...
          if (!TTY.utf8) {
            TTY.utf8 = new Runtime.UTF8Processor();
          }
          var tty = TTY.ttys[stream.node.rdev];
          if (!tty) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          stream.tty = tty;
          stream.seekable = false;
        },close:function (stream) {
          // flush any pending line data
          if (stream.tty.output.length) {
            stream.tty.ops.put_char(stream.tty, 10);
          }
        },read:function (stream, buffer, offset, length, pos /* ignored */) {
          if (!stream.tty || !stream.tty.ops.get_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          var bytesRead = 0;
          for (var i = 0; i < length; i++) {
            var result;
            try {
              result = stream.tty.ops.get_char(stream.tty);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            if (result === undefined && bytesRead === 0) {
              throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
            }
            if (result === null || result === undefined) break;
            bytesRead++;
            buffer[offset+i] = result;
          }
          if (bytesRead) {
            stream.node.timestamp = Date.now();
          }
          return bytesRead;
        },write:function (stream, buffer, offset, length, pos) {
          if (!stream.tty || !stream.tty.ops.put_char) {
            throw new FS.ErrnoError(ERRNO_CODES.ENXIO);
          }
          for (var i = 0; i < length; i++) {
            try {
              stream.tty.ops.put_char(stream.tty, buffer[offset+i]);
            } catch (e) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
          }
          if (length) {
            stream.node.timestamp = Date.now();
          }
          return i;
        }},default_tty_ops:{get_char:function (tty) {
          if (!tty.input.length) {
            var result = null;
            if (ENVIRONMENT_IS_NODE) {
              if (process.stdin.destroyed) {
                return undefined;
              }
              result = process.stdin.read();
            } else if (typeof window != 'undefined' &&
              typeof window.prompt == 'function') {
              // Browser.
              result = window.prompt('Input: ');  // returns null on cancel
              if (result !== null) {
                result += '\n';
              }
            } else if (typeof readline == 'function') {
              // Command line.
              result = readline();
              if (result !== null) {
                result += '\n';
              }
            }
            if (!result) {
              return null;
            }
            tty.input = intArrayFromString(result, true);
          }
          return tty.input.shift();
        },put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['print'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }},default_tty1_ops:{put_char:function (tty, val) {
          if (val === null || val === 10) {
            Module['printErr'](tty.output.join(''));
            tty.output = [];
          } else {
            tty.output.push(TTY.utf8.processCChar(val));
          }
        }}};
  var MEMFS={CONTENT_OWNING:1,CONTENT_FLEXIBLE:2,CONTENT_FIXED:3,ensureFlexible:function (node) {
        if (node.contentMode !== MEMFS.CONTENT_FLEXIBLE) {
          var contents = node.contents;
          node.contents = Array.prototype.slice.call(contents);
          if (node.contentMode === MEMFS.CONTENT_OWNING) {
            assert(contents.byteOffset);
            Module['_free'](contents.byteOffset);
          }
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        }
      },mount:function (mount) {
        return MEMFS.create_node(null, '/', 0040000 | 0777, 0);
      },create_node:function (parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
          // no supported
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            lookup: MEMFS.node_ops.lookup,
            mknod: MEMFS.node_ops.mknod,
            mknod: MEMFS.node_ops.mknod,
            rename: MEMFS.node_ops.rename,
            unlink: MEMFS.node_ops.unlink,
            rmdir: MEMFS.node_ops.rmdir,
            readdir: MEMFS.node_ops.readdir,
            symlink: MEMFS.node_ops.symlink
          };
          node.stream_ops = {
            llseek: MEMFS.stream_ops.llseek
          };
          node.contents = {};
        } else if (FS.isFile(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          };
          node.stream_ops = {
            llseek: MEMFS.stream_ops.llseek,
            read: MEMFS.stream_ops.read,
            write: MEMFS.stream_ops.write,
            allocate: MEMFS.stream_ops.allocate,
            mmap: MEMFS.stream_ops.mmap
          };
          node.contents = [];
          node.contentMode = MEMFS.CONTENT_FLEXIBLE;
        } else if (FS.isLink(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr,
            readlink: MEMFS.node_ops.readlink
          };
          node.stream_ops = {};
        } else if (FS.isChrdev(node.mode)) {
          node.node_ops = {
            getattr: MEMFS.node_ops.getattr,
            setattr: MEMFS.node_ops.setattr
          };
          node.stream_ops = FS.chrdev_stream_ops;
        }
        node.timestamp = Date.now();
        // add the new node to the parent
        if (parent) {
          parent.contents[name] = node;
        }
        return node;
      },node_ops:{getattr:function (node) {
          var attr = {};
          // device numbers reuse inode numbers.
          attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
          attr.ino = node.id;
          attr.mode = node.mode;
          attr.nlink = 1;
          attr.uid = 0;
          attr.gid = 0;
          attr.rdev = node.rdev;
          if (FS.isDir(node.mode)) {
            attr.size = 4096;
          } else if (FS.isFile(node.mode)) {
            attr.size = node.contents.length;
          } else if (FS.isLink(node.mode)) {
            attr.size = node.link.length;
          } else {
            attr.size = 0;
          }
          attr.atime = new Date(node.timestamp);
          attr.mtime = new Date(node.timestamp);
          attr.ctime = new Date(node.timestamp);
          // NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
          //       but this is not required by the standard.
          attr.blksize = 4096;
          attr.blocks = Math.ceil(attr.size / attr.blksize);
          return attr;
        },setattr:function (node, attr) {
          if (attr.mode !== undefined) {
            node.mode = attr.mode;
          }
          if (attr.timestamp !== undefined) {
            node.timestamp = attr.timestamp;
          }
          if (attr.size !== undefined) {
            MEMFS.ensureFlexible(node);
            var contents = node.contents;
            if (attr.size < contents.length) contents.length = attr.size;
            else while (attr.size > contents.length) contents.push(0);
          }
        },lookup:function (parent, name) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        },mknod:function (parent, name, mode, dev) {
          return MEMFS.create_node(parent, name, mode, dev);
        },rename:function (old_node, new_dir, new_name) {
          // if we're overwriting a directory at new_name, make sure it's empty.
          if (FS.isDir(old_node.mode)) {
            var new_node;
            try {
              new_node = FS.lookupNode(new_dir, new_name);
            } catch (e) {
            }
            if (new_node) {
              for (var i in new_node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
              }
            }
          }
          // do the internal rewiring
          delete old_node.parent.contents[old_node.name];
          old_node.name = new_name;
          new_dir.contents[new_name] = old_node;
        },unlink:function (parent, name) {
          delete parent.contents[name];
        },rmdir:function (parent, name) {
          var node = FS.lookupNode(parent, name);
          for (var i in node.contents) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
          }
          delete parent.contents[name];
        },readdir:function (node) {
          var entries = ['.', '..']
          for (var key in node.contents) {
            if (!node.contents.hasOwnProperty(key)) {
              continue;
            }
            entries.push(key);
          }
          return entries;
        },symlink:function (parent, newname, oldpath) {
          var node = MEMFS.create_node(parent, newname, 0777 | 0120000, 0);
          node.link = oldpath;
          return node;
        },readlink:function (node) {
          if (!FS.isLink(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          return node.link;
        }},stream_ops:{read:function (stream, buffer, offset, length, position) {
          var contents = stream.node.contents;
          var size = Math.min(contents.length - position, length);
          if (size > 8 && contents.subarray) { // non-trivial, and typed array
            buffer.set(contents.subarray(position, position + size), offset);
          } else
          {
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          }
          return size;
        },write:function (stream, buffer, offset, length, position, canOwn) {
          var node = stream.node;
          node.timestamp = Date.now();
          var contents = node.contents;
          if (length && contents.length === 0 && position === 0 && buffer.subarray) {
            // just replace it with the new data
            assert(buffer.length);
            if (canOwn && buffer.buffer === HEAP8.buffer && offset === 0) {
              node.contents = buffer; // this is a subarray of the heap, and we can own it
              node.contentMode = MEMFS.CONTENT_OWNING;
            } else {
              node.contents = new Uint8Array(buffer.subarray(offset, offset+length));
              node.contentMode = MEMFS.CONTENT_FIXED;
            }
            return length;
          }
          MEMFS.ensureFlexible(node);
          var contents = node.contents;
          while (contents.length < position) contents.push(0);
          for (var i = 0; i < length; i++) {
            contents[position + i] = buffer[offset + i];
          }
          return length;
        },llseek:function (stream, offset, whence) {
          var position = offset;
          if (whence === 1) {  // SEEK_CUR.
            position += stream.position;
          } else if (whence === 2) {  // SEEK_END.
            if (FS.isFile(stream.node.mode)) {
              position += stream.node.contents.length;
            }
          }
          if (position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
          }
          stream.ungotten = [];
          stream.position = position;
          return position;
        },allocate:function (stream, offset, length) {
          MEMFS.ensureFlexible(stream.node);
          var contents = stream.node.contents;
          var limit = offset + length;
          while (limit > contents.length) contents.push(0);
        },mmap:function (stream, buffer, offset, length, position, prot, flags) {
          if (!FS.isFile(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
          }
          var ptr;
          var allocated;
          var contents = stream.node.contents;
          // Only make a new copy when MAP_PRIVATE is specified.
          if ( !(flags & 0x02) &&
                (contents.buffer === buffer || contents.buffer === buffer.buffer) ) {
            // We can't emulate MAP_SHARED when the file is not backed by the buffer
            // we're mapping to (e.g. the HEAP buffer).
            allocated = false;
            ptr = contents.byteOffset;
          } else {
            // Try to avoid unnecessary slices.
            if (position > 0 || position + length < contents.length) {
              if (contents.subarray) {
                contents = contents.subarray(position, position + length);
              } else {
                contents = Array.prototype.slice.call(contents, position, position + length);
              }
            }
            allocated = true;
            ptr = _malloc(length);
            if (!ptr) {
              throw new FS.ErrnoError(ERRNO_CODES.ENOMEM);
            }
            buffer.set(contents, ptr);
          }
          return { ptr: ptr, allocated: allocated };
        }}};
  var _stdin=allocate(1, "i32*", ALLOC_STATIC);
  var _stdout=allocate(1, "i32*", ALLOC_STATIC);
  var _stderr=allocate(1, "i32*", ALLOC_STATIC);
  function _fflush(stream) {
      // int fflush(FILE *stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fflush.html
      // we don't currently perform any user-space buffering of data
    }var FS={root:null,nodes:[null],devices:[null],streams:[null],nextInode:1,name_table:null,currentPath:"/",initialized:false,ignorePermissions:true,ErrnoError:function ErrnoError(errno) {
          this.errno = errno;
          for (var key in ERRNO_CODES) {
            if (ERRNO_CODES[key] === errno) {
              this.code = key;
              break;
            }
          }
          this.message = ERRNO_MESSAGES[errno];
        },handleFSError:function (e) {
        if (!(e instanceof FS.ErrnoError)) throw e + ' : ' + new Error().stack;
        return ___setErrNo(e.errno);
      },hashName:function (parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
          hash = ((hash << 5) - hash + name.charCodeAt(i)) | 0;
        }
        return ((parentid + hash) >>> 0) % FS.name_table.length;
      },hashAddNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.name_table[hash];
        FS.name_table[hash] = node;
      },hashRemoveNode:function (node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.name_table[hash] === node) {
          FS.name_table[hash] = node.name_next;
        } else {
          var current = FS.name_table[hash];
          while (current) {
            if (current.name_next === node) {
              current.name_next = node.name_next;
              break;
            }
            current = current.name_next;
          }
        }
      },lookupNode:function (parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.name_table[hash]; node; node = node.name_next) {
          if (node.parent.id === parent.id && node.name === name) {
            return node;
          }
        }
        // if we failed to find it in the cache, call into the VFS
        return FS.lookup(parent, name);
      },createNode:function (parent, name, mode, rdev) {
        var node = {
          id: FS.nextInode++,
          name: name,
          mode: mode,
          node_ops: {},
          stream_ops: {},
          rdev: rdev,
          parent: null,
          mount: null
        };
        if (!parent) {
          parent = node;  // root node sets parent to itself
        }
        node.parent = parent;
        node.mount = parent.mount;
        // compatibility
        var readMode = 292 | 73;
        var writeMode = 146;
        // NOTE we must use Object.defineProperties instead of individual calls to
        // Object.defineProperty in order to make closure compiler happy
        Object.defineProperties(node, {
          read: {
            get: function() { return (node.mode & readMode) === readMode; },
            set: function(val) { val ? node.mode |= readMode : node.mode &= ~readMode; }
          },
          write: {
            get: function() { return (node.mode & writeMode) === writeMode; },
            set: function(val) { val ? node.mode |= writeMode : node.mode &= ~writeMode; }
          },
          isFolder: {
            get: function() { return FS.isDir(node.mode); },
          },
          isDevice: {
            get: function() { return FS.isChrdev(node.mode); },
          },
        });
        FS.hashAddNode(node);
        return node;
      },destroyNode:function (node) {
        FS.hashRemoveNode(node);
      },isRoot:function (node) {
        return node === node.parent;
      },isMountpoint:function (node) {
        return node.mounted;
      },isFile:function (mode) {
        return (mode & 0170000) === 0100000;
      },isDir:function (mode) {
        return (mode & 0170000) === 0040000;
      },isLink:function (mode) {
        return (mode & 0170000) === 0120000;
      },isChrdev:function (mode) {
        return (mode & 0170000) === 0020000;
      },isBlkdev:function (mode) {
        return (mode & 0170000) === 0060000;
      },isFIFO:function (mode) {
        return (mode & 0170000) === 0010000;
      },cwd:function () {
        return FS.currentPath;
      },lookupPath:function (path, opts) {
        path = PATH.resolve(FS.currentPath, path);
        opts = opts || { recurse_count: 0 };
        if (opts.recurse_count > 8) {  // max recursive lookup of 8
          throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
        }
        // split the path
        var parts = PATH.normalizeArray(path.split('/').filter(function(p) {
          return !!p;
        }), false);
        // start at the root
        var current = FS.root;
        var current_path = '/';
        for (var i = 0; i < parts.length; i++) {
          var islast = (i === parts.length-1);
          if (islast && opts.parent) {
            // stop resolving
            break;
          }
          current = FS.lookupNode(current, parts[i]);
          current_path = PATH.join(current_path, parts[i]);
          // jump to the mount's root node if this is a mountpoint
          if (FS.isMountpoint(current)) {
            current = current.mount.root;
          }
          // follow symlinks
          // by default, lookupPath will not follow a symlink if it is the final path component.
          // setting opts.follow = true will override this behavior.
          if (!islast || opts.follow) {
            var count = 0;
            while (FS.isLink(current.mode)) {
              var link = FS.readlink(current_path);
              current_path = PATH.resolve(PATH.dirname(current_path), link);
              var lookup = FS.lookupPath(current_path, { recurse_count: opts.recurse_count });
              current = lookup.node;
              if (count++ > 40) {  // limit max consecutive symlinks to 40 (SYMLOOP_MAX).
                throw new FS.ErrnoError(ERRNO_CODES.ELOOP);
              }
            }
          }
        }
        return { path: current_path, node: current };
      },getPath:function (node) {
        var path;
        while (true) {
          if (FS.isRoot(node)) {
            return path ? PATH.join(node.mount.mountpoint, path) : node.mount.mountpoint;
          }
          path = path ? PATH.join(node.name, path) : node.name;
          node = node.parent;
        }
      },flagModes:{"r":0,"rs":8192,"r+":2,"w":1537,"wx":3585,"xw":3585,"w+":1538,"wx+":3586,"xw+":3586,"a":521,"ax":2569,"xa":2569,"a+":522,"ax+":2570,"xa+":2570},modeStringToFlags:function (str) {
        var flags = FS.flagModes[str];
        if (typeof flags === 'undefined') {
          throw new Error('Unknown file open mode: ' + str);
        }
        return flags;
      },flagsToPermissionString:function (flag) {
        var accmode = flag & 3;
        var perms = ['r', 'w', 'rw'][accmode];
        if ((flag & 1024)) {
          perms += 'w';
        }
        return perms;
      },nodePermissions:function (node, perms) {
        if (FS.ignorePermissions) {
          return 0;
        }
        // return 0 if any user, group or owner bits are set.
        if (perms.indexOf('r') !== -1 && !(node.mode & 292)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('w') !== -1 && !(node.mode & 146)) {
          return ERRNO_CODES.EACCES;
        } else if (perms.indexOf('x') !== -1 && !(node.mode & 73)) {
          return ERRNO_CODES.EACCES;
        }
        return 0;
      },mayLookup:function (dir) {
        return FS.nodePermissions(dir, 'x');
      },mayMknod:function (mode) {
        switch (mode & 0170000) {
          case 0100000:
          case 0020000:
          case 0060000:
          case 0010000:
          case 0140000:
            return 0;
          default:
            return ERRNO_CODES.EINVAL;
        }
      },mayCreate:function (dir, name) {
        try {
          var node = FS.lookupNode(dir, name);
          return ERRNO_CODES.EEXIST;
        } catch (e) {
        }
        return FS.nodePermissions(dir, 'wx');
      },mayDelete:function (dir, name, isdir) {
        var node;
        try {
          node = FS.lookupNode(dir, name);
        } catch (e) {
          return e.errno;
        }
        var err = FS.nodePermissions(dir, 'wx');
        if (err) {
          return err;
        }
        if (isdir) {
          if (!FS.isDir(node.mode)) {
            return ERRNO_CODES.ENOTDIR;
          }
          if (FS.isRoot(node) || FS.getPath(node) === FS.currentPath) {
            return ERRNO_CODES.EBUSY;
          }
        } else {
          if (FS.isDir(node.mode)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return 0;
      },mayOpen:function (node, flags) {
        if (!node) {
          return ERRNO_CODES.ENOENT;
        }
        if (FS.isLink(node.mode)) {
          return ERRNO_CODES.ELOOP;
        } else if (FS.isDir(node.mode)) {
          if ((flags & 3) !== 0 ||  // opening for write
              (flags & 1024)) {
            return ERRNO_CODES.EISDIR;
          }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags));
      },chrdev_stream_ops:{open:function (stream) {
          var device = FS.getDevice(stream.node.rdev);
          // override node's stream ops with the device's
          stream.stream_ops = device.stream_ops;
          // forward the open call
          if (stream.stream_ops.open) {
            stream.stream_ops.open(stream);
          }
        },llseek:function () {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }},major:function (dev) {
        return ((dev) >> 8);
      },minor:function (dev) {
        return ((dev) & 0xff);
      },makedev:function (ma, mi) {
        return ((ma) << 8 | (mi));
      },registerDevice:function (dev, ops) {
        FS.devices[dev] = { stream_ops: ops };
      },getDevice:function (dev) {
        return FS.devices[dev];
      },MAX_OPEN_FDS:4096,nextfd:function (fd_start, fd_end) {
        fd_start = fd_start || 1;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
          if (!FS.streams[fd]) {
            return fd;
          }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE);
      },getStream:function (fd) {
        return FS.streams[fd];
      },createStream:function (stream, fd_start, fd_end) {
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        // compatibility
        Object.defineProperties(stream, {
          object: {
            get: function() { return stream.node; },
            set: function(val) { stream.node = val; }
          },
          isRead: {
            get: function() { return (stream.flags & 3) !== 1; }
          },
          isWrite: {
            get: function() { return (stream.flags & 3) !== 0; }
          },
          isAppend: {
            get: function() { return (stream.flags & 8); }
          }
        });
        FS.streams[fd] = stream;
        return stream;
      },closeStream:function (fd) {
        FS.streams[fd] = null;
      },getMode:function (canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode;
      },joinPath:function (parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == '/') path = path.substr(1);
        return path;
      },absolutePath:function (relative, base) {
        return PATH.resolve(base, relative);
      },standardizePath:function (path) {
        return PATH.normalize(path);
      },findObject:function (path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
          return ret.object;
        } else {
          ___setErrNo(ret.error);
          return null;
        }
      },analyzePath:function (path, dontResolveLastLink) {
        // operate from within the context of the symlink's target
        try {
          var lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          path = lookup.path;
        } catch (e) {
        }
        var ret = {
          isRoot: false, exists: false, error: 0, name: null, path: null, object: null,
          parentExists: false, parentPath: null, parentObject: null
        };
        try {
          var lookup = FS.lookupPath(path, { parent: true });
          ret.parentExists = true;
          ret.parentPath = lookup.path;
          ret.parentObject = lookup.node;
          ret.name = PATH.basename(path);
          lookup = FS.lookupPath(path, { follow: !dontResolveLastLink });
          ret.exists = true;
          ret.path = lookup.path;
          ret.object = lookup.node;
          ret.name = lookup.node.name;
          ret.isRoot = lookup.path === '/';
        } catch (e) {
          ret.error = e.errno;
        };
        return ret;
      },createFolder:function (parent, name, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode);
      },createPath:function (parent, path, canRead, canWrite) {
        parent = typeof parent === 'string' ? parent : FS.getPath(parent);
        var parts = path.split('/').reverse();
        while (parts.length) {
          var part = parts.pop();
          if (!part) continue;
          var current = PATH.join(parent, part);
          try {
            FS.mkdir(current, 0777);
          } catch (e) {
            // ignore EEXIST
          }
          parent = current;
        }
        return current;
      },createFile:function (parent, name, properties, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode);
      },createDataFile:function (parent, name, data, canRead, canWrite, canOwn) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
          if (typeof data === 'string') {
            var arr = new Array(data.length);
            for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
            data = arr;
          }
          // make sure we can write to the file
          FS.chmod(path, mode | 146);
          var stream = FS.open(path, 'w');
          FS.write(stream, data, 0, data.length, 0, canOwn);
          FS.close(stream);
          FS.chmod(path, mode);
        }
        return node;
      },createDevice:function (parent, name, input, output) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        var mode = input && output ? 0777 : (input ? 0333 : 0555);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        // Create a fake device that a set of stream ops to emulate
        // the old behavior.
        FS.registerDevice(dev, {
          open: function(stream) {
            stream.seekable = false;
          },
          close: function(stream) {
            // flush any pending line data
            if (output && output.buffer && output.buffer.length) {
              output(10);
            }
          },
          read: function(stream, buffer, offset, length, pos /* ignored */) {
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
              var result;
              try {
                result = input();
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
              if (result === undefined && bytesRead === 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EAGAIN);
              }
              if (result === null || result === undefined) break;
              bytesRead++;
              buffer[offset+i] = result;
            }
            if (bytesRead) {
              stream.node.timestamp = Date.now();
            }
            return bytesRead;
          },
          write: function(stream, buffer, offset, length, pos) {
            for (var i = 0; i < length; i++) {
              try {
                output(buffer[offset+i]);
              } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO);
              }
            }
            if (length) {
              stream.node.timestamp = Date.now();
            }
            return i;
          }
        });
        return FS.mkdev(path, mode, dev);
      },createLink:function (parent, name, target, canRead, canWrite) {
        var path = PATH.join(typeof parent === 'string' ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path);
      },forceLoadFile:function (obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== 'undefined') {
          throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.");
        } else if (Module['read']) {
          // Command-line.
          try {
            // WARNING: Can't read binary files in V8's d8 or tracemonkey's js, as
            //          read() will try to parse UTF8.
            obj.contents = intArrayFromString(Module['read'](obj.url), true);
          } catch (e) {
            success = false;
          }
        } else {
          throw new Error('Cannot load without read() or XMLHttpRequest.');
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success;
      },createLazyFile:function (parent, name, url, canRead, canWrite) {
        if (typeof XMLHttpRequest !== 'undefined') {
          if (!ENVIRONMENT_IS_WORKER) throw 'Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc';
          // Lazy chunked Uint8Array (implements get and length from Uint8Array). Actual getting is abstracted away for eventual reuse.
          var LazyUint8Array = function() {
            this.lengthKnown = false;
            this.chunks = []; // Loaded chunks. Index is the chunk number
          }
          LazyUint8Array.prototype.get = function(idx) {
            if (idx > this.length-1 || idx < 0) {
              return undefined;
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = Math.floor(idx / this.chunkSize);
            return this.getter(chunkNum)[chunkOffset];
          }
          LazyUint8Array.prototype.setDataGetter = function(getter) {
            this.getter = getter;
          }
          LazyUint8Array.prototype.cacheLength = function() {
              // Find length
              var xhr = new XMLHttpRequest();
              xhr.open('HEAD', url, false);
              xhr.send(null);
              if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
              var datalength = Number(xhr.getResponseHeader("Content-length"));
              var header;
              var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
              var chunkSize = 1024*1024; // Chunk size in bytes
              if (!hasByteServing) chunkSize = datalength;
              // Function to get a range from the remote URL.
              var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength-1) throw new Error("only " + datalength + " bytes available! programmer error!");
                // TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
                var xhr = new XMLHttpRequest();
                xhr.open('GET', url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                // Some hints to the browser that we want binary data.
                if (typeof Uint8Array != 'undefined') xhr.responseType = 'arraybuffer';
                if (xhr.overrideMimeType) {
                  xhr.overrideMimeType('text/plain; charset=x-user-defined');
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                  return new Uint8Array(xhr.response || []);
                } else {
                  return intArrayFromString(xhr.responseText || '', true);
                }
              });
              var lazyArray = this;
              lazyArray.setDataGetter(function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum+1) * chunkSize - 1; // including this byte
                end = Math.min(end, datalength-1); // if datalength-1 is selected, this is the last block
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") {
                  lazyArray.chunks[chunkNum] = doXHR(start, end);
                }
                if (typeof(lazyArray.chunks[chunkNum]) === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum];
              });
              this._length = datalength;
              this._chunkSize = chunkSize;
              this.lengthKnown = true;
          }
          var lazyArray = new LazyUint8Array();
          Object.defineProperty(lazyArray, "length", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._length;
              }
          });
          Object.defineProperty(lazyArray, "chunkSize", {
              get: function() {
                  if(!this.lengthKnown) {
                      this.cacheLength();
                  }
                  return this._chunkSize;
              }
          });
          var properties = { isDevice: false, contents: lazyArray };
        } else {
          var properties = { isDevice: false, url: url };
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        // This is a total hack, but I want to get this lazy file code out of the
        // core of MEMFS. If we want to keep this lazy file concept I feel it should
        // be its own thin LAZYFS proxying calls to MEMFS.
        if (properties.contents) {
          node.contents = properties.contents;
        } else if (properties.url) {
          node.contents = null;
          node.url = properties.url;
        }
        // override each stream op with one that tries to force load the lazy file first
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach(function(key) {
          var fn = node.stream_ops[key];
          stream_ops[key] = function() {
            if (!FS.forceLoadFile(node)) {
              throw new FS.ErrnoError(ERRNO_CODES.EIO);
            }
            return fn.apply(null, arguments);
          };
        });
        // use a custom read function
        stream_ops.read = function(stream, buffer, offset, length, position) {
          if (!FS.forceLoadFile(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EIO);
          }
          var contents = stream.node.contents;
          var size = Math.min(contents.length - position, length);
          if (contents.slice) { // normal array
            for (var i = 0; i < size; i++) {
              buffer[offset + i] = contents[position + i];
            }
          } else {
            for (var i = 0; i < size; i++) { // LazyUint8Array from sync binary XHR
              buffer[offset + i] = contents.get(position + i);
            }
          }
          return size;
        };
        node.stream_ops = stream_ops;
        return node;
      },createPreloadedFile:function (parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        // TODO we should allow people to just pass in a complete filename instead
        // of parent and name being that we just join them anyways
        var fullname = PATH.resolve(PATH.join(parent, name));
        function processData(byteArray) {
          function finish(byteArray) {
            if (!dontCreateFile) {
              FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn);
            }
            if (onload) onload();
            removeRunDependency('cp ' + fullname);
          }
          var handled = false;
          Module['preloadPlugins'].forEach(function(plugin) {
            if (handled) return;
            if (plugin['canHandle'](fullname)) {
              plugin['handle'](byteArray, fullname, finish, function() {
                if (onerror) onerror();
                removeRunDependency('cp ' + fullname);
              });
              handled = true;
            }
          });
          if (!handled) finish(byteArray);
        }
        addRunDependency('cp ' + fullname);
        if (typeof url == 'string') {
          Browser.asyncLoad(url, function(byteArray) {
            processData(byteArray);
          }, onerror);
        } else {
          processData(url);
        }
      },createDefaultDirectories:function () {
        FS.mkdir('/tmp', 0777);
      },createDefaultDevices:function () {
        // create /dev
        FS.mkdir('/dev', 0777);
        // setup /dev/null
        FS.registerDevice(FS.makedev(1, 3), {
          read: function() { return 0; },
          write: function() { return 0; }
        });
        FS.mkdev('/dev/null', 0666, FS.makedev(1, 3));
        // setup /dev/tty and /dev/tty1
        // stderr needs to print output using Module['printErr']
        // so we register a second tty just for it.
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev('/dev/tty', 0666, FS.makedev(5, 0));
        FS.mkdev('/dev/tty1', 0666, FS.makedev(6, 0));
        // we're not going to emulate the actual shm device,
        // just create the tmp dirs that reside in it commonly
        FS.mkdir('/dev/shm', 0777);
        FS.mkdir('/dev/shm/tmp', 0777);
      },createStandardStreams:function () {
        // TODO deprecate the old functionality of a single
        // input / output callback and that utilizes FS.createDevice
        // and instead require a unique set of stream ops
        // by default, we symlink the standard streams to the
        // default tty devices. however, if the standard streams
        // have been overwritten we create a unique device for
        // them instead.
        if (Module['stdin']) {
          FS.createDevice('/dev', 'stdin', Module['stdin']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdin');
        }
        if (Module['stdout']) {
          FS.createDevice('/dev', 'stdout', null, Module['stdout']);
        } else {
          FS.symlink('/dev/tty', '/dev/stdout');
        }
        if (Module['stderr']) {
          FS.createDevice('/dev', 'stderr', null, Module['stderr']);
        } else {
          FS.symlink('/dev/tty1', '/dev/stderr');
        }
        // open default streams for the stdin, stdout and stderr devices
        var stdin = FS.open('/dev/stdin', 'r');
        HEAP32[((_stdin)>>2)]=stdin.fd;
        assert(stdin.fd === 1, 'invalid handle for stdin (' + stdin.fd + ')');
        var stdout = FS.open('/dev/stdout', 'w');
        HEAP32[((_stdout)>>2)]=stdout.fd;
        assert(stdout.fd === 2, 'invalid handle for stdout (' + stdout.fd + ')');
        var stderr = FS.open('/dev/stderr', 'w');
        HEAP32[((_stderr)>>2)]=stderr.fd;
        assert(stderr.fd === 3, 'invalid handle for stderr (' + stderr.fd + ')');
      },staticInit:function () {
        FS.name_table = new Array(4096);
        FS.root = FS.createNode(null, '/', 0040000 | 0777, 0);
        FS.mount(MEMFS, {}, '/');
        FS.createDefaultDirectories();
        FS.createDefaultDevices();
      },init:function (input, output, error) {
        assert(!FS.init.initialized, 'FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)');
        FS.init.initialized = true;
        // Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
        Module['stdin'] = input || Module['stdin'];
        Module['stdout'] = output || Module['stdout'];
        Module['stderr'] = error || Module['stderr'];
        FS.createStandardStreams();
      },quit:function () {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
          var stream = FS.streams[i];
          if (!stream) {
            continue;
          }
          FS.close(stream);
        }
      },mount:function (type, opts, mountpoint) {
        var mount = {
          type: type,
          opts: opts,
          mountpoint: mountpoint,
          root: null
        };
        var lookup;
        if (mountpoint) {
          lookup = FS.lookupPath(mountpoint, { follow: false });
        }
        // create a root node for the fs
        var root = type.mount(mount);
        root.mount = mount;
        mount.root = root;
        // assign the mount info to the mountpoint's node
        if (lookup) {
          lookup.node.mount = mount;
          lookup.node.mounted = true;
          // compatibility update FS.root if we mount to /
          if (mountpoint === '/') {
            FS.root = mount.root;
          }
        }
        return root;
      },lookup:function (parent, name) {
        return parent.node_ops.lookup(parent, name);
      },mknod:function (path, mode, dev) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var err = FS.mayCreate(parent, name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.mknod) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.mknod(parent, name, mode, dev);
      },create:function (path, mode) {
        mode &= 4095;
        mode |= 0100000;
        return FS.mknod(path, mode, 0);
      },mkdir:function (path, mode) {
        mode &= 511 | 0001000;
        mode |= 0040000;
        return FS.mknod(path, mode, 0);
      },mkdev:function (path, mode, dev) {
        mode |= 0020000;
        return FS.mknod(path, mode, dev);
      },symlink:function (oldpath, newpath) {
        var lookup = FS.lookupPath(newpath, { parent: true });
        var parent = lookup.node;
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.symlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return parent.node_ops.symlink(parent, newname, oldpath);
      },rename:function (old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        // parents must exist
        var lookup, old_dir, new_dir;
        try {
          lookup = FS.lookupPath(old_path, { parent: true });
          old_dir = lookup.node;
          lookup = FS.lookupPath(new_path, { parent: true });
          new_dir = lookup.node;
        } catch (e) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // need to be part of the same mount
        if (old_dir.mount !== new_dir.mount) {
          throw new FS.ErrnoError(ERRNO_CODES.EXDEV);
        }
        // source must exist
        var old_node = FS.lookupNode(old_dir, old_name);
        // old path should not be an ancestor of the new path
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        // new path should not be an ancestor of the old path
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== '.') {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY);
        }
        // see if the new path already exists
        var new_node;
        try {
          new_node = FS.lookupNode(new_dir, new_name);
        } catch (e) {
          // not fatal
        }
        // early out if nothing needs to change
        if (old_node === new_node) {
          return;
        }
        // we'll need to delete the old entry
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // need delete permissions if we'll be overwriting.
        // need create permissions if new doesn't already exist.
        err = new_node ?
          FS.mayDelete(new_dir, new_name, isdir) :
          FS.mayCreate(new_dir, new_name);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!old_dir.node_ops.rename) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(old_node) || (new_node && FS.isMountpoint(new_node))) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        // if we are going to change the parent, check write permissions
        if (new_dir !== old_dir) {
          err = FS.nodePermissions(old_dir, 'w');
          if (err) {
            throw new FS.ErrnoError(err);
          }
        }
        // remove the node from the lookup hash
        FS.hashRemoveNode(old_node);
        // do the underlying fs rename
        try {
          old_dir.node_ops.rename(old_node, new_dir, new_name);
        } catch (e) {
          throw e;
        } finally {
          // add the node back to the hash (in case node_ops.rename
          // changed its name)
          FS.hashAddNode(old_node);
        }
      },rmdir:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.rmdir) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
      },readdir:function (path) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR);
        }
        return node.node_ops.readdir(node);
      },unlink:function (path) {
        var lookup = FS.lookupPath(path, { parent: true });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
          // POSIX says unlink should set EPERM, not EISDIR
          if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
          throw new FS.ErrnoError(err);
        }
        if (!parent.node_ops.unlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isMountpoint(node)) {
          throw new FS.ErrnoError(ERRNO_CODES.EBUSY);
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
      },readlink:function (path) {
        var lookup = FS.lookupPath(path, { follow: false });
        var link = lookup.node;
        if (!link.node_ops.readlink) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        return link.node_ops.readlink(link);
      },stat:function (path, dontFollow) {
        var lookup = FS.lookupPath(path, { follow: !dontFollow });
        var node = lookup.node;
        if (!node.node_ops.getattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        return node.node_ops.getattr(node);
      },lstat:function (path) {
        return FS.stat(path, true);
      },chmod:function (path, mode, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          mode: (mode & 4095) | (node.mode & ~4095),
          timestamp: Date.now()
        });
      },lchmod:function (path, mode) {
        FS.chmod(path, mode, true);
      },fchmod:function (fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chmod(stream.node, mode);
      },chown:function (path, uid, gid, dontFollow) {
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: !dontFollow });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        node.node_ops.setattr(node, {
          timestamp: Date.now()
          // we ignore the uid / gid for now
        });
      },lchown:function (path, uid, gid) {
        FS.chown(path, uid, gid, true);
      },fchown:function (fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        FS.chown(stream.node, uid, gid);
      },truncate:function (path, len) {
        if (len < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var node;
        if (typeof path === 'string') {
          var lookup = FS.lookupPath(path, { follow: true });
          node = lookup.node;
        } else {
          node = path;
        }
        if (!node.node_ops.setattr) {
          throw new FS.ErrnoError(ERRNO_CODES.EPERM);
        }
        if (FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!FS.isFile(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var err = FS.nodePermissions(node, 'w');
        if (err) {
          throw new FS.ErrnoError(err);
        }
        node.node_ops.setattr(node, {
          size: len,
          timestamp: Date.now()
        });
      },ftruncate:function (fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        FS.truncate(stream.node, len);
      },utime:function (path, atime, mtime) {
        var lookup = FS.lookupPath(path, { follow: true });
        var node = lookup.node;
        node.node_ops.setattr(node, {
          timestamp: Math.max(atime, mtime)
        });
      },open:function (path, flags, mode, fd_start, fd_end) {
        path = PATH.normalize(path);
        flags = typeof flags === 'string' ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === 'undefined' ? 0666 : mode;
        if ((flags & 512)) {
          mode = (mode & 4095) | 0100000;
        } else {
          mode = 0;
        }
        var node;
        try {
          var lookup = FS.lookupPath(path, {
            follow: !(flags & 0200000)
          });
          node = lookup.node;
          path = lookup.path;
        } catch (e) {
          // ignore
        }
        // perhaps we need to create the node
        if ((flags & 512)) {
          if (node) {
            // if O_CREAT and O_EXCL are set, error out if the node already exists
            if ((flags & 2048)) {
              throw new FS.ErrnoError(ERRNO_CODES.EEXIST);
            }
          } else {
            // node doesn't exist, try to create it
            node = FS.mknod(path, mode, 0);
          }
        }
        if (!node) {
          throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        }
        // can't truncate a device
        if (FS.isChrdev(node.mode)) {
          flags &= ~1024;
        }
        // check permissions
        var err = FS.mayOpen(node, flags);
        if (err) {
          throw new FS.ErrnoError(err);
        }
        // do truncation if necessary
        if ((flags & 1024)) {
          FS.truncate(node, 0);
        }
        // register the stream with the filesystem
        var stream = FS.createStream({
          path: path,
          node: node,
          flags: flags,
          seekable: true,
          position: 0,
          stream_ops: node.stream_ops,
          // used by the file family libc calls (fopen, fwrite, ferror, etc.)
          ungotten: [],
          error: false
        }, fd_start, fd_end);
        // call the new stream's open function
        if (stream.stream_ops.open) {
          stream.stream_ops.open(stream);
        }
        return stream;
      },close:function (stream) {
        try {
          if (stream.stream_ops.close) {
            stream.stream_ops.close(stream);
          }
        } catch (e) {
          throw e;
        } finally {
          FS.closeStream(stream.fd);
        }
      },llseek:function (stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        return stream.stream_ops.llseek(stream, offset, whence);
      },read:function (stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.read) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead;
      },write:function (stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (FS.isDir(stream.node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.EISDIR);
        }
        if (!stream.stream_ops.write) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        var seeking = true;
        if (typeof position === 'undefined') {
          position = stream.position;
          seeking = false;
        } else if (!stream.seekable) {
          throw new FS.ErrnoError(ERRNO_CODES.ESPIPE);
        }
        if (stream.flags & 8) {
          // seek to the end before writing in append mode
          FS.llseek(stream, 0, 2);
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        return bytesWritten;
      },allocate:function (stream, offset, length) {
        if (offset < 0 || length <= 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EINVAL);
        }
        if ((stream.flags & 3) === 0) {
          throw new FS.ErrnoError(ERRNO_CODES.EBADF);
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
          throw new FS.ErrnoError(ERRNO_CODES.ENODEV);
        }
        if (!stream.stream_ops.allocate) {
          throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP);
        }
        stream.stream_ops.allocate(stream, offset, length);
      },mmap:function (stream, buffer, offset, length, position, prot, flags) {
        // TODO if PROT is PROT_WRITE, make sure we have write access
        if ((stream.flags & 3) === 1) {
          throw new FS.ErrnoError(ERRNO_CODES.EACCES);
        }
        if (!stream.stream_ops.mmap) {
          throw new FS.errnoError(ERRNO_CODES.ENODEV);
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags);
      }};
  function _send(fd, buf, len, flags) {
      var info = FS.getStream(fd);
      if (!info) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      if (info.socket.readyState === WebSocket.CLOSING || info.socket.readyState === WebSocket.CLOSED) {
        ___setErrNo(ERRNO_CODES.ENOTCONN);
        return -1;
      } else if (info.socket.readyState === WebSocket.CONNECTING) {
        ___setErrNo(ERRNO_CODES.EAGAIN);
        return -1;
      }
      info.sender(HEAPU8.subarray(buf, buf+len));
      return len;
    }
  function _pwrite(fildes, buf, nbyte, offset) {
      // ssize_t pwrite(int fildes, const void *buf, size_t nbyte, off_t offset);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _write(fildes, buf, nbyte) {
      // ssize_t write(int fildes, const void *buf, size_t nbyte);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/write.html
      var stream = FS.getStream(fildes);
      if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1;
      }
      if (stream && ('socket' in stream)) {
        return _send(fildes, buf, nbyte, 0);
      }
      try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte);
      } catch (e) {
        FS.handleFSError(e);
        return -1;
      }
    }function _fwrite(ptr, size, nitems, stream) {
      // size_t fwrite(const void *restrict ptr, size_t size, size_t nitems, FILE *restrict stream);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/fwrite.html
      var bytesToWrite = nitems * size;
      if (bytesToWrite == 0) return 0;
      var bytesWritten = _write(stream, ptr, bytesToWrite);
      if (bytesWritten == -1) {
        var streamObj = FS.getStream(stream);
        if (streamObj) streamObj.error = true;
        return 0;
      } else {
        return Math.floor(bytesWritten / size);
      }
    }
  Module["_strlen"] = _strlen;
  function __reallyNegative(x) {
      return x < 0 || (x === 0 && (1/x) === -Infinity);
    }function __formatString(format, varargs) {
      var textIndex = format;
      var argIndex = 0;
      function getNextArg(type) {
        // NOTE: Explicitly ignoring type safety. Otherwise this fails:
        //       int x = 4; printf("%c\n", (char)x);
        var ret;
        if (type === 'double') {
          ret = HEAPF64[(((varargs)+(argIndex))>>3)];
        } else if (type == 'i64') {
          ret = [HEAP32[(((varargs)+(argIndex))>>2)],
                 HEAP32[(((varargs)+(argIndex+8))>>2)]];
          argIndex += 8; // each 32-bit chunk is in a 64-bit block
        } else {
          type = 'i32'; // varargs are always i32, i64, or double
          ret = HEAP32[(((varargs)+(argIndex))>>2)];
        }
        argIndex += Math.max(Runtime.getNativeFieldSize(type), Runtime.getAlignSize(type, null, true));
        return ret;
      }
      var ret = [];
      var curr, next, currArg;
      while(1) {
        var startTextIndex = textIndex;
        curr = HEAP8[(textIndex)];
        if (curr === 0) break;
        next = HEAP8[((textIndex+1)|0)];
        if (curr == 37) {
          // Handle flags.
          var flagAlwaysSigned = false;
          var flagLeftAlign = false;
          var flagAlternative = false;
          var flagZeroPad = false;
          flagsLoop: while (1) {
            switch (next) {
              case 43:
                flagAlwaysSigned = true;
                break;
              case 45:
                flagLeftAlign = true;
                break;
              case 35:
                flagAlternative = true;
                break;
              case 48:
                if (flagZeroPad) {
                  break flagsLoop;
                } else {
                  flagZeroPad = true;
                  break;
                }
              default:
                break flagsLoop;
            }
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          }
          // Handle width.
          var width = 0;
          if (next == 42) {
            width = getNextArg('i32');
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
          } else {
            while (next >= 48 && next <= 57) {
              width = width * 10 + (next - 48);
              textIndex++;
              next = HEAP8[((textIndex+1)|0)];
            }
          }
          // Handle precision.
          var precisionSet = false;
          if (next == 46) {
            var precision = 0;
            precisionSet = true;
            textIndex++;
            next = HEAP8[((textIndex+1)|0)];
            if (next == 42) {
              precision = getNextArg('i32');
              textIndex++;
            } else {
              while(1) {
                var precisionChr = HEAP8[((textIndex+1)|0)];
                if (precisionChr < 48 ||
                    precisionChr > 57) break;
                precision = precision * 10 + (precisionChr - 48);
                textIndex++;
              }
            }
            next = HEAP8[((textIndex+1)|0)];
          } else {
            var precision = 6; // Standard default.
          }
          // Handle integer sizes. WARNING: These assume a 32-bit architecture!
          var argSize;
          switch (String.fromCharCode(next)) {
            case 'h':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 104) {
                textIndex++;
                argSize = 1; // char (actually i32 in varargs)
              } else {
                argSize = 2; // short (actually i32 in varargs)
              }
              break;
            case 'l':
              var nextNext = HEAP8[((textIndex+2)|0)];
              if (nextNext == 108) {
                textIndex++;
                argSize = 8; // long long
              } else {
                argSize = 4; // long
              }
              break;
            case 'L': // long long
            case 'q': // int64_t
            case 'j': // intmax_t
              argSize = 8;
              break;
            case 'z': // size_t
            case 't': // ptrdiff_t
            case 'I': // signed ptrdiff_t or unsigned size_t
              argSize = 4;
              break;
            default:
              argSize = null;
          }
          if (argSize) textIndex++;
          next = HEAP8[((textIndex+1)|0)];
          // Handle type specifier.
          switch (String.fromCharCode(next)) {
            case 'd': case 'i': case 'u': case 'o': case 'x': case 'X': case 'p': {
              // Integer.
              var signed = next == 100 || next == 105;
              argSize = argSize || 4;
              var currArg = getNextArg('i' + (argSize * 8));
              var argText;
              // Flatten i64-1 [low, high] into a (slightly rounded) double
              if (argSize == 8) {
                currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117);
              }
              // Truncate to requested size.
              if (argSize <= 4) {
                var limit = Math.pow(256, argSize) - 1;
                currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8);
              }
              // Format the number.
              var currAbsArg = Math.abs(currArg);
              var prefix = '';
              if (next == 100 || next == 105) {
                argText = reSign(currArg, 8 * argSize, 1).toString(10);
              } else if (next == 117) {
                argText = unSign(currArg, 8 * argSize, 1).toString(10);
                currArg = Math.abs(currArg);
              } else if (next == 111) {
                argText = (flagAlternative ? '0' : '') + currAbsArg.toString(8);
              } else if (next == 120 || next == 88) {
                prefix = (flagAlternative && currArg != 0) ? '0x' : '';
                if (currArg < 0) {
                  // Represent negative numbers in hex as 2's complement.
                  currArg = -currArg;
                  argText = (currAbsArg - 1).toString(16);
                  var buffer = [];
                  for (var i = 0; i < argText.length; i++) {
                    buffer.push((0xF - parseInt(argText[i], 16)).toString(16));
                  }
                  argText = buffer.join('');
                  while (argText.length < argSize * 2) argText = 'f' + argText;
                } else {
                  argText = currAbsArg.toString(16);
                }
                if (next == 88) {
                  prefix = prefix.toUpperCase();
                  argText = argText.toUpperCase();
                }
              } else if (next == 112) {
                if (currAbsArg === 0) {
                  argText = '(nil)';
                } else {
                  prefix = '0x';
                  argText = currAbsArg.toString(16);
                }
              }
              if (precisionSet) {
                while (argText.length < precision) {
                  argText = '0' + argText;
                }
              }
              // Add sign if needed
              if (flagAlwaysSigned) {
                if (currArg < 0) {
                  prefix = '-' + prefix;
                } else {
                  prefix = '+' + prefix;
                }
              }
              // Add padding.
              while (prefix.length + argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad) {
                    argText = '0' + argText;
                  } else {
                    prefix = ' ' + prefix;
                  }
                }
              }
              // Insert the result into the buffer.
              argText = prefix + argText;
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 'f': case 'F': case 'e': case 'E': case 'g': case 'G': {
              // Float.
              var currArg = getNextArg('double');
              var argText;
              if (isNaN(currArg)) {
                argText = 'nan';
                flagZeroPad = false;
              } else if (!isFinite(currArg)) {
                argText = (currArg < 0 ? '-' : '') + 'inf';
                flagZeroPad = false;
              } else {
                var isGeneral = false;
                var effectivePrecision = Math.min(precision, 20);
                // Convert g/G to f/F or e/E, as per:
                // http://pubs.opengroup.org/onlinepubs/9699919799/functions/printf.html
                if (next == 103 || next == 71) {
                  isGeneral = true;
                  precision = precision || 1;
                  var exponent = parseInt(currArg.toExponential(effectivePrecision).split('e')[1], 10);
                  if (precision > exponent && exponent >= -4) {
                    next = ((next == 103) ? 'f' : 'F').charCodeAt(0);
                    precision -= exponent + 1;
                  } else {
                    next = ((next == 103) ? 'e' : 'E').charCodeAt(0);
                    precision--;
                  }
                  effectivePrecision = Math.min(precision, 20);
                }
                if (next == 101 || next == 69) {
                  argText = currArg.toExponential(effectivePrecision);
                  // Make sure the exponent has at least 2 digits.
                  if (/[eE][-+]\d$/.test(argText)) {
                    argText = argText.slice(0, -1) + '0' + argText.slice(-1);
                  }
                } else if (next == 102 || next == 70) {
                  argText = currArg.toFixed(effectivePrecision);
                  if (currArg === 0 && __reallyNegative(currArg)) {
                    argText = '-' + argText;
                  }
                }
                var parts = argText.split('e');
                if (isGeneral && !flagAlternative) {
                  // Discard trailing zeros and periods.
                  while (parts[0].length > 1 && parts[0].indexOf('.') != -1 &&
                         (parts[0].slice(-1) == '0' || parts[0].slice(-1) == '.')) {
                    parts[0] = parts[0].slice(0, -1);
                  }
                } else {
                  // Make sure we have a period in alternative mode.
                  if (flagAlternative && argText.indexOf('.') == -1) parts[0] += '.';
                  // Zero pad until required precision.
                  while (precision > effectivePrecision++) parts[0] += '0';
                }
                argText = parts[0] + (parts.length > 1 ? 'e' + parts[1] : '');
                // Capitalize 'E' if needed.
                if (next == 69) argText = argText.toUpperCase();
                // Add sign.
                if (flagAlwaysSigned && currArg >= 0) {
                  argText = '+' + argText;
                }
              }
              // Add padding.
              while (argText.length < width) {
                if (flagLeftAlign) {
                  argText += ' ';
                } else {
                  if (flagZeroPad && (argText[0] == '-' || argText[0] == '+')) {
                    argText = argText[0] + '0' + argText.slice(1);
                  } else {
                    argText = (flagZeroPad ? '0' : ' ') + argText;
                  }
                }
              }
              // Adjust case.
              if (next < 97) argText = argText.toUpperCase();
              // Insert the result into the buffer.
              argText.split('').forEach(function(chr) {
                ret.push(chr.charCodeAt(0));
              });
              break;
            }
            case 's': {
              // String.
              var arg = getNextArg('i8*');
              var argLength = arg ? _strlen(arg) : '(null)'.length;
              if (precisionSet) argLength = Math.min(argLength, precision);
              if (!flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              if (arg) {
                for (var i = 0; i < argLength; i++) {
                  ret.push(HEAPU8[((arg++)|0)]);
                }
              } else {
                ret = ret.concat(intArrayFromString('(null)'.substr(0, argLength), true));
              }
              if (flagLeftAlign) {
                while (argLength < width--) {
                  ret.push(32);
                }
              }
              break;
            }
            case 'c': {
              // Character.
              if (flagLeftAlign) ret.push(getNextArg('i8'));
              while (--width > 0) {
                ret.push(32);
              }
              if (!flagLeftAlign) ret.push(getNextArg('i8'));
              break;
            }
            case 'n': {
              // Write the length written so far to the next parameter.
              var ptr = getNextArg('i32*');
              HEAP32[((ptr)>>2)]=ret.length
              break;
            }
            case '%': {
              // Literal percent sign.
              ret.push(curr);
              break;
            }
            default: {
              // Unknown specifiers remain untouched.
              for (var i = startTextIndex; i < textIndex + 2; i++) {
                ret.push(HEAP8[(i)]);
              }
            }
          }
          textIndex += 2;
          // TODO: Support a/A (hex float) and m (last error) specifiers.
          // TODO: Support %1${specifier} for arg selection.
        } else {
          ret.push(curr);
          textIndex += 1;
        }
      }
      return ret;
    }function _fprintf(stream, format, varargs) {
      // int fprintf(FILE *restrict stream, const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var result = __formatString(format, varargs);
      var stack = Runtime.stackSave();
      var ret = _fwrite(allocate(result, 'i8', ALLOC_STACK), 1, result.length, stream);
      Runtime.stackRestore(stack);
      return ret;
    }function _printf(format, varargs) {
      // int printf(const char *restrict format, ...);
      // http://pubs.opengroup.org/onlinepubs/000095399/functions/printf.html
      var stdout = HEAP32[((_stdout)>>2)];
      return _fprintf(stdout, format, varargs);
    }
  function _atexit(func, arg) {
      __ATEXIT__.unshift({ func: func, arg: arg });
    }var ___cxa_atexit=_atexit;
  var _llvm_memset_p0i8_i32=_memset;
  function _llvm_umul_with_overflow_i32(x, y) {
      x = x>>>0;
      y = y>>>0;
      return ((asm["setTempRet0"](x*y > 4294967295),(x*y)>>>0)|0);
    }
  function _llvm_bswap_i16(x) {
      return ((x&0xff)<<8) | ((x>>8)&0xff);
    }
  function _llvm_bswap_i32(x) {
      return ((x&0xff)<<24) | (((x>>8)&0xff)<<16) | (((x>>16)&0xff)<<8) | (x>>>24);
    }
  function ___assert_func(filename, line, func, condition) {
      throw 'Assertion failed: ' + (condition ? Pointer_stringify(condition) : 'unknown condition') + ', at: ' + [filename ? Pointer_stringify(filename) : 'unknown filename', line, func ? Pointer_stringify(func) : 'unknown function'] + ' at ' + new Error().stack;
    }
  Module["_llvm_uadd_with_overflow_i64"] = _llvm_uadd_with_overflow_i64;
  function _gettimeofday(ptr) {
      // %struct.timeval = type { i32, i32 }
      var now = Date.now();
      HEAP32[((ptr)>>2)]=Math.floor(now/1000); // seconds
      HEAP32[(((ptr)+(4))>>2)]=Math.floor((now-1000*Math.floor(now/1000))*1000); // microseconds
      return 0;
    }
  function _abort() {
      Module['abort']();
    }
  function ___errno_location() {
      return ___errno_state;
    }var ___errno=___errno_location;
  function _sbrk(bytes) {
      // Implement a Linux-like 'memory area' for our 'process'.
      // Changes the size of the memory area by |bytes|; returns the
      // address of the previous top ('break') of the memory area
      // We control the "dynamic" memory - DYNAMIC_BASE to DYNAMICTOP
      var self = _sbrk;
      if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP); // make sure we start out aligned
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = function() { abort('cannot dynamically allocate, sbrk now has control') };
      }
      var ret = DYNAMICTOP;
      if (bytes != 0) self.alloc(bytes);
      return ret;  // Previous break location.
    }
  function _sysconf(name) {
      // long sysconf(int name);
      // http://pubs.opengroup.org/onlinepubs/009695399/functions/sysconf.html
      switch(name) {
        case 8: return PAGE_SIZE;
        case 54:
        case 56:
        case 21:
        case 61:
        case 63:
        case 22:
        case 67:
        case 23:
        case 24:
        case 25:
        case 26:
        case 27:
        case 69:
        case 28:
        case 101:
        case 70:
        case 71:
        case 29:
        case 30:
        case 199:
        case 75:
        case 76:
        case 32:
        case 43:
        case 44:
        case 80:
        case 46:
        case 47:
        case 45:
        case 48:
        case 49:
        case 42:
        case 82:
        case 33:
        case 7:
        case 108:
        case 109:
        case 107:
        case 112:
        case 119:
        case 121:
          return 200809;
        case 13:
        case 104:
        case 94:
        case 95:
        case 34:
        case 35:
        case 77:
        case 81:
        case 83:
        case 84:
        case 85:
        case 86:
        case 87:
        case 88:
        case 89:
        case 90:
        case 91:
        case 94:
        case 95:
        case 110:
        case 111:
        case 113:
        case 114:
        case 115:
        case 116:
        case 117:
        case 118:
        case 120:
        case 40:
        case 16:
        case 79:
        case 19:
          return -1;
        case 92:
        case 93:
        case 5:
        case 72:
        case 6:
        case 74:
        case 92:
        case 93:
        case 96:
        case 97:
        case 98:
        case 99:
        case 102:
        case 103:
        case 105:
          return 1;
        case 38:
        case 66:
        case 50:
        case 51:
        case 4:
          return 1024;
        case 15:
        case 64:
        case 41:
          return 32;
        case 55:
        case 37:
        case 17:
          return 2147483647;
        case 18:
        case 1:
          return 47839;
        case 59:
        case 57:
          return 99;
        case 68:
        case 58:
          return 2048;
        case 0: return 2097152;
        case 3: return 65536;
        case 14: return 32768;
        case 73: return 32767;
        case 39: return 16384;
        case 60: return 1000;
        case 106: return 700;
        case 52: return 256;
        case 62: return 255;
        case 2: return 100;
        case 65: return 64;
        case 36: return 20;
        case 100: return 16;
        case 20: return 6;
        case 53: return 4;
        case 10: return 1;
      }
      ___setErrNo(ERRNO_CODES.EINVAL);
      return -1;
    }
  function _time(ptr) {
      var ret = Math.floor(Date.now()/1000);
      if (ptr) {
        HEAP32[((ptr)>>2)]=ret
      }
      return ret;
    }
  function ___cxa_allocate_exception(size) {
      return _malloc(size);
    }
  function _llvm_eh_exception() {
      return HEAP32[((_llvm_eh_exception.buf)>>2)];
    }
  function __ZSt18uncaught_exceptionv() { // std::uncaught_exception()
      return !!__ZSt18uncaught_exceptionv.uncaught_exception;
    }
  function ___cxa_is_number_type(type) {
      var isNumber = false;
      try { if (type == __ZTIi) isNumber = true } catch(e){}
      try { if (type == __ZTIj) isNumber = true } catch(e){}
      try { if (type == __ZTIl) isNumber = true } catch(e){}
      try { if (type == __ZTIm) isNumber = true } catch(e){}
      try { if (type == __ZTIx) isNumber = true } catch(e){}
      try { if (type == __ZTIy) isNumber = true } catch(e){}
      try { if (type == __ZTIf) isNumber = true } catch(e){}
      try { if (type == __ZTId) isNumber = true } catch(e){}
      try { if (type == __ZTIe) isNumber = true } catch(e){}
      try { if (type == __ZTIc) isNumber = true } catch(e){}
      try { if (type == __ZTIa) isNumber = true } catch(e){}
      try { if (type == __ZTIh) isNumber = true } catch(e){}
      try { if (type == __ZTIs) isNumber = true } catch(e){}
      try { if (type == __ZTIt) isNumber = true } catch(e){}
      return isNumber;
    }function ___cxa_does_inherit(definiteType, possibilityType, possibility) {
      if (possibility == 0) return false;
      if (possibilityType == 0 || possibilityType == definiteType)
        return true;
      var possibility_type_info;
      if (___cxa_is_number_type(possibilityType)) {
        possibility_type_info = possibilityType;
      } else {
        var possibility_type_infoAddr = HEAP32[((possibilityType)>>2)] - 8;
        possibility_type_info = HEAP32[((possibility_type_infoAddr)>>2)];
      }
      switch (possibility_type_info) {
      case 0: // possibility is a pointer
        // See if definite type is a pointer
        var definite_type_infoAddr = HEAP32[((definiteType)>>2)] - 8;
        var definite_type_info = HEAP32[((definite_type_infoAddr)>>2)];
        if (definite_type_info == 0) {
          // Also a pointer; compare base types of pointers
          var defPointerBaseAddr = definiteType+8;
          var defPointerBaseType = HEAP32[((defPointerBaseAddr)>>2)];
          var possPointerBaseAddr = possibilityType+8;
          var possPointerBaseType = HEAP32[((possPointerBaseAddr)>>2)];
          return ___cxa_does_inherit(defPointerBaseType, possPointerBaseType, possibility);
        } else
          return false; // one pointer and one non-pointer
      case 1: // class with no base class
        return false;
      case 2: // class with base class
        var parentTypeAddr = possibilityType + 8;
        var parentType = HEAP32[((parentTypeAddr)>>2)];
        return ___cxa_does_inherit(definiteType, parentType, possibility);
      default:
        return false; // some unencountered type
      }
    }
  function ___resumeException(ptr) {
      if (HEAP32[((_llvm_eh_exception.buf)>>2)] == 0) HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr;
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }function ___cxa_find_matching_catch(thrown, throwntype) {
      if (thrown == -1) thrown = HEAP32[((_llvm_eh_exception.buf)>>2)];
      if (throwntype == -1) throwntype = HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)];
      var typeArray = Array.prototype.slice.call(arguments, 2);
      // If throwntype is a pointer, this means a pointer has been
      // thrown. When a pointer is thrown, actually what's thrown
      // is a pointer to the pointer. We'll dereference it.
      if (throwntype != 0 && !___cxa_is_number_type(throwntype)) {
        var throwntypeInfoAddr= HEAP32[((throwntype)>>2)] - 8;
        var throwntypeInfo= HEAP32[((throwntypeInfoAddr)>>2)];
        if (throwntypeInfo == 0)
          thrown = HEAP32[((thrown)>>2)];
      }
      // The different catch blocks are denoted by different types.
      // Due to inheritance, those types may not precisely match the
      // type of the thrown object. Find one which matches, and
      // return the type of the catch block which should be called.
      for (var i = 0; i < typeArray.length; i++) {
        if (___cxa_does_inherit(typeArray[i], throwntype, thrown))
          return ((asm["setTempRet0"](typeArray[i]),thrown)|0);
      }
      // Shouldn't happen unless we have bogus data in typeArray
      // or encounter a type for which emscripten doesn't have suitable
      // typeinfo defined. Best-efforts match just in case.
      return ((asm["setTempRet0"](throwntype),thrown)|0);
    }function ___cxa_throw(ptr, type, destructor) {
      if (!___cxa_throw.initialized) {
        try {
          HEAP32[((__ZTVN10__cxxabiv119__pointer_type_infoE)>>2)]=0; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv117__class_type_infoE)>>2)]=1; // Workaround for libcxxabi integration bug
        } catch(e){}
        try {
          HEAP32[((__ZTVN10__cxxabiv120__si_class_type_infoE)>>2)]=2; // Workaround for libcxxabi integration bug
        } catch(e){}
        ___cxa_throw.initialized = true;
      }
      HEAP32[((_llvm_eh_exception.buf)>>2)]=ptr
      HEAP32[(((_llvm_eh_exception.buf)+(4))>>2)]=type
      HEAP32[(((_llvm_eh_exception.buf)+(8))>>2)]=destructor
      if (!("uncaught_exception" in __ZSt18uncaught_exceptionv)) {
        __ZSt18uncaught_exceptionv.uncaught_exception = 1;
      } else {
        __ZSt18uncaught_exceptionv.uncaught_exception++;
      }
      throw ptr + " - Exception catching is disabled, this exception cannot be caught. Compile with -s DISABLE_EXCEPTION_CATCHING=0 or DISABLE_EXCEPTION_CATCHING=2 to catch.";;
    }
  function ___cxa_call_unexpected(exception) {
      Module.printErr('Unexpected exception thrown, this is not properly supported - aborting');
      ABORT = true;
      throw exception;
    }
  Module["_memmove"] = _memmove;var _llvm_memmove_p0i8_p0i8_i32=_memmove;
  var Browser={mainLoop:{scheduler:null,shouldPause:false,paused:false,queue:[],pause:function () {
          Browser.mainLoop.shouldPause = true;
        },resume:function () {
          if (Browser.mainLoop.paused) {
            Browser.mainLoop.paused = false;
            Browser.mainLoop.scheduler();
          }
          Browser.mainLoop.shouldPause = false;
        },updateStatus:function () {
          if (Module['setStatus']) {
            var message = Module['statusMessage'] || 'Please wait...';
            var remaining = Browser.mainLoop.remainingBlockers;
            var expected = Browser.mainLoop.expectedBlockers;
            if (remaining) {
              if (remaining < expected) {
                Module['setStatus'](message + ' (' + (expected - remaining) + '/' + expected + ')');
              } else {
                Module['setStatus'](message);
              }
            } else {
              Module['setStatus']('');
            }
          }
        }},isFullScreen:false,pointerLock:false,moduleContextCreatedCallbacks:[],workers:[],init:function () {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = []; // needs to exist even in workers
        if (Browser.initted || ENVIRONMENT_IS_WORKER) return;
        Browser.initted = true;
        try {
          new Blob();
          Browser.hasBlobConstructor = true;
        } catch(e) {
          Browser.hasBlobConstructor = false;
          console.log("warning: no blob constructor, cannot create blobs with mimetypes");
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : (typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : (!Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null));
        Browser.URLObject = typeof window != "undefined" ? (window.URL ? window.URL : window.webkitURL) : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === 'undefined') {
          console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
          Module.noImageDecoding = true;
        }
        // Support for plugins that can process preloaded files. You can add more of these to
        // your app by creating and appending to Module.preloadPlugins.
        //
        // Each plugin is asked if it can handle a file based on the file's name. If it can,
        // it is given the file's raw data. When it is done, it calls a callback with the file's
        // (possibly modified) data. For example, a plugin might decompress a file, or it
        // might create some side data structure for use later (like an Image element, etc.).
        var imagePlugin = {};
        imagePlugin['canHandle'] = function(name) {
          return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name);
        };
        imagePlugin['handle'] = function(byteArray, name, onload, onerror) {
          var b = null;
          if (Browser.hasBlobConstructor) {
            try {
              b = new Blob([byteArray], { type: Browser.getMimetype(name) });
              if (b.size !== byteArray.length) { // Safari bug #118630
                // Safari's Blob can only take an ArrayBuffer
                b = new Blob([(new Uint8Array(byteArray)).buffer], { type: Browser.getMimetype(name) });
              }
            } catch(e) {
              Runtime.warnOnce('Blob constructor present but fails: ' + e + '; falling back to blob builder');
            }
          }
          if (!b) {
            var bb = new Browser.BlobBuilder();
            bb.append((new Uint8Array(byteArray)).buffer); // we need to pass a buffer, and must copy the array to get the right data range
            b = bb.getBlob();
          }
          var url = Browser.URLObject.createObjectURL(b);
          var img = new Image();
          img.onload = function() {
            assert(img.complete, 'Image ' + name + ' could not be decoded');
            var canvas = document.createElement('canvas');
            canvas.width = img.width;
            canvas.height = img.height;
            var ctx = canvas.getContext('2d');
            ctx.drawImage(img, 0, 0);
            Module["preloadedImages"][name] = canvas;
            Browser.URLObject.revokeObjectURL(url);
            if (onload) onload(byteArray);
          };
          img.onerror = function(event) {
            console.log('Image ' + url + ' could not be decoded');
            if (onerror) onerror();
          };
          img.src = url;
        };
        Module['preloadPlugins'].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin['canHandle'] = function(name) {
          return !Module.noAudioDecoding && name.substr(-4) in { '.ogg': 1, '.wav': 1, '.mp3': 1 };
        };
        audioPlugin['handle'] = function(byteArray, name, onload, onerror) {
          var done = false;
          function finish(audio) {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = audio;
            if (onload) onload(byteArray);
          }
          function fail() {
            if (done) return;
            done = true;
            Module["preloadedAudios"][name] = new Audio(); // empty shim
            if (onerror) onerror();
          }
          if (Browser.hasBlobConstructor) {
            try {
              var b = new Blob([byteArray], { type: Browser.getMimetype(name) });
            } catch(e) {
              return fail();
            }
            var url = Browser.URLObject.createObjectURL(b); // XXX we never revoke this!
            var audio = new Audio();
            audio.addEventListener('canplaythrough', function() { finish(audio) }, false); // use addEventListener due to chromium bug 124926
            audio.onerror = function(event) {
              if (done) return;
              console.log('warning: browser could not fully decode audio ' + name + ', trying slower base64 approach');
              function encode64(data) {
                var BASE = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
                var PAD = '=';
                var ret = '';
                var leftchar = 0;
                var leftbits = 0;
                for (var i = 0; i < data.length; i++) {
                  leftchar = (leftchar << 8) | data[i];
                  leftbits += 8;
                  while (leftbits >= 6) {
                    var curr = (leftchar >> (leftbits-6)) & 0x3f;
                    leftbits -= 6;
                    ret += BASE[curr];
                  }
                }
                if (leftbits == 2) {
                  ret += BASE[(leftchar&3) << 4];
                  ret += PAD + PAD;
                } else if (leftbits == 4) {
                  ret += BASE[(leftchar&0xf) << 2];
                  ret += PAD;
                }
                return ret;
              }
              audio.src = 'data:audio/x-' + name.substr(-3) + ';base64,' + encode64(byteArray);
              finish(audio); // we don't wait for confirmation this worked - but it's worth trying
            };
            audio.src = url;
            // workaround for chrome bug 124926 - we do not always get oncanplaythrough or onerror
            Browser.safeSetTimeout(function() {
              finish(audio); // try to use it even though it is not necessarily ready to play
            }, 10000);
          } else {
            return fail();
          }
        };
        Module['preloadPlugins'].push(audioPlugin);
        // Canvas event setup
        var canvas = Module['canvas'];
        canvas.requestPointerLock = canvas['requestPointerLock'] ||
                                    canvas['mozRequestPointerLock'] ||
                                    canvas['webkitRequestPointerLock'];
        canvas.exitPointerLock = document['exitPointerLock'] ||
                                 document['mozExitPointerLock'] ||
                                 document['webkitExitPointerLock'] ||
                                 function(){}; // no-op if function does not exist
        canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
        function pointerLockChange() {
          Browser.pointerLock = document['pointerLockElement'] === canvas ||
                                document['mozPointerLockElement'] === canvas ||
                                document['webkitPointerLockElement'] === canvas;
        }
        document.addEventListener('pointerlockchange', pointerLockChange, false);
        document.addEventListener('mozpointerlockchange', pointerLockChange, false);
        document.addEventListener('webkitpointerlockchange', pointerLockChange, false);
        if (Module['elementPointerLock']) {
          canvas.addEventListener("click", function(ev) {
            if (!Browser.pointerLock && canvas.requestPointerLock) {
              canvas.requestPointerLock();
              ev.preventDefault();
            }
          }, false);
        }
      },createContext:function (canvas, useWebGL, setInModule) {
        var ctx;
        try {
          if (useWebGL) {
            ctx = canvas.getContext('experimental-webgl', {
              alpha: false
            });
          } else {
            ctx = canvas.getContext('2d');
          }
          if (!ctx) throw ':(';
        } catch (e) {
          Module.print('Could not create canvas - ' + e);
          return null;
        }
        if (useWebGL) {
          // Set the background of the WebGL canvas to black
          canvas.style.backgroundColor = "black";
          // Warn on context loss
          canvas.addEventListener('webglcontextlost', function(event) {
            alert('WebGL context lost. You will need to reload the page.');
          }, false);
        }
        if (setInModule) {
          Module.ctx = ctx;
          Module.useWebGL = useWebGL;
          Browser.moduleContextCreatedCallbacks.forEach(function(callback) { callback() });
          Browser.init();
        }
        return ctx;
      },destroyContext:function (canvas, useWebGL, setInModule) {},fullScreenHandlersInstalled:false,lockPointer:undefined,resizeCanvas:undefined,requestFullScreen:function (lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === 'undefined') Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === 'undefined') Browser.resizeCanvas = false;
        var canvas = Module['canvas'];
        function fullScreenChange() {
          Browser.isFullScreen = false;
          if ((document['webkitFullScreenElement'] || document['webkitFullscreenElement'] ||
               document['mozFullScreenElement'] || document['mozFullscreenElement'] ||
               document['fullScreenElement'] || document['fullscreenElement']) === canvas) {
            canvas.cancelFullScreen = document['cancelFullScreen'] ||
                                      document['mozCancelFullScreen'] ||
                                      document['webkitCancelFullScreen'];
            canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
            if (Browser.lockPointer) canvas.requestPointerLock();
            Browser.isFullScreen = true;
            if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize();
          } else if (Browser.resizeCanvas){
            Browser.setWindowedCanvasSize();
          }
          if (Module['onFullScreen']) Module['onFullScreen'](Browser.isFullScreen);
        }
        if (!Browser.fullScreenHandlersInstalled) {
          Browser.fullScreenHandlersInstalled = true;
          document.addEventListener('fullscreenchange', fullScreenChange, false);
          document.addEventListener('mozfullscreenchange', fullScreenChange, false);
          document.addEventListener('webkitfullscreenchange', fullScreenChange, false);
        }
        canvas.requestFullScreen = canvas['requestFullScreen'] ||
                                   canvas['mozRequestFullScreen'] ||
                                   (canvas['webkitRequestFullScreen'] ? function() { canvas['webkitRequestFullScreen'](Element['ALLOW_KEYBOARD_INPUT']) } : null);
        canvas.requestFullScreen();
      },requestAnimationFrame:function (func) {
        if (!window.requestAnimationFrame) {
          window.requestAnimationFrame = window['requestAnimationFrame'] ||
                                         window['mozRequestAnimationFrame'] ||
                                         window['webkitRequestAnimationFrame'] ||
                                         window['msRequestAnimationFrame'] ||
                                         window['oRequestAnimationFrame'] ||
                                         window['setTimeout'];
        }
        window.requestAnimationFrame(func);
      },safeCallback:function (func) {
        return function() {
          if (!ABORT) return func.apply(null, arguments);
        };
      },safeRequestAnimationFrame:function (func) {
        return Browser.requestAnimationFrame(function() {
          if (!ABORT) func();
        });
      },safeSetTimeout:function (func, timeout) {
        return setTimeout(function() {
          if (!ABORT) func();
        }, timeout);
      },safeSetInterval:function (func, timeout) {
        return setInterval(function() {
          if (!ABORT) func();
        }, timeout);
      },getMimetype:function (name) {
        return {
          'jpg': 'image/jpeg',
          'jpeg': 'image/jpeg',
          'png': 'image/png',
          'bmp': 'image/bmp',
          'ogg': 'audio/ogg',
          'wav': 'audio/wav',
          'mp3': 'audio/mpeg'
        }[name.substr(name.lastIndexOf('.')+1)];
      },getUserMedia:function (func) {
        if(!window.getUserMedia) {
          window.getUserMedia = navigator['getUserMedia'] ||
                                navigator['mozGetUserMedia'];
        }
        window.getUserMedia(func);
      },getMovementX:function (event) {
        return event['movementX'] ||
               event['mozMovementX'] ||
               event['webkitMovementX'] ||
               0;
      },getMovementY:function (event) {
        return event['movementY'] ||
               event['mozMovementY'] ||
               event['webkitMovementY'] ||
               0;
      },mouseX:0,mouseY:0,mouseMovementX:0,mouseMovementY:0,calculateMouseEvent:function (event) { // event should be mousemove, mousedown or mouseup
        if (Browser.pointerLock) {
          // When the pointer is locked, calculate the coordinates
          // based on the movement of the mouse.
          // Workaround for Firefox bug 764498
          if (event.type != 'mousemove' &&
              ('mozMovementX' in event)) {
            Browser.mouseMovementX = Browser.mouseMovementY = 0;
          } else {
            Browser.mouseMovementX = Browser.getMovementX(event);
            Browser.mouseMovementY = Browser.getMovementY(event);
          }
          // check if SDL is available
          if (typeof SDL != "undefined") {
          	Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
          	Browser.mouseY = SDL.mouseY + Browser.mouseMovementY;
          } else {
          	// just add the mouse delta to the current absolut mouse position
          	// FIXME: ideally this should be clamped against the canvas size and zero
          	Browser.mouseX += Browser.mouseMovementX;
          	Browser.mouseY += Browser.mouseMovementY;
          }        
        } else {
          // Otherwise, calculate the movement based on the changes
          // in the coordinates.
          var rect = Module["canvas"].getBoundingClientRect();
          var x, y;
          if (event.type == 'touchstart' ||
              event.type == 'touchend' ||
              event.type == 'touchmove') {
            var t = event.touches.item(0);
            if (t) {
              x = t.pageX - (window.scrollX + rect.left);
              y = t.pageY - (window.scrollY + rect.top);
            } else {
              return;
            }
          } else {
            x = event.pageX - (window.scrollX + rect.left);
            y = event.pageY - (window.scrollY + rect.top);
          }
          // the canvas might be CSS-scaled compared to its backbuffer;
          // SDL-using content will want mouse coordinates in terms
          // of backbuffer units.
          var cw = Module["canvas"].width;
          var ch = Module["canvas"].height;
          x = x * (cw / rect.width);
          y = y * (ch / rect.height);
          Browser.mouseMovementX = x - Browser.mouseX;
          Browser.mouseMovementY = y - Browser.mouseY;
          Browser.mouseX = x;
          Browser.mouseY = y;
        }
      },xhrLoad:function (url, onload, onerror) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'arraybuffer';
        xhr.onload = function() {
          if (xhr.status == 200 || (xhr.status == 0 && xhr.response)) { // file URLs can return 0
            onload(xhr.response);
          } else {
            onerror();
          }
        };
        xhr.onerror = onerror;
        xhr.send(null);
      },asyncLoad:function (url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, function(arrayBuffer) {
          assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
          onload(new Uint8Array(arrayBuffer));
          if (!noRunDep) removeRunDependency('al ' + url);
        }, function(event) {
          if (onerror) {
            onerror();
          } else {
            throw 'Loading data file "' + url + '" failed.';
          }
        });
        if (!noRunDep) addRunDependency('al ' + url);
      },resizeListeners:[],updateResizeListeners:function () {
        var canvas = Module['canvas'];
        Browser.resizeListeners.forEach(function(listener) {
          listener(canvas.width, canvas.height);
        });
      },setCanvasSize:function (width, height, noUpdates) {
        var canvas = Module['canvas'];
        canvas.width = width;
        canvas.height = height;
        if (!noUpdates) Browser.updateResizeListeners();
      },windowedWidth:0,windowedHeight:0,setFullScreenCanvasSize:function () {
        var canvas = Module['canvas'];
        this.windowedWidth = canvas.width;
        this.windowedHeight = canvas.height;
        canvas.width = screen.width;
        canvas.height = screen.height;
        // check if SDL is available   
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags | 0x00800000; // set SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      },setWindowedCanvasSize:function () {
        var canvas = Module['canvas'];
        canvas.width = this.windowedWidth;
        canvas.height = this.windowedHeight;
        // check if SDL is available       
        if (typeof SDL != "undefined") {
        	var flags = HEAPU32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)];
        	flags = flags & ~0x00800000; // clear SDL_FULLSCREEN flag
        	HEAP32[((SDL.screen+Runtime.QUANTUM_SIZE*0)>>2)]=flags
        }
        Browser.updateResizeListeners();
      }};
FS.staticInit();__ATINIT__.unshift({ func: function() { if (!Module["noFSInit"] && !FS.init.initialized) FS.init() } });__ATMAIN__.push({ func: function() { FS.ignorePermissions = false } });__ATEXIT__.push({ func: function() { FS.quit() } });Module["FS_createFolder"] = FS.createFolder;Module["FS_createPath"] = FS.createPath;Module["FS_createDataFile"] = FS.createDataFile;Module["FS_createPreloadedFile"] = FS.createPreloadedFile;Module["FS_createLazyFile"] = FS.createLazyFile;Module["FS_createLink"] = FS.createLink;Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4); HEAP32[((___errno_state)>>2)]=0;
_llvm_eh_exception.buf = allocate(12, "void*", ALLOC_STATIC);
Module["requestFullScreen"] = function(lockPointer, resizeCanvas) { Browser.requestFullScreen(lockPointer, resizeCanvas) };
  Module["requestAnimationFrame"] = function(func) { Browser.requestAnimationFrame(func) };
  Module["setCanvasSize"] = function(width, height, noUpdates) { Browser.setCanvasSize(width, height, noUpdates) };
  Module["pauseMainLoop"] = function() { Browser.mainLoop.pause() };
  Module["resumeMainLoop"] = function() { Browser.mainLoop.resume() };
  Module["getUserMedia"] = function() { Browser.getUserMedia() }
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true; // seal the static portion of memory
STACK_MAX = STACK_BASE + 5242880;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY); // Stack must fit in TOTAL_MEMORY; allocations from here on may enlarge TOTAL_MEMORY
var Math_min = Math.min;
function invoke_viiiii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiif(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_iiiiiif"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vif(index,a1,a2) {
  try {
    Module["dynCall_vif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viifii(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viifii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiifffffif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    Module["dynCall_viiiifffffif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vi(index,a1) {
  try {
    Module["dynCall_vi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiffii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    return Module["dynCall_iiiiiffii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vii(index,a1,a2) {
  try {
    Module["dynCall_vii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiifii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiifii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ifffffffff(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    return Module["dynCall_ifffffffff"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiif(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viiiif"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiffffii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    Module["dynCall_viiiiffffii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ii(index,a1) {
  try {
    return Module["dynCall_ii"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiifif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    return Module["dynCall_iiiiiiifif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifffi(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_vifffi"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ifiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_ifiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viifi(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viifi"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiff(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiff"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiifiii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    return Module["dynCall_iiiifiii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13) {
  try {
    return Module["dynCall_iiiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12,a13);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viffff(index,a1,a2,a3,a4,a5) {
  try {
    Module["dynCall_viffff"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viffiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viffiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    return Module["dynCall_iiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fififii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_fififii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    return Module["dynCall_fiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiifii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_fiifii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ifff(index,a1,a2,a3) {
  try {
    return Module["dynCall_ifff"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiff(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiff"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iifi(index,a1,a2,a3) {
  try {
    return Module["dynCall_iifi"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiifffffi(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    Module["dynCall_viiiifffffi"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fif(index,a1,a2) {
  try {
    return Module["dynCall_fif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiff(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiff"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viff(index,a1,a2,a3) {
  try {
    Module["dynCall_viff"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifi(index,a1,a2,a3) {
  try {
    Module["dynCall_vifi"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiif(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiif"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifff(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_vifff"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_viiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiff(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_fiiff"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiif(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    return Module["dynCall_iiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viffffff(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viffffff"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiii(index,a1,a2,a3) {
  try {
    return Module["dynCall_fiii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    return Module["dynCall_iiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiif(index,a1,a2,a3) {
  try {
    return Module["dynCall_fiif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    return Module["dynCall_fiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_ifii(index,a1,a2,a3) {
  try {
    return Module["dynCall_ifii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiffiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    return Module["dynCall_fiffiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12) {
  try {
    return Module["dynCall_iiiiiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11,a12);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_fiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iif(index,a1,a2) {
  try {
    return Module["dynCall_iif"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_if(index,a1) {
  try {
    return Module["dynCall_if"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifffff(index,a1,a2,a3,a4,a5,a6) {
  try {
    Module["dynCall_vifffff"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    Module["dynCall_viiiiiiiif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_vifii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fi(index,a1) {
  try {
    return Module["dynCall_fi"](index,a1);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    Module["dynCall_viiiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iii(index,a1,a2) {
  try {
    return Module["dynCall_iii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiii(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiii"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_iiiiiii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiiiif(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    Module["dynCall_viiiiiiif"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fii(index,a1,a2) {
  try {
    return Module["dynCall_fii"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_vifffffffff(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10) {
  try {
    Module["dynCall_vifffffffff"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    return Module["dynCall_fiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iifif(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iifif"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iffff(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iffff"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiiffffiif(index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11) {
  try {
    Module["dynCall_viiiiffffiif"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiif(index,a1,a2,a3,a4,a5) {
  try {
    return Module["dynCall_iiiiif"](index,a1,a2,a3,a4,a5);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiff(index,a1,a2,a3) {
  try {
    return Module["dynCall_iiff"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiif(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiif"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_i(index) {
  try {
    return Module["dynCall_i"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiiifii(index,a1,a2,a3,a4,a5,a6,a7) {
  try {
    Module["dynCall_viiiifii"](index,a1,a2,a3,a4,a5,a6,a7);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiifffiii(index,a1,a2,a3,a4,a5,a6,a7,a8,a9) {
  try {
    return Module["dynCall_iiiifffiii"](index,a1,a2,a3,a4,a5,a6,a7,a8,a9);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viii(index,a1,a2,a3) {
  try {
    Module["dynCall_viii"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iff(index,a1,a2) {
  try {
    return Module["dynCall_iff"](index,a1,a2);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_v(index) {
  try {
    Module["dynCall_v"](index);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiiiiiii(index,a1,a2,a3,a4,a5,a6,a7,a8) {
  try {
    return Module["dynCall_iiiiiiiii"](index,a1,a2,a3,a4,a5,a6,a7,a8);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiii(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viif(index,a1,a2,a3) {
  try {
    Module["dynCall_viif"](index,a1,a2,a3);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_iiiif(index,a1,a2,a3,a4) {
  try {
    return Module["dynCall_iiiif"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_fiiifii(index,a1,a2,a3,a4,a5,a6) {
  try {
    return Module["dynCall_fiiifii"](index,a1,a2,a3,a4,a5,a6);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function invoke_viiii(index,a1,a2,a3,a4) {
  try {
    Module["dynCall_viiii"](index,a1,a2,a3,a4);
  } catch(e) {
    if (typeof e !== 'number' && e !== 'longjmp') throw e;
    asm["setThrew"](1, 0);
  }
}
function asmPrintInt(x, y) {
  Module.print('int ' + x + ',' + y);// + ' ' + new Error().stack);
}
function asmPrintFloat(x, y) {
  Module.print('float ' + x + ',' + y);// + ' ' + new Error().stack);
}
// EMSCRIPTEN_START_ASM
var asm=(function(global,env,buffer){"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.__ZTVN10__cxxabiv117__class_type_infoE|0;var n=env.__ZTVN10__cxxabiv120__si_class_type_infoE|0;var o=env.___dso_handle|0;var p=+env.NaN;var q=+env.Infinity;var r=0;var s=0;var t=0;var u=0;var v=0,w=0,x=0,y=0,z=0.0,A=0,B=0,C=0,D=0.0;var E=0;var F=0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=global.Math.floor;var P=global.Math.abs;var Q=global.Math.sqrt;var R=global.Math.pow;var S=global.Math.cos;var T=global.Math.sin;var U=global.Math.tan;var V=global.Math.acos;var W=global.Math.asin;var X=global.Math.atan;var Y=global.Math.atan2;var Z=global.Math.exp;var _=global.Math.log;var $=global.Math.ceil;var aa=global.Math.imul;var ab=env.abort;var ac=env.assert;var ad=env.asmPrintInt;var ae=env.asmPrintFloat;var af=env.min;var ag=env.jsCall;var ah=env.invoke_viiiii;var ai=env.invoke_iiiiiif;var aj=env.invoke_vif;var ak=env.invoke_viifii;var al=env.invoke_viiiifffffif;var am=env.invoke_vi;var an=env.invoke_iiiiiffii;var ao=env.invoke_vii;var ap=env.invoke_viiifii;var aq=env.invoke_ifffffffff;var ar=env.invoke_viiiif;var as=env.invoke_viiiiffffii;var at=env.invoke_ii;var au=env.invoke_iiiiiiifif;var av=env.invoke_vifffi;var aw=env.invoke_ifiii;var ax=env.invoke_viifi;var ay=env.invoke_viiiiiiiii;var az=env.invoke_viiiiiiff;var aA=env.invoke_iiiifiii;var aB=env.invoke_iiiiiiiiiiiiii;var aC=env.invoke_viffff;var aD=env.invoke_viffiii;var aE=env.invoke_iiiiiiiiiiii;var aF=env.invoke_fififii;var aG=env.invoke_fiiiiiiiiiii;var aH=env.invoke_fiifii;var aI=env.invoke_ifff;var aJ=env.invoke_viiff;var aK=env.invoke_iifi;var aL=env.invoke_iiii;var aM=env.invoke_viiiifffffi;var aN=env.invoke_fif;var aO=env.invoke_iiiiff;var aP=env.invoke_viff;var aQ=env.invoke_vifi;var aR=env.invoke_viiiiif;var aS=env.invoke_vifff;var aT=env.invoke_viiiiii;var aU=env.invoke_fiiff;var aV=env.invoke_iiif;var aW=env.invoke_iiiiiiii;var aX=env.invoke_viiiiiiii;var aY=env.invoke_viffffff;var aZ=env.invoke_fiii;var a_=env.invoke_iiiiiiiiii;var a$=env.invoke_fiif;var a0=env.invoke_fiiiiiiiiii;var a1=env.invoke_ifii;var a2=env.invoke_fiffiiiiiii;var a3=env.invoke_iiiiiiiiiiiii;var a4=env.invoke_fiiiii;var a5=env.invoke_iif;var a6=env.invoke_if;var a7=env.invoke_vifffff;var a8=env.invoke_viiiiiiiif;var a9=env.invoke_vifii;var ba=env.invoke_fi;var bb=env.invoke_viiiiiiiiii;var bc=env.invoke_iii;var bd=env.invoke_iiiiii;var be=env.invoke_iiiiiii;var bf=env.invoke_viiiiiiif;var bg=env.invoke_fii;var bh=env.invoke_vifffffffff;var bi=env.invoke_fiiiiiiii;var bj=env.invoke_iifif;var bk=env.invoke_iffff;var bl=env.invoke_viiiiffffiif;var bm=env.invoke_iiiiif;var bn=env.invoke_iiff;var bo=env.invoke_viiif;var bp=env.invoke_i;var bq=env.invoke_viiiifii;var br=env.invoke_iiiifffiii;var bs=env.invoke_viii;var bt=env.invoke_iff;var bu=env.invoke_v;var bv=env.invoke_iiiiiiiii;var bw=env.invoke_iiiii;var bx=env.invoke_viif;var by=env.invoke_iiiif;var bz=env.invoke_fiiifii;var bA=env.invoke_viiii;var bB=env._llvm_lifetime_end;var bC=env._cosf;var bD=env._fabsf;var bE=env._sysconf;var bF=env.___cxa_throw;var bG=env._atexit;var bH=env._abort;var bI=env._fprintf;var bJ=env._llvm_eh_exception;var bK=env._printf;var bL=env._acosf;var bM=env._fflush;var bN=env._sqrtf;var bO=env._write;var bP=env.___setErrNo;var bQ=env._fwrite;var bR=env._send;var bS=env._llvm_pow_f32;var bT=env._llvm_umul_with_overflow_i32;var bU=env._exit;var bV=env._atan2f;var bW=env.___cxa_pure_virtual;var bX=env._llvm_bswap_i16;var bY=env.__formatString;var bZ=env.__reallyNegative;var b_=env._time;var b$=env._asinf;var b0=env.___cxa_does_inherit;var b1=env.___cxa_guard_acquire;var b2=env.__ZSt9terminatev;var b3=env._gettimeofday;var b4=env.___cxa_find_matching_catch;var b5=env._sinf;var b6=env.__ZN20btAxisSweep3InternalItE26processAllOverlappingPairsEP17btOverlapCallback;var b7=env.___assert_func;var b8=env.__ZSt18uncaught_exceptionv;var b9=env._pwrite;var ca=env.___cxa_call_unexpected;var cb=env._sbrk;var cc=env.___cxa_guard_abort;var cd=env.___cxa_allocate_exception;var ce=env.___errno_location;var cf=env.___gxx_personality_v0;var cg=env.__ZN20btAxisSweep3InternalIjE26processAllOverlappingPairsEP17btOverlapCallback;var ch=env._llvm_lifetime_start;var ci=env.___cxa_is_number_type;var cj=env._llvm_bswap_i32;var ck=env._fmod;var cl=env.___cxa_guard_release;var cm=env.__exit;var cn=env.___resumeException;
// EMSCRIPTEN_START_FUNCS
function dJ(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+7>>3<<3;return b|0}function dK(){return i|0}function dL(a){a=a|0;i=a}function dM(a,b){a=a|0;b=b|0;if((r|0)==0){r=a;s=b}}function dN(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0]}function dO(b){b=b|0;a[k]=a[b];a[k+1|0]=a[b+1|0];a[k+2|0]=a[b+2|0];a[k+3|0]=a[b+3|0];a[k+4|0]=a[b+4|0];a[k+5|0]=a[b+5|0];a[k+6|0]=a[b+6|0];a[k+7|0]=a[b+7|0]}function dP(a){a=a|0;E=a}function dQ(a){a=a|0;F=a}function dR(a){a=a|0;G=a}function dS(a){a=a|0;H=a}function dT(a){a=a|0;I=a}function dU(a){a=a|0;J=a}function dV(a){a=a|0;K=a}function dW(a){a=a|0;L=a}function dX(a){a=a|0;M=a}function dY(a){a=a|0;N=a}function dZ(){c[n+8>>2]=512;c[n+12>>2]=384;c[n+16>>2]=82;c[n+20>>2]=488;c[n+24>>2]=174;c[n+28>>2]=80;c[n+32>>2]=104;c[n+36>>2]=224;c[m+8>>2]=512;c[m+12>>2]=440;c[m+16>>2]=82;c[m+20>>2]=488;c[m+24>>2]=174;c[m+28>>2]=52;c[m+32>>2]=96;c[m+36>>2]=544;c[8500]=n+8;c[8504]=n+8;c[8508]=n+8;c[8512]=n+8;c[8516]=n+8;c[8520]=n+8;c[8524]=n+8;c[8528]=n+8;c[8532]=n+8;c[8536]=n+8;c[8540]=n+8;c[8544]=n+8;c[8548]=n+8;c[8552]=n+8;c[8556]=n+8;c[8560]=n+8;c[8564]=n+8;c[8568]=n+8;c[8572]=n+8;c[8576]=n+8;c[8580]=n+8;c[8584]=n+8;c[8588]=m+8;c[8590]=m+8;c[8592]=n+8;c[8596]=m+8;c[8598]=m+8;c[8600]=n+8;c[8604]=n+8;c[8608]=n+8;c[8612]=n+8;c[8616]=n+8;c[8620]=n+8;c[8624]=n+8;c[8628]=n+8;c[8632]=m+8;c[8634]=n+8;c[8638]=n+8;c[8642]=n+8;c[8646]=n+8;c[8650]=n+8;c[8654]=m+8;c[8656]=m+8;c[8658]=m+8;c[8660]=m+8;c[8662]=n+8;c[8666]=n+8;c[8670]=n+8;c[8674]=n+8;c[8678]=m+8;c[8680]=n+8;c[8684]=n+8;c[8688]=n+8;c[8692]=n+8;c[8696]=n+8;c[8700]=n+8;c[8704]=n+8;c[8708]=n+8;c[8712]=m+8;c[8714]=n+8;c[8718]=n+8;c[8722]=n+8;c[8726]=m+8;c[8728]=m+8;c[8730]=n+8;c[8734]=n+8;c[8738]=n+8;c[8742]=n+8;c[8746]=n+8;c[8750]=n+8;c[8754]=n+8;c[8758]=n+8;c[8762]=n+8;c[8766]=n+8;c[8770]=n+8;c[8774]=n+8;c[8778]=m+8;c[8780]=m+8;c[8782]=n+8;c[8786]=n+8;c[8790]=n+8;c[8794]=n+8;c[8798]=n+8;c[8802]=n+8;c[8806]=n+8;c[8810]=n+8;c[8814]=m+8;c[8816]=m+8;c[8818]=m+8;c[8820]=n+8;c[8824]=n+8;c[8828]=n+8;c[8832]=n+8;c[8836]=n+8;c[8840]=n+8;c[8844]=n+8;c[8848]=n+8;c[8852]=n+8;c[8856]=n+8;c[8860]=n+8;c[8864]=n+8;c[8868]=n+8;c[8872]=n+8;c[8876]=n+8;c[8880]=n+8;c[8884]=n+8;c[8888]=n+8;c[8892]=m+8;c[8894]=n+8;c[8898]=n+8;c[8902]=n+8;c[8906]=m+8;c[8908]=n+8;c[8912]=n+8;c[8916]=m+8;c[8918]=n+8;c[8922]=n+8;c[8926]=n+8;c[8930]=n+8;c[8934]=n+8;c[8938]=n+8;c[8942]=n+8;c[8946]=m+8;c[8948]=m+8;c[8950]=n+8;c[8954]=n+8;c[8958]=n+8;c[8962]=n+8;c[8966]=n+8;c[8970]=n+8;c[8974]=m+8;c[8976]=m+8;c[8984]=m+8;c[8986]=n+8;c[8990]=n+8;c[8994]=n+8;c[8998]=m+8;c[9e3]=m+8;c[9002]=n+8;c[9014]=n+8;c[9018]=n+8;c[9022]=n+8;c[9026]=n+8;c[9030]=n+8;c[9034]=n+8;c[9038]=n+8;c[9042]=m+8;c[9044]=m+8;c[9046]=n+8;c[9050]=n+8;c[9054]=n+8;c[9058]=n+8;c[9062]=n+8;c[9066]=n+8;c[9070]=n+8;c[9074]=n+8;c[9078]=n+8;c[9082]=n+8;c[9086]=n+8;c[9090]=m+8;c[9092]=n+8;c[9096]=n+8;c[9100]=n+8;c[9104]=m+8;c[9106]=n+8;c[9110]=m+8;c[9112]=n+8;c[9116]=n+8;c[9120]=n+8;c[9124]=m+8;c[9126]=m+8;c[9128]=n+8;c[9132]=n+8;c[9136]=n+8;c[9140]=n+8;c[9144]=n+8;c[9148]=n+8}function d_(a){a=a|0;return 44}function d$(a,b,c,d,e,f,h,i,j,k){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0;l=a+48|0;m=a|0;do{m=m+16|0;}while((m|0)!=(l|0));g[a>>2]=+g[b>>2];g[a+4>>2]=+g[c>>2];g[a+8>>2]=+g[d>>2];g[a+12>>2]=0.0;g[a+16>>2]=+g[e>>2];g[a+20>>2]=+g[f>>2];g[a+24>>2]=+g[h>>2];g[a+28>>2]=0.0;g[a+32>>2]=+g[i>>2];g[a+36>>2]=+g[j>>2];g[a+40>>2]=+g[k>>2];g[a+44>>2]=0.0;return}function d0(a,b){a=a|0;b=b|0;var c=0,d=0;c=0;while(1){if((c|0)<3){d=0}else{break}while(1){if((d|0)>=4){break}g[b+(c<<4)+(d<<2)>>2]=+g[a+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}return}function d1(a,b){a=a|0;b=b|0;var c=0,d=0;c=0;while(1){if((c|0)<3){d=0}else{break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+h[b+(c<<5)+(d<<3)>>3];d=d+1|0}c=c+1|0}return}function d2(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0,t=0.0;c=a|0;d=a+4|0;e=+g[d>>2]- +g[b+4>>2];f=a+8|0;h=+g[f>>2]- +g[b+8>>2];i=a+16|0;j=+g[i>>2]- +g[b+16>>2];k=a+20|0;l=+g[k>>2]- +g[b+20>>2];m=a+24|0;n=+g[m>>2]- +g[b+24>>2];o=a+32|0;p=+g[o>>2]- +g[b+32>>2];q=a+36|0;r=+g[q>>2]- +g[b+36>>2];s=a+40|0;t=+g[s>>2]- +g[b+40>>2];g[c>>2]=+g[c>>2]- +g[b>>2];g[d>>2]=e;g[f>>2]=h;g[a+12>>2]=0.0;g[i>>2]=j;g[k>>2]=l;g[m>>2]=n;g[a+28>>2]=0.0;g[o>>2]=p;g[q>>2]=r;g[s>>2]=t;g[a+44>>2]=0.0;return a|0}function d3(a,b){a=a|0;b=b|0;return+(+g[a+8>>2]*+g[b>>2]+ +g[a+24>>2]*+g[b+4>>2]+ +g[a+40>>2]*+g[b+8>>2])}function d4(a,b){a=a|0;b=b|0;var c=0,d=0;c=0;while(1){if((c|0)<3){d=0}else{break}while(1){if((d|0)>=4){break}g[b+(c<<4)+(d<<2)>>2]=+g[a+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}return}function d5(a,b){a=a|0;b=b|0;return+(+g[a>>2]*+g[b>>2]+ +g[a+16>>2]*+g[b+4>>2]+ +g[a+32>>2]*+g[b+8>>2])}function d6(a,b){a=a|0;b=b|0;return+(+g[a+4>>2]*+g[b>>2]+ +g[a+20>>2]*+g[b+4>>2]+ +g[a+36>>2]*+g[b+8>>2])}function d7(b,c){b=b|0;c=c|0;var d=0.0,e=0.0;do{if((a[43976]|0)==0){if((b1(43976)|0)==0){break}}}while(0);d=+g[b+16+(c<<2)>>2];e=+g[b+32+(c<<2)>>2];g[9778]=+g[b+(c<<2)>>2];g[9779]=d;g[9780]=e;g[9781]=0.0;return 39112}function d8(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0;e=i;i=i+120|0;f=e|0;h=e+8|0;j=e+16|0;k=e+24|0;l=e+32|0;m=e+40|0;n=e+48|0;o=e+56|0;p=e+64|0;q=e+72|0;do{if((a[44104]|0)==0){if((b1(44104)|0)==0){break}else{r=39064}do{r=r+16|0;}while((r|0)!=39112)}}while(0);s=+g[d>>2];g[f>>2]=+g[b>>2]*s;t=+g[d+4>>2];g[h>>2]=+g[b+4>>2]*t;u=+g[d+8>>2];g[j>>2]=+g[b+8>>2]*u;g[k>>2]=+g[b+16>>2]*s;g[l>>2]=+g[b+20>>2]*t;g[m>>2]=+g[b+24>>2]*u;g[n>>2]=+g[b+32>>2]*s;g[o>>2]=+g[b+36>>2]*t;g[p>>2]=+g[b+40>>2]*u;d$(q,f,h,j,k,l,m,n,o,p);p=q;c[9766]=c[p>>2];c[9767]=c[p+4>>2];c[9768]=c[p+8>>2];c[9769]=c[p+12>>2];p=q+16|0;c[9770]=c[p>>2];c[39084>>2]=c[p+4>>2];c[39088>>2]=c[p+8>>2];c[39092>>2]=c[p+12>>2];p=q+32|0;c[9774]=c[p>>2];c[39100>>2]=c[p+4>>2];c[39104>>2]=c[p+8>>2];c[39108>>2]=c[p+12>>2];i=e;return 39064}function d9(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+48|0;f=e|0;do{if((a[43888]|0)==0){if((b1(43888)|0)==0){break}else{g=38264}do{g=g+16|0;}while((g|0)!=38312)}}while(0);ea(f,b,d);d=f;c[9566]=c[d>>2];c[9567]=c[d+4>>2];c[9568]=c[d+8>>2];c[9569]=c[d+12>>2];d=f+16|0;c[9570]=c[d>>2];c[38284>>2]=c[d+4>>2];c[38288>>2]=c[d+8>>2];c[38292>>2]=c[d+12>>2];d=f+32|0;c[9574]=c[d>>2];c[38300>>2]=c[d+4>>2];c[38304>>2]=c[d+8>>2];c[38308>>2]=c[d+12>>2];i=e;return 38264}function ea(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;d=i;i=i+72|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+40|0;m=d+48|0;n=d+56|0;o=d+64|0;p=+g[b>>2];q=+g[c>>2];r=+g[b+16>>2];s=+g[c+16>>2];t=+g[b+32>>2];u=+g[c+32>>2];g[e>>2]=p*q+r*s+t*u;v=+g[c+4>>2];w=+g[c+20>>2];x=+g[c+36>>2];g[f>>2]=p*v+r*w+t*x;y=+g[c+8>>2];z=+g[c+24>>2];A=+g[c+40>>2];g[h>>2]=p*y+r*z+t*A;t=+g[b+4>>2];r=+g[b+20>>2];p=+g[b+36>>2];g[j>>2]=t*q+r*s+p*u;g[k>>2]=t*v+r*w+p*x;g[l>>2]=t*y+r*z+p*A;p=+g[b+8>>2];r=+g[b+24>>2];t=+g[b+40>>2];g[m>>2]=p*q+r*s+t*u;g[n>>2]=p*v+r*w+t*x;g[o>>2]=p*y+r*z+t*A;d$(a,e,f,h,j,k,l,m,n,o);i=d;return}function eb(a,b){a=a|0;b=b|0;ec(a,b);return}function ec(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;c=i;i=i+16|0;d=c|0;e=+g[a>>2];f=+g[a+20>>2];h=+g[a+40>>2];j=e+f+h;if(j>0.0){k=+Q(+(j+1.0));j=k*.5;g[d+12>>2]=j;l=.5/k;k=(+g[a+36>>2]- +g[a+24>>2])*l;g[d>>2]=k;m=(+g[a+8>>2]- +g[a+32>>2])*l;g[d+4>>2]=m;n=(+g[a+16>>2]- +g[a+4>>2])*l;g[d+8>>2]=n;o=k;p=m;q=n;r=j;s=b|0;g[s>>2]=o;t=b+4|0;g[t>>2]=p;u=b+8|0;g[u>>2]=q;v=b+12|0;g[v>>2]=r;i=c;return}if(e<f){w=f<h?2:1}else{w=e<h?2:0}x=((w+1|0)>>>0)%3|0;y=((w+2|0)>>>0)%3|0;h=+Q(+(+g[a+(w<<4)+(w<<2)>>2]- +g[a+(x<<4)+(x<<2)>>2]- +g[a+(y<<4)+(y<<2)>>2]+1.0));g[d+(w<<2)>>2]=h*.5;e=.5/h;z=d+12|0;g[z>>2]=(+g[a+(y<<4)+(x<<2)>>2]- +g[a+(x<<4)+(y<<2)>>2])*e;g[d+(x<<2)>>2]=(+g[a+(x<<4)+(w<<2)>>2]+ +g[a+(w<<4)+(x<<2)>>2])*e;g[d+(y<<2)>>2]=(+g[a+(y<<4)+(w<<2)>>2]+ +g[a+(w<<4)+(y<<2)>>2])*e;o=+g[d>>2];p=+g[d+4>>2];q=+g[d+8>>2];r=+g[z>>2];s=b|0;g[s>>2]=o;t=b+4|0;g[t>>2]=p;u=b+8|0;g[u>>2]=q;v=b+12|0;g[v>>2]=r;i=c;return}function ed(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;i=i+120|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+40|0;m=d+48|0;n=d+56|0;o=d+64|0;p=d+72|0;do{if((a[44032]|0)==0){if((b1(44032)|0)==0){break}else{q=38056}do{q=q+16|0;}while((q|0)!=38104)}}while(0);g[e>>2]=+P(+(+g[b>>2]));g[f>>2]=+P(+(+g[b+4>>2]));g[h>>2]=+P(+(+g[b+8>>2]));g[j>>2]=+P(+(+g[b+16>>2]));g[k>>2]=+P(+(+g[b+20>>2]));g[l>>2]=+P(+(+g[b+24>>2]));g[m>>2]=+P(+(+g[b+32>>2]));g[n>>2]=+P(+(+g[b+36>>2]));g[o>>2]=+P(+(+g[b+40>>2]));d$(p,e,f,h,j,k,l,m,n,o);o=p;c[9514]=c[o>>2];c[9515]=c[o+4>>2];c[9516]=c[o+8>>2];c[9517]=c[o+12>>2];o=p+16|0;c[9518]=c[o>>2];c[38076>>2]=c[o+4>>2];c[38080>>2]=c[o+8>>2];c[38084>>2]=c[o+12>>2];o=p+32|0;c[9522]=c[o>>2];c[38092>>2]=c[o+4>>2];c[38096>>2]=c[o+8>>2];c[38100>>2]=c[o+12>>2];i=d;return 38056}function ee(){var a=0,b=0,d=0,e=0;while(1){a=aDx(48)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=65;break}dC[b&63]()}if((d|0)==65){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=a;b=a+48|0;e=a;do{e=e+16|0;}while((e|0)!=(b|0));return d|0}function ef(a){a=a|0;var b=0,d=0,e=0,f=0;while(1){b=aDx(48)|0;if((b|0)!=0){break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){e=79;break}dC[d&63]()}if((e|0)==79){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}e=b;d=b+48|0;f=b;do{f=f+16|0;}while((f|0)!=(d|0));em(e,a);return e|0}function eg(a,b,d,e,f,h,j,k,l){a=+a;b=+b;d=+d;e=+e;f=+f;h=+h;j=+j;k=+k;l=+l;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;m=i;i=i+72|0;n=m|0;o=m+8|0;p=m+16|0;q=m+24|0;r=m+32|0;s=m+40|0;t=m+48|0;u=m+56|0;v=m+64|0;g[n>>2]=a;g[o>>2]=b;g[p>>2]=d;g[q>>2]=e;g[r>>2]=f;g[s>>2]=h;g[t>>2]=j;g[u>>2]=k;g[v>>2]=l;while(1){w=aDx(48)|0;if((w|0)!=0){x=96;break}y=(C=c[10744]|0,c[10744]=C+0,C);if((y|0)==0){break}dC[y&63]()}if((x|0)==96){x=w;d$(x,n,o,p,q,r,s,t,u,v);i=m;return x|0}x=cd(4)|0;c[x>>2]=19096;bF(x|0,34368,676);return 0}function eh(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return+(+g[a+(b<<4)+(c<<2)>>2]*+g[a+(d<<4)+(e<<2)>>2]- +g[a+(b<<4)+(e<<2)>>2]*+g[a+(d<<4)+(c<<2)>>2])}function ei(a,b){a=a|0;b=b|0;var c=0,d=0;c=0;while(1){if((c|0)<3){d=0}else{break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+g[b+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}return}function ej(a,b){a=a|0;b=b|0;return a+(b<<4)|0}function ek(a,b){a=a|0;b=b|0;var c=0,d=0,e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0,t=0.0;c=a|0;d=a+4|0;e=+g[d>>2]+ +g[b+4>>2];f=a+8|0;h=+g[f>>2]+ +g[b+8>>2];i=a+16|0;j=+g[i>>2]+ +g[b+16>>2];k=a+20|0;l=+g[k>>2]+ +g[b+20>>2];m=a+24|0;n=+g[m>>2]+ +g[b+24>>2];o=a+32|0;p=+g[o>>2]+ +g[b+32>>2];q=a+36|0;r=+g[q>>2]+ +g[b+36>>2];s=a+40|0;t=+g[s>>2]+ +g[b+40>>2];g[c>>2]=+g[c>>2]+ +g[b>>2];g[d>>2]=e;g[f>>2]=h;g[a+12>>2]=0.0;g[i>>2]=j;g[k>>2]=l;g[m>>2]=n;g[a+28>>2]=0.0;g[o>>2]=p;g[q>>2]=r;g[s>>2]=t;g[a+44>>2]=0.0;return a|0}function el(a,b){a=a|0;b=b|0;var c=0.0,d=0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;c=+g[b>>2];d=a|0;e=+g[d>>2];f=+g[b+16>>2];h=+g[a+4>>2];i=+g[b+32>>2];j=+g[a+8>>2];k=+g[b+4>>2];l=+g[b+20>>2];m=+g[b+36>>2];n=+g[b+8>>2];o=+g[b+24>>2];p=+g[b+40>>2];q=+g[a+16>>2];r=+g[a+20>>2];s=+g[a+24>>2];t=+g[a+32>>2];u=+g[a+36>>2];v=+g[a+40>>2];g[d>>2]=c*e+f*h+i*j;g[a+4>>2]=k*e+l*h+m*j;g[a+8>>2]=n*e+o*h+p*j;g[a+12>>2]=0.0;g[a+16>>2]=c*q+f*r+i*s;g[a+20>>2]=k*q+l*r+m*s;g[a+24>>2]=n*q+o*r+p*s;g[a+28>>2]=0.0;g[a+32>>2]=c*t+f*u+i*v;g[a+36>>2]=k*t+l*u+m*v;g[a+40>>2]=n*t+o*u+p*v;g[a+44>>2]=0.0;return a|0}function em(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];f=+g[b+12>>2];h=2.0/(c*c+d*d+e*e+f*f);i=c*h;j=d*h;k=e*h;h=f*i;l=f*j;m=f*k;f=c*i;i=c*j;n=c*k;c=d*j;j=d*k;d=e*k;g[a>>2]=1.0-(c+d);g[a+4>>2]=i-m;g[a+8>>2]=n+l;g[a+12>>2]=0.0;g[a+16>>2]=i+m;g[a+20>>2]=1.0-(f+d);g[a+24>>2]=j-h;g[a+28>>2]=0.0;g[a+32>>2]=n-l;g[a+36>>2]=j+h;g[a+40>>2]=1.0-(f+c);g[a+44>>2]=0.0;return}function en(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;b=+g[a+20>>2];c=+g[a+40>>2];d=+g[a+24>>2];e=+g[a+36>>2];f=+g[a+32>>2];h=+g[a+16>>2];return+(+g[a>>2]*(b*c-d*e)+ +g[a+4>>2]*(d*f-h*c)+ +g[a+8>>2]*(h*e-b*f))}function eo(a,b,c,d,e,f,h,i,j,k){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;i=+i;j=+j;k=+k;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;g[a+16>>2]=e;g[a+20>>2]=f;g[a+24>>2]=h;g[a+28>>2]=0.0;g[a+32>>2]=i;g[a+36>>2]=j;g[a+40>>2]=k;g[a+44>>2]=0.0;return}function ep(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+48|0;e=d|0;do{if((a[44056]|0)==0){if((b1(44056)|0)==0){break}else{f=37848}do{f=f+16|0;}while((f|0)!=37896)}}while(0);eq(e,b);b=e;c[9462]=c[b>>2];c[9463]=c[b+4>>2];c[9464]=c[b+8>>2];c[9465]=c[b+12>>2];b=e+16|0;c[9466]=c[b>>2];c[37868>>2]=c[b+4>>2];c[37872>>2]=c[b+8>>2];c[37876>>2]=c[b+12>>2];b=e+32|0;c[9470]=c[b>>2];c[37884>>2]=c[b+4>>2];c[37888>>2]=c[b+8>>2];c[37892>>2]=c[b+12>>2];i=d;return 37848}function eq(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;c=i;i=i+72|0;d=c|0;e=c+8|0;f=c+16|0;h=c+24|0;j=c+32|0;k=c+40|0;l=c+48|0;m=c+56|0;n=c+64|0;o=+g[b+20>>2];p=+g[b+40>>2];q=+g[b+24>>2];r=+g[b+36>>2];s=o*p-q*r;t=+g[b+32>>2];u=+g[b+16>>2];v=q*t-u*p;w=u*r-o*t;x=+g[b>>2];y=+g[b+4>>2];z=+g[b+8>>2];A=1.0/(x*s+y*v+z*w);g[d>>2]=s*A;g[e>>2]=(z*r-y*p)*A;g[f>>2]=(y*q-z*o)*A;g[h>>2]=v*A;g[j>>2]=(x*p-z*t)*A;g[k>>2]=(z*u-x*q)*A;g[l>>2]=w*A;g[m>>2]=(y*t-x*r)*A;g[n>>2]=(x*o-y*u)*A;d$(a,d,e,f,h,j,k,l,m,n);i=c;return}function er(){es();return 42816}function es(){var b=0,c=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0;b=i;i=i+72|0;c=b|0;d=b+8|0;e=b+16|0;f=b+24|0;h=b+32|0;j=b+40|0;k=b+48|0;l=b+56|0;m=b+64|0;if((a[43048]|0)!=0){i=b;return}if((b1(43048)|0)==0){i=b;return}g[c>>2]=1.0;g[d>>2]=0.0;g[e>>2]=0.0;g[f>>2]=0.0;g[h>>2]=1.0;g[j>>2]=0.0;g[k>>2]=0.0;g[l>>2]=0.0;g[m>>2]=1.0;d$(42816,c,d,e,f,h,j,k,l,m);i=b;return}function et(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;d=i;i=i+120|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+40|0;m=d+48|0;n=d+56|0;o=d+64|0;p=d+72|0;do{if((a[44064]|0)==0){if((b1(44064)|0)==0){break}else{q=37640}do{q=q+16|0;}while((q|0)!=37688)}}while(0);r=+g[b+20>>2];s=+g[b+40>>2];t=+g[b+24>>2];u=+g[b+36>>2];g[e>>2]=r*s-t*u;v=+g[b+8>>2];w=+g[b+4>>2];g[f>>2]=v*u-w*s;g[h>>2]=w*t-v*r;x=+g[b+32>>2];y=+g[b+16>>2];g[j>>2]=t*x-y*s;z=+g[b>>2];g[k>>2]=z*s-v*x;g[l>>2]=v*y-z*t;g[m>>2]=y*u-r*x;g[n>>2]=w*x-z*u;g[o>>2]=z*r-w*y;d$(p,e,f,h,j,k,l,m,n,o);o=p;c[9410]=c[o>>2];c[9411]=c[o+4>>2];c[9412]=c[o+8>>2];c[9413]=c[o+12>>2];o=p+16|0;c[9414]=c[o>>2];c[37660>>2]=c[o+4>>2];c[37664>>2]=c[o+8>>2];c[37668>>2]=c[o+12>>2];o=p+32|0;c[9418]=c[o>>2];c[37676>>2]=c[o+4>>2];c[37680>>2]=c[o+8>>2];c[37684>>2]=c[o+12>>2];i=d;return 37640}function eu(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;ev(a,b,c,d);return}function ev(a,b,c,d){a=a|0;b=b|0;c=+c;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0,r=0,s=0,t=0.0,u=0,v=0,w=0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;g[b>>2]=1.0;aDD(b+4|0,0,16);g[b+20>>2]=1.0;aDD(b+24|0,0,16);g[b+40>>2]=1.0;g[b+44>>2]=0.0;e=a+4|0;f=a+8|0;h=a+24|0;i=a|0;j=a+20|0;k=a+40|0;l=d;while(1){if((l|0)<=0){m=147;break}n=+P(+(+g[e>>2]));o=+P(+(+g[f>>2]));d=o>n;p=d?o:n;n=+P(+(+g[h>>2]));if(n>p){q=1;r=2;s=0;t=n}else{q=0;r=d?2:1;s=d?1:2;t=p}p=+P(+(+g[i>>2]));n=p+ +P(+(+g[j>>2]));p=(n+ +P(+(+g[k>>2])))*c;if(t>p){u=l}else{if(t>p*1.1920928955078125e-7){u=1}else{m=148;break}}d=a+(q<<4)+(r<<2)|0;p=+g[d>>2];v=a+(r<<4)+(r<<2)|0;w=a+(q<<4)+(q<<2)|0;n=(+g[v>>2]- +g[w>>2])/(p*2.0);o=n*n;if(o*o<83886080.0){x=+Q(+(o+1.0));if(n<0.0){y=n-x}else{y=n+x}x=1.0/y;z=1.0/+Q(+(x*x+1.0));A=z*x;B=z;C=x}else{x=1.0/(n*(.5/o+2.0));o=1.0-x*.5*x;A=o*x;B=o;C=x}g[a+(r<<4)+(q<<2)>>2]=0.0;g[d>>2]=0.0;x=C*p;g[w>>2]=+g[w>>2]-x;g[v>>2]=+g[v>>2]+x;v=a+(s<<4)+(q<<2)|0;x=+g[v>>2];w=a+(s<<4)+(r<<2)|0;p=+g[w>>2];o=B*x-A*p;g[a+(q<<4)+(s<<2)>>2]=o;g[v>>2]=o;o=B*p+A*x;g[a+(r<<4)+(s<<2)>>2]=o;g[w>>2]=o;w=0;while(1){if((w|0)>=3){break}o=+g[b+(w<<4)+(q<<2)>>2];x=+g[b+(w<<4)+(r<<2)>>2];g[b+(w<<4)+(q<<2)>>2]=B*o-A*x;g[b+(w<<4)+(r<<2)>>2]=B*x+A*o;w=w+1|0}l=u-1|0}if((m|0)==147){return}else if((m|0)==148){return}}function ew(a,b){a=a|0;b=b|0;em(a,b);return}function ex(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;ey(a,b,c,d);return}function ey(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=+S(+b);f=+S(+c);h=+S(+d);i=+T(+b);b=+T(+c);c=+T(+d);d=e*h;j=e*c;k=i*h;l=i*c;g[a>>2]=f*h;g[a+4>>2]=b*k-j;g[a+8>>2]=b*d+l;g[a+12>>2]=0.0;g[a+16>>2]=f*c;g[a+20>>2]=b*l+d;g[a+24>>2]=b*j-k;g[a+28>>2]=0.0;g[a+32>>2]=-0.0-b;g[a+36>>2]=f*i;g[a+40>>2]=f*e;g[a+44>>2]=0.0;return}function ez(a){a=a|0;g[a>>2]=1.0;aDD(a+4|0,0,16);g[a+20>>2]=1.0;aDD(a+24|0,0,16);g[a+40>>2]=1.0;g[a+44>>2]=0.0;return}function eA(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+16|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+32|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];return a|0}function eB(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0,f=0,h=0,j=0;e=i;i=i+24|0;f=e|0;h=e+8|0;j=e+16|0;g[f>>2]=b;g[h>>2]=c;g[j>>2]=d;eC(a,f,h,j,1);i=e;return}function eC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;f=+g[a+32>>2];if(+P(+f)<1.0){do{if(f<-1.0){h=-1.0}else{if(f<=1.0){h=f;break}h=1.0}}while(0);i=+W(+h);h=-0.0-i;j=i+3.1415927410125732;i=+g[a+36>>2];k=+S(+h);l=+g[a+40>>2];m=+Y(+(i/k),+(l/k));n=+S(+j);o=+Y(+(i/n),+(l/n));l=+g[a+16>>2];i=+g[a>>2];p=+Y(+(l/k),+(i/k));q=m;r=+Y(+(l/n),+(i/n));s=j;t=o;u=p;v=h}else{h=+Y(+(+g[a>>2]),+(+g[a+8>>2]))+1.5707963705062866;p=f>0.0?1.5707963705062866:-1.5707963705062866;q=h;r=0.0;s=p;t=h;u=0.0;v=p}a=(e|0)==1;g[b>>2]=a?u:r;g[c>>2]=a?v:s;g[d>>2]=a?q:t;return}function eD(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=e|0;var f=0,h=0,j=0,k=0;f=i;i=i+24|0;h=f|0;j=f+8|0;k=f+16|0;g[h>>2]=b;g[j>>2]=c;g[k>>2]=d;eC(a,h,j,k,e);i=f;return}function eE(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;ey(a,d,c,b);return}function eF(a,b){a=a|0;b=b|0;var c=0,d=0;c=0;while(1){if((c|0)<3){d=0}else{break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+g[b+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}return}function eG(a,b){a=a|0;b=b|0;return a+(b<<4)|0}function eH(b,c){b=b|0;c=c|0;a[b+24|0]=c&1;return}function eI(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function eJ(a){a=a|0;return+(+g[a+12>>2])}function eK(a){a=a|0;return c[a+4>>2]|0}function eL(b){b=b|0;return(a[b+26|0]&1)!=0|0}function eM(b){b=b|0;return(a[b+16|0]&1)!=0|0}function eN(b,c){b=b|0;c=c|0;a[b+16|0]=c&1;return}function eO(a){a=a|0;return c[a+8>>2]|0}function eP(a,b){a=a|0;b=b|0;c[a+40>>2]=b;return}function eQ(a){a=a|0;return c[a+40>>2]|0}function eR(a){a=a|0;return+(+g[a>>2])}function eS(a){a=a|0;return+(+g[a+36>>2])}function eT(b){b=b|0;return(a[b+24|0]&1)!=0|0}function eU(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function eV(a,b){a=a|0;b=+b;g[a>>2]=b;return}function eW(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function eX(b,c){b=b|0;c=c|0;a[b+32|0]=c&1;return}function eY(b){b=b|0;return(a[b+32|0]&1)!=0|0}function eZ(a){a=a|0;return+(+g[a+28>>2])}function e_(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function e$(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function e0(b){b=b|0;return(a[b+25|0]&1)!=0|0}function e1(b,c){b=b|0;c=c|0;a[b+25|0]=c&1;return}function e2(b,c){b=b|0;c=c|0;a[b+26|0]=c&1;return}function e3(a){a=a|0;return(c[a+4>>2]|0)==31|0}function e4(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function e5(a){a=a|0;return c[a+52>>2]|0}function e6(a){a=a|0;return(c[a+4>>2]|0)<7|0}function e7(a){a=a|0;return+(+g[a+28+((((c[a+52>>2]|0)+2|0)%3|0)<<2)>>2])}function e8(a){a=a|0;return+(+g[a+28+(c[a+52>>2]<<2)>>2])}function e9(a){a=a|0;return a+12|0}function fa(a){a=a|0;return+(+g[a+44>>2])}function fb(a){a=a|0;return(c[a+4>>2]|0)<20|0}function fc(a){a=a|0;return(c[a+4>>2]|0)==28|0}function fd(a){a=a|0;return c[a+8>>2]|0}function fe(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function ff(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function fg(a){a=a|0;return(c[a+4>>2]|0)==32|0}function fh(a){a=a|0;return a+28|0}function fi(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function fj(b){b=b|0;var d=0,e=0,f=0;d=i;i=i+48|0;e=d|0;do{if((a[43968]|0)==0){if((b1(43968)|0)==0){break}else{f=37432}do{f=f+16|0;}while((f|0)!=37480)}}while(0);d$(e,b|0,b+16|0,b+32|0,b+4|0,b+20|0,b+36|0,b+8|0,b+24|0,b+40|0);b=e;c[9358]=c[b>>2];c[9359]=c[b+4>>2];c[9360]=c[b+8>>2];c[9361]=c[b+12>>2];b=e+16|0;c[9362]=c[b>>2];c[37452>>2]=c[b+4>>2];c[37456>>2]=c[b+8>>2];c[37460>>2]=c[b+12>>2];b=e+32|0;c[9366]=c[b>>2];c[37468>>2]=c[b+4>>2];c[37472>>2]=c[b+8>>2];c[37476>>2]=c[b+12>>2];i=d;return 37432}function fk(a){a=a|0;if((a|0)==0){return}aDB(a);return}function fl(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;e=i;i=i+120|0;f=e|0;h=e+8|0;j=e+16|0;k=e+24|0;l=e+32|0;m=e+40|0;n=e+48|0;o=e+56|0;p=e+64|0;q=e+72|0;do{if((a[43896]|0)==0){if((b1(43896)|0)==0){break}else{r=37224}do{r=r+16|0;}while((r|0)!=37272)}}while(0);s=+g[b>>2];t=+g[d>>2];u=+g[b+4>>2];v=+g[d+4>>2];w=+g[b+8>>2];x=+g[d+8>>2];g[f>>2]=s*t+u*v+w*x;y=+g[d+16>>2];z=+g[d+20>>2];A=+g[d+24>>2];g[h>>2]=s*y+u*z+w*A;B=+g[d+32>>2];C=+g[d+36>>2];D=+g[d+40>>2];g[j>>2]=s*B+u*C+w*D;w=+g[b+16>>2];u=+g[b+20>>2];s=+g[b+24>>2];g[k>>2]=w*t+u*v+s*x;g[l>>2]=w*y+u*z+s*A;g[m>>2]=w*B+u*C+s*D;s=+g[b+32>>2];u=+g[b+36>>2];w=+g[b+40>>2];g[n>>2]=s*t+u*v+w*x;g[o>>2]=s*y+u*z+w*A;g[p>>2]=s*B+u*C+w*D;d$(q,f,h,j,k,l,m,n,o,p);p=q;c[9306]=c[p>>2];c[9307]=c[p+4>>2];c[9308]=c[p+8>>2];c[9309]=c[p+12>>2];p=q+16|0;c[9310]=c[p>>2];c[37244>>2]=c[p+4>>2];c[37248>>2]=c[p+8>>2];c[37252>>2]=c[p+12>>2];p=q+32|0;c[9314]=c[p>>2];c[37260>>2]=c[p+4>>2];c[37264>>2]=c[p+8>>2];c[37268>>2]=c[p+12>>2];i=e;return 37224}function fm(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0;d=+g[a+32>>2];do{if(d>1.0){e=-1.0}else{if(d>=-1.0){e=-0.0-d;break}e=1.0}}while(0);+P(+(+W(+e)));return}function fn(a){a=a|0;if((a|0)==0){return}aDB(a);return}function fo(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function fp(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43720]|0)==0){if((b1(43720)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9262]=c[d>>2];c[9263]=c[d+4>>2];c[9264]=c[d+8>>2];c[9265]=c[d+12>>2];i=e;return 37048}function fq(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(75)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e>>2]=25424;c[e+4>>2]=10;c[e+52>>2]=1;g[e+28>>2]=a;g[e+32>>2]=b*.5;g[e+36>>2]=a;g[e+40>>2]=0.0;return e|0}function fr(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function fs(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function ft(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function fu(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function fv(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function fw(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function fx(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43256]|0)==0){if((b1(43256)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9218]=c[d>>2];c[9219]=c[d+4>>2];c[9220]=c[d+8>>2];c[9221]=c[d+12>>2];i=e;return 36872}function fy(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43416]|0)==0){if((b1(43416)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9762]=c[d>>2];c[9763]=c[d+4>>2];c[9764]=c[d+8>>2];c[9765]=c[d+12>>2];i=e;return 39048}function fz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function fA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function fB(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43576]|0)==0){if((b1(43576)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9718]=c[d>>2];c[9719]=c[d+4>>2];c[9720]=c[d+8>>2];c[9721]=c[d+12>>2];i=e;return 38872}function fC(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function fD(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function fE(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function fF(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function fG(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function fH(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function fI(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function fJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function fK(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function fL(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function fM(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function fN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function fO(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function fP(){var b=0,d=0,e=0;while(1){b=aDx(44)|0;if((b|0)!=0){d=299;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==299){g[b>>2]=0.0;c[b+4>>2]=0;c[b+8>>2]=1;g[b+12>>2]=1.0;a[b+16|0]=1;c[b+20>>2]=0;a[b+24|0]=0;a[b+25|0]=1;a[b+26|0]=1;g[b+28>>2]=.03999999910593033;a[b+32|0]=0;g[b+36>>2]=0.0;c[b+40>>2]=0;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function fQ(a){a=a|0;return c[a+4>>2]|0}function fR(a){a=a|0;return(c[a+4>>2]|0)<20|0}function fS(a){a=a|0;return(c[a+4>>2]|0)<7|0}function fT(a){a=a|0;return c[a+104>>2]|0}function fU(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function fV(a){a=a|0;return a+12|0}function fW(a){a=a|0;return+(+g[a+44>>2])}function fX(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function fY(a){a=a|0;return(c[a+4>>2]|0)==28|0}function fZ(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function f_(a){a=a|0;return c[a+8>>2]|0}function f$(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function f0(a){a=a|0;return(c[a+4>>2]|0)==32|0}function f1(a){a=a|0;return c[a+104>>2]|0}function f2(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function f3(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a)|0}function f4(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43632]|0)==0){if((b1(43632)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9674]=c[d>>2];c[9675]=c[d+4>>2];c[9676]=c[d+8>>2];c[9677]=c[d+12>>2];i=e;return 38696}function f5(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function f6(b,d){b=b|0;d=d|0;var e=0,f=0.0,h=0.0;do{if((a[43840]|0)==0){if((b1(43840)|0)==0){break}}}while(0);e=c[b+104>>2]|0;f=+g[e+(d<<4)+4>>2]*+g[b+16>>2];h=+g[e+(d<<4)+8>>2]*+g[b+20>>2];g[9630]=+g[e+(d<<4)>>2]*+g[b+12>>2];g[9631]=f;g[9632]=h;g[9633]=0.0;return 38520}function f7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a,b,d,e);return}function f8(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a)|0}function f9(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function ga(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function gb(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a,b,d);return}function gc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function gd(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function ge(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a)|0}function gf(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function gg(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(131)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}d=b;avo(d,0,0,16);return d|0}function gh(a){a=a|0;var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(131)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d;avo(e,a,0,16);return e|0}function gi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(131)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;avo(f,a,b,16);return f|0}function gj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[9806]=(c[9806]|0)+1;e=aDx(131)|0;if((e|0)==0){f=0}else{g=-(e+4|0)&15;c[e+g>>2]=e;f=e+(g+4)|0}g=f;avo(g,a,b,d);return g|0}function gk(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43160]|0)==0){if((b1(43160)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9598]=c[d>>2];c[9599]=c[d+4>>2];c[9600]=c[d+8>>2];c[9601]=c[d+12>>2];i=e;return 38392}function gl(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function gm(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function gn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function go(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43472]|0)==0){if((b1(43472)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9594]=c[d>>2];c[9595]=c[d+4>>2];c[9596]=c[d+8>>2];c[9597]=c[d+12>>2];i=e;return 38376}function gp(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function gq(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;e=b+96|0;f=c[e>>2]|0;g=b+100|0;do{if((f|0)==(c[g>>2]|0)){h=(f|0)==0?1:f<<1;if((f|0)>=(h|0)){i=f;break}if((h|0)==0){j=0;k=f}else{c[9806]=(c[9806]|0)+1;l=aDx((h<<4|4)+15|0)|0;if((l|0)==0){m=0}else{n=-(l+4|0)&15;c[l+n>>2]=l;m=l+(n+4)|0}j=m;k=c[e>>2]|0}n=b+104|0;if((k|0)>0){l=0;do{o=j+(l<<4)|0;if((o|0)!=0){p=o;o=(c[n>>2]|0)+(l<<4)|0;c[p>>2]=c[o>>2];c[p+4>>2]=c[o+4>>2];c[p+8>>2]=c[o+8>>2];c[p+12>>2]=c[o+12>>2]}l=l+1|0;}while((l|0)<(k|0))}l=c[n>>2]|0;o=b+108|0;if((l|0)!=0){if((a[o]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[l-16+12>>2]|0)}c[n>>2]=0}a[o]=1;c[n>>2]=j;c[g>>2]=h;i=c[e>>2]|0}else{i=f}}while(0);f=(c[b+104>>2]|0)+(i<<4)|0;if((f|0)==0){q=i;r=q+1|0;c[e>>2]=r;s=b|0;aze(s);return}i=f;f=d;c[i>>2]=c[f>>2];c[i+4>>2]=c[f+4>>2];c[i+8>>2]=c[f+8>>2];c[i+12>>2]=c[f+12>>2];q=c[e>>2]|0;r=q+1|0;c[e>>2]=r;s=b|0;aze(s);return}function gr(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function gs(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function gt(a){a=a|0;aze(a|0);return}function gu(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function gv(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function gw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;gx(a|0,b,c,d,e);return}function gx(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0;f=i;i=i+120|0;h=f|0;j=f+8|0;k=f+16|0;l=f+24|0;m=f+32|0;n=f+40|0;o=f+48|0;p=f+56|0;q=f+64|0;r=f+72|0;s=+g[a+72>>2];t=+g[a+56>>2];u=+g[a+76>>2];v=+g[a+60>>2];w=+g[a+80>>2];x=+g[a+64>>2];y=(s-t)*.5+e;z=(u-v)*.5+e;A=(w-x)*.5+e;e=(s+t)*.5;t=(u+v)*.5;v=(w+x)*.5;a=b|0;g[h>>2]=+P(+(+g[a>>2]));B=b+4|0;g[j>>2]=+P(+(+g[B>>2]));C=b+8|0;g[k>>2]=+P(+(+g[C>>2]));D=b+16|0;g[l>>2]=+P(+(+g[D>>2]));E=b+20|0;g[m>>2]=+P(+(+g[E>>2]));F=b+24|0;g[n>>2]=+P(+(+g[F>>2]));G=b+32|0;g[o>>2]=+P(+(+g[G>>2]));H=b+36|0;g[p>>2]=+P(+(+g[H>>2]));I=b+40|0;g[q>>2]=+P(+(+g[I>>2]));d$(r,h,j,k,l,m,n,o,p,q);x=+g[a>>2]*e+ +g[B>>2]*t+ +g[C>>2]*v+ +g[b+48>>2];w=+g[D>>2]*e+ +g[E>>2]*t+ +g[F>>2]*v+ +g[b+52>>2];u=+g[G>>2]*e+ +g[H>>2]*t+ +g[I>>2]*v+ +g[b+56>>2];v=+g[r>>2]*y+ +g[r+4>>2]*z+ +g[r+8>>2]*A;t=+g[r+16>>2]*y+ +g[r+20>>2]*z+ +g[r+24>>2]*A;e=+g[r+32>>2]*y+ +g[r+36>>2]*z+ +g[r+40>>2]*A;g[c>>2]=x-v;g[c+4>>2]=w-t;g[c+8>>2]=u-e;g[c+12>>2]=0.0;g[d>>2]=x+v;g[d+4>>2]=w+t;g[d+8>>2]=u+e;g[d+12>>2]=0.0;i=f;return}function gy(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43336]|0)==0){if((b1(43336)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9590]=c[d>>2];c[9591]=c[d+4>>2];c[9592]=c[d+8>>2];c[9593]=c[d+12>>2];i=e;return 38360}function gz(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 5:case 4:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function gA(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function gB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function gC(a){a=a|0;return a+28|0}function gD(a){a=a|0;return(c[a+4>>2]|0)==31|0}function gE(a){a=a|0;return c[a+52>>2]|0}function gF(a){a=a|0;return c[a+4>>2]|0}function gG(a){a=a|0;return c[a+96>>2]|0}function gH(a){a=a|0;return c[a>>2]|0}function gI(a){a=a|0;return c[a>>2]|0}function gJ(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function gK(a){a=a|0;return c[a+12>>2]|0}function gL(a){a=a|0;return c[a+16>>2]|0}function gM(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function gN(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function gO(a){a=a|0;return c[a+28>>2]|0}function gP(a){a=a|0;return c[a+20>>2]|0}function gQ(a){a=a|0;return c[a>>2]|0}function gR(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function gS(a,b){a=a|0;b=b|0;c[a+28>>2]=b;return}function gT(a){a=a|0;return c[a+24>>2]|0}function gU(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function gV(a){a=a|0;return c[a+4>>2]|0}function gW(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function gX(a,b){a=a|0;b=b|0;c[a+20>>2]=b;return}function gY(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function gZ(a){a=a|0;return c[a+8>>2]|0}function g_(a){a=a|0;return+(+g[a+224>>2])}function g$(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function g0(a){a=a|0;return+(+g[a+220>>2])}function g1(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function g2(a,b){a=a|0;b=b|0;c[a+196>>2]=b;return}function g3(a){a=a|0;var b=0;if((c[a+204>>2]&3|0)!=0){return}b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function g4(a,b){a=a|0;b=b|0;do{if(!b){if((c[a+204>>2]&3|0)==0){break}return}}while(0);b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function g5(a){a=a|0;return a+132|0}function g6(a){a=a|0;return(c[a+204>>2]&7|0)==0|0}function g7(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function g8(a){a=a|0;return c[a+208>>2]|0}function g9(a,b){a=a|0;b=b|0;c[a+212>>2]=b;return}function ha(a){a=a|0;return+(+g[a+248>>2])}function hb(a,b){a=a|0;b=b|0;c[a+236>>2]=b;return}function hc(a){a=a|0;return a+164|0}function hd(a){a=a|0;return a+148|0}function he(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function hf(a){a=a|0;return a+68|0}function hg(a,b){a=a|0;b=b|0;c[a+208>>2]=b;return}function hh(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function hi(a){a=a|0;return c[a+204>>2]|0}function hj(a){a=a|0;return(c[a+204>>2]&1|0)!=0|0}function hk(a){a=a|0;return c[a+192>>2]|0}function hl(a){a=a|0;return c[a+188>>2]|0}function hm(a){a=a|0;return+(+g[a+228>>2])}function hn(a){a=a|0;return c[a+236>>2]|0}function ho(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function hp(a){a=a|0;return a+4|0}function hq(a){a=a|0;var b=0.0;b=+g[a+248>>2];return+(b*b)}function hr(a,b){a=a|0;b=b|0;c[a+192>>2]=b;return}function hs(a){a=a|0;return c[a+212>>2]|0}function ht(a){a=a|0;var b=0;b=c[a+216>>2]|0;return((b|0)==2?0:(b|0)!=5)|0}function hu(a){a=a|0;return c[a+232>>2]|0}function hv(a){a=a|0;return c[a+216>>2]|0}function hw(a){a=a|0;return(c[a+204>>2]&4|0)==0|0}function hx(a,b){a=a|0;b=b|0;var d=0;d=a+216|0;if(((c[d>>2]|0)-4|0)>>>0<2){return}c[d>>2]=b;return}function hy(a){a=a|0;return c[a+200>>2]|0}function hz(a){a=a|0;return+(+g[a+184>>2])}function hA(a){a=a|0;return+(+g[a+240>>2])}function hB(a){a=a|0;return+(+g[a+244>>2])}function hC(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function hD(a){a=a|0;return c[a+196>>2]|0}function hE(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function hF(a){a=a|0;return(c[a+204>>2]&3|0)!=0|0}function hG(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function hH(a){a=a|0;return(c[a+180>>2]|0)!=0|0}function hI(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function hJ(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function hK(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function hL(a){a=a|0;return c[a+92>>2]|0}function hM(a){a=a|0;return(c[a+4>>2]|0)<7|0}function hN(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function hO(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a,b,d)|0}function hP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function hQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function hR(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a,b,d,e);return}function hS(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function hT(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a|0)|0}function hU(a){a=a|0;if((a|0)==0){return}aDB(a);return}function hV(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-32+28>>2]|0);return}function hW(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(51)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}c[b+24>>2]=2;c[b+28>>2]=0;return b|0}function hX(a,b){a=a|0;b=b|0;var d=0;d=a+132|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function hY(a,b){a=a|0;b=b|0;var d=0;d=a+148|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function hZ(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a,b,d)|0}function h_(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+68|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+84|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+100|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+116|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function h$(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(275)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}c[b>>2]=23736;g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749400.0;aDD(b+188|0,0,16);c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;c[b+232>>2]=1;c[b+236>>2]=0;g[b+240>>2]=1.0;g[b+244>>2]=0.0;g[b+248>>2]=0.0;c[b+252>>2]=0;g[b+4>>2]=1.0;aDD(b+8|0,0,16);g[b+24>>2]=1.0;aDD(b+28|0,0,16);g[b+44>>2]=1.0;aDD(b+48|0,0,20);return b|0}function h0(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function h1(a,b){a=a|0;b=b|0;var d=0;if((c[a+252>>2]|0)==0){d=1;return d|0}d=dj[c[c[a>>2]>>2]&511](a,b)|0;return d|0}function h2(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0}function h3(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function h4(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a+164|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];do{if(+g[b>>2]!=1.0){f=1}else{if(+g[b+4>>2]!=1.0){f=1;break}f=+g[b+8>>2]!=1.0|0}}while(0);c[a+180>>2]=f;return}function h5(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function h6(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+20|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+36|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+52|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function h7(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function h8(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a)|0}function h9(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43448]|0)==0){if((b1(43448)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9586]=c[d>>2];c[9587]=c[d+4>>2];c[9588]=c[d+8>>2];c[9589]=c[d+12>>2];i=e;return 38344}function ia(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a,b,d)|0}function ib(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a)|0}function ic(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function id(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a,b,d);return}function ie(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(4)|0;if((b|0)!=0){d=578;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==578){c[b>>2]=a;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function ig(a){a=a|0;return a+12|0}function ih(a){a=a|0;return+(+g[a+44>>2])}function ii(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function ij(a){a=a|0;return(c[a+4>>2]|0)<20|0}function ik(a){a=a|0;return(c[a+4>>2]|0)==28|0}function il(a){a=a|0;return c[a+8>>2]|0}function im(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function io(a){a=a|0;return(c[a+4>>2]|0)==32|0}function ip(a){a=a|0;return a+28|0}function iq(a){a=a|0;return(c[a+4>>2]|0)==31|0}function ir(a){a=a|0;return c[a+52>>2]|0}function is(a){a=a|0;return c[a+4>>2]|0}function it(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function iu(a){a=a|0;return+(+g[a+20>>2])}function iv(b){b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(115)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;g[e+56>>2]=1.0;g[e+60>>2]=1.0;g[e+64>>2]=1.0;g[e+68>>2]=0.0;g[e+72>>2]=-1.0;g[e+76>>2]=-1.0;g[e+80>>2]=-1.0;g[e+84>>2]=0.0;a[e+88|0]=0;c[e>>2]=20672;c[e+92>>2]=b;c[e+4>>2]=3;aze(e);return e|0}function iw(b,d){b=b|0;d=d|0;var e=0,f=0,h=0;c[9806]=(c[9806]|0)+1;e=aDx(115)|0;if((e|0)==0){f=0}else{h=-(e+4|0)&15;c[e+h>>2]=e;f=e+(h+4)|0}h=f;c[f+8>>2]=0;g[f+12>>2]=1.0;g[f+16>>2]=1.0;g[f+20>>2]=1.0;g[f+24>>2]=0.0;g[f+44>>2]=.03999999910593033;c[f+52>>2]=0;g[f+56>>2]=1.0;g[f+60>>2]=1.0;g[f+64>>2]=1.0;g[f+68>>2]=0.0;g[f+72>>2]=-1.0;g[f+76>>2]=-1.0;g[f+80>>2]=-1.0;g[f+84>>2]=0.0;a[f+88|0]=0;c[f>>2]=20672;c[f+92>>2]=b;c[f+4>>2]=3;if(!d){return h|0}aze(f);return h|0}function ix(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43280]|0)==0){if((b1(43280)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9582]=c[d>>2];c[9583]=c[d+4>>2];c[9584]=c[d+8>>2];c[9585]=c[d+12>>2];i=e;return 38328}function iy(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function iz(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function iA(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a)|0}function iB(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function iC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a,b,d,e);return}function iD(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43088]|0)==0){if((b1(43088)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9578]=c[d>>2];c[9579]=c[d+4>>2];c[9580]=c[d+8>>2];c[9581]=c[d+12>>2];i=e;return 38312}function iE(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function iF(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function iG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function iH(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function iI(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function iJ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function iK(a){a=a|0;aze(a|0);return}function iL(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function iM(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function iN(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;gx(a|0,b,c,d,e);return}function iO(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43152]|0)==0){if((b1(43152)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9562]=c[d>>2];c[9563]=c[d+4>>2];c[9564]=c[d+8>>2];c[9565]=c[d+12>>2];i=e;return 38248}function iP(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 13:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function iQ(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function iR(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function iS(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function iT(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function iU(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function iV(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function iW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a,b,d,e);return}function iX(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function iY(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;h=i;i=i+168|0;j=h|0;k=h+48|0;l=h+64|0;m=h+80|0;n=h+152|0;c[j>>2]=18392;a[j+4|0]=1;o=j+8|0;aDD(o|0,0,36);p=k|0;g[p>>2]=999999984306749400.0;q=k+4|0;g[q>>2]=999999984306749400.0;r=k+8|0;g[r>>2]=999999984306749400.0;g[k+12>>2]=0.0;s=b+92|0;b=c[s>>2]|0;t=c[(c[b>>2]|0)+8>>2]|0;g[l>>2]=-999999984306749400.0;g[l+4>>2]=-999999984306749400.0;g[l+8>>2]=-999999984306749400.0;g[l+12>>2]=0.0;dI[t&1023](b,j|0,l,k);f=+g[j+40>>2];if(f>0.0){u=1.0/f;v=u*+g[j+24>>2];w=u*+g[j+28>>2];x=u*+g[j+32>>2];y=0.0}else{v=+g[o>>2];w=+g[j+12>>2];x=+g[j+16>>2];y=+g[j+20>>2]}g[d+48>>2]=v;g[d+52>>2]=w;g[d+56>>2]=x;g[d+60>>2]=y;c[m>>2]=18360;aDD(m+4|0,0,48);g[m+52>>2]=v;g[m+56>>2]=w;g[m+60>>2]=x;g[m+64>>2]=y;j=c[s>>2]|0;s=c[(c[j>>2]|0)+8>>2]|0;y=-0.0- +g[q>>2];x=-0.0- +g[r>>2];g[n>>2]=-0.0- +g[p>>2];g[n+4>>2]=y;g[n+8>>2]=x;g[n+12>>2]=0.0;dI[s&1023](j,m|0,n,k);k=m+4|0;ev(k,d|0,9999999747378752.0e-21,20);x=+g[k>>2];y=+g[m+24>>2];w=+g[m+44>>2];g[e+12>>2]=0.0;v=1.0/(f*.1666666716337204);g[e>>2]=v*x;g[e+4>>2]=v*y;g[e+8>>2]=v*w;i=h;return}function iZ(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function i_(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a|0)|0}function i$(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f|0;h=f+16|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(g|0,0,16);aDD(h|0,0,16);c_[j&127](a,b,d,e,g,h);i=f;return}function i0(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(h|0,0,16);c_[j&127](a,b,d,e,f,h);i=g;return}function i1(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c_[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e,f,g);return}function i2(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+16>>2]&255](a,b,d,e,f);return}function i3(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function i4(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+48>>2]&2047](a,b);return}function i5(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function i6(a){a=a|0;ct[c[(c[a>>2]|0)+52>>2]&2047](a);return}function i7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+20>>2]&1023](a,b,d,e);return}function i8(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a,b,d,e);return}function i9(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return c5[c[(c[a>>2]|0)+8>>2]&63](a,b,d,e,f,g,h,i,j)|0}function ja(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function jb(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,d);return}function jc(a){a=a|0;return+(+g[a+20>>2]*+g[a+24>>2])}function jd(b){b=b|0;return(a[b+28|0]&1)!=0|0}function je(a){a=a|0;return+(+g[a+12>>2])}function jf(a){a=a|0;return+(+g[a+24>>2])}function jg(a){a=a|0;return+(+g[a+8>>2])}function jh(a){a=a|0;return+(+g[a+4>>2])}function ji(a){a=a|0;return+(+g[a+16>>2])}function jj(a){a=a|0;var b=0;b=c[a+40>>2]|0;c[b+16>>2]=3;c[b+20>>2]=3;return}function jk(a,b){a=a|0;b=b|0;var d=0;d=c[a+40>>2]|0;c[d+16>>2]=b;c[d+20>>2]=3;return}function jl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=c[a+40>>2]|0;c[e+16>>2]=b;c[e+20>>2]=d;return}function jm(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function jn(a,c){a=a|0;c=c|0;b[a+6>>1]=c;return}function jo(a){a=a|0;return b[a+6>>1]|0}function jp(a){a=a|0;return b[a+4>>1]|0}function jq(a,b){a=a|0;b=+b;var c=0,d=0;c=i;i=i+8|0;d=c|0;g[d>>2]=b;aq4(a,d);i=c;return}function jr(a){a=a|0;if((a|0)==0){return}aDB(a);return}function js(a,b,c){a=a|0;b=+b;c=+c;var d=0.0,e=0.0;d=(c-b)*.5;g[a+4>>2]=d;c=+ck(+(d+b),6.2831854820251465);do{if(c<-3.1415927410125732){e=c+6.2831854820251465}else{if(c<=3.1415927410125732){e=c;break}e=c-6.2831854820251465}}while(0);g[a>>2]=e;g[a+8>>2]=.8999999761581421;g[a+12>>2]=.30000001192092896;g[a+16>>2]=1.0;return}function jt(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0;e=(c-b)*.5;g[a+4>>2]=e;c=+ck(+(e+b),6.2831854820251465);do{if(c<-3.1415927410125732){f=c+6.2831854820251465}else{if(c<=3.1415927410125732){f=c;break}f=c-6.2831854820251465}}while(0);g[a>>2]=f;g[a+8>>2]=d;g[a+12>>2]=.30000001192092896;g[a+16>>2]=1.0;return}function ju(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;var f=0.0,h=0.0;f=(c-b)*.5;g[a+4>>2]=f;c=+ck(+(f+b),6.2831854820251465);do{if(c<-3.1415927410125732){h=c+6.2831854820251465}else{if(c<=3.1415927410125732){h=c;break}h=c-6.2831854820251465}}while(0);g[a>>2]=h;g[a+8>>2]=d;g[a+12>>2]=e;g[a+16>>2]=1.0;return}function jv(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;var h=0.0,i=0.0;h=(c-b)*.5;g[a+4>>2]=h;c=+ck(+(h+b),6.2831854820251465);do{if(c<-3.1415927410125732){i=c+6.2831854820251465}else{if(c<=3.1415927410125732){i=c;break}i=c-6.2831854820251465}}while(0);g[a>>2]=i;g[a+8>>2]=d;g[a+12>>2]=e;g[a+16>>2]=f;return}function jw(a){a=a|0;var b=0.0,c=0.0;b=+ck(+(+g[a>>2]+ +g[a+4>>2]),6.2831854820251465);if(b<-3.1415927410125732){c=b+6.2831854820251465;return+c}if(b<=3.1415927410125732){c=b;return+c}c=b-6.2831854820251465;return+c}function jx(b,c){b=b|0;c=+c;var d=0,e=0,f=0,h=0,i=0.0,j=0.0;d=b+20|0;g[d>>2]=0.0;e=b+24|0;g[e>>2]=0.0;f=b+28|0;a[f]=0;h=b+4|0;if(+g[h>>2]<0.0){return}i=+ck(+(c- +g[b>>2]),6.2831854820251465);do{if(i<-3.1415927410125732){j=i+6.2831854820251465}else{if(i<=3.1415927410125732){j=i;break}j=i-6.2831854820251465}}while(0);i=+g[h>>2];if(j<-0.0-i){a[f]=1;g[d>>2]=-0.0-(j+i);g[e>>2]=1.0;return}if(j<=i){return}a[f]=1;g[d>>2]=i-j;g[e>>2]=-1.0;return}function jy(a){a=a|0;var b=0.0,c=0.0;b=+ck(+(+g[a>>2]- +g[a+4>>2]),6.2831854820251465);if(b<-3.1415927410125732){c=b+6.2831854820251465;return+c}if(b<=3.1415927410125732){c=b;return+c}c=b-6.2831854820251465;return+c}function jz(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function jA(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0}function jB(a){a=a|0;return cA[c[(c[a>>2]|0)+8>>2]&4095](a)|0}function jC(a){a=a|0;return cA[c[(c[a>>2]|0)+24>>2]&4095](a)|0}function jD(a){a=a|0;return cA[c[(c[a>>2]|0)+12>>2]&4095](a)|0}function jE(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a,b,d)|0}function jF(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return+(+dq[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i))}function jG(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a,b)|0}function jH(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function jI(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return+(+db[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f))}function jJ(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+8>>2]&255](a,b,d,e,f);return}function jK(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function jL(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function jM(){var b=0,d=0,e=0;while(1){b=aDx(32)|0;if((b|0)!=0){d=792;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==792){g[b>>2]=0.0;g[b+4>>2]=-1.0;g[b+8>>2]=.8999999761581421;g[b+12>>2]=.30000001192092896;g[b+16>>2]=1.0;g[b+20>>2]=0.0;g[b+24>>2]=0.0;a[b+28|0]=0;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function jN(){var a=0,b=0,d=0,e=0,f=0;a=i;i=i+32|0;b=a|0;while(1){d=aDx(88)|0;if((d|0)!=0){e=804;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==804){e=d;c[b>>2]=0;c[b+4>>2]=0;c[b+8>>2]=0;c[b+12>>2]=4096;c[b+16>>2]=4096;c[b+20>>2]=0;c[b+24>>2]=0;c[b+28>>2]=1;aw$(e,b);i=a;return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function jO(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(88)|0;if((b|0)!=0){d=816;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==816){d=b;aw$(d,a);return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function jP(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(16)|0;if((b|0)!=0){d=828;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==828){d=b;c[d>>2]=22536;c[b+4>>2]=c[a>>2];c[d>>2]=19832;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function jQ(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0;while(1){g=aDx(16)|0;if((g|0)!=0){break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){i=837;break}dC[h&63]()}if((i|0)==837){i=cd(4)|0;c[i>>2]=19096;bF(i|0,34368,676);return 0}i=g;h=g;c[h>>2]=22536;j=c[d>>2]|0;c[g+4>>2]=j;c[h>>2]=19832;h=g+8|0;a[h]=0;d=g+12|0;c[d>>2]=b;if((b|0)!=0){return i|0}c[d>>2]=cS[c[(c[j>>2]|0)+12>>2]&511](j,e,f)|0;a[h]=1;return i|0}function jR(){var a=0,b=0,d=0;while(1){a=aDx(40)|0;if((a|0)!=0){b=856;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){b=853;break}dC[d&63]()}if((b|0)==853){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}else if((b|0)==856){b=a;az0(b,16384,0);return b|0}return 0}function jS(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(40)|0;if((b|0)!=0){d=870;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){d=867;break}dC[e&63]()}if((d|0)==867){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}else if((d|0)==870){d=b;az0(d,a,0);return d|0}return 0}function jT(a,b){a=a|0;b=b|0;return}function jU(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;if(+g[b+16>>2]>+g[c+32>>2]){d=0;return d|0}if(+g[c+16>>2]>+g[b+32>>2]){d=0;return d|0}if(+g[b+20>>2]>+g[c+36>>2]){d=0;return d|0}if(+g[c+20>>2]>+g[b+36>>2]){d=0;return d|0}if(+g[b+24>>2]>+g[c+40>>2]){d=0;return d|0}d=+g[c+24>>2]<=+g[b+40>>2];return d|0}function jV(a,b){a=a|0;b=b|0;var c=0;if(+g[a+16>>2]>+g[b+32>>2]){c=0;return c|0}if(+g[b+16>>2]>+g[a+32>>2]){c=0;return c|0}if(+g[a+20>>2]>+g[b+36>>2]){c=0;return c|0}if(+g[b+20>>2]>+g[a+36>>2]){c=0;return c|0}if(+g[a+24>>2]>+g[b+40>>2]){c=0;return c|0}c=+g[b+24>>2]<=+g[a+40>>2];return c|0}function jW(a){a=a|0;return c[a+1116>>2]|0}function jX(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function jY(a){a=a|0;return c[a+1112>>2]|0}function jZ(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0;d=+g[b+80>>2];if((c[b+144>>2]|0)>1){e=+g[a+1120>>2];f=d<=e;return f|0}else{e=+g[a+1124>>2];f=d<=e;return f|0}return 0}function j_(a){a=a|0;return c[a>>2]|0}function j$(a,b){a=a|0;b=b|0;c[a+1136>>2]=b;return}function j0(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0,q=0,r=0;d=+g[a+1120>>2];e=c[a+1116>>2]|0;if((e|0)<=0){f=-1;return f|0}h=+g[b>>2];i=+g[b+4>>2];j=+g[b+8>>2];b=0;k=-1;l=d*d;while(1){d=+g[a+4+(b*276|0)>>2]-h;m=+g[a+4+(b*276|0)+4>>2]-i;n=+g[a+4+(b*276|0)+8>>2]-j;o=d*d+m*m+n*n;p=o<l;q=p?b:k;r=b+1|0;if((r|0)<(e|0)){b=r;k=q;l=p?o:l}else{f=q;break}}return f|0}function j1(a){a=a|0;return c[a>>2]|0}function j2(a,b){a=a|0;b=b|0;return a+4+(b*276|0)|0}function j3(a){a=a|0;return+(+g[a+1120>>2])}function j4(a){a=a|0;var b=0,d=0;b=a+1116|0;a=c[b>>2]|0;d=0;while(1){if((d|0)>=(a|0)){break}d=d+1|0}c[b>>2]=0;return}function j5(a){a=a|0;return c[a+1108>>2]|0}function j6(a,b,d){a=a|0;b=b|0;d=d|0;c[a+1108>>2]=b;c[a+1112>>2]=d;return}function j7(a){a=a|0;return c[a+1136>>2]|0}function j8(a){a=a|0;return+(+g[a+1124>>2])}function j9(a){a=a|0;return c[a+1132>>2]|0}function ka(a){a=a|0;return c[a+1128>>2]|0}function kb(a,b){a=a|0;b=b|0;c[a+1132>>2]=b;return}function kc(a,b){a=a|0;b=b|0;c[a+1128>>2]=b;return}function kd(a){a=a|0;return c[a+64>>2]|0}function ke(a){a=a|0;return(c[a+4>>2]|0)<20|0}function kf(a){a=a|0;return c[a+68>>2]|0}function kg(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+16>>2]&255](a,b,d,e,f);return}function kh(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function ki(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f|0;h=f+16|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(g|0,0,16);aDD(h|0,0,16);c_[j&127](a,b,d,e,g,h);i=f;return}function kj(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(h|0,0,16);c_[j&127](a,b,d,e,f,h);i=g;return}function kk(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c_[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e,f,g);return}function kl(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function km(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+20>>2]&1023](a,b,d,e);return}function kn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a,b,d,e);return}function ko(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return c5[c[(c[a>>2]|0)+8>>2]&63](a,b,d,e,f,g,h,i,j)|0}function kp(a){a=a|0;ct[c[(c[a>>2]|0)+52>>2]&2047](a);return}function kq(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function kr(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,d);return}function ks(a){a=a|0;return cA[c[(c[a>>2]|0)+8>>2]&4095](a)|0}function kt(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0}function ku(a){a=a|0;return cA[c[(c[a>>2]|0)+12>>2]&4095](a)|0}function kv(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a,b,d)|0}function kw(a,b,c){a=a|0;b=b|0;c=c|0;ay6(a,b,c);return}function kx(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(1159)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d>>2]=1025;c[d+112>>2]=0;g[d+116>>2]=0.0;a[d+120|0]=0;aDD(d+124|0,0,28);c[d+388>>2]=0;g[d+392>>2]=0.0;a[d+396|0]=0;aDD(d+400|0,0,28);c[d+664>>2]=0;g[d+668>>2]=0.0;a[d+672|0]=0;aDD(d+676|0,0,28);c[d+940>>2]=0;g[d+944>>2]=0.0;a[d+948|0]=0;aDD(d+952|0,0,28);c[d+1108>>2]=0;c[d+1112>>2]=0;c[d+1116>>2]=0;c[d+1136>>2]=0;return d|0}function ky(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=+f;h=+h;var i=0,j=0,k=0;c[9806]=(c[9806]|0)+1;e=aDx(1159)|0;i=-(e+4|0)&15;c[e+i>>2]=e;j=e+(i+4)|0;c[j>>2]=1025;i=j+1108|0;e=j+4|0;while(1){c[e+108>>2]=0;g[e+112>>2]=0.0;a[e+116|0]=0;k=e+276|0;aDD(e+120|0,0,28);if((k|0)==(i|0)){break}else{e=k}}c[j+1108>>2]=b;c[j+1112>>2]=d;c[j+1116>>2]=0;g[j+1120>>2]=f;g[j+1124>>2]=h;return j|0}function kz(a,b){a=a|0;b=b|0;return ay5(a,b)|0}function kA(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;e=b+1116|0;f=c[e>>2]|0;h=f-1|0;if((h|0)==(d|0)){i=f;j=i-1|0;c[e>>2]=j;return}f=b+4+(d*276|0)|0;d=b+4+(h*276|0)|0;aDC(f|0,d|0,276)|0;c[b+4+(h*276|0)+108>>2]=0;g[b+4+(h*276|0)+208>>2]=0.0;g[b+4+(h*276|0)+240>>2]=0.0;g[b+4+(h*276|0)+272>>2]=0.0;g[b+4+(h*276|0)+112>>2]=0.0;a[b+4+(h*276|0)+116|0]=0;g[b+4+(h*276|0)+120>>2]=0.0;g[b+4+(h*276|0)+124>>2]=0.0;c[b+4+(h*276|0)+144>>2]=0;i=c[e>>2]|0;j=i-1|0;c[e>>2]=j;return}function kB(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-1140+1136>>2]|0);return}function kC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0,k=0.0,l=0,m=0.0,n=0,o=0,p=0,q=0;e=a+4+(d*276|0)+144|0;f=c[e>>2]|0;h=a+4+(d*276|0)+208|0;i=+g[h>>2];j=a+4+(d*276|0)+240|0;k=+g[j>>2];l=a+4+(d*276|0)+272|0;m=+g[l>>2];n=a+4+(d*276|0)+108|0;o=c[n>>2]|0;p=a+4+(d*276|0)|0;q=b;aDC(p|0,q|0,276)|0;c[n>>2]=o;g[a+4+(d*276|0)+112>>2]=i;g[a+4+(d*276|0)+120>>2]=k;g[a+4+(d*276|0)+124>>2]=m;g[h>>2]=i;g[j>>2]=k;g[l>>2]=m;c[e>>2]=f;return}function kD(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a,b,d);return}function kE(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function kF(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function kG(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function kH(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;d=i;i=i+48|0;e=d|0;f=d+16|0;g=e;h=f;j=b+64|0;if((c[j>>2]|0)!=0){i=d;return}c[9806]=(c[9806]|0)+1;k=aDx(59)|0;do{if((k|0)==0){l=0}else{m=-(k+4|0)&15;n=k+(m+4)|0;c[k+m>>2]=k;if((n|0)==0){l=0;break}a[k+(m+40)|0]=1;c[k+(m+36)>>2]=0;c[k+(m+28)>>2]=0;c[k+(m|32)>>2]=0;c[n>>2]=0;c[k+(m+8)>>2]=0;c[k+(m+12)>>2]=-1;c[k+(m|16)>>2]=0;c[k+(m+20)>>2]=0;l=n}}while(0);c[j>>2]=l;l=b+16|0;if((c[l>>2]|0)<=0){i=d;return}k=b+24|0;b=f+16|0;n=f|0;f=0;do{m=c[k>>2]|0;o=c[m+(f*80|0)+64>>2]|0;dI[c[(c[o>>2]|0)+8>>2]&1023](o,m+(f*80|0)|0,n,e);c[b>>2]=c[g>>2];c[b+4>>2]=c[g+4>>2];c[b+8>>2]=c[g+8>>2];c[b+12>>2]=c[g+12>>2];o=c[j>>2]|0;p=o+4|0;q=c[p>>2]|0;do{if((q|0)==0){c[9806]=(c[9806]|0)+1;r=aDx(63)|0;if((r|0)==0){s=0;break}t=-(r+4|0)&15;u=r+(t+4)|0;c[r+t>>2]=r;if((u|0)==0){s=0;break}aDD(u|0,0,44);s=u}else{c[p>>2]=0;s=q}}while(0);c[s+32>>2]=0;c[s+36>>2]=f;c[s+40>>2]=0;q=s;aDC(q|0,h|0,32)|0;awv(o,c[o>>2]|0,s);q=o+12|0;c[q>>2]=(c[q>>2]|0)+1;c[m+(f*80|0)+76>>2]=s;f=f+1|0;}while((f|0)<(c[l>>2]|0));i=d;return}function kI(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(111)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}d=b;auE(d,1);return d|0}function kJ(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;while(1){d=aDx(40)|0;if((d|0)!=0){e=1008;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){e=1005;break}dC[f&63]()}if((e|0)==1005){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}else if((e|0)==1008){e=d;az0(e,a,b);return e|0}return 0}function kK(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function kL(a){a=a|0;return(c[a+4>>2]|0)==31|0}function kM(a){a=a|0;return(c[a+4>>2]|0)<7|0}function kN(a,b){a=a|0;b=b|0;return c[(c[a+24>>2]|0)+(b*80|0)+64>>2]|0}function kO(a){a=a|0;return(c[a+4>>2]|0)==28|0}function kP(a,b){a=a|0;b=b|0;return(c[a+24>>2]|0)+(b*80|0)|0}function kQ(a){a=a|0;return c[a+8>>2]|0}function kR(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function kS(a){a=a|0;return c[a+24>>2]|0}function kT(a){a=a|0;return c[a+16>>2]|0}function kU(a){a=a|0;return(c[a+4>>2]|0)==32|0}function kV(a){a=a|0;var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(111)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d;auE(e,a);return e|0}function kW(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function kX(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function kY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function kZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function k_(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function k$(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+128|0;h=f+64|0;j=f+80|0;k=f+96|0;l=f|0;m=f+16|0;n=f+32|0;o=f+48|0;p=h;q=j;r=k;s=b+68|0;c[s>>2]=(c[s>>2]|0)+1;s=d;c[l>>2]=c[s>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];c[l+12>>2]=c[s+12>>2];s=d+16|0;c[m>>2]=c[s>>2];c[m+4>>2]=c[s+4>>2];c[m+8>>2]=c[s+8>>2];c[m+12>>2]=c[s+12>>2];s=d+32|0;c[n>>2]=c[s>>2];c[n+4>>2]=c[s+4>>2];c[n+8>>2]=c[s+8>>2];c[n+12>>2]=c[s+12>>2];s=d+48|0;c[o>>2]=c[s>>2];c[o+4>>2]=c[s+4>>2];c[o+8>>2]=c[s+8>>2];c[o+12>>2]=c[s+12>>2];s=c[e+4>>2]|0;t=+dh[c[(c[e>>2]|0)+44>>2]&1023](e);dI[c[(c[e>>2]|0)+8>>2]&1023](e,d,h,j);d=b+32|0;u=+g[h>>2];if(+g[d>>2]>u){g[d>>2]=u}d=b+48|0;u=+g[j>>2];if(+g[d>>2]<u){g[d>>2]=u}d=b+36|0;u=+g[h+4>>2];if(+g[d>>2]>u){g[d>>2]=u}d=b+52|0;u=+g[j+4>>2];if(+g[d>>2]<u){g[d>>2]=u}d=b+40|0;u=+g[h+8>>2];if(+g[d>>2]>u){g[d>>2]=u}d=b+56|0;u=+g[j+8>>2];if(+g[d>>2]<u){g[d>>2]=u}d=c[b+64>>2]|0;if((d|0)==0){v=0;w=b+16|0}else{c[r>>2]=c[p>>2];c[r+4>>2]=c[p+4>>2];c[r+8>>2]=c[p+8>>2];c[r+12>>2]=c[p+12>>2];p=k+16|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];q=b+16|0;p=c[q>>2]|0;k=d+4|0;j=c[k>>2]|0;do{if((j|0)==0){c[9806]=(c[9806]|0)+1;h=aDx(63)|0;if((h|0)==0){x=0;break}y=-(h+4|0)&15;z=h+(y+4)|0;c[h+y>>2]=h;if((z|0)==0){x=0;break}aDD(z|0,0,44);x=z}else{c[k>>2]=0;x=j}}while(0);c[x+32>>2]=0;c[x+36>>2]=p;c[x+40>>2]=0;p=x;aDC(p|0,r|0,32)|0;awv(d,c[d>>2]|0,x);r=d+12|0;c[r>>2]=(c[r>>2]|0)+1;v=x;w=q}q=c[w>>2]|0;x=b+20|0;do{if((q|0)==(c[x>>2]|0)){r=(q|0)==0?1:q<<1;if((q|0)>=(r|0)){A=q;break}do{if((r|0)==0){B=0}else{c[9806]=(c[9806]|0)+1;d=aDx((r*80|0|4)+15|0)|0;if((d|0)==0){B=0;break}p=-(d+4|0)&15;c[d+p>>2]=d;B=d+(p+4)|0}}while(0);p=c[b+16>>2]|0;d=b+24|0;if((p|0)>0){j=0;do{k=c[d>>2]|0;z=B+(j*80|0)|0;h=k+(j*80|0)|0;c[z>>2]=c[h>>2];c[z+4>>2]=c[h+4>>2];c[z+8>>2]=c[h+8>>2];c[z+12>>2]=c[h+12>>2];h=B+(j*80|0)+16|0;z=k+(j*80|0)+16|0;c[h>>2]=c[z>>2];c[h+4>>2]=c[z+4>>2];c[h+8>>2]=c[z+8>>2];c[h+12>>2]=c[z+12>>2];z=B+(j*80|0)+32|0;h=k+(j*80|0)+32|0;c[z>>2]=c[h>>2];c[z+4>>2]=c[h+4>>2];c[z+8>>2]=c[h+8>>2];c[z+12>>2]=c[h+12>>2];h=B+(j*80|0)+48|0;z=k+(j*80|0)+48|0;c[h>>2]=c[z>>2];c[h+4>>2]=c[z+4>>2];c[h+8>>2]=c[z+8>>2];c[h+12>>2]=c[z+12>>2];c[B+(j*80|0)+64>>2]=c[k+(j*80|0)+64>>2];c[B+(j*80|0)+68>>2]=c[k+(j*80|0)+68>>2];g[B+(j*80|0)+72>>2]=+g[k+(j*80|0)+72>>2];c[B+(j*80|0)+76>>2]=c[k+(j*80|0)+76>>2];j=j+1|0;}while((j|0)<(p|0))}p=c[d>>2]|0;j=b+28|0;if((p|0)!=0){if((a[j]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-80+76>>2]|0)}c[d>>2]=0}a[j]=1;c[d>>2]=B;c[x>>2]=r;A=c[w>>2]|0}else{A=q}}while(0);q=c[b+24>>2]|0;b=q+(A*80|0)|0;c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];c[b+8>>2]=c[l+8>>2];c[b+12>>2]=c[l+12>>2];l=q+(A*80|0)+16|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];m=q+(A*80|0)+32|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];n=q+(A*80|0)+48|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];c[q+(A*80|0)+64>>2]=e;c[q+(A*80|0)+68>>2]=s;g[q+(A*80|0)+72>>2]=t;c[q+(A*80|0)+76>>2]=v;c[w>>2]=(c[w>>2]|0)+1;i=f;return}function k0(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function k1(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function k2(a,b){a=a|0;b=b|0;auH(a,b);return}function k3(a){a=a|0;ct[c[(c[a>>2]|0)+64>>2]&2047](a);return}function k4(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function k5(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=f;j=g;k=a+24|0;l=c[k>>2]|0;m=l+(b*80|0)|0;n=d;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];n=l+(b*80|0)+16|0;m=d+16|0;c[n>>2]=c[m>>2];c[n+4>>2]=c[m+4>>2];c[n+8>>2]=c[m+8>>2];c[n+12>>2]=c[m+12>>2];m=l+(b*80|0)+32|0;n=d+32|0;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];n=l+(b*80|0)+48|0;l=d+48|0;c[n>>2]=c[l>>2];c[n+4>>2]=c[l+4>>2];c[n+8>>2]=c[l+8>>2];c[n+12>>2]=c[l+12>>2];l=a+64|0;if((c[l>>2]|0)==0){o=a;p=c[o>>2]|0;q=p+64|0;r=c[q>>2]|0;ct[r&2047](a);i=e;return}n=c[(c[k>>2]|0)+(b*80|0)+64>>2]|0;dI[c[(c[n>>2]|0)+8>>2]&1023](n,d,g|0,f);f=g+16|0;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];h=c[l>>2]|0;l=c[(c[k>>2]|0)+(b*80|0)+76>>2]|0;b=aww(h,l)|0;L1123:do{if((b|0)==0){s=0}else{k=c[h+8>>2]|0;if((k|0)>-1){t=0;u=b}else{s=c[h>>2]|0;break}while(1){if((t|0)>=(k|0)){s=u;break L1123}f=c[u+32>>2]|0;if((f|0)==0){s=u;break}else{t=t+1|0;u=f}}}}while(0);u=l;aDC(u|0,j|0,32)|0;awv(h,s,l);o=a;p=c[o>>2]|0;q=p+64|0;r=c[q>>2]|0;ct[r&2047](a);i=e;return}function k6(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=i;i=i+48|0;g=f|0;h=f+16|0;j=g;k=h;l=a+24|0;m=c[l>>2]|0;n=m+(b*80|0)|0;o=d;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];o=m+(b*80|0)+16|0;n=d+16|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2];n=m+(b*80|0)+32|0;o=d+32|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];o=m+(b*80|0)+48|0;m=d+48|0;c[o>>2]=c[m>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];m=a+64|0;if((c[m>>2]|0)!=0){o=c[(c[l>>2]|0)+(b*80|0)+64>>2]|0;dI[c[(c[o>>2]|0)+8>>2]&1023](o,d,h|0,g);g=h+16|0;c[g>>2]=c[j>>2];c[g+4>>2]=c[j+4>>2];c[g+8>>2]=c[j+8>>2];c[g+12>>2]=c[j+12>>2];j=c[m>>2]|0;m=c[(c[l>>2]|0)+(b*80|0)+76>>2]|0;b=aww(j,m)|0;L1135:do{if((b|0)==0){p=0}else{l=c[j+8>>2]|0;if((l|0)>-1){q=0;r=b}else{p=c[j>>2]|0;break}while(1){if((q|0)>=(l|0)){p=r;break L1135}g=c[r+32>>2]|0;if((g|0)==0){p=r;break}else{q=q+1|0;r=g}}}}while(0);r=m;aDC(r|0,k|0,32)|0;awv(j,p,m)}if(!e){i=f;return}ct[c[(c[a>>2]|0)+64>>2]&2047](a);i=f;return}function k7(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function k8(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function k9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function la(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function lb(a){a=a|0;return c[a+4>>2]|0}function lc(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function ld(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function le(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function lf(a){a=a|0;return(c[a+4>>2]|0)==31|0}function lg(a){a=a|0;return(c[a+4>>2]|0)<7|0}function lh(a){a=a|0;return c[a+32>>2]|0}function li(a){a=a|0;return(c[a+4>>2]|0)<20|0}function lj(a){a=a|0;return(c[a+4>>2]|0)==28|0}function lk(a){a=a|0;return c[a+8>>2]|0}function ll(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function lm(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function ln(a){a=a|0;return(c[a+4>>2]|0)==32|0}function lo(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function lp(a){a=a|0;return c[a+4>>2]|0}function lq(a){a=a|0;return a+100|0}function lr(a){a=a|0;return c[a+24>>2]|0}function ls(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function lt(a){a=a|0;return a+4|0}function lu(a,b){a=a|0;b=b|0;c[a+88>>2]=b;c[a+96>>2]=0;return}function lv(a,b,d){a=a|0;b=b|0;d=d|0;c[a+88>>2]=b;c[a+96>>2]=d;return}function lw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if(e){c[a+92>>2]=b}else{c[a+88>>2]=b}c[a+96>>2]=d;return}function lx(b){b=b|0;return(a[b+84|0]&1)!=0|0}function ly(a){a=a|0;return c[a+8>>2]|0}function lz(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0.0,L=0,M=0.0,N=0,O=0.0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0;f=i;i=i+64|0;h=f|0;j=f+48|0;k=h;l=c[a+16>>2]|0;m=(l|0)>0;if(m){n=c[a+24>>2]|0;o=0.0;p=0.0;q=0.0;r=0.0;s=0;while(1){t=+g[b+(s<<2)>>2];u=r+ +g[n+(s*80|0)+48>>2]*t;v=q+t*+g[n+(s*80|0)+52>>2];w=p+t*+g[n+(s*80|0)+56>>2];x=o+t;y=s+1|0;if((y|0)<(l|0)){o=x;p=w;q=v;r=u;s=y}else{z=x;A=w;B=v;C=u;break}}}else{z=0.0;A=0.0;B=0.0;C=0.0}r=1.0/z;z=C*r;C=B*r;B=A*r;g[d+48>>2]=z;g[d+52>>2]=C;g[d+56>>2]=B;g[d+60>>2]=0.0;s=h|0;n=h+4|0;y=h+8|0;D=h+16|0;E=h+20|0;F=h+24|0;G=h+32|0;H=h+36|0;I=h+40|0;aDD(k|0,0,48);if(!m){J=d|0;ev(h,J,9999999747378752.0e-21,20);K=+g[s>>2];L=e|0;g[L>>2]=K;M=+g[E>>2];N=e+4|0;g[N>>2]=M;O=+g[I>>2];P=e+8|0;g[P>>2]=O;Q=e+12|0;g[Q>>2]=0.0;i=f;return}m=a+24|0;a=j|0;k=j+4|0;R=j+8|0;S=0;T=c[m>>2]|0;r=0.0;A=0.0;q=0.0;p=0.0;o=0.0;u=0.0;v=0.0;w=0.0;x=0.0;do{U=c[T+(S*80|0)+64>>2]|0;V=b+(S<<2)|0;cX[c[(c[U>>2]|0)+32>>2]&255](U,+g[V>>2],j);T=c[m>>2]|0;t=+g[T+(S*80|0)+48>>2]-z;W=+g[T+(S*80|0)+52>>2]-C;X=+g[T+(S*80|0)+56>>2]-B;Y=+g[T+(S*80|0)>>2];Z=+g[T+(S*80|0)+16>>2];_=+g[T+(S*80|0)+32>>2];$=+g[T+(S*80|0)+4>>2];aa=+g[T+(S*80|0)+20>>2];ab=+g[T+(S*80|0)+36>>2];ac=+g[T+(S*80|0)+8>>2];ad=+g[T+(S*80|0)+24>>2];ae=+g[T+(S*80|0)+40>>2];af=+g[a>>2];ag=Y*af;ah=Z*af;ai=_*af;af=+g[k>>2];aj=$*af;ak=aa*af;al=ab*af;af=+g[R>>2];am=ac*af;an=ad*af;ao=ae*af;af=t*t+W*W+X*X;ap=-0.0-t;aq=-0.0-W;ar=-0.0-X;as=+g[V>>2];r=(t*ap+af)*as+(r+(Y*ag+$*aj+ac*am));g[s>>2]=r;A=(W*ap+0.0)*as+(A+(Y*ah+$*ak+ac*an));g[n>>2]=A;q=(X*ap+0.0)*as+(Y*ai+$*al+ac*ao+q);g[y>>2]=q;p=(t*aq+0.0)*as+(Z*ag+aa*aj+ad*am+p);g[D>>2]=p;o=(W*aq+af)*as+(Z*ah+aa*ak+ad*an+o);g[E>>2]=o;u=(X*aq+0.0)*as+(Z*ai+aa*al+ad*ao+u);g[F>>2]=u;v=(t*ar+0.0)*as+(_*ag+ab*aj+ae*am+v);g[G>>2]=v;w=(W*ar+0.0)*as+(_*ah+ab*ak+ae*an+w);g[H>>2]=w;x=(X*ar+af)*as+(_*ai+ab*al+ae*ao+x);g[I>>2]=x;S=S+1|0;}while((S|0)<(l|0));J=d|0;ev(h,J,9999999747378752.0e-21,20);K=+g[s>>2];L=e|0;g[L>>2]=K;M=+g[E>>2];N=e+4|0;g[N>>2]=M;O=+g[I>>2];P=e+8|0;g[P>>2]=O;Q=e+12|0;g[Q>>2]=0.0;i=f;return}function lA(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function lB(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function lC(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function lD(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function lE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function lF(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function lG(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function lH(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function lI(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function lJ(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function lK(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function lL(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function lM(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function lN(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function lO(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function lP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function lQ(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function lR(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+68>>2]&2047](a,b);return}function lS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function lT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a|0,b);return}function lU(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+80>>2]&2047](a,b);return}function lV(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+84>>2]&1023](a,b,d,e);return}function lW(a){a=a|0;ct[c[(c[a>>2]|0)+116>>2]&2047](a);return}function lX(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+124>>2]&2047](a,b);return}function lY(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function lZ(a){a=a|0;ct[c[(c[a>>2]|0)+40>>2]&2047](a|0);return}function l_(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a|0,b,d,e);return}function l$(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a,b);return}function l0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function l1(a){a=a|0;return cA[c[(c[a>>2]|0)+100>>2]&4095](a)|0}function l2(a,b){a=a|0;b=b|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,1,-1);return}function l3(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,-1);return}function l4(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,e);return}function l5(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+88>>2]&2047](a,b);return}function l6(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=e+32|0;j=c[b+192>>2]|0;dI[c[(c[j>>2]|0)+8>>2]&1023](j,b+4|0,f,g);c[h>>2]=21168;c[h+4>>2]=b;c[h+8>>2]=a;c[h+12>>2]=d;d=c[a+76>>2]|0;dI[c[(c[d>>2]|0)+28>>2]&1023](d,f,g,h|0);i=e;return}function l7(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function l8(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function l9(a){a=a|0;ct[c[(c[a>>2]|0)+76>>2]&2047](a);return}function ma(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;atO(a|0,b,c,d,e,0.0);return}function mb(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;atO(a|0,b,c,d,e,f);return}function mc(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function md(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+52>>2]&511](a,b,0);return}function me(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+52>>2]&511](a,b,d);return}function mf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+168|0;g=f|0;h=a+24|0;j=c[h>>2]|0;k=dE[c[(c[j>>2]|0)+8>>2]&127](j,b,d,0)|0;if((k|0)==0){i=f;return}c[g+4>>2]=0;c[g+136>>2]=b;c[g+140>>2]=d;j=g+8|0;l=b+4|0;aDD(g+144|0,-1|0,16);c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+24|0;j=b+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+40|0;l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+56|0;j=b+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+72|0;l=d+4|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+88|0;j=d+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+104|0;l=d+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+120|0;j=d+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[g>>2]=21728;c[g+160>>2]=e;co[c[(c[k>>2]|0)+8>>2]&255](k,b,d,a+28|0,g|0);ct[c[c[k>>2]>>2]&2047](k);g=c[h>>2]|0;cv[c[(c[g>>2]|0)+60>>2]&2047](g,k);i=f;return}function mg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0;while(1){d=aDx(36)|0;if((d|0)!=0){e=1205;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==1205){e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;g[d+12>>2]=0.0;c[d>>2]=20128;f=d+16|0;h=b;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];c[d+32>>2]=a;c[e>>2]=22;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function mh(a){a=a|0;return c[a+76>>2]|0}function mi(b,c){b=b|0;c=c|0;a[b+84|0]=c&1;return}function mj(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function mk(a){a=a|0;return c[a+96>>2]|0}function ml(a){a=a|0;return a+28|0}function mm(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function mn(a){a=a|0;return+(+g[a+4>>2])}function mo(a){a=a|0;return+(+g[a+8>>2])}function mp(a,b){a=a|0;b=+b;g[a>>2]=b;return}function mq(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function mr(a){a=a|0;return+(+g[a>>2])}function ms(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=a+8|0;e=c[d>>2]|0;f=e+b|0;if(f>>>0>=(c[a+4>>2]|0)>>>0){g=0;return g|0}c[d>>2]=f;g=(c[a>>2]|0)+e|0;return g|0}function mt(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;b=a+8|0;d=c[b>>2]|0;e=d+8|0;if(e>>>0<(c[a+4>>2]|0)>>>0){c[b>>2]=e;e=a|0;f=(c[e>>2]|0)+d|0;g=e}else{f=0;g=a|0}e=f;d=a+12|0;c[f>>2]=c[d>>2];c[f+4>>2]=(c[g>>2]|0)+(c[b>>2]|0);c[d>>2]=e;return e|0}function mu(a){a=a|0;return(c[a+4>>2]|0)-(c[a+8>>2]|0)|0}function mv(a,b){a=a|0;b=b|0;var d=0;d=a+12|0;if((c[d>>2]|0)!=(b|0)){return}c[d>>2]=c[b>>2];c[a+8>>2]=(c[b+4>>2]|0)-(c[a>>2]|0)-8;return}function mw(a){a=a|0;return c[a+28>>2]|0}function mx(a){a=a|0;return c[a+12>>2]|0}function my(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function mz(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function mA(a){a=a|0;return a+40|0}function mB(a,b){a=a|0;b=b|0;return+(+g[a+1248+(b<<2)>>2])}function mC(a){a=a|0;return a+104|0}function mD(a){a=a|0;return a+1056|0}function mE(a){a=a|0;return c[a+12>>2]|0}function mF(a){a=a|0;return c[a+4>>2]|0}function mG(a){a=a|0;return c[a+24>>2]|0}function mH(a){a=a|0;return+(+g[a+16>>2])}function mI(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43912]|0)==0){if((b1(43912)|0)==0){break}}}while(0);cv[c[(c[b>>2]|0)+72>>2]&2047](e,b);b=e;c[9558]=c[b>>2];c[9559]=c[b+4>>2];c[9560]=c[b+8>>2];c[9561]=c[b+12>>2];i=d;return 38232}function mJ(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function mK(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;atG(a,b,c,d,e,f);return}function mL(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function mM(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+132>>2]&2047](a,b);return}function mN(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+104>>2]&511](a,b)|0}function mO(a){a=a|0;return cA[c[(c[a>>2]|0)+96>>2]&4095](a)|0}function mP(a,b){a=a|0;b=+b;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,1,.01666666753590107)|0}function mQ(a,b,d){a=a|0;b=+b;d=d|0;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,.01666666753590107)|0}function mR(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,e)|0}function mS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+128>>2]&2047](a,b);return}function mT(a){a=a|0;return cA[c[(c[a>>2]|0)+112>>2]&4095](a)|0}function mU(a,b){a=a|0;b=b|0;atC(a|0,b);return}function mV(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+120>>2]&2047](a,b);return}function mW(a){a=a|0;var b=0;b=c[a+76>>2]|0;return cA[c[(c[b>>2]|0)+36>>2]&4095](b)|0}function mX(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a|0,b);return}function mY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+92>>2]&2047](a,b);return}function mZ(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;atI(a,b,c,d,e,f,g,h);return}function m_(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function m$(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function m0(a){a=a|0;if((a|0)==0){return}aDB(a);return}function m1(b){b=b|0;var d=0,e=0,f=0,g=0;if((b|0)==0){return}d=b+8|0;L1333:do{if((c[d>>2]|0)==0){e=b|0;do{if((a[b+16|0]&1)==0){f=c[e>>2]|0;if((f|0)==0){c[e>>2]=0;c[d>>2]=0;break L1333}else{c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0);g=e;break}}else{g=e}}while(0);c[g>>2]=0;c[d>>2]=0}}while(0);aDB(b);return}function m2(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=b+8|0;if((c[e>>2]|0)==0){f=b|0;do{if((a[b+16|0]&1)==0){g=c[f>>2]|0;if((g|0)==0){h=f;break}c[9804]=(c[9804]|0)+1;aDB(c[g-4>>2]|0);h=f}else{h=f}}while(0);c[h>>2]=0;c[e>>2]=0}c[9806]=(c[9806]|0)+1;e=aDx(d+19|0)|0;if((e|0)==0){i=0;j=b|0;c[j>>2]=i;k=b+4|0;c[k>>2]=d;return}h=-(e+4|0)&15;c[e+h>>2]=e;i=e+(h+4)|0;j=b|0;c[j>>2]=i;k=b+4|0;c[k>>2]=d;return}function m3(b){b=b|0;var d=0,e=0,f=0,g=0;d=b+8|0;if((c[d>>2]|0)!=0){return}e=b|0;do{if((a[b+16|0]&1)==0){f=c[e>>2]|0;if((f|0)==0){g=e;break}c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0);g=e}else{g=e}}while(0);c[g>>2]=0;c[d>>2]=0;return}function m4(a){a=a|0;if((a|0)==0){return}aDB(a);return}function m5(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function m6(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a|0,b,d,-1);return}function m7(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a|0,b,d,e);return}function m8(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;apb(a|0,b,c,d,e,f,g,h);return}function m9(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a|0,b,-1))}function na(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a|0,b,d))}function nb(a,b,c){a=a|0;b=+b;c=+c;var d=0,e=0,f=0,h=0.0;d=i;i=i+16|0;e=d|0;g[e>>2]=0.0;g[e+4>>2]=b;g[e+8>>2]=c;g[e+12>>2]=0.0;f=0;while(1){if((f|0)>=3){break}c=+ck(+(+g[e+(f<<2)>>2]),6.2831854820251465);do{if(c<-3.1415927410125732){h=c+6.2831854820251465}else{if(c<=3.1415927410125732){h=c;break}h=c-6.2831854820251465}}while(0);g[a+860+(f<<6)+4>>2]=h;f=f+1|0}i=d;return}function nc(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a|0,b);return}function nd(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a|0,b);return}function ne(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(8)|0;if((b|0)!=0){d=1337;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==1337){c[b>>2]=20640;c[b+4>>2]=a;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function nf(){var a=0,b=0,d=0;while(1){a=aDx(12)|0;if((a|0)!=0){b=1349;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==1349){g[a>>2]=.30000001192092896;g[a+4>>2]=1.0;g[a+8>>2]=0.0;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function ng(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;while(1){b=aDx(20)|0;if((b|0)!=0){break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){e=1358;break}dC[d&63]()}if((e|0)==1358){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}e=b;d=b;f=b+4|0;aDD(b|0,0,17);c[d>>2]=0;c[b+8>>2]=0;c[9806]=(c[9806]|0)+1;b=aDx(a+19|0)|0;if((b|0)==0){g=0;c[d>>2]=g;c[f>>2]=a;return e|0}h=-(b+4|0)&15;c[b+h>>2]=b;g=b+(h+4)|0;c[d>>2]=g;c[f>>2]=a;return e|0}function nh(){var a=0,b=0,d=0;while(1){a=aDx(72)|0;if((a|0)!=0){b=1377;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==1377){g[a>>2]=.6000000238418579;g[a+4>>2]=1.0;g[a+8>>2]=.30000001192092896;g[a+16>>2]=0.0;g[a+24>>2]=20.0;c[a+20>>2]=10;g[a+32>>2]=.20000000298023224;g[a+36>>2]=.10000000149011612;g[a+40>>2]=0.0;g[a+28>>2]=1.0;c[a+44>>2]=0;g[a+48>>2]=-.019999999552965164;g[a+52>>2]=0.0;g[a+56>>2]=.8500000238418579;c[a+60>>2]=260;c[a+64>>2]=2;c[a+68>>2]=128;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function ni(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=3){break}g[b+(c<<2)>>2]=+g[a+860+(c<<6)>>2];c=c+1|0}return}function nj(a){a=a|0;return+(+g[a+32>>2])}function nk(b){b=b|0;return(a[b+20|0]&1)!=0|0}function nl(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function nm(a){a=a|0;return c[a+4>>2]|0}function nn(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function no(a){a=a|0;return a+1104|0}function np(b,c){b=b|0;c=c|0;a[b+1293|0]=c&1;return}function nq(a,b){a=a|0;b=b|0;var c=0,d=0;if((b|0)<3){c=+g[a+688+(b<<2)>>2]>=+g[a+672+(b<<2)>>2];return c|0}d=b-3|0;if(+g[a+860+(d<<6)>>2]>+g[a+860+(d<<6)+4>>2]){c=0;return c|0}c=1;return c|0}function nr(a){a=a|0;return+(+g[a+1188>>2])}function ns(a,b){a=a|0;b=b|0;return a+860+(b<<6)|0}function nt(a){a=a|0;return+(+g[a+1192>>2])}function nu(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+1300|0]&1)==0){c[e>>2]=6;c[d+4>>2]=0;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function nv(a){a=a|0;return a+1168|0}function nw(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function nx(b){b=b|0;return(a[b+1293|0]&1)!=0|0}function ny(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function nz(a){a=a|0;return a+1120|0}function nA(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function nB(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function nC(b){b=b|0;return(a[b+1300|0]&1)!=0|0}function nD(a){a=a|0;return+(+g[a+32>>2])}function nE(a){a=a|0;ct[c[(c[a>>2]|0)+44>>2]&2047](a|0);return}function nF(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function nG(b,c){b=b|0;c=c|0;do{if((a[43872]|0)==0){if((b1(43872)|0)==0){break}}}while(0);aDG(38216,b+1200+(c<<4)|0,16);return 38216}function nH(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+688|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];return}function nI(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a|0,b,d)|0}function nJ(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function nK(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function nL(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+672|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];return}function nM(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=a|0;f=a+40|0;g=b;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+56|0;f=b+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+72|0;g=b+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+88|0;f=b+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+104|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+120|0;f=d+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+136|0;g=d+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+152|0;f=d+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](e);aoZ(e,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function nN(a){a=a|0;aoZ(a|0,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function nO(a,b,c){a=a|0;b=b|0;c=c|0;aoZ(a|0,b,c);return}function nP(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return ao7(a|0,b,c,d,e,f,g,h,i,j,k,l,0)|0}function nQ(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;return ao7(a|0,b,c,d,e,f,g,h,i,j,k,l,m)|0}function nR(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;nS(a|0,b,c,d);return}function nS(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0;if((b|0)<3){g[a+672+(b<<2)>>2]=c;g[a+688+(b<<2)>>2]=d;return}e=+ck(+c,6.2831854820251465);do{if(e<-3.1415927410125732){f=e+6.2831854820251465}else{if(e<=3.1415927410125732){f=e;break}f=e-6.2831854820251465}}while(0);e=+ck(+d,6.2831854820251465);do{if(e<-3.1415927410125732){h=e+6.2831854820251465}else{if(e<=3.1415927410125732){h=e;break}h=e-6.2831854820251465}}while(0);i=b-3|0;g[a+860+(i<<6)>>2]=f;g[a+860+(i<<6)+4>>2]=h;return}function nT(a,b){a=a|0;b=+b;return}function nU(a){a=a|0;return a+672|0}function nV(b){b=b|0;return(a[b+21|0]&1)!=0|0}function nW(a,b){a=a|0;b=b|0;return+(+g[a+1184+(b<<2)>>2])}function nX(b,c){b=b|0;c=c|0;a[b+1300|0]=c&1;return}function nY(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=3){break}g[b+(c<<2)>>2]=+g[a+860+(c<<6)+4>>2];c=c+1|0}return}function nZ(a){a=a|0;return c[a+4>>2]|0}function n_(a){a=a|0;return c[a+8>>2]|0}function n$(a){a=a|0;return+(+g[a+36>>2])}function n0(a){a=a|0;return a+1320|0}function n1(a){a=a|0;return c[a+12>>2]|0}function n2(a){a=a|0;return a+1336|0}function n3(a,b,c){a=a|0;b=+b;c=+c;var d=0,e=0,f=0,h=0.0;d=i;i=i+16|0;e=d|0;g[e>>2]=0.0;g[e+4>>2]=b;g[e+8>>2]=c;g[e+12>>2]=0.0;f=0;while(1){if((f|0)>=3){break}c=+ck(+(+g[e+(f<<2)>>2]),6.2831854820251465);do{if(c<-3.1415927410125732){h=c+6.2831854820251465}else{if(c<=3.1415927410125732){h=c;break}h=c-6.2831854820251465}}while(0);g[a+860+(f<<6)>>2]=h;f=f+1|0}i=d;return}function n4(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function n5(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=0;while(1){if((c|0)>=3){break}d=+ck(+(+g[b+(c<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[a+860+(c<<6)>>2]=e;c=c+1|0}return}function n6(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function n7(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function n8(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=0;while(1){if((c|0)>=3){break}d=+ck(+(+g[b+(c<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[a+860+(c<<6)+4>>2]=e;c=c+1|0}return}function n9(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0,S=0.0,T=0,U=0;while(1){i=aDx(1352)|0;if((i|0)!=0){break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){k=1500;break}dC[j&63]()}if((k|0)==1500){k=cd(4)|0;c[k>>2]=19096;bF(k|0,34368,676);return 0}k=i;j=i;do{if((a[43040]|0)==0){if((b1(43040)|0)==0){break}do{if((a[43048]|0)==0){if((b1(43048)|0)==0){break}g[10704]=1.0;aDD(42820,0,16);g[10709]=1.0;aDD(42840,0,16);g[10714]=1.0;g[10715]=0.0}}while(0);c[10688]=c[10704];c[10689]=c[10705];c[10690]=c[10706];c[10691]=c[10707];c[10692]=c[10708];c[42772>>2]=c[42836>>2];c[42776>>2]=c[42840>>2];c[42780>>2]=c[42844>>2];c[10696]=c[10712];c[42788>>2]=c[42852>>2];c[42792>>2]=c[42856>>2];c[42796>>2]=c[42860>>2];aDD(42800,0,16)}}while(0);do{if((a[43040]|0)==0){if((b1(43040)|0)==0){break}do{if((a[43048]|0)==0){if((b1(43048)|0)==0){break}g[10704]=1.0;aDD(42820,0,16);g[10709]=1.0;aDD(42840,0,16);g[10714]=1.0;g[10715]=0.0}}while(0);c[10688]=c[10704];c[10689]=c[10705];c[10690]=c[10706];c[10691]=c[10707];c[10692]=c[10708];c[42772>>2]=c[42836>>2];c[42776>>2]=c[42840>>2];c[42780>>2]=c[42844>>2];c[10696]=c[10712];c[42788>>2]=c[42852>>2];c[42792>>2]=c[42856>>2];c[42796>>2]=c[42860>>2];aDD(42800,0,16)}}while(0);aoY(j,b,d,42752,42752,1);c[i>>2]=21976;j=i+1304|0;l=e;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=i+1320|0;j=f;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=i+1336|0;l=h;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=f|0;m=+g[l>>2];j=f+4|0;n=+g[j>>2];o=f+8|0;p=+g[o>>2];q=1.0/+Q(+(m*m+n*n+p*p));r=m*q;g[l>>2]=r;m=n*q;g[j>>2]=m;n=p*q;g[o>>2]=n;o=h|0;q=+g[o>>2];j=h+4|0;p=+g[j>>2];l=h+8|0;s=+g[l>>2];t=1.0/+Q(+(q*q+p*p+s*s));u=q*t;g[o>>2]=u;q=p*t;g[j>>2]=q;p=s*t;g[l>>2]=p;t=n*q-m*p;s=r*p-n*u;v=m*u-r*q;w=+g[e>>2];x=+g[e+4>>2];y=+g[e+8>>2];z=+g[b+4>>2];A=+g[b+20>>2];B=+g[b+36>>2];D=+g[b+8>>2];E=+g[b+24>>2];F=+g[b+40>>2];G=+g[b+12>>2];H=+g[b+28>>2];I=+g[b+44>>2];J=-0.0- +g[b+52>>2];K=-0.0- +g[b+56>>2];L=-0.0- +g[b+60>>2];g[i+40>>2]=t*z+s*A+v*B;g[i+44>>2]=u*z+q*A+p*B;g[i+48>>2]=r*z+m*A+n*B;g[i+52>>2]=0.0;g[i+56>>2]=t*D+s*E+v*F;g[i+60>>2]=u*D+q*E+p*F;g[i+64>>2]=r*D+m*E+n*F;g[i+68>>2]=0.0;g[i+72>>2]=t*G+s*H+v*I;g[i+76>>2]=u*G+q*H+p*I;g[i+80>>2]=r*G+m*H+n*I;g[i+84>>2]=0.0;g[i+88>>2]=w*z+x*A+y*B+(z*J+A*K+B*L);g[i+92>>2]=w*D+x*E+y*F+(D*J+E*K+F*L);g[i+96>>2]=w*G+x*H+y*I+(G*J+H*K+I*L);g[i+100>>2]=0.0;L=+g[d+4>>2];I=+g[d+20>>2];K=+g[d+36>>2];H=+g[d+8>>2];J=+g[d+24>>2];G=+g[d+40>>2];F=+g[d+12>>2];E=+g[d+28>>2];D=+g[d+44>>2];B=-0.0- +g[d+52>>2];A=-0.0- +g[d+56>>2];z=-0.0- +g[d+60>>2];g[i+104>>2]=t*L+s*I+v*K;g[i+108>>2]=u*L+q*I+p*K;g[i+112>>2]=r*L+m*I+n*K;g[i+116>>2]=0.0;g[i+120>>2]=t*H+s*J+v*G;g[i+124>>2]=u*H+q*J+p*G;g[i+128>>2]=r*H+m*J+n*G;g[i+132>>2]=0.0;g[i+136>>2]=t*F+s*E+v*D;g[i+140>>2]=u*F+q*E+p*D;g[i+144>>2]=r*F+m*E+n*D;g[i+148>>2]=0.0;g[i+152>>2]=w*L+x*I+y*K+(L*B+I*A+K*z);g[i+156>>2]=w*H+x*J+y*G+(H*B+J*A+G*z);g[i+160>>2]=w*F+x*E+y*D+(F*B+E*A+D*z);g[i+164>>2]=0.0;aDD(i+672|0,0,32);z=+ck(0.0,6.2831854820251465);do{if(z<-3.1415927410125732){M=z+6.2831854820251465}else{if(z<=3.1415927410125732){M=z;break}M=z-6.2831854820251465}}while(0);g[i+860>>2]=M;M=+ck(-1.5607963800430298,6.2831854820251465);do{if(M<-3.1415927410125732){N=M+6.2831854820251465}else{if(M<=3.1415927410125732){N=M;break}N=M-6.2831854820251465}}while(0);g[i+924>>2]=N;N=+ck(-3.1315927505493164,6.2831854820251465);do{if(N<-3.1415927410125732){O=N+6.2831854820251465}else{if(N<=3.1415927410125732){O=N;break}O=N-6.2831854820251465}}while(0);g[i+988>>2]=O;O=+ck(0.0,6.2831854820251465);do{if(O<-3.1415927410125732){P=O+6.2831854820251465}else{if(O<=3.1415927410125732){P=O;break}P=O-6.2831854820251465}}while(0);g[i+864>>2]=P;P=+ck(1.5607963800430298,6.2831854820251465);do{if(P<-3.1415927410125732){R=P+6.2831854820251465}else{if(P<=3.1415927410125732){R=P;break}R=P-6.2831854820251465}}while(0);g[i+928>>2]=R;R=+ck(3.1315927505493164,6.2831854820251465);if(R<-3.1415927410125732){S=R+6.2831854820251465;T=i+992|0;U=T;g[U>>2]=S;return k|0}if(R<=3.1415927410125732){S=R;T=i+992|0;U=T;g[U>>2]=S;return k|0}S=R-6.2831854820251465;T=i+992|0;U=T;g[U>>2]=S;return k|0}function oa(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function ob(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function oc(a){a=a|0;return(c[a+4>>2]|0)==31|0}function od(a){a=a|0;return(c[a+4>>2]|0)<7|0}function oe(a){a=a|0;return(c[a+4>>2]|0)<20|0}function of(a){a=a|0;return(c[a+4>>2]|0)==28|0}function og(a){a=a|0;return c[a+8>>2]|0}function oh(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function oi(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function oj(a){a=a|0;return(c[a+4>>2]|0)==32|0}function ok(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function ol(a){a=a|0;return c[a+4>>2]|0}function om(a,b){a=a|0;b=+b;var d=0,e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0;d=a+216|0;e=c[d>>2]|0;if((e|0)==2|(e|0)==4){return}f=+g[a+304>>2];h=+g[a+308>>2];i=+g[a+312>>2];j=+g[a+464>>2];do{if(f*f+h*h+i*i<j*j){k=+g[a+320>>2];l=+g[a+324>>2];m=+g[a+328>>2];n=+g[a+468>>2];if(k*k+l*l+m*m>=n*n){break}o=a+220|0;g[o>>2]=+g[o>>2]+b;return}}while(0);g[a+220>>2]=0.0;if((e-4|0)>>>0<2){return}c[d>>2]=0;return}function on(a,b){a=a|0;b=b|0;c[a+236>>2]=b;return}function oo(b){b=b|0;var d=0,e=0;d=c[b+216>>2]|0;do{if((d|0)==4){e=0}else{if((a[39240]&1)!=0){e=0;break}if((d-2|0)>>>0<2){e=1;break}if(+g[b+220>>2]>2.0){e=1;break}e=0}}while(0);return e|0}function op(a){a=a|0;return a+132|0}function oq(a,b){a=a|0;b=b|0;c[a+604>>2]=b;return}function or(a){a=a|0;return+(+g[a+240>>2])}function os(a){a=a|0;return a+584|0}function ot(a){a=a|0;return a+552|0}function ou(a,b){a=a|0;b=b|0;c[a+208>>2]=b;return}function ov(a){a=a|0;return+(+g[a+336>>2])}function ow(a){a=a|0;return c[a+204>>2]|0}function ox(a){a=a|0;return a+404|0}function oy(a){a=a|0;return a+52|0}function oz(a){a=a|0;return+(+g[a+220>>2])}function oA(a){a=a|0;return c[a+200>>2]|0}function oB(a){a=a|0;return a+372|0}function oC(a,b){a=a|0;b=b|0;c[a+496>>2]=b;return}function oD(a){a=a|0;var b=0;b=c[a+216>>2]|0;return((b|0)==2?0:(b|0)!=5)|0}function oE(a){a=a|0;return c[a+216>>2]|0}function oF(a){a=a|0;return a+420|0}function oG(a){a=a|0;return a+256|0}function oH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;d=+g[b>>2]- +g[a+52>>2];e=+g[b+4>>2]- +g[a+56>>2];f=+g[b+8>>2]- +g[a+60>>2];h=+g[c+8>>2];i=+g[c+4>>2];j=e*h-f*i;k=+g[c>>2];l=f*k-d*h;m=d*i-e*k;n=+g[a+256>>2]*j+ +g[a+272>>2]*l+ +g[a+288>>2]*m;o=+g[a+260>>2]*j+ +g[a+276>>2]*l+ +g[a+292>>2]*m;p=+g[a+264>>2]*j+ +g[a+280>>2]*l+ +g[a+296>>2]*m;return+(+g[a+336>>2]+(k*(o*f-p*e)+i*(p*d-n*f)+h*(n*e-o*d)))}function oI(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0;e=a+1320|0;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+1336|0;e=d;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];h=+g[b>>2];i=+g[b+4>>2];j=+g[b+8>>2];k=1.0/+Q(+(h*h+i*i+j*j));l=h*k;h=i*k;i=j*k;k=+g[d>>2];j=+g[d+4>>2];m=+g[d+8>>2];n=1.0/+Q(+(k*k+j*j+m*m));o=k*n;k=j*n;j=m*n;n=i*k-h*j;m=l*j-i*o;p=h*o-l*k;q=+g[a+1304>>2];r=+g[a+1308>>2];s=+g[a+1312>>2];d=c[a+24>>2]|0;t=+g[d+4>>2];u=+g[d+20>>2];v=+g[d+36>>2];w=+g[d+8>>2];x=+g[d+24>>2];y=+g[d+40>>2];z=+g[d+12>>2];A=+g[d+28>>2];B=+g[d+44>>2];C=-0.0- +g[d+52>>2];D=-0.0- +g[d+56>>2];E=-0.0- +g[d+60>>2];g[a+40>>2]=n*t+m*u+p*v;g[a+44>>2]=o*t+k*u+j*v;g[a+48>>2]=l*t+h*u+i*v;g[a+52>>2]=0.0;g[a+56>>2]=n*w+m*x+p*y;g[a+60>>2]=o*w+k*x+j*y;g[a+64>>2]=l*w+h*x+i*y;g[a+68>>2]=0.0;g[a+72>>2]=n*z+m*A+p*B;g[a+76>>2]=o*z+k*A+j*B;g[a+80>>2]=l*z+h*A+i*B;g[a+84>>2]=0.0;g[a+88>>2]=q*t+r*u+s*v+(t*C+u*D+v*E);g[a+92>>2]=q*w+r*x+s*y+(w*C+x*D+y*E);g[a+96>>2]=q*z+r*A+s*B+(z*C+A*D+B*E);g[a+100>>2]=0.0;b=c[a+28>>2]|0;E=+g[b+4>>2];B=+g[b+20>>2];D=+g[b+36>>2];A=+g[b+8>>2];C=+g[b+24>>2];z=+g[b+40>>2];y=+g[b+12>>2];x=+g[b+28>>2];w=+g[b+44>>2];v=-0.0- +g[b+52>>2];u=-0.0- +g[b+56>>2];t=-0.0- +g[b+60>>2];g[a+104>>2]=n*E+m*B+p*D;g[a+108>>2]=o*E+k*B+j*D;g[a+112>>2]=l*E+h*B+i*D;g[a+116>>2]=0.0;g[a+120>>2]=n*A+m*C+p*z;g[a+124>>2]=o*A+k*C+j*z;g[a+128>>2]=l*A+h*C+i*z;g[a+132>>2]=0.0;g[a+136>>2]=n*y+m*x+p*w;g[a+140>>2]=o*y+k*x+j*w;g[a+144>>2]=l*y+h*x+i*w;g[a+148>>2]=0.0;g[a+152>>2]=q*E+r*B+s*D+(E*v+B*u+D*t);g[a+156>>2]=q*A+r*C+s*z+(A*v+C*u+z*t);g[a+160>>2]=q*y+r*x+s*w+(y*v+x*u+w*t);g[a+164>>2]=0.0;aoZ(a|0,d+4|0,b+4|0);return}function oJ(a,b){a=a|0;b=b|0;return ao$(a|0,b)|0}function oK(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function oL(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function oM(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function oN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function oO(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function oP(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function oQ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function oR(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function oS(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function oT(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function oU(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function oV(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function oW(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function oX(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function oY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function oZ(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function o_(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43880]|0)==0){if((b1(43880)|0)==0){break}}}while(0);ec(b+4|0,e);b=e;c[9550]=c[b>>2];c[9551]=c[b+4>>2];c[9552]=c[b+8>>2];c[9553]=c[b+12>>2];i=d;return 38200}function o$(a,b,c){a=a|0;b=+b;c=c|0;apV(a,b,c);return}function o0(a,b){a=a|0;b=b|0;c[a+472>>2]=b;if((b|0)==0){return}cv[c[(c[b>>2]|0)+8>>2]&2047](b,a+4|0);return}function o1(a){a=a|0;aDD(a+404|0,0,32);return}function o2(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function o3(a,b){a=a|0;b=b|0;ap4(a,b);return}function o4(){var a=0,b=0,d=0;while(1){a=aDx(32)|0;if((a|0)!=0){b=1645;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==1645){c[a+8>>2]=0;g[a+12>>2]=0.0;c[a>>2]=25688;c[a+4>>2]=27;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function o5(a){a=a|0;return+(+g[a+464>>2])}function o6(a){a=a|0;return c[a+196>>2]|0}function o7(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0,h=0.0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=b|0;e=+g[a+340>>2];f=b+4|0;h=+g[a+344>>2];i=+g[f>>2]*h;j=b+8|0;k=+g[a+348>>2];l=+g[j>>2]*k;b=a+404|0;g[b>>2]=+g[b>>2]+ +g[d>>2]*e;b=a+408|0;g[b>>2]=+g[b>>2]+i;b=a+412|0;g[b>>2]=+g[b>>2]+l;l=+g[d>>2]*e;e=+g[f>>2]*h;h=+g[j>>2]*k;k=+g[c+4>>2];i=+g[c+8>>2];m=+g[c>>2];n=(i*l-m*h)*+g[a+540>>2];o=(m*e-k*l)*+g[a+544>>2];c=a+420|0;g[c>>2]=+g[c>>2]+(k*h-i*e)*+g[a+536>>2];c=a+424|0;g[c>>2]=+g[c>>2]+n;c=a+428|0;g[c>>2]=+g[c>>2]+o;return}function o8(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;d=+g[a+320>>2]+ +g[a+520>>2];e=+g[a+324>>2]+ +g[a+524>>2];f=+g[a+328>>2]+ +g[a+528>>2];h=+g[b+8>>2];i=+g[b+4>>2];j=+g[b>>2];k=+g[a+308>>2]+ +g[a+508>>2]+(f*j-d*h);l=+g[a+312>>2]+ +g[a+512>>2]+(d*i-e*j);g[c>>2]=+g[a+304>>2]+ +g[a+504>>2]+(e*h-f*i);g[c+4>>2]=k;g[c+8>>2]=l;g[c+12>>2]=0.0;return}function o9(a){a=a|0;return(c[a+204>>2]&7|0)==0|0}function pa(a){a=a|0;return+(+g[a+224>>2])}function pb(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function pc(a){a=a|0;return a+520|0}function pd(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0;c=+g[b+4>>2]*+g[a+344>>2];d=+g[b+8>>2]*+g[a+348>>2];e=a+404|0;g[e>>2]=+g[e>>2]+ +g[b>>2]*+g[a+340>>2];b=a+408|0;g[b>>2]=+g[b>>2]+c;b=a+412|0;g[b>>2]=+g[b>>2]+d;return}function pe(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0,f=0.0,h=0,i=0.0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;d=+g[a+336>>2];if(d==0.0){return}e=b|0;f=+g[a+340>>2];h=b+4|0;i=+g[a+344>>2];j=b+8|0;k=+g[a+348>>2];l=+g[h>>2]*i*d;m=+g[j>>2]*k*d;b=a+304|0;g[b>>2]=+g[b>>2]+ +g[e>>2]*f*d;b=a+308|0;g[b>>2]=+g[b>>2]+l;b=a+312|0;g[b>>2]=+g[b>>2]+m;if((a+536|0)==0){return}m=+g[e>>2]*f;f=+g[h>>2]*i;i=+g[j>>2]*k;k=+g[c+4>>2];l=+g[c+8>>2];d=k*i-l*f;n=+g[c>>2];o=l*m-n*i;i=n*f-k*m;m=(+g[a+272>>2]*d+ +g[a+276>>2]*o+ +g[a+280>>2]*i)*+g[a+540>>2];k=(+g[a+288>>2]*d+ +g[a+292>>2]*o+ +g[a+296>>2]*i)*+g[a+544>>2];c=a+320|0;g[c>>2]=+g[c>>2]+(+g[a+256>>2]*d+ +g[a+260>>2]*o+ +g[a+264>>2]*i)*+g[a+536>>2];c=a+324|0;g[c>>2]=+g[c>>2]+m;c=a+328|0;g[c>>2]=+g[c>>2]+k;return}function pf(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0;c=+g[b+4>>2]*+g[a+540>>2];d=+g[b+8>>2]*+g[a+544>>2];e=a+420|0;g[e>>2]=+g[e>>2]+ +g[b>>2]*+g[a+536>>2];b=a+424|0;g[b>>2]=+g[b>>2]+c;b=a+428|0;g[b>>2]=+g[b>>2]+d;return}function pg(a){a=a|0;return c[a+208>>2]|0}function ph(a){a=a|0;return a+536|0}function pi(a){a=a|0;return a+148|0}function pj(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function pk(a){a=a|0;return a+320|0}function pl(a){a=a|0;return a+304|0}function pm(a){a=a|0;return c[a+188>>2]|0}function pn(a){a=a|0;return c[a+236>>2]|0}function po(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function pp(a){a=a|0;return(c[a+188>>2]|0)!=0|0}function pq(a,b){a=a|0;b=b|0;c[a+192>>2]=b;return}function pr(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];return+(c*(+g[a+256>>2]*c+ +g[a+272>>2]*d+ +g[a+288>>2]*e)+d*(+g[a+260>>2]*c+ +g[a+276>>2]*d+ +g[a+292>>2]*e)+e*(+g[a+264>>2]*c+ +g[a+280>>2]*d+ +g[a+296>>2]*e))}function ps(a){a=a|0;return+(+g[a+440>>2])}function pt(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function pu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=a+480|0;e=c[d>>2]|0;f=a+488|0;g=0;while(1){if((g|0)>=(e|0)){h=e;i=1683;break}j=c[f>>2]|0;k=j+(g<<2)|0;if((c[k>>2]|0)==(b|0)){break}else{g=g+1|0}}if((i|0)==1683){l=(h|0)>0;m=l&1;n=a+252|0;c[n>>2]=m;return}i=e-1|0;c[k>>2]=c[j+(i<<2)>>2];c[(c[f>>2]|0)+(i<<2)>>2]=b;b=(c[d>>2]|0)-1|0;c[d>>2]=b;h=b;l=(h|0)>0;m=l&1;n=a+252|0;c[n>>2]=m;return}function pv(a){a=a|0;return a+536|0}function pw(a){a=a|0;return(c[a+204>>2]&3|0)!=0|0}function px(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function py(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function pz(a){a=a|0;var b=0.0,c=0.0;if(+g[a+336>>2]==0.0){return}b=+g[a+308>>2]+ +g[a+508>>2];c=+g[a+312>>2]+ +g[a+512>>2];g[a+304>>2]=+g[a+304>>2]+ +g[a+504>>2];g[a+308>>2]=b;g[a+312>>2]=c;g[a+316>>2]=0.0;c=+g[a+324>>2]+ +g[a+524>>2];b=+g[a+328>>2]+ +g[a+528>>2];g[a+320>>2]=+g[a+320>>2]+ +g[a+520>>2];g[a+324>>2]=c;g[a+328>>2]=b;g[a+332>>2]=0.0;return}function pA(b){b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(627)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;g[e+164>>2]=1.0;g[e+168>>2]=1.0;g[e+172>>2]=1.0;g[e+176>>2]=0.0;c[e+180>>2]=0;g[e+184>>2]=999999984306749400.0;aDD(e+188|0,0,16);c[e+204>>2]=1;c[e+208>>2]=-1;c[e+212>>2]=-1;c[e+216>>2]=1;g[e+220>>2]=0.0;g[e+224>>2]=.5;g[e+228>>2]=0.0;c[e+232>>2]=1;c[e+236>>2]=0;g[e+240>>2]=1.0;g[e+244>>2]=0.0;g[e+248>>2]=0.0;c[e+252>>2]=0;g[e+4>>2]=1.0;aDD(e+8|0,0,16);g[e+24>>2]=1.0;aDD(e+28|0,0,16);g[e+44>>2]=1.0;aDD(e+48|0,0,20);c[e>>2]=26048;a[e+492|0]=1;c[e+488>>2]=0;c[e+480>>2]=0;c[e+484>>2]=0;ap_(f,b);return f|0}function pB(a,b,d){a=+a;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+16|0;f=e|0;c[9806]=(c[9806]|0)+1;g=aDx(627)|0;if((g|0)==0){h=0}else{j=-(g+4|0)&15;c[g+j>>2]=g;h=g+(j+4)|0}j=h;aDD(f|0,0,16);ap$(j,a,b,d,f);i=e;return j|0}function pC(a,b,d,e){a=+a;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;c[9806]=(c[9806]|0)+1;f=aDx(627)|0;if((f|0)==0){g=0}else{h=-(f+4|0)&15;c[f+h>>2]=f;g=f+(h+4)|0}h=g;ap$(h,a,b,d,e);return h|0}function pD(a,b,c){a=a|0;b=b|0;c=c|0;pe(a,b,c);return}function pE(a,b,c){a=a|0;b=+b;c=c|0;anY(a+4|0,+g[a+304>>2],+g[a+308>>2],+g[a+312>>2],a+320|0,b,c);return}function pF(a,b){a=a|0;b=b|0;return dj[c[c[a>>2]>>2]&511](a,b)|0}function pG(a,b){a=a|0;b=b|0;var d=0;d=a+320|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function pH(a,b){a=a|0;b=b|0;ap6(a,b);return}function pI(a,b){a=a|0;b=+b;ap5(a,b);return}function pJ(a,b){a=a|0;b=b|0;ap4(a,b);return}function pK(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0.0,l=0,m=0.0;d=i;i=i+64|0;e=d|0;f=e;if(+g[a+336>>2]==0.0){i=d;return}h=a+304|0;j=a+308|0;k=+g[j>>2]+ +g[a+508>>2];l=a+312|0;m=+g[l>>2]+ +g[a+512>>2];g[h>>2]=+g[h>>2]+ +g[a+504>>2];g[j>>2]=k;g[l>>2]=m;g[a+316>>2]=0.0;l=a+320|0;j=a+324|0;m=+g[j>>2]+ +g[a+524>>2];h=a+328|0;k=+g[h>>2]+ +g[a+528>>2];g[l>>2]=+g[l>>2]+ +g[a+520>>2];g[j>>2]=m;g[h>>2]=k;g[a+332>>2]=0.0;h=a+4|0;anY(h,+g[a+568>>2],+g[a+572>>2],+g[a+576>>2],a+584|0,b,e);j=h;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];f=a+20|0;j=e+16|0;c[f>>2]=c[j>>2];c[f+4>>2]=c[j+4>>2];c[f+8>>2]=c[j+8>>2];c[f+12>>2]=c[j+12>>2];j=a+36|0;f=e+32|0;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];f=a+52|0;a=e+48|0;c[f>>2]=c[a>>2];c[f+4>>2]=c[a+4>>2];c[f+8>>2]=c[a+8>>2];c[f+12>>2]=c[a+12>>2];i=d;return}function pL(a,b){a=a|0;b=b|0;var d=0;d=a+132|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function pM(a){a=a|0;var b=0.0,d=0.0,e=0;if((c[a+204>>2]&3|0)!=0){return}b=+g[a+360>>2]*+g[a+344>>2];d=+g[a+364>>2]*+g[a+348>>2];e=a+404|0;g[e>>2]=+g[a+356>>2]*+g[a+340>>2]+ +g[e>>2];e=a+408|0;g[e>>2]=b+ +g[e>>2];e=a+412|0;g[e>>2]=d+ +g[e>>2];return}function pN(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0;if(+g[a+336>>2]==0.0){return}e=+g[b+4>>2]*d;f=+g[b+8>>2]*d;h=a+504|0;g[h>>2]=+g[h>>2]+ +g[b>>2]*d;b=a+508|0;g[b>>2]=+g[b>>2]+e;b=a+512|0;g[b>>2]=+g[b>>2]+f;f=+g[c+4>>2]*+g[a+540>>2]*d;e=+g[c+8>>2]*+g[a+544>>2]*d;b=a+520|0;g[b>>2]=+g[b>>2]+ +g[c>>2]*+g[a+536>>2]*d;c=a+524|0;g[c>>2]=+g[c>>2]+f;c=a+528|0;g[c>>2]=+g[c>>2]+e;return}function pO(a,b){a=a|0;b=b|0;c[a+196>>2]=b;return}function pP(a){a=a|0;var b=0;if((c[a+204>>2]&3|0)!=0){return}b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function pQ(a,b){a=a|0;b=b|0;do{if(!b){if((c[a+204>>2]&3|0)==0){break}return}}while(0);b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function pR(a){a=a|0;return c[a+472>>2]|0}function pS(a,b){a=a|0;b=b|0;c[a+212>>2]=b;return}function pT(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0;if(+g[a+336>>2]==0.0){return}e=+g[b+4>>2]*d;f=+g[b+8>>2]*d;h=a+568|0;g[h>>2]=+g[h>>2]+ +g[b>>2]*d;b=a+572|0;g[b>>2]=+g[b>>2]+e;b=a+576|0;g[b>>2]=+g[b>>2]+f;f=+g[c+4>>2]*+g[a+540>>2]*d;e=+g[c+8>>2]*+g[a+544>>2]*d;b=a+584|0;g[b>>2]=+g[b>>2]+ +g[c>>2]*+g[a+536>>2]*d;c=a+588|0;g[c>>2]=+g[c>>2]+f;c=a+592|0;g[c>>2]=+g[c>>2]+e;return}function pU(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function pV(a){a=a|0;return+(+g[a+248>>2])}function pW(a){a=a|0;return a+340|0}function pX(a){a=a|0;return a+164|0}function pY(a){a=a|0;return+(+g[a+468>>2])}function pZ(a){a=a|0;return a+68|0}function p_(a,b){a=a|0;b=b|0;var c=0;c=a+52|0;g[c>>2]=+g[c>>2]+ +g[b>>2];c=a+56|0;g[c>>2]=+g[c>>2]+ +g[b+4>>2];c=a+60|0;g[c>>2]=+g[c>>2]+ +g[b+8>>2];return}function p$(a){a=a|0;return a+4|0}function p0(a){a=a|0;return c[a+188>>2]|0}function p1(a){a=a|0;return c[a+192>>2]|0}function p2(a){a=a|0;return c[a+600>>2]|0}function p3(a){a=a|0;return a+504|0}function p4(a){a=a|0;return(c[a+204>>2]&4|0)==0|0}function p5(a){a=a|0;var b=0;if((c[a+232>>2]&2|0)==0){b=0}else{b=a}return b|0}function p6(a){a=a|0;return c[a+212>>2]|0}function p7(a,b){a=a|0;b=b|0;var d=0;d=a+216|0;if(((c[d>>2]|0)-4|0)>>>0<2){return}c[d>>2]=b;return}function p8(a){a=a|0;return a+520|0}function p9(a){a=a|0;return+(+g[a+244>>2])}function qa(a,b){a=a|0;b=b|0;return c[(c[a+488>>2]|0)+(b<<2)>>2]|0}function qb(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function qc(a){a=a|0;return a+4|0}function qd(a){a=a|0;return(c[a+180>>2]|0)!=0|0}function qe(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function qf(a){a=a|0;return c[a+496>>2]|0}function qg(a){a=a|0;var b=0.0;b=+g[a+248>>2];return+(b*b)}function qh(a){a=a|0;return a+568|0}function qi(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;b=+g[a+4>>2];c=+g[a+388>>2];d=b*c;e=+g[a+8>>2];f=+g[a+392>>2];h=e*f;i=+g[a+12>>2];j=+g[a+396>>2];k=i*j;l=+g[a+20>>2];m=c*l;n=+g[a+24>>2];o=f*n;p=+g[a+28>>2];q=j*p;r=+g[a+36>>2];s=c*r;c=+g[a+40>>2];t=f*c;f=+g[a+44>>2];u=j*f;g[a+256>>2]=b*d+e*h+i*k;g[a+260>>2]=d*l+h*n+k*p;g[a+264>>2]=d*r+h*c+k*f;g[a+268>>2]=0.0;g[a+272>>2]=b*m+e*o+i*q;g[a+276>>2]=l*m+n*o+p*q;g[a+280>>2]=m*r+o*c+q*f;g[a+284>>2]=0.0;g[a+288>>2]=b*s+e*t+i*u;g[a+292>>2]=l*s+n*t+p*u;g[a+296>>2]=r*s+c*t+f*u;g[a+300>>2]=0.0;return}function qj(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function qk(a,b,c){a=a|0;b=+b;c=+c;var d=0.0,e=0.0;if(b<0.0){d=0.0}else{d=b>1.0?1.0:b}g[a+436>>2]=d;if(c<0.0){e=0.0}else{e=c>1.0?1.0:c}g[a+440>>2]=e;return}function ql(a){a=a|0;return c[a+232>>2]|0}function qm(a,b){a=a|0;b=b|0;c[a+600>>2]=b;return}function qn(a){a=a|0;return a+388|0}function qo(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];f=(+g[a+272>>2]*c+ +g[a+276>>2]*d+ +g[a+280>>2]*e)*+g[a+540>>2];h=(+g[a+288>>2]*c+ +g[a+292>>2]*d+ +g[a+296>>2]*e)*+g[a+544>>2];b=a+320|0;g[b>>2]=+g[b>>2]+(+g[a+256>>2]*c+ +g[a+260>>2]*d+ +g[a+264>>2]*e)*+g[a+536>>2];b=a+324|0;g[b>>2]=+g[b>>2]+f;b=a+328|0;g[b>>2]=+g[b>>2]+h;return}function qp(a){a=a|0;return a+568|0}function qq(a){a=a|0;return(c[a+204>>2]&1|0)!=0|0}function qr(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0;c=+g[a+336>>2];d=+g[b+4>>2]*+g[a+344>>2]*c;e=+g[b+8>>2]*+g[a+348>>2]*c;f=a+304|0;g[f>>2]=+g[f>>2]+ +g[b>>2]*+g[a+340>>2]*c;b=a+308|0;g[b>>2]=+g[b>>2]+d;b=a+312|0;g[b>>2]=+g[b>>2]+e;return}function qs(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function qt(a){a=a|0;return a+504|0}function qu(a,b,c){a=a|0;b=+b;c=+c;g[a+464>>2]=b;g[a+468>>2]=c;return}function qv(a){a=a|0;return c[a+604>>2]|0}function qw(a,b){a=a|0;b=b|0;var c=0.0,d=0.0;c=+g[a+324>>2]+ +g[a+524>>2];d=+g[a+328>>2]+ +g[a+528>>2];g[b>>2]=+g[a+320>>2]+ +g[a+520>>2];g[b+4>>2]=c;g[b+8>>2]=d;g[b+12>>2]=0.0;return}function qx(a){a=a|0;return c[a+480>>2]|0}function qy(a){a=a|0;return+(+g[a+228>>2])}function qz(a){a=a|0;return+(+g[a+184>>2])}function qA(a){a=a|0;return a+584|0}function qB(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a,b,d)|0}function qC(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;do{if((a[43792]|0)==0){if((b1(43792)|0)==0){break}}}while(0);d=+g[b+324>>2];e=+g[c+8>>2];f=+g[b+328>>2];h=+g[c+4>>2];i=+g[c>>2];j=+g[b+320>>2];k=+g[b+308>>2]+(f*i-j*e);l=+g[b+312>>2]+(j*h-d*i);g[9546]=+g[b+304>>2]+(d*e-f*h);g[9547]=k;g[9548]=l;g[9549]=0.0;return 38184}function qD(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=c[a+192>>2]|0;dI[c[(c[e>>2]|0)+8>>2]&1023](e,a+4|0,b,d);return}function qE(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function qF(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a+164|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];do{if(+g[b>>2]!=1.0){f=1}else{if(+g[b+4>>2]!=1.0){f=1;break}f=+g[b+8>>2]!=1.0|0}}while(0);c[a+180>>2]=f;return}function qG(a,b){a=a|0;b=+b;ap0(a,b);return}function qH(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+20|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+36|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+52|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function qI(a,b){a=a|0;b=b|0;var d=0.0,e=0.0,f=0.0,h=0;d=+g[a+336>>2];if(d!=0.0){e=1.0/d;d=e*+g[b+4>>2];f=e*+g[b+8>>2];g[a+356>>2]=e*+g[b>>2];g[a+360>>2]=d;g[a+364>>2]=f;g[a+368>>2]=0.0}h=a+372|0;a=b;c[h>>2]=c[a>>2];c[h+4>>2]=c[a+4>>2];c[h+8>>2]=c[a+8>>2];c[h+12>>2]=c[a+12>>2];return}function qJ(a,b){a=a|0;b=b|0;var d=0;d=a+536|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function qK(a,b){a=a|0;b=b|0;var d=0;d=a+148|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function qL(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0}function qM(a,b){a=a|0;b=b|0;var d=0;if((c[a+252>>2]|0)==0){d=1;return d|0}d=dj[c[c[a>>2]>>2]&511](a|0,b)|0;return d|0}function qN(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0;d=a+340|0;e=d;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];h=+g[a+336>>2];i=+g[a+344>>2]*h;j=+g[a+348>>2]*h;g[a+552>>2]=+g[d>>2]*h;g[a+556>>2]=i;g[a+560>>2]=j;g[a+564>>2]=0.0;return}function qO(a,b){a=a|0;b=b|0;var d=0;d=a+304|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function qP(a,b){a=a|0;b=b|0;var d=0;d=a+388|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function qQ(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function qR(){return 0}function qS(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function qT(a){a=a|0;return+(+g[a+436>>2])}function qU(a){a=a|0;return a+104|0}function qV(b,c,d){b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=+g[c>>2]+-1.0;f=+g[c+4>>2]+-1.0;h=+g[c+8>>2]+-1.0;g[b+4>>2]=e;g[b+8>>2]=f;g[b+12>>2]=h;g[b+16>>2]=0.0;i=+g[d>>2]+1.0;j=+g[d+4>>2]+1.0;k=+g[d+8>>2]+1.0;g[b+20>>2]=i;g[b+24>>2]=j;g[b+28>>2]=k;g[b+32>>2]=0.0;g[b+36>>2]=65533.0/(i-e);g[b+40>>2]=65533.0/(j-f);g[b+44>>2]=65533.0/(k-h);g[b+48>>2]=0.0;a[b+60|0]=1;return}function qW(b,c,d,e){b=b|0;c=c|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;f=+g[c>>2]-e;h=+g[c+4>>2]-e;i=+g[c+8>>2]-e;g[b+4>>2]=f;g[b+8>>2]=h;g[b+12>>2]=i;g[b+16>>2]=0.0;j=+g[d>>2]+e;k=+g[d+4>>2]+e;l=+g[d+8>>2]+e;g[b+20>>2]=j;g[b+24>>2]=k;g[b+28>>2]=l;g[b+32>>2]=0.0;g[b+36>>2]=65533.0/(j-f);g[b+40>>2]=65533.0/(k-h);g[b+44>>2]=65533.0/(l-i);g[b+48>>2]=0.0;a[b+60|0]=1;return}function qX(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0;f=(+g[d>>2]- +g[a+4>>2])*+g[a+36>>2];h=(+g[d+4>>2]- +g[a+8>>2])*+g[a+40>>2];i=(+g[d+8>>2]- +g[a+12>>2])*+g[a+44>>2];if((e|0)==0){b[c>>1]=~~f&-2;b[c+2>>1]=~~h&-2;b[c+4>>1]=~~i&-2;return}else{b[c>>1]=~~(f+1.0)|1;b[c+2>>1]=~~(h+1.0)|1;b[c+4>>1]=~~(i+1.0)|1;return}}function qY(b){b=b|0;return(a[b+60|0]&1)!=0|0}function qZ(b){b=b|0;return(c[b+168>>2]<<5)+172+(c[b+56>>2]<<((a[b+60|0]&1)==0?6:4))|0}function q_(a){a=a|0;return a+124|0}function q$(a){a=a|0;return a+148|0}function q0(a){a=a|0;return c[a+28>>2]|0}function q1(a){a=a|0;return c[a+24>>2]|0}function q2(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function q3(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function q4(a){a=a|0;return c[a+12>>2]|0}function q5(a){a=a|0;return c[a+4>>2]|0}function q6(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function q7(b){b=b|0;return(a[b+20|0]&1)!=0|0}function q8(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function q9(a){a=a|0;return c[a+4>>2]|0}function ra(a){a=a|0;return+(+g[a+36>>2])}function rb(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function rc(b){b=b|0;return(a[b+21|0]&1)!=0|0}function rd(a){a=a|0;return c[a+4>>2]|0}function re(a){a=a|0;return c[a+12>>2]|0}function rf(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function rg(a){a=a|0;return c[a+12>>2]|0}function rh(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function ri(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function rj(a){a=a|0;return+(+g[a+32>>2])}function rk(a){a=a|0;return+(+g[a+16>>2])}function rl(a){a=a|0;return c[a+8>>2]|0}function rm(a){a=a|0;return+(+g[a+32>>2])}function rn(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function ro(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function rp(a){a=a|0;return(c[a+4>>2]|0)<7|0}function rq(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+68|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+84|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+100|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+116|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function rr(a,b){a=a|0;b=+b;ap3(a,b);return}function rs(a){a=a|0;azj(a|0);return}function rt(a,b,d){a=a|0;b=b|0;d=d|0;return(cS[c[(c[a>>2]|0)+16>>2]&511](a|0,b,d)|0)!=0|0}function ru(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a|0,b,d,e)|0}function rv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;qX(a|0,b,c,d);return}function rw(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ayA(a,b,c,d);return}function rx(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;azn(a|0,b,c,d);return}function ry(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0;h=i;i=i+32|0;j=h|0;k=h+16|0;l=b|0;aDD(j|0,0,16);aDD(k|0,0,16);if((a[b+60|0]&1)==0){azp(l,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k);i=h;return}else{azq(l,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k,c[b+56>>2]|0);i=h;return}}function rz(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;ayv(a,b,c,d,e);return}function rA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ayB(a,b,+g[c>>2],+g[c+4>>2],+g[c+8>>2],+g[d>>2],+g[d+4>>2],+g[d+8>>2]);return}function rB(a,b,c){a=a|0;b=b|0;c=c|0;return azs(a,b,c)|0}function rC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rD(a|0,b,c,d);return}function rD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0;f=i;i=i+16|0;h=f|0;j=h;k=d;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=h|0;l=+g[k>>2];m=+g[a+4>>2];if(l<m){g[k>>2]=m;n=m}else{n=l}j=h+4|0;l=+g[j>>2];m=+g[a+8>>2];if(l<m){g[j>>2]=m;o=m}else{o=l}d=h+8|0;l=+g[d>>2];m=+g[a+12>>2];if(l<m){g[d>>2]=m;p=m}else{p=l}q=h+12|0;l=+g[q>>2];m=+g[a+16>>2];if(l<m){g[q>>2]=m;r=m}else{r=l}l=+g[a+20>>2];if(l<n){g[k>>2]=l}l=+g[a+24>>2];if(l<o){g[j>>2]=l}l=+g[a+28>>2];if(l<p){g[d>>2]=l}l=+g[a+32>>2];if(l>=r){qX(a,b,h,e);i=f;return}g[q>>2]=l;qX(a,b,h,e);i=f;return}function rE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ayw(a,b,c,d);return}function rF(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function rG(a){a=a|0;return cA[c[(c[a>>2]|0)+12>>2]&4095](a|0)|0}function rH(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function rI(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a|0,b);return}function rJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e)|0}function rK(b,c){b=b|0;c=c|0;var d=0.0,f=0.0;do{if((a[43928]|0)==0){if((b1(43928)|0)==0){break}}}while(0);d=+((e[c+2>>1]|0)>>>0)/+g[b+40>>2]+ +g[b+8>>2];f=+((e[c+4>>1]|0)>>>0)/+g[b+44>>2]+ +g[b+12>>2];g[9542]=+((e[c>>1]|0)>>>0)/+g[b+36>>2]+ +g[b+4>>2];g[9543]=d;g[9544]=f;g[9545]=0.0;return 38168}function rL(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0;j=b|0;if((a[b+60|0]&1)==0){azp(j,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,i);return}else{azq(j,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,i,c[b+56>>2]|0);return}}function rM(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(191)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d+52>>2]=278;a[d+60|0]=0;a[d+80|0]=1;c[d+76>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;a[d+100|0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120|0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140|0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;c[d+144>>2]=0;a[d+164|0]=1;c[d+160>>2]=0;c[d+152>>2]=0;c[d+156>>2]=0;c[d+168>>2]=0;g[d+4>>2]=-3.4028234663852886e+38;g[d+8>>2]=-3.4028234663852886e+38;g[d+12>>2]=-3.4028234663852886e+38;g[d+16>>2]=0.0;g[d+20>>2]=3.4028234663852886e+38;g[d+24>>2]=3.4028234663852886e+38;g[d+28>>2]=3.4028234663852886e+38;g[d+32>>2]=0.0;c[d>>2]=25376;return d|0}function rN(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function rO(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function rP(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function rQ(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function rR(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function rS(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function rT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function rU(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function rV(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function rW(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function rX(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f);return}function rY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function rZ(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function r_(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a)|0}function r$(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43488]|0)==0){if((b1(43488)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9538]=c[d>>2];c[9539]=c[d+4>>2];c[9540]=c[d+8>>2];c[9541]=c[d+12>>2];i=e;return 38152}function r0(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a,b,d)|0}function r1(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a)|0}function r2(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function r3(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function r4(a){a=a|0;return}function r5(a){a=a|0;return a+12|0}function r6(a){a=a|0;return+(+g[a+44>>2])}function r7(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function r8(a){a=a|0;return(c[a+4>>2]|0)<20|0}function r9(a){a=a|0;return(c[a+4>>2]|0)==28|0}function sa(a){a=a|0;return c[a+8>>2]|0}function sb(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function sc(a){a=a|0;return(c[a+4>>2]|0)==32|0}function sd(a){a=a|0;return a+28|0}function se(a){a=a|0;return(c[a+4>>2]|0)==31|0}function sf(a){a=a|0;return c[a+52>>2]|0}function sg(a){a=a|0;return c[a+4>>2]|0}function sh(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function si(a,b){a=a|0;b=b|0;c[a+140>>2]=b;return}function sj(b){b=b|0;return(a[b+153|0]&1)!=0|0}function sk(b,c){b=b|0;c=c|0;a[b+152|0]=c&1;return}function sl(a){a=a|0;return c[a+112>>2]|0}function sm(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function sn(b){b=b|0;return(a[b+152|0]&1)!=0|0}function so(a,b){a=a|0;b=b|0;c[a+108>>2]=b;return}function sp(b,c){b=b|0;c=c|0;a[b+153|0]=c&1;return}function sq(a,b){a=a|0;b=b|0;c[a+144>>2]=b;return}function sr(a,b){a=a|0;b=b|0;c[a+120>>2]=b;return}function ss(a){a=a|0;return c[a+124>>2]|0}function st(a,b){a=a|0;b=b|0;c[a+148>>2]=b;return}function su(a){a=a|0;return c[a+104>>2]|0}function sv(a,b){a=a|0;b=b|0;c[a+128>>2]=b;return}function sw(b,c){b=b|0;c=c|0;a[b+154|0]=c&1;return}function sx(a,b){a=a|0;b=b|0;c[a+132>>2]=b;return}function sy(a){a=a|0;return c[a+108>>2]|0}function sz(a){a=a|0;return c[a+140>>2]|0}function sA(a,b){a=a|0;b=b|0;c[a+112>>2]=b;return}function sB(a){a=a|0;return c[a+144>>2]|0}function sC(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function sD(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function sE(a){a=a|0;return c[a+128>>2]|0}function sF(a){a=a|0;return c[a+116>>2]|0}function sG(a,b){a=a|0;b=b|0;c[a+116>>2]=b;return}function sH(a){a=a|0;return+(+g[a+100>>2])}function sI(a){a=a|0;return c[a+148>>2]|0}function sJ(b){b=b|0;return(a[b+154|0]&1)!=0|0}function sK(a){a=a|0;return c[a+120>>2]|0}function sL(a){a=a|0;return+(+g[a+136>>2])}function sM(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a,b,d);return}function sN(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43328]|0)==0){if((b1(43328)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9534]=c[d>>2];c[9535]=c[d+4>>2];c[9536]=c[d+8>>2];c[9537]=c[d+12>>2];i=e;return 38136}function sO(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function sP(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function sQ(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a)|0}function sR(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function sS(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a,b,d,e);return}function sT(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43104]|0)==0){if((b1(43104)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9530]=c[d>>2];c[9531]=c[d+4>>2];c[9532]=c[d+8>>2];c[9533]=c[d+12>>2];i=e;return 38120}function sU(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43168]|0)==0){if((b1(43168)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9526]=c[d>>2];c[9527]=c[d+4>>2];c[9528]=c[d+8>>2];c[9529]=c[d+12>>2];i=e;return 38104}function sV(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function sW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function sX(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function sY(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function sZ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function s_(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function s$(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function s0(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a)|0}function s1(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function s2(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 13:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function s3(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function s4(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function s5(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function s6(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function s7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function s8(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a,b,d,e);return}function s9(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function ta(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+40>>2]&511](a,b,d);return}function tb(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=+g;cY[c[(c[a>>2]|0)+28>>2]&63](a,b,d,e,f,g);return}function tc(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=+j;df[c[(c[a>>2]|0)+24>>2]&63](a,b,d,e,f,g,h,i,j);return}function td(a,b,d,e,f,g){a=a|0;b=+b;d=+d;e=e|0;f=f|0;g=g|0;cK[c[(c[a>>2]|0)+84>>2]&63](a,b,d,e,f,g);return}function te(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;g=g|0;cw[c[(c[a>>2]|0)+32>>2]&63](a,b,d,e,f,g);return}function tf(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=j|0;k=k|0;dt[c[(c[a>>2]|0)+60>>2]&63](a,b,d,e,f,g,h,i,j,k,10.0);return}function tg(a,b,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=j|0;k=k|0;l=+l;dt[c[(c[a>>2]|0)+60>>2]&63](a,b,d,e,f,g,h,i,j,k,l);return}function th(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function ti(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+12>>2]&255](a,b,d,e,f);return}function tj(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function tk(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function tl(a,b,d,e,f,g){a=a|0;b=+b;d=+d;e=e|0;f=f|0;g=g|0;cK[c[(c[a>>2]|0)+80>>2]&63](a,b,d,e,f,g);return}function tm(a,b,d){a=a|0;b=b|0;d=+d;dF[c[(c[a>>2]|0)+56>>2]&255](a,b,d);return}function tn(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+52>>2]&1023](a,b,d,e);return}function to(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;cr[c[(c[a>>2]|0)+88>>2]&63](a,b,d,e,f);return}function tp(a,b,d,e,f,g){a=a|0;b=+b;d=+d;e=e|0;f=f|0;g=g|0;cK[c[(c[a>>2]|0)+76>>2]&63](a,b,d,e,f,g);return}function tq(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function tr(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+72>>2]&255](a,b,d,e,f);return}function ts(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a,b);return}function tt(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=+j;k=k|0;cs[c[(c[a>>2]|0)+64>>2]&63](a,b,d,e,f,g,h,i,j,k,10.0);return}function tu(a,b,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;g=+g;h=+h;i=+i;j=+j;k=k|0;l=+l;cs[c[(c[a>>2]|0)+64>>2]&63](a,b,d,e,f,g,h,i,j,k,l);return}function tv(a,b,d,e){a=a|0;b=+b;d=d|0;e=e|0;dg[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e);return}function tw(a,b){a=a|0;b=b|0;awS(a,b);return}function tx(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function ty(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f|0;h=f+16|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(g|0,0,16);aDD(h|0,0,16);c_[j&127](a,b,d,e,g,h);i=f;return}function tz(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(h|0,0,16);c_[j&127](a,b,d,e,f,h);i=g;return}function tA(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c_[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e,f,g);return}function tB(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+16>>2]&255](a,b,d,e,f);return}function tC(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+48>>2]&2047](a,b);return}function tD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+20>>2]&1023](a,b,d,e);return}function tE(a,b){a=a|0;b=b|0;awR(a,b);return}function tF(a){a=a|0;ct[c[(c[a>>2]|0)+52>>2]&2047](a);return}function tG(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return c5[c[(c[a>>2]|0)+8>>2]&63](a,b,d,e,f,g,h,i,j)|0}function tH(a){a=a|0;aws(a+4|0);aws(a+44|0);return}function tI(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function tJ(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function tK(){var a=0,b=0,d=0;while(1){a=aDx(156)|0;if((a|0)!=0){b=2117;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){b=2114;break}dC[d&63]()}if((b|0)==2114){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}else if((b|0)==2117){b=a;awx(b,0);return b|0}return 0}function tL(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(156)|0;if((b|0)!=0){d=2131;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){d=2128;break}dC[e&63]()}if((d|0)==2128){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}else if((d|0)==2131){d=b;awx(d,a);return d|0}return 0}function tM(a){a=a|0;return(a|0)==28|0}function tN(a){a=a|0;return(a|0)==31|0}function tO(a){a=a|0;return(a|0)<7|0}function tP(a){a=a|0;return(a|0)<20|0}function tQ(a){a=a|0;return((a|0)>20&(a|0)<30?(a|0)!=25:0)|0}function tR(a){a=a|0;return((a|0)==17?1:(a|0)==18)|0}function tS(a){a=a|0;return(a|0)==32|0}function tT(a){a=a|0;return((a|0)>20?(a|0)<30:0)|0}function tU(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function tV(a){a=a|0;return+(+g[a+100>>2])}function tW(a){a=a|0;return c[a+96>>2]|0}function tX(a){a=a|0;return c[a+132>>2]|0}function tY(a,b){a=a|0;b=b|0;c[a+124>>2]=b;return}function tZ(a,b){a=a|0;b=b|0;c[a+104>>2]=b;return}function t_(a){a=a|0;return c[a>>2]|0}function t$(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function t0(a,b){a=a|0;b=b|0;c[a+48>>2]=b;return}function t1(a){a=a|0;return c[a+48>>2]|0}function t2(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function t3(a){a=a|0;return a+16|0}function t4(a){a=a|0;return b[a+6>>1]|0}function t5(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function t6(a){a=a|0;return c[a+48>>2]|0}function t7(a){a=a|0;return c[a+12>>2]|0}function t8(a){a=a|0;return a+32|0}function t9(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function ua(a){a=a|0;return c[a+12>>2]|0}function ub(a,b){a=a|0;b=b|0;c[a+48>>2]=b;return}function uc(a,c){a=a|0;c=c|0;b[a+6>>1]=c;return}function ud(a){a=a|0;return c[a+8>>2]|0}function ue(a){a=a|0;return b[a+4>>1]|0}function uf(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function ug(a){a=a|0;return c[a+188>>2]|0}function uh(a){a=a|0;return c[a+4>>2]|0}function ui(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function uj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+200+(b*144|0)+(d<<2)>>2]=e;return}function uk(a,b){a=a|0;b=b|0;c[a+5384>>2]=b;return}function ul(a){a=a|0;return c[a+5384>>2]|0}function um(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;g=i;i=i+48|0;h=g|0;j=g+32|0;k=h;l=d;m=e;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];e=h+16|0;h=f;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=d+60|0;if((c[e>>2]|0)==2){f=b+44|0;n=d+48|0;o=c[n>>2]|0;aww(f,o)|0;f=b+48|0;p=c[f>>2]|0;if((p|0)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-44+40>>2]|0)}c[f>>2]=o;o=b+56|0;c[o>>2]=(c[o>>2]|0)-1;o=b+4|0;f=b+8|0;p=c[f>>2]|0;do{if((p|0)==0){c[9806]=(c[9806]|0)+1;q=aDx(63)|0;if((q|0)==0){r=0;break}s=-(q+4|0)&15;t=q+(s+4)|0;c[q+s>>2]=q;if((t|0)==0){r=0;break}aDD(t|0,0,44);r=t}else{c[f>>2]=0;r=p}}while(0);c[r+32>>2]=0;c[r+36>>2]=d;c[r+40>>2]=0;p=r;aDC(p|0,k|0,32)|0;awv(o,c[o>>2]|0,r);r=b+16|0;c[r>>2]=(c[r>>2]|0)+1;c[n>>2]=p}else{p=b+128|0;c[p>>2]=(c[p>>2]|0)+1;p=b+4|0;n=c[d+48>>2]|0;r=aww(p,n)|0;L2259:do{if((r|0)==0){u=0}else{o=c[b+12>>2]|0;if((o|0)>-1){v=0;w=r}else{u=c[p>>2]|0;break}while(1){if((v|0)>=(o|0)){u=w;break L2259}f=c[w+32>>2]|0;if((f|0)==0){u=w;break}else{v=v+1|0;w=f}}}}while(0);w=n;aDC(w|0,k|0,32)|0;awv(p,u,n);n=b+132|0;c[n>>2]=(c[n>>2]|0)+1}n=d+52|0;u=c[n>>2]|0;p=d+56|0;k=c[p>>2]|0;if((u|0)==0){c[b+84+(c[e>>2]<<2)>>2]=k}else{c[u+56>>2]=k}k=c[p>>2]|0;if((k|0)!=0){c[k+52>>2]=c[n>>2]}k=d+16|0;c[k>>2]=c[m>>2];c[k+4>>2]=c[m+4>>2];c[k+8>>2]=c[m+8>>2];c[k+12>>2]=c[m+12>>2];m=d+32|0;c[m>>2]=c[h>>2];c[m+4>>2]=c[h+4>>2];c[m+8>>2]=c[h+8>>2];c[m+12>>2]=c[h+12>>2];h=b+104|0;c[e>>2]=c[h>>2];e=b+84+(c[h>>2]<<2)|0;c[n>>2]=0;c[p>>2]=c[e>>2];p=c[e>>2]|0;if((p|0)!=0){c[p+52>>2]=l}c[e>>2]=l;a[b+154|0]=1;if((a[b+153|0]&1)!=0){x=32;y=0;i=g;return}c[j>>2]=23368;c[j+4>>2]=b;l=b+44|0;e=d+48|0;d=j|0;awL(l,c[l>>2]|0,c[e>>2]|0,d);l=b+4|0;awL(l,c[l>>2]|0,c[e>>2]|0,d);x=32;y=0;i=g;return}function un(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a,b,d,e);return}function uo(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function up(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,d);return}function uq(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(71)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}c[b>>2]=0;c[b+8>>2]=0;return b|0}function ur(a,d,e,f,g,h,i){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;var j=0,k=0;c[9806]=(c[9806]|0)+1;e=aDx(71)|0;if((e|0)==0){j=0}else{k=-(e+4|0)&15;c[e+k>>2]=e;j=e+(k+4)|0}c[j>>2]=f;b[j+4>>1]=g;b[j+6>>1]=h;h=j+16|0;g=a;c[h>>2]=c[g>>2];c[h+4>>2]=c[g+4>>2];c[h+8>>2]=c[g+8>>2];c[h+12>>2]=c[g+12>>2];g=j+32|0;h=d;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];c[g+12>>2]=c[h+12>>2];c[j+8>>2]=i;return j|0}function us(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ut(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function uu(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-52+48>>2]|0);return}function uv(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function uw(a,b,d){a=a|0;b=b|0;d=d|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,0)|0}function ux(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function uy(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+28>>2]&511](a,b,d)|0}function uz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function uA(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+40>>2]&511](a,b)|0}function uB(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+24>>2]&511](a,b,d)|0}function uC(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function uD(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function uE(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+12>>2]&511](a,b,d)|0}function uF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function uG(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+56>>2]&511](a,b)|0}function uH(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function uI(a){a=a|0;return cA[c[(c[a>>2]|0)+44>>2]&4095](a)|0}function uJ(a,b,c){a=a|0;b=b|0;c=c|0;ata(a,b,c);return}function uK(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function uL(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(135)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;aq6(f,a,b,16384,0,0);return f|0}function uM(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[9806]=(c[9806]|0)+1;e=aDx(135)|0;if((e|0)==0){f=0}else{g=-(e+4|0)&15;c[e+g>>2]=e;f=e+(g+4)|0}g=f;aq6(g,a,b,d,0,0);return g|0}function uN(b){b=b|0;var d=0,e=0,f=0,g=0;while(1){d=aDx(5388)|0;if((d|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){f=2257;break}dC[e&63]()}if((f|0)==2257){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}f=d;c[d>>2]=22392;c[d+4>>2]=2;a[d+24|0]=1;c[d+20>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+28>>2]=24e3;aDD(d+172|0,-1|0,16);e=d+5384|0;c[e>>2]=b;c[d+188>>2]=156;g=b;c[d+192>>2]=cA[c[(c[g>>2]|0)+12>>2]&4095](b)|0;c[d+196>>2]=cA[c[(c[g>>2]|0)+8>>2]&4095](b)|0;b=0;do{g=0;do{d=c[e>>2]|0;c[f+200+(b*144|0)+(g<<2)>>2]=cS[c[(c[d>>2]|0)+20>>2]&511](d,b,g)|0;g=g+1|0;}while((g|0)<36);b=b+1|0;}while((b|0)<36);return f|0}function uO(a){a=a|0;return b[a+56>>1]|0}function uP(a,c,d,e){a=a|0;c=c|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0;f=(+g[d>>2]- +g[a+8>>2])*+g[a+40>>2];h=(+g[d+4>>2]- +g[a+12>>2])*+g[a+44>>2];i=(+g[d+8>>2]- +g[a+16>>2])*+g[a+48>>2];do{if(f>0.0){d=b[a+6>>1]|0;if(f<+(d&65535|0)){j=(~~f&b[a+4>>1]&65535|e)&65535;break}else{j=(d&b[a+4>>1]&65535|e)&65535;break}}else{j=e&65535}}while(0);b[c>>1]=j;do{if(h>0.0){j=b[a+6>>1]|0;if(h<+(j&65535|0)){k=(~~h&b[a+4>>1]&65535|e)&65535;break}else{k=(j&b[a+4>>1]&65535|e)&65535;break}}else{k=e&65535}}while(0);b[c+2>>1]=k;if(i<=0.0){l=e&65535;m=c+4|0;b[m>>1]=l;return}k=b[a+6>>1]|0;if(i<+(k&65535|0)){l=(~~i&b[a+4>>1]&65535|e)&65535;m=c+4|0;b[m>>1]=l;return}else{l=(k&b[a+4>>1]&65535|e)&65535;m=c+4|0;b[m>>1]=l;return}}function uQ(a){a=a|0;return c[a+96>>2]|0}function uR(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,f=0;a=b;b=c;c=0;while(1){if((c|0)>=3){d=1;f=2303;break}if((e[a+54+(c<<1)>>1]|0)<(e[b+48+(c<<1)>>1]|0)){d=0;f=2304;break}if((e[b+54+(c<<1)>>1]|0)<(e[a+48+(c<<1)>>1]|0)){d=0;f=2302;break}c=c+1|0}if((f|0)==2302){return d|0}else if((f|0)==2303){return d|0}else if((f|0)==2304){return d|0}return 0}function uS(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function uT(a,d,f,h){a=a|0;d=d|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0;i=d;j=c[a+68>>2]|0;k=(b[j+((e[d+54>>1]|0)<<2)>>1]|0)+1&65535;l=c[a+72>>2]|0;m=(b[l+((e[d+56>>1]|0)<<2)>>1]|0)+1&65535;n=c[a+76>>2]|0;o=(b[n+((e[i+58>>1]|0)<<2)>>1]|0)+1&65535;p=a+40|0;q=+((e[j+((e[d+48>>1]|0)<<2)>>1]|0)>>>0)/+g[p>>2];j=a+44|0;r=+((e[l+((e[i+50>>1]|0)<<2)>>1]|0)>>>0)/+g[j>>2];i=a+48|0;s=+((e[n+((e[d+52>>1]|0)<<2)>>1]|0)>>>0)/+g[i>>2];d=f|0;g[d>>2]=q;n=f+4|0;g[n>>2]=r;l=f+8|0;g[l>>2]=s;g[f+12>>2]=0.0;f=a+8|0;g[d>>2]=q+ +g[f>>2];d=a+12|0;g[n>>2]=r+ +g[d>>2];n=a+16|0;g[l>>2]=s+ +g[n>>2];s=+((k&65535)>>>0)/+g[p>>2];r=+((m&65535)>>>0)/+g[j>>2];q=+((o&65535)>>>0)/+g[i>>2];i=h|0;g[i>>2]=s;o=h+4|0;g[o>>2]=r;j=h+8|0;g[j>>2]=q;g[h+12>>2]=0.0;g[i>>2]=s+ +g[f>>2];g[o>>2]=r+ +g[d>>2];g[j>>2]=q+ +g[n>>2];return}function uU(a,b){a=a|0;b=b|0;return(c[a+60>>2]|0)+((b&65535)<<6)|0}function uV(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function uW(a){a=a|0;return c[a>>2]|0}function uX(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function uY(a){a=a|0;return c[a+4>>2]|0}function uZ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;c[9806]=(c[9806]|0)+1;f=aDx(135)|0;if((f|0)==0){g=0}else{h=-(f+4|0)&15;c[f+h>>2]=f;g=f+(h+4)|0}h=g;aq6(h,a,b,d,e,0);return h|0}function u_(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;c[9806]=(c[9806]|0)+1;g=aDx(135)|0;if((g|0)==0){h=0}else{i=-(g+4|0)&15;c[g+i>>2]=g;h=g+(i+4)|0}i=h;aq6(i,a,b,d,e,f);return i|0}function u$(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return u0(a|0,b,c,d,e,f,g,h)|0}function u0(a,d,f,g,h,j,k,l){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,x=0,y=0;m=i;i=i+16|0;n=m|0;o=m+8|0;uP(a,n|0,d,0);uP(a,o|0,f,1);f=a+64|0;d=b[f>>1]|0;p=a+60|0;q=c[p>>2]|0;r=d&65535;b[f>>1]=b[q+(r<<6)+48>>1]|0;f=a+56|0;b[f>>1]=(b[f>>1]|0)+1&65535;c[q+(r<<6)+12>>2]=r;c[q+(r<<6)>>2]=g;b[q+(r<<6)+4>>1]=h;b[q+(r<<6)+6>>1]=j;c[q+(r<<6)+8>>2]=l;l=b[f>>1]<<1;f=l&65535;j=f|1;h=f-1|0;g=l-1&65535;s=0;while(1){if((s&65535)>=3){break}t=s&65535;u=(c[p>>2]|0)+54+(t<<1)|0;b[u>>1]=(b[u>>1]|0)+2&65535;u=a+68+(t<<2)|0;v=c[u>>2]|0;x=v+(h<<2)|0;y=v+(j<<2)|0;w=e[x>>1]|e[x+2>>1]<<16;b[y>>1]=w&65535;b[y+2>>1]=w>>16;b[(c[u>>2]|0)+(h<<2)>>1]=b[n+(t<<1)>>1]|0;b[(c[u>>2]|0)+(h<<2)+2>>1]=d;b[(c[u>>2]|0)+(f<<2)>>1]=b[o+(t<<1)>>1]|0;b[(c[u>>2]|0)+(f<<2)+2>>1]=d;b[q+(r<<6)+48+(t<<1)>>1]=g;b[q+(r<<6)+54+(t<<1)>>1]=l;s=s+1&65535}and(a,0,b[q+(r<<6)+48>>1]|0,0);ang(a,0,b[q+(r<<6)+54>>1]|0,k,0);and(a,1,b[q+(r<<6)+50>>1]|0,0);ang(a,1,b[q+(r<<6)+56>>1]|0,k,0);and(a,2,b[q+(r<<6)+52>>1]|0,1);ang(a,2,b[q+(r<<6)+58>>1]|0,k,1);i=m;return d|0}function u1(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;uP(a|0,b,c,d);return}function u2(a,b,c){a=a|0;b=b|0;c=c|0;u3(a|0,b,c);return}function u3(a,d,f){a=a|0;d=d|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=a+60|0;h=c[g>>2]|0;i=d&65535;j=a+92|0;k=c[j>>2]|0;if(!(cA[c[(c[k>>2]|0)+56>>2]&4095](k)|0)){k=c[j>>2]|0;dA[c[(c[k>>2]|0)+16>>2]&511](k|0,h+(i<<6)|0,f)}k=a+56|0;j=(e[k>>1]|0)<<1;l=0;while(1){if((l|0)>=3){break}m=(c[g>>2]|0)+54+(l<<1)|0;b[m>>1]=(b[m>>1]|0)-2&65535;l=l+1|0}l=a+6|0;m=j-1|0;j=0;while(1){if((j|0)>=3){break}n=c[a+68+(j<<2)>>2]|0;o=b[h+(i<<6)+54+(j<<1)>>1]|0;b[n+((o&65535)<<2)>>1]=b[l>>1]|0;ane(a,j,o,0);o=b[h+(i<<6)+48+(j<<1)>>1]|0;b[n+((o&65535)<<2)>>1]=b[l>>1]|0;anf(a,j,o,f,0);b[n+(m<<2)+2>>1]=0;b[n+(m<<2)>>1]=b[l>>1]|0;j=j+1|0}j=a+64|0;b[(c[g>>2]|0)+(i<<6)+48>>1]=b[j>>1]|0;b[j>>1]=d;b[k>>1]=(b[k>>1]|0)-1&65535;return}function u4(a,b){a=a|0;b=b|0;b6(a|0,b|0);return}function u5(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f|0;h=f+16|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(g|0,0,16);aDD(h|0,0,16);c_[j&127](a|0,b,d,e,g,h);i=f;return}function u6(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(h|0,0,16);c_[j&127](a|0,b,d,e,f,h);i=g;return}function u7(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c_[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e,f,g);return}function u8(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+16>>2]&255](a|0,b,d,e,f);return}function u9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+48>>2]&2047](a|0,b);return}function va(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+20>>2]&1023](a|0,b,d,e);return}function vb(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;vc(a|0,b,c,d,e);return}function vc(a,d,f,g,h){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;j=i;i=i+16|0;k=j|0;l=j+8|0;m=c[a+60>>2]|0;n=d&65535;uP(a,k|0,f,0);uP(a,l|0,g,1);g=0;while(1){if((g|0)>=3){break}f=b[m+(n<<6)+48+(g<<1)>>1]|0;d=b[m+(n<<6)+54+(g<<1)>>1]|0;o=b[k+(g<<1)>>1]|0;p=a+68+(g<<2)|0;q=c[p>>2]|0;r=q+((f&65535)<<2)|0;s=(o&65535)-(e[r>>1]|0)|0;t=b[l+(g<<1)>>1]|0;u=d&65535;v=(t&65535)-(e[q+(u<<2)>>1]|0)|0;b[r>>1]=o;b[(c[p>>2]|0)+(u<<2)>>1]=t;if((s|0)<0){and(a,g,f,1)}if((v|0)>0){ane(a,g,d,1)}if((s|0)>0){anf(a,g,f,h,1)}if((v|0)<0){ang(a,g,d,h,1)}g=g+1|0}i=j;return}function vd(a){a=a|0;ct[c[(c[a>>2]|0)+52>>2]&2047](a|0);return}function ve(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return c5[c[(c[a>>2]|0)+8>>2]&63](a|0,b,d,e,f,g,h,i,j)|0}function vf(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function vg(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a|0,b);return}function vh(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function vi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function vj(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a|0,b,d);return}function vk(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,d);return}function vl(a){a=a|0;if((a|0)==0){return}aDB(a);return}function vm(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+68>>2]&2047](a,b);return}function vn(){var a=0,b=0,d=0;while(1){a=aDx(8)|0;if((a|0)!=0){b=2391;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==2391){c[a>>2]=0;c[a+4>>2]=0;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function vo(a,b){a=a|0;b=b|0;var d=0,e=0;while(1){d=aDx(8)|0;if((d|0)!=0){e=2403;break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){break}dC[b&63]()}if((e|0)==2403){c[d>>2]=a;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function vp(a){a=a|0;return a+100|0}function vq(a){a=a|0;return c[a+24>>2]|0}function vr(a){a=a|0;return a|0}function vs(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function vt(b){b=b|0;return(a[b+242|0]&1)!=0|0}function vu(b,c){b=b|0;c=c|0;a[b+242|0]=c&1;return}function vv(a){a=a|0;return a+4|0}function vw(a,b){a=a|0;b=b|0;c[a+88>>2]=b;c[a+96>>2]=0;return}function vx(a,b,d){a=a|0;b=b|0;d=d|0;c[a+88>>2]=b;c[a+96>>2]=d;return}function vy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if(e){c[a+92>>2]=b}else{c[a+88>>2]=b}c[a+96>>2]=d;return}function vz(b){b=b|0;return(a[b+84|0]&1)!=0|0}function vA(a){a=a|0;return c[a+8>>2]|0}function vB(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function vC(a){a=a|0;return c[a+96>>2]|0}function vD(a){a=a|0;return c[a+76>>2]|0}function vE(b,c){b=b|0;c=c|0;a[b+84|0]=c&1;return}function vF(a){a=a|0;return c[a+176>>2]|0}function vG(a){a=a|0;return a+28|0}function vH(a){a=a|0;return c[a+28>>2]|0}function vI(a){a=a|0;return c[a+24>>2]|0}function vJ(b){b=b|0;return(a[b+518|0]&1)!=0|0}function vK(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function vL(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function vM(a){a=a|0;return a+292|0}function vN(a){a=a|0;return a+356|0}function vO(a){a=a|0;return+(+g[a+440>>2])}function vP(a){a=a|0;return+(+g[a+436>>2])}function vQ(a){a=a|0;return c[a+4>>2]|0}function vR(a,b){a=a|0;b=+b;g[a+432>>2]=b;return}function vS(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function vT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function vU(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function vV(a){a=a|0;ct[c[(c[a>>2]|0)+164>>2]&2047](a);return}function vW(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a,b);return}function vX(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+80>>2]&2047](a,b);return}function vY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+84>>2]&1023](a,b,d,e);return}function vZ(a){a=a|0;ct[c[(c[a>>2]|0)+116>>2]&2047](a);return}function v_(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+124>>2]&2047](a,b);return}function v$(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+168>>2]&2047](a,b);return}function v0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a|0,b,d,e);return}function v1(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a,b);return}function v2(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function v3(a){a=a|0;return cA[c[(c[a>>2]|0)+100>>2]&4095](a)|0}function v4(a,b){a=a|0;b=b|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,2,-3);return}function v5(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,-3);return}function v6(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function v7(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+88>>2]&2047](a,b);return}function v8(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=e+32|0;j=c[b+192>>2]|0;dI[c[(c[j>>2]|0)+8>>2]&1023](j,b+4|0,f,g);c[h>>2]=21168;c[h+4>>2]=b;c[h+8>>2]=a;c[h+12>>2]=d;d=c[a+76>>2]|0;dI[c[(c[d>>2]|0)+28>>2]&1023](d,f,g,h|0);i=e;return}function v9(a){a=a|0;ct[c[(c[a>>2]|0)+40>>2]&2047](a|0);return}function wa(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function wb(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function wc(a,b){a=a|0;b=b|0;aoh(a,b);return}function wd(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function we(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;atO(a|0,b,c,d,e,0.0);return}function wf(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;atO(a|0,b,c,d,e,f);return}function wg(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+52>>2]&511](a,b,0);return}function wh(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+52>>2]&511](a,b,d);return}function wi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+168|0;g=f|0;h=a+24|0;j=c[h>>2]|0;k=dE[c[(c[j>>2]|0)+8>>2]&127](j,b,d,0)|0;if((k|0)==0){i=f;return}c[g+4>>2]=0;c[g+136>>2]=b;c[g+140>>2]=d;j=g+8|0;l=b+4|0;aDD(g+144|0,-1|0,16);c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+24|0;j=b+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+40|0;l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+56|0;j=b+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+72|0;l=d+4|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+88|0;j=d+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+104|0;l=d+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+120|0;j=d+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[g>>2]=21728;c[g+160>>2]=e;co[c[(c[k>>2]|0)+8>>2]&255](k,b,d,a+28|0,g|0);ct[c[c[k>>2]>>2]&2047](k);g=c[h>>2]|0;cv[c[(c[g>>2]|0)+60>>2]&2047](g,k);i=f;return}function wj(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43816]|0)==0){if((b1(43816)|0)==0){break}}}while(0);cv[c[(c[b>>2]|0)+72>>2]&2047](e,b);b=e;c[9510]=c[b>>2];c[9511]=c[b+4>>2];c[9512]=c[b+8>>2];c[9513]=c[b+12>>2];i=d;return 38040}function wk(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;atG(a,b,c,d,e,f);return}function wl(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function wm(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function wn(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+132>>2]&2047](a,b);return}function wo(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+104>>2]&511](a,b)|0}function wp(a){a=a|0;return cA[c[(c[a>>2]|0)+96>>2]&4095](a)|0}function wq(a,b){a=a|0;b=+b;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,1,.01666666753590107)|0}function wr(a,b,d){a=a|0;b=+b;d=d|0;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,.01666666753590107)|0}function ws(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,e)|0}function wt(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+128>>2]&2047](a,b);return}function wu(a){a=a|0;return cA[c[(c[a>>2]|0)+112>>2]&4095](a)|0}function wv(a,b){a=a|0;b=b|0;atC(a|0,b);return}function ww(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+172>>2]&1023](a,b);return}function wx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+64|0;e=d|0;f=b+472|0;if((c[f>>2]|0)==0){i=d;return}if((c[b+204>>2]&3|0)!=0){i=d;return}anY(b+68|0,+g[b+132>>2],+g[b+136>>2],+g[b+140>>2],b+148|0,+g[a+236>>2]*+g[b+240>>2],e);b=c[f>>2]|0;cv[c[(c[b>>2]|0)+12>>2]&2047](b,e);i=d;return}function wy(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+120>>2]&2047](a,b);return}function wz(a){a=a|0;var b=0;b=c[a+76>>2]|0;return cA[c[(c[b>>2]|0)+36>>2]&4095](b)|0}function wA(a){a=a|0;ct[c[(c[a>>2]|0)+76>>2]&2047](a);return}function wB(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function wC(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+92>>2]&2047](a,b);return}function wD(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;atI(a,b,c,d,e,f,g,h);return}function wE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function wF(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function wG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;anP(a,b,c,d,e);return}function wH(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function wI(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function wJ(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function wK(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function wL(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function wM(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function wN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;while(1){f=aDx(268)|0;if((f|0)!=0){g=2523;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){g=2520;break}dC[h&63]()}if((g|0)==2523){h=f;aob(h,a,b,d,e);return h|0}else if((g|0)==2520){g=cd(4)|0;c[g>>2]=19096;bF(g|0,34368,676);return 0}return 0}function wO(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;while(1){e=aDx(600)|0;if((e|0)!=0){f=2537;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){f=2534;break}dC[h&63]()}if((f|0)==2534){h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}else if((f|0)==2537){aq1(e,5,b);c[e>>2]=22328;b=e+292|0;f=d;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=e+308|0;h=d+16|0;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];h=e+324|0;i=d+32|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];i=e+340|0;j=d+48|0;c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];j=e+356|0;a[e+519|0]=0;c[j>>2]=c[b>>2];c[j+4>>2]=c[b+4>>2];c[j+8>>2]=c[b+8>>2];c[j+12>>2]=c[b+12>>2];b=e+372|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=e+388|0;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];h=e+404|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];a[e+516|0]=0;a[e+517|0]=0;a[e+518|0]=0;a[e+544|0]=0;g[e+564>>2]=-1.0;g[e+436>>2]=999999984306749400.0;g[e+440>>2]=999999984306749400.0;g[e+444>>2]=999999984306749400.0;g[e+420>>2]=1.0;g[e+424>>2]=.30000001192092896;g[e+428>>2]=1.0;g[e+432>>2]=.009999999776482582;g[e+448>>2]=.05000000074505806;c[e+584>>2]=0;g[e+588>>2]=0.0;g[e+592>>2]=.699999988079071;g[e+596>>2]=0.0;return e|0}return 0}function wP(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function wQ(b){b=b|0;return(a[b+20|0]&1)!=0|0}function wR(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function wS(a){a=a|0;return c[a+4>>2]|0}function wT(a){a=a|0;return+(+g[a+504>>2])}function wU(b,c){b=b|0;c=+c;g[b+564>>2]=c;a[b+545|0]=1;return}function wV(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function wW(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function wX(b){b=b|0;return(a[b+21|0]&1)!=0|0}function wY(a){a=a|0;return c[a+4>>2]|0}function wZ(b){b=b|0;return a[b+517|0]&1|0}function w_(a){a=a|0;return c[a+12>>2]|0}function w$(b,c){b=b|0;c=c|0;a[b+544|0]=c&1;return}function w0(a){a=a|0;return a+356|0}function w1(a,b){a=a|0;b=b|0;c[b>>2]=6;c[b+4>>2]=0;return}function w2(a){a=a|0;return c[a+12>>2]|0}function w3(a){a=a|0;return+(+g[a+36>>2])}function w4(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function w5(a){a=a|0;return+(+g[a+448>>2])}function w6(b){b=b|0;return a[b+517|0]&1|0}function w7(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function w8(a){a=a|0;return+(+g[a+32>>2])}function w9(b,c){b=b|0;c=c|0;a[b+516|0]=c&1;return}function xa(a,b,c){a=a|0;b=b|0;c=+c;if((b|0)==3){g[a+444>>2]=c;return}else if((b|0)==5){g[a+436>>2]=c;return}else if((b|0)==4){g[a+440>>2]=c;return}else{return}}function xb(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a+436>>2]=b;g[a+440>>2]=c;g[a+444>>2]=d;g[a+420>>2]=1.0;g[a+424>>2]=.30000001192092896;g[a+428>>2]=1.0;return}function xc(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a+436>>2]=b;g[a+440>>2]=c;g[a+444>>2]=d;g[a+420>>2]=e;g[a+424>>2]=.30000001192092896;g[a+428>>2]=1.0;return}function xd(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;g[a+436>>2]=b;g[a+440>>2]=c;g[a+444>>2]=d;g[a+420>>2]=e;g[a+424>>2]=f;g[a+428>>2]=1.0;return}function xe(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;h=+h;g[a+436>>2]=b;g[a+440>>2]=c;g[a+444>>2]=d;g[a+420>>2]=e;g[a+424>>2]=f;g[a+428>>2]=h;return}function xf(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0;d=i;i=i+208|0;e=d|0;f=d+80|0;h=d+160|0;j=d+176|0;k=d+192|0;l=c[a+24>>2]|0;m=+g[l+4>>2];n=+g[l+8>>2];o=+g[l+12>>2];p=+g[l+20>>2];q=+g[l+24>>2];r=+g[l+28>>2];s=+g[l+36>>2];t=+g[l+40>>2];u=+g[l+44>>2];v=+g[l+52>>2];w=+g[l+56>>2];x=+g[l+60>>2];l=c[a+28>>2]|0;y=+g[l+4>>2];z=+g[l+8>>2];A=+g[l+12>>2];B=+g[l+20>>2];C=+g[l+24>>2];D=+g[l+28>>2];E=+g[l+36>>2];F=+g[l+40>>2];G=+g[l+44>>2];H=+g[l+52>>2];I=+g[l+56>>2];J=+g[l+60>>2];K=-0.0-H;L=-0.0-I;M=-0.0-J;g[e>>2]=m*y+p*B+s*E;g[e+4>>2]=n*y+q*B+t*E;g[e+8>>2]=o*y+r*B+u*E;g[e+12>>2]=0.0;g[e+16>>2]=m*z+p*C+s*F;g[e+20>>2]=n*z+q*C+t*F;g[e+24>>2]=o*z+r*C+u*F;g[e+28>>2]=0.0;g[e+32>>2]=m*A+p*D+s*G;g[e+36>>2]=n*A+q*D+t*G;g[e+40>>2]=o*A+r*D+u*G;g[e+44>>2]=0.0;g[e+48>>2]=v*y+w*B+x*E+(y*K+B*L+E*M);g[e+52>>2]=v*z+w*C+x*F+(z*K+C*L+F*M);g[e+56>>2]=v*A+w*D+x*G+(A*K+D*L+G*M);g[e+60>>2]=0.0;ec(e|0,d+64|0);e=a+356|0;M=+g[e>>2];L=+g[a+372>>2];K=+g[a+388>>2];N=y*M+z*L+A*K;O=+g[a+360>>2];P=+g[a+376>>2];Q=+g[a+392>>2];R=y*O+z*P+A*Q;S=+g[a+364>>2];T=+g[a+380>>2];U=+g[a+396>>2];V=y*S+z*T+A*U;W=B*M+C*L+D*K;X=B*O+C*P+D*Q;Y=B*S+C*T+D*U;Z=E*M+F*L+G*K;K=E*O+F*P+G*Q;Q=E*S+F*T+G*U;U=+g[a+404>>2];T=+g[a+408>>2];S=+g[a+412>>2];P=-0.0-(H+(y*U+z*T+A*S));A=-0.0-(I+(B*U+C*T+D*S));D=-0.0-(J+(E*U+F*T+G*S));l=a+292|0;S=+g[l>>2];G=+g[a+308>>2];T=+g[a+324>>2];F=m*S+n*G+o*T;U=+g[a+296>>2];E=+g[a+312>>2];J=+g[a+328>>2];C=m*U+n*E+o*J;B=+g[a+300>>2];I=+g[a+316>>2];z=+g[a+332>>2];y=m*B+n*I+o*z;H=p*S+q*G+r*T;O=p*U+q*E+r*J;L=p*B+q*I+r*z;M=s*S+t*G+u*T;T=s*U+t*E+u*J;J=s*B+t*I+u*z;z=+g[a+340>>2];I=+g[a+344>>2];B=+g[a+348>>2];E=v+(m*z+n*I+o*B);o=w+(p*z+q*I+r*B);r=x+(s*z+t*I+u*B);g[f>>2]=Z*M+(N*F+W*H);g[f+4>>2]=Z*T+(N*C+W*O);g[f+8>>2]=Z*J+(N*y+W*L);g[f+12>>2]=0.0;g[f+16>>2]=K*M+(R*F+X*H);g[f+20>>2]=K*T+(R*C+X*O);g[f+24>>2]=K*J+(R*y+X*L);g[f+28>>2]=0.0;g[f+32>>2]=Q*M+(V*F+Y*H);g[f+36>>2]=Q*T+(V*C+Y*O);g[f+40>>2]=Q*J+(V*y+Y*L);g[f+44>>2]=0.0;g[f+48>>2]=Z*D+(N*P+W*A)+(Z*r+(N*E+W*o));g[f+52>>2]=K*D+(R*P+X*A)+(K*r+(R*E+X*o));g[f+56>>2]=Q*D+(V*P+Y*A)+(Q*r+(V*E+Y*o));g[f+60>>2]=0.0;ec(f|0,d+144|0);ec(e|0,j);o=-0.0- +g[j>>2];Y=-0.0- +g[j+4>>2];E=-0.0- +g[j+8>>2];V=+g[j+12>>2];r=+g[b>>2];Q=+g[b+12>>2];A=+g[b+8>>2];P=+g[b+4>>2];D=V*r+Q*o+A*Y-P*E;X=r*E+(Q*Y+V*P)-A*o;R=Q*E+V*A+P*o-r*Y;K=V*Q-r*o-P*Y-A*E;ec(l|0,k);E=+g[k>>2];A=+g[k+12>>2];Y=+g[k+8>>2];P=+g[k+4>>2];g[h>>2]=E*K+D*A+X*Y-R*P;g[h+4>>2]=E*R+(A*X+K*P)-D*Y;g[h+8>>2]=A*R+K*Y+D*P-E*X;g[h+12>>2]=K*A-E*D-X*P-R*Y;an_(a,h);i=d;return}function xg(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function xh(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function xi(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function xj(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function xk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;while(1){h=aDx(600)|0;if((h|0)!=0){i=2596;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==2596){c[h+4>>2]=5;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3.4028234663852886e+38;a[h+20|0]=1;a[h+21|0]=0;c[h+24>>2]=b;c[h+28>>2]=d;g[h+32>>2]=0.0;g[h+36>>2]=.30000001192092896;c[h>>2]=22328;d=h+292|0;b=e;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=h+308|0;d=e+16|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];d=h+324|0;b=e+32|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=h+340|0;d=e+48|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];d=h+356|0;b=f;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=h+372|0;d=f+16|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];d=h+388|0;b=f+32|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=h+404|0;d=f+48|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];a[h+544|0]=0;d=h+516|0;w=0;a[d]=w&255;w=w>>8;a[d+1|0]=w&255;w=w>>8;a[d+2|0]=w&255;w=w>>8;a[d+3|0]=w&255;g[h+564>>2]=-1.0;g[h+436>>2]=999999984306749400.0;g[h+440>>2]=999999984306749400.0;g[h+444>>2]=999999984306749400.0;g[h+420>>2]=1.0;g[h+424>>2]=.30000001192092896;g[h+428>>2]=1.0;g[h+432>>2]=.009999999776482582;g[h+448>>2]=.05000000074505806;c[h+584>>2]=0;g[h+588>>2]=0.0;g[h+592>>2]=.699999988079071;g[h+596>>2]=0.0;return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function xl(a,b){a=a|0;b=+b;return}function xm(a){a=a|0;return+(+g[a+32>>2])}function xn(a){a=a|0;return+(+g[a+492>>2])}function xo(b,c){b=b|0;c=+c;g[b+564>>2]=c;a[b+545|0]=0;return}function xp(a){a=a|0;return c[a+12>>2]|0}function xq(a,b){a=a|0;b=+b;g[a+448>>2]=b;return}function xr(a){a=a|0;return+(+g[a+16>>2])}function xs(a){a=a|0;return c[a+8>>2]|0}function xt(a){a=a|0;return+(+g[a+444>>2])}function xu(a){a=a|0;return a+292|0}function xv(a){a=a|0;return c[a+28>>2]|0}function xw(a){a=a|0;return c[a+24>>2]|0}function xx(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function xy(a){a=a|0;return+(+g[a+672>>2])}function xz(a){a=a|0;return a+544|0}function xA(a){a=a|0;return a+608|0}function xB(a,b){a=a|0;b=+b;g[a+676>>2]=b;return}function xC(a){a=a|0;return c[a+4>>2]|0}function xD(b,c,d,e){b=b|0;c=c|0;d=+d;e=+e;a[b+729|0]=c&1;g[b+672>>2]=d;g[b+676>>2]=e;return}function xE(a){a=a|0;return+(+g[a+704>>2])}function xF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function xG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;anR(a,b,c,d,e,f);return}function xH(a,b){a=a|0;b=b|0;an_(a,b);return}function xI(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function xJ(b,d,e){b=b|0;d=+d;e=+e;var f=0,g=0;f=i;i=i+16|0;g=f|0;do{if((a[43744]|0)==0){if((b1(43744)|0)==0){break}}}while(0);anZ(g,b,d,e);b=g;c[9506]=c[b>>2];c[9507]=c[b+4>>2];c[9508]=c[b+8>>2];c[9509]=c[b+12>>2];i=f;return 38024}function xK(b){b=b|0;var d=0,e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0.0,F=0,G=0,H=0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0;d=b+496|0;g[d>>2]=0.0;g[b+492>>2]=0.0;e=b+517|0;a[e]=0;f=b+518|0;a[f]=0;h=c[b+24>>2]|0;i=+g[b+292>>2];j=+g[b+308>>2];k=+g[b+324>>2];l=+g[h+4>>2];m=+g[h+8>>2];n=+g[h+12>>2];o=i*l+j*m+k*n;p=+g[h+20>>2];q=+g[h+24>>2];r=+g[h+28>>2];s=i*p+j*q+k*r;t=+g[h+36>>2];u=+g[h+40>>2];v=+g[h+44>>2];w=i*t+j*u+k*v;h=c[b+28>>2]|0;k=+g[b+356>>2];j=+g[b+372>>2];i=+g[b+388>>2];x=h+4|0;y=h+8|0;z=h+12|0;A=k*+g[x>>2]+j*+g[y>>2]+i*+g[z>>2];B=h+20|0;C=h+24|0;D=h+28|0;E=k*+g[B>>2]+j*+g[C>>2]+i*+g[D>>2];F=h+36|0;G=h+40|0;H=h+44|0;I=k*+g[F>>2]+j*+g[G>>2]+i*+g[H>>2];i=+g[b+436>>2];if(i<.05000000074505806){J=0.0;K=0.0;L=0.0;M=0.0}else{j=+g[b+296>>2];k=+g[b+312>>2];N=+g[b+328>>2];O=l*j+m*k+n*N;R=p*j+q*k+r*N;S=t*j+u*k+v*N;N=o*A+s*E+w*I;k=I*S+(A*O+E*R);j=+P(+k);if(N<0.0){T=2.356194496154785-(N+j)/(j-N)*.7853981852531433}else{T=.7853981852531433-(N-j)/(N+j)*.7853981852531433}if(k<0.0){U=-0.0-T}else{U=T}T=(N*N+k*k)*10.0*10.0;J=U*(T/(T+1.0));K=O;L=R;M=S}S=+g[b+440>>2];if(S<.05000000074505806){V=0.0;W=0.0;X=0.0;Y=0.0}else{R=+g[b+300>>2];O=+g[b+316>>2];T=+g[b+332>>2];U=R*l+O*m+T*n;n=R*p+O*q+T*r;r=R*t+O*u+T*v;v=o*A+s*E+w*I;T=A*U+E*n+I*r;u=+P(+T);if(v<0.0){Z=2.356194496154785-(v+u)/(u-v)*.7853981852531433}else{Z=.7853981852531433-(v-u)/(v+u)*.7853981852531433}if(T<0.0){_=-0.0-Z}else{_=Z}Z=(v*v+T*T)*10.0*10.0;V=_*(Z/(Z+1.0));W=U;X=n;Y=r}r=1.0/(i*i)*+P(+(J*J));J=r+1.0/(S*S)*+P(+(V*V));if(J>1.0){g[d>>2]=J+-1.0;a[f]=1;J=I*M+(E*L+A*K);V=I*Y+(E*X+A*W);S=K*J+W*V;r=L*J+X*V;i=M*J+Y*V;V=E*i-I*r;J=I*S-A*i;i=A*r-E*S;g[b+464>>2]=0.0;S=1.0/+Q(+(V*V+J*J+i*i));r=o*A+s*E+w*I>=0.0?1.0:-1.0;g[b+452>>2]=r*V*S;g[b+456>>2]=r*J*S;g[b+460>>2]=r*i*S}S=+g[b+444>>2];if(S<0.0){return}i=+g[b+360>>2];r=+g[b+376>>2];J=+g[b+392>>2];V=i*+g[x>>2]+r*+g[y>>2]+J*+g[z>>2];n=i*+g[B>>2]+r*+g[C>>2]+J*+g[D>>2];U=i*+g[F>>2]+r*+g[G>>2]+J*+g[H>>2];J=o*A+s*E+w*I;do{if(J<-.9999998807907104){if(+P(+I)>.7071067690849304){r=1.0/+Q(+(E*E+I*I));$=0.0;aa=r*(-0.0-I);ab=E*r;ac=0.0;break}else{r=1.0/+Q(+(A*A+E*E));$=r*(-0.0-E);aa=A*r;ab=0.0;ac=0.0;break}}else{r=+Q(+((J+1.0)*2.0));i=1.0/r;$=(w*E-s*I)*i;aa=(o*I-w*A)*i;ab=(s*A-o*E)*i;ac=r*.5}}while(0);J=V*ac+U*aa-n*ab;r=n*ac+V*ab-U*$;i=U*ac+n*$-V*aa;Z=-0.0-$;$=V*Z-n*aa-U*ab;U=-0.0-aa;aa=-0.0-ab;ab=r*aa+(ac*J+$*Z)-i*U;n=i*Z+(ac*r+$*U)-J*aa;V=J*U+(ac*i+$*aa)-r*Z;Z=Y*V+(W*ab+X*n);X=M*V+(K*ab+L*n);n=+P(+Z);if(X<0.0){ad=2.356194496154785-(n+X)/(n-X)*.7853981852531433}else{ad=.7853981852531433-(X-n)/(n+X)*.7853981852531433}if(Z<0.0){ae=-0.0-ad}else{ae=ad}g[b+504>>2]=ae;ad=S>.05000000074505806?1.0:0.0;if(ae<=ad*(-0.0-S)){g[b+500>>2]=-0.0-(ae+S);a[e]=1;Z=(o+A)*.5;X=(s+E)*.5;n=(w+I)*.5;g[b+480>>2]=0.0;L=1.0/+Q(+(Z*Z+X*X+n*n));g[b+468>>2]=Z*L*-1.0;g[b+472>>2]=X*L*-1.0;g[b+476>>2]=n*L*-1.0;return}if(ae<=S*ad){return}g[b+500>>2]=ae-S;a[e]=1;S=(o+A)*.5;A=(s+E)*.5;E=(w+I)*.5;g[b+480>>2]=0.0;I=1.0/+Q(+(S*S+A*A+E*E));g[b+468>>2]=S*I;g[b+472>>2]=A*I;g[b+476>>2]=E*I;return}function xL(b,c,d,e,f,h){b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0.0,j=0,k=0,l=0,m=0,n=0.0,o=0.0;i=+apy(b,d,e);g[b+720>>2]=i;j=b+700|0;g[j>>2]=0.0;k=b+704|0;g[k>>2]=0.0;l=b+708|0;a[l]=0;m=b+684|0;do{if(+g[m>>2]>=0.0){n=+ck(+(i- +g[b+680>>2]),6.2831854820251465);do{if(n<-3.1415927410125732){o=n+6.2831854820251465}else{if(n<=3.1415927410125732){o=n;break}o=n-6.2831854820251465}}while(0);n=+g[m>>2];if(o<-0.0-n){a[l]=1;g[j>>2]=-0.0-(o+n);g[k>>2]=1.0;break}if(o<=n){break}a[l]=1;g[j>>2]=n-o;g[k>>2]=-1.0}}while(0);apx(b,c,d,e,f,h);return}function xM(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function xN(a){a=a|0;return+(+apy(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0))}function xO(a,b,c){a=a|0;b=b|0;c=c|0;return+(+apy(a,b,c))}function xP(b,c,d){b=b|0;c=c|0;d=d|0;var e=0.0,f=0,h=0,i=0.0,j=0.0;e=+apy(b,c,d);g[b+720>>2]=e;d=b+700|0;g[d>>2]=0.0;c=b+704|0;g[c>>2]=0.0;f=b+708|0;a[f]=0;h=b+684|0;if(+g[h>>2]<0.0){return}i=+ck(+(e- +g[b+680>>2]),6.2831854820251465);do{if(i<-3.1415927410125732){j=i+6.2831854820251465}else{if(i<=3.1415927410125732){j=i;break}j=i-6.2831854820251465}}while(0);i=+g[h>>2];if(j<-0.0-i){a[f]=1;g[d>>2]=-0.0-(j+i);g[c>>2]=1.0;return}if(j<=i){return}a[f]=1;g[d>>2]=i-j;g[c>>2]=-1.0;return}function xQ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function xR(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;apx(a,b,c,d,e,f);return}function xS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function xT(a){a=a|0;var b=0.0,c=0.0;b=+ck(+(+g[a+680>>2]+ +g[a+684>>2]),6.2831854820251465);if(b<-3.1415927410125732){c=b+6.2831854820251465;return+c}if(b<=3.1415927410125732){c=b;return+c}c=b-6.2831854820251465;return+c}function xU(a,b){a=a|0;b=+b;return}function xV(b){b=b|0;return(a[b+20|0]&1)!=0|0}function xW(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function xX(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function xY(a){a=a|0;return c[a+4>>2]|0}function xZ(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function x_(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function x$(a){a=a|0;return+(+g[a+676>>2])}function x0(b,c){b=b|0;c=c|0;a[b+731|0]=c&1;return}function x1(b){b=b|0;return(a[b+729|0]&1)!=0|0}function x2(b){b=b|0;return(a[b+21|0]&1)!=0|0}function x3(a){a=a|0;return c[a+4>>2]|0}function x4(a){a=a|0;return c[a+12>>2]|0}function x5(b,c){b=b|0;c=c|0;a[b+729|0]=c&1;return}function x6(a){a=a|0;return a+608|0}function x7(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+730|0]&1)==0){c[e>>2]=6;c[d+4>>2]=0;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function x8(a){a=a|0;return c[a+12>>2]|0}function x9(a){a=a|0;return+(+g[a+36>>2])}function ya(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function yb(b){b=b|0;return(a[b+731|0]&1)!=0|0}function yc(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function yd(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function ye(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function yf(a){a=a|0;return+(+g[a+32>>2])}function yg(b,c){b=b|0;c=c|0;a[b+728|0]=c&1;return}function yh(b){b=b|0;return a[b+708|0]&1|0}function yi(a){a=a|0;return c[a+12>>2]|0}function yj(a){a=a|0;return+(+g[a+16>>2])}function yk(a){a=a|0;return c[a+8>>2]|0}function yl(b){b=b|0;return(a[b+728|0]&1)!=0|0}function ym(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function yn(a){a=a|0;var b=0.0,c=0.0;b=+ck(+(+g[a+680>>2]- +g[a+684>>2]),6.2831854820251465);if(b<-3.1415927410125732){c=b+6.2831854820251465;return+c}if(b<=3.1415927410125732){c=b;return+c}c=b-6.2831854820251465;return+c}function yo(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function yp(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function yq(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;aps(a,b,c,d,e,f);return}function yr(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function ys(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function yt(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function yu(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function yv(a,b,c){a=a|0;b=+b;c=+c;var d=0.0,e=0.0;d=(c-b)*.5;g[a+684>>2]=d;c=+ck(+(d+b),6.2831854820251465);do{if(c<-3.1415927410125732){e=c+6.2831854820251465}else{if(c<=3.1415927410125732){e=c;break}e=c-6.2831854820251465}}while(0);g[a+680>>2]=e;g[a+688>>2]=.8999999761581421;g[a+692>>2]=.30000001192092896;g[a+696>>2]=1.0;return}function yw(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0;e=(c-b)*.5;g[a+684>>2]=e;c=+ck(+(e+b),6.2831854820251465);do{if(c<-3.1415927410125732){f=c+6.2831854820251465}else{if(c<=3.1415927410125732){f=c;break}f=c-6.2831854820251465}}while(0);g[a+680>>2]=f;g[a+688>>2]=d;g[a+692>>2]=.30000001192092896;g[a+696>>2]=1.0;return}function yx(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;var f=0.0,h=0.0;f=(c-b)*.5;g[a+684>>2]=f;c=+ck(+(f+b),6.2831854820251465);do{if(c<-3.1415927410125732){h=c+6.2831854820251465}else{if(c<=3.1415927410125732){h=c;break}h=c-6.2831854820251465}}while(0);g[a+680>>2]=h;g[a+688>>2]=d;g[a+692>>2]=e;g[a+696>>2]=1.0;return}function yy(a,b,c,d,e,f){a=a|0;b=+b;c=+c;d=+d;e=+e;f=+f;var h=0.0,i=0.0;h=(c-b)*.5;g[a+684>>2]=h;c=+ck(+(h+b),6.2831854820251465);do{if(c<-3.1415927410125732){i=c+6.2831854820251465}else{if(c<=3.1415927410125732){i=c;break}i=c-6.2831854820251465}}while(0);g[a+680>>2]=i;g[a+688>>2]=d;g[a+692>>2]=e;g[a+696>>2]=f;return}function yz(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function yA(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function yB(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0.0,R=0.0,S=0.0,T=0.0,U=0;e=i;i=i+40|0;f=e|0;h=e+8|0;j=e+24|0;ec(a+608|0,h);k=-0.0- +g[h>>2];l=-0.0- +g[h+4>>2];m=-0.0- +g[h+8>>2];n=+g[h+12>>2];o=+g[b>>2];q=+g[b+12>>2];r=+g[b+8>>2];s=+g[b+4>>2];t=n*o+q*k+r*l-s*m;u=o*m+(q*l+n*s)-r*k;v=q*m+n*r+s*k-o*l;w=n*q-o*k-s*l-r*m;ec(a+544|0,j);m=+g[j>>2];r=+g[j+12>>2];l=+g[j+8>>2];s=+g[j+4>>2];k=m*w+t*r+u*l-v*s;o=m*v+(r*u+w*s)-t*l;q=r*v+w*l+t*s-m*u;n=w*r-m*t-u*s-v*l;l=1.0/+Q(+(n*n+(q*q+(k*k+o*o))));v=k*l;k=l*o;o=l*q;q=l*n;n=q*0.0;l=o*0.0;s=n+k-l;u=l+n-v;n=k*0.0;l=q+v*0.0-n;t=-0.0-v;m=v*-0.0-n-o;n=-0.0-k;r=-0.0-o;w=u*r+(q*s+m*t)-l*n;x=l*t+(q*u+m*n)-s*r;y=s*n+(q*l+m*r)-u*t;t=1.0/+Q(+(y*y+(w*w+x*x)));u=t*w;w=t*x;x=t*y;y=u*0.0;t=w*0.0;r=x+(t+y);do{if(r<-.9999998807907104){if(+P(1.0)>.7071067690849304){z=0.0;A=-1.0;B=0.0;C=0.0;break}z=p;A=p;B=0.0;C=0.0}else{m=x*0.0;l=+Q(+((r+1.0)*2.0));n=1.0/l;z=(m-w)*n;A=(u-m)*n;B=(t-y)*n;C=l*.5}}while(0);y=-0.0-z;z=-0.0-A;A=-0.0-B;B=o*z+(v*C+q*y)-k*A;t=v*A+(k*C+q*z)-o*y;u=o*C+q*A+k*y-v*z;w=q*C-v*y-k*z-o*A;A=1.0/+Q(+(w*w+(u*u+(t*t+B*B))));B=A*u;u=A*w;w=u<-1.0?-1.0:u;A=+V(+(w>1.0?1.0:w))*2.0;if(A>3.1415927410125732){w=u>1.0?-1.0:-0.0-u;D=+V(+(w>1.0?1.0:w))*2.0;E=-0.0-B}else{D=A;E=B}if(E>=0.0){F=D;G=f;g[f>>2]=F;H=a+680|0;aq4(H,f);I=a+24|0;J=c[I>>2]|0;K=J+4|0;L=a+28|0;M=c[L>>2]|0;N=M+4|0;O=+apy(a,K,N);R=+g[f>>2];S=R-O;T=S/d;U=a+672|0;g[U>>2]=T;i=e;return}F=-0.0-D;G=f;g[f>>2]=F;H=a+680|0;aq4(H,f);I=a+24|0;J=c[I>>2]|0;K=J+4|0;L=a+28|0;M=c[L>>2]|0;N=M+4|0;O=+apy(a,K,N);R=+g[f>>2];S=R-O;T=S/d;U=a+672|0;g[U>>2]=T;i=e;return}function yC(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;while(1){e=aDx(756)|0;if((e|0)!=0){f=2798;break}g=(C=c[10744]|0,c[10744]=C+0,C);if((g|0)==0){f=2795;break}dC[g&63]()}if((f|0)==2798){g=e;apo(g,a,b,d,0);return g|0}else if((f|0)==2795){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}return 0}function yD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;while(1){f=aDx(756)|0;if((f|0)!=0){g=2812;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){g=2809;break}dC[h&63]()}if((g|0)==2812){h=f;apo(h,a,b,d,e);return h|0}else if((g|0)==2809){g=cd(4)|0;c[g>>2]=19096;bF(g|0,34368,676);return 0}return 0}function yE(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;while(1){h=aDx(756)|0;if((h|0)!=0){i=2826;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==2826){i=h;apn(i,a,b,d,e,f,g,0);return i|0}i=cd(4)|0;c[i>>2]=19096;bF(i|0,34368,676);return 0}function yF(a,b,d,e,f,g,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;while(1){i=aDx(756)|0;if((i|0)!=0){j=2838;break}k=(C=c[10744]|0,c[10744]=C+0,C);if((k|0)==0){break}dC[k&63]()}if((j|0)==2838){j=i;apn(j,a,b,d,e,f,g,h);return j|0}j=cd(4)|0;c[j>>2]=19096;bF(j|0,34368,676);return 0}function yG(a){a=a|0;return+(+g[a+32>>2])}function yH(a){a=a|0;return a+544|0}function yI(a,b){a=a|0;b=+b;g[a>>2]=b;return}function yJ(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function yK(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function yL(b){b=b|0;var d=0;do{if((c[b+56>>2]|0)==0){if((a[b+44|0]&1)==0){d=0}else{break}return d|0}}while(0);d=1;return d|0}function yM(a,b){a=a|0;b=+b;g[a+52>>2]=b;return}function yN(b,d,e,f,h,i){b=b|0;d=+d;e=e|0;f=+f;h=h|0;i=i|0;var j=0.0,k=0.0,l=0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0;do{if((c[b+56>>2]|0)==0){if((a[b+44|0]&1)==0){j=0.0;return+j}else{k=+g[b+8>>2];l=b+12|0;break}}else{k=+g[b+48>>2]*(-0.0- +g[b+32>>2])/d;l=b+16|0}}while(0);m=+g[l>>2]*d;l=h+520|0;n=h+524|0;o=h+528|0;p=i+520|0;q=i+524|0;r=i+528|0;s=e|0;t=e+4|0;u=e+8|0;d=+g[b+24>>2]*(k- +g[b+20>>2]*((+g[h+320>>2]+ +g[l>>2]-(+g[i+320>>2]+ +g[p>>2]))*+g[s>>2]+(+g[h+324>>2]+ +g[n>>2]-(+g[i+324>>2]+ +g[q>>2]))*+g[t>>2]+(+g[h+328>>2]+ +g[o>>2]-(+g[i+328>>2]+ +g[r>>2]))*+g[u>>2]));if(d<1.1920928955078125e-7&d>-1.1920928955078125e-7){j=0.0;return+j}k=d*(+g[b+40>>2]+1.0)*f;if(k>0.0){v=k>m?m:k}else{f=-0.0-m;v=k<f?f:k}e=b+60|0;k=+g[e>>2];f=v+k;if(f>999999984306749400.0){w=0.0}else{w=f<-999999984306749400.0?0.0:f}g[e>>2]=w;f=w-k;k=+g[s>>2];w=+g[t>>2];v=+g[u>>2];if(+g[h+336>>2]!=0.0){m=w*+g[h+292>>2]+k*+g[h+288>>2]+v*+g[h+296>>2];d=w*+g[h+276>>2]+k*+g[h+272>>2]+v*+g[h+280>>2];x=w*+g[h+260>>2]+k*+g[h+256>>2]+v*+g[h+264>>2];y=f*0.0;e=h+504|0;g[e>>2]=y+ +g[e>>2];e=h+508|0;g[e>>2]=y+ +g[e>>2];e=h+512|0;g[e>>2]=y+ +g[e>>2];y=d*f*+g[h+540>>2];d=m*f*+g[h+544>>2];g[l>>2]=x*f*+g[h+536>>2]+ +g[l>>2];g[n>>2]=y+ +g[n>>2];g[o>>2]=d+ +g[o>>2];z=+g[s>>2];A=+g[t>>2];B=+g[u>>2]}else{z=k;A=w;B=v}v=-0.0-f;if(+g[i+336>>2]==0.0){j=f;return+j}w=A*+g[i+292>>2]+z*+g[i+288>>2]+B*+g[i+296>>2];k=A*+g[i+276>>2]+z*+g[i+272>>2]+B*+g[i+280>>2];d=A*+g[i+260>>2]+z*+g[i+256>>2]+B*+g[i+264>>2];B=f*-0.0;u=i+504|0;g[u>>2]=B+ +g[u>>2];u=i+508|0;g[u>>2]=B+ +g[u>>2];u=i+512|0;g[u>>2]=B+ +g[u>>2];B=k*+g[i+540>>2]*v;k=w*+g[i+544>>2]*v;g[p>>2]=d*+g[i+536>>2]*v+ +g[p>>2];g[q>>2]=B+ +g[q>>2];g[r>>2]=k+ +g[r>>2];j=f;return+j}function yO(a){a=a|0;return+(+g[a+32>>2])}function yP(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function yQ(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function yR(a){a=a|0;return+(+g[a+52>>2])}function yS(a){a=a|0;return+(+g[a+36>>2])}function yT(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+544|0;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+560|0;e=b+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+576|0;f=b+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+592|0;e=b+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+608|0;f=d;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+624|0;e=d+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+640|0;f=d+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+656|0;e=d+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function yU(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0;d=i;i=i+272|0;e=d|0;f=d+32|0;h=d+80|0;j=d+96|0;k=d+112|0;l=d+176|0;m=d+224|0;n=k;o=l;anN(b,h,j);p=+g[a+592>>2];q=+g[a+596>>2];r=+g[a+600>>2];s=b|0;t=b+4|0;u=b+8|0;v=+g[h>>2];g[a+544>>2]=v;g[a+548>>2]=+g[j>>2];g[a+552>>2]=+g[s>>2];g[a+556>>2]=0.0;w=+g[h+4>>2];g[a+560>>2]=w;g[a+564>>2]=+g[j+4>>2];g[a+568>>2]=+g[t>>2];g[a+572>>2]=0.0;x=+g[h+8>>2];g[a+576>>2]=x;g[a+580>>2]=+g[j+8>>2];g[a+584>>2]=+g[u>>2];g[a+588>>2]=0.0;j=a+24|0;h=c[j>>2]|0;y=+g[s>>2];z=+g[t>>2];A=+g[u>>2];B=+g[h+4>>2]*y+ +g[h+8>>2]*z+ +g[h+12>>2]*A;C=+g[h+20>>2]*y+ +g[h+24>>2]*z+ +g[h+28>>2]*A;D=+g[h+36>>2]*y+ +g[h+40>>2]*z+ +g[h+44>>2]*A;E=y*B+z*C+A*D;if(E<-.9999998807907104){anN(b,e,d+16|0);F=0.0;G=+g[e+8>>2];H=+g[e+4>>2];I=+g[e>>2]}else{J=+Q(+((E+1.0)*2.0));E=1.0/J;F=J*.5;G=(y*C-z*B)*E;H=(A*B-y*D)*E;I=(z*D-A*C)*E}E=F*v+H*x-G*w;A=F*w+G*v-I*x;z=F*x+I*w-H*v;y=-0.0-I;I=v*y-H*w-G*x;x=-0.0-H;H=-0.0-G;G=I*y+E*F+A*H-z*x;w=I*x+A*F+z*y-E*H;v=I*H+z*F+E*x-A*y;y=C*v-D*w;A=D*G-B*v;x=B*w-C*G;e=a+28|0;b=c[e>>2]|0;h=f;d$(f,b+4|0,b+20|0,b+36|0,b+8|0,b+24|0,b+40|0,b+12|0,b+28|0,b+44|0);E=-0.0- +g[b+52>>2];F=-0.0- +g[b+56>>2];z=-0.0- +g[b+60>>2];H=+g[f>>2]*E+ +g[f+4>>2]*F+ +g[f+8>>2]*z;I=+g[f+16>>2]*E+ +g[f+20>>2]*F+ +g[f+24>>2]*z;J=+g[f+32>>2]*E+ +g[f+36>>2]*F+ +g[f+40>>2]*z;b=k+48|0;u=k|0;do{u=u+16|0;}while((u|0)!=(b|0));c[n>>2]=c[h>>2];c[n+4>>2]=c[h+4>>2];c[n+8>>2]=c[h+8>>2];c[n+12>>2]=c[h+12>>2];h=k+16|0;n=f+16|0;c[h>>2]=c[n>>2];c[h+4>>2]=c[n+4>>2];c[h+8>>2]=c[n+8>>2];c[h+12>>2]=c[n+12>>2];n=k+32|0;h=f+32|0;c[n>>2]=c[h>>2];c[n+4>>2]=c[h+4>>2];c[n+8>>2]=c[h+8>>2];c[n+12>>2]=c[h+12>>2];g[k+48>>2]=H;g[k+52>>2]=I;g[k+56>>2]=J;g[k+60>>2]=0.0;h=c[j>>2]|0;z=+g[h+4>>2]*p+ +g[h+8>>2]*q+ +g[h+12>>2]*r+ +g[h+52>>2];F=+g[h+20>>2]*p+ +g[h+24>>2]*q+ +g[h+28>>2]*r+ +g[h+56>>2];E=+g[h+36>>2]*p+ +g[h+40>>2]*q+ +g[h+44>>2]*r+ +g[h+60>>2];r=+g[k+16>>2]*z+ +g[k+20>>2]*F+ +g[k+24>>2]*E+I;I=+g[k+32>>2]*z+ +g[k+36>>2]*F+ +g[k+40>>2]*E+J;g[a+656>>2]=+g[k>>2]*z+ +g[k+4>>2]*F+ +g[k+8>>2]*E+H;g[a+660>>2]=r;g[a+664>>2]=I;g[a+668>>2]=0.0;k=a+608|0;g[k>>2]=G;g[a+612>>2]=y;g[a+616>>2]=B;g[a+620>>2]=0.0;g[a+624>>2]=w;g[a+628>>2]=A;g[a+632>>2]=C;g[a+636>>2]=0.0;g[a+640>>2]=v;g[a+644>>2]=x;g[a+648>>2]=D;g[a+652>>2]=0.0;eq(m,(c[e>>2]|0)+4|0);anx(l,m,k);m=k;c[m>>2]=c[o>>2];c[m+4>>2]=c[o+4>>2];c[m+8>>2]=c[o+8>>2];c[m+12>>2]=c[o+12>>2];o=a+624|0;m=l+16|0;c[o>>2]=c[m>>2];c[o+4>>2]=c[m+4>>2];c[o+8>>2]=c[m+8>>2];c[o+12>>2]=c[m+12>>2];m=a+640|0;a=l+32|0;c[m>>2]=c[a>>2];c[m+4>>2]=c[a+4>>2];c[m+8>>2]=c[a+8>>2];c[m+12>>2]=c[a+12>>2];i=d;return}function yV(){var b=0,d=0,e=0;while(1){b=aDx(64)|0;if((b|0)!=0){d=2893;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==2893){g[b+60>>2]=0.0;g[b+8>>2]=0.0;g[b+12>>2]=.10000000149011612;g[b+16>>2]=300.0;g[b>>2]=1.0;g[b+4>>2]=-1.0;g[b+28>>2]=0.0;g[b+32>>2]=.20000000298023224;g[b+36>>2]=0.0;g[b+40>>2]=0.0;g[b+20>>2]=1.0;g[b+24>>2]=.5;c[b+56>>2]=0;g[b+48>>2]=0.0;a[b+44|0]=0;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function yW(b){b=b|0;return(a[b+44|0]&1)!=0|0}function yX(b,c){b=b|0;c=c|0;a[b+44|0]=c&1;return}function yY(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0,h=0;d=+g[a>>2];e=+g[a+4>>2];if(d>e){c[a+56>>2]=0;f=0;return f|0}if(d>b){c[a+56>>2]=1;g[a+48>>2]=b-d;f=1;return f|0}h=a+56|0;if(e<b){c[h>>2]=2;g[a+48>>2]=b-e;f=2;return f|0}else{c[h>>2]=0;f=0;return f|0}return 0}function yZ(a){a=a|0;return+(+g[a+48>>2])}function y_(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function y$(a){a=a|0;return+(+g[a>>2])}function y0(a){a=a|0;return c[a+56>>2]|0}function y1(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function y2(a){a=a|0;return+(+g[a+40>>2])}function y3(a){a=a|0;return+(+g[a+8>>2])}function y4(a){a=a|0;return+(+g[a+60>>2])}function y5(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function y6(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function y7(a,b){a=a|0;b=+b;g[a+28>>2]=b;return}function y8(a){a=a|0;return+(+g[a+16>>2])}function y9(a){a=a|0;return+(+g[a+20>>2])}function za(a){a=a|0;return+(+g[a+28>>2])}function zb(a){a=a|0;return+(+g[a+4>>2])}function zc(a,b){a=a|0;b=+b;g[a+60>>2]=b;return}function zd(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function ze(a){a=a|0;return(+g[a>>2]>+g[a+4>>2]?0:1)|0}function zf(a){a=a|0;return+(+g[a+12>>2])}function zg(a,b){a=a|0;b=b|0;c[a+56>>2]=b;return}function zh(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function zi(a){a=a|0;return+(+g[a+24>>2])}function zj(a){a=a|0;return(c[a+4>>2]|0)==31|0}function zk(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function zl(a){a=a|0;return+(+g[a+44>>2])}function zm(a){a=a|0;return(c[a+4>>2]|0)<7|0}function zn(a){a=a|0;return+(+g[a+56>>2])}function zo(a){a=a|0;return+(+g[a+60>>2])}function zp(a){a=a|0;return a+12|0}function zq(a,b){a=a|0;b=b|0;if((b|0)==0){c[a+64>>2]=1;c[a+68>>2]=0;c[a+72>>2]=2;return}else if((b|0)==2){c[a+64>>2]=0;c[a+68>>2]=2;c[a+72>>2]=1;return}else if((b|0)==1){c[a+64>>2]=0;c[a+68>>2]=1;c[a+72>>2]=2;return}else{return}}function zr(a){a=a|0;return(c[a+4>>2]|0)<20|0}function zs(a){a=a|0;return(c[a+4>>2]|0)==28|0}function zt(a){a=a|0;return c[a+8>>2]|0}function zu(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function zv(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function zw(a){a=a|0;return(c[a+4>>2]|0)==32|0}function zx(a){a=a|0;return a+28|0}function zy(a){a=a|0;return c[a+68>>2]|0}function zz(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function zA(a){a=a|0;return c[a+4>>2]|0}function zB(a){a=a|0;return(c[a+4>>2]|0)==31|0}function zC(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function zD(a){a=a|0;return+(+g[a+44>>2])}function zE(a){a=a|0;return(c[a+4>>2]|0)<7|0}function zF(a){a=a|0;return+(+g[a+56>>2])}function zG(a){a=a|0;if((a|0)==0){return}aDB(a);return}function zH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function zI(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function zJ(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43760]|0)==0){if((b1(43760)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9502]=c[d>>2];c[9503]=c[d+4>>2];c[9504]=c[d+8>>2];c[9505]=c[d+12>>2];i=e;return 38008}function zK(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function zL(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function zM(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function zN(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function zO(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function zP(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(95)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;g[e+52>>2]=a/+Q(+(a*a+b*b));c[e>>2]=25768;c[e+64>>2]=0;c[e+68>>2]=2;c[e+72>>2]=1;return e|0}function zQ(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function zR(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43296]|0)==0){if((b1(43296)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9498]=c[d>>2];c[9499]=c[d+4>>2];c[9500]=c[d+8>>2];c[9501]=c[d+12>>2];i=e;return 37992}function zS(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43456]|0)==0){if((b1(43456)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9494]=c[d>>2];c[9495]=c[d+4>>2];c[9496]=c[d+8>>2];c[9497]=c[d+12>>2];i=e;return 37976}function zT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function zU(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function zV(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43600]|0)==0){if((b1(43600)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9490]=c[d>>2];c[9491]=c[d+4>>2];c[9492]=c[d+8>>2];c[9493]=c[d+12>>2];i=e;return 37960}function zW(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function zX(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function zY(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function zZ(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function z_(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function z$(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 10:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function z0(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function z1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function z2(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function z3(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function z4(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function z5(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function z6(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function z7(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function z8(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43768]|0)==0){if((b1(43768)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9486]=c[d>>2];c[9487]=c[d+4>>2];c[9488]=c[d+8>>2];c[9489]=c[d+12>>2];i=e;return 37944}function z9(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function Aa(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Ab(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function Ac(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function Ad(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function Ae(b){b=b|0;var d=0,e=0,f=0;while(1){d=aDx(64)|0;if((d|0)!=0){e=3041;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==3041){g[d+8>>2]=+g[b+8>>2];g[d+12>>2]=+g[b+12>>2];g[d+24>>2]=+g[b+24>>2];g[d>>2]=+g[b>>2];g[d+4>>2]=+g[b+4>>2];g[d+28>>2]=+g[b+28>>2];g[d+32>>2]=+g[b+32>>2];g[d+36>>2]=+g[b+36>>2];g[d+40>>2]=+g[b+40>>2];c[d+56>>2]=c[b+56>>2];g[d+48>>2]=+g[b+48>>2];a[d+44|0]=a[b+44|0]&1;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function Af(a){a=a|0;return+(+g[a+60>>2])}function Ag(a){a=a|0;return a+12|0}function Ah(a,b){a=a|0;b=b|0;if((b|0)==1){c[a+64>>2]=0;c[a+68>>2]=1;c[a+72>>2]=2;return}else if((b|0)==2){c[a+64>>2]=0;c[a+68>>2]=2;c[a+72>>2]=1;return}else if((b|0)==0){c[a+64>>2]=1;c[a+68>>2]=0;c[a+72>>2]=2;return}else{return}}function Ai(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Aj(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Ak(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Al(a){a=a|0;return c[a+8>>2]|0}function Am(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function An(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Ao(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Ap(a){a=a|0;return a+28|0}function Aq(a){a=a|0;return c[a+68>>2]|0}function Ar(a){a=a|0;return c[a+4>>2]|0}function As(a){a=a|0;return+(+g[a+168>>2])}function At(b){b=b|0;return(a[b+165|0]&1)!=0|0}function Au(a){a=a|0;return a+4|0}function Av(a,b){a=a|0;b=+b;g[a+168>>2]=b;return}function Aw(b){b=b|0;return(a[b+164|0]&1)!=0|0}function Ax(b){b=b|0;return(c[((a[b+164|0]&1)==0?b+148|0:b+128|0)>>2]|0)/3|0|0}function Ay(a){a=a|0;return a+20|0}function Az(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(95)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;g[e+52>>2]=a/+Q(+(a*a+b*b));c[e>>2]=25872;c[e+64>>2]=1;c[e+68>>2]=0;c[e+72>>2]=2;return e|0}function AA(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43304]|0)==0){if((b1(43304)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9482]=c[d>>2];c[9483]=c[d+4>>2];c[9484]=c[d+8>>2];c[9485]=c[d+12>>2];i=e;return 37928}function AB(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43464]|0)==0){if((b1(43464)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9478]=c[d>>2];c[9479]=c[d+4>>2];c[9480]=c[d+8>>2];c[9481]=c[d+12>>2];i=e;return 37912}function AC(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function AD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function AE(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43608]|0)==0){if((b1(43608)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9474]=c[d>>2];c[9475]=c[d+4>>2];c[9476]=c[d+8>>2];c[9477]=c[d+12>>2];i=e;return 37896}function AF(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function AG(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function AH(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function AI(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function AJ(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function AK(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 10:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function AL(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function AM(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function AN(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function AO(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function AP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function AQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function AR(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function AS(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function AT(a,b){a=a|0;b=b|0;aBk(a,b);return}function AU(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function AV(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+40|0;f=e|0;c[f>>2]=18624;g[f+4>>2]=999999984306749400.0;g[f+8>>2]=999999984306749400.0;g[f+12>>2]=999999984306749400.0;g[f+16>>2]=0.0;g[f+20>>2]=-999999984306749400.0;g[f+24>>2]=-999999984306749400.0;g[f+28>>2]=-999999984306749400.0;g[f+32>>2]=0.0;g[b>>2]=-999999984306749400.0;g[b+4>>2]=-999999984306749400.0;g[b+8>>2]=-999999984306749400.0;g[b+12>>2]=0.0;g[d>>2]=999999984306749400.0;g[d+4>>2]=999999984306749400.0;g[d+8>>2]=999999984306749400.0;g[d+12>>2]=0.0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,f|0,b,d);a=b;b=f+4|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];b=d;d=f+20|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];i=e;return}function AW(a,b,c){a=a|0;b=b|0;c=c|0;return aBn(a,b,c)|0}function AX(a,b){a=a|0;b=b|0;AY(a|0,b,2);return}function AY(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;f=b+24|0;g=c[f>>2]|0;h=b+28|0;do{if((g|0)==(c[h>>2]|0)){i=(g|0)==0?1:g<<1;if((g|0)>=(i|0)){j=g;break}do{if((i|0)==0){k=0}else{c[9806]=(c[9806]|0)+1;l=aDx((i<<5|4)+15|0)|0;if((l|0)==0){k=0;break}m=-(l+4|0)&15;c[l+m>>2]=l;k=l+(m+4)|0}}while(0);m=c[f>>2]|0;l=b+32|0;n=0;while(1){if((n|0)>=(m|0)){break}o=k+(n<<5)|0;p=(c[l>>2]|0)+(n<<5)|0;aDC(o|0,p|0,32)|0;n=n+1|0}n=c[f>>2]|0;m=0;while(1){if((m|0)>=(n|0)){break}m=m+1|0}m=c[l>>2]|0;p=b+36|0;if((m|0)==0){q=n;r=p}else{if((a[p]&1)==0){s=n}else{c[9804]=(c[9804]|0)+1;aDB(c[m-32+28>>2]|0);s=c[f>>2]|0}c[l>>2]=0;q=s;r=p}a[r]=1;c[l>>2]=k;c[h>>2]=i;j=q}else{j=g}}while(0);g=b+32|0;b=(c[g>>2]|0)+(j<<5)|0;j=d;aDC(b|0,j|0,32)|0;j=c[f>>2]|0;c[f>>2]=j+1;c[(c[g>>2]|0)+(j<<5)+24>>2]=e;return}function AZ(a,b,c){a=a|0;b=b|0;c=c|0;AY(a|0,b,c);return}function A_(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a|0,b,d);return}function A$(a){a=a|0;return cA[c[(c[a>>2]|0)+52>>2]&4095](a|0)|0}function A0(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(191)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}d=b;aBj(d,1,1);return d|0}function A1(a){a=a|0;var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(191)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d;aBj(e,a,1);return e|0}function A2(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(191)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;aBj(f,a,b);return f|0}function A3(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a|0,b,d);return}function A4(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function A5(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function A6(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function A7(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+16>>2]&63](a|0,b,d,e,f,g,h,i,j,0);return}function A8(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+16>>2]&63](a|0,b,d,e,f,g,h,i,j,k);return}function A9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function Ba(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+56>>2]&511](a|0,b,d)|0}function Bb(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a|0,b);return}function Bc(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Bd(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Be(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+12>>2]&63](a|0,b,d,e,f,g,h,i,j,0);return}function Bf(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+12>>2]&63](a|0,b,d,e,f,g,h,i,j,k);return}function Bg(a){a=a|0;return cA[c[(c[a>>2]|0)+40>>2]&4095](a|0)|0}function Bh(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Bi(a){a=a|0;return c[a>>2]|0}function Bj(a){a=a|0;return c[a+4>>2]|0}function Bk(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Bl(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Bm(a){a=a|0;return c[a+12>>2]|0}function Bn(a){a=a|0;return c[a+12>>2]|0}function Bo(a){a=a|0;return c[a+8>>2]|0}function Bp(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Bq(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Br(a){a=a|0;return a+4|0}function Bs(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function Bt(a){a=a|0;return+(+g[a+32>>2])}function Bu(a){a=a|0;return+(+g[a+4>>2])}function Bv(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function Bw(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Bx(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function By(a){a=a|0;return+g[a+4>>2]<1.0|0}function Bz(a){a=a|0;return b[a+10>>1]|0}function BA(a){a=a|0;return b[a+8>>1]|0}function BB(a){a=a|0;return a+132|0}function BC(a){a=a|0;return c[a+196>>2]|0}function BD(a){a=a|0;return a+4|0}function BE(a,b){a=a|0;b=b|0;c[a+196>>2]=b;return}function BF(a){a=a|0;return a+68|0}function BG(a){a=a|0;return a+100|0}function BH(a){a=a|0;return c[a+24>>2]|0}function BI(a){a=a|0;return a|0}function BJ(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function BK(b){b=b|0;return(a[b+242|0]&1)!=0|0}function BL(b,c){b=b|0;c=c|0;a[b+242|0]=c&1;return}function BM(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=c[a+32>>2]|0;c[f>>2]=(c[f>>2]|0)+1;aBk(a,aBn(a,b,0)|0);aBk(a,aBn(a,d,0)|0);aBk(a,aBn(a,e,0)|0);return}function BN(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0;g=c[a+32>>2]|0;c[g>>2]=(c[g>>2]|0)+1;aBk(a,aBn(a,b,f)|0);aBk(a,aBn(a,d,f)|0);aBk(a,aBn(a,e,f)|0);return}function BO(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a,b)|0}function BP(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-16+12>>2]|0);return}function BQ(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(35)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}aDD(b|0,0,16);return b|0}function BR(a){a=a|0;var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(35)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return d|0}function BS(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;c[9806]=(c[9806]|0)+1;d=aDx(35)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e|0;if((c[a+12>>2]|0)<(c[b+12>>2]|0)){c[f>>2]=a;c[e+4>>2]=b;g=e+8|0;c[g>>2]=0;h=e+12|0;c[h>>2]=0;return e|0}else{c[f>>2]=b;c[e+4>>2]=a;g=e+8|0;c[g>>2]=0;h=e+12|0;c[h>>2]=0;return e|0}return 0}function BT(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a|0,b)|0}function BU(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function BV(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a,b)|0}function BW(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+12>>2]&127](a,b,d))}function BX(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function BY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+8>>2]&2047](a,b);return}function BZ(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+132|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+148|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+164|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+180|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function B_(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function B$(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+20|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+36|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+52|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function B0(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0;c[a>>2]=22504;e=a+4|0;f=a+52|0;g=e|0;do{g=g+16|0;}while((g|0)!=(f|0));f=e;e=b;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];f=a+20|0;g=b+16|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];f=a+36|0;h=b+32|0;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];f=a+52|0;i=b+48|0;c[f>>2]=c[i>>2];c[f+4>>2]=c[i+4>>2];c[f+8>>2]=c[i+8>>2];c[f+12>>2]=c[i+12>>2];f=a+68|0;b=a+116|0;j=f|0;do{j=j+16|0;}while((j|0)!=(b|0));b=f;f=d;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=a+84|0;b=d+16|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];b=a+100|0;f=d+32|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=a+116|0;b=d+48|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];b=a+132|0;f=a+180|0;d=b|0;do{d=d+16|0;}while((d|0)!=(f|0));f=b;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+148|0;c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];g=a+164|0;c[g>>2]=c[h>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];c[g+12>>2]=c[h+12>>2];h=a+180|0;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];c[a+196>>2]=0;return}function B1(){var b=0;if((a[43040]|0)!=0){return}if((b1(43040)|0)==0){return}es();b=42752;do{b=b+16|0;}while((b|0)!=42800);c[10688]=c[10704];c[10689]=c[10705];c[10690]=c[10706];c[10691]=c[10707];c[10692]=c[10708];c[42772>>2]=c[42836>>2];c[42776>>2]=c[42840>>2];c[42780>>2]=c[42844>>2];c[10696]=c[10712];c[42788>>2]=c[42852>>2];c[42792>>2]=c[42856>>2];c[42796>>2]=c[42860>>2];aDD(42800,0,16);return}function B2(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+68|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+84|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+100|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+116|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function B3(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+68>>2]&2047](a|0,b);return}function B4(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a|0,b);return}function B5(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function B6(a){a=a|0;ct[c[(c[a>>2]|0)+164>>2]&2047](a|0);return}function B7(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a|0,b);return}function B8(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+80>>2]&2047](a|0,b);return}function B9(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+84>>2]&1023](a|0,b,d,e);return}function Ca(a){a=a|0;ct[c[(c[a>>2]|0)+116>>2]&2047](a|0);return}function Cb(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+124>>2]&2047](a|0,b);return}function Cc(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+156>>2]&1023](a,b);return}function Cd(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+168>>2]&2047](a|0,b);return}function Ce(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+176>>2]&1023](a,b);return}function Cf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a|0,b,d,e);return}function Cg(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function Ch(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function Ci(a){a=a|0;return cA[c[(c[a>>2]|0)+100>>2]&4095](a|0)|0}function Cj(a,b){a=a|0;b=b|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,2,-3);return}function Ck(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,-3);return}function Cl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,e);return}function Cm(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+88>>2]&2047](a|0,b);return}function Cn(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=e+32|0;j=c[b+192>>2]|0;dI[c[(c[j>>2]|0)+8>>2]&1023](j,b+4|0,f,g);c[h>>2]=21168;c[h+4>>2]=b;c[h+8>>2]=a;c[h+12>>2]=d;d=c[a+76>>2]|0;dI[c[(c[d>>2]|0)+28>>2]&1023](d,f,g,h|0);i=e;return}function Co(){var a=0,b=0,d=0;while(1){a=aDx(200)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=3290;break}dC[b&63]()}if((d|0)==3290){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=a;B1();B1();B0(d,42752,42752);return d|0}function Cp(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(200)|0;if((b|0)!=0){d=3308;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){d=3305;break}dC[e&63]()}if((d|0)==3305){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}else if((d|0)==3308){d=b;B1();B0(d,a,42752);return d|0}return 0}function Cq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;while(1){d=aDx(200)|0;if((d|0)!=0){e=3322;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==3322){e=d;B0(e,a,b);return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function Cr(a,b){a=a|0;b=b|0;c[a+88>>2]=b;c[a+96>>2]=0;return}function Cs(a,b,d){a=a|0;b=b|0;d=d|0;c[a+88>>2]=b;c[a+96>>2]=d;return}function Ct(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if(e){c[a+92>>2]=b}else{c[a+88>>2]=b}c[a+96>>2]=d;return}function Cu(b){b=b|0;return(a[b+84|0]&1)!=0|0}function Cv(a){a=a|0;return c[a+8>>2]|0}function Cw(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function Cx(a){a=a|0;return c[a+96>>2]|0}function Cy(a){a=a|0;return c[a+76>>2]|0}function Cz(b,c){b=b|0;c=c|0;a[b+84|0]=c&1;return}function CA(a){a=a|0;return a+4|0}function CB(a){a=a|0;return c[a+176>>2]|0}function CC(a){a=a|0;return a+28|0}function CD(a){a=a|0;return(c[a+4>>2]|0)==31|0}function CE(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function CF(a){a=a|0;return+(+g[a+44>>2])}function CG(a){a=a|0;return(c[a+4>>2]|0)<7|0}function CH(a){a=a|0;return+(+g[a+56>>2])}function CI(a){a=a|0;return+(+g[a+60>>2])}function CJ(a){a=a|0;return a+12|0}function CK(a,b){a=a|0;b=b|0;if((b|0)==0){c[a+64>>2]=1;c[a+68>>2]=0;c[a+72>>2]=2;return}else if((b|0)==2){c[a+64>>2]=0;c[a+68>>2]=2;c[a+72>>2]=1;return}else if((b|0)==1){c[a+64>>2]=0;c[a+68>>2]=1;c[a+72>>2]=2;return}else{return}}function CL(a){a=a|0;return(c[a+4>>2]|0)<20|0}function CM(a){a=a|0;return(c[a+4>>2]|0)==28|0}function CN(a){a=a|0;return c[a+8>>2]|0}function CO(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function CP(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function CQ(a){a=a|0;return(c[a+4>>2]|0)==32|0}function CR(a){a=a|0;ct[c[(c[a>>2]|0)+40>>2]&2047](a|0);return}function CS(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function CT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function CU(a,b){a=a|0;b=b|0;aoh(a|0,b);return}function CV(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a|0);return}function CW(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;atO(a|0,b,c,d,e,0.0);return}function CX(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;atO(a|0,b,c,d,e,f);return}function CY(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+52>>2]&511](a|0,b,0);return}function CZ(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d);return}function C_(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+168|0;g=f|0;h=a+24|0;j=c[h>>2]|0;k=dE[c[(c[j>>2]|0)+8>>2]&127](j,b,d,0)|0;if((k|0)==0){i=f;return}c[g+4>>2]=0;c[g+136>>2]=b;c[g+140>>2]=d;j=g+8|0;l=b+4|0;aDD(g+144|0,-1|0,16);c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+24|0;j=b+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+40|0;l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+56|0;j=b+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+72|0;l=d+4|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+88|0;j=d+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+104|0;l=d+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+120|0;j=d+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[g>>2]=21728;c[g+160>>2]=e;co[c[(c[k>>2]|0)+8>>2]&255](k,b,d,a+28|0,g|0);ct[c[c[k>>2]>>2]&2047](k);g=c[h>>2]|0;cv[c[(c[g>>2]|0)+60>>2]&2047](g,k);i=f;return}function C$(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43776]|0)==0){if((b1(43776)|0)==0){break}}}while(0);cv[c[(c[b>>2]|0)+72>>2]&2047](e,b|0);b=e;c[9458]=c[b>>2];c[9459]=c[b+4>>2];c[9460]=c[b+8>>2];c[9461]=c[b+12>>2];i=d;return 37832}function C0(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;atG(a,b,c,d,e,f);return}function C1(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a|0,b);return}function C2(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function C3(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+132>>2]&2047](a|0,b);return}function C4(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+104>>2]&511](a|0,b)|0}function C5(a){a=a|0;return cA[c[(c[a>>2]|0)+96>>2]&4095](a|0)|0}function C6(a,b){a=a|0;b=+b;return dr[c[(c[a>>2]|0)+48>>2]&63](a|0,b,1,.01666666753590107)|0}function C7(a,b,d){a=a|0;b=+b;d=d|0;return dr[c[(c[a>>2]|0)+48>>2]&63](a|0,b,d,.01666666753590107)|0}function C8(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return dr[c[(c[a>>2]|0)+48>>2]&63](a|0,b,d,e)|0}function C9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+128>>2]&2047](a|0,b);return}function Da(a){a=a|0;return cA[c[(c[a>>2]|0)+112>>2]&4095](a)|0}function Db(a,b){a=a|0;b=b|0;atC(a|0,b);return}function Dc(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+172>>2]&1023](a|0,b);return}function Dd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;i=i+64|0;e=d|0;f=b+472|0;if((c[f>>2]|0)==0){i=d;return}if((c[b+204>>2]&3|0)!=0){i=d;return}anY(b+68|0,+g[b+132>>2],+g[b+136>>2],+g[b+140>>2],b+148|0,+g[a+236>>2]*+g[b+240>>2],e);b=c[f>>2]|0;cv[c[(c[b>>2]|0)+12>>2]&2047](b,e);i=d;return}function De(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+120>>2]&2047](a|0,b);return}function Df(a){a=a|0;var b=0;b=c[a+76>>2]|0;return cA[c[(c[b>>2]|0)+36>>2]&4095](b)|0}function Dg(a){a=a|0;ct[c[(c[a>>2]|0)+76>>2]&2047](a|0);return}function Dh(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a|0,b);return}function Di(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+92>>2]&2047](a|0,b);return}function Dj(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;atI(a,b,c,d,e,f,g,h);return}function Dk(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function Dl(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43784]|0)==0){if((b1(43784)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9454]=c[d>>2];c[9455]=c[d+4>>2];c[9456]=c[d+8>>2];c[9457]=c[d+12>>2];i=e;return 37816}function Dm(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function Dn(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Do(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function Dp(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(95)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e>>2]=26096;g[e+56>>2]=a;g[e+60>>2]=b;c[e+4>>2]=11;c[e+64>>2]=0;c[e+68>>2]=1;c[e+72>>2]=2;g[e+52>>2]=a/+Q(+(a*a+b*b));return e|0}function Dq(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function Dr(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Ds(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43320]|0)==0){if((b1(43320)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9450]=c[d>>2];c[9451]=c[d+4>>2];c[9452]=c[d+8>>2];c[9453]=c[d+12>>2];i=e;return 37800}function Dt(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43480]|0)==0){if((b1(43480)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9446]=c[d>>2];c[9447]=c[d+4>>2];c[9448]=c[d+8>>2];c[9449]=c[d+12>>2];i=e;return 37784}function Du(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function Dv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function Dw(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43624]|0)==0){if((b1(43624)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9442]=c[d>>2];c[9443]=c[d+4>>2];c[9444]=c[d+8>>2];c[9445]=c[d+12>>2];i=e;return 37768}function Dx(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function Dy(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function Dz(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function DA(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function DB(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function DC(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function DD(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 10:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 1:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function DE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;while(1){f=aDx(268)|0;if((f|0)!=0){g=3461;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){g=3458;break}dC[h&63]()}if((g|0)==3461){aob(f,a,b,d,e);c[f>>2]=20808;return f|0}else if((g|0)==3458){g=cd(4)|0;c[g>>2]=19096;bF(g|0,34368,676);return 0}return 0}function DF(a){a=a|0;return a+28|0}function DG(a){a=a|0;return c[a+68>>2]|0}function DH(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function DI(a){a=a|0;return c[a+4>>2]|0}function DJ(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function DK(a){a=a|0;return+(+g[a+212>>2])}function DL(a){a=a|0;return+(+g[a+204>>2])}function DM(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function DN(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function DO(a){a=a|0;return+(+g[a+248>>2])}function DP(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;e=i;f=d;d=i;i=i+92|0;i=i+7>>3<<3;aDC(d,f,92)|0;if((a[b+84|0]&1)==0){g[b+32>>2]=+g[b+204>>2];g[b+272>>2]=0.0;h=-0.0- +g[b+56>>2];j=-0.0- +g[b+60>>2];g[b>>2]=-0.0- +g[b+52>>2];g[b+4>>2]=h;g[b+8>>2]=j;g[b+12>>2]=0.0;g[b+268>>2]=1.0;i=e;return}j=+g[b>>2];h=+g[b+4>>2];k=+g[b+8>>2];l=j*+g[b+52>>2]+h*+g[b+56>>2]+k*+g[b+60>>2];m=+g[b+16>>2]- +g[c+52>>2];n=+g[b+20>>2]- +g[c+56>>2];o=+g[b+24>>2]- +g[c+60>>2];p=+g[c+324>>2];q=+g[c+328>>2];r=+g[c+320>>2];if(l<-.10000000149011612){s=-1.0/l;g[b+272>>2]=s*(h*(m*q-o*r+ +g[c+308>>2])+j*(p*o-n*q+ +g[c+304>>2])+k*(n*r-m*p+ +g[c+312>>2]));g[b+268>>2]=s;i=e;return}else{g[b+272>>2]=0.0;g[b+268>>2]=10.0;i=e;return}}function DQ(a){a=a|0;return+(+g[a+220>>2])}function DR(a){a=a|0;return+(+g[a+268>>2])}function DS(a){a=a|0;return a+92|0}function DT(a){a=a|0;return+(+g[a+228>>2])}function DU(b){b=b|0;return(a[b+260|0]&1)!=0|0}function DV(a,b){a=a|0;b=+b;g[a+252>>2]=b;return}function DW(a){a=a|0;return+(+g[a+252>>2])}function DX(a){a=a|0;return+(+g[a+232>>2])}function DY(a){a=a|0;return+(+g[a+244>>2])}function DZ(a){a=a|0;return+(+g[a+272>>2])}function D_(a,b){a=a|0;b=b|0;c[a+264>>2]=b;return}function D$(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function D0(a,b){a=a|0;b=+b;g[a+272>>2]=b;return}function D1(b,c){b=b|0;c=c|0;a[b+260|0]=c&1;return}function D2(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function D3(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function D4(a){a=a|0;return c[a+264>>2]|0}function D5(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function D6(a){a=a|0;return+(+g[a+280>>2])}function D7(a){a=a|0;return+(+g[a+204>>2])}function D8(a){a=a|0;return+(+g[a+224>>2])}function D9(a){a=a|0;return+(+g[a+208>>2])}function Ea(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function Eb(a){a=a|0;return a+156|0}function Ec(a){a=a|0;return+(+g[a+256>>2])}function Ed(a,b){a=a|0;b=+b;g[a+280>>2]=b;return}function Ee(a){a=a|0;return+(+g[a+276>>2])}function Ef(a,b){a=a|0;b=+b;g[a+204>>2]=b;return}function Eg(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function Eh(a){a=a|0;return+(+g[a+236>>2])}function Ei(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function Ej(a){a=a|0;return a+172|0}function Ek(a){a=a|0;return+(+g[a+216>>2])}function El(a,b){a=a|0;b=+b;g[a+268>>2]=b;return}function Em(a,b){a=a|0;b=+b;g[a+236>>2]=b;return}function En(a){a=a|0;return a+188|0}function Eo(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function Ep(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function Eq(a){a=a|0;return+(+g[a+240>>2])}function Er(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Es(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Et(a){a=a|0;return a+12|0}function Eu(a){a=a|0;return+(+g[a+44>>2])}function Ev(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Ew(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Ex(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Ey(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Ez(a){a=a|0;return c[a+8>>2]|0}function EA(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function EB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function EC(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function ED(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function EE(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function EF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function EG(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function EH(a,b){a=a|0;b=b|0;var d=0;d=a+156|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function EI(a,b){a=a|0;b=b|0;var d=0;d=a+172|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function EJ(a,b){a=a|0;b=b|0;var d=0;d=a+188|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function EK(a){a=a|0;if((a|0)==0){return}aDB(a);return}function EL(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+92|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+108|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+124|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+140|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function EM(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function EN(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a)|0}function EO(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43680]|0)==0){if((b1(43680)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9438]=c[d>>2];c[9439]=c[d+4>>2];c[9440]=c[d+8>>2];c[9441]=c[d+12>>2];i=e;return 37752}function EP(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a,b,d)|0}function EQ(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a)|0}function ER(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+92|0;e=c[d>>2]|0;c[d>>2]=e+1;d=a+96+(e<<4)|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];aze(a|0);return}function ES(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function ET(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function EU(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a,b,d);return}function EV(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43520]|0)==0){if((b1(43520)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9434]=c[d>>2];c[9435]=c[d+4>>2];c[9436]=c[d+8>>2];c[9437]=c[d+12>>2];i=e;return 37736}function EW(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+116>>2]&511](a,b)|0}function EX(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function EY(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function EZ(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a)|0}function E_(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function E$(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a,b,d,e);return}function E0(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43192]|0)==0){if((b1(43192)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9430]=c[d>>2];c[9431]=c[d+4>>2];c[9432]=c[d+8>>2];c[9433]=c[d+12>>2];i=e;return 37720}function E1(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function E2(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function E3(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function E4(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function E5(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function E6(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(179)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;g[d+56>>2]=1.0;g[d+60>>2]=1.0;g[d+64>>2]=1.0;g[d+68>>2]=0.0;g[d+72>>2]=-1.0;g[d+76>>2]=-1.0;g[d+80>>2]=-1.0;g[d+84>>2]=0.0;a[d+88|0]=0;c[d>>2]=24456;c[d+92>>2]=0;c[d+4>>2]=2;return d|0}function E7(b){b=b|0;var d=0,e=0,f=0,h=0;while(1){d=aDx(284)|0;if((d|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){f=3593;break}dC[e&63]()}if((f|0)==3593){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}f=d;e=d+140|0;h=d+92|0;do{h=h+16|0;}while((h|0)!=(e|0));g[d+204>>2]=+g[b+48>>2];g[d+208>>2]=+g[b+52>>2];g[d+212>>2]=+g[b+56>>2];g[d+216>>2]=+g[b+60>>2];g[d+220>>2]=+g[b+64>>2];g[d+224>>2]=+g[b+68>>2];e=d+156|0;h=b;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];h=d+172|0;e=b+16|0;c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];e=d+188|0;h=b+32|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];g[d+228>>2]=+g[b+72>>2];g[d+232>>2]=0.0;g[d+252>>2]=0.0;g[d+236>>2]=0.0;g[d+240>>2]=0.0;g[d+256>>2]=0.0;g[d+244>>2]=.10000000149011612;a[d+260|0]=a[b+80|0]&1;g[d+248>>2]=+g[b+76>>2];return f|0}function E8(a){a=a|0;return(c[a+4>>2]|0)==32|0}function E9(a){a=a|0;c[a+92>>2]=0;return}function Fa(a){a=a|0;return a+28|0}function Fb(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Fc(a){a=a|0;return c[a+52>>2]|0}function Fd(a){a=a|0;return c[a+4>>2]|0}function Fe(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Ff(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(d>=+g[c>>2]){return}g[c>>2]=d;return}function Fg(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0;e=a+8|0;f=-0.0- +g[e>>2];h=a+4|0;g[b>>2]=0.0;g[b+4>>2]=f;g[b+8>>2]=+g[h>>2];g[b+12>>2]=0.0;b=a|0;f=-0.0- +g[b>>2];g[c>>2]=+g[e>>2];g[c+4>>2]=0.0;g[c+8>>2]=f;g[c+12>>2]=0.0;g[d>>2]=-0.0- +g[h>>2];g[d+4>>2]=+g[b>>2];g[d+8>>2]=0.0;g[d+12>>2]=0.0;return}function Fh(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[b+(c<<2)>>2]=+g[a+(c<<2)>>2];c=c+1|0}return}function Fi(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+h[b+(c<<3)>>3];c=c+1|0}return}function Fj(a){a=a|0;return+(+g[a>>2])}function Fk(a){a=a|0;var b=0.0,c=0,d=0.0,e=0,f=0.0,h=0;b=+g[a>>2];c=b<999999984306749400.0;d=c?b:999999984306749400.0;b=+g[a+4>>2];e=b<d;f=e?b:d;d=+g[a+8>>2];h=d<f;return(+g[a+12>>2]<(h?d:f)?3:h?2:e?1:c?0:-1)|0}function Fl(a){a=a|0;return+(+g[a+8>>2])}function Fm(b){b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(179)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+52>>2]=0;g[e+56>>2]=1.0;g[e+60>>2]=1.0;g[e+64>>2]=1.0;g[e+68>>2]=0.0;g[e+72>>2]=-1.0;g[e+76>>2]=-1.0;g[e+80>>2]=-1.0;g[e+84>>2]=0.0;a[e+88|0]=0;c[e>>2]=24456;f=e+96|0;c[e+4>>2]=2;c[e+92>>2]=1;d=b;c[f>>2]=c[d>>2];c[f+4>>2]=c[d+4>>2];c[f+8>>2]=c[d+8>>2];c[f+12>>2]=c[d+12>>2];aze(e);return e|0}function Fn(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0;c[9806]=(c[9806]|0)+1;e=aDx(179)|0;if((e|0)==0){f=0}else{h=-(e+4|0)&15;c[e+h>>2]=e;f=e+(h+4)|0}h=f;e=f;c[f+8>>2]=0;g[f+12>>2]=1.0;g[f+16>>2]=1.0;g[f+20>>2]=1.0;g[f+24>>2]=0.0;g[f+44>>2]=.03999999910593033;c[f+52>>2]=0;g[f+56>>2]=1.0;g[f+60>>2]=1.0;g[f+64>>2]=1.0;g[f+68>>2]=0.0;g[f+72>>2]=-1.0;g[f+76>>2]=-1.0;g[f+80>>2]=-1.0;g[f+84>>2]=0.0;a[f+88|0]=0;c[f>>2]=24456;i=f+92|0;j=f+96|0;c[f+4>>2]=2;c[i>>2]=1;f=b;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];aze(e);f=c[i>>2]|0;c[i>>2]=f+1;i=h+96+(f<<4)|0;f=d;c[i>>2]=c[f>>2];c[i+4>>2]=c[f+4>>2];c[i+8>>2]=c[f+8>>2];c[i+12>>2]=c[f+12>>2];aze(e);return h|0}function Fo(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0;c[9806]=(c[9806]|0)+1;f=aDx(179)|0;if((f|0)==0){h=0}else{i=-(f+4|0)&15;c[f+i>>2]=f;h=f+(i+4)|0}i=h;f=h;c[h+8>>2]=0;g[h+12>>2]=1.0;g[h+16>>2]=1.0;g[h+20>>2]=1.0;g[h+24>>2]=0.0;g[h+44>>2]=.03999999910593033;c[h+52>>2]=0;g[h+56>>2]=1.0;g[h+60>>2]=1.0;g[h+64>>2]=1.0;g[h+68>>2]=0.0;g[h+72>>2]=-1.0;g[h+76>>2]=-1.0;g[h+80>>2]=-1.0;g[h+84>>2]=0.0;a[h+88|0]=0;c[h>>2]=24456;j=h+92|0;k=h+96|0;c[h+4>>2]=2;c[j>>2]=1;h=b;c[k>>2]=c[h>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];aze(f);h=c[j>>2]|0;c[j>>2]=h+1;k=i+96+(h<<4)|0;h=d;c[k>>2]=c[h>>2];c[k+4>>2]=c[h+4>>2];c[k+8>>2]=c[h+8>>2];c[k+12>>2]=c[h+12>>2];aze(f);h=c[j>>2]|0;c[j>>2]=h+1;j=i+96+(h<<4)|0;h=e;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];aze(f);return i|0}function Fp(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0,l=0;c[9806]=(c[9806]|0)+1;h=aDx(179)|0;if((h|0)==0){i=0}else{j=-(h+4|0)&15;c[h+j>>2]=h;i=h+(j+4)|0}j=i;h=i;c[i+8>>2]=0;g[i+12>>2]=1.0;g[i+16>>2]=1.0;g[i+20>>2]=1.0;g[i+24>>2]=0.0;g[i+44>>2]=.03999999910593033;c[i+52>>2]=0;g[i+56>>2]=1.0;g[i+60>>2]=1.0;g[i+64>>2]=1.0;g[i+68>>2]=0.0;g[i+72>>2]=-1.0;g[i+76>>2]=-1.0;g[i+80>>2]=-1.0;g[i+84>>2]=0.0;a[i+88|0]=0;c[i>>2]=24456;k=i+92|0;l=i+96|0;c[i+4>>2]=2;c[k>>2]=1;i=b;c[l>>2]=c[i>>2];c[l+4>>2]=c[i+4>>2];c[l+8>>2]=c[i+8>>2];c[l+12>>2]=c[i+12>>2];aze(h);i=c[k>>2]|0;c[k>>2]=i+1;l=j+96+(i<<4)|0;i=d;c[l>>2]=c[i>>2];c[l+4>>2]=c[i+4>>2];c[l+8>>2]=c[i+8>>2];c[l+12>>2]=c[i+12>>2];aze(h);i=c[k>>2]|0;c[k>>2]=i+1;l=j+96+(i<<4)|0;i=e;c[l>>2]=c[i>>2];c[l+4>>2]=c[i+4>>2];c[l+8>>2]=c[i+8>>2];c[l+12>>2]=c[i+12>>2];aze(h);i=c[k>>2]|0;c[k>>2]=i+1;k=j+96+(i<<4)|0;i=f;c[k>>2]=c[i>>2];c[k+4>>2]=c[i+4>>2];c[k+8>>2]=c[i+8>>2];c[k+12>>2]=c[i+12>>2];aze(h);return j|0}function Fq(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function Fr(a){a=a|0;aze(a|0);return}function Fs(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function Ft(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function Fu(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a|0)|0}function Fv(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43368]|0)==0){if((b1(43368)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9426]=c[d>>2];c[9427]=c[d+4>>2];c[9428]=c[d+8>>2];c[9429]=c[d+12>>2];i=e;return 37704}function Fw(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 5:case 4:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 1:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function Fx(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Fy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function Fz(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function FA(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function FB(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function FC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function FD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a,b,d,e);return}function FE(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function FF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;gx(a|0,b,c,d,e);return}function FG(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0.0;e=1.0-d;g[a>>2]=e*+g[b>>2]+ +g[c>>2]*d;g[a+4>>2]=e*+g[b+4>>2]+ +g[c+4>>2]*d;g[a+8>>2]=e*+g[b+8>>2]+ +g[c+8>>2]*d;return}function FH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+4>>2];e=+g[c+8>>2];f=+g[b+8>>2];h=+g[c+4>>2];i=+g[c>>2];j=+g[b>>2];return+(+g[a>>2]*(d*e-f*h)+ +g[a+4>>2]*(f*i-j*e)+ +g[a+8>>2]*(j*h-d*i))}function FI(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+g[b+(c<<2)>>2];c=c+1|0}return}function FJ(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(+g[c>>2]>=d){return}g[c>>2]=d;return}function FK(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}h[b+(c<<3)>>3]=+g[a+(c<<2)>>2];c=c+1|0}return}function FL(a){a=a|0;return+(+g[a+12>>2])}function FM(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;c=+g[b>>2]- +g[a>>2];d=+g[b+4>>2]- +g[a+4>>2];e=+g[b+8>>2]- +g[a+8>>2];return+(c*c+d*d+e*e)}function FN(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function FO(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return b*b+c*c+d*d<1.1920928955078125e-7|0}function FP(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+g[b+(c<<2)>>2];c=c+1|0}return}function FQ(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];if(b<c){e=b<d?0:2;return e|0}else{e=c<d?1:2;return e|0}return 0}function FR(a){a=a|0;var b=0;if(+g[a>>2]!=0.0){b=0;return b|0}if(+g[a+4>>2]!=0.0){b=0;return b|0}b=+g[a+8>>2]==0.0;return b|0}function FS(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[b+(c<<2)>>2]=+g[a+(c<<2)>>2];c=c+1|0}return}function FT(a,b){a=a|0;b=+b;g[a>>2]=b;return}function FU(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function FV(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function FW(a){a=a|0;var b=0.0,c=0,d=0.0,e=0,f=0.0,h=0;b=+g[a>>2];c=b>-999999984306749400.0;d=c?b:-999999984306749400.0;b=+g[a+4>>2];e=b>d;f=e?b:d;d=+g[a+8>>2];h=d>f;return(+g[a+12>>2]>(h?d:f)?3:h?2:e?1:c?0:-1)|0}function FX(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];if(b<c){e=c<d?2:1;return e|0}else{e=b<d?2:0;return e|0}return 0}function FY(a){a=a|0;return+(+g[a+4>>2])}function FZ(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return+(b*b+c*c+d*d)}function F_(b){b=b|0;var c=0.0,d=0.0,e=0.0;do{if((a[44072]|0)==0){if((b1(44072)|0)==0){break}}}while(0);c=+P(+(+g[b>>2]));d=+P(+(+g[b+4>>2]));e=+P(+(+g[b+8>>2]));g[9422]=c;g[9423]=d;g[9424]=e;g[9425]=0.0;return 37688}function F$(a){a=a|0;var b=0,c=0.0,d=0,e=0.0,f=0,h=0.0,i=0.0;b=a|0;c=+g[b>>2];d=a+4|0;e=+g[d>>2];f=a+8|0;h=+g[f>>2];i=1.0/+Q(+(c*c+e*e+h*h));g[b>>2]=c*i;g[d>>2]=e*i;g[f>>2]=h*i;return a|0}function F0(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;c=+g[a>>2];d=+g[a+4>>2];e=+g[a+8>>2];f=+g[b>>2];h=+g[b+4>>2];i=+g[b+8>>2];j=(c*f+d*h+e*i)/+Q(+((c*c+d*d+e*e)*(f*f+h*h+i*i)));if(j<-1.0){k=-1.0;l=+V(+k);return+l}if(j<=1.0){k=j;l=+V(+k);return+l}k=1.0;l=+V(+k);return+l}function F1(b,c,d){b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0;do{if((a[44144]|0)==0){if((b1(44144)|0)==0){break}}}while(0);e=+g[b>>2];f=+g[b+4>>2];h=f+(+g[c+4>>2]-f)*d;f=+g[b+8>>2];i=f+(+g[c+8>>2]-f)*d;g[9406]=e+(+g[c>>2]-e)*d;g[9407]=h;g[9408]=i;g[9409]=0.0;return 37624}function F2(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;do{if((a[44128]|0)==0){if((b1(44128)|0)==0){break}}}while(0);d=+g[b+4>>2];e=+g[c+8>>2];f=+g[b+8>>2];h=+g[c+4>>2];i=+g[c>>2];j=+g[b>>2];g[9402]=d*e-f*h;g[9403]=f*i-j*e;g[9404]=j*h-d*i;g[9405]=0.0;return 37608}function F3(b){b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0;do{if((a[44040]|0)==0){if((b1(44040)|0)==0){break}}}while(0);c=+P(+(+g[b>>2]));d=+P(+(+g[b+4>>2]));e=+P(+(+g[b+8>>2]));f=+P(+(+g[b+12>>2]));g[9398]=c;g[9399]=d;g[9400]=e;g[9401]=f;return 37592}function F4(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+P(+(+g[a>>2]));c=+P(+(+g[a+4>>2]));d=+P(+(+g[a+8>>2]));if(b<c){e=c<d?2:1;return e|0}else{e=b<d?2:0;return e|0}return 0}function F5(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;c=+g[b>>2]- +g[a>>2];d=+g[b+4>>2]- +g[a+4>>2];e=+g[b+8>>2]- +g[a+8>>2];return+(+Q(+(c*c+d*d+e*e)))}function F6(a){a=a|0;return F7(a|0)|0}function F7(a){a=a|0;var b=0,c=0,d=0,e=0.0,f=0.0,h=0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0;b=i;i=i+16|0;c=b|0;d=a|0;e=+g[d>>2];f=+P(+e);h=a+4|0;j=+g[h>>2];k=+P(+j);l=a+8|0;m=+g[l>>2];n=+P(+m);g[c>>2]=f;g[c+4>>2]=k;g[c+8>>2]=n;g[c+12>>2]=0.0;if(f<k){o=k<n?2:1}else{o=f<n?2:0}n=+g[c+(o<<2)>>2];if(n>0.0){f=1.0/n;n=e*f;e=j*f;j=m*f;f=1.0/+Q(+(n*n+e*e+j*j));g[d>>2]=n*f;g[h>>2]=e*f;g[l>>2]=j*f;i=b;return a|0}else{g[d>>2]=1.0;g[h>>2]=0.0;g[l>>2]=0.0;g[a+12>>2]=0.0;i=b;return a|0}return 0}function F8(b){b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0;do{if((a[43984]|0)==0){if((b1(43984)|0)==0){break}}}while(0);c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];f=1.0/+Q(+(c*c+d*d+e*e));g[9394]=c*f;g[9395]=d*f;g[9396]=e*f;g[9397]=0.0;return 37576}function F9(a){a=a|0;if((a|0)==0){return}aDB(a);return}function Ga(b,d,e){b=b|0;d=d|0;e=+e;var f=0,g=0;f=i;i=i+16|0;g=f|0;do{if((a[44112]|0)==0){if((b1(44112)|0)==0){break}}}while(0);Gb(g,b|0,d,e);d=g;c[9390]=c[d>>2];c[9391]=c[d+4>>2];c[9392]=c[d+8>>2];c[9393]=c[d+12>>2];i=f;return 37560}function Gb(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;e=+g[c>>2];f=+g[b>>2];h=+g[c+4>>2];i=+g[b+4>>2];j=+g[c+8>>2];k=+g[b+8>>2];l=e*f+h*i+j*k;m=e*l;n=h*l;o=j*l;l=+S(+d);p=+T(+d);g[a>>2]=m+(f-m)*l+(h*k-j*i)*p;g[a+4>>2]=n+(i-n)*l+(j*f-e*k)*p;g[a+8>>2]=o+(k-o)*l+(e*i-h*f)*p;g[a+12>>2]=0.0;return}function Gc(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0,f=0.0,h=0,i=0;b=+P(+(+g[a>>2]));c=+P(+(+g[a+4>>2]));d=+P(+(+g[a+8>>2]));e=b>-999999984306749400.0;f=e?b:-999999984306749400.0;h=c>f;b=h?c:f;i=d>b;return(+P(+(+g[a+12>>2]))>(i?d:b)?3:i?2:h?1:e?0:-1)|0}function Gd(a){a=a|0;aDD(a|0,0,16);return}function Ge(){var a=0,b=0,d=0;while(1){a=aDx(16)|0;if((a|0)!=0){b=3828;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==3828){return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function Gf(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0,i=0;while(1){f=aDx(16)|0;if((f|0)!=0){h=3840;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==3840){g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function Gg(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Gh(a){a=a|0;return+(+g[a+12>>2])}function Gi(a){a=a|0;return+(+g[a+4>>2])}function Gj(a){a=a|0;return+(+g[a>>2])}function Gk(a){a=a|0;return+(+g[a+8>>2])}function Gl(a,b){a=a|0;b=b|0;return+(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])}function Gm(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(d>=+g[c>>2]){return}g[c>>2]=d;return}function Gn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0.0,h=0;e=a+8|0;f=-0.0- +g[e>>2];h=a+4|0;g[b>>2]=0.0;g[b+4>>2]=f;g[b+8>>2]=+g[h>>2];g[b+12>>2]=0.0;b=a|0;f=-0.0- +g[b>>2];g[c>>2]=+g[e>>2];g[c+4>>2]=0.0;g[c+8>>2]=f;g[c+12>>2]=0.0;g[d>>2]=-0.0- +g[h>>2];g[d+4>>2]=+g[b>>2];g[d+8>>2]=0.0;g[d+12>>2]=0.0;return}function Go(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[b+(c<<2)>>2]=+g[a+(c<<2)>>2];c=c+1|0}return}function Gp(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+h[b+(c<<3)>>3];c=c+1|0}return}function Gq(a){a=a|0;return+(+g[a>>2])}function Gr(a){a=a|0;return+(+g[a+4>>2])}function Gs(a){a=a|0;return+(+g[a+8>>2])}function Gt(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;var e=0.0;e=1.0-d;g[a>>2]=e*+g[b>>2]+ +g[c>>2]*d;g[a+4>>2]=e*+g[b+4>>2]+ +g[c+4>>2]*d;g[a+8>>2]=e*+g[b+8>>2]+ +g[c+8>>2]*d;return}function Gu(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;d=+g[b+4>>2];e=+g[c+8>>2];f=+g[b+8>>2];h=+g[c+4>>2];i=+g[c>>2];j=+g[b>>2];return+(+g[a>>2]*(d*e-f*h)+ +g[a+4>>2]*(f*i-j*e)+ +g[a+8>>2]*(j*h-d*i))}function Gv(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[c>>2]- +g[b>>2];c=a+4|0;g[c>>2]=+g[c>>2]- +g[b+4>>2];c=a+8|0;g[c>>2]=+g[c>>2]- +g[b+8>>2];return a|0}function Gw(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(+g[c>>2]>=d){return}g[c>>2]=d;return}function Gx(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[c>>2]+ +g[b>>2];c=a+4|0;g[c>>2]=+g[c>>2]+ +g[b+4>>2];c=a+8|0;g[c>>2]=+g[c>>2]+ +g[b+8>>2];return a|0}function Gy(a,b){a=a|0;b=b|0;var c=0;if(+g[a+12>>2]!=+g[b+12>>2]){c=0;return c|0}if(+g[a+8>>2]!=+g[b+8>>2]){c=0;return c|0}if(+g[a+4>>2]!=+g[b+4>>2]){c=0;return c|0}c=+g[a>>2]==+g[b>>2];return c|0}function Gz(a,b){a=a|0;b=+b;var c=0;c=a|0;g[c>>2]=+g[c>>2]*b;c=a+4|0;g[c>>2]=+g[c>>2]*b;c=a+8|0;g[c>>2]=+g[c>>2]*b;return a|0}function GA(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}h[b+(c<<3)>>3]=+g[a+(c<<2)>>2];c=c+1|0}return}function GB(a){a=a|0;var b=0;if(+g[a>>2]!=0.0){b=0;return b|0}if(+g[a+4>>2]!=0.0){b=0;return b|0}b=+g[a+8>>2]==0.0;return b|0}function GC(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;c=+g[b>>2]- +g[a>>2];d=+g[b+4>>2]- +g[a+4>>2];e=+g[b+8>>2]- +g[a+8>>2];return+(c*c+d*d+e*e)}function GD(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function GE(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return b*b+c*c+d*d<1.1920928955078125e-7|0}function GF(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+g[b+(c<<2)>>2];c=c+1|0}return}function GG(a,b){a=a|0;b=+b;var c=0.0,d=0;c=1.0/b;d=a|0;g[d>>2]=+g[d>>2]*c;d=a+4|0;g[d>>2]=+g[d>>2]*c;d=a+8|0;g[d>>2]=+g[d>>2]*c;return a|0}function GH(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];if(b<c){e=b<d?0:2;return e|0}else{e=c<d?1:2;return e|0}return 0}function GI(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return+(+Q(+(b*b+c*c+d*d)))}function GJ(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+P(+(+g[a>>2]));c=+P(+(+g[a+4>>2]));d=+P(+(+g[a+8>>2]));if(b<c){e=b<d?0:2;return e|0}else{e=c<d?1:2;return e|0}return 0}function GK(a,b,d){a=a|0;b=b|0;d=+d;dF[c[(c[a>>2]|0)+8>>2]&255](a,b,d);return}function GL(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function GM(b){b=b|0;var c=0.0,d=0.0,e=0.0;do{if((a[44080]|0)==0){if((b1(44080)|0)==0){break}}}while(0);c=+P(+(+g[b>>2]));d=+P(+(+g[b+4>>2]));e=+P(+(+g[b+8>>2]));g[9386]=c;g[9387]=d;g[9388]=e;g[9389]=0.0;return 37544}function GN(a){a=a|0;var b=0,c=0.0,d=0,e=0.0,f=0,h=0.0,i=0.0;b=a|0;c=+g[b>>2];d=a+4|0;e=+g[d>>2];f=a+8|0;h=+g[f>>2];i=1.0/+Q(+(c*c+e*e+h*h));g[b>>2]=c*i;g[d>>2]=e*i;g[f>>2]=h*i;return a|0}function GO(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;c=+g[a>>2];d=+g[a+4>>2];e=+g[a+8>>2];f=+g[b>>2];h=+g[b+4>>2];i=+g[b+8>>2];j=(c*f+d*h+e*i)/+Q(+((c*c+d*d+e*e)*(f*f+h*h+i*i)));if(j<-1.0){k=-1.0;l=+V(+k);return+l}if(j<=1.0){k=j;l=+V(+k);return+l}k=1.0;l=+V(+k);return+l}function GP(b,c,d){b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0;do{if((a[44152]|0)==0){if((b1(44152)|0)==0){break}}}while(0);e=+g[b>>2];f=+g[b+4>>2];h=f+(+g[c+4>>2]-f)*d;f=+g[b+8>>2];i=f+(+g[c+8>>2]-f)*d;g[9382]=e+(+g[c>>2]-e)*d;g[9383]=h;g[9384]=i;g[9385]=0.0;return 37528}function GQ(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0;do{if((a[44136]|0)==0){if((b1(44136)|0)==0){break}}}while(0);d=+g[b+4>>2];e=+g[c+8>>2];f=+g[b+8>>2];h=+g[c+4>>2];i=+g[c>>2];j=+g[b>>2];g[9378]=d*e-f*h;g[9379]=f*i-j*e;g[9380]=j*h-d*i;g[9381]=0.0;return 37512}function GR(a){a=a|0;if((a|0)==0){return}aDB(a);return}function GS(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];return(a|0)!=0|0}function GT(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+P(+(+g[a>>2]));c=+P(+(+g[a+4>>2]));d=+P(+(+g[a+8>>2]));if(b<c){e=c<d?2:1;return e|0}else{e=b<d?2:0;return e|0}return 0}function GU(a){a=a|0;return F7(a)|0}function GV(b){b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0;do{if((a[43992]|0)==0){if((b1(43992)|0)==0){break}}}while(0);c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];f=1.0/+Q(+(c*c+d*d+e*e));g[9374]=c*f;g[9375]=d*f;g[9376]=e*f;g[9377]=0.0;return 37496}function GW(){var a=0,b=0,d=0;while(1){a=aDx(16)|0;if((a|0)!=0){b=3977;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==3977){return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function GX(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0,h=0;while(1){e=aDx(16)|0;if((e|0)!=0){f=3989;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){break}dC[h&63]()}if((f|0)==3989){g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function GY(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[b+(c<<2)>>2]=+g[a+(c<<2)>>2];c=c+1|0}return}function GZ(a,b){a=a|0;b=+b;g[a>>2]=b;return}function G_(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function G$(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function G0(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];if(b<c){e=c<d?2:1;return e|0}else{e=b<d?2:0;return e|0}return 0}function G1(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=4){break}g[a+(c<<2)>>2]=+g[b+(c<<2)>>2];c=c+1|0}return}function G2(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return+(b*b+c*c+d*d)}function G3(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function G4(a,b){a=a|0;b=b|0;return+(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])}function G5(a){a=a|0;return+(+g[a+12>>2])}function G6(a){a=a|0;return+(+g[a+4>>2])}function G7(a){a=a|0;return+(+g[a>>2])}function G8(a){a=a|0;return+(+g[a+8>>2])}function G9(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function Ha(a){a=a|0;return+(+g[a+8>>2])}function Hb(a){a=a|0;return+(+g[a+4>>2])}function Hc(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Hd(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function He(a){a=a|0;return+(+g[a+12>>2])}function Hf(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function Hg(a){a=a|0;return c[a>>2]|0}function Hh(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function Hi(a){a=a|0;return a+36|0}function Hj(a){a=a|0;return a+68|0}function Hk(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Hl(a){a=a|0;return c[a+8>>2]|0}function Hm(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function Hn(a){a=a|0;return a+20|0}function Ho(a){a=a|0;return b[a+14>>1]|0}function Hp(a){a=a|0;return+(+g[a+4>>2])}function Hq(a){a=a|0;return c[a+16>>2]|0}function Hr(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function Hs(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function Ht(a){a=a|0;return(c[a+8>>2]|0)!=0|0}function Hu(a){a=a|0;return a+52|0}function Hv(a){a=a|0;return b[a+12>>1]|0}function Hw(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Hx(a){a=a|0;return a+8|0}function Hy(a,b){a=a|0;b=+b;g[a+24>>2]=b;return}function Hz(a){a=a|0;return+(+g[a+24>>2])}function HA(a){a=a|0;return c[a+4>>2]|0}function HB(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function HC(a){a=a|0;return c[a>>2]|0}function HD(a){a=a|0;return c[a+28>>2]|0}function HE(a){a=a|0;return c[a+12>>2]|0}function HF(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function HG(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function HH(a){a=a|0;return a+40|0}function HI(a,b){a=a|0;b=b|0;return+(+g[a+1248+(b<<2)>>2])}function HJ(a){a=a|0;return a+1120|0}function HK(a){a=a|0;return a+1056|0}function HL(a){a=a|0;return c[a+12>>2]|0}function HM(a){a=a|0;return c[a+4>>2]|0}function HN(a){a=a|0;return c[a+24>>2]|0}function HO(a){a=a|0;return+(+g[a+16>>2])}function HP(a,b,c){a=a|0;b=b|0;c=+c;g[a+1356+(b<<2)>>2]=c;return}function HQ(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0;c=+g[b>>2]- +g[a>>2];d=+g[b+4>>2]- +g[a+4>>2];e=+g[b+8>>2]- +g[a+8>>2];return+(+Q(+(c*c+d*d+e*e)))}function HR(b,d,e){b=b|0;d=d|0;e=+e;var f=0,g=0;f=i;i=i+16|0;g=f|0;do{if((a[44120]|0)==0){if((b1(44120)|0)==0){break}}}while(0);Gb(g,b,d,e);d=g;c[9370]=c[d>>2];c[9371]=c[d+4>>2];c[9372]=c[d+8>>2];c[9373]=c[d+12>>2];i=f;return 37480}function HS(a){a=a|0;aDD(a|0,0,16);return}function HT(a){a=a|0;var b=0.0,c=0.0,d=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];return+(+Q(+(b*b+c*c+d*d)))}function HU(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0;b=+P(+(+g[a>>2]));c=+P(+(+g[a+4>>2]));d=+P(+(+g[a+8>>2]));if(b<c){e=b<d?0:2;return e|0}else{e=c<d?1:2;return e|0}return 0}function HV(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a,b);return}function HW(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+40>>2]&511](a,b)|0}function HX(a){a=a|0;ct[c[(c[a>>2]|0)+32>>2]&2047](a);return}function HY(a){a=a|0;return cA[c[(c[a>>2]|0)+52>>2]&4095](a)|0}function HZ(a){a=a|0;ct[c[(c[a>>2]|0)+36>>2]&2047](a);return}function H_(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+28>>2]&511](a,b)|0}function H$(a){a=a|0;return cA[c[(c[a>>2]|0)+8>>2]&4095](a)|0}function H0(a){a=a|0;return cA[c[(c[a>>2]|0)+12>>2]&4095](a)|0}function H1(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+20>>2]&255](a,b,d,e,f);return}function H2(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+48>>2]&2047](a,b);return}function H3(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+24>>2]&511](a,b)|0}function H4(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function H5(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+16>>2]&511](a,b,d)|0}function H6(a){a=a|0;if((a|0)==0){return}aDB(a);return}function H7(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+12>>2]&127](a,b,d))}function H8(a,b){a=a|0;b=b|0;var d=0;d=a+36|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function H9(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a|0,b)|0}function Ia(a,b){a=a|0;b=b|0;var d=0;d=a+52|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ib(a,b){a=a|0;b=b|0;var d=0;d=a+68|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ic(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Id(a,b){a=a|0;b=b|0;var d=0;d=a+20|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ie(a){a=a|0;if((a|0)==0){return}aDB(a);return}function If(a,b){a=a|0;b=b|0;var d=0;d=a+8|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ig(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function Ih(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function Ii(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function Ij(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a|0,b,d)|0}function Ik(a,b){a=a|0;b=+b;var c=0,d=0,e=0,f=0.0;c=i;i=i+16|0;d=c|0;e=a;g[d>>2]=-1.0;g[d+4>>2]=0.0;g[d+8>>2]=b;g[d+12>>2]=0.0;a=0;while(1){if((a|0)>=3){break}b=+ck(+(+g[d+(a<<2)>>2]),6.2831854820251465);do{if(b<-3.1415927410125732){f=b+6.2831854820251465}else{if(b<=3.1415927410125732){f=b;break}f=b-6.2831854820251465}}while(0);g[e+860+(a<<6)+4>>2]=f;a=a+1|0}i=c;return}function Il(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function Im(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function In(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function Io(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a|0,b);return}function Ip(a){a=a|0;ct[c[(c[a>>2]|0)+44>>2]&2047](a);return}function Iq(){var a=0,b=0,d=0;while(1){a=aDx(16)|0;if((a|0)!=0){b=4133;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==4133){g[a+4>>2]=6.2831854820251465;g[a+8>>2]=6.2831854820251465;g[a+12>>2]=6.2831854820251465;c[a>>2]=0;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function Ir(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;while(1){e=aDx(84)|0;if((e|0)!=0){f=4145;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){break}dC[h&63]()}if((f|0)==4145){g[e+4>>2]=1.0;c[e+8>>2]=0;b[e+12>>1]=1;b[e+14>>1]=-1;c[e+16>>2]=0;c[e>>2]=19480;f=e+20|0;h=a;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];h=e+36|0;f=d;c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function Is(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;var f=0,h=0,i=0;while(1){f=aDx(28)|0;if((f|0)!=0){h=4157;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==4157){c[f>>2]=a;c[f+4>>2]=b;b=f+8|0;a=d;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];g[f+24>>2]=e;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function It(a,b){a=a|0;b=+b;return}function Iu(a,b){a=a|0;b=b|0;var c=0;c=a;a=0;while(1){if((a|0)>=3){break}g[b+(a<<2)>>2]=+g[c+860+(a<<6)>>2];a=a+1|0}return}function Iv(a,b,c){a=a|0;b=b|0;c=+c;g[a+1308+(b<<2)>>2]=c;return}function Iw(a){a=a|0;return+(+g[a+32>>2])}function Ix(b){b=b|0;return(a[b+20|0]&1)!=0|0}function Iy(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Iz(a){a=a|0;return c[a+4>>2]|0}function IA(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function IB(a){a=a|0;return a+1104|0}function IC(b,c){b=b|0;c=c|0;a[b+1293|0]=c&1;return}function ID(a,b){a=a|0;b=b|0;var c=0,d=0;c=a;if((b|0)<3){d=+g[a+688+(b<<2)>>2]>=+g[a+672+(b<<2)>>2];return d|0}a=b-3|0;if(+g[c+860+(a<<6)>>2]>+g[c+860+(a<<6)+4>>2]){d=0;return d|0}d=1;return d|0}function IE(a){a=a|0;return+(+g[a+1184>>2])}function IF(a,b){a=a|0;b=b|0;return a+860+(b<<6)|0}function IG(a){a=a|0;return+(+g[a+1192>>2])}function IH(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+1300|0]&1)==0){c[e>>2]=6;c[d+4>>2]=0;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function II(a){a=a|0;return a+104|0}function IJ(a){a=a|0;return a+1168|0}function IK(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function IL(b){b=b|0;return(a[b+1293|0]&1)!=0|0}function IM(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function IN(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;e=d&1;a[b+1301+c|0]=e;if((c|0)<3){a[b+(c+780)|0]=e;return}else{a[b+860+(c-3<<6)+44|0]=e;return}}function IO(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function IP(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function IQ(a,b,c){a=a|0;b=b|0;c=+c;g[a+1332+(b<<2)>>2]=c;return}function IR(b){b=b|0;return(a[b+1300|0]&1)!=0|0}function IS(a){a=a|0;return+(+g[a+32>>2])}function IT(b,c){b=b|0;c=c|0;a[b+1300|0]=c&1;return}function IU(a){a=a|0;return a+672|0}function IV(b){b=b|0;return(a[b+21|0]&1)!=0|0}function IW(a,b){a=a|0;b=b|0;return+(+g[a+1184+(b<<2)>>2])}function IX(a,b){a=a|0;b=b|0;var c=0;c=a;a=0;while(1){if((a|0)>=3){break}g[b+(a<<2)>>2]=+g[c+860+(a<<6)+4>>2];a=a+1|0}return}function IY(a){a=a|0;return c[a+4>>2]|0}function IZ(a){a=a|0;return c[a+8>>2]|0}function I_(a){a=a|0;return+(+g[a+36>>2])}function I$(a){a=a|0;return a+1396|0}function I0(a){a=a|0;return c[a+12>>2]|0}function I1(a){a=a|0;return a+1412|0}function I2(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function I3(a){a=a|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);g[a+1308>>2]=+g[a+1248>>2];g[a+1312>>2]=+g[a+1252>>2];g[a+1316>>2]=+g[a+1256>>2];g[a+1320>>2]=+g[a+1184>>2];g[a+1324>>2]=+g[a+1188>>2];g[a+1328>>2]=+g[a+1192>>2];return}function I4(a,b){a=a|0;b=b|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);if((b|0)<3){g[a+1308+(b<<2)>>2]=+g[a+1248+(b<<2)>>2];return}else{g[a+1308+(b<<2)>>2]=+g[a+1184+(b-3<<2)>>2];return}}function I5(b,c){b=b|0;c=c|0;do{if((a[43904]|0)==0){if((b1(43904)|0)==0){break}}}while(0);aDG(37416,b+1200+(c<<4)|0,16);return 37416}function I6(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}function I7(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function I8(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function I9(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}function Ja(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=a;f=a+40|0;g=b;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+56|0;f=b+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+72|0;g=b+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+88|0;f=b+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+104|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+120|0;f=d+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+136|0;g=d+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+152|0;f=d+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](e);aoZ(e,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function Jb(a){a=a|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function Jc(a,b,c){a=a|0;b=b|0;c=c|0;aoZ(a,b,c);return}function Jd(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,0)|0}function Je(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,m)|0}function Jf(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;nS(a,b,c,d);return}function Jg(a,b){a=a|0;b=+b;var c=0,d=0,e=0,f=0.0;c=i;i=i+16|0;d=c|0;e=a;g[d>>2]=1.0;g[d+4>>2]=0.0;g[d+8>>2]=b;g[d+12>>2]=0.0;a=0;while(1){if((a|0)>=3){break}b=+ck(+(+g[d+(a<<2)>>2]),6.2831854820251465);do{if(b<-3.1415927410125732){f=b+6.2831854820251465}else{if(b<=3.1415927410125732){f=b;break}f=b-6.2831854820251465}}while(0);g[e+860+(a<<6)>>2]=f;a=a+1|0}i=c;return}function Jh(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f);return}function Ji(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;apb(a,b,c,d,e,f,g,h);return}function Jj(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=a;a=0;while(1){if((a|0)>=3){break}d=+ck(+(+g[b+(a<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[c+860+(a<<6)>>2]=e;a=a+1|0}return}function Jk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function Jl(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Jm(b,d){b=b|0;d=+d;var e=0,f=0,h=0,i=0.0,j=0.0,k=0;d=1.0/+g[(c[b+116>>2]|0)+336>>2];e=b+136|0;if((c[e>>2]|0)<=0){return}f=b+144|0;b=0;do{h=c[f>>2]|0;do{if((a[h+(b*284|0)+84|0]&1)==0){g[h+(b*284|0)+276>>2]=0.0}else{i=+g[h+(b*284|0)+272>>2];j=d*(+g[h+(b*284|0)+216>>2]*(+g[h+(b*284|0)+204>>2]- +g[h+(b*284|0)+32>>2])*+g[h+(b*284|0)+268>>2]-i*+g[(i<0.0?h+(b*284|0)+220|0:h+(b*284|0)+224|0)>>2]);k=h+(b*284|0)+276|0;g[k>>2]=j;if(j>=0.0){break}g[k>>2]=0.0}}while(0);b=b+1|0;}while((b|0)<(c[e>>2]|0));return}function Jn(a){a=a|0;return c[a+116>>2]|0}function Jo(a){a=a|0;return c[a+88>>2]|0}function Jp(a,b){a=a|0;b=b|0;return(c[a+144>>2]|0)+(b*284|0)+92|0}function Jq(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Jr(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=a;a=0;while(1){if((a|0)>=3){break}d=+ck(+(+g[b+(a<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[c+860+(a<<6)+4>>2]=e;a=a+1|0}return}function Js(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a|0,b,d);return}function Jt(a,b){a=a|0;b=b|0;return ao$(a,b)|0}function Ju(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function Jv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+16>>2]&1023](a,b,d,e);return}function Jw(a,b,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return+(+cN[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,k,l))}function Jx(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a,b,d);return}function Jy(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0,z=0.0,A=0.0,B=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0.0,ap=0,aq=0,ar=0.0,as=0,at=0,au=0.0,av=0,aw=0,ax=0.0,ay=0,az=0,aA=0.0,aB=0,aC=0,aD=0.0;while(1){i=aDx(1428)|0;if((i|0)!=0){break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){k=4300;break}dC[j&63]()}if((k|0)==4300){k=cd(4)|0;c[k>>2]=19096;bF(k|0,34368,676);return 0}k=i;do{if((a[43040]|0)==0){if((b1(43040)|0)==0){break}do{if((a[43048]|0)==0){if((b1(43048)|0)==0){break}g[10704]=1.0;aDD(42820,0,16);g[10709]=1.0;aDD(42840,0,16);g[10714]=1.0;g[10715]=0.0}}while(0);c[10688]=c[10704];c[10689]=c[10705];c[10690]=c[10706];c[10691]=c[10707];c[10692]=c[10708];c[42772>>2]=c[42836>>2];c[42776>>2]=c[42840>>2];c[42780>>2]=c[42844>>2];c[10696]=c[10712];c[42788>>2]=c[42852>>2];c[42792>>2]=c[42856>>2];c[42796>>2]=c[42860>>2];aDD(42800,0,16)}}while(0);do{if((a[43040]|0)==0){if((b1(43040)|0)==0){break}do{if((a[43048]|0)==0){if((b1(43048)|0)==0){break}g[10704]=1.0;aDD(42820,0,16);g[10709]=1.0;aDD(42840,0,16);g[10714]=1.0;g[10715]=0.0}}while(0);c[10688]=c[10704];c[10689]=c[10705];c[10690]=c[10706];c[10691]=c[10707];c[10692]=c[10708];c[42772>>2]=c[42836>>2];c[42776>>2]=c[42840>>2];c[42780>>2]=c[42844>>2];c[10696]=c[10712];c[42788>>2]=c[42852>>2];c[42792>>2]=c[42856>>2];c[42796>>2]=c[42860>>2];aDD(42800,0,16)}}while(0);j=i;aoY(j,b,d,42752,42752,1);c[i+4>>2]=9;a[i+1301|0]=0;l=i+1308|0;g[l>>2]=0.0;g[i+1332>>2]=0.0;g[i+1356>>2]=1.0;a[i+1302|0]=0;m=i+1312|0;g[m>>2]=0.0;g[i+1336>>2]=0.0;g[i+1360>>2]=1.0;n=i+1303|0;a[n]=0;o=i+1316|0;g[o>>2]=0.0;p=i+1340|0;g[p>>2]=0.0;q=i+1364|0;g[q>>2]=1.0;a[i+1304|0]=0;r=i+1320|0;g[r>>2]=0.0;g[i+1344>>2]=0.0;g[i+1368>>2]=1.0;a[i+1305|0]=0;s=i+1324|0;g[s>>2]=0.0;g[i+1348>>2]=0.0;g[i+1372>>2]=1.0;a[i+1306|0]=0;t=i+1328|0;g[t>>2]=0.0;g[i+1352>>2]=0.0;g[i+1376>>2]=1.0;c[i>>2]=23296;u=i+1380|0;v=e;c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[u+12>>2]=c[v+12>>2];v=i+1396|0;u=f;c[v>>2]=c[u>>2];c[v+4>>2]=c[u+4>>2];c[v+8>>2]=c[u+8>>2];c[v+12>>2]=c[u+12>>2];u=i+1412|0;v=h;c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[u+12>>2]=c[v+12>>2];v=f|0;w=+g[v>>2];u=f+4|0;x=+g[u>>2];y=f+8|0;z=+g[y>>2];A=1.0/+Q(+(w*w+x*x+z*z));B=w*A;g[v>>2]=B;w=x*A;g[u>>2]=w;x=z*A;g[y>>2]=x;y=h|0;A=+g[y>>2];u=h+4|0;z=+g[u>>2];v=h+8|0;D=+g[v>>2];E=1.0/+Q(+(A*A+z*z+D*D));F=A*E;g[y>>2]=F;A=z*E;g[u>>2]=A;z=D*E;g[v>>2]=z;E=w*z-x*A;D=x*F-B*z;G=B*A-w*F;H=+g[e>>2];I=+g[e+4>>2];J=+g[e+8>>2];K=+g[b+4>>2];L=+g[b+20>>2];M=+g[b+36>>2];N=+g[b+8>>2];O=+g[b+24>>2];P=+g[b+40>>2];R=+g[b+12>>2];S=+g[b+28>>2];T=+g[b+44>>2];U=-0.0- +g[b+52>>2];V=-0.0- +g[b+56>>2];W=-0.0- +g[b+60>>2];g[i+40>>2]=F*K+A*L+z*M;g[i+44>>2]=E*K+D*L+G*M;g[i+48>>2]=B*K+w*L+x*M;g[i+52>>2]=0.0;g[i+56>>2]=F*N+A*O+z*P;g[i+60>>2]=E*N+D*O+G*P;g[i+64>>2]=B*N+w*O+x*P;g[i+68>>2]=0.0;g[i+72>>2]=F*R+A*S+z*T;g[i+76>>2]=E*R+D*S+G*T;g[i+80>>2]=B*R+w*S+x*T;g[i+84>>2]=0.0;g[i+88>>2]=H*K+I*L+J*M+(K*U+L*V+M*W);g[i+92>>2]=H*N+I*O+J*P+(N*U+O*V+P*W);g[i+96>>2]=H*R+I*S+J*T+(R*U+S*V+T*W);g[i+100>>2]=0.0;W=+g[d+4>>2];T=+g[d+20>>2];V=+g[d+36>>2];S=+g[d+8>>2];U=+g[d+24>>2];R=+g[d+40>>2];P=+g[d+12>>2];O=+g[d+28>>2];N=+g[d+44>>2];M=-0.0- +g[d+52>>2];L=-0.0- +g[d+56>>2];K=-0.0- +g[d+60>>2];g[i+104>>2]=F*W+A*T+z*V;g[i+108>>2]=E*W+D*T+G*V;g[i+112>>2]=B*W+w*T+x*V;g[i+116>>2]=0.0;g[i+120>>2]=F*S+A*U+z*R;g[i+124>>2]=E*S+D*U+G*R;g[i+128>>2]=B*S+w*U+x*R;g[i+132>>2]=0.0;g[i+136>>2]=F*P+A*O+z*N;g[i+140>>2]=E*P+D*O+G*N;g[i+144>>2]=B*P+w*O+x*N;g[i+148>>2]=0.0;g[i+152>>2]=H*W+I*T+J*V+(W*M+T*L+V*K);g[i+156>>2]=H*S+I*U+J*R+(S*M+U*L+R*K);g[i+160>>2]=H*P+I*O+J*N+(P*M+O*L+N*K);g[i+164>>2]=0.0;g[i+672>>2]=0.0;g[i+676>>2]=0.0;g[i+680>>2]=-1.0;g[i+684>>2]=0.0;g[i+688>>2]=0.0;g[i+692>>2]=0.0;g[i+696>>2]=1.0;g[i+700>>2]=0.0;K=+ck(1.0,6.2831854820251465);do{if(K<-3.1415927410125732){X=K+6.2831854820251465}else{if(K<=3.1415927410125732){X=K;break}X=K-6.2831854820251465}}while(0);g[i+860>>2]=X;X=+ck(0.0,6.2831854820251465);do{if(X<-3.1415927410125732){Y=X+6.2831854820251465}else{if(X<=3.1415927410125732){Y=X;break}Y=X-6.2831854820251465}}while(0);g[i+924>>2]=Y;Y=+ck(-.7853981852531433,6.2831854820251465);do{if(Y<-3.1415927410125732){Z=Y+6.2831854820251465}else{if(Y<=3.1415927410125732){Z=Y;break}Z=Y-6.2831854820251465}}while(0);g[i+988>>2]=Z;Z=+ck(-1.0,6.2831854820251465);do{if(Z<-3.1415927410125732){_=Z+6.2831854820251465}else{if(Z<=3.1415927410125732){_=Z;break}_=Z-6.2831854820251465}}while(0);g[i+864>>2]=_;_=+ck(0.0,6.2831854820251465);do{if(_<-3.1415927410125732){$=_+6.2831854820251465}else{if(_<=3.1415927410125732){$=_;break}$=_-6.2831854820251465}}while(0);g[i+928>>2]=$;$=+ck(.7853981852531433,6.2831854820251465);if($<-3.1415927410125732){aa=$+6.2831854820251465;ab=i+992|0;ac=ab;g[ac>>2]=aa;a[n]=1;ad=i+782|0;a[ad]=1;g[p>>2]=39.47842025756836;g[q>>2]=.009999999776482582;ae=i+24|0;af=ae;ag=c[af>>2]|0;ah=ag+4|0;ai=i+28|0;aj=ai;ak=c[aj>>2]|0;al=ak+4|0;aoZ(j,ah,al);am=i+1248|0;an=am;ao=+g[an>>2];g[l>>2]=ao;ap=i+1252|0;aq=ap;ar=+g[aq>>2];g[m>>2]=ar;as=i+1256|0;at=as;au=+g[at>>2];g[o>>2]=au;av=i+1184|0;aw=av;ax=+g[aw>>2];g[r>>2]=ax;ay=i+1188|0;az=ay;aA=+g[az>>2];g[s>>2]=aA;aB=i+1192|0;aC=aB;aD=+g[aC>>2];g[t>>2]=aD;return k|0}if($<=3.1415927410125732){aa=$;ab=i+992|0;ac=ab;g[ac>>2]=aa;a[n]=1;ad=i+782|0;a[ad]=1;g[p>>2]=39.47842025756836;g[q>>2]=.009999999776482582;ae=i+24|0;af=ae;ag=c[af>>2]|0;ah=ag+4|0;ai=i+28|0;aj=ai;ak=c[aj>>2]|0;al=ak+4|0;aoZ(j,ah,al);am=i+1248|0;an=am;ao=+g[an>>2];g[l>>2]=ao;ap=i+1252|0;aq=ap;ar=+g[aq>>2];g[m>>2]=ar;as=i+1256|0;at=as;au=+g[at>>2];g[o>>2]=au;av=i+1184|0;aw=av;ax=+g[aw>>2];g[r>>2]=ax;ay=i+1188|0;az=ay;aA=+g[az>>2];g[s>>2]=aA;aB=i+1192|0;aC=aB;aD=+g[aC>>2];g[t>>2]=aD;return k|0}aa=$-6.2831854820251465;ab=i+992|0;ac=ab;g[ac>>2]=aa;a[n]=1;ad=i+782|0;a[ad]=1;g[p>>2]=39.47842025756836;g[q>>2]=.009999999776482582;ae=i+24|0;af=ae;ag=c[af>>2]|0;ah=ag+4|0;ai=i+28|0;aj=ai;ak=c[aj>>2]|0;al=ak+4|0;aoZ(j,ah,al);am=i+1248|0;an=am;ao=+g[an>>2];g[l>>2]=ao;ap=i+1252|0;aq=ap;ar=+g[aq>>2];g[m>>2]=ar;as=i+1256|0;at=as;au=+g[at>>2];g[o>>2]=au;av=i+1184|0;aw=av;ax=+g[aw>>2];g[r>>2]=ax;ay=i+1188|0;az=ay;aA=+g[az>>2];g[s>>2]=aA;aB=i+1192|0;aC=aB;aD=+g[aC>>2];g[t>>2]=aD;return k|0}function Jz(a,b){a=a|0;b=b|0;c[a+88>>2]=b;return}function JA(a){a=a|0;return c[a+136>>2]|0}function JB(a){a=a|0;return c[a+120>>2]|0}function JC(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+252>>2]=b;return}function JD(a,b){a=a|0;b=b|0;return(c[a+144>>2]|0)+(b*284|0)|0}function JE(a){a=a|0;return(c[a+116>>2]|0)+4|0}function JF(a){a=a|0;var b=0,d=0,e=0,f=0.0,h=0.0;b=a+136|0;if((c[b>>2]|0)<=0){return}d=a+144|0;a=0;do{e=c[d>>2]|0;g[e+(a*284|0)+32>>2]=+g[e+(a*284|0)+204>>2];g[e+(a*284|0)+272>>2]=0.0;f=-0.0- +g[e+(a*284|0)+56>>2];h=-0.0- +g[e+(a*284|0)+60>>2];g[e+(a*284|0)>>2]=-0.0- +g[e+(a*284|0)+52>>2];g[e+(a*284|0)+4>>2]=f;g[e+(a*284|0)+8>>2]=h;g[e+(a*284|0)+12>>2]=0.0;g[e+(a*284|0)+268>>2]=1.0;a=a+1|0;}while((a|0)<(c[b>>2]|0));return}function JG(a,b){a=a|0;b=b|0;c[a+84>>2]=b;return}function JH(a){a=a|0;return c[a+128>>2]|0}function JI(a,b){a=a|0;b=b|0;return+(+g[(c[a+144>>2]|0)+(b*284|0)+232>>2])}function JJ(a){a=a|0;return c[a+84>>2]|0}function JK(a){a=a|0;return c[a+124>>2]|0}function JL(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function JM(a){a=a|0;return+(+g[a+112>>2])}function JN(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+256>>2]=b;return}function JO(a,b,d){a=a|0;b=+b;d=d|0;g[(c[a+144>>2]|0)+(d*284|0)+232>>2]=b;return}function JP(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function JQ(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function JR(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function JS(a){a=a|0;return+(+g[a+4>>2])}function JT(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function JU(a){a=a|0;return b[a+14>>1]|0}function JV(a){a=a|0;return a+56|0}function JW(a){a=a|0;return c[a+16>>2]|0}function JX(a){a=a|0;return a+40|0}function JY(a){a=a|0;return b[a+12>>1]|0}function JZ(a){a=a|0;return(c[a+8>>2]|0)!=0|0}function J_(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function J$(a){a=a|0;return c[a+8>>2]|0}function J0(a){a=a|0;return(c[a+4>>2]|0)==31|0}
function J1(b,d,e,f,h,j,k,l){b=b|0;d=d|0;e=e|0;f=f|0;h=+h;j=+j;k=k|0;l=l|0;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0;m=i;i=i+256|0;n=m+48|0;o=l&1;l=m|0;p=m+16|0;q=m+32|0;r=n;s=d;c[l>>2]=c[s>>2];c[l+4>>2]=c[s+4>>2];c[l+8>>2]=c[s+8>>2];c[l+12>>2]=c[s+12>>2];s=e;c[p>>2]=c[s>>2];c[p+4>>2]=c[s+4>>2];c[p+8>>2]=c[s+8>>2];c[p+12>>2]=c[s+12>>2];s=f;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];t=+g[k>>2];u=+g[k+4>>2];v=+g[k+8>>2];w=+g[k+16>>2];x=+g[k+12>>2];y=+g[k+20>>2];k=n+156|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];l=n+172|0;c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[l+12>>2]=c[p+12>>2];p=n+188|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];q=b+136|0;s=c[q>>2]|0;f=b+140|0;do{if((s|0)==(c[f>>2]|0)){e=(s|0)==0?1:s<<1;if((s|0)>=(e|0)){z=s;break}if((e|0)==0){A=0;B=s}else{c[9806]=(c[9806]|0)+1;d=aDx((e*284|0)+19|0)|0;if((d|0)==0){C=0}else{D=-(d+4|0)&15;c[d+D>>2]=d;C=d+(D+4)|0}A=C;B=c[q>>2]|0}D=b+144|0;if((B|0)>0){d=0;while(1){E=A+(d*284|0)|0;if((E|0)!=0){F=c[D>>2]|0;G=E;E=F+(d*284|0)|0;aDC(G|0,E|0,92)|0;E=A+(d*284|0)+92|0;G=F+(d*284|0)+92|0;c[E>>2]=c[G>>2];c[E+4>>2]=c[G+4>>2];c[E+8>>2]=c[G+8>>2];c[E+12>>2]=c[G+12>>2];G=A+(d*284|0)+108|0;E=F+(d*284|0)+108|0;c[G>>2]=c[E>>2];c[G+4>>2]=c[E+4>>2];c[G+8>>2]=c[E+8>>2];c[G+12>>2]=c[E+12>>2];E=A+(d*284|0)+124|0;G=F+(d*284|0)+124|0;c[E>>2]=c[G>>2];c[E+4>>2]=c[G+4>>2];c[E+8>>2]=c[G+8>>2];c[E+12>>2]=c[G+12>>2];G=A+(d*284|0)+140|0;E=F+(d*284|0)+140|0;c[G>>2]=c[E>>2];c[G+4>>2]=c[E+4>>2];c[G+8>>2]=c[E+8>>2];c[G+12>>2]=c[E+12>>2];E=A+(d*284|0)+156|0;G=F+(d*284|0)+156|0;c[E>>2]=c[G>>2];c[E+4>>2]=c[G+4>>2];c[E+8>>2]=c[G+8>>2];c[E+12>>2]=c[G+12>>2];G=A+(d*284|0)+172|0;E=F+(d*284|0)+172|0;c[G>>2]=c[E>>2];c[G+4>>2]=c[E+4>>2];c[G+8>>2]=c[E+8>>2];c[G+12>>2]=c[E+12>>2];E=A+(d*284|0)+188|0;G=F+(d*284|0)+188|0;c[E>>2]=c[G>>2];c[E+4>>2]=c[G+4>>2];c[E+8>>2]=c[G+8>>2];c[E+12>>2]=c[G+12>>2];g[A+(d*284|0)+204>>2]=+g[F+(d*284|0)+204>>2];g[A+(d*284|0)+208>>2]=+g[F+(d*284|0)+208>>2];g[A+(d*284|0)+212>>2]=+g[F+(d*284|0)+212>>2];g[A+(d*284|0)+216>>2]=+g[F+(d*284|0)+216>>2];g[A+(d*284|0)+220>>2]=+g[F+(d*284|0)+220>>2];g[A+(d*284|0)+224>>2]=+g[F+(d*284|0)+224>>2];g[A+(d*284|0)+228>>2]=+g[F+(d*284|0)+228>>2];g[A+(d*284|0)+232>>2]=+g[F+(d*284|0)+232>>2];g[A+(d*284|0)+236>>2]=+g[F+(d*284|0)+236>>2];g[A+(d*284|0)+240>>2]=+g[F+(d*284|0)+240>>2];g[A+(d*284|0)+244>>2]=+g[F+(d*284|0)+244>>2];g[A+(d*284|0)+248>>2]=+g[F+(d*284|0)+248>>2];g[A+(d*284|0)+252>>2]=+g[F+(d*284|0)+252>>2];g[A+(d*284|0)+256>>2]=+g[F+(d*284|0)+256>>2];a[A+(d*284|0)+260|0]=a[F+(d*284|0)+260|0]&1;c[A+(d*284|0)+264>>2]=c[F+(d*284|0)+264>>2];g[A+(d*284|0)+268>>2]=+g[F+(d*284|0)+268>>2];g[A+(d*284|0)+272>>2]=+g[F+(d*284|0)+272>>2];g[A+(d*284|0)+276>>2]=+g[F+(d*284|0)+276>>2];g[A+(d*284|0)+280>>2]=+g[F+(d*284|0)+280>>2]}F=d+1|0;if((F|0)<(B|0)){d=F}else{H=D;break}}}else{H=D}d=c[H>>2]|0;F=b+148|0;if((d|0)!=0){if((a[F]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[d-284+280>>2]|0)}c[H>>2]=0}a[F]=1;c[H>>2]=A;c[f>>2]=e;z=c[q>>2]|0}else{z=s}}while(0);s=b+144|0;f=c[s>>2]|0;A=f+(z*284|0)|0;if((A|0)==0){I=z;J=f;K=I+1|0;c[q>>2]=K;L=J+(I*284|0)|0;apO(b,L,0);M=c[q>>2]|0;N=M-1|0;apP(b,N,0);O=16;P=0;Q=16;R=0;S=16;T=0;U=204;V=0;i=m;return L|0}H=A;aDC(H|0,r|0,92)|0;r=f+(z*284|0)+92|0;H=n+92|0;c[r>>2]=c[H>>2];c[r+4>>2]=c[H+4>>2];c[r+8>>2]=c[H+8>>2];c[r+12>>2]=c[H+12>>2];H=f+(z*284|0)+108|0;r=n+108|0;c[H>>2]=c[r>>2];c[H+4>>2]=c[r+4>>2];c[H+8>>2]=c[r+8>>2];c[H+12>>2]=c[r+12>>2];r=f+(z*284|0)+124|0;H=n+124|0;c[r>>2]=c[H>>2];c[r+4>>2]=c[H+4>>2];c[r+8>>2]=c[H+8>>2];c[r+12>>2]=c[H+12>>2];H=f+(z*284|0)+140|0;r=n+140|0;c[H>>2]=c[r>>2];c[H+4>>2]=c[r+4>>2];c[H+8>>2]=c[r+8>>2];c[H+12>>2]=c[r+12>>2];r=f+(z*284|0)+156|0;c[r>>2]=c[k>>2];c[r+4>>2]=c[k+4>>2];c[r+8>>2]=c[k+8>>2];c[r+12>>2]=c[k+12>>2];k=f+(z*284|0)+172|0;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];l=f+(z*284|0)+188|0;c[l>>2]=c[p>>2];c[l+4>>2]=c[p+4>>2];c[l+8>>2]=c[p+8>>2];c[l+12>>2]=c[p+12>>2];g[f+(z*284|0)+204>>2]=h;g[f+(z*284|0)+208>>2]=x;g[f+(z*284|0)+212>>2]=j;g[f+(z*284|0)+216>>2]=t;g[f+(z*284|0)+220>>2]=u;g[f+(z*284|0)+224>>2]=v;g[f+(z*284|0)+228>>2]=w;g[f+(z*284|0)+232>>2]=0.0;g[f+(z*284|0)+236>>2]=0.0;g[f+(z*284|0)+240>>2]=0.0;g[f+(z*284|0)+244>>2]=.10000000149011612;g[f+(z*284|0)+248>>2]=y;g[f+(z*284|0)+252>>2]=0.0;g[f+(z*284|0)+256>>2]=0.0;a[f+(z*284|0)+260|0]=o;I=c[q>>2]|0;J=c[s>>2]|0;K=I+1|0;c[q>>2]=K;L=J+(I*284|0)|0;apO(b,L,0);M=c[q>>2]|0;N=M-1|0;apP(b,N,0);O=16;P=0;Q=16;R=0;S=16;T=0;U=204;V=0;i=m;return L|0}function J2(a,b){a=a|0;b=b|0;apP(a,b,1);return}function J3(a,b,c){a=a|0;b=b|0;c=c|0;apP(a,b,c);return}function J4(a,b){a=a|0;b=b|0;return+(+apQ(a,b))}function J5(b){b=b|0;var d=0,e=0,f=0.0,h=0.0;do{if((a[43824]|0)==0){if((b1(43824)|0)==0){break}}}while(0);d=c[b+116>>2]|0;e=c[b+128>>2]|0;f=+g[d+20+(e<<2)>>2];h=+g[d+36+(e<<2)>>2];g[9350]=+g[d+4+(e<<2)>>2];g[9351]=f;g[9352]=h;g[9353]=0.0;return 37400}function J6(a,b){a=a|0;b=b|0;apO(a,b,1);return}function J7(a,b,c){a=a|0;b=b|0;c=c|0;apO(a,b,c);return}function J8(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a,b,d,e);return}function J9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function Ka(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Kb(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+20>>2]&1023](a,b);return}function Kc(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+16>>2]&1023](a,b);return}function Kd(a,b,d){a=a|0;b=b|0;d=+d;dF[c[(c[a>>2]|0)+8>>2]&255](a,b,d);return}function Ke(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Kf(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a|0,b)|0}function Kg(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+12>>2]&127](a,b,d))}function Kh(a,b){a=a|0;b=b|0;var d=0;d=a+56|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ki(a,b){a=a|0;b=b|0;var d=0;d=a+40|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Kj(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function Kk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0;while(1){f=aDx(152)|0;if((f|0)!=0){h=4445;break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){break}dC[b&63]()}if((h|0)==4445){c[f>>2]=23912;a[f+20|0]=1;c[f+16>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;a[f+40|0]=1;c[f+36>>2]=0;c[f+28>>2]=0;c[f+32>>2]=0;a[f+60|0]=1;c[f+56>>2]=0;c[f+48>>2]=0;c[f+52>>2]=0;a[f+80|0]=1;c[f+76>>2]=0;c[f+68>>2]=0;c[f+72>>2]=0;c[f+100>>2]=e;g[f+104>>2]=0.0;a[f+148|0]=1;c[f+144>>2]=0;c[f+136>>2]=0;c[f+140>>2]=0;c[f+116>>2]=d;c[f+120>>2]=0;c[f+124>>2]=2;c[f+128>>2]=1;g[f+112>>2]=0.0;g[f+108>>2]=0.0;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function Kl(d,e){d=d|0;e=e|0;var f=0,h=0,i=0;while(1){f=aDx(132)|0;if((f|0)!=0){h=4457;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==4457){g[f+4>>2]=1.0;c[f+8>>2]=0;b[f+12>>1]=1;b[f+14>>1]=-1;c[f+16>>2]=0;c[f>>2]=19512;a[f+36|0]=1;c[f+32>>2]=0;c[f+24>>2]=0;c[f+28>>2]=0;h=f+40|0;i=d;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];i=f+56|0;h=e;c[i>>2]=c[h>>2];c[i+4>>2]=c[h+4>>2];c[i+8>>2]=c[h+8>>2];c[i+12>>2]=c[h+12>>2];a[f+88|0]=1;c[f+84>>2]=0;c[f+76>>2]=0;c[f+80>>2]=0;a[f+108|0]=1;c[f+104>>2]=0;c[f+96>>2]=0;c[f+100>>2]=0;a[f+128|0]=1;c[f+124>>2]=0;c[f+116>>2]=0;c[f+120>>2]=0;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function Km(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Kn(a){a=a|0;return c[a+52>>2]|0}function Ko(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Kp(a){a=a|0;return a+12|0}function Kq(a){a=a|0;return+(+g[a+44>>2])}function Kr(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Ks(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Kt(a){a=a|0;return c[a+8>>2]|0}function Ku(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Kv(a){a=a|0;return a+28|0}function Kw(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Kx(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Ky(a){a=a|0;return a+28|0}function Kz(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function KA(a){a=a|0;return c[a+4>>2]|0}function KB(a){a=a|0;return+(+g[a+4>>2])}function KC(a,c){a=a|0;c=c|0;b[a+12>>1]=c;return}function KD(a){a=a|0;return c[a+16>>2]|0}function KE(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function KF(a,c){a=a|0;c=c|0;b[a+14>>1]=c;return}function KG(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function KH(a){a=a|0;return(c[a+8>>2]|0)!=0|0}function KI(a){a=a|0;return b[a+14>>1]|0}function KJ(a){a=a|0;return b[a+12>>1]|0}function KK(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function KL(a){a=a|0;return c[a+8>>2]|0}function KM(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function KN(a){a=a|0;return(c[a+4>>2]|0)<7|0}function KO(a){a=a|0;return(c[a+4>>2]|0)==31|0}function KP(a){a=a|0;return c[a+12>>2]|0}function KQ(a){a=a|0;return(c[a+4>>2]|0)<20|0}function KR(a){a=a|0;return(c[a+4>>2]|0)==28|0}function KS(a){a=a|0;return c[a+8>>2]|0}function KT(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function KU(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function KV(a){a=a|0;return(c[a+4>>2]|0)==32|0}function KW(a){a=a|0;return+(+g[a+16>>2])}function KX(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43664]|0)==0){if((b1(43664)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9346]=c[d>>2];c[9347]=c[d+4>>2];c[9348]=c[d+8>>2];c[9349]=c[d+12>>2];i=e;return 37384}function KY(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function KZ(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function K_(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function K$(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function K0(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+84>>2]&1023](a))}function K1(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function K2(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function K3(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function K4(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43184]|0)==0){if((b1(43184)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9342]=c[d>>2];c[9343]=c[d+4>>2];c[9344]=c[d+8>>2];c[9345]=c[d+12>>2];i=e;return 37368}function K5(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43360]|0)==0){if((b1(43360)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9338]=c[d>>2];c[9339]=c[d+4>>2];c[9340]=c[d+8>>2];c[9341]=c[d+12>>2];i=e;return 37352}function K6(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function K7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function K8(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43504]|0)==0){if((b1(43504)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9334]=c[d>>2];c[9335]=c[d+4>>2];c[9336]=c[d+8>>2];c[9337]=c[d+12>>2];i=e;return 37336}function K9(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function La(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function Lb(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function Lc(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ld(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 1:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function Le(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Lf(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function Lg(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function Lh(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function Li(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,i=0.0;c[9806]=(c[9806]|0)+1;b=aDx(75)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;b=d|0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[b>>2]=24848;f=d+52|0;c[f>>2]=1;h=+g[a+4>>2]+-.03999999910593033;i=+g[a+8>>2]+-.03999999910593033;g[d+28>>2]=+g[a>>2]+-.03999999910593033;g[d+32>>2]=h;g[d+36>>2]=i;g[d+40>>2]=0.0;c[e>>2]=13;c[b>>2]=24256;c[f>>2]=0;return d|0}function Lj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function Lk(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function Ll(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function Lm(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0;do{if((a[43672]|0)==0){if((b1(43672)|0)==0){break}}}while(0);d=+g[b+28>>2];e=+g[b+32>>2];f=+g[b+36>>2];h=+g[b+40>>2];i=b|0;j=b;k=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);l=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);m=f+ +dh[c[(c[j>>2]|0)+44>>2]&1023](i);g[9330]=d+k;g[9331]=e+l;g[9332]=m;g[9333]=h;return 37320}function Ln(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+12>>2]&127](a,b,d))}function Lo(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a,b)|0}function Lp(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function Lq(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43560]|0)==0){if((b1(43560)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9326]=c[d>>2];c[9327]=c[d+4>>2];c[9328]=c[d+8>>2];c[9329]=c[d+12>>2];i=e;return 37304}function Lr(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function Ls(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function Lt(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a)|0}function Lu(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43376]|0)==0){if((b1(43376)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9322]=c[d>>2];c[9323]=c[d+4>>2];c[9324]=c[d+8>>2];c[9325]=c[d+12>>2];i=e;return 37288}function Lv(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function Lw(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function Lx(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Ly(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43112]|0)==0){if((b1(43112)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9318]=c[d>>2];c[9319]=c[d+4>>2];c[9320]=c[d+8>>2];c[9321]=c[d+12>>2];i=e;return 37272}function Lz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function LA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function LB(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function LC(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function LD(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function LE(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a,b,d);return}function LF(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function LG(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43232]|0)==0){if((b1(43232)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9302]=c[d>>2];c[9303]=c[d+4>>2];c[9304]=c[d+8>>2];c[9305]=c[d+12>>2];i=e;return 37208}function LH(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function LI(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function LJ(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function LK(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function LL(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function LM(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function LN(a){a=a|0;return c[a+4>>2]|0}function LO(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function LP(a){a=a|0;return a+16|0}function LQ(a){a=a|0;return a|0}function LR(a){a=a|0;return+(+g[a+32>>2])}function LS(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(d>=+g[c>>2]){return}g[c>>2]=d;return}function LT(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function LU(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function LV(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(+g[c>>2]>=d){return}g[c>>2]=d;return}function LW(a,b){a=a|0;b=b|0;var c=0;if(+g[a+12>>2]!=+g[b+12>>2]){c=0;return c|0}if(+g[a+8>>2]!=+g[b+8>>2]){c=0;return c|0}if(+g[a+4>>2]!=+g[b+4>>2]){c=0;return c|0}c=+g[a>>2]==+g[b>>2];return c|0}function LX(a){a=a|0;return+(+g[a>>2])}function LY(a){a=a|0;return+(+g[a+4>>2])}function LZ(a){a=a|0;return+(+g[a+8>>2])}function L_(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function L$(a){a=a|0;return+(+g[a+12>>2])}function L0(a){a=a|0;return+(+g[a+4>>2])}function L1(a){a=a|0;return+(+g[a>>2])}function L2(a){a=a|0;return+(+g[a+8>>2])}function L3(a,b){a=a|0;b=+b;g[a>>2]=b;return}function L4(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function L5(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function L6(a){a=a|0;return(c[a+4>>2]|0)==31|0}function L7(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function L8(a){a=a|0;return c[a+52>>2]|0}function L9(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Ma(a){a=a|0;return a+12|0}function Mb(a){a=a|0;return+(+g[a+44>>2])}function Mc(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Md(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Me(a){a=a|0;return c[a+8>>2]|0}function Mf(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Mg(a){a=a|0;return a+28|0}function Mh(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Mi(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Mj(a){a=a|0;return a+28|0}function Mk(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function Ml(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a,b,d,e);return}function Mm(a,b){a=a|0;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(39)|0;e=-(d+4|0)&15;c[d+e>>2]=d;f=d+(e+4)|0;c[f+8>>2]=0;c[f>>2]=22040;c[f+12>>2]=a;g[f+16>>2]=b;c[f+4>>2]=14;return f|0}function Mn(a){a=a|0;if((a|0)==0){return}aDB(a);return}function Mo(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Mp(a,b){a=a|0;b=b|0;var d=0;d=a;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Mq(a){a=a|0;if((a|0)==0){return}aDB(a);return}function Mr(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];return(a|0)!=0|0}function Ms(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function Mt(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43688]|0)==0){if((b1(43688)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9298]=c[d>>2];c[9299]=c[d+4>>2];c[9300]=c[d+8>>2];c[9301]=c[d+12>>2];i=e;return 37192}function Mu(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function Mv(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Mw(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function Mx(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+84>>2]&1023](a))}function My(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function Mz(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function MA(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function MB(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43200]|0)==0){if((b1(43200)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9294]=c[d>>2];c[9295]=c[d+4>>2];c[9296]=c[d+8>>2];c[9297]=c[d+12>>2];i=e;return 37176}function MC(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43384]|0)==0){if((b1(43384)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9290]=c[d>>2];c[9291]=c[d+4>>2];c[9292]=c[d+8>>2];c[9293]=c[d+12>>2];i=e;return 37160}function MD(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function ME(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function MF(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43528]|0)==0){if((b1(43528)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9286]=c[d>>2];c[9287]=c[d+4>>2];c[9288]=c[d+8>>2];c[9289]=c[d+12>>2];i=e;return 37144}function MG(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function MH(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function MI(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function MJ(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function MK(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 1:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function ML(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function MM(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function MN(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function MO(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function MP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function MQ(){var a=0,b=0,d=0;while(1){a=aDx(36)|0;if((a|0)!=0){b=4740;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==4740){g[a+32>>2]=-1.0;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function MR(){var a=0,b=0,d=0;while(1){a=aDx(16)|0;if((a|0)!=0){b=4752;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==4752){return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function MS(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0,h=0;while(1){e=aDx(16)|0;if((e|0)!=0){f=4764;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){break}dC[h&63]()}if((f|0)==4764){g[e>>2]=a;g[e+4>>2]=b;g[e+8>>2]=d;g[e+12>>2]=0.0;return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function MT(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0,i=0;while(1){f=aDx(16)|0;if((f|0)!=0){h=4776;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==4776){g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function MU(a){a=a|0;return(a|0)==31|0}function MV(a){a=a|0;return(a|0)<7|0}function MW(a){a=a|0;return(a|0)<20|0}function MX(a){a=a|0;return((a|0)>20&(a|0)<30?(a|0)!=25:0)|0}function MY(a){a=a|0;return(a|0)==32|0}function MZ(a){a=a|0;return(a|0)==28|0}function M_(a){a=a|0;return((a|0)>20?(a|0)<30:0)|0}function M$(a){a=a|0;return((a|0)==17?1:(a|0)==18)|0}function M0(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function M1(a){a=a|0;return c[a+4>>2]|0}function M2(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function M3(a){a=a|0;return+(+g[a+36>>2])}function M4(a){a=a|0;return a+20|0}function M5(a){a=a|0;return a+4|0}function M6(a){a=a|0;return c[a>>2]|0}function M7(a){a=a|0;return c[a+60>>2]|0}function M8(a,b){a=a|0;b=b|0;c[a+60>>2]=b;return}function M9(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Na(a){a=a|0;return c[a+48>>2]|0}function Nb(a){a=a|0;return a+16|0}function Nc(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Nd(a){a=a|0;return b[a+6>>1]|0}function Ne(a){a=a|0;return c[a+12>>2]|0}function Nf(a){a=a|0;return a+32|0}function Ng(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Nh(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function Ni(a){a=a|0;return c[a+12>>2]|0}function Nj(a,c){a=a|0;c=c|0;b[a+6>>1]=c;return}function Nk(a,b){a=a|0;b=b|0;c[a+48>>2]=b;return}function Nl(a){a=a|0;return c[a+8>>2]|0}function Nm(a){a=a|0;return b[a+4>>1]|0}function Nn(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function No(a,c){a=a|0;c=c|0;b[a+6>>1]=c;return}function Np(a){a=a|0;return b[a+6>>1]|0}function Nq(a){a=a|0;return b[a+4>>1]|0}function Nr(a){a=a|0;var b=0;b=a+124|0;a=(aa(c[b>>2]|0,1664525)|0)+1013904223|0;c[b>>2]=a;return a|0}function Ns(a){a=a|0;return c[a+124>>2]|0}function Nt(a,b){a=a|0;b=b|0;c[a+124>>2]=b;return}function Nu(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a+124|0;a=(aa(c[d>>2]|0,1664525)|0)+1013904223|0;c[d>>2]=a;do{if(b>>>0<65537){d=a>>>16^a;if(b>>>0>=257){e=d;break}f=d>>>8^d;if(b>>>0>=17){e=f;break}d=f>>>4^f;if(b>>>0>=5){e=d;break}f=d>>>2^d;if(b>>>0>=3){e=f;break}e=f>>>1^f}else{e=a}}while(0);return(e>>>0)%(b>>>0)|0|0}function Nv(a){a=a|0;return a+100|0}function Nw(a){a=a|0;return c[a+24>>2]|0}function Nx(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function Ny(a){a=a|0;return a+4|0}function Nz(a,b){a=a|0;b=b|0;c[a+88>>2]=b;c[a+96>>2]=0;return}function NA(a,b,d){a=a|0;b=b|0;d=d|0;c[a+88>>2]=b;c[a+96>>2]=d;return}function NB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;if(e){c[a+92>>2]=b}else{c[a+88>>2]=b}c[a+96>>2]=d;return}function NC(b){b=b|0;return(a[b+84|0]&1)!=0|0}function ND(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function NE(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function NF(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function NG(a){a=a|0;var b=0,d=0,e=0,f=0.0,h=0.0;c[9806]=(c[9806]|0)+1;b=aDx(75)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d>>2]=24848;c[d+52>>2]=1;f=+g[a+4>>2]+-.03999999910593033;h=+g[a+8>>2]+-.03999999910593033;g[d+28>>2]=+g[a>>2]+-.03999999910593033;g[d+32>>2]=f;g[d+36>>2]=h;g[d+40>>2]=0.0;c[e>>2]=13;return d|0}function NH(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0;do{if((a[43696]|0)==0){if((b1(43696)|0)==0){break}}}while(0);d=+g[b+28>>2];e=+g[b+32>>2];f=+g[b+36>>2];h=+g[b+40>>2];i=b|0;j=b;k=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);l=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);m=f+ +dh[c[(c[j>>2]|0)+44>>2]&1023](i);g[9282]=d+k;g[9283]=e+l;g[9284]=m;g[9285]=h;return 37128}function NI(a,b){a=a|0;b=b|0;var d=0;d=a+20|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function NJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+16>>2]&127](a,b,d,e);return}function NK(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function NL(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,d);return}function NM(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a|0,b,d);return}function NN(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function NO(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;c[9806]=(c[9806]|0)+1;h=aDx(83)|0;if((h|0)==0){i=0}else{j=-(h+4|0)&15;c[h+j>>2]=h;i=h+(j+4)|0}c[i>>2]=e;b[i+4>>1]=f;b[i+6>>1]=g;g=i+16|0;f=a;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=i+32|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[i+8>>2]=0;c[i+56>>2]=0;c[i+52>>2]=0;return i|0}function NP(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function NQ(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-64+60>>2]|0);return}function NR(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function NS(a,b,d,e,f,g,h,i){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;return+(+dq[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i))}function NT(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a|0,b)|0}function NU(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function NV(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function NW(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a|0,b,d);return}function NX(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+16>>2]&1023](a|0,b,d,e);return}function NY(a,b,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return+(+cN[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,k,l))}function NZ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+68>>2]&2047](a,b);return}function N_(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function N$(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a|0,b);return}function N0(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+80>>2]&2047](a,b);return}function N1(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+84>>2]&1023](a,b,d,e);return}function N2(a){a=a|0;ct[c[(c[a>>2]|0)+116>>2]&2047](a);return}function N3(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+124>>2]&2047](a|0,b);return}function N4(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function N5(a){a=a|0;ct[c[(c[a>>2]|0)+40>>2]&2047](a|0);return}function N6(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a|0,b,d,e);return}function N7(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function N8(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function N9(a){a=a|0;return cA[c[(c[a>>2]|0)+100>>2]&4095](a|0)|0}function Oa(a,b){a=a|0;b=b|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,1,-1);return}function Ob(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,-1);return}function Oc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a|0,b,d,e);return}function Od(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+88>>2]&2047](a,b);return}function Oe(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=e+32|0;j=c[b+192>>2]|0;dI[c[(c[j>>2]|0)+8>>2]&1023](j,b+4|0,f,g);c[h>>2]=21168;c[h+4>>2]=b;c[h+8>>2]=a;c[h+12>>2]=d;d=c[a+76>>2]|0;dI[c[(c[d>>2]|0)+28>>2]&1023](d,f,g,h|0);i=e;return}function Of(){var a=0,d=0,e=0;while(1){a=aDx(8)|0;if((a|0)!=0){d=4903;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==4903){b[a+4>>1]=1;b[a+6>>1]=-1;c[a>>2]=20096;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function Og(){var b=0,d=0,e=0;while(1){b=aDx(128)|0;if((b|0)!=0){d=4915;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==4915){c[b>>2]=19632;a[b+20|0]=1;c[b+16>>2]=0;c[b+8>>2]=0;c[b+12>>2]=0;a[b+40|0]=1;c[b+36>>2]=0;c[b+28>>2]=0;c[b+32>>2]=0;a[b+60|0]=1;c[b+56>>2]=0;c[b+48>>2]=0;c[b+52>>2]=0;a[b+80|0]=1;c[b+76>>2]=0;c[b+68>>2]=0;c[b+72>>2]=0;a[b+100|0]=1;c[b+96>>2]=0;c[b+88>>2]=0;c[b+92>>2]=0;a[b+120|0]=1;c[b+116>>2]=0;c[b+108>>2]=0;c[b+112>>2]=0;c[b+124>>2]=0;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function Oh(a){a=a|0;return c[a+8>>2]|0}function Oi(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function Oj(a){a=a|0;return c[a+96>>2]|0}function Ok(a){a=a|0;return c[a+76>>2]|0}function Ol(b,c){b=b|0;c=c|0;a[b+84|0]=c&1;return}function Om(a){a=a|0;return a+28|0}function On(a){a=a|0;return c[a+4>>2]|0}function Oo(a){a=a|0;return c[a+136>>2]|0}function Op(a){a=a|0;return c[a+140>>2]|0}function Oq(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Or(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Os(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Ot(a){a=a|0;return+(+g[a+44>>2])}function Ou(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function Ov(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function Ow(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function Ox(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;atO(a|0,b,c,d,e,0.0);return}function Oy(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;atO(a|0,b,c,d,e,f);return}function Oz(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+52>>2]&511](a|0,b,0);return}function OA(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d);return}function OB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+168|0;g=f|0;h=a+24|0;j=c[h>>2]|0;k=dE[c[(c[j>>2]|0)+8>>2]&127](j,b,d,0)|0;if((k|0)==0){i=f;return}c[g+4>>2]=0;c[g+136>>2]=b;c[g+140>>2]=d;j=g+8|0;l=b+4|0;aDD(g+144|0,-1|0,16);c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+24|0;j=b+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+40|0;l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+56|0;j=b+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+72|0;l=d+4|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+88|0;j=d+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+104|0;l=d+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+120|0;j=d+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[g>>2]=21728;c[g+160>>2]=e;co[c[(c[k>>2]|0)+8>>2]&255](k,b,d,a+28|0,g|0);ct[c[c[k>>2]>>2]&2047](k);g=c[h>>2]|0;cv[c[(c[g>>2]|0)+60>>2]&2047](g,k);i=f;return}function OC(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43832]|0)==0){if((b1(43832)|0)==0){break}}}while(0);cv[c[(c[b>>2]|0)+72>>2]&2047](e,b);b=e;c[9278]=c[b>>2];c[9279]=c[b+4>>2];c[9280]=c[b+8>>2];c[9281]=c[b+12>>2];i=d;return 37112}function OD(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;atG(a,b,c,d,e,f);return}function OE(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function OF(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function OG(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+132>>2]&2047](a|0,b);return}function OH(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+104>>2]&511](a|0,b)|0}function OI(a){a=a|0;return cA[c[(c[a>>2]|0)+96>>2]&4095](a)|0}function OJ(a,b){a=a|0;b=+b;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,1,.01666666753590107)|0}function OK(a,b,d){a=a|0;b=+b;d=d|0;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,.01666666753590107)|0}function OL(a,b,d,e){a=a|0;b=+b;d=d|0;e=+e;return dr[c[(c[a>>2]|0)+48>>2]&63](a,b,d,e)|0}function OM(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+128>>2]&2047](a|0,b);return}function ON(a){a=a|0;return cA[c[(c[a>>2]|0)+112>>2]&4095](a)|0}function OO(a,b){a=a|0;b=b|0;atC(a|0,b);return}function OP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+120>>2]&2047](a|0,b);return}function OQ(a){a=a|0;var b=0;b=c[a+76>>2]|0;return cA[c[(c[b>>2]|0)+36>>2]&4095](b)|0}function OR(a){a=a|0;ct[c[(c[a>>2]|0)+76>>2]&2047](a);return}function OS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function OT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+92>>2]&2047](a,b);return}function OU(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;atI(a,b,c,d,e,f,g,h);return}function OV(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function OW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+16>>2]&127](a,b,d,e);return}function OX(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,d);return}function OY(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a,b,d);return}function OZ(a){a=a|0;var b=0;b=c[a+4>>2]|0;if((c[b+1116>>2]|0)==0){return}if((c[b+1108>>2]|0)==(c[a+136>>2]|0)){ay6(b,a+8|0,a+72|0);return}else{ay6(b,a+72|0,a+8|0);return}}function O_(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function O$(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43616]|0)==0){if((b1(43616)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9274]=c[d>>2];c[9275]=c[d+4>>2];c[9276]=c[d+8>>2];c[9277]=c[d+12>>2];i=e;return 37096}function O0(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function O1(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;while(1){h=aDx(196)|0;if((h|0)!=0){i=5e3;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){i=4997;break}dC[j&63]()}if((i|0)==4997){j=cd(4)|0;c[j>>2]=19096;bF(j|0,34368,676);return 0}else if((i|0)==5e3){aty(h,b,d,f);c[h+88>>2]=0;c[h+92>>2]=0;c[h+96>>2]=0;g[h+100>>2]=.6000000238418579;g[h+104>>2]=1.0;g[h+108>>2]=.30000001192092896;g[h+116>>2]=0.0;g[h+124>>2]=20.0;c[h+120>>2]=10;g[h+132>>2]=.20000000298023224;g[h+136>>2]=.10000000149011612;g[h+140>>2]=0.0;g[h+128>>2]=1.0;c[h+144>>2]=0;g[h+148>>2]=-.019999999552965164;g[h+152>>2]=0.0;g[h+156>>2]=.8500000238418579;c[h+160>>2]=260;c[h+164>>2]=2;c[h+168>>2]=128;c[h>>2]=22176;c[h+172>>2]=e;a[h+176|0]=0;g[h+180>>2]=0.0;g[h+184>>2]=0.0;g[h+188>>2]=-10.0;g[h+192>>2]=0.0;return h|0}return 0}function O2(){var a=0,b=0,d=0,e=0;while(1){a=aDx(160)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=5011;break}dC[b&63]()}if((d|0)==5011){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=a;c[a>>2]=24e3;b=a+56|0;e=a+8|0;do{e=e+16|0;}while((e|0)!=(b|0));b=a+120|0;e=a+72|0;do{e=e+16|0;}while((e|0)!=(b|0));aDD(a+144|0,-1|0,16);return d|0}function O3(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;while(1){d=aDx(160)|0;if((d|0)!=0){e=5030;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==5030){c[d>>2]=24e3;c[d+4>>2]=0;e=d+8|0;f=d+72|0;c[d+136>>2]=a;c[d+140>>2]=b;g=a+4|0;aDD(d+144|0,-1|0,16);c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];g=d+24|0;e=a+20|0;c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];e=d+40|0;g=a+36|0;c[e>>2]=c[g>>2];c[e+4>>2]=c[g+4>>2];c[e+8>>2]=c[g+8>>2];c[e+12>>2]=c[g+12>>2];g=d+56|0;e=a+52|0;c[g>>2]=c[e>>2];c[g+4>>2]=c[e+4>>2];c[g+8>>2]=c[e+8>>2];c[g+12>>2]=c[e+12>>2];e=b+4|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=d+88|0;f=b+20|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=d+104|0;e=b+36|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=d+120|0;f=b+52|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function O4(a){a=a|0;return(c[a+4>>2]|0)<7|0}function O5(a,b){a=a|0;b=b|0;return+(+g[(c[a+120>>2]|0)+(b<<2)>>2])}function O6(a){a=a|0;return c[a+92>>2]|0}function O7(a){a=a|0;return a+12|0}function O8(a,b){a=a|0;b=b|0;return(c[a+100>>2]|0)+(b<<4)|0}function O9(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Pa(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Pb(a){a=a|0;return c[a+8>>2]|0}function Pc(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Pd(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Pe(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Pf(a){a=a|0;return a+28|0}function Pg(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Ph(a){a=a|0;return c[a+4>>2]|0}function Pi(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Pj(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;f=i;i=i+16|0;c[9806]=(c[9806]|0)+1;h=aDx(147)|0;if((h|0)==0){j=0}else{k=-(h+4|0)&15;c[h+k>>2]=h;j=h+(k+4)|0}k=j;h=f|0;l=j;c[j+8>>2]=0;g[j+12>>2]=1.0;g[j+16>>2]=1.0;g[j+20>>2]=1.0;g[j+24>>2]=0.0;g[j+44>>2]=.03999999910593033;g[j+52>>2]=1.0;g[j+56>>2]=1.0;g[j+60>>2]=1.0;g[j+64>>2]=0.0;g[j+68>>2]=-1.0;g[j+72>>2]=-1.0;g[j+76>>2]=-1.0;g[j+80>>2]=0.0;a[j+84|0]=0;c[j>>2]=23192;m=j+104|0;a[m]=1;n=j+100|0;c[n>>2]=0;o=j+92|0;c[o>>2]=0;p=j+96|0;c[p>>2]=0;q=j+124|0;a[q]=1;r=j+120|0;c[r>>2]=0;s=j+112|0;c[s>>2]=0;t=j+116|0;c[t>>2]=0;c[j+4>>2]=9;j=(e|0)>0;if(j){c[9806]=(c[9806]|0)+1;u=aDx((e<<4|4)+15|0)|0;if((u|0)==0){v=0}else{w=-(u+4|0)&15;c[u+w>>2]=u;v=u+(w+4)|0}w=c[o>>2]|0;if((w|0)>0){u=0;do{x=v+(u<<4)|0;if((x|0)!=0){y=x;x=(c[n>>2]|0)+(u<<4)|0;c[y>>2]=c[x>>2];c[y+4>>2]=c[x+4>>2];c[y+8>>2]=c[x+8>>2];c[y+12>>2]=c[x+12>>2]}u=u+1|0;}while((u|0)<(w|0))}w=c[n>>2]|0;if((w|0)!=0){if((a[m]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[w-16+12>>2]|0)}c[n>>2]=0}a[m]=1;c[n>>2]=v;c[p>>2]=e;p=0;m=v;while(1){v=m+(p<<4)|0;if((v|0)!=0){w=v;c[w>>2]=c[h>>2];c[w+4>>2]=c[h+4>>2];c[w+8>>2]=c[h+8>>2];c[w+12>>2]=c[h+12>>2]}w=p+1|0;if((w|0)>=(e|0)){break}p=w;m=c[n>>2]|0}z=c[s>>2]|0}else{z=0}c[o>>2]=e;if((z|0)<(e|0)){if((c[t>>2]|0)<(e|0)){if((e|0)==0){A=0;B=z}else{c[9806]=(c[9806]|0)+1;o=aDx((e<<2)+19|0)|0;if((o|0)==0){C=0}else{m=-(o+4|0)&15;c[o+m>>2]=o;C=o+(m+4)|0}A=C;B=c[s>>2]|0}if((B|0)>0){C=0;do{m=A+(C<<2)|0;if((m|0)!=0){g[m>>2]=+g[(c[r>>2]|0)+(C<<2)>>2]}C=C+1|0;}while((C|0)<(B|0))}B=c[r>>2]|0;if((B|0)!=0){if((a[q]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[B-4>>2]|0)}c[r>>2]=0}a[q]=1;c[r>>2]=A;c[t>>2]=e;D=z}else{D=z}do{z=(c[r>>2]|0)+(D<<2)|0;if((z|0)!=0){g[z>>2]=0.0}D=D+1|0;}while((D|0)<(e|0))}c[s>>2]=e;if(j){j=0;do{s=(c[n>>2]|0)+(j<<4)|0;D=b+(j<<4)|0;c[s>>2]=c[D>>2];c[s+4>>2]=c[D+4>>2];c[s+8>>2]=c[D+8>>2];c[s+12>>2]=c[D+12>>2];g[(c[r>>2]|0)+(j<<2)>>2]=+g[d+(j<<2)>>2];j=j+1|0;}while((j|0)<(e|0))}avA(l);i=f;return k|0}function Pk(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function Pl(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43440]|0)==0){if((b1(43440)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9270]=c[d>>2];c[9271]=c[d+4>>2];c[9272]=c[d+8>>2];c[9273]=c[d+12>>2];i=e;return 37080}function Pm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function Pn(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function Po(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Pp(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43144]|0)==0){if((b1(43144)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9266]=c[d>>2];c[9267]=c[d+4>>2];c[9268]=c[d+8>>2];c[9269]=c[d+12>>2];i=e;return 37064}function Pq(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Pr(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function Ps(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function Pt(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function Pu(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function Pv(a){a=a|0;avA(a|0);return}function Pw(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function Px(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function Py(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Pz(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43312]|0)==0){if((b1(43312)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9258]=c[d>>2];c[9259]=c[d+4>>2];c[9260]=c[d+8>>2];c[9261]=c[d+12>>2];i=e;return 37032}function PA(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 1:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function PB(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function PC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function PD(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function PE(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function PF(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function PG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function PH(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function PI(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function PJ(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function PK(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function PL(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function PM(a,b,d,e,f,h,i){a=a|0;b=b|0;d=d|0;e=+e;f=f|0;h=h|0;i=i|0;var j=0,k=0,l=0;while(1){j=aDx(124)|0;if((j|0)!=0){k=5158;break}l=(C=c[10744]|0,c[10744]=C+0,C);if((l|0)==0){break}dC[l&63]()}if((k|0)==5158){k=j;c[j+4>>2]=35;c[j+8>>2]=0;g[j+12>>2]=0.0;c[j>>2]=20552;ax$(k,a,b,d,e/65535.0,0.0,e,f,h?0:5,i);return k|0}k=cd(4)|0;c[k>>2]=19096;bF(k|0,34368,676);return 0}function PN(a,b,d,e,f,h,i,j,k){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0;while(1){l=aDx(124)|0;if((l|0)!=0){m=5170;break}n=(C=c[10744]|0,c[10744]=C+0,C);if((n|0)==0){break}dC[n&63]()}if((m|0)==5170){m=l;c[l+4>>2]=35;c[l+8>>2]=0;g[l+12>>2]=0.0;c[l>>2]=20552;ax$(m,a,b,d,e,f,h,i,j,k);return m|0}m=cd(4)|0;c[m>>2]=19096;bF(m|0,34368,676);return 0}function PO(a){a=a|0;return(c[a+4>>2]|0)==31|0}function PP(a){a=a|0;return(c[a+4>>2]|0)<7|0}function PQ(b){b=b|0;a[b+101|0]=1;return}function PR(b,c){b=b|0;c=c|0;a[b+101|0]=c&1;return}function PS(a){a=a|0;return(c[a+4>>2]|0)<20|0}function PT(a){a=a|0;return(c[a+4>>2]|0)==28|0}function PU(a){a=a|0;return c[a+8>>2]|0}function PV(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function PW(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function PX(a){a=a|0;return(c[a+4>>2]|0)==32|0}function PY(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function PZ(a){a=a|0;return c[a+4>>2]|0}function P_(a){a=a|0;return(c[a+4>>2]|0)==31|0}function P$(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function P0(a){a=a|0;return+(+g[a+44>>2])}function P1(a){a=a|0;return(c[a+4>>2]|0)<7|0}function P2(a){a=a|0;return a+12|0}function P3(a){a=a|0;return(c[a+4>>2]|0)<20|0}function P4(a){a=a|0;return(c[a+4>>2]|0)==28|0}function P5(a){a=a|0;return c[a+8>>2]|0}function P6(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function P7(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function P8(a){a=a|0;return(c[a+4>>2]|0)==32|0}function P9(a){a=a|0;return a+28|0}function Qa(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Qb(a){a=a|0;return c[a+4>>2]|0}function Qc(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Qd(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Qe(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Qf(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Qg(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Qh(a){a=a|0;return c[a+8>>2]|0}function Qi(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Qj(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Qk(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Ql(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function Qm(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Qn(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function Qo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function Qp(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function Qq(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function Qr(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function Qs(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Qt(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function Qu(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function Qv(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function Qw(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function Qx(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function Qy(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43288]|0)==0){if((b1(43288)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9254]=c[d>>2];c[9255]=c[d+4>>2];c[9256]=c[d+8>>2];c[9257]=c[d+12>>2];i=e;return 37016}function Qz(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function QA(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function QB(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function QC(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43136]|0)==0){if((b1(43136)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9250]=c[d>>2];c[9251]=c[d+4>>2];c[9252]=c[d+8>>2];c[9253]=c[d+12>>2];i=e;return 37e3}function QD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function QE(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function QF(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function QG(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43072]|0)==0){if((b1(43072)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9246]=c[d>>2];c[9247]=c[d+4>>2];c[9248]=c[d+8>>2];c[9249]=c[d+12>>2];i=e;return 36984}function QH(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function QI(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function QJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function QK(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function QL(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function QM(a){a=a|0;avA(a);return}function QN(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function QO(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function QP(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43096]|0)==0){if((b1(43096)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9242]=c[d>>2];c[9243]=c[d+4>>2];c[9244]=c[d+8>>2];c[9245]=c[d+12>>2];i=e;return 36968}function QQ(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 0:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 10:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function QR(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function QS(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function QT(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function QU(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function QV(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function QW(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function QX(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function QY(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function QZ(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43736]|0)==0){if((b1(43736)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9238]=c[d>>2];c[9239]=c[d+4>>2];c[9240]=c[d+8>>2];c[9241]=c[d+12>>2];i=e;return 36952}function Q_(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function Q$(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function Q0(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a)|0}function Q1(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43592]|0)==0){if((b1(43592)|0)==0){break}}}while(0);avC(f,b,d);d=f;c[9234]=c[d>>2];c[9235]=c[d+4>>2];c[9236]=c[d+8>>2];c[9237]=c[d+12>>2];i=e;return 36936}function Q2(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a,b,c,d);return}function Q3(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function Q4(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function Q5(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43272]|0)==0){if((b1(43272)|0)==0){break}}}while(0);avB(f,b,d);d=f;c[9230]=c[d>>2];c[9231]=c[d+4>>2];c[9232]=c[d+8>>2];c[9233]=c[d+12>>2];i=e;return 36920}function Q6(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function Q7(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function Q8(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function Q9(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function Ra(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a,b,d);return}function Rb(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function Rc(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43432]|0)==0){if((b1(43432)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9226]=c[d>>2];c[9227]=c[d+4>>2];c[9228]=c[d+8>>2];c[9229]=c[d+12>>2];i=e;return 36904}function Rd(a){a=a|0;var b=0.0;switch(c[a+4>>2]|0){case 13:{b=+g[a+44>>2];break};case 8:{b=+g[a+28>>2]*+g[a+12>>2];break};case 1:{b=+g[a+44>>2];break};case 0:{b=+g[a+44>>2];break};case 10:{b=+g[a+44>>2];break};case 5:case 4:{b=+g[a+44>>2];break};default:{b=+dh[c[(c[a>>2]|0)+44>>2]&1023](a)}}return+b}function Re(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function Rf(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function Rg(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function Rh(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function Ri(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function Rj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a,b,d,e);return}function Rk(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Rl(a){a=a|0;return c[a+4>>2]|0}function Rm(a,b){a=a|0;b=b|0;c[a+20>>2]=b;return}function Rn(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Ro(a){a=a|0;return c[a+20>>2]|0}function Rp(a){a=a|0;return c[a+4>>2]|0}function Rq(a,b){a=a|0;b=b|0;c[a+28>>2]=b;return}function Rr(a){a=a|0;return c[a+24>>2]|0}function Rs(a,b){a=a|0;b=b|0;c[a+24>>2]=b;return}function Rt(a){a=a|0;return c[a+16>>2]|0}function Ru(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Rv(a){a=a|0;return c[a+28>>2]|0}function Rw(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Rx(a){a=a|0;return c[a+8>>2]|0}function Ry(a){a=a|0;return c[a>>2]|0}function Rz(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function RA(a){a=a|0;return c[a+12>>2]|0}function RB(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function RC(a){a=a|0;return a+32|0}function RD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;co[c[(c[a>>2]|0)+8>>2]&255](a,b,d,e,0);return}function RE(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+8>>2]&255](a,b,d,e,f);return}function RF(a){a=a|0;if((a|0)==0){return}aDB(a);return}function RG(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+56>>2]&511](a,b)|0}function RH(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+40>>2]&511](a,b)|0}function RI(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function RJ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function RK(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function RL(a){a=a|0;return cA[c[(c[a>>2]|0)+44>>2]&4095](a)|0}function RM(a,b,d){a=a|0;b=b|0;d=d|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,0)|0}function RN(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function RO(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+28>>2]&511](a,b,d)|0}function RP(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+12>>2]&511](a,b,d)|0}function RQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function RR(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function RS(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+24>>2]&511](a,b,d)|0}function RT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function RU(a){a=a|0;if((a|0)==0){return}aDB(a);return}function RV(a,b){a=a|0;b=b|0;var d=0;d=a;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function RW(){var a=0,b=0,d=0;while(1){a=aDx(32)|0;if((a|0)!=0){b=5374;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==5374){c[a>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=4096;c[a+16>>2]=4096;c[a+20>>2]=0;c[a+24>>2]=0;c[a+28>>2]=1;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function RX(){var a=0,b=0,d=0;while(1){a=aDx(84)|0;if((a|0)!=0){b=5386;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==5386){return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function RY(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;while(1){f=aDx(84)|0;if((f|0)!=0){h=5398;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==5398){h=f+16|0;i=a;aDD(f|0,0,16);c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];j=-0.0- +g[b>>2];k=-0.0- +g[b+4>>2];l=-0.0- +g[b+8>>2];g[f+32>>2]=j;g[f+36>>2]=k;g[f+40>>2]=l;g[f+44>>2]=0.0;m=+g[h>>2];n=+g[d>>2]*m;o=+g[f+20>>2];p=+g[d+4>>2]*o;q=+g[f+24>>2];r=+g[d+8>>2]*q;g[f+48>>2]=n;g[f+52>>2]=p;g[f+56>>2]=r;g[f+60>>2]=0.0;s=+g[e>>2]*j;t=+g[e+4>>2]*k;u=+g[e+8>>2]*l;g[f+64>>2]=s;g[f+68>>2]=t;g[f+72>>2]=u;g[f+76>>2]=0.0;g[f+80>>2]=n*m+p*o+r*q+(s*j+t*k+u*l);return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function RZ(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0.0,l=0.0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0;while(1){h=aDx(84)|0;if((h|0)!=0){i=5410;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==5410){aDD(h|0,0,16);i=a|0;k=+g[i>>2];j=a+4|0;l=+g[j>>2];m=a+8|0;n=+g[m>>2];o=+g[b>>2]*k+ +g[b+4>>2]*l+ +g[b+8>>2]*n;p=+g[b+16>>2]*k+ +g[b+20>>2]*l+ +g[b+24>>2]*n;q=+g[b+32>>2]*k+ +g[b+36>>2]*l+ +g[b+40>>2]*n;g[h+16>>2]=o;g[h+20>>2]=p;g[h+24>>2]=q;g[h+28>>2]=0.0;n=-0.0- +g[i>>2];l=-0.0- +g[j>>2];k=-0.0- +g[m>>2];r=+g[d>>2]*n+ +g[d+4>>2]*l+ +g[d+8>>2]*k;s=+g[d+16>>2]*n+ +g[d+20>>2]*l+ +g[d+24>>2]*k;t=+g[d+32>>2]*n+ +g[d+36>>2]*l+ +g[d+40>>2]*k;g[h+32>>2]=r;g[h+36>>2]=s;g[h+40>>2]=t;g[h+44>>2]=0.0;k=+g[e>>2]*o;l=+g[e+4>>2]*p;n=+g[e+8>>2]*q;g[h+48>>2]=k;g[h+52>>2]=l;g[h+56>>2]=n;g[h+60>>2]=0.0;u=+g[f>>2]*r;v=+g[f+4>>2]*s;w=+g[f+8>>2]*t;g[h+64>>2]=u;g[h+68>>2]=v;g[h+72>>2]=w;g[h+76>>2]=0.0;g[h+80>>2]=k*o+l*p+n*q+(u*r+v*s+w*t);return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function R_(a,b,d,e,f,h){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=+h;var i=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,D=0.0,E=0.0;while(1){i=aDx(84)|0;if((i|0)!=0){j=5422;break}k=(C=c[10744]|0,c[10744]=C+0,C);if((k|0)==0){break}dC[k&63]()}if((j|0)==5422){j=e;c[i>>2]=c[j>>2];c[i+4>>2]=c[j+4>>2];c[i+8>>2]=c[j+8>>2];c[i+12>>2]=c[j+12>>2];l=+g[b+4>>2];j=e+8|0;m=+g[j>>2];n=+g[b+8>>2];k=e+4|0;o=+g[k>>2];p=l*m-n*o;q=e|0;r=+g[q>>2];s=+g[b>>2];t=n*r-s*m;m=s*o-l*r;b=a|0;e=a+4|0;u=a+8|0;r=+g[b>>2]*p+ +g[e>>2]*t+ +g[u>>2]*m;v=a+16|0;w=a+20|0;x=a+24|0;l=+g[v>>2]*p+ +g[w>>2]*t+ +g[x>>2]*m;y=a+32|0;z=a+36|0;A=a+40|0;o=+g[y>>2]*p+ +g[z>>2]*t+ +g[A>>2]*m;g[i+16>>2]=r;g[i+20>>2]=l;g[i+24>>2]=o;g[i+28>>2]=0.0;m=-0.0- +g[q>>2];t=-0.0- +g[k>>2];p=-0.0- +g[j>>2];s=+g[d+4>>2];n=+g[d+8>>2];B=s*p-n*t;D=+g[d>>2];E=n*m-D*p;p=D*t-s*m;m=+g[v>>2]*B+ +g[w>>2]*E+ +g[x>>2]*p;s=+g[y>>2]*B+ +g[z>>2]*E+ +g[A>>2]*p;g[i+32>>2]=+g[b>>2]*B+ +g[e>>2]*E+ +g[u>>2]*p;g[i+36>>2]=m;g[i+40>>2]=s;g[i+44>>2]=0.0;s=+g[f>>2]*r;m=+g[f+4>>2]*l;p=+g[f+8>>2]*o;g[i+48>>2]=s;g[i+52>>2]=m;g[i+56>>2]=p;aDD(i+60|0,0,20);g[i+80>>2]=s*r+m*l+p*o+h;return i|0}i=cd(4)|0;c[i>>2]=19096;bF(i|0,34368,676);return 0}function R$(a){a=a|0;return a|0}function R0(a){a=a|0;return+(+g[a+80>>2])}function R1(a,b){a=a|0;b=+b;g[a+80>>2]=b;return}function R2(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;return+(+g[c>>2]*+g[a+16>>2]+ +g[e>>2]*+g[a+32>>2]+(+g[b>>2]- +g[d>>2])*+g[a>>2]+(+g[c+4>>2]*+g[a+20>>2]+ +g[e+4>>2]*+g[a+36>>2]+(+g[b+4>>2]- +g[d+4>>2])*+g[a+4>>2])+(+g[c+8>>2]*+g[a+24>>2]+ +g[e+8>>2]*+g[a+40>>2]+(+g[b+8>>2]- +g[d+8>>2])*+g[a+8>>2])+1.1920928955078125e-7)}function R3(a){a=a|0;return+(+g[a+80>>2])}function R4(a,b,c){a=a|0;b=b|0;c=+c;return+((+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2])*c+(+g[a+48>>2]*+g[b+16>>2]+ +g[a+52>>2]*+g[b+20>>2]+ +g[a+56>>2]*+g[b+24>>2]))}function R5(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0;e=+g[a>>2]*+g[b>>2];f=+g[a+4>>2]*+g[b+4>>2];h=+g[a+8>>2]*+g[b+8>>2];return+(+g[a+48>>2]*+g[b+16>>2]+ +g[a+64>>2]*+g[b+32>>2]+e*c+e*d+(+g[a+52>>2]*+g[b+20>>2]+ +g[a+68>>2]*+g[b+36>>2]+f*c+f*d)+(+g[a+56>>2]*+g[b+24>>2]+ +g[a+72>>2]*+g[b+40>>2]+h*c+h*d))}function R6(a){a=a|0;return a+48|0}function R7(a){a=a|0;return a+16|0}function R8(a){a=a|0;return a+64|0}function R9(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function Sa(a,b){a=a|0;b=b|0;return(c[a>>2]|0)==(c[b>>2]|0)|0}function Sb(a){a=a|0;return c[a>>2]|0}function Sc(a){a=a|0;var b=0;b=c[a>>2]|0;a=b+~(b<<15)|0;b=(a^a>>10)*9|0;a=b^b>>6;b=a+~(a<<11)|0;return b^b>>16|0}function Sd(b){b=b|0;return(a[b+4|0]&1)!=0|0}function Se(b,c){b=b|0;c=c|0;a[b+4|0]=c&1;return}function Sf(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function Sg(a){a=a|0;return c[a+24>>2]|0}function Sh(a){a=a|0;return a+28|0}function Si(a){a=a|0;return a+4|0}function Sj(b){b=b|0;return(a[b+84|0]&1)!=0|0}function Sk(a){a=a|0;return c[a+8>>2]|0}function Sl(a){a=a|0;return c[a+76>>2]|0}function Sm(b,c){b=b|0;c=c|0;a[b+84|0]=c&1;return}function Sn(b,d){b=b|0;d=d|0;var e=0;do{if((c[b+176+(d<<2)>>2]|0)==0){if((a[b+108+d|0]&1)==0){e=0}else{break}return e|0}}while(0);e=1;return e|0}function So(a){a=a|0;return a+144|0}function Sp(a){a=a|0;return a+160|0}function Sq(a){a=a|0;return a+76|0}function Sr(a){a=a|0;return a+92|0}function Ss(a){a=a|0;return a|0}function St(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Su(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Sv(a,b){a=a|0;b=b|0;var d=0;d=a+64|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Sw(a,b){a=a|0;b=b|0;var d=0;d=a+48|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Sx(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+8>>2]&511](a,b,d)|0}function Sy(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e)|0}function Sz(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+16>>2]&511](a,b,d);return}function SA(a){a=a|0;if((a|0)==0){return}aDB(a);return}function SB(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function SC(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function SD(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a,b);return}function SE(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0}function SF(a){a=a|0;ct[c[(c[a>>2]|0)+40>>2]&2047](a);return}function SG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+24>>2]&1023](a,b,d,e);return}function SH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a,b,d,e);return}function SI(a,b){a=a|0;b=b|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,1,-1);return}function SJ(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,-1);return}function SK(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function SL(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+48|0;f=e|0;g=e+16|0;h=e+32|0;j=c[b+192>>2]|0;dI[c[(c[j>>2]|0)+8>>2]&1023](j,b+4|0,f,g);c[h>>2]=21168;c[h+4>>2]=b;c[h+8>>2]=a;c[h+12>>2]=d;d=c[a+76>>2]|0;dI[c[(c[d>>2]|0)+28>>2]&1023](d,f,g,h|0);i=e;return}function SM(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function SN(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function SO(a){a=a|0;ct[c[(c[a>>2]|0)+20>>2]&2047](a);return}function SP(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;atO(a,b,c,d,e,0.0);return}function SQ(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;atO(a,b,c,d,e,f);return}function SR(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+168|0;g=f|0;h=a+24|0;j=c[h>>2]|0;k=dE[c[(c[j>>2]|0)+8>>2]&127](j,b,d,0)|0;if((k|0)==0){i=f;return}c[g+4>>2]=0;c[g+136>>2]=b;c[g+140>>2]=d;j=g+8|0;l=b+4|0;aDD(g+144|0,-1|0,16);c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+24|0;j=b+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+40|0;l=b+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+56|0;j=b+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+72|0;l=d+4|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+88|0;j=d+20|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];j=g+104|0;l=d+36|0;c[j>>2]=c[l>>2];c[j+4>>2]=c[l+4>>2];c[j+8>>2]=c[l+8>>2];c[j+12>>2]=c[l+12>>2];l=g+120|0;j=d+52|0;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];c[g>>2]=21728;c[g+160>>2]=e;co[c[(c[k>>2]|0)+8>>2]&255](k,b,d,a+28|0,g|0);ct[c[c[k>>2]>>2]&2047](k);g=c[h>>2]|0;cv[c[(c[g>>2]|0)+60>>2]&2047](g,k);i=f;return}function SS(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;atG(a,b,c,d,e,f);return}function ST(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function SU(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;atI(a,b,c,d,e,f,g,h);return}function SV(a,b){a=a|0;b=b|0;atC(a,b);return}function SW(a){a=a|0;var b=0;b=c[a+76>>2]|0;return cA[c[(c[b>>2]|0)+36>>2]&4095](b)|0}function SX(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function SY(a,b){a=a|0;b=b|0;var d=0;d=a+144|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function SZ(a,b){a=a|0;b=b|0;var d=0;d=a+76|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function S_(a,b){a=a|0;b=b|0;var d=0;d=a+92|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function S$(a,b){a=a|0;b=b|0;var d=0;d=a+128|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function S0(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=+h;i=i|0;j=+j;var k=0,l=0,m=0;while(1){k=aDx(84)|0;if((k|0)!=0){l=5520;break}m=(C=c[10744]|0,c[10744]=C+0,C);if((m|0)==0){break}dC[m&63]()}if((l|0)==5520){l=k;anz(l,a,b,d,e,f,g,h,i,j);return l|0}l=cd(4)|0;c[l>>2]=19096;bF(l|0,34368,676);return 0}function S1(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(4)|0;if((b|0)!=0){d=5532;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==5532){c[b>>2]=a;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function S2(){var b=0,d=0,e=0;while(1){b=aDx(8)|0;if((b|0)!=0){d=5544;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==5544){c[b>>2]=19992;a[b+4|0]=0;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function S3(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;while(1){e=aDx(88)|0;if((e|0)!=0){f=5556;break}g=(C=c[10744]|0,c[10744]=C+0,C);if((g|0)==0){f=5553;break}dC[g&63]()}if((f|0)==5553){g=cd(4)|0;c[g>>2]=19096;bF(g|0,34368,676);return 0}else if((f|0)==5556){f=e;aty(f,a,b,d);return f|0}return 0}function S4(a,b,d){a=a|0;b=b|0;d=+d;var e=0.0,f=0.0,h=0,i=0;e=+g[a+(b<<2)>>2];f=+g[a+16+(b<<2)>>2];if(e>f){c[a+176+(b<<2)>>2]=0;g[a+144+(b<<2)>>2]=0.0;h=0;return h|0}if(e>d){c[a+176+(b<<2)>>2]=2;g[a+144+(b<<2)>>2]=d-e;h=2;return h|0}i=a+176+(b<<2)|0;if(f<d){c[i>>2]=1;g[a+144+(b<<2)>>2]=d-f;h=1;return h|0}else{c[i>>2]=0;g[a+144+(b<<2)>>2]=0.0;h=0;return h|0}return 0}function S5(a,b){a=a|0;b=+b;g[a+56>>2]=b;return}function S6(a,b){a=a|0;b=+b;g[a+48>>2]=b;return}function S7(a){a=a|0;return+(+g[a+56>>2])}function S8(a){a=a|0;return a+112|0}function S9(a){a=a|0;return a+128|0}function Ta(a,b){a=a|0;b=+b;g[a+52>>2]=b;return}function Tb(a){a=a|0;return a+16|0}function Tc(a){a=a|0;return+(+g[a+52>>2])}function Td(a){a=a|0;return a+60|0}function Te(a,b){a=a|0;b=b|0;return+g[a+16+(b<<2)>>2]>=+g[a+(b<<2)>>2]|0}function Tf(a){a=a|0;return a+32|0}function Tg(a){a=a|0;return+(+g[a+48>>2])}function Th(a,b,c,d,e,f,h,i,j,k){a=a|0;b=+b;c=+c;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0,t=0,u=0,v=0,w=0.0,x=0,y=0.0,z=0,A=0,B=0,C=0,D=0.0,E=0,F=0.0,G=0,H=0.0,I=0,J=0.0,K=0,L=0.0,M=0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;l=+g[k>>2];m=l- +g[d+52>>2];n=+g[k+4>>2];o=n- +g[d+56>>2];p=+g[k+8>>2];q=p- +g[d+60>>2];r=l- +g[f+52>>2];l=n- +g[f+56>>2];n=p- +g[f+60>>2];k=d+504|0;s=d+508|0;t=d+512|0;u=d+520|0;p=+g[d+320>>2]+ +g[u>>2];v=d+524|0;w=+g[d+324>>2]+ +g[v>>2];x=d+528|0;y=+g[d+328>>2]+ +g[x>>2];z=f+504|0;A=f+508|0;B=f+512|0;C=f+520|0;D=+g[f+320>>2]+ +g[C>>2];E=f+524|0;F=+g[f+324>>2]+ +g[E>>2];G=f+528|0;H=+g[f+328>>2]+ +g[G>>2];I=j|0;J=+g[I>>2];K=j+4|0;L=+g[K>>2];M=j+8|0;N=+g[M>>2];O=N*(+g[d+312>>2]+ +g[t>>2]+(o*p-m*w)-(+g[f+312>>2]+ +g[B>>2]+(l*D-r*F)))+(J*(+g[d+304>>2]+ +g[k>>2]+(q*w-o*y)-(+g[f+304>>2]+ +g[z>>2]+(n*F-l*H)))+L*(+g[d+308>>2]+ +g[s>>2]+(m*y-q*p)-(+g[f+308>>2]+ +g[A>>2]+(r*H-n*D))));D=-0.0-(J*(+g[e>>2]- +g[h>>2])+L*(+g[e+4>>2]- +g[h+4>>2])+N*(+g[e+8>>2]- +g[h+8>>2]));N=+g[a+(i<<2)>>2];L=+g[a+16+(i<<2)>>2];do{if(N<L){if(L<D){P=D-L;Q=0.0;R=999999984306749400.0;break}if(N>D){P=D-N;Q=-999999984306749400.0;R=0.0;break}else{S=0.0;return+S}}else{P=D;Q=-999999984306749400.0;R=999999984306749400.0}}while(0);h=a+32+(i<<2)|0;D=+g[h>>2];N=D+ +g[a+48>>2]*(P*+g[a+56>>2]/b-O*+g[a+52>>2])*c;if(N>R){T=0.0}else{T=N<Q?0.0:N}g[h>>2]=T;N=T-D;D=+g[I>>2];T=+g[K>>2];Q=+g[M>>2];R=o*Q-q*T;c=q*D-m*Q;q=m*T-o*D;o=l*Q-n*T;m=n*D-r*Q;n=r*T-l*D;l=+g[d+336>>2];if(l!=0.0){r=c*+g[d+292>>2]+R*+g[d+288>>2]+q*+g[d+296>>2];O=c*+g[d+276>>2]+R*+g[d+272>>2]+q*+g[d+280>>2];b=c*+g[d+260>>2]+R*+g[d+256>>2]+q*+g[d+264>>2];g[k>>2]=N*D*l+ +g[k>>2];g[s>>2]=N*T*l+ +g[s>>2];g[t>>2]=N*Q*l+ +g[t>>2];l=O*N*+g[d+540>>2];O=r*N*+g[d+544>>2];g[u>>2]=b*N*+g[d+536>>2]+ +g[u>>2];g[v>>2]=l+ +g[v>>2];g[x>>2]=O+ +g[x>>2]}O=+g[f+336>>2];l=-0.0-N;if(O==0.0){S=N;return+S}b=m*+g[f+292>>2]+o*+g[f+288>>2]+n*+g[f+296>>2];r=m*+g[f+276>>2]+o*+g[f+272>>2]+n*+g[f+280>>2];Q=m*+g[f+260>>2]+o*+g[f+256>>2]+n*+g[f+264>>2];n=O*+g[K>>2]*l;o=O*+g[M>>2]*l;g[z>>2]=+g[z>>2]+O*+g[I>>2]*l;g[A>>2]=n+ +g[A>>2];g[B>>2]=o+ +g[B>>2];o=r*+g[f+540>>2]*l;r=b*+g[f+544>>2]*l;g[C>>2]=Q*+g[f+536>>2]*l+ +g[C>>2];g[E>>2]=o+ +g[E>>2];g[G>>2]=r+ +g[G>>2];S=N;return+S}function Ti(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Tj(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Tk(a){a=a|0;return+(+g[a+44>>2])}function Tl(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Tm(a){a=a|0;return a+12|0}function Tn(a){a=a|0;return(c[a+4>>2]|0)<20|0}function To(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Tp(a){a=a|0;return c[a+8>>2]|0}function Tq(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Tr(a,b){a=a|0;b=b|0;var d=0;d=a+160|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ts(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Tt(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Tu(a){a=a|0;if((a|0)==0){return}aDB(a);return}function Tv(a,b){a=a|0;b=b|0;var d=0;d=a+60|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Tw(a,b){a=a|0;b=b|0;var d=0;d=a+112|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Tx(a,b){a=a|0;b=b|0;var d=0;d=a;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Ty(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function Tz(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function TA(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43568]|0)==0){if((b1(43568)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9222]=c[d>>2];c[9223]=c[d+4>>2];c[9224]=c[d+8>>2];c[9225]=c[d+12>>2];i=e;return 36888}function TB(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function TC(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function TD(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a)|0}function TE(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43392]|0)==0){if((b1(43392)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9214]=c[d>>2];c[9215]=c[d+4>>2];c[9216]=c[d+8>>2];c[9217]=c[d+12>>2];i=e;return 36856}function TF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function TG(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function TH(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function TI(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43128]|0)==0){if((b1(43128)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9210]=c[d>>2];c[9211]=c[d+4>>2];c[9212]=c[d+8>>2];c[9213]=c[d+12>>2];i=e;return 36840}function TJ(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function TK(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function TL(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function TM(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function TN(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function TO(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a,b,d);return}function TP(){var b=0,d=0,e=0,f=0;while(1){b=aDx(188)|0;if((b|0)!=0){break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){e=5652;break}dC[d&63]()}if((e|0)==5652){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}e=b;aDD(b|0,0,48);aDD(b+60|0,0,16);g[b+76>>2]=.20000000298023224;g[b+80>>2]=.20000000298023224;g[b+84>>2]=.20000000298023224;aDD(b+88|0,0,20);g[b+48>>2]=.699999988079071;g[b+52>>2]=1.0;g[b+56>>2]=.5;d=b+112|0;f=b+128|0;b=0;while(1){if((b|0)>=3){break}a[e+108+b|0]=0;g[d+(b<<2)>>2]=0.0;g[f+(b<<2)>>2]=0.0;b=b+1|0}return e|0}function TQ(b){b=b|0;var d=0,e=0,f=0,h=0;while(1){d=aDx(188)|0;if((d|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){f=5667;break}dC[e&63]()}if((f|0)==5667){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}f=d;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=d+16|0;h=b+16|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];h=d+32|0;e=b+32|0;c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];g[d+48>>2]=+g[b+48>>2];g[d+52>>2]=+g[b+52>>2];g[d+56>>2]=+g[b+56>>2];e=d+60|0;h=b+60|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];h=d+76|0;e=b+76|0;c[h>>2]=c[e>>2];c[h+4>>2]=c[e+4>>2];c[h+8>>2]=c[e+8>>2];c[h+12>>2]=c[e+12>>2];e=d+92|0;h=b+92|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];h=d+112|0;e=d+128|0;d=0;while(1){if((d|0)>=3){break}a[f+108+d|0]=a[b+108+d|0]&1;g[h+(d<<2)>>2]=+g[b+112+(d<<2)>>2];g[e+(d<<2)>>2]=+g[b+128+(d<<2)>>2];d=d+1|0}return f|0}function TR(a,b){a=a|0;b=b|0;return(c[a>>2]|0)==(c[b>>2]|0)|0}function TS(a){a=a|0;return c[a>>2]|0}function TT(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function TU(a){a=a|0;return(c[a+4>>2]|0)==32|0}function TV(a){a=a|0;return a+28|0}function TW(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function TX(a){a=a|0;return c[a+4>>2]|0}function TY(a){a=a|0;var b=0;b=c[a>>2]|0;a=b+~(b<<15)|0;b=(a^a>>10)*9|0;a=b^b>>6;b=a+~(a<<11)|0;return b^b>>16|0}function TZ(a){a=a|0;return+(+g[a+224>>2])}function T_(a){a=a|0;return+(+g[a+220>>2])}function T$(a,b){a=a|0;b=b|0;c[a+212>>2]=b;return}function T0(a){a=a|0;return+(+g[a+244>>2])}function T1(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function T2(a,b){a=a|0;b=b|0;c[a+196>>2]=b;return}function T3(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function T4(a){a=a|0;return a+132|0}function T5(a){a=a|0;return(c[a+204>>2]&7|0)==0|0}function T6(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function T7(a){a=a|0;return c[a+208>>2]|0}function T8(a){a=a|0;return c[a+260>>2]|0}function T9(a,b){a=a|0;b=b|0;c[a+236>>2]=b;return}function Ua(a){a=a|0;return a+148|0}function Ub(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function Uc(a){a=a|0;var b=0;if((c[a+204>>2]&3|0)!=0){return}b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function Ud(a,b){a=a|0;b=b|0;do{if(!b){if((c[a+204>>2]&3|0)==0){break}return}}while(0);b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function Ue(a,b){a=a|0;b=b|0;c[a+208>>2]=b;return}function Uf(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function Ug(a){a=a|0;return a+68|0}function Uh(a){a=a|0;return+(+g[a+240>>2])}function Ui(a,b){a=a|0;b=b|0;return c[(c[a+268>>2]|0)+(b<<2)>>2]|0}function Uj(a){a=a|0;return(c[a+204>>2]&1|0)!=0|0}function Uk(a){a=a|0;return c[a+192>>2]|0}function Ul(a){a=a|0;return c[a+216>>2]|0}function Um(a){a=a|0;return c[a+188>>2]|0}function Un(a){a=a|0;return+(+g[a+228>>2])}function Uo(a){a=a|0;return c[a+236>>2]|0}function Up(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function Uq(a){a=a|0;return a+4|0}function Ur(a){a=a|0;var b=0.0;b=+g[a+248>>2];return+(b*b)}function Us(a,b){a=a|0;b=b|0;c[a+192>>2]=b;return}function Ut(a){a=a|0;return+(+g[a+248>>2])}function Uu(a){a=a|0;return c[a+212>>2]|0}function Uv(a){a=a|0;var b=0;b=c[a+216>>2]|0;return((b|0)==2?0:(b|0)!=5)|0}function Uw(a){a=a|0;return c[a+232>>2]|0}function Ux(a){a=a|0;return(c[a+204>>2]&4|0)==0|0}function Uy(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function Uz(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43248]|0)==0){if((b1(43248)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9206]=c[d>>2];c[9207]=c[d+4>>2];c[9208]=c[d+8>>2];c[9209]=c[d+12>>2];i=e;return 36824}function UA(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 13:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function UB(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function UC(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function UD(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function UE(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function UF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a,b,d,e);return}function UG(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function UH(a){a=a|0;if((a|0)==0){return}aDB(a);return}function UI(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,0);return}function UJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function UK(a,b){a=a|0;b=b|0;var d=0;d=a+132|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function UL(a,b){a=a|0;b=b|0;var d=0;d=a+148|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function UM(){var b=0,d=0,e=0,f=0,h=0,i=0,j=0,k=0;c[9806]=(c[9806]|0)+1;b=aDx(299)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d;g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749400.0;aDD(d+188|0,0,16);c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;c[d+236>>2]=0;g[d+240>>2]=1.0;g[d+244>>2]=0.0;g[d+248>>2]=0.0;c[d+252>>2]=0;g[d+4>>2]=1.0;aDD(d+8|0,0,16);g[d+24>>2]=1.0;aDD(d+28|0,0,16);g[d+44>>2]=1.0;aDD(d+48|0,0,20);a[d+272|0]=1;c[d+268>>2]=0;c[d+260>>2]=0;c[d+264>>2]=0;c[d+232>>2]=4;c[d>>2]=21080;c[9806]=(c[9806]|0)+1;b=aDx(95)|0;if((b|0)==0){f=0;h=d+276|0;i=h;c[i>>2]=f;return e|0}j=-(b+4|0)&15;k=b+(j+4)|0;c[b+j>>2]=b;if((k|0)==0){f=0;h=d+276|0;i=h;c[i>>2]=f;return e|0}b=k;ayI(b);f=b;h=d+276|0;i=h;c[i>>2]=f;return e|0}function UN(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+68|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+84|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+100|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+116|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function UO(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function UP(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+28>>2]&511](a,b,0);return}function UQ(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+28>>2]&511](a,b,d);return}function UR(a,b){a=a|0;b=b|0;var d=0;if((c[a+252>>2]|0)==0){d=1;return d|0}d=dj[c[c[a>>2]>>2]&511](a|0,b)|0;return d|0}function US(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;f=i;i=i+128|0;h=f|0;j=f+64|0;g[h>>2]=1.0;aDD(h+4|0,0,16);g[h+20>>2]=1.0;aDD(h+24|0,0,16);g[h+40>>2]=1.0;c[h+44>>2]=0;k=h+48|0;l=b;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];g[j>>2]=1.0;aDD(j+4|0,0,16);g[j+20>>2]=1.0;aDD(j+24|0,0,16);g[j+40>>2]=1.0;c[j+44>>2]=0;l=j+48|0;k=d;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];k=a+260|0;if((c[k>>2]|0)<=0){i=f;return}l=a+268|0;a=e;d=0;do{b=c[(c[l>>2]|0)+(d<<2)>>2]|0;if(dj[c[(c[a>>2]|0)+8>>2]&511](e,c[b+188>>2]|0)|0){atG(h,j,b,c[b+192>>2]|0,b+4|0,e)}d=d+1|0;}while((d|0)<(c[k>>2]|0));i=f;return}function UT(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function UU(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;axT(a|0,b,c,d,e,0.0);return}function UV(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;axT(a|0,b,c,d,e,f);return}function UW(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a+164|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];do{if(+g[b>>2]!=1.0){f=1}else{if(+g[b+4>>2]!=1.0){f=1;break}f=+g[b+8>>2]!=1.0|0}}while(0);c[a+180>>2]=f;return}function UX(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+20|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+36|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+52|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function UY(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a|0,b,d)|0}function UZ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function U_(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function U$(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(8)|0;if((b|0)!=0){d=5820;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==5820){c[b>>2]=a;return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function U0(a){a=a|0;var b=0;if((c[a+232>>2]|0)==4){b=a}else{b=0}return b|0}function U1(a,b){a=a|0;b=b|0;var d=0;d=a+216|0;if(((c[d>>2]|0)-4|0)>>>0<2){return}c[d>>2]=b;return}function U2(a){a=a|0;return c[a+200>>2]|0}function U3(a){a=a|0;return+(+g[a+184>>2])}function U4(a){a=a|0;return c[a+204>>2]|0}function U5(a){a=a|0;return c[a+276>>2]|0}function U6(a){a=a|0;return a+164|0}function U7(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function U8(a){a=a|0;return c[a+196>>2]|0}function U9(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function Va(a){a=a|0;return(c[a+204>>2]&3|0)!=0|0}function Vb(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function Vc(a){a=a|0;return(c[a+180>>2]|0)!=0|0}function Vd(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function Ve(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function Vf(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Vg(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Vh(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Vi(a){a=a|0;return a+48|0}function Vj(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Vk(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Vl(a){a=a|0;return c[a+8>>2]|0}function Vm(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Vn(a){a=a|0;return+(+g[a+64>>2])}function Vo(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Vp(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Vq(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Vr(a){a=a|0;return c[a+4>>2]|0}function Vs(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Vt(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Vu(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Vv(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Vw(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Vx(a){a=a|0;return c[a+8>>2]|0}function Vy(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Vz(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function VA(a){a=a|0;return(c[a+4>>2]|0)==32|0}function VB(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function VC(a){a=a|0;return c[a+4>>2]|0}function VD(a){a=a|0;return c[a+28>>2]|0}function VE(a){a=a|0;return c[a+12>>2]|0}function VF(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function VG(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function VH(a){a=a|0;return a+40|0}function VI(a,b){a=a|0;b=b|0;return+(+g[a+1248+(b<<2)>>2])}function VJ(a){a=a|0;return a+104|0}function VK(a){a=a|0;return a+1056|0}function VL(a){a=a|0;return c[a+12>>2]|0}function VM(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a,b)|0}function VN(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function VO(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function VP(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function VQ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function VR(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function VS(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function VT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function VU(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function VV(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function VW(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function VX(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function VY(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function VZ(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function V_(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function V$(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function V0(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function V1(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function V2(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function V3(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+8>>2]&511](a|0,b,d)|0}function V4(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+16>>2]&511](a|0,b,d);return}function V5(a){a=a|0;return cA[c[(c[a>>2]|0)+56>>2]&4095](a)|0}function V6(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function V7(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function V8(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+40>>2]&511](a,b,d);return}function V9(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+32>>2]&511](a,b,d);return}function Wa(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Wb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e)|0}function Wc(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+44>>2]&2047](a,b);return}function Wd(a){a=a|0;return cA[c[(c[a>>2]|0)+20>>2]&4095](a)|0}function We(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a,b,d);return}function Wf(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function Wg(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function Wh(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function Wi(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function Wj(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Wk(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function Wl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function Wm(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a,b))}function Wn(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function Wo(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function Wp(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a,b,c,d,e,f,g);return}function Wq(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,f);i=e;return}function Wr(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a))}function Ws(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a,b);return}function Wt(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function Wu(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function Wv(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function Ww(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;apb(a,b,c,d,e,f,g,h);return}function Wx(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0;while(1){d=aDx(84)|0;if((d|0)!=0){e=5939;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==5939){e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;g[d+12>>2]=0.0;c[d>>2]=22976;h=+g[a>>2];i=+g[a+4>>2];j=+g[a+8>>2];k=1.0/+Q(+(h*h+i*i+j*j));g[d+48>>2]=h*k;g[d+52>>2]=i*k;g[d+56>>2]=j*k;g[d+60>>2]=0.0;g[d+64>>2]=b;aDD(d+68|0,0,16);c[e>>2]=28;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function Wy(a,b){a=a|0;b=+b;return}function Wz(a){a=a|0;return c[a+24>>2]|0}function WA(a){a=a|0;return+(+g[a+16>>2])}function WB(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=3){break}g[b+(c<<2)>>2]=+g[a+860+(c<<6)>>2];c=c+1|0}return}function WC(a){a=a|0;return+(+g[a+32>>2])}function WD(b){b=b|0;return(a[b+20|0]&1)!=0|0}function WE(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function WF(a){a=a|0;return c[a+4>>2]|0}function WG(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function WH(b,c){b=b|0;c=c|0;a[b+1293|0]=c&1;return}function WI(b){b=b|0;return(a[b+21|0]&1)!=0|0}function WJ(a){a=a|0;return c[a+4>>2]|0}function WK(a,b){a=a|0;b=b|0;return a+860+(b<<6)|0}function WL(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+1300|0]&1)==0){c[e>>2]=6;c[d+4>>2]=0;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function WM(a){a=a|0;return+(+g[a+36>>2])}function WN(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function WO(a,b){a=a|0;b=b|0;var c=0,d=0;if((b|0)<3){c=+g[a+688+(b<<2)>>2]>=+g[a+672+(b<<2)>>2];return c|0}d=b-3|0;if(+g[a+860+(d<<6)>>2]>+g[a+860+(d<<6)+4>>2]){c=0;return c|0}c=1;return c|0}function WP(b){b=b|0;return(a[b+1293|0]&1)!=0|0}function WQ(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function WR(a){a=a|0;return a+1120|0}function WS(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function WT(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function WU(b){b=b|0;return(a[b+1300|0]&1)!=0|0}function WV(a){a=a|0;return+(+g[a+32>>2])}function WW(b,c){b=b|0;c=c|0;a[b+1300|0]=c&1;return}function WX(a){a=a|0;return a+672|0}function WY(a,b){a=a|0;b=b|0;return+(+g[a+1184+(b<<2)>>2])}function WZ(a,b){a=a|0;b=b|0;var c=0;c=0;while(1){if((c|0)>=3){break}g[b+(c<<2)>>2]=+g[a+860+(c<<6)+4>>2];c=c+1|0}return}function W_(a){a=a|0;return c[a+4>>2]|0}function W$(a){a=a|0;return c[a+8>>2]|0}function W0(a){a=a|0;return c[a+12>>2]|0}function W1(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function W2(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function W3(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function W4(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function W5(a){a=a|0;ct[c[(c[a>>2]|0)+44>>2]&2047](a);return}function W6(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function W7(b,c){b=b|0;c=c|0;do{if((a[43848]|0)==0){if((b1(43848)|0)==0){break}}}while(0);aDG(36808,b+1200+(c<<4)|0,16);return 36808}function W8(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+688|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];return}function W9(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function Xa(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Xb(a,b){a=a|0;b=b|0;var d=0;d=b;b=a+672|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];return}function Xc(a){a=a|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function Xd(a,b,c){a=a|0;b=b|0;c=c|0;aoZ(a,b,c);return}function Xe(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,0)|0}function Xf(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,m)|0}function Xg(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;nS(a,b,c,d);return}function Xh(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function Xi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function Xj(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=0;while(1){if((c|0)>=3){break}d=+ck(+(+g[b+(c<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[a+860+(c<<6)>>2]=e;c=c+1|0}return}function Xk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function Xl(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+40|0;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+56|0;e=b+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+72|0;f=b+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+88|0;e=b+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+104|0;f=d;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+120|0;e=d+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+136|0;f=d+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+152|0;e=d+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](a);aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function Xm(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function Xn(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=0;while(1){if((c|0)>=3){break}d=+ck(+(+g[b+(c<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[a+860+(c<<6)+4>>2]=e;c=c+1|0}return}function Xo(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;f=i;i=i+112|0;h=f|0;j=f+48|0;k=e&1;while(1){l=aDx(1304)|0;if((l|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){m=6041;break}dC[e&63]()}if((m|0)==6041){m=cd(4)|0;c[m>>2]=19096;bF(m|0,34368,676);return 0}m=l;e=j;aq2();c[l+4>>2]=6;c[l+8>>2]=-1;c[l+12>>2]=-1;g[l+16>>2]=3.4028234663852886e+38;a[l+20|0]=1;a[l+21|0]=0;n=l+24|0;c[n>>2]=41520;o=l+28|0;c[o>>2]=b;g[l+32>>2]=0.0;g[l+36>>2]=.30000001192092896;c[l>>2]=21400;p=l+104|0;q=d;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];q=l+120|0;r=d+16|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];r=l+136|0;q=d+32|0;c[r>>2]=c[q>>2];c[r+4>>2]=c[q+4>>2];c[r+8>>2]=c[q+8>>2];c[r+12>>2]=c[q+12>>2];q=l+152|0;r=d+48|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];r=l+40|0;aDD(l+672|0,0,48);aDD(l+732|0,0,16);g[l+748>>2]=.20000000298023224;g[l+752>>2]=.20000000298023224;g[l+756>>2]=.20000000298023224;aDD(l+760|0,0,20);g[l+720>>2]=.699999988079071;g[l+724>>2]=1.0;g[l+728>>2]=.5;a[l+780|0]=0;g[l+784>>2]=0.0;g[l+800>>2]=0.0;a[l+781|0]=0;g[l+788>>2]=0.0;g[l+804>>2]=0.0;a[l+782|0]=0;g[l+792>>2]=0.0;g[l+808>>2]=0.0;g[l+920>>2]=0.0;g[l+868>>2]=0.0;g[l+872>>2]=.10000000149011612;g[l+876>>2]=300.0;g[l+860>>2]=1.0;g[l+864>>2]=-1.0;g[l+888>>2]=0.0;g[l+892>>2]=.20000000298023224;g[l+896>>2]=0.0;g[l+900>>2]=0.0;g[l+880>>2]=1.0;g[l+884>>2]=.5;c[l+916>>2]=0;g[l+908>>2]=0.0;a[l+904|0]=0;g[l+984>>2]=0.0;g[l+932>>2]=0.0;g[l+936>>2]=.10000000149011612;g[l+940>>2]=300.0;g[l+924>>2]=1.0;g[l+928>>2]=-1.0;g[l+952>>2]=0.0;g[l+956>>2]=.20000000298023224;g[l+960>>2]=0.0;g[l+964>>2]=0.0;g[l+944>>2]=1.0;g[l+948>>2]=.5;c[l+980>>2]=0;g[l+972>>2]=0.0;a[l+968|0]=0;g[l+1048>>2]=0.0;g[l+996>>2]=0.0;g[l+1e3>>2]=.10000000149011612;g[l+1004>>2]=300.0;g[l+988>>2]=1.0;g[l+992>>2]=-1.0;g[l+1016>>2]=0.0;g[l+1020>>2]=.20000000298023224;g[l+1024>>2]=0.0;g[l+1028>>2]=0.0;g[l+1008>>2]=1.0;g[l+1012>>2]=.5;c[l+1044>>2]=0;g[l+1036>>2]=0.0;a[l+1032|0]=0;a[l+1292|0]=k;a[l+1293|0]=1;c[l+1296>>2]=0;a[l+1300|0]=0;k=b+4|0;q=h;anx(h,k|0,p);s=+g[l+152>>2];t=+g[l+156>>2];u=+g[l+160>>2];v=+g[k>>2]*s+ +g[b+8>>2]*t+ +g[b+12>>2]*u+ +g[b+52>>2];w=+g[b+20>>2]*s+ +g[b+24>>2]*t+ +g[b+28>>2]*u+ +g[b+56>>2];x=+g[b+36>>2]*s+ +g[b+40>>2]*t+ +g[b+44>>2]*u+ +g[b+60>>2];b=j+48|0;k=j|0;do{k=k+16|0;}while((k|0)!=(b|0));c[e>>2]=c[q>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];q=j+16|0;b=h+16|0;c[q>>2]=c[b>>2];c[q+4>>2]=c[b+4>>2];c[q+8>>2]=c[b+8>>2];c[q+12>>2]=c[b+12>>2];b=j+32|0;k=h+32|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];g[j+48>>2]=v;g[j+52>>2]=w;g[j+56>>2]=x;g[j+60>>2]=0.0;c[r>>2]=c[e>>2];c[r+4>>2]=c[e+4>>2];c[r+8>>2]=c[e+8>>2];c[r+12>>2]=c[e+12>>2];e=l+56|0;c[e>>2]=c[q>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];q=l+72|0;c[q>>2]=c[b>>2];c[q+4>>2]=c[b+4>>2];c[q+8>>2]=c[b+8>>2];c[q+12>>2]=c[b+12>>2];b=l+88|0;l=j+48|0;c[b>>2]=c[l>>2];c[b+4>>2]=c[l+4>>2];c[b+8>>2]=c[l+8>>2];c[b+12>>2]=c[l+12>>2];aoZ(m,(c[n>>2]|0)+4|0,(c[o>>2]|0)+4|0);i=f;return m|0}function Xp(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;while(1){g=aDx(1304)|0;if((g|0)!=0){h=6060;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==6060){h=g;aoY(h,a,b,d,e,f);return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function Xq(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function Xr(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[b>>2]|0;b=c[a>>2]|0;e=c[d+4>>2]|0;c[b>>2]=c[d>>2];c[b+4>>2]=e;return a|0}function Xs(a,b){a=a|0;b=b|0;g[a>>2]=+g[b>>2];g[a+4>>2]=+g[b+16>>2];g[a+8>>2]=+g[b+32>>2];g[a+12>>2]=0.0;g[a+16>>2]=+g[b+4>>2];g[a+20>>2]=+g[b+20>>2];g[a+24>>2]=+g[b+36>>2];g[a+28>>2]=0.0;g[a+32>>2]=+g[b+8>>2];g[a+36>>2]=+g[b+24>>2];g[a+40>>2]=+g[b+40>>2];g[a+44>>2]=0.0;g[a+48>>2]=+g[b+48>>2];g[a+52>>2]=+g[b+52>>2];g[a+56>>2]=+g[b+56>>2];g[a+60>>2]=0.0;return}function Xt(a){a=a|0;return a+48|0}function Xu(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=0;while(1){if((c|0)<3){d=0}else{e=0;break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+h[b+(c<<5)+(d<<3)>>3];d=d+1|0}c=c+1|0}while(1){if((e|0)>=4){break}g[a+48+(e<<2)>>2]=+h[b+96+(e<<3)>>3];e=e+1|0}return}function Xv(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=0;while(1){if((c|0)<3){d=0}else{e=0;break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+g[b+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}while(1){if((e|0)>=4){break}g[a+48+(e<<2)>>2]=+g[b+48+(e<<2)>>2];e=e+1|0}return}function Xw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;e=+g[b>>2];f=+g[b+4>>2];h=+g[b+8>>2];i=1.0/+Q(+(e*e+f*f+h*h));j=e*i;e=f*i;f=h*i;i=+g[d>>2];h=+g[d+4>>2];k=+g[d+8>>2];l=1.0/+Q(+(i*i+h*h+k*k));m=i*l;i=h*l;h=k*l;l=f*i-e*h;k=j*h-f*m;n=e*m-j*i;d=c[a+24>>2]|0;o=+g[d+4>>2];p=+g[d+20>>2];q=+g[d+36>>2];r=+g[d+8>>2];s=+g[d+24>>2];t=+g[d+40>>2];u=+g[d+12>>2];v=+g[d+28>>2];w=+g[d+44>>2];x=-0.0- +g[d+52>>2];y=-0.0- +g[d+56>>2];z=-0.0- +g[d+60>>2];g[a+40>>2]=o*l+k*p+n*q;g[a+44>>2]=m*o+i*p+h*q;g[a+48>>2]=j*o+e*p+f*q;g[a+52>>2]=0.0;g[a+56>>2]=l*r+k*s+n*t;g[a+60>>2]=m*r+i*s+h*t;g[a+64>>2]=j*r+e*s+f*t;g[a+68>>2]=0.0;g[a+72>>2]=l*u+k*v+n*w;g[a+76>>2]=m*u+i*v+h*w;g[a+80>>2]=j*u+e*v+f*w;g[a+84>>2]=0.0;g[a+88>>2]=o*0.0+p*0.0+q*0.0+(o*x+p*y+q*z);g[a+92>>2]=r*0.0+s*0.0+t*0.0+(r*x+s*y+t*z);g[a+96>>2]=u*0.0+v*0.0+w*0.0+(u*x+v*y+w*z);g[a+100>>2]=0.0;b=c[a+28>>2]|0;z=+g[b+4>>2];w=+g[b+20>>2];y=+g[b+36>>2];v=+g[b+8>>2];x=+g[b+24>>2];u=+g[b+40>>2];t=+g[b+12>>2];s=+g[b+28>>2];r=+g[b+44>>2];q=-0.0- +g[b+52>>2];p=-0.0- +g[b+56>>2];o=-0.0- +g[b+60>>2];g[a+104>>2]=l*z+k*w+n*y;g[a+108>>2]=m*z+i*w+h*y;g[a+112>>2]=j*z+e*w+f*y;g[a+116>>2]=0.0;g[a+120>>2]=l*v+k*x+n*u;g[a+124>>2]=m*v+i*x+h*u;g[a+128>>2]=j*v+e*x+f*u;g[a+132>>2]=0.0;g[a+136>>2]=l*t+k*s+n*r;g[a+140>>2]=m*t+i*s+h*r;g[a+144>>2]=j*t+e*s+f*r;g[a+148>>2]=0.0;g[a+152>>2]=z*0.0+w*0.0+y*0.0+(z*q+w*p+y*o);g[a+156>>2]=v*0.0+x*0.0+u*0.0+(v*q+x*p+u*o);g[a+160>>2]=t*0.0+s*0.0+r*0.0+(t*q+s*p+r*o);g[a+164>>2]=0.0;aoZ(a,d+4|0,b+4|0);return}function Xx(a,b){a=a|0;b=b|0;return ao$(a,b)|0}function Xy(a){a=a|0;b3(c[a>>2]|0,0)|0;return}function Xz(a){a=a|0;var b=0;if((a|0)==0){return}b=c[a>>2]|0;if((b|0)!=0){aDB(b)}aDB(a);return}function XA(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+8|0;d=b|0;b3(d|0,0)|0;e=c[a>>2]|0;i=b;return(((c[d+4>>2]|0)-(c[e+4>>2]|0)|0)/1e3|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e3|0)|0}function XB(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+8|0;d=b|0;b3(d|0,0)|0;e=c[a>>2]|0;i=b;return(c[d+4>>2]|0)-(c[e+4>>2]|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e6|0)|0}function XC(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+16|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+32|0;a=b+32|0;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function XD(b){b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d|0;do{if((a[43944]|0)==0){if((b1(43944)|0)==0){break}}}while(0);ec(b|0,e);b=e;c[9198]=c[b>>2];c[9199]=c[b+4>>2];c[9200]=c[b+8>>2];c[9201]=c[b+12>>2];i=d;return 36792}function XE(b){b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0;d=i;i=i+112|0;e=d|0;f=d+48|0;do{if((a[44048]|0)==0){if((b1(44048)|0)==0){break}else{h=36728}do{h=h+16|0;}while((h|0)!=36776)}}while(0);h=e;d$(e,b|0,b+16|0,b+32|0,b+4|0,b+20|0,b+36|0,b+8|0,b+24|0,b+40|0);j=-0.0- +g[b+48>>2];k=-0.0- +g[b+52>>2];l=-0.0- +g[b+56>>2];m=+g[e>>2]*j+ +g[e+4>>2]*k+ +g[e+8>>2]*l;n=+g[e+16>>2]*j+ +g[e+20>>2]*k+ +g[e+24>>2]*l;o=+g[e+32>>2]*j+ +g[e+36>>2]*k+ +g[e+40>>2]*l;b=f+48|0;p=f|0;do{p=p+16|0;}while((p|0)!=(b|0));b=f;c[b>>2]=c[h>>2];c[b+4>>2]=c[h+4>>2];c[b+8>>2]=c[h+8>>2];c[b+12>>2]=c[h+12>>2];h=f+16|0;p=e+16|0;c[h>>2]=c[p>>2];c[h+4>>2]=c[p+4>>2];c[h+8>>2]=c[p+8>>2];c[h+12>>2]=c[p+12>>2];p=f+32|0;h=e+32|0;c[p>>2]=c[h>>2];c[p+4>>2]=c[h+4>>2];c[p+8>>2]=c[h+8>>2];c[p+12>>2]=c[h+12>>2];g[f+48>>2]=m;g[f+52>>2]=n;g[f+56>>2]=o;g[f+60>>2]=0.0;c[9182]=c[b>>2];c[9183]=c[b+4>>2];c[9184]=c[b+8>>2];c[9185]=c[b+12>>2];b=f+16|0;c[9186]=c[b>>2];c[36748>>2]=c[b+4>>2];c[36752>>2]=c[b+8>>2];c[36756>>2]=c[b+12>>2];b=f+32|0;c[9190]=c[b>>2];c[36764>>2]=c[b+4>>2];c[36768>>2]=c[b+8>>2];c[36772>>2]=c[b+12>>2];b=f+48|0;c[9194]=c[b>>2];c[36780>>2]=c[b+4>>2];c[36784>>2]=c[b+8>>2];c[36788>>2]=c[b+12>>2];i=d;return 36728}function XF(){B1();return 42752}function XG(){var a=0,b=0,d=0,e=0,f=0;while(1){a=aDx(4)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=6114;break}dC[b&63]()}if((d|0)==6114){b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}b=a;while(1){e=aDx(8)|0;if((e|0)!=0){d=6128;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){d=6126;break}dC[f&63]()}if((d|0)==6126){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}else if((d|0)==6128){c[a>>2]=e;b3(e|0,0)|0;return b|0}return 0}function XH(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;while(1){b=aDx(4)|0;if((b|0)!=0){break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){e=6140;break}dC[d&63]()}if((e|0)==6140){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=b;while(1){f=aDx(8)|0;if((f|0)!=0){e=6154;break}g=(C=c[10744]|0,c[10744]=C+0,C);if((g|0)==0){break}dC[g&63]()}if((e|0)==6154){c[b>>2]=f;b=c[a>>2]|0;a=f;f=c[b+4>>2]|0;c[a>>2]=c[b>>2];c[a+4>>2]=f;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function XI(a,b){a=a|0;b=b|0;g[b>>2]=+g[a>>2];g[b+4>>2]=+g[a+16>>2];g[b+8>>2]=+g[a+32>>2];g[b+12>>2]=0.0;g[b+16>>2]=+g[a+4>>2];g[b+20>>2]=+g[a+20>>2];g[b+24>>2]=+g[a+36>>2];g[b+28>>2]=0.0;g[b+32>>2]=+g[a+8>>2];g[b+36>>2]=+g[a+24>>2];g[b+40>>2]=+g[a+40>>2];g[b+44>>2]=0.0;g[b+48>>2]=+g[a+48>>2];g[b+52>>2]=+g[a+52>>2];g[b+56>>2]=+g[a+56>>2];g[b+60>>2]=1.0;return}function XJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=0;while(1){if((c|0)<3){d=0}else{e=0;break}while(1){if((d|0)>=4){break}g[b+(c<<4)+(d<<2)>>2]=+g[a+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}while(1){if((e|0)>=4){break}g[b+48+(e<<2)>>2]=+g[a+48+(e<<2)>>2];e=e+1|0}return}function XK(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=0;while(1){if((c|0)<3){d=0}else{e=0;break}while(1){if((d|0)>=4){break}g[a+(c<<4)+(d<<2)>>2]=+g[b+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}while(1){if((e|0)>=4){break}g[a+48+(e<<2)>>2]=+g[b+48+(e<<2)>>2];e=e+1|0}return}function XL(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=0;while(1){if((c|0)<3){d=0}else{e=0;break}while(1){if((d|0)>=4){break}g[b+(c<<4)+(d<<2)>>2]=+g[a+(c<<4)+(d<<2)>>2];d=d+1|0}c=c+1|0}while(1){if((e|0)>=4){break}g[b+48+(e<<2)>>2]=+g[a+48+(e<<2)>>2];e=e+1|0}return}function XM(a){a=a|0;return a|0}function XN(a){a=a|0;return+(+g[a+104>>2])}function XO(b){b=b|0;return(a[b+116|0]&1)!=0|0}function XP(a,b){a=a|0;b=+b;g[a>>2]=b;return}function XQ(b,c){b=b|0;c=c|0;a[b+116|0]=c&1;return}function XR(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function XS(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function XT(a){a=a|0;return+(+g[a+108>>2])}function XU(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function XV(a){a=a|0;return+(+g[a+92>>2])}function XW(a){a=a|0;return+(+g[a+96>>2])}function XX(a){a=a|0;return+(+g[a>>2])}function XY(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function XZ(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0;e=i;i=i+112|0;f=e|0;h=e+48|0;do{if((a[43936]|0)==0){if((b1(43936)|0)==0){break}else{j=36664}do{j=j+16|0;}while((j|0)!=36712)}}while(0);j=f;k=+g[d+48>>2]- +g[b+48>>2];l=+g[d+52>>2]- +g[b+52>>2];m=+g[d+56>>2]- +g[b+56>>2];ea(f,b|0,d|0);n=+g[b>>2]*k+ +g[b+16>>2]*l+ +g[b+32>>2]*m;o=+g[b+4>>2]*k+ +g[b+20>>2]*l+ +g[b+36>>2]*m;p=+g[b+8>>2]*k+ +g[b+24>>2]*l+ +g[b+40>>2]*m;b=h+48|0;d=h|0;do{d=d+16|0;}while((d|0)!=(b|0));b=h;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];j=h+16|0;d=f+16|0;c[j>>2]=c[d>>2];c[j+4>>2]=c[d+4>>2];c[j+8>>2]=c[d+8>>2];c[j+12>>2]=c[d+12>>2];d=h+32|0;j=f+32|0;c[d>>2]=c[j>>2];c[d+4>>2]=c[j+4>>2];c[d+8>>2]=c[j+8>>2];c[d+12>>2]=c[j+12>>2];g[h+48>>2]=n;g[h+52>>2]=o;g[h+56>>2]=p;g[h+60>>2]=0.0;c[9166]=c[b>>2];c[9167]=c[b+4>>2];c[9168]=c[b+8>>2];c[9169]=c[b+12>>2];b=h+16|0;c[9170]=c[b>>2];c[36684>>2]=c[b+4>>2];c[36688>>2]=c[b+8>>2];c[36692>>2]=c[b+12>>2];b=h+32|0;c[9174]=c[b>>2];c[36700>>2]=c[b+4>>2];c[36704>>2]=c[b+8>>2];c[36708>>2]=c[b+12>>2];b=h+48|0;c[9178]=c[b>>2];c[36716>>2]=c[b+4>>2];c[36720>>2]=c[b+8>>2];c[36724>>2]=c[b+12>>2];i=e;return 36664}function X_(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;do{if((a[44088]|0)==0){if((b1(44088)|0)==0){break}}}while(0);d=+g[c>>2];e=+g[c+4>>2];f=+g[c+8>>2];h=+g[b+16>>2]*d+ +g[b+20>>2]*e+ +g[b+24>>2]*f+ +g[b+52>>2];i=+g[b+32>>2]*d+ +g[b+36>>2]*e+ +g[b+40>>2]*f+ +g[b+56>>2];g[9162]=+g[b>>2]*d+ +g[b+4>>2]*e+ +g[b+8>>2]*f+ +g[b+48>>2];g[9163]=h;g[9164]=i;g[9165]=0.0;return 36648}function X$(a,b){a=a|0;b=b|0;em(a|0,b);return}function X0(a){a=a|0;X1(a);return}function X1(a){a=a|0;g[a>>2]=1.0;aDD(a+4|0,0,16);g[a+20>>2]=1.0;aDD(a+24|0,0,16);g[a+40>>2]=1.0;g[a+44>>2]=0.0;aDD(a+48|0,0,16);return}function X2(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+16|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+32|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+48|0;d=b+48|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];return a|0}function X3(b,c){b=b|0;c=c|0;var d=0,e=0,f=0.0,h=0.0,j=0.0,k=0.0,l=0.0;d=i;i=i+48|0;e=d|0;do{if((a[44e3]|0)==0){if((b1(44e3)|0)==0){break}}}while(0);f=+g[c>>2]- +g[b+48>>2];h=+g[c+4>>2]- +g[b+52>>2];j=+g[c+8>>2]- +g[b+56>>2];d$(e,b|0,b+16|0,b+32|0,b+4|0,b+20|0,b+36|0,b+8|0,b+24|0,b+40|0);k=+g[e+16>>2]*f+ +g[e+20>>2]*h+ +g[e+24>>2]*j;l=+g[e+32>>2]*f+ +g[e+36>>2]*h+ +g[e+40>>2]*j;g[9158]=+g[e>>2]*f+ +g[e+4>>2]*h+ +g[e+8>>2]*j;g[9159]=k;g[9160]=l;g[9161]=0.0;i=d;return 36632}function X4(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;e=i;i=i+48|0;f=e|0;h=f;anx(f,b|0,d|0);j=a;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];h=a+16|0;j=f+16|0;c[h>>2]=c[j>>2];c[h+4>>2]=c[j+4>>2];c[h+8>>2]=c[j+8>>2];c[h+12>>2]=c[j+12>>2];j=a+32|0;h=f+32|0;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];k=+g[d+48>>2];l=+g[d+52>>2];m=+g[d+56>>2];n=+g[b+16>>2]*k+ +g[b+20>>2]*l+ +g[b+24>>2]*m+ +g[b+52>>2];o=+g[b+32>>2]*k+ +g[b+36>>2]*l+ +g[b+40>>2]*m+ +g[b+56>>2];g[a+48>>2]=+g[b>>2]*k+ +g[b+4>>2]*l+ +g[b+8>>2]*m+ +g[b+48>>2];g[a+52>>2]=n;g[a+56>>2]=o;g[a+60>>2]=0.0;i=e;return}function X5(a){a=a|0;if((a|0)==0){return}aDB(a);return}function X6(a,b){a=a|0;b=b|0;var d=0;d=a+48|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function X7(){var a=0,b=0,d=0,e=0;while(1){a=aDx(64)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=6229;break}dC[b&63]()}if((d|0)==6229){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=a;b=a+48|0;e=a;do{e=e+16|0;}while((e|0)!=(b|0));return d|0}function X8(a){a=a|0;var b=0,d=0,e=0,f=0,g=0;while(1){b=aDx(64)|0;if((b|0)!=0){break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){e=6243;break}dC[d&63]()}if((e|0)==6243){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}e=b;d=b+48|0;f=d;g=b;do{g=g+16|0;}while((g|0)!=(f|0));f=a;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=b+16|0;g=a+16|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=b+32|0;b=a+32|0;c[g>>2]=c[b>>2];c[g+4>>2]=c[b+4>>2];c[g+8>>2]=c[b+8>>2];c[g+12>>2]=c[b+12>>2];b=a+48|0;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];return e|0}function X9(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;while(1){d=aDx(64)|0;if((d|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){f=6257;break}dC[e&63]()}if((f|0)==6257){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}f=d;e=d;g=d+48|0;h=g;i=d;do{i=i+16|0;}while((i|0)!=(h|0));em(e,a);a=b;c[g>>2]=c[a>>2];c[g+4>>2]=c[a+4>>2];c[g+8>>2]=c[a+8>>2];c[g+12>>2]=c[a+12>>2];return f|0}function Ya(b,d,e){b=+b;d=d|0;e=e|0;var f=0,h=0,i=0,j=0;while(1){f=aDx(136)|0;if((f|0)!=0){break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){i=6271;break}dC[h&63]()}if((i|0)==6271){i=cd(4)|0;c[i>>2]=19096;bF(i|0,34368,676);return 0}i=f;g[f>>2]=b;c[f+4>>2]=d;d=f+8|0;h=f+56|0;j=d;do{j=j+16|0;}while((j|0)!=(h|0));c[f+72>>2]=e;aDD(f+76|0,0,24);g[f+100>>2]=.5;g[f+104>>2]=0.0;g[f+108>>2]=.800000011920929;g[f+112>>2]=1.0;a[f+116|0]=0;g[f+120>>2]=.004999999888241291;g[f+124>>2]=.009999999776482582;g[f+128>>2]=.009999999776482582;g[f+132>>2]=.009999999776482582;X1(d);return i|0}function Yb(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function Yc(a){a=a|0;return+(+g[a+132>>2])}function Yd(a){a=a|0;return+(+g[a+128>>2])}function Ye(a,b){a=a|0;b=b|0;c[a+72>>2]=b;return}function Yf(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function Yg(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function Yh(a){a=a|0;return c[a+72>>2]|0}function Yi(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function Yj(a){a=a|0;return+(+g[a+100>>2])}function Yk(a,b){a=a|0;b=+b;g[a+108>>2]=b;return}function Yl(a){a=a|0;return a+8|0}function Ym(a){a=a|0;return a+76|0}function Yn(a){a=a|0;return c[a+4>>2]|0}function Yo(a){a=a|0;return+(+g[a+120>>2])}function Yp(a){a=a|0;return+(+g[a+124>>2])}function Yq(a,b){a=a|0;b=+b;g[a+120>>2]=b;return}function Yr(a){a=a|0;return+(+g[a+112>>2])}function Ys(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function Yt(a){a=a|0;return c[a+20>>2]|0}function Yu(a){a=a|0;return c[a+4>>2]|0}function Yv(a){a=a|0;return c[a>>2]|0}function Yw(a){a=a|0;return+(+g[a+8>>2])}function Yx(a){a=a|0;return c[a+28>>2]|0}function Yy(a){a=a|0;return c[a+24>>2]|0}function Yz(a){a=a|0;return+(+g[a+128>>2])}function YA(a){a=a|0;return a|0}function YB(a){a=a|0;return a+64|0}function YC(a,b){a=a|0;b=b|0;c[a+132>>2]=b;return}function YD(a){a=a|0;return c[a+132>>2]|0}function YE(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function YF(a){a=a|0;return a+32|0}function YG(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+8|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+24|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+40|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+56|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function YH(a,b){a=a|0;b=b|0;var d=0;d=a+76|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function YI(a){a=a|0;if((a|0)==0){return}aDB(a);return}function YJ(a){a=a|0;aDg(a);return}function YK(a){a=a|0;if((a|0)==0){return}aDh(a);aDB(a);return}function YL(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0;b=i;i=i+8|0;d=b|0;e=a+16|0;f=(c[e>>2]|0)-1|0;c[e>>2]=f;if((f|0)!=0){h=f;j=(h|0)==0;i=b;return j|0}if((c[a+4>>2]|0)==0){h=0;j=(h|0)==0;i=b;return j|0}b3(d|0,0)|0;f=c[10742]|0;k=a+8|0;g[k>>2]=+(((c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[k>>2];h=c[e>>2]|0;j=(h|0)==0;i=b;return j|0}function YM(a){a=a|0;var b=0,d=0;b=a+24|0;d=c[b>>2]|0;if((d|0)!=0){aDh(d);aDB(d)}c[b>>2]=0;b=a+28|0;a=c[b>>2]|0;if((a|0)==0){c[b>>2]=0;return}aDh(a);aDB(a);c[b>>2]=0;return}function YN(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+8|0;d=b|0;e=a+4|0;c[e>>2]=(c[e>>2]|0)+1;e=a+16|0;f=c[e>>2]|0;c[e>>2]=f+1;if((f|0)!=0){i=b;return}b3(d|0,0)|0;f=c[10742]|0;c[a+12>>2]=(c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0);i=b;return}function YO(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+64|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+80|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+96|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+112|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function YP(a,b){a=a|0;b=b|0;var d=0,e=0;d=a;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+16|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+32|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+48|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function YQ(a){a=a|0;if((a|0)==0){return}aDB(a);return}function YR(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function YS(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(95)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;asr(f,a,b,1);return f|0}function YT(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[9806]=(c[9806]|0)+1;e=aDx(95)|0;if((e|0)==0){f=0}else{g=-(e+4|0)&15;c[e+g>>2]=e;f=e+(g+4)|0}g=f;asr(g,a,b,d);return g|0}function YU(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;c[9806]=(c[9806]|0)+1;f=aDx(95)|0;if((f|0)==0){g=0}else{h=-(f+4|0)&15;c[f+h>>2]=f;g=f+(h+4)|0}h=g;ass(h,a,b,d,e,1);return h|0}function YV(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;c[9806]=(c[9806]|0)+1;g=aDx(95)|0;if((g|0)==0){h=0}else{i=-(g+4|0)&15;c[g+i>>2]=g;h=g+(i+4)|0}i=h;ass(i,a,b,d,e,f);return i|0}function YW(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+76>>2]&2047](a,b);return}function YX(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a,b,d)|0}function YY(b,d,e,f){b=+b;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0;while(1){h=aDx(136)|0;if((h|0)!=0){break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){j=6393;break}dC[i&63]()}if((j|0)==6393){j=cd(4)|0;c[j>>2]=19096;bF(j|0,34368,676);return 0}j=h;g[h>>2]=b;c[h+4>>2]=d;d=h+8|0;i=h+56|0;k=d;do{k=k+16|0;}while((k|0)!=(i|0));c[h+72>>2]=e;e=h+76|0;i=f;c[e>>2]=c[i>>2];c[e+4>>2]=c[i+4>>2];c[e+8>>2]=c[i+8>>2];c[e+12>>2]=c[i+12>>2];g[h+92>>2]=0.0;g[h+96>>2]=0.0;g[h+100>>2]=.5;g[h+104>>2]=0.0;g[h+108>>2]=.800000011920929;g[h+112>>2]=1.0;a[h+116|0]=0;g[h+120>>2]=.004999999888241291;g[h+124>>2]=.009999999776482582;g[h+128>>2]=.009999999776482582;g[h+132>>2]=.009999999776482582;X1(d);return j|0}function YZ(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a+24|0;e=d;while(1){f=c[e>>2]|0;if((f|0)==0){break}if((c[f>>2]|0)==(b|0)){g=f;h=6414;break}else{e=f+28|0}}if((h|0)==6414){return g|0}while(1){i=aDx(32)|0;if((i|0)!=0){h=6412;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){h=6409;break}dC[e&63]()}if((h|0)==6409){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}else if((h|0)==6412){h=i;c[i>>2]=b;aDD(i+4|0,0,16);c[i+20>>2]=a;c[i+24>>2]=0;a=i+28|0;c[a>>2]=0;aDg(h);c[a>>2]=c[d>>2];c[d>>2]=h;g=h;return g|0}return 0}function Y_(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;while(1){d=aDx(32)|0;if((d|0)!=0){e=6427;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==6427){e=d;c[d>>2]=a;aDD(d+4|0,0,16);c[d+20>>2]=b;c[d+24>>2]=0;c[d+28>>2]=0;aDg(e);return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function Y$(){var a=0,b=0,d=0,e=0;while(1){a=aDx(136)|0;if((a|0)!=0){break}b=(C=c[10744]|0,c[10744]=C+0,C);if((b|0)==0){d=6436;break}dC[b&63]()}if((d|0)==6436){d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}d=a;b=a+48|0;e=a;do{e=e+16|0;}while((e|0)!=(b|0));b=a+112|0;e=a+64|0;do{e=e+16|0;}while((e|0)!=(b|0));g[a+128>>2]=999999984306749400.0;c[a+132>>2]=0;return d|0}function Y0(b){b=b|0;return(a[b+61|0]&1)!=0|0}function Y1(a){a=a|0;return c[a+48>>2]|0}function Y2(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function Y3(a,b){a=a|0;b=b|0;c[a+56>>2]=b;return}function Y4(b){b=b|0;return(a[b+60|0]&1)!=0|0}function Y5(a){a=a|0;return c[a+56>>2]|0}function Y6(a){a=a|0;return(c[a+4>>2]|0)==31|0}function Y7(a){a=a|0;return(c[a+4>>2]|0)<7|0}function Y8(a){a=a|0;return c[a+52>>2]|0}function Y9(a){a=a|0;return a+16|0}function Za(a){a=a|0;return(c[a+4>>2]|0)<20|0}function Zb(a){a=a|0;return(c[a+4>>2]|0)==28|0}function Zc(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function Zd(a){a=a|0;return c[a+8>>2]|0}function Ze(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function Zf(a){a=a|0;return(c[a+4>>2]|0)==32|0}function Zg(a){a=a|0;return c[a+4>>2]|0}function Zh(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function Zi(a){a=a|0;return c[a+28>>2]|0}function Zj(a){a=a|0;return c[a+24>>2]|0}function Zk(a){a=a|0;return+(+g[a+1080>>2])}function Zl(a){a=a|0;return+(+g[a+1108>>2])}function Zm(a){a=a|0;return+(+g[a+1076>>2])}function Zn(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function Zo(b){b=b|0;return(a[b+20|0]&1)!=0|0}function Zp(b){b=b|0;return(a[b+1088|0]&1)!=0|0}function Zq(b,c){b=b|0;c=c|0;a[b+41|0]=c&1;return}function Zr(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function Zs(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43552]|0)==0){if((b1(43552)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9154]=c[d>>2];c[9155]=c[d+4>>2];c[9156]=c[d+8>>2];c[9157]=c[d+12>>2];i=e;return 36616}function Zt(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function Zu(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function Zv(a,b,d){a=a|0;b=b|0;d=d|0;ayw(c[a+52>>2]|0,c[a+48>>2]|0,b,d);aBy(a|0);return}function Zw(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a)|0}function Zx(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0;h=i;i=i+48|0;j=h|0;k=h+16|0;l=h+32|0;m=c[b+48>>2]|0;c[l>>2]=18760;c[l+4>>2]=m;c[l+8>>2]=d;d=c[b+52>>2]|0;b=d|0;m=l|0;aDD(j|0,0,16);aDD(k|0,0,16);if((a[d+60|0]&1)==0){azp(b,m,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k);i=h;return}else{azq(b,m,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k,c[d+56>>2]|0);i=h;return}}function Zy(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function Zz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function ZA(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function ZB(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function ZC(b){b=b|0;var d=0,e=0,f=0,h=0,i=0;d=b+61|0;e=b+52|0;do{if((a[d]&1)!=0){f=c[e>>2]|0;ct[c[c[f>>2]>>2]&2047](f);f=c[e>>2]|0;if((f|0)==0){break}c[9804]=(c[9804]|0)+1;aDB(c[f-172+168>>2]|0)}}while(0);c[9806]=(c[9806]|0)+1;f=aDx(191)|0;if((f|0)==0){h=0}else{i=-(f+4|0)&15;c[f+i>>2]=f;h=f+(i+4)|0}c[h+52>>2]=278;a[h+60|0]=0;a[h+80|0]=1;c[h+76>>2]=0;c[h+68>>2]=0;c[h+72>>2]=0;a[h+100|0]=1;c[h+96>>2]=0;c[h+88>>2]=0;c[h+92>>2]=0;a[h+120|0]=1;c[h+116>>2]=0;c[h+108>>2]=0;c[h+112>>2]=0;a[h+140|0]=1;c[h+136>>2]=0;c[h+128>>2]=0;c[h+132>>2]=0;c[h+144>>2]=0;a[h+164|0]=1;c[h+160>>2]=0;c[h+152>>2]=0;c[h+156>>2]=0;c[h+168>>2]=0;g[h+4>>2]=-3.4028234663852886e+38;g[h+8>>2]=-3.4028234663852886e+38;g[h+12>>2]=-3.4028234663852886e+38;g[h+16>>2]=0.0;g[h+20>>2]=3.4028234663852886e+38;g[h+24>>2]=3.4028234663852886e+38;g[h+28>>2]=3.4028234663852886e+38;g[h+32>>2]=0.0;c[h>>2]=25376;c[e>>2]=h;ayv(h,c[b+48>>2]|0,(a[b+60|0]&1)!=0,b+16|0,b+32|0);a[d]=1;return}function ZD(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function ZE(a){a=a|0;aBy(a|0);return}function ZF(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function ZG(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0;e=b|0;f=b+4|0;h=b+8|0;i=d|0;j=d+4|0;k=d+8|0;ayB(c[a+52>>2]|0,c[a+48>>2]|0,+g[e>>2],+g[f>>2],+g[h>>2],+g[i>>2],+g[j>>2],+g[k>>2]);l=a+16|0;m=+g[e>>2];if(m<+g[l>>2]){g[l>>2]=m}l=a+20|0;m=+g[f>>2];if(m<+g[l>>2]){g[l>>2]=m}l=a+24|0;m=+g[h>>2];if(m<+g[l>>2]){g[l>>2]=m}l=a+28|0;m=+g[b+12>>2];if(m<+g[l>>2]){g[l>>2]=m}l=a+32|0;m=+g[i>>2];if(+g[l>>2]<m){g[l>>2]=m}l=a+36|0;m=+g[j>>2];if(+g[l>>2]<m){g[l>>2]=m}l=a+40|0;m=+g[k>>2];if(+g[l>>2]<m){g[l>>2]=m}l=a+44|0;m=+g[d+12>>2];if(+g[l>>2]>=m){return}g[l>>2]=m;return}function ZH(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0;k=i;i=i+16|0;l=k|0;m=c[b+48>>2]|0;c[l>>2]=18728;c[l+4>>2]=m;c[l+8>>2]=d;d=c[b+52>>2]|0;b=d|0;m=l|0;if((a[d+60|0]&1)==0){azp(b,m,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,j);i=k;return}else{azq(b,m,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,j,c[d+56>>2]|0);i=k;return}}function ZI(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43224]|0)==0){if((b1(43224)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+68>>2]&511](f,b|0,d);d=f;c[9758]=c[d>>2];c[9759]=c[d+4>>2];c[9760]=c[d+8>>2];c[9761]=c[d+12>>2];i=e;return 39032}function ZJ(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function ZK(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function ZL(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function ZM(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function ZN(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function ZO(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+72>>2]&2047](a,b);return}function ZP(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0;e=i;i=i+16|0;f=e|0;g[f>>2]=1.0;g[f+4>>2]=1.0;g[f+8>>2]=1.0;g[f+12>>2]=0.0;c[b+52>>2]=d;a[b+61|0]=0;d=b|0;h=cA[c[(c[b>>2]|0)+28>>2]&4095](d)|0;j=+g[h>>2]+-1.0;k=+g[h+4>>2]+-1.0;l=+g[h+8>>2]+-1.0;if(j*j+k*k+l*l<=1.1920928955078125e-7){i=e;return}aBB(d,f);i=e;return}function ZQ(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0;c[b+52>>2]=d;a[b+61|0]=0;d=b|0;f=cA[c[(c[b>>2]|0)+28>>2]&4095](d)|0;h=+g[f>>2]- +g[e>>2];i=+g[f+4>>2]- +g[e+4>>2];j=+g[f+8>>2]- +g[e+8>>2];if(h*h+i*i+j*j<=1.1920928955078125e-7){return}aBB(d,e);return}function ZR(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+8>>2]&511](a,b,d)|0}function ZS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a|0,b);return}function ZT(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return+(+db[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f))}function ZU(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+8>>2]&255](a|0,b,d,e,f);return}function ZV(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function ZW(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function ZX(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function ZY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function ZZ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function Z_(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;do{if((a[43864]|0)==0){if((b1(43864)|0)==0){break}}}while(0);d=(+g[b+176>>2]+ +g[b+180>>2])*.5;e=+g[b+944>>2]*d+ +g[b+960>>2];f=d*+g[b+948>>2]+ +g[b+964>>2];h=d*+g[b+952>>2]+ +g[b+968>>2];i=c[b+24>>2]|0;d=+g[i+4>>2];j=+g[i+20>>2];k=+g[i+36>>2];l=+g[i+8>>2];m=+g[i+24>>2];n=+g[i+40>>2];o=+g[i+12>>2];p=+g[i+28>>2];q=+g[i+44>>2];r=-0.0- +g[i+52>>2];s=-0.0- +g[i+56>>2];t=-0.0- +g[i+60>>2];g[9754]=d*r+j*s+k*t+(d*e+j*f+k*h);g[9755]=l*r+m*s+n*t+(l*e+m*f+n*h);g[9756]=o*r+p*s+q*t+(o*e+p*f+q*h);g[9757]=0.0;return 39016}function Z$(a,b){a=a|0;b=+b;g[a+216>>2]=b;return}function Z0(b){b=b|0;return(a[b+288|0]&1)!=0|0}function Z1(b){b=b|0;return(a[b+41|0]&1)!=0|0}function Z2(a){a=a|0;return+(+g[a+1112>>2])}function Z3(a,b){a=a|0;b=+b;g[a+212>>2]=b;return}function Z4(b){b=b|0;return(a[b+21|0]&1)!=0|0}function Z5(a){a=a|0;return+(+g[a+1096>>2])}function Z6(a){a=a|0;return c[a+4>>2]|0}function Z7(a,b){a=a|0;b=+b;g[a+264>>2]=b;return}function Z8(b){b=b|0;return(a[b+289|0]&1)!=0|0}function Z9(b,c){b=b|0;c=c|0;a[b+1104|0]=c&1;return}function _a(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function _b(a){a=a|0;return+(+g[a+1072>>2])}function _c(a){a=a|0;return a+880|0}function _d(a){a=a|0;return a+816|0}function _e(a){a=a|0;return c[a+4>>2]|0}function _f(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function _g(a,b){a=a|0;b=+b;g[a+200>>2]=b;return}function _h(a){a=a|0;return+(+g[a+188>>2])}function _i(a){a=a|0;return+(+g[a+244>>2])}function _j(a){a=a|0;return+(+g[a+256>>2])}function _k(a,b){a=a|0;b=+b;g[a+176>>2]=b;return}function _l(a){a=a|0;return+(+g[a+196>>2])}function _m(a,b){a=a|0;b=b|0;c[b>>2]=6;c[b+4>>2]=0;return}function _n(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function _o(a){a=a|0;return c[a+12>>2]|0}function _p(a,b){a=a|0;b=+b;g[a+1092>>2]=b;return}function _q(a){a=a|0;return+(+g[a+180>>2])}function _r(a,b){a=a|0;b=+b;g[a+1096>>2]=b;return}function _s(a){a=a|0;return+(+g[a+184>>2])}function _t(a){a=a|0;return+(+g[a+16>>2])}function _u(a,b){a=a|0;b=+b;g[a+192>>2]=b;return}function _v(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function _w(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function _x(a){a=a|0;return a+44|0}function _y(a){a=a|0;return a+108|0}function _z(a){a=a|0;return+(+g[a+216>>2])}function _A(a){a=a|0;return+(+g[a+228>>2])}function _B(a){a=a|0;return+(+g[a+272>>2])}function _C(a,b){a=a|0;b=+b;g[a+256>>2]=b;return}function _D(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function _E(a){a=a|0;return+(+g[a+200>>2])}function _F(a){a=a|0;return+(+g[a+36>>2])}function _G(a){a=a|0;return c[a+12>>2]|0}function _H(a){a=a|0;return+(+g[a+224>>2])}function _I(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function _J(b,c){b=b|0;c=c|0;a[b+1088|0]=c&1;return}function _K(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function _L(a){a=a|0;return+(+g[a+1024>>2])}function _M(a){a=a|0;return+(+g[a+232>>2])}function _N(a){a=a|0;return+(+g[a+212>>2])}function _O(a){a=a|0;return+(+g[a+32>>2])}function _P(a){a=a|0;return+(+g[a+248>>2])}function _Q(a,b){a=a|0;b=+b;g[a+260>>2]=b;return}function _R(a,b){a=a|0;b=+b;g[a+196>>2]=b;return}function _S(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function _T(b){b=b|0;do{if((a[43856]|0)==0){if((b1(43856)|0)==0){break}}}while(0);aDG(39e3,b+156|0,16);return 39e3}function _U(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function _V(a){a=a|0;aqT(a);return}function _W(a,b){a=a|0;b=+b;var c=0.0,d=0.0;c=+ck(+b,6.2831854820251465);do{if(c<-3.1415927410125732){d=c+6.2831854820251465}else{if(c<=3.1415927410125732){d=c;break}d=c-6.2831854820251465}}while(0);g[a+188>>2]=d;return}function _X(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=+g;h=+h;aqV(a,b,c,d,e,f,g,h);return}function _Y(a,b,c){a=a|0;b=b|0;c=c|0;aqR(a,b,c);return}function _Z(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function __(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function _$(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function _0(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function _1(a){a=a|0;return c[a+12>>2]|0}function _2(a,b){a=a|0;b=+b;g[a+208>>2]=b;return}function _3(a,b){a=a|0;b=+b;g[a+180>>2]=b;return}function _4(a,b){a=a|0;b=+b;g[a+1108>>2]=b;return}function _5(a){a=a|0;return+(+g[a+208>>2])}function _6(a,b){a=a|0;b=+b;g[a+1112>>2]=b;return}function _7(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function _8(a){a=a|0;return c[a+4>>2]|0}function _9(b){b=b|0;return(a[b+1104|0]&1)!=0|0}function $a(a){a=a|0;return+(+g[a+280>>2])}function $b(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function $c(a){a=a|0;return+(+g[a+260>>2])}function $d(a){a=a|0;return+(+g[a+1092>>2])}function $e(b){b=b|0;var c=0,d=0,e=0.0,f=0.0,h=0.0;c=b+288|0;a[c]=0;d=b+1024|0;e=+g[d>>2];g[b+1072>>2]=e;f=+g[b+176>>2];h=+g[b+180>>2];if(f>h){g[d>>2]=0.0;return}if(e>h){g[d>>2]=e-h;a[c]=1;return}if(e<f){g[d>>2]=e-f;a[c]=1;return}else{g[d>>2]=0.0;return}}function $f(a){a=a|0;return+(+g[a+176>>2])}function $g(a,b){a=a|0;b=+b;g[a+280>>2]=b;return}function $h(a){a=a|0;return c[a+8>>2]|0}function $i(a,b){a=a|0;b=+b;g[a+276>>2]=b;return}function $j(a){a=a|0;return+(+g[a+276>>2])}function $k(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function $l(a){a=a|0;return+(+g[a+264>>2])}function $m(a){a=a|0;return+(+g[a+32>>2])}function $n(a){a=a|0;return+(+g[a+240>>2])}function $o(a,b){a=a|0;b=+b;g[a+272>>2]=b;return}function $p(a,b){a=a|0;b=+b;g[a+232>>2]=b;return}function $q(a){a=a|0;return+(+g[a+192>>2])}function $r(b){b=b|0;return(a[b+172|0]&1)!=0|0}function $s(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function $t(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function $u(a){a=a|0;return+(+g[a+12>>2])}function $v(a,b){a=a|0;b=+b;g[a>>2]=b;return}function $w(a){a=a|0;return+(+g[a+16>>2])}function $x(a){a=a|0;return+(+g[a+8>>2])}function $y(a){a=a|0;return+(+g[a>>2])}function $z(a){a=a|0;return+(+g[a+4>>2])}function $A(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function $B(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function $C(a,b){a=a|0;b=+b;g[a+20>>2]=b;return}function $D(a){a=a|0;return+(+g[a+20>>2])}function $E(a){a=a|0;return c[a+28>>2]|0}function $F(a){a=a|0;return c[a+24>>2]|0}function $G(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function $H(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function $I(a,b){a=a|0;b=+b;var c=0.0,d=0.0;c=+ck(+b,6.2831854820251465);do{if(c<-3.1415927410125732){d=c+6.2831854820251465}else{if(c<=3.1415927410125732){d=c;break}d=c-6.2831854820251465}}while(0);g[a+184>>2]=d;return}function $J(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function $K(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+44|0;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+60|0;e=b+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+76|0;f=b+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+92|0;e=b+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+108|0;f=d;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+124|0;e=d+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+140|0;f=d+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+156|0;e=d+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];aqR(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);ct[c[(c[a>>2]|0)+8>>2]&2047](a|0);return}function $L(a){a=a|0;if((a|0)==0){return}aDB(a);return}function $M(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function $N(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0;f=i;i=i+112|0;h=f|0;j=f+48|0;k=e&1;while(1){l=aDx(1120)|0;if((l|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){m=80;break}dC[e&63]()}if((m|0)==80){m=cd(4)|0;c[m>>2]=19096;bF(m|0,34368,676);return 0}m=l;e=j;aq2();c[l+4>>2]=7;c[l+8>>2]=-1;c[l+12>>2]=-1;g[l+16>>2]=3.4028234663852886e+38;a[l+20|0]=1;a[l+21|0]=0;n=l+24|0;c[n>>2]=41520;o=l+28|0;c[o>>2]=b;g[l+32>>2]=0.0;g[l+36>>2]=.30000001192092896;c[l>>2]=23056;a[l+40|0]=0;p=l+108|0;q=d;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];q=l+124|0;r=d+16|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];r=l+140|0;q=d+32|0;c[r>>2]=c[q>>2];c[r+4>>2]=c[q+4>>2];c[r+8>>2]=c[q+8>>2];c[r+12>>2]=c[q+12>>2];q=l+156|0;r=d+48|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];a[l+172|0]=k;k=l+44|0;r=b+4|0;q=h;anx(h,r|0,p);s=+g[l+156>>2];t=+g[l+160>>2];u=+g[l+164>>2];v=+g[r>>2]*s+ +g[b+8>>2]*t+ +g[b+12>>2]*u+ +g[b+52>>2];w=+g[b+20>>2]*s+ +g[b+24>>2]*t+ +g[b+28>>2]*u+ +g[b+56>>2];x=+g[b+36>>2]*s+ +g[b+40>>2]*t+ +g[b+44>>2]*u+ +g[b+60>>2];b=j+48|0;r=j|0;do{r=r+16|0;}while((r|0)!=(b|0));c[e>>2]=c[q>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];q=j+16|0;b=h+16|0;c[q>>2]=c[b>>2];c[q+4>>2]=c[b+4>>2];c[q+8>>2]=c[b+8>>2];c[q+12>>2]=c[b+12>>2];b=j+32|0;r=h+32|0;c[b>>2]=c[r>>2];c[b+4>>2]=c[r+4>>2];c[b+8>>2]=c[r+8>>2];c[b+12>>2]=c[r+12>>2];g[j+48>>2]=v;g[j+52>>2]=w;g[j+56>>2]=x;g[j+60>>2]=0.0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];e=l+60|0;c[e>>2]=c[q>>2];c[e+4>>2]=c[q+4>>2];c[e+8>>2]=c[q+8>>2];c[e+12>>2]=c[q+12>>2];q=l+76|0;c[q>>2]=c[b>>2];c[q+4>>2]=c[b+4>>2];c[q+8>>2]=c[b+8>>2];c[q+12>>2]=c[b+12>>2];b=l+92|0;q=j+48|0;c[b>>2]=c[q>>2];c[b+4>>2]=c[q+4>>2];c[b+8>>2]=c[q+8>>2];c[b+12>>2]=c[q+12>>2];g[l+176>>2]=1.0;g[l+180>>2]=-1.0;g[l+184>>2]=0.0;g[l+188>>2]=0.0;g[l+192>>2]=1.0;g[l+196>>2]=.699999988079071;g[l+200>>2]=0.0;g[l+204>>2]=0.0;g[l+208>>2]=1.0;g[l+212>>2]=.699999988079071;g[l+216>>2]=0.0;g[l+220>>2]=0.0;g[l+256>>2]=1.0;g[l+260>>2]=.699999988079071;g[l+264>>2]=1.0;g[l+268>>2]=0.0;g[l+272>>2]=1.0;g[l+276>>2]=.699999988079071;g[l+280>>2]=1.0;g[l+284>>2]=0.0;g[l+224>>2]=1.0;g[l+228>>2]=.699999988079071;g[l+232>>2]=1.0;g[l+236>>2]=0.0;g[l+240>>2]=1.0;g[l+244>>2]=.699999988079071;g[l+248>>2]=1.0;g[l+252>>2]=0.0;a[l+1088|0]=0;g[l+1108>>2]=0.0;g[l+1112>>2]=0.0;g[l+1116>>2]=0.0;c[l+292>>2]=0;aDD(l+1092|0,0,13);a[l+41|0]=1;aqR(m,(c[n>>2]|0)+4|0,(c[o>>2]|0)+4|0);i=f;return m|0}function $O(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0;i=h&1;while(1){j=aDx(1120)|0;if((j|0)!=0){k=99;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){break}dC[h&63]()}if((k|0)==99){k=j;c[j+4>>2]=7;c[j+8>>2]=-1;c[j+12>>2]=-1;g[j+16>>2]=3.4028234663852886e+38;a[j+20|0]=1;a[j+21|0]=0;c[j+24>>2]=b;c[j+28>>2]=d;g[j+32>>2]=0.0;g[j+36>>2]=.30000001192092896;c[j>>2]=23056;a[j+40|0]=0;h=j+44|0;l=e;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];l=j+60|0;h=e+16|0;c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];h=j+76|0;l=e+32|0;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];l=j+92|0;h=e+48|0;c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];h=j+108|0;l=f;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];l=j+124|0;h=f+16|0;c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];h=j+140|0;l=f+32|0;c[h>>2]=c[l>>2];c[h+4>>2]=c[l+4>>2];c[h+8>>2]=c[l+8>>2];c[h+12>>2]=c[l+12>>2];l=j+156|0;h=f+48|0;c[l>>2]=c[h>>2];c[l+4>>2]=c[h+4>>2];c[l+8>>2]=c[h+8>>2];c[l+12>>2]=c[h+12>>2];a[j+172|0]=i;g[j+176>>2]=1.0;g[j+180>>2]=-1.0;g[j+184>>2]=0.0;g[j+188>>2]=0.0;g[j+192>>2]=1.0;g[j+196>>2]=.699999988079071;g[j+200>>2]=0.0;g[j+204>>2]=0.0;g[j+208>>2]=1.0;g[j+212>>2]=.699999988079071;g[j+216>>2]=0.0;g[j+220>>2]=0.0;g[j+256>>2]=1.0;g[j+260>>2]=.699999988079071;g[j+264>>2]=1.0;g[j+268>>2]=0.0;g[j+272>>2]=1.0;g[j+276>>2]=.699999988079071;g[j+280>>2]=1.0;g[j+284>>2]=0.0;g[j+224>>2]=1.0;g[j+228>>2]=.699999988079071;g[j+232>>2]=1.0;g[j+236>>2]=0.0;g[j+240>>2]=1.0;g[j+244>>2]=.699999988079071;g[j+248>>2]=1.0;g[j+252>>2]=0.0;a[j+1088|0]=0;g[j+1108>>2]=0.0;g[j+1112>>2]=0.0;g[j+1116>>2]=0.0;c[j+292>>2]=0;aDD(j+1092|0,0,13);a[j+41|0]=1;aqR(k,b+4|0,d+4|0);return k|0}k=cd(4)|0;c[k>>2]=19096;bF(k|0,34368,676);return 0}function $P(){var a=0,b=0,d=0;while(1){a=aDx(24)|0;if((a|0)!=0){b=111;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==111){g[a>>2]=5.880000114440918;g[a+4>>2]=.8299999833106995;g[a+8>>2]=.8799999952316284;g[a+12>>2]=500.0;g[a+16>>2]=10.5;g[a+20>>2]=6.0e3;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function $Q(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function $R(a){a=a|0;return a+40|0}function $S(a){a=a|0;return c[a+12>>2]|0}function $T(a){a=a|0;return c[a+4>>2]|0}function $U(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function $V(b){b=b|0;return(a[b+20|0]&1)!=0|0}function $W(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function $X(a){a=a|0;return c[a+4>>2]|0}function $Y(a){a=a|0;return+(+g[a+36>>2])}function $Z(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function $_(b){b=b|0;return(a[b+21|0]&1)!=0|0}function $$(a){a=a|0;return c[a+4>>2]|0}function $0(a){a=a|0;return c[a+12>>2]|0}function $1(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function $2(a){a=a|0;return c[a+12>>2]|0}function $3(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function $4(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function $5(a){a=a|0;return+(+g[a+32>>2])}function $6(a){a=a|0;return+(+g[a+16>>2])}function $7(a){a=a|0;return c[a+8>>2]|0}function $8(a){a=a|0;return+(+g[a+32>>2])}function $9(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function aaa(a){a=a|0;return+(+g[a+136>>2])}function aab(a){a=a|0;return+(+g[a+140>>2])}function aac(a,b){a=a|0;b=+b;g[a+112>>2]=b;return}function aad(a,b){a=a|0;b=+b;g[a+136>>2]=b;return}function aae(a){a=a|0;return+(+g[a+84>>2])}function aaf(a){a=a|0;return c[a+92>>2]|0}function aag(a){a=a|0;return c[a+96>>2]|0}function aah(a){a=a|0;return a+64|0}function aai(a,b){a=a|0;b=+b;g[a+84>>2]=b;return}function aaj(a){a=a|0;return c[a+104>>2]|0}function aak(a){a=a|0;return c[a+100>>2]|0}function aal(a,b){a=a|0;b=b|0;c[a+108>>2]=b;return}function aam(a,b){a=a|0;b=+b;g[a+140>>2]=b;return}function aan(a){a=a|0;return+(+g[a+112>>2])}function aao(a){a=a|0;return c[a+108>>2]|0}function aap(a){a=a|0;return+(+g[a+80>>2])}function aaq(a){a=a|0;return c[a+144>>2]|0}function aar(a){a=a|0;return a+32|0}function aas(a){a=a|0;return a+48|0}function aat(a,b){a=a|0;b=b|0;c[a+92>>2]=b;return}function aau(a,b){a=a|0;b=b|0;c[a+96>>2]=b;return}function aav(a,b){a=a|0;b=+b;g[a+80>>2]=b;return}function aaw(a){a=a|0;return+(+g[a+120>>2])}function aax(a){a=a|0;return+(+g[a+124>>2])}function aay(b,c){b=b|0;c=c|0;a[b+116|0]=c&1;return}function aaz(a){a=a|0;return c[a+144>>2]|0}function aaA(a,b){a=a|0;b=b|0;c[a+100>>2]=b;return}function aaB(a){a=a|0;return+(+g[a+128>>2])}function aaC(a){a=a|0;return+(+g[a+132>>2])}function aaD(a,b){a=a|0;b=b|0;c[a+104>>2]=b;return}function aaE(a){a=a|0;return a+148|0}function aaF(a,b){a=a|0;b=+b;g[a+88>>2]=b;return}function aaG(a){a=a|0;return a+48|0}function aaH(a){a=a|0;return a+164|0}function aaI(a){a=a|0;return a+32|0}function aaJ(a,b){a=a|0;b=+b;g[a+120>>2]=b;return}function aaK(a,b){a=a|0;b=+b;g[a+124>>2]=b;return}function aaL(b){b=b|0;return(a[b+116|0]&1)!=0|0}function aaM(a){a=a|0;return+(+g[a+88>>2])}function aaN(a,b){a=a|0;b=+b;g[a+128>>2]=b;return}function aaO(a,b){a=a|0;b=+b;g[a+132>>2]=b;return}function aaP(a){a=a|0;return a+16|0}function aaQ(a){a=a|0;return a|0}function aaR(a,b){a=a|0;b=+b;g[a+80>>2]=b;return}function aaS(a){a=a|0;return+(+g[a+80>>2])}function aaT(a){a=a|0;return+(+g[a+112>>2])}function aaU(a,b){a=a|0;b=b|0;c[a+144>>2]=b;return}function aaV(a){a=a|0;return a+4|0}function aaW(a){a=a|0;return c[a+28>>2]|0}function aaX(a){a=a|0;return c[a+12>>2]|0}function aaY(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function aaZ(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function aa_(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function aa$(a){a=a|0;return c[a+12>>2]|0}function aa0(a){a=a|0;return c[a+4>>2]|0}function aa1(a){a=a|0;return c[a+24>>2]|0}function aa2(b,c){b=b|0;c=c|0;a[b+336|0]=c&1;return}function aa3(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a|0,b,d)|0}function aa4(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a|0,b,d,-1);return}function aa5(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a|0,b,d,e);return}function aa6(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a|0,b,-1))}function aa7(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a|0,b,d))}function aa8(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function aa9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function aba(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function abb(a,b){a=a|0;b=b|0;var c=0;c=a+40|0;a=b;aDC(c|0,a|0,1140)|0;return}function abc(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function abd(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function abe(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function abf(a,b){a=a|0;b=b|0;var d=0;d=a+148|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abg(a,b){a=a|0;b=b|0;var d=0;d=a+48|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abh(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abi(a){a=a|0;if((a|0)==0){return}aDB(a);return}function abj(a,b){a=a|0;b=b|0;var d=0;d=a+64|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abk(a,b){a=a|0;b=b|0;var d=0;d=a+164|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abl(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abm(a,b){a=a|0;b=b|0;var d=0;d=a;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abn(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e,f,g,h,i,j,0);return}function abo(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e,f,g,h,i,j,k);return}function abp(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function abq(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+40|0;f=e|0;c[f>>2]=18624;g[f+4>>2]=999999984306749400.0;g[f+8>>2]=999999984306749400.0;g[f+12>>2]=999999984306749400.0;g[f+16>>2]=0.0;g[f+20>>2]=-999999984306749400.0;g[f+24>>2]=-999999984306749400.0;g[f+28>>2]=-999999984306749400.0;g[f+32>>2]=0.0;g[b>>2]=-999999984306749400.0;g[b+4>>2]=-999999984306749400.0;g[b+8>>2]=-999999984306749400.0;g[b+12>>2]=0.0;g[d>>2]=999999984306749400.0;g[d+4>>2]=999999984306749400.0;g[d+8>>2]=999999984306749400.0;g[d+12>>2]=0.0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,f|0,b,d);a=b;b=f+4|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];b=d;d=f+20|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];i=e;return}function abr(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+56>>2]&511](a,b,d)|0}function abs(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function abt(a){a=a|0;return cA[c[(c[a>>2]|0)+52>>2]&4095](a)|0}function abu(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function abv(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function abw(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function abx(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a,b,d);return}function aby(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function abz(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,0);return}function abA(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,k);return}function abB(a){a=a|0;return cA[c[(c[a>>2]|0)+40>>2]&4095](a)|0}function abC(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function abD(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function abE(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;apD(a,b,c,d);return}function abF(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function abG(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function abH(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function abI(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function abJ(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function abK(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function abL(){var b=0,d=0,e=0;while(1){b=aDx(276)|0;if((b|0)!=0){d=254;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){break}dC[e&63]()}if((d|0)==254){c[b+108>>2]=0;g[b+112>>2]=0.0;a[b+116|0]=0;aDD(b+120|0,0,28);return b|0}b=cd(4)|0;c[b>>2]=19096;bF(b|0,34368,676);return 0}function abM(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,i=0,j=0;while(1){h=aDx(276)|0;if((h|0)!=0){i=266;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==266){i=b;c[h>>2]=c[i>>2];c[h+4>>2]=c[i+4>>2];c[h+8>>2]=c[i+8>>2];c[h+12>>2]=c[i+12>>2];i=h+16|0;b=d;c[i>>2]=c[b>>2];c[i+4>>2]=c[b+4>>2];c[i+8>>2]=c[b+8>>2];c[i+12>>2]=c[b+12>>2];b=h+64|0;i=e;c[b>>2]=c[i>>2];c[b+4>>2]=c[i+4>>2];c[b+8>>2]=c[i+8>>2];c[b+12>>2]=c[i+12>>2];g[h+80>>2]=f;g[h+84>>2]=0.0;g[h+88>>2]=0.0;c[h+108>>2]=0;g[h+112>>2]=0.0;a[h+116|0]=0;g[h+208>>2]=0.0;g[h+240>>2]=0.0;g[h+272>>2]=0.0;aDD(h+120|0,0,28);return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function abN(a,b){a=a|0;b=+b;return}function abO(a){a=a|0;return c[a+4>>2]|0}function abP(a){a=a|0;return a+292|0}function abQ(a){a=a|0;return a+308|0}function abR(a){a=a|0;return a+340|0}function abS(b){b=b|0;return(a[b+20|0]&1)!=0|0}function abT(a){a=a|0;return c[a+4>>2]|0}function abU(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function abV(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function abW(b){b=b|0;return(a[b+21|0]&1)!=0|0}function abX(a){a=a|0;return c[a+12>>2]|0}function abY(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+336|0]&1)==0){c[e>>2]=3;c[d+4>>2]=3;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function abZ(a){a=a|0;return+(+g[a+36>>2])}function ab_(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function ab$(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function ab0(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function ab1(a){a=a|0;return+(+g[a+32>>2])}function ab2(b){b=b|0;return(a[b+336|0]&1)!=0|0}function ab3(a){a=a|0;return+(+g[a+16>>2])}function ab4(a){a=a|0;return c[a+8>>2]|0}function ab5(a){a=a|0;return+(+g[a+32>>2])}function ab6(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function ab7(a){a=a|0;return(c[a+4>>2]|0)==31|0}function ab8(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function ab9(a){a=a|0;return c[a+52>>2]|0}function aca(a){a=a|0;return(c[a+4>>2]|0)<7|0}function acb(a){a=a|0;return a+12|0}function acc(a){a=a|0;return+(+g[a+44>>2])}function acd(a){a=a|0;return(c[a+4>>2]|0)<20|0}function ace(a){a=a|0;return(c[a+4>>2]|0)==28|0}function acf(a){a=a|0;return c[a+8>>2]|0}function acg(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function ach(a){a=a|0;return a+28|0}function aci(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function acj(a){a=a|0;return(c[a+4>>2]|0)==32|0}function ack(a){a=a|0;return a+28|0}function acl(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function acm(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function acn(a,b){a=a|0;b=b|0;var d=0;d=a+340|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];return}function aco(a,b){a=a|0;b=b|0;var d=0;d=a+292|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function acp(a,b){a=a|0;b=b|0;var d=0;d=a+308|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function acq(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function acr(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function acs(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a|0,b,d,e,f);return}function act(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e);return}function acu(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function acv(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43648]|0)==0){if((b1(43648)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9746]=c[d>>2];c[9747]=c[d+4>>2];c[9748]=c[d+8>>2];c[9749]=c[d+12>>2];i=e;return 38984}function acw(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function acx(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function acy(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function acz(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+84>>2]&1023](a))}function acA(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function acB(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function acC(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function acD(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43176]|0)==0){if((b1(43176)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9742]=c[d>>2];c[9743]=c[d+4>>2];c[9744]=c[d+8>>2];c[9745]=c[d+12>>2];i=e;return 38968}function acE(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function acF(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function acG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function acH(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43496]|0)==0){if((b1(43496)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9738]=c[d>>2];c[9739]=c[d+4>>2];c[9740]=c[d+8>>2];c[9741]=c[d+12>>2];i=e;return 38952}function acI(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function acJ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function acK(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function acL(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43352]|0)==0){if((b1(43352)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9734]=c[d>>2];c[9735]=c[d+4>>2];c[9736]=c[d+8>>2];c[9737]=c[d+12>>2];i=e;return 38936}function acM(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function acN(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function acO(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function acP(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function acQ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function acR(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function acS(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function acT(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,i=0.0;c[9806]=(c[9806]|0)+1;b=aDx(75)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}e=d+4|0;c[e>>2]=35;c[d+8>>2]=0;b=d|0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[b>>2]=24848;f=d+52|0;c[f>>2]=1;h=+g[a+4>>2]+-.03999999910593033;i=+g[a+8>>2]+-.03999999910593033;g[d+28>>2]=+g[a>>2]+-.03999999910593033;g[d+32>>2]=h;g[d+36>>2]=i;g[d+40>>2]=0.0;c[e>>2]=13;c[b>>2]=24152;c[f>>2]=2;return d|0}function acU(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function acV(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function acW(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;while(1){e=aDx(352)|0;if((e|0)!=0){f=386;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){f=383;break}dC[h&63]()}if((f|0)==383){h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}else if((f|0)==386){aq1(e,3,b);c[e>>2]=21336;f=e+292|0;h=d;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];i=+g[d>>2];j=+g[d+4>>2];k=+g[d+8>>2];l=+g[b+56>>2]+(i*+g[b+20>>2]+j*+g[b+24>>2]+k*+g[b+28>>2]);m=+g[b+60>>2]+(i*+g[b+36>>2]+j*+g[b+40>>2]+k*+g[b+44>>2]);g[e+308>>2]=+g[b+52>>2]+(+g[b+4>>2]*i+ +g[b+8>>2]*j+ +g[b+12>>2]*k);g[e+312>>2]=l;g[e+316>>2]=m;g[e+320>>2]=0.0;c[e+324>>2]=0;a[e+336|0]=0;g[e+340>>2]=.30000001192092896;g[e+344>>2]=1.0;g[e+348>>2]=0.0;return e|0}return 0}function acX(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0;while(1){h=aDx(352)|0;if((h|0)!=0){i=400;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==400){c[h+4>>2]=3;c[h+8>>2]=-1;c[h+12>>2]=-1;g[h+16>>2]=3.4028234663852886e+38;a[h+20|0]=1;a[h+21|0]=0;c[h+24>>2]=b;c[h+28>>2]=d;g[h+32>>2]=0.0;g[h+36>>2]=.30000001192092896;c[h>>2]=21336;d=h+292|0;b=e;c[d>>2]=c[b>>2];c[d+4>>2]=c[b+4>>2];c[d+8>>2]=c[b+8>>2];c[d+12>>2]=c[b+12>>2];b=h+308|0;d=f;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];c[h+324>>2]=0;a[h+336|0]=0;g[h+340>>2]=.30000001192092896;g[h+344>>2]=1.0;g[h+348>>2]=0.0;return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function acY(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function acZ(a){a=a|0;return c[a+4>>2]|0}function ac_(a){a=a|0;return c[a+16>>2]|0}function ac$(a){a=a|0;return c[a+12>>2]|0}function ac0(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function ac1(a,c){a=a|0;c=c|0;b[a>>1]=b[c>>1]|0;b[a+2>>1]=b[c+2>>1]|0;b[a+4>>1]=b[c+4>>1]|0;b[a+6>>1]=b[c+6>>1]|0;b[a+8>>1]=b[c+8>>1]|0;b[a+10>>1]=b[c+10>>1]|0;return}function ac2(a,b){a=a|0;b=b|0;c[a+16>>2]=b;return}function ac3(a){a=a|0;return a+28|0}function ac4(a,c){a=a|0;c=c|0;b[a+8>>1]=c;return}function ac5(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function ac6(a){a=a|0;return+(+g[a+4>>2])}function ac7(a){a=a|0;return c[a+76>>2]|0}function ac8(a,b){a=a|0;b=b|0;c[a+76>>2]=b;return}function ac9(a){a=a|0;return a+44|0}function ada(a){a=a|0;return a+60|0}function adb(a){a=a|0;return b[a+10>>1]|0}function adc(a){a=a|0;return+g[a+4>>2]<1.0|0}function add(a){a=a|0;return a+12|0}function ade(a){a=a|0;return b[a+8>>1]|0}function adf(a,c){a=a|0;c=c|0;b[a+10>>1]=c;return}function adg(a){a=a|0;return+(+g[a+88>>2])}function adh(a){a=a|0;return c[a+28>>2]|0}function adi(a){a=a|0;return c[a+12>>2]|0}function adj(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function adk(b,c){b=b|0;c=c|0;a[b+20|0]=c&1;return}function adl(a){a=a|0;return a+40|0}function adm(a,b){a=a|0;b=b|0;return+(+g[a+1248+(b<<2)>>2])}function adn(a){a=a|0;return a+104|0}function ado(a){a=a|0;return a+1056|0}function adp(a){a=a|0;return c[a+12>>2]|0}function adq(a){a=a|0;return c[a+4>>2]|0}function adr(a){a=a|0;return c[a+24>>2]|0}function ads(a){a=a|0;return+(+g[a+16>>2])}function adt(a,b,c){a=a|0;b=b|0;c=+c;g[a+1356+(b<<2)>>2]=c;return}function adu(a,b){a=a|0;b=b|0;var c=0;c=a;a=0;while(1){if((a|0)>=3){break}g[b+(a<<2)>>2]=+g[c+860+(a<<6)>>2];a=a+1|0}return}function adv(a,b,c){a=a|0;b=b|0;c=+c;g[a+1308+(b<<2)>>2]=c;return}function adw(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0;do{if((a[43656]|0)==0){if((b1(43656)|0)==0){break}}}while(0);d=+g[b+28>>2];e=+g[b+32>>2];f=+g[b+36>>2];h=+g[b+40>>2];i=b|0;j=b;k=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);l=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);m=f+ +dh[c[(c[j>>2]|0)+44>>2]&1023](i);g[9730]=d+k;g[9731]=e+l;g[9732]=m;g[9733]=h;return 38920}function adx(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-32+28>>2]|0);return}function ady(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(51)|0;if((a|0)==0){b=0;return b|0}d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0;return b|0}function adz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a,b);return}function adA(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+8>>2]&2047](a,b);return}function adB(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function adC(a,b){a=a|0;b=b|0;return dj[c[(c[a>>2]|0)+8>>2]&511](a|0,b)|0}function adD(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+12>>2]&127](a,b,d))}function adE(a,b){a=a|0;b=b|0;var d=0;d=a+60|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function adF(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function adG(a,b){a=a|0;b=b|0;var d=0;d=a+44|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function adH(a,b){a=a|0;b=b|0;var d=0;d=a+12|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function adI(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0,y=0,z=0;e=i;i=i+96|0;f=e|0;h=e+16|0;j=e+32|0;k=e+48|0;l=e+64|0;m=e+80|0;n=f;o=h;p=b+48|0;q=d+48|0;ec(b|0,f);ec(d|0,h);d=a+88|0;b=a+32|0;if(+g[d>>2]>0.0){anu(b,p,a|0,f,j,k);f=a+48|0;r=a+16|0;anu(f,q,r,h,l,m);s=+g[k>>2];t=+g[k+4>>2];u=+g[k+8>>2];v=+Q(+(s*s+t*t+u*u));u=v*+g[a+80>>2];v=+g[m>>2];t=+g[m+4>>2];s=+g[m+8>>2];w=+Q(+(v*v+t*t+s*s));s=(+g[l>>2]- +g[j>>2])*+g[a+64>>2]+(+g[l+4>>2]- +g[j+4>>2])*+g[a+68>>2]+(+g[l+8>>2]- +g[j+8>>2])*+g[a+72>>2];g[d>>2]=+g[d>>2]-(u+w*+g[a+84>>2]+(s<0.0?0.0:s));x=b;y=f;z=r}else{x=b;y=a+48|0;z=a+16|0}b=x;x=p;c[b>>2]=c[x>>2];c[b+4>>2]=c[x+4>>2];c[b+8>>2]=c[x+8>>2];c[b+12>>2]=c[x+12>>2];x=y;y=q;c[x>>2]=c[y>>2];c[x+4>>2]=c[y+4>>2];c[x+8>>2]=c[y+8>>2];c[x+12>>2]=c[y+12>>2];y=a;c[y>>2]=c[n>>2];c[y+4>>2]=c[n+4>>2];c[y+8>>2]=c[n+8>>2];c[y+12>>2]=c[n+12>>2];n=z;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];i=e;return}function adJ(a){a=a|0;if((a|0)==0){return}aDB(a);return}function adK(a,b,d,e,f){a=a|0;b=b|0;d=+d;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0;h=i;i=i+32|0;j=h|0;k=h+16|0;l=j;m=k;g[a+88>>2]=d;if(d<=0.0){i=h;return}n=a+64|0;o=b;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];ec(e|0,j);ec(f|0,k);k=a+32|0;j=e+48|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];j=a+48|0;k=f+48|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=a;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];l=a+16|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];i=h;return}function adL(a){a=a|0;ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function adM(a,b,d){a=a|0;b=b|0;d=+d;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,-1);return}function adN(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;cE[c[(c[a>>2]|0)+28>>2]&127](a,b,d,e);return}function adO(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;apb(a,b,c,d,e,f,g,h);return}function adP(a,b){a=a|0;b=b|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,-1))}function adQ(a,b,d){a=a|0;b=b|0;d=d|0;return+(+c4[c[(c[a>>2]|0)+32>>2]&127](a,b,d))}function adR(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function adS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function adT(a){a=a|0;ct[c[(c[a>>2]|0)+44>>2]&2047](a);return}function adU(a){a=a|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);g[a+1308>>2]=+g[a+1248>>2];g[a+1312>>2]=+g[a+1252>>2];g[a+1316>>2]=+g[a+1256>>2];g[a+1320>>2]=+g[a+1184>>2];g[a+1324>>2]=+g[a+1188>>2];g[a+1328>>2]=+g[a+1192>>2];return}function adV(a,b){a=a|0;b=b|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);if((b|0)<3){g[a+1308+(b<<2)>>2]=+g[a+1248+(b<<2)>>2];return}else{g[a+1308+(b<<2)>>2]=+g[a+1184+(b-3<<2)>>2];return}}function adW(a,d){a=a|0;d=d|0;var e=0,f=0,h=0;while(1){e=aDx(80)|0;if((e|0)!=0){f=508;break}h=(C=c[10744]|0,c[10744]=C+0,C);if((h|0)==0){break}dC[h&63]()}if((f|0)==508){g[e+4>>2]=1.0;b[e+8>>1]=1;b[e+10>>1]=-1;c[e>>2]=19448;f=e+12|0;h=a;c[f>>2]=c[h>>2];c[f+4>>2]=c[h+4>>2];c[f+8>>2]=c[h+8>>2];c[f+12>>2]=c[h+12>>2];h=e+28|0;f=d;c[h>>2]=c[f>>2];c[h+4>>2]=c[f+4>>2];c[h+8>>2]=c[f+8>>2];c[h+12>>2]=c[f+12>>2];c[e+76>>2]=0;return e|0}e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}function adX(a,b){a=+a;b=+b;var d=0,e=0,f=0;while(1){d=aDx(92)|0;if((d|0)!=0){e=520;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==520){g[d+80>>2]=a;g[d+84>>2]=b;g[d+88>>2]=0.0;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function adY(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0;while(1){i=aDx(1380)|0;if((i|0)!=0){j=532;break}k=(C=c[10744]|0,c[10744]=C+0,C);if((k|0)==0){break}dC[k&63]()}if((j|0)==532){aoY(i,b,d,e,f,h);c[i>>2]=20024;c[i+4>>2]=9;a[i+1301|0]=0;g[i+1308>>2]=0.0;g[i+1332>>2]=0.0;g[i+1356>>2]=1.0;a[i+1302|0]=0;g[i+1312>>2]=0.0;g[i+1336>>2]=0.0;g[i+1360>>2]=1.0;a[i+1303|0]=0;g[i+1316>>2]=0.0;g[i+1340>>2]=0.0;g[i+1364>>2]=1.0;a[i+1304|0]=0;g[i+1320>>2]=0.0;g[i+1344>>2]=0.0;g[i+1368>>2]=1.0;a[i+1305|0]=0;g[i+1324>>2]=0.0;g[i+1348>>2]=0.0;g[i+1372>>2]=1.0;a[i+1306|0]=0;g[i+1328>>2]=0.0;g[i+1352>>2]=0.0;g[i+1376>>2]=1.0;return i|0}i=cd(4)|0;c[i>>2]=19096;bF(i|0,34368,676);return 0}function adZ(a,b){a=a|0;b=+b;return}function ad_(a){a=a|0;return(a|0)==28|0}function ad$(a){a=a|0;return(a|0)==31|0}function ad0(a){a=a|0;return(a|0)<7|0}function ad1(a){a=a|0;return(a|0)<20|0}function ad2(a){a=a|0;return((a|0)>20&(a|0)<30?(a|0)!=25:0)|0}function ad3(a){a=a|0;return((a|0)==17?1:(a|0)==18)|0}function ad4(a){a=a|0;return(a|0)==32|0}function ad5(a){a=a|0;return((a|0)>20?(a|0)<30:0)|0}function ad6(a){a=a|0;return+(+g[a+32>>2])}function ad7(b){b=b|0;return(a[b+20|0]&1)!=0|0}function ad8(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function ad9(a){a=a|0;return c[a+4>>2]|0}function aea(b,c){b=b|0;c=c|0;a[b+21|0]=c&1;return}function aeb(b,c){b=b|0;c=c|0;a[b+1293|0]=c&1;return}function aec(b){b=b|0;return(a[b+21|0]&1)!=0|0}function aed(a){a=a|0;return c[a+4>>2]|0}function aee(a,b){a=a|0;b=b|0;return a+860+(b<<6)|0}function aef(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+1300|0]&1)==0){c[e>>2]=6;c[d+4>>2]=0;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function aeg(a){a=a|0;return+(+g[a+36>>2])}function aeh(a,b){a=a|0;b=+b;g[a+36>>2]=b;return}function aei(a,b){a=a|0;b=b|0;var c=0,d=0;c=a;if((b|0)<3){d=+g[a+688+(b<<2)>>2]>=+g[a+672+(b<<2)>>2];return d|0}a=b-3|0;if(+g[c+860+(a<<6)>>2]>+g[c+860+(a<<6)+4>>2]){d=0;return d|0}d=1;return d|0}function aej(b){b=b|0;return(a[b+1293|0]&1)!=0|0}function aek(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function ael(b,c,d){b=b|0;c=c|0;d=d|0;var e=0;e=d&1;a[b+1301+c|0]=e;if((c|0)<3){a[b+(c+780)|0]=e;return}else{a[b+860+(c-3<<6)+44|0]=e;return}}function aem(a){a=a|0;return a+1120|0}function aen(a,b){a=a|0;b=+b;g[a+32>>2]=b;return}function aeo(a,b){a=a|0;b=+b;g[a+16>>2]=b;return}function aep(b){b=b|0;return(a[b+1300|0]&1)!=0|0}function aeq(a){a=a|0;return+(+g[a+32>>2])}function aer(b,c){b=b|0;c=c|0;a[b+1300|0]=c&1;return}function aes(a){a=a|0;return a+672|0}function aet(a,b){a=a|0;b=b|0;return+(+g[a+1184+(b<<2)>>2])}function aeu(a,b){a=a|0;b=b|0;var c=0;c=a;a=0;while(1){if((a|0)>=3){break}g[b+(a<<2)>>2]=+g[c+860+(a<<6)+4>>2];a=a+1|0}return}function aev(a){a=a|0;return c[a+8>>2]|0}function aew(a,b,c){a=a|0;b=b|0;c=+c;g[a+1332+(b<<2)>>2]=c;return}function aex(a){a=a|0;return c[a+12>>2]|0}function aey(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function aez(a){a=a|0;return c[a>>2]|0}function aeA(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function aeB(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function aeC(a){a=a|0;return a+16|0}function aeD(a,b){a=a|0;b=b|0;c[a+12>>2]=b;return}function aeE(a){a=a|0;return b[a+6>>1]|0}function aeF(a){a=a|0;return c[a+12>>2]|0}function aeG(a){a=a|0;return a+32|0}function aeH(a,c){a=a|0;c=c|0;b[a+4>>1]=c;return}function aeI(a){a=a|0;return c[a+12>>2]|0}function aeJ(a,c){a=a|0;c=c|0;b[a+6>>1]=c;return}function aeK(a){a=a|0;return c[a+8>>2]|0}function aeL(a){a=a|0;return b[a+4>>1]|0}function aeM(a){a=a|0;return a+20|0}function aeN(a){a=a|0;return a+4|0}function aeO(b,c){b=b|0;c=c|0;do{if((a[43752]|0)==0){if((b1(43752)|0)==0){break}}}while(0);aDG(38904,b+1200+(c<<4)|0,16);return 38904}function aeP(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}function aeQ(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+40>>2]&511](a,b,d)|0}function aeR(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function aeS(a,b){a=a|0;b=b|0;var d=0;d=a+672|0;a=b;c[a>>2]=c[d>>2];c[a+4>>2]=c[d+4>>2];c[a+8>>2]=c[d+8>>2];c[a+12>>2]=c[d+12>>2];return}function aeT(a){a=a|0;aoZ(a,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function aeU(a,b,c){a=a|0;b=b|0;c=c|0;aoZ(a,b,c);return}function aeV(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function aeW(a,b,c,d,e,f,g,h,i,j,k,l){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,0)|0}function aeX(a,b,c,d,e,f,g,h,i,j,k,l,m){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;return ao7(a,b,c,d,e,f,g,h,i,j,k,l,m)|0}function aeY(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;nS(a,b,c,d);return}function aeZ(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function ae_(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;cy[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f);return}function ae$(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=a;a=0;while(1){if((a|0)>=3){break}d=+ck(+(+g[b+(a<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[c+860+(a<<6)>>2]=e;a=a+1|0}return}function ae0(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+24>>2]&127](a,b,d,e);return}function ae1(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=a;f=a+40|0;g=b;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+56|0;f=b+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+72|0;g=b+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+88|0;f=b+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+104|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+120|0;f=d+16|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=a+136|0;g=d+32|0;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];g=a+152|0;f=d+48|0;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](e);aoZ(e,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function ae2(a,b){a=a|0;b=b|0;var d=0;d=a+688|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ae3(a,b){a=a|0;b=b|0;var c=0,d=0.0,e=0.0;c=a;a=0;while(1){if((a|0)>=3){break}d=+ck(+(+g[b+(a<<2)>>2]),6.2831854820251465);do{if(d<-3.1415927410125732){e=d+6.2831854820251465}else{if(d<=3.1415927410125732){e=d;break}e=d-6.2831854820251465}}while(0);g[c+860+(a<<6)+4>>2]=e;a=a+1|0}return}function ae4(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a,b,d);return}function ae5(a,b){a=a|0;b=b|0;return ao$(a,b)|0}function ae6(){var a=0,b=0,d=0;c[9806]=(c[9806]|0)+1;a=aDx(67)|0;if((a|0)==0){b=0}else{d=-(a+4|0)&15;c[a+d>>2]=a;b=a+(d+4)|0}c[b>>2]=0;c[b+8>>2]=0;return b|0}function ae7(a,d,e,f,g){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,i=0,j=0;c[9806]=(c[9806]|0)+1;h=aDx(67)|0;if((h|0)==0){i=0}else{j=-(h+4|0)&15;c[h+j>>2]=h;i=h+(j+4)|0}c[i>>2]=e;b[i+4>>1]=f;b[i+6>>1]=g;g=i+16|0;f=a;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=i+32|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[i+8>>2]=0;return i|0}function ae8(a,d,e,f,g,h){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0;c[9806]=(c[9806]|0)+1;i=aDx(67)|0;if((i|0)==0){j=0}else{k=-(i+4|0)&15;c[i+k>>2]=i;j=i+(k+4)|0}c[j>>2]=e;b[j+4>>1]=f;b[j+6>>1]=g;g=j+16|0;f=a;c[g>>2]=c[f>>2];c[g+4>>2]=c[f+4>>2];c[g+8>>2]=c[f+8>>2];c[g+12>>2]=c[f+12>>2];f=j+32|0;g=d;c[f>>2]=c[g>>2];c[f+4>>2]=c[g+4>>2];c[f+8>>2]=c[g+8>>2];c[f+12>>2]=c[g+12>>2];c[j+8>>2]=h;return j|0}function ae9(a,b){a=a|0;b=b|0;var d=0;d=a+16|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function afa(a,b){a=a|0;b=b|0;var d=0;d=a+32|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function afb(a){a=a|0;if((a|0)==0){return}c[9804]=(c[9804]|0)+1;aDB(c[a-48+44>>2]|0);return}function afc(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e,f,g,h,i,j,0);return}function afd(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+16>>2]&63](a,b,d,e,f,g,h,i,j,k);return}function afe(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+36>>2]&2047](a,b);return}function aff(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+40|0;f=e|0;c[f>>2]=18624;g[f+4>>2]=999999984306749400.0;g[f+8>>2]=999999984306749400.0;g[f+12>>2]=999999984306749400.0;g[f+16>>2]=0.0;g[f+20>>2]=-999999984306749400.0;g[f+24>>2]=-999999984306749400.0;g[f+28>>2]=-999999984306749400.0;g[f+32>>2]=0.0;g[b>>2]=-999999984306749400.0;g[b+4>>2]=-999999984306749400.0;g[b+8>>2]=-999999984306749400.0;g[b+12>>2]=0.0;g[d>>2]=999999984306749400.0;g[d+4>>2]=999999984306749400.0;g[d+8>>2]=999999984306749400.0;g[d+12>>2]=0.0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,f|0,b,d);a=b;b=f+4|0;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];b=d;d=f+20|0;c[b>>2]=c[d>>2];c[b+4>>2]=c[d+4>>2];c[b+8>>2]=c[d+8>>2];c[b+12>>2]=c[d+12>>2];i=e;return}function afg(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function afh(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a,b);return}function afi(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+56>>2]&511](a|0,b,d)|0}function afj(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(103)|0;d=-(b+4|0)&15;c[b+d>>2]=b;e=b+(d+4)|0;g[e+4>>2]=1.0;g[e+8>>2]=1.0;g[e+12>>2]=1.0;g[e+16>>2]=0.0;c[e>>2]=20368;a[e+36|0]=1;c[e+32>>2]=0;c[e+24>>2]=0;c[e+28>>2]=0;c[e+48>>2]=0;return e|0}function afk(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0;k=i;i=i+32|0;l=k|0;c[9806]=(c[9806]|0)+1;m=aDx(103)|0;if((m|0)==0){n=0}else{o=-(m+4|0)&15;c[m+o>>2]=m;n=m+(o+4)|0}g[n+4>>2]=1.0;g[n+8>>2]=1.0;g[n+12>>2]=1.0;g[n+16>>2]=0.0;c[n>>2]=20368;a[n+36|0]=1;c[n+32>>2]=0;c[n+24>>2]=0;c[n+28>>2]=0;c[n+48>>2]=0;c[l+24>>2]=2;c[l+28>>2]=0;c[l>>2]=b;c[l+4>>2]=d;c[l+8>>2]=e;c[l+12>>2]=f;c[l+16>>2]=h;c[l+20>>2]=j;AY(n,l,2);i=k;return n|0}function afl(a,b){a=a|0;b=b|0;var d=0;d=a+4|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function afm(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function afn(a){a=a|0;return(c[a+4>>2]|0)<7|0}function afo(a){a=a|0;return a+12|0}function afp(a){a=a|0;return(c[a+4>>2]|0)==31|0}function afq(a){a=a|0;return+(+g[a+44>>2])}function afr(a){a=a|0;return(c[a+4>>2]|0)<20|0}function afs(a){a=a|0;return(c[a+4>>2]|0)==28|0}function aft(a){a=a|0;return c[a+8>>2]|0}function afu(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function afv(a){a=a|0;return a+28|0}function afw(a){a=a|0;return(c[a+4>>2]|0)==32|0}function afx(a){a=a|0;return a+28|0}function afy(a){a=a|0;return c[a+52>>2]|0}function afz(a){a=a|0;return c[a+4>>2]|0}function afA(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function afB(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function afC(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function afD(a){a=a|0;return(c[a+4>>2]|0)<7|0}function afE(a){a=a|0;return a+12|0}function afF(a){a=a|0;return cA[c[(c[a>>2]|0)+52>>2]&4095](a|0)|0}function afG(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a,b,d);return}function afH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function afI(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+48>>2]&511](a,b,d);return}function afJ(a,b){a=a|0;b=b|0;AY(a,b,2);return}function afK(a,b,c){a=a|0;b=b|0;c=c|0;AY(a,b,c);return}function afL(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a)|0}function afM(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;di[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,0);return}function afN(a,b,d,e,f,g,h,i,j,k){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;k=k|0;di[c[(c[a>>2]|0)+12>>2]&63](a,b,d,e,f,g,h,i,j,k);return}function afO(a){a=a|0;return cA[c[(c[a>>2]|0)+40>>2]&4095](a)|0}function afP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function afQ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function afR(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function afS(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a)|0}function afT(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43800]|0)==0){if((b1(43800)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9722]=c[d>>2];c[9723]=c[d+4>>2];c[9724]=c[d+8>>2];c[9725]=c[d+12>>2];i=e;return 38888}function afU(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a,b,d)|0}function afV(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a)|0}function afW(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function afX(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a)|0}function afY(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43344]|0)==0){if((b1(43344)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9714]=c[d>>2];c[9715]=c[d+4>>2];c[9716]=c[d+8>>2];c[9717]=c[d+12>>2];i=e;return 38856}function afZ(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a,b,d);return}function af_(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+116>>2]&511](a,b,d);return}function af$(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43640]|0)==0){if((b1(43640)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9710]=c[d>>2];c[9711]=c[d+4>>2];c[9712]=c[d+8>>2];c[9713]=c[d+12>>2];i=e;return 38840}function af0(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function af1(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function af2(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a)|0}function af3(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function af4(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a,b,d,e);return}function af5(a){a=a|0;var b=0,d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0;c[9806]=(c[9806]|0)+1;b=aDx(75)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d+8>>2]=0;e=d+12|0;g[e>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;g[d+44>>2]=.03999999910593033;c[d+52>>2]=0;c[d>>2]=26200;c[d+4>>2]=0;b=d;f=d;h=+ar4(b);i=+dh[c[(c[f>>2]|0)+44>>2]&1023](b);j=+dh[c[(c[f>>2]|0)+44>>2]&1023](b);k=+g[a+4>>2]*+g[d+16>>2]-i;i=+g[a+8>>2]*+g[d+20>>2]-j;g[d+28>>2]=+g[a>>2]*+g[e>>2]-h;g[d+32>>2]=k;g[d+36>>2]=i;g[d+40>>2]=0.0;return d|0}function af6(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function af7(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function af8(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function af9(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function aga(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function agb(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function agc(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a,b,d);return}function agd(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a|0)|0}function age(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43512]|0)==0){if((b1(43512)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9706]=c[d>>2];c[9707]=c[d+4>>2];c[9708]=c[d+8>>2];c[9709]=c[d+12>>2];i=e;return 38824}function agf(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 13:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function agg(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function agh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function agi(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function agj(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function agk(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function agl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function agm(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a,b,d,e);return}function agn(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function ago(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function agp(b){b=b|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0,j=0,k=0.0,l=0.0,m=0.0;do{if((a[43808]|0)==0){if((b1(43808)|0)==0){break}}}while(0);d=+g[b+28>>2];e=+g[b+32>>2];f=+g[b+36>>2];h=+g[b+40>>2];i=b|0;j=b;k=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);l=+dh[c[(c[j>>2]|0)+44>>2]&1023](i);m=f+ +dh[c[(c[j>>2]|0)+44>>2]&1023](i);g[9702]=d+k;g[9703]=e+l;g[9704]=m;g[9705]=h;return 38808}function agq(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a,b,d);return}function agr(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+8>>2]&511](a,b,d);return}function ags(a,b,d,e){a=a|0;b=b|0;d=d|0;e=+e;dw[c[(c[a>>2]|0)+16>>2]&127](a,b,d,e);return}function agt(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function agu(a){a=a|0;return cA[c[(c[a>>2]|0)+104>>2]&4095](a|0)|0}function agv(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43240]|0)==0){if((b1(43240)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9698]=c[d>>2];c[9699]=c[d+4>>2];c[9700]=c[d+8>>2];c[9701]=c[d+12>>2];i=e;return 38792}function agw(a,b,d){a=a|0;b=b|0;d=+d;return c0[c[(c[a>>2]|0)+112>>2]&127](a|0,b,d)|0}function agx(a){a=a|0;return cA[c[(c[a>>2]|0)+88>>2]&4095](a|0)|0}function agy(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function agz(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function agA(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+100>>2]&511](a|0,b,d);return}function agB(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43120]|0)==0){if((b1(43120)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9694]=c[d>>2];c[9695]=c[d+4>>2];c[9696]=c[d+8>>2];c[9697]=c[d+12>>2];i=e;return 38776}function agC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function agD(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function agE(a){a=a|0;return cA[c[(c[a>>2]|0)+92>>2]&4095](a|0)|0}function agF(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function agG(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+96>>2]&1023](a|0,b,d,e);return}function agH(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43064]|0)==0){if((b1(43064)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9690]=c[d>>2];c[9691]=c[d+4>>2];c[9692]=c[d+8>>2];c[9693]=c[d+12>>2];i=e;return 38760}function agI(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function agJ(a){a=a|0;return(c[a+4>>2]|0)<20|0}function agK(a){a=a|0;return(c[a+4>>2]|0)==28|0}function agL(a){a=a|0;return c[a+8>>2]|0}function agM(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function agN(a){a=a|0;return+(+g[a+44>>2])}function agO(a){a=a|0;return(c[a+4>>2]|0)==32|0}function agP(a){a=a|0;return a+28|0}function agQ(a){a=a|0;return(c[a+4>>2]|0)==31|0}function agR(a){a=a|0;return c[a+52>>2]|0}function agS(a){a=a|0;return c[a+4>>2]|0}function agT(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function agU(a){a=a|0;return(c[a+4>>2]|0)==31|0}function agV(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function agW(a){a=a|0;return c[a+52>>2]|0}function agX(a){a=a|0;return(c[a+4>>2]|0)<7|0}function agY(a){a=a|0;return+(+g[a+28+((((c[a+52>>2]|0)+2|0)%3|0)<<2)>>2])}function agZ(a){a=a|0;return+(+g[a+28+(c[a+52>>2]<<2)>>2])}function ag_(a){a=a|0;return a+12|0}function ag$(a){a=a|0;return+(+g[a+44>>2])}function ag0(a){a=a|0;return(c[a+4>>2]|0)<20|0}function ag1(a){a=a|0;return(c[a+4>>2]|0)==28|0}function ag2(a){a=a|0;return c[a+8>>2]|0}function ag3(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function ag4(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function ag5(a){a=a|0;return(c[a+4>>2]|0)==32|0}function ag6(a){a=a|0;return a+28|0}function ag7(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function ag8(a){a=a|0;return c[a+4>>2]|0}function ag9(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43080]|0)==0){if((b1(43080)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9686]=c[d>>2];c[9687]=c[d+4>>2];c[9688]=c[d+8>>2];c[9689]=c[d+12>>2];i=e;return 38744}function aha(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function ahb(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function ahc(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function ahd(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function ahe(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function ahf(a){a=a|0;aze(a);return}function ahg(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function ahh(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function ahi(a){a=a|0;return cA[c[(c[a>>2]|0)+84>>2]&4095](a|0)|0}function ahj(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ahk(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function ahl(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function ahm(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function ahn(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function aho(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function ahp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function ahq(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+108>>2]&1023](a|0,b,d,e);return}function ahr(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function ahs(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;gx(a,b,c,d,e);return}function aht(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0;b=i;i=i+8|0;d=b|0;if((a|0)==0){i=b;return}e=c[9152]|0;f=e+16|0;h=(c[f>>2]|0)-1|0;c[f>>2]=h;do{if((h|0)==0){if((c[e+4>>2]|0)==0){j=e}else{b3(d|0,0)|0;k=c[10742]|0;l=e+8|0;g[l>>2]=+(((c[d+4>>2]|0)-(c[k+4>>2]|0)+(((c[d>>2]|0)-(c[k>>2]|0)|0)*1e6|0)-(c[e+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[l>>2];if((c[f>>2]|0)!=0){break}j=c[9152]|0}c[9152]=c[j+20>>2]}}while(0);aDB(a|0);i=b;return}function ahu(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function ahv(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43712]|0)==0){if((b1(43712)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9682]=c[d>>2];c[9683]=c[d+4>>2];c[9684]=c[d+8>>2];c[9685]=c[d+12>>2];i=e;return 38728}function ahw(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function ahx(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function ahy(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function ahz(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function ahA(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function ahB(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function ahC(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43216]|0)==0){if((b1(43216)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9678]=c[d>>2];c[9679]=c[d+4>>2];c[9680]=c[d+8>>2];c[9681]=c[d+12>>2];i=e;return 38712}function ahD(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43408]|0)==0){if((b1(43408)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9670]=c[d>>2];c[9671]=c[d+4>>2];c[9672]=c[d+8>>2];c[9673]=c[d+12>>2];i=e;return 38680}function ahE(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function ahF(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function ahG(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43544]|0)==0){if((b1(43544)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9666]=c[d>>2];c[9667]=c[d+4>>2];c[9668]=c[d+8>>2];c[9669]=c[d+12>>2];i=e;return 38664}function ahH(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function ahI(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(75)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+4>>2]=10;c[e>>2]=25144;c[e+52>>2]=0;g[e+28>>2]=b*.5;g[e+32>>2]=a;g[e+36>>2]=a;g[e+40>>2]=0.0;return e|0}function ahJ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function ahK(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function ahL(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function ahM(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ahN(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function ahO(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function ahP(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function ahQ(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function ahR(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function ahS(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function ahT(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function ahU(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function ahV(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[44008]|0)==0){if((b1(44008)|0)==0){break}}}while(0);ah6(f,b,d);d=f;c[9662]=c[d>>2];c[9663]=c[d+4>>2];c[9664]=c[d+8>>2];c[9665]=c[d+12>>2];i=e;return 38648}function ahW(a){a=a|0;var b=0,d=0,e=0;while(1){b=aDx(1)|0;if((b|0)!=0){d=950;break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){d=947;break}dC[e&63]()}if((d|0)==947){e=cd(4)|0;c[e>>2]=19096;bF(e|0,34368,676);return 0}else if((d|0)==950){aDo(a);return b|0}return 0}function ahX(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(d<+g[c>>2]){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(d>=+g[c>>2]){return}g[c>>2]=d;return}function ahY(a){a=a|0;return+(+g[a>>2])}function ahZ(a){a=a|0;return+(+g[a+4>>2])}function ah_(a){a=a|0;return+(+g[a+8>>2])}function ah$(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[c>>2]- +g[b>>2];c=a+4|0;g[c>>2]=+g[c>>2]- +g[b+4>>2];c=a+8|0;g[c>>2]=+g[c>>2]- +g[b+8>>2];c=a+12|0;g[c>>2]=+g[c>>2]- +g[b+12>>2];return a|0}function ah0(a){a=a|0;return+(+g[a+12>>2])}function ah1(a,b){a=a|0;b=b|0;var c=0,d=0.0;c=a|0;d=+g[b>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+4|0;d=+g[b+4>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+8|0;d=+g[b+8>>2];if(+g[c>>2]<d){g[c>>2]=d}c=a+12|0;d=+g[b+12>>2];if(+g[c>>2]>=d){return}g[c>>2]=d;return}function ah2(a,b){a=a|0;b=b|0;var c=0;c=a|0;g[c>>2]=+g[c>>2]+ +g[b>>2];c=a+4|0;g[c>>2]=+g[c>>2]+ +g[b+4>>2];c=a+8|0;g[c>>2]=+g[c>>2]+ +g[b+8>>2];c=a+12|0;g[c>>2]=+g[c>>2]+ +g[b+12>>2];return a|0}function ah3(a,b){a=a|0;b=+b;var c=0;c=a|0;g[c>>2]=+g[c>>2]*b;c=a+4|0;g[c>>2]=+g[c>>2]*b;c=a+8|0;g[c>>2]=+g[c>>2]*b;c=a+12|0;g[c>>2]=+g[c>>2]*b;return a|0}function ah4(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=0.0;return}function ah5(a,b,c,d,e){a=a|0;b=+b;c=+c;d=+d;e=+e;g[a>>2]=b;g[a+4>>2]=c;g[a+8>>2]=d;g[a+12>>2]=e;return}function ah6(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0;e=+g[b>>2];f=+g[d>>2];h=e-f;i=+g[b+4>>2];j=+g[d+4>>2];k=i-j;l=+g[b+8>>2];m=+g[d+8>>2];n=l-m;o=+g[b+12>>2];p=+g[d+12>>2];q=o-p;r=e+f;e=i+j;i=l+m;l=o+p;if(h*h+k*k+n*n+q*q<r*r+e*e+i*i+l*l){b=a;s=d;c[b>>2]=c[s>>2];c[b+4>>2]=c[s+4>>2];c[b+8>>2]=c[s+8>>2];c[b+12>>2]=c[s+12>>2];return}else{g[a>>2]=-0.0-f;g[a+4>>2]=-0.0-j;g[a+8>>2]=-0.0-m;g[a+12>>2]=-0.0-p;return}}function ah7(b,c){b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0;do{if((a[43960]|0)==0){if((b1(43960)|0)==0){break}}}while(0);d=+g[b>>2];e=+g[c>>2];f=d-e;h=+g[b+4>>2];i=+g[c+4>>2];j=h-i;k=+g[b+8>>2];l=+g[c+8>>2];m=k-l;n=+g[b+12>>2];o=+g[c+12>>2];p=n-o;q=d+e;d=h+i;h=k+l;k=n+o;if(f*f+j*j+m*m+p*p>q*q+d*d+h*h+k*k){r=e;s=i;t=l;u=o;g[9658]=r;g[9659]=s;g[9660]=t;g[9661]=u;return 38632}r=-0.0-e;s=-0.0-i;t=-0.0-l;u=-0.0-o;g[9658]=r;g[9659]=s;g[9660]=t;g[9661]=u;return 38632}function ah8(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;ah9(a,b,c,f);i=e;return}function ah9(a,b,c,d){a=a|0;b=+b;c=+c;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;e=b*.5;b=c*.5;c=+g[d>>2]*.5;f=+S(+e);h=+T(+e);e=+S(+b);i=+T(+b);b=+S(+c);j=+T(+c);c=b*i;k=j*e;l=b*e;e=j*i;g[a>>2]=c*f+k*h;g[a+4>>2]=l*h-e*f;g[a+8>>2]=k*f-c*h;g[a+12>>2]=l*f+e*h;return}function aia(a){a=a|0;var b=0,c=0.0,d=0,e=0.0,f=0,h=0.0,i=0,j=0.0,k=0.0;b=a|0;c=+g[b>>2];d=a+4|0;e=+g[d>>2];f=a+8|0;h=+g[f>>2];i=a+12|0;j=+g[i>>2];k=1.0/+Q(+(c*c+e*e+h*h+j*j));g[b>>2]=c*k;g[d>>2]=e*k;g[f>>2]=h*k;g[i>>2]=j*k;return a|0}function aib(b,c,d){b=b|0;c=c|0;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0;do{if((a[44096]|0)==0){if((b1(44096)|0)==0){break}}}while(0);e=+aie(b,c);if(e==0.0){f=+g[b>>2];h=+g[b+4>>2];i=+g[b+8>>2];j=+g[b+12>>2];g[9654]=f;g[9655]=h;g[9656]=i;g[9657]=j;return 38616}k=1.0/+T(+e);l=+T(+((1.0-d)*e));m=+T(+(e*d));d=+g[b>>2];e=+g[c>>2];n=+g[b+4>>2];o=+g[c+4>>2];p=+g[b+8>>2];q=+g[c+8>>2];r=+g[b+12>>2];s=+g[c+12>>2];t=d*l;if(d*e+n*o+p*q+r*s<0.0){f=(t+m*(-0.0-e))*k;h=(n*l+m*(-0.0-o))*k;i=(p*l+m*(-0.0-q))*k;j=(r*l+m*(-0.0-s))*k;g[9654]=f;g[9655]=h;g[9656]=i;g[9657]=j;return 38616}else{f=(t+e*m)*k;h=(n*l+o*m)*k;i=(p*l+q*m)*k;j=(r*l+s*m)*k;g[9654]=f;g[9655]=h;g[9656]=i;g[9657]=j;return 38616}return 0}function aic(b){b=b|0;var c=0.0,d=0.0,e=0.0;do{if((a[44016]|0)==0){if((b1(44016)|0)==0){break}}}while(0);c=-0.0- +g[b+4>>2];d=-0.0- +g[b+8>>2];e=+g[b+12>>2];g[9650]=-0.0- +g[b>>2];g[9651]=c;g[9652]=d;g[9653]=e;return 38600}function aid(a,b){a=a|0;b=b|0;return+(+aie(a,b))}function aie(a,b){a=a|0;b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0;c=+g[a>>2];d=+g[a+4>>2];e=+g[a+8>>2];f=+g[a+12>>2];h=+g[b>>2];i=+g[b+4>>2];j=+g[b+8>>2];k=+g[b+12>>2];l=(c*h+d*i+e*j+f*k)/+Q(+((c*c+d*d+e*e+f*f)*(h*h+i*i+j*j+k*k)));if(l<-1.0){m=-1.0;n=+V(+m);return+n}if(l<=1.0){m=l;n=+V(+m);return+n}m=1.0;n=+V(+m);return+n}function aif(b){b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;do{if((a[44024]|0)==0){if((b1(44024)|0)==0){break}}}while(0);c=1.0- +R(+(+g[b+12>>2]),2.0);if(c<11920928955078125.0e-22){d=1.0;e=0.0;f=0.0}else{h=+Q(+c);d=+g[b>>2]/h;e=+g[b+4>>2]/h;f=+g[b+8>>2]/h}g[9646]=d;g[9647]=e;g[9648]=f;g[9649]=0.0;return 38584}function aig(){if((a[43032]|0)!=0){return 42736}if((b1(43032)|0)==0){return 42736}g[10684]=0.0;g[10685]=0.0;g[10686]=0.0;g[10687]=1.0;return 42736}function aih(a,b,c){a=a|0;b=b|0;c=+c;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0;d=+g[b>>2];e=+g[b+4>>2];f=+g[b+8>>2];h=+Q(+(d*d+e*e+f*f));i=c*.5;c=+T(+i)/h;h=+S(+i);g[a>>2]=d*c;g[a+4>>2]=e*c;g[a+8>>2]=f*c;g[a+12>>2]=h;return}function aii(a,b,c,d){a=a|0;b=+b;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=b*.5;b=c*.5;c=d*.5;d=+S(+e);f=+T(+e);e=+S(+b);h=+T(+b);b=+S(+c);i=+T(+c);c=i*e;j=b*h;k=b*e;e=i*h;g[a>>2]=c*d-j*f;g[a+4>>2]=j*d+c*f;g[a+8>>2]=k*f-e*d;g[a+12>>2]=k*d+e*f;return}function aij(){var a=0,b=0,d=0;while(1){a=aDx(16)|0;if((a|0)!=0){b=1051;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==1051){return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function aik(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;while(1){d=aDx(16)|0;if((d|0)!=0){e=1063;break}f=(C=c[10744]|0,c[10744]=C+0,C);if((f|0)==0){break}dC[f&63]()}if((e|0)==1063){h=+g[a>>2];i=+g[a+4>>2];j=+g[a+8>>2];k=+Q(+(h*h+i*i+j*j));l=b*.5;b=+T(+l)/k;k=+S(+l);g[d>>2]=h*b;g[d+4>>2]=i*b;g[d+8>>2]=j*b;g[d+12>>2]=k;return d|0}d=cd(4)|0;c[d>>2]=19096;bF(d|0,34368,676);return 0}function ail(a,b,d){a=+a;b=+b;d=+d;var e=0,f=0,h=0,j=0,k=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;while(1){h=aDx(16)|0;if((h|0)!=0){j=1075;break}k=(C=c[10744]|0,c[10744]=C+0,C);if((k|0)==0){break}dC[k&63]()}if((j|0)==1075){j=h;ah9(j,a,b,f);i=e;return j|0}j=cd(4)|0;c[j>>2]=19096;bF(j|0,34368,676);return 0}function aim(a,b){a=a|0;b=+b;var c=0.0,d=0;c=1.0/b;d=a|0;g[d>>2]=+g[d>>2]*c;d=a+4|0;g[d>>2]=+g[d>>2]*c;d=a+8|0;g[d>>2]=+g[d>>2]*c;d=a+12|0;g[d>>2]=+g[d>>2]*c;return a|0}function ain(a,b){a=a|0;b=+b;g[a+12>>2]=b;return}function aio(a,b){a=a|0;b=+b;g[a>>2]=b;return}function aip(a,b){a=a|0;b=+b;g[a+4>>2]=b;return}function aiq(a,b){a=a|0;b=+b;g[a+8>>2]=b;return}function air(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];e=+g[a+12>>2];return+(b*b+c*c+d*d+e*e)}function ais(a){a=a|0;return+(+g[a+12>>2])}function ait(a){a=a|0;return+(+g[a+4>>2])}function aiu(a){a=a|0;return+(+g[a>>2])}function aiv(a){a=a|0;return+(+g[a+8>>2])}function aiw(a,b){a=a|0;b=b|0;return+(+g[a>>2]*+g[b>>2]+ +g[a+4>>2]*+g[b+4>>2]+ +g[a+8>>2]*+g[b+8>>2]+ +g[a+12>>2]*+g[b+12>>2])}function aix(a){a=a|0;return(c[a+4>>2]|0)==31|0}function aiy(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function aiz(a){a=a|0;return c[a+52>>2]|0}function aiA(a){a=a|0;return(c[a+4>>2]|0)<7|0}function aiB(a){a=a|0;return+(+g[a+28+((((c[a+52>>2]|0)+2|0)%3|0)<<2)>>2])}function aiC(a){a=a|0;return+(+g[a+28+(c[a+52>>2]<<2)>>2])}function aiD(a){a=a|0;return a+12|0}function aiE(a){a=a|0;return+(+g[a+44>>2])}function aiF(a){a=a|0;return(c[a+4>>2]|0)<20|0}function aiG(a){a=a|0;return(c[a+4>>2]|0)==28|0}function aiH(a){a=a|0;return c[a+8>>2]|0}function aiI(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function aiJ(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function aiK(a){a=a|0;return(c[a+4>>2]|0)==32|0}function aiL(a){a=a|0;return a+28|0}function aiM(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function aiN(a){a=a|0;return c[a+4>>2]|0}function aiO(a){a=a|0;return+(+g[a+224>>2])}function aiP(a){a=a|0;return+(+g[a+220>>2])}function aiQ(a,b){a=a|0;b=b|0;c[a+212>>2]=b;return}function aiR(a){a=a|0;return+(+g[a+244>>2])}function aiS(a,b){a=a|0;b=+b;g[a+224>>2]=b;return}function aiT(a,b){a=a|0;b=b|0;c[a+196>>2]=b;return}function aiU(a,b){a=a|0;b=+b;g[a+184>>2]=b;return}function aiV(a){a=a|0;return a+132|0}function aiW(a){a=a|0;return(c[a+204>>2]&7|0)==0|0}function aiX(a,b){a=a|0;b=+b;g[a+248>>2]=b;return}function aiY(a){a=a|0;return c[a+208>>2]|0}function aiZ(a){a=a|0;return c[a+260>>2]|0}function ai_(a,b){a=a|0;b=b|0;c[a+236>>2]=b;return}function ai$(b){b=b|0;var c=0.0,d=0.0,e=0.0,f=0.0,h=0.0;do{if((a[43952]|0)==0){if((b1(43952)|0)==0){break}}}while(0);c=+g[b>>2];d=+g[b+4>>2];e=+g[b+8>>2];f=+g[b+12>>2];h=1.0/+Q(+(c*c+d*d+e*e+f*f));g[9642]=c*h;g[9643]=d*h;g[9644]=e*h;g[9645]=f*h;return 38568}function ai0(a){a=a|0;if((a|0)==0){return}aDB(a);return}function ai1(a){a=a|0;var b=0.0,c=0.0;b=+g[a+12>>2];do{if(b<-1.0){c=-1.0}else{if(b<=1.0){c=b;break}c=1.0}}while(0);return+(+V(+c)*2.0)}function ai2(a){a=a|0;var b=0.0,c=0.0,d=0.0,e=0.0;b=+g[a>>2];c=+g[a+4>>2];d=+g[a+8>>2];e=+g[a+12>>2];return+(+Q(+(b*b+c*c+d*d+e*e)))}function ai3(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function ai4(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43704]|0)==0){if((b1(43704)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b|0,d);d=f;c[9638]=c[d>>2];c[9639]=c[d+4>>2];c[9640]=c[d+8>>2];c[9641]=c[d+12>>2];i=e;return 38552}function ai5(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function ai6(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function ai7(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function ai8(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function ai9(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function aja(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function ajb(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43208]|0)==0){if((b1(43208)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9634]=c[d>>2];c[9635]=c[d+4>>2];c[9636]=c[d+8>>2];c[9637]=c[d+12>>2];i=e;return 38536}function ajc(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43400]|0)==0){if((b1(43400)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b|0,d);d=f;c[9626]=c[d>>2];c[9627]=c[d+4>>2];c[9628]=c[d+8>>2];c[9629]=c[d+12>>2];i=e;return 38504}function ajd(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function aje(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function ajf(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43536]|0)==0){if((b1(43536)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9622]=c[d>>2];c[9623]=c[d+4>>2];c[9624]=c[d+8>>2];c[9625]=c[d+12>>2];i=e;return 38488}function ajg(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function ajh(a,b){a=+a;b=+b;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(75)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}c[e+8>>2]=0;g[e+12>>2]=1.0;g[e+16>>2]=1.0;g[e+20>>2]=1.0;g[e+24>>2]=0.0;g[e+44>>2]=.03999999910593033;c[e+4>>2]=10;c[e>>2]=25040;c[e+52>>2]=2;g[e+28>>2]=a;g[e+32>>2]=a;g[e+36>>2]=b*.5;g[e+40>>2]=0.0;return e|0}function aji(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a|0))}function ajj(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function ajk(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a|0,b);return}function ajl(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ajm(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 0:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 10:{d=+g[b+44>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function ajn(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function ajo(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a|0,b,d,e);return}function ajp(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function ajq(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function ajr(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function ajs(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function ajt(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function aju(a,b,d){a=a|0;b=b|0;d=d|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,0);return}function ajv(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+32>>2]&1023](a,b,d,e);return}function ajw(a,b){a=a|0;b=b|0;var d=0;d=a+132|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ajx(a,b){a=a|0;b=b|0;var d=0;d=a+148|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function ajy(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+20>>2]&511](a|0,b,d)|0}function ajz(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+68|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+84|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+100|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+116|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function ajA(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+12>>2]&2047](a|0,b);return}function ajB(a,b){a=a|0;b=b|0;dA[c[(c[a>>2]|0)+28>>2]&511](a,b,0);return}function ajC(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+28>>2]&511](a,b,d);return}function ajD(a,b){a=a|0;b=b|0;var d=0;if((c[a+252>>2]|0)==0){d=1;return d|0}d=dj[c[c[a>>2]>>2]&511](a|0,b)|0;return d|0}function ajE(a,b,d,e){a=+a;b=+b;d=+d;e=+e;var f=0,h=0,i=0;while(1){f=aDx(16)|0;if((f|0)!=0){h=1209;break}i=(C=c[10744]|0,c[10744]=C+0,C);if((i|0)==0){break}dC[i&63]()}if((h|0)==1209){g[f>>2]=a;g[f+4>>2]=b;g[f+8>>2]=d;g[f+12>>2]=e;return f|0}f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}function ajF(a){a=a|0;return a+148|0}function ajG(a,b){a=a|0;b=b|0;c[a+216>>2]=b;return}function ajH(a){a=a|0;var b=0;if((c[a+204>>2]&3|0)!=0){return}b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function ajI(a,b){a=a|0;b=b|0;do{if(!b){if((c[a+204>>2]&3|0)==0){break}return}}while(0);b=a+216|0;if(((c[b>>2]|0)-4|0)>>>0>=2){c[b>>2]=1}g[a+220>>2]=0.0;return}function ajJ(a,b){a=a|0;b=b|0;c[a+208>>2]=b;return}function ajK(a,b){a=a|0;b=+b;g[a+240>>2]=b;return}function ajL(a,b){a=a|0;b=+b;g[a+244>>2]=b;return}function ajM(a){a=a|0;return a+68|0}function ajN(a,b){a=a|0;b=b|0;return c[(c[a+268>>2]|0)+(b<<2)>>2]|0}function ajO(a){a=a|0;return(c[a+204>>2]&1|0)!=0|0}function ajP(a){a=a|0;return c[a+192>>2]|0}function ajQ(a){a=a|0;return c[a+216>>2]|0}function ajR(a){a=a|0;return c[a+188>>2]|0}function ajS(a){a=a|0;return+(+g[a+228>>2])}function ajT(a){a=a|0;return c[a+236>>2]|0}function ajU(a){a=a|0;return a+4|0}function ajV(a){a=a|0;var b=0.0;b=+g[a+248>>2];return+(b*b)}function ajW(a,b){a=a|0;b=b|0;c[a+192>>2]=b;return}function ajX(a){a=a|0;return+(+g[a+248>>2])}function ajY(a){a=a|0;return c[a+212>>2]|0}function ajZ(a){a=a|0;var b=0;b=c[a+216>>2]|0;return((b|0)==2?0:(b|0)!=5)|0}function aj_(a){a=a|0;return c[a+232>>2]|0}function aj$(a){a=a|0;return(c[a+204>>2]&4|0)==0|0}function aj0(a){a=a|0;var b=0;if((c[a+232>>2]|0)==4){b=a}else{b=0}return b|0}function aj1(a,b){a=a|0;b=b|0;var d=0;d=a+216|0;if(((c[d>>2]|0)-4|0)>>>0<2){return}c[d>>2]=b;return}function aj2(a){a=a|0;return c[a+200>>2]|0}function aj3(a){a=a|0;return+(+g[a+184>>2])}function aj4(a){a=a|0;return c[a+204>>2]|0}function aj5(a){a=a|0;return+(+g[a+240>>2])}function aj6(a){a=a|0;return a+164|0}function aj7(a,b){a=a|0;b=+b;g[a+220>>2]=b;return}function aj8(a){a=a|0;return c[a+196>>2]|0}function aj9(a,b){a=a|0;b=b|0;c[a+204>>2]=b;return}function aka(a){a=a|0;return(c[a+204>>2]&3|0)!=0|0}function akb(a,b){a=a|0;b=+b;g[a+228>>2]=b;return}function akc(a){a=a|0;return(c[a+180>>2]|0)!=0|0}function akd(a,b){a=a|0;b=b|0;c[a+188>>2]=b;return}function ake(a){a=a|0;return(c[a+204>>2]&2|0)!=0|0}function akf(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function akg(a){a=a|0;return(c[a+4>>2]|0)==31|0}function akh(a){a=a|0;return(c[a+4>>2]|0)<7|0}function aki(a){a=a|0;return(c[a+4>>2]|0)<20|0}function akj(a){a=a|0;return(c[a+4>>2]|0)==28|0}function akk(a){a=a|0;return c[a+8>>2]|0}function akl(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function akm(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function akn(a){a=a|0;return(c[a+4>>2]|0)==32|0}function ako(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function akp(a){a=a|0;return c[a+4>>2]|0}function akq(a){a=a|0;return+(+g[a+104>>2])}function akr(a){a=a|0;return+(+g[a+100>>2])}function aks(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0;f=i;i=i+128|0;h=f|0;j=f+64|0;g[h>>2]=1.0;aDD(h+4|0,0,16);g[h+20>>2]=1.0;aDD(h+24|0,0,16);g[h+40>>2]=1.0;c[h+44>>2]=0;k=h+48|0;l=b;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];g[j>>2]=1.0;aDD(j+4|0,0,16);g[j+20>>2]=1.0;aDD(j+24|0,0,16);g[j+40>>2]=1.0;c[j+44>>2]=0;l=j+48|0;k=d;c[l>>2]=c[k>>2];c[l+4>>2]=c[k+4>>2];c[l+8>>2]=c[k+8>>2];c[l+12>>2]=c[k+12>>2];k=a+260|0;if((c[k>>2]|0)<=0){i=f;return}l=a+268|0;a=e;d=0;do{b=c[(c[l>>2]|0)+(d<<2)>>2]|0;if(dj[c[(c[a>>2]|0)+8>>2]&511](e,c[b+188>>2]|0)|0){atG(h,j,b,c[b+192>>2]|0,b+4|0,e)}d=d+1|0;}while((d|0)<(c[k>>2]|0));i=f;return}function akt(a){a=a|0;return cA[c[(c[a>>2]|0)+16>>2]&4095](a|0)|0}function aku(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function akv(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;axT(a,b,c,d,e,0.0);return}function akw(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=+f;axT(a,b,c,d,e,f);return}function akx(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=a+164|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];do{if(+g[b>>2]!=1.0){f=1}else{if(+g[b+4>>2]!=1.0){f=1;break}f=+g[b+8>>2]!=1.0|0}}while(0);c[a+180>>2]=f;return}function aky(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(295)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}g[d+164>>2]=1.0;g[d+168>>2]=1.0;g[d+172>>2]=1.0;g[d+176>>2]=0.0;c[d+180>>2]=0;g[d+184>>2]=999999984306749400.0;aDD(d+188|0,0,16);c[d+204>>2]=1;c[d+208>>2]=-1;c[d+212>>2]=-1;c[d+216>>2]=1;g[d+220>>2]=0.0;g[d+224>>2]=.5;g[d+228>>2]=0.0;c[d+236>>2]=0;g[d+240>>2]=1.0;g[d+244>>2]=0.0;g[d+248>>2]=0.0;c[d+252>>2]=0;g[d+4>>2]=1.0;aDD(d+8|0,0,16);g[d+24>>2]=1.0;aDD(d+28|0,0,16);g[d+44>>2]=1.0;aDD(d+48|0,0,20);c[d>>2]=25632;a[d+272|0]=1;c[d+268>>2]=0;c[d+260>>2]=0;c[d+264>>2]=0;c[d+232>>2]=4;return d|0}function akz(a,b){a=a|0;b=b|0;var d=0,e=0;d=a+4|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+20|0;d=b+16|0;c[e>>2]=c[d>>2];c[e+4>>2]=c[d+4>>2];c[e+8>>2]=c[d+8>>2];c[e+12>>2]=c[d+12>>2];d=a+36|0;e=b+32|0;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=a+52|0;a=b+48|0;c[e>>2]=c[a>>2];c[e+4>>2]=c[a+4>>2];c[e+8>>2]=c[a+8>>2];c[e+12>>2]=c[a+12>>2];return}function akA(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function akB(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a|0,b,d);return}function akC(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function akD(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function akE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+60>>2]&1023](a,b,d,e);return}function akF(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function akG(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function akH(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function akI(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a|0,b,d,e);return}function akJ(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function akK(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function akL(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function akM(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function akN(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function akO(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function akP(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function akQ(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function akR(a){a=a|0;return cA[c[(c[a>>2]|0)+8>>2]&4095](a)|0}function akS(a,b){a=a|0;b=+b;g[a+84>>2]=b;return}function akT(a){a=a|0;return+(+g[a+96>>2])}function akU(a,b){a=a|0;b=+b;g[a+92>>2]=b;return}function akV(a,b){a=a|0;b=+b;g[a+88>>2]=b;return}function akW(a){a=a|0;return+(+g[a+92>>2])}function akX(a){a=a|0;return+(+g[a+84>>2])}function akY(a,b){a=a|0;b=+b;g[a+96>>2]=b;return}function akZ(a,b){a=a|0;b=+b;g[a+100>>2]=b;return}function ak_(a,b){a=a|0;b=+b;g[a+104>>2]=b;return}function ak$(a){a=a|0;return+(+g[a+88>>2])}function ak0(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function ak1(a){a=a|0;return a+8|0}function ak2(a){a=a|0;return c[a>>2]|0}function ak3(a,b){a=a|0;b=+b;g[a+40>>2]=b;return}function ak4(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function ak5(a){a=a|0;return+(+g[a+40>>2])}function ak6(a){a=a|0;return c[a+4>>2]|0}function ak7(a){a=a|0;return a+24|0}function ak8(a){a=a|0;return c[a+60>>2]|0}function ak9(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0.0,h=0.0,i=0.0,j=0,k=0,l=0,m=0;f=(+g[d>>2]- +g[a+12>>2])*+g[a+44>>2];h=(+g[d+4>>2]- +g[a+16>>2])*+g[a+48>>2];i=(+g[d+8>>2]- +g[a+20>>2])*+g[a+52>>2];do{if(f>0.0){d=c[a+8>>2]|0;if(f<+(d>>>0>>>0)){j=~~f&c[a+4>>2]|e;break}else{j=d&c[a+4>>2]|e;break}}else{j=e}}while(0);c[b>>2]=j;do{if(h>0.0){j=c[a+8>>2]|0;if(h<+(j>>>0>>>0)){k=~~h&c[a+4>>2]|e;break}else{k=j&c[a+4>>2]|e;break}}else{k=e}}while(0);c[b+4>>2]=k;if(i<=0.0){l=e;m=b+8|0;c[m>>2]=l;return}k=c[a+8>>2]|0;if(i<+(k>>>0>>>0)){l=~~i&c[a+4>>2]|e;m=b+8|0;c[m>>2]=l;return}else{l=k&c[a+4>>2]|e;m=b+8|0;c[m>>2]=l;return}}function ala(a){a=a|0;return c[a+104>>2]|0}function alb(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;e=i;i=i+16|0;f=e|0;h=e+8|0;g[b+84>>2]=+g[d+16>>2];g[b+88>>2]=+g[d+20>>2];g[b+92>>2]=+g[d+24>>2];g[b+96>>2]=+g[d+28>>2];g[b+104>>2]=+g[d+32>>2];j=b+4|0;b=d+40|0;k=c[b>>2]|0;c[f>>2]=0;ant(j,k,f);f=d|0;k=j+12|0;l=0;while(1){if((l|0)>=(c[b>>2]|0)){break}c[(c[k>>2]|0)+(l<<2)>>2]=c[(c[f>>2]|0)+(l<<2)>>2];l=l+1|0}l=d+36|0;f=c[l>>2]|0;c[h>>2]=0;ant(j+20|0,f,h);h=d+4|0;f=j+32|0;k=0;while(1){if((k|0)>=(c[l>>2]|0)){break}c[(c[f>>2]|0)+(k<<2)>>2]=c[(c[h>>2]|0)+(k<<2)>>2];k=k+1|0}k=d+44|0;h=c[k>>2]|0;f=j+44|0;l=c[f>>2]|0;L1395:do{if((h|0)<(l|0)){b=h;while(1){if((b|0)>=(l|0)){break}b=b+1|0}m=j+52|0}else{do{if((h|0)>(l|0)){b=j+48|0;if((c[b>>2]|0)>=(h|0)){break}do{if((h|0)==0){n=0}else{c[9806]=(c[9806]|0)+1;o=aDx((h<<4|4)+15|0)|0;if((o|0)==0){n=0;break}p=-(o+4|0)&15;c[o+p>>2]=o;n=o+(p+4)|0}}while(0);p=c[f>>2]|0;o=j+52|0;q=0;while(1){if((q|0)>=(p|0)){break}r=n+(q<<4)|0;if((r|0)!=0){s=r;r=(c[o>>2]|0)+(q<<4)|0;c[s>>2]=c[r>>2];c[s+4>>2]=c[r+4>>2];c[s+8>>2]=c[r+8>>2];c[s+12>>2]=c[r+12>>2]}q=q+1|0}q=c[f>>2]|0;p=0;while(1){if((p|0)>=(q|0)){break}p=p+1|0}p=c[o>>2]|0;q=j+56|0;if((p|0)==0){t=q}else{if((a[q]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-16+12>>2]|0)}c[o>>2]=0;t=q}a[t]=1;c[o>>2]=n;c[b>>2]=h}}while(0);q=j+52|0;p=l;while(1){if((p|0)>=(h|0)){m=q;break L1395}r=c[q>>2]|0;s=r+(p<<4)|0;if((s|0)!=0){c[s>>2]=0;g[r+(p<<4)+4>>2]=6.2831854820251465;g[r+(p<<4)+8>>2]=6.2831854820251465;g[r+(p<<4)+12>>2]=6.2831854820251465}p=p+1|0}}}while(0);c[f>>2]=h;h=d+8|0;f=0;while(1){if((f|0)>=(c[k>>2]|0)){break}g[(c[m>>2]|0)+(f<<4)+4>>2]=+g[(c[h>>2]|0)+(f<<4)+4>>2];g[(c[m>>2]|0)+(f<<4)+8>>2]=+g[(c[h>>2]|0)+(f<<4)+8>>2];g[(c[m>>2]|0)+(f<<4)+12>>2]=+g[(c[h>>2]|0)+(f<<4)+12>>2];c[(c[m>>2]|0)+(f<<4)>>2]=c[(c[h>>2]|0)+(f<<4)>>2];f=f+1|0}f=d+48|0;h=c[f>>2]|0;m=j+64|0;k=c[m>>2]|0;L1437:do{if((h|0)<(k|0)){l=h;while(1){if((l|0)>=(k|0)){break}l=l+1|0}u=j+72|0}else{do{if((h|0)>(k|0)){l=j+68|0;if((c[l>>2]|0)>=(h|0)){break}do{if((h|0)==0){v=0}else{c[9806]=(c[9806]|0)+1;n=aDx((h<<2)+19|0)|0;if((n|0)==0){v=0;break}t=-(n+4|0)&15;c[n+t>>2]=n;v=n+(t+4)|0}}while(0);b=c[m>>2]|0;o=j+72|0;t=0;while(1){if((t|0)>=(b|0)){break}n=v+(t<<2)|0;if((n|0)!=0){c[n>>2]=c[(c[o>>2]|0)+(t<<2)>>2]}t=t+1|0}t=c[m>>2]|0;b=0;while(1){if((b|0)>=(t|0)){break}b=b+1|0}b=c[o>>2]|0;t=j+76|0;if((b|0)==0){w=t}else{if((a[t]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[b-4>>2]|0)}c[o>>2]=0;w=t}a[w]=1;c[o>>2]=v;c[l>>2]=h}}while(0);t=j+72|0;b=k;while(1){if((b|0)>=(h|0)){u=t;break L1437}n=(c[t>>2]|0)+(b<<2)|0;if((n|0)!=0){c[n>>2]=0}b=b+1|0}}}while(0);c[m>>2]=h;h=d+12|0;d=0;while(1){if((d|0)>=(c[f>>2]|0)){break}c[(c[u>>2]|0)+(d<<2)>>2]=c[(c[h>>2]|0)+(d<<2)>>2];d=d+1|0}i=e;return}function alc(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+12>>2]&511](a,b,d)|0}function ald(a){a=a|0;if((a|0)==0){return}aDB(a);return}function ale(a,b){a=a|0;b=b|0;var d=0;d=a+8|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function alf(a,b){a=a|0;b=b|0;var d=0;d=a+24|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function alg(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return alh(a|0,b,c,d,e,f,g,h)|0}function alh(a,d,e,f,g,h,j,k){a=a|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;j=j|0;k=k|0;var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;l=i;i=i+32|0;m=l|0;n=l+16|0;ak9(a,m|0,d,0);ak9(a,n|0,e,1);e=a+72|0;d=c[e>>2]|0;o=a+68|0;p=c[o>>2]|0;c[e>>2]=c[p+(d*76|0)+48>>2];e=a+60|0;c[e>>2]=(c[e>>2]|0)+1;c[p+(d*76|0)+12>>2]=d;c[p+(d*76|0)>>2]=f;b[p+(d*76|0)+4>>1]=g;b[p+(d*76|0)+6>>1]=h;c[p+(d*76|0)+8>>2]=k;k=c[e>>2]<<1;e=k|1;h=k-1|0;g=0;while(1){if(g>>>0>=3){break}f=(c[o>>2]|0)+60+(g<<2)|0;c[f>>2]=(c[f>>2]|0)+2;f=a+76+(g<<2)|0;q=c[f>>2]|0;r=q+(h<<3)|0;s=q+(e<<3)|0;q=c[r+4>>2]|0;c[s>>2]=c[r>>2];c[s+4>>2]=q;c[(c[f>>2]|0)+(h<<3)>>2]=c[m+(g<<2)>>2];c[(c[f>>2]|0)+(h<<3)+4>>2]=d;c[(c[f>>2]|0)+(k<<3)>>2]=c[n+(g<<2)>>2];c[(c[f>>2]|0)+(k<<3)+4>>2]=d;c[p+(d*76|0)+48+(g<<2)>>2]=h;c[p+(d*76|0)+60+(g<<2)>>2]=k;g=g+1|0}am6(a,0,c[p+(d*76|0)+48>>2]|0,0);anc(a,0,c[p+(d*76|0)+60>>2]|0,j,0);am6(a,1,c[p+(d*76|0)+52>>2]|0,0);anc(a,1,c[p+(d*76|0)+64>>2]|0,j,0);am6(a,2,c[p+(d*76|0)+56>>2]|0,1);anc(a,2,c[p+(d*76|0)+68>>2]|0,j,1);i=l;return d|0}function ali(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;ak9(a|0,b,c,d);return}function alj(a,b,c){a=a|0;b=b|0;c=c|0;alk(a|0,b,c);return}function alk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=a+68|0;f=c[e>>2]|0;g=a+100|0;h=c[g>>2]|0;if(!(cA[c[(c[h>>2]|0)+56>>2]&4095](h)|0)){h=c[g>>2]|0;dA[c[(c[h>>2]|0)+16>>2]&511](h|0,f+(b*76|0)|0,d)}h=a+60|0;g=c[h>>2]<<1;i=0;while(1){if((i|0)>=3){break}j=(c[e>>2]|0)+60+(i<<2)|0;c[j>>2]=(c[j>>2]|0)-2;i=i+1|0}i=a+8|0;j=g-1|0;g=0;while(1){if((g|0)>=3){break}k=c[a+76+(g<<2)>>2]|0;l=c[f+(b*76|0)+60+(g<<2)>>2]|0;c[k+(l<<3)>>2]=c[i>>2];ana(a,g,l,0);l=c[f+(b*76|0)+48+(g<<2)>>2]|0;c[k+(l<<3)>>2]=c[i>>2];anb(a,g,l,d,0);c[k+(j<<3)+4>>2]=0;c[k+(j<<3)>>2]=c[i>>2];g=g+1|0}g=a+72|0;c[(c[e>>2]|0)+(b*76|0)+48>>2]=c[g>>2];c[g>>2]=b;c[h>>2]=(c[h>>2]|0)-1;return}function all(a,b){a=a|0;b=b|0;cg(a|0,b|0);return}function alm(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=+f;var h=0,i=0,j=0;while(1){h=aDx(44)|0;if((h|0)!=0){i=1465;break}j=(C=c[10744]|0,c[10744]=C+0,C);if((j|0)==0){break}dC[j&63]()}if((i|0)==1465){c[h>>2]=a;c[h+4>>2]=b;b=h+8|0;a=d;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];a=h+24|0;b=e;c[a>>2]=c[b>>2];c[a+4>>2]=c[b+4>>2];c[a+8>>2]=c[b+8>>2];c[a+12>>2]=c[b+12>>2];g[h+40>>2]=f;return h|0}h=cd(4)|0;c[h>>2]=19096;bF(h|0,34368,676);return 0}function aln(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;a=b;b=d;d=0;while(1){if((d|0)>=3){e=1;f=1474;break}if((c[a+60+(d<<2)>>2]|0)>>>0<(c[b+48+(d<<2)>>2]|0)>>>0){e=0;f=1472;break}if((c[b+60+(d<<2)>>2]|0)>>>0<(c[a+48+(d<<2)>>2]|0)>>>0){e=0;f=1473;break}d=d+1|0}if((f|0)==1472){return e|0}else if((f|0)==1473){return e|0}else if((f|0)==1474){return e|0}return 0}function alo(a,b){a=a|0;b=b|0;c[a+104>>2]=b;return}function alp(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0;f=c[a+76>>2]|0;h=(c[f+(c[b+60>>2]<<3)>>2]|0)+1&65535;i=c[a+80>>2]|0;j=(c[i+(c[b+64>>2]<<3)>>2]|0)+1&65535;k=c[a+84>>2]|0;l=(c[k+(c[b+68>>2]<<3)>>2]|0)+1&65535;m=a+44|0;n=+((c[f+(c[b+48>>2]<<3)>>2]&65535)>>>0)/+g[m>>2];f=a+48|0;o=+((c[i+(c[b+52>>2]<<3)>>2]&65535)>>>0)/+g[f>>2];i=a+52|0;p=+((c[k+(c[b+56>>2]<<3)>>2]&65535)>>>0)/+g[i>>2];b=d|0;g[b>>2]=n;k=d+4|0;g[k>>2]=o;q=d+8|0;g[q>>2]=p;g[d+12>>2]=0.0;d=a+12|0;g[b>>2]=n+ +g[d>>2];b=a+16|0;g[k>>2]=o+ +g[b>>2];k=a+20|0;g[q>>2]=p+ +g[k>>2];p=+((h&65535)>>>0)/+g[m>>2];o=+((j&65535)>>>0)/+g[f>>2];n=+((l&65535)>>>0)/+g[i>>2];i=e|0;g[i>>2]=p;l=e+4|0;g[l>>2]=o;f=e+8|0;g[f>>2]=n;g[e+12>>2]=0.0;g[i>>2]=p+ +g[d>>2];g[l>>2]=o+ +g[b>>2];g[f>>2]=n+ +g[k>>2];return}function alq(a,b){a=a|0;b=b|0;return(c[a+68>>2]|0)+(b*76|0)|0}function alr(a){a=a|0;return(c[a+4>>2]|0)==31|0}function als(a,b){a=a|0;b=b|0;c[a+8>>2]=b;return}function alt(a){a=a|0;return+(+g[a+44>>2])}function alu(a){a=a|0;return(c[a+4>>2]|0)<7|0}function alv(a){a=a|0;return+(+g[a+28>>2]*+g[a+12>>2])}function alw(a){a=a|0;return a+12|0}function alx(a,b){a=a|0;b=+b;g[a+28>>2]=b;g[a+44>>2]=b;return}function aly(a){a=a|0;return(c[a+4>>2]|0)<20|0}function alz(a){a=a|0;return(c[a+4>>2]|0)==28|0}function alA(a){a=a|0;return c[a+8>>2]|0}function alB(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20&(b|0)<30?(b|0)!=25:0)|0}function alC(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)==17?1:(b|0)==18)|0}function alD(a){a=a|0;return(c[a+4>>2]|0)==32|0}function alE(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+32|0;g=f|0;h=f+16|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(g|0,0,16);aDD(h|0,0,16);c_[j&127](a|0,b,d,e,g,h);i=f;return}function alF(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;g=i;i=i+16|0;h=g|0;j=c[(c[a>>2]|0)+24>>2]|0;aDD(h|0,0,16);c_[j&127](a|0,b,d,e,f,h);i=g;return}function alG(a,b,d,e,f,g){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;c_[c[(c[a>>2]|0)+24>>2]&127](a|0,b,d,e,f,g);return}function alH(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+16>>2]&255](a|0,b,d,e,f);return}function alI(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+48>>2]&2047](a|0,b);return}function alJ(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+20>>2]&1023](a|0,b,d,e);return}function alK(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;alL(a|0,b,c,d,e);return}function alL(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;i=i+32|0;h=g|0;j=g+16|0;k=c[a+68>>2]|0;ak9(a,h|0,d,0);ak9(a,j|0,e,1);e=0;while(1){if((e|0)>=3){break}d=c[k+(b*76|0)+48+(e<<2)>>2]|0;l=c[k+(b*76|0)+60+(e<<2)>>2]|0;m=c[h+(e<<2)>>2]|0;n=a+76+(e<<2)|0;o=c[n>>2]|0;p=o+(d<<3)|0;q=m-(c[p>>2]|0)|0;r=c[j+(e<<2)>>2]|0;s=r-(c[o+(l<<3)>>2]|0)|0;c[p>>2]=m;c[(c[n>>2]|0)+(l<<3)>>2]=r;if((q|0)<0){am6(a,e,d,1)}if((s|0)>0){ana(a,e,l,1)}if((q|0)>0){anb(a,e,d,f,1)}if((s|0)<0){anc(a,e,l,f,1)}e=e+1|0}i=g;return}function alM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;c[9806]=(c[9806]|0)+1;d=aDx(143)|0;if((d|0)==0){e=0}else{f=-(d+4|0)&15;c[d+f>>2]=d;e=d+(f+4)|0}f=e;aq7(f,a,b,15e5,0,0);return f|0}function alN(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;c[9806]=(c[9806]|0)+1;e=aDx(143)|0;if((e|0)==0){f=0}else{g=-(e+4|0)&15;c[e+g>>2]=e;f=e+(g+4)|0}g=f;aq7(g,a,b,d,0,0);return g|0}function alO(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;c[9806]=(c[9806]|0)+1;f=aDx(143)|0;if((f|0)==0){g=0}else{h=-(f+4|0)&15;c[f+h>>2]=f;g=f+(h+4)|0}h=g;aq7(h,a,b,d,e,0);return h|0}function alP(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0;c[9806]=(c[9806]|0)+1;g=aDx(143)|0;if((g|0)==0){h=0}else{i=-(g+4|0)&15;c[g+i>>2]=g;h=g+(i+4)|0}i=h;aq7(i,a,b,d,e,f);return i|0}function alQ(a){a=a|0;ct[c[(c[a>>2]|0)+52>>2]&2047](a|0);return}function alR(a,b,d,e,f,g,h,i,j){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;i=i|0;j=j|0;return c5[c[(c[a>>2]|0)+8>>2]&63](a|0,b,d,e,f,g,h,i,j)|0}function alS(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function alT(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+32>>2]&2047](a|0,b);return}function alU(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a|0)|0}function alV(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+28>>2]&1023](a|0,b,d,e);return}function alW(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+44>>2]&511](a|0,b,d);return}function alX(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,d);return}function alY(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+16>>2]&2047](a,b);return}function alZ(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;return+(+db[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e,f))}function al_(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;co[c[(c[a>>2]|0)+8>>2]&255](a,b,d,e,f);return}function al$(a,b,d){a=a|0;b=+b;d=d|0;cX[c[(c[a>>2]|0)+32>>2]&255](a,b,d);return}function al0(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43728]|0)==0){if((b1(43728)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+60>>2]&511](f,b,d);d=f;c[9618]=c[d>>2];c[9619]=c[d+4>>2];c[9620]=c[d+8>>2];c[9621]=c[d+12>>2];i=e;return 38472}function al1(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+52>>2]&511](a|0,b,d)|0}function al2(a){a=a|0;return cA[c[(c[a>>2]|0)+28>>2]&4095](a|0)|0}function al3(a){a=a|0;return cA[c[(c[a>>2]|0)+76>>2]&4095](a|0)|0}function al4(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;avP(a|0,b,c,d);return}function al5(a){a=a|0;return cA[c[(c[a>>2]|0)+48>>2]&4095](a|0)|0}function al6(a){a=a|0;return cA[c[(c[a>>2]|0)+36>>2]&4095](a)|0}function al7(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43264]|0)==0){if((b1(43264)|0)==0){break}}}while(0);avB(f,b|0,d);d=f;c[9614]=c[d>>2];c[9615]=c[d+4>>2];c[9616]=c[d+8>>2];c[9617]=c[d+12>>2];i=e;return 38456}function al8(a,b){a=a|0;b=b|0;var d=0;d=a+28|0;a=b;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function al9(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a|0,b);return}function ama(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+8>>2]&1023](a,b,d,e);return}function amb(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43584]|0)==0){if((b1(43584)|0)==0){break}}}while(0);avC(f,b|0,d);d=f;c[9610]=c[d>>2];c[9611]=c[d+4>>2];c[9612]=c[d+8>>2];c[9613]=c[d+12>>2];i=e;return 38440}function amc(a,b){a=a|0;b=+b;return+(+cU[c[(c[a>>2]|0)+20>>2]&127](a|0,b))}function amd(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+44>>2]&1023](a))}function ame(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+80>>2]&511](a|0,b,d);return}function amf(a,b){a=a|0;b=+b;cq[c[(c[a>>2]|0)+40>>2]&1023](a,b);return}function amg(a){a=+a;var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(71)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d+8>>2]=0;g[d+12>>2]=1.0;g[d+16>>2]=1.0;g[d+20>>2]=1.0;g[d+24>>2]=0.0;c[d>>2]=25528;c[d+4>>2]=8;g[d+28>>2]=a;g[d+44>>2]=a;return d|0}function amh(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e|0;do{if((a[43424]|0)==0){if((b1(43424)|0)==0){break}}}while(0);dA[c[(c[b>>2]|0)+64>>2]&511](f,b,d);d=f;c[9606]=c[d>>2];c[9607]=c[d+4>>2];c[9608]=c[d+8>>2];c[9609]=c[d+12>>2];i=e;return 38424}function ami(a){a=a|0;var b=0,d=0.0;b=a|0;switch(c[a+4>>2]|0){case 10:{d=+g[b+44>>2];break};case 1:{d=+g[b+44>>2];break};case 13:{d=+g[b+44>>2];break};case 8:{d=+g[b+28>>2]*+g[b+12>>2];break};case 5:case 4:{d=+g[b+44>>2];break};case 0:{d=+g[b+44>>2];break};default:{d=+dh[c[(c[a>>2]|0)+44>>2]&1023](b)}}return+d}function amj(){return 0}function amk(a){a=a|0;return}function aml(a){a=a|0;return}function amm(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;return}function amn(a,b,c,d){a=a|0;b=b|0;c=c|0;d=+d;return}function amo(a){a=a|0;return a+28|0}function amp(a){a=a|0;var b=0;b=c[a+4>>2]|0;return((b|0)>20?(b|0)<30:0)|0}function amq(a){a=a|0;return c[a+4>>2]|0}function amr(a,b){a=a|0;b=b|0;c[a+144>>2]=b;return}function ams(a){a=a|0;return a+104|0}function amt(b,c,d){b=b|0;c=c|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0;e=+g[c>>2]+-1.0;f=+g[c+4>>2]+-1.0;h=+g[c+8>>2]+-1.0;g[b+4>>2]=e;g[b+8>>2]=f;g[b+12>>2]=h;g[b+16>>2]=0.0;i=+g[d>>2]+1.0;j=+g[d+4>>2]+1.0;k=+g[d+8>>2]+1.0;g[b+20>>2]=i;g[b+24>>2]=j;g[b+28>>2]=k;g[b+32>>2]=0.0;g[b+36>>2]=65533.0/(i-e);g[b+40>>2]=65533.0/(j-f);g[b+44>>2]=65533.0/(k-h);g[b+48>>2]=0.0;a[b+60|0]=1;return}function amu(b,c,d,e){b=b|0;c=c|0;d=d|0;e=+e;var f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0;f=+g[c>>2]-e;h=+g[c+4>>2]-e;i=+g[c+8>>2]-e;g[b+4>>2]=f;g[b+8>>2]=h;g[b+12>>2]=i;g[b+16>>2]=0.0;j=+g[d>>2]+e;k=+g[d+4>>2]+e;l=+g[d+8>>2]+e;g[b+20>>2]=j;g[b+24>>2]=k;g[b+28>>2]=l;g[b+32>>2]=0.0;g[b+36>>2]=65533.0/(j-f);g[b+40>>2]=65533.0/(k-h);g[b+44>>2]=65533.0/(l-i);g[b+48>>2]=0.0;a[b+60|0]=1;return}function amv(b){b=b|0;return(a[b+60|0]&1)!=0|0}function amw(b){b=b|0;return(c[b+168>>2]<<5)+172+(c[b+56>>2]<<((a[b+60|0]&1)==0?6:4))|0}function amx(a){a=a|0;return a+124|0}function amy(a){a=a|0;return a+148|0}function amz(a){a=a|0;return c[a>>2]|0}function amA(a,b){a=a|0;b=b|0;c[a+4>>2]=b;return}function amB(a,b){a=a|0;b=b|0;c[a>>2]=b;return}function amC(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=c[b>>2]|0;b=c[d>>2]|0;if((e|0)==(b|0)){f=1;return f|0}else{g=e;h=b}while(1){i=a[g]|0;j=a[h]|0;if(i<<24>>24!=j<<24>>24){k=1618;break}if(i<<24>>24==0){l=0;break}g=g+1|0;h=h+1|0}do{if((k|0)==1618){h=(i&255)-(j&255)|0;if((h|0)<0){l=-1;break}else{m=h}l=(m|0)>0?1:m}}while(0);f=(l|0)==0;return f|0}function amD(a){a=a|0;return c[a+4>>2]|0}function amE(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;b=d;d=c;while(1){e=a[d]|0;f=a[b]|0;if(e<<24>>24!=f<<24>>24){break}if(e<<24>>24==0){g=0;h=1633;break}b=b+1|0;d=d+1|0}if((h|0)==1633){return g|0}h=(e&255)-(f&255)|0;if((h|0)<0){g=-1;return g|0}else{g=h;return((g|0)>0?1:g)|0}return 0}function amF(a){a=a|0;return c[a+4>>2]|0}function amG(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function amH(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+68>>2]&1023](a,b,d,e);return}function amI(a,b,d){a=a|0;b=b|0;d=+d;var e=0,f=0;e=i;i=i+8|0;f=e|0;g[f>>2]=d;dA[c[(c[a>>2]|0)+12>>2]&511](a|0,b,f);i=e;return}function amJ(a){a=a|0;return+(+dh[c[(c[a>>2]|0)+16>>2]&1023](a|0))}function amK(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+56>>2]&2047](a|0,b);return}function amL(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;dI[c[(c[a>>2]|0)+72>>2]&1023](a|0,b,d,e);return}function amM(a,b,c,d,e,f,g){a=a|0;b=b|0;c=c|0;d=d|0;e=+e;f=f|0;g=g|0;atv(a|0,b,c,d,e,f,g);return}function amN(a){a=a|0;azj(a);return}function amO(a,b,d){a=a|0;b=b|0;d=d|0;return(cS[c[(c[a>>2]|0)+16>>2]&511](a,b,d)|0)!=0|0}function amP(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+8>>2]&127](a,b,d,e)|0}function amQ(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;qX(a,b,c,d);return}function amR(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;azn(a,b,c,d);return}function amS(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0;h=i;i=i+32|0;j=h|0;k=h+16|0;aDD(j|0,0,16);aDD(k|0,0,16);if((a[b+60|0]&1)==0){azp(b,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k);i=h;return}else{azq(b,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],j,k,c[b+56>>2]|0);i=h;return}}function amT(a,b,c){a=a|0;b=b|0;c=c|0;return azs(a,b,c)|0}function amU(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;rD(a,b,c,d);return}function amV(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+24>>2]&2047](a,b);return}function amW(a){a=a|0;return cA[c[(c[a>>2]|0)+12>>2]&4095](a)|0}function amX(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function amY(){var b=0,d=0,e=0;c[9806]=(c[9806]|0)+1;b=aDx(191)|0;if((b|0)==0){d=0}else{e=-(b+4|0)&15;c[b+e>>2]=b;d=b+(e+4)|0}c[d>>2]=25328;c[d+52>>2]=278;a[d+60|0]=0;a[d+80|0]=1;c[d+76>>2]=0;c[d+68>>2]=0;c[d+72>>2]=0;a[d+100|0]=1;c[d+96>>2]=0;c[d+88>>2]=0;c[d+92>>2]=0;a[d+120|0]=1;c[d+116>>2]=0;c[d+108>>2]=0;c[d+112>>2]=0;a[d+140|0]=1;c[d+136>>2]=0;c[d+128>>2]=0;c[d+132>>2]=0;c[d+144>>2]=0;a[d+164|0]=1;c[d+160>>2]=0;c[d+152>>2]=0;c[d+156>>2]=0;c[d+168>>2]=0;g[d+4>>2]=-3.4028234663852886e+38;g[d+8>>2]=-3.4028234663852886e+38;g[d+12>>2]=-3.4028234663852886e+38;g[d+16>>2]=0.0;g[d+20>>2]=3.4028234663852886e+38;g[d+24>>2]=3.4028234663852886e+38;g[d+28>>2]=3.4028234663852886e+38;g[d+32>>2]=0.0;return d|0}function amZ(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+20>>2]&2047](a,b);return}function am_(b,c){b=b|0;c=c|0;var d=0.0,f=0.0;do{if((a[43920]|0)==0){if((b1(43920)|0)==0){break}}}while(0);d=+((e[c+2>>1]|0)>>>0)/+g[b+40>>2]+ +g[b+8>>2];f=+((e[c+4>>1]|0)>>>0)/+g[b+44>>2]+ +g[b+12>>2];g[9602]=+((e[c>>1]|0)>>>0)/+g[b+36>>2]+ +g[b+4>>2];g[9603]=d;g[9604]=f;g[9605]=0.0;return 38408}function am$(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;if((a[b+60|0]&1)==0){azp(b,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,i);return}else{azq(b,d,e,+g[f>>2],+g[f+4>>2],+g[f+8>>2],h,i,c[b+56>>2]|0);return}}function am0(a){a=a|0;if((a|0)==0){return}aDB(a);return}function am1(a,b,d){a=a|0;b=b|0;d=d|0;return cS[c[(c[a>>2]|0)+8>>2]&511](a,b,d)|0}function am2(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;return dE[c[(c[a>>2]|0)+12>>2]&127](a,b,d,e)|0}function am3(a){a=a|0;if((a|0)==0){return}ct[c[(c[a>>2]|0)+4>>2]&2047](a);return}function am4(a,b,d){a=a|0;b=b|0;d=d|0;dA[c[(c[a>>2]|0)+16>>2]&511](a,b,d);return}function am5(a){a=a|0;if((a|0)==0){return}aDB(a);return}function am6(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;f=c[a+76+(b<<2)>>2]|0;g=c[f+(d<<3)+4>>2]|0;h=a+68|0;i=c[h>>2]|0;j=i+(g*76|0)+48+(b<<2)|0;k=1<<b&3;l=1<<k&3;m=i+(g*76|0)+60+(k<<2)|0;n=a+100|0;o=i+(g*76|0)|0;p=a+104|0;a=i+(g*76|0)+48+(k<<2)|0;q=i+(g*76|0)+60+(l<<2)|0;r=i+(g*76|0)+48+(l<<2)|0;g=f+(d<<3)|0;i=f+(d-1<<3)|0;while(1){d=c[i>>2]|0;if((c[g>>2]|0)>>>0>=d>>>0){break}f=c[i+4>>2]|0;s=c[h>>2]|0;if((d&1|0)==0){d=s+(f*76|0)+48+(b<<2)|0;c[d>>2]=(c[d>>2]|0)+1}else{do{if(e){if((c[m>>2]|0)>>>0<(c[s+(f*76|0)+48+(k<<2)>>2]|0)>>>0){break}if((c[s+(f*76|0)+60+(k<<2)>>2]|0)>>>0<(c[a>>2]|0)>>>0){break}if((c[q>>2]|0)>>>0<(c[s+(f*76|0)+48+(l<<2)>>2]|0)>>>0){break}if((c[s+(f*76|0)+60+(l<<2)>>2]|0)>>>0<(c[r>>2]|0)>>>0){break}d=c[n>>2]|0;t=d|0;u=c[(c[d>>2]|0)+8>>2]|0;d=s+(f*76|0)|0;cS[u&511](t,o,d)|0;t=c[p>>2]|0;if((t|0)==0){break}u=c[(c[t>>2]|0)+8>>2]|0;cS[u&511](t,o,d)|0}}while(0);d=s+(f*76|0)+60+(b<<2)|0;c[d>>2]=(c[d>>2]|0)+1}c[j>>2]=(c[j>>2]|0)-1;d=g;t=c[d>>2]|0;u=c[d+4>>2]|0;v=i;w=c[v+4>>2]|0;c[d>>2]=c[v>>2];c[d+4>>2]=w;c[v>>2]=t;c[v+4>>2]=u;g=g-8|0;i=i-8|0}return}function am7(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;while(1){d=aDx(8)|0;if((d|0)!=0){break}e=(C=c[10744]|0,c[10744]=C+0,C);if((e|0)==0){f=1720;break}dC[e&63]()}if((f|0)==1720){f=cd(4)|0;c[f>>2]=19096;bF(f|0,34368,676);return 0}f=d;c[d>>2]=b;e=0;g=-2128831035;while(1){h=a[b+e|0]|0;if(h<<24>>24==0){break}e=e+1|0;g=aa(g^h<<24>>24,16777619)|0}c[d+4>>2]=g;return f|0}function am8(){var a=0,b=0,d=0;while(1){a=aDx(4)|0;if((a|0)!=0){b=1738;break}d=(C=c[10744]|0,c[10744]=C+0,C);if((d|0)==0){break}dC[d&63]()}if((b|0)==1738){c[a>>2]=22888;return a|0}a=cd(4)|0;c[a>>2]=19096;bF(a|0,34368,676);return 0}function am9(a){a=a|0;return}function ana(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;f=c[a+76+(b<<2)>>2]|0;g=c[f+(d<<3)+4>>2]|0;h=a+68|0;i=c[h>>2]|0;j=1<<b&3;k=1<<j&3;l=i+(g*76|0)+60+(j<<2)|0;m=a+100|0;n=a+104|0;a=i+(g*76|0)+48+(j<<2)|0;o=i+(g*76|0)+60+(k<<2)|0;p=i+(g*76|0)+48+(k<<2)|0;q=i+(g*76|0)+60+(b<<2)|0;g=f+(d<<3)|0;i=f+(d+1<<3)|0;while(1){d=c[i+4>>2]|0;if((d|0)==0){r=1755;break}f=c[i>>2]|0;if((c[g>>2]|0)>>>0<f>>>0){r=1756;break}s=c[h>>2]|0;if((f&1|0)==0){do{if(e){if((c[l>>2]|0)>>>0<(c[s+(d*76|0)+48+(j<<2)>>2]|0)>>>0){break}if((c[s+(d*76|0)+60+(j<<2)>>2]|0)>>>0<(c[a>>2]|0)>>>0){break}if((c[o>>2]|0)>>>0<(c[s+(d*76|0)+48+(k<<2)>>2]|0)>>>0){break}if((c[s+(d*76|0)+60+(k<<2)>>2]|0)>>>0<(c[p>>2]|0)>>>0){break}f=c[m>>2]|0;t=f|0;u=c[(c[f>>2]|0)+8>>2]|0;f=s+((c[g+4>>2]|0)*76|0)|0;v=s+(d*76|0)|0;cS[u&511](t,f,v)|0;t=c[n>>2]|0;if((t|0)==0){break}u=c[(c[t>>2]|0)+8>>2]|0;cS[u&511](t,f,v)|0}}while(0);v=s+(d*76|0)+48+(b<<2)|0;c[v>>2]=(c[v>>2]|0)-1}else{v=s+(d*76|0)+60+(b<<2)|0;c[v>>2]=(c[v>>2]|0)-1}c[q>>2]=(c[q>>2]|0)+1;v=g;f=c[v>>2]|0;t=c[v+4>>2]|0;u=i;w=c[u+4>>2]|0;c[v>>2]=c[u>>2];c[v+4>>2]=w;c[u>>2]=f;c[u+4>>2]=t;g=g+8|0;i=i+8|0}if((r|0)==1755){return}else if((r|0)==1756){return}}function anb(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=c[a+76+(b<<2)>>2]|0;h=a+68|0;i=(c[h>>2]|0)+((c[g+(d<<3)+4>>2]|0)*76|0)+48+(b<<2)|0;j=1<<b&3;k=1<<j&3;l=a+100|0;m=a+104|0;a=g+(d<<3)|0;n=g+(d+1<<3)|0;while(1){d=c[n+4>>2]|0;if((d|0)==0){o=1773;break}g=c[n>>2]|0;if((c[a>>2]|0)>>>0<g>>>0){o=1772;break}p=c[h>>2]|0;if((g&1|0)==0){g=p+(d*76|0)+48+(b<<2)|0;c[g>>2]=(c[g>>2]|0)-1}else{g=c[a+4>>2]|0;do{if(f){if((c[p+(g*76|0)+60+(j<<2)>>2]|0)>>>0<(c[p+(d*76|0)+48+(j<<2)>>2]|0)>>>0){break}if((c[p+(d*76|0)+60+(j<<2)>>2]|0)>>>0<(c[p+(g*76|0)+48+(j<<2)>>2]|0)>>>0){break}if((c[p+(g*76|0)+60+(k<<2)>>2]|0)>>>0<(c[p+(d*76|0)+48+(k<<2)>>2]|0)>>>0){break}if((c[p+(d*76|0)+60+(k<<2)>>2]|0)>>>0<(c[p+(g*76|0)+48+(k<<2)>>2]|0)>>>0){break}q=c[l>>2]|0;r=q|0;s=c[(c[q>>2]|0)+12>>2]|0;q=p+(g*76|0)|0;t=p+(d*76|0)|0;dE[s&127](r,q,t,e)|0;r=c[m>>2]|0;if((r|0)==0){break}s=c[(c[r>>2]|0)+12>>2]|0;dE[s&127](r,q,t,e)|0}}while(0);g=p+(d*76|0)+60+(b<<2)|0;c[g>>2]=(c[g>>2]|0)-1}c[i>>2]=(c[i>>2]|0)+1;g=a;t=c[g>>2]|0;q=c[g+4>>2]|0;r=n;s=c[r+4>>2]|0;c[g>>2]=c[r>>2];c[g+4>>2]=s;c[r>>2]=t;c[r+4>>2]=q;a=a+8|0;n=n+8|0}if((o|0)==1772){return}else if((o|0)==1773){return}}function anc(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=c[a+76+(b<<2)>>2]|0;h=a+68|0;i=1<<b&3;j=1<<i&3;k=a+100|0;l=a+104|0;a=(c[h>>2]|0)+((c[g+(d<<3)+4>>2]|0)*76|0)+60+(b<<2)|0;m=g+(d<<3)|0;n=g+(d-1<<3)|0;while(1){d=c[n>>2]|0;if((c[m>>2]|0)>>>0>=d>>>0){break}g=c[n+4>>2]|0;o=c[h>>2]|0;if((d&1|0)==0){d=c[m+4>>2]|0;do{if(f){if((c[o+(d*76|0)+60+(i<<2)>>2]|0)>>>0<(c[o+(g*76|0)+48+(i<<2)>>2]|0)>>>0){break}if((c[o+(g*76|0)+60+(i<<2)>>2]|0)>>>0<(c[o+(d*76|0)+48+(i<<2)>>2]|0)>>>0){break}if((c[o+(d*76|0)+60+(j<<2)>>2]|0)>>>0<(c[o+(g*76|0)+48+(j<<2)>>2]|0)>>>0){break}if((c[o+(g*76|0)+60+(j<<2)>>2]|0)>>>0<(c[o+(d*76|0)+48+(j<<2)>>2]|0)>>>0){break}p=c[k>>2]|0;q=p|0;r=c[(c[p>>2]|0)+12>>2]|0;p=o+(d*76|0)|0;s=o+(g*76|0)|0;dE[r&127](q,p,s,e)|0;q=c[l>>2]|0;if((q|0)==0){break}r=c[(c[q>>2]|0)+12>>2]|0;dE[r&127](q,p,s,e)|0}}while(0);d=o+(g*76|0)+48+(b<<2)|0;c[d>>2]=(c[d>>2]|0)+1}else{d=o+(g*76|0)+60+(b<<2)|0;c[d>>2]=(c[d>>2]|0)+1}c[a>>2]=(c[a>>2]|0)-1;d=m;s=c[d>>2]|0;p=c[d+4>>2]|0;q=n;r=c[q+4>>2]|0;c[d>>2]=c[q>>2];c[d+4>>2]=r;c[q>>2]=s;c[q+4>>2]=p;m=m-8|0;n=n-8|0}return}function and(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,x=0;h=c[a+68+(d<<2)>>2]|0;i=f&65535;f=a+60|0;j=c[f>>2]|0;k=e[h+(i<<2)+2>>1]|0;l=j+(k<<6)+48+(d<<1)|0;m=1<<d&3;n=1<<m&3;o=j+(k<<6)+54+(m<<1)|0;p=a+92|0;q=j+(k<<6)|0;r=a+96|0;a=j+(k<<6)+48+(m<<1)|0;s=j+(k<<6)+54+(n<<1)|0;t=j+(k<<6)+48+(n<<1)|0;k=h+(i<<2)|0;j=h+(i-1<<2)|0;while(1){i=b[j>>1]|0;if((e[k>>1]|0)>=(i&65535)){break}h=c[f>>2]|0;u=e[j+2>>1]|0;if((i&1)==0){i=h+(u<<6)+48+(d<<1)|0;b[i>>1]=(b[i>>1]|0)+1&65535}else{do{if(g){if((e[o>>1]|0)<(e[h+(u<<6)+48+(m<<1)>>1]|0)){break}if((e[h+(u<<6)+54+(m<<1)>>1]|0)<(e[a>>1]|0)){break}if((e[s>>1]|0)<(e[h+(u<<6)+48+(n<<1)>>1]|0)){break}if((e[h+(u<<6)+54+(n<<1)>>1]|0)<(e[t>>1]|0)){break}i=c[p>>2]|0;v=i|0;x=c[(c[i>>2]|0)+8>>2]|0;i=h+(u<<6)|0;cS[x&511](v,q,i)|0;v=c[r>>2]|0;if((v|0)==0){break}x=c[(c[v>>2]|0)+8>>2]|0;cS[x&511](v,q,i)|0}}while(0);i=h+(u<<6)+54+(d<<1)|0;b[i>>1]=(b[i>>1]|0)+1&65535}b[l>>1]=(b[l>>1]|0)-1&65535;i=k;v=e[i>>1]|e[i+2>>1]<<16;x=j;w=e[x>>1]|e[x+2>>1]<<16;b[i>>1]=w&65535;b[i+2>>1]=w>>16;w=v;b[x>>1]=w&65535;b[x+2>>1]=w>>16;k=k-4|0;j=j-4|0}return}function ane(a,d,f,g){a=a|0;d=d|0;f=f|0;g=g|0;var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,x=0,y=0;h=c[a+68+(d<<2)>>2]|0;i=f&65535;f=a+60|0;j=c[f>>2]|0;k=e[h+(i<<2)+2>>1]|0;l=1<<d&3;m=1<<l&3;n=j+(k<<6)+54+(l<<1)|0;o=a+92|0;p=a+96|0;a=j+(k<<6)+48+(l<<1)|0;q=j+(k<<6)+54+(m<<1)|0;r=j+(k<<6)+48+(m<<1)|0;s=j+(k<<6)+54+(d<<1)|0;k=h+(i<<2)|0;j=h+(i+1<<2)|0;while(1){i=b[j+2>>1]|0;if(i<<16>>16==0){t=1817;break}h=b[j>>1]|0;if((e[k>>1]|0)<(h&65535)){t=1818;break}u=c[f>>2]|0;v=i&65535;if((h&1)==0){do{if(g){if((e[n>>1]|0)<(e[u+(v<<6)+48+(l<<1)>>1]|0)){break}if((e[u+(v<<6)+54+(l<<1)>>1]|0)<(e[a>>1]|0)){break}if((e[q>>1]|0)<(e[u+(v<<6)+48+(m<<1)>>1]|0)){break}if((e[u+(v<<6)+54+(m<<1)>>1]|0)<(e[r>>1]|0)){break}h=c[o>>2]|0;i=h|0;x=c[(c[h>>2]|0)+8>>2]|0;h=u+((e[k+2>>1]|0)<<6)|0;y=u+(v<<6)|0;cS[x&511](i,h,y)|0;i=c[p>>2]|0;if((i|0)==0){break}x=c[(c[i>>2]|0)+8>>2]|0;cS[x&511](i,h,y)|0}}while(0);y=u+(v<<6)+48+(d<<1)|0;b[y>>1]=(b[y>>1]|0)-1&65535}else{y=u+(v<<6)+54+(d<<1)|0;b[y>>1]=(b[y>>1]|0)-1&65535}b[s>>1]=(b[s>>1]|0)+1&65535;y=k;h=e[y>>1]|e[y+2>>1]<<16;i=j;w=e[i>>1]|e[i+2>>1]<<16;b[y>>1]=w&65535;b[y+2>>1]=w>>16;w=h;b[i>>1]=w&65535;b[i+2>>1]=w>>16;k=k+4|0;j=j+4|0}if((t|0)==1817){return}else if((t|0)==1818){return}}function anf(a,d,f,g,h){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;i=c[a+68+(d<<2)>>2]|0;j=f&65535;f=a+60|0;k=(c[f>>2]|0)+((e[i+(j<<2)+2>>1]|0)<<6)+48+(d<<1)|0;l=1<<d&3;m=1<<l&3;n=a+92|0;o=a+96|0;a=i+(j<<2)|0;p=i+(j+1<<2)|0;while(1){j=b[p+2>>1]|0;if(j<<16>>16==0){q=1834;break}i=b[p>>1]|0;if((e[a>>1]|0)<(i&65535)){q=1835;break}r=c[f>>2]|0;s=j&65535;if((i&1)==0){i=r+(s<<6)+48+(d<<1)|0;b[i>>1]=(b[i>>1]|0)-1&65535}else{i=e[a+2>>1]|0;do{if(h){if((e[r+(i<<6)+54+(l<<1)>>1]|0)<(e[r+(s<<6)+48+(l<<1)>>1]|0)){break}if((e[r+(s<<6)+54+(l<<1)>>1]|0)<(e[r+(i<<6)+48+(l<<1)>>1]|0)){break}if((e[r+(i<<6)+54+(m<<1)>>1]|0)<(e[r+(s<<6)+48+(m<<1)>>1]|0)){break}if((e[r+(s<<6)+54+(m<<1)>>1]|0)<(e[r+(i<<6)+48+(m<<1)>>1]|0)){break}j=c[n>>2]|0;t=j|0;u=c[(c[j>>2]|0)+12>>2]|0;j=r+(i<<6)|0;v=r+(s<<6)|0;dE[u&127](t,j,v,g)|0;t=c[o>>2]|0;if((t|0)==0){break}u=c[(c[t>>2]|0)+12>>2]|0;dE[u&127](t,j,v,g)|0}}while(0);i=r+(s<<6)+54+(d<<1)|0;b[i>>1]=(b[i>>1]|0)-1&65535}b[k>>1]=(b[k>>1]|0)+1&65535;i=a;v=e[i>>1]|e[i+2>>1]<<16;j=p;w=e[j>>1]|e[j+2>>1]<<16;b[i>>1]=w&65535;b[i+2>>1]=w>>16;w=v;b[j>>1]=w&65535;b[j+2>>1]=w>>16;a=a+4|0;p=p+4|0}if((q|0)==1834){return}else if((q|0)==1835){return}}function ang(a,d,f,g,h){a=a|0;d=d|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;i=c[a+68+(d<<2)>>2]|0;j=f&65535;f=a+60|0;k=1<<d&3;l=1<<k&3;m=a+92|0;n=a+96|0;a=(c[f>>2]|0)+((e[i+(j<<2)+2>>1]|0)<<6)+54+(d<<1)|0;o=i+(j<<2)|0;p=i+(j-1<<2)|0;while(1){j=b[p>>1]|0;if((e[o>>1]|0)>=(j&65535)){break}i=c[f>>2]|0;q=e[p+2>>1]|0;if((j&1)==0){j=e[o+2>>1]|0;do{if(h){if((e[i+(j<<6)+54+(k<<1)>>1]|0)<(e[i+(q<<6)+48+(k<<1)>>1]|0)){break}if((e[i+(q<<6)+54+(k<<1)>>1]|0)<(e[i+(j<<6)+48+(k<<1)>>1]|0)){break}if((e[i+(j<<6)+54+(l<<1)>>1]|0)<(e[i+(q<<6)+48+(l<<1)>>1]|0)){break}if((e[i+(q<<6)+54+(l<<1)>>1]|0)<(e[i+(j<<6)+48+(l<<1)>>1]|0)){break}r=c[m>>2]|0;s=r|0;t=c[(c[r>>2]|0)+12>>2]|0;r=i+(j<<6)|0;u=i+(q<<6)|0;dE[t&127](s,r,u,g)|0;s=c[n>>2]|0;if((s|0)==0){break}t=c[(c[s>>2]|0)+12>>2]|0;dE[t&127](s,r,u,g)|0}}while(0);j=i+(q<<6)+48+(d<<1)|0;b[j>>1]=(b[j>>1]|0)+1&65535}else{j=i+(q<<6)+54+(d<<1)|0;b[j>>1]=(b[j>>1]|0)+1&65535}b[a>>1]=(b[a>>1]|0)-1&65535;j=o;u=e[j>>1]|e[j+2>>1]<<16;r=p;w=e[r>>1]|e[r+2>>1]<<16;b[j>>1]=w&65535;b[j+2>>1]=w>>16;w=u;b[r>>1]=w&65535;b[r+2>>1]=w>>16;o=o-4|0;p=p-4|0}return}function anh(a){a=a|0;if((a|0)==0){return}aDB(a);return}function ani(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;a=c[b>>2]|0;e=c[d>>2]|0;if((c[a+232>>2]|0)==4){f=a}else{f=0}if((c[e+232>>2]|0)==4){g=e}else{g=0}if((f|0)!=0){dA[c[(c[f>>2]|0)+28>>2]&511](f,d,b)}if((g|0)==0){return 0}dA[c[(c[g>>2]|0)+28>>2]&511](g,b,d);return 0}function anj(a,b,c){a=a|0;b=b|0;c=c|0;return}function ank(a){a=a|0;return}function anl(a){a=a|0;return}function anm(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;return 0}function ann(a){a=a|0;return}function ano(a,b,c,d,e,f,g,h){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;return+0.0}function anp(a,b){a=a|0;b=+b;g[a+44>>2]=b;return}function anq(a,c){a=a|0;c=c|0;var d=0;if((b[c+4>>1]&b[a+10>>1])<<16>>16==0){d=0;return d|0}d=(b[a+8>>1]&b[c+6>>1])<<16>>16!=0;return d|0}function anr(a,c){a=a|0;c=c|0;var d=0;if((b[c+4>>1]&b[a+6>>1])<<16>>16==0){d=0;return d|0}d=(b[a+4>>1]&b[c+6>>1])<<16>>16!=0;return d|0}function ans(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;a=c[b>>2]|0;f=c[d>>2]|0;if((c[a+232>>2]|0)==4){g=a}else{g=0}if((c[f+232>>2]|0)==4){h=f}else{h=0}if((g|0)!=0){dI[c[(c[g>>2]|0)+32>>2]&1023](g,d,e,b)}if((h|0)==0){return 0}dI[c[(c[h>>2]|0)+32>>2]&1023](h,b,e,d);return 0}function ant(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=b+4|0;g=c[f>>2]|0;if((g|0)>(d|0)){h=d;while(1){if((h|0)>=(g|0)){break}h=h+1|0}c[f>>2]=d;return}do{if((g|0)<(d|0)){h=b+8|0;if((c[h>>2]|0)>=(d|0)){break}do{if((d|0)==0){i=0}else{c[9806]=(c[9806]|0)+1;j=aDx((d<<2)+19|0)|0;if((j|0)==0){i=0;break}k=-(j+4|0)&15;c[j+k>>2]=j;i=j+(k+4)|0}}while(0);k=c[f>>2]|0;j=b+12|0;l=0;while(1){if((l|0)>=(k|0)){break}m=i+(l<<2)|0;if((m|0)!=0){c[m>>2]=c[(c[j>>2]|0)+(l<<2)>>2]}l=l+1|0}l=c[f>>2]|0;k=0;while(1){if((k|0)>=(l|0)){break}k=k+1|0}k=c[j>>2]|0;l=b+16|0;if((k|0)==0){n=l}else{if((a[l]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[k-4>>2]|0)}c[j>>2]=0;n=l}a[n]=1;c[j>>2]=i;c[h>>2]=d}}while(0);i=b+12|0;b=g;while(1){if((b|0)>=(d|0)){break}g=(c[i>>2]|0)+(b<<2)|0;if((g|0)!=0){c[g>>2]=c[e>>2]}b=b+1|0}c[f>>2]=d;return}function anu(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;h=i;i=i+16|0;j=h|0;k=+g[b+4>>2]- +g[a+4>>2];l=+g[b+8>>2]- +g[a+8>>2];g[e>>2]=+g[b>>2]- +g[a>>2];g[e+4>>2]=k;g[e+8>>2]=l;g[e+12>>2]=0.0;e=c+12|0;a=c+8|0;do{if(+g[e>>2]==+g[d+12>>2]){if(+g[a>>2]!=+g[d+8>>2]){m=a;n=1926;break}b=c+4|0;if(+g[b>>2]!=+g[d+4>>2]){m=a;n=1926;break}o=c|0;if(+g[o>>2]!=+g[d>>2]){p=o;q=b;r=a;break}aDD(f|0,0,16);i=h;return}else{m=a;n=1926}}while(0);if((n|0)==1926){p=c|0;q=c+4|0;r=m}ah6(j,c,d);l=-0.0- +g[p>>2];k=-0.0- +g[q>>2];s=-0.0- +g[r>>2];t=+g[e>>2];u=+g[j+12>>2];v=+g[j>>2];w=+g[j+4>>2];x=+g[j+8>>2];y=u*l+v*t+w*s-x*k;z=u*k+w*t+x*l-v*s;A=u*s+x*t+v*k-w*l;B=u*t-v*l-w*k-x*s;do{if(B<-1.0){C=-1.0}else{if(B<=1.0){C=B;break}C=1.0}}while(0);B=+V(+C)*2.0;C=y*y+z*z+A*A;if(C<1.4210854715202004e-14){D=0.0;E=0.0;F=1.0}else{s=1.0/+Q(+C);D=A*s;E=z*s;F=y*s}g[f>>2]=F*B;g[f+4>>2]=E*B;g[f+8>>2]=D*B;g[f+12>>2]=0.0;i=h;return}function anv(a){a=a|0;if((a|0)==0){return}aDB(a);return}function anw(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0;e=b+40|0;g[a+4>>2]=+g[e>>2];f=c[b>>2]|0;c[a+76>>2]=f;if(d){d=a+44|0;h=b+8|0;c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2];i=a+60|0;j=b+24|0;k=i;l=j;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];m=+g[e>>2];return+m}else{n=+g[b+8>>2];o=+g[b+12>>2];p=+g[b+16>>2];q=+g[f+20>>2]*n+ +g[f+24>>2]*o+ +g[f+28>>2]*p;r=+g[f+36>>2]*n+ +g[f+40>>2]*o+ +g[f+44>>2]*p;g[a+44>>2]=+g[f+4>>2]*n+ +g[f+8>>2]*o+ +g[f+12>>2]*p;g[a+48>>2]=q;g[a+52>>2]=r;g[a+56>>2]=0.0;i=a+60|0;j=b+24|0;k=i;l=j;c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];m=+g[e>>2];return+m}return 0.0}function anx(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0;d=i;i=i+72|0;e=d|0;f=d+8|0;h=d+16|0;j=d+24|0;k=d+32|0;l=d+40|0;m=d+48|0;n=d+56|0;o=d+64|0;p=+g[c>>2];q=+g[b>>2];r=+g[c+16>>2];s=+g[b+4>>2];t=+g[c+32>>2];u=+g[b+8>>2];g[e>>2]=p*q+r*s+t*u;v=+g[c+4>>2];w=+g[c+20>>2];x=+g[c+36>>2];g[f>>2]=v*q+w*s+x*u;y=+g[c+8>>2];z=+g[c+24>>2];A=+g[c+40>>2];g[h>>2]=y*q+z*s+A*u;u=+g[b+16>>2];s=+g[b+20>>2];q=+g[b+24>>2];g[j>>2]=p*u+r*s+t*q;g[k>>2]=v*u+w*s+x*q;g[l>>2]=y*u+z*s+A*q;q=+g[b+32>>2];s=+g[b+36>>2];u=+g[b+40>>2];g[m>>2]=p*q+r*s+t*u;g[n>>2]=v*q+w*s+x*u;g[o>>2]=y*q+z*s+A*u;d$(a,e,f,h,j,k,l,m,n,o);i=d;return}function any(a){a=a|0;if((a|0)==0){return}aDB(a);return}function anz(a,b,d,e,f,h,i,j,k,l){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=+j;k=k|0;l=+l;var m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;m=a;n=h;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];o=+g[e+4>>2];p=+g[a+8>>2];q=+g[e+8>>2];r=+g[a+4>>2];s=o*p-q*r;t=+g[a>>2];u=+g[e>>2];v=q*t-u*p;q=u*r-o*t;o=+g[b>>2]*s+ +g[b+4>>2]*v+ +g[b+8>>2]*q;u=+g[b+16>>2]*s+ +g[b+20>>2]*v+ +g[b+24>>2]*q;w=+g[b+32>>2]*s+ +g[b+36>>2]*v+ +g[b+40>>2]*q;g[a+16>>2]=o;g[a+20>>2]=u;g[a+24>>2]=w;g[a+28>>2]=0.0;q=-0.0-t;t=-0.0-r;r=-0.0-p;p=+g[f+4>>2];v=+g[f+8>>2];s=p*r-v*t;x=+g[f>>2];y=v*q-x*r;r=x*t-p*q;q=+g[d>>2]*s+ +g[d+4>>2]*y+ +g[d+8>>2]*r;p=+g[d+16>>2]*s+ +g[d+20>>2]*y+ +g[d+24>>2]*r;t=+g[d+32>>2]*s+ +g[d+36>>2]*y+ +g[d+40>>2]*r;g[a+32>>2]=q;g[a+36>>2]=p;g[a+40>>2]=t;g[a+44>>2]=0.0;r=+g[i>>2]*o;y=+g[i+4>>2]*u;s=+g[i+8>>2]*w;g[a+48>>2]=r;g[a+52>>2]=y;g[a+56>>2]=s;g[a+60>>2]=0.0;x=+g[k>>2]*q;v=+g[k+4>>2]*p;z=+g[k+8>>2]*t;g[a+64>>2]=x;g[a+68>>2]=v;g[a+72>>2]=z;g[a+76>>2]=0.0;g[a+80>>2]=r*o+y*u+s*w+j+l+(x*q+v*p+z*t);return}function anA(a){a=a|0;if((a|0)==0){return}aDB(a);return}function anB(a){a=a|0;return}function anC(a){a=a|0;return}function anD(a,c){a=a|0;c=c|0;var d=0;if((b[c+4>>1]&b[a+14>>1])<<16>>16==0){d=0;return d|0}d=(b[a+12>>1]&b[c+6>>1])<<16>>16!=0;return d|0}function anE(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c[b>>2]=19512;d=b+116|0;e=c[d>>2]|0;f=0;while(1){if((f|0)>=(e|0)){break}f=f+1|0}f=b+124|0;e=c[f>>2]|0;g=b+128|0;if((e|0)==0){h=g}else{if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[e-4>>2]|0)}c[f>>2]=0;h=g}a[h]=1;c[f>>2]=0;c[d>>2]=0;c[b+120>>2]=0;d=b+96|0;f=c[d>>2]|0;h=0;while(1){if((h|0)>=(f|0)){break}h=h+1|0}h=b+104|0;f=c[h>>2]|0;g=b+108|0;if((f|0)==0){i=g}else{if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-16+12>>2]|0)}c[h>>2]=0;i=g}a[i]=1;c[h>>2]=0;c[d>>2]=0;c[b+100>>2]=0;d=b+76|0;h=c[d>>2]|0;i=0;while(1){if((i|0)>=(h|0)){break}i=i+1|0}i=b+84|0;h=c[i>>2]|0;g=b+88|0;if((h|0)==0){j=g}else{if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[h-16+12>>2]|0)}c[i>>2]=0;j=g}a[j]=1;c[i>>2]=0;c[d>>2]=0;c[b+80>>2]=0;d=b+24|0;i=c[d>>2]|0;j=0;while(1){if((j|0)>=(i|0)){break}j=j+1|0}j=b+32|0;i=c[j>>2]|0;g=b+36|0;if((i|0)==0){k=g;a[k]=1;c[j>>2]=0;c[d>>2]=0;l=b+28|0;c[l>>2]=0;return}if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[i-4>>2]|0)}c[j>>2]=0;k=g;a[k]=1;c[j>>2]=0;c[d>>2]=0;l=b+28|0;c[l>>2]=0;return}function anF(a){a=a|0;anE(a);if((a|0)==0){return}aDB(a);return}function anG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0.0;f=i;i=i+32|0;h=f|0;j=f+16|0;k=d|0;l=b+8|0;c[l>>2]=c[k>>2];m=b+24|0;n=c[m>>2]|0;o=b+28|0;do{if((n|0)==(c[o>>2]|0)){p=(n|0)==0?1:n<<1;if((n|0)>=(p|0)){q=n;break}do{if((p|0)==0){r=0}else{c[9806]=(c[9806]|0)+1;s=aDx((p<<2)+19|0)|0;if((s|0)==0){r=0;break}t=-(s+4|0)&15;c[s+t>>2]=s;r=s+(t+4)|0}}while(0);t=c[m>>2]|0;s=b+32|0;u=0;while(1){if((u|0)>=(t|0)){break}v=r+(u<<2)|0;if((v|0)!=0){c[v>>2]=c[(c[s>>2]|0)+(u<<2)>>2]}u=u+1|0}u=c[m>>2]|0;t=0;while(1){if((t|0)>=(u|0)){break}t=t+1|0}t=c[s>>2]|0;v=b+36|0;if((t|0)==0){w=u;x=v}else{if((a[v]&1)==0){y=u}else{c[9804]=(c[9804]|0)+1;aDB(c[t-4>>2]|0);y=c[m>>2]|0}c[s>>2]=0;w=y;x=v}a[x]=1;c[s>>2]=r;c[o>>2]=p;q=w}else{q=n}}while(0);n=(c[b+32>>2]|0)+(q<<2)|0;if((n|0)==0){z=q}else{c[n>>2]=c[k>>2];z=c[m>>2]|0}c[m>>2]=z+1;if(e){e=h;z=d+8|0;c[e>>2]=c[z>>2];c[e+4>>2]=c[z+4>>2];c[e+8>>2]=c[z+8>>2];c[e+12>>2]=c[z+12>>2]}else{z=c[l>>2]|0;A=+g[d+8>>2];B=+g[d+12>>2];C=+g[d+16>>2];D=+g[z+20>>2]*A+ +g[z+24>>2]*B+ +g[z+28>>2]*C;E=+g[z+36>>2]*A+ +g[z+40>>2]*B+ +g[z+44>>2]*C;g[h>>2]=+g[z+4>>2]*A+ +g[z+8>>2]*B+ +g[z+12>>2]*C;g[h+4>>2]=D;g[h+8>>2]=E;g[h+12>>2]=0.0}anH(b+72|0,h);h=d+24|0;E=+g[h>>2];D=1.0-E;g[j>>2]=D*+g[b+40>>2]+ +g[b+56>>2]*E;g[j+4>>2]=D*+g[b+44>>2]+E*+g[b+60>>2];g[j+8>>2]=D*+g[b+48>>2]+E*+g[b+64>>2];anH(b+92|0,j);j=b+116|0;d=c[j>>2]|0;z=b+120|0;do{if((d|0)==(c[z>>2]|0)){l=(d|0)==0?1:d<<1;if((d|0)>=(l|0)){F=d;break}do{if((l|0)==0){G=0}else{c[9806]=(c[9806]|0)+1;e=aDx((l<<2)+19|0)|0;if((e|0)==0){G=0;break}m=-(e+4|0)&15;c[e+m>>2]=e;G=e+(m+4)|0}}while(0);p=c[j>>2]|0;s=b+124|0;u=0;while(1){if((u|0)>=(p|0)){break}m=G+(u<<2)|0;if((m|0)!=0){g[m>>2]=+g[(c[s>>2]|0)+(u<<2)>>2]}u=u+1|0}u=c[j>>2]|0;p=0;while(1){if((p|0)>=(u|0)){break}p=p+1|0}p=c[s>>2]|0;m=b+128|0;if((p|0)==0){H=u;I=m}else{if((a[m]&1)==0){J=u}else{c[9804]=(c[9804]|0)+1;aDB(c[p-4>>2]|0);J=c[j>>2]|0}c[s>>2]=0;H=J;I=m}a[I]=1;c[s>>2]=G;c[z>>2]=l;F=H}else{F=d}}while(0);d=(c[b+124>>2]|0)+(F<<2)|0;if((d|0)==0){K=F;L=K+1|0;c[j>>2]=L;M=b+4|0;N=+g[M>>2];i=f;return+N}g[d>>2]=+g[h>>2];K=c[j>>2]|0;L=K+1|0;c[j>>2]=L;M=b+4|0;N=+g[M>>2];i=f;return+N}function anH(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;e=b+4|0;f=c[e>>2]|0;g=b+8|0;do{if((f|0)==(c[g>>2]|0)){h=(f|0)==0?1:f<<1;if((f|0)>=(h|0)){i=f;break}do{if((h|0)==0){j=0}else{c[9806]=(c[9806]|0)+1;k=aDx((h<<4|4)+15|0)|0;if((k|0)==0){j=0;break}l=-(k+4|0)&15;c[k+l>>2]=k;j=k+(l+4)|0}}while(0);l=c[e>>2]|0;k=b+12|0;m=0;while(1){if((m|0)>=(l|0)){break}n=j+(m<<4)|0;if((n|0)!=0){o=n;n=(c[k>>2]|0)+(m<<4)|0;c[o>>2]=c[n>>2];c[o+4>>2]=c[n+4>>2];c[o+8>>2]=c[n+8>>2];c[o+12>>2]=c[n+12>>2]}m=m+1|0}m=c[e>>2]|0;l=0;while(1){if((l|0)>=(m|0)){break}l=l+1|0}l=c[k>>2]|0;n=b+16|0;if((l|0)==0){p=m;q=n}else{if((a[n]&1)==0){r=m}else{c[9804]=(c[9804]|0)+1;aDB(c[l-16+12>>2]|0);r=c[e>>2]|0}c[k>>2]=0;p=r;q=n}a[q]=1;c[k>>2]=j;c[g>>2]=h;i=p}else{i=f}}while(0);f=(c[b+12>>2]|0)+(i<<4)|0;if((f|0)==0){s=i;t=s+1|0;c[e>>2]=t;return}i=f;f=d;c[i>>2]=c[f>>2];c[i+4>>2]=c[f+4>>2];c[i+8>>2]=c[f+8>>2];c[i+12>>2]=c[f+12>>2];s=c[e>>2]|0;t=s+1|0;c[e>>2]=t;return}function anI(a){a=a|0;if((a|0)==0){return}aDB(a);return}function anJ(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=b+24|0;g[a+4>>2]=+g[e>>2];f=c[b>>2]|0;c[a+8>>2]=f;if(d){d=a+52|0;h=b+8|0;c[d>>2]=c[h>>2];c[d+4>>2]=c[h+4>>2];c[d+8>>2]=c[h+8>>2];c[d+12>>2]=c[h+12>>2]}else{i=+g[b+8>>2];j=+g[b+12>>2];k=+g[b+16>>2];l=+g[f+20>>2]*i+ +g[f+24>>2]*j+ +g[f+28>>2]*k;m=+g[f+36>>2]*i+ +g[f+40>>2]*j+ +g[f+44>>2]*k;g[a+52>>2]=+g[f+4>>2]*i+ +g[f+8>>2]*j+ +g[f+12>>2]*k;g[a+56>>2]=l;g[a+60>>2]=m;g[a+64>>2]=0.0}m=+g[e>>2];l=1.0-m;g[a+68>>2]=l*+g[a+20>>2]+ +g[a+36>>2]*m;g[a+72>>2]=l*+g[a+24>>2]+m*+g[a+40>>2];g[a+76>>2]=l*+g[a+28>>2]+m*+g[a+44>>2];return+(+g[e>>2])}function anK(a){a=a|0;if((a|0)==0){return}aDB(a);return}function anL(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0;d=i;i=i+224|0;e=d|0;f=d+48|0;h=d+96|0;j=d+160|0;k=f;d$(f,a+68|0,a+84|0,a+100|0,a+72|0,a+88|0,a+104|0,a+76|0,a+92|0,a+108|0);l=-0.0- +g[a+116>>2];m=-0.0- +g[a+120>>2];n=-0.0- +g[a+124>>2];o=+g[f>>2]*l+ +g[f+4>>2]*m+ +g[f+8>>2]*n;p=+g[f+16>>2]*l+ +g[f+20>>2]*m+ +g[f+24>>2]*n;q=+g[f+32>>2]*l+ +g[f+36>>2]*m+ +g[f+40>>2]*n;r=j+48|0;s=j|0;do{s=s+16|0;}while((s|0)!=(r|0));r=j;c[r>>2]=c[k>>2];c[r+4>>2]=c[k+4>>2];c[r+8>>2]=c[k+8>>2];c[r+12>>2]=c[k+12>>2];k=j+16|0;r=f+16|0;c[k>>2]=c[r>>2];c[k+4>>2]=c[r+4>>2];c[k+8>>2]=c[r+8>>2];c[k+12>>2]=c[r+12>>2];r=j+32|0;k=f+32|0;c[r>>2]=c[k>>2];c[r+4>>2]=c[k+4>>2];c[r+8>>2]=c[k+8>>2];c[r+12>>2]=c[k+12>>2];k=j+48|0;g[k>>2]=o;r=j+52|0;g[r>>2]=p;f=j+56|0;g[f>>2]=q;g[j+60>>2]=0.0;s=e;anx(e,j|0,a+4|0);q=+g[a+52>>2];p=+g[a+56>>2];o=+g[a+60>>2];n=+g[j>>2]*q+ +g[j+4>>2]*p+ +g[j+8>>2]*o+ +g[k>>2];m=+g[j+16>>2]*q+ +g[j+20>>2]*p+ +g[j+24>>2]*o+ +g[r>>2];l=+g[j+32>>2]*q+ +g[j+36>>2]*p+ +g[j+40>>2]*o+ +g[f>>2];f=h+48|0;j=h|0;do{j=j+16|0;}while((j|0)!=(f|0));f=h;c[f>>2]=c[s>>2];c[f+4>>2]=c[s+4>>2];c[f+8>>2]=c[s+8>>2];c[f+12>>2]=c[s+12>>2];s=h+16|0;j=e+16|0;c[s>>2]=c[j>>2];c[s+4>>2]=c[j+4>>2];c[s+8>>2]=c[j+8>>2];c[s+12>>2]=c[j+12>>2];j=h+32|0;s=e+32|0;c[j>>2]=c[s>>2];c[j+4>>2]=c[s+4>>2];c[j+8>>2]=c[s+8>>2];c[j+12>>2]=c[s+12>>2];g[h+48>>2]=n;g[h+52>>2]=m;g[h+56>>2]=l;g[h+60>>2]=0.0;s=b;c[s>>2]=c[f>>2];c[s+4>>2]=c[f+4>>2];c[s+8>>2]=c[f+8>>2];c[s+12>>2]=c[f+12>>2];f=b+16|0;s=h+16|0;c[f>>2]=c[s>>2];c[f+4>>2]=c[s+4>>2];c[f+8>>2]=c[s+8>>2];c[f+12>>2]=c[s+12>>2];s=b+32|0;f=h+32|0;c[s>>2]=c[f>>2];c[s+4>>2]=c[f+4>>2];c[s+8>>2]=c[f+8>>2];c[s+12>>2]=c[f+12>>2];f=b+48|0;b=h+48|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];i=d;return}function anM(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0;d=i;i=i+112|0;e=d|0;f=d+48|0;h=a+4|0;j=e;anx(e,b|0,a+68|0);k=+g[a+116>>2];l=+g[a+120>>2];m=+g[a+124>>2];n=+g[b>>2]*k+ +g[b+4>>2]*l+ +g[b+8>>2]*m+ +g[b+48>>2];o=+g[b+16>>2]*k+ +g[b+20>>2]*l+ +g[b+24>>2]*m+ +g[b+52>>2];p=+g[b+32>>2]*k+ +g[b+36>>2]*l+ +g[b+40>>2]*m+ +g[b+56>>2];b=f+48|0;q=f|0;do{q=q+16|0;}while((q|0)!=(b|0));b=f;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];j=f+16|0;q=e+16|0;c[j>>2]=c[q>>2];c[j+4>>2]=c[q+4>>2];c[j+8>>2]=c[q+8>>2];c[j+12>>2]=c[q+12>>2];q=f+32|0;j=e+32|0;c[q>>2]=c[j>>2];c[q+4>>2]=c[j+4>>2];c[q+8>>2]=c[j+8>>2];c[q+12>>2]=c[j+12>>2];g[f+48>>2]=n;g[f+52>>2]=o;g[f+56>>2]=p;g[f+60>>2]=0.0;j=h;c[j>>2]=c[b>>2];c[j+4>>2]=c[b+4>>2];c[j+8>>2]=c[b+8>>2];c[j+12>>2]=c[b+12>>2];b=a+20|0;j=f+16|0;c[b>>2]=c[j>>2];c[b+4>>2]=c[j+4>>2];c[b+8>>2]=c[j+8>>2];c[b+12>>2]=c[j+12>>2];j=a+36|0;b=f+32|0;c[j>>2]=c[b>>2];c[j+4>>2]=c[b+4>>2];c[j+8>>2]=c[b+8>>2];c[j+12>>2]=c[b+12>>2];b=a+52|0;a=f+48|0;c[b>>2]=c[a>>2];c[b+4>>2]=c[a+4>>2];c[b+8>>2]=c[a+8>>2];c[b+12>>2]=c[a+12>>2];i=d;return}function anN(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0,h=0.0,i=0.0,j=0,k=0;d=a+8|0;e=+g[d>>2];if(+P(+e)>.7071067690849304){f=a+4|0;h=+g[f>>2];i=h*h+e*e;e=1.0/+Q(+i);g[b>>2]=0.0;j=b+4|0;g[j>>2]=e*(-0.0- +g[d>>2]);k=b+8|0;g[k>>2]=+g[f>>2]*e;g[c>>2]=i*e;f=a|0;g[c+4>>2]=+g[k>>2]*(-0.0- +g[f>>2]);g[c+8>>2]=+g[f>>2]*+g[j>>2];return}else{j=a|0;e=+g[j>>2];i=+g[a+4>>2];h=e*e+i*i;e=1.0/+Q(+h);a=b|0;g[a>>2]=e*(-0.0-i);i=+g[j>>2]*e;g[b+4>>2]=i;g[b+8>>2]=0.0;g[c>>2]=i*(-0.0- +g[d>>2]);g[c+4>>2]=+g[d>>2]*+g[a>>2];g[c+8>>2]=h*e;return}}function anO(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0;e=d|0;if((a[b+519|0]&1)!=0){c[e>>2]=0;c[d+4>>2]=0;return}c[e>>2]=3;f=d+4|0;c[f>>2]=3;d=c[b+24>>2]|0;h=c[b+28>>2]|0;anP(b,d+4|0,h+4|0,d+256|0,h+256|0);do{if((a[b+518|0]&1)!=0){h=c[e>>2]|0;c[e>>2]=h+1;d=c[f>>2]|0;c[f>>2]=d-1;i=+g[b+448>>2];if(+g[b+436>>2]>=i){break}if(+g[b+440>>2]>=i){break}c[e>>2]=h+2;c[f>>2]=d-2}}while(0);if((a[b+517|0]&1)==0){return}c[e>>2]=(c[e>>2]|0)+1;c[f>>2]=(c[f>>2]|0)-1;return}function anP(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0.0,N=0.0,O=0,R=0,U=0,W=0,X=0.0,Z=0.0,_=0.0,$=0,aa=0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0.0,av=0.0,aw=0.0,ax=0.0,ay=0.0,az=0.0,aA=0.0,aB=0.0,aC=0.0,aD=0.0,aE=0.0,aF=0.0,aG=0,aH=0.0,aI=0.0,aJ=0.0,aK=0.0,aL=0.0,aM=0.0,aN=0.0,aO=0.0,aP=0.0,aQ=0.0,aR=0.0,aS=0.0,aT=0.0,aU=0.0,aV=0.0,aW=0.0,aX=0.0,aY=0.0,aZ=0.0,a_=0.0;j=i;i=i+368|0;k=j|0;l=j+48|0;m=j+96|0;n=j+160|0;o=j+224|0;q=j+288|0;r=j+304|0;s=j+320|0;t=j+336|0;u=j+352|0;v=b+496|0;g[v>>2]=0.0;g[b+492>>2]=0.0;w=b+517|0;a[w]=0;x=b+518|0;a[x]=0;do{if((a[b+544|0]&1)!=0){if((a[b+519|0]&1)!=0){break}y=+g[b+548>>2];z=+g[b+552>>2];A=+g[b+556>>2];B=+g[b+560>>2];C=2.0/(y*y+z*z+A*A+B*B);D=y*C;E=z*C;F=A*C;C=B*D;G=B*E;H=B*F;B=y*D;D=y*E;I=y*F;y=z*E;E=z*F;z=A*F;F=1.0-(y+z);A=D-H;J=I+G;K=D+H;H=1.0-(B+z);z=E-C;D=I-G;G=E+C;C=1.0-(B+y);L=l;anx(l,d|0,b+292|0);y=+g[b+340>>2];B=+g[b+344>>2];E=+g[b+348>>2];I=+g[d>>2]*y+ +g[d+4>>2]*B+ +g[d+8>>2]*E+ +g[d+48>>2];M=+g[d+16>>2]*y+ +g[d+20>>2]*B+ +g[d+24>>2]*E+ +g[d+52>>2];N=+g[d+32>>2]*y+ +g[d+36>>2]*B+ +g[d+40>>2]*E+ +g[d+56>>2];O=m+48|0;R=m|0;do{R=R+16|0;}while((R|0)!=(O|0));O=m;c[O>>2]=c[L>>2];c[O+4>>2]=c[L+4>>2];c[O+8>>2]=c[L+8>>2];c[O+12>>2]=c[L+12>>2];O=m+16|0;R=l+16|0;c[O>>2]=c[R>>2];c[O+4>>2]=c[R+4>>2];c[O+8>>2]=c[R+8>>2];c[O+12>>2]=c[R+12>>2];R=m+32|0;O=l+32|0;c[R>>2]=c[O>>2];c[R+4>>2]=c[O+4>>2];c[R+8>>2]=c[O+8>>2];c[R+12>>2]=c[O+12>>2];O=m+48|0;g[O>>2]=I;R=m+52|0;g[R>>2]=M;U=m+56|0;g[U>>2]=N;g[m+60>>2]=0.0;W=k;anx(k,e|0,b+356|0);E=+g[b+404>>2];B=+g[b+408>>2];y=+g[b+412>>2];X=+g[e>>2]*E+ +g[e+4>>2]*B+ +g[e+8>>2]*y+ +g[e+48>>2];Z=+g[e+16>>2]*E+ +g[e+20>>2]*B+ +g[e+24>>2]*y+ +g[e+52>>2];_=+g[e+32>>2]*E+ +g[e+36>>2]*B+ +g[e+40>>2]*y+ +g[e+56>>2];$=n+48|0;aa=n|0;do{aa=aa+16|0;}while((aa|0)!=($|0));$=n;c[$>>2]=c[W>>2];c[$+4>>2]=c[W+4>>2];c[$+8>>2]=c[W+8>>2];c[$+12>>2]=c[W+12>>2];$=n+16|0;aa=k+16|0;c[$>>2]=c[aa>>2];c[$+4>>2]=c[aa+4>>2];c[$+8>>2]=c[aa+8>>2];c[$+12>>2]=c[aa+12>>2];aa=n+32|0;$=k+32|0;c[aa>>2]=c[$>>2];c[aa+4>>2]=c[$+4>>2];c[aa+8>>2]=c[$+8>>2];c[aa+12>>2]=c[$+12>>2];g[n+48>>2]=X;g[n+52>>2]=Z;g[n+56>>2]=_;g[n+60>>2]=0.0;N=+g[n>>2];M=+g[n+4>>2];I=+g[n+8>>2];y=N*F+K*M+D*I;B=N*A+M*H+G*I;E=N*J+z*M+C*I;ab=+g[n+16>>2];ac=+g[n+20>>2];ad=+g[n+24>>2];ae=F*ab+K*ac+D*ad;af=A*ab+H*ac+G*ad;ag=J*ab+z*ac+C*ad;ah=+g[n+32>>2];ai=+g[n+36>>2];aj=+g[n+40>>2];ak=F*ah+K*ai+D*aj;al=A*ah+H*ai+G*aj;am=J*ah+z*ai+C*aj;an=+g[m>>2];ao=+g[m+16>>2];ap=+g[m+32>>2];aq=+g[m+4>>2];ar=+g[m+20>>2];as=+g[m+36>>2];at=+g[m+8>>2];au=+g[m+24>>2];av=+g[m+40>>2];aw=-0.0- +g[O>>2];ax=-0.0- +g[R>>2];ay=-0.0- +g[U>>2];az=an*aw+ao*ax+ap*ay;aA=aq*aw+ar*ax+as*ay;aB=at*aw+au*ax+av*ay;g[o>>2]=y*an+B*aq+E*at;g[o+4>>2]=y*ao+B*ar+E*au;g[o+8>>2]=y*ap+B*as+E*av;g[o+12>>2]=0.0;g[o+16>>2]=ae*an+af*aq+ag*at;g[o+20>>2]=ae*ao+af*ar+ag*au;g[o+24>>2]=ae*ap+af*as+ag*av;g[o+28>>2]=0.0;g[o+32>>2]=ak*an+al*aq+am*at;g[o+36>>2]=ak*ao+al*ar+am*au;g[o+40>>2]=ak*ap+al*as+am*av;g[o+44>>2]=0.0;g[o+48>>2]=N*0.0+M*0.0+I*0.0+X+(E*aB+(y*az+B*aA));g[o+52>>2]=ab*0.0+ac*0.0+ad*0.0+Z+(ag*aB+(ae*az+af*aA));g[o+56>>2]=ah*0.0+ai*0.0+aj*0.0+_+(am*aB+(ak*az+al*aA));g[o+60>>2]=0.0;ec(o|0,q);aA=+g[q>>2];al=+g[q+4>>2];az=+g[q+8>>2];g[b+464>>2]=0.0;ak=1.0/+Q(+(aA*aA+al*al+az*az));g[b+452>>2]=aA*ak;g[b+456>>2]=al*ak;g[b+460>>2]=az*ak;ak=+g[q+12>>2];az=ak<-1.0?-1.0:ak;ak=+V(+(az>1.0?1.0:az))*2.0;g[v>>2]=ak;if(+P(+ak)<1.1920928955078125e-7){i=j;return}a[x]=1;i=j;return}}while(0);ec(d|0,r);q=b+292|0;ec(q,s);ak=+g[r+12>>2];az=+g[s>>2];al=+g[r>>2];aA=+g[s+12>>2];aB=+g[r+4>>2];am=+g[s+8>>2];aj=+g[r+8>>2];ai=+g[s+4>>2];ah=ak*az+al*aA+aB*am-aj*ai;af=az*aj+(aA*aB+ak*ai)-al*am;ae=ak*am+aA*aj+al*ai-az*aB;ag=ak*aA-az*al-aB*ai-am*aj;ec(e|0,t);s=b+356|0;ec(s,u);aj=+g[t+12>>2];am=+g[u>>2];ai=+g[t>>2];aB=+g[u+12>>2];al=+g[t+4>>2];az=+g[u+8>>2];aA=+g[t+8>>2];ak=+g[u+4>>2];ad=aj*am+ai*aB+al*az-aA*ak;ac=am*aA+(aB*al+aj*ak)-ai*az;ab=aj*az+aB*aA+ai*ak-am*al;B=aj*aB-am*ai-al*ak-az*aA;aA=-0.0-ad;az=-0.0-ac;ak=-0.0-ab;al=ah*B+ag*aA+ae*az-af*ak;ai=ah*ak+(af*B+ag*az)-ae*aA;am=af*aA+(ae*B+ag*ak)-ah*az;aB=ag*B-ah*aA-af*az-ae*ak;aj=ai*0.0;y=am*0.0;E=aB+aj-y;I=aB*0.0;M=al*0.0;N=am+I-M;av=I+M-ai;M=-0.0-al;I=M-aj-y;y=-0.0-ai;aj=-0.0-am;as=N*aj+(aB*E+I*M)-av*y;ap=av*M+(aB*N+I*y)-E*aj;au=E*y+(aB*av+I*aj)-N*M;M=1.0/+Q(+(au*au+(as*as+ap*ap)));N=M*as;as=M*ap;ap=M*au;au=as*0.0;M=ap*0.0;aj=M+(au+N);do{if(aj<-.9999998807907104){if(+P(0.0)>.7071067690849304){aC=0.0;aD=p;aE=p;aF=0.0;break}aC=-0.0;aD=1.0;aE=0.0;aF=0.0}else{I=N*0.0;av=+Q(+((aj+1.0)*2.0));y=1.0/av;aC=(M-au)*y;aD=(I-ap)*y;aE=(as-I)*y;aF=av*.5}}while(0);as=1.0/+Q(+(aF*aF+(aE*aE+(aD*aD+aC*aC))));ap=aC*as;aC=aD*as;aD=aE*as;aE=aF*as;as=-0.0-ap;aF=-0.0-aC;au=-0.0-aD;M=am*aF+(al*aE+aB*as)-ai*au;aj=al*au+(ai*aE+aB*aF)-am*as;N=ai*as+(am*aE+aB*au)-al*aF;av=aB*aE-al*as-ai*aF-am*au;au=1.0/+Q(+(av*av+(N*N+(M*M+aj*aj))));am=au*M;M=au*aj;aj=au*N;N=au*av;av=+g[b+436>>2];au=+g[b+448>>2];u=av<au;do{if(u){aG=2138}else{aF=+g[b+440>>2];if(aF<au){aG=2138;break}ai=aE<-1.0?-1.0:aE;as=+V(+(ai>1.0?1.0:ai))*2.0;do{if(as>1.1920928955078125e-7){ai=1.0/+Q(+(aD*aD+(ap*ap+aC*aC)));al=ap*ai;aB=aC*ai;y=aD*ai;if(+P(+aB)<=1.1920928955078125e-7){aH=al;aI=aB;aJ=y;aK=av;break}ai=y*y/(aB*aB);aH=al;aI=aB;aJ=y;aK=+Q(+((ai+1.0)/(1.0/(aF*aF)+ai/(av*av))))}else{aH=0.0;aI=0.0;aJ=0.0;aK=0.0}}while(0);_=+g[b+420>>2];Z=aK*_;if(as<=Z){break}a[x]=1;X=as-Z;if(as<aK&_<.9999998807907104){aL=X/(aK-Z)}else{aL=1.0}g[b+520>>2]=aL;g[v>>2]=X;if(+P(+aI)>1.1920928955078125e-7){X=+P(+(aI*(-0.0-aJ)/aI*(aF/av)));if(aJ<-0.0){aM=X}else{aM=-0.0-X}X=aM;Z=1.0/+Q(+(aI*aI+aH*aH+X*X));aN=aH*Z;aO=aI*Z;aP=Z*(-0.0-X)}else{aN=aH;aO=aI;aP=aJ}X=-0.0-aN;Z=-0.0-aO;_=-0.0-aP;C=ac*_+B*X-ab*Z;z=B*Z+ab*X-ad*_;J=B*_+ad*Z-ac*X;X=ad*aN-ac*Z-ab*_;_=z*ak+(X*aA+B*C)-J*az;Z=J*aA+(X*az+B*z)-C*ak;G=C*az+(B*J+X*ak)-z*aA;g[b+452>>2]=_;g[b+456>>2]=Z;g[b+460>>2]=G;g[b+464>>2]=0.0;aDD(b+528|0,0,16);g[b+484>>2]=1.0/(_*(+g[f>>2]*_+ +g[f+16>>2]*Z+ +g[f+32>>2]*G)+Z*(_*+g[f+4>>2]+Z*+g[f+20>>2]+G*+g[f+36>>2])+G*(_*+g[f+8>>2]+Z*+g[f+24>>2]+G*+g[f+40>>2])+(_*(_*+g[h>>2]+Z*+g[h+16>>2]+G*+g[h+32>>2])+Z*(_*+g[h+4>>2]+Z*+g[h+20>>2]+G*+g[h+36>>2])+G*(_*+g[h+8>>2]+Z*+g[h+24>>2]+G*+g[h+40>>2])))}}while(0);L2289:do{if((aG|0)==2138){aN=+g[q>>2];aP=+g[b+308>>2];aO=+g[b+324>>2];aJ=+g[d>>2];aI=+g[d+4>>2];aH=+g[d+8>>2];aM=aN*aJ+aP*aI+aO*aH;aL=+g[d+16>>2];aK=+g[d+20>>2];aD=+g[d+24>>2];aC=aN*aL+aP*aK+aO*aD;ap=+g[d+32>>2];aE=+g[d+36>>2];G=+g[d+40>>2];Z=aN*ap+aP*aE+aO*G;aO=+g[b+296>>2];aP=+g[b+312>>2];aN=+g[b+328>>2];_=aJ*aO+aI*aP+aH*aN;z=aL*aO+aK*aP+aD*aN;X=ap*aO+aE*aP+G*aN;aN=+g[b+300>>2];aP=+g[b+316>>2];aO=+g[b+332>>2];J=aJ*aN+aI*aP+aH*aO;aH=aL*aN+aK*aP+aD*aO;aD=ap*aN+aE*aP+G*aO;aO=+g[s>>2];G=+g[b+372>>2];aP=+g[b+388>>2];aE=aO*+g[e>>2]+G*+g[e+4>>2]+aP*+g[e+8>>2];aN=aO*+g[e+16>>2]+G*+g[e+20>>2]+aP*+g[e+24>>2];ap=aO*+g[e+32>>2]+G*+g[e+36>>2]+aP*+g[e+40>>2];aP=aM*aE+aC*aN+Z*ap;G=_*aE+z*aN+X*ap;aO=J*aE+aH*aN+aD*ap;do{if(av<au){aK=+g[b+440>>2];U=+P(+G)<1.1920928955078125e-7;if(aK<au){if(U){if(+P(+aO)<1.1920928955078125e-7){break L2289}}a[x]=1;g[b+452>>2]=-0.0-(Z*aN-aC*ap);g[b+456>>2]=-0.0-(aM*ap-Z*aE);g[b+460>>2]=-0.0-(aC*aE-aM*aN);g[b+464>>2]=0.0;break L2289}if(U){aQ=aP;aR=G;aS=aO;break}a[x]=1;if(aK<au){aQ=aP;aR=G;aS=aO;break}aL=+Y(+aO,+aP);if(aL>aK){aI=+S(+aK);aQ=aI;aR=0.0;aS=+T(+aK);break}if(aL>=-0.0-aK){aQ=aP;aR=0.0;aS=aO;break}aL=+S(+aK);aQ=aL;aR=0.0;aS=-0.0- +T(+aK)}else{if(+P(+aO)<1.1920928955078125e-7){aQ=aP;aR=G;aS=aO;break}a[x]=1;if(u){aQ=aP;aR=G;aS=aO;break}aK=+Y(+G,+aP);if(aK>av){aL=+S(+av);aQ=aL;aR=+T(+av);aS=0.0;break}if(aK>=-0.0-av){aQ=aP;aR=G;aS=0.0;break}aK=+S(+av);aQ=aK;aR=-0.0- +T(+av);aS=0.0}}while(0);G=J*aS+(_*aR+aM*aQ);aP=aH*aS+(z*aR+aC*aQ);aO=aD*aS+(X*aR+Z*aQ);aF=1.0/+Q(+(aO*aO+(G*G+aP*aP)));as=aF*G;G=aF*aP;aP=aF*aO;aO=aN*aP-ap*G;aF=ap*as-aE*aP;aP=aE*G-aN*as;g[b+464>>2]=0.0;as=+Q(+(aO*aO+aF*aF+aP*aP));g[v>>2]=as;G=1.0/as;g[b+452>>2]=G*(-0.0-aO);g[b+456>>2]=G*(-0.0-aF);g[b+460>>2]=G*(-0.0-aP)}}while(0);aQ=+g[b+444>>2];v=b+504|0;if(aQ<0.0){g[v>>2]=0.0;i=j;return}aR=N<-1.0?-1.0:N;aS=+V(+(aR>1.0?1.0:aR))*2.0;if(aS>3.1415927410125732){aR=N>1.0?-1.0:-0.0-N;aT=-0.0-am;aU=-0.0-M;aV=-0.0-aj;aW=+V(+(aR>1.0?1.0:aR))*2.0}else{aT=am;aU=M;aV=aj;aW=aS}g[v>>2]=aW;if(aW>1.1920928955078125e-7){aS=1.0/+Q(+(aV*aV+(aU*aU+aT*aT)));aX=aT*aS;aY=aU*aS;aZ=aV*aS}else{aX=aT;aY=aU;aZ=aV}aV=+g[b+420>>2];aU=aQ*aV;if(aW>aU+1.0e-4){a[w]=1;aT=aW-aU;if(aW<aQ&aV<.9999998807907104){a_=aT/(aQ-aU)}else{a_=1.0}g[b+524>>2]=a_;g[b+500>>2]=aT;aT=-0.0-aX;a_=-0.0-aY;aU=-0.0-aZ;aQ=ac*aU+B*aT-ab*a_;aV=B*a_+ab*aT-ad*aU;aW=B*aU+ad*a_-ac*aT;aT=ad*aX-ac*a_-ab*aU;aU=aV*ak+(aT*aA+B*aQ)-aW*az;ab=aW*aA+(aT*az+B*aV)-aQ*ak;a_=aQ*az+(B*aW+aT*ak)-aV*aA;g[b+468>>2]=aU;g[b+472>>2]=ab;g[b+476>>2]=a_;g[b+480>>2]=0.0;g[b+488>>2]=1.0/(aU*(+g[f>>2]*aU+ +g[f+16>>2]*ab+ +g[f+32>>2]*a_)+ab*(aU*+g[f+4>>2]+ab*+g[f+20>>2]+a_*+g[f+36>>2])+a_*(aU*+g[f+8>>2]+ab*+g[f+24>>2]+a_*+g[f+40>>2])+(aU*(aU*+g[h>>2]+ab*+g[h+16>>2]+a_*+g[h+32>>2])+ab*(aU*+g[h+4>>2]+ab*+g[h+20>>2]+a_*+g[h+36>>2])+a_*(aU*+g[h+8>>2]+ab*+g[h+24>>2]+a_*+g[h+40>>2])))}if((a[x]&1)==0){i=j;return}a_=-0.0-aX;ab=-0.0-aY;aY=-0.0-aZ;aZ=af*aY+ag*a_-ae*ab;aU=ag*ab+ae*a_-ah*aY;aA=ag*aY+ah*ab-af*a_;a_=-0.0-ah;aV=ah*aX-af*ab-ae*aY;aY=-0.0-af;af=-0.0-ae;g[b+528>>2]=aU*af+(aV*a_+ag*aZ)-aA*aY;g[b+532>>2]=aA*a_+(aV*aY+ag*aU)-aZ*af;g[b+536>>2]=aZ*aY+(ag*aA+aV*af)-aU*a_;g[b+540>>2]=0.0;i=j;return}function anQ(a,b){a=a|0;b=b|0;var d=0,e=0;d=c[a+24>>2]|0;e=c[a+28>>2]|0;anR(a,b,d+4|0,e+4|0,d+256|0,e+256|0);return}
function anR(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0,u=0,v=0,w=0.0,x=0,y=0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0.0,G=0.0,H=0.0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0.0,V=0,W=0,X=0,Y=0.0;k=i;i=i+112|0;l=k|0;m=k+48|0;anP(b,e,f,h,j);j=d+8|0;g[c[j>>2]>>2]=1.0;h=d+24|0;g[(c[j>>2]|0)+((c[h>>2]|0)+1<<2)>>2]=1.0;g[(c[j>>2]|0)+((c[h>>2]<<1)+2<<2)>>2]=1.0;j=e|0;n=+g[b+340>>2];o=e+4|0;p=+g[b+344>>2];q=e+8|0;r=+g[b+348>>2];s=+g[j>>2]*n+ +g[o>>2]*p+ +g[q>>2]*r;t=e+16|0;u=e+20|0;v=e+24|0;w=n*+g[t>>2]+p*+g[u>>2]+r*+g[v>>2];x=e+32|0;y=e+36|0;z=e+40|0;A=n*+g[x>>2]+p*+g[y>>2]+r*+g[z>>2];B=d+12|0;C=c[B>>2]|0;D=c[h>>2]|0;E=D<<1;g[C>>2]=0.0;g[C+4>>2]=A;g[C+8>>2]=-0.0-w;g[C+12>>2]=0.0;g[C+(D<<2)>>2]=-0.0-A;g[C+(D+1<<2)>>2]=0.0;g[C+(D+2<<2)>>2]=s;g[C+(D+3<<2)>>2]=0.0;g[C+(E<<2)>>2]=w;g[C+((E|1)<<2)>>2]=-0.0-s;g[C+(E+2<<2)>>2]=0.0;g[C+(E+3<<2)>>2]=0.0;r=+g[b+404>>2];p=+g[b+408>>2];n=+g[b+412>>2];F=+g[f>>2]*r+ +g[f+4>>2]*p+ +g[f+8>>2]*n;G=r*+g[f+16>>2]+p*+g[f+20>>2]+n*+g[f+24>>2];H=r*+g[f+32>>2]+p*+g[f+36>>2]+n*+g[f+40>>2];E=d+20|0;C=c[E>>2]|0;D=c[h>>2]|0;I=D<<1;g[C>>2]=0.0;g[C+4>>2]=-0.0-H;g[C+8>>2]=G;g[C+12>>2]=0.0;g[C+(D<<2)>>2]=H;g[C+(D+1<<2)>>2]=0.0;g[C+(D+2<<2)>>2]=-0.0-F;g[C+(D+3<<2)>>2]=0.0;g[C+(I<<2)>>2]=-0.0-G;g[C+((I|1)<<2)>>2]=F;g[C+(I+2<<2)>>2]=0.0;g[C+(I+3<<2)>>2]=0.0;I=b+584|0;C=d|0;n=+g[((c[I>>2]&2|0)==0?d+4|0:b+592|0)>>2]*+g[C>>2];D=d+28|0;J=d+36|0;K=d+40|0;L=b+588|0;M=d+32|0;d=e+48|0;g[c[D>>2]>>2]=n*(F+ +g[f+48>>2]-s- +g[d>>2]);g[c[J>>2]>>2]=-3.4028234663852886e+38;g[c[K>>2]>>2]=3.4028234663852886e+38;if((c[I>>2]&1|0)!=0){g[c[M>>2]>>2]=+g[L>>2]}N=e+52|0;g[(c[D>>2]|0)+(c[h>>2]<<2)>>2]=n*(G+ +g[f+52>>2]-w- +g[N>>2]);g[(c[J>>2]|0)+(c[h>>2]<<2)>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(c[h>>2]<<2)>>2]=3.4028234663852886e+38;if((c[I>>2]&1|0)!=0){g[(c[M>>2]|0)+(c[h>>2]<<2)>>2]=+g[L>>2]}O=e+56|0;g[(c[D>>2]|0)+(c[h>>2]<<1<<2)>>2]=n*(H+ +g[f+56>>2]-A- +g[O>>2]);g[(c[J>>2]|0)+(c[h>>2]<<1<<2)>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(c[h>>2]<<1<<2)>>2]=3.4028234663852886e+38;if((c[I>>2]&1|0)!=0){g[(c[M>>2]|0)+(c[h>>2]<<1<<2)>>2]=+g[L>>2]}L=(c[h>>2]|0)*3|0;L2345:do{if((a[b+518|0]&1)==0){P=L}else{f=c[B>>2]|0;Q=c[E>>2]|0;A=+g[b+448>>2];do{if(+g[b+436>>2]<A){if(+g[b+440>>2]>=A){break}R=l;anx(l,e|0,b+292|0);H=+g[b+340>>2];n=+g[b+344>>2];w=+g[b+348>>2];G=+g[j>>2]*H+ +g[o>>2]*n+ +g[q>>2]*w+ +g[d>>2];s=+g[t>>2]*H+ +g[u>>2]*n+ +g[v>>2]*w+ +g[N>>2];F=+g[x>>2]*H+ +g[y>>2]*n+ +g[z>>2]*w+ +g[O>>2];S=m+48|0;T=m|0;do{T=T+16|0;}while((T|0)!=(S|0));S=m;c[S>>2]=c[R>>2];c[S+4>>2]=c[R+4>>2];c[S+8>>2]=c[R+8>>2];c[S+12>>2]=c[R+12>>2];S=m+16|0;T=l+16|0;c[S>>2]=c[T>>2];c[S+4>>2]=c[T+4>>2];c[S+8>>2]=c[T+8>>2];c[S+12>>2]=c[T+12>>2];T=m+32|0;S=l+32|0;c[T>>2]=c[S>>2];c[T+4>>2]=c[S+4>>2];c[T+8>>2]=c[S+8>>2];c[T+12>>2]=c[S+12>>2];g[m+48>>2]=G;g[m+52>>2]=s;g[m+56>>2]=F;g[m+60>>2]=0.0;w=+g[m+4>>2];n=+g[m+20>>2];H=+g[m+36>>2];p=+g[m+8>>2];r=+g[m+24>>2];U=+g[m+40>>2];S=(c[h>>2]|0)+L|0;g[f+(L<<2)>>2]=w;T=L+1|0;g[f+(T<<2)>>2]=n;V=L+2|0;g[f+(V<<2)>>2]=H;g[f+(S<<2)>>2]=p;W=S+1|0;g[f+(W<<2)>>2]=r;X=S+2|0;g[f+(X<<2)>>2]=U;g[Q+(L<<2)>>2]=-0.0-w;g[Q+(T<<2)>>2]=-0.0-n;g[Q+(V<<2)>>2]=-0.0-H;g[Q+(S<<2)>>2]=-0.0-p;g[Q+(W<<2)>>2]=-0.0-r;g[Q+(X<<2)>>2]=-0.0-U;Y=+g[C>>2]*+g[b+428>>2];X=b+452|0;W=b+456|0;V=b+460|0;g[(c[D>>2]|0)+(L<<2)>>2]=Y*(w*+g[X>>2]+n*+g[W>>2]+H*+g[V>>2]);g[(c[D>>2]|0)+(S<<2)>>2]=Y*(p*+g[X>>2]+r*+g[W>>2]+U*+g[V>>2]);g[(c[J>>2]|0)+(L<<2)>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(L<<2)>>2]=3.4028234663852886e+38;g[(c[J>>2]|0)+(S<<2)>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(S<<2)>>2]=3.4028234663852886e+38;P=(c[h>>2]|0)+S|0;break L2345}}while(0);A=+g[b+428>>2];U=A*+g[b+452>>2]*A;r=A*A*+g[b+456>>2];p=A*A*+g[b+460>>2];g[f+(L<<2)>>2]=U;S=L+1|0;g[f+(S<<2)>>2]=r;V=L+2|0;g[f+(V<<2)>>2]=p;g[Q+(L<<2)>>2]=-0.0-U;g[Q+(S<<2)>>2]=-0.0-r;g[Q+(V<<2)>>2]=-0.0-p;g[(c[D>>2]|0)+(L<<2)>>2]=+g[C>>2]*+g[b+424>>2]*+g[b+496>>2];if((c[I>>2]&4|0)!=0){g[(c[M>>2]|0)+(L<<2)>>2]=+g[b+596>>2]}g[(c[J>>2]|0)+(L<<2)>>2]=0.0;g[(c[K>>2]|0)+(L<<2)>>2]=3.4028234663852886e+38;P=(c[h>>2]|0)+L|0}}while(0);if((a[b+517|0]&1)==0){i=k;return}p=+g[b+428>>2];r=p*+g[b+468>>2]*p;U=p*p*+g[b+472>>2];A=p*p*+g[b+476>>2];L=c[B>>2]|0;B=c[E>>2]|0;g[L+(P<<2)>>2]=r;E=P+1|0;g[L+(E<<2)>>2]=U;h=P+2|0;g[L+(h<<2)>>2]=A;g[B+(P<<2)>>2]=-0.0-r;g[B+(E<<2)>>2]=-0.0-U;g[B+(h<<2)>>2]=-0.0-A;h=b+500|0;g[(c[D>>2]|0)+(P<<2)>>2]=+g[C>>2]*+g[b+424>>2]*+g[h>>2];if((c[I>>2]&4|0)!=0){g[(c[M>>2]|0)+(P<<2)>>2]=+g[b+596>>2]}if(+g[b+444>>2]<=0.0){g[(c[J>>2]|0)+(P<<2)>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(P<<2)>>2]=3.4028234663852886e+38;i=k;return}b=(c[J>>2]|0)+(P<<2)|0;if(+g[h>>2]>0.0){g[b>>2]=0.0;g[(c[K>>2]|0)+(P<<2)>>2]=3.4028234663852886e+38;i=k;return}else{g[b>>2]=-3.4028234663852886e+38;g[(c[K>>2]|0)+(P<<2)>>2]=0.0;i=k;return}}function anS(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0;d=i;i=i+176|0;e=d|0;f=d+48|0;h=d+96|0;j=d+144|0;k=d+160|0;if((a[b+519|0]&1)==0){i=d;return}g[b+32>>2]=0.0;g[b+512>>2]=0.0;g[b+508>>2]=0.0;aDD(b+568|0,0,16);l=b+24|0;if((a[b+516|0]&1)==0){m=c[l>>2]|0;n=+g[b+340>>2];o=+g[b+344>>2];p=+g[b+348>>2];q=+g[m+56>>2]+(n*+g[m+20>>2]+o*+g[m+24>>2]+p*+g[m+28>>2]);r=b+28|0;s=c[r>>2]|0;t=+g[b+404>>2];u=+g[b+408>>2];v=+g[b+412>>2];w=+g[s+56>>2]+(t*+g[s+20>>2]+u*+g[s+24>>2]+v*+g[s+28>>2]);x=+g[s+60>>2]+(t*+g[s+36>>2]+u*+g[s+40>>2]+v*+g[s+44>>2]);y=w-q;z=+g[m+52>>2]+(+g[m+4>>2]*n+ +g[m+8>>2]*o+ +g[m+12>>2]*p);A=+g[m+60>>2]+(n*+g[m+36>>2]+o*+g[m+40>>2]+p*+g[m+44>>2]);p=+g[s+52>>2]+(+g[s+4>>2]*t+ +g[s+8>>2]*u+ +g[s+12>>2]*v);v=p-z;u=x-A;t=v*v+y*y+u*u;if(t>1.1920928955078125e-7){o=1.0/+Q(+t);t=v*o;v=y*o;y=u*o;g[e>>2]=t;g[e+4>>2]=v;g[e+8>>2]=y;g[e+12>>2]=0.0;B=y;C=v;D=t}else{g[e>>2]=1.0;g[e+4>>2]=0.0;g[e+8>>2]=0.0;g[e+12>>2]=0.0;B=0.0;C=0.0;D=1.0}s=e+16|0;m=e+32|0;if(+P(+B)>.7071067690849304){t=B*B+C*C;v=1.0/+Q(+t);g[s>>2]=0.0;y=v*(-0.0-B);g[e+20>>2]=y;o=v*C;g[e+24>>2]=o;g[m>>2]=t*v;g[e+36>>2]=o*(-0.0-D);g[e+40>>2]=D*y}else{y=D*D+C*C;o=1.0/+Q(+y);v=o*(-0.0-C);g[s>>2]=v;C=o*D;g[e+20>>2]=C;g[e+24>>2]=0.0;g[m>>2]=C*(-0.0-B);g[e+36>>2]=B*v;g[e+40>>2]=y*o}m=f|0;s=f+4|0;E=f+8|0;F=f+12|0;G=f+16|0;H=f+20|0;I=f+24|0;J=f+28|0;K=f+32|0;L=f+36|0;M=f+40|0;N=f+44|0;O=h|0;R=h+4|0;S=h+8|0;T=h+12|0;U=h+16|0;V=h+20|0;W=h+24|0;X=h+28|0;Y=h+32|0;Z=h+36|0;_=h+40|0;$=h+44|0;aa=j|0;ab=j+4|0;ac=j+8|0;ad=j+12|0;ae=k|0;af=k+4|0;ag=k+8|0;ah=k+12|0;ai=0;while(1){aj=b+40+(ai*84|0)|0;if((aj|0)!=0){ak=c[l>>2]|0;g[m>>2]=+g[ak+4>>2];g[s>>2]=+g[ak+20>>2];g[E>>2]=+g[ak+36>>2];g[F>>2]=0.0;g[G>>2]=+g[ak+8>>2];g[H>>2]=+g[ak+24>>2];g[I>>2]=+g[ak+40>>2];g[J>>2]=0.0;g[K>>2]=+g[ak+12>>2];g[L>>2]=+g[ak+28>>2];g[M>>2]=+g[ak+44>>2];g[N>>2]=0.0;al=c[r>>2]|0;g[O>>2]=+g[al+4>>2];g[R>>2]=+g[al+20>>2];g[S>>2]=+g[al+36>>2];g[T>>2]=0.0;g[U>>2]=+g[al+8>>2];g[V>>2]=+g[al+24>>2];g[W>>2]=+g[al+40>>2];g[X>>2]=0.0;g[Y>>2]=+g[al+12>>2];g[Z>>2]=+g[al+28>>2];g[_>>2]=+g[al+44>>2];g[$>>2]=0.0;o=q- +g[ak+56>>2];y=A- +g[ak+60>>2];g[aa>>2]=z- +g[ak+52>>2];g[ab>>2]=o;g[ac>>2]=y;g[ad>>2]=0.0;y=w- +g[al+56>>2];o=x- +g[al+60>>2];g[ae>>2]=p- +g[al+52>>2];g[af>>2]=y;g[ag>>2]=o;g[ah>>2]=0.0;anz(aj,f,h,j,k,e+(ai<<4)|0,ak+388|0,+g[ak+336>>2],al+388|0,+g[al+336>>2])}al=ai+1|0;if((al|0)<3){ai=al}else{am=r;break}}}else{am=b+28|0}r=c[l>>2]|0;l=c[am>>2]|0;anP(b,r+4|0,l+4|0,r+256|0,l+256|0);i=d;return}function anT(b,d,e,f){b=b|0;d=d|0;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0,K=0,L=0,M=0,N=0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0,Z=0,_=0,$=0.0,aa=0,ab=0.0,ac=0,ad=0.0,ae=0,af=0,ag=0,ah=0,ai=0.0,aj=0,ak=0.0,al=0,am=0.0,an=0.0,ao=0.0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0.0,aD=0,aE=0.0,aF=0.0,aG=0.0,aH=0.0,aI=0.0,aJ=0.0,aK=0.0,aL=0.0,aM=0.0,aN=0.0,aO=0.0,aP=0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0,a0=0,a1=0.0,a2=0.0,a3=0.0,a4=0.0,a5=0.0,a6=0.0,a7=0.0,a8=0.0,a9=0.0,ba=0.0,bb=0.0,bc=0.0,bd=0.0,be=0.0,bf=0.0,bg=0,bh=0.0,bi=0.0,bj=0.0,bk=0.0,bl=0.0;h=i;i=i+464|0;j=h|0;k=h+16|0;l=h+24|0;m=h+40|0;n=h+48|0;o=h+112|0;p=h+176|0;q=h+192|0;r=h+208|0;s=h+272|0;t=h+336|0;u=h+400|0;if((a[b+519|0]&1)==0){i=h;return}v=b+24|0;w=c[v>>2]|0;x=b+340|0;y=+g[x>>2];z=b+344|0;A=+g[z>>2];B=b+348|0;C=+g[B>>2];D=+g[w+52>>2];E=D+(+g[w+4>>2]*y+ +g[w+8>>2]*A+ +g[w+12>>2]*C);F=+g[w+56>>2];G=F+(y*+g[w+20>>2]+A*+g[w+24>>2]+C*+g[w+28>>2]);H=+g[w+60>>2];I=H+(y*+g[w+36>>2]+A*+g[w+40>>2]+C*+g[w+44>>2]);J=b+28|0;K=c[J>>2]|0;L=b+404|0;C=+g[L>>2];M=b+408|0;A=+g[M>>2];N=b+412|0;y=+g[N>>2];O=+g[K+52>>2];P=O+(+g[K+4>>2]*C+ +g[K+8>>2]*A+ +g[K+12>>2]*y);R=+g[K+56>>2];S=R+(C*+g[K+20>>2]+A*+g[K+24>>2]+y*+g[K+28>>2]);T=+g[K+60>>2];U=T+(C*+g[K+36>>2]+A*+g[K+40>>2]+y*+g[K+44>>2]);L2399:do{if((a[b+516|0]&1)==0){y=E-D;A=G-F;C=I-H;V=P-O;W=S-R;X=U-T;K=d+504|0;Y=d+508|0;Z=d+512|0;_=d+520|0;$=+g[d+320>>2]+ +g[_>>2];aa=d+524|0;ab=+g[d+324>>2]+ +g[aa>>2];ac=d+528|0;ad=+g[d+328>>2]+ +g[ac>>2];ae=e+504|0;af=e+508|0;ag=e+512|0;ah=e+520|0;ai=+g[e+320>>2]+ +g[ah>>2];aj=e+524|0;ak=+g[e+324>>2]+ +g[aj>>2];al=e+528|0;am=+g[e+328>>2]+ +g[al>>2];an=+g[d+304>>2]+ +g[K>>2]+(C*ab-A*ad)-(+g[e+304>>2]+ +g[ae>>2]+(X*ak-W*am));ao=+g[d+308>>2]+ +g[Y>>2]+(y*ad-C*$)-(+g[e+308>>2]+ +g[af>>2]+(V*am-X*ai));am=+g[d+312>>2]+ +g[Z>>2]+(A*$-y*ab)-(+g[e+312>>2]+ +g[ag>>2]+(W*ai-V*ak));ak=E-P;ai=G-S;ab=I-U;ap=b+32|0;aq=d+336|0;ar=d+536|0;as=d+540|0;at=d+544|0;au=e+336|0;av=e+536|0;aw=e+540|0;ax=e+544|0;ay=0;az=w;while(1){$=1.0/+g[b+40+(ay*84|0)+80>>2];aA=b+40+(ay*84|0)|0;ad=+g[aA>>2];aB=b+40+(ay*84|0)+4|0;aC=+g[aB>>2];aD=b+40+(ay*84|0)+8|0;aE=+g[aD>>2];aF=$*((ak*ad+ai*aC+ab*aE)*-.30000001192092896/f)-$*(an*ad+ao*aC+am*aE);g[ap>>2]=+g[ap>>2]+aF;aE=+g[aD>>2];aC=+g[aB>>2];ad=A*aE-C*aC;$=+g[aA>>2];aG=C*$-y*aE;aH=y*aC-A*$;aI=W*aE-X*aC;aJ=X*$-V*aE;aK=V*aC-W*$;aL=+g[az+336>>2];if(+g[aq>>2]!=0.0){aM=aG*+g[az+292>>2]+ad*+g[az+288>>2]+aH*+g[az+296>>2];aN=aG*+g[az+276>>2]+ad*+g[az+272>>2]+aH*+g[az+280>>2];aO=aG*+g[az+260>>2]+ad*+g[az+256>>2]+aH*+g[az+264>>2];g[K>>2]=aF*$*aL+ +g[K>>2];g[Y>>2]=aF*aC*aL+ +g[Y>>2];g[Z>>2]=aF*aE*aL+ +g[Z>>2];aL=aN*aF*+g[as>>2];aN=aM*aF*+g[at>>2];g[_>>2]=aO*aF*+g[ar>>2]+ +g[_>>2];g[aa>>2]=aL+ +g[aa>>2];g[ac>>2]=aN+ +g[ac>>2]}aP=c[J>>2]|0;aN=+g[aP+336>>2];aL=-0.0-aF;if(+g[au>>2]!=0.0){aF=aJ*+g[aP+292>>2]+aI*+g[aP+288>>2]+aK*+g[aP+296>>2];aO=aJ*+g[aP+276>>2]+aI*+g[aP+272>>2]+aK*+g[aP+280>>2];aM=aJ*+g[aP+260>>2]+aI*+g[aP+256>>2]+aK*+g[aP+264>>2];aK=aN*+g[aB>>2]*aL;aI=aN*+g[aD>>2]*aL;g[ae>>2]=+g[ae>>2]+aN*+g[aA>>2]*aL;g[af>>2]=aK+ +g[af>>2];g[ag>>2]=aI+ +g[ag>>2];aI=aO*+g[aw>>2]*aL;aO=aF*+g[ax>>2]*aL;g[ah>>2]=aM*+g[av>>2]*aL+ +g[ah>>2];g[aj>>2]=aI+ +g[aj>>2];g[al>>2]=aO+ +g[al>>2]}aA=ay+1|0;if((aA|0)>=3){break L2399}ay=aA;az=c[v>>2]|0}}}while(0);do{if((a[b+544|0]&1)==0){U=+g[b+432>>2];w=d+320|0;if(U<=1.1920928955078125e-7){aQ=w;aR=d+520|0;aS=d+324|0;aT=d+524|0;aU=d+328|0;aV=d+528|0;aW=e+320|0;aX=e+520|0;aY=e+324|0;aZ=e+524|0;a_=e+328|0;a$=e+528|0;break}az=d+520|0;I=+g[az>>2];ay=d+324|0;al=d+524|0;S=+g[al>>2];aj=d+328|0;ah=d+528|0;G=+g[ah>>2];av=e+320|0;ax=e+520|0;aw=e+324|0;ag=e+524|0;af=e+328|0;ae=e+528|0;P=+g[av>>2]+ +g[ax>>2]-(+g[w>>2]+I);E=+g[aw>>2]+ +g[ag>>2]-(+g[ay>>2]+S);T=+g[af>>2]+ +g[ae>>2]-(+g[aj>>2]+G);R=P*P+E*E+T*T;if(R<=1.1920928955078125e-7){aQ=w;aR=az;aS=ay;aT=al;aU=aj;aV=ah;aW=av;aX=ax;aY=aw;aZ=ag;a_=af;a$=ae;break}O=1.0/+Q(+R);R=P*O;H=E*O;F=T*O;au=c[v>>2]|0;O=+g[au+256>>2];D=+g[au+272>>2];W=+g[au+288>>2];V=+g[au+260>>2];X=+g[au+276>>2];A=+g[au+292>>2];y=+g[au+264>>2];C=+g[au+280>>2];am=+g[au+296>>2];au=c[J>>2]|0;ao=U*(1.0/(R*(R*O+H*D+F*W)+H*(R*V+H*X+F*A)+F*(R*y+H*C+F*am)+(R*(R*+g[au+256>>2]+H*+g[au+272>>2]+F*+g[au+288>>2])+H*(R*+g[au+260>>2]+H*+g[au+276>>2]+F*+g[au+292>>2])+F*(R*+g[au+264>>2]+H*+g[au+280>>2]+F*+g[au+296>>2]))));F=P*ao;P=E*ao;E=T*ao;ao=+Q(+(E*E+(F*F+P*P)));T=1.0/ao;H=T*F;F=T*P;P=T*E;if(+g[d+336>>2]!=0.0){E=ao*0.0;ac=d+504|0;g[ac>>2]=E+ +g[ac>>2];ac=d+508|0;g[ac>>2]=E+ +g[ac>>2];ac=d+512|0;g[ac>>2]=E+ +g[ac>>2];E=(F*X+H*D+P*C)*ao*+g[d+540>>2];C=(F*A+H*W+P*am)*ao*+g[d+544>>2];g[az>>2]=(F*V+H*O+P*y)*ao*+g[d+536>>2]+I;g[al>>2]=E+S;g[ah>>2]=C+G;a0=c[J>>2]|0}else{a0=au}G=-0.0-ao;if(+g[e+336>>2]==0.0){aQ=w;aR=az;aS=ay;aT=al;aU=aj;aV=ah;aW=av;aX=ax;aY=aw;aZ=ag;a_=af;a$=ae;break}C=F*+g[a0+292>>2]+H*+g[a0+288>>2]+P*+g[a0+296>>2];S=F*+g[a0+276>>2]+H*+g[a0+272>>2]+P*+g[a0+280>>2];E=F*+g[a0+260>>2]+H*+g[a0+256>>2]+P*+g[a0+264>>2];P=ao*-0.0;au=e+504|0;g[au>>2]=P+ +g[au>>2];au=e+508|0;g[au>>2]=P+ +g[au>>2];au=e+512|0;g[au>>2]=P+ +g[au>>2];P=S*+g[e+540>>2]*G;S=C*+g[e+544>>2]*G;g[ax>>2]=E*+g[e+536>>2]*G+ +g[ax>>2];g[ag>>2]=P+ +g[ag>>2];g[ae>>2]=S+ +g[ae>>2];aQ=w;aR=az;aS=ay;aT=al;aU=aj;aV=ah;aW=av;aX=ax;aY=aw;aZ=ag;a_=af;a$=ae}else{ae=c[v>>2]|0;af=n;ag=ae+4|0;c[af>>2]=c[ag>>2];c[af+4>>2]=c[ag+4>>2];c[af+8>>2]=c[ag+8>>2];c[af+12>>2]=c[ag+12>>2];ag=n+16|0;af=ae+20|0;c[ag>>2]=c[af>>2];c[ag+4>>2]=c[af+4>>2];c[ag+8>>2]=c[af+8>>2];c[ag+12>>2]=c[af+12>>2];af=n+32|0;ag=ae+36|0;c[af>>2]=c[ag>>2];c[af+4>>2]=c[ag+4>>2];c[af+8>>2]=c[ag+8>>2];c[af+12>>2]=c[ag+12>>2];ag=n+48|0;af=ae+52|0;c[ag>>2]=c[af>>2];c[ag+4>>2]=c[af+4>>2];c[ag+8>>2]=c[af+8>>2];c[ag+12>>2]=c[af+12>>2];af=c[J>>2]|0;ag=o;ae=af+4|0;c[ag>>2]=c[ae>>2];c[ag+4>>2]=c[ae+4>>2];c[ag+8>>2]=c[ae+8>>2];c[ag+12>>2]=c[ae+12>>2];ae=o+16|0;ag=af+20|0;c[ae>>2]=c[ag>>2];c[ae+4>>2]=c[ag+4>>2];c[ae+8>>2]=c[ag+8>>2];c[ae+12>>2]=c[ag+12>>2];ag=o+32|0;ae=af+36|0;c[ag>>2]=c[ae>>2];c[ag+4>>2]=c[ae+4>>2];c[ag+8>>2]=c[ae+8>>2];c[ag+12>>2]=c[ae+12>>2];ae=o+48|0;ag=af+52|0;c[ae>>2]=c[ag>>2];c[ae+4>>2]=c[ag+4>>2];c[ae+8>>2]=c[ag+8>>2];c[ae+12>>2]=c[ag+12>>2];ag=d+320|0;ae=d+520|0;af=d+324|0;aw=d+524|0;S=+g[af>>2]+ +g[aw>>2];ax=d+328|0;av=d+528|0;P=+g[ax>>2]+ +g[av>>2];ah=p|0;g[ah>>2]=+g[ag>>2]+ +g[ae>>2];aj=p+4|0;g[aj>>2]=S;al=p+8|0;g[al>>2]=P;g[p+12>>2]=0.0;ay=e+320|0;az=e+520|0;w=e+324|0;au=e+524|0;P=+g[w>>2]+ +g[au>>2];ac=e+328|0;aa=e+528|0;S=+g[ac>>2]+ +g[aa>>2];_=q|0;g[_>>2]=+g[ay>>2]+ +g[az>>2];ar=q+4|0;g[ar>>2]=P;at=q+8|0;g[at>>2]=S;g[q+12>>2]=0.0;as=r|0;g[as>>2]=1.0;Z=r+4|0;Y=r+20|0;aDD(Z|0,0,16);g[Y>>2]=1.0;K=r+24|0;aq=r+40|0;aDD(K|0,0,16);g[aq>>2]=1.0;aDD(r+44|0,0,20);anY(n,0.0,0.0,0.0,p,f,r);ap=s|0;g[ap>>2]=1.0;aA=s+4|0;aD=s+20|0;aDD(aA|0,0,16);g[aD>>2]=1.0;aB=s+24|0;aP=s+40|0;aDD(aB|0,0,16);g[aP>>2]=1.0;aDD(s+44|0,0,20);anY(o,0.0,0.0,0.0,q,f,s);S=+g[b+548>>2];P=+g[b+552>>2];G=+g[b+556>>2];E=+g[b+560>>2];C=2.0/(S*S+P*P+G*G+E*E);ao=S*C;H=P*C;F=G*C;C=E*ao;I=E*H;y=E*F;E=S*ao;ao=S*H;O=S*F;S=P*H;H=P*F;P=G*F;F=1.0-(S+P);G=ao-y;V=O+I;am=ao+y;y=1.0-(E+P);P=H-C;ao=O-I;I=H+C;C=1.0-(E+S);S=+g[b+356>>2];E=+g[b+360>>2];H=+g[b+364>>2];O=ao*H+(E*am+S*F);W=H*I+(S*G+E*y);A=S*V+E*P+H*C;D=+g[b+372>>2];X=+g[b+376>>2];T=+g[b+380>>2];R=F*D+am*X+ao*T;U=G*D+y*X+I*T;an=V*D+P*X+C*T;ab=+g[b+388>>2];ai=+g[b+392>>2];ak=+g[b+396>>2];aO=F*ab+am*ai+ao*ak;ao=G*ab+y*ai+I*ak;I=V*ab+P*ai+C*ak;C=+g[b+292>>2];P=+g[b+308>>2];V=+g[b+324>>2];y=+g[b+296>>2];G=+g[b+312>>2];am=+g[b+328>>2];F=+g[b+300>>2];aI=+g[b+316>>2];aL=+g[b+332>>2];aM=-0.0- +g[x>>2];aF=-0.0- +g[z>>2];aK=-0.0- +g[B>>2];aN=C*aM+P*aF+V*aK;aJ=y*aM+G*aF+am*aK;aE=F*aM+aI*aF+aL*aK;aK=O*C+W*y+A*F;aF=O*P+W*G+A*aI;aM=O*V+W*am+A*aL;aC=R*C+U*y+an*F;$=R*P+U*G+an*aI;aH=R*V+U*am+an*aL;ad=aO*C+ao*y+I*F;F=aO*P+ao*G+I*aI;aI=aO*V+ao*am+I*aL;aL=S*0.0+E*0.0+H*0.0+ +g[L>>2]+(A*aE+(O*aN+W*aJ));W=D*0.0+X*0.0+T*0.0+ +g[M>>2]+(an*aE+(R*aN+U*aJ));U=ab*0.0+ai*0.0+ak*0.0+ +g[N>>2]+(I*aE+(aO*aN+ao*aJ));aJ=+g[ap>>2];ao=+g[aA>>2];aN=+g[s+8>>2];aO=+g[s+16>>2];aE=+g[aD>>2];I=+g[aB>>2];ak=+g[s+32>>2];ai=+g[s+36>>2];ab=+g[aP>>2];R=+g[s+48>>2]+(aN*U+(aJ*aL+ao*W));an=I*U+(aO*aL+aE*W)+ +g[s+52>>2];T=aL*ak+W*ai+U*ab+ +g[s+56>>2];g[t>>2]=aK*aJ+aC*ao+ad*aN;g[t+4>>2]=aF*aJ+$*ao+F*aN;g[t+8>>2]=aM*aJ+aH*ao+aI*aN;g[t+12>>2]=0.0;g[t+16>>2]=aK*aO+aC*aE+ad*I;g[t+20>>2]=aF*aO+$*aE+F*I;g[t+24>>2]=aM*aO+aH*aE+aI*I;g[t+28>>2]=0.0;g[t+32>>2]=aK*ak+aC*ai+ad*ab;g[t+36>>2]=aF*ak+$*ai+F*ab;g[t+40>>2]=aM*ak+aH*ai+aI*ab;g[t+44>>2]=0.0;g[t+48>>2]=R;g[t+52>>2]=an;g[t+56>>2]=T;g[t+60>>2]=0.0;T=-0.0-aL;aL=-0.0-W;W=-0.0-U;U=ad*W+(aK*T+aC*aL);an=F*W+(aF*T+$*aL);R=aI*W+(aM*T+aH*aL);aL=+g[as>>2];T=+g[Z>>2];W=+g[r+8>>2];ab=+g[r+16>>2];ai=+g[Y>>2];ak=+g[K>>2];I=+g[r+32>>2];aE=+g[r+36>>2];aO=+g[aq>>2];aN=U*aL+an*T+R*W+ +g[r+48>>2];ao=U*ab+an*ai+R*ak+ +g[r+52>>2];aJ=U*I+an*aE+R*aO+ +g[r+56>>2];g[u>>2]=aK*aL+aF*T+aM*W;g[u+4>>2]=aC*aL+$*T+aH*W;g[u+8>>2]=ad*aL+F*T+aI*W;g[u+12>>2]=0.0;g[u+16>>2]=aK*ab+aF*ai+aM*ak;g[u+20>>2]=aC*ab+$*ai+aH*ak;g[u+24>>2]=ad*ab+F*ai+aI*ak;g[u+28>>2]=0.0;g[u+32>>2]=aK*I+aF*aE+aM*aO;g[u+36>>2]=aC*I+$*aE+aH*aO;g[u+40>>2]=ad*I+F*aE+aI*aO;g[u+44>>2]=0.0;g[u+48>>2]=aN;g[u+52>>2]=ao;g[u+56>>2]=aJ;g[u+60>>2]=0.0;aJ=1.0/f;an6(n,t,j,k);ao=+g[k>>2];aN=aJ*+g[j>>2]*ao;aO=aJ*ao*+g[j+4>>2];aI=aJ*ao*+g[j+8>>2];an6(o,u,l,m);ao=+g[m>>2];aE=aN- +g[ah>>2];aN=aO- +g[aj>>2];aO=aI- +g[al>>2];aI=aJ*+g[l>>2]*ao- +g[_>>2];F=aJ*ao*+g[l+4>>2]- +g[ar>>2];I=aJ*ao*+g[l+8>>2]- +g[at>>2];ao=aE*aE+aN*aN+aO*aO;if(ao>1.1920928955078125e-7){aJ=1.0/+Q(+ao);ao=aE*aJ;ad=aN*aJ;aH=aO*aJ;at=c[v>>2]|0;a1=ao*(ao*+g[at+256>>2]+ad*+g[at+272>>2]+aH*+g[at+288>>2])+ad*(ao*+g[at+260>>2]+ad*+g[at+276>>2]+aH*+g[at+292>>2])+aH*(ao*+g[at+264>>2]+ad*+g[at+280>>2]+aH*+g[at+296>>2]);a2=ao;a3=ad;a4=aH}else{a1=0.0;a2=0.0;a3=0.0;a4=0.0}aH=aI*aI+F*F+I*I;if(aH>1.1920928955078125e-7){ad=1.0/+Q(+aH);aH=aI*ad;ao=F*ad;aJ=I*ad;at=c[J>>2]|0;a5=aH*(aH*+g[at+256>>2]+ao*+g[at+272>>2]+aJ*+g[at+288>>2])+ao*(aH*+g[at+260>>2]+ao*+g[at+276>>2]+aJ*+g[at+292>>2])+aJ*(aH*+g[at+264>>2]+ao*+g[at+280>>2]+aJ*+g[at+296>>2]);a6=aH;a7=ao;a8=aJ}else{a5=0.0;a6=0.0;a7=0.0;a8=0.0}aJ=a2*a1+a6*a5;ao=a3*a1+a7*a5;aH=a4*a1+a8*a5;ad=aH*aH+(aJ*aJ+ao*ao);if(ad<=1.1920928955078125e-7){aQ=ag;aR=ae;aS=af;aT=aw;aU=ax;aV=av;aW=ay;aX=az;aY=w;aZ=au;a_=ac;a$=aa;break}$=1.0/+Q(+ad);ad=aJ*$;aJ=ao*$;ao=aH*$;at=c[v>>2]|0;ar=at+256|0;_=at+272|0;al=at+288|0;aj=at+260|0;ah=at+276|0;aq=at+292|0;K=at+264|0;Y=at+280|0;Z=at+296|0;$=ad*(ad*+g[ar>>2]+aJ*+g[_>>2]+ao*+g[al>>2])+aJ*(ad*+g[aj>>2]+aJ*+g[ah>>2]+ao*+g[aq>>2])+ao*(ad*+g[K>>2]+aJ*+g[Y>>2]+ao*+g[Z>>2]);at=c[J>>2]|0;aH=ad*(ad*+g[at+256>>2]+aJ*+g[at+272>>2]+ao*+g[at+288>>2])+aJ*(ad*+g[at+260>>2]+aJ*+g[at+276>>2]+ao*+g[at+292>>2])+ao*(ad*+g[at+264>>2]+aJ*+g[at+280>>2]+ao*+g[at+296>>2]);ao=$+aH;aJ=1.0/(ao*ao);ao=aJ*(aE*$-aI*aH);aI=aJ*(aN*$-F*aH);F=aJ*(aO*$-I*aH);aH=+g[b+564>>2];if(aH<0.0){a9=ao;ba=aI;bb=F}else{if((a[b+545|0]&1)==0){bc=aH}else{bc=aH/$}as=b+568|0;$=+g[as>>2];aH=ao+$;aP=b+572|0;I=+g[aP>>2];aO=aI+I;aB=b+576|0;aJ=+g[aB>>2];aN=F+aJ;aE=+Q(+(aH*aH+aO*aO+aN*aN));if(aE>bc){ad=1.0/aE;bd=bc*aH*ad-$;be=bc*aO*ad-I;bf=bc*aN*ad-aJ}else{bd=ao;be=aI;bf=F}g[as>>2]=bd+$;g[aP>>2]=be+I;g[aB>>2]=bf+aJ;a9=bd;ba=be;bb=bf}aJ=+Q(+(bb*bb+(ba*ba+a9*a9)));I=1.0/aJ;$=a9*I;F=ba*I;aI=bb*I;if(+g[d+336>>2]!=0.0){I=F*+g[aq>>2]+$*+g[al>>2]+aI*+g[Z>>2];ao=F*+g[ah>>2]+$*+g[_>>2]+aI*+g[Y>>2];ad=F*+g[aj>>2]+$*+g[ar>>2]+aI*+g[K>>2];aN=aJ*0.0;K=d+504|0;g[K>>2]=aN+ +g[K>>2];K=d+508|0;g[K>>2]=aN+ +g[K>>2];K=d+512|0;g[K>>2]=aN+ +g[K>>2];aN=ao*aJ*+g[d+540>>2];ao=I*aJ*+g[d+544>>2];g[ae>>2]=ad*aJ*+g[d+536>>2]+ +g[ae>>2];g[aw>>2]=aN+ +g[aw>>2];g[av>>2]=ao+ +g[av>>2];bg=c[J>>2]|0}else{bg=at}ao=-0.0-aJ;if(+g[e+336>>2]==0.0){aQ=ag;aR=ae;aS=af;aT=aw;aU=ax;aV=av;aW=ay;aX=az;aY=w;aZ=au;a_=ac;a$=aa;break}aN=F*+g[bg+292>>2]+$*+g[bg+288>>2]+aI*+g[bg+296>>2];ad=F*+g[bg+276>>2]+$*+g[bg+272>>2]+aI*+g[bg+280>>2];I=F*+g[bg+260>>2]+$*+g[bg+256>>2]+aI*+g[bg+264>>2];aI=aJ*-0.0;at=e+504|0;g[at>>2]=aI+ +g[at>>2];at=e+508|0;g[at>>2]=aI+ +g[at>>2];at=e+512|0;g[at>>2]=aI+ +g[at>>2];aI=ad*+g[e+540>>2]*ao;ad=aN*+g[e+544>>2]*ao;g[az>>2]=I*+g[e+536>>2]*ao+ +g[az>>2];g[au>>2]=aI+ +g[au>>2];g[aa>>2]=ad+ +g[aa>>2];aQ=ag;aR=ae;aS=af;aT=aw;aU=ax;aV=av;aW=ay;aX=az;aY=w;aZ=au;a_=ac;a$=aa}}while(0);bb=+g[aQ>>2]+ +g[aR>>2];ba=+g[aS>>2]+ +g[aT>>2];a9=+g[aU>>2]+ +g[aV>>2];bf=+g[aW>>2]+ +g[aX>>2];be=+g[aY>>2]+ +g[aZ>>2];bd=+g[a_>>2]+ +g[a$>>2];do{if((a[b+518|0]&1)!=0){bc=+g[b+520>>2];a5=bc*+g[b+496>>2]*+g[b+424>>2]/f;a8=+g[b+452>>2];a1=+g[b+456>>2];a4=+g[b+460>>2];a7=(bf-bb)*a8+(be-ba)*a1+(bd-a9)*a4;if(a7>0.0){bh=a5+bc*a7*+g[b+428>>2]}else{bh=a5}a_=b+508|0;a5=+g[a_>>2];a7=a5+bh*+g[b+484>>2];bc=a7>0.0?a7:0.0;g[a_>>2]=bc;a7=bc-a5;a5=a8*a7;a8=a1*a7;a1=a4*a7;a7=+g[b+528>>2];a4=+g[b+532>>2];bc=+g[b+536>>2];a3=a7*a5+a8*a4+a1*bc;a6=a5-a7*a3;a7=a8-a4*a3;a4=a1-bc*a3;a3=+Q(+(a4*a4+(a6*a6+a7*a7)));bc=1.0/a3;a1=bc*a6;a6=bc*a7;a7=bc*a4;a_=c[v>>2]|0;if(+g[d+336>>2]!=0.0){a4=a6*+g[a_+292>>2]+a1*+g[a_+288>>2]+a7*+g[a_+296>>2];bc=a6*+g[a_+276>>2]+a1*+g[a_+272>>2]+a7*+g[a_+280>>2];a8=a6*+g[a_+260>>2]+a1*+g[a_+256>>2]+a7*+g[a_+264>>2];a5=a3*0.0;a_=d+504|0;g[a_>>2]=a5+ +g[a_>>2];a_=d+508|0;g[a_>>2]=a5+ +g[a_>>2];a_=d+512|0;g[a_>>2]=a5+ +g[a_>>2];a5=bc*a3*+g[d+540>>2];bc=a4*a3*+g[d+544>>2];g[aR>>2]=a8*a3*+g[d+536>>2]+ +g[aR>>2];g[aT>>2]=a5+ +g[aT>>2];g[aV>>2]=bc+ +g[aV>>2]}a_=c[J>>2]|0;bc=-0.0-a3;if(+g[e+336>>2]==0.0){break}a5=a6*+g[a_+292>>2]+a1*+g[a_+288>>2]+a7*+g[a_+296>>2];a8=a6*+g[a_+276>>2]+a1*+g[a_+272>>2]+a7*+g[a_+280>>2];a4=a6*+g[a_+260>>2]+a1*+g[a_+256>>2]+a7*+g[a_+264>>2];a7=a3*-0.0;a_=e+504|0;g[a_>>2]=a7+ +g[a_>>2];a_=e+508|0;g[a_>>2]=a7+ +g[a_>>2];a_=e+512|0;g[a_>>2]=a7+ +g[a_>>2];a7=a8*+g[e+540>>2]*bc;a8=a5*+g[e+544>>2]*bc;g[aX>>2]=a4*+g[e+536>>2]*bc+ +g[aX>>2];g[aZ>>2]=a7+ +g[aZ>>2];g[a$>>2]=a8+ +g[a$>>2]}}while(0);if((a[b+517|0]&1)==0){i=h;return}bh=+g[b+524>>2];a8=bh*+g[b+500>>2]*+g[b+424>>2]/f;a_=b+468|0;f=+g[a_>>2];aY=b+472|0;a7=+g[aY>>2];aW=b+476|0;bc=+g[aW>>2];a4=(bf-bb)*f+(be-ba)*a7+(bd-a9)*bc;if(a4>0.0){bi=a8+bh*a4*+g[b+428>>2]}else{bi=a8}aU=b+512|0;a8=+g[aU>>2];a4=a8+bi*+g[b+488>>2];bi=a4>0.0?a4:0.0;g[aU>>2]=bi;a4=bi-a8;aU=c[v>>2]|0;if(+g[d+336>>2]!=0.0){a8=a7*+g[aU+292>>2]+f*+g[aU+288>>2]+bc*+g[aU+296>>2];bi=a7*+g[aU+276>>2]+f*+g[aU+272>>2]+bc*+g[aU+280>>2];bh=a7*+g[aU+260>>2]+f*+g[aU+256>>2]+bc*+g[aU+264>>2];a9=a4*0.0;aU=d+504|0;g[aU>>2]=a9+ +g[aU>>2];aU=d+508|0;g[aU>>2]=a9+ +g[aU>>2];aU=d+512|0;g[aU>>2]=a9+ +g[aU>>2];a9=bi*a4*+g[d+540>>2];bi=a8*a4*+g[d+544>>2];g[aR>>2]=bh*a4*+g[d+536>>2]+ +g[aR>>2];g[aT>>2]=a9+ +g[aT>>2];g[aV>>2]=bi+ +g[aV>>2];bj=+g[a_>>2];bk=+g[aY>>2];bl=+g[aW>>2]}else{bj=f;bk=a7;bl=bc}aW=c[J>>2]|0;bc=-0.0-a4;if(+g[e+336>>2]==0.0){i=h;return}a7=bk*+g[aW+292>>2]+bj*+g[aW+288>>2]+bl*+g[aW+296>>2];f=bk*+g[aW+276>>2]+bj*+g[aW+272>>2]+bl*+g[aW+280>>2];bi=bk*+g[aW+260>>2]+bj*+g[aW+256>>2]+bl*+g[aW+264>>2];bl=a4*-0.0;aW=e+504|0;g[aW>>2]=bl+ +g[aW>>2];aW=e+508|0;g[aW>>2]=bl+ +g[aW>>2];aW=e+512|0;g[aW>>2]=bl+ +g[aW>>2];bl=f*+g[e+540>>2]*bc;f=a7*+g[e+544>>2]*bc;g[aX>>2]=bi*+g[e+536>>2]*bc+ +g[aX>>2];g[aZ>>2]=bl+ +g[aZ>>2];g[a$>>2]=f+ +g[a$>>2];i=h;return}function anU(a){a=a|0;return}function anV(a){a=a|0;return 204}function anW(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0;if((b|0)==1|(b|0)==2){if(e>>>0<3){g[a+592>>2]=d;f=a+584|0;c[f>>2]=c[f>>2]|2;return}else{g[a+424>>2]=d;return}}else if((b|0)==3|(b|0)==4){if(e>>>0<3){g[a+588>>2]=d;e=a+584|0;c[e>>2]=c[e>>2]|1;return}else{g[a+596>>2]=d;e=a+584|0;c[e>>2]=c[e>>2]|4;return}}else{return}}function anX(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do{if((b|0)==1|(b|0)==2){if(c>>>0<3){d=+g[a+592>>2];break}if((c-3|0)>>>0>=3){d=0.0;break}d=+g[a+424>>2]}else if((b|0)==3|(b|0)==4){if(c>>>0<3){d=+g[a+588>>2];break}if((c-3|0)>>>0>=3){d=0.0;break}d=+g[a+596>>2]}else{d=0.0}}while(0);return+d}function anY(a,b,c,d,e,f,h){a=a|0;b=+b;c=+c;d=+d;e=e|0;f=+f;h=h|0;var j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0;j=i;i=i+16|0;k=j|0;l=c*f+ +g[a+52>>2];c=d*f+ +g[a+56>>2];g[h+48>>2]=b*f+ +g[a+48>>2];g[h+52>>2]=l;g[h+56>>2]=c;g[h+60>>2]=0.0;c=+g[e>>2];l=+g[e+4>>2];b=+g[e+8>>2];d=+Q(+(c*c+l*l+b*b));if(d*f>.7853981852531433){m=.7853981852531433/f}else{m=d}if(m<.0010000000474974513){n=f*.5-m*f*f*f*.02083333395421505*m}else{n=+T(+(m*.5*f))/m}d=n*c;c=n*l;l=n*b;b=+S(+(m*f*.5));ec(a|0,k);f=+g[k>>2];m=+g[k+12>>2];n=+g[k+8>>2];o=+g[k+4>>2];p=b*f+d*m+c*n-l*o;q=l*f+(c*m+b*o)-d*n;r=l*m+b*n+d*o-c*f;s=b*m-d*f-c*o-l*n;n=1.0/+Q(+(s*s+(r*r+(p*p+q*q))));l=p*n;p=n*q;q=n*r;r=n*s;s=2.0/(r*r+(q*q+(l*l+p*p)));n=l*s;o=s*p;c=s*q;s=r*n;f=r*o;d=r*c;r=l*n;n=l*o;m=l*c;l=p*o;o=p*c;p=q*c;g[h>>2]=1.0-(p+l);g[h+4>>2]=n-d;g[h+8>>2]=m+f;g[h+12>>2]=0.0;g[h+16>>2]=d+n;g[h+20>>2]=1.0-(r+p);g[h+24>>2]=o-s;g[h+28>>2]=0.0;g[h+32>>2]=m-f;g[h+36>>2]=s+o;g[h+40>>2]=1.0-(r+l);g[h+44>>2]=0.0;i=j;return}function anZ(a,b,c,d){a=a|0;b=b|0;c=+c;d=+d;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0;e=+S(+c);f=+T(+c);c=+g[b+436>>2];if(+P(+e)>1.1920928955078125e-7){h=f*f;i=e*e;j=h/i;k=+g[b+440>>2];l=+Q(+((j+1.0)/(1.0/(k*k)+j/(c*c))));m=i;n=h}else{l=c;m=e*e;n=f*f}c=+Q(+(m+0.0+n));n=l*.5;l=+T(+n)/c;c=l*0.0;m=e*l;e=l*(-0.0-f);f=+S(+n);n=m*0.0;l=e*0.0;h=f*d+n-l;i=f*0.0;j=c*0.0;k=e*d+i-j;o=i+j-m*d;j=-0.0-c;c=d*j-n-l;l=-0.0-m;m=-0.0-e;g[a>>2]=k*m+(f*h+c*j)-o*l;g[a+4>>2]=o*j+(f*k+c*l)-h*m;g[a+8>>2]=h*l+(f*o+c*m)-k*j;g[a+12>>2]=0.0;return}function an_(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,R=0.0,U=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0;d=a+548|0;e=d;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+560|0;h=+g[f>>2];e=a+552|0;i=+g[e>>2];j=i*0.0;b=a+556|0;k=+g[b>>2];l=k*0.0;m=h+j-l;n=h*0.0;o=+g[d>>2];q=o*0.0;r=k+n-q;s=n+q-i;q=-0.0-o;n=q-j-l;l=-0.0-i;j=-0.0-k;t=r*j+(h*m+n*q)-s*l;u=s*q+(h*r+n*l)-m*j;v=m*l+(h*s+n*j)-r*q;q=u*0.0;r=v*0.0;j=r+(q+t);do{if(j<-.9999998807907104){if(+P(0.0)>.7071067690849304){w=0.0;x=p;y=p;z=0.0;break}w=-0.0;x=1.0;y=0.0;z=0.0}else{n=t*0.0;s=+Q(+((j+1.0)*2.0));l=1.0/s;w=(r-q)*l;x=(n-v)*l;y=(u-n)*l;z=s*.5}}while(0);u=1.0/+Q(+(z*z+(y*y+(x*x+w*w))));v=w*u;w=x*u;x=y*u;y=z*u;u=-0.0-v;z=-0.0-w;q=-0.0-x;r=y*o+h*u+k*z-i*q;j=o*q+(h*z+y*i)-k*u;t=h*q+y*k+i*u-o*z;s=y*h-o*u-i*z-k*q;q=1.0/+Q(+(s*s+(t*t+(r*r+j*j))));k=r*q;r=q*j;j=q*t;t=q*s;s=+g[a+436>>2];do{if(s<.05000000074505806){A=v;B=w;C=x;D=y}else{q=+g[a+440>>2];if(q<.05000000074505806){A=v;B=w;C=x;D=y;break}z=y<-1.0?-1.0:y;i=+V(+(z>1.0?1.0:z))*2.0;do{if(i>1.1920928955078125e-7){z=1.0/+Q(+(x*x+(v*v+w*w)));u=v*z;o=w*z;h=x*z;if(+P(+o)<=1.1920928955078125e-7){E=u;F=o;G=h;H=s;break}z=h*h/(o*o);E=u;F=o;G=h;H=+Q(+((z+1.0)/(1.0/(q*q)+z/(s*s))))}else{E=0.0;F=0.0;G=0.0;H=0.0}}while(0);if(+P(+i)<=1.1920928955078125e-7){A=v;B=w;C=x;D=y;break}do{if(i>H){I=H}else{q=-0.0-H;if(i>=q){I=i;break}I=q}}while(0);i=+Q(+(G*G+(F*F+E*E)));q=I*.5;z=+T(+q)/i;A=E*z;B=F*z;C=G*z;D=+S(+q)}}while(0);G=+g[a+444>>2];do{if(G<.05000000074505806){J=k;K=r;L=j;M=t}else{F=t<-1.0?-1.0:t;E=+V(+(F>1.0?1.0:F))*2.0;if(E>3.1415927410125732){F=t>1.0?-1.0:-0.0-t;N=-0.0-k;O=-0.0-r;R=-0.0-j;U=+V(+(F>1.0?1.0:F))*2.0}else{N=k;O=r;R=j;U=E}if(U>1.1920928955078125e-7){E=1.0/+Q(+(R*R+(O*O+N*N)));W=N*E;X=O*E;Y=R*E}else{W=N;X=O;Y=R}if(+P(+U)<=1.1920928955078125e-7){J=k;K=r;L=j;M=t;break}do{if(U>G){Z=G}else{E=-0.0-G;if(U>=E){Z=U;break}Z=E}}while(0);E=+Q(+(Y*Y+(X*X+W*W)));F=Z*.5;I=+T(+F)/E;J=W*I;K=X*I;L=Y*I;M=+S(+F)}}while(0);g[a+548>>2]=B*L+(A*M+D*J)-C*K;g[e>>2]=C*J+(B*M+D*K)-A*L;g[b>>2]=C*M+D*L+A*K-B*J;g[f>>2]=D*M-A*J-B*K-C*L;return}function an$(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=a+292|0;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+308|0;e=b+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+324|0;f=b+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+340|0;e=b+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+356|0;f=d;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+372|0;e=d+16|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=a+388|0;f=d+32|0;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+404|0;e=d+48|0;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];ct[c[(c[a>>2]|0)+8>>2]&2047](a);return}function an0(a){a=a|0;if((a|0)==0){return}aDB(a);return}function an1(a){a=a|0;return 3}function an2(a,b){a=a|0;b=b|0;return}function an3(a,b){a=a|0;b=b|0;c[a+80>>2]=b;return}function an4(a){a=a|0;return c[a+80>>2]|0}function an5(a,b,c){a=a|0;b=b|0;c=c|0;aq3(a|0,b,c)|0;g[b+44>>2]=+g[a+292>>2];g[b+48>>2]=+g[a+296>>2];g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];g[b+76>>2]=+g[a+324>>2];g[b+80>>2]=+g[a+328>>2];g[b+84>>2]=+g[a+332>>2];g[b+88>>2]=+g[a+336>>2];g[b+92>>2]=+g[a+340>>2];g[b+96>>2]=+g[a+344>>2];g[b+100>>2]=+g[a+348>>2];g[b+104>>2]=+g[a+352>>2];g[b+108>>2]=+g[a+356>>2];g[b+112>>2]=+g[a+360>>2];g[b+116>>2]=+g[a+364>>2];g[b+120>>2]=+g[a+368>>2];g[b+124>>2]=+g[a+372>>2];g[b+128>>2]=+g[a+376>>2];g[b+132>>2]=+g[a+380>>2];g[b+136>>2]=+g[a+384>>2];g[b+140>>2]=+g[a+388>>2];g[b+144>>2]=+g[a+392>>2];g[b+148>>2]=+g[a+396>>2];g[b+152>>2]=+g[a+400>>2];g[b+156>>2]=+g[a+404>>2];g[b+160>>2]=+g[a+408>>2];g[b+164>>2]=+g[a+412>>2];g[b+168>>2]=+g[a+416>>2];g[b+172>>2]=+g[a+436>>2];g[b+176>>2]=+g[a+440>>2];g[b+180>>2]=+g[a+444>>2];g[b+184>>2]=+g[a+420>>2];g[b+188>>2]=+g[a+424>>2];g[b+192>>2]=+g[a+428>>2];g[b+196>>2]=+g[a+432>>2];return 18136}function an6(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0;e=i;i=i+64|0;f=e|0;h=e+48|0;j=+g[a+20>>2];k=+g[a+40>>2];l=+g[a+24>>2];m=+g[a+36>>2];n=j*k-l*m;o=+g[a+32>>2];p=+g[a+16>>2];q=l*o-k*p;r=m*p-j*o;s=+g[a>>2];t=+g[a+4>>2];u=+g[a+8>>2];v=1.0/(n*s+t*q+r*u);w=n*v;n=v*(m*u-k*t);x=v*(l*t-j*u);y=q*v;q=v*(k*s-o*u);k=v*(p*u-l*s);l=r*v;r=v*(o*t-m*s);m=v*(j*s-p*t);t=+g[b>>2];p=+g[b+4>>2];s=+g[b+8>>2];j=+g[b+16>>2];v=+g[b+20>>2];o=+g[b+24>>2];u=+g[b+32>>2];z=+g[b+36>>2];A=+g[b+40>>2];g[f>>2]=w*t+y*p+l*s;g[f+4>>2]=t*n+p*q+r*s;g[f+8>>2]=t*x+p*k+m*s;g[f+12>>2]=0.0;g[f+16>>2]=w*j+y*v+l*o;g[f+20>>2]=n*j+q*v+r*o;g[f+24>>2]=x*j+k*v+m*o;g[f+28>>2]=0.0;g[f+32>>2]=w*u+y*z+l*A;g[f+36>>2]=n*u+q*z+r*A;g[f+40>>2]=x*u+k*z+m*A;g[f+44>>2]=0.0;ec(f,h);f=h|0;A=+g[f>>2];b=h+4|0;m=+g[b>>2];a=h+8|0;z=+g[a>>2];B=h+12|0;k=+g[B>>2];u=1.0/+Q(+(A*A+m*m+z*z+k*k));x=A*u;g[f>>2]=x;A=m*u;g[b>>2]=A;m=z*u;g[a>>2]=m;z=k*u;g[B>>2]=z;u=z<-1.0?-1.0:z;g[d>>2]=+V(+(u>1.0?1.0:u))*2.0;d=c|0;g[d>>2]=x;B=c+4|0;g[B>>2]=A;a=c+8|0;g[a>>2]=m;b=c+12|0;g[b>>2]=0.0;u=x*x+A*A+m*m;if(u<1.4210854715202004e-14){g[d>>2]=1.0;g[B>>2]=0.0;g[a>>2]=0.0;g[b>>2]=0.0;i=e;return}else{z=1.0/+Q(+u);g[d>>2]=x*z;g[B>>2]=z*A;g[a>>2]=z*m;i=e;return}}function an7(a){a=a|0;aof(a|0);if((a|0)==0){return}aDB(a);return}function an8(a){a=a|0;aof(a|0);return}function an9(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0,P=0;d=i;i=i+32|0;e=d|0;f=d+16|0;h=a+8|0;j=c[h>>2]|0;if((j|0)>0){k=a+16|0;l=f|0;m=f+4|0;n=f+8|0;o=e|0;p=e+4|0;q=e+8|0;r=e+12|0;s=f+12|0;t=a+76|0;u=a+24|0;v=0;w=j;while(1){j=c[(c[k>>2]|0)+(v<<2)>>2]|0;if((c[j+232>>2]&2|0)==0|(j|0)==0){x=w}else{y=c[j+192>>2]|0;dI[c[(c[y>>2]|0)+8>>2]&1023](y,j+4|0,e,f);z=+g[l>>2];A=+g[m>>2];B=+g[n>>2];C=+g[o>>2];D=+g[p>>2];E=+g[q>>2];F=+g[j+304>>2]*b;G=+g[j+308>>2]*b;H=+g[j+312>>2]*b;if(F>0.0){I=C;J=z+F}else{I=C+F;J=z}if(G>0.0){K=D;L=A+G}else{K=D+G;L=A}if(H>0.0){M=E;N=B+H}else{M=E+H;N=B}g[o>>2]=I;g[p>>2]=K;g[q>>2]=M;g[r>>2]=0.0;g[s>>2]=0.0;g[l>>2]=J+0.0;g[m>>2]=L+0.0;g[n>>2]=N+0.0;y=c[t>>2]|0;co[c[(c[y>>2]|0)+16>>2]&255](y,c[j+188>>2]|0,e,f,c[u>>2]|0);x=c[h>>2]|0}j=v+1|0;if((j|0)<(x|0)){v=j;w=x}else{O=t;P=u;break}}}else{O=a+76|0;P=a+24|0}u=c[O>>2]|0;cv[c[(c[u>>2]|0)+32>>2]&2047](u,c[P>>2]|0);P=a+28|0;g[P>>2]=b;g[a+40>>2]=1.0;c[a+32>>2]=0;u=a+36|0;c[u>>2]=2;O=a+24|0;t=c[O>>2]|0;if((t|0)==0){c[u>>2]=1;i=d;return}x=c[(c[t>>2]|0)+32>>2]|0;w=c[a+76>>2]|0;a=cA[c[(c[w>>2]|0)+36>>2]&4095](w)|0;dI[x&1023](t,a,P,c[O>>2]|0);c[u>>2]=1;i=d;return}function aoa(a,b){a=a|0;b=+b;var d=0,e=0,f=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0,q=0,r=0;d=i;i=i+16|0;e=d|0;f=a|0;aDi();j=a|0;k=c[a+92>>2]|0;if((k|0)!=0){cq[k&1023](j,b)}k=a|0;l=a;ct[c[(c[l>>2]|0)+8>>2]&2047](k);m=a;cq[c[(c[m>>2]|0)+136>>2]&1023](f,b);g[a+28>>2]=b;c[a+32>>2]=0;c[a+48>>2]=cA[c[(c[a>>2]|0)+16>>2]&4095](k)|0;ct[c[(c[l>>2]|0)+40>>2]&2047](k);ct[c[(c[a>>2]|0)+148>>2]&2047](f);g[a+112>>2]=b;cv[c[(c[a>>2]|0)+152>>2]&2047](f,a+100|0);cq[c[(c[a>>2]|0)+176>>2]&1023](a,b);n=+g[a+40>>2];if(n<0.0){o=n;bK(17384,(l=i,i=i+8|0,h[l>>3]=o,l)|0)|0;i=l}cq[c[(c[m>>2]|0)+140>>2]&1023](f,n*b);aDo(16856);m=a+248|0;if((c[m>>2]|0)>0){l=a+256|0;p=0;do{q=c[(c[l>>2]|0)+(p<<2)>>2]|0;dF[c[(c[q>>2]|0)+8>>2]&255](q,k,b);p=p+1|0;}while((p|0)<(c[m>>2]|0))}m=c[9152]|0;p=m+16|0;k=(c[p>>2]|0)-1|0;c[p>>2]=k;do{if((k|0)==0){if((c[m+4>>2]|0)==0){r=m}else{b3(e|0,0)|0;l=c[10742]|0;q=m+8|0;g[q>>2]=+(((c[e+4>>2]|0)-(c[l+4>>2]|0)+(((c[e>>2]|0)-(c[l>>2]|0)|0)*1e6|0)-(c[m+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[q>>2];if((c[p>>2]|0)!=0){break}r=c[9152]|0}c[9152]=c[r+20>>2]}}while(0);aom(f,b);f=c[a+88>>2]|0;if((f|0)==0){i=d;return}cq[f&1023](j,b);i=d;return}function aob(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0,l=0;aty(b|0,d,e,h);c[b+88>>2]=0;c[b+92>>2]=0;c[b+96>>2]=0;g[b+100>>2]=.6000000238418579;g[b+104>>2]=1.0;g[b+108>>2]=.30000001192092896;g[b+116>>2]=0.0;g[b+124>>2]=20.0;c[b+120>>2]=10;g[b+132>>2]=.20000000298023224;g[b+136>>2]=.10000000149011612;g[b+140>>2]=0.0;g[b+128>>2]=1.0;c[b+144>>2]=0;g[b+148>>2]=-.019999999552965164;g[b+152>>2]=0.0;g[b+156>>2]=.8500000238418579;c[b+160>>2]=260;c[b+164>>2]=2;c[b+168>>2]=128;c[b>>2]=21464;h=b+172|0;c[h>>2]=f;a[b+196|0]=1;c[b+192>>2]=0;c[b+184>>2]=0;c[b+188>>2]=0;a[b+216|0]=1;c[b+212>>2]=0;c[b+204>>2]=0;c[b+208>>2]=0;g[b+220>>2]=0.0;g[b+224>>2]=-10.0;g[b+228>>2]=0.0;g[b+232>>2]=0.0;g[b+236>>2]=0.0;a[b+242|0]=0;a[b+260|0]=1;c[b+256>>2]=0;c[b+248>>2]=0;c[b+252>>2]=0;c[b+264>>2]=0;if((f|0)==0){c[9806]=(c[9806]|0)+1;f=aDx(147)|0;do{if((f|0)==0){i=0}else{e=-(f+4|0)&15;d=f+(e+4)|0;c[f+e>>2]=f;if((d|0)==0){i=0;break}c[d>>2]=19632;a[f+(e+24)|0]=1;c[f+(e+20)>>2]=0;c[f+(e+12)>>2]=0;c[f+(e|16)>>2]=0;a[f+(e+44)|0]=1;c[f+(e+40)>>2]=0;c[f+(e|32)>>2]=0;c[f+(e+36)>>2]=0;a[f+(e|64)|0]=1;c[f+(e+60)>>2]=0;c[f+(e+52)>>2]=0;c[f+(e+56)>>2]=0;a[f+(e+84)|0]=1;c[f+(e|80)>>2]=0;c[f+(e+72)>>2]=0;c[f+(e+76)>>2]=0;a[f+(e+104)|0]=1;c[f+(e+100)>>2]=0;c[f+(e+92)>>2]=0;c[f+(e|96)>>2]=0;a[f+(e+124)|0]=1;c[f+(e+120)>>2]=0;c[f+(e|112)>>2]=0;c[f+(e+116)>>2]=0;c[f+(e|128)>>2]=0;i=d}}while(0);c[h>>2]=i;a[b+241|0]=1}else{a[b+241|0]=0}c[9806]=(c[9806]|0)+1;i=aDx(87)|0;if((i|0)==0){j=0;k=b+176|0;c[k>>2]=j;l=b+240|0;a[l]=1;return}h=-(i+4|0)&15;f=i+(h+4)|0;c[i+h>>2]=i;if((f|0)==0){j=0;k=b+176|0;c[k>>2]=j;l=b+240|0;a[l]=1;return}c[f>>2]=20520;a[i+(h+24)|0]=1;c[i+(h+20)>>2]=0;c[i+(h+12)>>2]=0;c[i+(h|16)>>2]=0;a[i+(h+44)|0]=1;c[i+(h+40)>>2]=0;c[i+(h|32)>>2]=0;c[i+(h+36)>>2]=0;a[i+(h|64)|0]=1;c[i+(h+60)>>2]=0;c[i+(h+52)>>2]=0;c[i+(h+56)>>2]=0;a[i+(h+68)|0]=1;j=f;k=b+176|0;c[k>>2]=j;l=b+240|0;a[l]=1;return}function aoc(a){a=a|0;aof(a);if((a|0)==0){return}aDB(a);return}function aod(a,b){a=a|0;b=+b;var d=0,e=0,f=0,g=0,h=0;d=a+8|0;e=c[d>>2]|0;if((e|0)<=0){return}f=a+16|0;a=0;g=e;while(1){e=c[(c[f>>2]|0)+(a<<2)>>2]|0;do{if((c[e+232>>2]&2|0)==0){h=g}else{if((e|0)==0){h=g;break}if((c[e+216>>2]|0)==2){h=g;break}if((c[e+204>>2]&2|0)==0){h=g;break}ap0(e,b);h=c[d>>2]|0}}while(0);e=a+1|0;if((e|0)<(h|0)){a=e;g=h}else{break}}return}function aoe(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0,l=0;d=i;i=i+16|0;e=d|0;aDo(16856);f=a+248|0;if((c[f>>2]|0)>0){h=a+256|0;j=a|0;a=0;do{k=c[(c[h>>2]|0)+(a<<2)>>2]|0;dF[c[(c[k>>2]|0)+8>>2]&255](k,j,b);a=a+1|0;}while((a|0)<(c[f>>2]|0))}f=c[9152]|0;a=f+16|0;j=(c[a>>2]|0)-1|0;c[a>>2]=j;if((j|0)!=0){i=d;return}do{if((c[f+4>>2]|0)==0){l=f}else{b3(e|0,0)|0;j=c[10742]|0;h=f+8|0;g[h>>2]=+(((c[e+4>>2]|0)-(c[j+4>>2]|0)+(((c[e>>2]|0)-(c[j>>2]|0)|0)*1e6|0)-(c[f+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[h>>2];if((c[a>>2]|0)==0){l=c[9152]|0;break}else{i=d;return}}}while(0);c[9152]=c[l+20>>2];i=d;return}function aof(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;c[b>>2]=21464;do{if((a[b+240|0]&1)!=0){d=b+176|0;e=c[d>>2]|0;ct[c[c[e>>2]>>2]&2047](e);e=c[d>>2]|0;if((e|0)==0){break}c[9804]=(c[9804]|0)+1;aDB(c[e-68+64>>2]|0)}}while(0);do{if((a[b+241|0]&1)!=0){e=b+172|0;d=c[e>>2]|0;ct[c[c[d>>2]>>2]&2047](d);d=c[e>>2]|0;if((d|0)==0){break}c[9804]=(c[9804]|0)+1;aDB(c[d-4>>2]|0)}}while(0);d=b+248|0;e=b+256|0;f=c[e>>2]|0;g=b+260|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+252>>2]=0;d=b+204|0;e=b+212|0;g=c[e>>2]|0;f=b+216|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-4>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+208>>2]=0;d=b+184|0;e=b+192|0;f=c[e>>2]|0;g=b+196|0;if((f|0)==0){a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+188|0;c[h>>2]=0;i=b|0;atA(i);return}if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0;a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+188|0;c[h>>2]=0;i=b|0;atA(i);return}function aog(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0;b=i;i=i+16|0;d=b|0;aDo(17208);e=a|0;atR(e);f=a;L2701:do{if((cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0)!=0){h=cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0;if(((cA[c[(c[h>>2]|0)+48>>2]&4095](h)|0)&6144|0)==0){break}h=a;j=cA[c[(c[a>>2]|0)+100>>2]&4095](a)|0;while(1){k=j-1|0;if((j|0)<=0){break L2701}aoh(a,dj[c[(c[h>>2]|0)+104>>2]&511](a,k)|0);j=k}}}while(0);do{if((cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0)!=0){j=cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0;if(((cA[c[(c[j>>2]|0)+48>>2]&4095](j)|0)&3|0)==0){break}if((cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0)==0){break}j=cA[c[(c[f>>2]|0)+16>>2]&4095](e)|0;if((cA[c[(c[j>>2]|0)+48>>2]&4095](j)|0)==0){break}j=a+248|0;if((c[j>>2]|0)<=0){break}h=a+256|0;k=a+80|0;l=0;do{m=c[(c[h>>2]|0)+(l<<2)>>2]|0;cv[c[(c[m>>2]|0)+12>>2]&2047](m,c[k>>2]|0);l=l+1|0;}while((l|0)<(c[j>>2]|0))}}while(0);a=c[9152]|0;e=a+16|0;f=(c[e>>2]|0)-1|0;c[e>>2]=f;if((f|0)!=0){i=b;return}do{if((c[a+4>>2]|0)==0){n=a}else{b3(d|0,0)|0;f=c[10742]|0;j=a+8|0;g[j>>2]=+(((c[d+4>>2]|0)-(c[f+4>>2]|0)+(((c[d>>2]|0)-(c[f>>2]|0)|0)*1e6|0)-(c[a+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[j>>2];if((c[e>>2]|0)==0){n=c[9152]|0;break}else{i=b;return}}}while(0);c[9152]=c[n+20>>2];i=b;return}function aoh(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0,ak=0,al=0,am=0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0.0,av=0.0,aw=0.0,ax=0.0;e=i;i=i+1392|0;f=e|0;h=e+48|0;j=e+96|0;k=e+144|0;l=e+192|0;m=e+240|0;n=e+288|0;o=e+336|0;p=e+384|0;q=e+448|0;r=e+512|0;s=e+576|0;t=e+592|0;u=e+608|0;v=e+624|0;w=e+688|0;x=e+752|0;y=e+768|0;z=e+784|0;A=e+800|0;B=e+816|0;C=e+880|0;D=e+944|0;E=e+960|0;F=e+976|0;G=e+992|0;H=e+1008|0;I=e+1072|0;J=e+1088|0;K=e+1104|0;L=e+1120|0;M=e+1136|0;N=e+1152|0;O=e+1168|0;P=e+1184|0;Q=e+1200|0;R=e+1216|0;U=e+1232|0;V=e+1296|0;W=e+1312|0;X=e+1328|0;Y=e+1344|0;Z=e+1360|0;_=e+1376|0;$=b|0;aa=b;b=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;ab=(cA[c[(c[b>>2]|0)+48>>2]&4095](b)|0)>>>11;b=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;ac=(cA[c[(c[b>>2]|0)+48>>2]&4095](b)|0)>>>12;ad=+g[d+36>>2];if(ad<=0.0){i=e;return}switch(c[d+4>>2]|0){case 3:{g[p>>2]=1.0;aDD(p+4|0,0,16);g[p+20>>2]=1.0;aDD(p+24|0,0,16);g[p+40>>2]=1.0;aDD(p+44|0,0,20);ae=+g[d+292>>2];af=+g[d+296>>2];ag=+g[d+300>>2];b=c[d+24>>2]|0;ah=+g[b+56>>2]+(ae*+g[b+20>>2]+af*+g[b+24>>2]+ag*+g[b+28>>2]);ai=+g[b+60>>2]+(ae*+g[b+36>>2]+af*+g[b+40>>2]+ag*+g[b+44>>2]);aj=p+48|0;g[aj>>2]=+g[b+52>>2]+(ae*+g[b+4>>2]+af*+g[b+8>>2]+ag*+g[b+12>>2]);b=p+52|0;g[b>>2]=ah;ak=p+56|0;g[ak>>2]=ai;al=p+60|0;g[al>>2]=0.0;am=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[am>>2]|0)+56>>2]&255](am,p,ad);ai=+g[d+308>>2];ah=+g[d+312>>2];ag=+g[d+316>>2];am=c[d+28>>2]|0;af=+g[am+56>>2]+(ai*+g[am+20>>2]+ah*+g[am+24>>2]+ag*+g[am+28>>2]);ae=+g[am+60>>2]+(ai*+g[am+36>>2]+ah*+g[am+40>>2]+ag*+g[am+44>>2]);g[aj>>2]=+g[am+52>>2]+(ai*+g[am+4>>2]+ah*+g[am+8>>2]+ag*+g[am+12>>2]);g[b>>2]=af;g[ak>>2]=ae;g[al>>2]=0.0;if((ab&1|0)==0){i=e;return}al=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[al>>2]|0)+56>>2]&255](al,p,ad);i=e;return};case 4:{p=c[d+24>>2]|0;al=p+4|0;ak=d+544|0;b=o;anx(o,al|0,ak);ae=+g[ak+48>>2];af=+g[ak+52>>2];ag=+g[ak+56>>2];ah=+g[al>>2]*ae+ +g[p+8>>2]*af+ +g[p+12>>2]*ag+ +g[p+52>>2];ai=+g[p+20>>2]*ae+ +g[p+24>>2]*af+ +g[p+28>>2]*ag+ +g[p+56>>2];an=+g[p+36>>2]*ae+ +g[p+40>>2]*af+ +g[p+44>>2]*ag+ +g[p+60>>2];p=q+48|0;al=q|0;do{al=al+16|0;}while((al|0)!=(p|0));p=q;c[p>>2]=c[b>>2];c[p+4>>2]=c[b+4>>2];c[p+8>>2]=c[b+8>>2];c[p+12>>2]=c[b+12>>2];b=q+16|0;al=o+16|0;c[b>>2]=c[al>>2];c[b+4>>2]=c[al+4>>2];c[b+8>>2]=c[al+8>>2];c[b+12>>2]=c[al+12>>2];al=q+32|0;ak=o+32|0;c[al>>2]=c[ak>>2];c[al+4>>2]=c[ak+4>>2];c[al+8>>2]=c[ak+8>>2];c[al+12>>2]=c[ak+12>>2];g[q+48>>2]=ah;g[q+52>>2]=ai;g[q+56>>2]=an;g[q+60>>2]=0.0;if((ab&1|0)==0){ak=c[d+28>>2]|0;o=ak+4|0;am=d+608|0;aj=m;anx(m,o|0,am);an=+g[am+48>>2];ai=+g[am+52>>2];ah=+g[am+56>>2];ag=+g[o>>2]*an+ +g[ak+8>>2]*ai+ +g[ak+12>>2]*ah+ +g[ak+52>>2];af=+g[ak+20>>2]*an+ +g[ak+24>>2]*ai+ +g[ak+28>>2]*ah+ +g[ak+56>>2];ae=+g[ak+36>>2]*an+ +g[ak+40>>2]*ai+ +g[ak+44>>2]*ah+ +g[ak+60>>2];ak=r+48|0;o=r|0;do{o=o+16|0;}while((o|0)!=(ak|0));ak=r;c[ak>>2]=c[aj>>2];c[ak+4>>2]=c[aj+4>>2];c[ak+8>>2]=c[aj+8>>2];c[ak+12>>2]=c[aj+12>>2];aj=r+16|0;o=m+16|0;c[aj>>2]=c[o>>2];c[aj+4>>2]=c[o+4>>2];c[aj+8>>2]=c[o+8>>2];c[aj+12>>2]=c[o+12>>2];o=r+32|0;am=m+32|0;c[o>>2]=c[am>>2];c[o+4>>2]=c[am+4>>2];c[o+8>>2]=c[am+8>>2];c[o+12>>2]=c[am+12>>2];g[r+48>>2]=ag;g[r+52>>2]=af;g[r+56>>2]=ae;g[r+60>>2]=0.0;c[p>>2]=c[ak>>2];c[p+4>>2]=c[ak+4>>2];c[p+8>>2]=c[ak+8>>2];c[p+12>>2]=c[ak+12>>2];c[b>>2]=c[aj>>2];c[b+4>>2]=c[aj+4>>2];c[b+8>>2]=c[aj+8>>2];c[b+12>>2]=c[aj+12>>2];c[al>>2]=c[o>>2];c[al+4>>2]=c[o+4>>2];c[al+8>>2]=c[o+8>>2];c[al+12>>2]=c[o+12>>2];o=q+48|0;aj=r+48|0;c[o>>2]=c[aj>>2];c[o+4>>2]=c[aj+4>>2];c[o+8>>2]=c[aj+8>>2];c[o+12>>2]=c[aj+12>>2]}else{aj=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[aj>>2]|0)+56>>2]&255](aj,q,ad);aj=c[d+28>>2]|0;o=aj+4|0;ak=d+608|0;am=n;anx(n,o|0,ak);ae=+g[ak+48>>2];af=+g[ak+52>>2];ag=+g[ak+56>>2];ah=+g[o>>2]*ae+ +g[aj+8>>2]*af+ +g[aj+12>>2]*ag+ +g[aj+52>>2];ai=+g[aj+20>>2]*ae+ +g[aj+24>>2]*af+ +g[aj+28>>2]*ag+ +g[aj+56>>2];an=+g[aj+36>>2]*ae+ +g[aj+40>>2]*af+ +g[aj+44>>2]*ag+ +g[aj+60>>2];aj=r+48|0;o=r|0;do{o=o+16|0;}while((o|0)!=(aj|0));aj=r;c[aj>>2]=c[am>>2];c[aj+4>>2]=c[am+4>>2];c[aj+8>>2]=c[am+8>>2];c[aj+12>>2]=c[am+12>>2];am=r+16|0;o=n+16|0;c[am>>2]=c[o>>2];c[am+4>>2]=c[o+4>>2];c[am+8>>2]=c[o+8>>2];c[am+12>>2]=c[o+12>>2];o=r+32|0;ak=n+32|0;c[o>>2]=c[ak>>2];c[o+4>>2]=c[ak+4>>2];c[o+8>>2]=c[ak+8>>2];c[o+12>>2]=c[ak+12>>2];g[r+48>>2]=ah;g[r+52>>2]=ai;g[r+56>>2]=an;g[r+60>>2]=0.0;c[p>>2]=c[aj>>2];c[p+4>>2]=c[aj+4>>2];c[p+8>>2]=c[aj+8>>2];c[p+12>>2]=c[aj+12>>2];c[b>>2]=c[am>>2];c[b+4>>2]=c[am+4>>2];c[b+8>>2]=c[am+8>>2];c[b+12>>2]=c[am+12>>2];c[al>>2]=c[o>>2];c[al+4>>2]=c[o+4>>2];c[al+8>>2]=c[o+8>>2];c[al+12>>2]=c[o+12>>2];o=q+48|0;al=r+48|0;c[o>>2]=c[al>>2];c[o+4>>2]=c[al+4>>2];c[o+8>>2]=c[al+8>>2];c[o+12>>2]=c[al+12>>2];al=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[al>>2]|0)+56>>2]&255](al,q,ad)}al=d+680|0;o=d+684|0;an=+ck(+(+g[al>>2]- +g[o>>2]),6.2831854820251465);do{if(an<-3.1415927410125732){ao=an+6.2831854820251465}else{if(an<=3.1415927410125732){ao=an;break}ao=an-6.2831854820251465}}while(0);an=+ck(+(+g[al>>2]+ +g[o>>2]),6.2831854820251465);do{if(an<-3.1415927410125732){ap=an+6.2831854820251465}else{if(an<=3.1415927410125732){ap=an;break}ap=an-6.2831854820251465}}while(0);if(ao==ap){i=e;return}o=ao>ap;if((ac&1|0)==0){i=e;return}g[s>>2]=+g[q+8>>2];g[s+4>>2]=+g[q+24>>2];g[s+8>>2]=+g[q+40>>2];g[s+12>>2]=0.0;g[t>>2]=+g[q>>2];g[t+4>>2]=+g[q+16>>2];g[t+8>>2]=+g[q+32>>2];g[t+12>>2]=0.0;al=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;r=c[(c[al>>2]|0)+60>>2]|0;aDD(u|0,0,16);dt[r&63](al,q+48|0,s,t,ad,ad,o?0.0:ao,o?6.2831854820251465:ap,u,o^1,10.0);i=e;return};case 7:{o=d+816|0;u=U;t=o;c[u>>2]=c[t>>2];c[u+4>>2]=c[t+4>>2];c[u+8>>2]=c[t+8>>2];c[u+12>>2]=c[t+12>>2];t=U+16|0;s=o+16|0;c[t>>2]=c[s>>2];c[t+4>>2]=c[s+4>>2];c[t+8>>2]=c[s+8>>2];c[t+12>>2]=c[s+12>>2];s=U+32|0;q=o+32|0;c[s>>2]=c[q>>2];c[s+4>>2]=c[q+4>>2];c[s+8>>2]=c[q+8>>2];c[s+12>>2]=c[q+12>>2];q=U+48|0;al=o+48|0;c[q>>2]=c[al>>2];c[q+4>>2]=c[al+4>>2];c[q+8>>2]=c[al+8>>2];c[q+12>>2]=c[al+12>>2];if((ab&1|0)==0){al=d+880|0;c[u>>2]=c[al>>2];c[u+4>>2]=c[al+4>>2];c[u+8>>2]=c[al+8>>2];c[u+12>>2]=c[al+12>>2];al=d+896|0;c[t>>2]=c[al>>2];c[t+4>>2]=c[al+4>>2];c[t+8>>2]=c[al+8>>2];c[t+12>>2]=c[al+12>>2];al=d+912|0;c[s>>2]=c[al>>2];c[s+4>>2]=c[al+4>>2];c[s+8>>2]=c[al+8>>2];c[s+12>>2]=c[al+12>>2];al=d+928|0;c[q>>2]=c[al>>2];c[q+4>>2]=c[al+4>>2];c[q+8>>2]=c[al+8>>2];c[q+12>>2]=c[al+12>>2]}else{al=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[al>>2]|0)+56>>2]&255](al,U,ad);al=d+880|0;c[u>>2]=c[al>>2];c[u+4>>2]=c[al+4>>2];c[u+8>>2]=c[al+8>>2];c[u+12>>2]=c[al+12>>2];al=d+896|0;c[t>>2]=c[al>>2];c[t+4>>2]=c[al+4>>2];c[t+8>>2]=c[al+8>>2];c[t+12>>2]=c[al+12>>2];al=d+912|0;c[s>>2]=c[al>>2];c[s+4>>2]=c[al+4>>2];c[s+8>>2]=c[al+8>>2];c[s+12>>2]=c[al+12>>2];al=d+928|0;c[q>>2]=c[al>>2];c[q+4>>2]=c[al+4>>2];c[q+8>>2]=c[al+8>>2];c[q+12>>2]=c[al+12>>2];al=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[al>>2]|0)+56>>2]&255](al,U,ad)}if((ac&1|0)==0){i=e;return}U=(a[d+172|0]&1)!=0?o:d+880|0;ap=+g[U>>2];ao=+g[U+4>>2];an=+g[U+16>>2];ai=+g[U+20>>2];ah=+g[U+32>>2];ag=+g[U+36>>2];af=+g[U+48>>2];ae=+g[U+52>>2];aq=+g[U+56>>2];ar=+g[d+176>>2];as=ao*0.0;at=+g[U+8>>2]*0.0;au=ai*0.0;av=+g[U+24>>2]*0.0;aw=ag*0.0;ax=+g[U+40>>2]*0.0;g[V>>2]=af+(at+(as+ap*ar));g[V+4>>2]=ae+(av+(au+an*ar));g[V+8>>2]=aq+(ax+(aw+ah*ar));g[V+12>>2]=0.0;ar=+g[d+180>>2];g[W>>2]=af+(at+(as+ap*ar));g[W+4>>2]=ae+(av+(au+an*ar));g[W+8>>2]=aq+(ax+(aw+ah*ar));g[W+12>>2]=0.0;U=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;o=c[(c[U>>2]|0)+8>>2]|0;aDD(X|0,0,16);dI[o&1023](U,V,W,X);g[Y>>2]=ap;g[Y+4>>2]=an;g[Y+8>>2]=ah;g[Y+12>>2]=0.0;g[Z>>2]=ao;g[Z+4>>2]=ai;g[Z+8>>2]=ag;g[Z+12>>2]=0.0;ag=+g[d+184>>2];ai=+g[d+188>>2];X=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;W=c[(c[X>>2]|0)+60>>2]|0;aDD(_|0,0,16);dt[W&63](X,d+928|0,Y,Z,ad,ad,ag,ai,_,1,10.0);i=e;return};case 9:case 6:{_=d+1056|0;Z=H;Y=_;c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];X=H+16|0;W=_+16|0;c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];V=H+32|0;U=_+32|0;c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];o=H+48|0;al=_+48|0;c[o>>2]=c[al>>2];c[o+4>>2]=c[al+4>>2];c[o+8>>2]=c[al+8>>2];c[o+12>>2]=c[al+12>>2];if((ab&1|0)==0){_=d+1120|0;c[Z>>2]=c[_>>2];c[Z+4>>2]=c[_+4>>2];c[Z+8>>2]=c[_+8>>2];c[Z+12>>2]=c[_+12>>2];_=d+1136|0;c[X>>2]=c[_>>2];c[X+4>>2]=c[_+4>>2];c[X+8>>2]=c[_+8>>2];c[X+12>>2]=c[_+12>>2];_=d+1152|0;c[V>>2]=c[_>>2];c[V+4>>2]=c[_+4>>2];c[V+8>>2]=c[_+8>>2];c[V+12>>2]=c[_+12>>2];_=d+1168|0;c[o>>2]=c[_>>2];c[o+4>>2]=c[_+4>>2];c[o+8>>2]=c[_+8>>2];c[o+12>>2]=c[_+12>>2]}else{_=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[_>>2]|0)+56>>2]&255](_,H,ad);_=d+1120|0;c[Z>>2]=c[_>>2];c[Z+4>>2]=c[_+4>>2];c[Z+8>>2]=c[_+8>>2];c[Z+12>>2]=c[_+12>>2];_=d+1136|0;c[X>>2]=c[_>>2];c[X+4>>2]=c[_+4>>2];c[X+8>>2]=c[_+8>>2];c[X+12>>2]=c[_+12>>2];_=d+1152|0;c[V>>2]=c[_>>2];c[V+4>>2]=c[_+4>>2];c[V+8>>2]=c[_+8>>2];c[V+12>>2]=c[_+12>>2];_=d+1168|0;c[o>>2]=c[_>>2];c[o+4>>2]=c[_+4>>2];c[o+8>>2]=c[_+8>>2];c[o+12>>2]=c[_+12>>2];_=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[_>>2]|0)+56>>2]&255](_,H,ad)}if((ac&1|0)==0){i=e;return}c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];c[o>>2]=c[al>>2];c[o+4>>2]=c[al+4>>2];c[o+8>>2]=c[al+8>>2];c[o+12>>2]=c[al+12>>2];_=d+1168|0;q=_;g[I>>2]=+g[H+8>>2];g[I+4>>2]=+g[H+24>>2];g[I+8>>2]=+g[H+40>>2];g[I+12>>2]=0.0;s=H|0;t=H+16|0;u=H+32|0;r=J|0;g[r>>2]=+g[s>>2];am=J+4|0;g[am>>2]=+g[t>>2];b=J+8|0;g[b>>2]=+g[u>>2];aj=J+12|0;g[aj>>2]=0.0;p=d+924|0;ai=+g[p>>2];ag=+g[p+4>>2];p=d+988|0;ao=+g[p>>2];ah=+g[p+4>>2];p=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;ak=c[(c[p>>2]|0)+64>>2]|0;aDD(K|0,0,16);cs[ak&63](p,q,I,J,ad*.8999999761581421,ai,ag,ao,ah,K,10.0);ah=+g[H+4>>2];ao=+g[H+20>>2];ag=+g[H+36>>2];g[r>>2]=ah;g[am>>2]=ao;g[b>>2]=ag;g[aj>>2]=0.0;ai=+g[d+1188>>2];an=+g[d+1192>>2];ap=+S(+ai);ar=+T(+ai);ai=+S(+an);aw=+T(+an);g[L>>2]=ap*ai*ah+ap*aw*ao-ar*ag;g[L+4>>2]=ah*(-0.0-aw)+ai*ao;g[L+8>>2]=ar*ai*ah+ar*aw*ao+ap*ag;aj=d+1120|0;c[Z>>2]=c[aj>>2];c[Z+4>>2]=c[aj+4>>2];c[Z+8>>2]=c[aj+8>>2];c[Z+12>>2]=c[aj+12>>2];aj=d+1136|0;c[X>>2]=c[aj>>2];c[X+4>>2]=c[aj+4>>2];c[X+8>>2]=c[aj+8>>2];c[X+12>>2]=c[aj+12>>2];aj=d+1152|0;c[V>>2]=c[aj>>2];c[V+4>>2]=c[aj+4>>2];c[V+8>>2]=c[aj+8>>2];c[V+12>>2]=c[aj+12>>2];aj=_;c[o>>2]=c[aj>>2];c[o+4>>2]=c[aj+4>>2];c[o+8>>2]=c[aj+8>>2];c[o+12>>2]=c[aj+12>>2];ag=-0.0- +g[t>>2];ap=-0.0- +g[u>>2];g[M>>2]=-0.0- +g[s>>2];g[M+4>>2]=ag;g[M+8>>2]=ap;g[M+12>>2]=0.0;s=d+860|0;ap=+g[s>>2];ag=+g[s+4>>2];do{if(ap>ag){s=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;u=c[(c[s>>2]|0)+60>>2]|0;aDD(N|0,0,16);dt[u&63](s,q,M,L,ad,ad,-3.1415927410125732,3.1415927410125732,N,0,10.0)}else{if(ap>=ag){break}s=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;u=c[(c[s>>2]|0)+60>>2]|0;aDD(O|0,0,16);dt[u&63](s,q,M,L,ad,ad,ap,ag,O,1,10.0)}}while(0);c[Z>>2]=c[Y>>2];c[Z+4>>2]=c[Y+4>>2];c[Z+8>>2]=c[Y+8>>2];c[Z+12>>2]=c[Y+12>>2];c[X>>2]=c[W>>2];c[X+4>>2]=c[W+4>>2];c[X+8>>2]=c[W+8>>2];c[X+12>>2]=c[W+12>>2];c[V>>2]=c[U>>2];c[V+4>>2]=c[U+4>>2];c[V+8>>2]=c[U+8>>2];c[V+12>>2]=c[U+12>>2];c[o>>2]=c[al>>2];c[o+4>>2]=c[al+4>>2];c[o+8>>2]=c[al+8>>2];c[o+12>>2]=c[al+12>>2];al=d+672|0;o=P;U=al;c[o>>2]=c[U>>2];c[o+4>>2]=c[U+4>>2];c[o+8>>2]=c[U+8>>2];c[o+12>>2]=c[U+12>>2];U=Q;o=al+16|0;c[U>>2]=c[o>>2];c[U+4>>2]=c[o+4>>2];c[U+8>>2]=c[o+8>>2];c[U+12>>2]=c[o+12>>2];o=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;U=c[(c[o>>2]|0)+72>>2]|0;aDD(R|0,0,16);co[U&255](o,P,Q,H,R);i=e;return};case 5:{R=d;H=d+24|0;Q=c[H>>2]|0;P=Q+4|0;o=d+292|0;U=l;al=o;anx(l,P|0,al);V=o+48|0;ag=+g[V>>2];W=o+52|0;ap=+g[W>>2];X=o+56|0;ao=+g[X>>2];aw=+g[P>>2]*ag+ +g[Q+8>>2]*ap+ +g[Q+12>>2]*ao+ +g[Q+52>>2];ar=+g[Q+20>>2]*ag+ +g[Q+24>>2]*ap+ +g[Q+28>>2]*ao+ +g[Q+56>>2];ah=+g[Q+36>>2]*ag+ +g[Q+40>>2]*ap+ +g[Q+44>>2]*ao+ +g[Q+60>>2];Q=v+48|0;P=v|0;do{P=P+16|0;}while((P|0)!=(Q|0));Q=v;c[Q>>2]=c[U>>2];c[Q+4>>2]=c[U+4>>2];c[Q+8>>2]=c[U+8>>2];c[Q+12>>2]=c[U+12>>2];U=v+16|0;P=l+16|0;c[U>>2]=c[P>>2];c[U+4>>2]=c[P+4>>2];c[U+8>>2]=c[P+8>>2];c[U+12>>2]=c[P+12>>2];P=v+32|0;o=l+32|0;c[P>>2]=c[o>>2];c[P+4>>2]=c[o+4>>2];c[P+8>>2]=c[o+8>>2];c[P+12>>2]=c[o+12>>2];o=v+48|0;g[o>>2]=aw;l=v+52|0;g[l>>2]=ar;Y=v+56|0;g[Y>>2]=ah;g[v+60>>2]=0.0;if((ab&1|0)==0){ab=c[d+28>>2]|0;Z=ab+4|0;O=d+356|0;L=j;anx(j,Z|0,O);ah=+g[O+48>>2];ar=+g[O+52>>2];aw=+g[O+56>>2];ao=+g[Z>>2]*ah+ +g[ab+8>>2]*ar+ +g[ab+12>>2]*aw+ +g[ab+52>>2];ap=+g[ab+20>>2]*ah+ +g[ab+24>>2]*ar+ +g[ab+28>>2]*aw+ +g[ab+56>>2];ag=+g[ab+36>>2]*ah+ +g[ab+40>>2]*ar+ +g[ab+44>>2]*aw+ +g[ab+60>>2];ab=w+48|0;Z=w|0;do{Z=Z+16|0;}while((Z|0)!=(ab|0));ab=w;c[ab>>2]=c[L>>2];c[ab+4>>2]=c[L+4>>2];c[ab+8>>2]=c[L+8>>2];c[ab+12>>2]=c[L+12>>2];L=w+16|0;Z=j+16|0;c[L>>2]=c[Z>>2];c[L+4>>2]=c[Z+4>>2];c[L+8>>2]=c[Z+8>>2];c[L+12>>2]=c[Z+12>>2];Z=w+32|0;O=j+32|0;c[Z>>2]=c[O>>2];c[Z+4>>2]=c[O+4>>2];c[Z+8>>2]=c[O+8>>2];c[Z+12>>2]=c[O+12>>2];g[w+48>>2]=ao;g[w+52>>2]=ap;g[w+56>>2]=ag;g[w+60>>2]=0.0;c[Q>>2]=c[ab>>2];c[Q+4>>2]=c[ab+4>>2];c[Q+8>>2]=c[ab+8>>2];c[Q+12>>2]=c[ab+12>>2];c[U>>2]=c[L>>2];c[U+4>>2]=c[L+4>>2];c[U+8>>2]=c[L+8>>2];c[U+12>>2]=c[L+12>>2];c[P>>2]=c[Z>>2];c[P+4>>2]=c[Z+4>>2];c[P+8>>2]=c[Z+8>>2];c[P+12>>2]=c[Z+12>>2];Z=v+48|0;L=w+48|0;c[Z>>2]=c[L>>2];c[Z+4>>2]=c[L+4>>2];c[Z+8>>2]=c[L+8>>2];c[Z+12>>2]=c[L+12>>2]}else{L=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[L>>2]|0)+56>>2]&255](L,v,ad);L=c[d+28>>2]|0;Z=L+4|0;ab=d+356|0;O=k;anx(k,Z|0,ab);ag=+g[ab+48>>2];ap=+g[ab+52>>2];ao=+g[ab+56>>2];aw=+g[Z>>2]*ag+ +g[L+8>>2]*ap+ +g[L+12>>2]*ao+ +g[L+52>>2];ar=+g[L+20>>2]*ag+ +g[L+24>>2]*ap+ +g[L+28>>2]*ao+ +g[L+56>>2];ah=+g[L+36>>2]*ag+ +g[L+40>>2]*ap+ +g[L+44>>2]*ao+ +g[L+60>>2];L=w+48|0;Z=w|0;do{Z=Z+16|0;}while((Z|0)!=(L|0));L=w;c[L>>2]=c[O>>2];c[L+4>>2]=c[O+4>>2];c[L+8>>2]=c[O+8>>2];c[L+12>>2]=c[O+12>>2];O=w+16|0;Z=k+16|0;c[O>>2]=c[Z>>2];c[O+4>>2]=c[Z+4>>2];c[O+8>>2]=c[Z+8>>2];c[O+12>>2]=c[Z+12>>2];Z=w+32|0;ab=k+32|0;c[Z>>2]=c[ab>>2];c[Z+4>>2]=c[ab+4>>2];c[Z+8>>2]=c[ab+8>>2];c[Z+12>>2]=c[ab+12>>2];g[w+48>>2]=aw;g[w+52>>2]=ar;g[w+56>>2]=ah;g[w+60>>2]=0.0;c[Q>>2]=c[L>>2];c[Q+4>>2]=c[L+4>>2];c[Q+8>>2]=c[L+8>>2];c[Q+12>>2]=c[L+12>>2];c[U>>2]=c[O>>2];c[U+4>>2]=c[O+4>>2];c[U+8>>2]=c[O+8>>2];c[U+12>>2]=c[O+12>>2];c[P>>2]=c[Z>>2];c[P+4>>2]=c[Z+4>>2];c[P+8>>2]=c[Z+8>>2];c[P+12>>2]=c[Z+12>>2];Z=v+48|0;O=w+48|0;c[Z>>2]=c[O>>2];c[Z+4>>2]=c[O+4>>2];c[Z+8>>2]=c[O+8>>2];c[Z+12>>2]=c[O+12>>2];O=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;dF[c[(c[O>>2]|0)+56>>2]&255](O,v,ad)}if((ac&1|0)==0){i=e;return}anZ(x,R,6.0868353843688965,ad);ac=v|0;O=x|0;ah=+g[O>>2];Z=v+4|0;w=x+4|0;ar=+g[w>>2];L=v+8|0;ab=x+8|0;aw=+g[ab>>2];k=v+16|0;j=v+20|0;M=v+24|0;ao=+g[l>>2]+(ah*+g[k>>2]+ar*+g[j>>2]+aw*+g[M>>2]);q=v+32|0;N=v+36|0;s=v+40|0;ap=+g[Y>>2]+(ah*+g[q>>2]+ar*+g[N>>2]+aw*+g[s>>2]);u=x;g[O>>2]=+g[o>>2]+(+g[ac>>2]*ah+ +g[Z>>2]*ar+ +g[L>>2]*aw);g[w>>2]=ao;g[ab>>2]=ap;g[x+12>>2]=0.0;ab=y|0;w=y+4|0;O=y+8|0;t=y;aj=y+12|0;_=v+48|0;v=z;b=A;am=0;do{anZ(y,R,+(am|0)*6.283185005187988*.03125,ad);ap=+g[ab>>2];ao=+g[w>>2];aw=+g[O>>2];ar=+g[l>>2]+(ap*+g[k>>2]+ao*+g[j>>2]+aw*+g[M>>2]);ah=+g[Y>>2]+(ap*+g[q>>2]+ao*+g[N>>2]+aw*+g[s>>2]);g[ab>>2]=+g[o>>2]+(+g[ac>>2]*ap+ +g[Z>>2]*ao+ +g[L>>2]*aw);g[w>>2]=ar;g[O>>2]=ah;g[aj>>2]=0.0;r=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;K=c[(c[r>>2]|0)+8>>2]|0;aDD(v|0,0,16);dI[K&1023](r,x,y,z);if((am&3|0)==0){r=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;K=c[(c[r>>2]|0)+8>>2]|0;aDD(b|0,0,16);dI[K&1023](r,_,y,A)}c[u>>2]=c[t>>2];c[u+4>>2]=c[t+4>>2];c[u+8>>2]=c[t+8>>2];c[u+12>>2]=c[t+12>>2];am=am+1|0;}while((am|0)<32);ah=+g[d+444>>2];ar=+g[d+504>>2];am=c[d+28>>2]|0;if(+g[am+336>>2]>0.0){t=am+4|0;u=d+356|0;d=h;anx(h,t|0,u);aw=+g[u+48>>2];ao=+g[u+52>>2];ap=+g[u+56>>2];ag=+g[t>>2]*aw+ +g[am+8>>2]*ao+ +g[am+12>>2]*ap+ +g[am+52>>2];ai=+g[am+20>>2]*aw+ +g[am+24>>2]*ao+ +g[am+28>>2]*ap+ +g[am+56>>2];an=+g[am+36>>2]*aw+ +g[am+40>>2]*ao+ +g[am+44>>2]*ap+ +g[am+60>>2];am=B+48|0;t=B|0;do{t=t+16|0;}while((t|0)!=(am|0));am=B;c[am>>2]=c[d>>2];c[am+4>>2]=c[d+4>>2];c[am+8>>2]=c[d+8>>2];c[am+12>>2]=c[d+12>>2];d=B+16|0;t=h+16|0;c[d>>2]=c[t>>2];c[d+4>>2]=c[t+4>>2];c[d+8>>2]=c[t+8>>2];c[d+12>>2]=c[t+12>>2];t=B+32|0;u=h+32|0;c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];c[t+12>>2]=c[u+12>>2];g[B+48>>2]=ag;g[B+52>>2]=ai;g[B+56>>2]=an;g[B+60>>2]=0.0;c[Q>>2]=c[am>>2];c[Q+4>>2]=c[am+4>>2];c[Q+8>>2]=c[am+8>>2];c[Q+12>>2]=c[am+12>>2];c[U>>2]=c[d>>2];c[U+4>>2]=c[d+4>>2];c[U+8>>2]=c[d+8>>2];c[U+12>>2]=c[d+12>>2];c[P>>2]=c[t>>2];c[P+4>>2]=c[t+4>>2];c[P+8>>2]=c[t+8>>2];c[P+12>>2]=c[t+12>>2];t=_;d=B+48|0;c[t>>2]=c[d>>2];c[t+4>>2]=c[d+4>>2];c[t+8>>2]=c[d+8>>2];c[t+12>>2]=c[d+12>>2]}else{d=c[H>>2]|0;H=d+4|0;t=f;anx(f,H|0,al);an=+g[V>>2];ai=+g[W>>2];ag=+g[X>>2];ap=+g[H>>2]*an+ +g[d+8>>2]*ai+ +g[d+12>>2]*ag+ +g[d+52>>2];ao=+g[d+20>>2]*an+ +g[d+24>>2]*ai+ +g[d+28>>2]*ag+ +g[d+56>>2];aw=+g[d+36>>2]*an+ +g[d+40>>2]*ai+ +g[d+44>>2]*ag+ +g[d+60>>2];d=C+48|0;H=C|0;do{H=H+16|0;}while((H|0)!=(d|0));d=C;c[d>>2]=c[t>>2];c[d+4>>2]=c[t+4>>2];c[d+8>>2]=c[t+8>>2];c[d+12>>2]=c[t+12>>2];t=C+16|0;H=f+16|0;c[t>>2]=c[H>>2];c[t+4>>2]=c[H+4>>2];c[t+8>>2]=c[H+8>>2];c[t+12>>2]=c[H+12>>2];H=C+32|0;X=f+32|0;c[H>>2]=c[X>>2];c[H+4>>2]=c[X+4>>2];c[H+8>>2]=c[X+8>>2];c[H+12>>2]=c[X+12>>2];g[C+48>>2]=ap;g[C+52>>2]=ao;g[C+56>>2]=aw;g[C+60>>2]=0.0;c[Q>>2]=c[d>>2];c[Q+4>>2]=c[d+4>>2];c[Q+8>>2]=c[d+8>>2];c[Q+12>>2]=c[d+12>>2];c[U>>2]=c[t>>2];c[U+4>>2]=c[t+4>>2];c[U+8>>2]=c[t+8>>2];c[U+12>>2]=c[t+12>>2];c[P>>2]=c[H>>2];c[P+4>>2]=c[H+4>>2];c[P+8>>2]=c[H+8>>2];c[P+12>>2]=c[H+12>>2];H=_;P=C+48|0;c[H>>2]=c[P>>2];c[H+4>>2]=c[P+4>>2];c[H+8>>2]=c[P+8>>2];c[H+12>>2]=c[P+12>>2]}P=D;H=_;c[P>>2]=c[H>>2];c[P+4>>2]=c[H+4>>2];c[P+8>>2]=c[H+8>>2];c[P+12>>2]=c[H+12>>2];g[E>>2]=+g[ac>>2];g[E+4>>2]=+g[k>>2];g[E+8>>2]=+g[q>>2];g[E+12>>2]=0.0;g[F>>2]=+g[Z>>2];g[F+4>>2]=+g[j>>2];g[F+8>>2]=+g[N>>2];g[F+12>>2]=0.0;N=cA[c[(c[aa>>2]|0)+16>>2]&4095]($)|0;$=c[(c[N>>2]|0)+60>>2]|0;aDD(G|0,0,16);dt[$&63](N,D,E,F,ad,ad,-0.0-ar-ah,ah-ar,G,1,10.0);i=e;return};default:{i=e;return}}}function aoi(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0;b=a+204|0;d=c[b>>2]|0;if((d|0)<=0){return}e=a+212|0;a=0;f=d;while(1){d=c[(c[e>>2]|0)+(a<<2)>>2]|0;h=c[d+216>>2]|0;do{if((h|0)==5|(h|0)==2){i=f}else{if((c[d+204>>2]&3|0)!=0){i=f;break}j=+g[d+360>>2]*+g[d+344>>2];k=+g[d+364>>2]*+g[d+348>>2];l=d+404|0;g[l>>2]=+g[d+356>>2]*+g[d+340>>2]+ +g[l>>2];l=d+408|0;g[l>>2]=j+ +g[l>>2];l=d+412|0;g[l>>2]=k+ +g[l>>2];i=c[b>>2]|0}}while(0);d=a+1|0;if((d|0)<(i|0)){a=d;f=i}else{break}}return}function aoj(a){a=a|0;var b=0,d=0;b=a+204|0;if((c[b>>2]|0)<=0){return}d=a+212|0;a=0;do{aDD((c[(c[d>>2]|0)+(a<<2)>>2]|0)+404|0,0,32);a=a+1|0;}while((a|0)<(c[b>>2]|0));return}function aok(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;d=i;i=i+144|0;e=d|0;f=d+16|0;h=d+80|0;aDo(17984);do{if((a[b+242|0]&1)==0){j=b+204|0;k=c[j>>2]|0;if((k|0)<=0){break}l=b+212|0;m=b+236|0;n=0;o=k;while(1){k=c[(c[l>>2]|0)+(n<<2)>>2]|0;p=c[k+216>>2]|0;do{if((p|0)==5|(p|0)==2){q=o}else{r=k+472|0;if((c[r>>2]|0)==0){q=o;break}if((c[k+204>>2]&3|0)!=0){q=o;break}anY(k+68|0,+g[k+132>>2],+g[k+136>>2],+g[k+140>>2],k+148|0,+g[m>>2]*+g[k+240>>2],h);s=c[r>>2]|0;cv[c[(c[s>>2]|0)+12>>2]&2047](s,h);q=c[j>>2]|0}}while(0);k=n+1|0;if((k|0)<(q|0)){n=k;o=q}else{break}}}else{o=b+8|0;n=c[o>>2]|0;if((n|0)<=0){break}j=b+16|0;m=b+236|0;l=0;k=n;while(1){n=c[(c[j>>2]|0)+(l<<2)>>2]|0;do{if((c[n+232>>2]&2|0)==0|(n|0)==0){t=k}else{p=n+472|0;if((c[p>>2]|0)==0){t=k;break}if((c[n+204>>2]&3|0)!=0){t=k;break}anY(n+68|0,+g[n+132>>2],+g[n+136>>2],+g[n+140>>2],n+148|0,+g[m>>2]*+g[n+240>>2],f);s=c[p>>2]|0;cv[c[(c[s>>2]|0)+12>>2]&2047](s,f);t=c[o>>2]|0}}while(0);n=l+1|0;if((n|0)<(t|0)){l=n;k=t}else{break}}}}while(0);t=c[9152]|0;f=t+16|0;b=(c[f>>2]|0)-1|0;c[f>>2]=b;if((b|0)!=0){i=d;return}do{if((c[t+4>>2]|0)==0){u=t}else{b3(e|0,0)|0;b=c[10742]|0;q=t+8|0;g[q>>2]=+(((c[e+4>>2]|0)-(c[b+4>>2]|0)+(((c[e>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[t+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[q>>2];if((c[f>>2]|0)==0){u=c[9152]|0;break}else{i=d;return}}}while(0);c[9152]=c[u+20>>2];i=d;return}function aol(b,d,e,f){b=b|0;d=+d;e=e|0;f=+f;var h=0,j=0,k=0,l=0,m=0,n=0.0,o=0,p=0.0,q=0,r=0;h=i;i=i+16|0;j=h|0;aDi();aDo(17464);k=b+236|0;do{if((e|0)==0){g[k>>2]=d;l=+P(+d)>=1.1920928955078125e-7|0;m=l;n=d;o=l}else{p=+g[k>>2]+d;g[k>>2]=p;if(p<f){m=e;n=f;o=0;break}l=~~(p/f);g[k>>2]=p- +(l|0)*f;m=e;n=f;o=l}}while(0);e=b|0;k=b;if((cA[c[(c[k>>2]|0)+16>>2]&4095](e)|0)!=0){l=cA[c[(c[k>>2]|0)+16>>2]&4095](e)|0;a[39240]=(cA[c[(c[l>>2]|0)+48>>2]&4095](l)|0)>>>4&1}do{if((o|0)==0){ct[c[(c[b>>2]|0)+76>>2]&2047](b)}else{l=(o|0)>(m|0)?m:o;e=b;cq[c[(c[e>>2]|0)+160>>2]&1023](b,n*+(l|0));k=b;ct[c[(c[k>>2]|0)+164>>2]&2047](b);if((l|0)>0){q=0}else{break}do{cq[c[(c[e>>2]|0)+156>>2]&1023](b,n);ct[c[(c[k>>2]|0)+76>>2]&2047](b);q=q+1|0;}while((q|0)<(l|0))}}while(0);ct[c[(c[b>>2]|0)+116>>2]&2047](b);c[10736]=(c[10736]|0)+1;b=c[9152]|0;q=b+16|0;m=(c[q>>2]|0)-1|0;c[q>>2]=m;if((m|0)!=0){i=h;return o|0}do{if((c[b+4>>2]|0)==0){r=b}else{b3(j|0,0)|0;m=c[10742]|0;l=b+8|0;g[l>>2]=+(((c[j+4>>2]|0)-(c[m+4>>2]|0)+(((c[j>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[b+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[l>>2];if((c[q>>2]|0)==0){r=c[9152]|0;break}else{i=h;return o|0}}}while(0);c[9152]=c[r+20>>2];i=h;return o|0}function aom(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0,z=0,A=0,B=0;e=i;i=i+8|0;f=e|0;aDo(16648);h=b+204|0;if((c[h>>2]|0)>0){j=b+212|0;b=(a[39240]&1)==0;k=0;do{l=c[(c[j>>2]|0)+(k<<2)>>2]|0;L2926:do{if((l|0)!=0){m=l+216|0;n=c[m>>2]|0;L2928:do{if((n|0)==2|(n|0)==4){o=n;p=2712}else{q=+g[l+304>>2];r=+g[l+308>>2];s=+g[l+312>>2];t=+g[l+464>>2];do{if(q*q+r*r+s*s<t*t){u=+g[l+320>>2];v=+g[l+324>>2];w=+g[l+328>>2];x=+g[l+468>>2];if(u*u+v*v+w*w>=x*x){break}y=l+220|0;g[y>>2]=+g[y>>2]+d;o=n;p=2712;break L2928}}while(0);g[l+220>>2]=0.0;if((n-4|0)>>>0<2){o=n;p=2712;break}c[m>>2]=0;z=0}}while(0);if((p|0)==2712){p=0;if((o|0)==4){break}else{z=o}}do{if(b){if((z-2|0)>>>0>=2){if(+g[l+220>>2]<=2.0){break}}if((c[l+204>>2]&3|0)!=0){if((z-4|0)>>>0<2){break L2926}c[m>>2]=2;break L2926}if((z|0)==1){c[m>>2]=3;break L2926}else{A=z}if((A|0)!=2){break L2926}aDD(l+304|0,0,32);break L2926}}while(0);if((z-4|0)>>>0<2){break}c[m>>2]=1}}while(0);k=k+1|0;}while((k|0)<(c[h>>2]|0))}h=c[9152]|0;k=h+16|0;z=(c[k>>2]|0)-1|0;c[k>>2]=z;if((z|0)!=0){i=e;return}do{if((c[h+4>>2]|0)==0){B=h}else{b3(f|0,0)|0;z=c[10742]|0;A=h+8|0;g[A>>2]=+(((c[f+4>>2]|0)-(c[z+4>>2]|0)+(((c[f>>2]|0)-(c[z>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[A>>2];if((c[k>>2]|0)==0){B=c[9152]|0;break}else{i=e;return}}}while(0);c[9152]=c[B+20>>2];i=e;return}function aon(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0;d=a+220|0;e=b;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];d=a+204|0;f=c[d>>2]|0;if((f|0)<=0){return}h=a+212|0;a=b|0;i=b+4|0;j=b+8|0;b=0;k=f;while(1){f=c[(c[h>>2]|0)+(b<<2)>>2]|0;l=c[f+216>>2]|0;do{if((l|0)==5|(l|0)==2){m=k}else{if((c[f+496>>2]&1|0)!=0){m=k;break}n=+g[f+336>>2];if(n!=0.0){o=1.0/n;n=o*+g[i>>2];p=o*+g[j>>2];g[f+356>>2]=o*+g[a>>2];g[f+360>>2]=n;g[f+364>>2]=p;g[f+368>>2]=0.0}q=f+372|0;c[q>>2]=c[e>>2];c[q+4>>2]=c[e+4>>2];c[q+8>>2]=c[e+8>>2];c[q+12>>2]=c[e+12>>2];m=c[d>>2]|0}}while(0);f=b+1|0;if((f|0)<(m|0)){b=f;k=m}else{break}}return}function aoo(a,b){a=a|0;b=b|0;var d=0;d=a;a=b+220|0;c[d>>2]=c[a>>2];c[d+4>>2]=c[a+4>>2];c[d+8>>2]=c[a+8>>2];c[d+12>>2]=c[a+12>>2];return}function aop(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;atB(a|0,b,c,d);return}function aoq(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;if(!((c[b+232>>2]&2|0)==0|(b|0)==0)){cv[c[(c[a>>2]|0)+88>>2]&2047](a,b);return}d=b+188|0;e=c[d>>2]|0;if((e|0)!=0){f=a+76|0;g=c[f>>2]|0;h=cA[c[(c[g>>2]|0)+36>>2]&4095](g)|0;g=a+24|0;dA[c[(c[h>>2]|0)+40>>2]&511](h,e,c[g>>2]|0);h=c[f>>2]|0;dA[c[(c[h>>2]|0)+12>>2]&511](h,e,c[g>>2]|0);c[d>>2]=0}d=a+8|0;g=c[d>>2]|0;e=a+16|0;a=0;while(1){if((a|0)>=(g|0)){i=2759;break}j=c[e>>2]|0;k=j+(a<<2)|0;if((c[k>>2]|0)==(b|0)){break}else{a=a+1|0}}if((i|0)==2759){return}i=g-1|0;c[k>>2]=c[j+(i<<2)>>2];c[(c[e>>2]|0)+(i<<2)>>2]=b;c[d>>2]=(c[d>>2]|0)-1;return}function aor(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=a+204|0;e=c[d>>2]|0;f=a+212|0;g=0;while(1){if((g|0)>=(e|0)){break}h=c[f>>2]|0;i=h+(g<<2)|0;if((c[i>>2]|0)==(b|0)){j=2763;break}else{g=g+1|0}}if((j|0)==2763){g=e-1|0;c[i>>2]=c[h+(g<<2)>>2];c[(c[f>>2]|0)+(g<<2)>>2]=b;c[d>>2]=(c[d>>2]|0)-1}d=b|0;g=b+188|0;b=c[g>>2]|0;if((b|0)!=0){f=a+76|0;h=c[f>>2]|0;i=cA[c[(c[h>>2]|0)+36>>2]&4095](h)|0;h=a+24|0;dA[c[(c[i>>2]|0)+40>>2]&511](i,b,c[h>>2]|0);i=c[f>>2]|0;dA[c[(c[i>>2]|0)+12>>2]&511](i,b,c[h>>2]|0);c[g>>2]=0}g=a+8|0;h=c[g>>2]|0;b=a+16|0;a=0;while(1){if((a|0)>=(h|0)){j=2772;break}k=c[b>>2]|0;l=k+(a<<2)|0;if((c[l>>2]|0)==(d|0)){break}else{a=a+1|0}}if((j|0)==2772){return}j=h-1|0;c[l>>2]=c[k+(j<<2)>>2];c[(c[b>>2]|0)+(j<<2)>>2]=d;c[g>>2]=(c[g>>2]|0)-1;return}function aos(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=i;i=i+32|0;f=e|0;h=e+8|0;aDo(17080);j=b|0;k=c[b+92>>2]|0;if((k|0)!=0){cq[k&1023](j,d)}k=b;cq[c[(c[k>>2]|0)+136>>2]&1023](b,d);l=b|0;g[b+28>>2]=d;c[b+32>>2]=0;c[b+48>>2]=cA[c[(c[b>>2]|0)+16>>2]&4095](l)|0;ct[c[(c[b>>2]|0)+40>>2]&2047](l);if((a[b+44|0]&1)!=0){cq[c[(c[k>>2]|0)+144>>2]&1023](b,d)}ct[c[(c[b>>2]|0)+148>>2]&2047](b);g[b+112>>2]=d;cv[c[(c[b>>2]|0)+152>>2]&2047](b,b+100|0);cq[c[(c[k>>2]|0)+140>>2]&1023](b,d);aDo(16856);k=b+248|0;if((c[k>>2]|0)>0){m=b+256|0;n=0;do{o=c[(c[m>>2]|0)+(n<<2)>>2]|0;dF[c[(c[o>>2]|0)+8>>2]&255](o,l,d);n=n+1|0;}while((n|0)<(c[k>>2]|0))}k=c[9152]|0;n=k+16|0;l=(c[n>>2]|0)-1|0;c[n>>2]=l;do{if((l|0)==0){if((c[k+4>>2]|0)==0){p=k}else{b3(h|0,0)|0;m=c[10742]|0;o=k+8|0;g[o>>2]=+(((c[h+4>>2]|0)-(c[m+4>>2]|0)+(((c[h>>2]|0)-(c[m>>2]|0)|0)*1e6|0)-(c[k+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[o>>2];if((c[n>>2]|0)!=0){break}p=c[9152]|0}c[9152]=c[p+20>>2]}}while(0);aom(b,d);p=c[b+88>>2]|0;if((p|0)!=0){cq[p&1023](j,d)}j=c[9152]|0;p=j+16|0;b=(c[p>>2]|0)-1|0;c[p>>2]=b;if((b|0)!=0){i=e;return}do{if((c[j+4>>2]|0)==0){q=j}else{b3(f|0,0)|0;b=c[10742]|0;n=j+8|0;g[n>>2]=+(((c[f+4>>2]|0)-(c[b+4>>2]|0)+(((c[f>>2]|0)-(c[b>>2]|0)|0)*1e6|0)-(c[j+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[n>>2];if((c[p>>2]|0)==0){q=c[9152]|0;break}else{i=e;return}}}while(0);c[9152]=c[q+20>>2];i=e;return}function aot(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=a+184|0;e=c[d>>2]|0;f=a+192|0;a=0;while(1){if((a|0)>=(e|0)){break}g=c[f>>2]|0;h=g+(a<<2)|0;if((c[h>>2]|0)==(b|0)){i=2825;break}else{a=a+1|0}}if((i|0)==2825){a=e-1|0;c[h>>2]=c[g+(a<<2)>>2];c[(c[f>>2]|0)+(a<<2)>>2]=b;c[d>>2]=(c[d>>2]|0)-1}d=c[b+24>>2]|0;a=d+480|0;f=c[a>>2]|0;g=d+488|0;h=0;while(1){if((h|0)>=(f|0)){j=f;break}k=c[g>>2]|0;l=k+(h<<2)|0;if((c[l>>2]|0)==(b|0)){i=2829;break}else{h=h+1|0}}if((i|0)==2829){h=f-1|0;c[l>>2]=c[k+(h<<2)>>2];c[(c[g>>2]|0)+(h<<2)>>2]=b;h=(c[a>>2]|0)-1|0;c[a>>2]=h;j=h}c[d+252>>2]=(j|0)>0;j=c[b+28>>2]|0;d=j+480|0;h=c[d>>2]|0;a=j+488|0;g=0;while(1){if((g|0)>=(h|0)){m=h;i=2835;break}n=c[a>>2]|0;o=n+(g<<2)|0;if((c[o>>2]|0)==(b|0)){break}else{g=g+1|0}}if((i|0)==2835){p=(m|0)>0;q=p&1;r=j+252|0;c[r>>2]=q;return}i=h-1|0;c[o>>2]=c[n+(i<<2)>>2];c[(c[a>>2]|0)+(i<<2)>>2]=b;b=(c[d>>2]|0)-1|0;c[d>>2]=b;m=b;p=(m|0)>0;q=p&1;r=j+252|0;c[r>>2]=q;return}function aou(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=a+248|0;e=c[d>>2]|0;f=a+256|0;a=0;while(1){if((a|0)>=(e|0)){g=2843;break}h=c[f>>2]|0;i=h+(a<<2)|0;if((c[i>>2]|0)==(b|0)){break}else{a=a+1|0}}if((g|0)==2843){return}g=e-1|0;c[i>>2]=c[h+(g<<2)>>2];c[(c[f>>2]|0)+(g<<2)>>2]=b;c[d>>2]=(c[d>>2]|0)-1;return}function aov(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;e=d|0;f=d+204|0;h=c[f>>2]|0;do{if((h&3|0)==0){if((c[d+496>>2]&1|0)!=0){break}i=b+220|0;j=+g[d+336>>2];if(j!=0.0){k=1.0/j;j=k*+g[b+224>>2];l=k*+g[b+228>>2];g[d+356>>2]=k*+g[i>>2];g[d+360>>2]=j;g[d+364>>2]=l;g[d+368>>2]=0.0}m=d+372|0;n=i;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2]}}while(0);if((c[d+192>>2]|0)==0){return}do{if((h&1|0)==0){n=b+204|0;m=c[n>>2]|0;i=b+208|0;do{if((m|0)==(c[i>>2]|0)){o=(m|0)==0?1:m<<1;if((m|0)>=(o|0)){p=m;break}if((o|0)==0){q=0;r=m}else{c[9806]=(c[9806]|0)+1;s=aDx((o<<2)+19|0)|0;if((s|0)==0){t=0}else{u=-(s+4|0)&15;c[s+u>>2]=s;t=s+(u+4)|0}q=t;r=c[n>>2]|0}u=b+212|0;if((r|0)>0){s=0;do{v=q+(s<<2)|0;if((v|0)!=0){c[v>>2]=c[(c[u>>2]|0)+(s<<2)>>2]}s=s+1|0;}while((s|0)<(r|0))}s=c[u>>2]|0;v=b+216|0;if((s|0)!=0){if((a[v]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[s-4>>2]|0)}c[u>>2]=0}a[v]=1;c[u>>2]=q;c[i>>2]=o;p=c[n>>2]|0}else{p=m}}while(0);m=(c[b+212>>2]|0)+(p<<2)|0;if((m|0)==0){w=p}else{c[m>>2]=d;w=c[n>>2]|0}c[n>>2]=w+1;x=c[f>>2]|0}else{m=d+216|0;if(((c[m>>2]|0)-4|0)>>>0<2){x=h;break}c[m>>2]=2;x=h}}while(0);if((x&1|0)==0){y=(x&2|0)==0}else{y=0}dI[c[(c[b>>2]|0)+32>>2]&1023](b,e,y?1:2,y?-1:-3);return}function aow(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var h=0,i=0,j=0,k=0.0,l=0.0,m=0.0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;h=d|0;i=c[d+204>>2]|0;do{if((i&3|0)==0){if((c[d+496>>2]&1|0)!=0){break}j=b+220|0;k=+g[d+336>>2];if(k!=0.0){l=1.0/k;k=l*+g[b+224>>2];m=l*+g[b+228>>2];g[d+356>>2]=l*+g[j>>2];g[d+360>>2]=k;g[d+364>>2]=m;g[d+368>>2]=0.0}n=d+372|0;o=j;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2]}}while(0);if((c[d+192>>2]|0)==0){return}do{if((i&1|0)==0){o=b+204|0;n=c[o>>2]|0;j=b+208|0;do{if((n|0)==(c[j>>2]|0)){p=(n|0)==0?1:n<<1;if((n|0)>=(p|0)){q=n;break}if((p|0)==0){r=0;s=n}else{c[9806]=(c[9806]|0)+1;t=aDx((p<<2)+19|0)|0;if((t|0)==0){u=0}else{v=-(t+4|0)&15;c[t+v>>2]=t;u=t+(v+4)|0}r=u;s=c[o>>2]|0}v=b+212|0;if((s|0)>0){t=0;do{w=r+(t<<2)|0;if((w|0)!=0){c[w>>2]=c[(c[v>>2]|0)+(t<<2)>>2]}t=t+1|0;}while((t|0)<(s|0))}t=c[v>>2]|0;w=b+216|0;if((t|0)!=0){if((a[w]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[t-4>>2]|0)}c[v>>2]=0}a[w]=1;c[v>>2]=r;c[j>>2]=p;q=c[o>>2]|0}else{q=n}}while(0);n=(c[b+212>>2]|0)+(q<<2)|0;if((n|0)==0){x=q}else{c[n>>2]=d;x=c[o>>2]|0}c[o>>2]=x+1}else{n=d+216|0;if(((c[n>>2]|0)-4|0)>>>0<2){break}c[n>>2]=2}}while(0);dI[c[(c[b>>2]|0)+32>>2]&1023](b,h,e,f);return}function aox(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=b+184|0;g=c[f>>2]|0;h=b+188|0;do{if((g|0)==(c[h>>2]|0)){i=(g|0)==0?1:g<<1;if((g|0)>=(i|0)){j=g;break}if((i|0)==0){k=0;l=g}else{c[9806]=(c[9806]|0)+1;m=aDx((i<<2)+19|0)|0;if((m|0)==0){n=0}else{o=-(m+4|0)&15;c[m+o>>2]=m;n=m+(o+4)|0}k=n;l=c[f>>2]|0}o=b+192|0;if((l|0)>0){m=0;do{p=k+(m<<2)|0;if((p|0)!=0){c[p>>2]=c[(c[o>>2]|0)+(m<<2)>>2]}m=m+1|0;}while((m|0)<(l|0))}m=c[o>>2]|0;p=b+196|0;if((m|0)!=0){if((a[p]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[m-4>>2]|0)}c[o>>2]=0}a[p]=1;c[o>>2]=k;c[h>>2]=i;j=c[f>>2]|0}else{j=g}}while(0);g=(c[b+192>>2]|0)+(j<<2)|0;if((g|0)==0){q=j}else{c[g>>2]=d;q=c[f>>2]|0}c[f>>2]=q+1;if(!e){return}ap6(c[d+24>>2]|0,d);ap6(c[d+28>>2]|0,d);return}function aoy(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=b+248|0;f=c[e>>2]|0;g=b+252|0;do{if((f|0)==(c[g>>2]|0)){h=(f|0)==0?1:f<<1;if((f|0)>=(h|0)){i=f;break}if((h|0)==0){j=0;k=f}else{c[9806]=(c[9806]|0)+1;l=aDx((h<<2)+19|0)|0;if((l|0)==0){m=0}else{n=-(l+4|0)&15;c[l+n>>2]=l;m=l+(n+4)|0}j=m;k=c[e>>2]|0}n=b+256|0;if((k|0)>0){l=0;do{o=j+(l<<2)|0;if((o|0)!=0){c[o>>2]=c[(c[n>>2]|0)+(l<<2)>>2]}l=l+1|0;}while((l|0)<(k|0))}l=c[n>>2]|0;o=b+260|0;if((l|0)!=0){if((a[o]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[l-4>>2]|0)}c[n>>2]=0}a[o]=1;c[n>>2]=j;c[g>>2]=h;i=c[e>>2]|0}else{i=f}}while(0);f=(c[b+256>>2]|0)+(i<<2)|0;if((f|0)==0){p=i;q=p+1|0;c[e>>2]=q;return}c[f>>2]=d;p=c[e>>2]|0;q=p+1|0;c[e>>2]=q;return}function aoz(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function aoA(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function aoB(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+60>>2]&2047](a,b);return}function aoC(a,b){a=a|0;b=b|0;cv[c[(c[a>>2]|0)+64>>2]&2047](a,b);return}function aoD(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0;e=i;i=i+176|0;f=e+8|0;h=e+16|0;j=e+32|0;k=e+48|0;l=e+56|0;m=e+80|0;aDo(16528);n=l+16|0;a[n]=1;o=l+12|0;c[o>>2]=0;p=l+4|0;c[p>>2]=0;q=l+8|0;c[q>>2]=0;r=c[b+184>>2]|0;L3236:do{if((r|0)>0){c[9806]=(c[9806]|0)+1;s=aDx((r<<2)+19|0)|0;if((s|0)==0){t=0}else{u=-(s+4|0)&15;c[s+u>>2]=s;t=s+(u+4)|0}u=c[p>>2]|0;if((u|0)>0){s=0;do{v=t+(s<<2)|0;if((v|0)!=0){c[v>>2]=c[(c[o>>2]|0)+(s<<2)>>2]}s=s+1|0;}while((s|0)<(u|0))}u=c[o>>2]|0;if((u|0)!=0){if((a[n]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[u-4>>2]|0)}c[o>>2]=0}a[n]=1;c[o>>2]=t;c[q>>2]=r;u=0;s=t;while(1){v=s+(u<<2)|0;if((v|0)!=0){c[v>>2]=0}v=u+1|0;if((v|0)>=(r|0)){break L3236}u=v;s=c[o>>2]|0}}}while(0);c[p>>2]=r;r=b;t=b+192|0;s=0;while(1){if((s|0)>=(cA[c[(c[r>>2]|0)+100>>2]&4095](b)|0)){break}c[(c[o>>2]|0)+(s<<2)>>2]=c[(c[t>>2]|0)+(s<<2)>>2];s=s+1|0}s=c[p>>2]|0;if((s|0)>1){aoR(l,0,s-1|0)}s=(cA[c[(c[r>>2]|0)+100>>2]&4095](b)|0)==0;r=s?0:c[o>>2]|0;s=b+172|0;l=c[s>>2]|0;t=c[p>>2]|0;u=b+80|0;v=c[u>>2]|0;w=b+72|0;x=c[w>>2]|0;y=b+24|0;z=c[y>>2]|0;c[m>>2]=18656;c[m+4>>2]=d;c[m+8>>2]=l;c[m+12>>2]=r;c[m+16>>2]=t;c[m+20>>2]=v;c[m+24>>2]=x;c[m+28>>2]=z;a[m+48|0]=1;c[m+44>>2]=0;c[m+36>>2]=0;c[m+40>>2]=0;a[m+68|0]=1;c[m+64>>2]=0;c[m+56>>2]=0;c[m+60>>2]=0;a[m+88|0]=1;c[m+84>>2]=0;c[m+76>>2]=0;c[m+80>>2]=0;x=c[(c[l>>2]|0)+8>>2]|0;v=b+8|0;t=c[v>>2]|0;r=cA[c[(c[z>>2]|0)+36>>2]&4095](z)|0;dA[x&511](l,t,r);r=c[b+176>>2]|0;t=c[y>>2]|0;y=m|0;aDo(16320);l=r+28|0;x=c[l>>2]|0;if((x|0)<0){z=r+32|0;A=r+36|0;if((c[z>>2]|0)<0){B=c[A>>2]|0;C=r+40|0;if((B|0)!=0){if((a[C]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[B-4>>2]|0)}c[A>>2]=0}a[C]=1;c[A>>2]=0;c[z>>2]=0;D=x}else{D=x}do{x=(c[A>>2]|0)+(D<<2)|0;if((x|0)!=0){c[x>>2]=0}D=D+1|0;}while((D|0)<0)}c[l>>2]=0;D=r+4|0;A=r+8|0;x=c[A>>2]|0;do{if((x|0)>0){z=r+16|0;C=0;do{B=c[z>>2]|0;E=B+(C<<3)|0;F=c[E>>2]|0;if((F|0)==(C|0)){G=C;H=B}else{I=B;B=E;E=F;while(1){F=I+(E<<3)|0;c[B>>2]=c[F>>2];J=c[F>>2]|0;F=c[z>>2]|0;K=F+(J<<3)|0;L=c[K>>2]|0;if((J|0)==(L|0)){G=J;H=F;break}else{I=F;B=K;E=L}}}c[H+(C<<3)>>2]=G;C=C+1|0;}while((C|0)<(x|0));C=c[A>>2]|0;z=k|0;if((C|0)>1){aBX(D,0,C-1|0);M=z;N=c[A>>2]|0}else{M=z;N=C}if((N|0)<=0){break}C=r+16|0;z=b+16|0;E=0;while(1){B=c[C>>2]|0;I=c[B+(E<<3)>>2]|0;L=E;do{L=L+1|0;O=(L|0)<(N|0);if(!O){break}}while((c[B+(L<<3)>>2]|0)==(I|0));L3309:do{if((E|0)<(L|0)){K=c[z>>2]|0;F=E;J=1;while(1){P=c[K+(c[B+(F<<3)+4>>2]<<2)>>2]|0;if((c[P+208>>2]|0)==(I|0)){Q=c[P+216>>2]|0;R=J&(Q|0)!=1&(Q|0)!=4}else{R=J}Q=F+1|0;if((Q|0)<(L|0)){F=Q;J=R}else{break}}if(R){J=E;F=B;Q=K;while(1){P=c[Q+(c[F+(J<<3)+4>>2]<<2)>>2]|0;do{if((c[P+208>>2]|0)==(I|0)){S=P+216|0;if(((c[S>>2]|0)-4|0)>>>0<2){break}c[S>>2]=2}}while(0);P=J+1|0;if((P|0)>=(L|0)){break L3309}J=P;F=c[C>>2]|0;Q=c[z>>2]|0}}else{Q=E;F=B;J=K;while(1){P=c[J+(c[F+(Q<<3)+4>>2]<<2)>>2]|0;do{if((c[P+208>>2]|0)==(I|0)){S=P+216|0;if((c[S>>2]|0)!=2){break}c[S>>2]=3;g[P+220>>2]=0.0}}while(0);P=Q+1|0;if((P|0)>=(L|0)){break L3309}Q=P;F=c[C>>2]|0;J=c[z>>2]|0}}}}while(0);if(O){E=L}else{break}}}else{}}while(0);O=t;R=cA[c[(c[O>>2]|0)+36>>2]&4095](t)|0;if((R|0)>0){N=t;M=r+64|0;D=t;k=r+32|0;x=r+36|0;G=r+40|0;H=0;do{E=dj[c[(c[N>>2]|0)+40>>2]&511](t,H)|0;z=c[E+1108>>2]|0;C=z;I=c[E+1112>>2]|0;B=I;if((z|0)==0){T=3037}else{if((c[z+216>>2]|0)==2){T=3037}else{T=3039}}do{if((T|0)==3037){T=0;if((I|0)==0){break}if((c[I+216>>2]|0)!=2){T=3039}}}while(0);do{if((T|0)==3039){T=0;J=z+204|0;do{if((c[J>>2]&2|0)!=0){if((c[z+216>>2]|0)==2){break}if((c[I+204>>2]&3|0)!=0){break}F=I+216|0;if(((c[F>>2]|0)-4|0)>>>0>=2){c[F>>2]=1}g[I+220>>2]=0.0}}while(0);do{if((c[I+204>>2]&2|0)!=0){if((c[I+216>>2]|0)==2){break}if((c[J>>2]&3|0)!=0){break}L=z+216|0;if(((c[L>>2]|0)-4|0)>>>0>=2){c[L>>2]=1}g[z+220>>2]=0.0}}while(0);if((a[M]&1)==0){break}if(!(cS[c[(c[D>>2]|0)+28>>2]&511](t,C,B)|0)){break}J=c[l>>2]|0;do{if((J|0)==(c[k>>2]|0)){L=(J|0)==0?1:J<<1;if((J|0)>=(L|0)){U=J;break}if((L|0)==0){V=0;W=J}else{c[9806]=(c[9806]|0)+1;F=aDx((L<<2)+19|0)|0;if((F|0)==0){X=0}else{Q=-(F+4|0)&15;c[F+Q>>2]=F;X=F+(Q+4)|0}V=X;W=c[l>>2]|0}if((W|0)>0){Q=0;do{F=V+(Q<<2)|0;if((F|0)!=0){c[F>>2]=c[(c[x>>2]|0)+(Q<<2)>>2]}Q=Q+1|0;}while((Q|0)<(W|0))}Q=c[x>>2]|0;if((Q|0)!=0){if((a[G]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[Q-4>>2]|0)}c[x>>2]=0}a[G]=1;c[x>>2]=V;c[k>>2]=L;U=c[l>>2]|0}else{U=J}}while(0);J=(c[x>>2]|0)+(U<<2)|0;if((J|0)==0){Y=U}else{c[J>>2]=E;Y=c[l>>2]|0}c[l>>2]=Y+1}}while(0);H=H+1|0;}while((H|0)<(R|0))}R=c[9152]|0;H=R+16|0;Y=(c[H>>2]|0)-1|0;c[H>>2]=Y;do{if((Y|0)==0){if((c[R+4>>2]|0)==0){Z=R}else{b3(j|0,0)|0;U=c[10742]|0;x=R+8|0;g[x>>2]=+(((c[j+4>>2]|0)-(c[U+4>>2]|0)+(((c[j>>2]|0)-(c[U>>2]|0)|0)*1e6|0)-(c[R+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[x>>2];if((c[H>>2]|0)!=0){break}Z=c[9152]|0}c[9152]=c[Z+20>>2]}}while(0);Z=c[A>>2]|0;aDo(17616);do{if((a[r+64|0]&1)==0){A=cA[c[(c[t>>2]|0)+44>>2]&4095](t)|0;H=cA[c[(c[O>>2]|0)+36>>2]&4095](t)|0;c_[c[(c[m>>2]|0)+8>>2]&127](y,c[b+16>>2]|0,c[v>>2]|0,A,H,-1)}else{H=c[l>>2]|0;if((H|0)>1){aAo(r+24|0,0,H-1|0)}if((Z|0)<=0){break}A=r+16|0;R=r+36|0;j=r+48|0;Y=r+52|0;x=r+56|0;U=r+60|0;k=m;V=b+16|0;G=1;W=0;X=0;while(1){D=c[A>>2]|0;M=c[D+(X<<3)>>2]|0;L3414:do{if((X|0)<(Z|0)){T=1;N=X;E=D;B=M;while(1){if((B|0)!=(M|0)){_=T;$=N;break L3414}C=c[(c[V>>2]|0)+(c[E+(N<<3)+4>>2]<<2)>>2]|0;z=c[j>>2]|0;do{if((z|0)==(c[Y>>2]|0)){I=(z|0)==0?1:z<<1;if((z|0)>=(I|0)){aa=z;break}if((I|0)==0){ab=0;ac=z}else{c[9806]=(c[9806]|0)+1;J=aDx((I<<2)+19|0)|0;if((J|0)==0){ad=0}else{Q=-(J+4|0)&15;c[J+Q>>2]=J;ad=J+(Q+4)|0}ab=ad;ac=c[j>>2]|0}if((ac|0)>0){Q=0;do{J=ab+(Q<<2)|0;if((J|0)!=0){c[J>>2]=c[(c[x>>2]|0)+(Q<<2)>>2]}Q=Q+1|0;}while((Q|0)<(ac|0))}Q=c[x>>2]|0;if((Q|0)!=0){if((a[U]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[Q-4>>2]|0)}c[x>>2]=0}a[U]=1;c[x>>2]=ab;c[Y>>2]=I;aa=c[j>>2]|0}else{aa=z}}while(0);z=(c[x>>2]|0)+(aa<<2)|0;if((z|0)==0){ae=aa}else{c[z>>2]=C;ae=c[j>>2]|0}c[j>>2]=ae+1;z=c[C+216>>2]|0;Q=T&((z|0)==2|(z|0)==5);z=N+1|0;if((z|0)>=(Z|0)){_=Q;$=z;break L3414}J=c[A>>2]|0;T=Q;N=z;E=J;B=c[J+(z<<3)>>2]|0}}else{_=1;$=X}}while(0);do{if((W|0)<(H|0)){D=c[R>>2]|0;B=D+(W<<2)|0;E=c[B>>2]|0;N=c[(c[E+1108>>2]|0)+208>>2]|0;if((N|0)>-1){af=N}else{af=c[(c[E+1112>>2]|0)+208>>2]|0}if((af|0)==(M|0)){ag=W}else{ah=0;ai=0;aj=G;break}do{ag=ag+1|0;if((ag|0)>=(H|0)){break}E=c[D+(ag<<2)>>2]|0;N=c[(c[E+1108>>2]|0)+208>>2]|0;if((N|0)>-1){ak=N}else{ak=c[(c[E+1112>>2]|0)+208>>2]|0}}while((M|0)==(ak|0));ah=B;ai=ag-W|0;aj=ag}else{ah=0;ai=0;aj=G}}while(0);if(!_){c_[c[(c[k>>2]|0)+8>>2]&127](y,c[x>>2]|0,c[j>>2]|0,ah,ai,M)}D=(ai|0)==0?W:aj;E=c[j>>2]|0;if((E|0)<0){if((c[Y>>2]|0)<0){N=c[x>>2]|0;if((N|0)!=0){if((a[U]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[N-4>>2]|0)}c[x>>2]=0}a[U]=1;c[x>>2]=0;c[Y>>2]=0;al=E}else{al=E}do{E=(c[x>>2]|0)+(al<<2)|0;if((E|0)!=0){c[E>>2]=0}al=al+1|0;}while((al|0)<0)}c[j>>2]=0;if(($|0)<(Z|0)){G=aj;W=D;X=$}else{break}}}}while(0);$=c[9152]|0;aj=$+16|0;Z=(c[aj>>2]|0)-1|0;c[aj>>2]=Z;do{if((Z|0)==0){if((c[$+4>>2]|0)==0){am=$}else{b3(h|0,0)|0;al=c[10742]|0;ai=$+8|0;g[ai>>2]=+(((c[h+4>>2]|0)-(c[al+4>>2]|0)+(((c[h>>2]|0)-(c[al>>2]|0)|0)*1e6|0)-(c[$+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[ai>>2];if((c[aj>>2]|0)!=0){break}am=c[9152]|0}c[9152]=c[am+20>>2]}}while(0);aoE(m);am=c[s>>2]|0;dI[c[(c[am>>2]|0)+16>>2]&1023](am,d,c[u>>2]|0,c[w>>2]|0);aoV(m);m=c[o>>2]|0;if((m|0)!=0){if((a[n]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[m-4>>2]|0)}c[o>>2]=0}a[n]=1;c[o>>2]=0;c[p>>2]=0;c[q>>2]=0;q=c[9152]|0;p=q+16|0;o=(c[p>>2]|0)-1|0;c[p>>2]=o;if((o|0)!=0){i=e;return}do{if((c[q+4>>2]|0)==0){an=q}else{b3(f|0,0)|0;o=c[10742]|0;n=q+8|0;g[n>>2]=+(((c[f+4>>2]|0)-(c[o+4>>2]|0)+(((c[f>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[q+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[n>>2];if((c[p>>2]|0)==0){an=c[9152]|0;break}else{i=e;return}}}while(0);c[9152]=c[an+20>>2];i=e;return}function aoE(b){b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=b+56|0;e=c[d>>2]|0;f=b+76|0;g=c[f>>2]|0;if((g+e|0)>0){h=c[b+8>>2]|0;i=c[(c[h>>2]|0)+12>>2]|0;j=c[b+44>>2]|0;k=b+36|0;l=c[k>>2]|0;m=c[b+64>>2]|0;n=c[b+84>>2]|0;o=c[b+4>>2]|0;p=c[b+20>>2]|0;q=c[b+24>>2]|0;r=c[b+28>>2]|0;+cN[i&63](h,j,l,m,e,n,g,o,p,q,r);s=k}else{s=b+36|0}k=c[s>>2]|0;if((k|0)<0){r=b+40|0;q=b+44|0;if((c[r>>2]|0)<0){p=c[q>>2]|0;o=b+48|0;if((p|0)!=0){if((a[o]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-4>>2]|0)}c[q>>2]=0}a[o]=1;c[q>>2]=0;c[r>>2]=0;t=k}else{t=k}do{k=(c[q>>2]|0)+(t<<2)|0;if((k|0)!=0){c[k>>2]=0}t=t+1|0;}while((t|0)<0)}c[s>>2]=0;s=c[d>>2]|0;if((s|0)<0){t=b+60|0;q=b+64|0;if((c[t>>2]|0)<0){k=c[q>>2]|0;r=b+68|0;if((k|0)!=0){if((a[r]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[k-4>>2]|0)}c[q>>2]=0}a[r]=1;c[q>>2]=0;c[t>>2]=0;u=s}else{u=s}do{s=(c[q>>2]|0)+(u<<2)|0;if((s|0)!=0){c[s>>2]=0}u=u+1|0;}while((u|0)<0)}c[d>>2]=0;d=c[f>>2]|0;if((d|0)>=0){c[f>>2]=0;return}u=b+80|0;q=b+84|0;if((c[u>>2]|0)<0){s=c[q>>2]|0;t=b+88|0;if((s|0)!=0){if((a[t]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[s-4>>2]|0)}c[q>>2]=0}a[t]=1;c[q>>2]=0;c[u>>2]=0;v=d}else{v=d}do{d=(c[q>>2]|0)+(v<<2)|0;if((d|0)!=0){c[d>>2]=0}v=v+1|0;}while((v|0)<0);c[f>>2]=0;return}function aoF(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;b=i;i=i+16|0;d=b|0;aDo(16384);e=a+176|0;f=c[e>>2]|0;h=a|0;dA[c[(c[f>>2]|0)+8>>2]&511](f,h,c[a+24>>2]|0);f=c[a+184>>2]|0;if((f|0)>0){j=a+192|0;a=0;do{k=c[(c[j>>2]|0)+(a<<2)>>2]|0;l=c[k+24>>2]|0;m=c[k+28>>2]|0;do{if((l|0)!=0){if((c[l+204>>2]&3|0)!=0|(m|0)==0){break}if((c[m+204>>2]&3|0)!=0){break}k=c[l+216>>2]|0;if((k|0)==5|(k|0)==2){k=c[m+216>>2]|0;if((k|0)==5|(k|0)==2){break}}k=c[l+208>>2]|0;n=c[m+208>>2]|0;o=(c[e>>2]|0)+16|0;p=c[o>>2]|0;q=p+(k<<3)|0;r=c[q>>2]|0;if((r|0)==(k|0)){s=k;t=p}else{k=p;p=q;q=r;while(1){r=k+(q<<3)|0;c[p>>2]=c[r>>2];u=c[r>>2]|0;r=c[o>>2]|0;v=r+(u<<3)|0;w=c[v>>2]|0;if((u|0)==(w|0)){s=u;t=r;break}else{k=r;p=v;q=w}}}q=t+(n<<3)|0;p=c[q>>2]|0;if((p|0)==(n|0)){x=n;y=t}else{k=t;w=q;q=p;while(1){p=k+(q<<3)|0;c[w>>2]=c[p>>2];v=c[p>>2]|0;p=c[o>>2]|0;r=p+(v<<3)|0;u=c[r>>2]|0;if((v|0)==(u|0)){x=v;y=p;break}else{k=p;w=r;q=u}}}if((s|0)==(x|0)){break}c[y+(s<<3)>>2]=x;q=c[o>>2]|0;w=q+(x<<3)+4|0;c[w>>2]=(c[w>>2]|0)+(c[q+(s<<3)+4>>2]|0)}}while(0);a=a+1|0;}while((a|0)<(f|0))}f=c[e>>2]|0;cv[c[(c[f>>2]|0)+12>>2]&2047](f,h);h=c[9152]|0;f=h+16|0;e=(c[f>>2]|0)-1|0;c[f>>2]=e;if((e|0)!=0){i=b;return}do{if((c[h+4>>2]|0)==0){z=h}else{b3(d|0,0)|0;e=c[10742]|0;a=h+8|0;g[a>>2]=+(((c[d+4>>2]|0)-(c[e+4>>2]|0)+(((c[d>>2]|0)-(c[e>>2]|0)|0)*1e6|0)-(c[h+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[a>>2];if((c[f>>2]|0)==0){z=c[9152]|0;break}else{i=b;return}}}while(0);c[9152]=c[z+20>>2];i=b;return}function aoG(a){a=a|0;return}function aoH(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0.0,aK=0,aL=0.0,aM=0,aN=0.0,aO=0.0,aP=0.0,aQ=0,aR=0,aS=0,aT=0,aU=0,aV=0.0,aW=0.0,aX=0.0,aY=0.0,aZ=0.0,a_=0.0,a$=0.0,a0=0.0,a1=0.0,a2=0.0,a3=0.0,a4=0.0,a5=0.0,a6=0.0,a7=0.0,a8=0.0,a9=0.0,ba=0.0,bb=0.0,bc=0.0,bd=0.0,be=0,bf=0,bg=0,bh=0,bi=0;f=i;i=i+376|0;h=f+8|0;j=f+16|0;k=f+24|0;l=f+40|0;m=f+56|0;n=f+72|0;o=f+96|0;p=f+160|0;q=f+256|0;r=f+312|0;aDo(16224);s=d+204|0;if((c[s>>2]|0)>0){t=d+212|0;u=o+48|0;v=u|0;w=o+52|0;x=o+56|0;y=d|0;z=d+44|0;A=d+76|0;B=d+24|0;C=p|0;D=p+4|0;E=p+8|0;F=p+10|0;G=p+12|0;H=p+28|0;I=u;u=p+76|0;J=p+80|0;K=p+84|0;L=p+88|0;M=p+92|0;N=q|0;O=q+4|0;P=q+28|0;Q=q+44|0;R=d+56|0;S=p|0;T=r;U=r+16|0;V=r+32|0;W=r+48|0;X=q|0;Y=q+8|0;Z=q+12|0;_=q+16|0;$=q+20|0;aa=q+24|0;q=p+60|0;ab=p+64|0;ac=p+68|0;ad=k|0;ae=k+4|0;af=k+8|0;ag=k+12|0;ah=l|0;ai=l+4|0;aj=l+8|0;ak=l+12|0;al=p+44|0;am=p+48|0;an=p+52|0;p=d+132|0;ao=d+112|0;d=m|0;ap=m+4|0;aq=m+8|0;ar=m+12|0;as=n|0;at=n+4|0;au=n+8|0;av=n+12|0;aw=h|0;ax=h+4|0;ay=0;do{az=c[(c[t>>2]|0)+(ay<<2)>>2]|0;aA=az|0;aB=az+240|0;g[aB>>2]=1.0;aC=c[az+216>>2]|0;L3601:do{if(!((aC|0)==5|(aC|0)==2)){if((c[az+204>>2]&3|0)!=0){break}aD=az+4|0;aE=az+320|0;aF=az+304|0;aG=az+308|0;aH=az+312|0;anY(aD,+g[aF>>2],+g[aG>>2],+g[aH>>2],aE,e,o);aI=az+52|0;aJ=+g[v>>2]- +g[aI>>2];aK=az+56|0;aL=+g[w>>2]- +g[aK>>2];aM=az+60|0;aN=+g[x>>2]- +g[aM>>2];do{if((a[z]&1)!=0){aO=+g[az+248>>2];aP=aO*aO;if(!(aP!=0.0&aP<aJ*aJ+aL*aL+aN*aN)){break}aDo(16048);do{if((c[(c[az+192>>2]|0)+4>>2]|0)<20){c[9802]=(c[9802]|0)+1;aQ=c[A>>2]|0;aR=cA[c[(c[aQ>>2]|0)+36>>2]&4095](aQ)|0;aQ=c[B>>2]|0;g[D>>2]=1.0;b[E>>1]=1;b[F>>1]=-1;c[C>>2]=19448;aS=aI;c[G>>2]=c[aS>>2];c[G+4>>2]=c[aS+4>>2];c[G+8>>2]=c[aS+8>>2];c[G+12>>2]=c[aS+12>>2];c[H>>2]=c[I>>2];c[H+4>>2]=c[I+4>>2];c[H+8>>2]=c[I+8>>2];c[H+12>>2]=c[I+12>>2];c[u>>2]=0;c[C>>2]=19728;c[J>>2]=aA;g[K>>2]=0.0;c[L>>2]=aR;c[M>>2]=aQ;aP=+g[az+244>>2];c[Y>>2]=0;g[Z>>2]=1.0;g[_>>2]=1.0;g[$>>2]=1.0;g[aa>>2]=0.0;c[N>>2]=25528;c[O>>2]=8;g[P>>2]=aP;g[Q>>2]=aP;g[K>>2]=+g[R>>2];aQ=az+188|0;b[E>>1]=b[(c[aQ>>2]|0)+4>>1]|0;b[F>>1]=b[(c[aQ>>2]|0)+6>>1]|0;c[W>>2]=c[I>>2];c[W+4>>2]=c[I+4>>2];c[W+8>>2]=c[I+8>>2];c[W+12>>2]=c[I+12>>2];aQ=aD;c[T>>2]=c[aQ>>2];c[T+4>>2]=c[aQ+4>>2];c[T+8>>2]=c[aQ+8>>2];c[T+12>>2]=c[aQ+12>>2];aQ=az+20|0;c[U>>2]=c[aQ>>2];c[U+4>>2]=c[aQ+4>>2];c[U+8>>2]=c[aQ+8>>2];c[U+12>>2]=c[aQ+12>>2];aQ=az+36|0;c[V>>2]=c[aQ>>2];c[V+4>>2]=c[aQ+4>>2];c[V+8>>2]=c[aQ+8>>2];c[V+12>>2]=c[aQ+12>>2];atO(y,X,aD,r,S,0.0);aP=+g[D>>2];if(aP>=1.0){aT=0;break}g[aB>>2]=aP;anY(aD,+g[aF>>2],+g[aG>>2],+g[aH>>2],aE,aP*e,o);g[aB>>2]=0.0;ap4(az,o);aQ=c[u>>2]|0;if((c[aQ+232>>2]&2|0)==0){aU=0}else{aU=aQ}aP=+g[q>>2];aO=aP- +g[az+52>>2];aV=+g[ab>>2];aW=aV- +g[aK>>2];aX=+g[ac>>2];aY=aX- +g[aM>>2];g[ad>>2]=aO;g[ae>>2]=aW;g[af>>2]=aY;g[ag>>2]=0.0;aZ=aP- +g[aQ+52>>2];a_=aV- +g[aQ+56>>2];a$=aX- +g[aQ+60>>2];g[ah>>2]=aZ;g[ai>>2]=a_;g[aj>>2]=a$;g[ak>>2]=0.0;a0=+g[az+324>>2];a1=+g[az+328>>2];a2=+g[az+320>>2];aR=(aU|0)!=0;if(aR){a3=+g[aU+324>>2];a4=+g[aU+328>>2];a5=+g[aU+320>>2];a6=a3*a$-a4*a_+ +g[aU+304>>2];a7=+g[aU+308>>2]+(a4*aZ-a$*a5);a8=a_*a5-a3*aZ+ +g[aU+312>>2]}else{a6=0.0;a7=0.0;a8=0.0}aZ=+g[al>>2];a3=+g[am>>2];a5=+g[an>>2];a_=aZ*(a0*aY-a1*aW+ +g[aF>>2]-a6)+(+g[aG>>2]+(a1*aO-aY*a2)-a7)*a3+(aW*a2-a0*aO+ +g[aH>>2]-a8)*a5;a0=a5*aW-a3*aY;a2=aZ*aY-a5*aO;a1=a3*aO-aZ*aW;a$=a1*+g[az+288>>2]+(+g[az+256>>2]*a0+ +g[az+272>>2]*a2);a4=a0*+g[az+260>>2]+a2*+g[az+276>>2]+a1*+g[az+292>>2];a9=a0*+g[az+264>>2]+a2*+g[az+280>>2]+a1*+g[az+296>>2];if(aR){a1=aP- +g[aU+52>>2];aP=aV- +g[aU+56>>2];aV=aX- +g[aU+60>>2];aX=a5*aP-a3*aV;a2=aZ*aV-a5*a1;a0=a3*a1-aZ*aP;ba=a0*+g[aU+288>>2]+(+g[aU+256>>2]*aX+ +g[aU+272>>2]*a2);bb=aX*+g[aU+260>>2]+a2*+g[aU+276>>2]+a0*+g[aU+292>>2];bc=aX*+g[aU+264>>2]+a2*+g[aU+280>>2]+a0*+g[aU+296>>2];bd=+g[aU+336>>2]+(a5*(aP*ba-a1*bb)+(aZ*(aV*bb-aP*bc)+a3*(a1*bc-aV*ba)));be=1}else{bd=0.0;be=0}ba=1.0/(+g[az+336>>2]+(a5*(aW*a$-aO*a4)+(aZ*(aY*a4-aW*a9)+a3*(aO*a9-aY*a$)))+bd);a$=+g[p>>2]*-0.0/+g[ao>>2]*ba+a_*(-0.0-(+g[az+228>>2]*+g[aQ+228>>2]*(-0.0-a_)+1.0))*ba;ba=a$<0.0?0.0:a$;g[d>>2]=aZ*ba;g[ap>>2]=a3*ba;g[aq>>2]=a5*ba;g[ar>>2]=0.0;pe(az,m,k);if(!be){aT=4;break}a5=ba*(-0.0- +g[am>>2]);a3=ba*(-0.0- +g[an>>2]);g[as>>2]=ba*(-0.0- +g[al>>2]);g[at>>2]=a5;g[au>>2]=a3;g[av>>2]=0.0;pe(aU,n,l);aT=4}else{aT=0}}while(0);aQ=c[9152]|0;aR=aQ+16|0;aS=(c[aR>>2]|0)-1|0;c[aR>>2]=aS;do{if((aS|0)==0){if((c[aQ+4>>2]|0)==0){bf=aQ}else{b3(h|0,0)|0;bg=c[10742]|0;bh=aQ+8|0;g[bh>>2]=+(((c[ax>>2]|0)-(c[bg+4>>2]|0)+(((c[aw>>2]|0)-(c[bg>>2]|0)|0)*1e6|0)-(c[aQ+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[bh>>2];if((c[aR>>2]|0)!=0){break}bf=c[9152]|0}c[9152]=c[bf+20>>2]}}while(0);if((aT|0)==4){break L3601}}}while(0);ap4(az,o)}}while(0);ay=ay+1|0;}while((ay|0)<(c[s>>2]|0))}s=c[9152]|0;ay=s+16|0;o=(c[ay>>2]|0)-1|0;c[ay>>2]=o;if((o|0)!=0){i=f;return}do{if((c[s+4>>2]|0)==0){bi=s}else{b3(j|0,0)|0;o=c[10742]|0;aT=s+8|0;g[aT>>2]=+(((c[j+4>>2]|0)-(c[o+4>>2]|0)+(((c[j>>2]|0)-(c[o>>2]|0)|0)*1e6|0)-(c[s+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[aT>>2];if((c[ay>>2]|0)==0){bi=c[9152]|0;break}else{i=f;return}}}while(0);c[9152]=c[bi+20>>2];i=f;return}function aoI(a){a=a|0;return 2}function aoJ(a){a=a|0;return c[a+172>>2]|0}function aoK(a){a=a|0;return c[a+184>>2]|0}function aoL(a,b){a=a|0;b=b|0;return c[(c[a+192>>2]|0)+(b<<2)>>2]|0}function aoM(a,b){a=a|0;b=b|0;return c[(c[a+192>>2]|0)+(b<<2)>>2]|0}function aoN(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0;d=i;i=i+8|0;e=d|0;aDo(18048);f=a+204|0;h=c[f>>2]|0;if((h|0)>0){j=a+212|0;a=0;k=h;while(1){h=c[(c[j>>2]|0)+(a<<2)>>2]|0;if((c[h+204>>2]&3|0)==0){ap5(h,b);ap3(h,b);anY(h+4|0,+g[h+304>>2],+g[h+308>>2],+g[h+312>>2],h+320|0,b,h+68|0);l=c[f>>2]|0}else{l=k}h=a+1|0;if((h|0)<(l|0)){a=h;k=l}else{break}}}l=c[9152]|0;k=l+16|0;a=(c[k>>2]|0)-1|0;c[k>>2]=a;if((a|0)!=0){i=d;return}do{if((c[l+4>>2]|0)==0){m=l}else{b3(e|0,0)|0;a=c[10742]|0;f=l+8|0;g[f>>2]=+(((c[e+4>>2]|0)-(c[a+4>>2]|0)+(((c[e>>2]|0)-(c[a>>2]|0)|0)*1e6|0)-(c[l+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[f>>2];if((c[k>>2]|0)==0){m=c[9152]|0;break}else{i=d;return}}}while(0);c[9152]=c[m+20>>2];i=d;return}function aoO(b,d){b=b|0;d=d|0;var e=0,f=0;e=b+241|0;f=b+172|0;do{if((a[e]&1)!=0){b=c[f>>2]|0;if((b|0)==0){break}c[9804]=(c[9804]|0)+1;aDB(c[b-4>>2]|0)}}while(0);a[e]=0;c[f>>2]=d;return}function aoP(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;d=b;ct[c[(c[d>>2]|0)+32>>2]&2047](b);e=a+8|0;f=c[e>>2]|0;if((f|0)>0){g=a+16|0;h=b;i=b;j=0;k=f;while(1){f=c[(c[g>>2]|0)+(j<<2)>>2]|0;if((c[f+232>>2]&2|0)==0){l=k}else{m=cA[c[(c[f>>2]|0)+16>>2]&4095](f)|0;n=cS[c[(c[h>>2]|0)+16>>2]&511](b,m,1)|0;m=cS[c[(c[f>>2]|0)+20>>2]&511](f,c[n+8>>2]|0,b)|0;co[c[(c[i>>2]|0)+20>>2]&255](b,n,m,1497645650,f);l=c[e>>2]|0}f=j+1|0;if((f|0)<(l|0)){j=f;k=l}else{break}}}l=a+184|0;if((c[l>>2]|0)<=0){o=a|0;atW(o,b);p=c[d>>2]|0;q=p+36|0;r=c[q>>2]|0;ct[r&2047](b);return}k=a+192|0;j=b;e=b;i=0;do{h=c[(c[k>>2]|0)+(i<<2)>>2]|0;g=cA[c[(c[h>>2]|0)+36>>2]&4095](h)|0;f=cS[c[(c[j>>2]|0)+16>>2]&511](b,g,1)|0;g=cS[c[(c[h>>2]|0)+40>>2]&511](h,c[f+8>>2]|0,b)|0;co[c[(c[e>>2]|0)+20>>2]&255](b,f,g,1397641027,h);i=i+1|0;}while((i|0)<(c[l>>2]|0));o=a|0;atW(o,b);p=c[d>>2]|0;q=p+36|0;r=c[q>>2]|0;ct[r&2047](b);return}function aoQ(d,e){d=d|0;e=+e;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0,ar=0,as=0,at=0,au=0,av=0,aw=0,ax=0,ay=0,az=0,aA=0,aB=0,aC=0,aD=0,aE=0,aF=0,aG=0,aH=0,aI=0,aJ=0,aK=0,aL=0,aM=0,aN=0.0,aO=0,aP=0.0,aQ=0,aR=0.0,aS=0.0,aT=0.0,aU=0,aV=0,aW=0,aX=0,aY=0,aZ=0,a_=0,a$=0.0,a0=0,a1=0;f=i;i=i+528|0;h=f|0;j=f+16|0;k=f+32|0;l=f+96|0;m=f+192|0;n=f+248|0;o=f+312|0;p=f+336|0;q=f+496|0;r=f+512|0;aDo(18112);s=d+204|0;if((c[s>>2]|0)>0){t=d+212|0;u=k+48|0;v=u|0;w=k+52|0;x=k+56|0;y=d|0;z=d+76|0;A=d+24|0;d=l|0;B=l+4|0;C=l+8|0;D=l+10|0;E=l+12|0;F=l+28|0;G=u;u=l+76|0;H=l+80|0;I=l+84|0;J=l+88|0;K=l+92|0;L=m|0;M=m+4|0;N=m+28|0;O=m+44|0;P=l|0;R=n;S=n+16|0;T=n+32|0;U=n+48|0;V=U;W=m|0;X=o+16|0;Y=o+12|0;Z=o+4|0;_=o+8|0;$=p+4|0;aa=U|0;U=n+52|0;ab=n+56|0;ac=q;ad=l+60|0;ae=q|0;af=q+4|0;ag=q+8|0;ah=l+44|0;ai=ah|0;aj=l+48|0;ak=l+52|0;l=r|0;al=r+4|0;am=r+8|0;an=r+12|0;ao=m+8|0;ap=m+12|0;aq=m+16|0;ar=m+20|0;as=m+24|0;m=p|0;at=p+136|0;au=p+140|0;av=p+8|0;aw=p+144|0;ax=p+24|0;ay=p+40|0;az=p+56|0;aA=p+72|0;aB=p+88|0;aC=p+104|0;aD=p+120|0;aE=h|0;aF=h+4|0;aG=0;do{aH=c[(c[t>>2]|0)+(aG<<2)>>2]|0;aI=aH|0;g[aH+240>>2]=1.0;aJ=c[aH+216>>2]|0;do{if(!((aJ|0)==5|(aJ|0)==2)){if((c[aH+204>>2]&3|0)!=0){break}aK=aH+4|0;anY(aK,+g[aH+304>>2],+g[aH+308>>2],+g[aH+312>>2],aH+320|0,e,k);aL=aH+52|0;aM=aL|0;aN=+g[v>>2]- +g[aM>>2];aO=aH+56|0;aP=+g[w>>2]- +g[aO>>2];aQ=aH+60|0;aR=+g[x>>2]- +g[aQ>>2];aS=+g[aH+248>>2];aT=aS*aS;if(!(aT!=0.0&aT<aN*aN+aP*aP+aR*aR)){break}aDo(18080);do{if((c[(c[aH+192>>2]|0)+4>>2]|0)<20){c[9802]=(c[9802]|0)+1;aU=c[z>>2]|0;aV=cA[c[(c[aU>>2]|0)+36>>2]&4095](aU)|0;aU=c[A>>2]|0;g[B>>2]=1.0;b[C>>1]=1;b[D>>1]=-1;c[d>>2]=19448;aW=aL;c[E>>2]=c[aW>>2];c[E+4>>2]=c[aW+4>>2];c[E+8>>2]=c[aW+8>>2];c[E+12>>2]=c[aW+12>>2];c[F>>2]=c[G>>2];c[F+4>>2]=c[G+4>>2];c[F+8>>2]=c[G+8>>2];c[F+12>>2]=c[G+12>>2];c[u>>2]=0;c[d>>2]=19728;c[H>>2]=aI;g[I>>2]=0.0;c[J>>2]=aV;c[K>>2]=aU;aR=+g[aH+244>>2];c[ao>>2]=0;g[ap>>2]=1.0;g[aq>>2]=1.0;g[ar>>2]=1.0;g[as>>2]=0.0;c[L>>2]=25528;c[M>>2]=8;g[N>>2]=aR;g[O>>2]=aR;aU=aH+188|0;b[C>>1]=b[(c[aU>>2]|0)+4>>1]|0;b[D>>1]=b[(c[aU>>2]|0)+6>>1]|0;c[V>>2]=c[G>>2];c[V+4>>2]=c[G+4>>2];c[V+8>>2]=c[G+8>>2];c[V+12>>2]=c[G+12>>2];aV=aK;c[R>>2]=c[aV>>2];c[R+4>>2]=c[aV+4>>2];c[R+8>>2]=c[aV+8>>2];c[R+12>>2]=c[aV+12>>2];aX=aH+20|0;c[S>>2]=c[aX>>2];c[S+4>>2]=c[aX+4>>2];c[S+8>>2]=c[aX+8>>2];c[S+12>>2]=c[aX+12>>2];aY=aH+36|0;c[T>>2]=c[aY>>2];c[T+4>>2]=c[aY+4>>2];c[T+8>>2]=c[aY+8>>2];c[T+12>>2]=c[aY+12>>2];atO(y,W,aK,n,P,0.0);if(+g[B>>2]>=1.0){break}aZ=c[J>>2]|0;a_=cS[c[(c[aZ>>2]|0)+52>>2]&511](aZ,c[aU>>2]|0,c[(c[u>>2]|0)+188>>2]|0)|0;if((a_|0)==0){break}aU=a_+8|0;if((c[aU>>2]|0)==0){break}a[X]=1;c[Y>>2]=0;c[Z>>2]=0;c[_>>2]=0;a_=c[aU>>2]|0;cv[c[(c[a_>>2]|0)+16>>2]&2047](a_,o);do{if((c[Z>>2]|0)!=0){a_=c[u>>2]|0;c[m>>2]=24e3;c[at>>2]=aI;c[au>>2]=a_;aDD(aw|0,-1|0,16);c[av>>2]=c[aV>>2];c[av+4>>2]=c[aV+4>>2];c[av+8>>2]=c[aV+8>>2];c[av+12>>2]=c[aV+12>>2];c[ax>>2]=c[aX>>2];c[ax+4>>2]=c[aX+4>>2];c[ax+8>>2]=c[aX+8>>2];c[ax+12>>2]=c[aX+12>>2];c[ay>>2]=c[aY>>2];c[ay+4>>2]=c[aY+4>>2];c[ay+8>>2]=c[aY+8>>2];c[ay+12>>2]=c[aY+12>>2];c[az>>2]=c[aW>>2];c[az+4>>2]=c[aW+4>>2];c[az+8>>2]=c[aW+8>>2];c[az+12>>2]=c[aW+12>>2];aU=a_+4|0;c[aA>>2]=c[aU>>2];c[aA+4>>2]=c[aU+4>>2];c[aA+8>>2]=c[aU+8>>2];c[aA+12>>2]=c[aU+12>>2];aU=a_+20|0;c[aB>>2]=c[aU>>2];c[aB+4>>2]=c[aU+4>>2];c[aB+8>>2]=c[aU+8>>2];c[aB+12>>2]=c[aU+12>>2];aU=a_+36|0;c[aC>>2]=c[aU>>2];c[aC+4>>2]=c[aU+4>>2];c[aC+8>>2]=c[aU+8>>2];c[aC+12>>2]=c[aU+12>>2];aU=a_+52|0;c[aD>>2]=c[aU>>2];c[aD+4>>2]=c[aU+4>>2];c[aD+8>>2]=c[aU+8>>2];c[aD+12>>2]=c[aU+12>>2];aU=c[c[Y>>2]>>2]|0;c[$>>2]=aU;aR=+g[B>>2];aP=(+g[aa>>2]- +g[aM>>2])*aR;aN=(+g[U>>2]- +g[aO>>2])*aR;aT=aR*(+g[ab>>2]- +g[aQ>>2]);aR=aT*aT+(aP*aP+aN*aN);c[ac>>2]=c[ad>>2];c[ac+4>>2]=c[ad+4>>2];c[ac+8>>2]=c[ad+8>>2];c[ac+12>>2]=c[ad+12>>2];if(aR>1.1920928955078125e-7){aS=+Q(+aR);g[ae>>2]=+g[ae>>2]-aP;g[af>>2]=+g[af>>2]-aN;g[ag>>2]=+g[ag>>2]-aT;a$=aS}else{a$=0.0}if((c[aU+1108>>2]|0)==(aH|0)){aya(p,ah,q,a$);break}else{aS=-0.0- +g[aj>>2];aT=-0.0- +g[ak>>2];g[l>>2]=-0.0- +g[ai>>2];g[al>>2]=aS;g[am>>2]=aT;g[an>>2]=0.0;aya(p,r,q,a$);break}}}while(0);aW=c[Y>>2]|0;if((aW|0)!=0){if((a[X]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[aW-4>>2]|0)}c[Y>>2]=0}a[X]=1;c[Y>>2]=0;c[Z>>2]=0;c[_>>2]=0}}while(0);aQ=c[9152]|0;aO=aQ+16|0;aM=(c[aO>>2]|0)-1|0;c[aO>>2]=aM;if((aM|0)!=0){break}if((c[aQ+4>>2]|0)==0){a0=aQ}else{b3(h|0,0)|0;aM=c[10742]|0;aK=aQ+8|0;g[aK>>2]=+(((c[aF>>2]|0)-(c[aM+4>>2]|0)+(((c[aE>>2]|0)-(c[aM>>2]|0)|0)*1e6|0)-(c[aQ+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[aK>>2];if((c[aO>>2]|0)!=0){break}a0=c[9152]|0}c[9152]=c[a0+20>>2]}}while(0);aG=aG+1|0;}while((aG|0)<(c[s>>2]|0))}s=c[9152]|0;aG=s+16|0;a0=(c[aG>>2]|0)-1|0;c[aG>>2]=a0;if((a0|0)!=0){i=f;return}do{if((c[s+4>>2]|0)==0){a1=s}else{b3(j|0,0)|0;a0=c[10742]|0;aE=s+8|0;g[aE>>2]=+(((c[j+4>>2]|0)-(c[a0+4>>2]|0)+(((c[j>>2]|0)-(c[a0>>2]|0)|0)*1e6|0)-(c[s+12>>2]|0)|0)>>>0>>>0)/1.0e3+ +g[aE>>2];if((c[aG>>2]|0)==0){a1=c[9152]|0;break}else{i=f;return}}}while(0);c[9152]=c[a1+20>>2];i=f;return}function aoR(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=a+12|0;f=c[e>>2]|0;g=c[f+(((d+b|0)/2|0)<<2)>>2]|0;h=g+24|0;i=g+28|0;g=b;j=d;k=f;while(1){f=c[(c[h>>2]|0)+208>>2]|0;l=(f|0)>-1;if(l){m=g;while(1){n=c[k+(m<<2)>>2]|0;o=c[(c[n+24>>2]|0)+208>>2]|0;if((o|0)>-1){p=o}else{p=c[(c[n+28>>2]|0)+208>>2]|0}if((p|0)<(f|0)){m=m+1|0}else{q=m;r=n;break}}}else{m=c[(c[i>>2]|0)+208>>2]|0;n=g;while(1){o=c[k+(n<<2)>>2]|0;s=c[(c[o+24>>2]|0)+208>>2]|0;if((s|0)>-1){t=s}else{t=c[(c[o+28>>2]|0)+208>>2]|0}if((t|0)<(m|0)){n=n+1|0}else{q=n;r=o;break}}}if(l){n=j;while(1){m=c[k+(n<<2)>>2]|0;o=c[(c[m+24>>2]|0)+208>>2]|0;if((o|0)>-1){u=o}else{u=c[(c[m+28>>2]|0)+208>>2]|0}if((f|0)<(u|0)){n=n-1|0}else{v=n;w=m;break}}}else{n=c[(c[i>>2]|0)+208>>2]|0;f=j;while(1){l=c[k+(f<<2)>>2]|0;m=c[(c[l+24>>2]|0)+208>>2]|0;if((m|0)>-1){x=m}else{x=c[(c[l+28>>2]|0)+208>>2]|0}if((n|0)<(x|0)){f=f-1|0}else{v=f;w=l;break}}}if((q|0)>(v|0)){y=q;z=v}else{c[k+(q<<2)>>2]=w;c[(c[e>>2]|0)+(v<<2)>>2]=r;y=q+1|0;z=v-1|0}if((y|0)>(z|0)){break}g=y;j=z;k=c[e>>2]|0}if((z|0)>(b|0)){aoR(a,b,z)}if((y|0)>=(d|0)){return}aoR(a,y,d);return}function aoS(a){a=a|0;if((a|0)==0){return}aDB(a);return}function aoT(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;e=c[d>>2]|0;f=c[a+80>>2]|0;if((e|0)==(f|0)){g=0;return g|0}if((b[a+10>>1]&b[d+4>>1])<<16>>16==0){g=0;return g|0}if((b[d+6>>1]&b[a+8>>1])<<16>>16==0){g=0;return g|0}d=c[a+92>>2]|0;g=cS[c[(c[d>>2]|0)+28>>2]&511](d,f,e)|0;return g|0}function aoU(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0;e=b|0;f=c[e>>2]|0;if((f|0)==(c[a+80>>2]|0)){h=1.0;return+h}if((c[f+204>>2]&4|0)!=0){h=1.0;return+h}f=b+8|0;i=b+12|0;j=b+16|0;if((+g[a+28>>2]- +g[a+12>>2])*+g[f>>2]+(+g[a+32>>2]- +g[a+16>>2])*+g[i>>2]+(+g[a+36>>2]- +g[a+20>>2])*+g[j>>2]>=-0.0- +g[a+84>>2]){h=1.0;return+h}k=b+40|0;g[a+4>>2]=+g[k>>2];l=c[e>>2]|0;c[a+76>>2]=l;if(d){d=a+44|0;e=f;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2]}else{m=+g[b+8>>2];n=+g[i>>2];o=+g[j>>2];p=m*+g[l+20>>2]+n*+g[l+24>>2]+o*+g[l+28>>2];q=m*+g[l+36>>2]+n*+g[l+40>>2]+o*+g[l+44>>2];g[a+44>>2]=+g[l+4>>2]*m+ +g[l+8>>2]*n+ +g[l+12>>2]*o;g[a+48>>2]=p;g[a+52>>2]=q;g[a+56>>2]=0.0}l=a+60|0;a=b+24|0;c[l>>2]=c[a>>2];c[l+4>>2]=c[a+4>>2];c[l+8>>2]=c[a+8>>2];c[l+12>>2]=c[a+12>>2];h=+g[k>>2];return+h}function aoV(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=18656;d=b+76|0;e=b+84|0;f=c[e>>2]|0;g=b+88|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+80>>2]=0;d=b+56|0;e=b+64|0;g=c[e>>2]|0;f=b+68|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-4>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+60>>2]=0;d=b+36|0;e=b+44|0;f=c[e>>2]|0;g=b+48|0;if((f|0)==0){a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+40|0;c[h>>2]=0;return}if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0;a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+40|0;c[h>>2]=0;return}function aoW(a){a=a|0;aoV(a);if((a|0)==0){return}aDB(a);return}function aoX(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;i=c[b+16>>2]|0;if((h|0)<0){if((i|0)==(-g|0)){return}j=c[b+8>>2]|0;k=c[(c[j>>2]|0)+12>>2]|0;l=c[b+12>>2]|0;m=c[b+4>>2]|0;n=c[b+20>>2]|0;o=c[b+24>>2]|0;p=c[b+28>>2]|0;+cN[k&63](j,d,e,f,g,l,i,m,n,o,p);return}p=b+12|0;o=0;while(1){if((o|0)>=(i|0)){q=0;r=0;break}s=c[p>>2]|0;t=s+(o<<2)|0;n=c[t>>2]|0;m=c[(c[n+24>>2]|0)+208>>2]|0;if((m|0)>-1){u=m}else{u=c[(c[n+28>>2]|0)+208>>2]|0}if((u|0)==(h|0)){v=0;w=o;x=3485;break}else{o=o+1|0}}if((x|0)==3485){while(1){x=0;o=c[s+(w<<2)>>2]|0;u=c[(c[o+24>>2]|0)+208>>2]|0;if((u|0)>-1){y=u}else{y=c[(c[o+28>>2]|0)+208>>2]|0}o=((y|0)==(h|0))+v|0;u=w+1|0;if((u|0)<(i|0)){v=o;w=u;x=3485}else{q=o;r=t;break}}}t=b+4|0;x=c[t>>2]|0;if((c[x+68>>2]|0)<2){if((q|0)==(-g|0)){return}w=c[b+8>>2]|0;v=c[(c[w>>2]|0)+12>>2]|0;i=c[b+20>>2]|0;h=c[b+24>>2]|0;y=c[b+28>>2]|0;+cN[v&63](w,d,e,f,g,r,q,x,i,h,y);return}if((e|0)>0){y=b+36|0;h=b+40|0;i=b+44|0;x=b+48|0;w=0;v=c[y>>2]|0;do{s=d+(w<<2)|0;do{if((v|0)==(c[h>>2]|0)){o=(v|0)==0?1:v<<1;if((v|0)>=(o|0)){z=v;break}if((o|0)==0){A=0;B=v}else{c[9806]=(c[9806]|0)+1;u=aDx((o<<2)+19|0)|0;if((u|0)==0){C=0}else{p=-(u+4|0)&15;c[u+p>>2]=u;C=u+(p+4)|0}A=C;B=c[y>>2]|0}if((B|0)>0){p=0;do{u=A+(p<<2)|0;if((u|0)!=0){c[u>>2]=c[(c[i>>2]|0)+(p<<2)>>2]}p=p+1|0;}while((p|0)<(B|0))}p=c[i>>2]|0;if((p|0)!=0){if((a[x]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-4>>2]|0)}c[i>>2]=0}a[x]=1;c[i>>2]=A;c[h>>2]=o;z=c[y>>2]|0}else{z=v}}while(0);p=(c[i>>2]|0)+(z<<2)|0;if((p|0)==0){D=z}else{c[p>>2]=c[s>>2];D=c[y>>2]|0}v=D+1|0;c[y>>2]=v;w=w+1|0;}while((w|0)<(e|0))}if((g|0)>0){e=b+56|0;w=b+60|0;v=b+64|0;y=b+68|0;D=0;z=c[e>>2]|0;do{i=f+(D<<2)|0;do{if((z|0)==(c[w>>2]|0)){h=(z|0)==0?1:z<<1;if((z|0)>=(h|0)){E=z;break}if((h|0)==0){F=0;G=z}else{c[9806]=(c[9806]|0)+1;A=aDx((h<<2)+19|0)|0;if((A|0)==0){H=0}else{x=-(A+4|0)&15;c[A+x>>2]=A;H=A+(x+4)|0}F=H;G=c[e>>2]|0}if((G|0)>0){x=0;do{A=F+(x<<2)|0;if((A|0)!=0){c[A>>2]=c[(c[v>>2]|0)+(x<<2)>>2]}x=x+1|0;}while((x|0)<(G|0))}x=c[v>>2]|0;if((x|0)!=0){if((a[y]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[x-4>>2]|0)}c[v>>2]=0}a[y]=1;c[v>>2]=F;c[w>>2]=h;E=c[e>>2]|0}else{E=z}}while(0);s=(c[v>>2]|0)+(E<<2)|0;if((s|0)==0){I=E}else{c[s>>2]=c[i>>2];I=c[e>>2]|0}z=I+1|0;c[e>>2]=z;D=D+1|0;}while((D|0)<(g|0))}g=b+76|0;if((q|0)>0){D=b+80|0;z=b+84|0;e=b+88|0;I=0;E=c[g>>2]|0;while(1){v=r+(I<<2)|0;do{if((E|0)==(c[D>>2]|0)){w=(E|0)==0?1:E<<1;if((E|0)>=(w|0)){J=E;break}if((w|0)==0){K=0;L=E}else{c[9806]=(c[9806]|0)+1;F=aDx((w<<2)+19|0)|0;if((F|0)==0){M=0}else{y=-(F+4|0)&15;c[F+y>>2]=F;M=F+(y+4)|0}K=M;L=c[g>>2]|0}if((L|0)>0){y=0;do{F=K+(y<<2)|0;if((F|0)!=0){c[F>>2]=c[(c[z>>2]|0)+(y<<2)>>2]}y=y+1|0;}while((y|0)<(L|0))}y=c[z>>2]|0;if((y|0)!=0){if((a[e]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[y-4>>2]|0)}c[z>>2]=0}a[e]=1;c[z>>2]=K;c[D>>2]=w;J=c[g>>2]|0}else{J=E}}while(0);i=(c[z>>2]|0)+(J<<2)|0;if((i|0)==0){N=J}else{c[i>>2]=c[v>>2];N=c[g>>2]|0}i=N+1|0;c[g>>2]=i;y=I+1|0;if((y|0)<(q|0)){I=y;E=i}else{O=i;break}}}else{O=c[g>>2]|0}if(((c[b+56>>2]|0)+O|0)<=(c[(c[t>>2]|0)+68>>2]|0)){return}aoE(b);return}function aoY(b,d,e,f,h,i){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;var j=0,k=0;c[b+4>>2]=6;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3.4028234663852886e+38;a[b+20|0]=1;a[b+21|0]=0;c[b+24>>2]=d;c[b+28>>2]=e;g[b+32>>2]=0.0;g[b+36>>2]=.30000001192092896;c[b>>2]=21400;j=b+40|0;k=f;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=b+56|0;j=f+16|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];j=b+72|0;k=f+32|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=b+88|0;j=f+48|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];j=b+104|0;k=h;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=b+120|0;j=h+16|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];j=b+136|0;k=h+32|0;c[j>>2]=c[k>>2];c[j+4>>2]=c[k+4>>2];c[j+8>>2]=c[k+8>>2];c[j+12>>2]=c[k+12>>2];k=b+152|0;j=h+48|0;c[k>>2]=c[j>>2];c[k+4>>2]=c[j+4>>2];c[k+8>>2]=c[j+8>>2];c[k+12>>2]=c[j+12>>2];aDD(b+672|0,0,48);aDD(b+732|0,0,16);g[b+748>>2]=.20000000298023224;g[b+752>>2]=.20000000298023224;g[b+756>>2]=.20000000298023224;aDD(b+760|0,0,20);g[b+720>>2]=.699999988079071;g[b+724>>2]=1.0;g[b+728>>2]=.5;a[b+780|0]=0;g[b+784>>2]=0.0;g[b+800>>2]=0.0;a[b+781|0]=0;g[b+788>>2]=0.0;g[b+804>>2]=0.0;a[b+782|0]=0;g[b+792>>2]=0.0;g[b+808>>2]=0.0;g[b+920>>2]=0.0;g[b+868>>2]=0.0;g[b+872>>2]=.10000000149011612;g[b+876>>2]=300.0;g[b+860>>2]=1.0;g[b+864>>2]=-1.0;g[b+888>>2]=0.0;g[b+892>>2]=.20000000298023224;g[b+896>>2]=0.0;g[b+900>>2]=0.0;g[b+880>>2]=1.0;g[b+884>>2]=.5;c[b+916>>2]=0;g[b+908>>2]=0.0;a[b+904|0]=0;g[b+984>>2]=0.0;g[b+932>>2]=0.0;g[b+936>>2]=.10000000149011612;g[b+940>>2]=300.0;g[b+924>>2]=1.0;g[b+928>>2]=-1.0;g[b+952>>2]=0.0;g[b+956>>2]=.20000000298023224;g[b+960>>2]=0.0;g[b+964>>2]=0.0;g[b+944>>2]=1.0;g[b+948>>2]=.5;c[b+980>>2]=0;g[b+972>>2]=0.0;a[b+968|0]=0;g[b+1048>>2]=0.0;g[b+996>>2]=0.0;g[b+1e3>>2]=.10000000149011612;g[b+1004>>2]=300.0;g[b+988>>2]=1.0;g[b+992>>2]=-1.0;g[b+1016>>2]=0.0;g[b+1020>>2]=.20000000298023224;g[b+1024>>2]=0.0;g[b+1028>>2]=0.0;g[b+1008>>2]=1.0;g[b+1012>>2]=.5;c[b+1044>>2]=0;g[b+1036>>2]=0.0;a[b+1032|0]=0;a[b+1292|0]=i&1;a[b+1293|0]=1;c[b+1296>>2]=0;a[b+1300|0]=0;aoZ(b,d+4|0,e+4|0);return}function aoZ(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0.0;f=i;i=i+224|0;h=f|0;j=f+48|0;k=f+96|0;l=f+160|0;m=b+1056|0;n=j;anx(j,d|0,b+40|0);o=+g[b+88>>2];p=+g[b+92>>2];q=+g[b+96>>2];r=+g[d>>2]*o+ +g[d+4>>2]*p+ +g[d+8>>2]*q+ +g[d+48>>2];s=+g[d+16>>2]*o+ +g[d+20>>2]*p+ +g[d+24>>2]*q+ +g[d+52>>2];t=+g[d+32>>2]*o+ +g[d+36>>2]*p+ +g[d+40>>2]*q+ +g[d+56>>2];d=k+48|0;u=k|0;do{u=u+16|0;}while((u|0)!=(d|0));d=k;c[d>>2]=c[n>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];n=k+16|0;u=j+16|0;c[n>>2]=c[u>>2];c[n+4>>2]=c[u+4>>2];c[n+8>>2]=c[u+8>>2];c[n+12>>2]=c[u+12>>2];u=k+32|0;v=j+32|0;c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[u+12>>2]=c[v+12>>2];g[k+48>>2]=r;g[k+52>>2]=s;g[k+56>>2]=t;g[k+60>>2]=0.0;v=m;c[v>>2]=c[d>>2];c[v+4>>2]=c[d+4>>2];c[v+8>>2]=c[d+8>>2];c[v+12>>2]=c[d+12>>2];d=b+1072|0;c[d>>2]=c[n>>2];c[d+4>>2]=c[n+4>>2];c[d+8>>2]=c[n+8>>2];c[d+12>>2]=c[n+12>>2];n=b+1088|0;c[n>>2]=c[u>>2];c[n+4>>2]=c[u+4>>2];c[n+8>>2]=c[u+8>>2];c[n+12>>2]=c[u+12>>2];u=b+1104|0;n=k+48|0;c[u>>2]=c[n>>2];c[u+4>>2]=c[n+4>>2];c[u+8>>2]=c[n+8>>2];c[u+12>>2]=c[n+12>>2];n=b+1120|0;u=h;anx(h,e|0,b+104|0);t=+g[b+152>>2];s=+g[b+156>>2];r=+g[b+160>>2];q=+g[e>>2]*t+ +g[e+4>>2]*s+ +g[e+8>>2]*r+ +g[e+48>>2];p=+g[e+16>>2]*t+ +g[e+20>>2]*s+ +g[e+24>>2]*r+ +g[e+52>>2];o=+g[e+32>>2]*t+ +g[e+36>>2]*s+ +g[e+40>>2]*r+ +g[e+56>>2];e=l+48|0;k=l|0;do{k=k+16|0;}while((k|0)!=(e|0));e=l;c[e>>2]=c[u>>2];c[e+4>>2]=c[u+4>>2];c[e+8>>2]=c[u+8>>2];c[e+12>>2]=c[u+12>>2];u=l+16|0;k=h+16|0;c[u>>2]=c[k>>2];c[u+4>>2]=c[k+4>>2];c[u+8>>2]=c[k+8>>2];c[u+12>>2]=c[k+12>>2];k=l+32|0;d=h+32|0;c[k>>2]=c[d>>2];c[k+4>>2]=c[d+4>>2];c[k+8>>2]=c[d+8>>2];c[k+12>>2]=c[d+12>>2];g[l+48>>2]=q;g[l+52>>2]=p;g[l+56>>2]=o;g[l+60>>2]=0.0;d=n;c[d>>2]=c[e>>2];c[d+4>>2]=c[e+4>>2];c[d+8>>2]=c[e+8>>2];c[d+12>>2]=c[e+12>>2];e=b+1136|0;c[e>>2]=c[u>>2];c[e+4>>2]=c[u+4>>2];c[e+8>>2]=c[u+8>>2];c[e+12>>2]=c[u+12>>2];u=b+1152|0;c[u>>2]=c[k>>2];c[u+4>>2]=c[k+4>>2];c[u+8>>2]=c[k+8>>2];c[u+12>>2]=c[k+12>>2];k=b+1168|0;u=l+48|0;c[k>>2]=c[u>>2];c[k+4>>2]=c[u+4>>2];c[k+8>>2]=c[u+8>>2];c[k+12>>2]=c[u+12>>2];o=+g[b+1168>>2]- +g[b+1104>>2];p=+g[b+1172>>2]- +g[b+1108>>2];q=+g[b+1176>>2]- +g[b+1112>>2];r=+g[b+1076>>2];s=+g[b+1096>>2];t=+g[b+1080>>2];w=+g[b+1092>>2];x=r*s-t*w;y=+g[b+1088>>2];z=+g[b+1072>>2];A=t*y-s*z;B=w*z-r*y;C=+g[b+1056>>2];D=+g[b+1060>>2];E=+g[b+1064>>2];F=1.0/(x*C+D*A+B*E);G=x*F;x=F*(w*E-s*D);H=F*(t*D-r*E);I=A*F;A=F*(s*C-y*E);J=F*(z*E-t*C);K=B*F;B=F*(y*D-w*C);w=F*(r*C-z*D);D=G*o+x*p+H*q;z=o*I+p*A+J*q;C=o*K+B*p+w*q;g[b+1248>>2]=D;g[b+1252>>2]=z;g[b+1256>>2]=C;g[b+1260>>2]=0.0;g[b+832>>2]=D;q=+g[b+672>>2];p=+g[b+688>>2];do{if(q>p){c[b+848>>2]=0;g[b+816>>2]=0.0}else{if(q>D){c[b+848>>2]=2;g[b+816>>2]=D-q;break}u=b+848|0;if(p<D){c[u>>2]=1;g[b+816>>2]=D-p;break}else{c[u>>2]=0;g[b+816>>2]=0.0;break}}}while(0);g[b+836>>2]=z;p=+g[b+676>>2];D=+g[b+692>>2];do{if(p>D){c[b+852>>2]=0;g[b+820>>2]=0.0}else{if(p>z){c[b+852>>2]=2;g[b+820>>2]=z-p;break}u=b+852|0;if(D<z){c[u>>2]=1;g[b+820>>2]=z-D;break}else{c[u>>2]=0;g[b+820>>2]=0.0;break}}}while(0);g[b+840>>2]=C;D=+g[b+680>>2];z=+g[b+696>>2];do{if(D>z){c[b+856>>2]=0;g[b+824>>2]=0.0}else{if(D>C){c[b+856>>2]=2;g[b+824>>2]=C-D;break}u=b+856|0;if(z<C){c[u>>2]=1;g[b+824>>2]=C-z;break}else{c[u>>2]=0;g[b+824>>2]=0.0;break}}}while(0);z=+g[b+1120>>2];C=+g[b+1136>>2];D=+g[b+1152>>2];p=z*G+C*x+H*D;q=+g[b+1124>>2];o=+g[b+1140>>2];r=+g[b+1156>>2];F=G*q+x*o+H*r;H=z*I+C*A+J*D;x=I*q+A*o+J*r;J=z*K+B*C+w*D;A=K*q+B*o+w*r;r=K*+g[b+1128>>2]+B*+g[b+1144>>2]+w*+g[b+1160>>2];u=b+1184|0;do{if(J<1.0){if(J>-1.0){g[u>>2]=+Y(+(-0.0-A),+r);w=J<-1.0?-1.0:J;g[b+1188>>2]=+W(+(w>1.0?1.0:w));g[b+1192>>2]=+Y(+(-0.0-H),+p);break}else{g[u>>2]=-0.0- +Y(+F,+x);g[b+1188>>2]=-1.5707963705062866;g[b+1192>>2]=0.0;break}}else{g[u>>2]=+Y(+F,+x);g[b+1188>>2]=1.5707963705062866;g[b+1192>>2]=0.0}}while(0);x=D*t-C*s;F=z*s-D*E;p=C*E-z*t;g[b+1228>>2]=0.0;H=s*F-t*p;J=E*p-s*x;s=t*x-E*F;g[b+1212>>2]=0.0;E=C*p-D*F;t=D*x-z*p;D=z*F-C*x;g[b+1244>>2]=0.0;C=1.0/+Q(+(H*H+J*J+s*s));g[b+1200>>2]=H*C;g[b+1204>>2]=J*C;g[b+1208>>2]=s*C;C=1.0/+Q(+(x*x+F*F+p*p));g[b+1216>>2]=x*C;g[b+1220>>2]=F*C;g[b+1224>>2]=p*C;C=1.0/+Q(+(E*E+t*t+D*D));g[b+1232>>2]=E*C;g[b+1236>>2]=t*C;g[b+1240>>2]=D*C;if((a[b+1293|0]&1)==0){i=f;return}C=+g[(c[b+24>>2]|0)+336>>2];D=+g[(c[b+28>>2]|0)+336>>2];if(C<1.1920928955078125e-7){L=1}else{L=D<1.1920928955078125e-7|0}a[b+1272|0]=L;t=C+D;if(t>0.0){C=D/t;g[b+1264>>2]=C;M=C}else{g[b+1264>>2]=.5;M=.5}g[b+1268>>2]=1.0-M;i=f;return}function ao_(a,b,d,e,f,h,j,k,l){a=a|0;b=b|0;d=d|0;e=+e;f=+f;h=+h;j=+j;k=+k;l=+l;var m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0.0;m=i;i=i+128|0;n=m|0;o=m+48|0;p=m+96|0;q=m+112|0;if((b|0)==0){i=m;return}r=c[a+24>>2]|0;g[n>>2]=+g[r+4>>2];g[n+4>>2]=+g[r+20>>2];g[n+8>>2]=+g[r+36>>2];g[n+12>>2]=0.0;g[n+16>>2]=+g[r+8>>2];g[n+20>>2]=+g[r+24>>2];g[n+24>>2]=+g[r+40>>2];g[n+28>>2]=0.0;g[n+32>>2]=+g[r+12>>2];g[n+36>>2]=+g[r+28>>2];g[n+40>>2]=+g[r+44>>2];g[n+44>>2]=0.0;s=c[a+28>>2]|0;g[o>>2]=+g[s+4>>2];g[o+4>>2]=+g[s+20>>2];g[o+8>>2]=+g[s+36>>2];g[o+12>>2]=0.0;g[o+16>>2]=+g[s+8>>2];g[o+20>>2]=+g[s+24>>2];g[o+24>>2]=+g[s+40>>2];g[o+28>>2]=0.0;g[o+32>>2]=+g[s+12>>2];g[o+36>>2]=+g[s+28>>2];g[o+40>>2]=+g[s+44>>2];g[o+44>>2]=0.0;t=f- +g[r+56>>2];f=h- +g[r+60>>2];g[p>>2]=e- +g[r+52>>2];g[p+4>>2]=t;g[p+8>>2]=f;g[p+12>>2]=0.0;f=k- +g[s+56>>2];k=l- +g[s+60>>2];g[q>>2]=j- +g[s+52>>2];g[q+4>>2]=f;g[q+8>>2]=k;g[q+12>>2]=0.0;anz(b,n,o,p,q,d,r+388|0,+g[r+336>>2],s+388|0,+g[s+336>>2]);i=m;return}function ao$(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0,k=0,l=0;e=b+860+(d<<6)|0;f=b+860+(d<<6)+4|0;h=+ao0(+g[b+1184+(d<<2)>>2],+g[e>>2],+g[f>>2]);g[b+860+(d<<6)+52>>2]=h;i=+g[e>>2];j=+g[f>>2];do{if(i>j){c[b+860+(d<<6)+56>>2]=0;k=3614}else{if(i>h){c[b+860+(d<<6)+56>>2]=1;g[b+860+(d<<6)+48>>2]=h-i;break}f=b+860+(d<<6)+56|0;if(j<h){c[f>>2]=2;g[b+860+(d<<6)+48>>2]=h-j;break}else{c[f>>2]=0;k=3614;break}}}while(0);do{if((k|0)==3614){if((a[b+860+(d<<6)+44|0]&1)==0){l=0}else{break}return l|0}}while(0);l=1;return l|0}function ao0(a,b,c){a=+a;b=+b;c=+c;var d=0.0,e=0.0,f=0.0,g=0.0,h=0.0,i=0.0;if(b>=c){d=a;return+d}if(a<b){e=+ck(+(b-a),6.2831854820251465);do{if(e<-3.1415927410125732){f=e+6.2831854820251465}else{if(e<=3.1415927410125732){f=e;break}f=e-6.2831854820251465}}while(0);e=+P(+f);f=+ck(+(c-a),6.2831854820251465);do{if(f<-3.1415927410125732){g=f+6.2831854820251465}else{if(f<=3.1415927410125732){g=f;break}g=f-6.2831854820251465}}while(0);if(e<+P(+g)){d=a;return+d}d=a+6.2831854820251465;return+d}if(a<=c){d=a;return+d}g=+ck(+(a-c),6.2831854820251465);do{if(g<-3.1415927410125732){h=g+6.2831854820251465}else{if(g<=3.1415927410125732){h=g;break}h=g-6.2831854820251465}}while(0);g=+P(+h);h=+ck(+(a-b),6.2831854820251465);do{if(h<-3.1415927410125732){i=h+6.2831854820251465}else{if(h<=3.1415927410125732){i=h;break}i=h-6.2831854820251465}}while(0);if(+P(+i)>=g){d=a;return+d}d=a-6.2831854820251465;return+d}function ao1(b){b=b|0;var d=0,e=0,f=0,h=0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0.0,v=0.0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0;d=i;i=i+16|0;e=d|0;if((a[b+1300|0]&1)==0){i=d;return}g[b+920>>2]=0.0;g[b+984>>2]=0.0;g[b+1048>>2]=0.0;f=b+24|0;aDD(b+704|0,0,16);h=b+28|0;aoZ(b,(c[f>>2]|0)+4|0,(c[h>>2]|0)+4|0);ct[c[(c[b>>2]|0)+44>>2]&2047](b);j=+g[b+1276>>2];k=+g[b+1280>>2];l=+g[b+1284>>2];m=b+1292|0;n=e|0;o=e+4|0;p=e+8|0;q=e+12|0;if(+g[b+688>>2]>=+g[b+672>>2]){if((a[m]&1)==0){r=b+1152|0;s=b+1136|0;t=b+1120|0}else{r=b+1088|0;s=b+1072|0;t=b+1056|0}u=+g[r>>2];v=+g[s>>2];g[n>>2]=+g[t>>2];g[o>>2]=v;g[p>>2]=u;g[q>>2]=0.0;ao_(b,b+168|0,e,j,k,l,j,k,l)}if(+g[b+692>>2]>=+g[b+676>>2]){if((a[m]&1)==0){w=b+1156|0;x=b+1140|0;y=b+1124|0}else{w=b+1092|0;x=b+1076|0;y=b+1060|0}u=+g[w>>2];v=+g[x>>2];g[n>>2]=+g[y>>2];g[o>>2]=v;g[p>>2]=u;g[q>>2]=0.0;ao_(b,b+252|0,e,j,k,l,j,k,l)}if(+g[b+696>>2]>=+g[b+680>>2]){if((a[m]&1)==0){z=b+1160|0;A=b+1144|0;B=b+1128|0}else{z=b+1096|0;A=b+1080|0;B=b+1064|0}u=+g[z>>2];v=+g[A>>2];g[n>>2]=+g[B>>2];g[o>>2]=v;g[p>>2]=u;g[q>>2]=0.0;ao_(b,b+336|0,e,j,k,l,j,k,l)}q=e;e=0;do{B=b+860+(e<<6)|0;A=b+860+(e<<6)+4|0;l=+ao0(+g[b+1184+(e<<2)>>2],+g[B>>2],+g[A>>2]);g[b+860+(e<<6)+52>>2]=l;k=+g[B>>2];j=+g[A>>2];do{if(k>j){c[b+860+(e<<6)+56>>2]=0;C=3663}else{if(k>l){c[b+860+(e<<6)+56>>2]=1;g[b+860+(e<<6)+48>>2]=l-k;C=3664;break}A=b+860+(e<<6)+56|0;if(j<l){c[A>>2]=2;g[b+860+(e<<6)+48>>2]=l-j;C=3664;break}else{c[A>>2]=0;C=3663;break}}}while(0);if((C|0)==3663){C=0;if((a[b+860+(e<<6)+44|0]&1)!=0){C=3664}}do{if((C|0)==3664){C=0;A=b+1200+(e<<4)|0;c[q>>2]=c[A>>2];c[q+4>>2]=c[A+4>>2];c[q+8>>2]=c[A+8>>2];c[q+12>>2]=c[A+12>>2];A=b+420+(e*84|0)|0;if((A|0)==0){break}B=c[f>>2]|0;j=+g[B+4>>2];l=+g[B+20>>2];k=+g[B+36>>2];u=+g[B+8>>2];v=+g[B+24>>2];D=+g[B+40>>2];E=+g[B+12>>2];F=+g[B+28>>2];G=+g[B+44>>2];z=c[h>>2]|0;H=+g[z+4>>2];I=+g[z+20>>2];J=+g[z+36>>2];K=+g[z+8>>2];L=+g[z+24>>2];M=+g[z+40>>2];N=+g[z+12>>2];O=+g[z+28>>2];P=+g[z+44>>2];aDD(A|0,0,16);Q=+g[n>>2];R=+g[o>>2];S=+g[p>>2];T=j*Q+l*R+k*S;k=u*Q+v*R+D*S;D=E*Q+F*R+G*S;g[b+420+(e*84|0)+16>>2]=T;g[b+420+(e*84|0)+20>>2]=k;g[b+420+(e*84|0)+24>>2]=D;g[b+420+(e*84|0)+28>>2]=0.0;G=-0.0-Q;Q=-0.0-R;R=-0.0-S;S=H*G+I*Q+J*R;J=K*G+L*Q+M*R;M=N*G+O*Q+P*R;g[b+420+(e*84|0)+32>>2]=S;g[b+420+(e*84|0)+36>>2]=J;g[b+420+(e*84|0)+40>>2]=M;g[b+420+(e*84|0)+44>>2]=0.0;R=T*+g[B+388>>2];P=k*+g[B+392>>2];Q=D*+g[B+396>>2];g[b+420+(e*84|0)+48>>2]=R;g[b+420+(e*84|0)+52>>2]=P;g[b+420+(e*84|0)+56>>2]=Q;g[b+420+(e*84|0)+60>>2]=0.0;O=S*+g[z+388>>2];G=J*+g[z+392>>2];N=M*+g[z+396>>2];g[b+420+(e*84|0)+64>>2]=O;g[b+420+(e*84|0)+68>>2]=G;g[b+420+(e*84|0)+72>>2]=N;g[b+420+(e*84|0)+76>>2]=0.0;g[b+420+(e*84|0)+80>>2]=T*R+k*P+D*Q+(S*O+J*G+M*N)}}while(0);e=e+1|0;}while((e|0)<3);i=d;return}function ao2(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0;if((a[b+1300|0]&1)!=0){c[d>>2]=0;c[d+4>>2]=0;return}aoZ(b,(c[b+24>>2]|0)+4|0,(c[b+28>>2]|0)+4|0);e=d|0;c[e>>2]=0;f=d+4|0;c[f>>2]=6;if((c[b+848>>2]|0)==0){if((a[b+780|0]&1)==0){h=0;i=6}else{j=3684}}else{j=3684}if((j|0)==3684){c[e>>2]=1;c[f>>2]=5;h=1;i=5}if((c[b+852>>2]|0)==0){if((a[b+781|0]&1)==0){k=h;l=i}else{j=3698}}else{j=3698}if((j|0)==3698){d=h+1|0;c[e>>2]=d;h=i-1|0;c[f>>2]=h;k=d;l=h}if((c[b+856>>2]|0)==0){if((a[b+782|0]&1)==0){m=0}else{j=3701}}else{j=3701}if((j|0)==3701){c[e>>2]=k+1;c[f>>2]=l-1;m=0}do{l=b+860+(m<<6)|0;k=b+860+(m<<6)+4|0;n=+ao0(+g[b+1184+(m<<2)>>2],+g[l>>2],+g[k>>2]);g[b+860+(m<<6)+52>>2]=n;o=+g[l>>2];p=+g[k>>2];do{if(o>p){c[b+860+(m<<6)+56>>2]=0;j=3693}else{if(o>n){c[b+860+(m<<6)+56>>2]=1;g[b+860+(m<<6)+48>>2]=n-o;j=3694;break}k=b+860+(m<<6)+56|0;if(p<n){c[k>>2]=2;g[b+860+(m<<6)+48>>2]=n-p;j=3694;break}else{c[k>>2]=0;j=3693;break}}}while(0);if((j|0)==3693){j=0;if((a[b+860+(m<<6)+44|0]&1)!=0){j=3694}}if((j|0)==3694){j=0;c[e>>2]=(c[e>>2]|0)+1;c[f>>2]=(c[f>>2]|0)-1}m=m+1|0;}while((m|0)<3);return}function ao3(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=c[b+24>>2]|0;f=e+4|0;g=c[b+28>>2]|0;h=g+4|0;i=e+304|0;j=g+304|0;k=e+320|0;e=g+320|0;if((a[b+1293|0]&1)==0){g=ao5(b,d,0,f,h,i,j,k,e)|0;ao4(b,d,g,f,h,i,j,k,e)|0;return}else{g=ao4(b,d,0,f,h,i,j,k,e)|0;ao5(b,d,g,f,h,i,j,k,e)|0;return}}function ao4(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;n=i;i=i+16|0;o=n|0;p=o;q=b+1296|0;r=d+32|0;s=d+4|0;t=0;u=e;while(1){e=b+860+(t<<6)|0;if((c[b+860+(t<<6)+56>>2]|0)==0){if((a[b+860+(t<<6)+44|0]&1)==0){v=u}else{w=3713}}else{w=3713}if((w|0)==3713){w=0;x=b+1200+(t<<4)|0;c[p>>2]=c[x>>2];c[p+4>>2]=c[x+4>>2];c[p+8>>2]=c[x+8>>2];c[p+12>>2]=c[x+12>>2];x=c[q>>2]>>(t*3|0)+9;if((x&1|0)==0){g[b+860+(t<<6)+28>>2]=+g[c[r>>2]>>2]}if((x&2|0)==0){g[b+860+(t<<6)+36>>2]=+g[c[r>>2]>>2]}if((x&4|0)==0){g[b+860+(t<<6)+32>>2]=+g[s>>2]}v=(ao7(b,e,f,h,j,k,l,m,d,u,o,1,0)|0)+u|0}e=t+1|0;if((e|0)<3){t=e;u=v}else{break}}i=n;return v|0}function ao5(b,d,e,f,h,j,k,l,m){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;k=k|0;l=l|0;m=m|0;var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0;n=i;i=i+80|0;o=n|0;p=n+64|0;g[o+60>>2]=0.0;q=o+8|0;g[q>>2]=0.0;r=o+12|0;g[r>>2]=.10000000149011612;s=o+16|0;g[s>>2]=300.0;t=o|0;g[t>>2]=1.0;u=o+4|0;g[u>>2]=-1.0;v=o+28|0;g[v>>2]=0.0;w=o+32|0;g[w>>2]=.20000000298023224;x=o+36|0;g[x>>2]=0.0;y=o+40|0;g[y>>2]=0.0;z=o+20|0;g[z>>2]=1.0;A=o+24|0;g[A>>2]=.5;B=o+56|0;c[B>>2]=0;C=o+48|0;g[C>>2]=0.0;D=o+44|0;a[D]=0;E=o+52|0;F=b+724|0;G=b+720|0;H=p|0;I=p+4|0;J=p+8|0;K=p+12|0;L=b+1296|0;M=d+32|0;N=d+4|0;O=b+1293|0;P=0;Q=e;while(1){e=c[b+848+(P<<2)>>2]|0;R=a[b+780+P|0]&1;do{if((e|0)==0&R<<24>>24==0){S=Q}else{g[y>>2]=0.0;c[B>>2]=e;g[E>>2]=+g[b+832+(P<<2)>>2];g[C>>2]=+g[b+816+(P<<2)>>2];g[z>>2]=+g[F>>2];a[D]=R;g[u>>2]=+g[b+688+(P<<2)>>2];g[A>>2]=+g[G>>2];g[t>>2]=+g[b+672+(P<<2)>>2];g[s>>2]=0.0;g[r>>2]=+g[b+800+(P<<2)>>2];g[q>>2]=+g[b+784+(P<<2)>>2];g[H>>2]=+g[b+1056+(P<<2)>>2];g[I>>2]=+g[b+1072+(P<<2)>>2];g[J>>2]=+g[b+1088+(P<<2)>>2];g[K>>2]=0.0;T=c[L>>2]>>(P*3|0);if((T&1|0)==0){U=c[M>>2]|0}else{U=b+732+(P<<2)|0}g[v>>2]=+g[U>>2];if((T&2|0)==0){V=c[M>>2]|0}else{V=b+764+(P<<2)|0}g[x>>2]=+g[V>>2];if((T&4|0)==0){W=N}else{W=b+748+(P<<2)|0}g[w>>2]=+g[W>>2];if((a[O]&1)==0){S=(ao7(b,o,f,h,j,k,l,m,d,Q,p,0,0)|0)+Q|0;break}T=P+1|0;if((c[b+860+(((T|0)==3?0:T)<<6)+56>>2]|0)==0){X=1}else{X=(c[b+860+(((P+2|0)%3|0)<<6)+56>>2]|0)==0|0}S=(ao7(b,o,f,h,j,k,l,m,d,Q,p,0,X)|0)+Q|0}}while(0);R=P+1|0;if((R|0)<3){P=R;Q=S}else{break}}i=n;return S|0}function ao6(a){a=a|0;return}function ao7(b,d,e,f,h,i,j,k,l,m,n,o,p){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;l=l|0;m=m|0;n=n|0;o=o|0;p=p|0;var q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0,D=0.0,E=0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,ab=0,ac=0,ad=0.0,ae=0.0,af=0.0;q=aa(c[l+24>>2]|0,m)|0;m=(a[d+44|0]&1)==0;r=c[d+56>>2]|0;if(m&(r|0)==0){s=0;return s|0}t=(o|0)!=0;o=l+12|0;u=c[(t?o:l+8|0)>>2]|0;if(t){v=c[l+20>>2]|0}else{v=0}w=n|0;g[u+(q<<2)>>2]=+g[w>>2];x=n+4|0;y=q+1|0;g[u+(y<<2)>>2]=+g[x>>2];z=n+8|0;n=q+2|0;g[u+(n<<2)>>2]=+g[z>>2];do{if(t){g[v+(q<<2)>>2]=-0.0- +g[w>>2];g[v+(y<<2)>>2]=-0.0- +g[x>>2];g[v+(n<<2)>>2]=-0.0- +g[z>>2]}else{u=b+1168|0;A=+g[u>>2];if((a[b+1293|0]&1)==0){B=A- +g[e+48>>2];C=b+1172|0;D=+g[C>>2]- +g[e+52>>2];E=b+1176|0;F=+g[E>>2]- +g[e+56>>2];G=+g[z>>2];H=+g[x>>2];I=+g[w>>2];g[(c[o>>2]|0)+(q<<2)>>2]=D*G-F*H;g[(c[o>>2]|0)+(y<<2)>>2]=F*I-B*G;g[(c[o>>2]|0)+(n<<2)>>2]=B*H-D*I;I=+g[u>>2]- +g[f+48>>2];D=+g[C>>2]- +g[f+52>>2];H=+g[E>>2]- +g[f+56>>2];B=+g[z>>2];G=+g[x>>2];F=+g[w>>2];E=l+20|0;g[(c[E>>2]|0)+(q<<2)>>2]=-0.0-(D*B-H*G);g[(c[E>>2]|0)+(y<<2)>>2]=-0.0-(H*F-I*B);g[(c[E>>2]|0)+(n<<2)>>2]=-0.0-(I*G-D*F);break}F=A- +g[f+48>>2];A=+g[b+1172>>2]- +g[f+52>>2];D=+g[b+1176>>2]- +g[f+56>>2];G=+g[w>>2];I=+g[x>>2];B=+g[z>>2];H=F*G+A*I+D*B;J=G*H;K=I*H;L=B*H;H=+g[b+1104>>2]- +g[e+48>>2];M=+g[b+1108>>2]- +g[e+52>>2];N=+g[b+1112>>2]- +g[e+56>>2];O=G*H+I*M+B*N;P=G*O;Q=I*O;R=B*O;O=+g[d+52>>2]- +g[d+48>>2];S=P+G*O-J;T=Q+I*O-K;U=R+B*O-L;O=+g[b+1264>>2];V=H-P+O*S;P=M-Q+O*T;Q=N-R+O*U;R=+g[b+1268>>2];N=F-J-R*S;S=A-K-R*T;T=D-L-R*U;U=B*P-I*Q;L=G*Q-B*V;Q=I*V-G*P;P=B*S-I*T;V=G*T-B*N;B=I*N-G*S;if((a[b+1272|0]&1)!=0&(p|0)==0){W=O*U;X=O*L;Y=O*Q;Z=R*P;_=R*V;$=R*B}else{W=U;X=L;Y=Q;Z=P;_=V;$=B}g[(c[o>>2]|0)+(q<<2)>>2]=W;g[(c[o>>2]|0)+(y<<2)>>2]=X;g[(c[o>>2]|0)+(n<<2)>>2]=Y;E=l+20|0;g[(c[E>>2]|0)+(q<<2)>>2]=-0.0-Z;g[(c[E>>2]|0)+(y<<2)>>2]=-0.0-_;g[(c[E>>2]|0)+(n<<2)>>2]=-0.0-$}}while(0);n=(r|0)!=0;do{if(n){if(+g[d>>2]!=+g[d+4>>2]){ab=3753;break}y=l+28|0;g[(c[y>>2]|0)+(q<<2)>>2]=0.0;ac=y}else{ab=3753}}while(0);do{if((ab|0)==3753){y=l+28|0;g[(c[y>>2]|0)+(q<<2)>>2]=0.0;if(!m){g[(c[l+32>>2]|0)+(q<<2)>>2]=+g[d+28>>2];if(n){ac=y;break}$=+g[d+8>>2];if(t){ad=$}else{ad=-0.0-$}_=+g[d+52>>2];Z=+g[d>>2];Y=+g[d+4>>2];X=+g[l>>2]*+g[d+32>>2];L4236:do{if(Z>Y){ae=1.0}else{if(Z==Y){ae=0.0;break}W=ad/X;if(W<0.0){do{if(_>=Z){if(Z-W<=_){break}ae=(Z-_)/W;break L4236}}while(0);ae=_<Z?0.0:1.0;break}if(W<=0.0){ae=0.0;break}do{if(_<=Y){if(Y-W>=_){break}ae=(Y-_)/W;break L4236}}while(0);ae=_>Y?0.0:1.0}}while(0);o=(c[y>>2]|0)+(q<<2)|0;g[o>>2]=ae*$+ +g[o>>2];o=d+12|0;g[(c[l+36>>2]|0)+(q<<2)>>2]=-0.0- +g[o>>2];g[(c[l+40>>2]|0)+(q<<2)>>2]=+g[o>>2]}if(n){ac=y;break}else{s=1}return s|0}}while(0);ae=+g[l>>2]*+g[d+32>>2];if(t){n=(c[ac>>2]|0)+(q<<2)|0;g[n>>2]=+g[d+48>>2]*(-0.0-ae)+ +g[n>>2]}else{n=(c[ac>>2]|0)+(q<<2)|0;g[n>>2]=ae*+g[d+48>>2]+ +g[n>>2]}g[(c[l+32>>2]|0)+(q<<2)>>2]=+g[d+36>>2];if(+g[d>>2]==+g[d+4>>2]){g[(c[l+36>>2]|0)+(q<<2)>>2]=-3.4028234663852886e+38;g[(c[l+40>>2]|0)+(q<<2)>>2]=3.4028234663852886e+38;s=1;return s|0}n=(r|0)==1;r=(c[l+36>>2]|0)+(q<<2)|0;if(n){g[r>>2]=0.0;g[(c[l+40>>2]|0)+(q<<2)>>2]=3.4028234663852886e+38}else{g[r>>2]=-3.4028234663852886e+38;g[(c[l+40>>2]|0)+(q<<2)>>2]=0.0}ae=+g[d+40>>2];if(ae<=0.0){s=1;return s|0}if(t){ad=+g[w>>2];Y=+g[x>>2];_=+g[z>>2];af=+g[j>>2]*ad+ +g[j+4>>2]*Y+ +g[j+8>>2]*_-(ad*+g[k>>2]+Y*+g[k+4>>2]+_*+g[k+8>>2])}else{_=+g[w>>2];Y=+g[x>>2];ad=+g[z>>2];af=+g[h>>2]*_+ +g[h+4>>2]*Y+ +g[h+8>>2]*ad-(_*+g[i>>2]+Y*+g[i+4>>2]+ad*+g[i+8>>2])}if(n){if(af>=0.0){s=1;return s|0}ad=af*(-0.0-ae);n=(c[ac>>2]|0)+(q<<2)|0;if(ad<=+g[n>>2]){s=1;return s|0}g[n>>2]=ad;s=1;return s|0}else{if(af<=0.0){s=1;return s|0}ad=af*(-0.0-ae);n=(c[ac>>2]|0)+(q<<2)|0;if(ad>=+g[n>>2]){s=1;return s|0}g[n>>2]=ad;s=1;return s|0}return 0}function ao8(a){a=a|0;var b=0.0,d=0.0,e=0.0,f=0.0;b=+g[(c[a+24>>2]|0)+336>>2];d=+g[(c[a+28>>2]|0)+336>>2];if(d==0.0){e=1.0}else{e=b/(b+d)}d=1.0-e;b=e*+g[a+1108>>2]+d*+g[a+1172>>2];f=e*+g[a+1112>>2]+d*+g[a+1176>>2];g[a+1276>>2]=e*+g[a+1104>>2]+d*+g[a+1168>>2];g[a+1280>>2]=b;g[a+1284>>2]=f;g[a+1288>>2]=0.0;return}function ao9(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;var f=0,h=0;if(e>>>0<3){if((b|0)==3){g[a+732+(e<<2)>>2]=d;f=a+1296|0;c[f>>2]=c[f>>2]|1<<(e*3|0);return}else if((b|0)==4){g[a+764+(e<<2)>>2]=d;f=a+1296|0;c[f>>2]=c[f>>2]|2<<(e*3|0);return}else if((b|0)==2){g[a+748+(e<<2)>>2]=d;f=a+1296|0;c[f>>2]=c[f>>2]|4<<(e*3|0);return}else{return}}f=e-3|0;if(f>>>0>=3){return}if((b|0)==2){g[a+860+(f<<6)+32>>2]=d;h=a+1296|0;c[h>>2]=c[h>>2]|4<<(e*3|0);return}else if((b|0)==3){g[a+860+(f<<6)+28>>2]=d;h=a+1296|0;c[h>>2]=c[h>>2]|1<<(e*3|0);return}else if((b|0)==4){g[a+860+(f<<6)+36>>2]=d;f=a+1296|0;c[f>>2]=c[f>>2]|2<<(e*3|0);return}else{return}}function apa(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0;do{if(c>>>0<3){if((b|0)==2){d=+g[a+748+(c<<2)>>2];break}else if((b|0)==4){d=+g[a+764+(c<<2)>>2];break}else if((b|0)==3){d=+g[a+732+(c<<2)>>2];break}else{d=0.0;break}}else{e=c-3|0;if(e>>>0>=3){d=0.0;break}if((b|0)==3){d=+g[a+860+(e<<6)+28>>2];break}else if((b|0)==4){d=+g[a+860+(e<<6)+36>>2];break}else if((b|0)==2){d=+g[a+860+(e<<6)+32>>2];break}else{d=0.0;break}}}while(0);return+d}function apb(b,d,e,f,h,i,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0,n=0.0,o=0.0,p=0.0;aoZ(b,e,f);l=b+860|0;m=b+864|0;n=+ao0(+g[b+1184>>2],+g[l>>2],+g[m>>2]);g[b+912>>2]=n;o=+g[l>>2];p=+g[m>>2];do{if(o>p){c[b+916>>2]=0}else{if(o>n){c[b+916>>2]=1;g[b+908>>2]=n-o;break}m=b+916|0;if(p<n){c[m>>2]=2;g[b+908>>2]=n-p;break}else{c[m>>2]=0;break}}}while(0);m=b+924|0;l=b+928|0;p=+ao0(+g[b+1188>>2],+g[m>>2],+g[l>>2]);g[b+976>>2]=p;n=+g[m>>2];o=+g[l>>2];do{if(n>o){c[b+980>>2]=0}else{if(n>p){c[b+980>>2]=1;g[b+972>>2]=p-n;break}l=b+980|0;if(o<p){c[l>>2]=2;g[b+972>>2]=p-o;break}else{c[l>>2]=0;break}}}while(0);l=b+988|0;m=b+992|0;o=+ao0(+g[b+1192>>2],+g[l>>2],+g[m>>2]);g[b+1040>>2]=o;p=+g[l>>2];n=+g[m>>2];do{if(p>n){c[b+1044>>2]=0}else{if(p>o){c[b+1044>>2]=1;g[b+1036>>2]=o-p;break}m=b+1044|0;if(n<o){c[m>>2]=2;g[b+1036>>2]=o-n;break}else{c[m>>2]=0;break}}}while(0);if((a[b+1293|0]&1)==0){m=ao5(b,d,0,e,f,h,i,j,k)|0;ao4(b,d,m,e,f,h,i,j,k)|0;return}else{m=ao4(b,d,0,e,f,h,i,j,k)|0;ao5(b,d,m,e,f,h,i,j,k)|0;return}}function apc(a){a=a|0;if((a|0)==0){return}aDB(a);return}function apd(a){a=a|0;return 244}function ape(a){a=a|0;return}function apf(a){a=a|0;return 340}function apg(a){a=a|0;return}function aph(b,d,e){b=b|0;d=d|0;e=e|0;aq3(b|0,d,e)|0;g[d+44>>2]=+g[b+40>>2];g[d+48>>2]=+g[b+44>>2];g[d+52>>2]=+g[b+48>>2];g[d+56>>2]=+g[b+52>>2];g[d+60>>2]=+g[b+56>>2];g[d+64>>2]=+g[b+60>>2];g[d+68>>2]=+g[b+64>>2];g[d+72>>2]=+g[b+68>>2];g[d+76>>2]=+g[b+72>>2];g[d+80>>2]=+g[b+76>>2];g[d+84>>2]=+g[b+80>>2];g[d+88>>2]=+g[b+84>>2];g[d+92>>2]=+g[b+88>>2];g[d+96>>2]=+g[b+92>>2];g[d+100>>2]=+g[b+96>>2];g[d+104>>2]=+g[b+100>>2];g[d+108>>2]=+g[b+104>>2];g[d+112>>2]=+g[b+108>>2];g[d+116>>2]=+g[b+112>>2];g[d+120>>2]=+g[b+116>>2];g[d+124>>2]=+g[b+120>>2];g[d+128>>2]=+g[b+124>>2];g[d+132>>2]=+g[b+128>>2];g[d+136>>2]=+g[b+132>>2];g[d+140>>2]=+g[b+136>>2];g[d+144>>2]=+g[b+140>>2];g[d+148>>2]=+g[b+144>>2];g[d+152>>2]=+g[b+148>>2];g[d+156>>2]=+g[b+152>>2];g[d+160>>2]=+g[b+156>>2];g[d+164>>2]=+g[b+160>>2];g[d+168>>2]=+g[b+164>>2];g[d+220>>2]=+g[b+860>>2];g[d+204>>2]=+g[b+864>>2];g[d+188>>2]=+g[b+672>>2];g[d+172>>2]=+g[b+688>>2];g[d+224>>2]=+g[b+924>>2];g[d+208>>2]=+g[b+928>>2];g[d+192>>2]=+g[b+676>>2];g[d+176>>2]=+g[b+692>>2];g[d+228>>2]=+g[b+988>>2];g[d+212>>2]=+g[b+992>>2];g[d+196>>2]=+g[b+680>>2];g[d+180>>2]=+g[b+696>>2];c[d+236>>2]=a[b+1292|0]&1;c[d+240>>2]=a[b+1293|0]&1;return 17808}function api(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0;e=d|0;f=d+48|0;if((a[b+1301|0]&1)!=0){h=(+g[b+1248>>2]- +g[b+1308>>2])*+g[b+1332>>2];g[b+784>>2]=h*(+g[e>>2]*+g[b+1356>>2]/+(c[f>>2]|0));i=+P(+h);g[b+800>>2]=i/+g[e>>2]}if((a[b+1302|0]&1)!=0){i=(+g[b+1252>>2]- +g[b+1312>>2])*+g[b+1336>>2];g[b+788>>2]=i*(+g[e>>2]*+g[b+1360>>2]/+(c[f>>2]|0));h=+P(+i);g[b+804>>2]=h/+g[e>>2]}if((a[b+1303|0]&1)!=0){h=(+g[b+1256>>2]- +g[b+1316>>2])*+g[b+1340>>2];g[b+792>>2]=h*(+g[e>>2]*+g[b+1364>>2]/+(c[f>>2]|0));i=+P(+h);g[b+808>>2]=i/+g[e>>2]}if((a[b+1304|0]&1)!=0){i=+g[b+1344>>2]*(-0.0-(+g[b+1184>>2]- +g[b+1320>>2]));g[b+868>>2]=i*(+g[e>>2]*+g[b+1368>>2]/+(c[f>>2]|0));h=+P(+i);g[b+872>>2]=h/+g[e>>2]}if((a[b+1305|0]&1)!=0){h=+g[b+1348>>2]*(-0.0-(+g[b+1188>>2]- +g[b+1324>>2]));g[b+932>>2]=h*(+g[e>>2]*+g[b+1372>>2]/+(c[f>>2]|0));i=+P(+h);g[b+936>>2]=i/+g[e>>2]}if((a[b+1306|0]&1)==0){j=b;ao3(j,d);return}i=+g[b+1352>>2]*(-0.0-(+g[b+1192>>2]- +g[b+1328>>2]));g[b+996>>2]=i*(+g[e>>2]*+g[b+1376>>2]/+(c[f>>2]|0));h=+P(+i);g[b+1e3>>2]=h/+g[e>>2];j=b;ao3(j,d);return}function apj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0;e=+g[b>>2];f=+g[b+4>>2];h=+g[b+8>>2];i=1.0/+Q(+(e*e+f*f+h*h));j=e*i;e=f*i;f=h*i;i=+g[d>>2];h=+g[d+4>>2];k=+g[d+8>>2];l=1.0/+Q(+(i*i+h*h+k*k));m=i*l;i=h*l;h=k*l;l=f*i-e*h;k=j*h-f*m;n=e*m-j*i;d=c[a+24>>2]|0;o=+g[d+4>>2];p=+g[d+20>>2];q=+g[d+36>>2];r=+g[d+8>>2];s=+g[d+24>>2];t=+g[d+40>>2];u=+g[d+12>>2];v=+g[d+28>>2];w=+g[d+44>>2];x=-0.0- +g[d+52>>2];y=-0.0- +g[d+56>>2];z=-0.0- +g[d+60>>2];g[a+40>>2]=o*l+k*p+n*q;g[a+44>>2]=m*o+i*p+h*q;g[a+48>>2]=j*o+e*p+f*q;g[a+52>>2]=0.0;g[a+56>>2]=l*r+k*s+n*t;g[a+60>>2]=m*r+i*s+h*t;g[a+64>>2]=j*r+e*s+f*t;g[a+68>>2]=0.0;g[a+72>>2]=l*u+k*v+n*w;g[a+76>>2]=m*u+i*v+h*w;g[a+80>>2]=j*u+e*v+f*w;g[a+84>>2]=0.0;g[a+88>>2]=o*0.0+p*0.0+q*0.0+(o*x+p*y+q*z);g[a+92>>2]=r*0.0+s*0.0+t*0.0+(r*x+s*y+t*z);g[a+96>>2]=u*0.0+v*0.0+w*0.0+(u*x+v*y+w*z);g[a+100>>2]=0.0;b=c[a+28>>2]|0;z=+g[b+4>>2];w=+g[b+20>>2];y=+g[b+36>>2];v=+g[b+8>>2];x=+g[b+24>>2];u=+g[b+40>>2];t=+g[b+12>>2];s=+g[b+28>>2];r=+g[b+44>>2];q=-0.0- +g[b+52>>2];p=-0.0- +g[b+56>>2];o=-0.0- +g[b+60>>2];g[a+104>>2]=l*z+k*w+n*y;g[a+108>>2]=m*z+i*w+h*y;g[a+112>>2]=j*z+e*w+f*y;g[a+116>>2]=0.0;g[a+120>>2]=l*v+k*x+n*u;g[a+124>>2]=m*v+i*x+h*u;g[a+128>>2]=j*v+e*x+f*u;g[a+132>>2]=0.0;g[a+136>>2]=l*t+k*s+n*r;g[a+140>>2]=m*t+i*s+h*r;g[a+144>>2]=j*t+e*s+f*r;g[a+148>>2]=0.0;g[a+152>>2]=z*0.0+w*0.0+y*0.0+(z*q+w*p+y*o);g[a+156>>2]=v*0.0+x*0.0+u*0.0+(v*q+x*p+u*o);g[a+160>>2]=t*0.0+s*0.0+r*0.0+(t*q+s*p+r*o);g[a+164>>2]=0.0;aoZ(a,d+4|0,b+4|0);return}function apk(a){a=a|0;if((a|0)==0){return}aDB(a|0);return}function apl(b,d,e){b=b|0;d=d|0;e=e|0;aph(b,d,e)|0;g[d+268>>2]=+g[b+1308>>2];g[d+316>>2]=+g[b+1356>>2];c[d+244>>2]=a[b+1301|0]&1;g[d+292>>2]=+g[b+1332>>2];g[d+272>>2]=+g[b+1312>>2];g[d+320>>2]=+g[b+1360>>2];c[d+248>>2]=a[b+1302|0]&1;g[d+296>>2]=+g[b+1336>>2];g[d+276>>2]=+g[b+1316>>2];g[d+324>>2]=+g[b+1364>>2];c[d+252>>2]=a[b+1303|0]&1;g[d+300>>2]=+g[b+1340>>2];g[d+280>>2]=+g[b+1320>>2];g[d+328>>2]=+g[b+1368>>2];c[d+256>>2]=a[b+1304|0]&1;g[d+304>>2]=+g[b+1344>>2];g[d+284>>2]=+g[b+1324>>2];g[d+332>>2]=+g[b+1372>>2];c[d+260>>2]=a[b+1305|0]&1;g[d+308>>2]=+g[b+1348>>2];g[d+288>>2]=+g[b+1328>>2];g[d+336>>2]=+g[b+1376>>2];c[d+264>>2]=a[b+1306|0]&1;g[d+312>>2]=+g[b+1352>>2];return 17808}function apm(a){a=a|0;if((a|0)==0){return}aDB(a|0);return}function apn(b,d,e,f,h,i,j,k){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;i=i|0;j=j|0;k=k|0;var l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0;c[b+4>>2]=4;c[b+8>>2]=-1;c[b+12>>2]=-1;g[b+16>>2]=3.4028234663852886e+38;a[b+20|0]=1;a[b+21|0]=0;c[b+24>>2]=d;c[b+28>>2]=e;g[b+32>>2]=0.0;g[b+36>>2]=.30000001192092896;c[b>>2]=23504;g[b+680>>2]=0.0;g[b+684>>2]=-1.0;g[b+688>>2]=.8999999761581421;g[b+692>>2]=.30000001192092896;g[b+696>>2]=1.0;g[b+700>>2]=0.0;g[b+704>>2]=0.0;a[b+708|0]=0;a[b+728|0]=0;a[b+729|0]=0;a[b+730|0]=0;a[b+731|0]=1;a[b+732|0]=k&1;c[b+740>>2]=0;e=b+592|0;l=f;c[e>>2]=c[l>>2];c[e+4>>2]=c[l+4>>2];c[e+8>>2]=c[l+8>>2];c[e+12>>2]=c[l+12>>2];m=+g[d+4>>2];n=+g[d+20>>2];o=+g[d+36>>2];l=i|0;p=+g[l>>2];e=i+4|0;q=+g[e>>2];f=i+8|0;r=+g[f>>2];s=m*p+n*q+o*r;do{if(s<.9999998807907104){if(s>-.9999998807907104){t=o*q-n*r;u=m*r-o*p;v=n*p-m*q;w=t;x=u;y=v;z=r*u-q*v;A=p*v-r*t;B=q*t-p*u;break}else{w=+g[d+8>>2];x=+g[d+24>>2];y=+g[d+40>>2];z=+g[d+12>>2];A=+g[d+28>>2];B=+g[d+44>>2];break}}else{w=+g[d+8>>2];x=+g[d+24>>2];y=+g[d+40>>2];z=-0.0- +g[d+12>>2];A=-0.0- +g[d+28>>2];B=-0.0- +g[d+44>>2]}}while(0);g[b+544>>2]=z;g[b+548>>2]=w;g[b+552>>2]=+g[l>>2];g[b+556>>2]=0.0;g[b+560>>2]=A;g[b+564>>2]=x;g[b+568>>2]=+g[e>>2];g[b+572>>2]=0.0;g[b+576>>2]=B;g[b+580>>2]=y;g[b+584>>2]=+g[f>>2];g[b+588>>2]=0.0;y=+g[e>>2];e=j+8|0;x=+g[e>>2];w=+g[f>>2];f=j+4|0;p=+g[f>>2];d=j|0;q=+g[d>>2];r=+g[l>>2];m=x*w+(y*p+q*r);do{if(m<-.9999998807907104){if(+P(+w)>.7071067690849304){n=1.0/+Q(+(y*y+w*w));C=0.0;D=n*(-0.0-w);E=y*n;F=0.0;break}else{n=1.0/+Q(+(y*y+r*r));C=n*(-0.0-y);D=r*n;E=0.0;F=0.0;break}}else{n=+Q(+((m+1.0)*2.0));o=1.0/n;C=(y*x-w*p)*o;D=(w*q-x*r)*o;E=(p*r-y*q)*o;F=n*.5}}while(0);y=z*F+B*D-A*E;r=A*F+z*E-B*C;w=B*F+A*C-z*D;m=-0.0-C;C=z*m-A*D-B*E;B=-0.0-D;D=-0.0-E;E=r*D+(F*y+C*m)-w*B;A=w*m+(F*r+C*B)-y*D;z=y*B+(F*w+C*D)-r*m;l=b+656|0;j=h;c[l>>2]=c[j>>2];c[l+4>>2]=c[j+4>>2];c[l+8>>2]=c[j+8>>2];c[l+12>>2]=c[j+12>>2];g[b+608>>2]=E;g[b+612>>2]=p*z-x*A;g[b+616>>2]=+g[d>>2];g[b+620>>2]=0.0;g[b+624>>2]=A;g[b+628>>2]=x*E-q*z;g[b+632>>2]=+g[f>>2];g[b+636>>2]=0.0;g[b+640>>2]=z;g[b+644>>2]=q*A-p*E;g[b+648>>2]=+g[e>>2];g[b+652>>2]=0.0;g[b+724>>2]=k?-1.0:1.0;return}function apo(b,d,e,f,h){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;var i=0,j=0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;aq1(b|0,4,d);c[b>>2]=23504;g[b+680>>2]=0.0;g[b+684>>2]=-1.0;g[b+688>>2]=.8999999761581421;g[b+692>>2]=.30000001192092896;g[b+696>>2]=1.0;g[b+700>>2]=0.0;g[b+704>>2]=0.0;a[b+708|0]=0;a[b+728|0]=0;a[b+729|0]=0;a[b+730|0]=0;a[b+731|0]=1;a[b+732|0]=h&1;c[b+740>>2]=0;i=f|0;j=f+8|0;k=+g[j>>2];if(+P(+k)>.7071067690849304){l=+g[f+4>>2];m=k*k+l*l;n=1.0/+Q(+m);o=n*(-0.0-k);p=l*n;l=+g[i>>2];q=m*n;r=p*(-0.0-l);s=l*o;t=0.0;u=o;v=p}else{p=+g[i>>2];o=+g[f+4>>2];l=p*p+o*o;n=1.0/+Q(+l);m=n*(-0.0-o);o=p*n;q=o*(-0.0-k);r=k*m;s=l*n;t=m;u=o;v=0.0}w=b+592|0;x=e;c[w>>2]=c[x>>2];c[w+4>>2]=c[x+4>>2];c[w+8>>2]=c[x+8>>2];c[w+12>>2]=c[x+12>>2];x=f+4|0;g[b+544>>2]=t;g[b+548>>2]=q;g[b+552>>2]=+g[i>>2];g[b+556>>2]=0.0;g[b+560>>2]=u;g[b+564>>2]=r;g[b+568>>2]=+g[x>>2];g[b+572>>2]=0.0;g[b+576>>2]=v;g[b+580>>2]=s;g[b+584>>2]=+g[j>>2];g[b+588>>2]=0.0;s=+g[d+4>>2];r=+g[i>>2];q=+g[d+8>>2];o=+g[x>>2];m=+g[d+12>>2];n=+g[j>>2];l=s*r+q*o+m*n;k=+g[d+20>>2];p=+g[d+24>>2];y=+g[d+28>>2];z=r*k+o*p+n*y;A=+g[d+36>>2];B=+g[d+40>>2];C=+g[d+44>>2];D=r*A+o*B+n*C;E=r*l+o*z+n*D;do{if(E<-.9999998807907104){if(+P(+n)>.7071067690849304){F=1.0/+Q(+(o*o+n*n));G=0.0;H=F*(-0.0-n);I=o*F;J=0.0;break}else{F=1.0/+Q(+(r*r+o*o));G=F*(-0.0-o);H=r*F;I=0.0;J=0.0;break}}else{F=+Q(+((E+1.0)*2.0));K=1.0/F;G=(o*D-n*z)*K;H=(n*l-r*D)*K;I=(r*z-o*l)*K;J=F*.5}}while(0);o=t*J+v*H-u*I;r=u*J+t*I-v*G;n=v*J+u*G-t*H;E=-0.0-G;G=t*E-u*H-v*I;v=-0.0-H;H=-0.0-I;I=r*H+(J*o+G*E)-n*v;u=n*E+(J*r+G*v)-o*H;t=o*v+(J*n+G*H)-r*E;E=+g[e>>2];r=+g[e+4>>2];H=+g[e+8>>2];G=+g[d+56>>2]+(E*k+r*p+H*y);y=+g[d+60>>2]+(E*A+r*B+H*C);g[b+656>>2]=+g[d+52>>2]+(s*E+q*r+m*H);g[b+660>>2]=G;g[b+664>>2]=y;g[b+668>>2]=0.0;g[b+608>>2]=I;g[b+612>>2]=z*t-D*u;g[b+616>>2]=l;g[b+620>>2]=0.0;g[b+624>>2]=u;g[b+628>>2]=D*I-l*t;g[b+632>>2]=z;g[b+636>>2]=0.0;g[b+640>>2]=t;g[b+644>>2]=l*u-z*I;g[b+648>>2]=D;g[b+652>>2]=0.0;g[b+724>>2]=h?-1.0:1.0;return}function app(b){b=b|0;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0.0,o=0.0,p=0.0,q=0.0,r=0,s=0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0.0,av=0.0,aw=0.0,ax=0.0,ay=0.0,az=0,aA=0.0;d=i;i=i+176|0;e=d|0;f=d+48|0;h=d+96|0;j=d+144|0;k=d+160|0;if((a[b+730|0]&1)==0){i=d;return}g[b+32>>2]=0.0;g[b+736>>2]=0.0;if((a[b+728|0]&1)==0){l=b+24|0;m=c[l>>2]|0;n=+g[b+592>>2];o=+g[b+596>>2];p=+g[b+600>>2];q=+g[m+56>>2]+(n*+g[m+20>>2]+o*+g[m+24>>2]+p*+g[m+28>>2]);r=b+28|0;s=c[r>>2]|0;t=+g[b+656>>2];u=+g[b+660>>2];v=+g[b+664>>2];w=+g[s+56>>2]+(t*+g[s+20>>2]+u*+g[s+24>>2]+v*+g[s+28>>2]);x=+g[s+60>>2]+(t*+g[s+36>>2]+u*+g[s+40>>2]+v*+g[s+44>>2]);y=w-q;z=+g[m+52>>2]+(+g[m+4>>2]*n+ +g[m+8>>2]*o+ +g[m+12>>2]*p);A=+g[m+60>>2]+(n*+g[m+36>>2]+o*+g[m+40>>2]+p*+g[m+44>>2]);p=+g[s+52>>2]+(+g[s+4>>2]*t+ +g[s+8>>2]*u+ +g[s+12>>2]*v);v=p-z;u=x-A;t=v*v+y*y+u*u;if(t>1.1920928955078125e-7){o=1.0/+Q(+t);t=v*o;v=y*o;y=u*o;g[e>>2]=t;g[e+4>>2]=v;g[e+8>>2]=y;g[e+12>>2]=0.0;B=y;C=v;D=t}else{g[e>>2]=1.0;g[e+4>>2]=0.0;g[e+8>>2]=0.0;g[e+12>>2]=0.0;B=0.0;C=0.0;D=1.0}s=e+16|0;m=e+32|0;if(+P(+B)>.7071067690849304){t=B*B+C*C;v=1.0/+Q(+t);g[s>>2]=0.0;y=v*(-0.0-B);g[e+20>>2]=y;o=v*C;g[e+24>>2]=o;g[m>>2]=t*v;g[e+36>>2]=o*(-0.0-D);g[e+40>>2]=D*y}else{y=D*D+C*C;o=1.0/+Q(+y);v=o*(-0.0-C);g[s>>2]=v;C=o*D;g[e+20>>2]=C;g[e+24>>2]=0.0;g[m>>2]=C*(-0.0-B);g[e+36>>2]=B*v;g[e+40>>2]=y*o}m=f|0;s=f+4|0;E=f+8|0;F=f+12|0;G=f+16|0;H=f+20|0;I=f+24|0;J=f+28|0;K=f+32|0;L=f+36|0;M=f+40|0;N=f+44|0;O=h|0;R=h+4|0;S=h+8|0;T=h+12|0;U=h+16|0;V=h+20|0;W=h+24|0;X=h+28|0;Y=h+32|0;Z=h+36|0;_=h+40|0;$=h+44|0;aa=j|0;ab=j+4|0;ac=j+8|0;ad=j+12|0;ae=k|0;af=k+4|0;ag=k+8|0;ah=k+12|0;ai=0;do{aj=b+40+(ai*84|0)|0;if((aj|0)!=0){ak=c[l>>2]|0;g[m>>2]=+g[ak+4>>2];g[s>>2]=+g[ak+20>>2];g[E>>2]=+g[ak+36>>2];g[F>>2]=0.0;g[G>>2]=+g[ak+8>>2];g[H>>2]=+g[ak+24>>2];g[I>>2]=+g[ak+40>>2];g[J>>2]=0.0;g[K>>2]=+g[ak+12>>2];g[L>>2]=+g[ak+28>>2];g[M>>2]=+g[ak+44>>2];g[N>>2]=0.0;al=c[r>>2]|0;g[O>>2]=+g[al+4>>2];g[R>>2]=+g[al+20>>2];g[S>>2]=+g[al+36>>2];g[T>>2]=0.0;g[U>>2]=+g[al+8>>2];g[V>>2]=+g[al+24>>2];g[W>>2]=+g[al+40>>2];g[X>>2]=0.0;g[Y>>2]=+g[al+12>>2];g[Z>>2]=+g[al+28>>2];g[_>>2]=+g[al+44>>2];g[$>>2]=0.0;o=q- +g[ak+56>>2];y=A- +g[ak+60>>2];g[aa>>2]=z- +g[ak+52>>2];g[ab>>2]=o;g[ac>>2]=y;g[ad>>2]=0.0;y=w- +g[al+56>>2];o=x- +g[al+60>>2];g[ae>>2]=p- +g[al+52>>2];g[af>>2]=y;g[ag>>2]=o;g[ah>>2]=0.0;anz(aj,f,h,j,k,e+(ai<<4)|0,ak+388|0,+g[ak+336>>2],al+388|0,+g[al+336>>2])}ai=ai+1|0;}while((ai|0)<3)}ai=b+552|0;e=b+568|0;k=b+584|0;p=+g[ai>>2];x=+g[e>>2];w=+g[k>>2];if(+P(+w)>.7071067690849304){z=x*x+w*w;A=1.0/+Q(+z);q=A*(-0.0-w);o=x*A;am=z*A;an=o*(-0.0-p);ao=p*q;ap=0.0;aq=q;ar=o}else{o=p*p+x*x;q=1.0/+Q(+o);A=q*(-0.0-x);z=p*q;am=z*(-0.0-w);an=w*A;ao=o*q;ap=A;aq=z;ar=0.0}j=b+24|0;h=c[j>>2]|0;f=h+4|0;z=+g[f>>2];ah=h+8|0;A=+g[ah>>2];ag=h+12|0;q=+g[ag>>2];o=ap*z+aq*A+ar*q;af=h+20|0;y=+g[af>>2];ae=h+24|0;v=+g[ae>>2];ad=h+28|0;B=+g[ad>>2];C=ap*y+aq*v+ar*B;ac=h+36|0;D=+g[ac>>2];ab=h+40|0;t=+g[ab>>2];aa=h+44|0;u=+g[aa>>2];n=ap*D+aq*t+ar*u;ar=am*z+an*A+ao*q;aq=am*y+an*v+ao*B;ap=am*D+an*t+ao*u;ao=z*p+A*x+q*w;an=y*p+v*x+B*w;am=D*p+t*x+u*w;$=b+292|0;if(($|0)!=0){_=c[b+28>>2]|0;w=+g[_+4>>2];x=+g[_+20>>2];p=+g[_+36>>2];as=+g[_+8>>2];at=+g[_+24>>2];au=+g[_+40>>2];av=+g[_+12>>2];aw=+g[_+28>>2];ax=+g[_+44>>2];aDD($|0,0,16);ay=z*o+y*C+D*n;D=A*o+v*C+t*n;t=q*o+B*C+u*n;g[b+308>>2]=ay;g[b+312>>2]=D;g[b+316>>2]=t;g[b+320>>2]=0.0;u=-0.0-o;o=-0.0-C;C=-0.0-n;n=w*u+x*o+p*C;p=as*u+at*o+au*C;au=av*u+aw*o+ax*C;g[b+324>>2]=n;g[b+328>>2]=p;g[b+332>>2]=au;g[b+336>>2]=0.0;C=ay*+g[h+388>>2];ax=D*+g[h+392>>2];o=t*+g[h+396>>2];g[b+340>>2]=C;g[b+344>>2]=ax;g[b+348>>2]=o;g[b+352>>2]=0.0;aw=n*+g[_+388>>2];u=p*+g[_+392>>2];av=au*+g[_+396>>2];g[b+356>>2]=aw;g[b+360>>2]=u;g[b+364>>2]=av;g[b+368>>2]=0.0;g[b+372>>2]=ay*C+D*ax+t*o+(n*aw+p*u+au*av)}_=b+376|0;if((_|0)!=0){av=+g[f>>2];au=+g[af>>2];u=+g[ac>>2];p=+g[ah>>2];aw=+g[ae>>2];n=+g[ab>>2];o=+g[ag>>2];t=+g[ad>>2];ax=+g[aa>>2];$=c[b+28>>2]|0;D=+g[$+4>>2];C=+g[$+20>>2];ay=+g[$+36>>2];at=+g[$+8>>2];as=+g[$+24>>2];x=+g[$+40>>2];w=+g[$+12>>2];B=+g[$+28>>2];q=+g[$+44>>2];aDD(_|0,0,16);v=ar*av+aq*au+ap*u;u=ar*p+aq*aw+ap*n;n=ar*o+aq*t+ap*ax;g[b+392>>2]=v;g[b+396>>2]=u;g[b+400>>2]=n;g[b+404>>2]=0.0;ax=-0.0-ar;ar=-0.0-aq;aq=-0.0-ap;ap=D*ax+C*ar+ay*aq;ay=at*ax+as*ar+x*aq;x=w*ax+B*ar+q*aq;g[b+408>>2]=ap;g[b+412>>2]=ay;g[b+416>>2]=x;g[b+420>>2]=0.0;aq=v*+g[h+388>>2];q=u*+g[h+392>>2];ar=n*+g[h+396>>2];g[b+424>>2]=aq;g[b+428>>2]=q;g[b+432>>2]=ar;g[b+436>>2]=0.0;B=ap*+g[$+388>>2];ax=ay*+g[$+392>>2];w=x*+g[$+396>>2];g[b+440>>2]=B;g[b+444>>2]=ax;g[b+448>>2]=w;g[b+452>>2]=0.0;g[b+456>>2]=v*aq+u*q+n*ar+(ap*B+ay*ax+x*w)}$=b+460|0;if(($|0)==0){az=b+28|0}else{w=+g[f>>2];x=+g[af>>2];ax=+g[ac>>2];ay=+g[ah>>2];B=+g[ae>>2];ap=+g[ab>>2];ar=+g[ag>>2];n=+g[ad>>2];q=+g[aa>>2];aa=b+28|0;ad=c[aa>>2]|0;u=+g[ad+4>>2];aq=+g[ad+20>>2];v=+g[ad+36>>2];as=+g[ad+8>>2];at=+g[ad+24>>2];C=+g[ad+40>>2];D=+g[ad+12>>2];t=+g[ad+28>>2];o=+g[ad+44>>2];aDD($|0,0,16);aw=ao*w+an*x+am*ax;ax=ao*ay+an*B+am*ap;ap=ao*ar+an*n+am*q;g[b+476>>2]=aw;g[b+480>>2]=ax;g[b+484>>2]=ap;g[b+488>>2]=0.0;q=-0.0-ao;ao=-0.0-an;an=-0.0-am;am=u*q+aq*ao+v*an;v=as*q+at*ao+C*an;C=D*q+t*ao+o*an;g[b+492>>2]=am;g[b+496>>2]=v;g[b+500>>2]=C;g[b+504>>2]=0.0;an=aw*+g[h+388>>2];o=ax*+g[h+392>>2];ao=ap*+g[h+396>>2];g[b+508>>2]=an;g[b+512>>2]=o;g[b+516>>2]=ao;g[b+520>>2]=0.0;t=am*+g[ad+388>>2];q=v*+g[ad+392>>2];D=C*+g[ad+396>>2];g[b+524>>2]=t;g[b+528>>2]=q;g[b+532>>2]=D;g[b+536>>2]=0.0;g[b+540>>2]=aw*an+ax*o+ap*ao+(am*t+v*q+C*D);az=aa}g[b+716>>2]=0.0;D=+apy(b,h+4|0,(c[az>>2]|0)+4|0);g[b+720>>2]=D;h=b+700|0;g[h>>2]=0.0;aa=b+704|0;g[aa>>2]=0.0;ad=b+708|0;a[ad]=0;$=b+684|0;do{if(+g[$>>2]>=0.0){C=+ck(+(D- +g[b+680>>2]),6.2831854820251465);do{if(C<-3.1415927410125732){aA=C+6.2831854820251465}else{if(C<=3.1415927410125732){aA=C;break}aA=C-6.2831854820251465}}while(0);C=+g[$>>2];if(aA<-0.0-C){a[ad]=1;g[h>>2]=-0.0-(aA+C);g[aa>>2]=1.0;break}if(aA<=C){break}a[ad]=1;g[h>>2]=C-aA;g[aa>>2]=-1.0}}while(0);aa=c[j>>2]|0;aA=+g[ai>>2];D=+g[e>>2];C=+g[k>>2];q=aA*+g[aa+4>>2]+D*+g[aa+8>>2]+C*+g[aa+12>>2];v=aA*+g[aa+20>>2]+D*+g[aa+24>>2]+C*+g[aa+28>>2];t=aA*+g[aa+36>>2]+D*+g[aa+40>>2]+C*+g[aa+44>>2];k=c[az>>2]|0;g[b+712>>2]=1.0/(q*(q*+g[aa+256>>2]+v*+g[aa+272>>2]+t*+g[aa+288>>2])+v*(q*+g[aa+260>>2]+v*+g[aa+276>>2]+t*+g[aa+292>>2])+t*(q*+g[aa+264>>2]+v*+g[aa+280>>2]+t*+g[aa+296>>2])+(q*(q*+g[k+256>>2]+v*+g[k+272>>2]+t*+g[k+288>>2])+v*(q*+g[k+260>>2]+v*+g[k+276>>2]+t*+g[k+292>>2])+t*(q*+g[k+264>>2]+v*+g[k+280>>2]+t*+g[k+296>>2])));i=d;return}function apq(b,d){b=b|0;d=d|0;var e=0,f=0,h=0.0,i=0,j=0,k=0,l=0,m=0.0,n=0.0;e=d|0;if((a[b+730|0]&1)!=0){c[e>>2]=0;c[d+4>>2]=0;return}c[e>>2]=5;f=d+4|0;c[f>>2]=1;h=+apy(b,(c[b+24>>2]|0)+4|0,(c[b+28>>2]|0)+4|0);g[b+720>>2]=h;d=b+700|0;g[d>>2]=0.0;i=b+704|0;g[i>>2]=0.0;j=b+708|0;a[j]=0;k=b+684|0;do{if(+g[k>>2]<0.0){l=3966}else{m=+ck(+(h- +g[b+680>>2]),6.2831854820251465);do{if(m<-3.1415927410125732){n=m+6.2831854820251465}else{if(m<=3.1415927410125732){n=m;break}n=m-6.2831854820251465}}while(0);m=+g[k>>2];if(n<-0.0-m){a[j]=1;g[d>>2]=-0.0-(n+m);g[i>>2]=1.0;break}if(n>m){a[j]=1;g[d>>2]=m-n;g[i>>2]=-1.0;break}else{if((a[j]&1)==0){l=3966;break}else{break}}}}while(0);do{if((l|0)==3966){if((a[b+729|0]&1)!=0){break}return}}while(0);c[e>>2]=(c[e>>2]|0)+1;c[f>>2]=(c[f>>2]|0)-1;return}function apr(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=c[b+24>>2]|0;f=e+4|0;g=c[b+28>>2]|0;h=g+4|0;i=e+320|0;e=g+320|0;if((a[b+731|0]&1)==0){apx(b,d,f,h,i,e);return}else{aps(b,d,f,h,i,e);return}}function aps(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0.0,z=0,A=0.0,B=0,C=0.0,D=0.0,E=0.0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0,S=0.0,T=0.0,U=0.0,V=0.0,W=0.0,X=0.0,Y=0.0,Z=0.0,_=0.0,$=0.0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0.0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0,aq=0.0,ar=0,as=0.0,at=0.0,au=0.0;k=i;i=i+224|0;l=k|0;m=k+48|0;n=k+96|0;o=k+160|0;p=d+24|0;q=c[p>>2]|0;r=m;anx(m,e|0,b+544|0);s=+g[b+592>>2];t=+g[b+596>>2];u=+g[b+600>>2];v=e+48|0;w=+g[e>>2]*s+ +g[e+4>>2]*t+ +g[e+8>>2]*u+ +g[v>>2];x=e+52|0;y=+g[e+16>>2]*s+ +g[e+20>>2]*t+ +g[e+24>>2]*u+ +g[x>>2];z=e+56|0;A=+g[e+32>>2]*s+ +g[e+36>>2]*t+ +g[e+40>>2]*u+ +g[z>>2];e=n+48|0;B=n|0;do{B=B+16|0;}while((B|0)!=(e|0));e=n;c[e>>2]=c[r>>2];c[e+4>>2]=c[r+4>>2];c[e+8>>2]=c[r+8>>2];c[e+12>>2]=c[r+12>>2];r=n+16|0;e=m+16|0;c[r>>2]=c[e>>2];c[r+4>>2]=c[e+4>>2];c[r+8>>2]=c[e+8>>2];c[r+12>>2]=c[e+12>>2];e=n+32|0;r=m+32|0;c[e>>2]=c[r>>2];c[e+4>>2]=c[r+4>>2];c[e+8>>2]=c[r+8>>2];c[e+12>>2]=c[r+12>>2];r=n+48|0;g[r>>2]=w;e=n+52|0;g[e>>2]=y;m=n+56|0;g[m>>2]=A;g[n+60>>2]=0.0;B=l;anx(l,f|0,b+608|0);A=+g[b+656>>2];y=+g[b+660>>2];w=+g[b+664>>2];u=+g[f+48>>2];t=+g[f>>2]*A+ +g[f+4>>2]*y+ +g[f+8>>2]*w+u;s=+g[f+52>>2];C=+g[f+16>>2]*A+ +g[f+20>>2]*y+ +g[f+24>>2]*w+s;D=+g[f+56>>2];E=+g[f+32>>2]*A+ +g[f+36>>2]*y+ +g[f+40>>2]*w+D;f=o+48|0;F=o|0;do{F=F+16|0;}while((F|0)!=(f|0));f=o;c[f>>2]=c[B>>2];c[f+4>>2]=c[B+4>>2];c[f+8>>2]=c[B+8>>2];c[f+12>>2]=c[B+12>>2];B=o+16|0;f=l+16|0;c[B>>2]=c[f>>2];c[B+4>>2]=c[f+4>>2];c[B+8>>2]=c[f+8>>2];c[B+12>>2]=c[f+12>>2];f=o+32|0;B=l+32|0;c[f>>2]=c[B>>2];c[f+4>>2]=c[B+4>>2];c[f+8>>2]=c[B+8>>2];c[f+12>>2]=c[B+12>>2];g[o+48>>2]=t;g[o+52>>2]=C;g[o+56>>2]=E;g[o+60>>2]=0.0;w=+g[r>>2];y=t-w;A=+g[e>>2];G=C-A;H=+g[m>>2];I=E-H;J=+g[(c[b+24>>2]|0)+336>>2];K=+g[(c[b+28>>2]|0)+336>>2];if(J<1.1920928955078125e-7){L=1}else{L=K<1.1920928955078125e-7}M=J+K;if(M>0.0){N=K/M}else{N=.5}M=1.0-N;K=+g[n+8>>2];J=+g[n+24>>2];O=+g[n+40>>2];P=+g[o+8>>2];R=+g[o+24>>2];S=+g[o+40>>2];T=N*K+M*P;U=N*J+M*R;V=N*O+M*S;W=1.0/+Q(+(T*T+U*U+V*V));X=T*W;T=U*W;U=V*W;o=q<<1;W=t-u;u=C-s;s=E-D;D=W*X+u*T+s*U;E=X*D;C=T*D;t=U*D;D=W-E;W=u-C;u=s-t;s=w- +g[v>>2];w=A- +g[x>>2];A=H- +g[z>>2];H=X*s+T*w+U*A;V=X*H;Y=T*H;Z=U*H;H=s-V;s=w-Y;w=A-Z;A=V-E;E=Y-C;C=Z-t;t=H+N*A;Z=s+N*E;Y=w+N*C;V=D-M*A;A=W-M*E;E=u-M*C;C=N*D+M*H;H=N*W+M*s;s=N*u+M*w;w=C*C+H*H+s*s;if(w>1.1920928955078125e-7){u=1.0/+Q(+w);_=u*s;$=u*H;aa=C*u}else{_=+g[n+36>>2];$=+g[n+20>>2];aa=+g[n+4>>2]}u=T*_-U*$;C=U*aa-_*X;H=$*X-T*aa;n=d+12|0;g[c[n>>2]>>2]=Z*_-Y*$;g[(c[n>>2]|0)+4>>2]=Y*aa-t*_;g[(c[n>>2]|0)+8>>2]=t*$-Z*aa;z=d+20|0;g[c[z>>2]>>2]=-0.0-(A*_-E*$);g[(c[z>>2]|0)+4>>2]=-0.0-(E*aa-V*_);g[(c[z>>2]|0)+8>>2]=-0.0-(V*$-A*aa);s=Z*H-Y*C;w=Y*u-t*H;W=t*C-Z*u;D=A*H-E*C;ab=E*u-V*H;ac=V*C-A*u;do{if(L){if((a[b+708|0]&1)==0){ad=s;ae=w;af=W;ag=D;ah=ab;ai=ac;break}ad=N*s;ae=N*w;af=N*W;ag=M*D;ah=M*ab;ai=M*ac}else{ad=s;ae=w;af=W;ag=D;ah=ab;ai=ac}}while(0);g[(c[n>>2]|0)+(q<<2)>>2]=ad;x=q+1|0;g[(c[n>>2]|0)+(x<<2)>>2]=ae;v=q+2|0;g[(c[n>>2]|0)+(v<<2)>>2]=af;g[(c[z>>2]|0)+(q<<2)>>2]=-0.0-ag;g[(c[z>>2]|0)+(x<<2)>>2]=-0.0-ah;g[(c[z>>2]|0)+(v<<2)>>2]=-0.0-ai;ai=Z*U-Y*T;ah=Y*X-t*U;Y=t*T-Z*X;Z=A*U-E*T;t=E*X-V*U;E=V*T-A*X;if(L){aj=N*ai;ak=N*ah;al=N*Y;am=M*Z;an=M*t;ao=M*E}else{aj=ai;ak=ah;al=Y;am=Z;an=t;ao=E}g[(c[n>>2]|0)+(o<<2)>>2]=aj;L=o|1;g[(c[n>>2]|0)+(L<<2)>>2]=ak;m=o+2|0;g[(c[n>>2]|0)+(m<<2)>>2]=al;g[(c[z>>2]|0)+(o<<2)>>2]=-0.0-am;g[(c[z>>2]|0)+(L<<2)>>2]=-0.0-an;g[(c[z>>2]|0)+(m<<2)>>2]=-0.0-ao;e=d|0;r=d+4|0;ao=+g[e>>2]*+g[r>>2];if((a[b+728|0]&1)==0){B=d+8|0;g[c[B>>2]>>2]=aa;g[(c[B>>2]|0)+4>>2]=$;g[(c[B>>2]|0)+8>>2]=_;g[(c[B>>2]|0)+(q<<2)>>2]=u;g[(c[B>>2]|0)+(x<<2)>>2]=C;g[(c[B>>2]|0)+(v<<2)>>2]=H;g[(c[B>>2]|0)+(o<<2)>>2]=X;g[(c[B>>2]|0)+(L<<2)>>2]=T;g[(c[B>>2]|0)+(m<<2)>>2]=U;m=d+28|0;g[c[m>>2]>>2]=ao*(y*aa+G*$+I*_);g[(c[m>>2]|0)+(q<<2)>>2]=ao*(y*u+G*C+I*H);g[(c[m>>2]|0)+(o<<2)>>2]=ao*(y*X+G*T+I*U);ap=m}else{ap=d+28|0}m=q*3|0;o=q<<2;g[(c[n>>2]|0)+(m<<2)>>2]=aa;q=m+1|0;g[(c[n>>2]|0)+(q<<2)>>2]=$;B=m+2|0;g[(c[n>>2]|0)+(B<<2)>>2]=_;g[(c[n>>2]|0)+(o<<2)>>2]=u;L=o|1;g[(c[n>>2]|0)+(L<<2)>>2]=C;v=o|2;g[(c[n>>2]|0)+(v<<2)>>2]=H;g[(c[z>>2]|0)+(m<<2)>>2]=-0.0-aa;g[(c[z>>2]|0)+(q<<2)>>2]=-0.0-$;g[(c[z>>2]|0)+(B<<2)>>2]=-0.0-_;g[(c[z>>2]|0)+(o<<2)>>2]=-0.0-u;g[(c[z>>2]|0)+(L<<2)>>2]=-0.0-C;g[(c[z>>2]|0)+(v<<2)>>2]=-0.0-H;I=+g[e>>2]*+g[r>>2];G=J*S-O*R;y=O*P-K*S;S=K*R-J*P;g[(c[ap>>2]|0)+(m<<2)>>2]=I*(G*aa+y*$+S*_);g[(c[ap>>2]|0)+(o<<2)>>2]=I*(G*u+y*C+S*H);if((a[b+708|0]&1)==0){aq=0.0;ar=0}else{H=+g[b+700>>2]*+g[b+724>>2];aq=H;ar=H>0.0?1:2}o=(ar|0)!=0;m=(a[b+729|0]&1)==0;if(m&(o^1)){i=k;return}v=(c[p>>2]|0)*5|0;g[(c[n>>2]|0)+(v<<2)>>2]=X;p=v+1|0;g[(c[n>>2]|0)+(p<<2)>>2]=T;L=v+2|0;g[(c[n>>2]|0)+(L<<2)>>2]=U;g[(c[z>>2]|0)+(v<<2)>>2]=-0.0-X;g[(c[z>>2]|0)+(p<<2)>>2]=-0.0-T;g[(c[z>>2]|0)+(L<<2)>>2]=-0.0-U;L=b+680|0;z=b+684|0;H=+ck(+(+g[L>>2]- +g[z>>2]),6.2831854820251465);do{if(H<-3.1415927410125732){as=H+6.2831854820251465}else{if(H<=3.1415927410125732){as=H;break}as=H-6.2831854820251465}}while(0);H=+ck(+(+g[L>>2]+ +g[z>>2]),6.2831854820251465);do{if(H<-3.1415927410125732){at=H+6.2831854820251465}else{if(H<=3.1415927410125732){at=H;break}at=H-6.2831854820251465}}while(0);z=as==at;g[(c[ap>>2]|0)+(v<<2)>>2]=0.0;L=b+740|0;p=c[L>>2]|0;H=+g[((p&2|0)==0?r:b+752|0)>>2];if(!(o&z|m)){if((p&4|0)!=0){g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+744>>2]}S=+g[b+720>>2];C=+g[b+672>>2];p=as>at;L4562:do{if(p|z){au=p?1.0:0.0}else{y=C/(H*+g[e>>2]);if(y<0.0){do{if(S>=as){if(as-y<=S){break}au=(as-S)/y;break L4562}}while(0);au=S<as?0.0:1.0;break}if(y<=0.0){au=0.0;break}do{if(S<=at){if(at-y>=S){break}au=(at-S)/y;break L4562}}while(0);au=S>at?0.0:1.0}}while(0);p=(c[ap>>2]|0)+(v<<2)|0;g[p>>2]=au*C*+g[b+724>>2]+ +g[p>>2];p=b+676|0;g[(c[d+36>>2]|0)+(v<<2)>>2]=-0.0- +g[p>>2];g[(c[d+40>>2]|0)+(v<<2)>>2]=+g[p>>2]}if(!o){i=k;return}o=(c[ap>>2]|0)+(v<<2)|0;g[o>>2]=+g[o>>2]+aq*H*+g[e>>2];if((c[L>>2]&1|0)!=0){g[(c[d+32>>2]|0)+(v<<2)>>2]=+g[b+748>>2]}do{if(z){g[(c[d+36>>2]|0)+(v<<2)>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(v<<2)>>2]=3.4028234663852886e+38}else{L=(c[d+36>>2]|0)+(v<<2)|0;if((ar|0)==1){g[L>>2]=0.0;g[(c[d+40>>2]|0)+(v<<2)>>2]=3.4028234663852886e+38;break}else{g[L>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(v<<2)>>2]=0.0;break}}}while(0);H=+g[b+696>>2];do{if(H>0.0){aq=+g[h>>2]*X+ +g[h+4>>2]*T+ +g[h+8>>2]*U-(X*+g[j>>2]+T*+g[j+4>>2]+U*+g[j+8>>2]);if((ar|0)==1){if(aq>=0.0){break}C=aq*(-0.0-H);d=(c[ap>>2]|0)+(v<<2)|0;if(C<=+g[d>>2]){break}g[d>>2]=C;break}else{if(aq<=0.0){break}C=aq*(-0.0-H);d=(c[ap>>2]|0)+(v<<2)|0;if(C>=+g[d>>2]){break}g[d>>2]=C;break}}}while(0);ar=(c[ap>>2]|0)+(v<<2)|0;g[ar>>2]=+g[b+692>>2]*+g[ar>>2];i=k;return}function apt(a){a=a|0;return}function apu(a){a=a|0;return 212}function apv(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if(!((e|0)==(-1|0)|(e|0)==5)){return}if((b|0)==3){g[a+744>>2]=d;e=a+740|0;c[e>>2]=c[e>>2]|4;return}else if((b|0)==4){g[a+748>>2]=d;e=a+740|0;c[e>>2]=c[e>>2]|1;return}else if((b|0)==2){g[a+752>>2]=d;b=a+740|0;c[b>>2]=c[b>>2]|2;return}else{return}}function apw(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do{if((c|0)==(-1|0)|(c|0)==5){if((b|0)==2){d=+g[a+752>>2];break}else if((b|0)==4){d=+g[a+748>>2];break}else if((b|0)==3){d=+g[a+744>>2];break}else{d=0.0;break}}else{d=0.0}}while(0);return+d}function apx(b,d,e,f,h,j){b=b|0;d=d|0;e=e|0;f=f|0;h=h|0;j=j|0;var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0,y=0.0,z=0,A=0.0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,Q=0.0,R=0.0,S=0.0,T=0,U=0.0,V=0.0,W=0.0;k=i;i=i+224|0;l=k|0;m=k+48|0;n=k+96|0;o=k+160|0;p=d+24|0;q=c[p>>2]|0;r=m;anx(m,e|0,b+544|0);s=+g[b+592>>2];t=+g[b+596>>2];u=+g[b+600>>2];v=e+48|0;w=+g[e>>2]*s+ +g[e+4>>2]*t+ +g[e+8>>2]*u+ +g[v>>2];x=e+52|0;y=+g[e+16>>2]*s+ +g[e+20>>2]*t+ +g[e+24>>2]*u+ +g[x>>2];z=e+56|0;A=+g[e+32>>2]*s+ +g[e+36>>2]*t+ +g[e+40>>2]*u+ +g[z>>2];e=n+48|0;B=n|0;do{B=B+16|0;}while((B|0)!=(e|0));e=n;c[e>>2]=c[r>>2];c[e+4>>2]=c[r+4>>2];c[e+8>>2]=c[r+8>>2];c[e+12>>2]=c[r+12>>2];r=n+16|0;e=m+16|0;c[r>>2]=c[e>>2];c[r+4>>2]=c[e+4>>2];c[r+8>>2]=c[e+8>>2];c[r+12>>2]=c[e+12>>2];e=n+32|0;r=m+32|0;c[e>>2]=c[r>>2];c[e+4>>2]=c[r+4>>2];c[e+8>>2]=c[r+8>>2];c[e+12>>2]=c[r+12>>2];r=n+48|0;g[r>>2]=w;e=n+52|0;g[e>>2]=y;m=n+56|0;g[m>>2]=A;g[n+60>>2]=0.0;B=l;anx(l,f|0,b+608|0);A=+g[b+656>>2];y=+g[b+660>>2];w=+g[b+664>>2];C=f+48|0;u=+g[f>>2]*A+ +g[f+4>>2]*y+ +g[f+8>>2]*w+ +g[C>>2];D=f+52|0;t=+g[f+16>>2]*A+ +g[f+20>>2]*y+ +g[f+24>>2]*w+ +g[D>>2];E=f+56|0;s=+g[f+32>>2]*A+ +g[f+36>>2]*y+ +g[f+40>>2]*w+ +g[E>>2];f=o+48|0;F=o|0;do{F=F+16|0;}while((F|0)!=(f|0));f=o;c[f>>2]=c[B>>2];c[f+4>>2]=c[B+4>>2];c[f+8>>2]=c[B+8>>2];c[f+12>>2]=c[B+12>>2];B=o+16|0;f=l+16|0;c[B>>2]=c[f>>2];c[B+4>>2]=c[f+4>>2];c[B+8>>2]=c[f+8>>2];c[B+12>>2]=c[f+12>>2];f=o+32|0;B=l+32|0;c[f>>2]=c[B>>2];c[f+4>>2]=c[B+4>>2];c[f+8>>2]=c[B+8>>2];c[f+12>>2]=c[B+12>>2];g[o+48>>2]=u;g[o+52>>2]=t;g[o+56>>2]=s;g[o+60>>2]=0.0;w=+g[r>>2];y=+g[e>>2];A=+g[m>>2];m=b+728|0;if((a[m]&1)==0){e=d+8|0;g[c[e>>2]>>2]=1.0;r=q+1|0;g[(c[e>>2]|0)+(r<<2)>>2]=1.0;B=q<<1;f=B+2|0;g[(c[e>>2]|0)+(f<<2)>>2]=1.0;G=B;H=r;I=f}else{f=q<<1;G=f;H=q+1|0;I=f+2|0}J=w- +g[v>>2];K=y- +g[x>>2];L=A- +g[z>>2];z=d+12|0;x=c[z>>2]|0;g[x>>2]=0.0;g[x+4>>2]=L;g[x+8>>2]=-0.0-K;g[x+12>>2]=0.0;g[x+(q<<2)>>2]=-0.0-L;g[x+(H<<2)>>2]=0.0;v=q+2|0;g[x+(v<<2)>>2]=J;f=q+3|0;g[x+(f<<2)>>2]=0.0;g[x+(G<<2)>>2]=K;r=G|1;g[x+(r<<2)>>2]=-0.0-J;g[x+(I<<2)>>2]=0.0;B=G+3|0;g[x+(B<<2)>>2]=0.0;J=u- +g[C>>2];K=t- +g[D>>2];L=s- +g[E>>2];E=d+20|0;D=c[E>>2]|0;g[D>>2]=0.0;g[D+4>>2]=-0.0-L;g[D+8>>2]=K;g[D+12>>2]=0.0;g[D+(q<<2)>>2]=L;g[D+(H<<2)>>2]=0.0;g[D+(v<<2)>>2]=-0.0-J;g[D+(f<<2)>>2]=0.0;g[D+(G<<2)>>2]=-0.0-K;g[D+(r<<2)>>2]=J;g[D+(I<<2)>>2]=0.0;g[D+(B<<2)>>2]=0.0;B=d|0;D=d+4|0;J=+g[B>>2]*+g[D>>2];I=d+28|0;if((a[m]&1)==0){g[c[I>>2]>>2]=J*(u-w);g[(c[I>>2]|0)+(q<<2)>>2]=J*(t-y);g[(c[I>>2]|0)+(q<<1<<2)>>2]=J*(s-A)}A=+g[n+8>>2];s=+g[n+24>>2];y=+g[n+40>>2];t=+g[n>>2];w=+g[n+16>>2];u=+g[n+32>>2];K=+g[n+4>>2];L=+g[n+20>>2];M=+g[n+36>>2];n=c[p>>2]|0;q=n*3|0;m=n<<2;g[(c[z>>2]|0)+(q<<2)>>2]=t;n=q+1|0;g[(c[z>>2]|0)+(n<<2)>>2]=w;r=q+2|0;g[(c[z>>2]|0)+(r<<2)>>2]=u;g[(c[z>>2]|0)+(m<<2)>>2]=K;G=m|1;g[(c[z>>2]|0)+(G<<2)>>2]=L;f=m|2;g[(c[z>>2]|0)+(f<<2)>>2]=M;g[(c[E>>2]|0)+(q<<2)>>2]=-0.0-t;g[(c[E>>2]|0)+(n<<2)>>2]=-0.0-w;g[(c[E>>2]|0)+(r<<2)>>2]=-0.0-u;g[(c[E>>2]|0)+(m<<2)>>2]=-0.0-K;g[(c[E>>2]|0)+(G<<2)>>2]=-0.0-L;g[(c[E>>2]|0)+(f<<2)>>2]=-0.0-M;N=+g[o+8>>2];O=+g[o+24>>2];P=+g[o+40>>2];Q=s*P-y*O;R=y*N-A*P;P=A*O-s*N;g[(c[I>>2]|0)+(q<<2)>>2]=J*(u*P+(t*Q+w*R));g[(c[I>>2]|0)+(m<<2)>>2]=J*(M*P+(K*Q+L*R));if((a[b+708|0]&1)==0){S=0.0;T=0}else{R=+g[b+700>>2]*+g[b+724>>2];S=R;T=R>0.0?1:2}m=(T|0)!=0;q=(a[b+729|0]&1)==0;if(q&(m^1)){i=k;return}o=(c[p>>2]|0)*5|0;g[(c[z>>2]|0)+(o<<2)>>2]=A;p=o+1|0;g[(c[z>>2]|0)+(p<<2)>>2]=s;f=o+2|0;g[(c[z>>2]|0)+(f<<2)>>2]=y;g[(c[E>>2]|0)+(o<<2)>>2]=-0.0-A;g[(c[E>>2]|0)+(p<<2)>>2]=-0.0-s;g[(c[E>>2]|0)+(f<<2)>>2]=-0.0-y;f=b+680|0;E=b+684|0;R=+ck(+(+g[f>>2]- +g[E>>2]),6.2831854820251465);do{if(R<-3.1415927410125732){U=R+6.2831854820251465}else{if(R<=3.1415927410125732){U=R;break}U=R-6.2831854820251465}}while(0);R=+ck(+(+g[f>>2]+ +g[E>>2]),6.2831854820251465);do{if(R<-3.1415927410125732){V=R+6.2831854820251465}else{if(R<=3.1415927410125732){V=R;break}V=R-6.2831854820251465}}while(0);E=U==V;g[(c[I>>2]|0)+(o<<2)>>2]=0.0;f=b+740|0;p=c[f>>2]|0;R=+g[((p&2|0)==0?D:b+752|0)>>2];if(!(m&E|q)){if((p&4|0)!=0){g[(c[d+32>>2]|0)+(o<<2)>>2]=+g[b+744>>2]}L=+g[b+720>>2];Q=+g[b+672>>2];p=U>V;L4659:do{if(p|E){W=p?1.0:0.0}else{K=Q/(R*+g[B>>2]);if(K<0.0){do{if(L>=U){if(U-K<=L){break}W=(U-L)/K;break L4659}}while(0);W=L<U?0.0:1.0;break}if(K<=0.0){W=0.0;break}do{if(L<=V){if(V-K>=L){break}W=(V-L)/K;break L4659}}while(0);W=L>V?0.0:1.0}}while(0);p=(c[I>>2]|0)+(o<<2)|0;g[p>>2]=W*Q*+g[b+724>>2]+ +g[p>>2];p=b+676|0;g[(c[d+36>>2]|0)+(o<<2)>>2]=-0.0- +g[p>>2];g[(c[d+40>>2]|0)+(o<<2)>>2]=+g[p>>2]}if(!m){i=k;return}m=(c[I>>2]|0)+(o<<2)|0;g[m>>2]=+g[m>>2]+S*R*+g[B>>2];if((c[f>>2]&1|0)!=0){g[(c[d+32>>2]|0)+(o<<2)>>2]=+g[b+748>>2]}do{if(E){g[(c[d+36>>2]|0)+(o<<2)>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(o<<2)>>2]=3.4028234663852886e+38}else{f=(c[d+36>>2]|0)+(o<<2)|0;if((T|0)==1){g[f>>2]=0.0;g[(c[d+40>>2]|0)+(o<<2)>>2]=3.4028234663852886e+38;break}else{g[f>>2]=-3.4028234663852886e+38;g[(c[d+40>>2]|0)+(o<<2)>>2]=0.0;break}}}while(0);R=+g[b+696>>2];do{if(R>0.0){S=A*+g[h>>2]+s*+g[h+4>>2]+y*+g[h+8>>2]-(A*+g[j>>2]+s*+g[j+4>>2]+y*+g[j+8>>2]);if((T|0)==1){if(S>=0.0){break}Q=S*(-0.0-R);d=(c[I>>2]|0)+(o<<2)|0;if(Q<=+g[d>>2]){break}g[d>>2]=Q;break}else{if(S<=0.0){break}Q=S*(-0.0-R);d=(c[I>>2]|0)+(o<<2)|0;if(Q>=+g[d>>2]){break}g[d>>2]=Q;break}}}while(0);T=(c[I>>2]|0)+(o<<2)|0;g[T>>2]=+g[b+692>>2]*+g[T>>2];i=k;return}function apy(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0,e=0.0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;d=+g[a+544>>2];e=+g[a+560>>2];f=+g[a+576>>2];h=+g[b>>2];i=+g[b+4>>2];j=+g[b+8>>2];k=+g[b+16>>2];l=+g[b+20>>2];m=+g[b+24>>2];n=+g[b+32>>2];o=+g[b+36>>2];p=+g[b+40>>2];q=+g[a+548>>2];r=+g[a+564>>2];s=+g[a+580>>2];t=+g[a+612>>2];u=+g[a+628>>2];v=+g[a+644>>2];w=t*+g[c>>2]+u*+g[c+4>>2]+v*+g[c+8>>2];x=t*+g[c+16>>2]+u*+g[c+20>>2]+v*+g[c+24>>2];y=t*+g[c+32>>2]+u*+g[c+36>>2]+v*+g[c+40>>2];v=+Y(+((d*h+e*i+f*j)*w+(d*k+e*l+f*m)*x+(d*n+e*o+f*p)*y),+((h*q+i*r+j*s)*w+(k*q+l*r+m*s)*x+(n*q+o*r+p*s)*y));return+(v*+g[a+724>>2])}function apz(a){a=a|0;if((a|0)==0){return}aDB(a);return}function apA(a){a=a|0;return}function apB(a){a=a|0;return 76}function apC(b,d){b=b|0;d=d|0;var e=0;e=d|0;if((a[b+336|0]&1)==0){c[e>>2]=3;c[d+4>>2]=3;return}else{c[e>>2]=0;c[d+4>>2]=0;return}}function apD(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0,p=0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0,w=0.0,x=0;f=b+8|0;g[c[f>>2]>>2]=1.0;h=b+24|0;g[(c[f>>2]|0)+((c[h>>2]|0)+1<<2)>>2]=1.0;g[(c[f>>2]|0)+((c[h>>2]<<1)+2<<2)>>2]=1.0;i=+g[a+292>>2];j=+g[a+296>>2];k=+g[a+300>>2];l=+g[d>>2]*i+ +g[d+4>>2]*j+ +g[d+8>>2]*k;m=i*+g[d+16>>2]+j*+g[d+20>>2]+k*+g[d+24>>2];n=i*+g[d+32>>2]+j*+g[d+36>>2]+k*+g[d+40>>2];f=c[b+12>>2]|0;o=c[h>>2]|0;p=o<<1;g[f>>2]=0.0;g[f+4>>2]=n;g[f+8>>2]=-0.0-m;g[f+12>>2]=0.0;g[f+(o<<2)>>2]=-0.0-n;g[f+(o+1<<2)>>2]=0.0;g[f+(o+2<<2)>>2]=l;g[f+(o+3<<2)>>2]=0.0;g[f+(p<<2)>>2]=m;g[f+((p|1)<<2)>>2]=-0.0-l;g[f+(p+2<<2)>>2]=0.0;g[f+(p+3<<2)>>2]=0.0;k=+g[a+308>>2];j=+g[a+312>>2];i=+g[a+316>>2];q=+g[e>>2]*k+ +g[e+4>>2]*j+ +g[e+8>>2]*i;r=k*+g[e+16>>2]+j*+g[e+20>>2]+i*+g[e+24>>2];s=k*+g[e+32>>2]+j*+g[e+36>>2]+i*+g[e+40>>2];p=c[b+20>>2]|0;f=c[h>>2]|0;o=f<<1;g[p>>2]=0.0;g[p+4>>2]=-0.0-s;g[p+8>>2]=r;g[p+12>>2]=0.0;g[p+(f<<2)>>2]=s;g[p+(f+1<<2)>>2]=0.0;g[p+(f+2<<2)>>2]=-0.0-q;g[p+(f+3<<2)>>2]=0.0;g[p+(o<<2)>>2]=-0.0-r;g[p+((o|1)<<2)>>2]=q;g[p+(o+2<<2)>>2]=0.0;g[p+(o+3<<2)>>2]=0.0;o=a+324|0;i=+g[((c[o>>2]&1|0)==0?b+4|0:a+328|0)>>2]*+g[b>>2];p=b+28|0;g[c[p>>2]>>2]=i*(q+ +g[e+48>>2]-l- +g[d+48>>2]);g[(c[p>>2]|0)+(c[h>>2]<<2)>>2]=i*(r+ +g[e+52>>2]-m- +g[d+52>>2]);g[(c[p>>2]|0)+(c[h>>2]<<1<<2)>>2]=i*(s+ +g[e+56>>2]-n- +g[d+56>>2]);if((c[o>>2]&2|0)!=0){o=a+332|0;d=b+32|0;g[c[d>>2]>>2]=+g[o>>2];g[(c[d>>2]|0)+(c[h>>2]<<2)>>2]=+g[o>>2];g[(c[d>>2]|0)+(c[h>>2]<<1<<2)>>2]=+g[o>>2]}o=a+348|0;n=+g[o>>2];s=-0.0-n;d=b+36|0;e=b+40|0;if(n>0.0){g[c[d>>2]>>2]=s;g[c[e>>2]>>2]=n;t=+g[o>>2]}else{t=n}if(t>0.0){g[(c[d>>2]|0)+(c[h>>2]<<2)>>2]=s;g[(c[e>>2]|0)+(c[h>>2]<<2)>>2]=n;u=+g[o>>2]}else{u=t}if(u<=0.0){v=a+344|0;w=+g[v>>2];x=b+52|0;g[x>>2]=w;return}g[(c[d>>2]|0)+(c[h>>2]<<1<<2)>>2]=s;g[(c[e>>2]|0)+(c[h>>2]<<1<<2)>>2]=n;v=a+344|0;w=+g[v>>2];x=b+52|0;g[x>>2]=w;return}function apE(a,b,d,e){a=a|0;b=b|0;d=+d;e=e|0;if((e|0)!=-1){return}if((b|0)==1|(b|0)==2){g[a+328>>2]=d;e=a+324|0;c[e>>2]=c[e>>2]|1;return}else if((b|0)==3|(b|0)==4){g[a+332>>2]=d;b=a+324|0;c[b>>2]=c[b>>2]|2;return}else{return}}function apF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0.0;do{if((c|0)==-1){if((b|0)==3|(b|0)==4){d=+g[a+332>>2];break}else if((b|0)==1|(b|0)==2){d=+g[a+328>>2];break}else{d=3.4028234663852886e+38;break}}else{d=3.4028234663852886e+38}}while(0);return+d}function apG(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0.0,i=0.0,j=0.0,k=0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0.0,s=0,t=0,u=0,v=0.0,w=0,x=0;aq3(b|0,d,e)|0;g[d+44>>2]=+g[b+544>>2];g[d+48>>2]=+g[b+548>>2];g[d+52>>2]=+g[b+552>>2];g[d+56>>2]=+g[b+556>>2];g[d+60>>2]=+g[b+560>>2];g[d+64>>2]=+g[b+564>>2];g[d+68>>2]=+g[b+568>>2];g[d+72>>2]=+g[b+572>>2];g[d+76>>2]=+g[b+576>>2];g[d+80>>2]=+g[b+580>>2];g[d+84>>2]=+g[b+584>>2];g[d+88>>2]=+g[b+588>>2];g[d+92>>2]=+g[b+592>>2];g[d+96>>2]=+g[b+596>>2];g[d+100>>2]=+g[b+600>>2];g[d+104>>2]=+g[b+604>>2];g[d+108>>2]=+g[b+608>>2];g[d+112>>2]=+g[b+612>>2];g[d+116>>2]=+g[b+616>>2];g[d+120>>2]=+g[b+620>>2];g[d+124>>2]=+g[b+624>>2];g[d+128>>2]=+g[b+628>>2];g[d+132>>2]=+g[b+632>>2];g[d+136>>2]=+g[b+636>>2];g[d+140>>2]=+g[b+640>>2];g[d+144>>2]=+g[b+644>>2];g[d+148>>2]=+g[b+648>>2];g[d+152>>2]=+g[b+652>>2];g[d+156>>2]=+g[b+656>>2];g[d+160>>2]=+g[b+660>>2];g[d+164>>2]=+g[b+664>>2];g[d+168>>2]=+g[b+668>>2];c[d+176>>2]=a[b+728|0]&1;c[d+180>>2]=a[b+729|0]&1;g[d+188>>2]=+g[b+676>>2];g[d+184>>2]=+g[b+672>>2];c[d+172>>2]=a[b+732|0]&1;e=b+680|0;f=b+684|0;h=+ck(+(+g[e>>2]- +g[f>>2]),6.2831854820251465);do{if(h<-3.1415927410125732){i=h+6.2831854820251465}else{if(h<=3.1415927410125732){i=h;break}i=h-6.2831854820251465}}while(0);g[d+192>>2]=i;i=+ck(+(+g[e>>2]+ +g[f>>2]),6.2831854820251465);if(i<-3.1415927410125732){j=i+6.2831854820251465;k=d+196|0;l=k;g[l>>2]=j;m=b+688|0;n=+g[m>>2];o=d+200|0;p=o;g[p>>2]=n;q=b+692|0;r=+g[q>>2];s=d+204|0;t=s;g[t>>2]=r;u=b+696|0;v=+g[u>>2];w=d+208|0;x=w;g[x>>2]=v;return 17696}if(i<=3.1415927410125732){j=i;k=d+196|0;l=k;g[l>>2]=j;m=b+688|0;n=+g[m>>2];o=d+200|0;p=o;g[p>>2]=n;q=b+692|0;r=+g[q>>2];s=d+204|0;t=s;g[t>>2]=r;u=b+696|0;v=+g[u>>2];w=d+208|0;x=w;g[x>>2]=v;return 17696}j=i-6.2831854820251465;k=d+196|0;l=k;g[l>>2]=j;m=b+688|0;n=+g[m>>2];o=d+200|0;p=o;g[p>>2]=n;q=b+692|0;r=+g[q>>2];s=d+204|0;t=s;g[t>>2]=r;u=b+696|0;v=+g[u>>2];w=d+208|0;x=w;g[x>>2]=v;return 17696}function apH(a){a=a|0;var b=0,d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0.0,ab=0.0,ac=0.0,ad=0.0,ae=0.0,af=0.0,ag=0.0,ah=0.0,ai=0.0,aj=0,ak=0.0,al=0.0,am=0.0,an=0.0,ao=0.0,ap=0.0,aq=0.0,ar=0.0,as=0.0,at=0.0,au=0.0,av=0.0,aw=0.0,ax=0.0,ay=0.0;b=i;i=i+144|0;d=b|0;e=b+16|0;f=b+64|0;h=b+112|0;j=b+128|0;g[a+32>>2]=0.0;k=a+24|0;l=e|0;m=e+4|0;n=e+8|0;o=e+12|0;p=e+16|0;q=e+20|0;r=e+24|0;s=e+28|0;t=e+32|0;u=e+36|0;v=e+40|0;w=e+44|0;x=a+28|0;y=f|0;z=f+4|0;A=f+8|0;B=f+12|0;C=f+16|0;D=f+20|0;E=f+24|0;F=f+28|0;G=f+32|0;H=f+36|0;I=f+40|0;J=f+44|0;K=a+292|0;L=a+296|0;M=a+300|0;N=h|0;O=h+4|0;P=h+8|0;Q=h+12|0;R=a+308|0;S=a+312|0;T=a+316|0;U=j|0;V=j+4|0;W=j+8|0;X=j+12|0;aDD(d|0,0,16);Y=0;do{Z=d+(Y<<2)|0;g[Z>>2]=1.0;_=a+40+(Y*84|0)|0;if((_|0)!=0){$=c[k>>2]|0;aa=+g[$+4>>2];g[l>>2]=aa;ab=+g[$+20>>2];g[m>>2]=ab;ac=+g[$+36>>2];g[n>>2]=ac;g[o>>2]=0.0;ad=+g[$+8>>2];g[p>>2]=ad;ae=+g[$+24>>2];g[q>>2]=ae;af=+g[$+40>>2];g[r>>2]=af;g[s>>2]=0.0;ag=+g[$+12>>2];g[t>>2]=ag;ah=+g[$+28>>2];g[u>>2]=ah;ai=+g[$+44>>2];g[v>>2]=ai;g[w>>2]=0.0;aj=c[x>>2]|0;ak=+g[aj+4>>2];g[y>>2]=ak;al=+g[aj+20>>2];g[z>>2]=al;am=+g[aj+36>>2];g[A>>2]=am;g[B>>2]=0.0;an=+g[aj+8>>2];g[C>>2]=an;ao=+g[aj+24>>2];g[D>>2]=ao;ap=+g[aj+40>>2];g[E>>2]=ap;g[F>>2]=0.0;aq=+g[aj+12>>2];g[G>>2]=aq;ar=+g[aj+28>>2];g[H>>2]=ar;as=+g[aj+44>>2];g[I>>2]=as;g[J>>2]=0.0;at=+g[K>>2];au=+g[L>>2];av=+g[M>>2];aw=+g[$+52>>2];ax=+g[$+56>>2];ay=+g[$+60>>2];g[N>>2]=aw+(aa*at+ad*au+ag*av)-aw;g[O>>2]=ax+(at*ab+au*ae+av*ah)-ax;g[P>>2]=ay+(at*ac+au*af+av*ai)-ay;g[Q>>2]=0.0;ay=+g[R>>2];ai=+g[S>>2];av=+g[T>>2];af=+g[aj+52>>2];au=+g[aj+56>>2];ac=+g[aj+60>>2];g[U>>2]=af+(ak*ay+an*ai+aq*av)-af;g[V>>2]=au+(ay*al+ai*ao+av*ar)-au;g[W>>2]=ac+(ay*am+ai*ap+av*as)-ac;g[X>>2]=0.0;anz(_,e,f,h,j,d,$+388|0,+g[$+336>>2],aj+388|0,+g[aj+336>>2])}g[Z>>2]=0.0;Y=Y+1|0;}while((Y|0)<3);i=b;return}function apI(a,b){a=a|0;b=b|0;apD(a,b,(c[a+24>>2]|0)+4|0,(c[a+28>>2]|0)+4|0);return}function apJ(a){a=a|0;if((a|0)==0){return}aDB(a);return}function apK(a,b,c){a=a|0;b=b|0;c=c|0;aq3(a|0,b,c)|0;g[b+44>>2]=+g[a+292>>2];g[b+48>>2]=+g[a+296>>2];g[b+52>>2]=+g[a+300>>2];g[b+56>>2]=+g[a+304>>2];g[b+60>>2]=+g[a+308>>2];g[b+64>>2]=+g[a+312>>2];g[b+68>>2]=+g[a+316>>2];g[b+72>>2]=+g[a+320>>2];return 17480}function apL(b){b=b|0;var d=0,e=0,f=0,g=0;c[b>>2]=26048;d=b+480|0;e=b+488|0;f=c[e>>2]|0;g=b+492|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+484>>2]=0;return}function apM(a){a=a|0;apN(a);if((a|0)==0){return}aDB(a);return}function apN(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=23912;d=b+136|0;e=b+144|0;f=c[e>>2]|0;g=b+148|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-284+280>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+140>>2]=0;d=b+68|0;e=b+76|0;g=c[e>>2]|0;f=b+80|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-4>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+72>>2]=0;d=b+48|0;e=b+56|0;f=c[e>>2]|0;g=b+60|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+52>>2]=0;d=b+28|0;e=b+36|0;g=c[e>>2]|0;f=b+40|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-16+12>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+32>>2]=0;d=b+8|0;e=b+16|0;f=c[e>>2]|0;g=b+20|0;if((f|0)==0){a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+12|0;c[h>>2]=0;return}if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-16+12>>2]|0)}c[e>>2]=0;a[g]=1;c[e>>2]=0;c[d>>2]=0;h=b+12|0;c[h>>2]=0;return}function apO(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,h=0,j=0,k=0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0;f=i;i=i+64|0;h=f|0;a[d+84|0]=0;j=c[b+116>>2]|0;b=h;k=j+4|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];k=h+16|0;b=j+20|0;c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];b=h+32|0;k=j+36|0;c[b>>2]=c[k>>2];c[b+4>>2]=c[k+4>>2];c[b+8>>2]=c[k+8>>2];c[b+12>>2]=c[k+12>>2];k=h+48|0;b=j+52|0;c[k>>2]=c[b>>2];c[k+4>>2]=c[b+4>>2];c[k+8>>2]=c[b+8>>2];c[k+12>>2]=c[b+12>>2];do{if(e){b=c[j+472>>2]|0;if((b|0)==0){break}cv[c[(c[b>>2]|0)+8>>2]&2047](b,h)}}while(0);l=+g[h>>2];m=+g[d+156>>2];n=+g[h+4>>2];o=+g[d+160>>2];p=+g[h+8>>2];q=+g[d+164>>2];r=+g[h+16>>2];s=+g[h+20>>2];t=+g[h+24>>2];u=+g[h+52>>2]+(m*r+o*s+q*t);v=+g[h+32>>2];w=+g[h+36>>2];x=+g[h+40>>2];y=+g[h+56>>2]+(m*v+o*w+q*x);g[d+36>>2]=+g[h+48>>2]+(l*m+n*o+p*q);g[d+40>>2]=u;g[d+44>>2]=y;g[d+48>>2]=0.0;y=+g[d+172>>2];u=+g[d+176>>2];q=+g[d+180>>2];g[d+52>>2]=l*y+n*u+p*q;g[d+56>>2]=y*r+u*s+q*t;g[d+60>>2]=y*v+u*w+q*x;g[d+64>>2]=0.0;q=+g[d+188>>2];u=+g[d+192>>2];y=+g[d+196>>2];g[d+68>>2]=l*q+n*u+p*y;g[d+72>>2]=q*r+u*s+y*t;g[d+76>>2]=q*v+u*w+y*x;g[d+80>>2]=0.0;i=f;return}function apP(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0.0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;e=c[a+144>>2]|0;apO(a,e+(b*284|0)|0,d);f=+g[e+(b*284|0)+52>>2];h=-0.0-f;i=+g[e+(b*284|0)+56>>2];j=-0.0-i;k=+g[e+(b*284|0)+60>>2];l=-0.0-k;m=+g[e+(b*284|0)+76>>2];n=+g[e+(b*284|0)+72>>2];o=m*j-n*l;p=+g[e+(b*284|0)+68>>2];q=p*l-m*h;r=n*h-p*j;s=1.0/+Q(+(r*r+(o*o+q*q)));t=o*s;o=s*q;q=s*r;r=+g[e+(b*284|0)+232>>2];s=+Q(+(f*f+i*i+k*k));u=r*.5;r=+T(+u)/s;s=r*h;v=r*j;w=r*l;r=+S(+u);u=2.0/(r*r+(w*w+(s*s+v*v)));x=s*u;y=v*u;z=w*u;u=r*x;A=r*y;B=r*z;r=s*x;x=s*y;C=s*z;s=v*y;y=v*z;v=w*z;z=1.0-(s+v);w=x-B;D=C+A;E=x+B;B=1.0-(r+v);v=y-u;x=C-A;A=y+u;u=1.0-(r+s);s=+g[e+(b*284|0)+236>>2];r=+Q(+(m*m+(n*n+p*p)));y=s*-.5;s=+T(+y)/r;r=p*s;C=n*s;F=m*s;s=+S(+y);y=2.0/(s*s+(F*F+(r*r+C*C)));G=r*y;H=C*y;I=F*y;y=s*G;J=s*H;K=s*I;s=r*G;G=r*H;L=r*I;r=C*H;H=C*I;C=F*I;I=1.0-(r+C);F=G-K;M=L+J;N=G+K;K=1.0-(s+C);C=H-y;G=L-J;J=H+y;y=1.0-(s+r);r=D*G+(w*N+z*I);s=D*J+(z*F+w*K);H=z*M+w*C+D*y;D=v*G+(B*N+E*I);w=v*J+(E*F+B*K);z=E*M+B*C+v*y;v=u*G+(A*N+x*I);I=u*J+(x*F+A*K);K=x*M+A*C+u*y;g[e+(b*284|0)+92>>2]=m*H+(p*r+n*s);g[e+(b*284|0)+96>>2]=q*H+(t*r+o*s);g[e+(b*284|0)+100>>2]=H*l+(r*h+s*j);g[e+(b*284|0)+104>>2]=0.0;g[e+(b*284|0)+108>>2]=m*z+(p*D+n*w);g[e+(b*284|0)+112>>2]=q*z+(t*D+o*w);g[e+(b*284|0)+116>>2]=z*l+(D*h+w*j);g[e+(b*284|0)+120>>2]=0.0;g[e+(b*284|0)+124>>2]=m*K+(p*v+n*I);g[e+(b*284|0)+128>>2]=q*K+(t*v+o*I);g[e+(b*284|0)+132>>2]=K*l+(v*h+I*j);g[e+(b*284|0)+136>>2]=0.0;j=+g[e+(b*284|0)+32>>2];I=j*i+ +g[e+(b*284|0)+40>>2];i=j*k+ +g[e+(b*284|0)+44>>2];g[e+(b*284|0)+140>>2]=f*j+ +g[e+(b*284|0)+36>>2];g[e+(b*284|0)+144>>2]=I;g[e+(b*284|0)+148>>2]=i;g[e+(b*284|0)+152>>2]=0.0;return}function apQ(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0,p=0,q=0,r=0,s=0,t=0.0,u=0.0,v=0,w=0,x=0,y=0,z=0,A=0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;e=i;i=i+72|0;f=e|0;h=e+16|0;j=e+32|0;apO(b,d,0);k=d+204|0;l=d+212|0;m=+g[k>>2]+ +g[l>>2];n=d+52|0;p=d+56|0;q=d+60|0;r=d+36|0;s=d+16|0;t=m*+g[p>>2]+ +g[d+40>>2];u=m*+g[q>>2]+ +g[d+44>>2];v=s;g[d+16>>2]=+g[n>>2]*m+ +g[r>>2];w=d+20|0;g[w>>2]=t;x=d+24|0;g[x>>2]=u;g[d+28>>2]=0.0;y=j+32|0;g[y>>2]=-1.0;z=c[b+100>>2]|0;A=dE[c[(c[z>>2]|0)+8>>2]&127](z,r,s,j)|0;r=d+88|0;c[r>>2]=0;if((A|0)==0){g[d+32>>2]=+g[k>>2];g[d+272>>2]=0.0;u=-0.0- +g[p>>2];t=-0.0- +g[q>>2];g[d>>2]=-0.0- +g[n>>2];g[d+4>>2]=u;g[d+8>>2]=t;g[d+12>>2]=0.0;g[d+268>>2]=1.0;B=-1.0;i=e;return+B}t=m*+g[y>>2];y=d;A=j+16|0;c[y>>2]=c[A>>2];c[y+4>>2]=c[A+4>>2];c[y+8>>2]=c[A+8>>2];c[y+12>>2]=c[A+12>>2];a[d+84|0]=1;A=f;y=h;do{if((a[43024]|0)==0){if((b1(43024)|0)==0){break}aDD(A|0,0,16);ap$(42128,0.0,0,0,f);bG(198,42128,o|0)|0}}while(0);aDD(y|0,0,16);apV(42128,0.0,h);c[r>>2]=42128;m=t- +g[l>>2];l=d+32|0;g[l>>2]=m;u=+g[k>>2];C=+g[d+208>>2]*.009999999776482582;D=u-C;E=u+C;if(m<D){g[l>>2]=D;F=D}else{F=m}if(F>E){g[l>>2]=E}l=j;c[v>>2]=c[l>>2];c[v+4>>2]=c[l+4>>2];c[v+8>>2]=c[l+8>>2];c[v+12>>2]=c[l+12>>2];E=+g[d>>2];F=+g[d+4>>2];m=+g[d+8>>2];D=E*+g[n>>2]+F*+g[p>>2]+m*+g[q>>2];q=c[b+116>>2]|0;C=+g[s>>2]- +g[q+52>>2];u=+g[w>>2]- +g[q+56>>2];G=+g[x>>2]- +g[q+60>>2];H=+g[q+324>>2];I=+g[q+328>>2];J=+g[q+320>>2];if(D<-.10000000149011612){K=-1.0/D;g[d+272>>2]=K*(F*(C*I-G*J+ +g[q+308>>2])+E*(H*G-u*I+ +g[q+304>>2])+m*(u*J-C*H+ +g[q+312>>2]));g[d+268>>2]=K;B=t;i=e;return+B}else{g[d+272>>2]=0.0;g[d+268>>2]=10.0;B=t;i=e;return+B}return 0.0}function apR(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0,s=0.0,t=0.0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0,O=0.0,P=0.0,R=0.0;e=i;i=i+32|0;f=e|0;h=e+16|0;j=b+136|0;k=c[j>>2]|0;if((k|0)>0){l=0;while(1){apP(b,l,0);m=l+1|0;n=c[j>>2]|0;if((m|0)<(n|0)){l=m}else{o=n;break}}}else{o=k}k=b+116|0;l=c[k>>2]|0;n=l+304|0;p=+g[n>>2];m=l+308|0;q=+g[m>>2];r=l+312|0;s=+g[r>>2];t=+Q(+(p*p+q*q+s*s))*3.5999999046325684;u=b+112|0;g[u>>2]=t;v=b+128|0;w=c[v>>2]|0;if(+g[l+4+(w<<2)>>2]*+g[n>>2]+ +g[l+20+(w<<2)>>2]*+g[m>>2]+ +g[l+36+(w<<2)>>2]*+g[r>>2]<0.0){g[u>>2]=t*-1.0}do{if((o|0)>0){u=b+144|0;r=0;do{+apQ(b,(c[u>>2]|0)+(r*284|0)|0);r=r+1|0;x=c[j>>2]|0;}while((r|0)<(x|0));t=1.0/+g[(c[k>>2]|0)+336>>2];if((x|0)>0){y=0}else{break}do{r=c[u>>2]|0;do{if((a[r+(y*284|0)+84|0]&1)==0){g[r+(y*284|0)+276>>2]=0.0}else{s=+g[r+(y*284|0)+272>>2];q=t*(+g[r+(y*284|0)+216>>2]*(+g[r+(y*284|0)+204>>2]- +g[r+(y*284|0)+32>>2])*+g[r+(y*284|0)+268>>2]-s*+g[(s<0.0?r+(y*284|0)+220|0:r+(y*284|0)+224|0)>>2]);w=r+(y*284|0)+276|0;g[w>>2]=q;if(q>=0.0){break}g[w>>2]=0.0}}while(0);y=y+1|0;z=c[j>>2]|0;}while((y|0)<(z|0));if((z|0)<=0){break}r=f|0;w=f+4|0;l=f+8|0;m=f+12|0;n=h|0;A=h+4|0;B=h+8|0;C=h+12|0;D=0;do{E=c[u>>2]|0;t=+g[E+(D*284|0)+276>>2];q=+g[E+(D*284|0)+248>>2];s=t>q?q:t;t=s*+g[E+(D*284|0)+4>>2]*d;q=s*+g[E+(D*284|0)+8>>2]*d;g[r>>2]=+g[E+(D*284|0)>>2]*s*d;g[w>>2]=t;g[l>>2]=q;g[m>>2]=0.0;F=c[k>>2]|0;q=+g[E+(D*284|0)+20>>2]- +g[F+56>>2];t=+g[E+(D*284|0)+24>>2]- +g[F+60>>2];g[n>>2]=+g[E+(D*284|0)+16>>2]- +g[F+52>>2];g[A>>2]=q;g[B>>2]=t;g[C>>2]=0.0;pe(F,f,h);D=D+1|0;}while((D|0)<(c[j>>2]|0))}}while(0);cq[c[(c[b>>2]|0)+20>>2]&1023](b,d);if((c[j>>2]|0)<=0){i=e;return}h=b+144|0;b=0;do{f=c[h>>2]|0;z=c[k>>2]|0;t=+g[f+(b*284|0)+36>>2]- +g[z+52>>2];q=+g[f+(b*284|0)+40>>2]- +g[z+56>>2];s=+g[f+(b*284|0)+44>>2]- +g[z+60>>2];p=+g[z+324>>2];G=+g[z+328>>2];H=+g[z+320>>2];if((a[f+(b*284|0)+84|0]&1)==0){I=+g[f+(b*284|0)+240>>2];y=f+(b*284|0)+236|0;g[y>>2]=I+ +g[y>>2];J=I}else{y=c[v>>2]|0;I=+g[z+4+(y<<2)>>2];K=+g[z+20+(y<<2)>>2];L=+g[z+36+(y<<2)>>2];M=+g[f+(b*284|0)>>2];N=+g[f+(b*284|0)+4>>2];O=+g[f+(b*284|0)+8>>2];P=I*M+K*N+L*O;R=((q*H-t*p+ +g[z+312>>2])*(L-O*P)+((p*s-q*G+ +g[z+304>>2])*(I-M*P)+(t*G-s*H+ +g[z+308>>2])*(K-N*P)))*d/+g[f+(b*284|0)+212>>2];g[f+(b*284|0)+240>>2]=R;z=f+(b*284|0)+236|0;g[z>>2]=R+ +g[z>>2];J=R}g[f+(b*284|0)+240>>2]=J*.9900000095367432;b=b+1|0;}while((b|0)<(c[j>>2]|0));i=e;return}function apS(b,d){b=b|0;d=+d;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ab=0,ac=0,ad=0,ae=0,af=0,ag=0,ah=0,ai=0,aj=0,ak=0,al=0,am=0,an=0,ao=0,ap=0,aq=0.0,ar=0.0,as=0,at=0,au=0.0,av=0,aw=0.0,ax=0,ay=0.0,az=0.0,aA=0.0,aB=0,aC=0.0,aD=0.0,aE=0.0,aF=0.0,aG=0.0,aH=0.0,aI=0.0,aJ=0.0,aK=0,aL=0,aM=0,aN=0.0,aO=0.0,aP=0.0,aQ=0.0,aR=0.0,aS=0.0,aT=0.0,aU=0.0,aV=0.0,aW=0,aX=0,aY=0,aZ=0,a_=0;e=i;i=i+376|0;f=e|0;h=e+16|0;j=e+32|0;k=e+120|0;l=e+168|0;m=e+216|0;n=e+232|0;o=e+248|0;p=e+296|0;q=e+312|0;r=e+328|0;s=e+344|0;t=e+360|0;u=b+136|0;v=c[u>>2]|0;if((v|0)==0){i=e;return}w=b+8|0;x=c[w>>2]|0;if((x|0)<(v|0)){y=b+12|0;if((c[y>>2]|0)<(v|0)){c[9806]=(c[9806]|0)+1;z=aDx((v<<4|4)+15|0)|0;if((z|0)==0){A=0}else{B=-(z+4|0)&15;c[z+B>>2]=z;A=z+(B+4)|0}B=c[w>>2]|0;z=b+16|0;if((B|0)>0){C=0;do{D=A+(C<<4)|0;if((D|0)!=0){E=D;D=(c[z>>2]|0)+(C<<4)|0;c[E>>2]=c[D>>2];c[E+4>>2]=c[D+4>>2];c[E+8>>2]=c[D+8>>2];c[E+12>>2]=c[D+12>>2]}C=C+1|0;}while((C|0)<(B|0))}B=c[z>>2]|0;C=b+20|0;if((B|0)!=0){if((a[C]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[B-16+12>>2]|0)}c[z>>2]=0}a[C]=1;c[z>>2]=A;c[y>>2]=v;F=z}else{F=b+16|0}z=m;m=x;do{x=(c[F>>2]|0)+(m<<4)|0;if((x|0)!=0){y=x;c[y>>2]=c[z>>2];c[y+4>>2]=c[z+4>>2];c[y+8>>2]=c[z+8>>2];c[y+12>>2]=c[z+12>>2]}m=m+1|0;}while((m|0)<(v|0))}c[w>>2]=v;w=b+28|0;m=c[w>>2]|0;if((m|0)<(v|0)){z=b+32|0;if((c[z>>2]|0)<(v|0)){c[9806]=(c[9806]|0)+1;F=aDx((v<<4|4)+15|0)|0;if((F|0)==0){G=0}else{y=-(F+4|0)&15;c[F+y>>2]=F;G=F+(y+4)|0}y=c[w>>2]|0;F=b+36|0;if((y|0)>0){x=0;do{A=G+(x<<4)|0;if((A|0)!=0){C=A;A=(c[F>>2]|0)+(x<<4)|0;c[C>>2]=c[A>>2];c[C+4>>2]=c[A+4>>2];c[C+8>>2]=c[A+8>>2];c[C+12>>2]=c[A+12>>2]}x=x+1|0;}while((x|0)<(y|0))}y=c[F>>2]|0;x=b+40|0;if((y|0)!=0){if((a[x]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[y-16+12>>2]|0)}c[F>>2]=0}a[x]=1;c[F>>2]=G;c[z>>2]=v;H=F}else{H=b+36|0}F=n;n=m;do{m=(c[H>>2]|0)+(n<<4)|0;if((m|0)!=0){z=m;c[z>>2]=c[F>>2];c[z+4>>2]=c[F+4>>2];c[z+8>>2]=c[F+8>>2];c[z+12>>2]=c[F+12>>2]}n=n+1|0;}while((n|0)<(v|0))}c[w>>2]=v;w=b+48|0;n=c[w>>2]|0;if((n|0)<(v|0)){F=b+52|0;if((c[F>>2]|0)<(v|0)){c[9806]=(c[9806]|0)+1;H=aDx((v<<2)+19|0)|0;if((H|0)==0){I=0}else{z=-(H+4|0)&15;c[H+z>>2]=H;I=H+(z+4)|0}z=c[w>>2]|0;H=b+56|0;if((z|0)>0){m=0;do{G=I+(m<<2)|0;if((G|0)!=0){g[G>>2]=+g[(c[H>>2]|0)+(m<<2)>>2]}m=m+1|0;}while((m|0)<(z|0))}z=c[H>>2]|0;m=b+60|0;if((z|0)!=0){if((a[m]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[z-4>>2]|0)}c[H>>2]=0}a[m]=1;c[H>>2]=I;c[F>>2]=v;J=H}else{J=b+56|0}H=n;do{n=(c[J>>2]|0)+(H<<2)|0;if((n|0)!=0){g[n>>2]=0.0}H=H+1|0;}while((H|0)<(v|0))}c[w>>2]=v;w=b+68|0;H=c[w>>2]|0;if((H|0)<(v|0)){J=b+72|0;if((c[J>>2]|0)<(v|0)){c[9806]=(c[9806]|0)+1;n=aDx((v<<2)+19|0)|0;if((n|0)==0){K=0}else{F=-(n+4|0)&15;c[n+F>>2]=n;K=n+(F+4)|0}F=c[w>>2]|0;n=b+76|0;if((F|0)>0){I=0;do{m=K+(I<<2)|0;if((m|0)!=0){g[m>>2]=+g[(c[n>>2]|0)+(I<<2)>>2]}I=I+1|0;}while((I|0)<(F|0))}F=c[n>>2]|0;I=b+80|0;if((F|0)!=0){if((a[I]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[F-4>>2]|0)}c[n>>2]=0}a[I]=1;c[n>>2]=K;c[J>>2]=v;L=n}else{L=b+76|0}n=H;do{H=(c[L>>2]|0)+(n<<2)|0;if((H|0)!=0){g[H>>2]=0.0}n=n+1|0;}while((n|0)<(v|0))}c[w>>2]=v;if((c[u>>2]|0)<=0){i=e;return}v=b+76|0;w=b+56|0;n=0;do{g[(c[v>>2]|0)+(n<<2)>>2]=0.0;g[(c[w>>2]|0)+(n<<2)>>2]=0.0;n=n+1|0;M=c[u>>2]|0;}while((n|0)<(M|0));if((M|0)<=0){i=e;return}n=b+144|0;L=o;H=o+16|0;J=o+32|0;K=b+36|0;I=b+120|0;F=b+16|0;m=b+116|0;z=f|0;G=f+4|0;x=f+8|0;y=f+12|0;A=h|0;C=h+4|0;B=h+8|0;D=h+12|0;E=k|0;N=k+4|0;O=k+8|0;P=k+12|0;R=k+16|0;S=k+20|0;T=k+24|0;U=k+28|0;V=k+32|0;W=k+36|0;X=k+40|0;Y=k+44|0;Z=l|0;_=l+4|0;$=l+8|0;aa=l+12|0;ab=l+16|0;ac=l+20|0;ad=l+24|0;ae=l+28|0;af=l+32|0;ag=l+36|0;ah=l+40|0;ai=l+44|0;aj=j+80|0;ak=0;al=M;while(1){M=c[n>>2]|0;am=c[M+(ak*284|0)+88>>2]|0;if((am|0)==0){an=al}else{ao=M+(ak*284|0)+92|0;c[L>>2]=c[ao>>2];c[L+4>>2]=c[ao+4>>2];c[L+8>>2]=c[ao+8>>2];c[L+12>>2]=c[ao+12>>2];ao=M+(ak*284|0)+108|0;c[H>>2]=c[ao>>2];c[H+4>>2]=c[ao+4>>2];c[H+8>>2]=c[ao+8>>2];c[H+12>>2]=c[ao+12>>2];ao=M+(ak*284|0)+124|0;c[J>>2]=c[ao>>2];c[J+4>>2]=c[ao+4>>2];c[J+8>>2]=c[ao+8>>2];c[J+12>>2]=c[ao+12>>2];ao=c[K>>2]|0;ap=c[I>>2]|0;aq=+g[o+16+(ap<<2)>>2];ar=+g[o+32+(ap<<2)>>2];g[ao+(ak<<4)>>2]=+g[o+(ap<<2)>>2];g[ao+(ak<<4)+4>>2]=aq;g[ao+(ak<<4)+8>>2]=ar;g[ao+(ak<<4)+12>>2]=0.0;ao=c[K>>2]|0;ap=ao+(ak<<4)|0;ar=+g[ap>>2];as=M+(ak*284|0)|0;aq=+g[as>>2];at=ao+(ak<<4)+4|0;au=+g[at>>2];av=M+(ak*284|0)+4|0;aw=+g[av>>2];ax=ao+(ak<<4)+8|0;ay=+g[ax>>2];ao=M+(ak*284|0)+8|0;az=+g[ao>>2];aA=ar*aq+au*aw+ay*az;g[ap>>2]=ar-aq*aA;g[at>>2]=au-aw*aA;g[ax>>2]=ay-az*aA;ax=c[K>>2]|0;at=ax+(ak<<4)|0;aA=+g[at>>2];ap=ax+(ak<<4)+4|0;az=+g[ap>>2];aB=ax+(ak<<4)+8|0;ay=+g[aB>>2];aw=1.0/+Q(+(aA*aA+az*az+ay*ay));g[at>>2]=aA*aw;g[ap>>2]=az*aw;g[aB>>2]=ay*aw;aB=c[F>>2]|0;ap=c[K>>2]|0;aw=+g[av>>2];ay=+g[ap+(ak<<4)+8>>2];az=+g[ao>>2];aA=+g[ap+(ak<<4)+4>>2];au=+g[ap+(ak<<4)>>2];aq=+g[as>>2];g[aB+(ak<<4)>>2]=aw*ay-az*aA;g[aB+(ak<<4)+4>>2]=az*au-ay*aq;g[aB+(ak<<4)+8>>2]=aA*aq-aw*au;g[aB+(ak<<4)+12>>2]=0.0;aB=c[F>>2]|0;as=aB+(ak<<4)|0;au=+g[as>>2];ap=aB+(ak<<4)+4|0;aw=+g[ap>>2];ao=aB+(ak<<4)+8|0;aq=+g[ao>>2];aA=1.0/+Q(+(au*au+aw*aw+aq*aq));g[as>>2]=au*aA;g[ap>>2]=aw*aA;g[ao>>2]=aq*aA;ao=c[m>>2]|0;ap=c[K>>2]|0;as=ap+(ak<<4)|0;aB=(c[v>>2]|0)+(ak<<2)|0;av=as|0;aA=+g[av>>2];at=ap+(ak<<4)+4|0;aq=+g[at>>2];ax=ap+(ak<<4)+8|0;aw=+g[ax>>2];if(aA*aA+aq*aq+aw*aw>1.100000023841858){aC=0.0}else{aw=+g[M+(ak*284|0)+16>>2];aq=aw- +g[ao+52>>2];aA=+g[M+(ak*284|0)+20>>2];au=aA- +g[ao+56>>2];ay=+g[M+(ak*284|0)+24>>2];az=ay- +g[ao+60>>2];g[z>>2]=aq;g[G>>2]=au;g[x>>2]=az;g[y>>2]=0.0;ar=aw- +g[am+52>>2];aw=aA- +g[am+56>>2];aA=ay- +g[am+60>>2];g[A>>2]=ar;g[C>>2]=aw;g[B>>2]=aA;g[D>>2]=0.0;ay=+g[ao+324>>2];aD=+g[ao+328>>2];aE=+g[ao+320>>2];aF=+g[am+324>>2];aG=+g[am+328>>2];aH=+g[am+320>>2];aI=ay*az-aD*au+ +g[ao+304>>2]-(aF*aA-aG*aw+ +g[am+304>>2]);aJ=+g[ao+308>>2]+(aD*aq-az*aE)-(+g[am+308>>2]+(aG*ar-aA*aH));aA=au*aE-ay*aq+ +g[ao+312>>2]-(aw*aH-aF*ar+ +g[am+312>>2]);g[E>>2]=+g[ao+4>>2];g[N>>2]=+g[ao+20>>2];g[O>>2]=+g[ao+36>>2];g[P>>2]=0.0;g[R>>2]=+g[ao+8>>2];g[S>>2]=+g[ao+24>>2];g[T>>2]=+g[ao+40>>2];g[U>>2]=0.0;g[V>>2]=+g[ao+12>>2];g[W>>2]=+g[ao+28>>2];g[X>>2]=+g[ao+44>>2];g[Y>>2]=0.0;g[Z>>2]=+g[am+4>>2];g[_>>2]=+g[am+20>>2];g[$>>2]=+g[am+36>>2];g[aa>>2]=0.0;g[ab>>2]=+g[am+8>>2];g[ac>>2]=+g[am+24>>2];g[ad>>2]=+g[am+40>>2];g[ae>>2]=0.0;g[af>>2]=+g[am+12>>2];g[ag>>2]=+g[am+28>>2];g[ah>>2]=+g[am+44>>2];g[ai>>2]=0.0;anz(j,k,l,f,h,as,ao+388|0,+g[ao+336>>2],am+388|0,+g[am+336>>2]);aC=1.0/+g[aj>>2]*(aI*+g[av>>2]+aJ*+g[at>>2]+aA*+g[ax>>2])*-.20000000298023224}g[aB>>2]=aC;an=c[u>>2]|0}aB=ak+1|0;if((aB|0)<(an|0)){ak=aB;al=an}else{break}}if((an|0)>0){aK=0;aL=0}else{i=e;return}while(1){an=c[n>>2]|0;al=c[an+(aK*284|0)+88>>2]|0;do{if((al|0)==0){g[(c[w>>2]|0)+(aK<<2)>>2]=0.0;g[(c[n>>2]|0)+(aK*284|0)+280>>2]=1.0;aM=aL}else{aC=+g[an+(aK*284|0)+252>>2];if(aC!=0.0){g[(c[w>>2]|0)+(aK<<2)>>2]=0.0;g[(c[n>>2]|0)+(aK*284|0)+280>>2]=1.0;aN=aC*d}else{aC=+g[an+(aK*284|0)+256>>2];aA=aC!=0.0?aC:0.0;ak=c[m>>2]|0;aj=c[F>>2]|0;aC=+g[an+(aK*284|0)+16>>2];aJ=+g[an+(aK*284|0)+20>>2];aI=+g[an+(aK*284|0)+24>>2];ar=+g[aj+(aK<<4)>>2];aF=+g[aj+(aK<<4)+4>>2];aH=+g[aj+(aK<<4)+8>>2];aw=aC- +g[ak+52>>2];aq=aJ- +g[ak+56>>2];ay=aI- +g[ak+60>>2];aE=aq*aH-ay*aF;au=ay*ar-aw*aH;aG=aw*aF-aq*ar;az=+g[ak+256>>2]*aE+ +g[ak+272>>2]*au+aG*+g[ak+288>>2];aD=aE*+g[ak+260>>2]+au*+g[ak+276>>2]+aG*+g[ak+292>>2];aO=aE*+g[ak+264>>2]+au*+g[ak+280>>2]+aG*+g[ak+296>>2];aG=aC- +g[al+52>>2];aC=aJ- +g[al+56>>2];aJ=aI- +g[al+60>>2];aI=aH*aC-aF*aJ;au=ar*aJ-aH*aG;aE=aF*aG-ar*aC;aP=aE*+g[al+288>>2]+(+g[al+256>>2]*aI+ +g[al+272>>2]*au);aQ=aI*+g[al+260>>2]+au*+g[al+276>>2]+aE*+g[al+292>>2];aR=aI*+g[al+264>>2]+au*+g[al+280>>2]+aE*+g[al+296>>2];aE=+g[ak+324>>2];au=+g[ak+328>>2];aI=+g[ak+320>>2];aS=+g[al+324>>2];aT=+g[al+328>>2];aU=+g[al+320>>2];aV=1.0/(+g[ak+336>>2]+(aH*(aq*az-aw*aD)+(ar*(ay*aD-aq*aO)+aF*(aw*aO-ay*az)))+(+g[al+336>>2]+(aH*(aC*aP-aG*aQ)+(ar*(aJ*aQ-aC*aR)+aF*(aG*aR-aJ*aP)))))*(-0.0-((ay*aE-aq*au+ +g[ak+304>>2]-(aJ*aS-aC*aT+ +g[al+304>>2]))*ar+(+g[ak+308>>2]+(aw*au-ay*aI)-(+g[al+308>>2]+(aG*aT-aJ*aU)))*aF+(aq*aI-aw*aE+ +g[ak+312>>2]-(aC*aU-aG*aS+ +g[al+312>>2]))*aH));aH=aA<aV?aA:aV;aV=-0.0-aA;g[(c[w>>2]|0)+(aK<<2)>>2]=0.0;g[(c[n>>2]|0)+(aK*284|0)+280>>2]=1.0;aN=aH<aV?aV:aH}g[(c[n>>2]|0)+(aK*284|0)+280>>2]=1.0;aH=+g[an+(aK*284|0)+276>>2]*d*+g[an+(aK*284|0)+228>>2];g[(c[w>>2]|0)+(aK<<2)>>2]=aN;aV=+g[(c[w>>2]|0)+(aK<<2)>>2]*.5;aA=+g[(c[v>>2]|0)+(aK<<2)>>2];aS=aV*aV+aA*aA;if(aS<=aH*aH){aM=aL;break}aA=aH/+Q(+aS);ak=(c[n>>2]|0)+(aK*284|0)+280|0;g[ak>>2]=aA*+g[ak>>2];aM=1}}while(0);an=aK+1|0;aW=c[u>>2]|0;if((an|0)<(aW|0)){aK=an;aL=aM}else{break}}if(aM){if((aW|0)>0){aX=0;aY=aW}else{i=e;return}while(1){do{if(+g[(c[v>>2]|0)+(aX<<2)>>2]!=0.0){aN=+g[(c[n>>2]|0)+(aX*284|0)+280>>2];if(aN>=1.0){aZ=aY;break}aM=(c[w>>2]|0)+(aX<<2)|0;g[aM>>2]=aN*+g[aM>>2];aM=(c[v>>2]|0)+(aX<<2)|0;g[aM>>2]=+g[(c[n>>2]|0)+(aX*284|0)+280>>2]*+g[aM>>2];aZ=c[u>>2]|0}else{aZ=aY}}while(0);aM=aX+1|0;if((aM|0)<(aZ|0)){aX=aM;aY=aZ}else{a_=aZ;break}}}else{a_=aW}if((a_|0)<=0){i=e;return}a_=p|0;aW=p+4|0;aZ=p+8|0;aY=p+12|0;aX=q|0;aM=q+4|0;aL=q+8|0;aK=q+12|0;an=r|0;al=r+4|0;ak=r+8|0;aj=r+12|0;h=s|0;f=s+4|0;l=s+8|0;k=s+12|0;j=b+124|0;b=t|0;ai=t+4|0;ah=t+8|0;ag=t+12|0;af=0;do{ae=c[n>>2]|0;ad=c[m>>2]|0;ac=ae+(af*284|0)+16|0;ab=ae+(af*284|0)+20|0;aN=+g[ab>>2]- +g[ad+56>>2];aa=ae+(af*284|0)+24|0;d=+g[aa>>2]- +g[ad+60>>2];g[a_>>2]=+g[ac>>2]- +g[ad+52>>2];g[aW>>2]=aN;g[aZ>>2]=d;g[aY>>2]=0.0;d=+g[(c[w>>2]|0)+(af<<2)>>2];if(d!=0.0){$=c[F>>2]|0;aN=d*+g[$+(af<<4)+4>>2];aA=d*+g[$+(af<<4)+8>>2];g[aX>>2]=d*+g[$+(af<<4)>>2];g[aM>>2]=aN;g[aL>>2]=aA;g[aK>>2]=0.0;pe(ad,q,p)}aA=+g[(c[v>>2]|0)+(af<<2)>>2];if(aA!=0.0){ad=c[(c[n>>2]|0)+(af*284|0)+88>>2]|0;aN=+g[ab>>2]- +g[ad+56>>2];d=+g[aa>>2]- +g[ad+60>>2];g[an>>2]=+g[ac>>2]- +g[ad+52>>2];g[al>>2]=aN;g[ak>>2]=d;g[aj>>2]=0.0;ac=c[K>>2]|0;d=aA*+g[ac+(af<<4)+4>>2];aN=aA*+g[ac+(af<<4)+8>>2];g[h>>2]=+g[ac+(af<<4)>>2]*aA;g[f>>2]=d;g[l>>2]=aN;g[k>>2]=0.0;ac=c[m>>2]|0;aa=c[j>>2]|0;aN=+g[ac+4+(aa<<2)>>2];d=+g[ac+20+(aa<<2)>>2];aA=+g[ac+36+(aa<<2)>>2];aS=+g[a_>>2];aH=+g[aW>>2];aV=+g[aZ>>2];aG=(aN*aS+d*aH+aA*aV)*(1.0- +g[ae+(af*284|0)+244>>2]);g[a_>>2]=aS-aN*aG;g[aW>>2]=aH-d*aG;g[aZ>>2]=aV-aA*aG;pe(ac,s,p);aG=-0.0- +g[f>>2];aA=-0.0- +g[l>>2];g[b>>2]=-0.0- +g[h>>2];g[ai>>2]=aG;g[ah>>2]=aA;g[ag>>2]=0.0;pe(ad,t,r)}af=af+1|0;}while((af|0)<(c[u>>2]|0));i=e;return}function apT(a){a=a|0;return}function apU(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;c[a+120>>2]=b;c[a+124>>2]=d;c[a+128>>2]=e;return}function apV(a,b,d){a=a|0;b=+b;d=d|0;var e=0,f=0,h=0.0,i=0.0,j=0.0,k=0.0,l=0.0,m=0.0;e=a+204|0;f=c[e>>2]|0;if(b==0.0){c[e>>2]=f|1;g[a+336>>2]=0.0;h=0.0}else{c[e>>2]=f&-2;i=1.0/b;g[a+336>>2]=i;h=i}i=+g[a+376>>2]*b;j=+g[a+380>>2]*b;g[a+356>>2]=+g[a+372>>2]*b;g[a+360>>2]=i;g[a+364>>2]=j;g[a+368>>2]=0.0;j=+g[d>>2];if(j!=0.0){k=1.0/j}else{k=0.0}j=+g[d+4>>2];if(j!=0.0){l=1.0/j}else{l=0.0}j=+g[d+8>>2];if(j!=0.0){m=1.0/j}else{m=0.0}g[a+388>>2]=k;g[a+392>>2]=l;g[a+396>>2]=m;g[a+400>>2]=0.0;m=h*+g[a+344>>2];l=h*+g[a+348>>2];g[a+552>>2]=+g[a+340>>2]*h;g[a+556>>2]=m;g[a+560>>2]=l;g[a+564>>2]=0.0;return}function apW(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0.0,E=0.0;e=i;i=i+48|0;f=e|0;h=e+16|0;j=e+32|0;k=b+136|0;if((c[k>>2]|0)<=0){i=e;return}l=f|0;m=f+4|0;n=f+8|0;o=f+12|0;p=b+144|0;q=h;r=b+120|0;b=d;s=h|0;t=h+4|0;u=h+8|0;v=j|0;w=j+4|0;x=j+8|0;y=j+12|0;z=0;do{g[l>>2]=0.0;g[m>>2]=1.0;g[n>>2]=1.0;g[o>>2]=0.0;A=c[p>>2]|0;g[l>>2]=(a[A+(z*284|0)+84|0]&1)==0?1.0:0.0;g[m>>2]=0.0;g[n>>2]=1.0;g[o>>2]=0.0;B=A+(z*284|0)+140|0;c[q>>2]=c[B>>2];c[q+4>>2]=c[B+4>>2];c[q+8>>2]=c[B+8>>2];c[q+12>>2]=c[B+12>>2];B=c[r>>2]|0;C=c[(c[b>>2]|0)+8>>2]|0;D=+g[A+(z*284|0)+108+(B<<2)>>2]+ +g[t>>2];E=+g[A+(z*284|0)+124+(B<<2)>>2]+ +g[u>>2];g[v>>2]=+g[A+(z*284|0)+92+(B<<2)>>2]+ +g[s>>2];g[w>>2]=D;g[x>>2]=E;g[y>>2]=0.0;dI[C&1023](d,h,j,f);dI[c[(c[b>>2]|0)+8>>2]&1023](d,h,(c[p>>2]|0)+(z*284|0)+16|0,f);z=z+1|0;}while((z|0)<(c[k>>2]|0));i=e;return}function apX(a,d,e,f){a=a|0;d=d|0;e=e|0;f=f|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0.0,q=0.0,r=0.0,s=0.0;h=i;i=i+88|0;j=h|0;k=j+4|0;g[k>>2]=1.0;l=j+8|0;c[l>>2]=0;b[j+12>>1]=1;b[j+14>>1]=-1;c[j+16>>2]=0;c[j>>2]=19480;m=j+20|0;n=d;c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];n=j+36|0;m=e;c[n>>2]=c[m>>2];c[n+4>>2]=c[m+4>>2];c[n+8>>2]=c[m+8>>2];c[n+12>>2]=c[m+12>>2];m=c[a+4>>2]|0;dI[c[(c[m>>2]|0)+28>>2]&1023](m|0,d,e,j|0);e=c[l>>2]|0;if((e|0)==0){o=0;i=h;return o|0}if((c[e+232>>2]&2|0)==0){o=0;i=h;return o|0}if((c[e+204>>2]&4|0)!=0){o=0;i=h;return o|0}l=f;d=j+68|0;c[l>>2]=c[d>>2];c[l+4>>2]=c[d+4>>2];c[l+8>>2]=c[d+8>>2];c[l+12>>2]=c[d+12>>2];d=f+16|0;l=d;m=j+52|0;c[l>>2]=c[m>>2];c[l+4>>2]=c[m+4>>2];c[l+8>>2]=c[m+8>>2];c[l+12>>2]=c[m+12>>2];m=d|0;p=+g[m>>2];d=f+20|0;q=+g[d>>2];l=f+24|0;r=+g[l>>2];s=1.0/+Q(+(p*p+q*q+r*r));g[m>>2]=p*s;g[d>>2]=q*s;g[l>>2]=r*s;g[f+32>>2]=+g[k>>2];o=e;i=h;return o|0}function apY(a,b,d){a=a|0;b=b|0;d=+d;cq[c[(c[a>>2]|0)+16>>2]&1023](a,d);return}function apZ(a){a=a|0;if((a|0)==0){return}aDB(a);return}function ap_(b,d){b=b|0;d=d|0;var e=0,f=0,h=0,i=0.0,j=0.0,k=0.0,l=0.0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0,L=0.0,M=0.0,N=0.0;c[b+232>>2]=2;aDD(b+304|0,0,32);g[b+536>>2]=1.0;g[b+540>>2]=1.0;g[b+544>>2]=1.0;g[b+548>>2]=0.0;e=b+340|0;g[e>>2]=1.0;f=b+344|0;g[f>>2]=1.0;h=b+348|0;g[h>>2]=1.0;aDD(b+352|0,0,36);aDD(b+404|0,0,32);i=+g[d+92>>2];j=+g[d+96>>2];if(i<0.0){k=0.0}else{k=i>1.0?1.0:i}g[b+436>>2]=k;if(j<0.0){l=0.0}else{l=j>1.0?1.0:j}g[b+440>>2]=l;g[b+464>>2]=+g[d+108>>2];g[b+468>>2]=+g[d+112>>2];m=c[d+4>>2]|0;c[b+472>>2]=m;c[b+600>>2]=0;c[b+604>>2]=0;a[b+444|0]=a[d+116|0]&1;g[b+448>>2]=+g[d+120>>2];g[b+452>>2]=+g[d+124>>2];g[b+456>>2]=+g[d+128>>2];g[b+460>>2]=+g[d+132>>2];if((m|0)==0){n=b+4|0;o=d+8|0;c[n>>2]=c[o>>2];c[n+4>>2]=c[o+4>>2];c[n+8>>2]=c[o+8>>2];c[n+12>>2]=c[o+12>>2];o=b+20|0;p=d+24|0;c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];p=b+36|0;q=d+40|0;c[p>>2]=c[q>>2];c[p+4>>2]=c[q+4>>2];c[p+8>>2]=c[q+8>>2];c[p+12>>2]=c[q+12>>2];q=b+52|0;r=d+56|0;c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];s=n;t=o;u=p;v=q}else{q=b+4|0;cv[c[(c[m>>2]|0)+8>>2]&2047](m,q);s=q;t=b+20|0;u=b+36|0;v=b+52|0}q=b+68|0;c[q>>2]=c[s>>2];c[q+4>>2]=c[s+4>>2];c[q+8>>2]=c[s+8>>2];c[q+12>>2]=c[s+12>>2];s=b+84|0;c[s>>2]=c[t>>2];c[s+4>>2]=c[t+4>>2];c[s+8>>2]=c[t+8>>2];c[s+12>>2]=c[t+12>>2];t=b+100|0;c[t>>2]=c[u>>2];c[t+4>>2]=c[u+4>>2];c[t+8>>2]=c[u+8>>2];c[t+12>>2]=c[u+12>>2];u=b+116|0;c[u>>2]=c[v>>2];c[u+4>>2]=c[v+4>>2];c[u+8>>2]=c[v+8>>2];c[u+12>>2]=c[v+12>>2];aDD(b+132|0,0,32);g[b+224>>2]=+g[d+100>>2];g[b+228>>2]=+g[d+104>>2];cv[c[(c[b>>2]|0)+12>>2]&2047](b|0,c[d+72>>2]|0);v=c[10738]|0;c[10738]=v+1;c[b+500>>2]=v;l=+g[d>>2];v=b+204|0;u=c[v>>2]|0;if(l==0.0){c[v>>2]=u|1;g[b+336>>2]=0.0;w=0.0}else{c[v>>2]=u&-2;j=1.0/l;g[b+336>>2]=j;w=j}j=l*+g[b+376>>2];k=l*+g[b+380>>2];g[b+356>>2]=l*+g[b+372>>2];g[b+360>>2]=j;g[b+364>>2]=k;g[b+368>>2]=0.0;k=+g[d+76>>2];if(k!=0.0){x=1.0/k}else{x=0.0}k=+g[d+80>>2];if(k!=0.0){y=1.0/k}else{y=0.0}k=+g[d+84>>2];if(k!=0.0){z=1.0/k}else{z=0.0}g[b+388>>2]=x;g[b+392>>2]=y;g[b+396>>2]=z;g[b+400>>2]=0.0;k=w*+g[e>>2];j=w*+g[f>>2];l=w*+g[h>>2];w=+g[b+4>>2];i=w*x;A=+g[b+8>>2];B=A*y;C=+g[b+12>>2];D=C*z;E=+g[b+20>>2];F=x*E;G=+g[b+24>>2];H=y*G;I=+g[b+28>>2];J=z*I;K=+g[b+36>>2];L=x*K;x=+g[b+40>>2];M=y*x;y=+g[b+44>>2];N=z*y;g[b+256>>2]=w*i+A*B+C*D;g[b+260>>2]=i*E+B*G+D*I;g[b+264>>2]=i*K+B*x+D*y;g[b+268>>2]=0.0;g[b+272>>2]=w*F+A*H+C*J;g[b+276>>2]=E*F+G*H+I*J;g[b+280>>2]=F*K+H*x+J*y;g[b+284>>2]=0.0;g[b+288>>2]=w*L+A*M+C*N;g[b+292>>2]=E*L+G*M+I*N;g[b+296>>2]=K*L+x*M+y*N;g[b+300>>2]=0.0;c[b+496>>2]=0;aDD(b+504|0,0,32);g[b+552>>2]=k;g[b+556>>2]=j;g[b+560>>2]=l;aDD(b+564|0,0,36);return}function ap$(b,d,e,f,h){b=b|0;d=+d;e=e|0;f=f|0;h=h|0;var j=0,k=0;j=i;i=i+136|0;k=j|0;g[b+164>>2]=1.0;g[b+168>>2]=1.0;g[b+172>>2]=1.0;g[b+176>>2]=0.0;c[b+180>>2]=0;g[b+184>>2]=999999984306749400.0;aDD(b+188|0,0,16);c[b+204>>2]=1;c[b+208>>2]=-1;c[b+212>>2]=-1;c[b+216>>2]=1;g[b+220>>2]=0.0;g[b+224>>2]=.5;g[b+228>>2]=0.0;c[b+232>>2]=1;c[b+236>>2]=0;g[b+240>>2]=1.0;g[b+244>>2]=0.0;g[b+248>>2]=0.0;c[b+252>>2]=0;g[b+4>>2]=1.0;aDD(b+8|0,0,16);g[b+24>>2]=1.0;aDD(b+28|0,0,16);g[b+44>>2]=1.0;aDD(b+48|0,0,20);c[b>>2]=26048;a[b+492|0]=1;c[b+488>>2]=0;c[b+480>>2]=0;c[b+484>>2]=0;g[k>>2]=d;c[k+4>>2]=e;c[k+72>>2]=f;f=k+76|0;e=h;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];g[k+92>>2]=0.0;g[k+96>>2]=0.0;g[k+100>>2]=.5;g[k+104>>2]=0.0;g[k+108>>2]=.800000011920929;g[k+112>>2]=1.0;a[k+116|0]=0;g[k+120>>2]=.004999999888241291;g[k+124>>2]=.009999999776482582;g[k+128>>2]=.009999999776482582;g[k+132>>2]=.009999999776482582;g[k+8>>2]=1.0;aDD(k+12|0,0,16);g[k+28>>2]=1.0;aDD(k+32|0,0,16);g[k+48>>2]=1.0;aDD(k+52|0,0,20);ap_(b,k);i=j;return}function ap0(a,b){a=a|0;b=+b;var d=0,e=0,f=0,h=0,j=0,k=0,l=0,m=0.0,n=0.0,o=0.0;d=i;i=i+24|0;e=d|0;f=d+16|0;if(b==0.0){i=d;return}h=c[a+472>>2]|0;if((h|0)==0){j=a+4|0}else{k=a+4|0;cv[c[(c[h>>2]|0)+8>>2]&2047](h,k);j=k}k=a+68|0;h=a+304|0;l=a+320|0;m=1.0/b;b=(+g[a+56>>2]- +g[a+120>>2])*m;n=m*(+g[a+60>>2]- +g[a+124>>2]);g[h>>2]=(+g[a+52>>2]- +g[a+116>>2])*m;g[a+308>>2]=b;g[a+312>>2]=n;g[a+316>>2]=0.0;an6(k,j,e,f);n=+g[f>>2];b=m*n*+g[e+4>>2];o=m*n*+g[e+8>>2];g[l>>2]=m*+g[e>>2]*n;g[a+324>>2]=b;g[a+328>>2]=o;g[a+332>>2]=0.0;e=a+132|0;f=h;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];f=a+148|0;e=l;c[f>>2]=c[e>>2];c[f+4>>2]=c[e+4>>2];c[f+8>>2]=c[e+8>>2];c[f+12>>2]=c[e+12>>2];e=k;k=j;c[e>>2]=c[k>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];k=a+84|0;e=a+20|0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];e=a+100|0;k=a+36|0;c[e>>2]=c[k>>2];c[e+4>>2]=c[k+4>>2];c[e+8>>2]=c[k+8>>2];c[e+12>>2]=c[k+12>>2];k=a+116|0;e=a+52|0;c[k>>2]=c[e>>2];c[k+4>>2]=c[e+4>>2];c[k+8>>2]=c[e+8>>2];c[k+12>>2]=c[e+12>>2];i=d;return}function ap1(a){a=a|0;return 480}function ap2(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;if((c[b+232>>2]&2|0)==0){d=1;return d|0}e=b;b=a+488|0;f=c[a+480>>2]|0;a=0;while(1){if((a|0)>=(f|0)){d=1;g=4452;break}h=c[(c[b>>2]|0)+(a<<2)>>2]|0;if((c[h+24>>2]|0)==(e|0)){d=0;g=4455;break}if((c[h+28>>2]|0)==(e|0)){d=0;g=4453;break}else{a=a+1|0}}if((g|0)==4455){return d|0}else if((g|0)==4452){return d|0}else if((g|0)==4453){return d|0}return 0}function ap3(b,c){b=b|0;c=+c;var d=0.0,e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0.0,m=0.0,n=0,o=0,p=0.0,q=0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0;d=+g[b+436>>2];e=+R(+(1.0-d),+c);f=b+304|0;h=e*+g[f>>2];g[f>>2]=h;i=b+308|0;j=e*+g[i>>2];g[i>>2]=j;k=b+312|0;l=e*+g[k>>2];g[k>>2]=l;e=+g[b+440>>2];m=+R(+(1.0-e),+c);n=b+320|0;c=m*+g[n>>2];g[n>>2]=c;o=b+324|0;p=m*+g[o>>2];g[o>>2]=p;q=b+328|0;r=m*+g[q>>2];g[q>>2]=r;if((a[b+444|0]&1)==0){return}do{if(r*r+(c*c+p*p)<+g[b+456>>2]){if(h*h+j*j+l*l>=+g[b+452>>2]){s=h;t=j;u=l;v=c;w=p;x=r;break}m=+g[b+448>>2];y=c*m;g[n>>2]=y;z=m*p;g[o>>2]=z;A=m*r;g[q>>2]=A;B=m*h;g[f>>2]=B;C=m*j;g[i>>2]=C;D=m*l;g[k>>2]=D;s=B;t=C;u=D;v=y;w=z;x=A}else{s=h;t=j;u=l;v=c;w=p;x=r}}while(0);r=+Q(+(s*s+t*t+u*u));do{if(r<d){if(r>.004999999888241291){p=1.0/r;g[f>>2]=s-s*p*.004999999888241291;g[i>>2]=t-t*p*.004999999888241291;g[k>>2]=u-u*p*.004999999888241291;break}else{aDD(f|0,0,16);break}}}while(0);u=+Q(+(v*v+w*w+x*x));if(u>=e){return}if(u>.004999999888241291){e=1.0/u;g[n>>2]=v-v*e*.004999999888241291;g[o>>2]=w-w*e*.004999999888241291;g[q>>2]=x-x*e*.004999999888241291;return}else{aDD(n|0,0,16);return}}function ap4(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0.0,t=0.0,u=0.0,v=0.0,w=0.0,x=0.0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0,D=0.0,E=0.0,F=0.0,G=0.0,H=0.0,I=0.0,J=0.0,K=0.0;d=a+68|0;if((c[a+204>>2]&3|0)==0){e=d;f=b;c[e>>2]=c[f>>2];c[e+4>>2]=c[f+4>>2];c[e+8>>2]=c[f+8>>2];c[e+12>>2]=c[f+12>>2];e=a+84|0;h=b+16|0;c[e>>2]=c[h>>2];c[e+4>>2]=c[h+4>>2];c[e+8>>2]=c[h+8>>2];c[e+12>>2]=c[h+12>>2];e=a+100|0;i=b+32|0;c[e>>2]=c[i>>2];c[e+4>>2]=c[i+4>>2];c[e+8>>2]=c[i+8>>2];c[e+12>>2]=c[i+12>>2];e=a+116|0;j=b+48|0;c[e>>2]=c[j>>2];c[e+4>>2]=c[j+4>>2];c[e+8>>2]=c[j+8>>2];c[e+12>>2]=c[j+12>>2];k=a+4|0;l=f;m=a+20|0;n=h;o=a+36|0;p=i;q=a+52|0;r=j}else{j=d;d=a+4|0;c[j>>2]=c[d>>2];c[j+4>>2]=c[d+4>>2];c[j+8>>2]=c[d+8>>2];c[j+12>>2]=c[d+12>>2];j=a+84|0;i=a+20|0;c[j>>2]=c[i>>2];c[j+4>>2]=c[i+4>>2];c[j+8>>2]=c[i+8>>2];c[j+12>>2]=c[i+12>>2];j=a+100|0;h=a+36|0;c[j>>2]=c[h>>2];c[j+4>>2]=c[h+4>>2];c[j+8>>2]=c[h+8>>2];c[j+12>>2]=c[h+12>>2];j=a+116|0;f=a+52|0;c[j>>2]=c[f>>2];c[j+4>>2]=c[f+4>>2];c[j+8>>2]=c[f+8>>2];c[j+12>>2]=c[f+12>>2];k=d;l=b;m=i;n=b+16|0;o=h;p=b+32|0;q=f;r=b+48|0}b=a+132|0;f=a+304|0;c[b>>2]=c[f>>2];c[b+4>>2]=c[f+4>>2];c[b+8>>2]=c[f+8>>2];c[b+12>>2]=c[f+12>>2];f=a+148|0;b=a+320|0;c[f>>2]=c[b>>2];c[f+4>>2]=c[b+4>>2];c[f+8>>2]=c[b+8>>2];c[f+12>>2]=c[b+12>>2];c[k>>2]=c[l>>2];c[k+4>>2]=c[l+4>>2];c[k+8>>2]=c[l+8>>2];c[k+12>>2]=c[l+12>>2];c[m>>2]=c[n>>2];c[m+4>>2]=c[n+4>>2];c[m+8>>2]=c[n+8>>2];c[m+12>>2]=c[n+12>>2];c[o>>2]=c[p>>2];c[o+4>>2]=c[p+4>>2];c[o+8>>2]=c[p+8>>2];c[o+12>>2]=c[p+12>>2];c[q>>2]=c[r>>2];c[q+4>>2]=c[r+4>>2];c[q+8>>2]=c[r+8>>2];c[q+12>>2]=c[r+12>>2];s=+g[a+4>>2];t=+g[a+388>>2];u=s*t;v=+g[a+8>>2];w=+g[a+392>>2];x=v*w;y=+g[a+12>>2];z=+g[a+396>>2];A=y*z;B=+g[a+20>>2];C=t*B;D=+g[a+24>>2];E=w*D;F=+g[a+28>>2];G=z*F;H=+g[a+36>>2];I=t*H;t=+g[a+40>>2];J=w*t;w=+g[a+44>>2];K=z*w;g[a+256>>2]=s*u+v*x+y*A;g[a+260>>2]=u*B+x*D+A*F;g[a+264>>2]=u*H+x*t+A*w;g[a+268>>2]=0.0;g[a+272>>2]=s*C+v*E+y*G;g[a+276>>2]=B*C+D*E+F*G;g[a+280>>2]=C*H+E*t+G*w;g[a+284>>2]=0.0;g[a+288>>2]=s*I+v*J+y*K;g[a+292>>2]=B*I+D*J+F*K;g[a+296>>2]=H*I+t*J+w*K;g[a+300>>2]=0.0;return}function ap5(a,b){a=a|0;b=+b;var d=0.0,e=0.0,f=0.0,h=0,i=0.0,j=0.0,k=0.0,l=0,m=0;if((c[a+204>>2]&3|0)!=0){return}d=+g[a+336>>2]*b;e=d*+g[a+408>>2];f=d*+g[a+412>>2];h=a+304|0;g[h>>2]=+g[a+404>>2]*d+ +g[h>>2];h=a+308|0;g[h>>2]=e+ +g[h>>2];h=a+312|0;g[h>>2]=f+ +g[h>>2];f=+g[a+420>>2];e=+g[a+424>>2];d=+g[a+428>>2];i=(f*+g[a+272>>2]+e*+g[a+276>>2]+d*+g[a+280>>2])*b;j=(f*+g[a+288>>2]+e*+g[a+292>>2]+d*+g[a+296>>2])*b;h=a+320|0;k=(+g[a+256>>2]*f+ +g[a+260>>2]*e+ +g[a+264>>2]*d)*b+ +g[h>>2];g[h>>2]=k;l=a+324|0;d=i+ +g[l>>2];g[l>>2]=d;m=a+328|0;i=j+ +g[m>>2];g[m>>2]=i;j=+Q(+(i*i+(k*k+d*d)));if(j*b<=1.5707963705062866){return}e=1.5707963705062866/b/j;g[h>>2]=k*e;g[l>>2]=e*d;g[m>>2]=e*i;return}function ap6(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;e=b+480|0;f=c[e>>2]|0;g=b+488|0;h=0;while(1){if((h|0)>=(f|0)){break}if((c[(c[g>>2]|0)+(h<<2)>>2]|0)==(d|0)){i=4487;break}else{h=h+1|0}}do{if((i|0)==4487){if((h|0)==(f|0)){break}j=b+252|0;c[j>>2]=1;return}}while(0);h=b+484|0;do{if((f|0)==(c[h>>2]|0)){i=(f|0)==0?1:f<<1;if((f|0)>=(i|0)){k=f;break}if((i|0)==0){l=0;m=f}else{c[9806]=(c[9806]|0)+1;n=aDx((i<<2)+19|0)|0;if((n|0)==0){o=0}else{p=-(n+4|0)&15;c[n+p>>2]=n;o=n+(p+4)|0}l=o;m=c[e>>2]|0}if((m|0)>0){p=0;do{n=l+(p<<2)|0;if((n|0)!=0){c[n>>2]=c[(c[g>>2]|0)+(p<<2)>>2]}p=p+1|0;}while((p|0)<(m|0))}p=c[g>>2]|0;n=b+492|0;if((p|0)!=0){if((a[n]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[p-4>>2]|0)}c[g>>2]=0}a[n]=1;c[g>>2]=l;c[h>>2]=i;k=c[e>>2]|0}else{k=f}}while(0);f=(c[g>>2]|0)+(k<<2)|0;if((f|0)==0){q=k}else{c[f>>2]=d;q=c[e>>2]|0}c[e>>2]=q+1;j=b+252|0;c[j>>2]=1;return}function ap7(b,d,e){b=b|0;d=d|0;e=e|0;atq(b|0,d,e)|0;g[d+248>>2]=+g[b+256>>2];g[d+252>>2]=+g[b+260>>2];g[d+256>>2]=+g[b+264>>2];g[d+260>>2]=+g[b+268>>2];g[d+264>>2]=+g[b+272>>2];g[d+268>>2]=+g[b+276>>2];g[d+272>>2]=+g[b+280>>2];g[d+276>>2]=+g[b+284>>2];g[d+280>>2]=+g[b+288>>2];g[d+284>>2]=+g[b+292>>2];g[d+288>>2]=+g[b+296>>2];g[d+292>>2]=+g[b+300>>2];g[d+296>>2]=+g[b+304>>2];g[d+300>>2]=+g[b+308>>2];g[d+304>>2]=+g[b+312>>2];g[d+308>>2]=+g[b+316>>2];g[d+312>>2]=+g[b+320>>2];g[d+316>>2]=+g[b+324>>2];g[d+320>>2]=+g[b+328>>2];g[d+324>>2]=+g[b+332>>2];g[d+440>>2]=+g[b+336>>2];g[d+328>>2]=+g[b+536>>2];g[d+332>>2]=+g[b+540>>2];g[d+336>>2]=+g[b+544>>2];g[d+340>>2]=+g[b+548>>2];g[d+344>>2]=+g[b+340>>2];g[d+348>>2]=+g[b+344>>2];g[d+352>>2]=+g[b+348>>2];g[d+356>>2]=+g[b+352>>2];g[d+360>>2]=+g[b+356>>2];g[d+364>>2]=+g[b+360>>2];g[d+368>>2]=+g[b+364>>2];g[d+372>>2]=+g[b+368>>2];g[d+376>>2]=+g[b+372>>2];g[d+380>>2]=+g[b+376>>2];g[d+384>>2]=+g[b+380>>2];g[d+388>>2]=+g[b+384>>2];g[d+392>>2]=+g[b+388>>2];g[d+396>>2]=+g[b+392>>2];g[d+400>>2]=+g[b+396>>2];g[d+404>>2]=+g[b+400>>2];g[d+408>>2]=+g[b+404>>2];g[d+412>>2]=+g[b+408>>2];g[d+416>>2]=+g[b+412>>2];g[d+420>>2]=+g[b+416>>2];g[d+424>>2]=+g[b+420>>2];g[d+428>>2]=+g[b+424>>2];g[d+432>>2]=+g[b+428>>2];g[d+436>>2]=+g[b+432>>2];g[d+444>>2]=+g[b+436>>2];g[d+448>>2]=+g[b+440>>2];c[d+476>>2]=a[b+444|0]&1;g[d+452>>2]=+g[b+448>>2];g[d+456>>2]=+g[b+452>>2];g[d+460>>2]=+g[b+456>>2];g[d+464>>2]=+g[b+460>>2];g[d+468>>2]=+g[b+464>>2];g[d+472>>2]=+g[b+468>>2];return 17400}function ap8(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=c[(c[b>>2]|0)+16>>2]|0;e=cA[c[(c[a>>2]|0)+16>>2]&4095](a)|0;f=cS[d&511](b,e,1)|0;e=cS[c[(c[a>>2]|0)+20>>2]&511](a,c[f+8>>2]|0,b)|0;co[c[(c[b>>2]|0)+20>>2]&255](b,f,e,1497645650,a);return}function ap9(a,b){a=a|0;b=b|0;c[a+192>>2]=b;c[a+200>>2]=b;return}function aqa(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0,h=0.0,i=0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;d=c+84|0;e=+g[d>>2];f=c+16|0;h=+g[f>>2];i=a+504|0;j=c+20|0;k=+g[j>>2];l=a+508|0;m=c+24|0;n=+g[m>>2];o=a+512|0;p=a+520|0;q=a+524|0;r=a+528|0;s=b+504|0;t=b+508|0;u=b+512|0;v=b+520|0;w=b+524|0;x=b+528|0;y=+g[c+92>>2];z=+g[c+116>>2]-e*+g[c+120>>2]-(h*+g[i>>2]+k*+g[l>>2]+n*+g[o>>2]+(+g[c>>2]*+g[p>>2]+ +g[c+4>>2]*+g[q>>2]+ +g[c+8>>2]*+g[r>>2]))*y-y*(+g[c+32>>2]*+g[v>>2]+ +g[c+36>>2]*+g[w>>2]+ +g[c+40>>2]*+g[x>>2]-(h*+g[s>>2]+k*+g[t>>2]+n*+g[u>>2]));y=e+z;A=+g[c+124>>2];do{if(y<A){g[d>>2]=A;B=A-e}else{C=+g[c+128>>2];if(y>C){g[d>>2]=C;B=C-e;break}else{g[d>>2]=y;B=z;break}}}while(0);if(+g[a+336>>2]!=0.0){z=B*+g[a+556>>2]*k;k=B*+g[a+560>>2]*n;g[i>>2]=+g[i>>2]+B*+g[a+552>>2]*h;g[l>>2]=z+ +g[l>>2];g[o>>2]=k+ +g[o>>2];k=B*+g[a+540>>2]*+g[c+52>>2];z=B*+g[a+544>>2]*+g[c+56>>2];g[p>>2]=B*+g[a+536>>2]*+g[c+48>>2]+ +g[p>>2];g[q>>2]=k+ +g[q>>2];g[r>>2]=z+ +g[r>>2]}if(+g[b+336>>2]==0.0){return}z=B*+g[b+556>>2]*(-0.0- +g[j>>2]);k=B*+g[b+560>>2]*(-0.0- +g[m>>2]);g[s>>2]=+g[s>>2]+B*+g[b+552>>2]*(-0.0- +g[f>>2]);g[t>>2]=z+ +g[t>>2];g[u>>2]=k+ +g[u>>2];k=B*+g[b+540>>2]*+g[c+68>>2];z=B*+g[b+544>>2]*+g[c+72>>2];g[v>>2]=B*+g[b+536>>2]*+g[c+64>>2]+ +g[v>>2];g[w>>2]=k+ +g[w>>2];g[x>>2]=z+ +g[x>>2];return}function aqb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0.0,f=0,h=0.0,i=0,j=0,k=0.0,l=0,m=0,n=0.0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0.0,z=0.0,A=0.0,B=0.0,C=0.0;d=c+84|0;e=+g[d>>2];f=c+16|0;h=+g[f>>2];i=a+504|0;j=c+20|0;k=+g[j>>2];l=a+508|0;m=c+24|0;n=+g[m>>2];o=a+512|0;p=a+520|0;q=a+524|0;r=a+528|0;s=b+504|0;t=b+508|0;u=b+512|0;v=b+520|0;w=b+524|0;x=b+528|0;y=+g[c+92>>2];z=+g[c+116>>2]-e*+g[c+120>>2]-(h*+g[i>>2]+k*+g[l>>2]+n*+g[o>>2]+(+g[c>>2]*+g[p>>2]+ +g[c+4>>2]*+g[q>>2]+ +g[c+8>>2]*+g[r>>2]))*y-y*(+g[c+32>>2]*+g[v>>2]+ +g[c+36>>2]*+g[w>>2]+ +g[c+40>>2]*+g[x>>2]-(h*+g[s>>2]+k*+g[t>>2]+n*+g[u>>2]));y=e+z;A=+g[c+124>>2];if(y<A){B=A-e;C=A}else{B=z;C=y}g[d>>2]=C;if(+g[a+336>>2]!=0.0){C=B*+g[a+556>>2]*k;k=B*+g[a+560>>2]*n;g[i>>2]=+g[i>>2]+B*+g[a+552>>2]*h;g[l>>2]=C+ +g[l>>2];g[o>>2]=k+ +g[o>>2];k=B*+g[a+540>>2]*+g[c+52>>2];C=B*+g[a+544>>2]*+g[c+56>>2];g[p>>2]=B*+g[a+536>>2]*+g[c+48>>2]+ +g[p>>2];g[q>>2]=k+ +g[q>>2];g[r>>2]=C+ +g[r>>2]}if(+g[b+336>>2]==0.0){return}C=B*+g[b+556>>2]*(-0.0- +g[j>>2]);k=B*+g[b+560>>2]*(-0.0- +g[m>>2]);g[s>>2]=+g[s>>2]+B*+g[b+552>>2]*(-0.0- +g[f>>2]);g[t>>2]=C+ +g[t>>2];g[u>>2]=k+ +g[u>>2];k=B*+g[b+540>>2]*+g[c+68>>2];C=B*+g[b+544>>2]*+g[c+72>>2];g[v>>2]=B*+g[b+536>>2]*+g[c+64>>2]+ +g[v>>2];g[w>>2]=k+ +g[w>>2];g[x>>2]=C+ +g[x>>2];return}function aqc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0.0,f=0,h=0.0,i=0,j=0.0,k=0,l=0,m=0.0,n=0,o=0,p=0.0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0.0,B=0.0,C=0.0,D=0.0;e=+g[d+132>>2];if(e==0.0){return}c[9794]=(c[9794]|0)+1;f=d+80|0;h=+g[f>>2];i=d+16|0;j=+g[i>>2];k=a+568|0;l=d+20|0;m=+g[l>>2];n=a+572|0;o=d+24|0;p=+g[o>>2];q=a+576|0;r=a+584|0;s=a+588|0;t=a+592|0;u=b+568|0;v=b+572|0;w=b+576|0;x=b+584|0;y=b+588|0;z=b+592|0;A=+g[d+92>>2];B=e-h*+g[d+120>>2]-(j*+g[k>>2]+m*+g[n>>2]+p*+g[q>>2]+(+g[d>>2]*+g[r>>2]+ +g[d+4>>2]*+g[s>>2]+ +g[d+8>>2]*+g[t>>2]))*A-A*(+g[d+32>>2]*+g[x>>2]+ +g[d+36>>2]*+g[y>>2]+ +g[d+40>>2]*+g[z>>2]-(j*+g[u>>2]+m*+g[v>>2]+p*+g[w>>2]));A=h+B;e=+g[d+124>>2];if(A<e){C=e-h;D=e}else{C=B;D=A}g[f>>2]=D;if(+g[a+336>>2]!=0.0){D=C*+g[a+556>>2]*m;m=C*+g[a+560>>2]*p;g[k>>2]=+g[k>>2]+C*+g[a+552>>2]*j;g[n>>2]=D+ +g[n>>2];g[q>>2]=m+ +g[q>>2];m=C*+g[a+540>>2]*+g[d+52>>2];D=C*+g[a+544>>2]*+g[d+56>>2];g[r>>2]=C*+g[a+536>>2]*+g[d+48>>2]+ +g[r>>2];g[s>>2]=m+ +g[s>>2];g[t>>2]=D+ +g[t>>2]}if(+g[b+336>>2]==0.0){return}D=C*+g[b+556>>2]*(-0.0- +g[l>>2]);m=C*+g[b+560>>2]*(-0.0- +g[o>>2]);g[u>>2]=+g[u>>2]+C*+g[b+552>>2]*(-0.0- +g[i>>2]);g[v>>2]=D+ +g[v>>2];g[w>>2]=m+ +g[w>>2];m=C*+g[b+540>>2]*+g[d+68>>2];D=C*+g[b+544>>2]*+g[d+72>>2];g[x>>2]=C*+g[b+536>>2]*+g[d+64>>2]+ +g[x>>2];g[y>>2]=m+ +g[y>>2];g[z>>2]=D+ +g[z>>2];return}function aqd(b){b=b|0;var d=0,e=0,f=0,g=0;c[b>>2]=26048;d=b+480|0;e=b+488|0;f=c[e>>2]|0;g=b+492|0;if((f|0)==0){a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+484>>2]=0}else{if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+484>>2]=0}c[9804]=(c[9804]|0)+1;aDB(c[b-608+604>>2]|0);return}function aqe(a){a=a|0;aqf(a);if((a|0)==0){return}aDB(a);return}function aqf(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;c[b>>2]=19632;d=b+108|0;e=b+116|0;f=c[e>>2]|0;g=b+120|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-8+4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+112>>2]=0;d=b+88|0;e=b+96|0;g=c[e>>2]|0;f=b+100|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-4>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+92>>2]=0;d=b+68|0;e=b+76|0;f=c[e>>2]|0;g=b+80|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-4>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+72>>2]=0;d=b+48|0;e=b+56|0;g=c[e>>2]|0;f=b+60|0;if((g|0)!=0){if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-136+132>>2]|0)}c[e>>2]=0}a[f]=1;c[e>>2]=0;c[d>>2]=0;c[b+52>>2]=0;d=b+28|0;e=b+36|0;f=c[e>>2]|0;g=b+40|0;if((f|0)!=0){if((a[g]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[f-136+132>>2]|0)}c[e>>2]=0}a[g]=1;c[e>>2]=0;c[d>>2]=0;c[b+32>>2]=0;d=b+8|0;e=b+16|0;g=c[e>>2]|0;f=b+20|0;if((g|0)==0){a[f]=1;c[e>>2]=0;c[d>>2]=0;h=b+12|0;c[h>>2]=0;return}if((a[f]&1)!=0){c[9804]=(c[9804]|0)+1;aDB(c[g-136+132>>2]|0)}c[e>>2]=0;a[f]=1;c[e>>2]=0;c[d>>2]=0;h=b+12|0;c[h>>2]=0;return}function aqg(a,b){a=a|0;b=b|0;var d=0.0,e=0,f=0.0,h=0.0,i=0,j=0.0,k=0.0,l=0,m=0.0,n=0.0,o=0.0,p=0.0,q=0.0,r=0.0,s=0.0,t=0.0,u=0.0,v=0.0;if((a|0)==0){return}if((c[a+180>>2]|0)==0){return}d=+g[a+4>>2];e=b|0;f=+g[e>>2];h=+g[a+