# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
The Adaptor2d package  is used to help defining
reusable geometric algorithms. i.e. that can be
used on curves and surfaces.

It defines general services for objects :

- the 2d curve.   Curve2d

The services are :

- Usual services found in Geom or Geom2d :

* parameter range, value and derivatives, etc...

- Continuity breakout services :

* Allows to divide a curve or a surfaces in
parts with a given derivation order.

- Special geometries detection services :

* Allows to test for special cases that can
be processed more easily :
- Conics, Quadrics, Bezier, BSpline ...

And to get the correponding data form the
package gp or  Geom.  The special type
OtherCurve means that no special case has
been detected and the algorithm may use
only the evaluation methods (D0, D1, ...)


For  each category Curve2d, Curve,  Surface we
define  three classes, we illustrate now the
principles with the Curve, the same applies to
Curve2d and Surface.

The class Curve is the  abstract root for all
Curves used by algorithms, it is handled by value
and  provides as deferred methods the services
described above.

Some services (breakout) requires to create new
curves,   this  leads  to  memory allocation
considerations (who create the curve, who deletes
it ?). To solve this problem elegantly the curve
will return a HCurve, the  HCurve is a  curve
handled by reference  so it will  be deallocated
automatically when it is not used.

A third class GenHCurve is provided, this class is
generic and its utility  is to provide automatic
generation of the HCurve class when you have
written the Curve class.


* Let us show an example (with 2d curves) :

Imagine an algorithm to intersect curves, this
algorithms is written to process Curve2d from
Adaptor2d :

A method may look like :

Intersect(C1,C2 : Curve2d from Adaptor2d);

Which will look like in C++

Intersect(const Adaptor2d_Curve2d& C1,
const Adaptor2d_Curve2d& C2)
{
// you can call any method
Standard_Real first1 = C1.FirstParameter();

// but avoid to copy in an Adaptor2d_Curve which
// is an Abstract class, use a reference or a pointer

const Adaptor2d_Curve& C = C1;
const Adaptor2d_Curve *pC = &C1;

// If you are interseted in Intervals you must
// store them in a HCurve to ensure they are kept
// in memory. Then a referrence may be used.

Handle(Adaptor2d_HCurve) HCI = C1.Interval(1);

const Adaptor2d_Curve& CI = HCI->Curve();
pC = &(HCI->Curve());


* The  Adaptor2d provides also Generic classes
implementing algorithmic curves and surfaces.

- IsoCurve    : Isoparametric curve on a surface.
- CurveOnSurface : 2D curve in the parametric
space of a surface.


- OffsetCurve2d : 2d offset curve
- ProjectedCurve : 3d curve projected on a plane
- SurfaceOfLinearExtrusion
- SurfaceOfRevolution

They are instantiated with HCurve, HSurface, HCurved2d

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _Adaptor2d.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Adaptor2d')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Adaptor2d')
    _Adaptor2d = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Adaptor2d', [dirname(__file__)])
        except ImportError:
            import _Adaptor2d
            return _Adaptor2d
        try:
            _mod = imp.load_module('_Adaptor2d', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Adaptor2d = swig_import_helper()
    del swig_import_helper
else:
    import _Adaptor2d
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Adaptor2d.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_Adaptor2d.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_Adaptor2d.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_Adaptor2d.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_Adaptor2d.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_Adaptor2d.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_Adaptor2d.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_Adaptor2d.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_Adaptor2d.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_Adaptor2d.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_Adaptor2d.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_Adaptor2d.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_Adaptor2d.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_Adaptor2d.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_Adaptor2d.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_Adaptor2d.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_Adaptor2d.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _Adaptor2d.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _Adaptor2d.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.GeomAbs
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.MMgt
import OCC.Core.gp
import OCC.Core.Geom2d
import OCC.Core.TColgp

def Handle_Adaptor2d_HCurve2d_Create() -> "Handle_Adaptor2d_HCurve2d":
    return _Adaptor2d.Handle_Adaptor2d_HCurve2d_Create()
Handle_Adaptor2d_HCurve2d_Create = _Adaptor2d.Handle_Adaptor2d_HCurve2d_Create

def Handle_Adaptor2d_HCurve2d_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor2d_HCurve2d":
    return _Adaptor2d.Handle_Adaptor2d_HCurve2d_DownCast(t)
Handle_Adaptor2d_HCurve2d_DownCast = _Adaptor2d.Handle_Adaptor2d_HCurve2d_DownCast

def Handle_Adaptor2d_HCurve2d_IsNull(t: 'Handle_Adaptor2d_HCurve2d const &') -> "bool":
    return _Adaptor2d.Handle_Adaptor2d_HCurve2d_IsNull(t)
Handle_Adaptor2d_HCurve2d_IsNull = _Adaptor2d.Handle_Adaptor2d_HCurve2d_IsNull

def Handle_Adaptor2d_HLine2d_Create() -> "Handle_Adaptor2d_HLine2d":
    return _Adaptor2d.Handle_Adaptor2d_HLine2d_Create()
Handle_Adaptor2d_HLine2d_Create = _Adaptor2d.Handle_Adaptor2d_HLine2d_Create

def Handle_Adaptor2d_HLine2d_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor2d_HLine2d":
    return _Adaptor2d.Handle_Adaptor2d_HLine2d_DownCast(t)
Handle_Adaptor2d_HLine2d_DownCast = _Adaptor2d.Handle_Adaptor2d_HLine2d_DownCast

def Handle_Adaptor2d_HLine2d_IsNull(t: 'Handle_Adaptor2d_HLine2d const &') -> "bool":
    return _Adaptor2d.Handle_Adaptor2d_HLine2d_IsNull(t)
Handle_Adaptor2d_HLine2d_IsNull = _Adaptor2d.Handle_Adaptor2d_HLine2d_IsNull
class Adaptor2d_Curve2d(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def FirstParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_Curve2d_FirstParameter(self, *args)


    def LastParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_Curve2d_LastParameter(self, *args)


    def Continuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Continuity(self, *args)


    def NbIntervals(self, *args) -> "Standard_Integer":
        """
        * If necessary, breaks the curve in intervals of continuity <S>. And returns the number of intervals.

        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_Curve2d_NbIntervals(self, *args)


    def Intervals(self, *args) -> "void":
        """
        * Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accomodate for the parameters. i.e. T.Length() > NbIntervals()

        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Intervals(self, *args)


    def Trim(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        * Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Trim(self, *args)


    def IsClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_Curve2d_IsClosed(self, *args)


    def IsPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_Curve2d_IsPeriodic(self, *args)


    def Period(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Period(self, *args)


    def Value(self, *args) -> "gp_Pnt2d":
        """
        * Computes the point of parameter U on the curve.

        :param U:
        :type U: float
        :rtype: gp_Pnt2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        * Computes the point of parameter U on the curve.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :rtype: void

        """
        return _Adaptor2d.Adaptor2d_Curve2d_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        * Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V:
        :type V: gp_Vec2d
        :rtype: void

        """
        return _Adaptor2d.Adaptor2d_Curve2d_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        * Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _Adaptor2d.Adaptor2d_Curve2d_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        * Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        """
        return _Adaptor2d.Adaptor2d_Curve2d_D3(self, *args)


    def DN(self, *args) -> "gp_Vec2d":
        """
        * The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.

        :param U:
        :type U: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_DN(self, *args)


    def Resolution(self, *args) -> "Standard_Real":
        """
        * Returns the parametric resolution corresponding to the real space resolution <R3d>.

        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Resolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_CurveType":
        """
        * Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.

        :rtype: GeomAbs_CurveType

        """
        return _Adaptor2d.Adaptor2d_Curve2d_GetType(self, *args)


    def Line(self, *args) -> "gp_Lin2d":
        """
        :rtype: gp_Lin2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Line(self, *args)


    def Circle(self, *args) -> "gp_Circ2d":
        """
        :rtype: gp_Circ2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Circle(self, *args)


    def Ellipse(self, *args) -> "gp_Elips2d":
        """
        :rtype: gp_Elips2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Ellipse(self, *args)


    def Hyperbola(self, *args) -> "gp_Hypr2d":
        """
        :rtype: gp_Hypr2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Hyperbola(self, *args)


    def Parabola(self, *args) -> "gp_Parab2d":
        """
        :rtype: gp_Parab2d

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Parabola(self, *args)


    def Degree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Degree(self, *args)


    def IsRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_Curve2d_IsRational(self, *args)


    def NbPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_Curve2d_NbPoles(self, *args)


    def NbKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_Curve2d_NbKnots(self, *args)


    def NbSamples(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_Curve2d_NbSamples(self, *args)


    def Bezier(self, *args) -> "Handle_Geom2d_BezierCurve":
        """
        :rtype: Handle_Geom2d_BezierCurve

        """
        return _Adaptor2d.Adaptor2d_Curve2d_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom2d_BSplineCurve":
        """
        :rtype: Handle_Geom2d_BSplineCurve

        """
        return _Adaptor2d.Adaptor2d_Curve2d_BSpline(self, *args)


    __repr__ = _dumps_object


    def __init__(self):
        _Adaptor2d.Adaptor2d_Curve2d_swiginit(self, _Adaptor2d.new_Adaptor2d_Curve2d())
    __swig_destroy__ = _Adaptor2d.delete_Adaptor2d_Curve2d
Adaptor2d_Curve2d.FirstParameter = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_FirstParameter, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.LastParameter = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_LastParameter, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Continuity = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Continuity, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.NbIntervals = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_NbIntervals, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Intervals = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Intervals, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Trim = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Trim, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.IsClosed = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_IsClosed, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.IsPeriodic = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_IsPeriodic, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Period = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Period, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Value = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Value, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.D0 = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_D0, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.D1 = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_D1, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.D2 = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_D2, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.D3 = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_D3, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.DN = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_DN, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Resolution = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Resolution, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.GetType = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_GetType, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Line = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Line, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Circle = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Circle, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Ellipse = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Ellipse, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Hyperbola = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Hyperbola, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Parabola = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Parabola, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Degree = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Degree, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.IsRational = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_IsRational, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.NbPoles = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_NbPoles, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.NbKnots = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_NbKnots, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.NbSamples = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_NbSamples, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.Bezier = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_Bezier, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d.BSpline = new_instancemethod(_Adaptor2d.Adaptor2d_Curve2d_BSpline, None, Adaptor2d_Curve2d)
Adaptor2d_Curve2d_swigregister = _Adaptor2d.Adaptor2d_Curve2d_swigregister
Adaptor2d_Curve2d_swigregister(Adaptor2d_Curve2d)

class Adaptor2d_HCurve2d(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Curve2d(self, *args) -> "Adaptor2d_Curve2d const &":
        """
        * Returns a reference to the Curve2d inside the HCurve2d.

        :rtype: Adaptor2d_Curve2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Curve2d(self, *args)


    def FirstParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_FirstParameter(self, *args)


    def LastParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_LastParameter(self, *args)


    def Continuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Continuity(self, *args)


    def NbIntervals(self, *args) -> "Standard_Integer":
        """
        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_NbIntervals(self, *args)


    def Intervals(self, *args) -> "void":
        """
        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Intervals(self, *args)


    def Trim(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        * If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Trim(self, *args)


    def IsClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_IsClosed(self, *args)


    def IsPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_IsPeriodic(self, *args)


    def Period(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Period(self, *args)


    def Value(self, *args) -> "gp_Pnt2d":
        """
        :param U:
        :type U: float
        :rtype: gp_Pnt2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V:
        :type V: gp_Vec2d
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_D3(self, *args)


    def DN(self, *args) -> "gp_Vec2d":
        """
        :param U:
        :type U: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_DN(self, *args)


    def Resolution(self, *args) -> "Standard_Real":
        """
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Resolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_CurveType":
        """
        :rtype: GeomAbs_CurveType

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_GetType(self, *args)


    def Line(self, *args) -> "gp_Lin2d":
        """
        :rtype: gp_Lin2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Line(self, *args)


    def Circle(self, *args) -> "gp_Circ2d":
        """
        :rtype: gp_Circ2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Circle(self, *args)


    def Ellipse(self, *args) -> "gp_Elips2d":
        """
        :rtype: gp_Elips2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Ellipse(self, *args)


    def Hyperbola(self, *args) -> "gp_Hypr2d":
        """
        :rtype: gp_Hypr2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Hyperbola(self, *args)


    def Parabola(self, *args) -> "gp_Parab2d":
        """
        :rtype: gp_Parab2d

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Parabola(self, *args)


    def Degree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Degree(self, *args)


    def IsRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_IsRational(self, *args)


    def NbPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_NbPoles(self, *args)


    def NbKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_NbKnots(self, *args)


    def Bezier(self, *args) -> "Handle_Geom2d_BezierCurve":
        """
        :rtype: Handle_Geom2d_BezierCurve

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom2d_BSplineCurve":
        """
        :rtype: Handle_Geom2d_BSplineCurve

        """
        return _Adaptor2d.Adaptor2d_HCurve2d_BSpline(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor2d_HCurve2d_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor2d_HCurve2d_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor2d.delete_Adaptor2d_HCurve2d
Adaptor2d_HCurve2d.Curve2d = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Curve2d, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.FirstParameter = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_FirstParameter, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.LastParameter = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_LastParameter, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Continuity = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Continuity, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.NbIntervals = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_NbIntervals, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Intervals = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Intervals, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Trim = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Trim, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.IsClosed = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_IsClosed, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.IsPeriodic = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_IsPeriodic, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Period = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Period, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Value = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Value, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.D0 = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_D0, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.D1 = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_D1, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.D2 = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_D2, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.D3 = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_D3, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.DN = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_DN, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Resolution = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Resolution, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.GetType = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_GetType, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Line = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Line, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Circle = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Circle, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Ellipse = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Ellipse, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Hyperbola = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Hyperbola, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Parabola = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Parabola, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Degree = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Degree, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.IsRational = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_IsRational, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.NbPoles = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_NbPoles, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.NbKnots = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_NbKnots, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.Bezier = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_Bezier, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d.BSpline = new_instancemethod(_Adaptor2d.Adaptor2d_HCurve2d_BSpline, None, Adaptor2d_HCurve2d)
Adaptor2d_HCurve2d_swigregister = _Adaptor2d.Adaptor2d_HCurve2d_swigregister
Adaptor2d_HCurve2d_swigregister(Adaptor2d_HCurve2d)


class Meta_Adaptor2d_HCurve2d(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor2d_HCurve2d_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor2d_HCurve2d", "Adaptor2d_HCurve2d"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor2d_HCurve2d(with_metaclass(Meta_Adaptor2d_HCurve2d, Adaptor2d_HCurve2d)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor2d_HCurve2d", "Adaptor2d_HCurve2d"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor2d_HCurve2d(Handle_Adaptor2d_HCurve2d_DownCast(o))

class Adaptor2d_HLine2d(Adaptor2d_HCurve2d):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param C:
        :type C: Adaptor2d_Line2d &
        :rtype: None

        """
        _Adaptor2d.Adaptor2d_HLine2d_swiginit(self, _Adaptor2d.new_Adaptor2d_HLine2d(*args))

    def Set(self, *args) -> "void":
        """
        :param C:
        :type C: Adaptor2d_Line2d &
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_HLine2d_Set(self, *args)


    def ChangeCurve2d(self, *args) -> "Adaptor2d_Line2d &":
        """
        :rtype: Adaptor2d_Line2d

        """
        return _Adaptor2d.Adaptor2d_HLine2d_ChangeCurve2d(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor2d_HLine2d_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor2d_HLine2d_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor2d.delete_Adaptor2d_HLine2d
Adaptor2d_HLine2d.Set = new_instancemethod(_Adaptor2d.Adaptor2d_HLine2d_Set, None, Adaptor2d_HLine2d)
Adaptor2d_HLine2d.ChangeCurve2d = new_instancemethod(_Adaptor2d.Adaptor2d_HLine2d_ChangeCurve2d, None, Adaptor2d_HLine2d)
Adaptor2d_HLine2d_swigregister = _Adaptor2d.Adaptor2d_HLine2d_swigregister
Adaptor2d_HLine2d_swigregister(Adaptor2d_HLine2d)


class Meta_Adaptor2d_HLine2d(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor2d_HLine2d_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor2d_HLine2d", "Adaptor2d_HLine2d"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor2d_HLine2d(with_metaclass(Meta_Adaptor2d_HLine2d, Adaptor2d_HLine2d)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor2d_HLine2d", "Adaptor2d_HLine2d"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor2d_HLine2d(Handle_Adaptor2d_HLine2d_DownCast(o))

class Adaptor2d_Line2d(Adaptor2d_Curve2d):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param P:
        :type P: gp_Pnt2d
        :param D:
        :type D: gp_Dir2d
        :param UFirst:
        :type UFirst: float
        :param ULast:
        :type ULast: float
        :rtype: None

        """
        _Adaptor2d.Adaptor2d_Line2d_swiginit(self, _Adaptor2d.new_Adaptor2d_Line2d(*args))

    def Load(self, *args) -> "void":
        """
        :param L:
        :type L: gp_Lin2d
        :rtype: None

        :param L:
        :type L: gp_Lin2d
        :param UFirst:
        :type UFirst: float
        :param ULast:
        :type ULast: float
        :rtype: None

        """
        return _Adaptor2d.Adaptor2d_Line2d_Load(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor2d.delete_Adaptor2d_Line2d
Adaptor2d_Line2d.Load = new_instancemethod(_Adaptor2d.Adaptor2d_Line2d_Load, None, Adaptor2d_Line2d)
Adaptor2d_Line2d_swigregister = _Adaptor2d.Adaptor2d_Line2d_swigregister
Adaptor2d_Line2d_swigregister(Adaptor2d_Line2d)



