# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
The Adaptor3d package  is used to help defining
reusable geometric algorithms. i.e. that can be
used on curves and surfaces.

It defines general services for 3 kind of objects :

- the 2d curve.   Curve2d
- the 3d curve.   Curve
- the 3d surface.  Surface

The services are :

- Usual services found in Geom or Geom2d :

* parameter range, value and derivatives, etc...

- Continuity breakout services :

* Allows to divide a curve or a surfaces in
parts with a given derivation order.

- Special geometries detection services :

* Allows to test for special cases that can
be processed more easily :
- Conics, Quadrics, Bezier, BSpline ...

And to get the correponding data form the
package gp or  Geom.  The special type
OtherCurve means that no special case has
been detected and the algorithm may use
only the evaluation methods (D0, D1, ...)


For  each category Curve2d, Curve,  Surface we
define  three classes, we illustrate now the
principles with the Curve, the same applies to
Curve2d and Surface.

The class Curve is the  abstract root for all
Curves used by algorithms, it is handled by value
and  provides as deferred methods the services
described above.

Some services (breakout) requires to create new
curves,   this  leads  to  memory allocation
considerations (who create the curve, who deletes
it ?). To solve this problem elegantly the curve
will return a HCurve, the  HCurve is a  curve
handled by reference  so it will  be deallocated
automatically when it is not used.

A third class GenHCurve is provided, this class is
generic and its utility  is to provide automatic
generation of the HCurve class when you have
written the Curve class.


* Let us show an example (with 2d curves) :

Imagine an algorithm to intersect curves, this
algorithms is written to process Curve2d from
Adaptor3d :

A method may look like :

Intersect(C1,C2 : Curve2d from Adaptor3d);

Which will look like in C++

Intersect(const Adaptor2d_Curve2d& C1,
const Adaptor2d_Curve2d& C2)
{
// you can call any method
Standard_Real first1 = C1.FirstParameter();

// but avoid to copy in an Adaptor3d_Curve which
// is an Abstract class, use a reference or a pointer

const Adaptor3d_Curve& C = C1;
const Adaptor3d_Curve *pC = &C1;

// If you are interseted in Intervals you must
// store them in a HCurve to ensure they are kept
// in memory. Then a referrence may be used.

Handle(Adaptor3d_HCurve) HCI = C1.Interval(1);

const Adaptor3d_Curve& CI = HCI->Curve();
pC = &(HCI->Curve());


* The  Adaptor3d provides also Generic classes
implementing algorithmic curves and surfaces.

- IsoCurve    : Isoparametric curve on a surface.
- CurveOnSurface : 2D curve in the parametric
space of a surface.


- OffsetCurve2d : 2d offset curve
- ProjectedCurve : 3d curve projected on a plane
- SurfaceOfLinearExtrusion
- SurfaceOfRevolution

They are instantiated with HCurve, HSurface, HCurved2d

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _Adaptor3d.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Adaptor3d')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Adaptor3d')
    _Adaptor3d = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Adaptor3d', [dirname(__file__)])
        except ImportError:
            import _Adaptor3d
            return _Adaptor3d
        try:
            _mod = imp.load_module('_Adaptor3d', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Adaptor3d = swig_import_helper()
    del swig_import_helper
else:
    import _Adaptor3d
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Adaptor3d.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_Adaptor3d.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_Adaptor3d.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_Adaptor3d.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_Adaptor3d.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_Adaptor3d.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_Adaptor3d.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_Adaptor3d.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_Adaptor3d.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_Adaptor3d.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_Adaptor3d.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_Adaptor3d.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_Adaptor3d.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_Adaptor3d.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_Adaptor3d.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_Adaptor3d.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_Adaptor3d.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _Adaptor3d.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _Adaptor3d.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.GeomAbs
import OCC.Core.TColStd
import OCC.Core.TCollection
import OCC.Core.MMgt
import OCC.Core.gp
import OCC.Core.Geom
import OCC.Core.TColgp
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.TopAbs
import OCC.Core.math

def Handle_Adaptor3d_HCurve_Create() -> "Handle_Adaptor3d_HCurve":
    return _Adaptor3d.Handle_Adaptor3d_HCurve_Create()
Handle_Adaptor3d_HCurve_Create = _Adaptor3d.Handle_Adaptor3d_HCurve_Create

def Handle_Adaptor3d_HCurve_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HCurve":
    return _Adaptor3d.Handle_Adaptor3d_HCurve_DownCast(t)
Handle_Adaptor3d_HCurve_DownCast = _Adaptor3d.Handle_Adaptor3d_HCurve_DownCast

def Handle_Adaptor3d_HCurve_IsNull(t: 'Handle_Adaptor3d_HCurve const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HCurve_IsNull(t)
Handle_Adaptor3d_HCurve_IsNull = _Adaptor3d.Handle_Adaptor3d_HCurve_IsNull

def Handle_Adaptor3d_HOffsetCurve_Create() -> "Handle_Adaptor3d_HOffsetCurve":
    return _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_Create()
Handle_Adaptor3d_HOffsetCurve_Create = _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_Create

def Handle_Adaptor3d_HOffsetCurve_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HOffsetCurve":
    return _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_DownCast(t)
Handle_Adaptor3d_HOffsetCurve_DownCast = _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_DownCast

def Handle_Adaptor3d_HOffsetCurve_IsNull(t: 'Handle_Adaptor3d_HOffsetCurve const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_IsNull(t)
Handle_Adaptor3d_HOffsetCurve_IsNull = _Adaptor3d.Handle_Adaptor3d_HOffsetCurve_IsNull

def Handle_Adaptor3d_HSurface_Create() -> "Handle_Adaptor3d_HSurface":
    return _Adaptor3d.Handle_Adaptor3d_HSurface_Create()
Handle_Adaptor3d_HSurface_Create = _Adaptor3d.Handle_Adaptor3d_HSurface_Create

def Handle_Adaptor3d_HSurface_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HSurface":
    return _Adaptor3d.Handle_Adaptor3d_HSurface_DownCast(t)
Handle_Adaptor3d_HSurface_DownCast = _Adaptor3d.Handle_Adaptor3d_HSurface_DownCast

def Handle_Adaptor3d_HSurface_IsNull(t: 'Handle_Adaptor3d_HSurface const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HSurface_IsNull(t)
Handle_Adaptor3d_HSurface_IsNull = _Adaptor3d.Handle_Adaptor3d_HSurface_IsNull

def Handle_Adaptor3d_HVertex_Create() -> "Handle_Adaptor3d_HVertex":
    return _Adaptor3d.Handle_Adaptor3d_HVertex_Create()
Handle_Adaptor3d_HVertex_Create = _Adaptor3d.Handle_Adaptor3d_HVertex_Create

def Handle_Adaptor3d_HVertex_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HVertex":
    return _Adaptor3d.Handle_Adaptor3d_HVertex_DownCast(t)
Handle_Adaptor3d_HVertex_DownCast = _Adaptor3d.Handle_Adaptor3d_HVertex_DownCast

def Handle_Adaptor3d_HVertex_IsNull(t: 'Handle_Adaptor3d_HVertex const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HVertex_IsNull(t)
Handle_Adaptor3d_HVertex_IsNull = _Adaptor3d.Handle_Adaptor3d_HVertex_IsNull

def Handle_Adaptor3d_TopolTool_Create() -> "Handle_Adaptor3d_TopolTool":
    return _Adaptor3d.Handle_Adaptor3d_TopolTool_Create()
Handle_Adaptor3d_TopolTool_Create = _Adaptor3d.Handle_Adaptor3d_TopolTool_Create

def Handle_Adaptor3d_TopolTool_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_TopolTool":
    return _Adaptor3d.Handle_Adaptor3d_TopolTool_DownCast(t)
Handle_Adaptor3d_TopolTool_DownCast = _Adaptor3d.Handle_Adaptor3d_TopolTool_DownCast

def Handle_Adaptor3d_TopolTool_IsNull(t: 'Handle_Adaptor3d_TopolTool const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_TopolTool_IsNull(t)
Handle_Adaptor3d_TopolTool_IsNull = _Adaptor3d.Handle_Adaptor3d_TopolTool_IsNull

def Handle_Adaptor3d_HCurveOnSurface_Create() -> "Handle_Adaptor3d_HCurveOnSurface":
    return _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_Create()
Handle_Adaptor3d_HCurveOnSurface_Create = _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_Create

def Handle_Adaptor3d_HCurveOnSurface_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HCurveOnSurface":
    return _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_DownCast(t)
Handle_Adaptor3d_HCurveOnSurface_DownCast = _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_DownCast

def Handle_Adaptor3d_HCurveOnSurface_IsNull(t: 'Handle_Adaptor3d_HCurveOnSurface const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_IsNull(t)
Handle_Adaptor3d_HCurveOnSurface_IsNull = _Adaptor3d.Handle_Adaptor3d_HCurveOnSurface_IsNull

def Handle_Adaptor3d_HIsoCurve_Create() -> "Handle_Adaptor3d_HIsoCurve":
    return _Adaptor3d.Handle_Adaptor3d_HIsoCurve_Create()
Handle_Adaptor3d_HIsoCurve_Create = _Adaptor3d.Handle_Adaptor3d_HIsoCurve_Create

def Handle_Adaptor3d_HIsoCurve_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HIsoCurve":
    return _Adaptor3d.Handle_Adaptor3d_HIsoCurve_DownCast(t)
Handle_Adaptor3d_HIsoCurve_DownCast = _Adaptor3d.Handle_Adaptor3d_HIsoCurve_DownCast

def Handle_Adaptor3d_HIsoCurve_IsNull(t: 'Handle_Adaptor3d_HIsoCurve const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HIsoCurve_IsNull(t)
Handle_Adaptor3d_HIsoCurve_IsNull = _Adaptor3d.Handle_Adaptor3d_HIsoCurve_IsNull

def Handle_Adaptor3d_HSurfaceOfLinearExtrusion_Create() -> "Handle_Adaptor3d_HSurfaceOfLinearExtrusion":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_Create()
Handle_Adaptor3d_HSurfaceOfLinearExtrusion_Create = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_Create

def Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HSurfaceOfLinearExtrusion":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast(t)
Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast

def Handle_Adaptor3d_HSurfaceOfLinearExtrusion_IsNull(t: 'Handle_Adaptor3d_HSurfaceOfLinearExtrusion const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_IsNull(t)
Handle_Adaptor3d_HSurfaceOfLinearExtrusion_IsNull = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfLinearExtrusion_IsNull

def Handle_Adaptor3d_HSurfaceOfRevolution_Create() -> "Handle_Adaptor3d_HSurfaceOfRevolution":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_Create()
Handle_Adaptor3d_HSurfaceOfRevolution_Create = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_Create

def Handle_Adaptor3d_HSurfaceOfRevolution_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Adaptor3d_HSurfaceOfRevolution":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_DownCast(t)
Handle_Adaptor3d_HSurfaceOfRevolution_DownCast = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_DownCast

def Handle_Adaptor3d_HSurfaceOfRevolution_IsNull(t: 'Handle_Adaptor3d_HSurfaceOfRevolution const &') -> "bool":
    return _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_IsNull(t)
Handle_Adaptor3d_HSurfaceOfRevolution_IsNull = _Adaptor3d.Handle_Adaptor3d_HSurfaceOfRevolution_IsNull
class Adaptor3d_Curve(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def FirstParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Curve_FirstParameter(self, *args)


    def LastParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Curve_LastParameter(self, *args)


    def Continuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_Curve_Continuity(self, *args)


    def NbIntervals(self, *args) -> "Standard_Integer":
        """
        * Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>

        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Curve_NbIntervals(self, *args)


    def Intervals(self, *args) -> "void":
        """
        * Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accomodate for the parameters. i.e. T.Length() > NbIntervals()

        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Curve_Intervals(self, *args)


    def Trim(self, *args) -> "Handle_Adaptor3d_HCurve":
        """
        * Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HCurve

        """
        return _Adaptor3d.Adaptor3d_Curve_Trim(self, *args)


    def IsClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Curve_IsClosed(self, *args)


    def IsPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Curve_IsPeriodic(self, *args)


    def Period(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Curve_Period(self, *args)


    def Value(self, *args) -> "gp_Pnt":
        """
        * Computes the point of parameter U on the curve.

        :param U:
        :type U: float
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_Curve_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        * Computes the point of parameter U on the curve.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Curve_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        * Computes the point of parameter U on the curve with its first derivative. Raised if the continuity of the current interval is not C1.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V:
        :type V: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Curve_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        * Returns the point P of parameter U, the first and second derivatives V1 and V2. Raised if the continuity of the current interval is not C2.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Curve_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        * Returns the point P of parameter U, the first, the second and the third derivative. Raised if the continuity of the current interval is not C3.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Curve_D3(self, *args)


    def DN(self, *args) -> "gp_Vec":
        """
        * The returned vector gives the value of the derivative for the order of derivation N. Raised if the continuity of the current interval is not CN. Raised if N < 1.

        :param U:
        :type U: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        """
        return _Adaptor3d.Adaptor3d_Curve_DN(self, *args)


    def Resolution(self, *args) -> "Standard_Real":
        """
        * Returns the parametric resolution corresponding to the real space resolution <R3d>.

        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Curve_Resolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_CurveType":
        """
        * Returns the type of the curve in the current interval : Line, Circle, Ellipse, Hyperbola, Parabola, BezierCurve, BSplineCurve, OtherCurve.

        :rtype: GeomAbs_CurveType

        """
        return _Adaptor3d.Adaptor3d_Curve_GetType(self, *args)


    def Line(self, *args) -> "gp_Lin":
        """
        :rtype: gp_Lin

        """
        return _Adaptor3d.Adaptor3d_Curve_Line(self, *args)


    def Circle(self, *args) -> "gp_Circ":
        """
        :rtype: gp_Circ

        """
        return _Adaptor3d.Adaptor3d_Curve_Circle(self, *args)


    def Ellipse(self, *args) -> "gp_Elips":
        """
        :rtype: gp_Elips

        """
        return _Adaptor3d.Adaptor3d_Curve_Ellipse(self, *args)


    def Hyperbola(self, *args) -> "gp_Hypr":
        """
        :rtype: gp_Hypr

        """
        return _Adaptor3d.Adaptor3d_Curve_Hyperbola(self, *args)


    def Parabola(self, *args) -> "gp_Parab":
        """
        :rtype: gp_Parab

        """
        return _Adaptor3d.Adaptor3d_Curve_Parabola(self, *args)


    def Degree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Curve_Degree(self, *args)


    def IsRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Curve_IsRational(self, *args)


    def NbPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Curve_NbPoles(self, *args)


    def NbKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Curve_NbKnots(self, *args)


    def Bezier(self, *args) -> "Handle_Geom_BezierCurve":
        """
        :rtype: Handle_Geom_BezierCurve

        """
        return _Adaptor3d.Adaptor3d_Curve_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom_BSplineCurve":
        """
        :rtype: Handle_Geom_BSplineCurve

        """
        return _Adaptor3d.Adaptor3d_Curve_BSpline(self, *args)


    __repr__ = _dumps_object


    def __init__(self):
        _Adaptor3d.Adaptor3d_Curve_swiginit(self, _Adaptor3d.new_Adaptor3d_Curve())
    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_Curve
Adaptor3d_Curve.FirstParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_FirstParameter, None, Adaptor3d_Curve)
Adaptor3d_Curve.LastParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_LastParameter, None, Adaptor3d_Curve)
Adaptor3d_Curve.Continuity = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Continuity, None, Adaptor3d_Curve)
Adaptor3d_Curve.NbIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_NbIntervals, None, Adaptor3d_Curve)
Adaptor3d_Curve.Intervals = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Intervals, None, Adaptor3d_Curve)
Adaptor3d_Curve.Trim = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Trim, None, Adaptor3d_Curve)
Adaptor3d_Curve.IsClosed = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_IsClosed, None, Adaptor3d_Curve)
Adaptor3d_Curve.IsPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_IsPeriodic, None, Adaptor3d_Curve)
Adaptor3d_Curve.Period = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Period, None, Adaptor3d_Curve)
Adaptor3d_Curve.Value = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Value, None, Adaptor3d_Curve)
Adaptor3d_Curve.D0 = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_D0, None, Adaptor3d_Curve)
Adaptor3d_Curve.D1 = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_D1, None, Adaptor3d_Curve)
Adaptor3d_Curve.D2 = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_D2, None, Adaptor3d_Curve)
Adaptor3d_Curve.D3 = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_D3, None, Adaptor3d_Curve)
Adaptor3d_Curve.DN = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_DN, None, Adaptor3d_Curve)
Adaptor3d_Curve.Resolution = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Resolution, None, Adaptor3d_Curve)
Adaptor3d_Curve.GetType = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_GetType, None, Adaptor3d_Curve)
Adaptor3d_Curve.Line = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Line, None, Adaptor3d_Curve)
Adaptor3d_Curve.Circle = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Circle, None, Adaptor3d_Curve)
Adaptor3d_Curve.Ellipse = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Ellipse, None, Adaptor3d_Curve)
Adaptor3d_Curve.Hyperbola = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Hyperbola, None, Adaptor3d_Curve)
Adaptor3d_Curve.Parabola = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Parabola, None, Adaptor3d_Curve)
Adaptor3d_Curve.Degree = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Degree, None, Adaptor3d_Curve)
Adaptor3d_Curve.IsRational = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_IsRational, None, Adaptor3d_Curve)
Adaptor3d_Curve.NbPoles = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_NbPoles, None, Adaptor3d_Curve)
Adaptor3d_Curve.NbKnots = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_NbKnots, None, Adaptor3d_Curve)
Adaptor3d_Curve.Bezier = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_Bezier, None, Adaptor3d_Curve)
Adaptor3d_Curve.BSpline = new_instancemethod(_Adaptor3d.Adaptor3d_Curve_BSpline, None, Adaptor3d_Curve)
Adaptor3d_Curve_swigregister = _Adaptor3d.Adaptor3d_Curve_swigregister
Adaptor3d_Curve_swigregister(Adaptor3d_Curve)

class Adaptor3d_HCurve(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Curve(self, *args) -> "Adaptor3d_Curve const &":
        """
        * Returns a pointer to the Curve inside the HCurve.

        :rtype: Adaptor3d_Curve

        """
        return _Adaptor3d.Adaptor3d_HCurve_Curve(self, *args)


    def GetCurve(self, *args) -> "Adaptor3d_Curve &":
        """
        * Returns a pointer to the Curve inside the HCurve.

        :rtype: Adaptor3d_Curve

        """
        return _Adaptor3d.Adaptor3d_HCurve_GetCurve(self, *args)


    def FirstParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HCurve_FirstParameter(self, *args)


    def LastParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HCurve_LastParameter(self, *args)


    def Continuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_HCurve_Continuity(self, *args)


    def NbIntervals(self, *args) -> "Standard_Integer":
        """
        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HCurve_NbIntervals(self, *args)


    def Intervals(self, *args) -> "void":
        """
        * Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accomodate for the parameters. i.e. T.Length() > NbIntervals()

        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurve_Intervals(self, *args)


    def Trim(self, *args) -> "Handle_Adaptor3d_HCurve":
        """
        * Returns a curve equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. //! If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HCurve

        """
        return _Adaptor3d.Adaptor3d_HCurve_Trim(self, *args)


    def IsClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HCurve_IsClosed(self, *args)


    def IsPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HCurve_IsPeriodic(self, *args)


    def Period(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HCurve_Period(self, *args)


    def Value(self, *args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_HCurve_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurve_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V:
        :type V: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurve_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurve_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurve_D3(self, *args)


    def DN(self, *args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        """
        return _Adaptor3d.Adaptor3d_HCurve_DN(self, *args)


    def Resolution(self, *args) -> "Standard_Real":
        """
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HCurve_Resolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_CurveType":
        """
        :rtype: GeomAbs_CurveType

        """
        return _Adaptor3d.Adaptor3d_HCurve_GetType(self, *args)


    def Line(self, *args) -> "gp_Lin":
        """
        :rtype: gp_Lin

        """
        return _Adaptor3d.Adaptor3d_HCurve_Line(self, *args)


    def Circle(self, *args) -> "gp_Circ":
        """
        :rtype: gp_Circ

        """
        return _Adaptor3d.Adaptor3d_HCurve_Circle(self, *args)


    def Ellipse(self, *args) -> "gp_Elips":
        """
        :rtype: gp_Elips

        """
        return _Adaptor3d.Adaptor3d_HCurve_Ellipse(self, *args)


    def Hyperbola(self, *args) -> "gp_Hypr":
        """
        :rtype: gp_Hypr

        """
        return _Adaptor3d.Adaptor3d_HCurve_Hyperbola(self, *args)


    def Parabola(self, *args) -> "gp_Parab":
        """
        :rtype: gp_Parab

        """
        return _Adaptor3d.Adaptor3d_HCurve_Parabola(self, *args)


    def Degree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HCurve_Degree(self, *args)


    def IsRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HCurve_IsRational(self, *args)


    def NbPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HCurve_NbPoles(self, *args)


    def NbKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HCurve_NbKnots(self, *args)


    def Bezier(self, *args) -> "Handle_Geom_BezierCurve":
        """
        :rtype: Handle_Geom_BezierCurve

        """
        return _Adaptor3d.Adaptor3d_HCurve_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom_BSplineCurve":
        """
        :rtype: Handle_Geom_BSplineCurve

        """
        return _Adaptor3d.Adaptor3d_HCurve_BSpline(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HCurve_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HCurve
Adaptor3d_HCurve.Curve = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Curve, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.GetCurve = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_GetCurve, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.FirstParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_FirstParameter, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.LastParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_LastParameter, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Continuity = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Continuity, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.NbIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_NbIntervals, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Intervals = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Intervals, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Trim = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Trim, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.IsClosed = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_IsClosed, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.IsPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_IsPeriodic, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Period = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Period, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Value = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Value, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.D0 = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_D0, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.D1 = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_D1, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.D2 = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_D2, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.D3 = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_D3, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.DN = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_DN, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Resolution = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Resolution, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.GetType = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_GetType, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Line = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Line, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Circle = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Circle, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Ellipse = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Ellipse, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Hyperbola = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Hyperbola, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Parabola = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Parabola, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Degree = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Degree, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.IsRational = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_IsRational, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.NbPoles = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_NbPoles, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.NbKnots = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_NbKnots, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.Bezier = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_Bezier, None, Adaptor3d_HCurve)
Adaptor3d_HCurve.BSpline = new_instancemethod(_Adaptor3d.Adaptor3d_HCurve_BSpline, None, Adaptor3d_HCurve)
Adaptor3d_HCurve_swigregister = _Adaptor3d.Adaptor3d_HCurve_swigregister
Adaptor3d_HCurve_swigregister(Adaptor3d_HCurve)


class Meta_Adaptor3d_HCurve(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HCurve_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HCurve", "Adaptor3d_HCurve"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HCurve(with_metaclass(Meta_Adaptor3d_HCurve, Adaptor3d_HCurve)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HCurve", "Adaptor3d_HCurve"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HCurve(Handle_Adaptor3d_HCurve_DownCast(o))

class Adaptor3d_HOffsetCurve(OCC.Core.Adaptor2d.Adaptor2d_HCurve2d):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param C:
        :type C: Adaptor3d_OffsetCurve &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HOffsetCurve_swiginit(self, _Adaptor3d.new_Adaptor3d_HOffsetCurve(*args))

    def Set(self, *args) -> "void":
        """
        :param C:
        :type C: Adaptor3d_OffsetCurve &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HOffsetCurve_Set(self, *args)


    def ChangeCurve2d(self, *args) -> "Adaptor3d_OffsetCurve &":
        """
        :rtype: Adaptor3d_OffsetCurve

        """
        return _Adaptor3d.Adaptor3d_HOffsetCurve_ChangeCurve2d(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HOffsetCurve_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HOffsetCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HOffsetCurve
Adaptor3d_HOffsetCurve.Set = new_instancemethod(_Adaptor3d.Adaptor3d_HOffsetCurve_Set, None, Adaptor3d_HOffsetCurve)
Adaptor3d_HOffsetCurve.ChangeCurve2d = new_instancemethod(_Adaptor3d.Adaptor3d_HOffsetCurve_ChangeCurve2d, None, Adaptor3d_HOffsetCurve)
Adaptor3d_HOffsetCurve_swigregister = _Adaptor3d.Adaptor3d_HOffsetCurve_swigregister
Adaptor3d_HOffsetCurve_swigregister(Adaptor3d_HOffsetCurve)


class Meta_Adaptor3d_HOffsetCurve(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HOffsetCurve_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HOffsetCurve", "Adaptor3d_HOffsetCurve"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HOffsetCurve(with_metaclass(Meta_Adaptor3d_HOffsetCurve, Adaptor3d_HOffsetCurve)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HOffsetCurve", "Adaptor3d_HOffsetCurve"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HOffsetCurve(Handle_Adaptor3d_HOffsetCurve_DownCast(o))

class Adaptor3d_HSurface(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Surface(self, *args) -> "Adaptor3d_Surface const &":
        """
        * Returns a reference to the Surface inside the HSurface.

        :rtype: Adaptor3d_Surface

        """
        return _Adaptor3d.Adaptor3d_HSurface_Surface(self, *args)


    def FirstUParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_FirstUParameter(self, *args)


    def LastUParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_LastUParameter(self, *args)


    def FirstVParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_FirstVParameter(self, *args)


    def LastVParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_LastVParameter(self, *args)


    def UContinuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_HSurface_UContinuity(self, *args)


    def VContinuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_HSurface_VContinuity(self, *args)


    def NbUIntervals(self, *args) -> "Standard_Integer":
        """
        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbUIntervals(self, *args)


    def NbVIntervals(self, *args) -> "Standard_Integer":
        """
        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbVIntervals(self, *args)


    def UIntervals(self, *args) -> "void":
        """
        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_UIntervals(self, *args)


    def VIntervals(self, *args) -> "void":
        """
        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_VIntervals(self, *args)


    def UTrim(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurface_UTrim(self, *args)


    def VTrim(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurface_VTrim(self, *args)


    def IsUClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsUClosed(self, *args)


    def IsVClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsVClosed(self, *args)


    def IsUPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsUPeriodic(self, *args)


    def UPeriod(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_UPeriod(self, *args)


    def IsVPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsVPeriodic(self, *args)


    def VPeriod(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_VPeriod(self, *args)


    def Value(self, *args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_HSurface_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :param D3U:
        :type D3U: gp_Vec
        :param D3V:
        :type D3V: gp_Vec
        :param D3UUV:
        :type D3UUV: gp_Vec
        :param D3UVV:
        :type D3UVV: gp_Vec
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurface_D3(self, *args)


    def DN(self, *args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _Adaptor3d.Adaptor3d_HSurface_DN(self, *args)


    def UResolution(self, *args) -> "Standard_Real":
        """
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_UResolution(self, *args)


    def VResolution(self, *args) -> "Standard_Real":
        """
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_VResolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_SurfaceType":
        """
        :rtype: GeomAbs_SurfaceType

        """
        return _Adaptor3d.Adaptor3d_HSurface_GetType(self, *args)


    def Plane(self, *args) -> "gp_Pln":
        """
        :rtype: gp_Pln

        """
        return _Adaptor3d.Adaptor3d_HSurface_Plane(self, *args)


    def Cylinder(self, *args) -> "gp_Cylinder":
        """
        :rtype: gp_Cylinder

        """
        return _Adaptor3d.Adaptor3d_HSurface_Cylinder(self, *args)


    def Cone(self, *args) -> "gp_Cone":
        """
        :rtype: gp_Cone

        """
        return _Adaptor3d.Adaptor3d_HSurface_Cone(self, *args)


    def Sphere(self, *args) -> "gp_Sphere":
        """
        :rtype: gp_Sphere

        """
        return _Adaptor3d.Adaptor3d_HSurface_Sphere(self, *args)


    def Torus(self, *args) -> "gp_Torus":
        """
        :rtype: gp_Torus

        """
        return _Adaptor3d.Adaptor3d_HSurface_Torus(self, *args)


    def UDegree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_UDegree(self, *args)


    def NbUPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbUPoles(self, *args)


    def VDegree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_VDegree(self, *args)


    def NbVPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbVPoles(self, *args)


    def NbUKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbUKnots(self, *args)


    def NbVKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurface_NbVKnots(self, *args)


    def IsURational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsURational(self, *args)


    def IsVRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurface_IsVRational(self, *args)


    def Bezier(self, *args) -> "Handle_Geom_BezierSurface":
        """
        :rtype: Handle_Geom_BezierSurface

        """
        return _Adaptor3d.Adaptor3d_HSurface_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom_BSplineSurface":
        """
        :rtype: Handle_Geom_BSplineSurface

        """
        return _Adaptor3d.Adaptor3d_HSurface_BSpline(self, *args)


    def AxeOfRevolution(self, *args) -> "gp_Ax1":
        """
        :rtype: gp_Ax1

        """
        return _Adaptor3d.Adaptor3d_HSurface_AxeOfRevolution(self, *args)


    def Direction(self, *args) -> "gp_Dir":
        """
        :rtype: gp_Dir

        """
        return _Adaptor3d.Adaptor3d_HSurface_Direction(self, *args)


    def BasisCurve(self, *args) -> "Handle_Adaptor3d_HCurve":
        """
        :rtype: Handle_Adaptor3d_HCurve

        """
        return _Adaptor3d.Adaptor3d_HSurface_BasisCurve(self, *args)


    def BasisSurface(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurface_BasisSurface(self, *args)


    def OffsetValue(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurface_OffsetValue(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HSurface_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HSurface
Adaptor3d_HSurface.Surface = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Surface, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.FirstUParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_FirstUParameter, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.LastUParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_LastUParameter, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.FirstVParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_FirstVParameter, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.LastVParameter = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_LastVParameter, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UContinuity = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UContinuity, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VContinuity = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VContinuity, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbUIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbUIntervals, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbVIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbVIntervals, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UIntervals, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VIntervals, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UTrim = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UTrim, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VTrim = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VTrim, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsUClosed = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsUClosed, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsVClosed = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsVClosed, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsUPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsUPeriodic, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UPeriod = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UPeriod, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsVPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsVPeriodic, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VPeriod = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VPeriod, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Value = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Value, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.D0 = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_D0, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.D1 = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_D1, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.D2 = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_D2, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.D3 = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_D3, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.DN = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_DN, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UResolution = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UResolution, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VResolution = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VResolution, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.GetType = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_GetType, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Plane = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Plane, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Cylinder = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Cylinder, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Cone = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Cone, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Sphere = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Sphere, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Torus = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Torus, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.UDegree = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_UDegree, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbUPoles = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbUPoles, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.VDegree = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_VDegree, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbVPoles = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbVPoles, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbUKnots = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbUKnots, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.NbVKnots = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_NbVKnots, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsURational = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsURational, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.IsVRational = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_IsVRational, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Bezier = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Bezier, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.BSpline = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_BSpline, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.AxeOfRevolution = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_AxeOfRevolution, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.Direction = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_Direction, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.BasisCurve = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_BasisCurve, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.BasisSurface = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_BasisSurface, None, Adaptor3d_HSurface)
Adaptor3d_HSurface.OffsetValue = new_instancemethod(_Adaptor3d.Adaptor3d_HSurface_OffsetValue, None, Adaptor3d_HSurface)
Adaptor3d_HSurface_swigregister = _Adaptor3d.Adaptor3d_HSurface_swigregister
Adaptor3d_HSurface_swigregister(Adaptor3d_HSurface)


class Meta_Adaptor3d_HSurface(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HSurface_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HSurface", "Adaptor3d_HSurface"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HSurface(with_metaclass(Meta_Adaptor3d_HSurface, Adaptor3d_HSurface)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HSurface", "Adaptor3d_HSurface"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HSurface(Handle_Adaptor3d_HSurface_DownCast(o))

class Adaptor3d_HSurfaceTool(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def FirstUParameter(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_FirstUParameter(*args)

    FirstUParameter = staticmethod(FirstUParameter)

    def FirstVParameter(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_FirstVParameter(*args)

    FirstVParameter = staticmethod(FirstVParameter)

    def LastUParameter(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_LastUParameter(*args)

    LastUParameter = staticmethod(LastUParameter)

    def LastVParameter(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_LastVParameter(*args)

    LastVParameter = staticmethod(LastVParameter)

    def NbUIntervals(*args) -> "Standard_Integer":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param Sh:
        :type Sh: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_NbUIntervals(*args)

    NbUIntervals = staticmethod(NbUIntervals)

    def NbVIntervals(*args) -> "Standard_Integer":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param Sh:
        :type Sh: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_NbVIntervals(*args)

    NbVIntervals = staticmethod(NbVIntervals)

    def UIntervals(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param T:
        :type T: TColStd_Array1OfReal &
        :param Sh:
        :type Sh: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_UIntervals(*args)

    UIntervals = staticmethod(UIntervals)

    def VIntervals(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param T:
        :type T: TColStd_Array1OfReal &
        :param Sh:
        :type Sh: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_VIntervals(*args)

    VIntervals = staticmethod(VIntervals)

    def UTrim(*args) -> "Handle_Adaptor3d_HSurface":
        """
        * If <First> >= <Last>

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_UTrim(*args)

    UTrim = staticmethod(UTrim)

    def VTrim(*args) -> "Handle_Adaptor3d_HSurface":
        """
        * If <First> >= <Last>

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_VTrim(*args)

    VTrim = staticmethod(VTrim)

    def IsUClosed(*args) -> "Standard_Boolean":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_IsUClosed(*args)

    IsUClosed = staticmethod(IsUClosed)

    def IsVClosed(*args) -> "Standard_Boolean":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_IsVClosed(*args)

    IsVClosed = staticmethod(IsVClosed)

    def IsUPeriodic(*args) -> "Standard_Boolean":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_IsUPeriodic(*args)

    IsUPeriodic = staticmethod(IsUPeriodic)

    def UPeriod(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_UPeriod(*args)

    UPeriod = staticmethod(UPeriod)

    def IsVPeriodic(*args) -> "Standard_Boolean":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_IsVPeriodic(*args)

    IsVPeriodic = staticmethod(IsVPeriodic)

    def VPeriod(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_VPeriod(*args)

    VPeriod = staticmethod(VPeriod)

    def Value(*args) -> "gp_Pnt":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Value(*args)

    Value = staticmethod(Value)

    def D0(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_D0(*args)

    D0 = staticmethod(D0)

    def D1(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :param P:
        :type P: gp_Pnt
        :param D1u:
        :type D1u: gp_Vec
        :param D1v:
        :type D1v: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_D1(*args)

    D1 = staticmethod(D1)

    def D2(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_D2(*args)

    D2 = staticmethod(D2)

    def D3(*args) -> "void":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :param D3U:
        :type D3U: gp_Vec
        :param D3V:
        :type D3V: gp_Vec
        :param D3UUV:
        :type D3UUV: gp_Vec
        :param D3UVV:
        :type D3UVV: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_D3(*args)

    D3 = staticmethod(D3)

    def DN(*args) -> "gp_Vec":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u:
        :type u: float
        :param v:
        :type v: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_DN(*args)

    DN = staticmethod(DN)

    def UResolution(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_UResolution(*args)

    UResolution = staticmethod(UResolution)

    def VResolution(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_VResolution(*args)

    VResolution = staticmethod(VResolution)

    def GetType(*args) -> "GeomAbs_SurfaceType":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: GeomAbs_SurfaceType

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_GetType(*args)

    GetType = staticmethod(GetType)

    def Plane(*args) -> "gp_Pln":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Pln

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Plane(*args)

    Plane = staticmethod(Plane)

    def Cylinder(*args) -> "gp_Cylinder":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Cylinder

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Cylinder(*args)

    Cylinder = staticmethod(Cylinder)

    def Cone(*args) -> "gp_Cone":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Cone

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Cone(*args)

    Cone = staticmethod(Cone)

    def Torus(*args) -> "gp_Torus":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Torus

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Torus(*args)

    Torus = staticmethod(Torus)

    def Sphere(*args) -> "gp_Sphere":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Sphere

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Sphere(*args)

    Sphere = staticmethod(Sphere)

    def Bezier(*args) -> "Handle_Geom_BezierSurface":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: Handle_Geom_BezierSurface

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Bezier(*args)

    Bezier = staticmethod(Bezier)

    def BSpline(*args) -> "Handle_Geom_BSplineSurface":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: Handle_Geom_BSplineSurface

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_BSpline(*args)

    BSpline = staticmethod(BSpline)

    def AxeOfRevolution(*args) -> "gp_Ax1":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Ax1

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_AxeOfRevolution(*args)

    AxeOfRevolution = staticmethod(AxeOfRevolution)

    def Direction(*args) -> "gp_Dir":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: gp_Dir

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_Direction(*args)

    Direction = staticmethod(Direction)

    def BasisCurve(*args) -> "Handle_Adaptor3d_HCurve":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: Handle_Adaptor3d_HCurve

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_BasisCurve(*args)

    BasisCurve = staticmethod(BasisCurve)

    def BasisSurface(*args) -> "Handle_Adaptor3d_HSurface":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_BasisSurface(*args)

    BasisSurface = staticmethod(BasisSurface)

    def OffsetValue(*args) -> "Standard_Real":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_OffsetValue(*args)

    OffsetValue = staticmethod(OffsetValue)

    def NbSamplesU(*args) -> "Standard_Integer":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: int

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param u1:
        :type u1: float
        :param u2:
        :type u2: float
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_NbSamplesU(*args)

    NbSamplesU = staticmethod(NbSamplesU)

    def NbSamplesV(*args) -> "Standard_Integer":
        """
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: int

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param v1:
        :type v1: float
        :param v2:
        :type v2: float
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_HSurfaceTool_NbSamplesV(*args)

    NbSamplesV = staticmethod(NbSamplesV)

    __repr__ = _dumps_object


    def __init__(self):
        _Adaptor3d.Adaptor3d_HSurfaceTool_swiginit(self, _Adaptor3d.new_Adaptor3d_HSurfaceTool())
    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HSurfaceTool
Adaptor3d_HSurfaceTool_swigregister = _Adaptor3d.Adaptor3d_HSurfaceTool_swigregister
Adaptor3d_HSurfaceTool_swigregister(Adaptor3d_HSurfaceTool)

def Adaptor3d_HSurfaceTool_FirstUParameter(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_FirstUParameter(*args)

def Adaptor3d_HSurfaceTool_FirstVParameter(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_FirstVParameter(*args)

def Adaptor3d_HSurfaceTool_LastUParameter(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_LastUParameter(*args)

def Adaptor3d_HSurfaceTool_LastVParameter(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_LastVParameter(*args)

def Adaptor3d_HSurfaceTool_NbUIntervals(*args) -> "Standard_Integer":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param Sh:
    :type Sh: GeomAbs_Shape
    :rtype: int

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_NbUIntervals(*args)

def Adaptor3d_HSurfaceTool_NbVIntervals(*args) -> "Standard_Integer":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param Sh:
    :type Sh: GeomAbs_Shape
    :rtype: int

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_NbVIntervals(*args)

def Adaptor3d_HSurfaceTool_UIntervals(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param T:
    :type T: TColStd_Array1OfReal &
    :param Sh:
    :type Sh: GeomAbs_Shape
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_UIntervals(*args)

def Adaptor3d_HSurfaceTool_VIntervals(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param T:
    :type T: TColStd_Array1OfReal &
    :param Sh:
    :type Sh: GeomAbs_Shape
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_VIntervals(*args)

def Adaptor3d_HSurfaceTool_UTrim(*args) -> "Handle_Adaptor3d_HSurface":
    """
    * If <First> >= <Last>

    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param First:
    :type First: float
    :param Last:
    :type Last: float
    :param Tol:
    :type Tol: float
    :rtype: Handle_Adaptor3d_HSurface

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_UTrim(*args)

def Adaptor3d_HSurfaceTool_VTrim(*args) -> "Handle_Adaptor3d_HSurface":
    """
    * If <First> >= <Last>

    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param First:
    :type First: float
    :param Last:
    :type Last: float
    :param Tol:
    :type Tol: float
    :rtype: Handle_Adaptor3d_HSurface

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_VTrim(*args)

def Adaptor3d_HSurfaceTool_IsUClosed(*args) -> "Standard_Boolean":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: bool

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_IsUClosed(*args)

def Adaptor3d_HSurfaceTool_IsVClosed(*args) -> "Standard_Boolean":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: bool

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_IsVClosed(*args)

def Adaptor3d_HSurfaceTool_IsUPeriodic(*args) -> "Standard_Boolean":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: bool

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_IsUPeriodic(*args)

def Adaptor3d_HSurfaceTool_UPeriod(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_UPeriod(*args)

def Adaptor3d_HSurfaceTool_IsVPeriodic(*args) -> "Standard_Boolean":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: bool

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_IsVPeriodic(*args)

def Adaptor3d_HSurfaceTool_VPeriod(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_VPeriod(*args)

def Adaptor3d_HSurfaceTool_Value(*args) -> "gp_Pnt":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :rtype: gp_Pnt

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Value(*args)

def Adaptor3d_HSurfaceTool_D0(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_D0(*args)

def Adaptor3d_HSurfaceTool_D1(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :param P:
    :type P: gp_Pnt
    :param D1u:
    :type D1u: gp_Vec
    :param D1v:
    :type D1v: gp_Vec
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_D1(*args)

def Adaptor3d_HSurfaceTool_D2(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :param P:
    :type P: gp_Pnt
    :param D1U:
    :type D1U: gp_Vec
    :param D1V:
    :type D1V: gp_Vec
    :param D2U:
    :type D2U: gp_Vec
    :param D2V:
    :type D2V: gp_Vec
    :param D2UV:
    :type D2UV: gp_Vec
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_D2(*args)

def Adaptor3d_HSurfaceTool_D3(*args) -> "void":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :param P:
    :type P: gp_Pnt
    :param D1U:
    :type D1U: gp_Vec
    :param D1V:
    :type D1V: gp_Vec
    :param D2U:
    :type D2U: gp_Vec
    :param D2V:
    :type D2V: gp_Vec
    :param D2UV:
    :type D2UV: gp_Vec
    :param D3U:
    :type D3U: gp_Vec
    :param D3V:
    :type D3V: gp_Vec
    :param D3UUV:
    :type D3UUV: gp_Vec
    :param D3UVV:
    :type D3UVV: gp_Vec
    :rtype: void

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_D3(*args)

def Adaptor3d_HSurfaceTool_DN(*args) -> "gp_Vec":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u:
    :type u: float
    :param v:
    :type v: float
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_DN(*args)

def Adaptor3d_HSurfaceTool_UResolution(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param R3d:
    :type R3d: float
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_UResolution(*args)

def Adaptor3d_HSurfaceTool_VResolution(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param R3d:
    :type R3d: float
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_VResolution(*args)

def Adaptor3d_HSurfaceTool_GetType(*args) -> "GeomAbs_SurfaceType":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: GeomAbs_SurfaceType

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_GetType(*args)

def Adaptor3d_HSurfaceTool_Plane(*args) -> "gp_Pln":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Pln

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Plane(*args)

def Adaptor3d_HSurfaceTool_Cylinder(*args) -> "gp_Cylinder":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Cylinder

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Cylinder(*args)

def Adaptor3d_HSurfaceTool_Cone(*args) -> "gp_Cone":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Cone

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Cone(*args)

def Adaptor3d_HSurfaceTool_Torus(*args) -> "gp_Torus":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Torus

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Torus(*args)

def Adaptor3d_HSurfaceTool_Sphere(*args) -> "gp_Sphere":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Sphere

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Sphere(*args)

def Adaptor3d_HSurfaceTool_Bezier(*args) -> "Handle_Geom_BezierSurface":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: Handle_Geom_BezierSurface

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Bezier(*args)

def Adaptor3d_HSurfaceTool_BSpline(*args) -> "Handle_Geom_BSplineSurface":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: Handle_Geom_BSplineSurface

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_BSpline(*args)

def Adaptor3d_HSurfaceTool_AxeOfRevolution(*args) -> "gp_Ax1":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Ax1

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_AxeOfRevolution(*args)

def Adaptor3d_HSurfaceTool_Direction(*args) -> "gp_Dir":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: gp_Dir

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_Direction(*args)

def Adaptor3d_HSurfaceTool_BasisCurve(*args) -> "Handle_Adaptor3d_HCurve":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: Handle_Adaptor3d_HCurve

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_BasisCurve(*args)

def Adaptor3d_HSurfaceTool_BasisSurface(*args) -> "Handle_Adaptor3d_HSurface":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: Handle_Adaptor3d_HSurface

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_BasisSurface(*args)

def Adaptor3d_HSurfaceTool_OffsetValue(*args) -> "Standard_Real":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: float

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_OffsetValue(*args)

def Adaptor3d_HSurfaceTool_NbSamplesU(*args) -> "Standard_Integer":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: int

    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param u1:
    :type u1: float
    :param u2:
    :type u2: float
    :rtype: int

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_NbSamplesU(*args)

def Adaptor3d_HSurfaceTool_NbSamplesV(*args) -> "Standard_Integer":
    """
    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :rtype: int

    :param S:
    :type S: Handle_Adaptor3d_HSurface &
    :param v1:
    :type v1: float
    :param v2:
    :type v2: float
    :rtype: int

    """
    return _Adaptor3d.Adaptor3d_HSurfaceTool_NbSamplesV(*args)

class Adaptor3d_HVertex(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param P:
        :type P: gp_Pnt2d
        :param Ori:
        :type Ori: TopAbs_Orientation
        :param Resolution:
        :type Resolution: float
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HVertex_swiginit(self, _Adaptor3d.new_Adaptor3d_HVertex(*args))

    def Value(self, *args) -> "gp_Pnt2d":
        """
        :rtype: gp_Pnt2d

        """
        return _Adaptor3d.Adaptor3d_HVertex_Value(self, *args)


    def Parameter(self, *args) -> "Standard_Real":
        """
        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HVertex_Parameter(self, *args)


    def Resolution(self, *args) -> "Standard_Real":
        """
        * Parametric resolution (2d).

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_HVertex_Resolution(self, *args)


    def Orientation(self, *args) -> "TopAbs_Orientation":
        """
        :rtype: TopAbs_Orientation

        """
        return _Adaptor3d.Adaptor3d_HVertex_Orientation(self, *args)


    def IsSame(self, *args) -> "Standard_Boolean":
        """
        :param Other:
        :type Other: Handle_Adaptor3d_HVertex &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_HVertex_IsSame(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HVertex_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HVertex_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HVertex
Adaptor3d_HVertex.Value = new_instancemethod(_Adaptor3d.Adaptor3d_HVertex_Value, None, Adaptor3d_HVertex)
Adaptor3d_HVertex.Parameter = new_instancemethod(_Adaptor3d.Adaptor3d_HVertex_Parameter, None, Adaptor3d_HVertex)
Adaptor3d_HVertex.Resolution = new_instancemethod(_Adaptor3d.Adaptor3d_HVertex_Resolution, None, Adaptor3d_HVertex)
Adaptor3d_HVertex.Orientation = new_instancemethod(_Adaptor3d.Adaptor3d_HVertex_Orientation, None, Adaptor3d_HVertex)
Adaptor3d_HVertex.IsSame = new_instancemethod(_Adaptor3d.Adaptor3d_HVertex_IsSame, None, Adaptor3d_HVertex)
Adaptor3d_HVertex_swigregister = _Adaptor3d.Adaptor3d_HVertex_swigregister
Adaptor3d_HVertex_swigregister(Adaptor3d_HVertex)


class Meta_Adaptor3d_HVertex(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HVertex_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HVertex", "Adaptor3d_HVertex"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HVertex(with_metaclass(Meta_Adaptor3d_HVertex, Adaptor3d_HVertex)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HVertex", "Adaptor3d_HVertex"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HVertex(Handle_Adaptor3d_HVertex_DownCast(o))

class Adaptor3d_InterFunc(OCC.Core.math.math_FunctionWithDerivative):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * build the function U(t)=FixVal if Fix =1 or V(t)=FixVal if Fix=2

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :param FixVal:
        :type FixVal: float
        :param Fix:
        :type Fix: int
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_InterFunc_swiginit(self, _Adaptor3d.new_Adaptor3d_InterFunc(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_InterFunc
Adaptor3d_InterFunc_swigregister = _Adaptor3d.Adaptor3d_InterFunc_swigregister
Adaptor3d_InterFunc_swigregister(Adaptor3d_InterFunc)

class Adaptor3d_OffsetCurve(OCC.Core.Adaptor2d.Adaptor2d_Curve2d):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * The Offset is set to 0.

        :rtype: None

        * The curve is loaded. The Offset is set to 0.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: None

        * Creates an OffsetCurve curve. The Offset is set to Offset.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :param Offset:
        :type Offset: float
        :rtype: None

        * Create an Offset curve. WFirst,WLast define the bounds of the Offset curve.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :param Offset:
        :type Offset: float
        :param WFirst:
        :type WFirst: float
        :param WLast:
        :type WLast: float
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_OffsetCurve_swiginit(self, _Adaptor3d.new_Adaptor3d_OffsetCurve(*args))

    def Load(self, *args) -> "void":
        """
        * Changes the curve. The Offset is reset to 0.

        :param S:
        :type S: Handle_Adaptor2d_HCurve2d &
        :rtype: None

        * Changes the Offset on the current Curve.

        :param Offset:
        :type Offset: float
        :rtype: None

        * Changes the Offset Curve on the current Curve.

        :param Offset:
        :type Offset: float
        :param WFirst:
        :type WFirst: float
        :param WLast:
        :type WLast: float
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_OffsetCurve_Load(self, *args)


    def Curve(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor3d.Adaptor3d_OffsetCurve_Curve(self, *args)


    def Offset(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_OffsetCurve_Offset(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_OffsetCurve
Adaptor3d_OffsetCurve.Load = new_instancemethod(_Adaptor3d.Adaptor3d_OffsetCurve_Load, None, Adaptor3d_OffsetCurve)
Adaptor3d_OffsetCurve.Curve = new_instancemethod(_Adaptor3d.Adaptor3d_OffsetCurve_Curve, None, Adaptor3d_OffsetCurve)
Adaptor3d_OffsetCurve.Offset = new_instancemethod(_Adaptor3d.Adaptor3d_OffsetCurve_Offset, None, Adaptor3d_OffsetCurve)
Adaptor3d_OffsetCurve_swigregister = _Adaptor3d.Adaptor3d_OffsetCurve_swigregister
Adaptor3d_OffsetCurve_swigregister(Adaptor3d_OffsetCurve)

class Adaptor3d_Surface(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def FirstUParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_FirstUParameter(self, *args)


    def LastUParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_LastUParameter(self, *args)


    def FirstVParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_FirstVParameter(self, *args)


    def LastVParameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_LastVParameter(self, *args)


    def UContinuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_Surface_UContinuity(self, *args)


    def VContinuity(self, *args) -> "GeomAbs_Shape":
        """
        :rtype: GeomAbs_Shape

        """
        return _Adaptor3d.Adaptor3d_Surface_VContinuity(self, *args)


    def NbUIntervals(self, *args) -> "Standard_Integer":
        """
        * Returns the number of U intervals for continuity <S>. May be one if UContinuity(me) >= <S>

        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbUIntervals(self, *args)


    def NbVIntervals(self, *args) -> "Standard_Integer":
        """
        * Returns the number of V intervals for continuity <S>. May be one if VContinuity(me) >= <S>

        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbVIntervals(self, *args)


    def UIntervals(self, *args) -> "void":
        """
        * Returns the intervals with the requested continuity in the U direction.

        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_UIntervals(self, *args)


    def VIntervals(self, *args) -> "void":
        """
        * Returns the intervals with the requested continuity in the V direction.

        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_VIntervals(self, *args)


    def UTrim(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        * Returns a surface trimmed in the U direction equivalent of <self> between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_Surface_UTrim(self, *args)


    def VTrim(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        * Returns a surface trimmed in the V direction between parameters <First> and <Last>. <Tol> is used to test for 3d points confusion. If <First> >= <Last>

        :param First:
        :type First: float
        :param Last:
        :type Last: float
        :param Tol:
        :type Tol: float
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_Surface_VTrim(self, *args)


    def IsUClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsUClosed(self, *args)


    def IsVClosed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsVClosed(self, *args)


    def IsUPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsUPeriodic(self, *args)


    def UPeriod(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_UPeriod(self, *args)


    def IsVPeriodic(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsVPeriodic(self, *args)


    def VPeriod(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_VPeriod(self, *args)


    def Value(self, *args) -> "gp_Pnt":
        """
        * Computes the point of parameters U,V on the surface.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_Surface_Value(self, *args)


    def D0(self, *args) -> "void":
        """
        * Computes the point of parameters U,V on the surface.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_D0(self, *args)


    def D1(self, *args) -> "void":
        """
        * Computes the point and the first derivatives on the surface. Raised if the continuity of the current intervals is not C1.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_D1(self, *args)


    def D2(self, *args) -> "void":
        """
        * Computes the point, the first and second derivatives on the surface. Raised if the continuity of the current intervals is not C2.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_D2(self, *args)


    def D3(self, *args) -> "void":
        """
        * Computes the point, the first, second and third derivatives on the surface. Raised if the continuity of the current intervals is not C3.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param D1U:
        :type D1U: gp_Vec
        :param D1V:
        :type D1V: gp_Vec
        :param D2U:
        :type D2U: gp_Vec
        :param D2V:
        :type D2V: gp_Vec
        :param D2UV:
        :type D2UV: gp_Vec
        :param D3U:
        :type D3U: gp_Vec
        :param D3V:
        :type D3V: gp_Vec
        :param D3UUV:
        :type D3UUV: gp_Vec
        :param D3UVV:
        :type D3UVV: gp_Vec
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_Surface_D3(self, *args)


    def DN(self, *args) -> "gp_Vec":
        """
        * Computes the derivative of order Nu in the direction U and Nv in the direction V at the point P(U, V). Raised if the current U interval is not not CNu and the current V interval is not CNv. Raised if Nu + Nv < 1 or Nu < 0 or Nv < 0.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _Adaptor3d.Adaptor3d_Surface_DN(self, *args)


    def UResolution(self, *args) -> "Standard_Real":
        """
        * Returns the parametric U resolution corresponding to the real space resolution <R3d>.

        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_UResolution(self, *args)


    def VResolution(self, *args) -> "Standard_Real":
        """
        * Returns the parametric V resolution corresponding to the real space resolution <R3d>.

        :param R3d:
        :type R3d: float
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_VResolution(self, *args)


    def GetType(self, *args) -> "GeomAbs_SurfaceType":
        """
        * Returns the type of the surface : Plane, Cylinder, Cone, Sphere, Torus, BezierSurface, BSplineSurface, SurfaceOfRevolution, SurfaceOfExtrusion, OtherSurface

        :rtype: GeomAbs_SurfaceType

        """
        return _Adaptor3d.Adaptor3d_Surface_GetType(self, *args)


    def Plane(self, *args) -> "gp_Pln":
        """
        :rtype: gp_Pln

        """
        return _Adaptor3d.Adaptor3d_Surface_Plane(self, *args)


    def Cylinder(self, *args) -> "gp_Cylinder":
        """
        :rtype: gp_Cylinder

        """
        return _Adaptor3d.Adaptor3d_Surface_Cylinder(self, *args)


    def Cone(self, *args) -> "gp_Cone":
        """
        :rtype: gp_Cone

        """
        return _Adaptor3d.Adaptor3d_Surface_Cone(self, *args)


    def Sphere(self, *args) -> "gp_Sphere":
        """
        :rtype: gp_Sphere

        """
        return _Adaptor3d.Adaptor3d_Surface_Sphere(self, *args)


    def Torus(self, *args) -> "gp_Torus":
        """
        :rtype: gp_Torus

        """
        return _Adaptor3d.Adaptor3d_Surface_Torus(self, *args)


    def UDegree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_UDegree(self, *args)


    def NbUPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbUPoles(self, *args)


    def VDegree(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_VDegree(self, *args)


    def NbVPoles(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbVPoles(self, *args)


    def NbUKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbUKnots(self, *args)


    def NbVKnots(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_Surface_NbVKnots(self, *args)


    def IsURational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsURational(self, *args)


    def IsVRational(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_Surface_IsVRational(self, *args)


    def Bezier(self, *args) -> "Handle_Geom_BezierSurface":
        """
        :rtype: Handle_Geom_BezierSurface

        """
        return _Adaptor3d.Adaptor3d_Surface_Bezier(self, *args)


    def BSpline(self, *args) -> "Handle_Geom_BSplineSurface":
        """
        :rtype: Handle_Geom_BSplineSurface

        """
        return _Adaptor3d.Adaptor3d_Surface_BSpline(self, *args)


    def AxeOfRevolution(self, *args) -> "gp_Ax1":
        """
        :rtype: gp_Ax1

        """
        return _Adaptor3d.Adaptor3d_Surface_AxeOfRevolution(self, *args)


    def Direction(self, *args) -> "gp_Dir":
        """
        :rtype: gp_Dir

        """
        return _Adaptor3d.Adaptor3d_Surface_Direction(self, *args)


    def BasisCurve(self, *args) -> "Handle_Adaptor3d_HCurve":
        """
        :rtype: Handle_Adaptor3d_HCurve

        """
        return _Adaptor3d.Adaptor3d_Surface_BasisCurve(self, *args)


    def BasisSurface(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_Surface_BasisSurface(self, *args)


    def OffsetValue(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_Surface_OffsetValue(self, *args)


    __repr__ = _dumps_object


    def __init__(self):
        _Adaptor3d.Adaptor3d_Surface_swiginit(self, _Adaptor3d.new_Adaptor3d_Surface())
    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_Surface
Adaptor3d_Surface.FirstUParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_FirstUParameter, None, Adaptor3d_Surface)
Adaptor3d_Surface.LastUParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_LastUParameter, None, Adaptor3d_Surface)
Adaptor3d_Surface.FirstVParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_FirstVParameter, None, Adaptor3d_Surface)
Adaptor3d_Surface.LastVParameter = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_LastVParameter, None, Adaptor3d_Surface)
Adaptor3d_Surface.UContinuity = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UContinuity, None, Adaptor3d_Surface)
Adaptor3d_Surface.VContinuity = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VContinuity, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbUIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbUIntervals, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbVIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbVIntervals, None, Adaptor3d_Surface)
Adaptor3d_Surface.UIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UIntervals, None, Adaptor3d_Surface)
Adaptor3d_Surface.VIntervals = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VIntervals, None, Adaptor3d_Surface)
Adaptor3d_Surface.UTrim = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UTrim, None, Adaptor3d_Surface)
Adaptor3d_Surface.VTrim = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VTrim, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsUClosed = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsUClosed, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsVClosed = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsVClosed, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsUPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsUPeriodic, None, Adaptor3d_Surface)
Adaptor3d_Surface.UPeriod = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UPeriod, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsVPeriodic = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsVPeriodic, None, Adaptor3d_Surface)
Adaptor3d_Surface.VPeriod = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VPeriod, None, Adaptor3d_Surface)
Adaptor3d_Surface.Value = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Value, None, Adaptor3d_Surface)
Adaptor3d_Surface.D0 = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_D0, None, Adaptor3d_Surface)
Adaptor3d_Surface.D1 = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_D1, None, Adaptor3d_Surface)
Adaptor3d_Surface.D2 = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_D2, None, Adaptor3d_Surface)
Adaptor3d_Surface.D3 = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_D3, None, Adaptor3d_Surface)
Adaptor3d_Surface.DN = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_DN, None, Adaptor3d_Surface)
Adaptor3d_Surface.UResolution = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UResolution, None, Adaptor3d_Surface)
Adaptor3d_Surface.VResolution = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VResolution, None, Adaptor3d_Surface)
Adaptor3d_Surface.GetType = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_GetType, None, Adaptor3d_Surface)
Adaptor3d_Surface.Plane = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Plane, None, Adaptor3d_Surface)
Adaptor3d_Surface.Cylinder = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Cylinder, None, Adaptor3d_Surface)
Adaptor3d_Surface.Cone = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Cone, None, Adaptor3d_Surface)
Adaptor3d_Surface.Sphere = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Sphere, None, Adaptor3d_Surface)
Adaptor3d_Surface.Torus = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Torus, None, Adaptor3d_Surface)
Adaptor3d_Surface.UDegree = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_UDegree, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbUPoles = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbUPoles, None, Adaptor3d_Surface)
Adaptor3d_Surface.VDegree = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_VDegree, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbVPoles = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbVPoles, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbUKnots = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbUKnots, None, Adaptor3d_Surface)
Adaptor3d_Surface.NbVKnots = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_NbVKnots, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsURational = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsURational, None, Adaptor3d_Surface)
Adaptor3d_Surface.IsVRational = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_IsVRational, None, Adaptor3d_Surface)
Adaptor3d_Surface.Bezier = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Bezier, None, Adaptor3d_Surface)
Adaptor3d_Surface.BSpline = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_BSpline, None, Adaptor3d_Surface)
Adaptor3d_Surface.AxeOfRevolution = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_AxeOfRevolution, None, Adaptor3d_Surface)
Adaptor3d_Surface.Direction = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_Direction, None, Adaptor3d_Surface)
Adaptor3d_Surface.BasisCurve = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_BasisCurve, None, Adaptor3d_Surface)
Adaptor3d_Surface.BasisSurface = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_BasisSurface, None, Adaptor3d_Surface)
Adaptor3d_Surface.OffsetValue = new_instancemethod(_Adaptor3d.Adaptor3d_Surface_OffsetValue, None, Adaptor3d_Surface)
Adaptor3d_Surface_swigregister = _Adaptor3d.Adaptor3d_Surface_swigregister
Adaptor3d_Surface_swigregister(Adaptor3d_Surface)

class Adaptor3d_TopolTool(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param Surface:
        :type Surface: Handle_Adaptor3d_HSurface &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_TopolTool_swiginit(self, _Adaptor3d.new_Adaptor3d_TopolTool(*args))

    def Initialize(self, *args) -> "void":
        """
        :rtype: void

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: void

        :param Curve:
        :type Curve: Handle_Adaptor2d_HCurve2d &
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Initialize(self, *args)


    def Init(self, *args) -> "void":
        """
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Init(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_More(self, *args)


    def Value(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Value(self, *args)


    def Next(self, *args) -> "void":
        """
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Next(self, *args)


    def InitVertexIterator(self, *args) -> "void":
        """
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_InitVertexIterator(self, *args)


    def MoreVertex(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_MoreVertex(self, *args)


    def Vertex(self, *args) -> "Handle_Adaptor3d_HVertex":
        """
        :rtype: Handle_Adaptor3d_HVertex

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Vertex(self, *args)


    def NextVertex(self, *args) -> "void":
        """
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_NextVertex(self, *args)


    def Classify(self, *args) -> "TopAbs_State":
        """
        :param P:
        :type P: gp_Pnt2d
        :param Tol:
        :type Tol: float
        :param ReacdreOnPeriodic: default value is Standard_True
        :type ReacdreOnPeriodic: bool
        :rtype: TopAbs_State

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Classify(self, *args)


    def IsThePointOn(self, *args) -> "Standard_Boolean":
        """
        :param P:
        :type P: gp_Pnt2d
        :param Tol:
        :type Tol: float
        :param ReacdreOnPeriodic: default value is Standard_True
        :type ReacdreOnPeriodic: bool
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_IsThePointOn(self, *args)


    def Orientation(self, *args) -> "TopAbs_Orientation":
        """
        * If the function returns the orientation of the arc. If the orientation is FORWARD or REVERSED, the arc is a 'real' limit of the surface. If the orientation is INTERNAL or EXTERNAL, the arc is considered as an arc on the surface.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: TopAbs_Orientation

        * Returns the orientation of the vertex V. The vertex has been found with an exploration on a given arc. The orientation is the orientation of the vertex on this arc.

        :param V:
        :type V: Handle_Adaptor3d_HVertex &
        :rtype: TopAbs_Orientation

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Orientation(self, *args)


    def Identical(self, *args) -> "Standard_Boolean":
        """
        * Returns True if the vertices V1 and V2 are identical. This method does not take the orientation of the vertices in account.

        :param V1:
        :type V1: Handle_Adaptor3d_HVertex &
        :param V2:
        :type V2: Handle_Adaptor3d_HVertex &
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Identical(self, *args)


    def Has3d(self, *args) -> "Standard_Boolean":
        """
        * answers if arcs and vertices may have 3d representations, so that we could use Tol3d and Pnt methods.

        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Has3d(self, *args)


    def Tol3d(self, *args) -> "Standard_Real":
        """
        * returns 3d tolerance of the arc C

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: float

        * returns 3d tolerance of the vertex V

        :param V:
        :type V: Handle_Adaptor3d_HVertex &
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Tol3d(self, *args)


    def Pnt(self, *args) -> "gp_Pnt":
        """
        * returns 3d point of the vertex V

        :param V:
        :type V: Handle_Adaptor3d_HVertex &
        :rtype: gp_Pnt

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Pnt(self, *args)


    def ComputeSamplePoints(self, *args) -> "void":
        """
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_ComputeSamplePoints(self, *args)


    def NbSamplesU(self, *args) -> "Standard_Integer":
        """
        * compute the sample-points for the intersections algorithms

        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_TopolTool_NbSamplesU(self, *args)


    def NbSamplesV(self, *args) -> "Standard_Integer":
        """
        * compute the sample-points for the intersections algorithms

        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_TopolTool_NbSamplesV(self, *args)


    def NbSamples(self, *args) -> "Standard_Integer":
        """
        * compute the sample-points for the intersections algorithms

        :rtype: int

        """
        return _Adaptor3d.Adaptor3d_TopolTool_NbSamples(self, *args)


    def UParameters(self, *args) -> "void":
        """
        * return the set of U parameters on the surface obtained by the method SamplePnts

        :param theArray:
        :type theArray: TColStd_Array1OfReal &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_TopolTool_UParameters(self, *args)


    def VParameters(self, *args) -> "void":
        """
        * return the set of V parameters on the surface obtained by the method SamplePnts

        :param theArray:
        :type theArray: TColStd_Array1OfReal &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_TopolTool_VParameters(self, *args)


    def SamplePoint(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param P2d:
        :type P2d: gp_Pnt2d
        :param P3d:
        :type P3d: gp_Pnt
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_SamplePoint(self, *args)


    def DomainIsInfinite(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_DomainIsInfinite(self, *args)


    def Edge(self, *args) -> "Standard_Address":
        """
        :rtype: Standard_Address

        """
        return _Adaptor3d.Adaptor3d_TopolTool_Edge(self, *args)


    def SamplePnts(self, *args) -> "void":
        """
        * compute the sample-points for the intersections algorithms by adaptive algorithm for BSpline surfaces. For other surfaces algorithm is the same as in method ComputeSamplePoints(), but only fill arrays of U and V sample parameters; theDefl is a requred deflection theNUmin, theNVmin are minimal nb points for U and V.

        :param theDefl:
        :type theDefl: float
        :param theNUmin:
        :type theNUmin: int
        :param theNVmin:
        :type theNVmin: int
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_SamplePnts(self, *args)


    def BSplSamplePnts(self, *args) -> "void":
        """
        * compute the sample-points for the intersections algorithms by adaptive algorithm for BSpline surfaces - is used in SamplePnts theDefl is a requred deflection theNUmin, theNVmin are minimal nb points for U and V.

        :param theDefl:
        :type theDefl: float
        :param theNUmin:
        :type theNUmin: int
        :param theNVmin:
        :type theNVmin: int
        :rtype: void

        """
        return _Adaptor3d.Adaptor3d_TopolTool_BSplSamplePnts(self, *args)


    def IsUniformSampling(self, *args) -> "Standard_Boolean":
        """
        * Returns true if provide uniform sampling of points.

        :rtype: bool

        """
        return _Adaptor3d.Adaptor3d_TopolTool_IsUniformSampling(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_TopolTool_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_TopolTool_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_TopolTool
Adaptor3d_TopolTool.Initialize = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Initialize, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Init = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Init, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.More = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_More, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Value = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Value, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Next = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Next, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.InitVertexIterator = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_InitVertexIterator, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.MoreVertex = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_MoreVertex, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Vertex = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Vertex, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.NextVertex = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_NextVertex, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Classify = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Classify, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.IsThePointOn = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_IsThePointOn, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Orientation = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Orientation, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Identical = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Identical, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Has3d = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Has3d, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Tol3d = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Tol3d, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Pnt = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Pnt, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.ComputeSamplePoints = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_ComputeSamplePoints, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.NbSamplesU = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_NbSamplesU, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.NbSamplesV = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_NbSamplesV, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.NbSamples = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_NbSamples, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.UParameters = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_UParameters, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.VParameters = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_VParameters, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.SamplePoint = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_SamplePoint, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.DomainIsInfinite = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_DomainIsInfinite, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.Edge = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_Edge, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.SamplePnts = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_SamplePnts, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.BSplSamplePnts = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_BSplSamplePnts, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool.IsUniformSampling = new_instancemethod(_Adaptor3d.Adaptor3d_TopolTool_IsUniformSampling, None, Adaptor3d_TopolTool)
Adaptor3d_TopolTool_swigregister = _Adaptor3d.Adaptor3d_TopolTool_swigregister
Adaptor3d_TopolTool_swigregister(Adaptor3d_TopolTool)


class Meta_Adaptor3d_TopolTool(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_TopolTool_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_TopolTool", "Adaptor3d_TopolTool"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_TopolTool(with_metaclass(Meta_Adaptor3d_TopolTool, Adaptor3d_TopolTool)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_TopolTool", "Adaptor3d_TopolTool"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_TopolTool(Handle_Adaptor3d_TopolTool_DownCast(o))

class Adaptor3d_CurveOnSurface(Adaptor3d_Curve):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: None

        * Creates a CurveOnSurface from the 2d curve <C> and the surface <S>.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_CurveOnSurface_swiginit(self, _Adaptor3d.new_Adaptor3d_CurveOnSurface(*args))

    def Load(self, *args) -> "void":
        """
        * Changes the surface.

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: None

        * Changes the 2d curve.

        :param C:
        :type C: Handle_Adaptor2d_HCurve2d &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_CurveOnSurface_Load(self, *args)


    def GetCurve(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor3d.Adaptor3d_CurveOnSurface_GetCurve(self, *args)


    def GetSurface(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_CurveOnSurface_GetSurface(self, *args)


    def ChangeCurve(self, *args) -> "Handle_Adaptor2d_HCurve2d":
        """
        :rtype: Handle_Adaptor2d_HCurve2d

        """
        return _Adaptor3d.Adaptor3d_CurveOnSurface_ChangeCurve(self, *args)


    def ChangeSurface(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_CurveOnSurface_ChangeSurface(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_CurveOnSurface
Adaptor3d_CurveOnSurface.Load = new_instancemethod(_Adaptor3d.Adaptor3d_CurveOnSurface_Load, None, Adaptor3d_CurveOnSurface)
Adaptor3d_CurveOnSurface.GetCurve = new_instancemethod(_Adaptor3d.Adaptor3d_CurveOnSurface_GetCurve, None, Adaptor3d_CurveOnSurface)
Adaptor3d_CurveOnSurface.GetSurface = new_instancemethod(_Adaptor3d.Adaptor3d_CurveOnSurface_GetSurface, None, Adaptor3d_CurveOnSurface)
Adaptor3d_CurveOnSurface.ChangeCurve = new_instancemethod(_Adaptor3d.Adaptor3d_CurveOnSurface_ChangeCurve, None, Adaptor3d_CurveOnSurface)
Adaptor3d_CurveOnSurface.ChangeSurface = new_instancemethod(_Adaptor3d.Adaptor3d_CurveOnSurface_ChangeSurface, None, Adaptor3d_CurveOnSurface)
Adaptor3d_CurveOnSurface_swigregister = _Adaptor3d.Adaptor3d_CurveOnSurface_swigregister
Adaptor3d_CurveOnSurface_swigregister(Adaptor3d_CurveOnSurface)

class Adaptor3d_HCurveOnSurface(Adaptor3d_HCurve):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param C:
        :type C: Adaptor3d_CurveOnSurface &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HCurveOnSurface_swiginit(self, _Adaptor3d.new_Adaptor3d_HCurveOnSurface(*args))

    def Set(self, *args) -> "void":
        """
        :param C:
        :type C: Adaptor3d_CurveOnSurface &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HCurveOnSurface_Set(self, *args)


    def ChangeCurve(self, *args) -> "Adaptor3d_CurveOnSurface &":
        """
        :rtype: Adaptor3d_CurveOnSurface

        """
        return _Adaptor3d.Adaptor3d_HCurveOnSurface_ChangeCurve(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HCurveOnSurface_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HCurveOnSurface_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HCurveOnSurface
Adaptor3d_HCurveOnSurface.Set = new_instancemethod(_Adaptor3d.Adaptor3d_HCurveOnSurface_Set, None, Adaptor3d_HCurveOnSurface)
Adaptor3d_HCurveOnSurface.ChangeCurve = new_instancemethod(_Adaptor3d.Adaptor3d_HCurveOnSurface_ChangeCurve, None, Adaptor3d_HCurveOnSurface)
Adaptor3d_HCurveOnSurface_swigregister = _Adaptor3d.Adaptor3d_HCurveOnSurface_swigregister
Adaptor3d_HCurveOnSurface_swigregister(Adaptor3d_HCurveOnSurface)


class Meta_Adaptor3d_HCurveOnSurface(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HCurveOnSurface_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HCurveOnSurface", "Adaptor3d_HCurveOnSurface"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HCurveOnSurface(with_metaclass(Meta_Adaptor3d_HCurveOnSurface, Adaptor3d_HCurveOnSurface)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HCurveOnSurface", "Adaptor3d_HCurveOnSurface"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HCurveOnSurface(Handle_Adaptor3d_HCurveOnSurface_DownCast(o))

class Adaptor3d_HIsoCurve(Adaptor3d_HCurve):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param C:
        :type C: Adaptor3d_IsoCurve &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HIsoCurve_swiginit(self, _Adaptor3d.new_Adaptor3d_HIsoCurve(*args))

    def Set(self, *args) -> "void":
        """
        :param C:
        :type C: Adaptor3d_IsoCurve &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HIsoCurve_Set(self, *args)


    def ChangeCurve(self, *args) -> "Adaptor3d_IsoCurve &":
        """
        :rtype: Adaptor3d_IsoCurve

        """
        return _Adaptor3d.Adaptor3d_HIsoCurve_ChangeCurve(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HIsoCurve_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HIsoCurve_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HIsoCurve
Adaptor3d_HIsoCurve.Set = new_instancemethod(_Adaptor3d.Adaptor3d_HIsoCurve_Set, None, Adaptor3d_HIsoCurve)
Adaptor3d_HIsoCurve.ChangeCurve = new_instancemethod(_Adaptor3d.Adaptor3d_HIsoCurve_ChangeCurve, None, Adaptor3d_HIsoCurve)
Adaptor3d_HIsoCurve_swigregister = _Adaptor3d.Adaptor3d_HIsoCurve_swigregister
Adaptor3d_HIsoCurve_swigregister(Adaptor3d_HIsoCurve)


class Meta_Adaptor3d_HIsoCurve(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HIsoCurve_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HIsoCurve", "Adaptor3d_HIsoCurve"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HIsoCurve(with_metaclass(Meta_Adaptor3d_HIsoCurve, Adaptor3d_HIsoCurve)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HIsoCurve", "Adaptor3d_HIsoCurve"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HIsoCurve(Handle_Adaptor3d_HIsoCurve_DownCast(o))

class Adaptor3d_HSurfaceOfLinearExtrusion(Adaptor3d_HSurface):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param S:
        :type S: Adaptor3d_SurfaceOfLinearExtrusion &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_swiginit(self, _Adaptor3d.new_Adaptor3d_HSurfaceOfLinearExtrusion(*args))

    def Set(self, *args) -> "void":
        """
        :param S:
        :type S: Adaptor3d_SurfaceOfLinearExtrusion &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_Set(self, *args)


    def ChangeSurface(self, *args) -> "Adaptor3d_SurfaceOfLinearExtrusion &":
        """
        :rtype: Adaptor3d_SurfaceOfLinearExtrusion

        """
        return _Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_ChangeSurface(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HSurfaceOfLinearExtrusion_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HSurfaceOfLinearExtrusion
Adaptor3d_HSurfaceOfLinearExtrusion.Set = new_instancemethod(_Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_Set, None, Adaptor3d_HSurfaceOfLinearExtrusion)
Adaptor3d_HSurfaceOfLinearExtrusion.ChangeSurface = new_instancemethod(_Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_ChangeSurface, None, Adaptor3d_HSurfaceOfLinearExtrusion)
Adaptor3d_HSurfaceOfLinearExtrusion_swigregister = _Adaptor3d.Adaptor3d_HSurfaceOfLinearExtrusion_swigregister
Adaptor3d_HSurfaceOfLinearExtrusion_swigregister(Adaptor3d_HSurfaceOfLinearExtrusion)


class Meta_Adaptor3d_HSurfaceOfLinearExtrusion(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HSurfaceOfLinearExtrusion_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HSurfaceOfLinearExtrusion", "Adaptor3d_HSurfaceOfLinearExtrusion"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HSurfaceOfLinearExtrusion(with_metaclass(Meta_Adaptor3d_HSurfaceOfLinearExtrusion, Adaptor3d_HSurfaceOfLinearExtrusion)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HSurfaceOfLinearExtrusion", "Adaptor3d_HSurfaceOfLinearExtrusion"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HSurfaceOfLinearExtrusion(Handle_Adaptor3d_HSurfaceOfLinearExtrusion_DownCast(o))

class Adaptor3d_HSurfaceOfRevolution(Adaptor3d_HSurface):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param S:
        :type S: Adaptor3d_SurfaceOfRevolution &
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_HSurfaceOfRevolution_swiginit(self, _Adaptor3d.new_Adaptor3d_HSurfaceOfRevolution(*args))

    def Set(self, *args) -> "void":
        """
        :param S:
        :type S: Adaptor3d_SurfaceOfRevolution &
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_HSurfaceOfRevolution_Set(self, *args)


    def ChangeSurface(self, *args) -> "Adaptor3d_SurfaceOfRevolution &":
        """
        :rtype: Adaptor3d_SurfaceOfRevolution

        """
        return _Adaptor3d.Adaptor3d_HSurfaceOfRevolution_ChangeSurface(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Adaptor3d_HSurfaceOfRevolution_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Adaptor3d_HSurfaceOfRevolution_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_HSurfaceOfRevolution
Adaptor3d_HSurfaceOfRevolution.Set = new_instancemethod(_Adaptor3d.Adaptor3d_HSurfaceOfRevolution_Set, None, Adaptor3d_HSurfaceOfRevolution)
Adaptor3d_HSurfaceOfRevolution.ChangeSurface = new_instancemethod(_Adaptor3d.Adaptor3d_HSurfaceOfRevolution_ChangeSurface, None, Adaptor3d_HSurfaceOfRevolution)
Adaptor3d_HSurfaceOfRevolution_swigregister = _Adaptor3d.Adaptor3d_HSurfaceOfRevolution_swigregister
Adaptor3d_HSurfaceOfRevolution_swigregister(Adaptor3d_HSurfaceOfRevolution)


class Meta_Adaptor3d_HSurfaceOfRevolution(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Adaptor3d_HSurfaceOfRevolution_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Adaptor3d_HSurfaceOfRevolution", "Adaptor3d_HSurfaceOfRevolution"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Adaptor3d_HSurfaceOfRevolution(with_metaclass(Meta_Adaptor3d_HSurfaceOfRevolution, Adaptor3d_HSurfaceOfRevolution)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Adaptor3d_HSurfaceOfRevolution", "Adaptor3d_HSurfaceOfRevolution"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Adaptor3d_HSurfaceOfRevolution(Handle_Adaptor3d_HSurfaceOfRevolution_DownCast(o))

class Adaptor3d_IsoCurve(Adaptor3d_Curve):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * The iso is set to NoneIso.

        :rtype: None

        * The surface is loaded. The iso is set to NoneIso.

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: None

        * Creates an IsoCurve curve. Iso defines the type (isoU or isoU) Param defines the value of the iso. The bounds of the iso are the bounds of the surface.

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param Iso:
        :type Iso: GeomAbs_IsoType
        :param Param:
        :type Param: float
        :rtype: None

        * Create an IsoCurve curve. Iso defines the type (isoU or isov). Param defines the value of the iso. WFirst,WLast define the bounds of the iso.

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :param Iso:
        :type Iso: GeomAbs_IsoType
        :param Param:
        :type Param: float
        :param WFirst:
        :type WFirst: float
        :param WLast:
        :type WLast: float
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_IsoCurve_swiginit(self, _Adaptor3d.new_Adaptor3d_IsoCurve(*args))

    def Load(self, *args) -> "void":
        """
        * Changes the surface. The iso is reset to NoneIso.

        :param S:
        :type S: Handle_Adaptor3d_HSurface &
        :rtype: None

        * Changes the iso on the current surface.

        :param Iso:
        :type Iso: GeomAbs_IsoType
        :param Param:
        :type Param: float
        :rtype: None

        * Changes the iso on the current surface.

        :param Iso:
        :type Iso: GeomAbs_IsoType
        :param Param:
        :type Param: float
        :param WFirst:
        :type WFirst: float
        :param WLast:
        :type WLast: float
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_IsoCurve_Load(self, *args)


    def Surface(self, *args) -> "Handle_Adaptor3d_HSurface":
        """
        :rtype: Handle_Adaptor3d_HSurface

        """
        return _Adaptor3d.Adaptor3d_IsoCurve_Surface(self, *args)


    def Iso(self, *args) -> "GeomAbs_IsoType":
        """
        :rtype: GeomAbs_IsoType

        """
        return _Adaptor3d.Adaptor3d_IsoCurve_Iso(self, *args)


    def Parameter(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Adaptor3d.Adaptor3d_IsoCurve_Parameter(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_IsoCurve
Adaptor3d_IsoCurve.Load = new_instancemethod(_Adaptor3d.Adaptor3d_IsoCurve_Load, None, Adaptor3d_IsoCurve)
Adaptor3d_IsoCurve.Surface = new_instancemethod(_Adaptor3d.Adaptor3d_IsoCurve_Surface, None, Adaptor3d_IsoCurve)
Adaptor3d_IsoCurve.Iso = new_instancemethod(_Adaptor3d.Adaptor3d_IsoCurve_Iso, None, Adaptor3d_IsoCurve)
Adaptor3d_IsoCurve.Parameter = new_instancemethod(_Adaptor3d.Adaptor3d_IsoCurve_Parameter, None, Adaptor3d_IsoCurve)
Adaptor3d_IsoCurve_swigregister = _Adaptor3d.Adaptor3d_IsoCurve_swigregister
Adaptor3d_IsoCurve_swigregister(Adaptor3d_IsoCurve)

class Adaptor3d_SurfaceOfLinearExtrusion(Adaptor3d_Surface):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        * The Curve is loaded.

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :rtype: None

        * Thew Curve and the Direction are loaded.

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :param V:
        :type V: gp_Dir
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_SurfaceOfLinearExtrusion_swiginit(self, _Adaptor3d.new_Adaptor3d_SurfaceOfLinearExtrusion(*args))

    def Load(self, *args) -> "void":
        """
        * Changes the Curve

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :rtype: None

        * Changes the Direction

        :param V:
        :type V: gp_Dir
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_SurfaceOfLinearExtrusion_Load(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_SurfaceOfLinearExtrusion
Adaptor3d_SurfaceOfLinearExtrusion.Load = new_instancemethod(_Adaptor3d.Adaptor3d_SurfaceOfLinearExtrusion_Load, None, Adaptor3d_SurfaceOfLinearExtrusion)
Adaptor3d_SurfaceOfLinearExtrusion_swigregister = _Adaptor3d.Adaptor3d_SurfaceOfLinearExtrusion_swigregister
Adaptor3d_SurfaceOfLinearExtrusion_swigregister(Adaptor3d_SurfaceOfLinearExtrusion)

class Adaptor3d_SurfaceOfRevolution(Adaptor3d_Surface):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        * The Curve is loaded.

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :rtype: None

        * The Curve and the Direction are loaded.

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :param V:
        :type V: gp_Ax1
        :rtype: None

        """
        _Adaptor3d.Adaptor3d_SurfaceOfRevolution_swiginit(self, _Adaptor3d.new_Adaptor3d_SurfaceOfRevolution(*args))

    def Load(self, *args) -> "void":
        """
        * Changes the Curve

        :param C:
        :type C: Handle_Adaptor3d_HCurve &
        :rtype: None

        * Changes the Direction

        :param V:
        :type V: gp_Ax1
        :rtype: None

        """
        return _Adaptor3d.Adaptor3d_SurfaceOfRevolution_Load(self, *args)


    def Axis(self, *args) -> "gp_Ax3":
        """
        :rtype: gp_Ax3

        """
        return _Adaptor3d.Adaptor3d_SurfaceOfRevolution_Axis(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Adaptor3d.delete_Adaptor3d_SurfaceOfRevolution
Adaptor3d_SurfaceOfRevolution.Load = new_instancemethod(_Adaptor3d.Adaptor3d_SurfaceOfRevolution_Load, None, Adaptor3d_SurfaceOfRevolution)
Adaptor3d_SurfaceOfRevolution.Axis = new_instancemethod(_Adaptor3d.Adaptor3d_SurfaceOfRevolution_Axis, None, Adaptor3d_SurfaceOfRevolution)
Adaptor3d_SurfaceOfRevolution_swigregister = _Adaptor3d.Adaptor3d_SurfaceOfRevolution_swigregister
Adaptor3d_SurfaceOfRevolution_swigregister(Adaptor3d_SurfaceOfRevolution)



