# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
This package provides classes and services to
handle :

* 3D triangular polyhedrons.

* 3D polygons.

* 2D polygon.

* Tools to dump, save and restore those objects.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _Poly.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Poly')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Poly')
    _Poly = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Poly', [dirname(__file__)])
        except ImportError:
            import _Poly
            return _Poly
        try:
            _mod = imp.load_module('_Poly', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Poly = swig_import_helper()
    del swig_import_helper
else:
    import _Poly
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Poly.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_Poly.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_Poly.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_Poly.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_Poly.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_Poly.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_Poly.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_Poly.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_Poly.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_Poly.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_Poly.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_Poly.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_Poly.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_Poly.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_Poly.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_Poly.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_Poly.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _Poly.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _Poly.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.gp
import OCC.Core.NCollection
import OCC.Core.MMgt
import OCC.Core.TColgp
import OCC.Core.TCollection
import OCC.Core.TColStd
import OCC.Core.TShort

def Handle_Poly_HArray1OfTriangle_Create() -> "Handle_Poly_HArray1OfTriangle":
    return _Poly.Handle_Poly_HArray1OfTriangle_Create()
Handle_Poly_HArray1OfTriangle_Create = _Poly.Handle_Poly_HArray1OfTriangle_Create

def Handle_Poly_HArray1OfTriangle_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Poly_HArray1OfTriangle":
    return _Poly.Handle_Poly_HArray1OfTriangle_DownCast(t)
Handle_Poly_HArray1OfTriangle_DownCast = _Poly.Handle_Poly_HArray1OfTriangle_DownCast

def Handle_Poly_HArray1OfTriangle_IsNull(t: 'Handle_Poly_HArray1OfTriangle const &') -> "bool":
    return _Poly.Handle_Poly_HArray1OfTriangle_IsNull(t)
Handle_Poly_HArray1OfTriangle_IsNull = _Poly.Handle_Poly_HArray1OfTriangle_IsNull

def Handle_Poly_Polygon2D_Create() -> "Handle_Poly_Polygon2D":
    return _Poly.Handle_Poly_Polygon2D_Create()
Handle_Poly_Polygon2D_Create = _Poly.Handle_Poly_Polygon2D_Create

def Handle_Poly_Polygon2D_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Poly_Polygon2D":
    return _Poly.Handle_Poly_Polygon2D_DownCast(t)
Handle_Poly_Polygon2D_DownCast = _Poly.Handle_Poly_Polygon2D_DownCast

def Handle_Poly_Polygon2D_IsNull(t: 'Handle_Poly_Polygon2D const &') -> "bool":
    return _Poly.Handle_Poly_Polygon2D_IsNull(t)
Handle_Poly_Polygon2D_IsNull = _Poly.Handle_Poly_Polygon2D_IsNull

def Handle_Poly_Polygon3D_Create() -> "Handle_Poly_Polygon3D":
    return _Poly.Handle_Poly_Polygon3D_Create()
Handle_Poly_Polygon3D_Create = _Poly.Handle_Poly_Polygon3D_Create

def Handle_Poly_Polygon3D_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Poly_Polygon3D":
    return _Poly.Handle_Poly_Polygon3D_DownCast(t)
Handle_Poly_Polygon3D_DownCast = _Poly.Handle_Poly_Polygon3D_DownCast

def Handle_Poly_Polygon3D_IsNull(t: 'Handle_Poly_Polygon3D const &') -> "bool":
    return _Poly.Handle_Poly_Polygon3D_IsNull(t)
Handle_Poly_Polygon3D_IsNull = _Poly.Handle_Poly_Polygon3D_IsNull

def Handle_Poly_PolygonOnTriangulation_Create() -> "Handle_Poly_PolygonOnTriangulation":
    return _Poly.Handle_Poly_PolygonOnTriangulation_Create()
Handle_Poly_PolygonOnTriangulation_Create = _Poly.Handle_Poly_PolygonOnTriangulation_Create

def Handle_Poly_PolygonOnTriangulation_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Poly_PolygonOnTriangulation":
    return _Poly.Handle_Poly_PolygonOnTriangulation_DownCast(t)
Handle_Poly_PolygonOnTriangulation_DownCast = _Poly.Handle_Poly_PolygonOnTriangulation_DownCast

def Handle_Poly_PolygonOnTriangulation_IsNull(t: 'Handle_Poly_PolygonOnTriangulation const &') -> "bool":
    return _Poly.Handle_Poly_PolygonOnTriangulation_IsNull(t)
Handle_Poly_PolygonOnTriangulation_IsNull = _Poly.Handle_Poly_PolygonOnTriangulation_IsNull

def Handle_Poly_Triangulation_Create() -> "Handle_Poly_Triangulation":
    return _Poly.Handle_Poly_Triangulation_Create()
Handle_Poly_Triangulation_Create = _Poly.Handle_Poly_Triangulation_Create

def Handle_Poly_Triangulation_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Poly_Triangulation":
    return _Poly.Handle_Poly_Triangulation_DownCast(t)
Handle_Poly_Triangulation_DownCast = _Poly.Handle_Poly_Triangulation_DownCast

def Handle_Poly_Triangulation_IsNull(t: 'Handle_Poly_Triangulation const &') -> "bool":
    return _Poly.Handle_Poly_Triangulation_IsNull(t)
Handle_Poly_Triangulation_IsNull = _Poly.Handle_Poly_Triangulation_IsNull
class poly(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def Catenate(*args) -> "Handle_Poly_Triangulation":
        """
        * Computes and stores the link from nodes to triangles and from triangles to neighbouring triangles. This tool is obsolete, replaced by Poly_CoherentTriangulation Algorithm to make minimal loops in a graph Join several triangulations to one new triangulation object. The new triangulation is just a mechanical sum of input triangulations, without node sharing. UV coordinates are dropped in the result.

        :param lstTri:
        :type lstTri: Poly_ListOfTriangulation &
        :rtype: Handle_Poly_Triangulation

        """
        return _Poly.poly_Catenate(*args)

    Catenate = staticmethod(Catenate)

    def Write(*args) -> "void":
        """
        * Writes the content of the triangulation <T> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

        :param T:
        :type T: Handle_Poly_Triangulation &
        :param OS:
        :type OS: Standard_OStream &
        :param Compact: default value is Standard_True
        :type Compact: bool
        :rtype: void

        * Writes the content of the 3D polygon <P> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

        :param P:
        :type P: Handle_Poly_Polygon3D &
        :param OS:
        :type OS: Standard_OStream &
        :param Compact: default value is Standard_True
        :type Compact: bool
        :rtype: void

        * Writes the content of the 2D polygon <P> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

        :param P:
        :type P: Handle_Poly_Polygon2D &
        :param OS:
        :type OS: Standard_OStream &
        :param Compact: default value is Standard_True
        :type Compact: bool
        :rtype: void

        """
        return _Poly.poly_Write(*args)

    Write = staticmethod(Write)

    def Dump(*args) -> "void":
        """
        * Dumps the triangulation. This is a call to the previous method with Comapct set to False.

        :param T:
        :type T: Handle_Poly_Triangulation &
        :param OS:
        :type OS: Standard_OStream &
        :rtype: void

        * Dumps the 3D polygon. This is a call to the previous method with Comapct set to False.

        :param P:
        :type P: Handle_Poly_Polygon3D &
        :param OS:
        :type OS: Standard_OStream &
        :rtype: void

        * Dumps the 2D polygon. This is a call to the previous method with Comapct set to False.

        :param P:
        :type P: Handle_Poly_Polygon2D &
        :param OS:
        :type OS: Standard_OStream &
        :rtype: void

        """
        return _Poly.poly_Dump(*args)

    Dump = staticmethod(Dump)

    def ReadTriangulationFromString(self, src: 'std::string') -> "void":
        """ReadTriangulationFromString(poly self, std::string src)"""
        return _Poly.poly_ReadTriangulationFromString(self, src)


    def ReadPolygon3DFromString(self, src: 'std::string') -> "void":
        """ReadPolygon3DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon3DFromString(self, src)


    def ReadPolygon2DFromString(self, src: 'std::string') -> "void":
        """ReadPolygon2DFromString(poly self, std::string src)"""
        return _Poly.poly_ReadPolygon2DFromString(self, src)


    def ComputeNormals(*args) -> "void":
        """
        * Compute node normals for face triangulation as mean normal of surrounding triangles

        :param Tri:
        :type Tri: Handle_Poly_Triangulation &
        :rtype: void

        """
        return _Poly.poly_ComputeNormals(*args)

    ComputeNormals = staticmethod(ComputeNormals)

    def PointOnTriangle(*args) -> "Standard_Real":
        """
        * Computes parameters of the point P on triangle defined by points P1, P2, and P3, in 2d. The parameters U and V are defined so that P = P1 + U * (P2 - P1) + V * (P3 - P1), with U >= 0, V >= 0, U + V <= 1. If P is located outside of triangle, or triangle is degenerated, the returned parameters correspond to closest point, and returned value is square of the distance from original point to triangle (0 if point is inside).

        :param P1:
        :type P1: gp_XY
        :param P2:
        :type P2: gp_XY
        :param P3:
        :type P3: gp_XY
        :param P:
        :type P: gp_XY
        :param UV:
        :type UV: gp_XY
        :rtype: float

        """
        return _Poly.poly_PointOnTriangle(*args)

    PointOnTriangle = staticmethod(PointOnTriangle)

    __repr__ = _dumps_object


    def __init__(self):
        """__init__(Poly self) -> poly"""
        _Poly.poly_swiginit(self, _Poly.new_poly())
    __swig_destroy__ = _Poly.delete_poly
poly.ReadTriangulationFromString = new_instancemethod(_Poly.poly_ReadTriangulationFromString, None, poly)
poly.ReadPolygon3DFromString = new_instancemethod(_Poly.poly_ReadPolygon3DFromString, None, poly)
poly.ReadPolygon2DFromString = new_instancemethod(_Poly.poly_ReadPolygon2DFromString, None, poly)
poly_swigregister = _Poly.poly_swigregister
poly_swigregister(poly)

def poly_Catenate(*args) -> "Handle_Poly_Triangulation":
    """
    * Computes and stores the link from nodes to triangles and from triangles to neighbouring triangles. This tool is obsolete, replaced by Poly_CoherentTriangulation Algorithm to make minimal loops in a graph Join several triangulations to one new triangulation object. The new triangulation is just a mechanical sum of input triangulations, without node sharing. UV coordinates are dropped in the result.

    :param lstTri:
    :type lstTri: Poly_ListOfTriangulation &
    :rtype: Handle_Poly_Triangulation

    """
    return _Poly.poly_Catenate(*args)

def poly_Write(*args) -> "void":
    """
    * Writes the content of the triangulation <T> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

    :param T:
    :type T: Handle_Poly_Triangulation &
    :param OS:
    :type OS: Standard_OStream &
    :param Compact: default value is Standard_True
    :type Compact: bool
    :rtype: void

    * Writes the content of the 3D polygon <P> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

    :param P:
    :type P: Handle_Poly_Polygon3D &
    :param OS:
    :type OS: Standard_OStream &
    :param Compact: default value is Standard_True
    :type Compact: bool
    :rtype: void

    * Writes the content of the 2D polygon <P> on the stream <OS>. If <Compact> is true this is a 'save' format intended to be read back with the Read method. If compact is False it is a 'Dump' format intended to be informative.

    :param P:
    :type P: Handle_Poly_Polygon2D &
    :param OS:
    :type OS: Standard_OStream &
    :param Compact: default value is Standard_True
    :type Compact: bool
    :rtype: void

    """
    return _Poly.poly_Write(*args)

def poly_Dump(*args) -> "void":
    """
    * Dumps the triangulation. This is a call to the previous method with Comapct set to False.

    :param T:
    :type T: Handle_Poly_Triangulation &
    :param OS:
    :type OS: Standard_OStream &
    :rtype: void

    * Dumps the 3D polygon. This is a call to the previous method with Comapct set to False.

    :param P:
    :type P: Handle_Poly_Polygon3D &
    :param OS:
    :type OS: Standard_OStream &
    :rtype: void

    * Dumps the 2D polygon. This is a call to the previous method with Comapct set to False.

    :param P:
    :type P: Handle_Poly_Polygon2D &
    :param OS:
    :type OS: Standard_OStream &
    :rtype: void

    """
    return _Poly.poly_Dump(*args)

def poly_ComputeNormals(*args) -> "void":
    """
    * Compute node normals for face triangulation as mean normal of surrounding triangles

    :param Tri:
    :type Tri: Handle_Poly_Triangulation &
    :rtype: void

    """
    return _Poly.poly_ComputeNormals(*args)

def poly_PointOnTriangle(*args) -> "Standard_Real":
    """
    * Computes parameters of the point P on triangle defined by points P1, P2, and P3, in 2d. The parameters U and V are defined so that P = P1 + U * (P2 - P1) + V * (P3 - P1), with U >= 0, V >= 0, U + V <= 1. If P is located outside of triangle, or triangle is degenerated, the returned parameters correspond to closest point, and returned value is square of the distance from original point to triangle (0 if point is inside).

    :param P1:
    :type P1: gp_XY
    :param P2:
    :type P2: gp_XY
    :param P3:
    :type P3: gp_XY
    :param P:
    :type P: gp_XY
    :param UV:
    :type UV: gp_XY
    :rtype: float

    """
    return _Poly.poly_PointOnTriangle(*args)

class Poly_Array1OfTriangle(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param Low:
        :type Low: int
        :param Up:
        :type Up: int
        :rtype: None

        :param Item:
        :type Item: Poly_Triangle &
        :param Low:
        :type Low: int
        :param Up:
        :type Up: int
        :rtype: None

        """
        _Poly.Poly_Array1OfTriangle_swiginit(self, _Poly.new_Poly_Array1OfTriangle(*args))

    def Init(self, *args) -> "void":
        """
        :param V:
        :type V: Poly_Triangle &
        :rtype: None

        """
        return _Poly.Poly_Array1OfTriangle_Init(self, *args)


    def Destroy(self, *args) -> "void":
        """
        :rtype: None

        """
        return _Poly.Poly_Array1OfTriangle_Destroy(self, *args)


    def IsAllocated(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Poly.Poly_Array1OfTriangle_IsAllocated(self, *args)


    def Assign(self, *args) -> "Poly_Array1OfTriangle const &":
        """
        :param Other:
        :type Other: Poly_Array1OfTriangle &
        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_Array1OfTriangle_Assign(self, *args)


    def Set(self, *args) -> "Poly_Array1OfTriangle const &":
        """
        :param Other:
        :type Other: Poly_Array1OfTriangle &
        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_Array1OfTriangle_Set(self, *args)


    def Length(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_Array1OfTriangle_Length(self, *args)


    def Lower(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_Array1OfTriangle_Lower(self, *args)


    def Upper(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_Array1OfTriangle_Upper(self, *args)


    def SetValue(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param Value:
        :type Value: Poly_Triangle &
        :rtype: None

        """
        return _Poly.Poly_Array1OfTriangle_SetValue(self, *args)


    def Value(self, *args) -> "Poly_Triangle const &":
        """
        :param Index:
        :type Index: int
        :rtype: Poly_Triangle

        """
        return _Poly.Poly_Array1OfTriangle_Value(self, *args)


    def ChangeValue(self, *args) -> "Poly_Triangle &":
        """
        :param Index:
        :type Index: int
        :rtype: Poly_Triangle

        """
        return _Poly.Poly_Array1OfTriangle_ChangeValue(self, *args)


    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current +=1
        return self.Value(self.current)

    __next__ = next



    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Array1OfTriangle
Poly_Array1OfTriangle.Init = new_instancemethod(_Poly.Poly_Array1OfTriangle_Init, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Destroy = new_instancemethod(_Poly.Poly_Array1OfTriangle_Destroy, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.IsAllocated = new_instancemethod(_Poly.Poly_Array1OfTriangle_IsAllocated, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Assign = new_instancemethod(_Poly.Poly_Array1OfTriangle_Assign, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Set = new_instancemethod(_Poly.Poly_Array1OfTriangle_Set, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Length = new_instancemethod(_Poly.Poly_Array1OfTriangle_Length, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Lower = new_instancemethod(_Poly.Poly_Array1OfTriangle_Lower, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Upper = new_instancemethod(_Poly.Poly_Array1OfTriangle_Upper, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.SetValue = new_instancemethod(_Poly.Poly_Array1OfTriangle_SetValue, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.Value = new_instancemethod(_Poly.Poly_Array1OfTriangle_Value, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle.ChangeValue = new_instancemethod(_Poly.Poly_Array1OfTriangle_ChangeValue, None, Poly_Array1OfTriangle)
Poly_Array1OfTriangle_swigregister = _Poly.Poly_Array1OfTriangle_swigregister
Poly_Array1OfTriangle_swigregister(Poly_Array1OfTriangle)

class Poly_CoherentLink(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * /** * Empty constructor. */

        :rtype: None

        * /** * Constructor. Creates a Link that has no reference to 'opposite nodes'. * This constructor is useful to create temporary object that is not * inserted into any existing triangulation. */

        :param iNode0:
        :type iNode0: int
        :param iNode1:
        :type iNode1: int
        :rtype: None

        * /** * Constructor, takes a triangle and a side. A link is created always such * that myNode[0] < myNode[1]. Unlike the previous constructor, this one * assigns the 'opposite node' fields. This constructor is used when a * link is inserted into a Poly_CoherentTriangulation structure. * @param theTri * Triangle containing the link that is created * @param iSide * Can be 0, 1 or 2. Index of the node */

        :param theTri:
        :type theTri: Poly_CoherentTriangle &
        :param iSide:
        :type iSide: int
        :rtype: None

        """
        _Poly.Poly_CoherentLink_swiginit(self, _Poly.new_Poly_CoherentLink(*args))

    def Node(self, *args) -> "Standard_Integer":
        """
        * /** * Return the node index in the current triangulation. * @param ind * 0 or 1 making distinction of the two nodes that constitute the Link. * Node(0) always returns a smaller number than Node(1). */

        :param ind:
        :type ind: int
        :rtype: inline int

        """
        return _Poly.Poly_CoherentLink_Node(self, *args)


    def OppositeNode(self, *args) -> "Standard_Integer":
        """
        * /** * Return the opposite node (belonging to the left or right incident triangle) * index in the current triangulation. * @param ind * 0 or 1 making distinction of the two involved triangles: 0 on the left, * 1 on the right side of the Link. */

        :param ind:
        :type ind: int
        :rtype: inline int

        """
        return _Poly.Poly_CoherentLink_OppositeNode(self, *args)


    def GetAttribute(self, *args) -> "Standard_Address":
        """
        * /** * Query the attribute of the Link. */

        :rtype: inline Standard_Address

        """
        return _Poly.Poly_CoherentLink_GetAttribute(self, *args)


    def SetAttribute(self, *args) -> "void":
        """
        * /** * Set the attribute of the Link. */

        :param theAtt:
        :type theAtt: Standard_Address
        :rtype: inline void

        """
        return _Poly.Poly_CoherentLink_SetAttribute(self, *args)


    def IsEmpty(self, *args) -> "Standard_Boolean":
        """
        * /** * Query the status of the link - if it is an invalid one. * An invalid link has Node members equal to -1. */

        :rtype: inline bool

        """
        return _Poly.Poly_CoherentLink_IsEmpty(self, *args)


    def Nullify(self, *args) -> "void":
        """
        * /** * Invalidate this Link. */

        :rtype: inline void

        """
        return _Poly.Poly_CoherentLink_Nullify(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentLink
Poly_CoherentLink.Node = new_instancemethod(_Poly.Poly_CoherentLink_Node, None, Poly_CoherentLink)
Poly_CoherentLink.OppositeNode = new_instancemethod(_Poly.Poly_CoherentLink_OppositeNode, None, Poly_CoherentLink)
Poly_CoherentLink.GetAttribute = new_instancemethod(_Poly.Poly_CoherentLink_GetAttribute, None, Poly_CoherentLink)
Poly_CoherentLink.SetAttribute = new_instancemethod(_Poly.Poly_CoherentLink_SetAttribute, None, Poly_CoherentLink)
Poly_CoherentLink.IsEmpty = new_instancemethod(_Poly.Poly_CoherentLink_IsEmpty, None, Poly_CoherentLink)
Poly_CoherentLink.Nullify = new_instancemethod(_Poly.Poly_CoherentLink_Nullify, None, Poly_CoherentLink)
Poly_CoherentLink_swigregister = _Poly.Poly_CoherentLink_swigregister
Poly_CoherentLink_swigregister(Poly_CoherentLink)

class Poly_CoherentNode(OCC.Core.gp.gp_XYZ):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * /** * Empty constructor. */

        :rtype: None

        * /** * Constructor. */

        :param thePnt:
        :type thePnt: gp_XYZ
        :rtype: None

        """
        _Poly.Poly_CoherentNode_swiginit(self, _Poly.new_Poly_CoherentNode(*args))

    def SetUV(self, *args) -> "void":
        """
        * /** * Set the UV coordinates of the Node. */

        :param theU:
        :type theU: float
        :param theV:
        :type theV: float
        :rtype: inline void

        """
        return _Poly.Poly_CoherentNode_SetUV(self, *args)


    def GetU(self, *args) -> "Standard_Real":
        """
        * /** * Get U coordinate of the Node. */

        :rtype: inline float

        """
        return _Poly.Poly_CoherentNode_GetU(self, *args)


    def GetV(self, *args) -> "Standard_Real":
        """
        * /** * Get V coordinate of the Node. */

        :rtype: inline float

        """
        return _Poly.Poly_CoherentNode_GetV(self, *args)


    def SetNormal(self, *args) -> "void":
        """
        * /** * Define the normal vector in the Node. */

        :param theVector:
        :type theVector: gp_XYZ
        :rtype: None

        """
        return _Poly.Poly_CoherentNode_SetNormal(self, *args)


    def HasNormal(self, *args) -> "Standard_Boolean":
        """
        * /** * Query if the Node contains a normal vector. */

        :rtype: inline bool

        """
        return _Poly.Poly_CoherentNode_HasNormal(self, *args)


    def GetNormal(self, *args) -> "gp_XYZ":
        """
        * /** * Get the stored normal in the node. */

        :rtype: inline gp_XYZ

        """
        return _Poly.Poly_CoherentNode_GetNormal(self, *args)


    def SetIndex(self, *args) -> "void":
        """
        * /** * Set the value of node Index. */

        :param theIndex:
        :type theIndex: int
        :rtype: inline void

        """
        return _Poly.Poly_CoherentNode_SetIndex(self, *args)


    def GetIndex(self, *args) -> "Standard_Integer":
        """
        * /** * Get the value of node Index. */

        :rtype: inline int

        """
        return _Poly.Poly_CoherentNode_GetIndex(self, *args)


    def IsFreeNode(self, *args) -> "Standard_Boolean":
        """
        * /** * Check if this is a free node, i.e., a node without a single * incident triangle. */

        :rtype: inline bool

        """
        return _Poly.Poly_CoherentNode_IsFreeNode(self, *args)


    def Clear(self, *args) -> "void":
        """
        * /** * Reset the Node to void. */

        :param &:
        :type &: Handle_NCollection_BaseAllocator
        :rtype: None

        """
        return _Poly.Poly_CoherentNode_Clear(self, *args)


    def AddTriangle(self, *args) -> "void":
        """
        * /** * Connect a triangle to this Node. */

        :param theTri:
        :type theTri: Poly_CoherentTriangle &
        :param theA:
        :type theA: Handle_NCollection_BaseAllocator &
        :rtype: None

        """
        return _Poly.Poly_CoherentNode_AddTriangle(self, *args)


    def RemoveTriangle(self, *args) -> "Standard_Boolean":
        """
        * /** * Disconnect a triangle from this Node. */

        :param theTri:
        :type theTri: Poly_CoherentTriangle &
        :param theA:
        :type theA: Handle_NCollection_BaseAllocator &
        :rtype: bool

        """
        return _Poly.Poly_CoherentNode_RemoveTriangle(self, *args)


    def TriangleIterator(self, *args) -> "Poly_CoherentTriPtr::Iterator":
        """
        * /** * Create an iterator of incident triangles. */

        :rtype: inline Poly_CoherentTriPtr::Iterator

        """
        return _Poly.Poly_CoherentNode_TriangleIterator(self, *args)


    def DumpToString(self) -> "std::string":
        """DumpToString(Poly_CoherentNode self) -> std::string"""
        return _Poly.Poly_CoherentNode_DumpToString(self)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentNode
Poly_CoherentNode.SetUV = new_instancemethod(_Poly.Poly_CoherentNode_SetUV, None, Poly_CoherentNode)
Poly_CoherentNode.GetU = new_instancemethod(_Poly.Poly_CoherentNode_GetU, None, Poly_CoherentNode)
Poly_CoherentNode.GetV = new_instancemethod(_Poly.Poly_CoherentNode_GetV, None, Poly_CoherentNode)
Poly_CoherentNode.SetNormal = new_instancemethod(_Poly.Poly_CoherentNode_SetNormal, None, Poly_CoherentNode)
Poly_CoherentNode.HasNormal = new_instancemethod(_Poly.Poly_CoherentNode_HasNormal, None, Poly_CoherentNode)
Poly_CoherentNode.GetNormal = new_instancemethod(_Poly.Poly_CoherentNode_GetNormal, None, Poly_CoherentNode)
Poly_CoherentNode.SetIndex = new_instancemethod(_Poly.Poly_CoherentNode_SetIndex, None, Poly_CoherentNode)
Poly_CoherentNode.GetIndex = new_instancemethod(_Poly.Poly_CoherentNode_GetIndex, None, Poly_CoherentNode)
Poly_CoherentNode.IsFreeNode = new_instancemethod(_Poly.Poly_CoherentNode_IsFreeNode, None, Poly_CoherentNode)
Poly_CoherentNode.Clear = new_instancemethod(_Poly.Poly_CoherentNode_Clear, None, Poly_CoherentNode)
Poly_CoherentNode.AddTriangle = new_instancemethod(_Poly.Poly_CoherentNode_AddTriangle, None, Poly_CoherentNode)
Poly_CoherentNode.RemoveTriangle = new_instancemethod(_Poly.Poly_CoherentNode_RemoveTriangle, None, Poly_CoherentNode)
Poly_CoherentNode.TriangleIterator = new_instancemethod(_Poly.Poly_CoherentNode_TriangleIterator, None, Poly_CoherentNode)
Poly_CoherentNode.DumpToString = new_instancemethod(_Poly.Poly_CoherentNode_DumpToString, None, Poly_CoherentNode)
Poly_CoherentNode_swigregister = _Poly.Poly_CoherentNode_swigregister
Poly_CoherentNode_swigregister(Poly_CoherentNode)

class Poly_CoherentTriangle(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * /** * Empty constructor. */

        :rtype: None

        * /** * Constructor. */

        :param iNode0:
        :type iNode0: int
        :param iNode1:
        :type iNode1: int
        :param iNode2:
        :type iNode2: int
        :rtype: None

        """
        _Poly.Poly_CoherentTriangle_swiginit(self, _Poly.new_Poly_CoherentTriangle(*args))

    def Node(self, *args) -> "Standard_Integer":
        """
        * /** * Query the node index in the position given by the parameter 'ind' */

        :param ind:
        :type ind: int
        :rtype: inline int

        """
        return _Poly.Poly_CoherentTriangle_Node(self, *args)


    def IsEmpty(self, *args) -> "Standard_Boolean":
        """
        * /** * Query if this is a valid triangle. */

        :rtype: inline bool

        """
        return _Poly.Poly_CoherentTriangle_IsEmpty(self, *args)


    def SetConnection(self, *args) -> "Standard_Boolean":
        """
        * /** * Create connection with another triangle theTri. * This method creates both connections: in this triangle and in theTri. You * do not need to call the same method on triangle theTr. * @param iConn * Can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). * @param theTr * Triangle that is connected on the given link. * returns * True if successful, False if the connection is rejected * due to improper topology. */

        :param iConn:
        :type iConn: int
        :param theTr:
        :type theTr: Poly_CoherentTriangle &
        :rtype: bool

        * /** * Create connection with another triangle theTri. * This method creates both connections: in this triangle and in theTri. * This method is slower than the previous one, because it makes analysis * what sides of both triangles are connected. * @param theTri * Triangle that is connected. * returns * True if successful, False if the connection is rejected * due to improper topology. */

        :param theTri:
        :type theTri: Poly_CoherentTriangle &
        :rtype: bool

        """
        return _Poly.Poly_CoherentTriangle_SetConnection(self, *args)


    def RemoveConnection(self, *args) -> "Standard_Boolean":
        """
        * /** * Remove the connection with the given index. * @param iConn * Can be 0, 1 or 2 - index of the node that is opposite to the connection * (shared link). */

        :param iConn:
        :type iConn: int
        :rtype: None

        * /** * Remove the connection with the given Triangle. * returns * True if successfuol or False if the connection has not been found. */

        :param theTri:
        :type theTri: Poly_CoherentTriangle &
        :rtype: bool

        """
        return _Poly.Poly_CoherentTriangle_RemoveConnection(self, *args)


    def NConnections(self, *args) -> "Standard_Integer":
        """
        * /** * Query the number of connected triangles. */

        :rtype: inline int

        """
        return _Poly.Poly_CoherentTriangle_NConnections(self, *args)


    def GetConnectedNode(self, *args) -> "Standard_Integer":
        """
        * /** * Query the connected node on the given side. * Returns -1 if there is no connection on the specified side. */

        :param iConn:
        :type iConn: int
        :rtype: inline int

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedNode(self, *args)


    def GetConnectedTri(self, *args) -> "Poly_CoherentTriangle const *":
        """
        * /** * Query the connected triangle on the given side. * Returns NULL if there is no connection on the specified side. */

        :param iConn:
        :type iConn: int
        :rtype: inline  Poly_CoherentTriangle *

        """
        return _Poly.Poly_CoherentTriangle_GetConnectedTri(self, *args)


    def GetLink(self, *args) -> "Poly_CoherentLink const *":
        """
        * /** * Query the Link associate with the given side of the Triangle. * May return NULL if there are no links in the triangulation. */

        :param iLink:
        :type iLink: int
        :rtype: inline  Poly_CoherentLink *

        """
        return _Poly.Poly_CoherentTriangle_GetLink(self, *args)


    def FindConnection(self, *args) -> "Standard_Integer":
        """
        * /** * Retuns the index of the connection with the given triangle, or -1 if not * found. */

        :param &:
        :type &: Poly_CoherentTriangle
        :rtype: int

        """
        return _Poly.Poly_CoherentTriangle_FindConnection(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_CoherentTriangle
Poly_CoherentTriangle.Node = new_instancemethod(_Poly.Poly_CoherentTriangle_Node, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.IsEmpty = new_instancemethod(_Poly.Poly_CoherentTriangle_IsEmpty, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.SetConnection = new_instancemethod(_Poly.Poly_CoherentTriangle_SetConnection, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.RemoveConnection = new_instancemethod(_Poly.Poly_CoherentTriangle_RemoveConnection, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.NConnections = new_instancemethod(_Poly.Poly_CoherentTriangle_NConnections, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.GetConnectedNode = new_instancemethod(_Poly.Poly_CoherentTriangle_GetConnectedNode, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.GetConnectedTri = new_instancemethod(_Poly.Poly_CoherentTriangle_GetConnectedTri, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.GetLink = new_instancemethod(_Poly.Poly_CoherentTriangle_GetLink, None, Poly_CoherentTriangle)
Poly_CoherentTriangle.FindConnection = new_instancemethod(_Poly.Poly_CoherentTriangle_FindConnection, None, Poly_CoherentTriangle)
Poly_CoherentTriangle_swigregister = _Poly.Poly_CoherentTriangle_swigregister
Poly_CoherentTriangle_swigregister(Poly_CoherentTriangle)

class Poly_Connect(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs an algorithm to explore the adjacency data of nodes or triangles for the triangulation T.

        :param T:
        :type T: Handle_Poly_Triangulation &
        :rtype: None

        """
        _Poly.Poly_Connect_swiginit(self, _Poly.new_Poly_Connect(*args))

    def Triangulation(self, *args) -> "Handle_Poly_Triangulation":
        """
        * Returns the triangulation analyzed by this tool.

        :rtype: Handle_Poly_Triangulation

        """
        return _Poly.Poly_Connect_Triangulation(self, *args)


    def Triangle(self, *args) -> "Standard_Integer":
        """
        * Returns the index of a triangle containing the node at index N in the nodes table specific to the triangulation analyzed by this tool

        :param N:
        :type N: int
        :rtype: int

        """
        return _Poly.Poly_Connect_Triangle(self, *args)


    def Triangles(self, *args) -> "void":
        """
        * Returns in t1, t2 and t3, the indices of the 3 triangles adjacent to the triangle at index T in the triangles table specific to the triangulation analyzed by this tool. Warning Null indices are returned when there are fewer than 3 adjacent triangles.

        :param T:
        :type T: int
        :param t1:
        :type t1: int &
        :param t2:
        :type t2: int &
        :param t3:
        :type t3: int &
        :rtype: None

        """
        return _Poly.Poly_Connect_Triangles(self, *args)


    def Nodes(self, *args) -> "void":
        """
        * Returns, in n1, n2 and n3, the indices of the 3 nodes adjacent to the triangle referenced at index T in the triangles table specific to the triangulation analyzed by this tool. Warning Null indices are returned when there are fewer than 3 adjacent nodes.

        :param T:
        :type T: int
        :param n1:
        :type n1: int &
        :param n2:
        :type n2: int &
        :param n3:
        :type n3: int &
        :rtype: None

        """
        return _Poly.Poly_Connect_Nodes(self, *args)


    def Initialize(self, *args) -> "void":
        """
        * Initializes an iterator to search for all the triangles containing the node referenced at index N in the nodes table, for the triangulation analyzed by this tool. The iterator is managed by the following functions: - More, which checks if there are still elements in the iterator - Next, which positions the iterator on the next element - Value, which returns the current element. The use of such an iterator provides direct access to the triangles around a particular node, i.e. it avoids iterating on all the component triangles of a triangulation. Example Poly_Connect C(Tr); for (C.Initialize(n1);C.More();C.Next()) { t = C.Value(); }

        :param N:
        :type N: int
        :rtype: None

        """
        return _Poly.Poly_Connect_Initialize(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        * Returns true if there is another element in the iterator defined with the function Initialize (i.e. if there is another triangle containing the given node).

        :rtype: bool

        """
        return _Poly.Poly_Connect_More(self, *args)


    def Next(self, *args) -> "void":
        """
        * Advances the iterator defined with the function Initialize to access the next triangle. Note: There is no action if the iterator is empty (i.e. if the function More returns false).-

        :rtype: None

        """
        return _Poly.Poly_Connect_Next(self, *args)


    def Value(self, *args) -> "Standard_Integer":
        """
        * Returns the index of the current triangle to which the iterator, defined with the function Initialize, points. This is an index in the triangles table specific to the triangulation analyzed by this tool

        :rtype: int

        """
        return _Poly.Poly_Connect_Value(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Connect
Poly_Connect.Triangulation = new_instancemethod(_Poly.Poly_Connect_Triangulation, None, Poly_Connect)
Poly_Connect.Triangle = new_instancemethod(_Poly.Poly_Connect_Triangle, None, Poly_Connect)
Poly_Connect.Triangles = new_instancemethod(_Poly.Poly_Connect_Triangles, None, Poly_Connect)
Poly_Connect.Nodes = new_instancemethod(_Poly.Poly_Connect_Nodes, None, Poly_Connect)
Poly_Connect.Initialize = new_instancemethod(_Poly.Poly_Connect_Initialize, None, Poly_Connect)
Poly_Connect.More = new_instancemethod(_Poly.Poly_Connect_More, None, Poly_Connect)
Poly_Connect.Next = new_instancemethod(_Poly.Poly_Connect_Next, None, Poly_Connect)
Poly_Connect.Value = new_instancemethod(_Poly.Poly_Connect_Value, None, Poly_Connect)
Poly_Connect_swigregister = _Poly.Poly_Connect_swigregister
Poly_Connect_swigregister(Poly_Connect)

class Poly_HArray1OfTriangle(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param Low:
        :type Low: int
        :param Up:
        :type Up: int
        :rtype: None

        :param Low:
        :type Low: int
        :param Up:
        :type Up: int
        :param V:
        :type V: Poly_Triangle &
        :rtype: None

        """
        _Poly.Poly_HArray1OfTriangle_swiginit(self, _Poly.new_Poly_HArray1OfTriangle(*args))

    def Init(self, *args) -> "void":
        """
        :param V:
        :type V: Poly_Triangle &
        :rtype: None

        """
        return _Poly.Poly_HArray1OfTriangle_Init(self, *args)


    def Length(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_HArray1OfTriangle_Length(self, *args)


    def Lower(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_HArray1OfTriangle_Lower(self, *args)


    def Upper(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Poly.Poly_HArray1OfTriangle_Upper(self, *args)


    def SetValue(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param Value:
        :type Value: Poly_Triangle &
        :rtype: None

        """
        return _Poly.Poly_HArray1OfTriangle_SetValue(self, *args)


    def Value(self, *args) -> "Poly_Triangle const &":
        """
        :param Index:
        :type Index: int
        :rtype: Poly_Triangle

        """
        return _Poly.Poly_HArray1OfTriangle_Value(self, *args)


    def ChangeValue(self, *args) -> "Poly_Triangle &":
        """
        :param Index:
        :type Index: int
        :rtype: Poly_Triangle

        """
        return _Poly.Poly_HArray1OfTriangle_ChangeValue(self, *args)


    def Array1(self, *args) -> "Poly_Array1OfTriangle const &":
        """
        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_HArray1OfTriangle_Array1(self, *args)


    def ChangeArray1(self, *args) -> "Poly_Array1OfTriangle &":
        """
        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_HArray1OfTriangle_ChangeArray1(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Poly_HArray1OfTriangle_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Poly_HArray1OfTriangle_DownCast(t)


    def __getitem__(self, index):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            return self.Value(index + self.Lower())

    def __setitem__(self, index, value):
        if index + self.Lower() > self.Upper():
            raise IndexError("index out of range")
        else:
            self.SetValue(index + self.Lower(), value)

    def __len__(self):
        return self.Length()

    def __iter__(self):
        self.low = self.Lower()
        self.up = self.Upper()
        self.current = self.Lower() - 1
        return self

    def next(self):
        if self.current >= self.Upper():
            raise StopIteration
        else:
            self.current +=1
        return self.Value(self.current)

    __next__ = next



    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_HArray1OfTriangle
Poly_HArray1OfTriangle.Init = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Init, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.Length = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Length, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.Lower = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Lower, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.Upper = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Upper, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.SetValue = new_instancemethod(_Poly.Poly_HArray1OfTriangle_SetValue, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.Value = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Value, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.ChangeValue = new_instancemethod(_Poly.Poly_HArray1OfTriangle_ChangeValue, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.Array1 = new_instancemethod(_Poly.Poly_HArray1OfTriangle_Array1, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle.ChangeArray1 = new_instancemethod(_Poly.Poly_HArray1OfTriangle_ChangeArray1, None, Poly_HArray1OfTriangle)
Poly_HArray1OfTriangle_swigregister = _Poly.Poly_HArray1OfTriangle_swigregister
Poly_HArray1OfTriangle_swigregister(Poly_HArray1OfTriangle)


class Meta_Poly_HArray1OfTriangle(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Poly_HArray1OfTriangle_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Poly_HArray1OfTriangle", "Poly_HArray1OfTriangle"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Poly_HArray1OfTriangle(with_metaclass(Meta_Poly_HArray1OfTriangle, Poly_HArray1OfTriangle)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Poly_HArray1OfTriangle", "Poly_HArray1OfTriangle"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Poly_HArray1OfTriangle(Handle_Poly_HArray1OfTriangle_DownCast(o))

class Poly_Polygon2D(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs a 2D polygon defined by the table of points, <Nodes>.

        :param Nodes:
        :type Nodes: TColgp_Array1OfPnt2d
        :rtype: None

        """
        _Poly.Poly_Polygon2D_swiginit(self, _Poly.new_Poly_Polygon2D(*args))

    def Deflection(self, *args) -> "void":
        """
        * Returns the deflection of this polygon. Deflection is used in cases where the polygon is an approximate representation of a curve. Deflection represents the maximum distance permitted between any point on the curve and the corresponding point on the polygon. By default the deflection value is equal to 0. An algorithm using this 2D polygon with a deflection value equal to 0 considers that it is working with a true polygon and not with an approximate representation of a curve. The Deflection function is used to modify the deflection value of this polygon. The deflection value can be used by any algorithm working with 2D polygons. For example: - An algorithm may use a unique deflection value for all its polygons. In this case it is not necessary to use the Deflection function. - Or an algorithm may want to attach a different deflection to each polygon. In this case, the Deflection function is used to set a value on each polygon, and later to fetch the value.

        :rtype: float

        * Sets the deflection of this polygon to D

        :param D:
        :type D: float
        :rtype: None

        """
        return _Poly.Poly_Polygon2D_Deflection(self, *args)


    def NbNodes(self, *args) -> "Standard_Integer":
        """
        * Returns the number of nodes in this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle, the function NbNodes returns 4.

        :rtype: int

        """
        return _Poly.Poly_Polygon2D_NbNodes(self, *args)


    def Nodes(self, *args) -> "TColgp_Array1OfPnt2d const &":
        """
        * Returns the table of nodes for this polygon.

        :rtype: TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Polygon2D_Nodes(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Poly_Polygon2D_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon2D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon2D
Poly_Polygon2D.Deflection = new_instancemethod(_Poly.Poly_Polygon2D_Deflection, None, Poly_Polygon2D)
Poly_Polygon2D.NbNodes = new_instancemethod(_Poly.Poly_Polygon2D_NbNodes, None, Poly_Polygon2D)
Poly_Polygon2D.Nodes = new_instancemethod(_Poly.Poly_Polygon2D_Nodes, None, Poly_Polygon2D)
Poly_Polygon2D_swigregister = _Poly.Poly_Polygon2D_swigregister
Poly_Polygon2D_swigregister(Poly_Polygon2D)


class Meta_Poly_Polygon2D(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Poly_Polygon2D_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Poly_Polygon2D", "Poly_Polygon2D"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Poly_Polygon2D(with_metaclass(Meta_Poly_Polygon2D, Poly_Polygon2D)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Poly_Polygon2D", "Poly_Polygon2D"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Poly_Polygon2D(Handle_Poly_Polygon2D_DownCast(o))

class Poly_Polygon3D(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * onstructs a 3D polygon defined by the table of points, Nodes.

        :param Nodes:
        :type Nodes: TColgp_Array1OfPnt
        :rtype: None

        * Constructs a 3D polygon defined by the table of points, Nodes, and the parallel table of parameters, Parameters, where each value of the table Parameters is the parameter of the corresponding point on the curve approximated by the constructed polygon. Warning Both the Nodes and Parameters tables must have the same bounds. This property is not checked at construction time.

        :param Nodes:
        :type Nodes: TColgp_Array1OfPnt
        :param Parameters:
        :type Parameters: TColStd_Array1OfReal &
        :rtype: None

        """
        _Poly.Poly_Polygon3D_swiginit(self, _Poly.new_Poly_Polygon3D(*args))

    def Deflection(self, *args) -> "void":
        """
        * Returns the deflection of this polygon

        :rtype: float

        * Sets the deflection of this polygon to D. See more on deflection in Poly_Polygon2D

        :param D:
        :type D: float
        :rtype: None

        """
        return _Poly.Poly_Polygon3D_Deflection(self, *args)


    def NbNodes(self, *args) -> "Standard_Integer":
        """
        * Returns the number of nodes in this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle the function NbNodes returns 4.

        :rtype: int

        """
        return _Poly.Poly_Polygon3D_NbNodes(self, *args)


    def Nodes(self, *args) -> "TColgp_Array1OfPnt const &":
        """
        * Returns the table of nodes for this polygon.

        :rtype: TColgp_Array1OfPnt

        """
        return _Poly.Poly_Polygon3D_Nodes(self, *args)


    def HasParameters(self, *args) -> "Standard_Boolean":
        """
        * Returns the table of the parameters associated with each node in this polygon. HasParameters function checks if parameters are associated with the nodes of this polygon.

        :rtype: bool

        """
        return _Poly.Poly_Polygon3D_HasParameters(self, *args)


    def Parameters(self, *args) -> "TColStd_Array1OfReal const &":
        """
        * Returns true if parameters are associated with the nodes in this polygon.

        :rtype: TColStd_Array1OfReal

        """
        return _Poly.Poly_Polygon3D_Parameters(self, *args)


    def ChangeParameters(self, *args) -> "TColStd_Array1OfReal &":
        """
        * Returns the table of the parameters associated with each node in this polygon. ChangeParameters function returnes the array as shared. Therefore if the table is selected by reference you can, by simply modifying it, directly modify the data structure of this polygon.

        :rtype: TColStd_Array1OfReal

        """
        return _Poly.Poly_Polygon3D_ChangeParameters(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Poly_Polygon3D_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Poly_Polygon3D_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Polygon3D
Poly_Polygon3D.Deflection = new_instancemethod(_Poly.Poly_Polygon3D_Deflection, None, Poly_Polygon3D)
Poly_Polygon3D.NbNodes = new_instancemethod(_Poly.Poly_Polygon3D_NbNodes, None, Poly_Polygon3D)
Poly_Polygon3D.Nodes = new_instancemethod(_Poly.Poly_Polygon3D_Nodes, None, Poly_Polygon3D)
Poly_Polygon3D.HasParameters = new_instancemethod(_Poly.Poly_Polygon3D_HasParameters, None, Poly_Polygon3D)
Poly_Polygon3D.Parameters = new_instancemethod(_Poly.Poly_Polygon3D_Parameters, None, Poly_Polygon3D)
Poly_Polygon3D.ChangeParameters = new_instancemethod(_Poly.Poly_Polygon3D_ChangeParameters, None, Poly_Polygon3D)
Poly_Polygon3D_swigregister = _Poly.Poly_Polygon3D_swigregister
Poly_Polygon3D_swigregister(Poly_Polygon3D)


class Meta_Poly_Polygon3D(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Poly_Polygon3D_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Poly_Polygon3D", "Poly_Polygon3D"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Poly_Polygon3D(with_metaclass(Meta_Poly_Polygon3D, Poly_Polygon3D)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Poly_Polygon3D", "Poly_Polygon3D"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Poly_Polygon3D(Handle_Poly_Polygon3D_DownCast(o))

class Poly_PolygonOnTriangulation(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs a 3D polygon on the triangulation of a shape, defined by the table of nodes, <Nodes>.

        :param Nodes:
        :type Nodes: TColStd_Array1OfInteger &
        :rtype: None

        * Constructs a 3D polygon on the triangulation of a shape, defined by: - the table of nodes, Nodes, and the table of parameters, <Parameters>. where: - a node value is an index in the table of nodes specific to an existing triangulation of a shape - and a parameter value is the value of the parameter of the corresponding point on the curve approximated by the constructed polygon. Warning The tables Nodes and Parameters must be the same size. This property is not checked at construction time.

        :param Nodes:
        :type Nodes: TColStd_Array1OfInteger &
        :param Parameters:
        :type Parameters: TColStd_Array1OfReal &
        :rtype: None

        """
        _Poly.Poly_PolygonOnTriangulation_swiginit(self, _Poly.new_Poly_PolygonOnTriangulation(*args))

    def Deflection(self, *args) -> "void":
        """
        * Returns the deflection of this polygon

        :rtype: float

        * Sets the deflection of this polygon to D. See more on deflection in Poly_Polygones2D.

        :param D:
        :type D: float
        :rtype: None

        """
        return _Poly.Poly_PolygonOnTriangulation_Deflection(self, *args)


    def NbNodes(self, *args) -> "Standard_Integer":
        """
        * Returns the number of nodes for this polygon. Note: If the polygon is closed, the point of closure is repeated at the end of its table of nodes. Thus, on a closed triangle, the function NbNodes returns 4.

        :rtype: int

        """
        return _Poly.Poly_PolygonOnTriangulation_NbNodes(self, *args)


    def Nodes(self, *args) -> "TColStd_Array1OfInteger const &":
        """
        * Returns the table of nodes for this polygon. A node value is an index in the table of nodes specific to an existing triangulation of a shape.

        :rtype: TColStd_Array1OfInteger

        """
        return _Poly.Poly_PolygonOnTriangulation_Nodes(self, *args)


    def HasParameters(self, *args) -> "Standard_Boolean":
        """
        * Returns true if parameters are associated with the nodes in this polygon.

        :rtype: bool

        """
        return _Poly.Poly_PolygonOnTriangulation_HasParameters(self, *args)


    def Parameters(self, *args) -> "Handle_TColStd_HArray1OfReal":
        """
        * Returns the table of the parameters associated with each node in this polygon. Warning Use the function HasParameters to check if parameters are associated with the nodes in this polygon.

        :rtype: Handle_TColStd_HArray1OfReal

        """
        return _Poly.Poly_PolygonOnTriangulation_Parameters(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Poly_PolygonOnTriangulation_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Poly_PolygonOnTriangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_PolygonOnTriangulation
Poly_PolygonOnTriangulation.Deflection = new_instancemethod(_Poly.Poly_PolygonOnTriangulation_Deflection, None, Poly_PolygonOnTriangulation)
Poly_PolygonOnTriangulation.NbNodes = new_instancemethod(_Poly.Poly_PolygonOnTriangulation_NbNodes, None, Poly_PolygonOnTriangulation)
Poly_PolygonOnTriangulation.Nodes = new_instancemethod(_Poly.Poly_PolygonOnTriangulation_Nodes, None, Poly_PolygonOnTriangulation)
Poly_PolygonOnTriangulation.HasParameters = new_instancemethod(_Poly.Poly_PolygonOnTriangulation_HasParameters, None, Poly_PolygonOnTriangulation)
Poly_PolygonOnTriangulation.Parameters = new_instancemethod(_Poly.Poly_PolygonOnTriangulation_Parameters, None, Poly_PolygonOnTriangulation)
Poly_PolygonOnTriangulation_swigregister = _Poly.Poly_PolygonOnTriangulation_swigregister
Poly_PolygonOnTriangulation_swigregister(Poly_PolygonOnTriangulation)


class Meta_Poly_PolygonOnTriangulation(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Poly_PolygonOnTriangulation_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Poly_PolygonOnTriangulation", "Poly_PolygonOnTriangulation"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Poly_PolygonOnTriangulation(with_metaclass(Meta_Poly_PolygonOnTriangulation, Poly_PolygonOnTriangulation)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Poly_PolygonOnTriangulation", "Poly_PolygonOnTriangulation"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Poly_PolygonOnTriangulation(Handle_Poly_PolygonOnTriangulation_DownCast(o))

class Poly_Triangle(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs a triangle and sets all indices to zero.

        :rtype: None

        * Constructs a triangle and sets its three indices to N1, N2 and N3 respectively, where these node values are indices in the table of nodes specific to an existing triangulation of a shape.

        :param N1:
        :type N1: int
        :param N2:
        :type N2: int
        :param N3:
        :type N3: int
        :rtype: None

        """
        _Poly.Poly_Triangle_swiginit(self, _Poly.new_Poly_Triangle(*args))

    def Set(self, *args) -> "void":
        """
        * Sets the value of the three nodes of this triangle to N1, N2 and N3 respectively.

        :param N1:
        :type N1: int
        :param N2:
        :type N2: int
        :param N3:
        :type N3: int
        :rtype: None

        * Sets the value of the Indexth node of this triangle to Node. Raises OutOfRange if Index is not in 1,2,3

        :param Index:
        :type Index: int
        :param Node:
        :type Node: int
        :rtype: None

        """
        return _Poly.Poly_Triangle_Set(self, *args)


    def Get(self, *args) -> "void":
        """
        * Returns the node indices of this triangle in N1, N2 and N3.

        :param N1:
        :type N1: int &
        :param N2:
        :type N2: int &
        :param N3:
        :type N3: int &
        :rtype: None

        """
        return _Poly.Poly_Triangle_Get(self, *args)


    def Value(self, *args) -> "Standard_Integer":
        """
        * Get the node of given Index. Raises OutOfRange from Standard if Index is not in 1,2,3

        :param Index:
        :type Index: int
        :rtype: int

        """
        return _Poly.Poly_Triangle_Value(self, *args)


    def ChangeValue(self, *args) -> "Standard_Integer &":
        """
        * Get the node of given Index. Raises OutOfRange if Index is not in 1,2,3

        :param Index:
        :type Index: int
        :rtype: int

        """
        return _Poly.Poly_Triangle_ChangeValue(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangle
Poly_Triangle.Set = new_instancemethod(_Poly.Poly_Triangle_Set, None, Poly_Triangle)
Poly_Triangle.Get = new_instancemethod(_Poly.Poly_Triangle_Get, None, Poly_Triangle)
Poly_Triangle.Value = new_instancemethod(_Poly.Poly_Triangle_Value, None, Poly_Triangle)
Poly_Triangle.ChangeValue = new_instancemethod(_Poly.Poly_Triangle_ChangeValue, None, Poly_Triangle)
Poly_Triangle_swigregister = _Poly.Poly_Triangle_swigregister
Poly_Triangle_swigregister(Poly_Triangle)

class Poly_Triangulation(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs a triangulation from a set of triangles. The triangulation is initialized without a triangle or a node, but capable of containing nbNodes nodes, and nbTriangles triangles. Here the UVNodes flag indicates whether 2D nodes will be associated with 3D ones, (i.e. to enable a 2D representation).

        :param nbNodes:
        :type nbNodes: int
        :param nbTriangles:
        :type nbTriangles: int
        :param UVNodes:
        :type UVNodes: bool
        :rtype: None

        * Constructs a triangulation from a set of triangles. The triangulation is initialized with 3D points from Nodes and triangles from Triangles.

        :param Nodes:
        :type Nodes: TColgp_Array1OfPnt
        :param Triangles:
        :type Triangles: Poly_Array1OfTriangle &
        :rtype: None

        * Constructs a triangulation from a set of triangles. The triangulation is initialized with 3D points from Nodes, 2D points from UVNodes and triangles from Triangles, where coordinates of a 2D point from UVNodes are the (u, v) parameters of the corresponding 3D point from Nodes on the surface approximated by the constructed triangulation.

        :param Nodes:
        :type Nodes: TColgp_Array1OfPnt
        :param UVNodes:
        :type UVNodes: TColgp_Array1OfPnt2d
        :param Triangles:
        :type Triangles: Poly_Array1OfTriangle &
        :rtype: None

        """
        _Poly.Poly_Triangulation_swiginit(self, _Poly.new_Poly_Triangulation(*args))

    def Copy(self, *args) -> "Handle_Poly_Triangulation":
        """
        * Creates full copy of current triangulation.

        :rtype: Handle_Poly_Triangulation

        """
        return _Poly.Poly_Triangulation_Copy(self, *args)


    def Deflection(self, *args) -> "void":
        """
        * Returns the deflection of this triangulation.

        :rtype: float

        * Sets the deflection of this triangulation to D. See more on deflection in Polygon2D

        :param D:
        :type D: float
        :rtype: None

        """
        return _Poly.Poly_Triangulation_Deflection(self, *args)


    def RemoveUVNodes(self, *args) -> "void":
        """
        * Deallocates the UV nodes.

        :rtype: None

        """
        return _Poly.Poly_Triangulation_RemoveUVNodes(self, *args)


    def NbNodes(self, *args) -> "Standard_Integer":
        """
        * Returns the number of nodes for this triangulation. Null if the nodes are not yet defined.

        :rtype: int

        """
        return _Poly.Poly_Triangulation_NbNodes(self, *args)


    def NbTriangles(self, *args) -> "Standard_Integer":
        """
        * Returns the number of triangles for this triangulation. Null if the Triangles are not yet defined.

        :rtype: int

        """
        return _Poly.Poly_Triangulation_NbTriangles(self, *args)


    def HasUVNodes(self, *args) -> "Standard_Boolean":
        """
        * Returns true if 2D nodes are associated with 3D nodes for this triangulation.

        :rtype: bool

        """
        return _Poly.Poly_Triangulation_HasUVNodes(self, *args)


    def Nodes(self, *args) -> "TColgp_Array1OfPnt const &":
        """
        * Returns the table of 3D nodes (3D points) for this triangulation.

        :rtype: TColgp_Array1OfPnt

        """
        return _Poly.Poly_Triangulation_Nodes(self, *args)


    def ChangeNodes(self, *args) -> "TColgp_Array1OfPnt &":
        """
        * Returns the table of 3D nodes (3D points) for this triangulation. The returned array is shared. Therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        :rtype: TColgp_Array1OfPnt

        """
        return _Poly.Poly_Triangulation_ChangeNodes(self, *args)


    def UVNodes(self, *args) -> "TColgp_Array1OfPnt2d const &":
        """
        * Returns the table of 2D nodes (2D points) associated with each 3D node of this triangulation. The function HasUVNodes checks if 2D nodes are associated with the 3D nodes of this triangulation. Const reference on the 2d nodes values.

        :rtype: TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Triangulation_UVNodes(self, *args)


    def ChangeUVNodes(self, *args) -> "TColgp_Array1OfPnt2d &":
        """
        * Returns the table of 2D nodes (2D points) associated with each 3D node of this triangulation. Function ChangeUVNodes shares the returned array. Therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        :rtype: TColgp_Array1OfPnt2d

        """
        return _Poly.Poly_Triangulation_ChangeUVNodes(self, *args)


    def Triangles(self, *args) -> "Poly_Array1OfTriangle const &":
        """
        * Returns the table of triangles for this triangulation.

        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_Triangulation_Triangles(self, *args)


    def ChangeTriangles(self, *args) -> "Poly_Array1OfTriangle &":
        """
        * Returns the table of triangles for this triangulation. Function ChangeUVNodes shares the returned array. Therefore if the table is selected by reference, you can, by simply modifying it, directly modify the data structure of this triangulation.

        :rtype: Poly_Array1OfTriangle

        """
        return _Poly.Poly_Triangulation_ChangeTriangles(self, *args)


    def SetNormals(self, *args) -> "void":
        """
        * Sets the table of node normals. raises exception if length of theNormals != 3*NbNodes

        :param theNormals:
        :type theNormals: Handle_TShort_HArray1OfShortReal &
        :rtype: None

        """
        return _Poly.Poly_Triangulation_SetNormals(self, *args)


    def Normals(self, *args) -> "TShort_Array1OfShortReal const &":
        """
        :rtype: TShort_Array1OfShortReal

        """
        return _Poly.Poly_Triangulation_Normals(self, *args)


    def ChangeNormals(self, *args) -> "TShort_Array1OfShortReal &":
        """
        :rtype: TShort_Array1OfShortReal

        """
        return _Poly.Poly_Triangulation_ChangeNormals(self, *args)


    def HasNormals(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _Poly.Poly_Triangulation_HasNormals(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Poly_Triangulation_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Poly_Triangulation_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Poly.delete_Poly_Triangulation
Poly_Triangulation.Copy = new_instancemethod(_Poly.Poly_Triangulation_Copy, None, Poly_Triangulation)
Poly_Triangulation.Deflection = new_instancemethod(_Poly.Poly_Triangulation_Deflection, None, Poly_Triangulation)
Poly_Triangulation.RemoveUVNodes = new_instancemethod(_Poly.Poly_Triangulation_RemoveUVNodes, None, Poly_Triangulation)
Poly_Triangulation.NbNodes = new_instancemethod(_Poly.Poly_Triangulation_NbNodes, None, Poly_Triangulation)
Poly_Triangulation.NbTriangles = new_instancemethod(_Poly.Poly_Triangulation_NbTriangles, None, Poly_Triangulation)
Poly_Triangulation.HasUVNodes = new_instancemethod(_Poly.Poly_Triangulation_HasUVNodes, None, Poly_Triangulation)
Poly_Triangulation.Nodes = new_instancemethod(_Poly.Poly_Triangulation_Nodes, None, Poly_Triangulation)
Poly_Triangulation.ChangeNodes = new_instancemethod(_Poly.Poly_Triangulation_ChangeNodes, None, Poly_Triangulation)
Poly_Triangulation.UVNodes = new_instancemethod(_Poly.Poly_Triangulation_UVNodes, None, Poly_Triangulation)
Poly_Triangulation.ChangeUVNodes = new_instancemethod(_Poly.Poly_Triangulation_ChangeUVNodes, None, Poly_Triangulation)
Poly_Triangulation.Triangles = new_instancemethod(_Poly.Poly_Triangulation_Triangles, None, Poly_Triangulation)
Poly_Triangulation.ChangeTriangles = new_instancemethod(_Poly.Poly_Triangulation_ChangeTriangles, None, Poly_Triangulation)
Poly_Triangulation.SetNormals = new_instancemethod(_Poly.Poly_Triangulation_SetNormals, None, Poly_Triangulation)
Poly_Triangulation.Normals = new_instancemethod(_Poly.Poly_Triangulation_Normals, None, Poly_Triangulation)
Poly_Triangulation.ChangeNormals = new_instancemethod(_Poly.Poly_Triangulation_ChangeNormals, None, Poly_Triangulation)
Poly_Triangulation.HasNormals = new_instancemethod(_Poly.Poly_Triangulation_HasNormals, None, Poly_Triangulation)
Poly_Triangulation_swigregister = _Poly.Poly_Triangulation_swigregister
Poly_Triangulation_swigregister(Poly_Triangulation)


class Meta_Poly_Triangulation(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Poly_Triangulation_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Poly_Triangulation", "Poly_Triangulation"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Poly_Triangulation(with_metaclass(Meta_Poly_Triangulation, Poly_Triangulation)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Poly_Triangulation", "Poly_Triangulation"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Poly_Triangulation(Handle_Poly_Triangulation_DownCast(o))



