# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Data structuire and visualization engine for voxel modeling.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _Voxel.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_Voxel')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_Voxel')
    _Voxel = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_Voxel', [dirname(__file__)])
        except ImportError:
            import _Voxel
            return _Voxel
        try:
            _mod = imp.load_module('_Voxel', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _Voxel = swig_import_helper()
    del swig_import_helper
else:
    import _Voxel
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _Voxel.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_Voxel.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_Voxel.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_Voxel.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_Voxel.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_Voxel.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_Voxel.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_Voxel.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_Voxel.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_Voxel.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_Voxel.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_Voxel.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_Voxel.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_Voxel.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_Voxel.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_Voxel.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_Voxel.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _Voxel.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _Voxel.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.TopoDS
import OCC.Core.MMgt
import OCC.Core.TCollection
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.TopAbs
import OCC.Core.Bnd
import OCC.Core.TColStd
import OCC.Core.AIS
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.Prs3d
import OCC.Core.Quantity
import OCC.Core.Aspect
import OCC.Core.Graphic3d
import OCC.Core.Image
import OCC.Core.NCollection
import OCC.Core.OSD
import OCC.Core.HLRAlgo
import OCC.Core.TopTools
import OCC.Core.Message
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.SelectMgr
import OCC.Core.SelectBasics
import OCC.Core.Select3D
import OCC.Core.PrsMgr
import OCC.Core.Visual3d
import OCC.Core.V3d
import OCC.Core.StdSelect
import OCC.Core.DsgPrs
Voxel_VFF_ASCII = _Voxel.Voxel_VFF_ASCII
Voxel_VFF_BINARY = _Voxel.Voxel_VFF_BINARY
Voxel_VDM_POINTS = _Voxel.Voxel_VDM_POINTS
Voxel_VDM_NEARESTPOINTS = _Voxel.Voxel_VDM_NEARESTPOINTS
Voxel_VDM_BOXES = _Voxel.Voxel_VDM_BOXES
Voxel_VDM_NEARESTBOXES = _Voxel.Voxel_VDM_NEARESTBOXES

def Handle_Voxel_Prs_Create() -> "Handle_Voxel_Prs":
    return _Voxel.Handle_Voxel_Prs_Create()
Handle_Voxel_Prs_Create = _Voxel.Handle_Voxel_Prs_Create

def Handle_Voxel_Prs_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_Voxel_Prs":
    return _Voxel.Handle_Voxel_Prs_DownCast(t)
Handle_Voxel_Prs_DownCast = _Voxel.Handle_Voxel_Prs_DownCast

def Handle_Voxel_Prs_IsNull(t: 'Handle_Voxel_Prs const &') -> "bool":
    return _Voxel.Handle_Voxel_Prs_IsNull(t)
Handle_Voxel_Prs_IsNull = _Voxel.Handle_Voxel_Prs_IsNull
class Voxel_BooleanOperation(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        """
        _Voxel.Voxel_BooleanOperation_swiginit(self, _Voxel.new_Voxel_BooleanOperation(*args))

    def Fuse(self, *args) -> "Standard_Boolean":
        """
        * Fuses two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels.

        :param theVoxels1:
        :type theVoxels1: Voxel_BoolDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_BoolDS &
        :rtype: bool

        * Fuses two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels. It summerizes the value of corresponding voxels and puts the result to theVoxels1. If the result exceeds 15 or becomes greater, it keeps 15.

        :param theVoxels1:
        :type theVoxels1: Voxel_ColorDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_ColorDS &
        :rtype: bool

        * Fuses two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels. It summerizes the value of corresponding voxels and puts the result to theVoxels1.

        :param theVoxels1:
        :type theVoxels1: Voxel_FloatDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_FloatDS &
        :rtype: bool

        """
        return _Voxel.Voxel_BooleanOperation_Fuse(self, *args)


    def Cut(self, *args) -> "Standard_Boolean":
        """
        * Cuts two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels.

        :param theVoxels1:
        :type theVoxels1: Voxel_BoolDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_BoolDS &
        :rtype: bool

        * Cuts two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels. It subtracts the value of corresponding voxels and puts the result to theVoxels1.

        :param theVoxels1:
        :type theVoxels1: Voxel_ColorDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_ColorDS &
        :rtype: bool

        * Cuts two cubes of voxels. It modifies the first cube of voxels. It returns false in case of different dimension of the cube, different number of voxels. It subtracts the value of corresponding voxels and puts the result to theVoxels1.

        :param theVoxels1:
        :type theVoxels1: Voxel_FloatDS &
        :param theVoxels2:
        :type theVoxels2: Voxel_FloatDS &
        :rtype: bool

        """
        return _Voxel.Voxel_BooleanOperation_Cut(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_BooleanOperation
Voxel_BooleanOperation.Fuse = new_instancemethod(_Voxel.Voxel_BooleanOperation_Fuse, None, Voxel_BooleanOperation)
Voxel_BooleanOperation.Cut = new_instancemethod(_Voxel.Voxel_BooleanOperation_Cut, None, Voxel_BooleanOperation)
Voxel_BooleanOperation_swigregister = _Voxel.Voxel_BooleanOperation_swigregister
Voxel_BooleanOperation_swigregister(Voxel_BooleanOperation)

class Voxel_CollisionDetection(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor. It defines deflection of triangulation for the shapes. As lower the deflection is, as proper the triangulation is generated. Also, it defines number of splits along X, Y and Z axes for generation of voxels. As greater the numbers are, as greater number of voxels is used for detection of collision.

        :param deflection:
        :type deflection: float
        :param nbx:
        :type nbx: int
        :param nby:
        :type nby: int
        :param nbz:
        :type nbz: int
        :rtype: None

        """
        _Voxel.Voxel_CollisionDetection_swiginit(self, _Voxel.new_Voxel_CollisionDetection(*args))

    def AddShape(self, *args) -> "Standard_Integer":
        """
        * Adds a shape. Returns an index of the shape.

        :param shape:
        :type shape: TopoDS_Shape &
        :rtype: int

        """
        return _Voxel.Voxel_CollisionDetection_AddShape(self, *args)


    def ReplaceShape(self, *args) -> "Standard_Boolean":
        """
        * Replaces a shape by another one. <ishape> is an index of the shape. This method is useful for moving shape, for example.

        :param ishape:
        :type ishape: int
        :param shape:
        :type shape: TopoDS_Shape &
        :rtype: bool

        """
        return _Voxel.Voxel_CollisionDetection_ReplaceShape(self, *args)


    def SetDeflection(self, *args) -> "void":
        """
        * Defines the deflection of triangulation of shapes.

        :param deflection:
        :type deflection: float
        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_SetDeflection(self, *args)


    def SetNbVoxels(self, *args) -> "void":
        """
        * Defines the number of voxels along X, Y and Z axes.

        :param nbx:
        :type nbx: int
        :param nby:
        :type nby: int
        :param nbz:
        :type nbz: int
        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_SetNbVoxels(self, *args)


    def SetBoundaryBox(self, *args) -> "void":
        """
        * Defines a user-defined boundary box for generation of voxels. If this method is not called, the algorithm calculates the boundary box itself.

        :param box:
        :type box: Bnd_Box &
        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_SetBoundaryBox(self, *args)


    def SetUsageOfVolume(self, *args) -> "void":
        """
        * Defines usage of volume of shapes in collision detection algorithm. Beware, usage of volume a little bit decreases the speed of algorithm.

        :param usage:
        :type usage: bool
        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_SetUsageOfVolume(self, *args)


    def KeepCollisions(self, *args) -> "void":
        """
        * Doesn't clean the collision points on new call to the method Compute(). It allows to see the collisions for a moving shape.

        :param keep:
        :type keep: bool
        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_KeepCollisions(self, *args)


    def Voxelize(self, *args) -> "Standard_Boolean":
        """
        * Prepares data for computation of collisions. It checks the inner parameters (number of voxels along X, Y and Z axes) and voxelizes the shapes. If the shape is not changed since the last call to this method, this method may be not called for this shape. <ishape> - is the index of the shape for processing by this method. If it is equal to -1, all shapes will be processed.

        :param ishape: default value is -1
        :type ishape: int
        :rtype: bool

        """
        return _Voxel.Voxel_CollisionDetection_Voxelize(self, *args)


    def Compute(self, *args) -> "Standard_Boolean":
        """
        * Computes the collisions. This method may be called many times if, for example, the shapes are being moved.

        :rtype: bool

        """
        return _Voxel.Voxel_CollisionDetection_Compute(self, *args)


    def HasCollisions(self, *args) -> "Standard_Boolean":
        """
        * Returns true if a collision is detected.

        :rtype: bool

        """
        return _Voxel.Voxel_CollisionDetection_HasCollisions(self, *args)


    def GetCollisions(self, *args) -> "Voxel_BoolDS const &":
        """
        * Returns the collided voxels.

        :rtype: Voxel_BoolDS

        """
        return _Voxel.Voxel_CollisionDetection_GetCollisions(self, *args)


    def Destroy(self, *args) -> "void":
        """
        * A destructor.

        :rtype: None

        """
        return _Voxel.Voxel_CollisionDetection_Destroy(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_CollisionDetection
Voxel_CollisionDetection.AddShape = new_instancemethod(_Voxel.Voxel_CollisionDetection_AddShape, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.ReplaceShape = new_instancemethod(_Voxel.Voxel_CollisionDetection_ReplaceShape, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.SetDeflection = new_instancemethod(_Voxel.Voxel_CollisionDetection_SetDeflection, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.SetNbVoxels = new_instancemethod(_Voxel.Voxel_CollisionDetection_SetNbVoxels, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.SetBoundaryBox = new_instancemethod(_Voxel.Voxel_CollisionDetection_SetBoundaryBox, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.SetUsageOfVolume = new_instancemethod(_Voxel.Voxel_CollisionDetection_SetUsageOfVolume, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.KeepCollisions = new_instancemethod(_Voxel.Voxel_CollisionDetection_KeepCollisions, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.Voxelize = new_instancemethod(_Voxel.Voxel_CollisionDetection_Voxelize, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.Compute = new_instancemethod(_Voxel.Voxel_CollisionDetection_Compute, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.HasCollisions = new_instancemethod(_Voxel.Voxel_CollisionDetection_HasCollisions, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.GetCollisions = new_instancemethod(_Voxel.Voxel_CollisionDetection_GetCollisions, None, Voxel_CollisionDetection)
Voxel_CollisionDetection.Destroy = new_instancemethod(_Voxel.Voxel_CollisionDetection_Destroy, None, Voxel_CollisionDetection)
Voxel_CollisionDetection_swigregister = _Voxel.Voxel_CollisionDetection_swigregister
Voxel_CollisionDetection_swigregister(Voxel_CollisionDetection)

class Voxel_DS(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_DS_swiginit(self, _Voxel.new_Voxel_DS(*args))

    def Init(self, *args) -> "void":
        """
        * Initialization of the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions. The methods below return initial data of the voxel model.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: void

        """
        return _Voxel.Voxel_DS_Init(self, *args)


    def GetX(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetX(self, *args)


    def GetY(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetY(self, *args)


    def GetZ(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetZ(self, *args)


    def GetXLen(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetXLen(self, *args)


    def GetYLen(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetYLen(self, *args)


    def GetZLen(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _Voxel.Voxel_DS_GetZLen(self, *args)


    def GetNbX(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Voxel.Voxel_DS_GetNbX(self, *args)


    def GetNbY(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Voxel.Voxel_DS_GetNbY(self, *args)


    def GetNbZ(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _Voxel.Voxel_DS_GetNbZ(self, *args)


    def GetCenter(self, *args) -> "void":
        """
        * Returns the center point of a voxel with co-ordinates (ix, iy, iz).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param xc:
        :type xc: float &
        :param yc:
        :type yc: float &
        :param zc:
        :type zc: float &
        :rtype: None

        """
        return _Voxel.Voxel_DS_GetCenter(self, *args)


    def GetOrigin(self, *args) -> "void":
        """
        * Returns the origin point of a voxel with co-ordinates (ix, iy, iz).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param x0:
        :type x0: float &
        :param y0:
        :type y0: float &
        :param z0:
        :type z0: float &
        :rtype: None

        """
        return _Voxel.Voxel_DS_GetOrigin(self, *args)


    def GetVoxel(self, *args) -> "Standard_Boolean":
        """
        * Finds a voxel corresponding to a 3D point. Returns true if it is found.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param ix:
        :type ix: int &
        :param iy:
        :type iy: int &
        :param iz:
        :type iz: int &
        :rtype: bool

        """
        return _Voxel.Voxel_DS_GetVoxel(self, *args)


    def GetVoxelX(self, *args) -> "Standard_Boolean":
        """
        * Returns x-index of a voxel corresponding to x-coordinate.

        :param x:
        :type x: float
        :param ix:
        :type ix: int &
        :rtype: bool

        """
        return _Voxel.Voxel_DS_GetVoxelX(self, *args)


    def GetVoxelY(self, *args) -> "Standard_Boolean":
        """
        * Returns y-index of a voxel corresponding to y-coordinate.

        :param y:
        :type y: float
        :param iy:
        :type iy: int &
        :rtype: bool

        """
        return _Voxel.Voxel_DS_GetVoxelY(self, *args)


    def GetVoxelZ(self, *args) -> "Standard_Boolean":
        """
        * Returns z-index of a voxel corresponding to z-coordinate.

        :param z:
        :type z: float
        :param iz:
        :type iz: int &
        :rtype: bool

        """
        return _Voxel.Voxel_DS_GetVoxelZ(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_DS
Voxel_DS.Init = new_instancemethod(_Voxel.Voxel_DS_Init, None, Voxel_DS)
Voxel_DS.GetX = new_instancemethod(_Voxel.Voxel_DS_GetX, None, Voxel_DS)
Voxel_DS.GetY = new_instancemethod(_Voxel.Voxel_DS_GetY, None, Voxel_DS)
Voxel_DS.GetZ = new_instancemethod(_Voxel.Voxel_DS_GetZ, None, Voxel_DS)
Voxel_DS.GetXLen = new_instancemethod(_Voxel.Voxel_DS_GetXLen, None, Voxel_DS)
Voxel_DS.GetYLen = new_instancemethod(_Voxel.Voxel_DS_GetYLen, None, Voxel_DS)
Voxel_DS.GetZLen = new_instancemethod(_Voxel.Voxel_DS_GetZLen, None, Voxel_DS)
Voxel_DS.GetNbX = new_instancemethod(_Voxel.Voxel_DS_GetNbX, None, Voxel_DS)
Voxel_DS.GetNbY = new_instancemethod(_Voxel.Voxel_DS_GetNbY, None, Voxel_DS)
Voxel_DS.GetNbZ = new_instancemethod(_Voxel.Voxel_DS_GetNbZ, None, Voxel_DS)
Voxel_DS.GetCenter = new_instancemethod(_Voxel.Voxel_DS_GetCenter, None, Voxel_DS)
Voxel_DS.GetOrigin = new_instancemethod(_Voxel.Voxel_DS_GetOrigin, None, Voxel_DS)
Voxel_DS.GetVoxel = new_instancemethod(_Voxel.Voxel_DS_GetVoxel, None, Voxel_DS)
Voxel_DS.GetVoxelX = new_instancemethod(_Voxel.Voxel_DS_GetVoxelX, None, Voxel_DS)
Voxel_DS.GetVoxelY = new_instancemethod(_Voxel.Voxel_DS_GetVoxelY, None, Voxel_DS)
Voxel_DS.GetVoxelZ = new_instancemethod(_Voxel.Voxel_DS_GetVoxelZ, None, Voxel_DS)
Voxel_DS_swigregister = _Voxel.Voxel_DS_swigregister
Voxel_DS_swigregister(Voxel_DS)

class Voxel_FastConverter(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * A constructor for conversion of a shape into a cube of boolean voxels. It allocates the voxels in memory. 'nbthreads' defines the number of threads used to convert the shape.

        :param shape:
        :type shape: TopoDS_Shape &
        :param voxels:
        :type voxels: Voxel_BoolDS &
        :param deflection: default value is 0.1
        :type deflection: float
        :param nbx: default value is 10
        :type nbx: int
        :param nby: default value is 10
        :type nby: int
        :param nbz: default value is 10
        :type nbz: int
        :param nbthreads: default value is 1
        :type nbthreads: int
        :param useExistingTriangulation: default value is Standard_False
        :type useExistingTriangulation: bool
        :rtype: None

        * A constructor for conversion of a shape into a cube of colored voxels. It allocates the voxels in memory. 'nbthreads' defines the number of threads used to convert the shape.

        :param shape:
        :type shape: TopoDS_Shape &
        :param voxels:
        :type voxels: Voxel_ColorDS &
        :param deflection: default value is 0.1
        :type deflection: float
        :param nbx: default value is 10
        :type nbx: int
        :param nby: default value is 10
        :type nby: int
        :param nbz: default value is 10
        :type nbz: int
        :param nbthreads: default value is 1
        :type nbthreads: int
        :param useExistingTriangulation: default value is Standard_False
        :type useExistingTriangulation: bool
        :rtype: None

        * A constructor for conversion of a shape into a cube of boolean voxels split into 8 sub-voxels recursively. It allocates the voxels in memory. 'nbthreads' defines the number of threads used to convert the shape.

        :param shape:
        :type shape: TopoDS_Shape &
        :param voxels:
        :type voxels: Voxel_ROctBoolDS &
        :param deflection: default value is 0.1
        :type deflection: float
        :param nbx: default value is 10
        :type nbx: int
        :param nby: default value is 10
        :type nby: int
        :param nbz: default value is 10
        :type nbz: int
        :param nbthreads: default value is 1
        :type nbthreads: int
        :param useExistingTriangulation: default value is Standard_False
        :type useExistingTriangulation: bool
        :rtype: None

        """
        _Voxel.Voxel_FastConverter_swiginit(self, _Voxel.new_Voxel_FastConverter(*args))

    def Convert(self, *args) -> "Standard_Boolean":
        """
        * Converts a shape into a voxel representation. It sets to 0 the outside volume of the shape and 1 for surfacic part of the shape. 'ithread' is the index of the thread for current call of ::Convert(). Start numeration of 'ithread' with 1, please.

        :param progress:
        :type progress: int &
        :param ithread: default value is 1
        :type ithread: int
        :rtype: bool

        """
        return _Voxel.Voxel_FastConverter_Convert(self, *args)


    def ConvertUsingSAT(self, *args) -> "Standard_Boolean":
        """
        * Converts a shape into a voxel representation using separating axis theorem. It sets to 0 the outside volume of the shape and 1 for surfacic part of the shape. 'ithread' is the index of the thread for current call of ::Convert(). Start numeration of 'ithread' with 1, please.

        :param progress:
        :type progress: int &
        :param ithread: default value is 1
        :type ithread: int
        :rtype: bool

        """
        return _Voxel.Voxel_FastConverter_ConvertUsingSAT(self, *args)


    def FillInVolume(self, *args) -> "Standard_Boolean":
        """
        * Fills-in volume of the shape by a value.

        :param inner:
        :type inner: Standard_Byte
        :param ithread: default value is 1
        :type ithread: int
        :rtype: bool

        * Fills-in volume of the shape by a value. Uses the topological information from the provided shape to judge whether points are inside the shape or not (only when processing vertical faces). The inner value has to be positive.

        :param inner:
        :type inner: Standard_Byte
        :param shape:
        :type shape: TopoDS_Shape &
        :param ithread: default value is 1
        :type ithread: int
        :rtype: bool

        """
        return _Voxel.Voxel_FastConverter_FillInVolume(self, *args)


    def Destroy(self, *args) -> "void":
        """
        * A destructor.

        :rtype: None

        """
        return _Voxel.Voxel_FastConverter_Destroy(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_FastConverter
Voxel_FastConverter.Convert = new_instancemethod(_Voxel.Voxel_FastConverter_Convert, None, Voxel_FastConverter)
Voxel_FastConverter.ConvertUsingSAT = new_instancemethod(_Voxel.Voxel_FastConverter_ConvertUsingSAT, None, Voxel_FastConverter)
Voxel_FastConverter.FillInVolume = new_instancemethod(_Voxel.Voxel_FastConverter_FillInVolume, None, Voxel_FastConverter)
Voxel_FastConverter.Destroy = new_instancemethod(_Voxel.Voxel_FastConverter_Destroy, None, Voxel_FastConverter)
Voxel_FastConverter_swigregister = _Voxel.Voxel_FastConverter_swigregister
Voxel_FastConverter_swigregister(Voxel_FastConverter)

class Voxel_Prs(OCC.Core.AIS.AIS_InteractiveObject):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        """
        _Voxel.Voxel_Prs_swiginit(self, _Voxel.new_Voxel_Prs(*args))

    def SetBoolVoxels(self, *args) -> "void":
        """
        * <theVoxels> is a Voxel_BoolDS* object.

        :param theVoxels:
        :type theVoxels: Standard_Address
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetBoolVoxels(self, *args)


    def SetColorVoxels(self, *args) -> "void":
        """
        * <theVoxels> is a Voxel_ColorDS* object.

        :param theVoxels:
        :type theVoxels: Standard_Address
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetColorVoxels(self, *args)


    def SetROctBoolVoxels(self, *args) -> "void":
        """
        * <theVoxels> is a Voxel_ROctBoolDS* object.

        :param theVoxels:
        :type theVoxels: Standard_Address
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetROctBoolVoxels(self, *args)


    def SetTriangulation(self, *args) -> "void":
        """
        * Sets a triangulation for visualization.

        :param theTriangulation:
        :type theTriangulation: Handle_Poly_Triangulation &
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetTriangulation(self, *args)


    def SetDisplayMode(self, *args) -> "void":
        """
        * Sets a display mode for voxels.

        :param theMode:
        :type theMode: Voxel_VoxelDisplayMode
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetDisplayMode(self, *args)


    def SetColors(self, *args) -> "void":
        """
        * Defines the color of points, quadrangles... for ColorDS. For ColorDS the size of array is 0 .. 15. 0 - means no color, this voxel is not drawn.

        :param theColors:
        :type theColors: Handle_Quantity_HArray1OfColor &
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetColors(self, *args)


    def SetPointSize(self, *args) -> "void":
        """
        * Defines the size of points for all types of voxels.

        :param theSize:
        :type theSize: float
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetPointSize(self, *args)


    def SetQuadrangleSize(self, *args) -> "void":
        """
        * Defines the size of quadrangles in per cents (0 .. 100).

        :param theSize:
        :type theSize: int
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetQuadrangleSize(self, *args)


    def Highlight(self, *args) -> "void":
        """
        * Highlights a voxel. It doesn't re-computes the whole interactive object, but only marks a voxels as 'highlighted'. The voxel becomes highlighted on next swapping of buffers. In order to unhighlight a voxel, set ix = iy = iz = -1.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: None

        """
        return _Voxel.Voxel_Prs_Highlight(self, *args)


    def Destroy(self, *args) -> "void":
        """
        * A destructor of presentation data.

        :rtype: None

        """
        return _Voxel.Voxel_Prs_Destroy(self, *args)


    def SetDegenerateMode(self, *args) -> "void":
        """
        * Simplifies visualization of voxels in case of view rotation, panning and zooming.

        :param theDegenerate:
        :type theDegenerate: bool
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetDegenerateMode(self, *args)


    def SetUsageOfGLlists(self, *args) -> "void":
        """
        * GL lists accelerate view rotation, panning and zooming operations, but it takes additional memory... It is up to the user of this interactive object to decide whether he has enough memory and may use GL lists or he is lack of memory and usage of GL lists is not recommended. By default, usage of GL lists is on. Also, as I noticed, the view without GL lists looks more precisely.

        :param theUsage:
        :type theUsage: bool
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetUsageOfGLlists(self, *args)


    def SetSmoothPoints(self, *args) -> "void":
        """
        * Switches visualization of points from smooth to rough.

        :param theSmooth:
        :type theSmooth: bool
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetSmoothPoints(self, *args)


    def SetColorRange(self, *args) -> "void":
        """
        * Defines min-max values for visualization of voxels of ColorDS structure. By default, min value = 1, max value = 15 (all non-zero values).

        :param theMinValue:
        :type theMinValue: Standard_Byte
        :param theMaxValue:
        :type theMaxValue: Standard_Byte
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetColorRange(self, *args)


    def SetSizeRange(self, *args) -> "void":
        """
        * Defines the displayed area of voxels. By default, the range is equal to the box of voxels (all voxels are displayed).

        :param theDisplayedXMin:
        :type theDisplayedXMin: float
        :param theDisplayedXMax:
        :type theDisplayedXMax: float
        :param theDisplayedYMin:
        :type theDisplayedYMin: float
        :param theDisplayedYMax:
        :type theDisplayedYMax: float
        :param theDisplayedZMin:
        :type theDisplayedZMin: float
        :param theDisplayedZMax:
        :type theDisplayedZMax: float
        :rtype: None

        """
        return _Voxel.Voxel_Prs_SetSizeRange(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_Voxel_Prs_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_Voxel_Prs_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_Prs
Voxel_Prs.SetBoolVoxels = new_instancemethod(_Voxel.Voxel_Prs_SetBoolVoxels, None, Voxel_Prs)
Voxel_Prs.SetColorVoxels = new_instancemethod(_Voxel.Voxel_Prs_SetColorVoxels, None, Voxel_Prs)
Voxel_Prs.SetROctBoolVoxels = new_instancemethod(_Voxel.Voxel_Prs_SetROctBoolVoxels, None, Voxel_Prs)
Voxel_Prs.SetTriangulation = new_instancemethod(_Voxel.Voxel_Prs_SetTriangulation, None, Voxel_Prs)
Voxel_Prs.SetDisplayMode = new_instancemethod(_Voxel.Voxel_Prs_SetDisplayMode, None, Voxel_Prs)
Voxel_Prs.SetColors = new_instancemethod(_Voxel.Voxel_Prs_SetColors, None, Voxel_Prs)
Voxel_Prs.SetPointSize = new_instancemethod(_Voxel.Voxel_Prs_SetPointSize, None, Voxel_Prs)
Voxel_Prs.SetQuadrangleSize = new_instancemethod(_Voxel.Voxel_Prs_SetQuadrangleSize, None, Voxel_Prs)
Voxel_Prs.Highlight = new_instancemethod(_Voxel.Voxel_Prs_Highlight, None, Voxel_Prs)
Voxel_Prs.Destroy = new_instancemethod(_Voxel.Voxel_Prs_Destroy, None, Voxel_Prs)
Voxel_Prs.SetDegenerateMode = new_instancemethod(_Voxel.Voxel_Prs_SetDegenerateMode, None, Voxel_Prs)
Voxel_Prs.SetUsageOfGLlists = new_instancemethod(_Voxel.Voxel_Prs_SetUsageOfGLlists, None, Voxel_Prs)
Voxel_Prs.SetSmoothPoints = new_instancemethod(_Voxel.Voxel_Prs_SetSmoothPoints, None, Voxel_Prs)
Voxel_Prs.SetColorRange = new_instancemethod(_Voxel.Voxel_Prs_SetColorRange, None, Voxel_Prs)
Voxel_Prs.SetSizeRange = new_instancemethod(_Voxel.Voxel_Prs_SetSizeRange, None, Voxel_Prs)
Voxel_Prs_swigregister = _Voxel.Voxel_Prs_swigregister
Voxel_Prs_swigregister(Voxel_Prs)


class Meta_Voxel_Prs(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_Voxel_Prs_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("Voxel_Prs", "Voxel_Prs"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_Voxel_Prs(with_metaclass(Meta_Voxel_Prs, Voxel_Prs)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("Voxel_Prs", "Voxel_Prs"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_Voxel_Prs(Handle_Voxel_Prs_DownCast(o))

class Voxel_Reader(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        """
        _Voxel.Voxel_Reader_swiginit(self, _Voxel.new_Voxel_Reader(*args))

    def Read(self, *args) -> "Standard_Boolean":
        """
        * Reads the voxels from disk

        :param file:
        :type file: TCollection_ExtendedString &
        :rtype: bool

        """
        return _Voxel.Voxel_Reader_Read(self, *args)


    def IsBoolVoxels(self, *args) -> "Standard_Boolean":
        """
        * Informs the user about the type of voxels he has read.

        :rtype: bool

        """
        return _Voxel.Voxel_Reader_IsBoolVoxels(self, *args)


    def IsColorVoxels(self, *args) -> "Standard_Boolean":
        """
        * Informs the user about the type of voxels he has read.

        :rtype: bool

        """
        return _Voxel.Voxel_Reader_IsColorVoxels(self, *args)


    def IsFloatVoxels(self, *args) -> "Standard_Boolean":
        """
        * Informs the user about the type of voxels he has read.

        :rtype: bool

        """
        return _Voxel.Voxel_Reader_IsFloatVoxels(self, *args)


    def GetBoolVoxels(self, *args) -> "Standard_Address":
        """
        * Returns a pointer to the read 1bit voxels.

        :rtype: Standard_Address

        """
        return _Voxel.Voxel_Reader_GetBoolVoxels(self, *args)


    def GetColorVoxels(self, *args) -> "Standard_Address":
        """
        * Returns a pointer to the read 4bit voxels.

        :rtype: Standard_Address

        """
        return _Voxel.Voxel_Reader_GetColorVoxels(self, *args)


    def GetFloatVoxels(self, *args) -> "Standard_Address":
        """
        * Returns a pointer to the read 4bytes voxels.

        :rtype: Standard_Address

        """
        return _Voxel.Voxel_Reader_GetFloatVoxels(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_Reader
Voxel_Reader.Read = new_instancemethod(_Voxel.Voxel_Reader_Read, None, Voxel_Reader)
Voxel_Reader.IsBoolVoxels = new_instancemethod(_Voxel.Voxel_Reader_IsBoolVoxels, None, Voxel_Reader)
Voxel_Reader.IsColorVoxels = new_instancemethod(_Voxel.Voxel_Reader_IsColorVoxels, None, Voxel_Reader)
Voxel_Reader.IsFloatVoxels = new_instancemethod(_Voxel.Voxel_Reader_IsFloatVoxels, None, Voxel_Reader)
Voxel_Reader.GetBoolVoxels = new_instancemethod(_Voxel.Voxel_Reader_GetBoolVoxels, None, Voxel_Reader)
Voxel_Reader.GetColorVoxels = new_instancemethod(_Voxel.Voxel_Reader_GetColorVoxels, None, Voxel_Reader)
Voxel_Reader.GetFloatVoxels = new_instancemethod(_Voxel.Voxel_Reader_GetFloatVoxels, None, Voxel_Reader)
Voxel_Reader_swigregister = _Voxel.Voxel_Reader_swigregister
Voxel_Reader_swigregister(Voxel_Reader)

class Voxel_Selector(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor of the selector, which initializes the classes by a view, where the user selects the voxels.

        :param view:
        :type view: Handle_V3d_View &
        :rtype: None

        """
        _Voxel.Voxel_Selector_swiginit(self, _Voxel.new_Voxel_Selector(*args))

    def Init(self, *args) -> "void":
        """
        * Initializes the selector by a view, where the user selects the voxels.

        :param view:
        :type view: Handle_V3d_View &
        :rtype: None

        """
        return _Voxel.Voxel_Selector_Init(self, *args)


    def SetVoxels(self, *args) -> "void":
        """
        * Defines the voxels (1bit).

        :param voxels:
        :type voxels: Voxel_BoolDS &
        :rtype: None

        * Defines the voxels (4bit).

        :param voxels:
        :type voxels: Voxel_ColorDS &
        :rtype: None

        * Defines the voxels (1bit recursive splitting).

        :param voxels:
        :type voxels: Voxel_ROctBoolDS &
        :rtype: None

        """
        return _Voxel.Voxel_Selector_SetVoxels(self, *args)


    def Detect(self, *args) -> "Standard_Boolean":
        """
        * Detects a voxel under the mouse cursor.

        :param winx:
        :type winx: int
        :param winy:
        :type winy: int
        :param ix:
        :type ix: int &
        :param iy:
        :type iy: int &
        :param iz:
        :type iz: int &
        :rtype: bool

        """
        return _Voxel.Voxel_Selector_Detect(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_Selector
Voxel_Selector.Init = new_instancemethod(_Voxel.Voxel_Selector_Init, None, Voxel_Selector)
Voxel_Selector.SetVoxels = new_instancemethod(_Voxel.Voxel_Selector_SetVoxels, None, Voxel_Selector)
Voxel_Selector.Detect = new_instancemethod(_Voxel.Voxel_Selector_Detect, None, Voxel_Selector)
Voxel_Selector_swigregister = _Voxel.Voxel_Selector_swigregister
Voxel_Selector_swigregister(Voxel_Selector)

class Voxel_SplitData(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        """
        _Voxel.Voxel_SplitData_swiginit(self, _Voxel.new_Voxel_SplitData(*args))

    def GetValues(self, *args) -> "Standard_Address &":
        """
        * Gives access to the values.

        :rtype: Standard_Address

        """
        return _Voxel.Voxel_SplitData_GetValues(self, *args)


    def GetSplitData(self, *args) -> "Standard_Address &":
        """
        * Gives access to the next split data.

        :rtype: Standard_Address

        """
        return _Voxel.Voxel_SplitData_GetSplitData(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_SplitData
Voxel_SplitData.GetValues = new_instancemethod(_Voxel.Voxel_SplitData_GetValues, None, Voxel_SplitData)
Voxel_SplitData.GetSplitData = new_instancemethod(_Voxel.Voxel_SplitData_GetSplitData, None, Voxel_SplitData)
Voxel_SplitData_swigregister = _Voxel.Voxel_SplitData_swigregister
Voxel_SplitData_swigregister(Voxel_SplitData)

class Voxel_Writer(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        """
        _Voxel.Voxel_Writer_swiginit(self, _Voxel.new_Voxel_Writer(*args))

    def SetFormat(self, *args) -> "void":
        """
        * Defines the file format for voxels. ASCII - slow and occupies more space on disk. BINARY - fast and occupies less space on disk.

        :param format:
        :type format: Voxel_VoxelFileFormat
        :rtype: None

        """
        return _Voxel.Voxel_Writer_SetFormat(self, *args)


    def SetVoxels(self, *args) -> "void":
        """
        * Defines the voxels (1bit).

        :param voxels:
        :type voxels: Voxel_BoolDS &
        :rtype: None

        * Defines the voxels (4bit).

        :param voxels:
        :type voxels: Voxel_ColorDS &
        :rtype: None

        * Defines the voxels (4bytes).

        :param voxels:
        :type voxels: Voxel_FloatDS &
        :rtype: None

        """
        return _Voxel.Voxel_Writer_SetVoxels(self, *args)


    def Write(self, *args) -> "Standard_Boolean":
        """
        * Writes the voxels on disk using the defined format and file name.

        :param file:
        :type file: TCollection_ExtendedString &
        :rtype: bool

        """
        return _Voxel.Voxel_Writer_Write(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_Writer
Voxel_Writer.SetFormat = new_instancemethod(_Voxel.Voxel_Writer_SetFormat, None, Voxel_Writer)
Voxel_Writer.SetVoxels = new_instancemethod(_Voxel.Voxel_Writer_SetVoxels, None, Voxel_Writer)
Voxel_Writer.Write = new_instancemethod(_Voxel.Voxel_Writer_Write, None, Voxel_Writer)
Voxel_Writer_swigregister = _Voxel.Voxel_Writer_swigregister
Voxel_Writer_swigregister(Voxel_Writer)

class Voxel_BoolDS(Voxel_DS):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_BoolDS_swiginit(self, _Voxel.new_Voxel_BoolDS(*args))

    def Destroy(self, *args) -> "void":
        """
        * A destructor of the voxel model.

        :rtype: None

        """
        return _Voxel.Voxel_BoolDS_Destroy(self, *args)


    def SetZero(self, *args) -> "void":
        """
        * The method sets all values equal to 0 (false) and releases the memory.

        :rtype: None

        """
        return _Voxel.Voxel_BoolDS_SetZero(self, *args)


    def Set(self, *args) -> "void":
        """
        * Defines a value for voxel with co-ordinates (ix, iy, iz). Initial state of the model is so that all voxels have value 0 (false), and this data doesn't occupy memory. Memory for data is allocating during setting non-zero values (true).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param data: default value is Standard_True
        :type data: bool
        :rtype: None

        """
        return _Voxel.Voxel_BoolDS_Set(self, *args)


    def Get(self, *args) -> "Standard_Boolean":
        """
        * Returns the value of voxel with co-ordinates (ix, iy, iz).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: bool

        """
        return _Voxel.Voxel_BoolDS_Get(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_BoolDS
Voxel_BoolDS.Destroy = new_instancemethod(_Voxel.Voxel_BoolDS_Destroy, None, Voxel_BoolDS)
Voxel_BoolDS.SetZero = new_instancemethod(_Voxel.Voxel_BoolDS_SetZero, None, Voxel_BoolDS)
Voxel_BoolDS.Set = new_instancemethod(_Voxel.Voxel_BoolDS_Set, None, Voxel_BoolDS)
Voxel_BoolDS.Get = new_instancemethod(_Voxel.Voxel_BoolDS_Get, None, Voxel_BoolDS)
Voxel_BoolDS_swigregister = _Voxel.Voxel_BoolDS_swigregister
Voxel_BoolDS_swigregister(Voxel_BoolDS)

class Voxel_ColorDS(Voxel_DS):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_ColorDS_swiginit(self, _Voxel.new_Voxel_ColorDS(*args))

    def Destroy(self, *args) -> "void":
        """
        * A destructor of the voxel model.

        :rtype: None

        """
        return _Voxel.Voxel_ColorDS_Destroy(self, *args)


    def SetZero(self, *args) -> "void":
        """
        * The method sets all values equal to 0 (false) and releases the memory.

        :rtype: None

        """
        return _Voxel.Voxel_ColorDS_SetZero(self, *args)


    def Set(self, *args) -> "void":
        """
        * Defines a value for voxel with co-ordinates (ix, iy, iz). Only the first four bits are used! Initial state of the model is so that all voxels have value 0x0000, and this data doesn't occupy memory. Memory for data is allocating during setting non-zero values (0x0101, for example).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param data:
        :type data: Standard_Byte
        :rtype: None

        """
        return _Voxel.Voxel_ColorDS_Set(self, *args)


    def Get(self, *args) -> "Standard_Byte":
        """
        * Returns the value of voxel with co-ordinates (ix, iy, iz).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: Standard_Byte

        """
        return _Voxel.Voxel_ColorDS_Get(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_ColorDS
Voxel_ColorDS.Destroy = new_instancemethod(_Voxel.Voxel_ColorDS_Destroy, None, Voxel_ColorDS)
Voxel_ColorDS.SetZero = new_instancemethod(_Voxel.Voxel_ColorDS_SetZero, None, Voxel_ColorDS)
Voxel_ColorDS.Set = new_instancemethod(_Voxel.Voxel_ColorDS_Set, None, Voxel_ColorDS)
Voxel_ColorDS.Get = new_instancemethod(_Voxel.Voxel_ColorDS_Get, None, Voxel_ColorDS)
Voxel_ColorDS_swigregister = _Voxel.Voxel_ColorDS_swigregister
Voxel_ColorDS_swigregister(Voxel_ColorDS)

class Voxel_FloatDS(Voxel_DS):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_FloatDS_swiginit(self, _Voxel.new_Voxel_FloatDS(*args))

    def Destroy(self, *args) -> "void":
        """
        * A destructor of the voxel model.

        :rtype: None

        """
        return _Voxel.Voxel_FloatDS_Destroy(self, *args)


    def SetZero(self, *args) -> "void":
        """
        * The method sets all values equal to 0 (false) and releases the memory.

        :rtype: None

        """
        return _Voxel.Voxel_FloatDS_SetZero(self, *args)


    def Set(self, *args) -> "void":
        """
        * Defines a value for voxel with co-ordinates (ix, iy, iz). Initial state of the model is so that all voxels have value 0.0f, and this data doesn't occupy memory. Memory for data is allocating during setting non-zero values.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param data:
        :type data: Standard_ShortReal
        :rtype: None

        """
        return _Voxel.Voxel_FloatDS_Set(self, *args)


    def Get(self, *args) -> "Standard_ShortReal":
        """
        * Returns the value of voxel with co-ordinates (ix, iy, iz).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: Standard_ShortReal

        """
        return _Voxel.Voxel_FloatDS_Get(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_FloatDS
Voxel_FloatDS.Destroy = new_instancemethod(_Voxel.Voxel_FloatDS_Destroy, None, Voxel_FloatDS)
Voxel_FloatDS.SetZero = new_instancemethod(_Voxel.Voxel_FloatDS_SetZero, None, Voxel_FloatDS)
Voxel_FloatDS.Set = new_instancemethod(_Voxel.Voxel_FloatDS_Set, None, Voxel_FloatDS)
Voxel_FloatDS.Get = new_instancemethod(_Voxel.Voxel_FloatDS_Get, None, Voxel_FloatDS)
Voxel_FloatDS_swigregister = _Voxel.Voxel_FloatDS_swigregister
Voxel_FloatDS_swigregister(Voxel_FloatDS)

class Voxel_OctBoolDS(Voxel_DS):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_OctBoolDS_swiginit(self, _Voxel.new_Voxel_OctBoolDS(*args))

    def Destroy(self, *args) -> "void":
        """
        * A destructor of the voxel model.

        :rtype: None

        """
        return _Voxel.Voxel_OctBoolDS_Destroy(self, *args)


    def SetZero(self, *args) -> "void":
        """
        * The method sets all values equal to 0 (false) and releases the memory.

        :rtype: None

        """
        return _Voxel.Voxel_OctBoolDS_SetZero(self, *args)


    def OptimizeMemory(self, *args) -> "void":
        """
        * The method searches voxels with equal-value of sub-voxels and removes them (remaining the value for the voxel).

        :rtype: None

        """
        return _Voxel.Voxel_OctBoolDS_OptimizeMemory(self, *args)


    def Set(self, *args) -> "void":
        """
        * Defines a value for voxel with co-ordinates (ix, iy, iz). If the voxel is split into 8 sub-voxels, the split disappears. Initial state of the model is so that all voxels have value 0 (false), and this data doesn't occupy memory. Memory for data is allocating during setting non-zero values (true).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param data:
        :type data: bool
        :rtype: None

        * Defines a value for a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split into 8 sub-voxels yet, this method splits the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct:
        :type ioct: int
        :param data:
        :type data: bool
        :rtype: None

        """
        return _Voxel.Voxel_OctBoolDS_Set(self, *args)


    def Get(self, *args) -> "Standard_Boolean":
        """
        * Returns the value of voxel with co-ordinates (ix, iy, iz). Warning!: the returned value may not coincide with the value of its 8 sub-voxels. Use the method ::IsSplit() to check whether a voxel has sub-voxels.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: bool

        * Returns the value of a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split, it returns the value of the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct:
        :type ioct: int
        :rtype: bool

        """
        return _Voxel.Voxel_OctBoolDS_Get(self, *args)


    def IsSplit(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the voxel is split into 8 sub-voxels.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: bool

        """
        return _Voxel.Voxel_OctBoolDS_IsSplit(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_OctBoolDS
Voxel_OctBoolDS.Destroy = new_instancemethod(_Voxel.Voxel_OctBoolDS_Destroy, None, Voxel_OctBoolDS)
Voxel_OctBoolDS.SetZero = new_instancemethod(_Voxel.Voxel_OctBoolDS_SetZero, None, Voxel_OctBoolDS)
Voxel_OctBoolDS.OptimizeMemory = new_instancemethod(_Voxel.Voxel_OctBoolDS_OptimizeMemory, None, Voxel_OctBoolDS)
Voxel_OctBoolDS.Set = new_instancemethod(_Voxel.Voxel_OctBoolDS_Set, None, Voxel_OctBoolDS)
Voxel_OctBoolDS.Get = new_instancemethod(_Voxel.Voxel_OctBoolDS_Get, None, Voxel_OctBoolDS)
Voxel_OctBoolDS.IsSplit = new_instancemethod(_Voxel.Voxel_OctBoolDS_IsSplit, None, Voxel_OctBoolDS)
Voxel_OctBoolDS_swigregister = _Voxel.Voxel_OctBoolDS_swigregister
Voxel_OctBoolDS_swigregister(Voxel_OctBoolDS)

class Voxel_ROctBoolDS(Voxel_DS):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * An empty constructor.

        :rtype: None

        * A constructor initializing the voxel model. (x, y, z) - the start point of the box. (x_len, y_len, z_len) - lengths in x, y and z directions along axes of a co-ordinate system. (nb_x, nb_y, nb_z) - number of splits (voxels) along x, y and z directions.

        :param x:
        :type x: float
        :param y:
        :type y: float
        :param z:
        :type z: float
        :param x_len:
        :type x_len: float
        :param y_len:
        :type y_len: float
        :param z_len:
        :type z_len: float
        :param nb_x:
        :type nb_x: int
        :param nb_y:
        :type nb_y: int
        :param nb_z:
        :type nb_z: int
        :rtype: None

        """
        _Voxel.Voxel_ROctBoolDS_swiginit(self, _Voxel.new_Voxel_ROctBoolDS(*args))

    def Destroy(self, *args) -> "void":
        """
        * A destructor of the voxel model.

        :rtype: None

        """
        return _Voxel.Voxel_ROctBoolDS_Destroy(self, *args)


    def SetZero(self, *args) -> "void":
        """
        * The method sets all values equal to 0 (false) and releases the memory.

        :rtype: None

        """
        return _Voxel.Voxel_ROctBoolDS_SetZero(self, *args)


    def OptimizeMemory(self, *args) -> "void":
        """
        * The method searches voxels with equal-value of sub-voxels and removes them (remaining the value for the voxel).

        :rtype: None

        """
        return _Voxel.Voxel_ROctBoolDS_OptimizeMemory(self, *args)


    def Set(self, *args) -> "void":
        """
        * Defines a value for voxel with co-ordinates (ix, iy, iz). If the voxel is split into 8 sub-voxels, the split disappears. Initial state of the model is so that all voxels have value 0 (false), and this data doesn't occupy memory. Memory for data is allocating during setting non-zero values (true).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param data:
        :type data: bool
        :rtype: None

        * Defines a value for a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split into 8 sub-voxels yet, this method splits the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct1:
        :type ioct1: int
        :param data:
        :type data: bool
        :rtype: None

        * Defines a value for a sub-voxel of a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split into 8 sub-voxels yet, this method splits the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct1:
        :type ioct1: int
        :param ioct2:
        :type ioct2: int
        :param data:
        :type data: bool
        :rtype: None

        """
        return _Voxel.Voxel_ROctBoolDS_Set(self, *args)


    def IsSplit(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the voxel is split into 8 sub-voxels.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: bool

        """
        return _Voxel.Voxel_ROctBoolDS_IsSplit(self, *args)


    def Deepness(self, *args) -> "Standard_Integer":
        """
        * Returns the deepness of splits of a voxel. 0 - no splits (::IsSplit() being called would return false). 1 - the voxel is split into 8 sub-voxels. 2 - the voxels is split into 8 sub-voxels, and each of the sub-voxels is split into 8 sub-sub-voxels. 3 - ...

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: int

        """
        return _Voxel.Voxel_ROctBoolDS_Deepness(self, *args)


    def Get(self, *args) -> "Standard_Boolean":
        """
        * Returns the value of voxel with co-ordinates (ix, iy, iz). Warning!: the returned value may not coincide with the value of its 8 sub-voxels. Use the method ::IsSplit() to check whether a voxel has sub-voxels.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :rtype: bool

        * Returns the value of a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split, it returns the value of the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct1:
        :type ioct1: int
        :rtype: bool

        * Returns the value of a sub-voxel of a sub-voxel of a voxel with co-ordinates (ix, iy, iz). If the voxel is not split, it returns the value of the voxel. Range of sub-voxels is 0 - 7.

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param ioct1:
        :type ioct1: int
        :param ioct2:
        :type ioct2: int
        :rtype: bool

        """
        return _Voxel.Voxel_ROctBoolDS_Get(self, *args)


    def GetCenter(self, *args) -> "void":
        """
        * Returns the center point of a sub-voxel with co-ordinates (ix, iy, iz, i).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param i:
        :type i: int
        :param xc:
        :type xc: float &
        :param yc:
        :type yc: float &
        :param zc:
        :type zc: float &
        :rtype: None

        * Returns the center point of a sub-voxel with co-ordinates (ix, iy, iz, i, j).

        :param ix:
        :type ix: int
        :param iy:
        :type iy: int
        :param iz:
        :type iz: int
        :param i:
        :type i: int
        :param j:
        :type j: int
        :param xc:
        :type xc: float &
        :param yc:
        :type yc: float &
        :param zc:
        :type zc: float &
        :rtype: None

        """
        return _Voxel.Voxel_ROctBoolDS_GetCenter(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _Voxel.delete_Voxel_ROctBoolDS
Voxel_ROctBoolDS.Destroy = new_instancemethod(_Voxel.Voxel_ROctBoolDS_Destroy, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.SetZero = new_instancemethod(_Voxel.Voxel_ROctBoolDS_SetZero, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.OptimizeMemory = new_instancemethod(_Voxel.Voxel_ROctBoolDS_OptimizeMemory, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.Set = new_instancemethod(_Voxel.Voxel_ROctBoolDS_Set, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.IsSplit = new_instancemethod(_Voxel.Voxel_ROctBoolDS_IsSplit, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.Deepness = new_instancemethod(_Voxel.Voxel_ROctBoolDS_Deepness, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.Get = new_instancemethod(_Voxel.Voxel_ROctBoolDS_Get, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS.GetCenter = new_instancemethod(_Voxel.Voxel_ROctBoolDS_GetCenter, None, Voxel_ROctBoolDS)
Voxel_ROctBoolDS_swigregister = _Voxel.Voxel_ROctBoolDS_swigregister
Voxel_ROctBoolDS_swigregister(Voxel_ROctBoolDS)



