# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
The BRepBuilderAPI package  provides an  Application
Programming Interface for the BRep topology data
structure.

The API is a set of classes aiming to provide :

* High level and simple calls for the most common
operations.

*  Keeping  an  access on  the  low-level
implementation of high-level calls.

* Examples of programming of high-level operations
from low-level operations.

* A complete coverage of modelling :

- Creating vertices ,edges, faces, solids.

- Sweeping operations.

- Boolean operations.

- Global properties computation.


The API provides classes to build objects:

* The constructors of the classes provides the
different constructions methods.

* The class keeps as fields the  different tools
used to build the object.

*  The class provides a casting method to get
automatically the result with a  function-like
call.

For example to make a vertex <V> from a point <P>
one can writes :

V = BRepBuilderAPI_MakeVertex(P);

or

BRepBuilderAPI_MakeVertex MV(P);
V = MV.Vertex();


For tolerances a default precision is used which
can  be  changed  by  the  packahe method
BRepBuilderAPI::Precision.

For error handling the BRepBuilderAPI commands raise only
the NotDone error. When Done is false on a command
the error description can be asked to the command.

In theory the comands can be  called with any
arguments, argument checking is performed by the
command.



"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _BRepPrimAPI.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_BRepPrimAPI')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_BRepPrimAPI')
    _BRepPrimAPI = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_BRepPrimAPI', [dirname(__file__)])
        except ImportError:
            import _BRepPrimAPI
            return _BRepPrimAPI
        try:
            _mod = imp.load_module('_BRepPrimAPI', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _BRepPrimAPI = swig_import_helper()
    del swig_import_helper
else:
    import _BRepPrimAPI
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepPrimAPI.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_BRepPrimAPI.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_BRepPrimAPI.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_BRepPrimAPI.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_BRepPrimAPI.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_BRepPrimAPI.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_BRepPrimAPI.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_BRepPrimAPI.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_BRepPrimAPI.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_BRepPrimAPI.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_BRepPrimAPI.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _BRepPrimAPI.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _BRepPrimAPI.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.BRepBuilderAPI
import OCC.Core.Geom
import OCC.Core.MMgt
import OCC.Core.Standard
import OCC.Core.gp
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TColStd
import OCC.Core.TopoDS
import OCC.Core.TopLoc
import OCC.Core.TopAbs
import OCC.Core.TopTools
import OCC.Core.Message
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.NCollection
import OCC.Core.TShort
import OCC.Core.Geom2d
import OCC.Core.BRepPrim
import OCC.Core.BRepSweep
import OCC.Core.Sweep
import OCC.Core.Quantity
class BRepPrimAPI_MakeBox(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a box with a corner at 0,0,0 and the other dx,dy,dz

        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :rtype: None

        * Make a box with a corner at P and size dx, dy, dz.

        :param P:
        :type P: gp_Pnt
        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :rtype: None

        * Make a box with corners P1,P2.

        :param P1:
        :type P1: gp_Pnt
        :param P2:
        :type P2: gp_Pnt
        :rtype: None

        * Ax2 is the left corner and the axis. Constructs a box such that its sides are parallel to the axes of - the global coordinate system, or - the local coordinate system Axis. and - with a corner at (0, 0, 0) and of size (dx, dy, dz), or - with a corner at point P and of size (dx, dy, dz), or - with corners at points P1 and P2. Exceptions Standard_DomainError if: dx, dy, dz are less than or equal to Precision::Confusion(), or - the vector joining the points P1 and P2 has a component projected onto the global coordinate system less than or equal to Precision::Confusion(). In these cases, the box would be flat.

        :param Axes:
        :type Axes: gp_Ax2
        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeBox_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeBox(*args))

    def Wedge(self, *args) -> "BRepPrim_Wedge &":
        """
        * Returns the internal algorithm.

        :rtype: BRepPrim_Wedge

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Wedge(self, *args)


    def Shell(self, *args) -> "TopoDS_Shell const":
        """
        * Returns the constructed box as a shell.

        :rtype: TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Shell(self, *args)


    def Solid(self, *args) -> "TopoDS_Solid const":
        """
        * Returns the constructed box as a solid.

        :rtype: TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_Solid(self, *args)


    def BottomFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns ZMin face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_BottomFace(self, *args)


    def BackFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns XMin face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_BackFace(self, *args)


    def FrontFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns XMax face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_FrontFace(self, *args)


    def LeftFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns YMin face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_LeftFace(self, *args)


    def RightFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns YMax face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_RightFace(self, *args)


    def TopFace(self, *args) -> "TopoDS_Face const":
        """
        * Returns ZMax face

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeBox_TopFace(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeBox
BRepPrimAPI_MakeBox.Wedge = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_Wedge, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.Shell = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_Shell, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.Solid = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_Solid, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.BottomFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_BottomFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.BackFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_BackFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.FrontFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_FrontFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.LeftFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_LeftFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.RightFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_RightFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox.TopFace = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeBox_TopFace, None, BRepPrimAPI_MakeBox)
BRepPrimAPI_MakeBox_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeBox_swigregister
BRepPrimAPI_MakeBox_swigregister(BRepPrimAPI_MakeBox)

class BRepPrimAPI_MakeHalfSpace(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a HalfSpace defined with a Face and a Point.

        :param Face:
        :type Face: TopoDS_Face &
        :param RefPnt:
        :type RefPnt: gp_Pnt
        :rtype: None

        * Make a HalfSpace defined with a Shell and a Point.

        :param Shell:
        :type Shell: TopoDS_Shell &
        :param RefPnt:
        :type RefPnt: gp_Pnt
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeHalfSpace(*args))

    def Solid(self, *args) -> "TopoDS_Solid const":
        """
        * Returns the constructed half-space as a solid.

        :rtype: TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_Solid(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeHalfSpace
BRepPrimAPI_MakeHalfSpace.Solid = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_Solid, None, BRepPrimAPI_MakeHalfSpace)
BRepPrimAPI_MakeHalfSpace_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeHalfSpace_swigregister
BRepPrimAPI_MakeHalfSpace_swigregister(BRepPrimAPI_MakeHalfSpace)

class BRepPrimAPI_MakeOneAxis(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def OneAxis(self, *args) -> "Standard_Address":
        """
        * The inherited commands should provide the algorithm. Returned as a pointer.

        :rtype: Standard_Address

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_OneAxis(self, *args)


    def Face(self, *args) -> "TopoDS_Face const":
        """
        * Returns the lateral face of the rotational primitive.

        :rtype: TopoDS_Face

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Face(self, *args)


    def Shell(self, *args) -> "TopoDS_Shell const":
        """
        * Returns the constructed rotational primitive as a shell.

        :rtype: TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Shell(self, *args)


    def Solid(self, *args) -> "TopoDS_Solid const":
        """
        * Returns the constructed rotational primitive as a solid.

        :rtype: TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Solid(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeOneAxis
BRepPrimAPI_MakeOneAxis.OneAxis = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeOneAxis_OneAxis, None, BRepPrimAPI_MakeOneAxis)
BRepPrimAPI_MakeOneAxis.Face = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Face, None, BRepPrimAPI_MakeOneAxis)
BRepPrimAPI_MakeOneAxis.Shell = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Shell, None, BRepPrimAPI_MakeOneAxis)
BRepPrimAPI_MakeOneAxis.Solid = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeOneAxis_Solid, None, BRepPrimAPI_MakeOneAxis)
BRepPrimAPI_MakeOneAxis_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeOneAxis_swigregister
BRepPrimAPI_MakeOneAxis_swigregister(BRepPrimAPI_MakeOneAxis)

class BRepPrimAPI_MakeSweep(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def FirstShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the TopoDS Shape of the bottom of the sweep.

        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSweep_FirstShape(self, *args)


    def LastShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the TopoDS Shape of the top of the sweep.

        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSweep_LastShape(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeSweep
BRepPrimAPI_MakeSweep.FirstShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeSweep_FirstShape, None, BRepPrimAPI_MakeSweep)
BRepPrimAPI_MakeSweep.LastShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeSweep_LastShape, None, BRepPrimAPI_MakeSweep)
BRepPrimAPI_MakeSweep_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeSweep_swigregister
BRepPrimAPI_MakeSweep_swigregister(BRepPrimAPI_MakeSweep)

class BRepPrimAPI_MakeWedge(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a STEP right angular wedge. (ltx >= 0)

        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :param ltx:
        :type ltx: float
        :rtype: None

        * Make a STEP right angular wedge. (ltx >= 0)

        :param Axes:
        :type Axes: gp_Ax2
        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :param ltx:
        :type ltx: float
        :rtype: None

        * Make a wedge. The face at dy is xmin,zmin xmax,zmax

        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :param xmin:
        :type xmin: float
        :param zmin:
        :type zmin: float
        :param xmax:
        :type xmax: float
        :param zmax:
        :type zmax: float
        :rtype: None

        * Make a wedge. The face at dy is xmin,zmin xmax,zmax

        :param Axes:
        :type Axes: gp_Ax2
        :param dx:
        :type dx: float
        :param dy:
        :type dy: float
        :param dz:
        :type dz: float
        :param xmin:
        :type xmin: float
        :param zmin:
        :type zmin: float
        :param xmax:
        :type xmax: float
        :param zmax:
        :type zmax: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeWedge_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeWedge(*args))

    def Wedge(self, *args) -> "BRepPrim_Wedge &":
        """
        * Returns the internal algorithm.

        :rtype: BRepPrim_Wedge

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Wedge(self, *args)


    def Shell(self, *args) -> "TopoDS_Shell const":
        """
        * Returns the constructed box in the form of a shell.

        :rtype: TopoDS_Shell

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Shell(self, *args)


    def Solid(self, *args) -> "TopoDS_Solid const":
        """
        * Returns the constructed box in the form of a solid.

        :rtype: TopoDS_Solid

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeWedge_Solid(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeWedge
BRepPrimAPI_MakeWedge.Wedge = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeWedge_Wedge, None, BRepPrimAPI_MakeWedge)
BRepPrimAPI_MakeWedge.Shell = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeWedge_Shell, None, BRepPrimAPI_MakeWedge)
BRepPrimAPI_MakeWedge.Solid = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeWedge_Solid, None, BRepPrimAPI_MakeWedge)
BRepPrimAPI_MakeWedge_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeWedge_swigregister
BRepPrimAPI_MakeWedge_swigregister(BRepPrimAPI_MakeWedge)

class BRepPrimAPI_MakeCone(BRepPrimAPI_MakeOneAxis):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a cone of height H radius R1 in the plane z = 0, R2 in the plane Z = H. R1 and R2 may be null.

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param H:
        :type H: float
        :rtype: None

        * Make a cone of height H radius R1 in the plane z = 0, R2 in the plane Z = H. R1 and R2 may be null. Take a section of <angle>

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param H:
        :type H: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a cone of height H radius R1 in the plane z = 0, R2 in the plane Z = H. R1 and R2 may be null.

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param H:
        :type H: float
        :rtype: None

        * Make a cone of height H radius R1 in the plane z = 0, R2 in the plane Z = H. R1 and R2 may be null. Take a section of <angle> Constructs a cone, or a portion of a cone, of height H, and radius R1 in the plane z = 0 and R2 in the plane z = H. The result is a sharp cone if R1 or R2 is equal to 0. The cone is constructed about the 'Z Axis' of either: - the global coordinate system, or - the local coordinate system Axes. It is limited in these coordinate systems as follows: - in the v parametric direction (the Z coordinate), by the two parameter values 0 and H, - and in the u parametric direction (defined by the angle of rotation around the Z axis), in the case of a portion of a cone, by the two parameter values 0 and angle. Angle is given in radians. The resulting shape is composed of: - a lateral conical face - two planar faces in the planes z = 0 and z = H, or only one planar face in one of these two planes if a radius value is null (in the case of a complete cone, these faces are circles), and - and in the case of a portion of a cone, two planar faces to close the shape. (either two parallelograms or two triangles, in the planes u = 0 and u = angle). Exceptions Standard_DomainError if: - H is less than or equal to Precision::Confusion(), or - the half-angle at the apex of the cone, defined by R1, R2 and H, is less than Precision::Confusion()/H, or greater than (Pi/2)-Precision::Confusion()/H.f

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param H:
        :type H: float
        :param angle:
        :type angle: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeCone_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeCone(*args))

    def Cone(self, *args) -> "BRepPrim_Cone &":
        """
        * Missing detailed docstring.

        :rtype: BRepPrim_Cone

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeCone_Cone(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeCone
BRepPrimAPI_MakeCone.Cone = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeCone_Cone, None, BRepPrimAPI_MakeCone)
BRepPrimAPI_MakeCone_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeCone_swigregister
BRepPrimAPI_MakeCone_swigregister(BRepPrimAPI_MakeCone)

class BRepPrimAPI_MakeCylinder(BRepPrimAPI_MakeOneAxis):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a cylinder of radius R and length H.

        :param R:
        :type R: float
        :param H:
        :type H: float
        :rtype: None

        * Make a cylinder of radius R and length H with angle H.

        :param R:
        :type R: float
        :param H:
        :type H: float
        :param Angle:
        :type Angle: float
        :rtype: None

        * Make a cylinder of radius R and length H.

        :param Axes:
        :type Axes: gp_Ax2
        :param R:
        :type R: float
        :param H:
        :type H: float
        :rtype: None

        * Make a cylinder of radius R and length H with angle H. Constructs - a cylinder of radius R and height H, or - a portion of cylinder of radius R and height H, and of the angle Angle defining the missing portion of the cylinder. The cylinder is constructed about the 'Z Axis' of either: - the global coordinate system, or - the local coordinate system Axes. It is limited in this coordinate system as follows: - in the v parametric direction (the Z axis), by the two parameter values 0 and H, - and in the u parametric direction (the rotation angle around the Z Axis), in the case of a portion of a cylinder, by the two parameter values 0 and Angle. Angle is given in radians. The resulting shape is composed of: - a lateral cylindrical face, - two planar faces in the planes z = 0 and z = H (in the case of a complete cylinder, these faces are circles), and - in case of a portion of a cylinder, two additional planar faces to close the shape.(two rectangles in the planes u = 0 and u = Angle). Exceptions Standard_DomainError if: - R is less than or equal to Precision::Confusion(), or - H is less than or equal to Precision::Confusion().

        :param Axes:
        :type Axes: gp_Ax2
        :param R:
        :type R: float
        :param H:
        :type H: float
        :param Angle:
        :type Angle: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeCylinder_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeCylinder(*args))

    def Cylinder(self, *args) -> "BRepPrim_Cylinder &":
        """
        * Missing detailed docstring.

        :rtype: BRepPrim_Cylinder

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeCylinder_Cylinder(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeCylinder
BRepPrimAPI_MakeCylinder.Cylinder = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeCylinder_Cylinder, None, BRepPrimAPI_MakeCylinder)
BRepPrimAPI_MakeCylinder_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeCylinder_swigregister
BRepPrimAPI_MakeCylinder_swigregister(BRepPrimAPI_MakeCylinder)

class BRepPrimAPI_MakePrism(BRepPrimAPI_MakeSweep):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Builds the prism of base S and vector V. If C is true, S is copied. If Canonize is true then generated surfaces are attempted to be canonized in simple types

        :param S:
        :type S: TopoDS_Shape &
        :param V:
        :type V: gp_Vec
        :param Copy: default value is Standard_False
        :type Copy: bool
        :param Canonize: default value is Standard_True
        :type Canonize: bool
        :rtype: None

        * Builds a semi-infinite or an infinite prism of base S. If Inf is true the prism is infinite, if Inf is false the prism is semi-infinite (in the direction D). If C is true S is copied (for semi-infinite prisms). If Canonize is true then generated surfaces are attempted to be canonized in simple types

        :param S:
        :type S: TopoDS_Shape &
        :param D:
        :type D: gp_Dir
        :param Inf: default value is Standard_True
        :type Inf: bool
        :param Copy: default value is Standard_False
        :type Copy: bool
        :param Canonize: default value is Standard_True
        :type Canonize: bool
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakePrism_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakePrism(*args))

    def Prism(self, *args) -> "BRepSweep_Prism const &":
        """
        * Returns the internal sweeping algorithm.

        :rtype: BRepSweep_Prism

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_Prism(self, *args)


    def FirstShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the TopoDS Shape of the bottom of the prism.

        :rtype: TopoDS_Shape

        * Returns the TopoDS Shape of the bottom of the prism. generated with theShape (subShape of the generating shape).

        :param theShape:
        :type theShape: TopoDS_Shape &
        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_FirstShape(self, *args)


    def LastShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the TopoDS Shape of the top of the prism. In the case of a finite prism, FirstShape returns the basis of the prism, in other words, S if Copy is false; otherwise, the copy of S belonging to the prism. LastShape returns the copy of S translated by V at the time of construction.

        :rtype: TopoDS_Shape

        * Returns the TopoDS Shape of the top of the prism. generated with theShape (subShape of the generating shape).

        :param theShape:
        :type theShape: TopoDS_Shape &
        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakePrism_LastShape(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakePrism
BRepPrimAPI_MakePrism.Prism = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakePrism_Prism, None, BRepPrimAPI_MakePrism)
BRepPrimAPI_MakePrism.FirstShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakePrism_FirstShape, None, BRepPrimAPI_MakePrism)
BRepPrimAPI_MakePrism.LastShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakePrism_LastShape, None, BRepPrimAPI_MakePrism)
BRepPrimAPI_MakePrism_swigregister = _BRepPrimAPI.BRepPrimAPI_MakePrism_swigregister
BRepPrimAPI_MakePrism_swigregister(BRepPrimAPI_MakePrism)

class BRepPrimAPI_MakeRevol(BRepPrimAPI_MakeSweep):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Builds the Revol of base S, axis A and angle D. If C is true, S is copied.

        :param S:
        :type S: TopoDS_Shape &
        :param A:
        :type A: gp_Ax1
        :param D:
        :type D: float
        :param Copy: default value is Standard_False
        :type Copy: bool
        :rtype: None

        * Builds the Revol of base S, axis A and angle 2*Pi. If C is true, S is copied.

        :param S:
        :type S: TopoDS_Shape &
        :param A:
        :type A: gp_Ax1
        :param Copy: default value is Standard_False
        :type Copy: bool
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeRevol_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeRevol(*args))

    def Revol(self, *args) -> "BRepSweep_Revol const &":
        """
        * Returns the internal sweeping algorithm.

        :rtype: BRepSweep_Revol

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_Revol(self, *args)


    def FirstShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the first shape of the revol (coinciding with the generating shape).

        :rtype: TopoDS_Shape

        * Returns the TopoDS Shape of the beginning of the revolution, generated with theShape (subShape of the generating shape).

        :param theShape:
        :type theShape: TopoDS_Shape &
        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_FirstShape(self, *args)


    def LastShape(self, *args) -> "TopoDS_Shape":
        """
        * Returns the TopoDS Shape of the end of the revol.

        :rtype: TopoDS_Shape

        * Returns the TopoDS Shape of the end of the revolution, generated with theShape (subShape of the generating shape).

        :param theShape:
        :type theShape: TopoDS_Shape &
        :rtype: TopoDS_Shape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_LastShape(self, *args)


    def HasDegenerated(self, *args) -> "Standard_Boolean":
        """
        * Check if there are degenerated edges in the result.

        :rtype: bool

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_HasDegenerated(self, *args)


    def Degenerated(self, *args) -> "TopTools_ListOfShape const &":
        """
        :rtype: TopTools_ListOfShape

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevol_Degenerated(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeRevol
BRepPrimAPI_MakeRevol.Revol = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevol_Revol, None, BRepPrimAPI_MakeRevol)
BRepPrimAPI_MakeRevol.FirstShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevol_FirstShape, None, BRepPrimAPI_MakeRevol)
BRepPrimAPI_MakeRevol.LastShape = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevol_LastShape, None, BRepPrimAPI_MakeRevol)
BRepPrimAPI_MakeRevol.HasDegenerated = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevol_HasDegenerated, None, BRepPrimAPI_MakeRevol)
BRepPrimAPI_MakeRevol.Degenerated = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevol_Degenerated, None, BRepPrimAPI_MakeRevol)
BRepPrimAPI_MakeRevol_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeRevol_swigregister
BRepPrimAPI_MakeRevol_swigregister(BRepPrimAPI_MakeRevol)

class BRepPrimAPI_MakeRevolution(BRepPrimAPI_MakeOneAxis):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a revolution body by rotating a curve around Z.

        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param angle:
        :type angle: float
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param VMin:
        :type VMin: float
        :param VMax:
        :type VMax: float
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param VMin:
        :type VMin: float
        :param VMax:
        :type VMax: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Axes:
        :type Axes: gp_Ax2
        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Axes:
        :type Axes: gp_Ax2
        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param angle:
        :type angle: float
        :rtype: None

        * Make a revolution body by rotating a curve around Z.

        :param Axes:
        :type Axes: gp_Ax2
        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param VMin:
        :type VMin: float
        :param VMax:
        :type VMax: float
        :rtype: None

        * Make a revolution body by rotating a curve around Z. For all algorithms the resulting shape is composed of - a lateral revolved face, - two planar faces in planes parallel to the plane z = 0, and passing by the extremities of the revolved portion of Meridian, if these points are not on the Z axis (in case of a complete revolved shape, these faces are circles), - and in the case of a portion of a revolved shape, two planar faces to close the shape (in the planes u = 0 and u = angle).

        :param Axes:
        :type Axes: gp_Ax2
        :param Meridian:
        :type Meridian: Handle_Geom_Curve &
        :param VMin:
        :type VMin: float
        :param VMax:
        :type VMax: float
        :param angle:
        :type angle: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeRevolution_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeRevolution(*args))

    def Revolution(self, *args) -> "BRepPrim_Revolution &":
        """
        * Missing detailed docstring.

        :rtype: BRepPrim_Revolution

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeRevolution_Revolution(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeRevolution
BRepPrimAPI_MakeRevolution.Revolution = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeRevolution_Revolution, None, BRepPrimAPI_MakeRevolution)
BRepPrimAPI_MakeRevolution_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeRevolution_swigregister
BRepPrimAPI_MakeRevolution_swigregister(BRepPrimAPI_MakeRevolution)

class BRepPrimAPI_MakeSphere(BRepPrimAPI_MakeOneAxis):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a sphere of radius R.

        :param R:
        :type R: float
        :rtype: None

        * Make a sphere of radius R.

        :param R:
        :type R: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a sphere of radius R.

        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :rtype: None

        * Make a sphere of radius R.

        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :param angle3:
        :type angle3: float
        :rtype: None

        * Make a sphere of radius R.

        :param Center:
        :type Center: gp_Pnt
        :param R:
        :type R: float
        :rtype: None

        * Make a sphere of radius R.

        :param Center:
        :type Center: gp_Pnt
        :param R:
        :type R: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a sphere of radius R.

        :param Center:
        :type Center: gp_Pnt
        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :rtype: None

        * Make a sphere of radius R.

        :param Center:
        :type Center: gp_Pnt
        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :param angle3:
        :type angle3: float
        :rtype: None

        * Make a sphere of radius R.

        :param Axis:
        :type Axis: gp_Ax2
        :param R:
        :type R: float
        :rtype: None

        * Make a sphere of radius R.

        :param Axis:
        :type Axis: gp_Ax2
        :param R:
        :type R: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a sphere of radius R.

        :param Axis:
        :type Axis: gp_Ax2
        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :rtype: None

        * Make a sphere of radius R. For all algorithms The resulting shape is composed of - a lateral spherical face, - two planar faces parallel to the plane z = 0 if the sphere is truncated in the v parametric direction, or only one planar face if angle1 is equal to -p/2 or if angle2 is equal to p/2 (these faces are circles in case of a complete truncated sphere), - and in case of a portion of sphere, two planar faces to shut the shape.(in the planes u = 0 and u = angle).

        :param Axis:
        :type Axis: gp_Ax2
        :param R:
        :type R: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :param angle3:
        :type angle3: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeSphere_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeSphere(*args))

    def Sphere(self, *args) -> "BRepPrim_Sphere &":
        """
        * Missing detailed docstring.

        :rtype: BRepPrim_Sphere

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeSphere_Sphere(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeSphere
BRepPrimAPI_MakeSphere.Sphere = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeSphere_Sphere, None, BRepPrimAPI_MakeSphere)
BRepPrimAPI_MakeSphere_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeSphere_swigregister
BRepPrimAPI_MakeSphere_swigregister(BRepPrimAPI_MakeSphere)

class BRepPrimAPI_MakeTorus(BRepPrimAPI_MakeOneAxis):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Make a torus of radii R1 R2.

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :rtype: None

        * Make a section of a torus of radii R1 R2.

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a torus of radii R2, R2 with angles on the small circle.

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :rtype: None

        * Make a torus of radii R2, R2 with angles on the small circle.

        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a torus of radii R1 R2.

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :rtype: None

        * Make a section of a torus of radii R1 R2.

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle:
        :type angle: float
        :rtype: None

        * Make a torus of radii R1 R2.

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :rtype: None

        * Make a section of a torus of radii R1 R2. For all algorithms The resulting shape is composed of - a lateral toroidal face, - two conical faces (defined by the equation v = angle1 and v = angle2) if the sphere is truncated in the v parametric direction (they may be cylindrical faces in some particular conditions), and in case of a portion of torus, two planar faces to close the shape.(in the planes u = 0 and u = angle). Notes: - The u parameter corresponds to a rotation angle around the Z axis. - The circle whose radius is equal to the minor radius, located in the plane defined by the X axis and the Z axis, centered on the X axis, on its positive side, and positioned at a distance from the origin equal to the major radius, is the reference circle of the torus. The rotation around an axis parallel to the Y axis and passing through the center of the reference circle gives the v parameter on the reference circle. The X axis gives the origin of the v parameter. Near 0, as v increases, the Z coordinate decreases.

        :param Axes:
        :type Axes: gp_Ax2
        :param R1:
        :type R1: float
        :param R2:
        :type R2: float
        :param angle1:
        :type angle1: float
        :param angle2:
        :type angle2: float
        :param angle:
        :type angle: float
        :rtype: None

        """
        _BRepPrimAPI.BRepPrimAPI_MakeTorus_swiginit(self, _BRepPrimAPI.new_BRepPrimAPI_MakeTorus(*args))

    def Torus(self, *args) -> "BRepPrim_Torus &":
        """
        * Missing detailed docstring.

        :rtype: BRepPrim_Torus

        """
        return _BRepPrimAPI.BRepPrimAPI_MakeTorus_Torus(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepPrimAPI.delete_BRepPrimAPI_MakeTorus
BRepPrimAPI_MakeTorus.Torus = new_instancemethod(_BRepPrimAPI.BRepPrimAPI_MakeTorus_Torus, None, BRepPrimAPI_MakeTorus)
BRepPrimAPI_MakeTorus_swigregister = _BRepPrimAPI.BRepPrimAPI_MakeTorus_swigregister
BRepPrimAPI_MakeTorus_swigregister(BRepPrimAPI_MakeTorus)



