# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
- Purpose: Provides functions for basic geometric computations on
elementary curves such as conics and lines in 2D and 3D space.
This includes:
-  calculation of a point or derived vector on a 2D or
3D curve where:
-  the curve is provided by the gp package, or
defined in reference form (as in the gp package),
and
-  the point is defined by a parameter,
-  evaluation of the parameter corresponding to a point
on a 2D or 3D curve from gp,
-  various elementary computations which allow you to
position parameterized values within the period of a curve.
Notes:
-  ElCLib stands for Elementary Curves Library.
-  If the curves provided by the gp package are not
explicitly parameterized, they still have an implicit
parameterization, analogous to that which they infer
for the equivalent Geom or Geom2d curves.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _ElCLib.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_ElCLib')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_ElCLib')
    _ElCLib = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_ElCLib', [dirname(__file__)])
        except ImportError:
            import _ElCLib
            return _ElCLib
        try:
            _mod = imp.load_module('_ElCLib', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _ElCLib = swig_import_helper()
    del swig_import_helper
else:
    import _ElCLib
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ElCLib.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_ElCLib.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_ElCLib.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_ElCLib.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_ElCLib.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_ElCLib.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_ElCLib.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_ElCLib.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_ElCLib.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_ElCLib.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_ElCLib.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_ElCLib.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_ElCLib.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_ElCLib.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_ElCLib.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_ElCLib.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_ElCLib.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _ElCLib.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _ElCLib.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.gp
class elclib(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def InPeriod(*args) -> "Standard_Real":
        """
        * Return a value in the range <UFirst, ULast> by adding or removing the period <ULast - UFirst> to <U>.

        :param U:
        :type U: float
        :param UFirst:
        :type UFirst: float
        :param ULast:
        :type ULast: float
        :rtype: float

        """
        return _ElCLib.elclib_InPeriod(*args)

    InPeriod = staticmethod(InPeriod)

    def AdjustPeriodic(*args) -> "Standard_Real &, Standard_Real &":
        """
        * Adjust U1 and U2 in the parametric range UFirst Ulast of a periodic curve, where ULast - UFirst is its period. To do this, this function: - sets U1 in the range [ UFirst, ULast ] by adding/removing the period to/from the value U1, then - sets U2 in the range [ U1, U1 + period ] by adding/removing the period to/from the value U2. Precision is used to test the equalities.

        :param UFirst:
        :type UFirst: float
        :param ULast:
        :type ULast: float
        :param Precision:
        :type Precision: float
        :param U1:
        :type U1: float &
        :param U2:
        :type U2: float &
        :rtype: void

        """
        return _ElCLib.elclib_AdjustPeriodic(*args)

    AdjustPeriodic = staticmethod(AdjustPeriodic)

    def Value(*args) -> "gp_Pnt2d":
        """
        * For elementary curves (lines, circles and conics) from the gp package, computes the point of parameter U. The result is either: - a gp_Pnt point for a curve in 3D space, or - a gp_Pnt2d point for a curve in 2D space.

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin2d
        :rtype: gp_Pnt2d

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ2d
        :rtype: gp_Pnt2d

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips2d
        :rtype: gp_Pnt2d

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr2d
        :rtype: gp_Pnt2d

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab2d
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_Value(*args)

    Value = staticmethod(Value)

    def D1(*args) -> "void":
        """
        * For elementary curves (lines, circles and conics) from the gp package, computes: - the point P of parameter U, and - the first derivative vector V1 at this point. The results P and V1 are either: - a gp_Pnt point and a gp_Vec vector, for a curve in 3D space, or - a gp_Pnt2d point and a gp_Vec2d vector, for a curve in 2D space.

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_D1(*args)

    D1 = staticmethod(D1)

    def D2(*args) -> "void":
        """
        * For elementary curves (circles and conics) from the gp package, computes: - the point P of parameter U, and - the first and second derivative vectors V1 and V2 at this point. The results, P, V1 and V2, are either: - a gp_Pnt point and two gp_Vec vectors, for a curve in 3D space, or - a gp_Pnt2d point and two gp_Vec2d vectors, for a curve in 2D space.

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_D2(*args)

    D2 = staticmethod(D2)

    def D3(*args) -> "void":
        """
        * For elementary curves (circles, ellipses and hyperbolae) from the gp package, computes: - the point P of parameter U, and - the first, second and third derivative vectors V1, V2 and V3 at this point. The results, P, V1, V2 and V3, are either: - a gp_Pnt point and three gp_Vec vectors, for a curve in 3D space, or - a gp_Pnt2d point and three gp_Vec2d vectors, for a curve in 2D space.

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        * In the following functions N is the order of derivation and should be greater than 0

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_D3(*args)

    D3 = staticmethod(D3)

    def DN(*args) -> "gp_Vec2d":
        """
        * For elementary curves (lines, circles and conics) from the gp package, computes the vector corresponding to the Nth derivative at the point of parameter U. The result is either: - a gp_Vec vector for a curve in 3D space, or - a gp_Vec2d vector for a curve in 2D space. In the following functions N is the order of derivation and should be greater than 0

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param L:
        :type L: gp_Lin2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        :param U:
        :type U: float
        :param C:
        :type C: gp_Circ2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        :param U:
        :type U: float
        :param E:
        :type E: gp_Elips2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        :param U:
        :type U: float
        :param H:
        :type H: gp_Hypr2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        :param U:
        :type U: float
        :param Prb:
        :type Prb: gp_Parab2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_DN(*args)

    DN = staticmethod(DN)

    def LineValue(*args) -> "gp_Pnt2d":
        """
        * Curve evaluation The following basis functions compute the derivatives on elementary curves defined by their geometric characteristics. These functions can be called without constructing a conic from package gp. They are called by the previous functions. Example : A circle is defined by its position and its radius.

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax1
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2d
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_LineValue(*args)

    LineValue = staticmethod(LineValue)

    def CircleValue(*args) -> "gp_Pnt2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Radius:
        :type Radius: float
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Radius:
        :type Radius: float
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_CircleValue(*args)

    CircleValue = staticmethod(CircleValue)

    def EllipseValue(*args) -> "gp_Pnt2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_EllipseValue(*args)

    EllipseValue = staticmethod(EllipseValue)

    def HyperbolaValue(*args) -> "gp_Pnt2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_HyperbolaValue(*args)

    HyperbolaValue = staticmethod(HyperbolaValue)

    def ParabolaValue(*args) -> "gp_Pnt2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Focal:
        :type Focal: float
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Focal:
        :type Focal: float
        :rtype: gp_Pnt2d

        """
        return _ElCLib.elclib_ParabolaValue(*args)

    ParabolaValue = staticmethod(ParabolaValue)

    def LineD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax1
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2d
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_LineD1(*args)

    LineD1 = staticmethod(LineD1)

    def CircleD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_CircleD1(*args)

    CircleD1 = staticmethod(CircleD1)

    def EllipseD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_EllipseD1(*args)

    EllipseD1 = staticmethod(EllipseD1)

    def HyperbolaD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_HyperbolaD1(*args)

    HyperbolaD1 = staticmethod(HyperbolaD1)

    def ParabolaD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Focal:
        :type Focal: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Focal:
        :type Focal: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_ParabolaD1(*args)

    ParabolaD1 = staticmethod(ParabolaD1)

    def CircleD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_CircleD2(*args)

    CircleD2 = staticmethod(CircleD2)

    def EllipseD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_EllipseD2(*args)

    EllipseD2 = staticmethod(EllipseD2)

    def HyperbolaD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_HyperbolaD2(*args)

    HyperbolaD2 = staticmethod(HyperbolaD2)

    def ParabolaD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Focal:
        :type Focal: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Focal:
        :type Focal: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_ParabolaD2(*args)

    ParabolaD2 = staticmethod(ParabolaD2)

    def CircleD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_CircleD3(*args)

    CircleD3 = staticmethod(CircleD3)

    def EllipseD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_EllipseD3(*args)

    EllipseD3 = staticmethod(EllipseD3)

    def HyperbolaD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :param V2:
        :type V2: gp_Vec
        :param V3:
        :type V3: gp_Vec
        :rtype: void

        * In the following functions N is the order of derivation and should be greater than 0

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :param V2:
        :type V2: gp_Vec2d
        :param V3:
        :type V3: gp_Vec2d
        :rtype: void

        """
        return _ElCLib.elclib_HyperbolaD3(*args)

    HyperbolaD3 = staticmethod(HyperbolaD3)

    def LineDN(*args) -> "gp_Vec2d":
        """
        * In the following functions N is the order of derivation and should be greater than 0

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax1
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2d
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_LineDN(*args)

    LineDN = staticmethod(LineDN)

    def CircleDN(*args) -> "gp_Vec2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Radius:
        :type Radius: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Radius:
        :type Radius: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_CircleDN(*args)

    CircleDN = staticmethod(CircleDN)

    def EllipseDN(*args) -> "gp_Vec2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_EllipseDN(*args)

    EllipseDN = staticmethod(EllipseDN)

    def HyperbolaDN(*args) -> "gp_Vec2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_HyperbolaDN(*args)

    HyperbolaDN = staticmethod(HyperbolaDN)

    def ParabolaDN(*args) -> "gp_Vec2d":
        """
        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax2
        :param Focal:
        :type Focal: float
        :param N:
        :type N: int
        :rtype: gp_Vec

        * The following functions compute the parametric value corresponding to a given point on a elementary curve. The point should be on the curve.

        :param U:
        :type U: float
        :param Pos:
        :type Pos: gp_Ax22d
        :param Focal:
        :type Focal: float
        :param N:
        :type N: int
        :rtype: gp_Vec2d

        """
        return _ElCLib.elclib_ParabolaDN(*args)

    ParabolaDN = staticmethod(ParabolaDN)

    def Parameter(*args) -> "Standard_Real":
        """
        * Computes the parameter value of the point P on the given curve. Note: In its local coordinate system, the parametric equation of the curve is given by the following: - for the line L: P(U) = Po + U*Vo where Po is the origin and Vo the unit vector of its positioning axis. - for the circle C: X(U) = Radius*Cos(U), Y(U) = Radius*Sin(U) - for the ellipse E: X(U) = MajorRadius*Cos(U). Y(U) = MinorRadius*Sin(U) - for the hyperbola H: X(U) = MajorRadius*Ch(U), Y(U) = MinorRadius*Sh(U) - for the parabola Prb: X(U) = U**2 / (2*p) Y(U) = U where p is the distance between the focus and the directrix. Warning The point P must be on the curve. These functions are not protected, however, and if point P is not on the curve, an exception may be raised.

        :param L:
        :type L: gp_Lin
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization P (U) = L.Location() + U * L.Direction()

        :param L:
        :type L: gp_Lin2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        :param C:
        :type C: gp_Circ
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization In the local coordinate system of the circle X (U) = Radius * Cos (U) Y (U) = Radius * Sin (U)

        :param C:
        :type C: gp_Circ2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        :param E:
        :type E: gp_Elips
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization In the local coordinate system of the Ellipse X (U) = MajorRadius * Cos (U) Y (U) = MinorRadius * Sin (U)

        :param E:
        :type E: gp_Elips2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        :param H:
        :type H: gp_Hypr
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization In the local coordinate system of the Hyperbola X (U) = MajorRadius * Ch (U) Y (U) = MinorRadius * Sh (U)

        :param H:
        :type H: gp_Hypr2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        :param Prb:
        :type Prb: gp_Parab
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization In the local coordinate system of the parabola Y**2 = (2*P) * X where P is the distance between the focus and the directrix.

        :param Prb:
        :type Prb: gp_Parab2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_Parameter(*args)

    Parameter = staticmethod(Parameter)

    def LineParameter(*args) -> "Standard_Real":
        """
        :param Pos:
        :type Pos: gp_Ax1
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * parametrization P (U) = L.Location() + U * L.Direction()

        :param Pos:
        :type Pos: gp_Ax2d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_LineParameter(*args)

    LineParameter = staticmethod(LineParameter)

    def CircleParameter(*args) -> "Standard_Real":
        """
        :param Pos:
        :type Pos: gp_Ax2
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * Pos is the Axis of the Circle parametrization In the local coordinate system of the circle X (U) = Radius * Cos (U) Y (U) = Radius * Sin (U)

        :param Pos:
        :type Pos: gp_Ax22d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_CircleParameter(*args)

    CircleParameter = staticmethod(CircleParameter)

    def EllipseParameter(*args) -> "Standard_Real":
        """
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * Pos is the Axis of the Ellipse parametrization In the local coordinate system of the Ellipse X (U) = MajorRadius * Cos (U) Y (U) = MinorRadius * Sin (U)

        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_EllipseParameter(*args)

    EllipseParameter = staticmethod(EllipseParameter)

    def HyperbolaParameter(*args) -> "Standard_Real":
        """
        :param Pos:
        :type Pos: gp_Ax2
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * Pos is the Axis of the Hyperbola parametrization In the local coordinate system of the Hyperbola X (U) = MajorRadius * Ch (U) Y (U) = MinorRadius * Sh (U)

        :param Pos:
        :type Pos: gp_Ax22d
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_HyperbolaParameter(*args)

    HyperbolaParameter = staticmethod(HyperbolaParameter)

    def ParabolaParameter(*args) -> "Standard_Real":
        """
        :param Pos:
        :type Pos: gp_Ax2
        :param P:
        :type P: gp_Pnt
        :rtype: float

        * Pos is the mirror axis of the parabola parametrization In the local coordinate system of the parabola Y**2 = (2*P) * X where P is the distance between the focus and the directrix. The following functions build a 3d curve from a 2d curve at a given position defined with an Ax2.

        :param Pos:
        :type Pos: gp_Ax22d
        :param P:
        :type P: gp_Pnt2d
        :rtype: float

        """
        return _ElCLib.elclib_ParabolaParameter(*args)

    ParabolaParameter = staticmethod(ParabolaParameter)

    def To3d(*args) -> "gp_Parab":
        """
        :param Pos:
        :type Pos: gp_Ax2
        :param P:
        :type P: gp_Pnt2d
        :rtype: gp_Pnt

        :param Pos:
        :type Pos: gp_Ax2
        :param V:
        :type V: gp_Vec2d
        :rtype: gp_Vec

        :param Pos:
        :type Pos: gp_Ax2
        :param V:
        :type V: gp_Dir2d
        :rtype: gp_Dir

        :param Pos:
        :type Pos: gp_Ax2
        :param A:
        :type A: gp_Ax2d
        :rtype: gp_Ax1

        :param Pos:
        :type Pos: gp_Ax2
        :param A:
        :type A: gp_Ax22d
        :rtype: gp_Ax2

        :param Pos:
        :type Pos: gp_Ax2
        :param L:
        :type L: gp_Lin2d
        :rtype: gp_Lin

        :param Pos:
        :type Pos: gp_Ax2
        :param C:
        :type C: gp_Circ2d
        :rtype: gp_Circ

        :param Pos:
        :type Pos: gp_Ax2
        :param E:
        :type E: gp_Elips2d
        :rtype: gp_Elips

        :param Pos:
        :type Pos: gp_Ax2
        :param H:
        :type H: gp_Hypr2d
        :rtype: gp_Hypr

        * These functions build a 3D geometric entity from a 2D geometric entity. The 'X Axis' and the 'Y Axis' of the global coordinate system (i.e. 2D space) are lined up respectively with the 'X Axis' and 'Y Axis' of the 3D coordinate system, Pos.

        :param Pos:
        :type Pos: gp_Ax2
        :param Prb:
        :type Prb: gp_Parab2d
        :rtype: gp_Parab

        """
        return _ElCLib.elclib_To3d(*args)

    To3d = staticmethod(To3d)

    __repr__ = _dumps_object


    def __init__(self):
        _ElCLib.elclib_swiginit(self, _ElCLib.new_elclib())
    __swig_destroy__ = _ElCLib.delete_elclib
elclib_swigregister = _ElCLib.elclib_swigregister
elclib_swigregister(elclib)

def elclib_InPeriod(*args) -> "Standard_Real":
    """
    * Return a value in the range <UFirst, ULast> by adding or removing the period <ULast - UFirst> to <U>.

    :param U:
    :type U: float
    :param UFirst:
    :type UFirst: float
    :param ULast:
    :type ULast: float
    :rtype: float

    """
    return _ElCLib.elclib_InPeriod(*args)

def elclib_AdjustPeriodic(*args) -> "Standard_Real &, Standard_Real &":
    """
    * Adjust U1 and U2 in the parametric range UFirst Ulast of a periodic curve, where ULast - UFirst is its period. To do this, this function: - sets U1 in the range [ UFirst, ULast ] by adding/removing the period to/from the value U1, then - sets U2 in the range [ U1, U1 + period ] by adding/removing the period to/from the value U2. Precision is used to test the equalities.

    :param UFirst:
    :type UFirst: float
    :param ULast:
    :type ULast: float
    :param Precision:
    :type Precision: float
    :param U1:
    :type U1: float &
    :param U2:
    :type U2: float &
    :rtype: void

    """
    return _ElCLib.elclib_AdjustPeriodic(*args)

def elclib_Value(*args) -> "gp_Pnt2d":
    """
    * For elementary curves (lines, circles and conics) from the gp package, computes the point of parameter U. The result is either: - a gp_Pnt point for a curve in 3D space, or - a gp_Pnt2d point for a curve in 2D space.

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin2d
    :rtype: gp_Pnt2d

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ2d
    :rtype: gp_Pnt2d

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips2d
    :rtype: gp_Pnt2d

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr2d
    :rtype: gp_Pnt2d

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab2d
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_Value(*args)

def elclib_D1(*args) -> "void":
    """
    * For elementary curves (lines, circles and conics) from the gp package, computes: - the point P of parameter U, and - the first derivative vector V1 at this point. The results P and V1 are either: - a gp_Pnt point and a gp_Vec vector, for a curve in 3D space, or - a gp_Pnt2d point and a gp_Vec2d vector, for a curve in 2D space.

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_D1(*args)

def elclib_D2(*args) -> "void":
    """
    * For elementary curves (circles and conics) from the gp package, computes: - the point P of parameter U, and - the first and second derivative vectors V1 and V2 at this point. The results, P, V1 and V2, are either: - a gp_Pnt point and two gp_Vec vectors, for a curve in 3D space, or - a gp_Pnt2d point and two gp_Vec2d vectors, for a curve in 2D space.

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_D2(*args)

def elclib_D3(*args) -> "void":
    """
    * For elementary curves (circles, ellipses and hyperbolae) from the gp package, computes: - the point P of parameter U, and - the first, second and third derivative vectors V1, V2 and V3 at this point. The results, P, V1, V2 and V3, are either: - a gp_Pnt point and three gp_Vec vectors, for a curve in 3D space, or - a gp_Pnt2d point and three gp_Vec2d vectors, for a curve in 2D space.

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    * In the following functions N is the order of derivation and should be greater than 0

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_D3(*args)

def elclib_DN(*args) -> "gp_Vec2d":
    """
    * For elementary curves (lines, circles and conics) from the gp package, computes the vector corresponding to the Nth derivative at the point of parameter U. The result is either: - a gp_Vec vector for a curve in 3D space, or - a gp_Vec2d vector for a curve in 2D space. In the following functions N is the order of derivation and should be greater than 0

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param L:
    :type L: gp_Lin2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    :param U:
    :type U: float
    :param C:
    :type C: gp_Circ2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    :param U:
    :type U: float
    :param E:
    :type E: gp_Elips2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    :param U:
    :type U: float
    :param H:
    :type H: gp_Hypr2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    :param U:
    :type U: float
    :param Prb:
    :type Prb: gp_Parab2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_DN(*args)

def elclib_LineValue(*args) -> "gp_Pnt2d":
    """
    * Curve evaluation The following basis functions compute the derivatives on elementary curves defined by their geometric characteristics. These functions can be called without constructing a conic from package gp. They are called by the previous functions. Example : A circle is defined by its position and its radius.

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax1
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2d
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_LineValue(*args)

def elclib_CircleValue(*args) -> "gp_Pnt2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Radius:
    :type Radius: float
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Radius:
    :type Radius: float
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_CircleValue(*args)

def elclib_EllipseValue(*args) -> "gp_Pnt2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_EllipseValue(*args)

def elclib_HyperbolaValue(*args) -> "gp_Pnt2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_HyperbolaValue(*args)

def elclib_ParabolaValue(*args) -> "gp_Pnt2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Focal:
    :type Focal: float
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Focal:
    :type Focal: float
    :rtype: gp_Pnt2d

    """
    return _ElCLib.elclib_ParabolaValue(*args)

def elclib_LineD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax1
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2d
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_LineD1(*args)

def elclib_CircleD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_CircleD1(*args)

def elclib_EllipseD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_EllipseD1(*args)

def elclib_HyperbolaD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_HyperbolaD1(*args)

def elclib_ParabolaD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Focal:
    :type Focal: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Focal:
    :type Focal: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_ParabolaD1(*args)

def elclib_CircleD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_CircleD2(*args)

def elclib_EllipseD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_EllipseD2(*args)

def elclib_HyperbolaD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_HyperbolaD2(*args)

def elclib_ParabolaD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Focal:
    :type Focal: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Focal:
    :type Focal: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_ParabolaD2(*args)

def elclib_CircleD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_CircleD3(*args)

def elclib_EllipseD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_EllipseD3(*args)

def elclib_HyperbolaD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :param V2:
    :type V2: gp_Vec
    :param V3:
    :type V3: gp_Vec
    :rtype: void

    * In the following functions N is the order of derivation and should be greater than 0

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :param V1:
    :type V1: gp_Vec2d
    :param V2:
    :type V2: gp_Vec2d
    :param V3:
    :type V3: gp_Vec2d
    :rtype: void

    """
    return _ElCLib.elclib_HyperbolaD3(*args)

def elclib_LineDN(*args) -> "gp_Vec2d":
    """
    * In the following functions N is the order of derivation and should be greater than 0

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax1
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2d
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_LineDN(*args)

def elclib_CircleDN(*args) -> "gp_Vec2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Radius:
    :type Radius: float
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Radius:
    :type Radius: float
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_CircleDN(*args)

def elclib_EllipseDN(*args) -> "gp_Vec2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_EllipseDN(*args)

def elclib_HyperbolaDN(*args) -> "gp_Vec2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param N:
    :type N: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_HyperbolaDN(*args)

def elclib_ParabolaDN(*args) -> "gp_Vec2d":
    """
    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax2
    :param Focal:
    :type Focal: float
    :param N:
    :type N: int
    :rtype: gp_Vec

    * The following functions compute the parametric value corresponding to a given point on a elementary curve. The point should be on the curve.

    :param U:
    :type U: float
    :param Pos:
    :type Pos: gp_Ax22d
    :param Focal:
    :type Focal: float
    :param N:
    :type N: int
    :rtype: gp_Vec2d

    """
    return _ElCLib.elclib_ParabolaDN(*args)

def elclib_Parameter(*args) -> "Standard_Real":
    """
    * Computes the parameter value of the point P on the given curve. Note: In its local coordinate system, the parametric equation of the curve is given by the following: - for the line L: P(U) = Po + U*Vo where Po is the origin and Vo the unit vector of its positioning axis. - for the circle C: X(U) = Radius*Cos(U), Y(U) = Radius*Sin(U) - for the ellipse E: X(U) = MajorRadius*Cos(U). Y(U) = MinorRadius*Sin(U) - for the hyperbola H: X(U) = MajorRadius*Ch(U), Y(U) = MinorRadius*Sh(U) - for the parabola Prb: X(U) = U**2 / (2*p) Y(U) = U where p is the distance between the focus and the directrix. Warning The point P must be on the curve. These functions are not protected, however, and if point P is not on the curve, an exception may be raised.

    :param L:
    :type L: gp_Lin
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization P (U) = L.Location() + U * L.Direction()

    :param L:
    :type L: gp_Lin2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    :param C:
    :type C: gp_Circ
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization In the local coordinate system of the circle X (U) = Radius * Cos (U) Y (U) = Radius * Sin (U)

    :param C:
    :type C: gp_Circ2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    :param E:
    :type E: gp_Elips
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization In the local coordinate system of the Ellipse X (U) = MajorRadius * Cos (U) Y (U) = MinorRadius * Sin (U)

    :param E:
    :type E: gp_Elips2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    :param H:
    :type H: gp_Hypr
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization In the local coordinate system of the Hyperbola X (U) = MajorRadius * Ch (U) Y (U) = MinorRadius * Sh (U)

    :param H:
    :type H: gp_Hypr2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    :param Prb:
    :type Prb: gp_Parab
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization In the local coordinate system of the parabola Y**2 = (2*P) * X where P is the distance between the focus and the directrix.

    :param Prb:
    :type Prb: gp_Parab2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_Parameter(*args)

def elclib_LineParameter(*args) -> "Standard_Real":
    """
    :param Pos:
    :type Pos: gp_Ax1
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * parametrization P (U) = L.Location() + U * L.Direction()

    :param Pos:
    :type Pos: gp_Ax2d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_LineParameter(*args)

def elclib_CircleParameter(*args) -> "Standard_Real":
    """
    :param Pos:
    :type Pos: gp_Ax2
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * Pos is the Axis of the Circle parametrization In the local coordinate system of the circle X (U) = Radius * Cos (U) Y (U) = Radius * Sin (U)

    :param Pos:
    :type Pos: gp_Ax22d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_CircleParameter(*args)

def elclib_EllipseParameter(*args) -> "Standard_Real":
    """
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * Pos is the Axis of the Ellipse parametrization In the local coordinate system of the Ellipse X (U) = MajorRadius * Cos (U) Y (U) = MinorRadius * Sin (U)

    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_EllipseParameter(*args)

def elclib_HyperbolaParameter(*args) -> "Standard_Real":
    """
    :param Pos:
    :type Pos: gp_Ax2
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * Pos is the Axis of the Hyperbola parametrization In the local coordinate system of the Hyperbola X (U) = MajorRadius * Ch (U) Y (U) = MinorRadius * Sh (U)

    :param Pos:
    :type Pos: gp_Ax22d
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_HyperbolaParameter(*args)

def elclib_ParabolaParameter(*args) -> "Standard_Real":
    """
    :param Pos:
    :type Pos: gp_Ax2
    :param P:
    :type P: gp_Pnt
    :rtype: float

    * Pos is the mirror axis of the parabola parametrization In the local coordinate system of the parabola Y**2 = (2*P) * X where P is the distance between the focus and the directrix. The following functions build a 3d curve from a 2d curve at a given position defined with an Ax2.

    :param Pos:
    :type Pos: gp_Ax22d
    :param P:
    :type P: gp_Pnt2d
    :rtype: float

    """
    return _ElCLib.elclib_ParabolaParameter(*args)

def elclib_To3d(*args) -> "gp_Parab":
    """
    :param Pos:
    :type Pos: gp_Ax2
    :param P:
    :type P: gp_Pnt2d
    :rtype: gp_Pnt

    :param Pos:
    :type Pos: gp_Ax2
    :param V:
    :type V: gp_Vec2d
    :rtype: gp_Vec

    :param Pos:
    :type Pos: gp_Ax2
    :param V:
    :type V: gp_Dir2d
    :rtype: gp_Dir

    :param Pos:
    :type Pos: gp_Ax2
    :param A:
    :type A: gp_Ax2d
    :rtype: gp_Ax1

    :param Pos:
    :type Pos: gp_Ax2
    :param A:
    :type A: gp_Ax22d
    :rtype: gp_Ax2

    :param Pos:
    :type Pos: gp_Ax2
    :param L:
    :type L: gp_Lin2d
    :rtype: gp_Lin

    :param Pos:
    :type Pos: gp_Ax2
    :param C:
    :type C: gp_Circ2d
    :rtype: gp_Circ

    :param Pos:
    :type Pos: gp_Ax2
    :param E:
    :type E: gp_Elips2d
    :rtype: gp_Elips

    :param Pos:
    :type Pos: gp_Ax2
    :param H:
    :type H: gp_Hypr2d
    :rtype: gp_Hypr

    * These functions build a 3D geometric entity from a 2D geometric entity. The 'X Axis' and the 'Y Axis' of the global coordinate system (i.e. 2D space) are lined up respectively with the 'X Axis' and 'Y Axis' of the 3D coordinate system, Pos.

    :param Pos:
    :type Pos: gp_Ax2
    :param Prb:
    :type Prb: gp_Parab2d
    :rtype: gp_Parab

    """
    return _ElCLib.elclib_To3d(*args)



