# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
- Purpose : Provides functions for basic geometric computation on
elementary surfaces.
This includes:
-  calculation of a point or derived vector on a surface
where the surface is provided by the gp package, or
defined in canonical form (as in the gp package), and
the point is defined with a parameter,
-  evaluation of the parameters corresponding to a
point on an elementary surface from gp,
-  calculation of isoparametric curves on an elementary
surface defined in canonical form (as in the gp package).
Notes:
-  ElSLib stands for Elementary Surfaces Library.
-  If the surfaces provided by the gp package are not
explicitly parameterized, they still have an implicit
parameterization, similar to that which they infer on
the equivalent Geom surfaces.
Note: ElSLib stands for Elementary Surfaces Library.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _ElSLib.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_ElSLib')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_ElSLib')
    _ElSLib = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_ElSLib', [dirname(__file__)])
        except ImportError:
            import _ElSLib
            return _ElSLib
        try:
            _mod = imp.load_module('_ElSLib', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _ElSLib = swig_import_helper()
    del swig_import_helper
else:
    import _ElSLib
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _ElSLib.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_ElSLib.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_ElSLib.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_ElSLib.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_ElSLib.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_ElSLib.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_ElSLib.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_ElSLib.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_ElSLib.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_ElSLib.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_ElSLib.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_ElSLib.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_ElSLib.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_ElSLib.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_ElSLib.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_ElSLib.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_ElSLib.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _ElSLib.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _ElSLib.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.Standard
import OCC.Core.gp
class elslib(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def Value(*args) -> "gp_Pnt":
        """
        * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the point of parameters (U, V).

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pl:
        :type Pl: gp_Pln
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :rtype: gp_Pnt

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_Value(*args)

    Value = staticmethod(Value)

    def DN(*args) -> "gp_Vec":
        """
        * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the derivative vector of order Nu and Nv in the u and v parametric directions respectively, at the point of parameters (U, V).

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pl:
        :type Pl: gp_Pln
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_DN(*args)

    DN = staticmethod(DN)

    def D0(*args) -> "void":
        """
        * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the point P of parameters (U, V).inline

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pl:
        :type Pl: gp_Pln
        :param P:
        :type P: gp_Pnt
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :param P:
        :type P: gp_Pnt
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :param P:
        :type P: gp_Pnt
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :param P:
        :type P: gp_Pnt
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_D0(*args)

    D0 = staticmethod(D0)

    def D1(*args) -> "void":
        """
        * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes: - the point P of parameters (U, V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pl:
        :type Pl: gp_Pln
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_D1(*args)

    D1 = staticmethod(D1)

    def D2(*args) -> "void":
        """
        * For elementary surfaces from the gp package (cones, cylinders, spheres and tori), computes: - the point P of parameters (U, V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively, and - the second derivative vectors Vuu, Vvv and Vuv at this point.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_D2(*args)

    D2 = staticmethod(D2)

    def D3(*args) -> "void":
        """
        * For elementary surfaces from the gp package (cones, cylinders, spheres and tori), computes: - the point P of parameters (U,V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively, and - the second derivative vectors Vuu, Vvv and Vuv at this point, and - the third derivative vectors Vuuu, Vvvv, Vuuv and Vuvv at this point.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cone
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param C:
        :type C: gp_Cylinder
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param S:
        :type S: gp_Sphere
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        * Surface evaluation The following functions compute the point and the derivatives on elementary surfaces defined with their geometric characterisitics. You don't need to create the surface to use these functions. These functions are called by the previous ones. Example : A cylinder is defined with its position and its radius.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param T:
        :type T: gp_Torus
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_D3(*args)

    D3 = staticmethod(D3)

    def PlaneValue(*args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_PlaneValue(*args)

    PlaneValue = staticmethod(PlaneValue)

    def CylinderValue(*args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_CylinderValue(*args)

    CylinderValue = staticmethod(CylinderValue)

    def ConeValue(*args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_ConeValue(*args)

    ConeValue = staticmethod(ConeValue)

    def SphereValue(*args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_SphereValue(*args)

    SphereValue = staticmethod(SphereValue)

    def TorusValue(*args) -> "gp_Pnt":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :rtype: gp_Pnt

        """
        return _ElSLib.elslib_TorusValue(*args)

    TorusValue = staticmethod(TorusValue)

    def PlaneDN(*args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_PlaneDN(*args)

    PlaneDN = staticmethod(PlaneDN)

    def CylinderDN(*args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_CylinderDN(*args)

    CylinderDN = staticmethod(CylinderDN)

    def ConeDN(*args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_ConeDN(*args)

    ConeDN = staticmethod(ConeDN)

    def SphereDN(*args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_SphereDN(*args)

    SphereDN = staticmethod(SphereDN)

    def TorusDN(*args) -> "gp_Vec":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param Nu:
        :type Nu: int
        :param Nv:
        :type Nv: int
        :rtype: gp_Vec

        """
        return _ElSLib.elslib_TorusDN(*args)

    TorusDN = staticmethod(TorusDN)

    def PlaneD0(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_PlaneD0(*args)

    PlaneD0 = staticmethod(PlaneD0)

    def ConeD0(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_ConeD0(*args)

    ConeD0 = staticmethod(ConeD0)

    def CylinderD0(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_CylinderD0(*args)

    CylinderD0 = staticmethod(CylinderD0)

    def SphereD0(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_SphereD0(*args)

    SphereD0 = staticmethod(SphereD0)

    def TorusD0(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :rtype: void

        """
        return _ElSLib.elslib_TorusD0(*args)

    TorusD0 = staticmethod(TorusD0)

    def PlaneD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_PlaneD1(*args)

    PlaneD1 = staticmethod(PlaneD1)

    def ConeD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_ConeD1(*args)

    ConeD1 = staticmethod(ConeD1)

    def CylinderD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_CylinderD1(*args)

    CylinderD1 = staticmethod(CylinderD1)

    def SphereD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_SphereD1(*args)

    SphereD1 = staticmethod(SphereD1)

    def TorusD1(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_TorusD1(*args)

    TorusD1 = staticmethod(TorusD1)

    def ConeD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_ConeD2(*args)

    ConeD2 = staticmethod(ConeD2)

    def CylinderD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_CylinderD2(*args)

    CylinderD2 = staticmethod(CylinderD2)

    def SphereD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_SphereD2(*args)

    SphereD2 = staticmethod(SphereD2)

    def TorusD2(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_TorusD2(*args)

    TorusD2 = staticmethod(TorusD2)

    def ConeD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_ConeD3(*args)

    ConeD3 = staticmethod(ConeD3)

    def CylinderD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_CylinderD3(*args)

    CylinderD3 = staticmethod(CylinderD3)

    def SphereD3(*args) -> "void":
        """
        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_SphereD3(*args)

    SphereD3 = staticmethod(SphereD3)

    def TorusD3(*args) -> "void":
        """
        * The following functions compute the parametric values corresponding to a given point on a elementary surface. The point should be on the surface.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param Vu:
        :type Vu: gp_Vec
        :param Vv:
        :type Vv: gp_Vec
        :param Vuu:
        :type Vuu: gp_Vec
        :param Vvv:
        :type Vvv: gp_Vec
        :param Vuv:
        :type Vuv: gp_Vec
        :param Vuuu:
        :type Vuuu: gp_Vec
        :param Vvvv:
        :type Vvvv: gp_Vec
        :param Vuuv:
        :type Vuuv: gp_Vec
        :param Vuvv:
        :type Vuvv: gp_Vec
        :rtype: void

        """
        return _ElSLib.elslib_TorusD3(*args)

    TorusD3 = staticmethod(TorusD3)

    def Parameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Pl.Location() + U * Pl.XDirection() + V * Pl.YDirection()

        :param Pl:
        :type Pl: gp_Pln
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        * parametrization P (U, V) = Location + V * ZDirection + Radius * (Cos(U) * XDirection + Sin (U) * YDirection)

        :param C:
        :type C: gp_Cylinder
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        * parametrization P (U, V) = Location + V * ZDirection + (Radius + V * Tan (SemiAngle)) * (Cos(U) * XDirection + Sin(U) * YDirection)

        :param C:
        :type C: gp_Cone
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        * parametrization P (U, V) = Location + Radius * Cos (V) * (Cos (U) * XDirection + Sin (U) * YDirection) + Radius * Sin (V) * ZDirection

        :param S:
        :type S: gp_Sphere
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        * parametrization P (U, V) = Location + (MajorRadius + MinorRadius * Cos(U)) * (Cos(V) * XDirection - Sin(V) * YDirection) + MinorRadius * Sin(U) * ZDirection

        :param T:
        :type T: gp_Torus
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_Parameters(*args)

    Parameters = staticmethod(Parameters)

    def PlaneParameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Pl.Location() + U * Pl.XDirection() + V * Pl.YDirection()

        :param Pos:
        :type Pos: gp_Ax3
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_PlaneParameters(*args)

    PlaneParameters = staticmethod(PlaneParameters)

    def CylinderParameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Location + V * ZDirection + Radius * (Cos(U) * XDirection + Sin (U) * YDirection)

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_CylinderParameters(*args)

    CylinderParameters = staticmethod(CylinderParameters)

    def ConeParameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Location + V * ZDirection + (Radius + V * Tan (SemiAngle)) * (Cos(U) * XDirection + Sin(U) * YDirection)

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_ConeParameters(*args)

    ConeParameters = staticmethod(ConeParameters)

    def SphereParameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Location + Radius * Cos (V) * (Cos (U) * XDirection + Sin (U) * YDirection) + Radius * Sin (V) * ZDirection

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_SphereParameters(*args)

    SphereParameters = staticmethod(SphereParameters)

    def TorusParameters(*args) -> "Standard_Real &, Standard_Real &":
        """
        * parametrization P (U, V) = Location + (MajorRadius + MinorRadius * Cos(U)) * (Cos(V) * XDirection - Sin(V) * YDirection) + MinorRadius * Sin(U) * ZDirection

        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param P:
        :type P: gp_Pnt
        :param U:
        :type U: float &
        :param V:
        :type V: float &
        :rtype: void

        """
        return _ElSLib.elslib_TorusParameters(*args)

    TorusParameters = staticmethod(TorusParameters)

    def PlaneUIso(*args) -> "gp_Lin":
        """
        * compute the U Isoparametric gp_Lin of the plane.

        :param Pos:
        :type Pos: gp_Ax3
        :param U:
        :type U: float
        :rtype: gp_Lin

        """
        return _ElSLib.elslib_PlaneUIso(*args)

    PlaneUIso = staticmethod(PlaneUIso)

    def CylinderUIso(*args) -> "gp_Lin":
        """
        * compute the U Isoparametric gp_Lin of the cylinder.

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param U:
        :type U: float
        :rtype: gp_Lin

        """
        return _ElSLib.elslib_CylinderUIso(*args)

    CylinderUIso = staticmethod(CylinderUIso)

    def ConeUIso(*args) -> "gp_Lin":
        """
        * compute the U Isoparametric gp_Lin of the cone.

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param U:
        :type U: float
        :rtype: gp_Lin

        """
        return _ElSLib.elslib_ConeUIso(*args)

    ConeUIso = staticmethod(ConeUIso)

    def SphereUIso(*args) -> "gp_Circ":
        """
        * compute the U Isoparametric gp_Circ of the sphere, (the meridian is not trimmed).

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param U:
        :type U: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_SphereUIso(*args)

    SphereUIso = staticmethod(SphereUIso)

    def TorusUIso(*args) -> "gp_Circ":
        """
        * compute the U Isoparametric gp_Circ of the torus.

        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param U:
        :type U: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_TorusUIso(*args)

    TorusUIso = staticmethod(TorusUIso)

    def PlaneVIso(*args) -> "gp_Lin":
        """
        * compute the V Isoparametric gp_Lin of the plane.

        :param Pos:
        :type Pos: gp_Ax3
        :param V:
        :type V: float
        :rtype: gp_Lin

        """
        return _ElSLib.elslib_PlaneVIso(*args)

    PlaneVIso = staticmethod(PlaneVIso)

    def CylinderVIso(*args) -> "gp_Circ":
        """
        * compute the V Isoparametric gp_Circ of the cylinder.

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param V:
        :type V: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_CylinderVIso(*args)

    CylinderVIso = staticmethod(CylinderVIso)

    def ConeVIso(*args) -> "gp_Circ":
        """
        * compute the V Isoparametric gp_Circ of the cone.

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param SAngle:
        :type SAngle: float
        :param V:
        :type V: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_ConeVIso(*args)

    ConeVIso = staticmethod(ConeVIso)

    def SphereVIso(*args) -> "gp_Circ":
        """
        * compute the V Isoparametric gp_Circ of the sphere, (the meridian is not trimmed).

        :param Pos:
        :type Pos: gp_Ax3
        :param Radius:
        :type Radius: float
        :param V:
        :type V: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_SphereVIso(*args)

    SphereVIso = staticmethod(SphereVIso)

    def TorusVIso(*args) -> "gp_Circ":
        """
        * compute the V Isoparametric gp_Circ of the torus.

        :param Pos:
        :type Pos: gp_Ax3
        :param MajorRadius:
        :type MajorRadius: float
        :param MinorRadius:
        :type MinorRadius: float
        :param V:
        :type V: float
        :rtype: gp_Circ

        """
        return _ElSLib.elslib_TorusVIso(*args)

    TorusVIso = staticmethod(TorusVIso)

    __repr__ = _dumps_object


    def __init__(self):
        _ElSLib.elslib_swiginit(self, _ElSLib.new_elslib())
    __swig_destroy__ = _ElSLib.delete_elslib
elslib_swigregister = _ElSLib.elslib_swigregister
elslib_swigregister(elslib)

def elslib_Value(*args) -> "gp_Pnt":
    """
    * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the point of parameters (U, V).

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pl:
    :type Pl: gp_Pln
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :rtype: gp_Pnt

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_Value(*args)

def elslib_DN(*args) -> "gp_Vec":
    """
    * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the derivative vector of order Nu and Nv in the u and v parametric directions respectively, at the point of parameters (U, V).

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pl:
    :type Pl: gp_Pln
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_DN(*args)

def elslib_D0(*args) -> "void":
    """
    * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes the point P of parameters (U, V).inline

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pl:
    :type Pl: gp_Pln
    :param P:
    :type P: gp_Pnt
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :param P:
    :type P: gp_Pnt
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :param P:
    :type P: gp_Pnt
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :param P:
    :type P: gp_Pnt
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_D0(*args)

def elslib_D1(*args) -> "void":
    """
    * For elementary surfaces from the gp package (planes, cones, cylinders, spheres and tori), computes: - the point P of parameters (U, V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively.

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pl:
    :type Pl: gp_Pln
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_D1(*args)

def elslib_D2(*args) -> "void":
    """
    * For elementary surfaces from the gp package (cones, cylinders, spheres and tori), computes: - the point P of parameters (U, V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively, and - the second derivative vectors Vuu, Vvv and Vuv at this point.

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_D2(*args)

def elslib_D3(*args) -> "void":
    """
    * For elementary surfaces from the gp package (cones, cylinders, spheres and tori), computes: - the point P of parameters (U,V), and - the first derivative vectors Vu and Vv at this point in the u and v parametric directions respectively, and - the second derivative vectors Vuu, Vvv and Vuv at this point, and - the third derivative vectors Vuuu, Vvvv, Vuuv and Vuvv at this point.

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cone
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param C:
    :type C: gp_Cylinder
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param S:
    :type S: gp_Sphere
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    * Surface evaluation The following functions compute the point and the derivatives on elementary surfaces defined with their geometric characterisitics. You don't need to create the surface to use these functions. These functions are called by the previous ones. Example : A cylinder is defined with its position and its radius.

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param T:
    :type T: gp_Torus
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_D3(*args)

def elslib_PlaneValue(*args) -> "gp_Pnt":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_PlaneValue(*args)

def elslib_CylinderValue(*args) -> "gp_Pnt":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_CylinderValue(*args)

def elslib_ConeValue(*args) -> "gp_Pnt":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_ConeValue(*args)

def elslib_SphereValue(*args) -> "gp_Pnt":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_SphereValue(*args)

def elslib_TorusValue(*args) -> "gp_Pnt":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :rtype: gp_Pnt

    """
    return _ElSLib.elslib_TorusValue(*args)

def elslib_PlaneDN(*args) -> "gp_Vec":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_PlaneDN(*args)

def elslib_CylinderDN(*args) -> "gp_Vec":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_CylinderDN(*args)

def elslib_ConeDN(*args) -> "gp_Vec":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_ConeDN(*args)

def elslib_SphereDN(*args) -> "gp_Vec":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_SphereDN(*args)

def elslib_TorusDN(*args) -> "gp_Vec":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param Nu:
    :type Nu: int
    :param Nv:
    :type Nv: int
    :rtype: gp_Vec

    """
    return _ElSLib.elslib_TorusDN(*args)

def elslib_PlaneD0(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_PlaneD0(*args)

def elslib_ConeD0(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_ConeD0(*args)

def elslib_CylinderD0(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_CylinderD0(*args)

def elslib_SphereD0(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_SphereD0(*args)

def elslib_TorusD0(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :rtype: void

    """
    return _ElSLib.elslib_TorusD0(*args)

def elslib_PlaneD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_PlaneD1(*args)

def elslib_ConeD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_ConeD1(*args)

def elslib_CylinderD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_CylinderD1(*args)

def elslib_SphereD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_SphereD1(*args)

def elslib_TorusD1(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_TorusD1(*args)

def elslib_ConeD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_ConeD2(*args)

def elslib_CylinderD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_CylinderD2(*args)

def elslib_SphereD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_SphereD2(*args)

def elslib_TorusD2(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_TorusD2(*args)

def elslib_ConeD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_ConeD3(*args)

def elslib_CylinderD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_CylinderD3(*args)

def elslib_SphereD3(*args) -> "void":
    """
    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_SphereD3(*args)

def elslib_TorusD3(*args) -> "void":
    """
    * The following functions compute the parametric values corresponding to a given point on a elementary surface. The point should be on the surface.

    :param U:
    :type U: float
    :param V:
    :type V: float
    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param Vu:
    :type Vu: gp_Vec
    :param Vv:
    :type Vv: gp_Vec
    :param Vuu:
    :type Vuu: gp_Vec
    :param Vvv:
    :type Vvv: gp_Vec
    :param Vuv:
    :type Vuv: gp_Vec
    :param Vuuu:
    :type Vuuu: gp_Vec
    :param Vvvv:
    :type Vvvv: gp_Vec
    :param Vuuv:
    :type Vuuv: gp_Vec
    :param Vuvv:
    :type Vuvv: gp_Vec
    :rtype: void

    """
    return _ElSLib.elslib_TorusD3(*args)

def elslib_Parameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Pl.Location() + U * Pl.XDirection() + V * Pl.YDirection()

    :param Pl:
    :type Pl: gp_Pln
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    * parametrization P (U, V) = Location + V * ZDirection + Radius * (Cos(U) * XDirection + Sin (U) * YDirection)

    :param C:
    :type C: gp_Cylinder
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    * parametrization P (U, V) = Location + V * ZDirection + (Radius + V * Tan (SemiAngle)) * (Cos(U) * XDirection + Sin(U) * YDirection)

    :param C:
    :type C: gp_Cone
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    * parametrization P (U, V) = Location + Radius * Cos (V) * (Cos (U) * XDirection + Sin (U) * YDirection) + Radius * Sin (V) * ZDirection

    :param S:
    :type S: gp_Sphere
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    * parametrization P (U, V) = Location + (MajorRadius + MinorRadius * Cos(U)) * (Cos(V) * XDirection - Sin(V) * YDirection) + MinorRadius * Sin(U) * ZDirection

    :param T:
    :type T: gp_Torus
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_Parameters(*args)

def elslib_PlaneParameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Pl.Location() + U * Pl.XDirection() + V * Pl.YDirection()

    :param Pos:
    :type Pos: gp_Ax3
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_PlaneParameters(*args)

def elslib_CylinderParameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Location + V * ZDirection + Radius * (Cos(U) * XDirection + Sin (U) * YDirection)

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_CylinderParameters(*args)

def elslib_ConeParameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Location + V * ZDirection + (Radius + V * Tan (SemiAngle)) * (Cos(U) * XDirection + Sin(U) * YDirection)

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_ConeParameters(*args)

def elslib_SphereParameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Location + Radius * Cos (V) * (Cos (U) * XDirection + Sin (U) * YDirection) + Radius * Sin (V) * ZDirection

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_SphereParameters(*args)

def elslib_TorusParameters(*args) -> "Standard_Real &, Standard_Real &":
    """
    * parametrization P (U, V) = Location + (MajorRadius + MinorRadius * Cos(U)) * (Cos(V) * XDirection - Sin(V) * YDirection) + MinorRadius * Sin(U) * ZDirection

    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param P:
    :type P: gp_Pnt
    :param U:
    :type U: float &
    :param V:
    :type V: float &
    :rtype: void

    """
    return _ElSLib.elslib_TorusParameters(*args)

def elslib_PlaneUIso(*args) -> "gp_Lin":
    """
    * compute the U Isoparametric gp_Lin of the plane.

    :param Pos:
    :type Pos: gp_Ax3
    :param U:
    :type U: float
    :rtype: gp_Lin

    """
    return _ElSLib.elslib_PlaneUIso(*args)

def elslib_CylinderUIso(*args) -> "gp_Lin":
    """
    * compute the U Isoparametric gp_Lin of the cylinder.

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param U:
    :type U: float
    :rtype: gp_Lin

    """
    return _ElSLib.elslib_CylinderUIso(*args)

def elslib_ConeUIso(*args) -> "gp_Lin":
    """
    * compute the U Isoparametric gp_Lin of the cone.

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param U:
    :type U: float
    :rtype: gp_Lin

    """
    return _ElSLib.elslib_ConeUIso(*args)

def elslib_SphereUIso(*args) -> "gp_Circ":
    """
    * compute the U Isoparametric gp_Circ of the sphere, (the meridian is not trimmed).

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param U:
    :type U: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_SphereUIso(*args)

def elslib_TorusUIso(*args) -> "gp_Circ":
    """
    * compute the U Isoparametric gp_Circ of the torus.

    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param U:
    :type U: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_TorusUIso(*args)

def elslib_PlaneVIso(*args) -> "gp_Lin":
    """
    * compute the V Isoparametric gp_Lin of the plane.

    :param Pos:
    :type Pos: gp_Ax3
    :param V:
    :type V: float
    :rtype: gp_Lin

    """
    return _ElSLib.elslib_PlaneVIso(*args)

def elslib_CylinderVIso(*args) -> "gp_Circ":
    """
    * compute the V Isoparametric gp_Circ of the cylinder.

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param V:
    :type V: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_CylinderVIso(*args)

def elslib_ConeVIso(*args) -> "gp_Circ":
    """
    * compute the V Isoparametric gp_Circ of the cone.

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param SAngle:
    :type SAngle: float
    :param V:
    :type V: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_ConeVIso(*args)

def elslib_SphereVIso(*args) -> "gp_Circ":
    """
    * compute the V Isoparametric gp_Circ of the sphere, (the meridian is not trimmed).

    :param Pos:
    :type Pos: gp_Ax3
    :param Radius:
    :type Radius: float
    :param V:
    :type V: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_SphereVIso(*args)

def elslib_TorusVIso(*args) -> "gp_Circ":
    """
    * compute the V Isoparametric gp_Circ of the torus.

    :param Pos:
    :type Pos: gp_Ax3
    :param MajorRadius:
    :type MajorRadius: float
    :param MinorRadius:
    :type MinorRadius: float
    :param V:
    :type V: float
    :rtype: gp_Circ

    """
    return _ElSLib.elslib_TorusVIso(*args)



