# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
The BRepAlgoAPI package provides a full range of
services to perform Boolean Operations on arguments (shapes
that are defined in the BRep data structures). The
implemented new algorithm is intended to replace the Old
Boolean Operations algorithm in the BRepAlgoAPI package.
The New algorithm is free of a large number of weak spots
and limitations characteristics of the Old algorithm.
It is more powerful and flexible.
It can process arguments the Old algorithm was not adapted for.
The new algorithm is based on a new approach to operations
with interfered shapes. The advantages of the new algorithm
include an ability to treat arguments that have shared
entities. It can properly process two solids with shared
faces (in terms of TopoDS_Shape::IsSame()), two
faces that have shared edges and so on. Now the New Boolean
Operation algorithm can treat a wide range of shapes while the
Old one fails on them.
A generalization of treatment of same-domain faces
was included into the New algorithm. Two faces that share
the same domain are processed according to the common rule
even if the underlying surfaces are of different types. This
allows to execute Boolean Operations properly for the same
domain faces. It also concerns solids and shells that have the
same domain faces. It is quite frequent when two faces share
the same domain. And the New algorithm successfully copes
with it in contrast to the Old one.
Generalization oftreatment of degenerated edges
gives a possibility to process them properly. Although there
are still some difficulties with processing faces in areas close
to degenerated edges.
Now the processing of arguments having internal sub-shapes gives
a correct result. Internal sub-shape means a sub-shape of a
shape with the orientation TopAbs_INTERNAL and is located
inside the shape boundaries. The New algorithm processes faces
with internal edges properly. The new API of the Boolean
Operations (in addition to the old API) allows to reuse the
already computed interference between arguments in different
types of Boolean Operations. It is possible to use once computed
interference in FUSE, CUT and COMMON operations on given
arguments. So there is no need to re-compute the interference
between the arguments. It allows to reduce time for more than one
operation on given arguments.
The shape type of a Boolean Operation result and types of the arguments:
-   For arguments with the same shape type (e.g. SOLID /
SOLID) the type of the resulting shape will be a
COMPOUND, containing shapes of this type;
-   For arguments with different shape types (e.g.
SHELL / SOLID) the type of the resulting shape will be a
COMPOUND, containing shapes of the type that is the same as
that of the low type of the argument. Example: For
SHELL/SOLID the result is a COMPOUND of SHELLs.
-   For arguments with different shape types some of
Boolean Operations can not be done using the default
implementation, because of a non-manifold type of the
result. Example: the FUSE operation for SHELL and SOLID
can not be done, but the CUT operation can be done, where
SHELL is the object and SOLID is the tool.
It is possible to perform Boolean Operations on arguments
of the COMPOUND shape type. In this case each compound must not
be heterogeneous, i.e. it must contain equidimensional shapes
(EDGEs or/and WIREs, FACEs or/and SHELLs, SOLIDs). SOLIDs
inside the COMPOUND must not contact (intersect or touch)
each other. The same condition is true for SHELLs or FACEs,
WIREs or EDGEs.
It does not support Boolean Operations for COMPSOLID type of shape.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _BRepAlgoAPI.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_BRepAlgoAPI')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_BRepAlgoAPI')
    _BRepAlgoAPI = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_BRepAlgoAPI', [dirname(__file__)])
        except ImportError:
            import _BRepAlgoAPI
            return _BRepAlgoAPI
        try:
            _mod = imp.load_module('_BRepAlgoAPI', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _BRepAlgoAPI = swig_import_helper()
    del swig_import_helper
else:
    import _BRepAlgoAPI
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepAlgoAPI.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_BRepAlgoAPI.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_BRepAlgoAPI.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _BRepAlgoAPI.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _BRepAlgoAPI.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.BRepBuilderAPI
import OCC.Core.Geom
import OCC.Core.MMgt
import OCC.Core.Standard
import OCC.Core.gp
import OCC.Core.TCollection
import OCC.Core.GeomAbs
import OCC.Core.TColgp
import OCC.Core.TColStd
import OCC.Core.TopoDS
import OCC.Core.TopLoc
import OCC.Core.TopAbs
import OCC.Core.TopTools
import OCC.Core.Message
import OCC.Core.BRepTools
import OCC.Core.Bnd
import OCC.Core.BRep
import OCC.Core.Poly
import OCC.Core.NCollection
import OCC.Core.TShort
import OCC.Core.Geom2d
import OCC.Core.BOPCol
import OCC.Core.BOPAlgo
import OCC.Core.BOPDS
import OCC.Core.IntTools
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.Adaptor2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
import OCC.Core.GeomAPI
import OCC.Core.Quantity
import OCC.Core.Extrema
import OCC.Core.Approx
import OCC.Core.AppCont
import OCC.Core.AppParCurves
import OCC.Core.BRepClass3d
import OCC.Core.IntCurveSurface
import OCC.Core.Intf
import OCC.Core.IntSurf
import OCC.Core.IntCurvesFace
import OCC.Core.Geom2dHatch
import OCC.Core.IntRes2d
import OCC.Core.HatchGen
import OCC.Core.Geom2dInt
import OCC.Core.IntCurve
import OCC.Core.BOPTools
import OCC.Core.ProjLib
class BRepAlgoAPI_Algo(OCC.Core.BRepBuilderAPI.BRepBuilderAPI_MakeShape):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def ErrorStatus(self, *args) -> "Standard_Integer":
        """
        * Returns error status of the algorithm ==0 - no errors occured !=0 - is in the event of various error conditions

        :rtype: int

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_ErrorStatus(self, *args)


    def WarningStatus(self, *args) -> "Standard_Integer":
        """
        * Returns warning status of the algorithm ==0 - no warning occured !=0 - is in the event of various warning conditions

        :rtype: int

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_WarningStatus(self, *args)


    def Allocator(self, *args) -> "BOPCol_BaseAllocator const &":
        """
        :rtype: BOPCol_BaseAllocator

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_Allocator(self, *args)


    def SetRunParallel(self, *args) -> "void":
        """
        * Set the flag of parallel processing if <theFlag> is true the parallel processing is switched on if <theFlag> is false the parallel processing is switched off

        :param theFlag:
        :type theFlag: bool
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_SetRunParallel(self, *args)


    def RunParallel(self, *args) -> "Standard_Boolean":
        """
        * Returns the flag of parallel processing

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_RunParallel(self, *args)


    def SetProgressIndicator(self, *args) -> "void":
        """
        * Set the Progress Indicator object.

        :param theObj:
        :type theObj: Handle_Message_ProgressIndicator &
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Algo_SetProgressIndicator(self, *args)


    __repr__ = _dumps_object

BRepAlgoAPI_Algo.ErrorStatus = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_ErrorStatus, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo.WarningStatus = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_WarningStatus, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo.Allocator = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_Allocator, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo.SetRunParallel = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_SetRunParallel, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo.RunParallel = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_RunParallel, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo.SetProgressIndicator = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Algo_SetProgressIndicator, None, BRepAlgoAPI_Algo)
BRepAlgoAPI_Algo_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Algo_swigregister
BRepAlgoAPI_Algo_swigregister(BRepAlgoAPI_Algo)

class BRepAlgoAPI_BuilderAlgo(BRepAlgoAPI_Algo):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor

        :rtype: None

        * Empty constructor

        :param thePF:
        :type thePF: BOPAlgo_PaveFiller &
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_BuilderAlgo(*args))

    def SetFuzzyValue(self, *args) -> "void":
        """
        * Sets the additional tolerance

        :param theFuzz:
        :type theFuzz: float
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_SetFuzzyValue(self, *args)


    def FuzzyValue(self, *args) -> "Standard_Real":
        """
        * Returns the additional tolerance

        :rtype: float

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_FuzzyValue(self, *args)


    def SetArguments(self, *args) -> "void":
        """
        * Sets the arguments

        :param theLS:
        :type theLS: TopTools_ListOfShape &
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_SetArguments(self, *args)


    def Arguments(self, *args) -> "TopTools_ListOfShape const &":
        """
        * Gets the arguments

        :rtype: TopTools_ListOfShape

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_Arguments(self, *args)


    def HasModified(self, *args) -> "Standard_Boolean":
        """
        * Returns true if there is at least one modified shape. For use in BRepNaming.

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasModified(self, *args)


    def HasGenerated(self, *args) -> "Standard_Boolean":
        """
        * Returns true if there is at least one generated shape. For use in BRepNaming.

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasGenerated(self, *args)


    def HasDeleted(self, *args) -> "Standard_Boolean":
        """
        * Returns true if there is at least one deleted shape. For use in BRepNaming. //! protected methods

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasDeleted(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_BuilderAlgo
BRepAlgoAPI_BuilderAlgo.SetFuzzyValue = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_SetFuzzyValue, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.FuzzyValue = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_FuzzyValue, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.SetArguments = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_SetArguments, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.Arguments = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_Arguments, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.HasModified = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasModified, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.HasGenerated = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasGenerated, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo.HasDeleted = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_HasDeleted, None, BRepAlgoAPI_BuilderAlgo)
BRepAlgoAPI_BuilderAlgo_swigregister = _BRepAlgoAPI.BRepAlgoAPI_BuilderAlgo_swigregister
BRepAlgoAPI_BuilderAlgo_swigregister(BRepAlgoAPI_BuilderAlgo)

class BRepAlgoAPI_Check(BRepAlgoAPI_Algo):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor.

        :rtype: None

        * Constructor for checking single shape. It calls methods Init(theS, TopoDS_Shape(), BOPAlgo_UNKNOWN, bTestSE, bTestSI) and Perform(). Params: theS - the shape that should be checked; bTestSE - flag that specifies whether check on small edges should be performed; by default it is set to True; bTestSI - flag that specifies whether check on self-interference should be performed; by default it is set to True;

        :param theS:
        :type theS: TopoDS_Shape &
        :param bTestSE: default value is Standard_True
        :type bTestSE: bool
        :param bTestSI: default value is Standard_True
        :type bTestSI: bool
        :rtype: None

        * Constructor for couple of shapes. It calls methods Init(theS1, theS2, theOp, bTestSE, bTestSI) and Perform(). Params: theS1, theS2 - the initial shapes. theOp - the type of Boolean Operation; if it is not defined (set to UNKNOWN) for each shape performed check as for single shape. bTestSE - flag that specifies whether check on small edges should be performed; by default it is set to True; bTestSI - flag that specifies whether check on self-interference should be performed; by default it is set to True;

        :param theS1:
        :type theS1: TopoDS_Shape &
        :param theS2:
        :type theS2: TopoDS_Shape &
        :param theOp: default value is BOPAlgo_UNKNOWN
        :type theOp: BOPAlgo_Operation
        :param bTestSE: default value is Standard_True
        :type bTestSE: bool
        :param bTestSI: default value is Standard_True
        :type bTestSI: bool
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_Check_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_Check(*args))

    def SetData(self, *args) -> "void":
        """
        * Sets data for check by Init method. The method provides alternative way for checking single shape.

        :param theS:
        :type theS: TopoDS_Shape &
        :param bTestSE: default value is Standard_True
        :type bTestSE: bool
        :param bTestSI: default value is Standard_True
        :type bTestSI: bool
        :rtype: None

        * Sets data for check by Init method. The method provides alternative way for checking couple of shapes.

        :param theS1:
        :type theS1: TopoDS_Shape &
        :param theS2:
        :type theS2: TopoDS_Shape &
        :param theOp: default value is BOPAlgo_UNKNOWN
        :type theOp: BOPAlgo_Operation
        :param bTestSE: default value is Standard_True
        :type bTestSE: bool
        :param bTestSI: default value is Standard_True
        :type bTestSI: bool
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_SetData(self, *args)


    def Perform(self, *args) -> "void":
        """
        * Performs the check.

        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_Perform(self, *args)


    def IsValid(self, *args) -> "Standard_Boolean":
        """
        * Shows whether shape(s) valid or not.

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_IsValid(self, *args)


    def Result(self, *args) -> "BOPAlgo_ListOfCheckResult const &":
        """
        * Returns faulty shapes.

        :rtype: BOPAlgo_ListOfCheckResult

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_Result(self, *args)


    def SetFuzzyValue(self, *args) -> "void":
        """
        * Sets the additional tolerance

        :param theFuzz:
        :type theFuzz: float
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_SetFuzzyValue(self, *args)


    def FuzzyValue(self, *args) -> "Standard_Real":
        """
        * Returns the additional tolerance

        :rtype: float

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Check_FuzzyValue(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_Check
BRepAlgoAPI_Check.SetData = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_SetData, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check.Perform = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_Perform, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check.IsValid = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_IsValid, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check.Result = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_Result, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check.SetFuzzyValue = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_SetFuzzyValue, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check.FuzzyValue = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Check_FuzzyValue, None, BRepAlgoAPI_Check)
BRepAlgoAPI_Check_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Check_swigregister
BRepAlgoAPI_Check_swigregister(BRepAlgoAPI_Check)

class BRepAlgoAPI_BooleanOperation(BRepAlgoAPI_BuilderAlgo):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Shape1(self, *args) -> "TopoDS_Shape const":
        """
        * Returns the first argument involved in this Boolean operation. Obsolete

        :rtype: TopoDS_Shape

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Shape1(self, *args)


    def Shape2(self, *args) -> "TopoDS_Shape const":
        """
        * Returns the second argument involved in this Boolean operation. Obsolete

        :rtype: TopoDS_Shape

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Shape2(self, *args)


    def SetTools(self, *args) -> "void":
        """
        * Sets the tools

        :param theLS:
        :type theLS: TopTools_ListOfShape &
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SetTools(self, *args)


    def Tools(self, *args) -> "TopTools_ListOfShape const &":
        """
        * Gets the tools

        :rtype: TopTools_ListOfShape

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Tools(self, *args)


    def SetOperation(self, *args) -> "void":
        """
        * Sets the type of Boolean operation

        :param anOp:
        :type anOp: BOPAlgo_Operation
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SetOperation(self, *args)


    def Operation(self, *args) -> "BOPAlgo_Operation":
        """
        * Returns the type of Boolean Operation

        :rtype: BOPAlgo_Operation

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Operation(self, *args)


    def BuilderCanWork(self, *args) -> "Standard_Boolean":
        """
        * Returns True if there was no errors occured obsolete

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_BuilderCanWork(self, *args)


    def FuseEdges(self, *args) -> "Standard_Boolean":
        """
        * Returns the flag of edge refining

        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_FuseEdges(self, *args)


    def RefineEdges(self, *args) -> "void":
        """
        * Fuse C1 edges

        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_RefineEdges(self, *args)


    def SectionEdges(self, *args) -> "TopTools_ListOfShape const &":
        """
        * Returns a list of section edges. The edges represent the result of intersection between arguments of Boolean Operation. They are computed during operation execution.

        :rtype: TopTools_ListOfShape

        """
        return _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SectionEdges(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_BooleanOperation
BRepAlgoAPI_BooleanOperation.Shape1 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Shape1, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.Shape2 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Shape2, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.SetTools = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SetTools, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.Tools = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Tools, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.SetOperation = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SetOperation, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.Operation = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_Operation, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.BuilderCanWork = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_BuilderCanWork, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.FuseEdges = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_FuseEdges, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.RefineEdges = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_RefineEdges, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation.SectionEdges = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_SectionEdges, None, BRepAlgoAPI_BooleanOperation)
BRepAlgoAPI_BooleanOperation_swigregister = _BRepAlgoAPI.BRepAlgoAPI_BooleanOperation_swigregister
BRepAlgoAPI_BooleanOperation_swigregister(BRepAlgoAPI_BooleanOperation)

class BRepAlgoAPI_Common(BRepAlgoAPI_BooleanOperation):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor

        :rtype: None

        * Empty constructor <PF> - PaveFiller object that is carried out

        :param PF:
        :type PF: BOPAlgo_PaveFiller &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation <PF> - PaveFiller object that is carried out Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :param PF:
        :type PF: BOPAlgo_PaveFiller &
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_Common_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_Common(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_Common
BRepAlgoAPI_Common_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Common_swigregister
BRepAlgoAPI_Common_swigregister(BRepAlgoAPI_Common)

class BRepAlgoAPI_Cut(BRepAlgoAPI_BooleanOperation):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor

        :rtype: None

        * Empty constructor <PF> - PaveFiller object that is carried out

        :param PF:
        :type PF: BOPAlgo_PaveFiller &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation <PF> - PaveFiller object that is carried out Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :param aDSF:
        :type aDSF: BOPAlgo_PaveFiller &
        :param bFWD: default value is Standard_True
        :type bFWD: bool
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_Cut_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_Cut(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_Cut
BRepAlgoAPI_Cut_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Cut_swigregister
BRepAlgoAPI_Cut_swigregister(BRepAlgoAPI_Cut)

class BRepAlgoAPI_Fuse(BRepAlgoAPI_BooleanOperation):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor

        :rtype: None

        * Empty constructor <PF> - PaveFiller object that is carried out

        :param PF:
        :type PF: BOPAlgo_PaveFiller &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <anOperation> - the type of the operation <PF> - PaveFiller object that is carried out Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :param aDSF:
        :type aDSF: BOPAlgo_PaveFiller &
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_Fuse_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_Fuse(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_Fuse
BRepAlgoAPI_Fuse_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Fuse_swigregister
BRepAlgoAPI_Fuse_swigregister(BRepAlgoAPI_Fuse)

class BRepAlgoAPI_Section(BRepAlgoAPI_BooleanOperation):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor

        :rtype: None

        * Empty constructor <PF> - PaveFiller object that is carried out

        :param PF:
        :type PF: BOPAlgo_PaveFiller &
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        * Constructor with two shapes <S1> -argument <S2> -tool <PF> - PaveFiller object that is carried out <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param S2:
        :type S2: TopoDS_Shape &
        :param aDSF:
        :type aDSF: BOPAlgo_PaveFiller &
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        * Constructor with two shapes <S1> - argument <Pl> - tool <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param Pl:
        :type Pl: gp_Pln
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        * Constructor with two shapes <S1> - argument <Sf> - tool <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :param Sf:
        :type Sf: Handle_Geom_Surface &
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        * Constructor with two shapes <Sf> - argument <S2> - tool <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param Sf:
        :type Sf: Handle_Geom_Surface &
        :param S2:
        :type S2: TopoDS_Shape &
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        * Constructor with two shapes <Sf1> - argument <Sf2> - tool <PerformNow> - the flag: if <PerformNow>=True - the algorithm is performed immediatly Obsolete

        :param Sf1:
        :type Sf1: Handle_Geom_Surface &
        :param Sf2:
        :type Sf2: Handle_Geom_Surface &
        :param PerformNow: default value is Standard_True
        :type PerformNow: bool
        :rtype: None

        """
        _BRepAlgoAPI.BRepAlgoAPI_Section_swiginit(self, _BRepAlgoAPI.new_BRepAlgoAPI_Section(*args))

    def Init1(self, *args) -> "void":
        """
        * initialize the argument <S1> - argument Obsolete

        :param S1:
        :type S1: TopoDS_Shape &
        :rtype: None

        * initialize the argument <Pl> - argument Obsolete

        :param Pl:
        :type Pl: gp_Pln
        :rtype: None

        * initialize the argument <Sf> - argument Obsolete

        :param Sf:
        :type Sf: Handle_Geom_Surface &
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_Init1(self, *args)


    def Init2(self, *args) -> "void":
        """
        * initialize the tool <S2> - tool Obsolete

        :param S2:
        :type S2: TopoDS_Shape &
        :rtype: None

        * initialize the tool <Pl> - tool Obsolete

        :param Pl:
        :type Pl: gp_Pln
        :rtype: None

        * initialize the tool <Sf> - tool Obsolete

        :param Sf:
        :type Sf: Handle_Geom_Surface &
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_Init2(self, *args)


    def Approximation(self, *args) -> "void":
        """
        :param B:
        :type B: bool
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_Approximation(self, *args)


    def ComputePCurveOn1(self, *args) -> "void":
        """
        * Indicates whether the P-Curve should be (or not) performed on the argument. By default, no parametric 2D curve (pcurve) is defined for the edges of the result. If ComputePCurve1 equals true, further computations performed to attach an P-Curve in the parametric space of the argument to the constructed edges. Obsolete

        :param B:
        :type B: bool
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_ComputePCurveOn1(self, *args)


    def ComputePCurveOn2(self, *args) -> "void":
        """
        * Indicates whether the P-Curve should be (or not) performed on the tool. By default, no parametric 2D curve (pcurve) is defined for the edges of the result. If ComputePCurve1 equals true, further computations performed to attach an P-Curve in the parametric space of the tool to the constructed edges. Obsolete

        :param B:
        :type B: bool
        :rtype: None

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_ComputePCurveOn2(self, *args)


    def HasAncestorFaceOn1(self, *args) -> "Standard_Boolean":
        """
        * get the face of the first part giving section edge <E>. Returns True on the 3 following conditions : 1/ <E> is an edge returned by the Shape() metwod. 2/ First part of section performed is a shape. 3/ <E> is built on a intersection curve (i.e <E> is not the result of common edges) When False, F remains untouched. Obsolete

        :param E:
        :type E: TopoDS_Shape &
        :param F:
        :type F: TopoDS_Shape &
        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_HasAncestorFaceOn1(self, *args)


    def HasAncestorFaceOn2(self, *args) -> "Standard_Boolean":
        """
        * Identifies the ancestor faces of the intersection edge E resulting from the last computation performed in this framework, that is, the faces of the two original shapes on which the edge E lies: - HasAncestorFaceOn1 gives the ancestor face in the first shape, and - HasAncestorFaceOn2 gives the ancestor face in the second shape. These functions return true if an ancestor face F is found, or false if not. An ancestor face is identifiable for the edge E if the following conditions are satisfied: - the first part on which this algorithm performed its last computation is a shape, that is, it was not given as a surface or a plane at the time of construction of this algorithm or at a later time by the Init1 function, - E is one of the elementary edges built by the last computation of this section algorithm. To use these functions properly, you have to test the returned Boolean value before using the ancestor face: F is significant only if the returned Boolean value equals true. Obsolete

        :param E:
        :type E: TopoDS_Shape &
        :param F:
        :type F: TopoDS_Shape &
        :rtype: bool

        """
        return _BRepAlgoAPI.BRepAlgoAPI_Section_HasAncestorFaceOn2(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepAlgoAPI.delete_BRepAlgoAPI_Section
BRepAlgoAPI_Section.Init1 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_Init1, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.Init2 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_Init2, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.Approximation = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_Approximation, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.ComputePCurveOn1 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_ComputePCurveOn1, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.ComputePCurveOn2 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_ComputePCurveOn2, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.HasAncestorFaceOn1 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_HasAncestorFaceOn1, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section.HasAncestorFaceOn2 = new_instancemethod(_BRepAlgoAPI.BRepAlgoAPI_Section_HasAncestorFaceOn2, None, BRepAlgoAPI_Section)
BRepAlgoAPI_Section_swigregister = _BRepAlgoAPI.BRepAlgoAPI_Section_swigregister
BRepAlgoAPI_Section_swigregister(BRepAlgoAPI_Section)



