# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
Provides global functions to compute a shape's global
properties for lines, surfaces or volumes, and bring
them together with the global properties already
computed for a geometric system.
The global properties computed for a system are :
- its mass,
- its center of mass,
- its matrix of inertia,
- its moment about an axis,
- its radius of gyration about an axis,
- and its principal properties of inertia such as
principal axis, principal moments, principal radius of gyration.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _BRepGProp.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_BRepGProp')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_BRepGProp')
    _BRepGProp = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_BRepGProp', [dirname(__file__)])
        except ImportError:
            import _BRepGProp
            return _BRepGProp
        try:
            _mod = imp.load_module('_BRepGProp', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _BRepGProp = swig_import_helper()
    del swig_import_helper
else:
    import _BRepGProp
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _BRepGProp.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_BRepGProp.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_BRepGProp.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_BRepGProp.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_BRepGProp.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_BRepGProp.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_BRepGProp.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_BRepGProp.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_BRepGProp.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_BRepGProp.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_BRepGProp.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_BRepGProp.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_BRepGProp.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_BRepGProp.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_BRepGProp.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_BRepGProp.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_BRepGProp.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _BRepGProp.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _BRepGProp.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.TopoDS
import OCC.Core.MMgt
import OCC.Core.Standard
import OCC.Core.TCollection
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.TopAbs
import OCC.Core.GProp
import OCC.Core.TColgp
import OCC.Core.TColStd
import OCC.Core.BRepAdaptor
import OCC.Core.Adaptor3d
import OCC.Core.GeomAbs
import OCC.Core.Geom
import OCC.Core.Adaptor2d
import OCC.Core.Geom2d
import OCC.Core.math
import OCC.Core.GeomAdaptor
import OCC.Core.Geom2dAdaptor
class brepgprop(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def LinearProperties(*args) -> "void":
        """
        * Computes the linear global properties of the shape S, i.e. the global properties induced by each edge of the shape S, and brings them together with the global properties still retained by the framework LProps. If the current system of LProps was empty, its global properties become equal to the linear global properties of S. For this computation no linear density is attached to the edges. So, for example, the added mass corresponds to the sum of the lengths of the edges of S. The density of the composed systems, i.e. that of each component of the current system of LProps, and that of S which is considered to be equal to 1, must be coherent. Note that this coherence cannot be checked. You are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework LProps. Note: if your programming ensures that the framework LProps retains only linear global properties (brought together for example, by the function LinearProperties) for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total length of edges of the system analysed by LProps. Warning No check is performed to verify that the shape S retains truly linear properties. If S is simply a vertex, it is not considered to present any additional global properties.

        :param S:
        :type S: TopoDS_Shape &
        :param LProps:
        :type LProps: GProp_GProps &
        :rtype: void

        """
        return _BRepGProp.brepgprop_LinearProperties(*args)

    LinearProperties = staticmethod(LinearProperties)

    def SurfaceProperties(*args) -> "Standard_Real":
        """
        * Computes the surface global properties of the shape S, i.e. the global properties induced by each face of the shape S, and brings them together with the global properties still retained by the framework SProps. If the current system of SProps was empty, its global properties become equal to the surface global properties of S. For this computation, no surface density is attached to the faces. Consequently, the added mass corresponds to the sum of the areas of the faces of S. The density of the component systems, i.e. that of each component of the current system of SProps, and that of S which is considered to be equal to 1, must be coherent. Note that this coherence cannot be checked. You are advised to use a framework for each different value of density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework SProps. Note : if your programming ensures that the framework SProps retains only surface global properties, brought together, for example, by the function SurfaceProperties, for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total area of faces of the system analysed by SProps. Warning No check is performed to verify that the shape S retains truly surface properties. If S is simply a vertex, an edge or a wire, it is not considered to present any additional global properties.

        :param S:
        :type S: TopoDS_Shape &
        :param SProps:
        :type SProps: GProp_GProps &
        :rtype: void

        * Updates <SProps> with the shape <S>, that contains its pricipal properties. The surface properties of all the faces in <S> are computed. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (area) for each face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. Method returns estimation of relative error reached for whole shape. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration. //! Computes the global volume properties of the solid S, and brings them together with the global properties still retained by the framework VProps. If the current system of VProps was empty, its global properties become equal to the global properties of S for volume. For this computation, no volume density is attached to the solid. Consequently, the added mass corresponds to the volume of S. The density of the component systems, i.e. that of each component of the current system of VProps, and that of S which is considered to be equal to 1, must be coherent to each other. Note that this coherence cannot be checked. You are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework VProps. Note: if your programming ensures that the framework VProps retains only global properties of volume (brought together for example, by the function VolumeProperties) for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total volume of the solids of the system analysed by VProps. Warning The shape S must represent an object whose global volume properties can be computed. It may be a finite solid, or a series of finite solids all oriented in a coherent way. Nonetheless, S must be exempt of any free boundary. Note that these conditions of coherence are not checked by this algorithm, and results will be false if they are not respected.

        :param S:
        :type S: TopoDS_Shape &
        :param SProps:
        :type SProps: GProp_GProps &
        :param Eps:
        :type Eps: float
        :rtype: float

        """
        return _BRepGProp.brepgprop_SurfaceProperties(*args)

    SurfaceProperties = staticmethod(SurfaceProperties)

    def VolumeProperties(*args) -> "Standard_Real":
        """
        :param S:
        :type S: TopoDS_Shape &
        :param VProps:
        :type VProps: GProp_GProps &
        :param OnlyClosed: default value is Standard_False
        :type OnlyClosed: bool
        :rtype: void

        * Updates <VProps> with the shape <S>, that contains its pricipal properties. The volume properties of all the FORWARD and REVERSED faces in <S> are computed. If OnlyClosed is True then computed faces must belong to closed Shells. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for each face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. Method returns estimation of relative error reached for whole shape. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

        :param S:
        :type S: TopoDS_Shape &
        :param VProps:
        :type VProps: GProp_GProps &
        :param Eps:
        :type Eps: float
        :param OnlyClosed: default value is Standard_False
        :type OnlyClosed: bool
        :rtype: float

        """
        return _BRepGProp.brepgprop_VolumeProperties(*args)

    VolumeProperties = staticmethod(VolumeProperties)

    def VolumePropertiesGK(*args) -> "Standard_Real":
        """
        * Updates <VProps> with the shape <S>, that contains its pricipal properties. The volume properties of all the FORWARD and REVERSED faces in <S> are computed. If OnlyClosed is True then computed faces must belong to closed Shells. Adaptive 2D Gauss integration is used. Parameter IsUseSpan says if it is necessary to define spans on a face. This option has an effect only for BSpline faces. Parameter Eps sets maximal relative error of computed property for each face. Error is delivered by the adaptive Gauss-Kronrod method of integral computation that is used for properties computation. Method returns estimation of relative error reached for whole shape. Returns negative value if the computation is failed.

        :param S:
        :type S: TopoDS_Shape &
        :param VProps:
        :type VProps: GProp_GProps &
        :param Eps: default value is 0.001
        :type Eps: float
        :param OnlyClosed: default value is Standard_False
        :type OnlyClosed: bool
        :param IsUseSpan: default value is Standard_False
        :type IsUseSpan: bool
        :param CGFlag: default value is Standard_False
        :type CGFlag: bool
        :param IFlag: default value is Standard_False
        :type IFlag: bool
        :rtype: float

        :param S:
        :type S: TopoDS_Shape &
        :param VProps:
        :type VProps: GProp_GProps &
        :param thePln:
        :type thePln: gp_Pln
        :param Eps: default value is 0.001
        :type Eps: float
        :param OnlyClosed: default value is Standard_False
        :type OnlyClosed: bool
        :param IsUseSpan: default value is Standard_False
        :type IsUseSpan: bool
        :param CGFlag: default value is Standard_False
        :type CGFlag: bool
        :param IFlag: default value is Standard_False
        :type IFlag: bool
        :rtype: float

        """
        return _BRepGProp.brepgprop_VolumePropertiesGK(*args)

    VolumePropertiesGK = staticmethod(VolumePropertiesGK)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepGProp.brepgprop_swiginit(self, _BRepGProp.new_brepgprop())
    __swig_destroy__ = _BRepGProp.delete_brepgprop
brepgprop_swigregister = _BRepGProp.brepgprop_swigregister
brepgprop_swigregister(brepgprop)

def brepgprop_LinearProperties(*args) -> "void":
    """
    * Computes the linear global properties of the shape S, i.e. the global properties induced by each edge of the shape S, and brings them together with the global properties still retained by the framework LProps. If the current system of LProps was empty, its global properties become equal to the linear global properties of S. For this computation no linear density is attached to the edges. So, for example, the added mass corresponds to the sum of the lengths of the edges of S. The density of the composed systems, i.e. that of each component of the current system of LProps, and that of S which is considered to be equal to 1, must be coherent. Note that this coherence cannot be checked. You are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework LProps. Note: if your programming ensures that the framework LProps retains only linear global properties (brought together for example, by the function LinearProperties) for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total length of edges of the system analysed by LProps. Warning No check is performed to verify that the shape S retains truly linear properties. If S is simply a vertex, it is not considered to present any additional global properties.

    :param S:
    :type S: TopoDS_Shape &
    :param LProps:
    :type LProps: GProp_GProps &
    :rtype: void

    """
    return _BRepGProp.brepgprop_LinearProperties(*args)

def brepgprop_SurfaceProperties(*args) -> "Standard_Real":
    """
    * Computes the surface global properties of the shape S, i.e. the global properties induced by each face of the shape S, and brings them together with the global properties still retained by the framework SProps. If the current system of SProps was empty, its global properties become equal to the surface global properties of S. For this computation, no surface density is attached to the faces. Consequently, the added mass corresponds to the sum of the areas of the faces of S. The density of the component systems, i.e. that of each component of the current system of SProps, and that of S which is considered to be equal to 1, must be coherent. Note that this coherence cannot be checked. You are advised to use a framework for each different value of density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework SProps. Note : if your programming ensures that the framework SProps retains only surface global properties, brought together, for example, by the function SurfaceProperties, for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total area of faces of the system analysed by SProps. Warning No check is performed to verify that the shape S retains truly surface properties. If S is simply a vertex, an edge or a wire, it is not considered to present any additional global properties.

    :param S:
    :type S: TopoDS_Shape &
    :param SProps:
    :type SProps: GProp_GProps &
    :rtype: void

    * Updates <SProps> with the shape <S>, that contains its pricipal properties. The surface properties of all the faces in <S> are computed. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (area) for each face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. Method returns estimation of relative error reached for whole shape. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration. //! Computes the global volume properties of the solid S, and brings them together with the global properties still retained by the framework VProps. If the current system of VProps was empty, its global properties become equal to the global properties of S for volume. For this computation, no volume density is attached to the solid. Consequently, the added mass corresponds to the volume of S. The density of the component systems, i.e. that of each component of the current system of VProps, and that of S which is considered to be equal to 1, must be coherent to each other. Note that this coherence cannot be checked. You are advised to use a separate framework for each density, and then to bring these frameworks together into a global one. The point relative to which the inertia of the system is computed is the reference point of the framework VProps. Note: if your programming ensures that the framework VProps retains only global properties of volume (brought together for example, by the function VolumeProperties) for objects the density of which is equal to 1 (or is not defined), the function Mass will return the total volume of the solids of the system analysed by VProps. Warning The shape S must represent an object whose global volume properties can be computed. It may be a finite solid, or a series of finite solids all oriented in a coherent way. Nonetheless, S must be exempt of any free boundary. Note that these conditions of coherence are not checked by this algorithm, and results will be false if they are not respected.

    :param S:
    :type S: TopoDS_Shape &
    :param SProps:
    :type SProps: GProp_GProps &
    :param Eps:
    :type Eps: float
    :rtype: float

    """
    return _BRepGProp.brepgprop_SurfaceProperties(*args)

def brepgprop_VolumeProperties(*args) -> "Standard_Real":
    """
    :param S:
    :type S: TopoDS_Shape &
    :param VProps:
    :type VProps: GProp_GProps &
    :param OnlyClosed: default value is Standard_False
    :type OnlyClosed: bool
    :rtype: void

    * Updates <VProps> with the shape <S>, that contains its pricipal properties. The volume properties of all the FORWARD and REVERSED faces in <S> are computed. If OnlyClosed is True then computed faces must belong to closed Shells. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for each face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. Method returns estimation of relative error reached for whole shape. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

    :param S:
    :type S: TopoDS_Shape &
    :param VProps:
    :type VProps: GProp_GProps &
    :param Eps:
    :type Eps: float
    :param OnlyClosed: default value is Standard_False
    :type OnlyClosed: bool
    :rtype: float

    """
    return _BRepGProp.brepgprop_VolumeProperties(*args)

def brepgprop_VolumePropertiesGK(*args) -> "Standard_Real":
    """
    * Updates <VProps> with the shape <S>, that contains its pricipal properties. The volume properties of all the FORWARD and REVERSED faces in <S> are computed. If OnlyClosed is True then computed faces must belong to closed Shells. Adaptive 2D Gauss integration is used. Parameter IsUseSpan says if it is necessary to define spans on a face. This option has an effect only for BSpline faces. Parameter Eps sets maximal relative error of computed property for each face. Error is delivered by the adaptive Gauss-Kronrod method of integral computation that is used for properties computation. Method returns estimation of relative error reached for whole shape. Returns negative value if the computation is failed.

    :param S:
    :type S: TopoDS_Shape &
    :param VProps:
    :type VProps: GProp_GProps &
    :param Eps: default value is 0.001
    :type Eps: float
    :param OnlyClosed: default value is Standard_False
    :type OnlyClosed: bool
    :param IsUseSpan: default value is Standard_False
    :type IsUseSpan: bool
    :param CGFlag: default value is Standard_False
    :type CGFlag: bool
    :param IFlag: default value is Standard_False
    :type IFlag: bool
    :rtype: float

    :param S:
    :type S: TopoDS_Shape &
    :param VProps:
    :type VProps: GProp_GProps &
    :param thePln:
    :type thePln: gp_Pln
    :param Eps: default value is 0.001
    :type Eps: float
    :param OnlyClosed: default value is Standard_False
    :type OnlyClosed: bool
    :param IsUseSpan: default value is Standard_False
    :type IsUseSpan: bool
    :param CGFlag: default value is Standard_False
    :type CGFlag: bool
    :param IFlag: default value is Standard_False
    :type IFlag: bool
    :rtype: float

    """
    return _BRepGProp.brepgprop_VolumePropertiesGK(*args)

class BRepGProp_Cinert(OCC.Core.GProp.GProp_GProps):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param C:
        :type C: BRepAdaptor_Curve &
        :param CLocation:
        :type CLocation: gp_Pnt
        :rtype: None

        """
        _BRepGProp.BRepGProp_Cinert_swiginit(self, _BRepGProp.new_BRepGProp_Cinert(*args))

    def SetLocation(self, *args) -> "void":
        """
        :param CLocation:
        :type CLocation: gp_Pnt
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Cinert_SetLocation(self, *args)


    def Perform(self, *args) -> "void":
        """
        :param C:
        :type C: BRepAdaptor_Curve &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Cinert_Perform(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Cinert
BRepGProp_Cinert.SetLocation = new_instancemethod(_BRepGProp.BRepGProp_Cinert_SetLocation, None, BRepGProp_Cinert)
BRepGProp_Cinert.Perform = new_instancemethod(_BRepGProp.BRepGProp_Cinert_Perform, None, BRepGProp_Cinert)
BRepGProp_Cinert_swigregister = _BRepGProp.BRepGProp_Cinert_swigregister
BRepGProp_Cinert_swigregister(BRepGProp_Cinert)

class BRepGProp_Domain(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor.

        :rtype: None

        * Constructor. Initializes the domain with the face.

        :param F:
        :type F: TopoDS_Face &
        :rtype: None

        """
        _BRepGProp.BRepGProp_Domain_swiginit(self, _BRepGProp.new_BRepGProp_Domain(*args))

    def More(self, *args) -> "Standard_Boolean":
        """
        * Returns True if there is another arc of curve in the list.

        :rtype: bool

        """
        return _BRepGProp.BRepGProp_Domain_More(self, *args)


    def Init(self, *args) -> "void":
        """
        * Initializes the domain with the face.

        :param F:
        :type F: TopoDS_Face &
        :rtype: None

        * Initializes the exploration with the face already set.

        :rtype: None

        """
        return _BRepGProp.BRepGProp_Domain_Init(self, *args)


    def Value(self, *args) -> "TopoDS_Edge const":
        """
        * Returns the current edge.

        :rtype: TopoDS_Edge

        """
        return _BRepGProp.BRepGProp_Domain_Value(self, *args)


    def Next(self, *args) -> "void":
        """
        * Sets the index of the arc iterator to the next arc of curve.

        :rtype: None

        """
        return _BRepGProp.BRepGProp_Domain_Next(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Domain
BRepGProp_Domain.More = new_instancemethod(_BRepGProp.BRepGProp_Domain_More, None, BRepGProp_Domain)
BRepGProp_Domain.Init = new_instancemethod(_BRepGProp.BRepGProp_Domain_Init, None, BRepGProp_Domain)
BRepGProp_Domain.Value = new_instancemethod(_BRepGProp.BRepGProp_Domain_Value, None, BRepGProp_Domain)
BRepGProp_Domain.Next = new_instancemethod(_BRepGProp.BRepGProp_Domain_Next, None, BRepGProp_Domain)
BRepGProp_Domain_swigregister = _BRepGProp.BRepGProp_Domain_swigregister
BRepGProp_Domain_swigregister(BRepGProp_Domain)

class BRepGProp_EdgeTool(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def FirstParameter(*args) -> "Standard_Real":
        """
        * Returns the parametric value of the start point of the curve. The curve is oriented from the start point to the end point.

        :param C:
        :type C: BRepAdaptor_Curve &
        :rtype: float

        """
        return _BRepGProp.BRepGProp_EdgeTool_FirstParameter(*args)

    FirstParameter = staticmethod(FirstParameter)

    def LastParameter(*args) -> "Standard_Real":
        """
        * Returns the parametric value of the end point of the curve. The curve is oriented from the start point to the end point.

        :param C:
        :type C: BRepAdaptor_Curve &
        :rtype: float

        """
        return _BRepGProp.BRepGProp_EdgeTool_LastParameter(*args)

    LastParameter = staticmethod(LastParameter)

    def IntegrationOrder(*args) -> "Standard_Integer":
        """
        * Returns the number of Gauss points required to do the integration with a good accuracy using the Gauss method. For a polynomial curve of degree n the maxima of accuracy is obtained with an order of integration equal to 2*n-1.

        :param C:
        :type C: BRepAdaptor_Curve &
        :rtype: int

        """
        return _BRepGProp.BRepGProp_EdgeTool_IntegrationOrder(*args)

    IntegrationOrder = staticmethod(IntegrationOrder)

    def Value(*args) -> "gp_Pnt":
        """
        * Returns the point of parameter U on the loaded curve.

        :param C:
        :type C: BRepAdaptor_Curve &
        :param U:
        :type U: float
        :rtype: gp_Pnt

        """
        return _BRepGProp.BRepGProp_EdgeTool_Value(*args)

    Value = staticmethod(Value)

    def D1(*args) -> "void":
        """
        * Returns the point of parameter U and the first derivative at this point.

        :param C:
        :type C: BRepAdaptor_Curve &
        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt
        :param V1:
        :type V1: gp_Vec
        :rtype: void

        """
        return _BRepGProp.BRepGProp_EdgeTool_D1(*args)

    D1 = staticmethod(D1)

    def NbIntervals(*args) -> "Standard_Integer":
        """
        * Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>

        :param C:
        :type C: BRepAdaptor_Curve &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: int

        """
        return _BRepGProp.BRepGProp_EdgeTool_NbIntervals(*args)

    NbIntervals = staticmethod(NbIntervals)

    def Intervals(*args) -> "void":
        """
        * Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accomodate for the parameters. i.e. T.Length() > NbIntervals()

        :param C:
        :type C: BRepAdaptor_Curve &
        :param T:
        :type T: TColStd_Array1OfReal &
        :param S:
        :type S: GeomAbs_Shape
        :rtype: void

        """
        return _BRepGProp.BRepGProp_EdgeTool_Intervals(*args)

    Intervals = staticmethod(Intervals)

    __repr__ = _dumps_object


    def __init__(self):
        _BRepGProp.BRepGProp_EdgeTool_swiginit(self, _BRepGProp.new_BRepGProp_EdgeTool())
    __swig_destroy__ = _BRepGProp.delete_BRepGProp_EdgeTool
BRepGProp_EdgeTool_swigregister = _BRepGProp.BRepGProp_EdgeTool_swigregister
BRepGProp_EdgeTool_swigregister(BRepGProp_EdgeTool)

def BRepGProp_EdgeTool_FirstParameter(*args) -> "Standard_Real":
    """
    * Returns the parametric value of the start point of the curve. The curve is oriented from the start point to the end point.

    :param C:
    :type C: BRepAdaptor_Curve &
    :rtype: float

    """
    return _BRepGProp.BRepGProp_EdgeTool_FirstParameter(*args)

def BRepGProp_EdgeTool_LastParameter(*args) -> "Standard_Real":
    """
    * Returns the parametric value of the end point of the curve. The curve is oriented from the start point to the end point.

    :param C:
    :type C: BRepAdaptor_Curve &
    :rtype: float

    """
    return _BRepGProp.BRepGProp_EdgeTool_LastParameter(*args)

def BRepGProp_EdgeTool_IntegrationOrder(*args) -> "Standard_Integer":
    """
    * Returns the number of Gauss points required to do the integration with a good accuracy using the Gauss method. For a polynomial curve of degree n the maxima of accuracy is obtained with an order of integration equal to 2*n-1.

    :param C:
    :type C: BRepAdaptor_Curve &
    :rtype: int

    """
    return _BRepGProp.BRepGProp_EdgeTool_IntegrationOrder(*args)

def BRepGProp_EdgeTool_Value(*args) -> "gp_Pnt":
    """
    * Returns the point of parameter U on the loaded curve.

    :param C:
    :type C: BRepAdaptor_Curve &
    :param U:
    :type U: float
    :rtype: gp_Pnt

    """
    return _BRepGProp.BRepGProp_EdgeTool_Value(*args)

def BRepGProp_EdgeTool_D1(*args) -> "void":
    """
    * Returns the point of parameter U and the first derivative at this point.

    :param C:
    :type C: BRepAdaptor_Curve &
    :param U:
    :type U: float
    :param P:
    :type P: gp_Pnt
    :param V1:
    :type V1: gp_Vec
    :rtype: void

    """
    return _BRepGProp.BRepGProp_EdgeTool_D1(*args)

def BRepGProp_EdgeTool_NbIntervals(*args) -> "Standard_Integer":
    """
    * Returns the number of intervals for continuity <S>. May be one if Continuity(me) >= <S>

    :param C:
    :type C: BRepAdaptor_Curve &
    :param S:
    :type S: GeomAbs_Shape
    :rtype: int

    """
    return _BRepGProp.BRepGProp_EdgeTool_NbIntervals(*args)

def BRepGProp_EdgeTool_Intervals(*args) -> "void":
    """
    * Stores in <T> the parameters bounding the intervals of continuity <S>. //! The array must provide enough room to accomodate for the parameters. i.e. T.Length() > NbIntervals()

    :param C:
    :type C: BRepAdaptor_Curve &
    :param T:
    :type T: TColStd_Array1OfReal &
    :param S:
    :type S: GeomAbs_Shape
    :rtype: void

    """
    return _BRepGProp.BRepGProp_EdgeTool_Intervals(*args)

class BRepGProp_Face(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructor. Initializes the object with a flag IsUseSpan that says if it is necessary to define spans on a face. This option has an effect only for BSpline faces. Spans are returned by the methods GetUKnots and GetTKnots.

        :param IsUseSpan: default value is Standard_False
        :type IsUseSpan: bool
        :rtype: None

        * Constructor. Initializes the object with the face and the flag IsUseSpan that says if it is necessary to define spans on a face. This option has an effect only for BSpline faces. Spans are returned by the methods GetUKnots and GetTKnots.

        :param F:
        :type F: TopoDS_Face &
        :param IsUseSpan: default value is Standard_False
        :type IsUseSpan: bool
        :rtype: None

        """
        _BRepGProp.BRepGProp_Face_swiginit(self, _BRepGProp.new_BRepGProp_Face(*args))

    def VIntegrationOrder(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_VIntegrationOrder(self, *args)


    def NaturalRestriction(self, *args) -> "Standard_Boolean":
        """
        * Returns Standard_True if the face is not trimmed.

        :rtype: bool

        """
        return _BRepGProp.BRepGProp_Face_NaturalRestriction(self, *args)


    def Value2d(self, *args) -> "gp_Pnt2d":
        """
        * Returns the value of the boundary curve of the face.

        :param U:
        :type U: float
        :rtype: gp_Pnt2d

        """
        return _BRepGProp.BRepGProp_Face_Value2d(self, *args)


    def SIntOrder(self, *args) -> "Standard_Integer":
        """
        :param Eps:
        :type Eps: float
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_SIntOrder(self, *args)


    def SVIntSubs(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_SVIntSubs(self, *args)


    def SUIntSubs(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_SUIntSubs(self, *args)


    def UKnots(self, *args) -> "void":
        """
        :param Knots:
        :type Knots: TColStd_Array1OfReal &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_UKnots(self, *args)


    def VKnots(self, *args) -> "void":
        """
        :param Knots:
        :type Knots: TColStd_Array1OfReal &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_VKnots(self, *args)


    def LIntOrder(self, *args) -> "Standard_Integer":
        """
        :param Eps:
        :type Eps: float
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_LIntOrder(self, *args)


    def LIntSubs(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_LIntSubs(self, *args)


    def LKnots(self, *args) -> "void":
        """
        :param Knots:
        :type Knots: TColStd_Array1OfReal &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_LKnots(self, *args)


    def UIntegrationOrder(self, *args) -> "Standard_Integer":
        """
        * Returns the number of points required to do the integration in the U parametric direction with a good accuracy.

        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_UIntegrationOrder(self, *args)


    def Bounds(self, *args) -> "void":
        """
        * Returns the parametric bounds of the Face.

        :param U1:
        :type U1: float &
        :param U2:
        :type U2: float &
        :param V1:
        :type V1: float &
        :param V2:
        :type V2: float &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_Bounds(self, *args)


    def Normal(self, *args) -> "void":
        """
        * Computes the point of parameter U, V on the Face <S> and the normal to the face at this point.

        :param U:
        :type U: float
        :param V:
        :type V: float
        :param P:
        :type P: gp_Pnt
        :param VNor:
        :type VNor: gp_Vec
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_Normal(self, *args)


    def FirstParameter(self, *args) -> "Standard_Real":
        """
        * Returns the parametric value of the start point of the current arc of curve.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_Face_FirstParameter(self, *args)


    def LastParameter(self, *args) -> "Standard_Real":
        """
        * Returns the parametric value of the end point of the current arc of curve.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_Face_LastParameter(self, *args)


    def IntegrationOrder(self, *args) -> "Standard_Integer":
        """
        * Returns the number of points required to do the integration along the parameter of curve.

        :rtype: int

        """
        return _BRepGProp.BRepGProp_Face_IntegrationOrder(self, *args)


    def D12d(self, *args) -> "void":
        """
        * Returns the point of parameter U and the first derivative at this point of a boundary curve.

        :param U:
        :type U: float
        :param P:
        :type P: gp_Pnt2d
        :param V1:
        :type V1: gp_Vec2d
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_D12d(self, *args)


    def Load(self, *args) -> "void":
        """
        :param F:
        :type F: TopoDS_Face &
        :rtype: None

        * Loading the boundary arc.

        :param E:
        :type E: TopoDS_Edge &
        :rtype: None

        * Loading the boundary arc. This arc is either a top, bottom, left or right bound of a UV rectangle in which the parameters of surface are defined. If IsFirstParam is equal to Standard_True, the face is initialized by either left of bottom bound. Otherwise it is initialized by the top or right one. If theIsoType is equal to GeomAbs_IsoU, the face is initialized with either left or right bound. Otherwise - with either top or bottom one.

        :param IsFirstParam:
        :type IsFirstParam: bool
        :param theIsoType:
        :type theIsoType: GeomAbs_IsoType
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_Load(self, *args)


    def GetUKnots(self, *args) -> "void":
        """
        * Returns an array of U knots of the face. The first and last elements of the array will be theUMin and theUMax. The middle elements will be the U Knots of the face greater then theUMin and lower then theUMax in increasing order. If the face is not a BSpline, the array initialized with theUMin and theUMax only.

        :param theUMin:
        :type theUMin: float
        :param theUMax:
        :type theUMax: float
        :param theUKnots:
        :type theUKnots: Handle_TColStd_HArray1OfReal &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_GetUKnots(self, *args)


    def GetTKnots(self, *args) -> "void":
        """
        * Returns an array of combination of T knots of the arc and V knots of the face. The first and last elements of the array will be theTMin and theTMax. The middle elements will be the Knots of the arc and the values of parameters of arc on which the value points have V coordinates close to V knots of face. All the parameter will be greater then theTMin and lower then theTMax in increasing order. If the face is not a BSpline, the array initialized with theTMin and theTMax only.

        :param theTMin:
        :type theTMin: float
        :param theTMax:
        :type theTMax: float
        :param theTKnots:
        :type theTKnots: Handle_TColStd_HArray1OfReal &
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Face_GetTKnots(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Face
BRepGProp_Face.VIntegrationOrder = new_instancemethod(_BRepGProp.BRepGProp_Face_VIntegrationOrder, None, BRepGProp_Face)
BRepGProp_Face.NaturalRestriction = new_instancemethod(_BRepGProp.BRepGProp_Face_NaturalRestriction, None, BRepGProp_Face)
BRepGProp_Face.Value2d = new_instancemethod(_BRepGProp.BRepGProp_Face_Value2d, None, BRepGProp_Face)
BRepGProp_Face.SIntOrder = new_instancemethod(_BRepGProp.BRepGProp_Face_SIntOrder, None, BRepGProp_Face)
BRepGProp_Face.SVIntSubs = new_instancemethod(_BRepGProp.BRepGProp_Face_SVIntSubs, None, BRepGProp_Face)
BRepGProp_Face.SUIntSubs = new_instancemethod(_BRepGProp.BRepGProp_Face_SUIntSubs, None, BRepGProp_Face)
BRepGProp_Face.UKnots = new_instancemethod(_BRepGProp.BRepGProp_Face_UKnots, None, BRepGProp_Face)
BRepGProp_Face.VKnots = new_instancemethod(_BRepGProp.BRepGProp_Face_VKnots, None, BRepGProp_Face)
BRepGProp_Face.LIntOrder = new_instancemethod(_BRepGProp.BRepGProp_Face_LIntOrder, None, BRepGProp_Face)
BRepGProp_Face.LIntSubs = new_instancemethod(_BRepGProp.BRepGProp_Face_LIntSubs, None, BRepGProp_Face)
BRepGProp_Face.LKnots = new_instancemethod(_BRepGProp.BRepGProp_Face_LKnots, None, BRepGProp_Face)
BRepGProp_Face.UIntegrationOrder = new_instancemethod(_BRepGProp.BRepGProp_Face_UIntegrationOrder, None, BRepGProp_Face)
BRepGProp_Face.Bounds = new_instancemethod(_BRepGProp.BRepGProp_Face_Bounds, None, BRepGProp_Face)
BRepGProp_Face.Normal = new_instancemethod(_BRepGProp.BRepGProp_Face_Normal, None, BRepGProp_Face)
BRepGProp_Face.FirstParameter = new_instancemethod(_BRepGProp.BRepGProp_Face_FirstParameter, None, BRepGProp_Face)
BRepGProp_Face.LastParameter = new_instancemethod(_BRepGProp.BRepGProp_Face_LastParameter, None, BRepGProp_Face)
BRepGProp_Face.IntegrationOrder = new_instancemethod(_BRepGProp.BRepGProp_Face_IntegrationOrder, None, BRepGProp_Face)
BRepGProp_Face.D12d = new_instancemethod(_BRepGProp.BRepGProp_Face_D12d, None, BRepGProp_Face)
BRepGProp_Face.Load = new_instancemethod(_BRepGProp.BRepGProp_Face_Load, None, BRepGProp_Face)
BRepGProp_Face.GetUKnots = new_instancemethod(_BRepGProp.BRepGProp_Face_GetUKnots, None, BRepGProp_Face)
BRepGProp_Face.GetTKnots = new_instancemethod(_BRepGProp.BRepGProp_Face_GetTKnots, None, BRepGProp_Face)
BRepGProp_Face_swigregister = _BRepGProp.BRepGProp_Face_swigregister
BRepGProp_Face_swigregister(BRepGProp_Face)

class BRepGProp_Gauss(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr
    Vinert = _BRepGProp.BRepGProp_Gauss_Vinert
    Sinert = _BRepGProp.BRepGProp_Gauss_Sinert

    def __init__(self, *args):
        """
        * Constructor

        :param theType:
        :type theType: BRepGProp_GaussType
        :rtype: None

        """
        _BRepGProp.BRepGProp_Gauss_swiginit(self, _BRepGProp.new_BRepGProp_Gauss(*args))

    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Gauss
BRepGProp_Gauss_swigregister = _BRepGProp.BRepGProp_Gauss_swigregister
BRepGProp_Gauss_swigregister(BRepGProp_Gauss)

class BRepGProp_Sinert(OCC.Core.GProp.GProp_GProps):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param SLocation:
        :type SLocation: gp_Pnt
        :rtype: None

        * Builds a Sinert to evaluate the global properties of the face <S>. If isNaturalRestriction is true the domain of S is defined with the natural bounds, else it defined with an iterator of Edge from TopoDS (see DomainTool from GProp)

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param SLocation:
        :type SLocation: gp_Pnt
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param SLocation:
        :type SLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param SLocation:
        :type SLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        """
        _BRepGProp.BRepGProp_Sinert_swiginit(self, _BRepGProp.new_BRepGProp_Sinert(*args))

    def SetLocation(self, *args) -> "void":
        """
        :param SLocation:
        :type SLocation: gp_Pnt
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Sinert_SetLocation(self, *args)


    def Perform(self, *args) -> "Standard_Real":
        """
        :param S:
        :type S: BRepGProp_Face &
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Eps:
        :type Eps: float
        :rtype: float

        """
        return _BRepGProp.BRepGProp_Sinert_Perform(self, *args)


    def GetEpsilon(self, *args) -> "Standard_Real":
        """
        * If previously used method contained Eps parameter get actual relative error of the computation, else return 1.0.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_Sinert_GetEpsilon(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Sinert
BRepGProp_Sinert.SetLocation = new_instancemethod(_BRepGProp.BRepGProp_Sinert_SetLocation, None, BRepGProp_Sinert)
BRepGProp_Sinert.Perform = new_instancemethod(_BRepGProp.BRepGProp_Sinert_Perform, None, BRepGProp_Sinert)
BRepGProp_Sinert.GetEpsilon = new_instancemethod(_BRepGProp.BRepGProp_Sinert_GetEpsilon, None, BRepGProp_Sinert)
BRepGProp_Sinert_swigregister = _BRepGProp.BRepGProp_Sinert_swigregister
BRepGProp_Sinert_swigregister(BRepGProp_Sinert)

class BRepGProp_TFunction(OCC.Core.math.math_Function):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructor. Initializes the function with the face, the location point, the flag IsByPoint, the coefficients theCoeff that have different meaning depending on the value of IsByPoint. The last two parameters are theUMin - the lower bound of the inner integral. This value is fixed for any integral. And the value of tolerance of inner integral computation. If IsByPoint is equal to Standard_True, the number of the coefficients is equal to 3 and they represent X, Y and Z coordinates (theCoeff[0], theCoeff[1] and theCoeff[2] correspondingly) of the shift if the inertia is computed with respect to the point different then the location. If IsByPoint is equal to Standard_False, the number of the coefficients is 4 and they represent the compbination of plane parameters and shift values.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theVertex:
        :type theVertex: gp_Pnt
        :param IsByPoint:
        :type IsByPoint: bool
        :param theCoeffs:
        :type theCoeffs: Standard_Address
        :param theUMin:
        :type theUMin: float
        :param theTolerance:
        :type theTolerance: float
        :rtype: None

        """
        _BRepGProp.BRepGProp_TFunction_swiginit(self, _BRepGProp.new_BRepGProp_TFunction(*args))

    def Init(self, *args) -> "void":
        """
        :rtype: None

        """
        return _BRepGProp.BRepGProp_TFunction_Init(self, *args)


    def SetNbKronrodPoints(self, *args) -> "void":
        """
        * Setting the expected number of Kronrod points for the outer integral computation. This number is required for computation of a value of tolerance for inner integral computation. After GetStateNumber method call, this number is recomputed by the same law as in math_KronrodSingleIntegration, i.e. next number of points is equal to the current number plus a square root of the current number. If the law in math_KronrodSingleIntegration is changed, the modification algo should be modified accordingly.

        :param theNbPoints:
        :type theNbPoints: int
        :rtype: None

        """
        return _BRepGProp.BRepGProp_TFunction_SetNbKronrodPoints(self, *args)


    def SetValueType(self, *args) -> "void":
        """
        * Setting the type of the value to be returned. This parameter is directly passed to the UFunction.

        :param aType:
        :type aType: GProp_ValueType
        :rtype: None

        """
        return _BRepGProp.BRepGProp_TFunction_SetValueType(self, *args)


    def SetTolerance(self, *args) -> "void":
        """
        * Setting the tolerance for inner integration

        :param aTol:
        :type aTol: float
        :rtype: None

        """
        return _BRepGProp.BRepGProp_TFunction_SetTolerance(self, *args)


    def ErrorReached(self, *args) -> "Standard_Real":
        """
        * Returns the relative reached error of all values computation since the last call of GetStateNumber method.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_TFunction_ErrorReached(self, *args)


    def AbsolutError(self, *args) -> "Standard_Real":
        """
        * Returns the absolut reached error of all values computation since the last call of GetStateNumber method.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_TFunction_AbsolutError(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_TFunction
BRepGProp_TFunction.Init = new_instancemethod(_BRepGProp.BRepGProp_TFunction_Init, None, BRepGProp_TFunction)
BRepGProp_TFunction.SetNbKronrodPoints = new_instancemethod(_BRepGProp.BRepGProp_TFunction_SetNbKronrodPoints, None, BRepGProp_TFunction)
BRepGProp_TFunction.SetValueType = new_instancemethod(_BRepGProp.BRepGProp_TFunction_SetValueType, None, BRepGProp_TFunction)
BRepGProp_TFunction.SetTolerance = new_instancemethod(_BRepGProp.BRepGProp_TFunction_SetTolerance, None, BRepGProp_TFunction)
BRepGProp_TFunction.ErrorReached = new_instancemethod(_BRepGProp.BRepGProp_TFunction_ErrorReached, None, BRepGProp_TFunction)
BRepGProp_TFunction.AbsolutError = new_instancemethod(_BRepGProp.BRepGProp_TFunction_AbsolutError, None, BRepGProp_TFunction)
BRepGProp_TFunction_swigregister = _BRepGProp.BRepGProp_TFunction_swigregister
BRepGProp_TFunction_swigregister(BRepGProp_TFunction)

class BRepGProp_UFunction(OCC.Core.math.math_Function):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructor. Initializes the function with the face, the location point, the flag IsByPoint and the coefficients theCoeff that have different meaning depending on the value of IsByPoint. If IsByPoint is equal to Standard_True, the number of the coefficients is equal to 3 and they represent X, Y and Z coordinates (theCoeff[0], theCoeff[1] and theCoeff[2] correspondingly) of the shift, if the inertia is computed with respect to the point different then the location. If IsByPoint is equal to Standard_False, the number of the coefficients is 4 and they represent the combination of plane parameters and shift values.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theVertex:
        :type theVertex: gp_Pnt
        :param IsByPoint:
        :type IsByPoint: bool
        :param theCoeffs:
        :type theCoeffs: Standard_Address
        :rtype: None

        """
        _BRepGProp.BRepGProp_UFunction_swiginit(self, _BRepGProp.new_BRepGProp_UFunction(*args))

    def SetValueType(self, *args) -> "void":
        """
        * Setting the type of the value to be returned.

        :param theType:
        :type theType: GProp_ValueType
        :rtype: None

        """
        return _BRepGProp.BRepGProp_UFunction_SetValueType(self, *args)


    def SetVParam(self, *args) -> "void":
        """
        * Setting the V parameter that is constant during the integral computation.

        :param theVParam:
        :type theVParam: float
        :rtype: None

        """
        return _BRepGProp.BRepGProp_UFunction_SetVParam(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_UFunction
BRepGProp_UFunction.SetValueType = new_instancemethod(_BRepGProp.BRepGProp_UFunction_SetValueType, None, BRepGProp_UFunction)
BRepGProp_UFunction.SetVParam = new_instancemethod(_BRepGProp.BRepGProp_UFunction_SetVParam, None, BRepGProp_UFunction)
BRepGProp_UFunction_swigregister = _BRepGProp.BRepGProp_UFunction_swigregister
BRepGProp_UFunction_swigregister(BRepGProp_UFunction)

class BRepGProp_Vinert(OCC.Core.GProp.GProp_GProps):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        * Computes the global properties of a region of 3D space delimited with the surface <S> and the point VLocation. S can be closed The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Errror of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of a region of 3D space delimited with the surface <S> and the point VLocation. S can be closed Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the point VLocation. The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Error of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param O:
        :type O: gp_Pnt
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the point VLocation. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param O:
        :type O: gp_Pnt
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the plane Pln. The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Error of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param Pl:
        :type Pl: gp_Pln
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the plane Pln. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param Pl:
        :type Pl: gp_Pln
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        * Computes the global properties of a region of 3D space delimited with the surface <S> and the point VLocation. S can be closed The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Errror of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of a region of 3D space delimited with the surface <S> and the point VLocation. S can be closed Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the point VLocation. The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Error of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param O:
        :type O: gp_Pnt
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the point VLocation. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param O:
        :type O: gp_Pnt
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the plane Pln. The method is quick and its precision is enough for many cases of analytical surfaces. Non-adaptive 2D Gauss integration with predefined numbers of Gauss points is used. Numbers of points depend on types of surfaces and curves. Error of the computation is not calculated.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Pl:
        :type Pl: gp_Pln
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        * Computes the global properties of the region of 3D space delimited with the surface <S> and the plane Pln. Adaptive 2D Gauss integration is used. Parameter Eps sets maximal relative error of computed mass (volume) for face. Error is calculated as Abs((M(i+1)-M(i))/M(i+1)), M(i+1) and M(i) are values for two successive steps of adaptive integration. WARNING: if Eps > 0.001 algorithm performs non-adaptive integration.

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Pl:
        :type Pl: gp_Pln
        :param VLocation:
        :type VLocation: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: None

        """
        _BRepGProp.BRepGProp_Vinert_swiginit(self, _BRepGProp.new_BRepGProp_Vinert(*args))

    def SetLocation(self, *args) -> "void":
        """
        :param VLocation:
        :type VLocation: gp_Pnt
        :rtype: None

        """
        return _BRepGProp.BRepGProp_Vinert_SetLocation(self, *args)


    def Perform(self, *args) -> "Standard_Real":
        """
        :param S:
        :type S: BRepGProp_Face &
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param O:
        :type O: gp_Pnt
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param O:
        :type O: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param Pl:
        :type Pl: gp_Pln
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param Pl:
        :type Pl: gp_Pln
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param O:
        :type O: gp_Pnt
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param O:
        :type O: gp_Pnt
        :param Eps:
        :type Eps: float
        :rtype: float

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Pl:
        :type Pl: gp_Pln
        :rtype: None

        :param S:
        :type S: BRepGProp_Face &
        :param D:
        :type D: BRepGProp_Domain &
        :param Pl:
        :type Pl: gp_Pln
        :param Eps:
        :type Eps: float
        :rtype: float

        """
        return _BRepGProp.BRepGProp_Vinert_Perform(self, *args)


    def GetEpsilon(self, *args) -> "Standard_Real":
        """
        * If previously used methods containe Eps parameter gets actual relative error of the computation, else returns 1.0.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_Vinert_GetEpsilon(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_Vinert
BRepGProp_Vinert.SetLocation = new_instancemethod(_BRepGProp.BRepGProp_Vinert_SetLocation, None, BRepGProp_Vinert)
BRepGProp_Vinert.Perform = new_instancemethod(_BRepGProp.BRepGProp_Vinert_Perform, None, BRepGProp_Vinert)
BRepGProp_Vinert.GetEpsilon = new_instancemethod(_BRepGProp.BRepGProp_Vinert_GetEpsilon, None, BRepGProp_Vinert)
BRepGProp_Vinert_swigregister = _BRepGProp.BRepGProp_Vinert_swigregister
BRepGProp_Vinert_swigregister(BRepGProp_Vinert)

class BRepGProp_VinertGK(OCC.Core.GProp.GProp_GProps):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Empty constructor.

        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the point VLocation.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the point VLocation. The inertia is computed with respect to thePoint.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param thePoint:
        :type thePoint: gp_Pnt
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the point VLocation.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the point VLocation. The inertia is computed with respect to thePoint.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param thePoint:
        :type thePoint: gp_Pnt
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the plane.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param thePlane:
        :type thePlane: gp_Pln
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        * Constructor. Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the plane.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param thePlane:
        :type thePlane: gp_Pln
        :param theLocation:
        :type theLocation: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: None

        """
        _BRepGProp.BRepGProp_VinertGK_swiginit(self, _BRepGProp.new_BRepGProp_VinertGK(*args))

    def SetLocation(self, *args) -> "void":
        """
        * Sets the vertex that delimit 3D closed region of space.

        :param theLocation:
        :type theLocation: gp_Pnt
        :rtype: None

        """
        return _BRepGProp.BRepGProp_VinertGK_SetLocation(self, *args)


    def Perform(self, *args) -> "Standard_Real":
        """
        * Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the point VLocation.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        * Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the point VLocation. The inertia is computed with respect to thePoint.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param thePoint:
        :type thePoint: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        * Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the point VLocation.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        * Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the point VLocation. The inertia is computed with respect to thePoint.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param thePoint:
        :type thePoint: gp_Pnt
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        * Computes the global properties of a region of 3D space delimited with the naturally restricted surface and the plane.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param thePlane:
        :type thePlane: gp_Pln
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        * Computes the global properties of a region of 3D space delimited with the surface bounded by the domain and the plane.

        :param theSurface:
        :type theSurface: BRepGProp_Face &
        :param theDomain:
        :type theDomain: BRepGProp_Domain &
        :param thePlane:
        :type thePlane: gp_Pln
        :param theTolerance: default value is 0.001
        :type theTolerance: float
        :param theCGFlag: default value is Standard_False
        :type theCGFlag: bool
        :param theIFlag: default value is Standard_False
        :type theIFlag: bool
        :rtype: float

        """
        return _BRepGProp.BRepGProp_VinertGK_Perform(self, *args)


    def GetErrorReached(self, *args) -> "Standard_Real":
        """
        * Returns the relative reached computation error.

        :rtype: float

        """
        return _BRepGProp.BRepGProp_VinertGK_GetErrorReached(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _BRepGProp.delete_BRepGProp_VinertGK
BRepGProp_VinertGK.SetLocation = new_instancemethod(_BRepGProp.BRepGProp_VinertGK_SetLocation, None, BRepGProp_VinertGK)
BRepGProp_VinertGK.Perform = new_instancemethod(_BRepGProp.BRepGProp_VinertGK_Perform, None, BRepGProp_VinertGK)
BRepGProp_VinertGK.GetErrorReached = new_instancemethod(_BRepGProp.BRepGProp_VinertGK_GetErrorReached, None, BRepGProp_VinertGK)
BRepGProp_VinertGK_swigregister = _BRepGProp.BRepGProp_VinertGK_swigregister
BRepGProp_VinertGK_swigregister(BRepGProp_VinertGK)



