# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

"""
SelectMgr manages the process of dynamic
selection through the following services:
-  activating and deactivating selection modes for Interactive Objects
-  adding and removing viewer selectors
-  definitions of abstract filter classes
The principle of graphic selection consists in
representing the objects which you want to select
by a bounding box in the selection view. The object
is selected when you use the mouse to designate
the zone produced by the object.
To realize this, the application creates a selection
structure which is independent of the point of view.
This structure is made up of sensitive primitives
which have one owner object associated to each of
them. The role of the sensitive primitive is to reply
to the requests of the selection algorithm whereas
the owner's purpose is to make the link between
the sensitive primitive and the object to be selected.
Each selection structure corresponds to a selection
mode which defines the elements that can be selected.
For example, to select a complete geometric model,
the application can create a sensitive primitive for
each face of the interactive object representing the
geometric model. In this case, all the primitives
share the same owner. On the other hand, to select
an edge in a model, the application must create
one sensitive primitive per edge.
Example
void
InteractiveBox::ComputeSelection
(const Handle(SelectMgr_Selection)& Sel,
const Standard_Integer Mode){ switch(Mode){ case 0:
// locating the whole box by making its faces sensitive ...
{
Handle(SelectMgr_EntityOwner)
Ownr = new
SelectMgr_EntityOwner(this,5);
for(Standard_Integer
I=1;I<=Nbfaces;I++){Sel->Add(new Select3D_SensitiveFace
(Ownr,[array of the vertices] face I);
break;
}
case 1:     // locates the  edges
{
for(Standard_Integer
i=1;i<=12;i++){
// 1 owner per edge...
Handle(mypk_EdgeOwner)
Ownr = new
mypk_EdgeOwner(this,i,6);
// 6->priority
Sel->Add(new
Select3D_SensitiveSegment
(Ownr,firstpt(i),lastpt(i));
}
}
}
The algorithms for creating selection structures
store the sensitive primitives in a
SelectMgr_Selection object. To do this, a set of
ready-made sensitive primitives is supplied in the
Select2D and Select3D packages. New sensitive
primitives can be defined through inheritance
from  SensitiveEntity. For the application to make
its own objects selectable, it must define owner
classes inheriting SelectMgr_EntityOwner.
For any object inheriting from
AIS_InteractiveObject, you redefine its
ComputeSelection functions. In the example below
there are different modes of selection on the
topological shape contained within the interactive
object -selection of the shape itself, the vertices,
the edges, the wires, the faces.
Example
void
MyPack_MyClass::ComputeSelection(
const Handle(SelectMgr_Selection)& aSelection,
const Standard_Integer aMode)
{
switch(aMode){
case 0:
StdSelect_BRepSelectionTool::Load(
aSelection,this,myShape,TopAbs_SHAPE);
break;
}
case 1:
StdSelect_BRepSelectionTool::Load(
aSelection,this,myShape,TopAbs_VERTEX);
break;
}
case 2:
StdSelect_BRepSelectionTool::Load(
aSelection,this,myShape,TopAbs_EDGE);
break;
}
case 3:
StdSelect_BRepSelectionTool::Load(
aSelection,this,myShape,TopAbs_WIRE);
break;
}
case 4:
StdSelect_BRepSelectionTool::Load(
aSelection,this,myShape,TopAbs_FACE);
break;
}
}
The StdSelect_BRepSelectionTool object
provides a high level service which will make the
shape 'myShape' selectable when the
AIS_InteractiveContext is asked to display your object.
Note: The traditional way of highlighting selected entity
owners adopted by the Open CASCADE library assumes that
each entity owner highlights itself on its own. This approach
has two drawbacks:
-   each entity owner has to maintain its own
Prs3d_Presentation object, that results in
large memory overhead for thousands of owners;
-   drawing selected owners one by one is not
efficient from the OpenGL usage viewpoint.
That is why a different method has been introduced. On the basis of
SelectMgr_EntityOwner::IsAutoHilight() return value an AIS_LocalContext
object either uses the traditional way of highlighting
(IsAutoHilight() returned true) or groups such owners according
to their Selectable Objects and finally calls
SelectMgr_SelectableObject::HilightSelected()
or ClearSelected(), passing a group of owners as an argument.
Hence, an application can derive its own interactive object and
redefine HilightSelected(), ClearSelected() and
HilightOwnerWithColor() virtual methods to take advantage of
such OpenGL technique as arrays of primitives. In any case,
these methods should at least have empty implementation.
The AIS_LocalContext::UpdateSelected(const Handle(AIS_InteratciveObject)&,
Standard_Boolean) method can be used for efficient redrawing a
selection presentation for a given interactive object from an
application code.
Additionally, the SelectMgr_SelectableObject::ClearSelections()
method now accepts an optional boolean argument. This parameter
defines whether all object selections should be flagged for
further update or not. This improved method can be used to
re-compute an object selection (without redisplaying the object
completely) when some selection mode is activated not for the first time.

"""


from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (3, 0, 0):
    new_instancemethod = lambda func, inst, cls: _SelectMgr.SWIG_PyInstanceMethod_New(func)
else:
    from new import instancemethod as new_instancemethod
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_SelectMgr')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_SelectMgr')
    _SelectMgr = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_SelectMgr', [dirname(__file__)])
        except ImportError:
            import _SelectMgr
            return _SelectMgr
        try:
            _mod = imp.load_module('_SelectMgr', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _SelectMgr = swig_import_helper()
    del swig_import_helper
else:
    import _SelectMgr
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        object.__setattr__(self, name, value)
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_method(set):
    def set_attr(self, name, value):
        if (name == "thisown"):
            return self.this.own(value)
        if hasattr(self, name) or (name == "this"):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add attributes to %s" % self)
    return set_attr


class SwigPyIterator(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _SelectMgr.delete_SwigPyIterator
    def __iter__(self):
        return self
SwigPyIterator.value = new_instancemethod(_SelectMgr.SwigPyIterator_value, None, SwigPyIterator)
SwigPyIterator.incr = new_instancemethod(_SelectMgr.SwigPyIterator_incr, None, SwigPyIterator)
SwigPyIterator.decr = new_instancemethod(_SelectMgr.SwigPyIterator_decr, None, SwigPyIterator)
SwigPyIterator.distance = new_instancemethod(_SelectMgr.SwigPyIterator_distance, None, SwigPyIterator)
SwigPyIterator.equal = new_instancemethod(_SelectMgr.SwigPyIterator_equal, None, SwigPyIterator)
SwigPyIterator.copy = new_instancemethod(_SelectMgr.SwigPyIterator_copy, None, SwigPyIterator)
SwigPyIterator.next = new_instancemethod(_SelectMgr.SwigPyIterator_next, None, SwigPyIterator)
SwigPyIterator.__next__ = new_instancemethod(_SelectMgr.SwigPyIterator___next__, None, SwigPyIterator)
SwigPyIterator.previous = new_instancemethod(_SelectMgr.SwigPyIterator_previous, None, SwigPyIterator)
SwigPyIterator.advance = new_instancemethod(_SelectMgr.SwigPyIterator_advance, None, SwigPyIterator)
SwigPyIterator.__eq__ = new_instancemethod(_SelectMgr.SwigPyIterator___eq__, None, SwigPyIterator)
SwigPyIterator.__ne__ = new_instancemethod(_SelectMgr.SwigPyIterator___ne__, None, SwigPyIterator)
SwigPyIterator.__iadd__ = new_instancemethod(_SelectMgr.SwigPyIterator___iadd__, None, SwigPyIterator)
SwigPyIterator.__isub__ = new_instancemethod(_SelectMgr.SwigPyIterator___isub__, None, SwigPyIterator)
SwigPyIterator.__add__ = new_instancemethod(_SelectMgr.SwigPyIterator___add__, None, SwigPyIterator)
SwigPyIterator.__sub__ = new_instancemethod(_SelectMgr.SwigPyIterator___sub__, None, SwigPyIterator)
SwigPyIterator_swigregister = _SelectMgr.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)


def _dumps_object(klass):
    """ Improve string output for any oce object.
    By default, __repr__ method returns something like:
    <OCC.Core.TopoDS.TopoDS_Shape; proxy of <Swig Object of type 'TopoDS_Shape *' at 0x02BB0758> >
    This is too much verbose.
    We prefer :
    class<'gp_Pnt'>
    or
    class<'TopoDS_Shape'; Type:Solid; Id:59391729>
    """
    klass_name = str(klass.__class__).split(".")[3].split("'")[0]
    repr_string = "class<'" + klass_name + "'"
# for TopoDS_Shape, we also look for the base type
    if klass_name == "TopoDS_Shape":
        if klass.IsNull():
            repr_string += " : Null>"
            return repr_string
        st = klass.ShapeType()
        types = {OCC.Core.TopAbs.TopAbs_VERTEX: "Vertex",
                 OCC.Core.TopAbs.TopAbs_SOLID: "Solid",
                 OCC.Core.TopAbs.TopAbs_EDGE: "Edge",
                 OCC.Core.TopAbs.TopAbs_FACE: "Face",
                 OCC.Core.TopAbs.TopAbs_SHELL: "Shell",
                 OCC.Core.TopAbs.TopAbs_WIRE: "Wire",
                 OCC.Core.TopAbs.TopAbs_COMPOUND: "Compound",
                 OCC.Core.TopAbs.TopAbs_COMPSOLID: "Compsolid"}
        repr_string += "; Type:%s" % types[st]        
# for each class that has an HashCode method define,
# print the id
    if hasattr(klass, "HashCode"):
        klass_id = hash(klass)
        repr_string += "; id:%s" % klass_id
    if hasattr(klass, "IsNull"):
        if klass.IsNull():
            repr_string += "; Null"
    repr_string += ">"
    return repr_string

SHARED_PTR_DISOWN = _SelectMgr.SHARED_PTR_DISOWN

from six import with_metaclass
import warnings
from OCC.Wrapper.wrapper_utils import Proxy, deprecated

import OCC.Core.TCollection
import OCC.Core.Standard
import OCC.Core.MMgt
import OCC.Core.SelectBasics
import OCC.Core.TopLoc
import OCC.Core.gp
import OCC.Core.NCollection
import OCC.Core.TColgp
import OCC.Core.Select3D
import OCC.Core.Bnd
import OCC.Core.TColStd
import OCC.Core.Geom
import OCC.Core.GeomAbs
import OCC.Core.PrsMgr
import OCC.Core.Graphic3d
import OCC.Core.Quantity
import OCC.Core.Aspect
import OCC.Core.Image
import OCC.Core.OSD
import OCC.Core.Prs3d
import OCC.Core.TopoDS
import OCC.Core.TopAbs
import OCC.Core.HLRAlgo
import OCC.Core.TopTools
import OCC.Core.Message
import OCC.Core.Poly
import OCC.Core.TShort
import OCC.Core.Visual3d
import OCC.Core.V3d
SelectMgr_TOU_Full = _SelectMgr.SelectMgr_TOU_Full
SelectMgr_TOU_Partial = _SelectMgr.SelectMgr_TOU_Partial
SelectMgr_TOU_None = _SelectMgr.SelectMgr_TOU_None
SelectMgr_TBU_Add = _SelectMgr.SelectMgr_TBU_Add
SelectMgr_TBU_Remove = _SelectMgr.SelectMgr_TBU_Remove
SelectMgr_TBU_Renew = _SelectMgr.SelectMgr_TBU_Renew
SelectMgr_TBU_Invalidate = _SelectMgr.SelectMgr_TBU_Invalidate
SelectMgr_TBU_None = _SelectMgr.SelectMgr_TBU_None
SelectMgr_SOS_Activated = _SelectMgr.SelectMgr_SOS_Activated
SelectMgr_SOS_Deactivated = _SelectMgr.SelectMgr_SOS_Deactivated
SelectMgr_SOS_Sleeping = _SelectMgr.SelectMgr_SOS_Sleeping
SelectMgr_SOS_Any = _SelectMgr.SelectMgr_SOS_Any
SelectMgr_SOS_Unknown = _SelectMgr.SelectMgr_SOS_Unknown

def Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Create() -> "Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors":
    return _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Create()
Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Create = _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Create

def Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors":
    return _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast(t)
Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast = _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast

def Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_IsNull(t: 'Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_IsNull(t)
Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_IsNull = _SelectMgr.Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_IsNull

def Handle_SelectMgr_EntityOwner_Create() -> "Handle_SelectMgr_EntityOwner":
    return _SelectMgr.Handle_SelectMgr_EntityOwner_Create()
Handle_SelectMgr_EntityOwner_Create = _SelectMgr.Handle_SelectMgr_EntityOwner_Create

def Handle_SelectMgr_EntityOwner_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_EntityOwner":
    return _SelectMgr.Handle_SelectMgr_EntityOwner_DownCast(t)
Handle_SelectMgr_EntityOwner_DownCast = _SelectMgr.Handle_SelectMgr_EntityOwner_DownCast

def Handle_SelectMgr_EntityOwner_IsNull(t: 'Handle_SelectMgr_EntityOwner const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_EntityOwner_IsNull(t)
Handle_SelectMgr_EntityOwner_IsNull = _SelectMgr.Handle_SelectMgr_EntityOwner_IsNull

def Handle_SelectMgr_Filter_Create() -> "Handle_SelectMgr_Filter":
    return _SelectMgr.Handle_SelectMgr_Filter_Create()
Handle_SelectMgr_Filter_Create = _SelectMgr.Handle_SelectMgr_Filter_Create

def Handle_SelectMgr_Filter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_Filter":
    return _SelectMgr.Handle_SelectMgr_Filter_DownCast(t)
Handle_SelectMgr_Filter_DownCast = _SelectMgr.Handle_SelectMgr_Filter_DownCast

def Handle_SelectMgr_Filter_IsNull(t: 'Handle_SelectMgr_Filter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_Filter_IsNull(t)
Handle_SelectMgr_Filter_IsNull = _SelectMgr.Handle_SelectMgr_Filter_IsNull

def Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Create() -> "Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion":
    return _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Create()
Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Create = _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Create

def Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion":
    return _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast(t)
Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast = _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast

def Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_IsNull(t: 'Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_IsNull(t)
Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_IsNull = _SelectMgr.Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_IsNull

def Handle_SelectMgr_ListNodeOfListOfFilter_Create() -> "Handle_SelectMgr_ListNodeOfListOfFilter":
    return _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_Create()
Handle_SelectMgr_ListNodeOfListOfFilter_Create = _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_Create

def Handle_SelectMgr_ListNodeOfListOfFilter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_ListNodeOfListOfFilter":
    return _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_DownCast(t)
Handle_SelectMgr_ListNodeOfListOfFilter_DownCast = _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_DownCast

def Handle_SelectMgr_ListNodeOfListOfFilter_IsNull(t: 'Handle_SelectMgr_ListNodeOfListOfFilter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_IsNull(t)
Handle_SelectMgr_ListNodeOfListOfFilter_IsNull = _SelectMgr.Handle_SelectMgr_ListNodeOfListOfFilter_IsNull

def Handle_SelectMgr_SelectableObject_Create() -> "Handle_SelectMgr_SelectableObject":
    return _SelectMgr.Handle_SelectMgr_SelectableObject_Create()
Handle_SelectMgr_SelectableObject_Create = _SelectMgr.Handle_SelectMgr_SelectableObject_Create

def Handle_SelectMgr_SelectableObject_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SelectableObject":
    return _SelectMgr.Handle_SelectMgr_SelectableObject_DownCast(t)
Handle_SelectMgr_SelectableObject_DownCast = _SelectMgr.Handle_SelectMgr_SelectableObject_DownCast

def Handle_SelectMgr_SelectableObject_IsNull(t: 'Handle_SelectMgr_SelectableObject const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SelectableObject_IsNull(t)
Handle_SelectMgr_SelectableObject_IsNull = _SelectMgr.Handle_SelectMgr_SelectableObject_IsNull

def Handle_SelectMgr_Selection_Create() -> "Handle_SelectMgr_Selection":
    return _SelectMgr.Handle_SelectMgr_Selection_Create()
Handle_SelectMgr_Selection_Create = _SelectMgr.Handle_SelectMgr_Selection_Create

def Handle_SelectMgr_Selection_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_Selection":
    return _SelectMgr.Handle_SelectMgr_Selection_DownCast(t)
Handle_SelectMgr_Selection_DownCast = _SelectMgr.Handle_SelectMgr_Selection_DownCast

def Handle_SelectMgr_Selection_IsNull(t: 'Handle_SelectMgr_Selection const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_Selection_IsNull(t)
Handle_SelectMgr_Selection_IsNull = _SelectMgr.Handle_SelectMgr_Selection_IsNull

def Handle_SelectMgr_SelectionManager_Create() -> "Handle_SelectMgr_SelectionManager":
    return _SelectMgr.Handle_SelectMgr_SelectionManager_Create()
Handle_SelectMgr_SelectionManager_Create = _SelectMgr.Handle_SelectMgr_SelectionManager_Create

def Handle_SelectMgr_SelectionManager_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SelectionManager":
    return _SelectMgr.Handle_SelectMgr_SelectionManager_DownCast(t)
Handle_SelectMgr_SelectionManager_DownCast = _SelectMgr.Handle_SelectMgr_SelectionManager_DownCast

def Handle_SelectMgr_SelectionManager_IsNull(t: 'Handle_SelectMgr_SelectionManager const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SelectionManager_IsNull(t)
Handle_SelectMgr_SelectionManager_IsNull = _SelectMgr.Handle_SelectMgr_SelectionManager_IsNull

def Handle_SelectMgr_SensitiveEntity_Create() -> "Handle_SelectMgr_SensitiveEntity":
    return _SelectMgr.Handle_SelectMgr_SensitiveEntity_Create()
Handle_SelectMgr_SensitiveEntity_Create = _SelectMgr.Handle_SelectMgr_SensitiveEntity_Create

def Handle_SelectMgr_SensitiveEntity_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SensitiveEntity":
    return _SelectMgr.Handle_SelectMgr_SensitiveEntity_DownCast(t)
Handle_SelectMgr_SensitiveEntity_DownCast = _SelectMgr.Handle_SelectMgr_SensitiveEntity_DownCast

def Handle_SelectMgr_SensitiveEntity_IsNull(t: 'Handle_SelectMgr_SensitiveEntity const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SensitiveEntity_IsNull(t)
Handle_SelectMgr_SensitiveEntity_IsNull = _SelectMgr.Handle_SelectMgr_SensitiveEntity_IsNull

def Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_Create() -> "Handle_SelectMgr_SequenceNodeOfSequenceOfFilter":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_Create()
Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_Create = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_Create

def Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SequenceNodeOfSequenceOfFilter":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast

def Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_IsNull(t: 'Handle_SelectMgr_SequenceNodeOfSequenceOfFilter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_IsNull(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_IsNull = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_IsNull

def Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_Create() -> "Handle_SelectMgr_SequenceNodeOfSequenceOfOwner":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_Create()
Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_Create = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_Create

def Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SequenceNodeOfSequenceOfOwner":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast

def Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_IsNull(t: 'Handle_SelectMgr_SequenceNodeOfSequenceOfOwner const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_IsNull(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_IsNull = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_IsNull

def Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_Create() -> "Handle_SelectMgr_SequenceNodeOfSequenceOfSelector":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_Create()
Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_Create = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_Create

def Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_SequenceNodeOfSequenceOfSelector":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast

def Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_IsNull(t: 'Handle_SelectMgr_SequenceNodeOfSequenceOfSelector const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_IsNull(t)
Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_IsNull = _SelectMgr.Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_IsNull

def Handle_SelectMgr_ViewerSelector_Create() -> "Handle_SelectMgr_ViewerSelector":
    return _SelectMgr.Handle_SelectMgr_ViewerSelector_Create()
Handle_SelectMgr_ViewerSelector_Create = _SelectMgr.Handle_SelectMgr_ViewerSelector_Create

def Handle_SelectMgr_ViewerSelector_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_ViewerSelector":
    return _SelectMgr.Handle_SelectMgr_ViewerSelector_DownCast(t)
Handle_SelectMgr_ViewerSelector_DownCast = _SelectMgr.Handle_SelectMgr_ViewerSelector_DownCast

def Handle_SelectMgr_ViewerSelector_IsNull(t: 'Handle_SelectMgr_ViewerSelector const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_ViewerSelector_IsNull(t)
Handle_SelectMgr_ViewerSelector_IsNull = _SelectMgr.Handle_SelectMgr_ViewerSelector_IsNull

def Handle_SelectMgr_CompositionFilter_Create() -> "Handle_SelectMgr_CompositionFilter":
    return _SelectMgr.Handle_SelectMgr_CompositionFilter_Create()
Handle_SelectMgr_CompositionFilter_Create = _SelectMgr.Handle_SelectMgr_CompositionFilter_Create

def Handle_SelectMgr_CompositionFilter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_CompositionFilter":
    return _SelectMgr.Handle_SelectMgr_CompositionFilter_DownCast(t)
Handle_SelectMgr_CompositionFilter_DownCast = _SelectMgr.Handle_SelectMgr_CompositionFilter_DownCast

def Handle_SelectMgr_CompositionFilter_IsNull(t: 'Handle_SelectMgr_CompositionFilter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_CompositionFilter_IsNull(t)
Handle_SelectMgr_CompositionFilter_IsNull = _SelectMgr.Handle_SelectMgr_CompositionFilter_IsNull

def Handle_SelectMgr_AndFilter_Create() -> "Handle_SelectMgr_AndFilter":
    return _SelectMgr.Handle_SelectMgr_AndFilter_Create()
Handle_SelectMgr_AndFilter_Create = _SelectMgr.Handle_SelectMgr_AndFilter_Create

def Handle_SelectMgr_AndFilter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_AndFilter":
    return _SelectMgr.Handle_SelectMgr_AndFilter_DownCast(t)
Handle_SelectMgr_AndFilter_DownCast = _SelectMgr.Handle_SelectMgr_AndFilter_DownCast

def Handle_SelectMgr_AndFilter_IsNull(t: 'Handle_SelectMgr_AndFilter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_AndFilter_IsNull(t)
Handle_SelectMgr_AndFilter_IsNull = _SelectMgr.Handle_SelectMgr_AndFilter_IsNull

def Handle_SelectMgr_OrFilter_Create() -> "Handle_SelectMgr_OrFilter":
    return _SelectMgr.Handle_SelectMgr_OrFilter_Create()
Handle_SelectMgr_OrFilter_Create = _SelectMgr.Handle_SelectMgr_OrFilter_Create

def Handle_SelectMgr_OrFilter_DownCast(t: 'Handle_Standard_Transient const &') -> "Handle_SelectMgr_OrFilter":
    return _SelectMgr.Handle_SelectMgr_OrFilter_DownCast(t)
Handle_SelectMgr_OrFilter_DownCast = _SelectMgr.Handle_SelectMgr_OrFilter_DownCast

def Handle_SelectMgr_OrFilter_IsNull(t: 'Handle_SelectMgr_OrFilter const &') -> "bool":
    return _SelectMgr.Handle_SelectMgr_OrFilter_IsNull(t)
Handle_SelectMgr_OrFilter_IsNull = _SelectMgr.Handle_SelectMgr_OrFilter_IsNull
class SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors(OCC.Core.TCollection.TCollection_BasicMapIterator):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param aMap:
        :type aMap: SelectMgr_DataMapOfObjectSelectors &
        :rtype: None

        """
        _SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_swiginit(self, _SelectMgr.new_SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors(*args))

    def Initialize(self, *args) -> "void":
        """
        :param aMap:
        :type aMap: SelectMgr_DataMapOfObjectSelectors &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Initialize(self, *args)


    def Key(self, *args) -> "Handle_SelectMgr_SelectableObject":
        """
        :rtype: Handle_SelectMgr_SelectableObject

        """
        return _SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Key(self, *args)


    def Value(self, *args) -> "SelectMgr_SequenceOfSelector const &":
        """
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Value(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors
SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors.Initialize = new_instancemethod(_SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Initialize, None, SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors)
SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors.Key = new_instancemethod(_SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Key, None, SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors)
SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors.Value = new_instancemethod(_SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_Value, None, SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors)
SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_swigregister = _SelectMgr.SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_swigregister
SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors_swigregister(SelectMgr_DataMapIteratorOfDataMapOfObjectSelectors)

class SelectMgr_DataMapNodeOfDataMapOfObjectSelectors(OCC.Core.TCollection.TCollection_MapNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :param I:
        :type I: SelectMgr_SequenceOfSelector &
        :param n:
        :type n: TCollection_MapNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_swiginit(self, _SelectMgr.new_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors(*args))

    def Key(self, *args) -> "Handle_SelectMgr_SelectableObject":
        """
        :rtype: Handle_SelectMgr_SelectableObject

        """
        return _SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Key(self, *args)


    def Value(self, *args) -> "SelectMgr_SequenceOfSelector &":
        """
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors
SelectMgr_DataMapNodeOfDataMapOfObjectSelectors.Key = new_instancemethod(_SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Key, None, SelectMgr_DataMapNodeOfDataMapOfObjectSelectors)
SelectMgr_DataMapNodeOfDataMapOfObjectSelectors.Value = new_instancemethod(_SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Value, None, SelectMgr_DataMapNodeOfDataMapOfObjectSelectors)
SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_swigregister = _SelectMgr.SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_swigregister
SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_swigregister(SelectMgr_DataMapNodeOfDataMapOfObjectSelectors)


class Meta_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_DataMapNodeOfDataMapOfObjectSelectors", "SelectMgr_DataMapNodeOfDataMapOfObjectSelectors"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors(with_metaclass(Meta_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors, SelectMgr_DataMapNodeOfDataMapOfObjectSelectors)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_DataMapNodeOfDataMapOfObjectSelectors", "SelectMgr_DataMapNodeOfDataMapOfObjectSelectors"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors(Handle_SelectMgr_DataMapNodeOfDataMapOfObjectSelectors_DownCast(o))

class SelectMgr_DataMapOfObjectSelectors(OCC.Core.TCollection.TCollection_BasicMap):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param NbBuckets: default value is 1
        :type NbBuckets: int
        :rtype: None

        """
        _SelectMgr.SelectMgr_DataMapOfObjectSelectors_swiginit(self, _SelectMgr.new_SelectMgr_DataMapOfObjectSelectors(*args))

    def Assign(self, *args) -> "SelectMgr_DataMapOfObjectSelectors &":
        """
        :param Other:
        :type Other: SelectMgr_DataMapOfObjectSelectors &
        :rtype: SelectMgr_DataMapOfObjectSelectors

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Assign(self, *args)


    def Set(self, *args) -> "SelectMgr_DataMapOfObjectSelectors &":
        """
        :param Other:
        :type Other: SelectMgr_DataMapOfObjectSelectors &
        :rtype: SelectMgr_DataMapOfObjectSelectors

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Set(self, *args)


    def ReSize(self, *args) -> "void":
        """
        :param NbBuckets:
        :type NbBuckets: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_ReSize(self, *args)


    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Clear(self, *args)


    def Bind(self, *args) -> "Standard_Boolean":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :param I:
        :type I: SelectMgr_SequenceOfSelector &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Bind(self, *args)


    def IsBound(self, *args) -> "Standard_Boolean":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_IsBound(self, *args)


    def UnBind(self, *args) -> "Standard_Boolean":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_UnBind(self, *args)


    def Find(self, *args) -> "SelectMgr_SequenceOfSelector const &":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Find(self, *args)


    def ChangeFind(self, *args) -> "SelectMgr_SequenceOfSelector &":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_ChangeFind(self, *args)


    def Find1(self, *args) -> "Standard_Address":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: Standard_Address

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_Find1(self, *args)


    def ChangeFind1(self, *args) -> "Standard_Address":
        """
        :param K:
        :type K: Handle_SelectMgr_SelectableObject &
        :rtype: Standard_Address

        """
        return _SelectMgr.SelectMgr_DataMapOfObjectSelectors_ChangeFind1(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_DataMapOfObjectSelectors
SelectMgr_DataMapOfObjectSelectors.Assign = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Assign, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.Set = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Set, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.ReSize = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_ReSize, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.Clear = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Clear, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.Bind = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Bind, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.IsBound = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_IsBound, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.UnBind = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_UnBind, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.Find = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Find, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.ChangeFind = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_ChangeFind, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.Find1 = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_Find1, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors.ChangeFind1 = new_instancemethod(_SelectMgr.SelectMgr_DataMapOfObjectSelectors_ChangeFind1, None, SelectMgr_DataMapOfObjectSelectors)
SelectMgr_DataMapOfObjectSelectors_swigregister = _SelectMgr.SelectMgr_DataMapOfObjectSelectors_swigregister
SelectMgr_DataMapOfObjectSelectors_swigregister(SelectMgr_DataMapOfObjectSelectors)

class SelectMgr_EntityOwner(OCC.Core.SelectBasics.SelectBasics_EntityOwner):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Initializes the selection priority aPriority.

        :param aPriority: default value is 0
        :type aPriority: int
        :rtype: None

        * Constructs a framework with the selectable object anSO being attributed the selection priority aPriority.

        :param aSO:
        :type aSO: Handle_SelectMgr_SelectableObject &
        :param aPriority: default value is 0
        :type aPriority: int
        :rtype: None

        * Constructs a framework from existing one anSO being attributed the selection priority aPriority.

        :param theOwner:
        :type theOwner: Handle_SelectMgr_EntityOwner &
        :param aPriority: default value is 0
        :type aPriority: int
        :rtype: None

        """
        _SelectMgr.SelectMgr_EntityOwner_swiginit(self, _SelectMgr.new_SelectMgr_EntityOwner(*args))

    def HasSelectable(self, *args) -> "Standard_Boolean":
        """
        * Returns true if there is a selectable object to serve as an owner.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_EntityOwner_HasSelectable(self, *args)


    def Selectable(self, *args) -> "Handle_SelectMgr_SelectableObject":
        """
        * Returns a selectable object detected in the working context.

        :rtype: Handle_SelectMgr_SelectableObject

        """
        return _SelectMgr.SelectMgr_EntityOwner_Selectable(self, *args)


    def Set(self, *args) -> "void":
        """
        * Sets the selectable object anSO to be used by the second constructor above.

        :param aSO:
        :type aSO: Handle_SelectMgr_SelectableObject &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_EntityOwner_Set(self, *args)


    def IsHilighted(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the presentation manager aPM highlights selections corresponding to the selection mode aMode.

        :param aPM:
        :type aPM: Handle_PrsMgr_PresentationManager &
        :param aMode: default value is 0
        :type aMode: int
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_EntityOwner_IsHilighted(self, *args)


    def Hilight(self, *args) -> "void":
        """
        * Provides a framework to highlight any selectable object found subsequently which can serve as an owner of a sensitive primitive.

        :rtype: void

        * Highlights the owner of a detected selectable object in the presentation manager aPM. This object could be the owner of a sensitive primitive. The display mode for the highlight is aMode; this has the default value of 0, that is, wireframe mode.

        :param aPM:
        :type aPM: Handle_PrsMgr_PresentationManager &
        :param aMode: default value is 0
        :type aMode: int
        :rtype: void

        """
        return _SelectMgr.SelectMgr_EntityOwner_Hilight(self, *args)


    def HilightWithColor(self, *args) -> "void":
        """
        :param aPM:
        :type aPM: Handle_PrsMgr_PresentationManager3d &
        :param aColor:
        :type aColor: Quantity_NameOfColor
        :param aMode: default value is 0
        :type aMode: int
        :rtype: void

        """
        return _SelectMgr.SelectMgr_EntityOwner_HilightWithColor(self, *args)


    def Unhilight(self, *args) -> "void":
        """
        * Removes highlighting from the owner of a detected selectable object in the presentation manager aPM. This object could be the owner of a sensitive primitive. The display mode for the highlight is aMode; this has the default value of 0, that is, wireframe mode.

        :param aPM:
        :type aPM: Handle_PrsMgr_PresentationManager &
        :param aMode: default value is 0
        :type aMode: int
        :rtype: void

        """
        return _SelectMgr.SelectMgr_EntityOwner_Unhilight(self, *args)


    def Clear(self, *args) -> "void":
        """
        * Clears the owners matching the value of the selection mode aMode from the presentation manager object aPM.

        :param aPM:
        :type aPM: Handle_PrsMgr_PresentationManager &
        :param aMode: default value is 0
        :type aMode: int
        :rtype: void

        """
        return _SelectMgr.SelectMgr_EntityOwner_Clear(self, *args)


    def SetSelected(self, *args) -> "void":
        """
        * Set the state of the owner. @param theIsSelected [in] shows if owner is selected.

        :param theIsSelected:
        :type theIsSelected: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_EntityOwner_SetSelected(self, *args)


    def IsSelected(self, *args) -> "Standard_Boolean":
        """
        * returns Standard_True if the owner is selected.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_EntityOwner_IsSelected(self, *args)


    def State(self, *args) -> "Standard_Integer":
        """
        * Set the state of the owner. The method is deprecated. Use SetSelected() instead.

        :param aStatus:
        :type aStatus: int
        :rtype: None

        :rtype: int

        """
        return _SelectMgr.SelectMgr_EntityOwner_State(self, *args)


    def IsAutoHilight(self, *args) -> "Standard_Boolean":
        """
        * if owner is not auto hilighted, for group contains many such owners will be called one method HilightSelected of SelectableObject

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_EntityOwner_IsAutoHilight(self, *args)


    def IsForcedHilight(self, *args) -> "Standard_Boolean":
        """
        * if this method returns True the owner will allways call method Hilight for SelectableObject when the owner is detected. By default it always return False.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_EntityOwner_IsForcedHilight(self, *args)


    def SetZLayer(self, *args) -> "void":
        """
        * Set Z layer ID and update all presentations.

        :param theLayerId:
        :type theLayerId: Graphic3d_ZLayerId
        :rtype: void

        """
        return _SelectMgr.SelectMgr_EntityOwner_SetZLayer(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_EntityOwner_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_EntityOwner_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_EntityOwner
SelectMgr_EntityOwner.HasSelectable = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_HasSelectable, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.Selectable = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_Selectable, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.Set = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_Set, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.IsHilighted = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_IsHilighted, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.Hilight = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_Hilight, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.HilightWithColor = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_HilightWithColor, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.Unhilight = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_Unhilight, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.Clear = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_Clear, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.SetSelected = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_SetSelected, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.IsSelected = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_IsSelected, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.State = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_State, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.IsAutoHilight = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_IsAutoHilight, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.IsForcedHilight = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_IsForcedHilight, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner.SetZLayer = new_instancemethod(_SelectMgr.SelectMgr_EntityOwner_SetZLayer, None, SelectMgr_EntityOwner)
SelectMgr_EntityOwner_swigregister = _SelectMgr.SelectMgr_EntityOwner_swigregister
SelectMgr_EntityOwner_swigregister(SelectMgr_EntityOwner)


class Meta_SelectMgr_EntityOwner(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_EntityOwner_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_EntityOwner", "SelectMgr_EntityOwner"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_EntityOwner(with_metaclass(Meta_SelectMgr_EntityOwner, SelectMgr_EntityOwner)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_EntityOwner", "SelectMgr_EntityOwner"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_EntityOwner(Handle_SelectMgr_EntityOwner_DownCast(o))

class SelectMgr_Filter(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def IsOk(self, *args) -> "Standard_Boolean":
        """
        * Indicates that the selected Interactive Object passes the filter. The owner, anObj, can be either direct or user. A direct owner is the corresponding construction element, whereas a user is the compound shape of which the entity forms a part. When an object is detected by the mouse - in AIS, this is done through a context selector - its owner is passed to the filter as an argument. If the object returns Standard_True, it is kept; if not, it is rejected. If you are creating a filter class inheriting this framework, and the daughter class is to be used in an AIS local context, you will need to implement the virtual function ActsOn.

        :param anObj:
        :type anObj: Handle_SelectMgr_EntityOwner &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_Filter_IsOk(self, *args)


    def ActsOn(self, *args) -> "Standard_Boolean":
        """
        * Returns true in an AIS local context, if this filter operates on a type of subshape defined in a filter class inheriting this framework. This function completes IsOk in an AIS local context.

        :param aStandardMode:
        :type aStandardMode: TopAbs_ShapeEnum
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_Filter_ActsOn(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_Filter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_Filter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_Filter
SelectMgr_Filter.IsOk = new_instancemethod(_SelectMgr.SelectMgr_Filter_IsOk, None, SelectMgr_Filter)
SelectMgr_Filter.ActsOn = new_instancemethod(_SelectMgr.SelectMgr_Filter_ActsOn, None, SelectMgr_Filter)
SelectMgr_Filter_swigregister = _SelectMgr.SelectMgr_Filter_swigregister
SelectMgr_Filter_swigregister(SelectMgr_Filter)


class Meta_SelectMgr_Filter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_Filter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_Filter", "SelectMgr_Filter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_Filter(with_metaclass(Meta_SelectMgr_Filter, SelectMgr_Filter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_Filter", "SelectMgr_Filter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_Filter(Handle_SelectMgr_Filter_DownCast(o))

class SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion(OCC.Core.TCollection.TCollection_MapNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param K1:
        :type K1: Handle_SelectBasics_EntityOwner &
        :param K2:
        :type K2: int
        :param I:
        :type I: SelectMgr_SortCriterion &
        :param n1:
        :type n1: TCollection_MapNodePtr &
        :param n2:
        :type n2: TCollection_MapNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_swiginit(self, _SelectMgr.new_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion(*args))

    def Key1(self, *args) -> "Handle_SelectBasics_EntityOwner":
        """
        :rtype: Handle_SelectBasics_EntityOwner

        """
        return _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Key1(self, *args)


    def GetKey2(self) -> "Standard_Integer":
        """GetKey2(SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion self) -> Standard_Integer"""
        return _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_GetKey2(self)


    def SetKey2(self, value: 'Standard_Integer') -> "void":
        """SetKey2(SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion self, Standard_Integer value)"""
        return _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_SetKey2(self, value)


    def Next2(self, *args) -> "TCollection_MapNodePtr &":
        """
        :rtype: TCollection_MapNodePtr

        """
        return _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Next2(self, *args)


    def Value(self, *args) -> "SelectMgr_SortCriterion &":
        """
        :rtype: SelectMgr_SortCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion.Key1 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Key1, None, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion.GetKey2 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_GetKey2, None, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion.SetKey2 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_SetKey2, None, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion.Next2 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Next2, None, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion.Value = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Value, None, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_swigregister = _SelectMgr.SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_swigregister
SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_swigregister(SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)


class Meta_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion", "SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion(with_metaclass(Meta_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion, SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion", "SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion(Handle_SelectMgr_IndexedDataMapNodeOfIndexedDataMapOfOwnerCriterion_DownCast(o))

class SelectMgr_IndexedDataMapOfOwnerCriterion(OCC.Core.TCollection.TCollection_BasicMap):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param NbBuckets: default value is 1
        :type NbBuckets: int
        :rtype: None

        """
        _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_swiginit(self, _SelectMgr.new_SelectMgr_IndexedDataMapOfOwnerCriterion(*args))

    def Assign(self, *args) -> "SelectMgr_IndexedDataMapOfOwnerCriterion &":
        """
        :param Other:
        :type Other: SelectMgr_IndexedDataMapOfOwnerCriterion &
        :rtype: SelectMgr_IndexedDataMapOfOwnerCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Assign(self, *args)


    def Set(self, *args) -> "SelectMgr_IndexedDataMapOfOwnerCriterion &":
        """
        :param Other:
        :type Other: SelectMgr_IndexedDataMapOfOwnerCriterion &
        :rtype: SelectMgr_IndexedDataMapOfOwnerCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Set(self, *args)


    def ReSize(self, *args) -> "void":
        """
        :param NbBuckets:
        :type NbBuckets: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ReSize(self, *args)


    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Clear(self, *args)


    def Add(self, *args) -> "Standard_Integer":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :param I:
        :type I: SelectMgr_SortCriterion &
        :rtype: int

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Add(self, *args)


    def Substitute(self, *args) -> "void":
        """
        :param I:
        :type I: int
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :param T:
        :type T: SelectMgr_SortCriterion &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Substitute(self, *args)


    def RemoveLast(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_RemoveLast(self, *args)


    def Contains(self, *args) -> "Standard_Boolean":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Contains(self, *args)


    def FindKey(self, *args) -> "Handle_SelectBasics_EntityOwner":
        """
        :param I:
        :type I: int
        :rtype: Handle_SelectBasics_EntityOwner

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindKey(self, *args)


    def FindFromIndex(self, *args) -> "SelectMgr_SortCriterion const &":
        """
        :param I:
        :type I: int
        :rtype: SelectMgr_SortCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromIndex(self, *args)


    def ChangeFromIndex(self, *args) -> "SelectMgr_SortCriterion &":
        """
        :param I:
        :type I: int
        :rtype: SelectMgr_SortCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromIndex(self, *args)


    def FindIndex(self, *args) -> "Standard_Integer":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: int

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindIndex(self, *args)


    def FindFromKey(self, *args) -> "SelectMgr_SortCriterion const &":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: SelectMgr_SortCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromKey(self, *args)


    def ChangeFromKey(self, *args) -> "SelectMgr_SortCriterion &":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: SelectMgr_SortCriterion

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromKey(self, *args)


    def FindFromKey1(self, *args) -> "Standard_Address":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: Standard_Address

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromKey1(self, *args)


    def ChangeFromKey1(self, *args) -> "Standard_Address":
        """
        :param K:
        :type K: Handle_SelectBasics_EntityOwner &
        :rtype: Standard_Address

        """
        return _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromKey1(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_IndexedDataMapOfOwnerCriterion
SelectMgr_IndexedDataMapOfOwnerCriterion.Assign = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Assign, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.Set = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Set, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.ReSize = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ReSize, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.Clear = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Clear, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.Add = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Add, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.Substitute = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Substitute, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.RemoveLast = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_RemoveLast, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.Contains = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_Contains, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.FindKey = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindKey, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.FindFromIndex = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromIndex, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.ChangeFromIndex = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromIndex, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.FindIndex = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindIndex, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.FindFromKey = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromKey, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.ChangeFromKey = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromKey, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.FindFromKey1 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_FindFromKey1, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion.ChangeFromKey1 = new_instancemethod(_SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_ChangeFromKey1, None, SelectMgr_IndexedDataMapOfOwnerCriterion)
SelectMgr_IndexedDataMapOfOwnerCriterion_swigregister = _SelectMgr.SelectMgr_IndexedDataMapOfOwnerCriterion_swigregister
SelectMgr_IndexedDataMapOfOwnerCriterion_swigregister(SelectMgr_IndexedDataMapOfOwnerCriterion)

class SelectMgr_ListIteratorOfListOfFilter(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param L:
        :type L: SelectMgr_ListOfFilter &
        :rtype: None

        """
        _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_swiginit(self, _SelectMgr.new_SelectMgr_ListIteratorOfListOfFilter(*args))

    def Initialize(self, *args) -> "void":
        """
        :param L:
        :type L: SelectMgr_ListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Initialize(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_More(self, *args)


    def Next(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Next(self, *args)


    def Value(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Value(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_ListIteratorOfListOfFilter
SelectMgr_ListIteratorOfListOfFilter.Initialize = new_instancemethod(_SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Initialize, None, SelectMgr_ListIteratorOfListOfFilter)
SelectMgr_ListIteratorOfListOfFilter.More = new_instancemethod(_SelectMgr.SelectMgr_ListIteratorOfListOfFilter_More, None, SelectMgr_ListIteratorOfListOfFilter)
SelectMgr_ListIteratorOfListOfFilter.Next = new_instancemethod(_SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Next, None, SelectMgr_ListIteratorOfListOfFilter)
SelectMgr_ListIteratorOfListOfFilter.Value = new_instancemethod(_SelectMgr.SelectMgr_ListIteratorOfListOfFilter_Value, None, SelectMgr_ListIteratorOfListOfFilter)
SelectMgr_ListIteratorOfListOfFilter_swigregister = _SelectMgr.SelectMgr_ListIteratorOfListOfFilter_swigregister
SelectMgr_ListIteratorOfListOfFilter_swigregister(SelectMgr_ListIteratorOfListOfFilter)

class SelectMgr_ListNodeOfListOfFilter(OCC.Core.TCollection.TCollection_MapNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param n:
        :type n: TCollection_MapNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_ListNodeOfListOfFilter_swiginit(self, _SelectMgr.new_SelectMgr_ListNodeOfListOfFilter(*args))

    def Value(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_ListNodeOfListOfFilter_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_ListNodeOfListOfFilter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_ListNodeOfListOfFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_ListNodeOfListOfFilter
SelectMgr_ListNodeOfListOfFilter.Value = new_instancemethod(_SelectMgr.SelectMgr_ListNodeOfListOfFilter_Value, None, SelectMgr_ListNodeOfListOfFilter)
SelectMgr_ListNodeOfListOfFilter_swigregister = _SelectMgr.SelectMgr_ListNodeOfListOfFilter_swigregister
SelectMgr_ListNodeOfListOfFilter_swigregister(SelectMgr_ListNodeOfListOfFilter)


class Meta_SelectMgr_ListNodeOfListOfFilter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_ListNodeOfListOfFilter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_ListNodeOfListOfFilter", "SelectMgr_ListNodeOfListOfFilter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_ListNodeOfListOfFilter(with_metaclass(Meta_SelectMgr_ListNodeOfListOfFilter, SelectMgr_ListNodeOfListOfFilter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_ListNodeOfListOfFilter", "SelectMgr_ListNodeOfListOfFilter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_ListNodeOfListOfFilter(Handle_SelectMgr_ListNodeOfListOfFilter_DownCast(o))

class SelectMgr_ListOfFilter(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :rtype: None

        """
        _SelectMgr.SelectMgr_ListOfFilter_swiginit(self, _SelectMgr.new_SelectMgr_ListOfFilter(*args))

    def Assign(self, *args) -> "void":
        """
        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Assign(self, *args)


    def Set(self, *args) -> "void":
        """
        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Set(self, *args)


    def Extent(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Extent(self, *args)


    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Clear(self, *args)


    def IsEmpty(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ListOfFilter_IsEmpty(self, *args)


    def Prepend(self, *args) -> "void":
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :rtype: None

        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param theIt:
        :type theIt: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Prepend(self, *args)


    def Append(self, *args) -> "void":
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :rtype: None

        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param theIt:
        :type theIt: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Append(self, *args)


    def First(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_ListOfFilter_First(self, *args)


    def Last(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Last(self, *args)


    def RemoveFirst(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_RemoveFirst(self, *args)


    def Remove(self, *args) -> "void":
        """
        :param It:
        :type It: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_Remove(self, *args)


    def InsertBefore(self, *args) -> "void":
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param It:
        :type It: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :param It:
        :type It: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_InsertBefore(self, *args)


    def InsertAfter(self, *args) -> "void":
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param It:
        :type It: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        :param Other:
        :type Other: SelectMgr_ListOfFilter &
        :param It:
        :type It: SelectMgr_ListIteratorOfListOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ListOfFilter_InsertAfter(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_ListOfFilter
SelectMgr_ListOfFilter.Assign = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Assign, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Set = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Set, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Extent = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Extent, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Clear = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Clear, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.IsEmpty = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_IsEmpty, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Prepend = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Prepend, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Append = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Append, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.First = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_First, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Last = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Last, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.RemoveFirst = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_RemoveFirst, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.Remove = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_Remove, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.InsertBefore = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_InsertBefore, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter.InsertAfter = new_instancemethod(_SelectMgr.SelectMgr_ListOfFilter_InsertAfter, None, SelectMgr_ListOfFilter)
SelectMgr_ListOfFilter_swigregister = _SelectMgr.SelectMgr_ListOfFilter_swigregister
SelectMgr_ListOfFilter_swigregister(SelectMgr_ListOfFilter)

class SelectMgr_SelectableObject(OCC.Core.PrsMgr.PrsMgr_PresentableObject):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def ComputeSelection(self, *args) -> "void":
        """
        * Recovers and calculates any sensitive primitive, aSelection, available in Shape mode, specified by aMode. As a rule, these are sensitive faces. This method is defined as virtual. This enables you to implement it in the creation of a new class of AIS Interactive Object. You need to do this and in so doing, redefine this method, if you create a class which enriches the list of signatures and types.

        :param aSelection:
        :type aSelection: Handle_SelectMgr_Selection &
        :param aMode:
        :type aMode: int
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_ComputeSelection(self, *args)


    def RecomputePrimitives(self, *args) -> "void":
        """
        * Re-computes the sensitive primitives for all modes. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        :rtype: None

        * Re-computes the sensitive primitives which correspond to the <theMode>th selection mode. IMPORTANT: Do not use this method to update selection primitives except implementing custom selection manager! selection manager! This method does not take into account necessary BVH updates, but may invalidate the pointers it refers to. TO UPDATE SELECTION properly from outside classes, use method UpdateSelection.

        :param theMode:
        :type theMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_RecomputePrimitives(self, *args)


    def AddSelection(self, *args) -> "void":
        """
        * Adds the selection aSelection with the selection mode index aMode to this framework.

        :param aSelection:
        :type aSelection: Handle_SelectMgr_Selection &
        :param aMode:
        :type aMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_AddSelection(self, *args)


    def ClearSelections(self, *args) -> "void":
        """
        * Empties all the selections in the SelectableObject <update> parameter defines whether all object's selections should be flagged for further update or not. This improved method can be used to recompute an object's selection (without redisplaying the object completely) when some selection mode is activated not for the first time.

        :param update: default value is Standard_False
        :type update: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_ClearSelections(self, *args)


    def Selection(self, *args) -> "Handle_SelectMgr_Selection":
        """
        * Returns the selection Selection having the selection mode aMode.

        :param aMode:
        :type aMode: int
        :rtype: Handle_SelectMgr_Selection

        """
        return _SelectMgr.SelectMgr_SelectableObject_Selection(self, *args)


    def HasSelection(self, *args) -> "Standard_Boolean":
        """
        * Returns true if a selection corresponding to the selection mode aMode is present in this framework.

        :param aMode:
        :type aMode: int
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectableObject_HasSelection(self, *args)


    def Init(self, *args) -> "void":
        """
        * Begins the iteration scanning for sensitive primitives.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_Init(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        * Continues the iteration scanning for sensitive primitives.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectableObject_More(self, *args)


    def Next(self, *args) -> "void":
        """
        * Continues the iteration scanning for sensitive primitives.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_Next(self, *args)


    def CurrentSelection(self, *args) -> "Handle_SelectMgr_Selection":
        """
        * Returns the current selection in this framework.

        :rtype: Handle_SelectMgr_Selection

        """
        return _SelectMgr.SelectMgr_SelectableObject_CurrentSelection(self, *args)


    def UpdateTransformations(self, *args) -> "void":
        """
        * Updates locations in all sensitive entities from <aSelection> and in corresponding entity owners.

        :param aSelection:
        :type aSelection: Handle_SelectMgr_Selection &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_UpdateTransformations(self, *args)


    def HilightSelected(self, *args) -> "void":
        """
        * Method which draws selected owners ( for fast presentation draw )

        :param PM:
        :type PM: Handle_PrsMgr_PresentationManager3d &
        :param Seq:
        :type Seq: SelectMgr_SequenceOfOwner &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_HilightSelected(self, *args)


    def ClearSelected(self, *args) -> "void":
        """
        * Method which clear all selected owners belonging to this selectable object ( for fast presentation draw )

        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_ClearSelected(self, *args)


    def HilightOwnerWithColor(self, *args) -> "void":
        """
        * Method which hilight an owner belonging to this selectable object ( for fast presentation draw )

        :param thePM:
        :type thePM: Handle_PrsMgr_PresentationManager3d &
        :param theColor:
        :type theColor: Quantity_NameOfColor
        :param theOwner:
        :type theOwner: Handle_SelectMgr_EntityOwner &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_HilightOwnerWithColor(self, *args)


    def IsAutoHilight(self, *args) -> "Standard_Boolean":
        """
        * If returns True, the old mechanism for highlighting selected objects is used (HilightSelected Method may be empty). If returns False, the HilightSelected method will be fully responsible for highlighting selected entity owners belonging to this selectable object.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectableObject_IsAutoHilight(self, *args)


    def SetAutoHilight(self, *args) -> "void":
        """
        * Set AutoHilight property to true or false Sets up Transform Persistence Mode for this object

        :param newAutoHilight:
        :type newAutoHilight: bool
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_SetAutoHilight(self, *args)


    def GetHilightPresentation(self, *args) -> "Handle_Prs3d_Presentation":
        """
        :param TheMgr:
        :type TheMgr: Handle_PrsMgr_PresentationManager3d &
        :rtype: Handle_Prs3d_Presentation

        """
        return _SelectMgr.SelectMgr_SelectableObject_GetHilightPresentation(self, *args)


    def GetSelectPresentation(self, *args) -> "Handle_Prs3d_Presentation":
        """
        :param TheMgr:
        :type TheMgr: Handle_PrsMgr_PresentationManager3d &
        :rtype: Handle_Prs3d_Presentation

        """
        return _SelectMgr.SelectMgr_SelectableObject_GetSelectPresentation(self, *args)


    def UpdateSelection(self, *args) -> "void":
        """
        * Sets update status FULL to selections of the object. Must be used as the only method of UpdateSelection from outer classes to prevent BVH structures from being outdated.

        :param theMode: default value is -1
        :type theMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_UpdateSelection(self, *args)


    def BoundingBox(self, *args) -> "void":
        """
        * Returns bounding box of selectable object by storing its minimum and maximum 3d coordinates to output parameters

        :param theBndBox:
        :type theBndBox: Bnd_Box &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_BoundingBox(self, *args)


    def SetAttributes(self, *args) -> "void":
        """
        * Initializes the drawing tool theDrawer.

        :param theDrawer:
        :type theDrawer: Handle_Prs3d_Drawer &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_SetAttributes(self, *args)


    def Attributes(self, *args) -> "Handle_Prs3d_Drawer":
        """
        * Returns the attributes settings.

        :rtype: Handle_Prs3d_Drawer

        """
        return _SelectMgr.SelectMgr_SelectableObject_Attributes(self, *args)


    def UnsetAttributes(self, *args) -> "void":
        """
        * Clears settings provided by the drawing tool theDrawer.

        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_UnsetAttributes(self, *args)


    def SetHilightAttributes(self, *args) -> "void":
        """
        * Initializes the hilight drawing tool theDrawer.

        :param theDrawer:
        :type theDrawer: Handle_Prs3d_Drawer &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_SetHilightAttributes(self, *args)


    def HilightAttributes(self, *args) -> "Handle_Prs3d_Drawer":
        """
        * Returns the hilight attributes settings.

        :rtype: Handle_Prs3d_Drawer

        """
        return _SelectMgr.SelectMgr_SelectableObject_HilightAttributes(self, *args)


    def UnsetHilightAttributes(self, *args) -> "void":
        """
        * Clears settings provided by the hilight drawing tool theDrawer.

        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_UnsetHilightAttributes(self, *args)


    def InitDefaultHilightAttributes(*args) -> "void":
        """
        * Initializes theDrawer by default hilight settings.

        :param theDrawer:
        :type theDrawer: Handle_Prs3d_Drawer &
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectableObject_InitDefaultHilightAttributes(*args)

    InitDefaultHilightAttributes = staticmethod(InitDefaultHilightAttributes)

    def SetAssemblyOwner(self, *args) -> "void":
        """
        * Sets common entity owner for assembly sensitive object entities

        :param theOwner:
        :type theOwner: Handle_SelectMgr_EntityOwner &
        :param theMode: default value is -1
        :type theMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectableObject_SetAssemblyOwner(self, *args)


    def GetAssemblyOwner(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        * Returns common entity owner if the object is an assembly

        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SelectableObject_GetAssemblyOwner(self, *args)


    def BndBoxOfSelected(self, *args) -> "Bnd_Box":
        """
        * Returns a bounding box of sensitive entities with the owners given if they are a part of activated selection

        :param theOwners:
        :type theOwners: Handle_SelectMgr_IndexedMapOfOwner &
        :rtype: Bnd_Box

        """
        return _SelectMgr.SelectMgr_SelectableObject_BndBoxOfSelected(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SelectableObject_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SelectableObject_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SelectableObject
SelectMgr_SelectableObject.ComputeSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_ComputeSelection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.RecomputePrimitives = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_RecomputePrimitives, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.AddSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_AddSelection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.ClearSelections = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_ClearSelections, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.Selection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_Selection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.HasSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_HasSelection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.Init = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_Init, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.More = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_More, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.Next = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_Next, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.CurrentSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_CurrentSelection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.UpdateTransformations = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_UpdateTransformations, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.HilightSelected = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_HilightSelected, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.ClearSelected = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_ClearSelected, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.HilightOwnerWithColor = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_HilightOwnerWithColor, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.IsAutoHilight = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_IsAutoHilight, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.SetAutoHilight = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_SetAutoHilight, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.GetHilightPresentation = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_GetHilightPresentation, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.GetSelectPresentation = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_GetSelectPresentation, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.UpdateSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_UpdateSelection, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.BoundingBox = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_BoundingBox, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.SetAttributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_SetAttributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.Attributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_Attributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.UnsetAttributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_UnsetAttributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.SetHilightAttributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_SetHilightAttributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.HilightAttributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_HilightAttributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.UnsetHilightAttributes = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_UnsetHilightAttributes, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.SetAssemblyOwner = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_SetAssemblyOwner, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.GetAssemblyOwner = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_GetAssemblyOwner, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject.BndBoxOfSelected = new_instancemethod(_SelectMgr.SelectMgr_SelectableObject_BndBoxOfSelected, None, SelectMgr_SelectableObject)
SelectMgr_SelectableObject_swigregister = _SelectMgr.SelectMgr_SelectableObject_swigregister
SelectMgr_SelectableObject_swigregister(SelectMgr_SelectableObject)

def SelectMgr_SelectableObject_InitDefaultHilightAttributes(*args) -> "void":
    """
    * Initializes theDrawer by default hilight settings.

    :param theDrawer:
    :type theDrawer: Handle_Prs3d_Drawer &
    :rtype: void

    """
    return _SelectMgr.SelectMgr_SelectableObject_InitDefaultHilightAttributes(*args)


class Meta_SelectMgr_SelectableObject(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SelectableObject_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SelectableObject", "SelectMgr_SelectableObject"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SelectableObject(with_metaclass(Meta_SelectMgr_SelectableObject, SelectMgr_SelectableObject)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SelectableObject", "SelectMgr_SelectableObject"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SelectableObject(Handle_SelectMgr_SelectableObject_DownCast(o))

class SelectMgr_SelectingVolumeManager(OCC.Core.SelectBasics.SelectBasics_SelectingVolumeManager):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Creates instances of all available selecting volume types

        :param theToAllocateFrustums: default value is Standard_True
        :type theToAllocateFrustums: bool
        :rtype: None

        """
        _SelectMgr.SelectMgr_SelectingVolumeManager_swiginit(self, _SelectMgr.new_SelectMgr_SelectingVolumeManager(*args))

    def ScaleAndTransform(self, *args) -> "SelectMgr_SelectingVolumeManager":
        """
        * IMPORTANT: Scaling makes sense only for frustum built on a single point! Note that this method does not perform any checks on type of the frustum. //! Returns a copy of the frustum resized according to the scale factor given and transforms it using the matrix given. There are no default parameters, but in case if: - transformation only is needed: @theScaleFactor must be initialized as any negative value; - scale only is needed: @theTrsf must be set to gp_Identity.

        :param theScaleFactor:
        :type theScaleFactor: int
        :param theTrsf:
        :type theTrsf: gp_Trsf
        :rtype: SelectMgr_SelectingVolumeManager

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_ScaleAndTransform(self, *args)


    def GetActiveSelectionType(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_GetActiveSelectionType(self, *args)


    def SetActiveSelectionType(self, *args) -> "void":
        """
        :param theType:
        :type theType: SelectionType &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_SetActiveSelectionType(self, *args)


    def SetCamera(self, *args) -> "void":
        """
        * Updates camera projection and orientation matrices in all selecting volumes

        :param theCamera:
        :type theCamera: Handle_Graphic3d_Camera
        :rtype: None

        * Updates camera projection and orientation matrices in all selecting volumes

        :param theProjection:
        :type theProjection: Graphic3d_Mat4d &
        :param theOrientation:
        :type theOrientation: Graphic3d_Mat4d &
        :param theIsOrthographic:
        :type theIsOrthographic: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_SetCamera(self, *args)


    def SetViewport(self, *args) -> "void":
        """
        * Updates viewport in all selecting volumes

        :param theX:
        :type theX: float
        :param theY:
        :type theY: float
        :param theWidth:
        :type theWidth: float
        :param theHeight:
        :type theHeight: float
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_SetViewport(self, *args)


    def SetPixelTolerance(self, *args) -> "void":
        """
        * Updates pixel tolerance in all selecting volumes

        :param theTolerance:
        :type theTolerance: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_SetPixelTolerance(self, *args)


    def SetWindowSize(self, *args) -> "void":
        """
        * Updates window size in all selecting volumes

        :param theWidth:
        :type theWidth: int
        :param theHeight:
        :type theHeight: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_SetWindowSize(self, *args)


    def BuildSelectingVolume(self, *args) -> "void":
        """
        * Builds rectangular selecting frustum for point selection

        :param thePoint:
        :type thePoint: gp_Pnt2d
        :rtype: None

        * Builds rectangular selecting frustum for box selection

        :param theMinPt:
        :type theMinPt: gp_Pnt2d
        :param theMaxPt:
        :type theMaxPt: gp_Pnt2d
        :rtype: None

        * Builds set of triangular selecting frustums for polyline selection

        :param thePoints:
        :type thePoints: TColgp_Array1OfPnt2d
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_BuildSelectingVolume(self, *args)


    def Overlaps(self, *args) -> "Standard_Boolean":
        """
        * SAT intersection test between defined volume and given axis-aligned box

        :param theBoxMin:
        :type theBoxMin: SelectMgr_Vec3 &
        :param theBoxMax:
        :type theBoxMax: SelectMgr_Vec3 &
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        * Returns true if selecting volume is overlapped by axis-aligned bounding box with minimum corner at point theMinPt and maximum at point theMaxPt

        :param theBoxMin:
        :type theBoxMin: SelectMgr_Vec3 &
        :param theBoxMax:
        :type theBoxMax: SelectMgr_Vec3 &
        :param theInside: default value is NULL
        :type theInside: bool *
        :rtype: bool

        * Intersection test between defined volume and given point

        :param thePnt:
        :type thePnt: gp_Pnt
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        * Intersection test between defined volume and given point

        :param thePnt:
        :type thePnt: gp_Pnt
        :rtype: bool

        * SAT intersection test between defined volume and given ordered set of points, representing line segments. The test may be considered of interior part or boundary line defined by segments depending on given sensitivity type

        :param theArrayOfPts:
        :type theArrayOfPts: Handle_TColgp_HArray1OfPnt
        :param theSensType:
        :type theSensType: int
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        * Checks if line segment overlaps selecting frustum

        :param thePnt1:
        :type thePnt1: gp_Pnt
        :param thePnt2:
        :type thePnt2: gp_Pnt
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        * SAT intersection test between defined volume and given triangle. The test may be considered of interior part or boundary line defined by triangle vertices depending on given sensitivity type

        :param thePnt1:
        :type thePnt1: gp_Pnt
        :param thePnt2:
        :type thePnt2: gp_Pnt
        :param thePnt3:
        :type thePnt3: gp_Pnt
        :param theSensType:
        :type theSensType: int
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_Overlaps(self, *args)


    def DistToGeometryCenter(self, *args) -> "Standard_Real":
        """
        * Measures distance between 3d projection of user-picked screen point and given point theCOG

        :param theCOG:
        :type theCOG: gp_Pnt
        :rtype: float

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_DistToGeometryCenter(self, *args)


    def DetectedPoint(self, *args) -> "gp_Pnt":
        """
        * Calculates the point on a view ray that was detected during the run of selection algo by given depth. Is valid for point selection only

        :param theDepth:
        :type theDepth: float
        :rtype: gp_Pnt

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_DetectedPoint(self, *args)


    def IsClipped(self, *args) -> "Standard_Boolean":
        """
        * Checks if the point of sensitive in which selection was detected belongs to the region defined by clipping planes

        :param thePlanes:
        :type thePlanes: Graphic3d_SequenceOfHClipPlane &
        :param theDepth:
        :type theDepth: float &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_IsClipped(self, *args)


    def AllowOverlapDetection(self, *args) -> "void":
        """
        * Is used for rectangular selection only If theIsToAllow is false, only fully included sensitives will be detected, otherwise the algorithm will mark both included and overlapped entities as matched

        :param theIsToAllow:
        :type theIsToAllow: bool
        :rtype: void

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_AllowOverlapDetection(self, *args)


    def IsOverlapAllowed(self, *args) -> "Standard_Boolean":
        """
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_IsOverlapAllowed(self, *args)


    def GetVertices(self, *args) -> "gp_Pnt const *":
        """
        * A set of helper functions that return rectangular selecting frustum data

        :rtype: gp_Pnt *

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_GetVertices(self, *args)


    def GetNearPnt(self, *args) -> "gp_Pnt":
        """
        :rtype: gp_Pnt

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_GetNearPnt(self, *args)


    def GetFarPnt(self, *args) -> "gp_Pnt":
        """
        :rtype: gp_Pnt

        """
        return _SelectMgr.SelectMgr_SelectingVolumeManager_GetFarPnt(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SelectingVolumeManager
SelectMgr_SelectingVolumeManager.ScaleAndTransform = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_ScaleAndTransform, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.GetActiveSelectionType = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_GetActiveSelectionType, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.SetActiveSelectionType = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_SetActiveSelectionType, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.SetCamera = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_SetCamera, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.SetViewport = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_SetViewport, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.SetPixelTolerance = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_SetPixelTolerance, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.SetWindowSize = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_SetWindowSize, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.BuildSelectingVolume = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_BuildSelectingVolume, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.Overlaps = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_Overlaps, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.DistToGeometryCenter = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_DistToGeometryCenter, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.DetectedPoint = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_DetectedPoint, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.IsClipped = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_IsClipped, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.AllowOverlapDetection = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_AllowOverlapDetection, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.IsOverlapAllowed = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_IsOverlapAllowed, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.GetVertices = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_GetVertices, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.GetNearPnt = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_GetNearPnt, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager.GetFarPnt = new_instancemethod(_SelectMgr.SelectMgr_SelectingVolumeManager_GetFarPnt, None, SelectMgr_SelectingVolumeManager)
SelectMgr_SelectingVolumeManager_swigregister = _SelectMgr.SelectMgr_SelectingVolumeManager_swigregister
SelectMgr_SelectingVolumeManager_swigregister(SelectMgr_SelectingVolumeManager)

class SelectMgr_Selection(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs a selection object defined by the selection mode IdMode. The default setting 0 is the selection mode for a shape in its entirety.

        :param theModeIdx: default value is 0
        :type theModeIdx: int
        :rtype: None

        """
        _SelectMgr.SelectMgr_Selection_swiginit(self, _SelectMgr.new_SelectMgr_Selection(*args))

    def Destroy(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_Destroy(self, *args)


    def Add(self, *args) -> "void":
        """
        * Adds the sensitive primitive aprimitive to the list of stored entities in this object. Raises NullObject if the primitive is a null handle.

        :param theSensitive:
        :type theSensitive: Handle_SelectBasics_SensitiveEntity &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_Add(self, *args)


    def Clear(self, *args) -> "void":
        """
        * empties the selection from all the stored entities

        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_Clear(self, *args)


    def IsEmpty(self, *args) -> "Standard_Boolean":
        """
        * returns true if no sensitive entity is stored.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_Selection_IsEmpty(self, *args)


    def Mode(self, *args) -> "Standard_Integer":
        """
        * returns the selection mode represented by this selection

        :rtype: int

        """
        return _SelectMgr.SelectMgr_Selection_Mode(self, *args)


    def Init(self, *args) -> "void":
        """
        * Begins an iteration scanning for sensitive primitives.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_Init(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        * Continues the iteration scanning for sensitive primitives with the mode defined in this framework.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_Selection_More(self, *args)


    def Next(self, *args) -> "void":
        """
        * Returns the next sensitive primitive found in the iteration. This is a scan for entities with the mode defined in this framework.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_Next(self, *args)


    def Sensitive(self, *args) -> "Handle_SelectMgr_SensitiveEntity":
        """
        * Returns any sensitive primitive in this framework.

        :rtype: Handle_SelectMgr_SensitiveEntity

        """
        return _SelectMgr.SelectMgr_Selection_Sensitive(self, *args)


    def UpdateStatus(self, *args) -> "void":
        """
        * Returns the flag UpdateFlag. This flage gives the update status of this framework in a ViewerSelector object: - full - partial, or - none.

        :rtype: SelectMgr_TypeOfUpdate

        :param theStatus:
        :type theStatus: SelectMgr_TypeOfUpdate
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_UpdateStatus(self, *args)


    def UpdateBVHStatus(self, *args) -> "void":
        """
        :param theStatus:
        :type theStatus: SelectMgr_TypeOfBVHUpdate
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_UpdateBVHStatus(self, *args)


    def BVHUpdateStatus(self, *args) -> "SelectMgr_TypeOfBVHUpdate":
        """
        :rtype: SelectMgr_TypeOfBVHUpdate

        """
        return _SelectMgr.SelectMgr_Selection_BVHUpdateStatus(self, *args)


    def GetSelectionState(self, *args) -> "SelectMgr_StateOfSelection const":
        """
        * Returns status of selection

        :rtype: SelectMgr_StateOfSelection

        """
        return _SelectMgr.SelectMgr_Selection_GetSelectionState(self, *args)


    def SetSelectionState(self, *args) -> "void":
        """
        * Sets status of selection

        :param theState:
        :type theState: SelectMgr_StateOfSelection
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_SetSelectionState(self, *args)


    def Sensitivity(self, *args) -> "Standard_Integer":
        """
        * Returns sensitivity of the selection

        :rtype: int

        """
        return _SelectMgr.SelectMgr_Selection_Sensitivity(self, *args)


    def SetSensitivity(self, *args) -> "void":
        """
        * Changes sensitivity of the selection and all its entities to the given value. IMPORTANT: This method does not update any outer selection structures, so for proper updates use SelectMgr_SelectionManager::SetSelectionSensitivity method.

        :param theNewSens:
        :type theNewSens: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_Selection_SetSensitivity(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_Selection_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_Selection_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_Selection
SelectMgr_Selection.Destroy = new_instancemethod(_SelectMgr.SelectMgr_Selection_Destroy, None, SelectMgr_Selection)
SelectMgr_Selection.Add = new_instancemethod(_SelectMgr.SelectMgr_Selection_Add, None, SelectMgr_Selection)
SelectMgr_Selection.Clear = new_instancemethod(_SelectMgr.SelectMgr_Selection_Clear, None, SelectMgr_Selection)
SelectMgr_Selection.IsEmpty = new_instancemethod(_SelectMgr.SelectMgr_Selection_IsEmpty, None, SelectMgr_Selection)
SelectMgr_Selection.Mode = new_instancemethod(_SelectMgr.SelectMgr_Selection_Mode, None, SelectMgr_Selection)
SelectMgr_Selection.Init = new_instancemethod(_SelectMgr.SelectMgr_Selection_Init, None, SelectMgr_Selection)
SelectMgr_Selection.More = new_instancemethod(_SelectMgr.SelectMgr_Selection_More, None, SelectMgr_Selection)
SelectMgr_Selection.Next = new_instancemethod(_SelectMgr.SelectMgr_Selection_Next, None, SelectMgr_Selection)
SelectMgr_Selection.Sensitive = new_instancemethod(_SelectMgr.SelectMgr_Selection_Sensitive, None, SelectMgr_Selection)
SelectMgr_Selection.UpdateStatus = new_instancemethod(_SelectMgr.SelectMgr_Selection_UpdateStatus, None, SelectMgr_Selection)
SelectMgr_Selection.UpdateBVHStatus = new_instancemethod(_SelectMgr.SelectMgr_Selection_UpdateBVHStatus, None, SelectMgr_Selection)
SelectMgr_Selection.BVHUpdateStatus = new_instancemethod(_SelectMgr.SelectMgr_Selection_BVHUpdateStatus, None, SelectMgr_Selection)
SelectMgr_Selection.GetSelectionState = new_instancemethod(_SelectMgr.SelectMgr_Selection_GetSelectionState, None, SelectMgr_Selection)
SelectMgr_Selection.SetSelectionState = new_instancemethod(_SelectMgr.SelectMgr_Selection_SetSelectionState, None, SelectMgr_Selection)
SelectMgr_Selection.Sensitivity = new_instancemethod(_SelectMgr.SelectMgr_Selection_Sensitivity, None, SelectMgr_Selection)
SelectMgr_Selection.SetSensitivity = new_instancemethod(_SelectMgr.SelectMgr_Selection_SetSensitivity, None, SelectMgr_Selection)
SelectMgr_Selection_swigregister = _SelectMgr.SelectMgr_Selection_swigregister
SelectMgr_Selection_swigregister(SelectMgr_Selection)


class Meta_SelectMgr_Selection(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_Selection_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_Selection", "SelectMgr_Selection"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_Selection(with_metaclass(Meta_SelectMgr_Selection, SelectMgr_Selection)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_Selection", "SelectMgr_Selection"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_Selection(Handle_SelectMgr_Selection_DownCast(o))

class SelectMgr_SelectionManager(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs an empty selection manager object.

        :rtype: None

        """
        _SelectMgr.SelectMgr_SelectionManager_swiginit(self, _SelectMgr.new_SelectMgr_SelectionManager(*args))

    def Add(self, *args) -> "void":
        """
        * Adds the viewer selector theSelector to the list of known items.

        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Add(self, *args)


    def Contains(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the manager contains the viewer selector theSelector in a list of known items.

        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: bool

        * Returns true if the manager contains the selectable object theObject.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectionManager_Contains(self, *args)


    def Load(self, *args) -> "void":
        """
        * Loads and computes selection mode theMode (if it is not equal to -1) in global context and adds selectable object to BVH tree. If the object theObject has an already calculated selection with mode theMode and it was removed, the selection will be recalculated.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is -1
        :type theMode: int
        :rtype: None

        * Loads and computes selection mode theMode (if it is not equal to -1) and adds selectable object to BVH tree. Does not perform check of existance of theObject in global context before addition, but adds theSelector to local context.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :param theMode: default value is -1
        :type theMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Load(self, *args)


    def Remove(self, *args) -> "void":
        """
        * Removes viewer selector theSelector from the list of known items.

        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        * Removes selectable object theObject from all viewer selectors it was added to previously, removes it from all contexts and clears all computed selections of theObject.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :rtype: None

        * Removes theObject from theSelector, does not clear selections and unbind theObject from context maps.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Remove(self, *args)


    def Activate(self, *args) -> "void":
        """
        * Activates the selection mode theMode in the selector theSelector for the selectable object anObject. By default, theMode is equal to 0. If theSelector is set to default (NULL), the selection with the mode theMode will be activated in all the viewers available.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is 0
        :type theMode: int
        :param theSelector: default value is NULL
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Activate(self, *args)


    def Deactivate(self, *args) -> "void":
        """
        * Deactivates mode theMode of theObject in theSelector. If theMode value is set to default (-1), all avtive selection modes will be deactivated. Likewise, if theSelector value is set to default (NULL), theMode will be deactivated in all viewer selectors.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is -1
        :type theMode: int
        :param theSelector: default value is NULL
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Deactivate(self, *args)


    def IsActivated(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the selection with theMode is active for the selectable object theObject and selector theSelector. If all parameters are set to default values, it returns it there is any active selection in any known viewer selector for object theObject.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is -1
        :type theMode: int
        :param theSelector: default value is NULL
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SelectionManager_IsActivated(self, *args)


    def ClearSelectionStructures(self, *args) -> "void":
        """
        * Removes sensitive entities from all viewer selectors after method Clear() was called to the selection they belonged to or it was recomputed somehow.

        :param theObj:
        :type theObj: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is -1
        :type theMode: int
        :param theSelector: default value is NULL
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_ClearSelectionStructures(self, *args)


    def RestoreSelectionStructures(self, *args) -> "void":
        """
        * Re-adds newely calculated sensitive entities of recomputed selection defined by mode theMode to all viewer selectors contained that selection.

        :param theObj:
        :type theObj: Handle_SelectMgr_SelectableObject &
        :param theMode: default value is -1
        :type theMode: int
        :param theSelector: default value is NULL
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_RestoreSelectionStructures(self, *args)


    def RecomputeSelection(self, *args) -> "void":
        """
        * Recomputes activated selections of theObject for all known viewer selectors according to theMode specified. If theMode is set to default (-1), then all activated selections will be recomputed. If theIsForce is set to true, then selection mode theMode for object theObject will be recomputed regardless of its activation status.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theIsForce: default value is Standard_False
        :type theIsForce: bool
        :param theMode: default value is -1
        :type theMode: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_RecomputeSelection(self, *args)


    def Update(self, *args) -> "void":
        """
        * Updates all selections of theObject in all viewer selectors according to its current update status. If theIsForce is set to true, the call is equal to recomputation.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theIsForce: default value is Standard_True
        :type theIsForce: bool
        :rtype: None

        * Updates all selections of theObject in specified viewer selector according to its current update status. If theIsForce is set to true, the call is equal to recomputation.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theSelector:
        :type theSelector: Handle_SelectMgr_ViewerSelector &
        :param theIsForce: default value is Standard_True
        :type theIsForce: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_Update(self, *args)


    def SetUpdateMode(self, *args) -> "void":
        """
        * Sets type of update of all selections of theObject to the given theType.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theType:
        :type theType: SelectMgr_TypeOfUpdate
        :rtype: None

        * Sets type of update of selection with theMode of theObject to the given theType.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode:
        :type theMode: int
        :param theType:
        :type theType: SelectMgr_TypeOfUpdate
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_SetUpdateMode(self, *args)


    def SetSelectionSensitivity(self, *args) -> "void":
        """
        * Allows to manage sensitivity of a particular selection of interactive object theObject and changes previous sensitivity value of all sensitive entities in selection with theMode to the given theNewSensitivity.

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theMode:
        :type theMode: int
        :param theNewSens:
        :type theNewSens: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SelectionManager_SetSelectionSensitivity(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SelectionManager_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SelectionManager_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SelectionManager
SelectMgr_SelectionManager.Add = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Add, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Contains = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Contains, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Load = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Load, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Remove = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Remove, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Activate = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Activate, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Deactivate = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Deactivate, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.IsActivated = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_IsActivated, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.ClearSelectionStructures = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_ClearSelectionStructures, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.RestoreSelectionStructures = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_RestoreSelectionStructures, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.RecomputeSelection = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_RecomputeSelection, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.Update = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_Update, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.SetUpdateMode = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_SetUpdateMode, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager.SetSelectionSensitivity = new_instancemethod(_SelectMgr.SelectMgr_SelectionManager_SetSelectionSensitivity, None, SelectMgr_SelectionManager)
SelectMgr_SelectionManager_swigregister = _SelectMgr.SelectMgr_SelectionManager_swigregister
SelectMgr_SelectionManager_swigregister(SelectMgr_SelectionManager)


class Meta_SelectMgr_SelectionManager(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SelectionManager_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SelectionManager", "SelectMgr_SelectionManager"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SelectionManager(with_metaclass(Meta_SelectMgr_SelectionManager, SelectMgr_SelectionManager)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SelectionManager", "SelectMgr_SelectionManager"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SelectionManager(Handle_SelectMgr_SelectionManager_DownCast(o))

class SelectMgr_SensitiveEntity(OCC.Core.Standard.Standard_Transient):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Creates new inactive for selection object with base entity theEntity

        :param theEntity:
        :type theEntity: Handle_SelectBasics_SensitiveEntity &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SensitiveEntity_swiginit(self, _SelectMgr.new_SelectMgr_SensitiveEntity(*args))

    def Clear(self, *args) -> "void":
        """
        * Clears up all resources and memory

        :rtype: None

        """
        return _SelectMgr.SelectMgr_SensitiveEntity_Clear(self, *args)


    def BaseSensitive(self, *args) -> "Handle_SelectBasics_SensitiveEntity":
        """
        * Returns related instance of SelectBasics class

        :rtype: Handle_SelectBasics_SensitiveEntity

        """
        return _SelectMgr.SelectMgr_SensitiveEntity_BaseSensitive(self, *args)


    def IsActiveForSelection(self, *args) -> "Standard_Boolean":
        """
        * Returns true if this entity belongs to the active selection mode of parent object

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SensitiveEntity_IsActiveForSelection(self, *args)


    def ResetSelectionActiveStatus(self, *args) -> "void":
        """
        * Marks entity as inactive for selection

        :rtype: None

        """
        return _SelectMgr.SelectMgr_SensitiveEntity_ResetSelectionActiveStatus(self, *args)


    def SetActiveForSelection(self, *args) -> "void":
        """
        * Marks entity as active for selection

        :rtype: None

        """
        return _SelectMgr.SelectMgr_SensitiveEntity_SetActiveForSelection(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SensitiveEntity_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SensitiveEntity_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SensitiveEntity
SelectMgr_SensitiveEntity.Clear = new_instancemethod(_SelectMgr.SelectMgr_SensitiveEntity_Clear, None, SelectMgr_SensitiveEntity)
SelectMgr_SensitiveEntity.BaseSensitive = new_instancemethod(_SelectMgr.SelectMgr_SensitiveEntity_BaseSensitive, None, SelectMgr_SensitiveEntity)
SelectMgr_SensitiveEntity.IsActiveForSelection = new_instancemethod(_SelectMgr.SelectMgr_SensitiveEntity_IsActiveForSelection, None, SelectMgr_SensitiveEntity)
SelectMgr_SensitiveEntity.ResetSelectionActiveStatus = new_instancemethod(_SelectMgr.SelectMgr_SensitiveEntity_ResetSelectionActiveStatus, None, SelectMgr_SensitiveEntity)
SelectMgr_SensitiveEntity.SetActiveForSelection = new_instancemethod(_SelectMgr.SelectMgr_SensitiveEntity_SetActiveForSelection, None, SelectMgr_SensitiveEntity)
SelectMgr_SensitiveEntity_swigregister = _SelectMgr.SelectMgr_SensitiveEntity_swigregister
SelectMgr_SensitiveEntity_swigregister(SelectMgr_SensitiveEntity)


class Meta_SelectMgr_SensitiveEntity(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SensitiveEntity_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SensitiveEntity", "SelectMgr_SensitiveEntity"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SensitiveEntity(with_metaclass(Meta_SelectMgr_SensitiveEntity, SelectMgr_SensitiveEntity)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SensitiveEntity", "SelectMgr_SensitiveEntity"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SensitiveEntity(Handle_SelectMgr_SensitiveEntity_DownCast(o))

class SelectMgr_SequenceNodeOfSequenceOfFilter(OCC.Core.TCollection.TCollection_SeqNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :param n:
        :type n: TCollection_SeqNodePtr &
        :param p:
        :type p: TCollection_SeqNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfFilter_swiginit(self, _SelectMgr.new_SelectMgr_SequenceNodeOfSequenceOfFilter(*args))

    def Value(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfFilter_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceNodeOfSequenceOfFilter
SelectMgr_SequenceNodeOfSequenceOfFilter.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceNodeOfSequenceOfFilter_Value, None, SelectMgr_SequenceNodeOfSequenceOfFilter)
SelectMgr_SequenceNodeOfSequenceOfFilter_swigregister = _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfFilter_swigregister
SelectMgr_SequenceNodeOfSequenceOfFilter_swigregister(SelectMgr_SequenceNodeOfSequenceOfFilter)


class Meta_SelectMgr_SequenceNodeOfSequenceOfFilter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SequenceNodeOfSequenceOfFilter", "SelectMgr_SequenceNodeOfSequenceOfFilter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SequenceNodeOfSequenceOfFilter(with_metaclass(Meta_SelectMgr_SequenceNodeOfSequenceOfFilter, SelectMgr_SequenceNodeOfSequenceOfFilter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SequenceNodeOfSequenceOfFilter", "SelectMgr_SequenceNodeOfSequenceOfFilter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SequenceNodeOfSequenceOfFilter(Handle_SelectMgr_SequenceNodeOfSequenceOfFilter_DownCast(o))

class SelectMgr_SequenceNodeOfSequenceOfOwner(OCC.Core.TCollection.TCollection_SeqNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param I:
        :type I: Handle_SelectMgr_EntityOwner &
        :param n:
        :type n: TCollection_SeqNodePtr &
        :param p:
        :type p: TCollection_SeqNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfOwner_swiginit(self, _SelectMgr.new_SelectMgr_SequenceNodeOfSequenceOfOwner(*args))

    def Value(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfOwner_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceNodeOfSequenceOfOwner
SelectMgr_SequenceNodeOfSequenceOfOwner.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceNodeOfSequenceOfOwner_Value, None, SelectMgr_SequenceNodeOfSequenceOfOwner)
SelectMgr_SequenceNodeOfSequenceOfOwner_swigregister = _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfOwner_swigregister
SelectMgr_SequenceNodeOfSequenceOfOwner_swigregister(SelectMgr_SequenceNodeOfSequenceOfOwner)


class Meta_SelectMgr_SequenceNodeOfSequenceOfOwner(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SequenceNodeOfSequenceOfOwner", "SelectMgr_SequenceNodeOfSequenceOfOwner"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SequenceNodeOfSequenceOfOwner(with_metaclass(Meta_SelectMgr_SequenceNodeOfSequenceOfOwner, SelectMgr_SequenceNodeOfSequenceOfOwner)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SequenceNodeOfSequenceOfOwner", "SelectMgr_SequenceNodeOfSequenceOfOwner"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SequenceNodeOfSequenceOfOwner(Handle_SelectMgr_SequenceNodeOfSequenceOfOwner_DownCast(o))

class SelectMgr_SequenceNodeOfSequenceOfSelector(OCC.Core.TCollection.TCollection_SeqNode):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :param I:
        :type I: Handle_SelectMgr_ViewerSelector &
        :param n:
        :type n: TCollection_SeqNodePtr &
        :param p:
        :type p: TCollection_SeqNodePtr &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfSelector_swiginit(self, _SelectMgr.new_SelectMgr_SequenceNodeOfSequenceOfSelector(*args))

    def Value(self, *args) -> "Handle_SelectMgr_ViewerSelector":
        """
        :rtype: Handle_SelectMgr_ViewerSelector

        """
        return _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfSelector_Value(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceNodeOfSequenceOfSelector
SelectMgr_SequenceNodeOfSequenceOfSelector.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceNodeOfSequenceOfSelector_Value, None, SelectMgr_SequenceNodeOfSequenceOfSelector)
SelectMgr_SequenceNodeOfSequenceOfSelector_swigregister = _SelectMgr.SelectMgr_SequenceNodeOfSequenceOfSelector_swigregister
SelectMgr_SequenceNodeOfSequenceOfSelector_swigregister(SelectMgr_SequenceNodeOfSequenceOfSelector)


class Meta_SelectMgr_SequenceNodeOfSequenceOfSelector(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_SequenceNodeOfSequenceOfSelector", "SelectMgr_SequenceNodeOfSequenceOfSelector"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_SequenceNodeOfSequenceOfSelector(with_metaclass(Meta_SelectMgr_SequenceNodeOfSequenceOfSelector, SelectMgr_SequenceNodeOfSequenceOfSelector)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_SequenceNodeOfSequenceOfSelector", "SelectMgr_SequenceNodeOfSequenceOfSelector"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_SequenceNodeOfSequenceOfSelector(Handle_SelectMgr_SequenceNodeOfSequenceOfSelector_DownCast(o))

class SelectMgr_SequenceOfFilter(OCC.Core.TCollection.TCollection_BaseSequence):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param Other:
        :type Other: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceOfFilter_swiginit(self, _SelectMgr.new_SelectMgr_SequenceOfFilter(*args))

    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Clear(self, *args)


    def Assign(self, *args) -> "SelectMgr_SequenceOfFilter const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfFilter &
        :rtype: SelectMgr_SequenceOfFilter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Assign(self, *args)


    def Set(self, *args) -> "SelectMgr_SequenceOfFilter const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfFilter &
        :rtype: SelectMgr_SequenceOfFilter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Set(self, *args)


    def Append(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_Filter &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Append(self, *args)


    def Prepend(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_Filter &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Prepend(self, *args)


    def InsertBefore(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_Filter &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_InsertBefore(self, *args)


    def InsertAfter(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_Filter &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_InsertAfter(self, *args)


    def First(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_First(self, *args)


    def Last(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Last(self, *args)


    def Split(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param Sub:
        :type Sub: SelectMgr_SequenceOfFilter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Split(self, *args)


    def Value(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Value(self, *args)


    def SetValue(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param I:
        :type I: Handle_SelectMgr_Filter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_SetValue(self, *args)


    def ChangeValue(self, *args) -> "Handle_SelectMgr_Filter":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_Filter

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_ChangeValue(self, *args)


    def Remove(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :rtype: None

        :param FromIndex:
        :type FromIndex: int
        :param ToIndex:
        :type ToIndex: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfFilter_Remove(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceOfFilter
SelectMgr_SequenceOfFilter.Clear = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Clear, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Assign = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Assign, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Set = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Set, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Append = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Append, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Prepend = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Prepend, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.InsertBefore = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_InsertBefore, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.InsertAfter = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_InsertAfter, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.First = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_First, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Last = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Last, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Split = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Split, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Value, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.SetValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_SetValue, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.ChangeValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_ChangeValue, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter.Remove = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfFilter_Remove, None, SelectMgr_SequenceOfFilter)
SelectMgr_SequenceOfFilter_swigregister = _SelectMgr.SelectMgr_SequenceOfFilter_swigregister
SelectMgr_SequenceOfFilter_swigregister(SelectMgr_SequenceOfFilter)

class SelectMgr_SequenceOfOwner(OCC.Core.TCollection.TCollection_BaseSequence):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param Other:
        :type Other: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceOfOwner_swiginit(self, _SelectMgr.new_SelectMgr_SequenceOfOwner(*args))

    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Clear(self, *args)


    def Assign(self, *args) -> "SelectMgr_SequenceOfOwner const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfOwner &
        :rtype: SelectMgr_SequenceOfOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Assign(self, *args)


    def Set(self, *args) -> "SelectMgr_SequenceOfOwner const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfOwner &
        :rtype: SelectMgr_SequenceOfOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Set(self, *args)


    def Append(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_EntityOwner &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Append(self, *args)


    def Prepend(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_EntityOwner &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Prepend(self, *args)


    def InsertBefore(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_EntityOwner &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_InsertBefore(self, *args)


    def InsertAfter(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_EntityOwner &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_InsertAfter(self, *args)


    def First(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_First(self, *args)


    def Last(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Last(self, *args)


    def Split(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param Sub:
        :type Sub: SelectMgr_SequenceOfOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Split(self, *args)


    def Value(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Value(self, *args)


    def SetValue(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param I:
        :type I: Handle_SelectMgr_EntityOwner &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_SetValue(self, *args)


    def ChangeValue(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_ChangeValue(self, *args)


    def Remove(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :rtype: None

        :param FromIndex:
        :type FromIndex: int
        :param ToIndex:
        :type ToIndex: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfOwner_Remove(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceOfOwner
SelectMgr_SequenceOfOwner.Clear = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Clear, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Assign = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Assign, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Set = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Set, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Append = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Append, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Prepend = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Prepend, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.InsertBefore = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_InsertBefore, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.InsertAfter = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_InsertAfter, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.First = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_First, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Last = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Last, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Split = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Split, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Value, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.SetValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_SetValue, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.ChangeValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_ChangeValue, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner.Remove = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfOwner_Remove, None, SelectMgr_SequenceOfOwner)
SelectMgr_SequenceOfOwner_swigregister = _SelectMgr.SelectMgr_SequenceOfOwner_swigregister
SelectMgr_SequenceOfOwner_swigregister(SelectMgr_SequenceOfOwner)

class SelectMgr_SequenceOfSelector(OCC.Core.TCollection.TCollection_BaseSequence):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        :param Other:
        :type Other: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        _SelectMgr.SelectMgr_SequenceOfSelector_swiginit(self, _SelectMgr.new_SelectMgr_SequenceOfSelector(*args))

    def Clear(self, *args) -> "void":
        """
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Clear(self, *args)


    def Assign(self, *args) -> "SelectMgr_SequenceOfSelector const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfSelector &
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Assign(self, *args)


    def Set(self, *args) -> "SelectMgr_SequenceOfSelector const &":
        """
        :param Other:
        :type Other: SelectMgr_SequenceOfSelector &
        :rtype: SelectMgr_SequenceOfSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Set(self, *args)


    def Append(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Append(self, *args)


    def Prepend(self, *args) -> "void":
        """
        :param T:
        :type T: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        :param S:
        :type S: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Prepend(self, *args)


    def InsertBefore(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_InsertBefore(self, *args)


    def InsertAfter(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param T:
        :type T: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        :param Index:
        :type Index: int
        :param S:
        :type S: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_InsertAfter(self, *args)


    def First(self, *args) -> "Handle_SelectMgr_ViewerSelector":
        """
        :rtype: Handle_SelectMgr_ViewerSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_First(self, *args)


    def Last(self, *args) -> "Handle_SelectMgr_ViewerSelector":
        """
        :rtype: Handle_SelectMgr_ViewerSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Last(self, *args)


    def Split(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param Sub:
        :type Sub: SelectMgr_SequenceOfSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Split(self, *args)


    def Value(self, *args) -> "Handle_SelectMgr_ViewerSelector":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_ViewerSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Value(self, *args)


    def SetValue(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :param I:
        :type I: Handle_SelectMgr_ViewerSelector &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_SetValue(self, *args)


    def ChangeValue(self, *args) -> "Handle_SelectMgr_ViewerSelector":
        """
        :param Index:
        :type Index: int
        :rtype: Handle_SelectMgr_ViewerSelector

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_ChangeValue(self, *args)


    def Remove(self, *args) -> "void":
        """
        :param Index:
        :type Index: int
        :rtype: None

        :param FromIndex:
        :type FromIndex: int
        :param ToIndex:
        :type ToIndex: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SequenceOfSelector_Remove(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SequenceOfSelector
SelectMgr_SequenceOfSelector.Clear = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Clear, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Assign = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Assign, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Set = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Set, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Append = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Append, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Prepend = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Prepend, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.InsertBefore = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_InsertBefore, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.InsertAfter = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_InsertAfter, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.First = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_First, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Last = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Last, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Split = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Split, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Value = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Value, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.SetValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_SetValue, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.ChangeValue = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_ChangeValue, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector.Remove = new_instancemethod(_SelectMgr.SelectMgr_SequenceOfSelector_Remove, None, SelectMgr_SequenceOfSelector)
SelectMgr_SequenceOfSelector_swigregister = _SelectMgr.SelectMgr_SequenceOfSelector_swigregister
SelectMgr_SequenceOfSelector_swigregister(SelectMgr_SequenceOfSelector)

class SelectMgr_SortCriterion(object):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        :rtype: None

        * Defines parameters of selection criterion: - Priority: selection priority - Depth: distance from the view plane to the entity - MinDist: distance from the clicked point to the entity on the view plane - Tol: tolerance used for selecting candidates - PreferClosest: specify whether closest object is preferred even if if has less priority

        :param thePriority:
        :type thePriority: int
        :param theDepth:
        :type theDepth: float
        :param theMinDist:
        :type theMinDist: float
        :param theTol:
        :type theTol: float
        :param PreferClosest:
        :type PreferClosest: bool
        :rtype: None

        """
        _SelectMgr.SelectMgr_SortCriterion_swiginit(self, _SelectMgr.new_SelectMgr_SortCriterion(*args))

    def SetPriority(self, *args) -> "void":
        """
        :param P:
        :type P: int
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SortCriterion_SetPriority(self, *args)


    def SetDepth(self, *args) -> "void":
        """
        :param D:
        :type D: float
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SortCriterion_SetDepth(self, *args)


    def SetMinDist(self, *args) -> "void":
        """
        :param D:
        :type D: float
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SortCriterion_SetMinDist(self, *args)


    def SetTol(self, *args) -> "void":
        """
        :param T:
        :type T: float
        :rtype: None

        """
        return _SelectMgr.SelectMgr_SortCriterion_SetTol(self, *args)


    def Priority(self, *args) -> "Standard_Integer":
        """
        :rtype: int

        """
        return _SelectMgr.SelectMgr_SortCriterion_Priority(self, *args)


    def Depth(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _SelectMgr.SelectMgr_SortCriterion_Depth(self, *args)


    def MinDist(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _SelectMgr.SelectMgr_SortCriterion_MinDist(self, *args)


    def Tol(self, *args) -> "Standard_Real":
        """
        :rtype: float

        """
        return _SelectMgr.SelectMgr_SortCriterion_Tol(self, *args)


    def IsGreater(self, *args) -> "Standard_Boolean":
        """
        :param anOtherCriterion:
        :type anOtherCriterion: SelectMgr_SortCriterion &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SortCriterion_IsGreater(self, *args)


    def __gt__(self, *args) -> "Standard_Boolean":
        """
        :param anOtherCriterion:
        :type anOtherCriterion: SelectMgr_SortCriterion &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SortCriterion___gt__(self, *args)


    def IsLower(self, *args) -> "Standard_Boolean":
        """
        :param anOtherCriterion:
        :type anOtherCriterion: SelectMgr_SortCriterion &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SortCriterion_IsLower(self, *args)


    def __lt__(self, *args) -> "Standard_Boolean":
        """
        :param anOtherCriterion:
        :type anOtherCriterion: SelectMgr_SortCriterion &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_SortCriterion___lt__(self, *args)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_SortCriterion
SelectMgr_SortCriterion.SetPriority = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_SetPriority, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.SetDepth = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_SetDepth, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.SetMinDist = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_SetMinDist, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.SetTol = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_SetTol, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.Priority = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_Priority, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.Depth = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_Depth, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.MinDist = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_MinDist, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.Tol = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_Tol, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.IsGreater = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_IsGreater, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.__gt__ = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion___gt__, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.IsLower = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion_IsLower, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion.__lt__ = new_instancemethod(_SelectMgr.SelectMgr_SortCriterion___lt__, None, SelectMgr_SortCriterion)
SelectMgr_SortCriterion_swigregister = _SelectMgr.SelectMgr_SortCriterion_swigregister
SelectMgr_SortCriterion_swigregister(SelectMgr_SortCriterion)

class SelectMgr_ViewerSelector(OCC.Core.MMgt.MMgt_TShared):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Clear(self, *args) -> "void":
        """
        * Empties all the tables, removes all selections...

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Clear(self, *args)


    def Sensitivity(self, *args) -> "Standard_Integer":
        """
        * returns the Sensitivity of picking

        :rtype: int

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Sensitivity(self, *args)


    def SortResult(self, *args) -> "void":
        """
        * Sorts the detected entites by priority and distance. to be redefined if other criterion are used...

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_SortResult(self, *args)


    def Init(self, *args) -> "void":
        """
        * Begins an iteration scanning for the owners detected at a position in the view.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Init(self, *args)


    def More(self, *args) -> "Standard_Boolean":
        """
        * Continues the interation scanning for the owners detected at a position in the view, or - continues the iteration scanning for the owner closest to the position in the view.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_More(self, *args)


    def Next(self, *args) -> "void":
        """
        * Returns the next owner found in the iteration. This is a scan for the owners detected at a position in the view.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Next(self, *args)


    def OnePicked(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        * Returns the picked element with the highest priority, and which is the closest to the last successful mouse position.

        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_ViewerSelector_OnePicked(self, *args)


    def SetPickClosest(self, *args) -> "void":
        """
        * Set preference of selecting one object for OnePicked() method: - If True, objects with less depth (distance fron the view plane) are preferred regardless of priority (priority is used then to choose among objects with similar depth), - If False, objects with higher priority are preferred regardless of the depth which is used to choose among objects of the same priority.

        :param preferClosest:
        :type preferClosest: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_SetPickClosest(self, *args)


    def NbPicked(self, *args) -> "Standard_Integer":
        """
        * Returns the number of owners found at a position in the view by the Init - More - Next - Picked iteration.

        :rtype: int

        """
        return _SelectMgr.SelectMgr_ViewerSelector_NbPicked(self, *args)


    def Picked(self, *args) -> "Handle_SelectMgr_EntityOwner":
        """
        * Returns the current selected entity detected by the selector;

        :rtype: Handle_SelectMgr_EntityOwner

        * Returns the entity which is at rank <aRank> in the list of stored ones.

        :param aRank:
        :type aRank: int
        :rtype: Handle_SelectMgr_EntityOwner

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Picked(self, *args)


    def Contains(self, *args) -> "Standard_Boolean":
        """
        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Contains(self, *args)


    def Modes(self, *args) -> "Standard_Boolean":
        """
        * Returns the list of selection modes ModeList found in this selector for the selectable object aSelectableObject. Returns true if aSelectableObject is referenced inside this selector; returns false if the object is not present in this selector.

        :param theSelectableObject:
        :type theSelectableObject: Handle_SelectMgr_SelectableObject &
        :param theModeList:
        :type theModeList: TColStd_ListOfInteger &
        :param theWantedState: default value is SelectMgr_SOS_Any
        :type theWantedState: SelectMgr_StateOfSelection
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Modes(self, *args)


    def IsActive(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the selectable object aSelectableObject having the selection mode aMode is active in this selector.

        :param theSelectableObject:
        :type theSelectableObject: Handle_SelectMgr_SelectableObject &
        :param theMode:
        :type theMode: int
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_IsActive(self, *args)


    def IsInside(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the selectable object aSelectableObject having the selection mode aMode is in this selector.

        :param theSelectableObject:
        :type theSelectableObject: Handle_SelectMgr_SelectableObject &
        :param theMode:
        :type theMode: int
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_IsInside(self, *args)


    def Status(self, *args) -> "TCollection_AsciiString":
        """
        * Returns the selection status Status of the selection aSelection.

        :param theSelection:
        :type theSelection: Handle_SelectMgr_Selection &
        :rtype: SelectMgr_StateOfSelection

        :param theSelectableObject:
        :type theSelectableObject: Handle_SelectMgr_SelectableObject &
        :rtype: TCollection_AsciiString

        """
        return _SelectMgr.SelectMgr_ViewerSelector_Status(self, *args)


    def ActiveOwners(self, *args) -> "void":
        """
        * Returns the list of active entity owners

        :param theOwners:
        :type theOwners: NCollection_List<Handle_SelectBasics_EntityOwner> &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_ActiveOwners(self, *args)


    def AddSelectableObject(self, *args) -> "void":
        """
        * Adds new object to the map of selectable objects

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_AddSelectableObject(self, *args)


    def AddSelectionToObject(self, *args) -> "void":
        """
        * Adds new selection to the object and builds its BVH tree

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theSelection:
        :type theSelection: Handle_SelectMgr_Selection &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_AddSelectionToObject(self, *args)


    def RemoveSelectableObject(self, *args) -> "void":
        """
        * Removes selectable object from map of selectable ones

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_RemoveSelectableObject(self, *args)


    def RemoveSelectionOfObject(self, *args) -> "void":
        """
        * Removes selection of the object and marks its BVH tree for rebuild

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theSelection:
        :type theSelection: Handle_SelectMgr_Selection &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_RemoveSelectionOfObject(self, *args)


    def RebuildObjectsTree(self, *args) -> "void":
        """
        * Marks BVH of selectable objects for rebuild. Parameter theIsForce set as true guarantees that 1st level BVH for the viewer selector will be rebuilt during this call

        :param theIsForce: default value is Standard_False
        :type theIsForce: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_RebuildObjectsTree(self, *args)


    def RebuildSensitivesTree(self, *args) -> "void":
        """
        * Marks BVH of sensitive entities of particular selectable object for rebuild. Parameter theIsForce set as true guarantees that 2nd level BVH for the object given will be rebuilt during this call

        :param theObject:
        :type theObject: Handle_SelectMgr_SelectableObject &
        :param theIsForce: default value is Standard_False
        :type theIsForce: bool
        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_RebuildSensitivesTree(self, *args)


    def InitDetected(self, *args) -> "void":
        """
        * Initializes internal iterator for stored detected sensitive entities

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_InitDetected(self, *args)


    def NextDetected(self, *args) -> "void":
        """
        * Makes a step along the map of detected sensitive entities and their owners

        :rtype: None

        """
        return _SelectMgr.SelectMgr_ViewerSelector_NextDetected(self, *args)


    def MoreDetected(self, *args) -> "Standard_Boolean":
        """
        * Returns true if iterator of map of detected sensitive entities has reached its end

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_ViewerSelector_MoreDetected(self, *args)


    def DetectedEntity(self, *args) -> "Handle_SelectBasics_SensitiveEntity":
        """
        * Returns sensitive entity that was detected during the previous run of selection algorithm

        :rtype: Handle_SelectBasics_SensitiveEntity

        """
        return _SelectMgr.SelectMgr_ViewerSelector_DetectedEntity(self, *args)


    def GetManager(self, *args) -> "SelectMgr_SelectingVolumeManager &":
        """
        * Returns instance of selecting volume manager of the viewer selector

        :rtype: SelectMgr_SelectingVolumeManager

        """
        return _SelectMgr.SelectMgr_ViewerSelector_GetManager(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_ViewerSelector_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_ViewerSelector_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_ViewerSelector
SelectMgr_ViewerSelector.Clear = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Clear, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Sensitivity = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Sensitivity, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.SortResult = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_SortResult, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Init = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Init, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.More = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_More, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Next = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Next, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.OnePicked = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_OnePicked, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.SetPickClosest = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_SetPickClosest, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.NbPicked = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_NbPicked, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Picked = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Picked, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Contains = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Contains, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Modes = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Modes, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.IsActive = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_IsActive, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.IsInside = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_IsInside, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.Status = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_Status, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.ActiveOwners = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_ActiveOwners, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.AddSelectableObject = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_AddSelectableObject, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.AddSelectionToObject = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_AddSelectionToObject, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.RemoveSelectableObject = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_RemoveSelectableObject, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.RemoveSelectionOfObject = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_RemoveSelectionOfObject, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.RebuildObjectsTree = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_RebuildObjectsTree, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.RebuildSensitivesTree = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_RebuildSensitivesTree, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.InitDetected = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_InitDetected, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.NextDetected = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_NextDetected, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.MoreDetected = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_MoreDetected, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.DetectedEntity = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_DetectedEntity, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector.GetManager = new_instancemethod(_SelectMgr.SelectMgr_ViewerSelector_GetManager, None, SelectMgr_ViewerSelector)
SelectMgr_ViewerSelector_swigregister = _SelectMgr.SelectMgr_ViewerSelector_swigregister
SelectMgr_ViewerSelector_swigregister(SelectMgr_ViewerSelector)


class Meta_SelectMgr_ViewerSelector(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_ViewerSelector_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_ViewerSelector", "SelectMgr_ViewerSelector"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_ViewerSelector(with_metaclass(Meta_SelectMgr_ViewerSelector, SelectMgr_ViewerSelector)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_ViewerSelector", "SelectMgr_ViewerSelector"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_ViewerSelector(Handle_SelectMgr_ViewerSelector_DownCast(o))

class SelectMgr_CompositionFilter(SelectMgr_Filter):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr

    def Add(self, *args) -> "void":
        """
        * Adds the filter afilter to a filter object created by a filter class inheriting this framework.

        :param afilter:
        :type afilter: Handle_SelectMgr_Filter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_CompositionFilter_Add(self, *args)


    def Remove(self, *args) -> "void":
        """
        * Removes the filter aFilter from this framework.

        :param aFilter:
        :type aFilter: Handle_SelectMgr_Filter &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_CompositionFilter_Remove(self, *args)


    def IsEmpty(self, *args) -> "Standard_Boolean":
        """
        * Returns true if this framework is empty.

        :rtype: bool

        """
        return _SelectMgr.SelectMgr_CompositionFilter_IsEmpty(self, *args)


    def IsIn(self, *args) -> "Standard_Boolean":
        """
        * Returns true if the filter aFilter is in this framework.

        :param aFilter:
        :type aFilter: Handle_SelectMgr_Filter &
        :rtype: bool

        """
        return _SelectMgr.SelectMgr_CompositionFilter_IsIn(self, *args)


    def StoredFilters(self, *args) -> "SelectMgr_ListOfFilter const &":
        """
        * Returns the list of stored filters from this framework.

        :rtype: SelectMgr_ListOfFilter

        """
        return _SelectMgr.SelectMgr_CompositionFilter_StoredFilters(self, *args)


    def Clear(self, *args) -> "void":
        """
        * Clears the filters used in this framework.

        :rtype: None

        """
        return _SelectMgr.SelectMgr_CompositionFilter_Clear(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_CompositionFilter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_CompositionFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_CompositionFilter
SelectMgr_CompositionFilter.Add = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_Add, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter.Remove = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_Remove, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter.IsEmpty = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_IsEmpty, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter.IsIn = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_IsIn, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter.StoredFilters = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_StoredFilters, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter.Clear = new_instancemethod(_SelectMgr.SelectMgr_CompositionFilter_Clear, None, SelectMgr_CompositionFilter)
SelectMgr_CompositionFilter_swigregister = _SelectMgr.SelectMgr_CompositionFilter_swigregister
SelectMgr_CompositionFilter_swigregister(SelectMgr_CompositionFilter)


class Meta_SelectMgr_CompositionFilter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_CompositionFilter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_CompositionFilter", "SelectMgr_CompositionFilter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_CompositionFilter(with_metaclass(Meta_SelectMgr_CompositionFilter, SelectMgr_CompositionFilter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_CompositionFilter", "SelectMgr_CompositionFilter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_CompositionFilter(Handle_SelectMgr_CompositionFilter_DownCast(o))

class SelectMgr_AndFilter(SelectMgr_CompositionFilter):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs an empty selection filter object for two or more types of entity.

        :rtype: None

        """
        _SelectMgr.SelectMgr_AndFilter_swiginit(self, _SelectMgr.new_SelectMgr_AndFilter(*args))

    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_AndFilter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_AndFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_AndFilter
SelectMgr_AndFilter_swigregister = _SelectMgr.SelectMgr_AndFilter_swigregister
SelectMgr_AndFilter_swigregister(SelectMgr_AndFilter)


class Meta_SelectMgr_AndFilter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_AndFilter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_AndFilter", "SelectMgr_AndFilter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_AndFilter(with_metaclass(Meta_SelectMgr_AndFilter, SelectMgr_AndFilter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_AndFilter", "SelectMgr_AndFilter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_AndFilter(Handle_SelectMgr_AndFilter_DownCast(o))

class SelectMgr_OrFilter(SelectMgr_CompositionFilter):
    thisown = _swig_property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc='The membership flag')
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
        * Constructs an empty or selection filter.

        :rtype: None

        """
        _SelectMgr.SelectMgr_OrFilter_swiginit(self, _SelectMgr.new_SelectMgr_OrFilter(*args))

    def SetDisabledObjects(self, *args) -> "void":
        """
        * Disable selection of specified objects.

        :param theObjects:
        :type theObjects: Handle_Graphic3d_NMapOfTransient &
        :rtype: None

        """
        return _SelectMgr.SelectMgr_OrFilter_SetDisabledObjects(self, *args)


    @deprecated("It is not required anymore.")
    def GetHandle(self):
        return self

    @deprecated("It is not required anymore.")
    def GetObject(self):
        return self

    @deprecated("Use is None instead")
    def IsNull(self):
      return Handle_SelectMgr_OrFilter_IsNull(self);

    @staticmethod
    def DownCast(t):
      return Handle_SelectMgr_OrFilter_DownCast(t)


    __repr__ = _dumps_object

    __swig_destroy__ = _SelectMgr.delete_SelectMgr_OrFilter
SelectMgr_OrFilter.SetDisabledObjects = new_instancemethod(_SelectMgr.SelectMgr_OrFilter_SetDisabledObjects, None, SelectMgr_OrFilter)
SelectMgr_OrFilter_swigregister = _SelectMgr.SelectMgr_OrFilter_swigregister
SelectMgr_OrFilter_swigregister(SelectMgr_OrFilter)


class Meta_SelectMgr_OrFilter(type):
    def __call__(cls, wrap=None):
        if wrap is None:
            return Handle_SelectMgr_OrFilter_Create()
        else:
            warnings.warn("class Handle_%s is deprecated. Use %s instead." % ("SelectMgr_OrFilter", "SelectMgr_OrFilter"),
                category=DeprecationWarning,
                stacklevel=2)
            warnings.simplefilter('default', DeprecationWarning)
            return Proxy(wrap)

class Handle_SelectMgr_OrFilter(with_metaclass(Meta_SelectMgr_OrFilter, SelectMgr_OrFilter)):
    @staticmethod
    def DownCast(o):
        warnings.warn("Handle_%s.DownCast is deprecated. Use %s.DownCast instead." % ("SelectMgr_OrFilter", "SelectMgr_OrFilter"),
            category=DeprecationWarning,
            stacklevel=2)
        warnings.simplefilter('default', DeprecationWarning)
        return Handle_SelectMgr_OrFilter(Handle_SelectMgr_OrFilter_DownCast(o))



